/*
 * Decompiled with CFR 0.152.
 */
package jflex.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import java_cup.runtime.Symbol;
import jflex.core.Action;
import jflex.core.unicode.CharClasses;
import jflex.core.unicode.ILexScan;
import jflex.core.unicode.IntCharSet;
import jflex.core.unicode.UnicodeProperties;
import jflex.l10n.ErrorMessages;
import jflex.logging.Out;
import jflex.scanner.LexicalStates;
import jflex.scanner.ScannerException;

public abstract class AbstractLexScan
implements ILexScan {
    int bufferSize = 16384;
    File file;
    private final Deque<File> files = new ArrayDeque<File>();
    StringBuilder userCode = new StringBuilder();
    String classCode;
    String initCode;
    String initThrow;
    String eofCode;
    String eofThrow;
    List<String> lexThrow = new ArrayList<String>();
    String eofVal;
    public String scanErrorException;
    String cupSymbol = "sym";
    StringBuilder string = new StringBuilder();
    UnicodeProperties unicodeProperties;
    boolean charCount;
    boolean lineCount;
    boolean columnCount;
    boolean cupCompatible;
    boolean cup2Compatible;
    boolean cupDebug;
    boolean isInteger;
    boolean isIntWrap;
    boolean isPublic;
    boolean isFinal;
    boolean isAbstract;
    boolean bolUsed;
    boolean standalone;
    boolean debugOption;
    boolean eofclose;
    boolean noSuppressWarnings;
    String isImplementing;
    String isExtending;
    String className = "Yylex";
    String functionName;
    String tokenType;
    String visibility = "public";
    String tokenSizeLimit;
    List<String> ctorArgs = new ArrayList<String>();
    List<String> ctorTypes = new ArrayList<String>();
    LexicalStates states = new LexicalStates();
    List<Action> actions = new ArrayList<Action>();
    CharClasses charClasses;

    @Override
    public UnicodeProperties getUnicodeProperties() {
        return this.unicodeProperties;
    }

    public int getMaximumCodePoint() {
        if (this.unicodeProperties == null) {
            this.populateDefaultVersionUnicodeProperties();
        }
        return this.unicodeProperties.getMaximumCodePoint();
    }

    public IntCharSet getIntCharSet(String propertyValue) {
        if (this.unicodeProperties == null) {
            this.populateDefaultVersionUnicodeProperties();
        }
        return this.unicodeProperties.getIntCharSet(propertyValue);
    }

    public CharClasses getCharClasses() {
        return this.charClasses;
    }

    public void setFile(File file) {
        this.file = file;
    }

    Symbol symbol(int type, Object value) {
        return new Symbol(type, this.lexLine(), this.lexColumn(), value);
    }

    Symbol symbol(int type) {
        return new Symbol(type, this.lexLine(), this.lexColumn());
    }

    Symbol symbol_countUpdate(int type, Object value) {
        int lc = this.lexLine();
        int cc = this.lexColumn();
        String text = this.lexText();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c != '\n' && c != '\r' && c != ' ' && c != '\t') {
                return new Symbol(type, lc, cc, value);
            }
            if (c == '\n') {
                ++lc;
                cc = 0;
                continue;
            }
            ++cc;
        }
        return new Symbol(type, this.lexLine(), this.lexColumn(), value);
    }

    String makeMacroIdent() {
        String matched = this.lexText().trim();
        return matched.substring(1, matched.length() - 1).trim();
    }

    public static String conc(Object a, Object b) {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            return b.toString();
        }
        if (b == null) {
            return a.toString();
        }
        return a.toString() + b.toString();
    }

    public static String concExc(Object a, Object b) {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            return b.toString();
        }
        if (b == null) {
            return a.toString();
        }
        return a.toString() + ", " + b.toString();
    }

    void populateDefaultVersionUnicodeProperties() {
        try {
            this.unicodeProperties = new UnicodeProperties();
        }
        catch (UnicodeProperties.UnsupportedUnicodeVersionException e) {
            throw new ScannerException(this.file, ErrorMessages.UNSUPPORTED_UNICODE_VERSION, this.lexLine());
        }
    }

    public void initCharClasses(CharSetSize size) {
        this.initCharClasses(size, null);
    }

    public void initCharClasses(CharSetSize size, String version) {
        if (this.charClasses != null) {
            throw new ScannerException(this.file, ErrorMessages.DOUBLE_CHARSET, this.lexLine());
        }
        if (version == null || version.length() == 0) {
            this.populateDefaultVersionUnicodeProperties();
        } else {
            try {
                this.unicodeProperties = new UnicodeProperties(version);
            }
            catch (UnicodeProperties.UnsupportedUnicodeVersionException e) {
                throw new ScannerException(this.file, ErrorMessages.UNSUPPORTED_UNICODE_VERSION, this.lexLine());
            }
        }
        switch (size) {
            case SEVEN_BIT: {
                this.charClasses = new CharClasses(127, this);
                break;
            }
            case EIGHT_BIT: {
                this.charClasses = new CharClasses(255, this);
                break;
            }
            case UNICODE: {
                this.charClasses = new CharClasses(this.unicodeProperties.getMaximumCodePoint(), this);
            }
        }
    }

    void includeFile(String filePath) {
        File f = new File(this.file.getParentFile(), filePath);
        if (!f.canRead()) {
            throw new ScannerException(this.file, ErrorMessages.NOT_READABLE, this.lexLine());
        }
        if (this.files.contains(f)) {
            throw new ScannerException(this.file, ErrorMessages.FILE_CYCLE, this.lexLine());
        }
        try {
            this.lexPushStream(f);
            this.files.push(this.file);
            this.file = f;
            Out.println("Including \"" + this.file + "\"");
        }
        catch (IOException e) {
            throw new ScannerException(this.file, ErrorMessages.NOT_READABLE, this.lexLine());
        }
    }

    File popFile() {
        return this.files.pop();
    }

    public Iterable<Action> actions() {
        return this.actions;
    }

    public File file() {
        return this.file;
    }

    public String classCode() {
        return this.classCode;
    }

    public String initCode() {
        return this.initCode;
    }

    public String initThrow() {
        return this.initThrow;
    }

    public String eofCode() {
        return this.eofCode;
    }

    public String eofThrow() {
        return this.eofThrow;
    }

    public List<String> lexThrow() {
        return this.lexThrow;
    }

    public String eofVal() {
        return this.eofVal;
    }

    public String scanErrorException() {
        return this.scanErrorException;
    }

    public String userCode() {
        return this.userCode.toString();
    }

    public String cupSymbol() {
        return this.cupSymbol;
    }

    public boolean charCount() {
        return this.charCount;
    }

    public boolean lineCount() {
        return this.lineCount;
    }

    public boolean columnCount() {
        return this.columnCount;
    }

    public boolean cupCompatible() {
        return this.cupCompatible;
    }

    public boolean cup2Compatible() {
        return this.cup2Compatible;
    }

    public boolean cupDebug() {
        return this.cupDebug;
    }

    public boolean isInteger() {
        return this.isInteger;
    }

    public boolean isIntWrap() {
        return this.isIntWrap;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean bolUsed() {
        return this.bolUsed;
    }

    public boolean standalone() {
        return this.standalone;
    }

    public boolean debugOption() {
        return this.debugOption;
    }

    public boolean eofclose() {
        return this.eofclose;
    }

    public String isImplementing() {
        return this.isImplementing;
    }

    public String isExtending() {
        return this.isExtending;
    }

    public String className() {
        return this.className;
    }

    public String functionName() {
        return this.functionName;
    }

    public String tokenType() {
        return this.tokenType;
    }

    public String visibility() {
        return this.visibility;
    }

    public Set<String> stateNames() {
        return this.states.names();
    }

    public int getStateNumber(String name) {
        return this.states.getNumber(name);
    }

    public int ctorArgsCount() {
        return this.ctorArgs.size();
    }

    public String ctorType(int i) {
        return this.ctorTypes.get(i);
    }

    public String ctorArg(int i) {
        return this.ctorArgs.get(i);
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public boolean noSuppressWarnings() {
        return this.noSuppressWarnings;
    }

    public String getTokenSizeLimit() {
        return this.tokenSizeLimit;
    }

    @Deprecated
    public int currentLine() {
        return this.lexLine();
    }

    @Deprecated
    public boolean isColumnCount() {
        return this.columnCount;
    }

    public void maybeWarnUnicodeMatch(int len) {
        if (this.lexLength() > (len += 2)) {
            Out.warning(this.file, ErrorMessages.UNICODE_TOO_LONG, this.lexLine(), this.lexColumn() + len);
            this.lexPushback(this.lexLength() - len);
        }
    }

    protected abstract int lexLine();

    protected abstract int lexColumn();

    protected abstract int lexLength();

    protected abstract String lexText();

    protected abstract void lexPushback(int var1);

    protected abstract void lexPushStream(File var1) throws IOException;

    public static enum CharSetSize {
        SEVEN_BIT,
        EIGHT_BIT,
        UNICODE;

    }
}

