// Code generated by go-swagger; DO NOT EDIT.

package global_network_manager_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-global-network-manager-service/preview/2022-02-15/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// ListClusterServicesReader is a Reader for the ListClusterServices structure.
type ListClusterServicesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListClusterServicesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListClusterServicesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewListClusterServicesDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewListClusterServicesOK creates a ListClusterServicesOK with default headers values
func NewListClusterServicesOK() *ListClusterServicesOK {
	return &ListClusterServicesOK{}
}

/*
ListClusterServicesOK describes a response with status code 200, with default header values.

A successful response.
*/
type ListClusterServicesOK struct {
	Payload *models.HashicorpCloudGlobalNetworkManager20220215ListClusterServicesResponse
}

// IsSuccess returns true when this list cluster services o k response has a 2xx status code
func (o *ListClusterServicesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this list cluster services o k response has a 3xx status code
func (o *ListClusterServicesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list cluster services o k response has a 4xx status code
func (o *ListClusterServicesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this list cluster services o k response has a 5xx status code
func (o *ListClusterServicesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this list cluster services o k response a status code equal to that given
func (o *ListClusterServicesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the list cluster services o k response
func (o *ListClusterServicesOK) Code() int {
	return 200
}

func (o *ListClusterServicesOK) Error() string {
	return fmt.Sprintf("[GET /2022-02-15/global-network-manager/{cluster_resource_name}/services][%d] listClusterServicesOK  %+v", 200, o.Payload)
}

func (o *ListClusterServicesOK) String() string {
	return fmt.Sprintf("[GET /2022-02-15/global-network-manager/{cluster_resource_name}/services][%d] listClusterServicesOK  %+v", 200, o.Payload)
}

func (o *ListClusterServicesOK) GetPayload() *models.HashicorpCloudGlobalNetworkManager20220215ListClusterServicesResponse {
	return o.Payload
}

func (o *ListClusterServicesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudGlobalNetworkManager20220215ListClusterServicesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListClusterServicesDefault creates a ListClusterServicesDefault with default headers values
func NewListClusterServicesDefault(code int) *ListClusterServicesDefault {
	return &ListClusterServicesDefault{
		_statusCode: code,
	}
}

/*
ListClusterServicesDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ListClusterServicesDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this list cluster services default response has a 2xx status code
func (o *ListClusterServicesDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this list cluster services default response has a 3xx status code
func (o *ListClusterServicesDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this list cluster services default response has a 4xx status code
func (o *ListClusterServicesDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this list cluster services default response has a 5xx status code
func (o *ListClusterServicesDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this list cluster services default response a status code equal to that given
func (o *ListClusterServicesDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the list cluster services default response
func (o *ListClusterServicesDefault) Code() int {
	return o._statusCode
}

func (o *ListClusterServicesDefault) Error() string {
	return fmt.Sprintf("[GET /2022-02-15/global-network-manager/{cluster_resource_name}/services][%d] ListClusterServices default  %+v", o._statusCode, o.Payload)
}

func (o *ListClusterServicesDefault) String() string {
	return fmt.Sprintf("[GET /2022-02-15/global-network-manager/{cluster_resource_name}/services][%d] ListClusterServices default  %+v", o._statusCode, o.Payload)
}

func (o *ListClusterServicesDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ListClusterServicesDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
