/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.api.context.Context;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

class ContentStats {
    private static ContentStats instance;
    private Properties stats = new Properties();

    public static ContentStats getInstance() throws IOException {
        if (instance == null) {
            if (HelperCommunication.getInstance().isElevatedHelper()) {
                HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

                    protected void run(Context context) throws Exception {
                        ContentStats.getInstance();
                    }
                });
            }
            instance = new ContentStats();
        }
        return instance;
    }

    private ContentStats() throws IOException {
        FileInputStream fileInputStream = new FileInputStream(InstallerUtil.getInstallerFile("stats.properties"));
        this.stats.load(fileInputStream);
        ((InputStream)fileInputStream).close();
    }

    public long getSelectedContentSize() throws IOException {
        return this.getStatValue("content.size.", this.getSelectedContentNumbers(null));
    }

    public long getSelectedContentCount() throws IOException {
        return this.getStatValue("content.count.", this.getSelectedContentNumbers(null));
    }

    public long getSelectedContentSize(String string) throws IOException {
        return this.getStatValue("content.size.", this.getSelectedContentNumbers(string));
    }

    public long getSelectedContentCount(String string) throws IOException {
        return this.getStatValue("content.count.", this.getSelectedContentNumbers(string));
    }

    private long getStatValue(String string, Set set) {
        long l = 0L;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            l += Long.parseLong(this.stats.getProperty(string + string2));
        }
        return l;
    }

    public Set getSelectedContentNumbers(String string) {
        HashSet hashSet = new HashSet();
        if (string == null) {
            this.addContentNumbers(hashSet, String.valueOf(0));
            Iterator iterator = ContentStats.getSelectedComponents().iterator();
            while (iterator.hasNext()) {
                this.addContentNumbers(hashSet, (String)iterator.next());
            }
        } else {
            this.addContentNumbers(hashSet, string);
        }
        return hashSet;
    }

    private static Collection getSelectedComponents() {
        return (Collection)HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, new FetchObjectAction(){

            protected Object fetchValue(Context context) throws Exception {
                ArrayList<String> arrayList = new ArrayList<String>();
                Iterator iterator = InstallerConfig.getCurrentInstance().getComponents().iterator();
                while (iterator.hasNext()) {
                    ComponentConfig componentConfig = (ComponentConfig)iterator.next();
                    if (!componentConfig.isSelected()) continue;
                    arrayList.add(componentConfig.getId());
                }
                return arrayList;
            }
        });
    }

    private void addContentNumbers(Set set, String string) {
        int n = Integer.parseInt(this.stats.getProperty("setCount", "0"));
        for (int i = 0; i < n; ++i) {
            String string2 = this.stats.getProperty("components." + i);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (!string3.equals(string)) continue;
                set.add(String.valueOf(i));
            }
        }
    }

    public long getFileSize(String string) {
        return Long.parseLong(this.stats.getProperty("file.size." + string));
    }

    public String getDirName() {
        return this.stats.getProperty("dirName");
    }

    public String getFileName(String string) {
        return this.stats.getProperty("file.name." + string);
    }

    public String getComponentListString(String string) {
        return this.stats.getProperty("components." + string);
    }

    public String getEntriesSize(String string) {
        return this.stats.getProperty("entries.size." + string);
    }
}

