Object.assign(window.search, {"doc_urls":["index.html#rust-by-example","hello.html#hello-world","hello.html#activity","hello/comment.html#comments","hello/comment.html#see-also","hello/print.html#formatted-print","hello/print.html#activities","hello/print.html#see-also","hello/print/print_debug.html#debug","hello/print/print_debug.html#see-also","hello/print/print_display.html#display","hello/print/print_display.html#activity","hello/print/print_display.html#see-also","hello/print/print_display/testcase_list.html#testcase-list","hello/print/print_display/testcase_list.html#activity","hello/print/print_display/testcase_list.html#see-also","hello/print/fmt.html#formatting","hello/print/fmt.html#activity","hello/print/fmt.html#see-also","primitives.html#primitives","primitives.html#scalar-types","primitives.html#compound-types","primitives.html#see-also","primitives/literals.html#literals-and-operators","primitives/tuples.html#tuples","primitives/tuples.html#activity","primitives/array.html#arrays-and-slices","custom_types.html#custom-types","custom_types/structs.html#structures","custom_types/structs.html#activity","custom_types/structs.html#see-also","custom_types/enum.html#enums","custom_types/enum.html#type-aliases","custom_types/enum.html#see-also","custom_types/enum/enum_use.html#use","custom_types/enum/enum_use.html#see-also","custom_types/enum/c_like.html#c-like","custom_types/enum/c_like.html#see-also","custom_types/enum/testcase_linked_list.html#testcase-linked-list","custom_types/enum/testcase_linked_list.html#see-also","custom_types/constants.html#constants","custom_types/constants.html#see-also","variable_bindings.html#variable-bindings","variable_bindings/mut.html#mutability","variable_bindings/scope.html#scope-and-shadowing","variable_bindings/declare.html#declare-first","variable_bindings/freeze.html#freezing","types.html#types","types/cast.html#casting","types/literals.html#literals","types/inference.html#inference","types/alias.html#aliasing","types/alias.html#see-also","conversion.html#conversion","conversion/from_into.html#from-and-into","conversion/from_into.html#from","conversion/from_into.html#into","conversion/try_from_try_into.html#tryfrom-and-tryinto","conversion/string.html#to-and-from-strings","conversion/string.html#converting-to-string","conversion/string.html#parsing-a-string","expression.html#expressions","flow_control.html#flow-of-control","flow_control/if_else.html#ifelse","flow_control/loop.html#loop","flow_control/loop/nested.html#nesting-and-labels","flow_control/loop/return.html#returning-from-loops","flow_control/while.html#while","flow_control/for.html#for-loops","flow_control/for.html#for-and-range","flow_control/for.html#for-and-iterators","flow_control/for.html#see-also","flow_control/match.html#match","flow_control/match/destructuring.html#destructuring","flow_control/match/destructuring/destructure_tuple.html#tuples","flow_control/match/destructuring/destructure_tuple.html#see-also","flow_control/match/destructuring/destructure_slice.html#arraysslices","flow_control/match/destructuring/destructure_slice.html#see-also","flow_control/match/destructuring/destructure_enum.html#enums","flow_control/match/destructuring/destructure_enum.html#see-also","flow_control/match/destructuring/destructure_pointers.html#pointersref","flow_control/match/destructuring/destructure_pointers.html#see-also","flow_control/match/destructuring/destructure_structures.html#structs","flow_control/match/destructuring/destructure_structures.html#see-also","flow_control/match/guard.html#guards","flow_control/match/guard.html#see-also","flow_control/match/binding.html#binding","flow_control/match/binding.html#see-also","flow_control/if_let.html#if-let","flow_control/if_let.html#see-also","flow_control/let_else.html#let-else","flow_control/let_else.html#see-also","flow_control/while_let.html#while-let","flow_control/while_let.html#see-also","fn.html#functions","fn/methods.html#associated-functions--methods","fn/closures.html#closures","fn/closures/capture.html#capturing","fn/closures/capture.html#see-also","fn/closures/input_parameters.html#as-input-parameters","fn/closures/input_parameters.html#see-also","fn/closures/anonymity.html#type-anonymity","fn/closures/anonymity.html#see-also","fn/closures/input_functions.html#input-functions","fn/closures/input_functions.html#see-also","fn/closures/output_parameters.html#as-output-parameters","fn/closures/output_parameters.html#see-also","fn/closures/closure_examples.html#examples-in-std","fn/closures/closure_examples/iter_any.html#iteratorany","fn/closures/closure_examples/iter_any.html#see-also","fn/closures/closure_examples/iter_find.html#searching-through-iterators","fn/closures/closure_examples/iter_find.html#see-also","fn/hof.html#higher-order-functions","fn/diverging.html#diverging-functions","mod.html#modules","mod/visibility.html#visibility","mod/struct_visibility.html#struct-visibility","mod/struct_visibility.html#see-also","mod/use.html#the-use-declaration","mod/super.html#super-and-self","mod/split.html#file-hierarchy","crates.html#crates","crates/lib.html#creating-a-library","crates/using_lib.html#using-a-library","cargo.html#cargo","cargo/deps.html#dependencies","cargo/conventions.html#conventions","cargo/test.html#testing","cargo/build_scripts.html#build-scripts","cargo/build_scripts.html#how-to-use-a-build-script","attribute.html#attributes","attribute/unused.html#dead_code","attribute/crate.html#crates","attribute/cfg.html#cfg","attribute/cfg.html#see-also","attribute/cfg/custom.html#custom","generics.html#generics","generics.html#see-also","generics/gen_fn.html#functions","generics/gen_fn.html#see-also","generics/impl.html#implementation","generics/impl.html#see-also","generics/gen_trait.html#traits","generics/gen_trait.html#see-also","generics/bounds.html#bounds","generics/bounds.html#see-also","generics/bounds/testcase_empty.html#testcase-empty-bounds","generics/bounds/testcase_empty.html#see-also","generics/multi_bounds.html#multiple-bounds","generics/multi_bounds.html#see-also","generics/where.html#where-clauses","generics/where.html#see-also","generics/new_types.html#new-type-idiom","generics/new_types.html#see-also","generics/assoc_items.html#associated-items","generics/assoc_items.html#see-also","generics/assoc_items/the_problem.html#the-problem","generics/assoc_items/the_problem.html#see-also","generics/assoc_items/types.html#associated-types","generics/phantom.html#phantom-type-parameters","generics/phantom.html#see-also","generics/phantom/testcase_units.html#testcase-unit-clarification","generics/phantom/testcase_units.html#see-also","scope.html#scoping-rules","scope/raii.html#raii","scope/raii.html#destructor","scope/raii.html#see-also","scope/move.html#ownership-and-moves","scope/move/mut.html#mutability","scope/move/partial_move.html#partial-moves","scope/move/partial_move.html#see-also","scope/borrow.html#borrowing","scope/borrow/mut.html#mutability","scope/borrow/mut.html#see-also","scope/borrow/alias.html#aliasing","scope/borrow/ref.html#the-ref-pattern","scope/lifetime.html#lifetimes","scope/lifetime/explicit.html#explicit-annotation","scope/lifetime/explicit.html#see-also","scope/lifetime/fn.html#functions","scope/lifetime/fn.html#see-also","scope/lifetime/methods.html#methods","scope/lifetime/methods.html#see-also","scope/lifetime/struct.html#structs","scope/lifetime/struct.html#see-also","scope/lifetime/trait.html#traits","scope/lifetime/trait.html#see-also","scope/lifetime/lifetime_bounds.html#bounds","scope/lifetime/lifetime_bounds.html#see-also","scope/lifetime/lifetime_coercion.html#coercion","scope/lifetime/static_lifetime.html#static","scope/lifetime/static_lifetime.html#reference-lifetime","scope/lifetime/static_lifetime.html#trait-bound","scope/lifetime/static_lifetime.html#see-also","scope/lifetime/elision.html#elision","scope/lifetime/elision.html#see-also","trait.html#traits","trait/derive.html#derive","trait/derive.html#see-also","trait/dyn.html#returning-traits-with-dyn","trait/ops.html#operator-overloading","trait/ops.html#see-also","trait/drop.html#drop","trait/iter.html#iterators","trait/impl_trait.html#impl-trait","trait/impl_trait.html#as-an-argument-type","trait/impl_trait.html#as-a-return-type","trait/clone.html#clone","trait/supertraits.html#supertraits","trait/supertraits.html#see-also","trait/disambiguating.html#disambiguating-overlapping-traits","trait/disambiguating.html#see-also","macros.html#macro_rules","macros/syntax.html#syntax","macros/designators.html#designators","macros/overload.html#overload","macros/repeat.html#repeat","macros/dry.html#dry-dont-repeat-yourself","macros/dsl.html#domain-specific-languages-dsls","macros/variadics.html#variadic-interfaces","error.html#error-handling","error/panic.html#panic","error/abort_unwind.html#abort-and-unwind","error/option_unwrap.html#option--unwrap","error/option_unwrap/question_mark.html#unpacking-options-with-","error/option_unwrap/map.html#combinators-map","error/option_unwrap/map.html#see-also","error/option_unwrap/and_then.html#combinators-and_then","error/option_unwrap/and_then.html#see-also","error/option_unwrap/defaults.html#unpacking-options-and-defaults","error/option_unwrap/defaults.html#or-is-chainable-evaluates-eagerly-keeps-empty-value-intact","error/option_unwrap/defaults.html#or_else-is-chainable-evaluates-lazily-keeps-empty-value-intact","error/option_unwrap/defaults.html#get_or_insert-evaluates-eagerly-modifies-empty-value-in-place","error/option_unwrap/defaults.html#get_or_insert_with-evaluates-lazily-modifies-empty-value-in-place","error/option_unwrap/defaults.html#see-also","error/result.html#result","error/result.html#using-result-in-main","error/result/result_map.html#map-for-result","error/result/result_alias.html#aliases-for-result","error/result/result_alias.html#see-also","error/result/early_returns.html#early-returns","error/result/enter_question_mark.html#introducing-","error/result/enter_question_mark.html#the-try-macro","error/multiple_error_types.html#multiple-error-types","error/multiple_error_types/option_result.html#pulling-results-out-of-options","error/multiple_error_types/define_error_type.html#defining-an-error-type","error/multiple_error_types/boxing_errors.html#boxing-errors","error/multiple_error_types/boxing_errors.html#see-also","error/multiple_error_types/reenter_question_mark.html#other-uses-of-","error/multiple_error_types/reenter_question_mark.html#see-also","error/multiple_error_types/wrap_error.html#wrapping-errors","error/multiple_error_types/wrap_error.html#see-also","error/iter_result.html#iterating-over-results","error/iter_result.html#ignore-the-failed-items-with-filter_map","error/iter_result.html#collect-the-failed-items-with-map_err-and-filter_map","error/iter_result.html#fail-the-entire-operation-with-collect","error/iter_result.html#collect-all-valid-values-and-failures-with-partition","std.html#std-library-types","std.html#see-also","std/box.html#box-stack-and-heap","std/vec.html#vectors","std/str.html#strings","std/str.html#literals-and-escapes","std/option.html#option","std/result.html#result","std/result/question_mark.html#","std/panic.html#panic","std/hash.html#hashmap","std/hash/alt_key_types.html#alternatecustom-key-types","std/hash/hashset.html#hashset","std/rc.html#rc","std/rc.html#see-also","std/arc.html#arc","std_misc.html#std-misc","std_misc.html#see-also","std_misc/threads.html#threads","std_misc/threads/testcase_mapreduce.html#testcase-map-reduce","std_misc/threads/testcase_mapreduce.html#assignments","std_misc/threads/testcase_mapreduce.html#see-also","std_misc/channels.html#channels","std_misc/path.html#path","std_misc/path.html#see-also","std_misc/file.html#file-io","std_misc/file/open.html#open","std_misc/file/create.html#create","std_misc/file/read_lines.html#read_lines","std_misc/file/read_lines.html#a-naive-approach","std_misc/file/read_lines.html#a-more-efficient-approach","std_misc/process.html#child-processes","std_misc/process/pipe.html#pipes","std_misc/process/wait.html#wait","std_misc/fs.html#filesystem-operations","std_misc/fs.html#see-also","std_misc/arg.html#program-arguments","std_misc/arg.html#standard-library","std_misc/arg.html#crates","std_misc/arg/matching.html#argument-parsing","std_misc/ffi.html#foreign-function-interface","testing.html#testing","testing.html#see-also","testing/unit_testing.html#unit-testing","testing/unit_testing.html#tests-and-","testing/unit_testing.html#testing-panics","testing/unit_testing.html#running-specific-tests","testing/unit_testing.html#ignoring-tests","testing/doc_testing.html#documentation-testing","testing/doc_testing.html#motivation-behind-documentation-tests","testing/doc_testing.html#see-also","testing/integration_testing.html#integration-testing","testing/dev_dependencies.html#development-dependencies","testing/dev_dependencies.html#see-also","unsafe.html#unsafe-operations","unsafe.html#raw-pointers","unsafe.html#calling-unsafe-functions","unsafe/asm.html#inline-assembly","unsafe/asm.html#basic-usage","unsafe/asm.html#inputs-and-outputs","unsafe/asm.html#late-output-operands","unsafe/asm.html#explicit-register-operands","unsafe/asm.html#clobbered-registers","unsafe/asm.html#symbol-operands-and-abi-clobbers","unsafe/asm.html#register-template-modifiers","unsafe/asm.html#memory-address-operands","unsafe/asm.html#labels","unsafe/asm.html#options","compatibility.html#compatibility","compatibility/raw_identifiers.html#raw-identifiers","meta.html#meta","meta/doc.html#documentation","meta/doc.html#doc-comments","meta/doc.html#doc-attributes","meta/doc.html#inline","meta/doc.html#no_inline","meta/doc.html#hidden","meta/doc.html#see-also","meta/playground.html#playground","meta/playground.html#using-it-with-mdbook","meta/playground.html#using-it-with-docs","meta/playground.html#see-also"],"index":{"documentStore":{"docInfo":{"0":{"body":217,"breadcrumbs":3,"title":2},"1":{"body":70,"breadcrumbs":4,"title":2},"10":{"body":280,"breadcrumbs":6,"title":1},"100":{"body":5,"breadcrumbs":5,"title":1},"101":{"body":113,"breadcrumbs":6,"title":2},"102":{"body":5,"breadcrumbs":5,"title":1},"103":{"body":67,"breadcrumbs":6,"title":2},"104":{"body":3,"breadcrumbs":5,"title":1},"105":{"body":83,"breadcrumbs":6,"title":2},"106":{"body":5,"breadcrumbs":5,"title":1},"107":{"body":8,"breadcrumbs":6,"title":2},"108":{"body":144,"breadcrumbs":6,"title":1},"109":{"body":1,"breadcrumbs":6,"title":1},"11":{"body":25,"breadcrumbs":6,"title":1},"110":{"body":194,"breadcrumbs":10,"title":3},"111":{"body":4,"breadcrumbs":8,"title":1},"112":{"body":109,"breadcrumbs":7,"title":3},"113":{"body":164,"breadcrumbs":5,"title":2},"114":{"body":26,"breadcrumbs":2,"title":1},"115":{"body":272,"breadcrumbs":3,"title":1},"116":{"body":131,"breadcrumbs":5,"title":2},"117":{"body":2,"breadcrumbs":4,"title":1},"118":{"body":76,"breadcrumbs":5,"title":2},"119":{"body":100,"breadcrumbs":5,"title":2},"12":{"body":6,"breadcrumbs":6,"title":1},"120":{"body":112,"breadcrumbs":5,"title":2},"121":{"body":51,"breadcrumbs":2,"title":1},"122":{"body":52,"breadcrumbs":5,"title":2},"123":{"body":60,"breadcrumbs":5,"title":2},"124":{"body":39,"breadcrumbs":2,"title":1},"125":{"body":234,"breadcrumbs":3,"title":1},"126":{"body":71,"breadcrumbs":3,"title":1},"127":{"body":307,"breadcrumbs":3,"title":1},"128":{"body":45,"breadcrumbs":5,"title":2},"129":{"body":56,"breadcrumbs":6,"title":3},"13":{"body":115,"breadcrumbs":9,"title":2},"130":{"body":133,"breadcrumbs":2,"title":1},"131":{"body":46,"breadcrumbs":3,"title":1},"132":{"body":87,"breadcrumbs":3,"title":1},"133":{"body":98,"breadcrumbs":3,"title":1},"134":{"body":3,"breadcrumbs":3,"title":1},"135":{"body":38,"breadcrumbs":4,"title":1},"136":{"body":199,"breadcrumbs":2,"title":1},"137":{"body":1,"breadcrumbs":2,"title":1},"138":{"body":178,"breadcrumbs":3,"title":1},"139":{"body":2,"breadcrumbs":3,"title":1},"14":{"body":17,"breadcrumbs":8,"title":1},"140":{"body":80,"breadcrumbs":3,"title":1},"141":{"body":5,"breadcrumbs":3,"title":1},"142":{"body":80,"breadcrumbs":3,"title":1},"143":{"body":3,"breadcrumbs":3,"title":1},"144":{"body":169,"breadcrumbs":3,"title":1},"145":{"body":3,"breadcrumbs":3,"title":1},"146":{"body":87,"breadcrumbs":8,"title":3},"147":{"body":3,"breadcrumbs":6,"title":1},"148":{"body":52,"breadcrumbs":5,"title":2},"149":{"body":2,"breadcrumbs":4,"title":1},"15":{"body":4,"breadcrumbs":8,"title":1},"150":{"body":107,"breadcrumbs":3,"title":1},"151":{"body":3,"breadcrumbs":3,"title":1},"152":{"body":96,"breadcrumbs":7,"title":3},"153":{"body":1,"breadcrumbs":5,"title":1},"154":{"body":34,"breadcrumbs":5,"title":2},"155":{"body":1,"breadcrumbs":4,"title":1},"156":{"body":175,"breadcrumbs":5,"title":1},"157":{"body":2,"breadcrumbs":5,"title":1},"158":{"body":206,"breadcrumbs":7,"title":2},"159":{"body":168,"breadcrumbs":7,"title":3},"16":{"body":182,"breadcrumbs":6,"title":1},"160":{"body":3,"breadcrumbs":5,"title":1},"161":{"body":185,"breadcrumbs":10,"title":3},"162":{"body":13,"breadcrumbs":8,"title":1},"163":{"body":16,"breadcrumbs":4,"title":2},"164":{"body":187,"breadcrumbs":4,"title":1},"165":{"body":55,"breadcrumbs":4,"title":1},"166":{"body":1,"breadcrumbs":4,"title":1},"167":{"body":154,"breadcrumbs":6,"title":2},"168":{"body":36,"breadcrumbs":6,"title":1},"169":{"body":124,"breadcrumbs":8,"title":2},"17":{"body":58,"breadcrumbs":6,"title":1},"170":{"body":1,"breadcrumbs":7,"title":1},"171":{"body":134,"breadcrumbs":4,"title":1},"172":{"body":137,"breadcrumbs":5,"title":1},"173":{"body":1,"breadcrumbs":5,"title":1},"174":{"body":168,"breadcrumbs":5,"title":1},"175":{"body":136,"breadcrumbs":7,"title":2},"176":{"body":113,"breadcrumbs":4,"title":1},"177":{"body":182,"breadcrumbs":7,"title":2},"178":{"body":2,"breadcrumbs":6,"title":1},"179":{"body":147,"breadcrumbs":5,"title":1},"18":{"body":1,"breadcrumbs":6,"title":1},"180":{"body":1,"breadcrumbs":5,"title":1},"181":{"body":30,"breadcrumbs":5,"title":1},"182":{"body":1,"breadcrumbs":5,"title":1},"183":{"body":72,"breadcrumbs":5,"title":1},"184":{"body":1,"breadcrumbs":5,"title":1},"185":{"body":38,"breadcrumbs":5,"title":1},"186":{"body":1,"breadcrumbs":5,"title":1},"187":{"body":113,"breadcrumbs":5,"title":1},"188":{"body":6,"breadcrumbs":5,"title":1},"189":{"body":82,"breadcrumbs":5,"title":1},"19":{"body":8,"breadcrumbs":2,"title":1},"190":{"body":41,"breadcrumbs":5,"title":1},"191":{"body":167,"breadcrumbs":6,"title":2},"192":{"body":88,"breadcrumbs":6,"title":2},"193":{"body":2,"breadcrumbs":5,"title":1},"194":{"body":82,"breadcrumbs":5,"title":1},"195":{"body":1,"breadcrumbs":5,"title":1},"196":{"body":168,"breadcrumbs":2,"title":1},"197":{"body":141,"breadcrumbs":3,"title":1},"198":{"body":1,"breadcrumbs":3,"title":1},"199":{"body":149,"breadcrumbs":7,"title":3},"2":{"body":19,"breadcrumbs":3,"title":1},"20":{"body":53,"breadcrumbs":3,"title":2},"200":{"body":140,"breadcrumbs":5,"title":2},"201":{"body":3,"breadcrumbs":4,"title":1},"202":{"body":122,"breadcrumbs":3,"title":1},"203":{"body":213,"breadcrumbs":3,"title":1},"204":{"body":9,"breadcrumbs":5,"title":2},"205":{"body":132,"breadcrumbs":5,"title":2},"206":{"body":190,"breadcrumbs":5,"title":2},"207":{"body":122,"breadcrumbs":3,"title":1},"208":{"body":73,"breadcrumbs":3,"title":1},"209":{"body":5,"breadcrumbs":3,"title":1},"21":{"body":88,"breadcrumbs":3,"title":2},"210":{"body":118,"breadcrumbs":7,"title":3},"211":{"body":7,"breadcrumbs":5,"title":1},"212":{"body":127,"breadcrumbs":2,"title":1},"213":{"body":13,"breadcrumbs":3,"title":1},"214":{"body":117,"breadcrumbs":4,"title":1},"215":{"body":57,"breadcrumbs":4,"title":1},"216":{"body":65,"breadcrumbs":4,"title":1},"217":{"body":158,"breadcrumbs":9,"title":4},"218":{"body":100,"breadcrumbs":9,"title":4},"219":{"body":79,"breadcrumbs":4,"title":2},"22":{"body":5,"breadcrumbs":2,"title":1},"220":{"body":137,"breadcrumbs":4,"title":2},"221":{"body":52,"breadcrumbs":4,"title":1},"222":{"body":106,"breadcrumbs":6,"title":2},"223":{"body":175,"breadcrumbs":6,"title":2},"224":{"body":119,"breadcrumbs":8,"title":2},"225":{"body":182,"breadcrumbs":8,"title":2},"226":{"body":3,"breadcrumbs":7,"title":1},"227":{"body":171,"breadcrumbs":8,"title":2},"228":{"body":4,"breadcrumbs":7,"title":1},"229":{"body":28,"breadcrumbs":11,"title":3},"23":{"body":165,"breadcrumbs":5,"title":2},"230":{"body":68,"breadcrumbs":15,"title":7},"231":{"body":44,"breadcrumbs":16,"title":8},"232":{"body":60,"breadcrumbs":15,"title":7},"233":{"body":70,"breadcrumbs":15,"title":7},"234":{"body":6,"breadcrumbs":9,"title":1},"235":{"body":137,"breadcrumbs":4,"title":1},"236":{"body":64,"breadcrumbs":6,"title":3},"237":{"body":189,"breadcrumbs":7,"title":2},"238":{"body":102,"breadcrumbs":7,"title":2},"239":{"body":1,"breadcrumbs":6,"title":1},"24":{"body":194,"breadcrumbs":3,"title":1},"240":{"body":115,"breadcrumbs":7,"title":2},"241":{"body":85,"breadcrumbs":5,"title":1},"242":{"body":77,"breadcrumbs":6,"title":2},"243":{"body":109,"breadcrumbs":8,"title":3},"244":{"body":110,"breadcrumbs":13,"title":4},"245":{"body":175,"breadcrumbs":11,"title":3},"246":{"body":112,"breadcrumbs":9,"title":2},"247":{"body":4,"breadcrumbs":8,"title":1},"248":{"body":169,"breadcrumbs":7,"title":1},"249":{"body":1,"breadcrumbs":7,"title":1},"25":{"body":59,"breadcrumbs":3,"title":1},"250":{"body":184,"breadcrumbs":9,"title":2},"251":{"body":2,"breadcrumbs":8,"title":1},"252":{"body":24,"breadcrumbs":8,"title":3},"253":{"body":22,"breadcrumbs":9,"title":4},"254":{"body":36,"breadcrumbs":10,"title":5},"255":{"body":37,"breadcrumbs":9,"title":4},"256":{"body":56,"breadcrumbs":10,"title":5},"257":{"body":31,"breadcrumbs":6,"title":3},"258":{"body":3,"breadcrumbs":4,"title":1},"259":{"body":181,"breadcrumbs":9,"title":3},"26":{"body":224,"breadcrumbs":5,"title":2},"260":{"body":178,"breadcrumbs":5,"title":1},"261":{"body":149,"breadcrumbs":5,"title":1},"262":{"body":296,"breadcrumbs":6,"title":2},"263":{"body":115,"breadcrumbs":5,"title":1},"264":{"body":147,"breadcrumbs":5,"title":1},"265":{"body":132,"breadcrumbs":4,"title":0},"266":{"body":164,"breadcrumbs":5,"title":1},"267":{"body":158,"breadcrumbs":5,"title":1},"268":{"body":184,"breadcrumbs":10,"title":3},"269":{"body":174,"breadcrumbs":6,"title":1},"27":{"body":21,"breadcrumbs":4,"title":2},"270":{"body":145,"breadcrumbs":5,"title":1},"271":{"body":2,"breadcrumbs":5,"title":1},"272":{"body":84,"breadcrumbs":5,"title":1},"273":{"body":16,"breadcrumbs":4,"title":2},"274":{"body":3,"breadcrumbs":3,"title":1},"275":{"body":53,"breadcrumbs":4,"title":1},"276":{"body":356,"breadcrumbs":9,"title":3},"277":{"body":30,"breadcrumbs":7,"title":1},"278":{"body":19,"breadcrumbs":7,"title":1},"279":{"body":128,"breadcrumbs":4,"title":1},"28":{"body":185,"breadcrumbs":4,"title":1},"280":{"body":145,"breadcrumbs":4,"title":1},"281":{"body":2,"breadcrumbs":4,"title":1},"282":{"body":44,"breadcrumbs":6,"title":2},"283":{"body":107,"breadcrumbs":6,"title":1},"284":{"body":219,"breadcrumbs":6,"title":1},"285":{"body":0,"breadcrumbs":6,"title":1},"286":{"body":83,"breadcrumbs":7,"title":2},"287":{"body":116,"breadcrumbs":8,"title":3},"288":{"body":47,"breadcrumbs":6,"title":2},"289":{"body":124,"breadcrumbs":6,"title":1},"29":{"body":27,"breadcrumbs":4,"title":1},"290":{"body":36,"breadcrumbs":6,"title":1},"291":{"body":248,"breadcrumbs":6,"title":2},"292":{"body":1,"breadcrumbs":5,"title":1},"293":{"body":0,"breadcrumbs":6,"title":2},"294":{"body":55,"breadcrumbs":6,"title":2},"295":{"body":19,"breadcrumbs":5,"title":1},"296":{"body":170,"breadcrumbs":8,"title":2},"297":{"body":155,"breadcrumbs":8,"title":3},"298":{"body":32,"breadcrumbs":2,"title":1},"299":{"body":7,"breadcrumbs":2,"title":1},"3":{"body":126,"breadcrumbs":4,"title":1},"30":{"body":2,"breadcrumbs":4,"title":1},"300":{"body":168,"breadcrumbs":5,"title":2},"301":{"body":52,"breadcrumbs":4,"title":1},"302":{"body":124,"breadcrumbs":5,"title":2},"303":{"body":114,"breadcrumbs":6,"title":3},"304":{"body":139,"breadcrumbs":5,"title":2},"305":{"body":180,"breadcrumbs":5,"title":2},"306":{"body":101,"breadcrumbs":7,"title":4},"307":{"body":7,"breadcrumbs":4,"title":1},"308":{"body":197,"breadcrumbs":5,"title":2},"309":{"body":71,"breadcrumbs":5,"title":2},"31":{"body":121,"breadcrumbs":4,"title":1},"310":{"body":4,"breadcrumbs":4,"title":1},"311":{"body":55,"breadcrumbs":4,"title":2},"312":{"body":32,"breadcrumbs":4,"title":2},"313":{"body":61,"breadcrumbs":5,"title":3},"314":{"body":55,"breadcrumbs":6,"title":2},"315":{"body":38,"breadcrumbs":6,"title":2},"316":{"body":270,"breadcrumbs":6,"title":2},"317":{"body":179,"breadcrumbs":7,"title":3},"318":{"body":182,"breadcrumbs":7,"title":3},"319":{"body":358,"breadcrumbs":6,"title":2},"32":{"body":79,"breadcrumbs":5,"title":2},"320":{"body":85,"breadcrumbs":8,"title":4},"321":{"body":150,"breadcrumbs":7,"title":3},"322":{"body":41,"breadcrumbs":7,"title":3},"323":{"body":199,"breadcrumbs":5,"title":1},"324":{"body":161,"breadcrumbs":5,"title":1},"325":{"body":17,"breadcrumbs":2,"title":1},"326":{"body":96,"breadcrumbs":5,"title":2},"327":{"body":28,"breadcrumbs":2,"title":1},"328":{"body":26,"breadcrumbs":3,"title":1},"329":{"body":111,"breadcrumbs":4,"title":2},"33":{"body":8,"breadcrumbs":4,"title":1},"330":{"body":8,"breadcrumbs":4,"title":2},"331":{"body":22,"breadcrumbs":3,"title":1},"332":{"body":13,"breadcrumbs":3,"title":1},"333":{"body":24,"breadcrumbs":3,"title":1},"334":{"body":31,"breadcrumbs":3,"title":1},"335":{"body":9,"breadcrumbs":3,"title":1},"336":{"body":44,"breadcrumbs":4,"title":2},"337":{"body":26,"breadcrumbs":4,"title":2},"338":{"body":7,"breadcrumbs":3,"title":1},"34":{"body":79,"breadcrumbs":5,"title":1},"35":{"body":2,"breadcrumbs":5,"title":1},"36":{"body":50,"breadcrumbs":5,"title":1},"37":{"body":1,"breadcrumbs":5,"title":1},"38":{"body":192,"breadcrumbs":9,"title":3},"39":{"body":2,"breadcrumbs":7,"title":1},"4":{"body":2,"breadcrumbs":4,"title":1},"40":{"body":83,"breadcrumbs":4,"title":1},"41":{"body":4,"breadcrumbs":4,"title":1},"42":{"body":75,"breadcrumbs":4,"title":2},"43":{"body":38,"breadcrumbs":4,"title":1},"44":{"body":84,"breadcrumbs":6,"title":2},"45":{"body":56,"breadcrumbs":6,"title":2},"46":{"body":46,"breadcrumbs":4,"title":1},"47":{"body":27,"breadcrumbs":2,"title":1},"48":{"body":295,"breadcrumbs":3,"title":1},"49":{"body":114,"breadcrumbs":3,"title":1},"5":{"body":306,"breadcrumbs":6,"title":2},"50":{"body":80,"breadcrumbs":3,"title":1},"51":{"body":81,"breadcrumbs":3,"title":1},"52":{"body":1,"breadcrumbs":3,"title":1},"53":{"body":30,"breadcrumbs":2,"title":1},"54":{"body":16,"breadcrumbs":1,"title":0},"55":{"body":64,"breadcrumbs":1,"title":0},"56":{"body":55,"breadcrumbs":1,"title":0},"57":{"body":60,"breadcrumbs":5,"title":2},"58":{"body":0,"breadcrumbs":3,"title":1},"59":{"body":49,"breadcrumbs":4,"title":2},"6":{"body":47,"breadcrumbs":5,"title":1},"60":{"body":63,"breadcrumbs":4,"title":2},"61":{"body":86,"breadcrumbs":2,"title":1},"62":{"body":13,"breadcrumbs":4,"title":2},"63":{"body":80,"breadcrumbs":4,"title":1},"64":{"body":54,"breadcrumbs":4,"title":1},"65":{"body":47,"breadcrumbs":7,"title":2},"66":{"body":36,"breadcrumbs":7,"title":2},"67":{"body":43,"breadcrumbs":2,"title":0},"68":{"body":0,"breadcrumbs":4,"title":1},"69":{"body":87,"breadcrumbs":4,"title":1},"7":{"body":5,"breadcrumbs":5,"title":1},"70":{"body":156,"breadcrumbs":4,"title":1},"71":{"body":1,"breadcrumbs":4,"title":1},"72":{"body":95,"breadcrumbs":4,"title":1},"73":{"body":17,"breadcrumbs":5,"title":1},"74":{"body":71,"breadcrumbs":6,"title":1},"75":{"body":1,"breadcrumbs":6,"title":1},"76":{"body":105,"breadcrumbs":6,"title":1},"77":{"body":4,"breadcrumbs":6,"title":1},"78":{"body":130,"breadcrumbs":6,"title":1},"79":{"body":4,"breadcrumbs":6,"title":1},"8":{"body":150,"breadcrumbs":6,"title":1},"80":{"body":149,"breadcrumbs":6,"title":1},"81":{"body":2,"breadcrumbs":6,"title":1},"82":{"body":120,"breadcrumbs":6,"title":1},"83":{"body":1,"breadcrumbs":6,"title":1},"84":{"body":86,"breadcrumbs":5,"title":1},"85":{"body":2,"breadcrumbs":5,"title":1},"86":{"body":115,"breadcrumbs":5,"title":1},"87":{"body":3,"breadcrumbs":5,"title":1},"88":{"body":235,"breadcrumbs":2,"title":0},"89":{"body":3,"breadcrumbs":3,"title":1},"9":{"body":4,"breadcrumbs":6,"title":1},"90":{"body":114,"breadcrumbs":2,"title":0},"91":{"body":3,"breadcrumbs":3,"title":1},"92":{"body":99,"breadcrumbs":2,"title":0},"93":{"body":3,"breadcrumbs":3,"title":1},"94":{"body":116,"breadcrumbs":2,"title":1},"95":{"body":298,"breadcrumbs":5,"title":3},"96":{"body":149,"breadcrumbs":3,"title":1},"97":{"body":281,"breadcrumbs":4,"title":1},"98":{"body":2,"breadcrumbs":4,"title":1},"99":{"body":235,"breadcrumbs":6,"title":2}},"docs":{"0":{"body":"Rust is a modern systems programming language focusing on safety, speed, and concurrency. It accomplishes these goals by being memory safe without using garbage collection. Rust by Example (RBE) is a collection of runnable examples that illustrate various Rust concepts and standard libraries. To get even more out of these examples, don't forget to install Rust locally and check out the official docs . Additionally for the curious, you can also check out the source code for this site . Now let's begin! Hello World - Start with a traditional Hello World program. Primitives - Learn about signed integers, unsigned integers and other primitives. Custom Types - struct and enum. Variable Bindings - mutable bindings, scope, shadowing. Types - Learn about changing and defining types. Conversion - Convert between different types, such as strings, integers, and floats. Expressions - Learn about Expressions & how to use them. Flow of Control - if/else, for, and others. Functions - Learn about Methods, Closures and Higher Order Functions. Modules - Organize code using modules Crates - A crate is a compilation unit in Rust. Learn to create a library. Cargo - Go through some basic features of the official Rust package management tool. Attributes - An attribute is metadata applied to some module, crate or item. Generics - Learn about writing a function or data type which can work for multiple types of arguments. Scoping rules - Scopes play an important part in ownership, borrowing, and lifetimes. Traits - A trait is a collection of methods defined for an unknown type: Self Macros - Macros are a way of writing code that writes other code, which is known as metaprogramming. Error handling - Learn Rust way of handling failures. Std library types - Learn about some custom types provided by std library. Std misc - More custom types for file handling, threads. Testing - All sorts of testing in Rust. Unsafe Operations - Learn about entering a block of unsafe operations. Compatibility - Handling Rust's evolution and potential compatibility issues. Meta - Documentation, Benchmarking.","breadcrumbs":"Introduction » Rust by Example","id":"0","title":"Rust by Example"},"1":{"body":"This is the source code of the traditional Hello World program. // This is a comment, and is ignored by the compiler.\n// You can test this code by clicking the \"Run\" button over there ->\n// or if you prefer to use your keyboard, you can use the \"Ctrl + Enter\"\n// shortcut. // This code is editable, feel free to hack it!\n// You can always return to the original code by clicking the \"Reset\" button -> // This is the main function.\nfn main() { // Statements here are executed when the compiled binary is called. // Print text to the console. println!(\"Hello World!\");\n} println! is a macro that prints text to the console. A binary can be generated using the Rust compiler: rustc. $ rustc hello.rs rustc will produce a hello binary that can be executed. $ ./hello\nHello World!","breadcrumbs":"Hello World » Hello World","id":"1","title":"Hello World"},"10":{"body":"fmt::Debug hardly looks compact and clean, so it is often advantageous to customize the output appearance. This is done by manually implementing fmt::Display , which uses the {} print marker. Implementing it looks like this: // Import (via `use`) the `fmt` module to make it available.\nuse std::fmt; // Define a structure for which `fmt::Display` will be implemented. This is\n// a tuple struct named `Structure` that contains an `i32`.\nstruct Structure(i32); // To use the `{}` marker, the trait `fmt::Display` must be implemented\n// manually for the type.\nimpl fmt::Display for Structure { // This trait requires `fmt` with this exact signature. fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result { // Write strictly the first element into the supplied output // stream: `f`. Returns `fmt::Result` which indicates whether the // operation succeeded or failed. Note that `write!` uses syntax which // is very similar to `println!`. write!(f, \"{}\", self.0) }\n} fmt::Display may be cleaner than fmt::Debug but this presents a problem for the std library. How should ambiguous types be displayed? For example, if the std library implemented a single style for all Vec<T>, what style should it be? Would it be either of these two? Vec<path>: /:/etc:/home/username:/bin (split on :) Vec<number>: 1,2,3 (split on ,) No, because there is no ideal style for all types and the std library doesn't presume to dictate one. fmt::Display is not implemented for Vec<T> or for any other generic containers. fmt::Debug must then be used for these generic cases. This is not a problem though because for any new container type which is not generic, fmt::Display can be implemented. use std::fmt; // Import `fmt` // A structure holding two numbers. `Debug` will be derived so the results can\n// be contrasted with `Display`.\n#[derive(Debug)]\nstruct MinMax(i64, i64); // Implement `Display` for `MinMax`.\nimpl fmt::Display for MinMax { fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result { // Use `self.number` to refer to each positional data point. write!(f, \"({}, {})\", self.0, self.1) }\n} // Define a structure where the fields are nameable for comparison.\n#[derive(Debug)]\nstruct Point2D { x: f64, y: f64,\n} // Similarly, implement `Display` for `Point2D`.\nimpl fmt::Display for Point2D { fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result { // Customize so only `x` and `y` are denoted. write!(f, \"x: {}, y: {}\", self.x, self.y) }\n} fn main() { let minmax = MinMax(0, 14); println!(\"Compare structures:\"); println!(\"Display: {}\", minmax); println!(\"Debug: {:?}\", minmax); let big_range = MinMax(-300, 300); let small_range = MinMax(-3, 3); println!(\"The big range is {big} and the small is {small}\", small = small_range, big = big_range); let point = Point2D { x: 3.3, y: 7.2 }; println!(\"Compare points:\"); println!(\"Display: {}\", point); println!(\"Debug: {:?}\", point); // Error. Both `Debug` and `Display` were implemented, but `{:b}` // requires `fmt::Binary` to be implemented. This will not work. // println!(\"What does Point2D look like in binary: {:b}?\", point);\n} So, fmt::Display has been implemented but fmt::Binary has not, and therefore cannot be used. std::fmt has many such traits and each requires its own implementation. This is detailed further in std::fmt .","breadcrumbs":"Hello World » Formatted print » Display » Display","id":"10","title":"Display"},"100":{"body":"std::mem::drop , Fn , FnMut , Generics , where and FnOnce","breadcrumbs":"Functions » Closures » As input parameters » See also:","id":"100","title":"See also:"},"101":{"body":"Closures succinctly capture variables from enclosing scopes. Does this have any consequences? It surely does. Observe how using a closure as a function parameter requires generics , which is necessary because of how they are defined: // `F` must be generic.\nfn apply<F>(f: F) where F: FnOnce() { f();\n} When a closure is defined, the compiler implicitly creates a new anonymous structure to store the captured variables inside, meanwhile implementing the functionality via one of the traits: Fn, FnMut, or FnOnce for this unknown type. This type is assigned to the variable which is stored until calling. Since this new type is of unknown type, any usage in a function will require generics. However, an unbounded type parameter <T> would still be ambiguous and not be allowed. Thus, bounding by one of the traits: Fn, FnMut, or FnOnce (which it implements) is sufficient to specify its type. // `F` must implement `Fn` for a closure which takes no\n// inputs and returns nothing - exactly what is required\n// for `print`.\nfn apply<F>(f: F) where F: Fn() { f();\n} fn main() { let x = 7; // Capture `x` into an anonymous type and implement // `Fn` for it. Store it in `print`. let print = || println!(\"{}\", x); apply(print);\n}","breadcrumbs":"Functions » Closures » Type anonymity » Type anonymity","id":"101","title":"Type anonymity"},"102":{"body":"A thorough analysis , Fn , FnMut , and FnOnce","breadcrumbs":"Functions » Closures » Type anonymity » See also:","id":"102","title":"See also:"},"103":{"body":"Since closures may be used as arguments, you might wonder if the same can be said about functions. And indeed they can! If you declare a function that takes a closure as parameter, then any function that satisfies the trait bound of that closure can be passed as a parameter. // Define a function which takes a generic `F` argument\n// bounded by `Fn`, and calls it\nfn call_me<F: Fn()>(f: F) { f();\n} // Define a wrapper function satisfying the `Fn` bound\nfn function() { println!(\"I'm a function!\");\n} fn main() { // Define a closure satisfying the `Fn` bound let closure = || println!(\"I'm a closure!\"); call_me(closure); call_me(function);\n} As an additional note, the Fn, FnMut, and FnOnce traits dictate how a closure captures variables from the enclosing scope.","breadcrumbs":"Functions » Closures » Input functions » Input functions","id":"103","title":"Input functions"},"104":{"body":"Fn , FnMut , and FnOnce","breadcrumbs":"Functions » Closures » Input functions » See also:","id":"104","title":"See also:"},"105":{"body":"Closures as input parameters are possible, so returning closures as output parameters should also be possible. However, anonymous closure types are, by definition, unknown, so we have to use impl Trait to return them. The valid traits for returning a closure are: Fn FnMut FnOnce Beyond this, the move keyword must be used, which signals that all captures occur by value. This is required because any captures by reference would be dropped as soon as the function exited, leaving invalid references in the closure. fn create_fn() -> impl Fn() { let text = \"Fn\".to_owned(); move || println!(\"This is a: {}\", text)\n} fn create_fnmut() -> impl FnMut() { let text = \"FnMut\".to_owned(); move || println!(\"This is a: {}\", text)\n} fn create_fnonce() -> impl FnOnce() { let text = \"FnOnce\".to_owned(); move || println!(\"This is a: {}\", text)\n} fn main() { let fn_plain = create_fn(); let mut fn_mut = create_fnmut(); let fn_once = create_fnonce(); fn_plain(); fn_mut(); fn_once();\n}","breadcrumbs":"Functions » Closures » As output parameters » As output parameters","id":"105","title":"As output parameters"},"106":{"body":"Fn , FnMut , Generics and impl Trait .","breadcrumbs":"Functions » Closures » As output parameters » See also:","id":"106","title":"See also:"},"107":{"body":"This section contains a few examples of using closures from the std library.","breadcrumbs":"Functions » Closures » Examples in std » Examples in std","id":"107","title":"Examples in std"},"108":{"body":"Iterator::any is a function which when passed an iterator, will return true if any element satisfies the predicate. Otherwise false. Its signature: pub trait Iterator { // The type being iterated over. type Item; // `any` takes `&mut self` meaning the caller may be borrowed // and modified, but not consumed. fn any<F>(&mut self, f: F) -> bool where // `FnMut` meaning any captured variable may at most be // modified, not consumed. `Self::Item` states it takes // arguments to the closure by value. F: FnMut(Self::Item) -> bool;\n} fn main() { let vec1 = vec![1, 2, 3]; let vec2 = vec![4, 5, 6]; // `iter()` for vecs yields `&i32`. Destructure to `i32`. println!(\"2 in vec1: {}\", vec1.iter() .any(|&x| x == 2)); // `into_iter()` for vecs yields `i32`. No destructuring required. println!(\"2 in vec2: {}\", vec2.into_iter().any(|x| x == 2)); // `iter()` only borrows `vec1` and its elements, so they can be used again println!(\"vec1 len: {}\", vec1.len()); println!(\"First element of vec1 is: {}\", vec1[0]); // `into_iter()` does move `vec2` and its elements, so they cannot be used again // println!(\"First element of vec2 is: {}\", vec2[0]); // println!(\"vec2 len: {}\", vec2.len()); // TODO: uncomment two lines above and see compiler errors. let array1 = [1, 2, 3]; let array2 = [4, 5, 6]; // `iter()` for arrays yields `&i32`. println!(\"2 in array1: {}\", array1.iter() .any(|&x| x == 2)); // `into_iter()` for arrays yields `i32`. println!(\"2 in array2: {}\", array2.into_iter().any(|x| x == 2));\n}","breadcrumbs":"Functions » Closures » Examples in std » Iterator::any » Iterator::any","id":"108","title":"Iterator::any"},"109":{"body":"std::iter::Iterator::any","breadcrumbs":"Functions » Closures » Examples in std » Iterator::any » See also:","id":"109","title":"See also:"},"11":{"body":"After checking the output of the above example, use the Point2D struct as a guide to add a Complex struct to the example. When printed in the same way, the output should be: Display: 3.3 + 7.2i\nDebug: Complex { real: 3.3, imag: 7.2 }","breadcrumbs":"Hello World » Formatted print » Display » Activity","id":"11","title":"Activity"},"110":{"body":"Iterator::find is a function which iterates over an iterator and searches for the first value which satisfies some condition. If none of the values satisfy the condition, it returns None. Its signature: pub trait Iterator { // The type being iterated over. type Item; // `find` takes `&mut self` meaning the caller may be borrowed // and modified, but not consumed. fn find<P>(&mut self, predicate: P) -> Option<Self::Item> where // `FnMut` meaning any captured variable may at most be // modified, not consumed. `&Self::Item` states it takes // arguments to the closure by reference. P: FnMut(&Self::Item) -> bool;\n} fn main() { let vec1 = vec![1, 2, 3]; let vec2 = vec![4, 5, 6]; // `iter()` for vecs yields `&i32`. let mut iter = vec1.iter(); // `into_iter()` for vecs yields `i32`. let mut into_iter = vec2.into_iter(); // `iter()` for vecs yields `&i32`, and we want to reference one of its // items, so we have to destructure `&&i32` to `i32` println!(\"Find 2 in vec1: {:?}\", iter .find(|&&x| x == 2)); // `into_iter()` for vecs yields `i32`, and we want to reference one of // its items, so we have to destructure `&i32` to `i32` println!(\"Find 2 in vec2: {:?}\", into_iter.find(| &x| x == 2)); let array1 = [1, 2, 3]; let array2 = [4, 5, 6]; // `iter()` for arrays yields `&&i32` println!(\"Find 2 in array1: {:?}\", array1.iter() .find(|&&x| x == 2)); // `into_iter()` for arrays yields `&i32` println!(\"Find 2 in array2: {:?}\", array2.into_iter().find(|&x| x == 2));\n} Iterator::find gives you a reference to the item. But if you want the index of the item, use Iterator::position. fn main() { let vec = vec![1, 9, 3, 3, 13, 2]; // `iter()` for vecs yields `&i32` and `position()` does not take a reference, so // we have to destructure `&i32` to `i32` let index_of_first_even_number = vec.iter().position(|&x| x % 2 == 0); assert_eq!(index_of_first_even_number, Some(5)); // `into_iter()` for vecs yields `i32` and `position()` does not take a reference, so // we do not have to destructure let index_of_first_negative_number = vec.into_iter().position(|x| x < 0); assert_eq!(index_of_first_negative_number, None);\n}","breadcrumbs":"Functions » Closures » Examples in std » Searching through iterators » Searching through iterators","id":"110","title":"Searching through iterators"},"111":{"body":"std::iter::Iterator::find std::iter::Iterator::find_map std::iter::Iterator::position std::iter::Iterator::rposition","breadcrumbs":"Functions » Closures » Examples in std » Searching through iterators » See also:","id":"111","title":"See also:"},"112":{"body":"Rust provides Higher Order Functions (HOF). These are functions that take one or more functions and/or produce a more useful function. HOFs and lazy iterators give Rust its functional flavor. fn is_odd(n: u32) -> bool { n % 2 == 1\n} fn main() { println!(\"Find the sum of all the numbers with odd squares under 1000\"); let upper = 1000; // Imperative approach // Declare accumulator variable let mut acc = 0; // Iterate: 0, 1, 2, ... to infinity for n in 0.. { // Square the number let n_squared = n * n; if n_squared >= upper { // Break loop if exceeded the upper limit break; } else if is_odd(n_squared) { // Accumulate value, if it's odd acc += n_squared; } } println!(\"imperative style: {}\", acc); // Functional approach let sum_of_squared_odd_numbers: u32 = (0..).map(|n| n * n) // All natural numbers squared .take_while(|&n_squared| n_squared < upper) // Below upper limit .filter(|&n_squared| is_odd(n_squared)) // That are odd .sum(); // Sum them println!(\"functional style: {}\", sum_of_squared_odd_numbers);\n} Option and Iterator implement their fair share of HOFs.","breadcrumbs":"Functions » Higher Order Functions » Higher Order Functions","id":"112","title":"Higher Order Functions"},"113":{"body":"Diverging functions never return. They are marked using !, which is an empty type. fn foo() -> ! { panic!(\"This call never returns.\");\n} As opposed to all the other types, this one cannot be instantiated, because the set of all possible values this type can have is empty. Note that, it is different from the () type, which has exactly one possible value. For example, this function returns as usual, although there is no information in the return value. fn some_fn() { ()\n} fn main() { let _a: () = some_fn(); println!(\"This function returns and you can see this line.\");\n} As opposed to this function, which will never return the control back to the caller. #![feature(never_type)] fn main() { let x: ! = panic!(\"This call never returns.\"); println!(\"You will never see this line!\");\n} Although this might seem like an abstract concept, it is in fact very useful and often handy. The main advantage of this type is that it can be cast to any other one and therefore used at places where an exact type is required, for instance in match branches. This allows us to write code like this: fn main() { fn sum_odd_numbers(up_to: u32) -> u32 { let mut acc = 0; for i in 0..up_to { // Notice that the return type of this match expression must be u32 // because of the type of the \"addition\" variable. let addition: u32 = match i%2 == 1 { // The \"i\" variable is of type u32, which is perfectly fine. true => i, // On the other hand, the \"continue\" expression does not return // u32, but it is still fine, because it never returns and therefore // does not violate the type requirements of the match expression. false => continue, }; acc += addition; } acc } println!(\"Sum of odd numbers up to 9 (excluding): {}\", sum_odd_numbers(9));\n} It is also the return type of functions that loop forever (e.g. loop {}) like network servers or functions that terminate the process (e.g. exit()).","breadcrumbs":"Functions » Diverging functions » Diverging functions","id":"113","title":"Diverging functions"},"114":{"body":"Rust provides a powerful module system that can be used to hierarchically split code in logical units (modules), and manage visibility (public/private) between them. A module is a collection of items: functions, structs, traits, impl blocks, and even other modules.","breadcrumbs":"Modules » Modules","id":"114","title":"Modules"},"115":{"body":"By default, the items in a module have private visibility, but this can be overridden with the pub modifier. Only the public items of a module can be accessed from outside the module scope. // A module named `my_mod`\nmod my_mod { // Items in modules default to private visibility. fn private_function() { println!(\"called `my_mod::private_function()`\"); } // Use the `pub` modifier to override default visibility. pub fn function() { println!(\"called `my_mod::function()`\"); } // Items can access other items in the same module, // even when private. pub fn indirect_access() { print!(\"called `my_mod::indirect_access()`, that\\n> \"); private_function(); } // Modules can also be nested pub mod nested { pub fn function() { println!(\"called `my_mod::nested::function()`\"); } #[allow(dead_code)] fn private_function() { println!(\"called `my_mod::nested::private_function()`\"); } // Functions declared using `pub(in path)` syntax are only visible // within the given path. `path` must be a parent or ancestor module pub(in crate::my_mod) fn public_function_in_my_mod() { print!(\"called `my_mod::nested::public_function_in_my_mod()`, that\\n> \"); public_function_in_nested(); } // Functions declared using `pub(self)` syntax are only visible within // the current module, which is the same as leaving them private pub(self) fn public_function_in_nested() { println!(\"called `my_mod::nested::public_function_in_nested()`\"); } // Functions declared using `pub(super)` syntax are only visible within // the parent module pub(super) fn public_function_in_super_mod() { println!(\"called `my_mod::nested::public_function_in_super_mod()`\"); } } pub fn call_public_function_in_my_mod() { print!(\"called `my_mod::call_public_function_in_my_mod()`, that\\n> \"); nested::public_function_in_my_mod(); print!(\"> \"); nested::public_function_in_super_mod(); } // pub(crate) makes functions visible only within the current crate pub(crate) fn public_function_in_crate() { println!(\"called `my_mod::public_function_in_crate()`\"); } // Nested modules follow the same rules for visibility mod private_nested { #[allow(dead_code)] pub fn function() { println!(\"called `my_mod::private_nested::function()`\"); } // Private parent items will still restrict the visibility of a child item, // even if it is declared as visible within a bigger scope. #[allow(dead_code)] pub(crate) fn restricted_function() { println!(\"called `my_mod::private_nested::restricted_function()`\"); } }\n} fn function() { println!(\"called `function()`\");\n} fn main() { // Modules allow disambiguation between items that have the same name. function(); my_mod::function(); // Public items, including those inside nested modules, can be // accessed from outside the parent module. my_mod::indirect_access(); my_mod::nested::function(); my_mod::call_public_function_in_my_mod(); // pub(crate) items can be called from anywhere in the same crate my_mod::public_function_in_crate(); // pub(in path) items can only be called from within the module specified // Error! function `public_function_in_my_mod` is private //my_mod::nested::public_function_in_my_mod(); // TODO ^ Try uncommenting this line // Private items of a module cannot be directly accessed, even if // nested in a public module: // Error! `private_function` is private //my_mod::private_function(); // TODO ^ Try uncommenting this line // Error! `private_function` is private //my_mod::nested::private_function(); // TODO ^ Try uncommenting this line // Error! `private_nested` is a private module //my_mod::private_nested::function(); // TODO ^ Try uncommenting this line // Error! `private_nested` is a private module //my_mod::private_nested::restricted_function(); // TODO ^ Try uncommenting this line\n}","breadcrumbs":"Modules » Visibility » Visibility","id":"115","title":"Visibility"},"116":{"body":"Structs have an extra level of visibility with their fields. The visibility defaults to private, and can be overridden with the pub modifier. This visibility only matters when a struct is accessed from outside the module where it is defined, and has the goal of hiding information (encapsulation). mod my { // A public struct with a public field of generic type `T` pub struct OpenBox<T> { pub contents: T, } // A public struct with a private field of generic type `T` pub struct ClosedBox<T> { contents: T, } impl<T> ClosedBox<T> { // A public constructor method pub fn new(contents: T) -> ClosedBox<T> { ClosedBox { contents: contents, } } }\n} fn main() { // Public structs with public fields can be constructed as usual let open_box = my::OpenBox { contents: \"public information\" }; // and their fields can be normally accessed. println!(\"The open box contains: {}\", open_box.contents); // Public structs with private fields cannot be constructed using field names. // Error! `ClosedBox` has private fields //let closed_box = my::ClosedBox { contents: \"classified information\" }; // TODO ^ Try uncommenting this line // However, structs with private fields can be created using // public constructors let _closed_box = my::ClosedBox::new(\"classified information\"); // and the private fields of a public struct cannot be accessed. // Error! The `contents` field is private //println!(\"The closed box contains: {}\", _closed_box.contents); // TODO ^ Try uncommenting this line\n}","breadcrumbs":"Modules » Struct visibility » Struct visibility","id":"116","title":"Struct visibility"},"117":{"body":"generics and methods","breadcrumbs":"Modules » Struct visibility » See also:","id":"117","title":"See also:"},"118":{"body":"The use declaration can be used to bind a full path to a new name, for easier access. It is often used like this: use crate::deeply::nested::{ my_first_function, my_second_function, AndATraitType\n}; fn main() { my_first_function();\n} You can use the as keyword to bind imports to a different name: // Bind the `deeply::nested::function` path to `other_function`.\nuse deeply::nested::function as other_function; fn function() { println!(\"called `function()`\");\n} mod deeply { pub mod nested { pub fn function() { println!(\"called `deeply::nested::function()`\"); } }\n} fn main() { // Easier access to `deeply::nested::function` other_function(); println!(\"Entering block\"); { // This is equivalent to `use deeply::nested::function as function`. // This `function()` will shadow the outer one. use crate::deeply::nested::function; // `use` bindings have a local scope. In this case, the // shadowing of `function()` is only in this block. function(); println!(\"Leaving block\"); } function();\n}","breadcrumbs":"Modules » The use declaration » The use declaration","id":"118","title":"The use declaration"},"119":{"body":"The super and self keywords can be used in the path to remove ambiguity when accessing items and to prevent unnecessary hardcoding of paths. fn function() { println!(\"called `function()`\");\n} mod cool { pub fn function() { println!(\"called `cool::function()`\"); }\n} mod my { fn function() { println!(\"called `my::function()`\"); } mod cool { pub fn function() { println!(\"called `my::cool::function()`\"); } } pub fn indirect_call() { // Let's access all the functions named `function` from this scope! print!(\"called `my::indirect_call()`, that\\n> \"); // The `self` keyword refers to the current module scope - in this case `my`. // Calling `self::function()` and calling `function()` directly both give // the same result, because they refer to the same function. self::function(); function(); // We can also use `self` to access another module inside `my`: self::cool::function(); // The `super` keyword refers to the parent scope (outside the `my` module). super::function(); // This will bind to the `cool::function` in the *crate* scope. // In this case the crate scope is the outermost scope. { use crate::cool::function as root_function; root_function(); } }\n} fn main() { my::indirect_call();\n}","breadcrumbs":"Modules » super and self » super and self","id":"119","title":"super and self"},"12":{"body":"derive , std::fmt , macros , struct , trait , and use","breadcrumbs":"Hello World » Formatted print » Display » See also:","id":"12","title":"See also:"},"120":{"body":"Modules can be mapped to a file/directory hierarchy. Let's break down the visibility example in files: $ tree .\n.\n├── my\n│ ├── inaccessible.rs\n│ └── nested.rs\n├── my.rs\n└── split.rs In split.rs: // This declaration will look for a file named `my.rs` and will\n// insert its contents inside a module named `my` under this scope\nmod my; fn function() { println!(\"called `function()`\");\n} fn main() { my::function(); function(); my::indirect_access(); my::nested::function();\n} In my.rs: // Similarly `mod inaccessible` and `mod nested` will locate the `nested.rs`\n// and `inaccessible.rs` files and insert them here under their respective\n// modules\nmod inaccessible;\npub mod nested; pub fn function() { println!(\"called `my::function()`\");\n} fn private_function() { println!(\"called `my::private_function()`\");\n} pub fn indirect_access() { print!(\"called `my::indirect_access()`, that\\n> \"); private_function();\n} In my/nested.rs: pub fn function() { println!(\"called `my::nested::function()`\");\n} #[allow(dead_code)]\nfn private_function() { println!(\"called `my::nested::private_function()`\");\n} In my/inaccessible.rs: #[allow(dead_code)]\npub fn public_function() { println!(\"called `my::inaccessible::public_function()`\");\n} Let's check that things still work as before: $ rustc split.rs && ./split\ncalled `my::function()`\ncalled `function()`\ncalled `my::indirect_access()`, that\n> called `my::private_function()`\ncalled `my::nested::function()`","breadcrumbs":"Modules » File hierarchy » File hierarchy","id":"120","title":"File hierarchy"},"121":{"body":"A crate is a compilation unit in Rust. Whenever rustc some_file.rs is called, some_file.rs is treated as the crate file . If some_file.rs has mod declarations in it, then the contents of the module files would be inserted in places where mod declarations in the crate file are found, before running the compiler over it. In other words, modules do not get compiled individually, only crates get compiled. A crate can be compiled into a binary or into a library. By default, rustc will produce a binary from a crate. This behavior can be overridden by passing the --crate-type flag to lib.","breadcrumbs":"Crates » Crates","id":"121","title":"Crates"},"122":{"body":"Let's create a library, and then see how to link it to another crate. In rary.rs: pub fn public_function() { println!(\"called rary's `public_function()`\");\n} fn private_function() { println!(\"called rary's `private_function()`\");\n} pub fn indirect_access() { print!(\"called rary's `indirect_access()`, that\\n> \"); private_function();\n} $ rustc --crate-type=lib rary.rs\n$ ls lib*\nlibrary.rlib Libraries get prefixed with \"lib\", and by default they get named after their crate file, but this default name can be overridden by passing the --crate-name option to rustc or by using the crate_name attribute .","breadcrumbs":"Crates » Creating a Library » Creating a Library","id":"122","title":"Creating a Library"},"123":{"body":"To link a crate to this new library you may use rustc's --extern flag. All of its items will then be imported under a module named the same as the library. This module generally behaves the same way as any other module. // extern crate rary; // May be required for Rust 2015 edition or earlier fn main() { rary::public_function(); // Error! `private_function` is private //rary::private_function(); rary::indirect_access();\n} # Where library.rlib is the path to the compiled library, assumed that it's\n# in the same directory here:\n$ rustc executable.rs --extern rary=library.rlib && ./executable called rary's `public_function()`\ncalled rary's `indirect_access()`, that\n> called rary's `private_function()`","breadcrumbs":"Crates » Using a Library » Using a Library","id":"123","title":"Using a Library"},"124":{"body":"cargo is the official Rust package management tool. It has lots of really useful features to improve code quality and developer velocity! These include Dependency management and integration with crates.io (the official Rust package registry) Awareness of unit tests Awareness of benchmarks This chapter will go through some quick basics, but you can find the comprehensive docs in The Cargo Book .","breadcrumbs":"Cargo » Cargo","id":"124","title":"Cargo"},"125":{"body":"Most programs have dependencies on some libraries. If you have ever managed dependencies by hand, you know how much of a pain this can be. Luckily, the Rust ecosystem comes standard with cargo! cargo can manage dependencies for a project. To create a new Rust project, # A binary\ncargo new foo # A library\ncargo new --lib bar For the rest of this chapter, let's assume we are making a binary, rather than a library, but all of the concepts are the same. After the above commands, you should see a file hierarchy like this: .\n├── bar\n│ ├── Cargo.toml\n│ └── src\n│ └── lib.rs\n└── foo ├── Cargo.toml └── src └── main.rs The main.rs is the root source file for your new foo project -- nothing new there. The Cargo.toml is the config file for cargo for this project. If you look inside it, you should see something like this: [package]\nname = \"foo\"\nversion = \"0.1.0\"\nauthors = [\"mark\"] [dependencies] The name field under [package] determines the name of the project. This is used by crates.io if you publish the crate (more later). It is also the name of the output binary when you compile. The version field is a crate version number using Semantic Versioning . The authors field is a list of authors used when publishing the crate. The [dependencies] section lets you add dependencies for your project. For example, suppose that we want our program to have a great CLI. You can find lots of great packages on crates.io (the official Rust package registry). One popular choice is clap . As of this writing, the most recent published version of clap is 2.27.1. To add a dependency to our program, we can simply add the following to our Cargo.toml under [dependencies]: clap = \"2.27.1\". And that's it! You can start using clap in your program. cargo also supports other types of dependencies . Here is just a small sampling: [package]\nname = \"foo\"\nversion = \"0.1.0\"\nauthors = [\"mark\"] [dependencies]\nclap = \"2.27.1\" # from crates.io\nrand = { git = \"https://github.com/rust-lang-nursery/rand\" } # from online repo\nbar = { path = \"../bar\" } # from a path in the local filesystem cargo is more than a dependency manager. All of the available configuration options are listed in the format specification of Cargo.toml. To build our project we can execute cargo build anywhere in the project directory (including subdirectories!). We can also do cargo run to build and run. Notice that these commands will resolve all dependencies, download crates if needed, and build everything, including your crate. (Note that it only rebuilds what it has not already built, similar to make). Voila! That's all there is to it!","breadcrumbs":"Cargo » Dependencies » Dependencies","id":"125","title":"Dependencies"},"126":{"body":"In the previous chapter, we saw the following directory hierarchy: foo\n├── Cargo.toml\n└── src └── main.rs Suppose that we wanted to have two binaries in the same project, though. What then? It turns out that cargo supports this. The default binary name is main, as we saw before, but you can add additional binaries by placing them in a bin/ directory: foo\n├── Cargo.toml\n└── src ├── main.rs └── bin └── my_other_bin.rs To tell cargo to only compile or run this binary, we just pass cargo the --bin my_other_bin flag, where my_other_bin is the name of the binary we want to work with. In addition to extra binaries, cargo supports more features such as benchmarks, tests, and examples. In the next chapter, we will look more closely at tests.","breadcrumbs":"Cargo » Conventions » Conventions","id":"126","title":"Conventions"},"127":{"body":"As we know testing is integral to any piece of software! Rust has first-class support for unit and integration testing ( see this chapter in TRPL). From the testing chapters linked above, we see how to write unit tests and integration tests. Organizationally, we can place unit tests in the modules they test and integration tests in their own tests/ directory: foo\n├── Cargo.toml\n├── src\n│ └── main.rs\n│ └── lib.rs\n└── tests ├── my_test.rs └── my_other_test.rs Each file in tests is a separate integration test , i.e. a test that is meant to test your library as if it were being called from a dependent crate. The Testing chapter elaborates on the three different testing styles: Unit , Doc , and Integration . cargo naturally provides an easy way to run all of your tests! $ cargo test You should see output like this: $ cargo test Compiling blah v0.1.0 (file:///nobackup/blah) Finished dev [unoptimized + debuginfo] target(s) in 0.89 secs Running target/debug/deps/blah-d3b32b97275ec472 running 4 tests\ntest test_bar ... ok\ntest test_baz ... ok\ntest test_foo_bar ... ok\ntest test_foo ... ok test result: ok. 4 passed; 0 failed; 0 ignored; 0 measured; 0 filtered out You can also run tests whose name matches a pattern: $ cargo test test_foo $ cargo test test_foo Compiling blah v0.1.0 (file:///nobackup/blah) Finished dev [unoptimized + debuginfo] target(s) in 0.35 secs Running target/debug/deps/blah-d3b32b97275ec472 running 2 tests\ntest test_foo ... ok\ntest test_foo_bar ... ok test result: ok. 2 passed; 0 failed; 0 ignored; 0 measured; 2 filtered out One word of caution: Cargo may run multiple tests concurrently, so make sure that they don't race with each other. One example of this concurrency causing issues is if two tests output to a file, such as below: #[cfg(test)]\nmod tests { // Import the necessary modules use std::fs::OpenOptions; use std::io::Write; // This test writes to a file #[test] fn test_file() { // Opens the file ferris.txt or creates one if it doesn't exist. let mut file = OpenOptions::new() .append(true) .create(true) .open(\"ferris.txt\") .expect(\"Failed to open ferris.txt\"); // Print \"Ferris\" 5 times. for _ in 0..5 { file.write_all(\"Ferris\\n\".as_bytes()) .expect(\"Could not write to ferris.txt\"); } } // This test tries to write to the same file #[test] fn test_file_also() { // Opens the file ferris.txt or creates one if it doesn't exist. let mut file = OpenOptions::new() .append(true) .create(true) .open(\"ferris.txt\") .expect(\"Failed to open ferris.txt\"); // Print \"Corro\" 5 times. for _ in 0..5 { file.write_all(\"Corro\\n\".as_bytes()) .expect(\"Could not write to ferris.txt\"); } }\n} Although the intent is to get the following: $ cat ferris.txt\nFerris\nFerris\nFerris\nFerris\nFerris\nCorro\nCorro\nCorro\nCorro\nCorro What actually gets put into ferris.txt is this: $ cargo test test_file && cat ferris.txt\nCorro\nFerris\nCorro\nFerris\nCorro\nFerris\nCorro\nFerris\nCorro\nFerris","breadcrumbs":"Cargo » Tests » Testing","id":"127","title":"Testing"},"128":{"body":"Sometimes a normal build from cargo is not enough. Perhaps your crate needs some pre-requisites before cargo will successfully compile, things like code generation, or some native code that needs to be compiled. To solve this problem we have build scripts that Cargo can run. To add a build script to your package it can either be specified in the Cargo.toml as follows: [package]\n...\nbuild = \"build.rs\" Otherwise Cargo will look for a build.rs file in the project directory by default.","breadcrumbs":"Cargo » Build Scripts » Build Scripts","id":"128","title":"Build Scripts"},"129":{"body":"The build script is simply another Rust file that will be compiled and invoked prior to compiling anything else in the package. Hence it can be used to fulfill pre-requisites of your crate. Cargo provides the script with inputs via environment variables specified here that can be used. The script provides output via stdout. All lines printed are written to target/debug/build/<pkg>/output. Further, lines prefixed with cargo: will be interpreted by Cargo directly and hence can be used to define parameters for the package's compilation. For further specification and examples have a read of the Cargo specification .","breadcrumbs":"Cargo » Build Scripts » How to use a build script","id":"129","title":"How to use a build script"},"13":{"body":"Implementing fmt::Display for a structure where the elements must each be handled sequentially is tricky. The problem is that each write! generates a fmt::Result. Proper handling of this requires dealing with all the results. Rust provides the ? operator for exactly this purpose. Using ? on write! looks like this: // Try `write!` to see if it errors. If it errors, return\n// the error. Otherwise continue.\nwrite!(f, \"{}\", value)?; With ? available, implementing fmt::Display for a Vec is straightforward: use std::fmt; // Import the `fmt` module. // Define a structure named `List` containing a `Vec`.\nstruct List(Vec<i32>); impl fmt::Display for List { fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result { // Extract the value using tuple indexing, // and create a reference to `vec`. let vec = &self.0; write!(f, \"[\")?; // Iterate over `v` in `vec` while enumerating the iteration // count in `count`. for (count, v) in vec.iter().enumerate() { // For every element except the first, add a comma. // Use the ? operator to return on errors. if count != 0 { write!(f, \", \")?; } write!(f, \"{}\", v)?; } // Close the opened bracket and return a fmt::Result value. write!(f, \"]\") }\n} fn main() { let v = List(vec![1, 2, 3]); println!(\"{}\", v);\n}","breadcrumbs":"Hello World » Formatted print » Display » Testcase: List » Testcase: List","id":"13","title":"Testcase: List"},"130":{"body":"An attribute is metadata applied to some module, crate or item. This metadata can be used to/for: conditional compilation of code set crate name, version and type (binary or library) disable lints (warnings) enable compiler features (macros, glob imports, etc.) link to a foreign library mark functions as unit tests mark functions that will be part of a benchmark attribute like macros Attributes look like #[outer_attribute] or #![inner_attribute], with the difference between them being where they apply. #[outer_attribute] applies to the item immediately following it. Some examples of items are: a function, a module declaration, a constant, a structure, an enum. Here is an example where attribute #[derive(Debug)] applies to the struct Rectangle: #[derive(Debug)]\nstruct Rectangle { width: u32, height: u32,\n} #![inner_attribute] applies to the enclosing item (typically a module or a crate). In other words, this attribute is interpreted as applying to the entire scope in which it's place. Here is an example where #![allow(unusude_variables)] applies to the whole crate (if placed in main.rs): #![allow(unused_variables)] fn main() { let x = 3; // This would normally warn about an unused variable.\n} Attributes can take arguments with different syntaxes: #[attribute = \"value\"] #[attribute(key = \"value\")] #[attribute(value)] Attributes can have multiple values and can be separated over multiple lines, too: #[attribute(value, value2)] #[attribute(value, value2, value3, value4, value5)]","breadcrumbs":"Attributes » Attributes","id":"130","title":"Attributes"},"131":{"body":"The compiler provides a dead_code lint that will warn about unused functions. An attribute can be used to disable the lint. fn used_function() {} // `#[allow(dead_code)]` is an attribute that disables the `dead_code` lint\n#[allow(dead_code)]\nfn unused_function() {} fn noisy_unused_function() {}\n// FIXME ^ Add an attribute to suppress the warning fn main() { used_function();\n} Note that in real programs, you should eliminate dead code. In these examples we'll allow dead code in some places because of the interactive nature of the examples.","breadcrumbs":"Attributes » dead_code » dead_code","id":"131","title":"dead_code"},"132":{"body":"The crate_type attribute can be used to tell the compiler whether a crate is a binary or a library (and even which type of library), and the crate_name attribute can be used to set the name of the crate. However, it is important to note that both the crate_type and crate_name attributes have no effect whatsoever when using Cargo, the Rust package manager. Since Cargo is used for the majority of Rust projects, this means real-world uses of crate_type and crate_name are relatively limited. // This crate is a library\n#![crate_type = \"lib\"]\n// The library is named \"rary\"\n#![crate_name = \"rary\"] pub fn public_function() { println!(\"called rary's `public_function()`\");\n} fn private_function() { println!(\"called rary's `private_function()`\");\n} pub fn indirect_access() { print!(\"called rary's `indirect_access()`, that\\n> \"); private_function();\n} When the crate_type attribute is used, we no longer need to pass the --crate-type flag to rustc. $ rustc lib.rs\n$ ls lib*\nlibrary.rlib","breadcrumbs":"Attributes » Crates » Crates","id":"132","title":"Crates"},"133":{"body":"Configuration conditional checks are possible through two different operators: the cfg attribute: #[cfg(...)] in attribute position the cfg! macro: cfg!(...) in boolean expressions While the former enables conditional compilation, the latter conditionally evaluates to true or false literals allowing for checks at run-time. Both utilize identical argument syntax. cfg!, unlike #[cfg], does not remove any code and only evaluates to true or false. For example, all blocks in an if/else expression need to be valid when cfg! is used for the condition, regardless of what cfg! is evaluating. // This function only gets compiled if the target OS is linux\n#[cfg(target_os = \"linux\")]\nfn are_you_on_linux() { println!(\"You are running linux!\");\n} // And this function only gets compiled if the target OS is *not* linux\n#[cfg(not(target_os = \"linux\"))]\nfn are_you_on_linux() { println!(\"You are *not* running linux!\");\n} fn main() { are_you_on_linux(); println!(\"Are you sure?\"); if cfg!(target_os = \"linux\") { println!(\"Yes. It's definitely linux!\"); } else { println!(\"Yes. It's definitely *not* linux!\"); }\n}","breadcrumbs":"Attributes » cfg » cfg","id":"133","title":"cfg"},"134":{"body":"the reference , cfg! , and macros .","breadcrumbs":"Attributes » cfg » See also:","id":"134","title":"See also:"},"135":{"body":"Some conditionals like target_os are implicitly provided by rustc, but custom conditionals must be passed to rustc using the --cfg flag. #[cfg(some_condition)]\nfn conditional_function() { println!(\"condition met!\");\n} fn main() { conditional_function();\n} Try to run this to see what happens without the custom cfg flag. With the custom cfg flag: $ rustc --cfg some_condition custom.rs && ./custom\ncondition met!","breadcrumbs":"Attributes » cfg » Custom » Custom","id":"135","title":"Custom"},"136":{"body":"Generics is the topic of generalizing types and functionalities to broader cases. This is extremely useful for reducing code duplication in many ways, but can call for rather involved syntax. Namely, being generic requires taking great care to specify over which types a generic type is actually considered valid. The simplest and most common use of generics is for type parameters. A type parameter is specified as generic by the use of angle brackets and upper camel case : <Aaa, Bbb, ...>. \"Generic type parameters\" are typically represented as <T>. In Rust, \"generic\" also describes anything that accepts one or more generic type parameters <T>. Any type specified as a generic type parameter is generic, and everything else is concrete (non-generic). For example, defining a generic function named foo that takes an argument T of any type: fn foo<T>(arg: T) { ... } Because T has been specified as a generic type parameter using <T>, it is considered generic when used here as (arg: T). This is the case even if T has previously been defined as a struct. This example shows some of the syntax in action: // A concrete type `A`.\nstruct A; // In defining the type `Single`, the first use of `A` is not preceded by `<A>`.\n// Therefore, `Single` is a concrete type, and `A` is defined as above.\nstruct Single(A);\n// ^ Here is `Single`s first use of the type `A`. // Here, `<T>` precedes the first use of `T`, so `SingleGen` is a generic type.\n// Because the type parameter `T` is generic, it could be anything, including\n// the concrete type `A` defined at the top.\nstruct SingleGen<T>(T); fn main() { // `Single` is concrete and explicitly takes `A`. let _s = Single(A); // Create a variable `_char` of type `SingleGen<char>` // and give it the value `SingleGen('a')`. // Here, `SingleGen` has a type parameter explicitly specified. let _char: SingleGen<char> = SingleGen('a'); // `SingleGen` can also have a type parameter implicitly specified: let _t = SingleGen(A); // Uses `A` defined at the top. let _i32 = SingleGen(6); // Uses `i32`. let _char = SingleGen('a'); // Uses `char`.\n}","breadcrumbs":"Generics » Generics","id":"136","title":"Generics"},"137":{"body":"structs","breadcrumbs":"Generics » See also:","id":"137","title":"See also:"},"138":{"body":"The same set of rules can be applied to functions: a type T becomes generic when preceded by <T>. Using generic functions sometimes requires explicitly specifying type parameters. This may be the case if the function is called where the return type is generic, or if the compiler doesn't have enough information to infer the necessary type parameters. A function call with explicitly specified type parameters looks like: fun::<A, B, ...>(). struct A; // Concrete type `A`.\nstruct S(A); // Concrete type `S`.\nstruct SGen<T>(T); // Generic type `SGen`. // The following functions all take ownership of the variable passed into\n// them and immediately go out of scope, freeing the variable. // Define a function `reg_fn` that takes an argument `_s` of type `S`.\n// This has no `<T>` so this is not a generic function.\nfn reg_fn(_s: S) {} // Define a function `gen_spec_t` that takes an argument `_s` of type `SGen<T>`.\n// It has been explicitly given the type parameter `A`, but because `A` has not // been specified as a generic type parameter for `gen_spec_t`, it is not generic.\nfn gen_spec_t(_s: SGen<A>) {} // Define a function `gen_spec_i32` that takes an argument `_s` of type `SGen<i32>`.\n// It has been explicitly given the type parameter `i32`, which is a specific type.\n// Because `i32` is not a generic type, this function is also not generic.\nfn gen_spec_i32(_s: SGen<i32>) {} // Define a function `generic` that takes an argument `_s` of type `SGen<T>`.\n// Because `SGen<T>` is preceded by `<T>`, this function is generic over `T`.\nfn generic<T>(_s: SGen<T>) {} fn main() { // Using the non-generic functions reg_fn(S(A)); // Concrete type. gen_spec_t(SGen(A)); // Implicitly specified type parameter `A`. gen_spec_i32(SGen(6)); // Implicitly specified type parameter `i32`. // Explicitly specified type parameter `char` to `generic()`. generic::<char>(SGen('a')); // Implicitly specified type parameter `char` to `generic()`. generic(SGen('c'));\n}","breadcrumbs":"Generics » Functions » Functions","id":"138","title":"Functions"},"139":{"body":"functions and structs","breadcrumbs":"Generics » Functions » See also:","id":"139","title":"See also:"},"14":{"body":"Try changing the program so that the index of each element in the vector is also printed. The new output should look like this: [0: 1, 1: 2, 2: 3]","breadcrumbs":"Hello World » Formatted print » Display » Testcase: List » Activity","id":"14","title":"Activity"},"140":{"body":"Similar to functions, implementations require care to remain generic. struct S; // Concrete type `S`\nstruct GenericVal<T>(T); // Generic type `GenericVal` // impl of GenericVal where we explicitly specify type parameters:\nimpl GenericVal<f32> {} // Specify `f32`\nimpl GenericVal<S> {} // Specify `S` as defined above // `<T>` Must precede the type to remain generic\nimpl<T> GenericVal<T> {} struct Val { val: f64,\n} struct GenVal<T> { gen_val: T,\n} // impl of Val\nimpl Val { fn value(&self) -> &f64 { &self.val }\n} // impl of GenVal for a generic type `T`\nimpl<T> GenVal<T> { fn value(&self) -> &T { &self.gen_val }\n} fn main() { let x = Val { val: 3.0 }; let y = GenVal { gen_val: 3i32 }; println!(\"{}, {}\", x.value(), y.value());\n}","breadcrumbs":"Generics » Implementation » Implementation","id":"140","title":"Implementation"},"141":{"body":"functions returning references , impl , and struct","breadcrumbs":"Generics » Implementation » See also:","id":"141","title":"See also:"},"142":{"body":"Of course traits can also be generic. Here we define one which reimplements the Drop trait as a generic method to drop itself and an input. // Non-copyable types.\nstruct Empty;\nstruct Null; // A trait generic over `T`.\ntrait DoubleDrop<T> { // Define a method on the caller type which takes an // additional single parameter `T` and does nothing with it. fn double_drop(self, _: T);\n} // Implement `DoubleDrop<T>` for any generic parameter `T` and\n// caller `U`.\nimpl<T, U> DoubleDrop<T> for U { // This method takes ownership of both passed arguments, // deallocating both. fn double_drop(self, _: T) {}\n} fn main() { let empty = Empty; let null = Null; // Deallocate `empty` and `null`. empty.double_drop(null); //empty; //null; // ^ TODO: Try uncommenting these lines.\n}","breadcrumbs":"Generics » Traits » Traits","id":"142","title":"Traits"},"143":{"body":"Drop , struct , and trait","breadcrumbs":"Generics » Traits » See also:","id":"143","title":"See also:"},"144":{"body":"When working with generics, the type parameters often must use traits as bounds to stipulate what functionality a type implements. For example, the following example uses the trait Display to print and so it requires T to be bound by Display; that is, T must implement Display. // Define a function `printer` that takes a generic type `T` which\n// must implement trait `Display`.\nfn printer<T: Display>(t: T) { println!(\"{}\", t);\n} Bounding restricts the generic to types that conform to the bounds. That is: struct S<T: Display>(T); // Error! `Vec<T>` does not implement `Display`. This\n// specialization will fail.\nlet s = S(vec![1]); Another effect of bounding is that generic instances are allowed to access the methods of traits specified in the bounds. For example: // A trait which implements the print marker: `{:?}`.\nuse std::fmt::Debug; trait HasArea { fn area(&self) -> f64;\n} impl HasArea for Rectangle { fn area(&self) -> f64 { self.length * self.height }\n} #[derive(Debug)]\nstruct Rectangle { length: f64, height: f64 }\n#[allow(dead_code)]\nstruct Triangle { length: f64, height: f64 } // The generic `T` must implement `Debug`. Regardless\n// of the type, this will work properly.\nfn print_debug<T: Debug>(t: &T) { println!(\"{:?}\", t);\n} // `T` must implement `HasArea`. Any type which meets\n// the bound can access `HasArea`'s function `area`.\nfn area<T: HasArea>(t: &T) -> f64 { t.area() } fn main() { let rectangle = Rectangle { length: 3.0, height: 4.0 }; let _triangle = Triangle { length: 3.0, height: 4.0 }; print_debug(&rectangle); println!(\"Area: {}\", area(&rectangle)); //print_debug(&_triangle); //println!(\"Area: {}\", area(&_triangle)); // ^ TODO: Try uncommenting these. // | Error: Does not implement either `Debug` or `HasArea`. } As an additional note, where clauses can also be used to apply bounds in some cases to be more expressive.","breadcrumbs":"Generics » Bounds » Bounds","id":"144","title":"Bounds"},"145":{"body":"std::fmt , structs , and traits","breadcrumbs":"Generics » Bounds » See also:","id":"145","title":"See also:"},"146":{"body":"A consequence of how bounds work is that even if a trait doesn't include any functionality, you can still use it as a bound. Eq and Copy are examples of such traits from the std library. struct Cardinal;\nstruct BlueJay;\nstruct Turkey; trait Red {}\ntrait Blue {} impl Red for Cardinal {}\nimpl Blue for BlueJay {} // These functions are only valid for types which implement these\n// traits. The fact that the traits are empty is irrelevant.\nfn red<T: Red>(_: &T) -> &'static str { \"red\" }\nfn blue<T: Blue>(_: &T) -> &'static str { \"blue\" } fn main() { let cardinal = Cardinal; let blue_jay = BlueJay; let _turkey = Turkey; // `red()` won't work on a blue jay nor vice versa // because of the bounds. println!(\"A cardinal is {}\", red(&cardinal)); println!(\"A blue jay is {}\", blue(&blue_jay)); //println!(\"A turkey is {}\", red(&_turkey)); // ^ TODO: Try uncommenting this line.\n}","breadcrumbs":"Generics » Bounds » Testcase: empty bounds » Testcase: empty bounds","id":"146","title":"Testcase: empty bounds"},"147":{"body":"std::cmp::Eq , std::marker::Copy , and traits","breadcrumbs":"Generics » Bounds » Testcase: empty bounds » See also:","id":"147","title":"See also:"},"148":{"body":"Multiple bounds for a single type can be applied with a +. Like normal, different types are separated with ,. use std::fmt::{Debug, Display}; fn compare_prints<T: Debug + Display>(t: &T) { println!(\"Debug: `{:?}`\", t); println!(\"Display: `{}`\", t);\n} fn compare_types<T: Debug, U: Debug>(t: &T, u: &U) { println!(\"t: `{:?}`\", t); println!(\"u: `{:?}`\", u);\n} fn main() { let string = \"words\"; let array = [1, 2, 3]; let vec = vec![1, 2, 3]; compare_prints(&string); //compare_prints(&array); // TODO ^ Try uncommenting this. compare_types(&array, &vec);\n}","breadcrumbs":"Generics » Multiple bounds » Multiple bounds","id":"148","title":"Multiple bounds"},"149":{"body":"std::fmt and traits","breadcrumbs":"Generics » Multiple bounds » See also:","id":"149","title":"See also:"},"15":{"body":"for , ref , Result , struct , ? , and vec!","breadcrumbs":"Hello World » Formatted print » Display » Testcase: List » See also:","id":"15","title":"See also:"},"150":{"body":"A bound can also be expressed using a where clause immediately before the opening {, rather than at the type's first mention. Additionally, where clauses can apply bounds to arbitrary types, rather than just to type parameters. Some cases that a where clause is useful: When specifying generic types and bounds separately is clearer: impl <A: TraitB + TraitC, D: TraitE + TraitF> MyTrait<A, D> for YourType {} // Expressing bounds with a `where` clause\nimpl <A, D> MyTrait<A, D> for YourType where A: TraitB + TraitC, D: TraitE + TraitF {} When using a where clause is more expressive than using normal syntax. The impl in this example cannot be directly expressed without a where clause: use std::fmt::Debug; trait PrintInOption { fn print_in_option(self);\n} // Because we would otherwise have to express this as `T: Debug` or // use another method of indirect approach, this requires a `where` clause:\nimpl<T> PrintInOption for T where Option<T>: Debug { // We want `Option<T>: Debug` as our bound because that is what's // being printed. Doing otherwise would be using the wrong bound. fn print_in_option(self) { println!(\"{:?}\", Some(self)); }\n} fn main() { let vec = vec![1, 2, 3]; vec.print_in_option();\n}","breadcrumbs":"Generics » Where clauses » Where clauses","id":"150","title":"Where clauses"},"151":{"body":"RFC , struct , and trait","breadcrumbs":"Generics » Where clauses » See also:","id":"151","title":"See also:"},"152":{"body":"The newtype idiom gives compile time guarantees that the right type of value is supplied to a program. For example, an age verification function that checks age in years, must be given a value of type Years. struct Years(i64); struct Days(i64); impl Years { pub fn to_days(&self) -> Days { Days(self.0 * 365) }\n} impl Days { /// truncates partial years pub fn to_years(&self) -> Years { Years(self.0 / 365) }\n} fn old_enough(age: &Years) -> bool { age.0 >= 18\n} fn main() { let age = Years(5); let age_days = age.to_days(); println!(\"Old enough {}\", old_enough(&age)); println!(\"Old enough {}\", old_enough(&age_days.to_years())); // println!(\"Old enough {}\", old_enough(&age_days));\n} Uncomment the last print statement to observe that the type supplied must be Years. To obtain the newtype's value as the base type, you may use the tuple or destructuring syntax like so: struct Years(i64); fn main() { let years = Years(42); let years_as_primitive_1: i64 = years.0; // Tuple let Years(years_as_primitive_2) = years; // Destructuring\n}","breadcrumbs":"Generics » New Type Idiom » New Type Idiom","id":"152","title":"New Type Idiom"},"153":{"body":"structs","breadcrumbs":"Generics » New Type Idiom » See also:","id":"153","title":"See also:"},"154":{"body":"\"Associated Items\" refers to a set of rules pertaining to item s of various types. It is an extension to trait generics, and allows traits to internally define new items. One such item is called an associated type , providing simpler usage patterns when the trait is generic over its container type.","breadcrumbs":"Generics » Associated items » Associated items","id":"154","title":"Associated items"},"155":{"body":"RFC","breadcrumbs":"Generics » Associated items » See also:","id":"155","title":"See also:"},"156":{"body":"A trait that is generic over its container type has type specification requirements - users of the trait must specify all of its generic types. In the example below, the Contains trait allows the use of the generic types A and B. The trait is then implemented for the Container type, specifying i32 for A and B so that it can be used with fn difference(). Because Contains is generic, we are forced to explicitly state all of the generic types for fn difference(). In practice, we want a way to express that A and B are determined by the input C. As you will see in the next section, associated types provide exactly that capability. struct Container(i32, i32); // A trait which checks if 2 items are stored inside of container.\n// Also retrieves first or last value.\ntrait Contains<A, B> { fn contains(&self, _: &A, _: &B) -> bool; // Explicitly requires `A` and `B`. fn first(&self) -> i32; // Doesn't explicitly require `A` or `B`. fn last(&self) -> i32; // Doesn't explicitly require `A` or `B`.\n} impl Contains<i32, i32> for Container { // True if the numbers stored are equal. fn contains(&self, number_1: &i32, number_2: &i32) -> bool { (&self.0 == number_1) && (&self.1 == number_2) } // Grab the first number. fn first(&self) -> i32 { self.0 } // Grab the last number. fn last(&self) -> i32 { self.1 }\n} // `C` contains `A` and `B`. In light of that, having to express `A` and\n// `B` again is a nuisance.\nfn difference<A, B, C>(container: &C) -> i32 where C: Contains<A, B> { container.last() - container.first()\n} fn main() { let number_1 = 3; let number_2 = 10; let container = Container(number_1, number_2); println!(\"Does container contain {} and {}: {}\", &number_1, &number_2, container.contains(&number_1, &number_2)); println!(\"First number: {}\", container.first()); println!(\"Last number: {}\", container.last()); println!(\"The difference is: {}\", difference(&container));\n}","breadcrumbs":"Generics » Associated items » The Problem » The Problem","id":"156","title":"The Problem"},"157":{"body":"structs , and traits","breadcrumbs":"Generics » Associated items » The Problem » See also:","id":"157","title":"See also:"},"158":{"body":"The use of \"Associated types\" improves the overall readability of code by moving inner types locally into a trait as output types. Syntax for the trait definition is as follows: // `A` and `B` are defined in the trait via the `type` keyword.\n// (Note: `type` in this context is different from `type` when used for\n// aliases).\ntrait Contains { type A; type B; // Updated syntax to refer to these new types generically. fn contains(&self, _: &Self::A, _: &Self::B) -> bool;\n} Note that functions that use the trait Contains are no longer required to express A or B at all: // Without using associated types\nfn difference<A, B, C>(container: &C) -> i32 where C: Contains<A, B> { ... } // Using associated types\nfn difference<C: Contains>(container: &C) -> i32 { ... } Let's rewrite the example from the previous section using associated types: struct Container(i32, i32); // A trait which checks if 2 items are stored inside of container.\n// Also retrieves first or last value.\ntrait Contains { // Define generic types here which methods will be able to utilize. type A; type B; fn contains(&self, _: &Self::A, _: &Self::B) -> bool; fn first(&self) -> i32; fn last(&self) -> i32;\n} impl Contains for Container { // Specify what types `A` and `B` are. If the `input` type // is `Container(i32, i32)`, the `output` types are determined // as `i32` and `i32`. type A = i32; type B = i32; // `&Self::A` and `&Self::B` are also valid here. fn contains(&self, number_1: &i32, number_2: &i32) -> bool { (&self.0 == number_1) && (&self.1 == number_2) } // Grab the first number. fn first(&self) -> i32 { self.0 } // Grab the last number. fn last(&self) -> i32 { self.1 }\n} fn difference<C: Contains>(container: &C) -> i32 { container.last() - container.first()\n} fn main() { let number_1 = 3; let number_2 = 10; let container = Container(number_1, number_2); println!(\"Does container contain {} and {}: {}\", &number_1, &number_2, container.contains(&number_1, &number_2)); println!(\"First number: {}\", container.first()); println!(\"Last number: {}\", container.last()); println!(\"The difference is: {}\", difference(&container));\n}","breadcrumbs":"Generics » Associated items » Associated types » Associated types","id":"158","title":"Associated types"},"159":{"body":"A phantom type parameter is one that doesn't show up at runtime, but is checked statically (and only) at compile time. Data types can use extra generic type parameters to act as markers or to perform type checking at compile time. These extra parameters hold no storage values, and have no runtime behavior. In the following example, we combine std::marker::PhantomData with the phantom type parameter concept to create tuples containing different data types. use std::marker::PhantomData; // A phantom tuple struct which is generic over `A` with hidden parameter `B`.\n#[derive(PartialEq)] // Allow equality test for this type.\nstruct PhantomTuple<A, B>(A, PhantomData<B>); // A phantom type struct which is generic over `A` with hidden parameter `B`.\n#[derive(PartialEq)] // Allow equality test for this type.\nstruct PhantomStruct<A, B> { first: A, phantom: PhantomData<B> } // Note: Storage is allocated for generic type `A`, but not for `B`.\n// Therefore, `B` cannot be used in computations. fn main() { // Here, `f32` and `f64` are the hidden parameters. // PhantomTuple type specified as `<char, f32>`. let _tuple1: PhantomTuple<char, f32> = PhantomTuple('Q', PhantomData); // PhantomTuple type specified as `<char, f64>`. let _tuple2: PhantomTuple<char, f64> = PhantomTuple('Q', PhantomData); // Type specified as `<char, f32>`. let _struct1: PhantomStruct<char, f32> = PhantomStruct { first: 'Q', phantom: PhantomData, }; // Type specified as `<char, f64>`. let _struct2: PhantomStruct<char, f64> = PhantomStruct { first: 'Q', phantom: PhantomData, }; // Compile-time Error! Type mismatch so these cannot be compared: // println!(\"_tuple1 == _tuple2 yields: {}\", // _tuple1 == _tuple2); // Compile-time Error! Type mismatch so these cannot be compared: // println!(\"_struct1 == _struct2 yields: {}\", // _struct1 == _struct2);\n}","breadcrumbs":"Generics » Phantom type parameters » Phantom type parameters","id":"159","title":"Phantom type parameters"},"16":{"body":"We've seen that formatting is specified via a format string : format!(\"{}\", foo) -> \"3735928559\" format!(\"0x{:X}\", foo) -> \"0xDEADBEEF\" format!(\"0o{:o}\", foo) -> \"0o33653337357\" The same variable (foo) can be formatted differently depending on which argument type is used: X vs o vs unspecified . This formatting functionality is implemented via traits, and there is one trait for each argument type. The most common formatting trait is Display, which handles cases where the argument type is left unspecified: {} for instance. use std::fmt::{self, Formatter, Display}; struct City { name: &'static str, // Latitude lat: f32, // Longitude lon: f32,\n} impl Display for City { // `f` is a buffer, and this method must write the formatted string into it. fn fmt(&self, f: &mut Formatter) -> fmt::Result { let lat_c = if self.lat >= 0.0 { 'N' } else { 'S' }; let lon_c = if self.lon >= 0.0 { 'E' } else { 'W' }; // `write!` is like `format!`, but it will write the formatted string // into a buffer (the first argument). write!(f, \"{}: {:.3}°{} {:.3}°{}\", self.name, self.lat.abs(), lat_c, self.lon.abs(), lon_c) }\n} #[derive(Debug)]\nstruct Color { red: u8, green: u8, blue: u8,\n} fn main() { for city in [ City { name: \"Dublin\", lat: 53.347778, lon: -6.259722 }, City { name: \"Oslo\", lat: 59.95, lon: 10.75 }, City { name: \"Vancouver\", lat: 49.25, lon: -123.1 }, ] { println!(\"{}\", city); } for color in [ Color { red: 128, green: 255, blue: 90 }, Color { red: 0, green: 3, blue: 254 }, Color { red: 0, green: 0, blue: 0 }, ] { // Switch this to use {} once you've added an implementation // for fmt::Display. println!(\"{:?}\", color); }\n} You can view a full list of formatting traits and their argument types in the std::fmt documentation.","breadcrumbs":"Hello World » Formatted print » Formatting » Formatting","id":"16","title":"Formatting"},"160":{"body":"Derive , struct , and TupleStructs","breadcrumbs":"Generics » Phantom type parameters » See also:","id":"160","title":"See also:"},"161":{"body":"A useful method of unit conversions can be examined by implementing Add with a phantom type parameter. The Add trait is examined below: // This construction would impose: `Self + RHS = Output`\n// where RHS defaults to Self if not specified in the implementation.\npub trait Add<RHS = Self> { type Output; fn add(self, rhs: RHS) -> Self::Output;\n} // `Output` must be `T<U>` so that `T<U> + T<U> = T<U>`.\nimpl<U> Add for T<U> { type Output = T<U>; ...\n} The whole implementation: use std::ops::Add;\nuse std::marker::PhantomData; /// Create void enumerations to define unit types.\n#[derive(Debug, Clone, Copy)]\nenum Inch {}\n#[derive(Debug, Clone, Copy)]\nenum Mm {} /// `Length` is a type with phantom type parameter `Unit`,\n/// and is not generic over the length type (that is `f64`).\n///\n/// `f64` already implements the `Clone` and `Copy` traits.\n#[derive(Debug, Clone, Copy)]\nstruct Length<Unit>(f64, PhantomData<Unit>); /// The `Add` trait defines the behavior of the `+` operator.\nimpl<Unit> Add for Length<Unit> { type Output = Length<Unit>; // add() returns a new `Length` struct containing the sum. fn add(self, rhs: Length<Unit>) -> Length<Unit> { // `+` calls the `Add` implementation for `f64`. Length(self.0 + rhs.0, PhantomData) }\n} fn main() { // Specifies `one_foot` to have phantom type parameter `Inch`. let one_foot: Length<Inch> = Length(12.0, PhantomData); // `one_meter` has phantom type parameter `Mm`. let one_meter: Length<Mm> = Length(1000.0, PhantomData); // `+` calls the `add()` method we implemented for `Length<Unit>`. // // Since `Length` implements `Copy`, `add()` does not consume // `one_foot` and `one_meter` but copies them into `self` and `rhs`. let two_feet = one_foot + one_foot; let two_meters = one_meter + one_meter; // Addition works. println!(\"one foot + one_foot = {:?} in\", two_feet.0); println!(\"one meter + one_meter = {:?} mm\", two_meters.0); // Nonsensical operations fail as they should: // Compile-time Error: type mismatch. //let one_feter = one_foot + one_meter;\n}","breadcrumbs":"Generics » Phantom type parameters » Testcase: unit clarification » Testcase: unit clarification","id":"161","title":"Testcase: unit clarification"},"162":{"body":"Borrowing (&) , Bounds (X: Y) , enum , impl & self , Overloading , ref , Traits (X for Y) , and TupleStructs .","breadcrumbs":"Generics » Phantom type parameters » Testcase: unit clarification » See also:","id":"162","title":"See also:"},"163":{"body":"Scopes play an important part in ownership, borrowing, and lifetimes. That is, they indicate to the compiler when borrows are valid, when resources can be freed, and when variables are created or destroyed.","breadcrumbs":"Scoping rules » Scoping rules","id":"163","title":"Scoping rules"},"164":{"body":"Variables in Rust do more than just hold data in the stack: they also own resources, e.g. Box<T> owns memory in the heap. Rust enforces RAII (Resource Acquisition Is Initialization), so whenever an object goes out of scope, its destructor is called and its owned resources are freed. This behavior shields against resource leak bugs, so you'll never have to manually free memory or worry about memory leaks again! Here's a quick showcase: // raii.rs\nfn create_box() { // Allocate an integer on the heap let _box1 = Box::new(3i32); // `_box1` is destroyed here, and memory gets freed\n} fn main() { // Allocate an integer on the heap let _box2 = Box::new(5i32); // A nested scope: { // Allocate an integer on the heap let _box3 = Box::new(4i32); // `_box3` is destroyed here, and memory gets freed } // Creating lots of boxes just for fun // There's no need to manually free memory! for _ in 0u32..1_000 { create_box(); } // `_box2` is destroyed here, and memory gets freed\n} Of course, we can double check for memory errors using valgrind : $ rustc raii.rs && valgrind ./raii\n==26873== Memcheck, a memory error detector\n==26873== Copyright (C) 2002-2013, and GNU GPL'd, by Julian Seward et al.\n==26873== Using Valgrind-3.9.0 and LibVEX; rerun with -h for copyright info\n==26873== Command: ./raii\n==26873==\n==26873==\n==26873== HEAP SUMMARY:\n==26873== in use at exit: 0 bytes in 0 blocks\n==26873== total heap usage: 1,013 allocs, 1,013 frees, 8,696 bytes allocated\n==26873==\n==26873== All heap blocks were freed -- no leaks are possible\n==26873==\n==26873== For counts of detected and suppressed errors, rerun with: -v\n==26873== ERROR SUMMARY: 0 errors from 0 contexts (suppressed: 2 from 2) No leaks here!","breadcrumbs":"Scoping rules » RAII » RAII","id":"164","title":"RAII"},"165":{"body":"The notion of a destructor in Rust is provided through the Drop trait. The destructor is called when the resource goes out of scope. This trait is not required to be implemented for every type, only implement it for your type if you require its own destructor logic. Run the below example to see how the Drop trait works. When the variable in the main function goes out of scope the custom destructor will be invoked. struct ToDrop; impl Drop for ToDrop { fn drop(&mut self) { println!(\"ToDrop is being dropped\"); }\n} fn main() { let x = ToDrop; println!(\"Made a ToDrop!\");\n}","breadcrumbs":"Scoping rules » RAII » Destructor","id":"165","title":"Destructor"},"166":{"body":"Box","breadcrumbs":"Scoping rules » RAII » See also:","id":"166","title":"See also:"},"167":{"body":"Because variables are in charge of freeing their own resources, resources can only have one owner . This prevents resources from being freed more than once. Note that not all variables own resources (e.g. references ). When doing assignments (let x = y) or passing function arguments by value (foo(x)), the ownership of the resources is transferred. In Rust-speak, this is known as a move . After moving resources, the previous owner can no longer be used. This avoids creating dangling pointers. // This function takes ownership of the heap allocated memory\nfn destroy_box(c: Box<i32>) { println!(\"Destroying a box that contains {}\", c); // `c` is destroyed and the memory freed\n} fn main() { // _Stack_ allocated integer let x = 5u32; // *Copy* `x` into `y` - no resources are moved let y = x; // Both values can be independently used println!(\"x is {}, and y is {}\", x, y); // `a` is a pointer to a _heap_ allocated integer let a = Box::new(5i32); println!(\"a contains: {}\", a); // *Move* `a` into `b` let b = a; // The pointer address of `a` is copied (not the data) into `b`. // Both are now pointers to the same heap allocated data, but // `b` now owns it. // Error! `a` can no longer access the data, because it no longer owns the // heap memory //println!(\"a contains: {}\", a); // TODO ^ Try uncommenting this line // This function takes ownership of the heap allocated memory from `b` destroy_box(b); // Since the heap memory has been freed at this point, this action would // result in dereferencing freed memory, but it's forbidden by the compiler // Error! Same reason as the previous Error //println!(\"b contains: {}\", b); // TODO ^ Try uncommenting this line\n}","breadcrumbs":"Scoping rules » Ownership and moves » Ownership and moves","id":"167","title":"Ownership and moves"},"168":{"body":"Mutability of data can be changed when ownership is transferred. fn main() { let immutable_box = Box::new(5u32); println!(\"immutable_box contains {}\", immutable_box); // Mutability error //*immutable_box = 4; // *Move* the box, changing the ownership (and mutability) let mut mutable_box = immutable_box; println!(\"mutable_box contains {}\", mutable_box); // Modify the contents of the box *mutable_box = 4; println!(\"mutable_box now contains {}\", mutable_box);\n}","breadcrumbs":"Scoping rules » Ownership and moves » Mutability » Mutability","id":"168","title":"Mutability"},"169":{"body":"Within the destructuring of a single variable, both by-move and by-reference pattern bindings can be used at the same time. Doing this will result in a partial move of the variable, which means that parts of the variable will be moved while other parts stay. In such a case, the parent variable cannot be used afterwards as a whole, however the parts that are only referenced (and not moved) can still be used. fn main() { #[derive(Debug)] struct Person { name: String, age: Box<u8>, } let person = Person { name: String::from(\"Alice\"), age: Box::new(20), }; // `name` is moved out of person, but `age` is referenced let Person { name, ref age } = person; println!(\"The person's age is {}\", age); println!(\"The person's name is {}\", name); // Error! borrow of partially moved value: `person` partial move occurs //println!(\"The person struct is {:?}\", person); // `person` cannot be used but `person.age` can be used as it is not moved println!(\"The person's age from person struct is {}\", person.age);\n} (In this example, we store the age variable on the heap to illustrate the partial move: deleting ref in the above code would give an error as the ownership of person.age would be moved to the variable age. If Person.age were stored on the stack, ref would not be required as the definition of age would copy the data from person.age without moving it.)","breadcrumbs":"Scoping rules » Ownership and moves » Partial moves » Partial moves","id":"169","title":"Partial moves"},"17":{"body":"Add an implementation of the fmt::Display trait for the Color struct above so that the output displays as: RGB (128, 255, 90) 0x80FF5A\nRGB (0, 3, 254) 0x0003FE\nRGB (0, 0, 0) 0x000000 Three hints if you get stuck: The formula for calculating a color in the RGB color space is: RGB = (R*65536)+(G*256)+B , (when R is RED, G is GREEN and B is BLUE). For more see RGB color format & calculation . You may need to list each color more than once . You can pad with zeros to a width of 2 with :0>2.","breadcrumbs":"Hello World » Formatted print » Formatting » Activity","id":"17","title":"Activity"},"170":{"body":"destructuring","breadcrumbs":"Scoping rules » Ownership and moves » Partial moves » See also:","id":"170","title":"See also:"},"171":{"body":"Most of the time, we'd like to access data without taking ownership over it. To accomplish this, Rust uses a borrowing mechanism. Instead of passing objects by value (T), objects can be passed by reference (&T). The compiler statically guarantees (via its borrow checker) that references always point to valid objects. That is, while references to an object exist, the object cannot be destroyed. // This function takes ownership of a box and destroys it\nfn eat_box_i32(boxed_i32: Box<i32>) { println!(\"Destroying box that contains {}\", boxed_i32);\n} // This function borrows an i32\nfn borrow_i32(borrowed_i32: &i32) { println!(\"This int is: {}\", borrowed_i32);\n} fn main() { // Create a boxed i32 in the heap, and a i32 on the stack // Remember: numbers can have arbitrary underscores added for readability // 5_i32 is the same as 5i32 let boxed_i32 = Box::new(5_i32); let stacked_i32 = 6_i32; // Borrow the contents of the box. Ownership is not taken, // so the contents can be borrowed again. borrow_i32(&boxed_i32); borrow_i32(&stacked_i32); { // Take a reference to the data contained inside the box let _ref_to_i32: &i32 = &boxed_i32; // Error! // Can't destroy `boxed_i32` while the inner value is borrowed later in scope. eat_box_i32(boxed_i32); // FIXME ^ Comment out this line // Attempt to borrow `_ref_to_i32` after inner value is destroyed borrow_i32(_ref_to_i32); // `_ref_to_i32` goes out of scope and is no longer borrowed. } // `boxed_i32` can now give up ownership to `eat_box` and be destroyed eat_box_i32(boxed_i32);\n}","breadcrumbs":"Scoping rules » Borrowing » Borrowing","id":"171","title":"Borrowing"},"172":{"body":"Mutable data can be mutably borrowed using &mut T. This is called a mutable reference and gives read/write access to the borrower. In contrast, &T borrows the data via an immutable reference, and the borrower can read the data but not modify it: #[allow(dead_code)]\n#[derive(Clone, Copy)]\nstruct Book { // `&'static str` is a reference to a string allocated in read only memory author: &'static str, title: &'static str, year: u32,\n} // This function takes a reference to a book\nfn borrow_book(book: &Book) { println!(\"I immutably borrowed {} - {} edition\", book.title, book.year);\n} // This function takes a reference to a mutable book and changes `year` to 2014\nfn new_edition(book: &mut Book) { book.year = 2014; println!(\"I mutably borrowed {} - {} edition\", book.title, book.year);\n} fn main() { // Create an immutable Book named `immutabook` let immutabook = Book { // string literals have type `&'static str` author: \"Douglas Hofstadter\", title: \"Gödel, Escher, Bach\", year: 1979, }; // Create a mutable copy of `immutabook` and call it `mutabook` let mut mutabook = immutabook; // Immutably borrow an immutable object borrow_book(&immutabook); // Immutably borrow a mutable object borrow_book(&mutabook); // Borrow a mutable object as mutable new_edition(&mut mutabook); // Error! Cannot borrow an immutable object as mutable new_edition(&mut immutabook); // FIXME ^ Comment out this line\n}","breadcrumbs":"Scoping rules » Borrowing » Mutability » Mutability","id":"172","title":"Mutability"},"173":{"body":"static","breadcrumbs":"Scoping rules » Borrowing » Mutability » See also:","id":"173","title":"See also:"},"174":{"body":"Data can be immutably borrowed any number of times, but while immutably borrowed, the original data can't be mutably borrowed. On the other hand, only one mutable borrow is allowed at a time. The original data can be borrowed again only after the mutable reference has been used for the last time. struct Point { x: i32, y: i32, z: i32 } fn main() { let mut point = Point { x: 0, y: 0, z: 0 }; let borrowed_point = &point; let another_borrow = &point; // Data can be accessed via the references and the original owner println!(\"Point has coordinates: ({}, {}, {})\", borrowed_point.x, another_borrow.y, point.z); // Error! Can't borrow `point` as mutable because it's currently // borrowed as immutable. // let mutable_borrow = &mut point; // TODO ^ Try uncommenting this line // The borrowed values are used again here println!(\"Point has coordinates: ({}, {}, {})\", borrowed_point.x, another_borrow.y, point.z); // The immutable references are no longer used for the rest of the code so // it is possible to reborrow with a mutable reference. let mutable_borrow = &mut point; // Change data via mutable reference mutable_borrow.x = 5; mutable_borrow.y = 2; mutable_borrow.z = 1; // Error! Can't borrow `point` as immutable because it's currently // borrowed as mutable. // let y = &point.y; // TODO ^ Try uncommenting this line // Error! Can't print because `println!` takes an immutable reference. // println!(\"Point Z coordinate is {}\", point.z); // TODO ^ Try uncommenting this line // Ok! Mutable references can be passed as immutable to `println!` println!(\"Point has coordinates: ({}, {}, {})\", mutable_borrow.x, mutable_borrow.y, mutable_borrow.z); // The mutable reference is no longer used for the rest of the code so it // is possible to reborrow let new_borrowed_point = &point; println!(\"Point now has coordinates: ({}, {}, {})\", new_borrowed_point.x, new_borrowed_point.y, new_borrowed_point.z);\n}","breadcrumbs":"Scoping rules » Borrowing » Aliasing » Aliasing","id":"174","title":"Aliasing"},"175":{"body":"When doing pattern matching or destructuring via the let binding, the ref keyword can be used to take references to the fields of a struct/tuple. The example below shows a few instances where this can be useful: #[derive(Clone, Copy)]\nstruct Point { x: i32, y: i32 } fn main() { let c = 'Q'; // A `ref` borrow on the left side of an assignment is equivalent to // an `&` borrow on the right side. let ref ref_c1 = c; let ref_c2 = &c; println!(\"ref_c1 equals ref_c2: {}\", *ref_c1 == *ref_c2); let point = Point { x: 0, y: 0 }; // `ref` is also valid when destructuring a struct. let _copy_of_x = { // `ref_to_x` is a reference to the `x` field of `point`. let Point { x: ref ref_to_x, y: _ } = point; // Return a copy of the `x` field of `point`. *ref_to_x }; // A mutable copy of `point` let mut mutable_point = point; { // `ref` can be paired with `mut` to take mutable references. let Point { x: _, y: ref mut mut_ref_to_y } = mutable_point; // Mutate the `y` field of `mutable_point` via a mutable reference. *mut_ref_to_y = 1; } println!(\"point is ({}, {})\", point.x, point.y); println!(\"mutable_point is ({}, {})\", mutable_point.x, mutable_point.y); // A mutable tuple that includes a pointer let mut mutable_tuple = (Box::new(5u32), 3u32); { // Destructure `mutable_tuple` to change the value of `last`. let (_, ref mut last) = mutable_tuple; *last = 2u32; } println!(\"tuple is {:?}\", mutable_tuple);\n}","breadcrumbs":"Scoping rules » Borrowing » The ref pattern » The ref pattern","id":"175","title":"The ref pattern"},"176":{"body":"A lifetime is a construct the compiler (or more specifically, its borrow checker ) uses to ensure all borrows are valid. Specifically, a variable's lifetime begins when it is created and ends when it is destroyed. While lifetimes and scopes are often referred to together, they are not the same. Take, for example, the case where we borrow a variable via &. The borrow has a lifetime that is determined by where it is declared. As a result, the borrow is valid as long as it ends before the lender is destroyed. However, the scope of the borrow is determined by where the reference is used. In the following example and in the rest of this section, we will see how lifetimes relate to scopes, as well as how the two differ. // Lifetimes are annotated below with lines denoting the creation\n// and destruction of each variable.\n// `i` has the longest lifetime because its scope entirely encloses // both `borrow1` and `borrow2`. The duration of `borrow1` compared // to `borrow2` is irrelevant since they are disjoint.\nfn main() { let i = 3; // Lifetime for `i` starts. ────────────────┐ // │ { // │ let borrow1 = &i; // `borrow1` lifetime starts. ──┐│ // ││ println!(\"borrow1: {}\", borrow1); // ││ } // `borrow1` ends. ─────────────────────────────────┘│ // │ // │ { // │ let borrow2 = &i; // `borrow2` lifetime starts. ──┐│ // ││ println!(\"borrow2: {}\", borrow2); // ││ } // `borrow2` ends. ─────────────────────────────────┘│ // │\n} // Lifetime ends. ─────────────────────────────────────┘ Note that no names or types are assigned to label lifetimes. This restricts how lifetimes will be able to be used as we will see.","breadcrumbs":"Scoping rules » Lifetimes » Lifetimes","id":"176","title":"Lifetimes"},"177":{"body":"The borrow checker uses explicit lifetime annotations to determine how long references should be valid. In cases where lifetimes are not elided [1] , Rust requires explicit annotations to determine what the lifetime of a reference should be. The syntax for explicitly annotating a lifetime uses an apostrophe character as follows: foo<'a>\n// `foo` has a lifetime parameter `'a` Similar to closures , using lifetimes requires generics. Additionally, this lifetime syntax indicates that the lifetime of foo may not exceed that of 'a. Explicit annotation of a type has the form &'a T where 'a has already been introduced. In cases with multiple lifetimes, the syntax is similar: foo<'a, 'b>\n// `foo` has lifetime parameters `'a` and `'b` In this case, the lifetime of foo cannot exceed that of either 'a or 'b. See the following example for explicit lifetime annotation in use: // `print_refs` takes two references to `i32` which have different\n// lifetimes `'a` and `'b`. These two lifetimes must both be at\n// least as long as the function `print_refs`.\nfn print_refs<'a, 'b>(x: &'a i32, y: &'b i32) { println!(\"x is {} and y is {}\", x, y);\n} // A function which takes no arguments, but has a lifetime parameter `'a`.\nfn failed_borrow<'a>() { let _x = 12; // ERROR: `_x` does not live long enough let _y: &'a i32 = &_x; // Attempting to use the lifetime `'a` as an explicit type annotation // inside the function will fail because the lifetime of `&_x` is shorter // than that of `_y`. A short lifetime cannot be coerced into a longer one.\n} fn main() { // Create variables to be borrowed below. let (four, nine) = (4, 9); // Borrows (`&`) of both variables are passed into the function. print_refs(&four, &nine); // Any input which is borrowed must outlive the borrower. // In other words, the lifetime of `four` and `nine` must // be longer than that of `print_refs`. failed_borrow(); // `failed_borrow` contains no references to force `'a` to be // longer than the lifetime of the function, but `'a` is longer. // Because the lifetime is never constrained, it defaults to `'static`.\n} elision implicitly annotates lifetimes and so is different.","breadcrumbs":"Scoping rules » Lifetimes » Explicit annotation » Explicit annotation","id":"177","title":"Explicit annotation"},"178":{"body":"generics and closures","breadcrumbs":"Scoping rules » Lifetimes » Explicit annotation » See also:","id":"178","title":"See also:"},"179":{"body":"Ignoring elision , function signatures with lifetimes have a few constraints: any reference must have an annotated lifetime. any reference being returned must have the same lifetime as an input or be static. Additionally, note that returning references without input is banned if it would result in returning references to invalid data. The following example shows off some valid forms of functions with lifetimes: // One input reference with lifetime `'a` which must live\n// at least as long as the function.\nfn print_one<'a>(x: &'a i32) { println!(\"`print_one`: x is {}\", x);\n} // Mutable references are possible with lifetimes as well.\nfn add_one<'a>(x: &'a mut i32) { *x += 1;\n} // Multiple elements with different lifetimes. In this case, it\n// would be fine for both to have the same lifetime `'a`, but\n// in more complex cases, different lifetimes may be required.\nfn print_multi<'a, 'b>(x: &'a i32, y: &'b i32) { println!(\"`print_multi`: x is {}, y is {}\", x, y);\n} // Returning references that have been passed in is acceptable.\n// However, the correct lifetime must be returned.\nfn pass_x<'a, 'b>(x: &'a i32, _: &'b i32) -> &'a i32 { x } //fn invalid_output<'a>() -> &'a String { &String::from(\"foo\") }\n// The above is invalid: `'a` must live longer than the function.\n// Here, `&String::from(\"foo\")` would create a `String`, followed by a\n// reference. Then the data is dropped upon exiting the scope, leaving\n// a reference to invalid data to be returned. fn main() { let x = 7; let y = 9; print_one(&x); print_multi(&x, &y); let z = pass_x(&x, &y); print_one(z); let mut t = 3; add_one(&mut t); print_one(&t);\n}","breadcrumbs":"Scoping rules » Lifetimes » Functions » Functions","id":"179","title":"Functions"},"18":{"body":"std::fmt","breadcrumbs":"Hello World » Formatted print » Formatting » See also:","id":"18","title":"See also:"},"180":{"body":"Functions","breadcrumbs":"Scoping rules » Lifetimes » Functions » See also:","id":"180","title":"See also:"},"181":{"body":"Methods are annotated similarly to functions: struct Owner(i32); impl Owner { // Annotate lifetimes as in a standalone function. fn add_one<'a>(&'a mut self) { self.0 += 1; } fn print<'a>(&'a self) { println!(\"`print`: {}\", self.0); }\n} fn main() { let mut owner = Owner(18); owner.add_one(); owner.print();\n}","breadcrumbs":"Scoping rules » Lifetimes » Methods » Methods","id":"181","title":"Methods"},"182":{"body":"methods","breadcrumbs":"Scoping rules » Lifetimes » Methods » See also:","id":"182","title":"See also:"},"183":{"body":"Annotation of lifetimes in structures are also similar to functions: // A type `Borrowed` which houses a reference to an\n// `i32`. The reference to `i32` must outlive `Borrowed`.\n#[derive(Debug)]\nstruct Borrowed<'a>(&'a i32); // Similarly, both references here must outlive this structure.\n#[derive(Debug)]\nstruct NamedBorrowed<'a> { x: &'a i32, y: &'a i32,\n} // An enum which is either an `i32` or a reference to one.\n#[derive(Debug)]\nenum Either<'a> { Num(i32), Ref(&'a i32),\n} fn main() { let x = 18; let y = 15; let single = Borrowed(&x); let double = NamedBorrowed { x: &x, y: &y }; let reference = Either::Ref(&x); let number = Either::Num(y); println!(\"x is borrowed in {:?}\", single); println!(\"x and y are borrowed in {:?}\", double); println!(\"x is borrowed in {:?}\", reference); println!(\"y is *not* borrowed in {:?}\", number);\n}","breadcrumbs":"Scoping rules » Lifetimes » Structs » Structs","id":"183","title":"Structs"},"184":{"body":"structs","breadcrumbs":"Scoping rules » Lifetimes » Structs » See also:","id":"184","title":"See also:"},"185":{"body":"Annotation of lifetimes in trait methods basically are similar to functions. Note that impl may have annotation of lifetimes too. // A struct with annotation of lifetimes.\n#[derive(Debug)]\nstruct Borrowed<'a> { x: &'a i32,\n} // Annotate lifetimes to impl.\nimpl<'a> Default for Borrowed<'a> { fn default() -> Self { Self { x: &10, } }\n} fn main() { let b: Borrowed = Default::default(); println!(\"b is {:?}\", b);\n}","breadcrumbs":"Scoping rules » Lifetimes » Traits » Traits","id":"185","title":"Traits"},"186":{"body":"traits","breadcrumbs":"Scoping rules » Lifetimes » Traits » See also:","id":"186","title":"See also:"},"187":{"body":"Just like generic types can be bounded, lifetimes (themselves generic) use bounds as well. The : character has a slightly different meaning here, but + is the same. Note how the following read: T: 'a: All references in T must outlive lifetime 'a. T: Trait + 'a: Type T must implement trait Trait and all references in T must outlive 'a. The example below shows the above syntax in action used after keyword where: use std::fmt::Debug; // Trait to bound with. #[derive(Debug)]\nstruct Ref<'a, T: 'a>(&'a T);\n// `Ref` contains a reference to a generic type `T` that has\n// an unknown lifetime `'a`. `T` is bounded such that any\n// *references* in `T` must outlive `'a`. Additionally, the lifetime\n// of `Ref` may not exceed `'a`. // A generic function which prints using the `Debug` trait.\nfn print<T>(t: T) where T: Debug { println!(\"`print`: t is {:?}\", t);\n} // Here a reference to `T` is taken where `T` implements\n// `Debug` and all *references* in `T` outlive `'a`. In\n// addition, `'a` must outlive the function.\nfn print_ref<'a, T>(t: &'a T) where T: Debug + 'a { println!(\"`print_ref`: t is {:?}\", t);\n} fn main() { let x = 7; let ref_x = Ref(&x); print_ref(&ref_x); print(ref_x);\n}","breadcrumbs":"Scoping rules » Lifetimes » Bounds » Bounds","id":"187","title":"Bounds"},"188":{"body":"generics , bounds in generics , and multiple bounds in generics","breadcrumbs":"Scoping rules » Lifetimes » Bounds » See also:","id":"188","title":"See also:"},"189":{"body":"A longer lifetime can be coerced into a shorter one so that it works inside a scope it normally wouldn't work in. This comes in the form of inferred coercion by the Rust compiler, and also in the form of declaring a lifetime difference: // Here, Rust infers a lifetime that is as short as possible.\n// The two references are then coerced to that lifetime.\nfn multiply<'a>(first: &'a i32, second: &'a i32) -> i32 { first * second\n} // `<'a: 'b, 'b>` reads as lifetime `'a` is at least as long as `'b`.\n// Here, we take in an `&'a i32` and return a `&'b i32` as a result of coercion.\nfn choose_first<'a: 'b, 'b>(first: &'a i32, _: &'b i32) -> &'b i32 { first\n} fn main() { let first = 2; // Longer lifetime { let second = 3; // Shorter lifetime println!(\"The product is {}\", multiply(&first, &second)); println!(\"{} is the first\", choose_first(&first, &second)); };\n}","breadcrumbs":"Scoping rules » Lifetimes » Coercion » Coercion","id":"189","title":"Coercion"},"19":{"body":"Rust provides access to a wide variety of primitives. A sample includes:","breadcrumbs":"Primitives » Primitives","id":"19","title":"Primitives"},"190":{"body":"Rust has a few reserved lifetime names. One of those is 'static. You might encounter it in two situations: // A reference with 'static lifetime:\nlet s: &'static str = \"hello world\"; // 'static as part of a trait bound:\nfn generic<T>(x: T) where T: 'static {} Both are related but subtly different and this is a common source for confusion when learning Rust. Here are some examples for each situation:","breadcrumbs":"Scoping rules » Lifetimes » Static » Static","id":"190","title":"Static"},"191":{"body":"As a reference lifetime 'static indicates that the data pointed to by the reference lives for the remaining lifetime of the running program. It can still be coerced to a shorter lifetime. There are two common ways to make a variable with 'static lifetime, and both are stored in the read-only memory of the binary: Make a constant with the static declaration. Make a string literal which has type: &'static str. See the following example for a display of each method: // Make a constant with `'static` lifetime.\nstatic NUM: i32 = 18; // Returns a reference to `NUM` where its `'static`\n// lifetime is coerced to that of the input argument.\nfn coerce_static<'a>(_: &'a i32) -> &'a i32 { &NUM\n} fn main() { { // Make a `string` literal and print it: let static_string = \"I'm in read-only memory\"; println!(\"static_string: {}\", static_string); // When `static_string` goes out of scope, the reference // can no longer be used, but the data remains in the binary. } { // Make an integer to use for `coerce_static`: let lifetime_num = 9; // Coerce `NUM` to lifetime of `lifetime_num`: let coerced_static = coerce_static(&lifetime_num); println!(\"coerced_static: {}\", coerced_static); } println!(\"NUM: {} stays accessible!\", NUM);\n} Since 'static references only need to be valid for the remainder of a program's life, they can be created while the program is executed. Just to demonstrate, the below example uses Box::leak to dynamically create 'static references. In that case it definitely doesn't live for the entire duration, but only for the leaking point onward. extern crate rand;\nuse rand::Fill; fn random_vec() -> &'static [usize; 100] { let mut rng = rand::thread_rng(); let mut boxed = Box::new([0; 100]); boxed.try_fill(&mut rng).unwrap(); Box::leak(boxed)\n} fn main() { let first: &'static [usize; 100] = random_vec(); let second: &'static [usize; 100] = random_vec(); assert_ne!(first, second)\n}","breadcrumbs":"Scoping rules » Lifetimes » Static » Reference lifetime","id":"191","title":"Reference lifetime"},"192":{"body":"As a trait bound, it means the type does not contain any non-static references. Eg. the receiver can hold on to the type for as long as they want and it will never become invalid until they drop it. It's important to understand this means that any owned data always passes a 'static lifetime bound, but a reference to that owned data generally does not: use std::fmt::Debug; fn print_it( input: impl Debug + 'static ) { println!( \"'static value passed in is: {:?}\", input );\n} fn main() { // i is owned and contains no references, thus it's 'static: let i = 5; print_it(i); // oops, &i only has the lifetime defined by the scope of // main(), so it's not 'static: print_it(&i);\n} The compiler will tell you: error[E0597]: `i` does not live long enough --> src/lib.rs:15:15 |\n15 | print_it(&i); | ---------^^-- | | | | | borrowed value does not live long enough | argument requires that `i` is borrowed for `'static`\n16 | } | - `i` dropped here while still borrowed","breadcrumbs":"Scoping rules » Lifetimes » Static » Trait bound","id":"192","title":"Trait bound"},"193":{"body":"'static constants","breadcrumbs":"Scoping rules » Lifetimes » Static » See also:","id":"193","title":"See also:"},"194":{"body":"Some lifetime patterns are overwhelmingly common and so the borrow checker will allow you to omit them to save typing and to improve readability. This is known as elision. Elision exists in Rust solely because these patterns are common. The following code shows a few examples of elision. For a more comprehensive description of elision, see lifetime elision in the book. // `elided_input` and `annotated_input` essentially have identical signatures\n// because the lifetime of `elided_input` is inferred by the compiler:\nfn elided_input(x: &i32) { println!(\"`elided_input`: {}\", x);\n} fn annotated_input<'a>(x: &'a i32) { println!(\"`annotated_input`: {}\", x);\n} // Similarly, `elided_pass` and `annotated_pass` have identical signatures\n// because the lifetime is added implicitly to `elided_pass`:\nfn elided_pass(x: &i32) -> &i32 { x } fn annotated_pass<'a>(x: &'a i32) -> &'a i32 { x } fn main() { let x = 3; elided_input(&x); annotated_input(&x); println!(\"`elided_pass`: {}\", elided_pass(&x)); println!(\"`annotated_pass`: {}\", annotated_pass(&x));\n}","breadcrumbs":"Scoping rules » Lifetimes » Elision » Elision","id":"194","title":"Elision"},"195":{"body":"elision","breadcrumbs":"Scoping rules » Lifetimes » Elision » See also:","id":"195","title":"See also:"},"196":{"body":"A trait is a collection of methods defined for an unknown type: Self. They can access other methods declared in the same trait. Traits can be implemented for any data type. In the example below, we define Animal, a group of methods. The Animal trait is then implemented for the Sheep data type, allowing the use of methods from Animal with a Sheep. struct Sheep { naked: bool, name: &'static str } trait Animal { // Associated function signature; `Self` refers to the implementor type. fn new(name: &'static str) -> Self; // Method signatures; these will return a string. fn name(&self) -> &'static str; fn noise(&self) -> &'static str; // Traits can provide default method definitions. fn talk(&self) { println!(\"{} says {}\", self.name(), self.noise()); }\n} impl Sheep { fn is_naked(&self) -> bool { self.naked } fn shear(&mut self) { if self.is_naked() { // Implementor methods can use the implementor's trait methods. println!(\"{} is already naked...\", self.name()); } else { println!(\"{} gets a haircut!\", self.name); self.naked = true; } }\n} // Implement the `Animal` trait for `Sheep`.\nimpl Animal for Sheep { // `Self` is the implementor type: `Sheep`. fn new(name: &'static str) -> Sheep { Sheep { name: name, naked: false } } fn name(&self) -> &'static str { self.name } fn noise(&self) -> &'static str { if self.is_naked() { \"baaaaah?\" } else { \"baaaaah!\" } } // Default trait methods can be overridden. fn talk(&self) { // For example, we can add some quiet contemplation. println!(\"{} pauses briefly... {}\", self.name, self.noise()); }\n} fn main() { // Type annotation is necessary in this case. let mut dolly: Sheep = Animal::new(\"Dolly\"); // TODO ^ Try removing the type annotations. dolly.talk(); dolly.shear(); dolly.talk();\n}","breadcrumbs":"Traits » Traits","id":"196","title":"Traits"},"197":{"body":"The compiler is capable of providing basic implementations for some traits via the #[derive] attribute . These traits can still be manually implemented if a more complex behavior is required. The following is a list of derivable traits: Comparison traits: Eq , PartialEq , Ord , PartialOrd . Clone , to create T from &T via a copy. Copy , to give a type 'copy semantics' instead of 'move semantics'. Hash , to compute a hash from &T. Default , to create an empty instance of a data type. Debug , to format a value using the {:?} formatter. // `Centimeters`, a tuple struct that can be compared\n#[derive(PartialEq, PartialOrd)]\nstruct Centimeters(f64); // `Inches`, a tuple struct that can be printed\n#[derive(Debug)]\nstruct Inches(i32); impl Inches { fn to_centimeters(&self) -> Centimeters { let &Inches(inches) = self; Centimeters(inches as f64 * 2.54) }\n} // `Seconds`, a tuple struct with no additional attributes\nstruct Seconds(i32); fn main() { let _one_second = Seconds(1); // Error: `Seconds` can't be printed; it doesn't implement the `Debug` trait //println!(\"One second looks like: {:?}\", _one_second); // TODO ^ Try uncommenting this line // Error: `Seconds` can't be compared; it doesn't implement the `PartialEq` trait //let _this_is_true = (_one_second == _one_second); // TODO ^ Try uncommenting this line let foot = Inches(12); println!(\"One foot equals {:?}\", foot); let meter = Centimeters(100.0); let cmp = if foot.to_centimeters() < meter { \"smaller\" } else { \"bigger\" }; println!(\"One foot is {} than one meter.\", cmp);\n}","breadcrumbs":"Traits » Derive » Derive","id":"197","title":"Derive"},"198":{"body":"derive","breadcrumbs":"Traits » Derive » See also:","id":"198","title":"See also:"},"199":{"body":"The Rust compiler needs to know how much space every function's return type requires. This means all your functions have to return a concrete type. Unlike other languages, if you have a trait like Animal, you can't write a function that returns Animal, because its different implementations will need different amounts of memory. However, there's an easy workaround. Instead of returning a trait object directly, our functions return a Box which contains some Animal. A box is just a reference to some memory in the heap. Because a reference has a statically-known size, and the compiler can guarantee it points to a heap-allocated Animal, we can return a trait from our function! Rust tries to be as explicit as possible whenever it allocates memory on the heap. So if your function returns a pointer-to-trait-on-heap in this way, you need to write the return type with the dyn keyword, e.g. Box<dyn Animal>. struct Sheep {}\nstruct Cow {} trait Animal { // Instance method signature fn noise(&self) -> &'static str;\n} // Implement the `Animal` trait for `Sheep`.\nimpl Animal for Sheep { fn noise(&self) -> &'static str { \"baaaaah!\" }\n} // Implement the `Animal` trait for `Cow`.\nimpl Animal for Cow { fn noise(&self) -> &'static str { \"moooooo!\" }\n} // Returns some struct that implements Animal, but we don't know which one at compile time.\nfn random_animal(random_number: f64) -> Box<dyn Animal> { if random_number < 0.5 { Box::new(Sheep {}) } else { Box::new(Cow {}) }\n} fn main() { let random_number = 0.234; let animal = random_animal(random_number); println!(\"You've randomly chosen an animal, and it says {}\", animal.noise());\n}","breadcrumbs":"Traits » Returning Traits with dyn » Returning Traits with dyn","id":"199","title":"Returning Traits with dyn"},"2":{"body":"Click 'Run' above to see the expected output. Next, add a new line with a second println! macro so that the output shows: Hello World!\nI'm a Rustacean!","breadcrumbs":"Hello World » Activity","id":"2","title":"Activity"},"20":{"body":"Signed integers: i8, i16, i32, i64, i128 and isize (pointer size) Unsigned integers: u8, u16, u32, u64, u128 and usize (pointer size) Floating point: f32, f64 char Unicode scalar values like 'a', 'α' and '∞' (4 bytes each) bool either true or false The unit type (), whose only possible value is an empty tuple: () Despite the value of a unit type being a tuple, it is not considered a compound type because it does not contain multiple values.","breadcrumbs":"Primitives » Scalar Types","id":"20","title":"Scalar Types"},"200":{"body":"In Rust, many of the operators can be overloaded via traits. That is, some operators can be used to accomplish different tasks based on their input arguments. This is possible because operators are syntactic sugar for method calls. For example, the + operator in a + b calls the add method (as in a.add(b)). This add method is part of the Add trait. Hence, the + operator can be used by any implementor of the Add trait. A list of the traits, such as Add, that overload operators can be found in core::ops . use std::ops; struct Foo;\nstruct Bar; #[derive(Debug)]\nstruct FooBar; #[derive(Debug)]\nstruct BarFoo; // The `std::ops::Add` trait is used to specify the functionality of `+`.\n// Here, we make `Add<Bar>` - the trait for addition with a RHS of type `Bar`.\n// The following block implements the operation: Foo + Bar = FooBar\nimpl ops::Add<Bar> for Foo { type Output = FooBar; fn add(self, _rhs: Bar) -> FooBar { println!(\"> Foo.add(Bar) was called\"); FooBar }\n} // By reversing the types, we end up implementing non-commutative addition.\n// Here, we make `Add<Foo>` - the trait for addition with a RHS of type `Foo`.\n// This block implements the operation: Bar + Foo = BarFoo\nimpl ops::Add<Foo> for Bar { type Output = BarFoo; fn add(self, _rhs: Foo) -> BarFoo { println!(\"> Bar.add(Foo) was called\"); BarFoo }\n} fn main() { println!(\"Foo + Bar = {:?}\", Foo + Bar); println!(\"Bar + Foo = {:?}\", Bar + Foo);\n}","breadcrumbs":"Traits » Operator Overloading » Operator Overloading","id":"200","title":"Operator Overloading"},"201":{"body":"Add , Syntax Index","breadcrumbs":"Traits » Operator Overloading » See Also","id":"201","title":"See Also"},"202":{"body":"The Drop trait only has one method: drop, which is called automatically when an object goes out of scope. The main use of the Drop trait is to free the resources that the implementor instance owns. Box, Vec, String, File, and Process are some examples of types that implement the Drop trait to free resources. The Drop trait can also be manually implemented for any custom data type. The following example adds a print to console to the drop function to announce when it is called. struct Droppable { name: &'static str,\n} // This trivial implementation of `drop` adds a print to console.\nimpl Drop for Droppable { fn drop(&mut self) { println!(\"> Dropping {}\", self.name); }\n} fn main() { let _a = Droppable { name: \"a\" }; // block A { let _b = Droppable { name: \"b\" }; // block B { let _c = Droppable { name: \"c\" }; let _d = Droppable { name: \"d\" }; println!(\"Exiting block B\"); } println!(\"Just exited block B\"); println!(\"Exiting block A\"); } println!(\"Just exited block A\"); // Variable can be manually dropped using the `drop` function drop(_a); // TODO ^ Try commenting this line println!(\"end of the main function\"); // `_a` *won't* be `drop`ed again here, because it already has been // (manually) `drop`ed\n}","breadcrumbs":"Traits » Drop » Drop","id":"202","title":"Drop"},"203":{"body":"The Iterator trait is used to implement iterators over collections such as arrays. The trait requires only a method to be defined for the next element, which may be manually defined in an impl block or automatically defined (as in arrays and ranges). As a point of convenience for common situations, the for construct turns some collections into iterators using the .into_iter() method. struct Fibonacci { curr: u32, next: u32,\n} // Implement `Iterator` for `Fibonacci`.\n// The `Iterator` trait only requires a method to be defined for the `next` element.\nimpl Iterator for Fibonacci { // We can refer to this type using Self::Item type Item = u32; // Here, we define the sequence using `.curr` and `.next`. // The return type is `Option<T>`: // * When the `Iterator` is finished, `None` is returned. // * Otherwise, the next value is wrapped in `Some` and returned. // We use Self::Item in the return type, so we can change // the type without having to update the function signatures. fn next(&mut self) -> Option<Self::Item> { let current = self.curr; self.curr = self.next; self.next = current + self.next; // Since there's no endpoint to a Fibonacci sequence, the `Iterator` // will never return `None`, and `Some` is always returned. Some(current) }\n} // Returns a Fibonacci sequence generator\nfn fibonacci() -> Fibonacci { Fibonacci { curr: 0, next: 1 }\n} fn main() { // `0..3` is an `Iterator` that generates: 0, 1, and 2. let mut sequence = 0..3; println!(\"Four consecutive `next` calls on 0..3\"); println!(\"> {:?}\", sequence.next()); println!(\"> {:?}\", sequence.next()); println!(\"> {:?}\", sequence.next()); println!(\"> {:?}\", sequence.next()); // `for` works through an `Iterator` until it returns `None`. // Each `Some` value is unwrapped and bound to a variable (here, `i`). println!(\"Iterate through 0..3 using `for`\"); for i in 0..3 { println!(\"> {}\", i); } // The `take(n)` method reduces an `Iterator` to its first `n` terms. println!(\"The first four terms of the Fibonacci sequence are: \"); for i in fibonacci().take(4) { println!(\"> {}\", i); } // The `skip(n)` method shortens an `Iterator` by dropping its first `n` terms. println!(\"The next four terms of the Fibonacci sequence are: \"); for i in fibonacci().skip(4).take(4) { println!(\"> {}\", i); } let array = [1u32, 3, 3, 7]; // The `iter` method produces an `Iterator` over an array/slice. println!(\"Iterate the following array {:?}\", &array); for i in array.iter() { println!(\"> {}\", i); }\n}","breadcrumbs":"Traits » Iterators » Iterators","id":"203","title":"Iterators"},"204":{"body":"impl Trait can be used in two locations: as an argument type as a return type","breadcrumbs":"Traits » impl Trait » impl Trait","id":"204","title":"impl Trait"},"205":{"body":"If your function is generic over a trait but you don't mind the specific type, you can simplify the function declaration using impl Trait as the type of the argument. For example, consider the following code: fn parse_csv_document<R: std::io::BufRead>(src: R) -> std::io::Result<Vec<Vec<String>>> { src.lines() .map(|line| { // For each line in the source line.map(|line| { // If the line was read successfully, process it, if not, return the error line.split(',') // Split the line separated by commas .map(|entry| String::from(entry.trim())) // Remove leading and trailing whitespace .collect() // Collect all strings in a row into a Vec<String> }) }) .collect() // Collect all lines into a Vec<Vec<String>>\n} parse_csv_document is generic, allowing it to take any type which implements BufRead, such as BufReader<File> or [u8], but it's not important what type R is, and R is only used to declare the type of src, so the function can also be written as: fn parse_csv_document(src: impl std::io::BufRead) -> std::io::Result<Vec<Vec<String>>> { src.lines() .map(|line| { // For each line in the source line.map(|line| { // If the line was read successfully, process it, if not, return the error line.split(',') // Split the line separated by commas .map(|entry| String::from(entry.trim())) // Remove leading and trailing whitespace .collect() // Collect all strings in a row into a Vec<String> }) }) .collect() // Collect all lines into a Vec<Vec<String>>\n} Note that using impl Trait as an argument type means that you cannot explicitly state what form of the function you use, i.e. parse_csv_document::<std::io::Empty>(std::io::empty()) will not work with the second example.","breadcrumbs":"Traits » impl Trait » As an argument type","id":"205","title":"As an argument type"},"206":{"body":"If your function returns a type that implements MyTrait, you can write its return type as -> impl MyTrait. This can help simplify your type signatures quite a lot! use std::iter;\nuse std::vec::IntoIter; // This function combines two `Vec<i32>` and returns an iterator over it.\n// Look how complicated its return type is!\nfn combine_vecs_explicit_return_type( v: Vec<i32>, u: Vec<i32>,\n) -> iter::Cycle<iter::Chain<IntoIter<i32>, IntoIter<i32>>> { v.into_iter().chain(u.into_iter()).cycle()\n} // This is the exact same function, but its return type uses `impl Trait`.\n// Look how much simpler it is!\nfn combine_vecs( v: Vec<i32>, u: Vec<i32>,\n) -> impl Iterator<Item=i32> { v.into_iter().chain(u.into_iter()).cycle()\n} fn main() { let v1 = vec![1, 2, 3]; let v2 = vec![4, 5]; let mut v3 = combine_vecs(v1, v2); assert_eq!(Some(1), v3.next()); assert_eq!(Some(2), v3.next()); assert_eq!(Some(3), v3.next()); assert_eq!(Some(4), v3.next()); assert_eq!(Some(5), v3.next()); println!(\"all done\");\n} More importantly, some Rust types can't be written out. For example, every closure has its own unnamed concrete type. Before impl Trait syntax, you had to allocate on the heap in order to return a closure. But now you can do it all statically, like this: // Returns a function that adds `y` to its input\nfn make_adder_function(y: i32) -> impl Fn(i32) -> i32 { let closure = move |x: i32| { x + y }; closure\n} fn main() { let plus_one = make_adder_function(1); assert_eq!(plus_one(2), 3);\n} You can also use impl Trait to return an iterator that uses map or filter closures! This makes using map and filter easier. Because closure types don't have names, you can't write out an explicit return type if your function returns iterators with closures. But with impl Trait you can do this easily: fn double_positives<'a>(numbers: &'a Vec<i32>) -> impl Iterator<Item = i32> + 'a { numbers .iter() .filter(|x| x > &&0) .map(|x| x * 2)\n} fn main() { let singles = vec![-3, -2, 2, 3]; let doubles = double_positives(&singles); assert_eq!(doubles.collect::<Vec<i32>>(), vec![4, 6]);\n}","breadcrumbs":"Traits » impl Trait » As a return type","id":"206","title":"As a return type"},"207":{"body":"When dealing with resources, the default behavior is to transfer them during assignments or function calls. However, sometimes we need to make a copy of the resource as well. The Clone trait helps us do exactly this. Most commonly, we can use the .clone() method defined by the Clone trait. // A unit struct without resources\n#[derive(Debug, Clone, Copy)]\nstruct Unit; // A tuple struct with resources that implements the `Clone` trait\n#[derive(Clone, Debug)]\nstruct Pair(Box<i32>, Box<i32>); fn main() { // Instantiate `Unit` let unit = Unit; // Copy `Unit`, there are no resources to move let copied_unit = unit; // Both `Unit`s can be used independently println!(\"original: {:?}\", unit); println!(\"copy: {:?}\", copied_unit); // Instantiate `Pair` let pair = Pair(Box::new(1), Box::new(2)); println!(\"original: {:?}\", pair); // Move `pair` into `moved_pair`, moves resources let moved_pair = pair; println!(\"moved: {:?}\", moved_pair); // Error! `pair` has lost its resources //println!(\"original: {:?}\", pair); // TODO ^ Try uncommenting this line // Clone `moved_pair` into `cloned_pair` (resources are included) let cloned_pair = moved_pair.clone(); // Drop the moved original pair using std::mem::drop drop(moved_pair); // Error! `moved_pair` has been dropped //println!(\"moved and dropped: {:?}\", moved_pair); // TODO ^ Try uncommenting this line // The result from .clone() can still be used! println!(\"clone: {:?}\", cloned_pair);\n}","breadcrumbs":"Traits » Clone » Clone","id":"207","title":"Clone"},"208":{"body":"Rust doesn't have \"inheritance\", but you can define a trait as being a superset of another trait. For example: trait Person { fn name(&self) -> String;\n} // Person is a supertrait of Student.\n// Implementing Student requires you to also impl Person.\ntrait Student: Person { fn university(&self) -> String;\n} trait Programmer { fn fav_language(&self) -> String;\n} // CompSciStudent (computer science student) is a subtrait of both Programmer // and Student. Implementing CompSciStudent requires you to impl both supertraits.\ntrait CompSciStudent: Programmer + Student { fn git_username(&self) -> String;\n} fn comp_sci_student_greeting(student: &dyn CompSciStudent) -> String { format!( \"My name is {} and I attend {}. My favorite language is {}. My Git username is {}\", student.name(), student.university(), student.fav_language(), student.git_username() )\n} fn main() {}","breadcrumbs":"Traits » Supertraits » Supertraits","id":"208","title":"Supertraits"},"209":{"body":"The Rust Programming Language chapter on supertraits","breadcrumbs":"Traits » Supertraits » See also:","id":"209","title":"See also:"},"21":{"body":"Arrays like [1, 2, 3] Tuples like (1, true) Variables can always be type annotated . Numbers may additionally be annotated via a suffix or by default . Integers default to i32 and floats to f64. Note that Rust can also infer types from context. fn main() { // Variables can be type annotated. let logical: bool = true; let a_float: f64 = 1.0; // Regular annotation let an_integer = 5i32; // Suffix annotation // Or a default will be used. let default_float = 3.0; // `f64` let default_integer = 7; // `i32` // A type can also be inferred from context. let mut inferred_type = 12; // Type i64 is inferred from another line. inferred_type = 4294967296i64; // A mutable variable's value can be changed. let mut mutable = 12; // Mutable `i32` mutable = 21; // Error! The type of a variable can't be changed. mutable = true; // Variables can be overwritten with shadowing. let mutable = true;\n}","breadcrumbs":"Primitives » Compound Types","id":"21","title":"Compound Types"},"210":{"body":"A type can implement many different traits. What if two traits both require the same name for a function? For example, many traits might have a method named get(). They might even have different return types! Good news: because each trait implementation gets its own impl block, it's clear which trait's get method you're implementing. What about when it comes time to call those methods? To disambiguate between them, we have to use Fully Qualified Syntax. trait UsernameWidget { // Get the selected username out of this widget fn get(&self) -> String;\n} trait AgeWidget { // Get the selected age out of this widget fn get(&self) -> u8;\n} // A form with both a UsernameWidget and an AgeWidget\nstruct Form { username: String, age: u8,\n} impl UsernameWidget for Form { fn get(&self) -> String { self.username.clone() }\n} impl AgeWidget for Form { fn get(&self) -> u8 { self.age }\n} fn main() { let form = Form { username: \"rustacean\".to_owned(), age: 28, }; // If you uncomment this line, you'll get an error saying // \"multiple `get` found\". Because, after all, there are multiple methods // named `get`. // println!(\"{}\", form.get()); let username = <Form as UsernameWidget>::get(&form); assert_eq!(\"rustacean\".to_owned(), username); let age = <Form as AgeWidget>::get(&form); assert_eq!(28, age);\n}","breadcrumbs":"Traits » Disambiguating overlapping traits » Disambiguating overlapping traits","id":"210","title":"Disambiguating overlapping traits"},"211":{"body":"The Rust Programming Language chapter on Fully Qualified syntax","breadcrumbs":"Traits » Disambiguating overlapping traits » See also:","id":"211","title":"See also:"},"212":{"body":"Rust provides a powerful macro system that allows metaprogramming. As you've seen in previous chapters, macros look like functions, except that their name ends with a bang !, but instead of generating a function call, macros are expanded into source code that gets compiled with the rest of the program. However, unlike macros in C and other languages, Rust macros are expanded into abstract syntax trees, rather than string preprocessing, so you don't get unexpected precedence bugs. Macros are created using the macro_rules! macro. // This is a simple macro named `say_hello`.\nmacro_rules! say_hello { // `()` indicates that the macro takes no argument. () => { // The macro will expand into the contents of this block. println!(\"Hello!\") };\n} fn main() { // This call will expand into `println!(\"Hello\")` say_hello!()\n} So why are macros useful? Don't repeat yourself. There are many cases where you may need similar functionality in multiple places but with different types. Often, writing a macro is a useful way to avoid repeating code. (More on this later) Domain-specific languages. Macros allow you to define special syntax for a specific purpose. (More on this later) Variadic interfaces. Sometimes you want to define an interface that takes a variable number of arguments. An example is println! which could take any number of arguments, depending on the format string. (More on this later)","breadcrumbs":"macro_rules! » macro_rules!","id":"212","title":"macro_rules!"},"213":{"body":"In following subsections, we will show how to define macros in Rust. There are three basic ideas: Patterns and Designators Overloading Repetition","breadcrumbs":"macro_rules! » Syntax » Syntax","id":"213","title":"Syntax"},"214":{"body":"The arguments of a macro are prefixed by a dollar sign $ and type annotated with a designator : macro_rules! create_function { // This macro takes an argument of designator `ident` and // creates a function named `$func_name`. // The `ident` designator is used for variable/function names. ($func_name:ident) => { fn $func_name() { // The `stringify!` macro converts an `ident` into a string. println!(\"You called {:?}()\", stringify!($func_name)); } };\n} // Create functions named `foo` and `bar` with the above macro.\ncreate_function!(foo);\ncreate_function!(bar); macro_rules! print_result { // This macro takes an expression of type `expr` and prints // it as a string along with its result. // The `expr` designator is used for expressions. ($expression:expr) => { // `stringify!` will convert the expression *as it is* into a string. println!(\"{:?} = {:?}\", stringify!($expression), $expression); };\n} fn main() { foo(); bar(); print_result!(1u32 + 1); // Recall that blocks are expressions too! print_result!({ let x = 1u32; x * x + 2 * x - 1 });\n} These are some of the available designators: block expr is used for expressions ident is used for variable/function names item literal is used for literal constants pat ( pattern ) path stmt ( statement ) tt ( token tree ) ty ( type ) vis ( visibility qualifier ) For a complete list, see the Rust Reference .","breadcrumbs":"macro_rules! » Syntax » Designators » Designators","id":"214","title":"Designators"},"215":{"body":"Macros can be overloaded to accept different combinations of arguments. In that regard, macro_rules! can work similarly to a match block: // `test!` will compare `$left` and `$right`\n// in different ways depending on how you invoke it:\nmacro_rules! test { // Arguments don't need to be separated by a comma. // Any template can be used! ($left:expr; and $right:expr) => { println!(\"{:?} and {:?} is {:?}\", stringify!($left), stringify!($right), $left && $right) }; // ^ each arm must end with a semicolon. ($left:expr; or $right:expr) => { println!(\"{:?} or {:?} is {:?}\", stringify!($left), stringify!($right), $left || $right) };\n} fn main() { test!(1i32 + 1 == 2i32; and 2i32 * 2 == 4i32); test!(true; or false);\n}","breadcrumbs":"macro_rules! » Syntax » Overload » Overload","id":"215","title":"Overload"},"216":{"body":"Macros can use + in the argument list to indicate that an argument may repeat at least once, or *, to indicate that the argument may repeat zero or more times. In the following example, surrounding the matcher with $(...),+ will match one or more expression, separated by commas. Also note that the semicolon is optional on the last case. // `find_min!` will calculate the minimum of any number of arguments.\nmacro_rules! find_min { // Base case: ($x:expr) => ($x); // `$x` followed by at least one `$y,` ($x:expr, $($y:expr),+) => ( // Call `find_min!` on the tail `$y` std::cmp::min($x, find_min!($($y),+)) )\n} fn main() { println!(\"{}\", find_min!(1)); println!(\"{}\", find_min!(1 + 2, 2)); println!(\"{}\", find_min!(5, 2 * 3, 4));\n}","breadcrumbs":"macro_rules! » Syntax » Repeat » Repeat","id":"216","title":"Repeat"},"217":{"body":"Macros allow writing DRY code by factoring out the common parts of functions and/or test suites. Here is an example that implements and tests the +=, *= and -= operators on Vec<T>: use std::ops::{Add, Mul, Sub}; macro_rules! assert_equal_len { // The `tt` (token tree) designator is used for // operators and tokens. ($a:expr, $b:expr, $func:ident, $op:tt) => { assert!($a.len() == $b.len(), \"{:?}: dimension mismatch: {:?} {:?} {:?}\", stringify!($func), ($a.len(),), stringify!($op), ($b.len(),)); };\n} macro_rules! op { ($func:ident, $bound:ident, $op:tt, $method:ident) => { fn $func<T: $bound<T, Output=T> + Copy>(xs: &mut Vec<T>, ys: &Vec<T>) { assert_equal_len!(xs, ys, $func, $op); for (x, y) in xs.iter_mut().zip(ys.iter()) { *x = $bound::$method(*x, *y); // *x = x.$method(*y); } } };\n} // Implement `add_assign`, `mul_assign`, and `sub_assign` functions.\nop!(add_assign, Add, +=, add);\nop!(mul_assign, Mul, *=, mul);\nop!(sub_assign, Sub, -=, sub); mod test { use std::iter; macro_rules! test { ($func:ident, $x:expr, $y:expr, $z:expr) => { #[test] fn $func() { for size in 0usize..10 { let mut x: Vec<_> = iter::repeat($x).take(size).collect(); let y: Vec<_> = iter::repeat($y).take(size).collect(); let z: Vec<_> = iter::repeat($z).take(size).collect(); super::$func(&mut x, &y); assert_eq!(x, z); } } }; } // Test `add_assign`, `mul_assign`, and `sub_assign`. test!(add_assign, 1u32, 2u32, 3u32); test!(mul_assign, 2u32, 3u32, 6u32); test!(sub_assign, 3u32, 2u32, 1u32);\n} $ rustc --test dry.rs && ./dry\nrunning 3 tests\ntest test::mul_assign ... ok\ntest test::add_assign ... ok\ntest test::sub_assign ... ok test result: ok. 3 passed; 0 failed; 0 ignored; 0 measured","breadcrumbs":"macro_rules! » DRY (Don't Repeat Yourself) » DRY (Don't Repeat Yourself)","id":"217","title":"DRY (Don't Repeat Yourself)"},"218":{"body":"A DSL is a mini \"language\" embedded in a Rust macro. It is completely valid Rust because the macro system expands into normal Rust constructs, but it looks like a small language. This allows you to define concise or intuitive syntax for some special functionality (within bounds). Suppose that I want to define a little calculator API. I would like to supply an expression and have the output printed to console. macro_rules! calculate { (eval $e:expr) => { { let val: usize = $e; // Force types to be unsigned integers println!(\"{} = {}\", stringify!{$e}, val); } };\n} fn main() { calculate! { eval 1 + 2 // hehehe `eval` is _not_ a Rust keyword! } calculate! { eval (1 + 2) * (3 / 4) }\n} Output: 1 + 2 = 3\n(1 + 2) * (3 / 4) = 0 This was a very simple example, but much more complex interfaces have been developed, such as lazy_static or clap . Also, note the two pairs of braces in the macro. The outer ones are part of the syntax of macro_rules!, in addition to () or [].","breadcrumbs":"macro_rules! » DSL (Domain Specific Languages) » Domain Specific Languages (DSLs)","id":"218","title":"Domain Specific Languages (DSLs)"},"219":{"body":"A variadic interface takes an arbitrary number of arguments. For example, println! can take an arbitrary number of arguments, as determined by the format string. We can extend our calculate! macro from the previous section to be variadic: macro_rules! calculate { // The pattern for a single `eval` (eval $e:expr) => { { let val: usize = $e; // Force types to be integers println!(\"{} = {}\", stringify!{$e}, val); } }; // Decompose multiple `eval`s recursively (eval $e:expr, $(eval $es:expr),+) => {{ calculate! { eval $e } calculate! { $(eval $es),+ } }};\n} fn main() { calculate! { // Look ma! Variadic `calculate!`! eval 1 + 2, eval 3 + 4, eval (2 * 3) + 1 }\n} Output: 1 + 2 = 3\n3 + 4 = 7\n(2 * 3) + 1 = 7","breadcrumbs":"macro_rules! » Variadics » Variadic Interfaces","id":"219","title":"Variadic Interfaces"},"22":{"body":"the std library , mut , inference , and shadowing","breadcrumbs":"Primitives » See also:","id":"22","title":"See also:"},"220":{"body":"Error handling is the process of handling the possibility of failure. For example, failing to read a file and then continuing to use that bad input would clearly be problematic. Noticing and explicitly managing those errors saves the rest of the program from various pitfalls. There are various ways to deal with errors in Rust, which are described in the following subchapters. They all have more or less subtle differences and different use cases. As a rule of thumb: An explicit panic is mainly useful for tests and dealing with unrecoverable errors. For prototyping it can be useful, for example when dealing with functions that haven't been implemented yet, but in those cases the more descriptive unimplemented is better. In tests panic is a reasonable way to explicitly fail. The Option type is for when a value is optional or when the lack of a value is not an error condition. For example the parent of a directory - / and C: don't have one. When dealing with Options, unwrap is fine for prototyping and cases where it's absolutely certain that there is guaranteed to be a value. However expect is more useful since it lets you specify an error message in case something goes wrong anyway. When there is a chance that things do go wrong and the caller has to deal with the problem, use Result. You can unwrap and expect them as well (please don't do that unless it's a test or quick prototype). For a more rigorous discussion of error handling, refer to the error handling section in the official book .","breadcrumbs":"Error handling » Error handling","id":"220","title":"Error handling"},"221":{"body":"The simplest error handling mechanism we will see is panic. It prints an error message, starts unwinding the stack, and usually exits the program. Here, we explicitly call panic on our error condition: fn drink(beverage: &str) { // You shouldn't drink too much sugary beverages. if beverage == \"lemonade\" { panic!(\"AAAaaaaa!!!!\"); } println!(\"Some refreshing {} is all I need.\", beverage);\n} fn main() { drink(\"water\"); drink(\"lemonade\"); drink(\"still water\");\n} The first call to drink works. The second panics and thus the third is never called.","breadcrumbs":"Error handling » panic » panic","id":"221","title":"panic"},"222":{"body":"The previous section illustrates the error handling mechanism panic. Different code paths can be conditionally compiled based on the panic setting. The current values available are unwind and abort. Building on the prior lemonade example, we explicitly use the panic strategy to exercise different lines of code. fn drink(beverage: &str) { // You shouldn't drink too much sugary beverages. if beverage == \"lemonade\" { if cfg!(panic = \"abort\") { println!(\"This is not your party. Run!!!!\"); } else { println!(\"Spit it out!!!!\"); } } else { println!(\"Some refreshing {} is all I need.\", beverage); }\n} fn main() { drink(\"water\"); drink(\"lemonade\");\n} Here is another example focusing on rewriting drink() and explicitly use the unwind keyword. #[cfg(panic = \"unwind\")]\nfn ah() { println!(\"Spit it out!!!!\");\n} #[cfg(not(panic = \"unwind\"))]\nfn ah() { println!(\"This is not your party. Run!!!!\");\n} fn drink(beverage: &str) { if beverage == \"lemonade\" { ah(); } else { println!(\"Some refreshing {} is all I need.\", beverage); }\n} fn main() { drink(\"water\"); drink(\"lemonade\");\n} The panic strategy can be set from the command line by using abort or unwind. rustc lemonade.rs -C panic=abort","breadcrumbs":"Error handling » abort & unwind » abort and unwind","id":"222","title":"abort and unwind"},"223":{"body":"In the last example, we showed that we can induce program failure at will. We told our program to panic if we drink a sugary lemonade. But what if we expect some drink but don't receive one? That case would be just as bad, so it needs to be handled! We could test this against the null string (\"\") as we do with a lemonade. Since we're using Rust, let's instead have the compiler point out cases where there's no drink. An enum called Option<T> in the std library is used when absence is a possibility. It manifests itself as one of two \"options\": Some(T): An element of type T was found None: No element was found These cases can either be explicitly handled via match or implicitly with unwrap. Implicit handling will either return the inner element or panic. Note that it's possible to manually customize panic with expect , but unwrap otherwise leaves us with a less meaningful output than explicit handling. In the following example, explicit handling yields a more controlled result while retaining the option to panic if desired. // The adult has seen it all, and can handle any drink well.\n// All drinks are handled explicitly using `match`.\nfn give_adult(drink: Option<&str>) { // Specify a course of action for each case. match drink { Some(\"lemonade\") => println!(\"Yuck! Too sugary.\"), Some(inner) => println!(\"{}? How nice.\", inner), None => println!(\"No drink? Oh well.\"), }\n} // Others will `panic` before drinking sugary drinks.\n// All drinks are handled implicitly using `unwrap`.\nfn drink(drink: Option<&str>) { // `unwrap` returns a `panic` when it receives a `None`. let inside = drink.unwrap(); if inside == \"lemonade\" { panic!(\"AAAaaaaa!!!!\"); } println!(\"I love {}s!!!!!\", inside);\n} fn main() { let water = Some(\"water\"); let lemonade = Some(\"lemonade\"); let void = None; give_adult(water); give_adult(lemonade); give_adult(void); let coffee = Some(\"coffee\"); let nothing = None; drink(coffee); drink(nothing);\n}","breadcrumbs":"Error handling » Option & unwrap » Option & unwrap","id":"223","title":"Option & unwrap"},"224":{"body":"You can unpack Options by using match statements, but it's often easier to use the ? operator. If x is an Option, then evaluating x? will return the underlying value if x is Some, otherwise it will terminate whatever function is being executed and return None. fn next_birthday(current_age: Option<u8>) -> Option<String> { // If `current_age` is `None`, this returns `None`. // If `current_age` is `Some`, the inner `u8` value + 1 // gets assigned to `next_age` let next_age: u8 = current_age? + 1; Some(format!(\"Next year I will be {}\", next_age))\n} You can chain many ?s together to make your code much more readable. struct Person { job: Option<Job>,\n} #[derive(Clone, Copy)]\nstruct Job { phone_number: Option<PhoneNumber>,\n} #[derive(Clone, Copy)]\nstruct PhoneNumber { area_code: Option<u8>, number: u32,\n} impl Person { // Gets the area code of the phone number of the person's job, if it exists. fn work_phone_area_code(&self) -> Option<u8> { // This would need many nested `match` statements without the `?` operator. // It would take a lot more code - try writing it yourself and see which // is easier. self.job?.phone_number?.area_code }\n} fn main() { let p = Person { job: Some(Job { phone_number: Some(PhoneNumber { area_code: Some(61), number: 439222222, }), }), }; assert_eq!(p.work_phone_area_code(), Some(61));\n}","breadcrumbs":"Error handling » Option & unwrap » Unpacking options with ? » Unpacking options with ?","id":"224","title":"Unpacking options with ?"},"225":{"body":"match is a valid method for handling Options. However, you may eventually find heavy usage tedious, especially with operations only valid with an input. In these cases, combinators can be used to manage control flow in a modular fashion. Option has a built in method called map(), a combinator for the simple mapping of Some -> Some and None -> None. Multiple map() calls can be chained together for even more flexibility. In the following example, process() replaces all functions previous to it while staying compact. #![allow(dead_code)] #[derive(Debug)] enum Food { Apple, Carrot, Potato } #[derive(Debug)] struct Peeled(Food);\n#[derive(Debug)] struct Chopped(Food);\n#[derive(Debug)] struct Cooked(Food); // Peeling food. If there isn't any, then return `None`.\n// Otherwise, return the peeled food.\nfn peel(food: Option<Food>) -> Option<Peeled> { match food { Some(food) => Some(Peeled(food)), None => None, }\n} // Chopping food. If there isn't any, then return `None`.\n// Otherwise, return the chopped food.\nfn chop(peeled: Option<Peeled>) -> Option<Chopped> { match peeled { Some(Peeled(food)) => Some(Chopped(food)), None => None, }\n} // Cooking food. Here, we showcase `map()` instead of `match` for case handling.\nfn cook(chopped: Option<Chopped>) -> Option<Cooked> { chopped.map(|Chopped(food)| Cooked(food))\n} // A function to peel, chop, and cook food all in sequence.\n// We chain multiple uses of `map()` to simplify the code.\nfn process(food: Option<Food>) -> Option<Cooked> { food.map(|f| Peeled(f)) .map(|Peeled(f)| Chopped(f)) .map(|Chopped(f)| Cooked(f))\n} // Check whether there's food or not before trying to eat it!\nfn eat(food: Option<Cooked>) { match food { Some(food) => println!(\"Mmm. I love {:?}\", food), None => println!(\"Oh no! It wasn't edible.\"), }\n} fn main() { let apple = Some(Food::Apple); let carrot = Some(Food::Carrot); let potato = None; let cooked_apple = cook(chop(peel(apple))); let cooked_carrot = cook(chop(peel(carrot))); // Let's try the simpler looking `process()` now. let cooked_potato = process(potato); eat(cooked_apple); eat(cooked_carrot); eat(cooked_potato);\n}","breadcrumbs":"Error handling » Option & unwrap » Combinators: map » Combinators: map","id":"225","title":"Combinators: map"},"226":{"body":"closures , Option , Option::map()","breadcrumbs":"Error handling » Option & unwrap » Combinators: map » See also:","id":"226","title":"See also:"},"227":{"body":"map() was described as a chainable way to simplify match statements. However, using map() on a function that returns an Option<T> results in the nested Option<Option<T>>. Chaining multiple calls together can then become confusing. That's where another combinator called and_then(), known in some languages as flatmap, comes in. and_then() calls its function input with the wrapped value and returns the result. If the Option is None, then it returns None instead. In the following example, cookable_v3() results in an Option<Food>. Using map() instead of and_then() would have given an Option<Option<Food>>, which is an invalid type for eat(). #![allow(dead_code)] #[derive(Debug)] enum Food { CordonBleu, Steak, Sushi }\n#[derive(Debug)] enum Day { Monday, Tuesday, Wednesday } // We don't have the ingredients to make Sushi.\nfn have_ingredients(food: Food) -> Option<Food> { match food { Food::Sushi => None, _ => Some(food), }\n} // We have the recipe for everything except Cordon Bleu.\nfn have_recipe(food: Food) -> Option<Food> { match food { Food::CordonBleu => None, _ => Some(food), }\n} // To make a dish, we need both the recipe and the ingredients.\n// We can represent the logic with a chain of `match`es:\nfn cookable_v1(food: Food) -> Option<Food> { match have_recipe(food) { None => None, Some(food) => have_ingredients(food), }\n} // This can conveniently be rewritten more compactly with `and_then()`:\nfn cookable_v3(food: Food) -> Option<Food> { have_recipe(food).and_then(have_ingredients)\n} // Otherwise we'd need to `flatten()` an `Option<Option<Food>>`\n// to get an `Option<Food>`:\nfn cookable_v2(food: Food) -> Option<Food> { have_recipe(food).map(have_ingredients).flatten()\n} fn eat(food: Food, day: Day) { match cookable_v3(food) { Some(food) => println!(\"Yay! On {:?} we get to eat {:?}.\", day, food), None => println!(\"Oh no. We don't get to eat on {:?}?\", day), }\n} fn main() { let (cordon_bleu, steak, sushi) = (Food::CordonBleu, Food::Steak, Food::Sushi); eat(cordon_bleu, Day::Monday); eat(steak, Day::Tuesday); eat(sushi, Day::Wednesday);\n}","breadcrumbs":"Error handling » Option & unwrap » Combinators: and_then » Combinators: and_then","id":"227","title":"Combinators: and_then"},"228":{"body":"closures , Option , Option::and_then() , and Option::flatten()","breadcrumbs":"Error handling » Option & unwrap » Combinators: and_then » See also:","id":"228","title":"See also:"},"229":{"body":"There is more than one way to unpack an Option and fall back on a default if it is None. To choose the one that meets our needs, we need to consider the following: do we need eager or lazy evaluation? do we need to keep the original empty value intact, or modify it in place?","breadcrumbs":"Error handling » Option & unwrap » Defaults: or, or_else, get_or_insert, get_or_insert_with » Unpacking options and defaults","id":"229","title":"Unpacking options and defaults"},"23":{"body":"Integers 1, floats 1.2, characters 'a', strings \"abc\", booleans true and the unit type () can be expressed using literals. Integers can, alternatively, be expressed using hexadecimal, octal or binary notation using these prefixes respectively: 0x, 0o or 0b. Underscores can be inserted in numeric literals to improve readability, e.g. 1_000 is the same as 1000, and 0.000_001 is the same as 0.000001. Rust also supports scientific E-notation , e.g. 1e6, 7.6e-4. The associated type is f64. We need to tell the compiler the type of the literals we use. For now, we'll use the u32 suffix to indicate that the literal is an unsigned 32-bit integer, and the i32 suffix to indicate that it's a signed 32-bit integer. The operators available and their precedence in Rust are similar to other C-like languages . fn main() { // Integer addition println!(\"1 + 2 = {}\", 1u32 + 2); // Integer subtraction println!(\"1 - 2 = {}\", 1i32 - 2); // TODO ^ Try changing `1i32` to `1u32` to see why the type is important // Scientific notation println!(\"1e4 is {}, -2.5e-3 is {}\", 1e4, -2.5e-3); // Short-circuiting boolean logic println!(\"true AND false is {}\", true && false); println!(\"true OR false is {}\", true || false); println!(\"NOT true is {}\", !true); // Bitwise operations println!(\"0011 AND 0101 is {:04b}\", 0b0011u32 & 0b0101); println!(\"0011 OR 0101 is {:04b}\", 0b0011u32 | 0b0101); println!(\"0011 XOR 0101 is {:04b}\", 0b0011u32 ^ 0b0101); println!(\"1 << 5 is {}\", 1u32 << 5); println!(\"0x80 >> 2 is 0x{:x}\", 0x80u32 >> 2); // Use underscores to improve readability! println!(\"One million is written as {}\", 1_000_000u32);\n}","breadcrumbs":"Primitives » Literals and operators » Literals and operators","id":"23","title":"Literals and operators"},"230":{"body":"or()is chainable and eagerly evaluates its argument, as is shown in the following example. Note that because or's arguments are evaluated eagerly, the variable passed to or is moved. #[derive(Debug)] enum Fruit { Apple, Orange, Banana, Kiwi, Lemon } fn main() { let apple = Some(Fruit::Apple); let orange = Some(Fruit::Orange); let no_fruit: Option<Fruit> = None; let first_available_fruit = no_fruit.or(orange).or(apple); println!(\"first_available_fruit: {:?}\", first_available_fruit); // first_available_fruit: Some(Orange) // `or` moves its argument. // In the example above, `or(orange)` returned a `Some`, so `or(apple)` was not invoked. // But the variable named `apple` has been moved regardless, and cannot be used anymore. // println!(\"Variable apple was moved, so this line won't compile: {:?}\", apple); // TODO: uncomment the line above to see the compiler error }","breadcrumbs":"Error handling » Option & unwrap » Defaults: or, or_else, get_or_insert, get_or_insert_with » or() is chainable, evaluates eagerly, keeps empty value intact","id":"230","title":"or() is chainable, evaluates eagerly, keeps empty value intact"},"231":{"body":"Another alternative is to use or_else, which is also chainable, and evaluates lazily, as is shown in the following example: #[derive(Debug)] enum Fruit { Apple, Orange, Banana, Kiwi, Lemon } fn main() { let no_fruit: Option<Fruit> = None; let get_kiwi_as_fallback = || { println!(\"Providing kiwi as fallback\"); Some(Fruit::Kiwi) }; let get_lemon_as_fallback = || { println!(\"Providing lemon as fallback\"); Some(Fruit::Lemon) }; let first_available_fruit = no_fruit .or_else(get_kiwi_as_fallback) .or_else(get_lemon_as_fallback); println!(\"first_available_fruit: {:?}\", first_available_fruit); // Providing kiwi as fallback // first_available_fruit: Some(Kiwi)\n}","breadcrumbs":"Error handling » Option & unwrap » Defaults: or, or_else, get_or_insert, get_or_insert_with » or_else() is chainable, evaluates lazily, keeps empty value intact","id":"231","title":"or_else() is chainable, evaluates lazily, keeps empty value intact"},"232":{"body":"To make sure that an Option contains a value, we can use get_or_insert to modify it in place with a fallback value, as is shown in the following example. Note that get_or_insert eagerly evaluates its parameter, so variable apple is moved: #[derive(Debug)]\nenum Fruit { Apple, Orange, Banana, Kiwi, Lemon } fn main() { let mut my_fruit: Option<Fruit> = None; let apple = Fruit::Apple; let first_available_fruit = my_fruit.get_or_insert(apple); println!(\"first_available_fruit is: {:?}\", first_available_fruit); println!(\"my_fruit is: {:?}\", my_fruit); // first_available_fruit is: Apple // my_fruit is: Some(Apple) //println!(\"Variable named `apple` is moved: {:?}\", apple); // TODO: uncomment the line above to see the compiler error\n}","breadcrumbs":"Error handling » Option & unwrap » Defaults: or, or_else, get_or_insert, get_or_insert_with » get_or_insert() evaluates eagerly, modifies empty value in place","id":"232","title":"get_or_insert() evaluates eagerly, modifies empty value in place"},"233":{"body":"Instead of explicitly providing a value to fall back on, we can pass a closure to get_or_insert_with, as follows: #[derive(Debug)] enum Fruit { Apple, Orange, Banana, Kiwi, Lemon } fn main() { let mut my_fruit: Option<Fruit> = None; let get_lemon_as_fallback = || { println!(\"Providing lemon as fallback\"); Fruit::Lemon }; let first_available_fruit = my_fruit .get_or_insert_with(get_lemon_as_fallback); println!(\"first_available_fruit is: {:?}\", first_available_fruit); println!(\"my_fruit is: {:?}\", my_fruit); // Providing lemon as fallback // first_available_fruit is: Lemon // my_fruit is: Some(Lemon) // If the Option has a value, it is left unchanged, and the closure is not invoked let mut my_apple = Some(Fruit::Apple); let should_be_apple = my_apple.get_or_insert_with(get_lemon_as_fallback); println!(\"should_be_apple is: {:?}\", should_be_apple); println!(\"my_apple is unchanged: {:?}\", my_apple); // The output is a follows. Note that the closure `get_lemon_as_fallback` is not invoked // should_be_apple is: Apple // my_apple is unchanged: Some(Apple)\n}","breadcrumbs":"Error handling » Option & unwrap » Defaults: or, or_else, get_or_insert, get_or_insert_with » get_or_insert_with() evaluates lazily, modifies empty value in place","id":"233","title":"get_or_insert_with() evaluates lazily, modifies empty value in place"},"234":{"body":"closures , get_or_insert , get_or_insert_with , moved variables , or , or_else","breadcrumbs":"Error handling » Option & unwrap » Defaults: or, or_else, get_or_insert, get_or_insert_with » See also:","id":"234","title":"See also:"},"235":{"body":"Result is a richer version of the Option type that describes possible error instead of possible absence . That is, Result<T, E> could have one of two outcomes: Ok(T): An element T was found Err(E): An error was found with element E By convention, the expected outcome is Ok while the unexpected outcome is Err. Like Option, Result has many methods associated with it. unwrap(), for example, either yields the element T or panics. For case handling, there are many combinators between Result and Option that overlap. In working with Rust, you will likely encounter methods that return the Result type, such as the parse() method. It might not always be possible to parse a string into the other type, so parse() returns a Result indicating possible failure. Let's see what happens when we successfully and unsuccessfully parse() a string: fn multiply(first_number_str: &str, second_number_str: &str) -> i32 { // Let's try using `unwrap()` to get the number out. Will it bite us? let first_number = first_number_str.parse::<i32>().unwrap(); let second_number = second_number_str.parse::<i32>().unwrap(); first_number * second_number\n} fn main() { let twenty = multiply(\"10\", \"2\"); println!(\"double is {}\", twenty); let tt = multiply(\"t\", \"2\"); println!(\"double is {}\", tt);\n} In the unsuccessful case, parse() leaves us with an error for unwrap() to panic on. Additionally, the panic exits our program and provides an unpleasant error message. To improve the quality of our error message, we should be more specific about the return type and consider explicitly handling the error.","breadcrumbs":"Error handling » Result » Result","id":"235","title":"Result"},"236":{"body":"The Result type can also be the return type of the main function if specified explicitly. Typically the main function will be of the form: fn main() { println!(\"Hello World!\");\n} However main is also able to have a return type of Result. If an error occurs within the main function it will return an error code and print a debug representation of the error (using the Debug trait). The following example shows such a scenario and touches on aspects covered in the following section . use std::num::ParseIntError; fn main() -> Result<(), ParseIntError> { let number_str = \"10\"; let number = match number_str.parse::<i32>() { Ok(number) => number, Err(e) => return Err(e), }; println!(\"{}\", number); Ok(())\n}","breadcrumbs":"Error handling » Result » Using Result in main","id":"236","title":"Using Result in main"},"237":{"body":"Panicking in the previous example's multiply does not make for robust code. Generally, we want to return the error to the caller so it can decide what is the right way to respond to errors. We first need to know what kind of error type we are dealing with. To determine the Err type, we look to parse() , which is implemented with the FromStr trait for i32 . As a result, the Err type is specified as ParseIntError . In the example below, the straightforward match statement leads to code that is overall more cumbersome. use std::num::ParseIntError; // With the return type rewritten, we use pattern matching without `unwrap()`.\nfn multiply(first_number_str: &str, second_number_str: &str) -> Result<i32, ParseIntError> { match first_number_str.parse::<i32>() { Ok(first_number) => { match second_number_str.parse::<i32>() { Ok(second_number) => { Ok(first_number * second_number) }, Err(e) => Err(e), } }, Err(e) => Err(e), }\n} fn print(result: Result<i32, ParseIntError>) { match result { Ok(n) => println!(\"n is {}\", n), Err(e) => println!(\"Error: {}\", e), }\n} fn main() { // This still presents a reasonable answer. let twenty = multiply(\"10\", \"2\"); print(twenty); // The following now provides a much more helpful error message. let tt = multiply(\"t\", \"2\"); print(tt);\n} Luckily, Option's map, and_then, and many other combinators are also implemented for Result. Result contains a complete listing. use std::num::ParseIntError; // As with `Option`, we can use combinators such as `map()`.\n// This function is otherwise identical to the one above and reads:\n// Multiply if both values can be parsed from str, otherwise pass on the error.\nfn multiply(first_number_str: &str, second_number_str: &str) -> Result<i32, ParseIntError> { first_number_str.parse::<i32>().and_then(|first_number| { second_number_str.parse::<i32>().map(|second_number| first_number * second_number) })\n} fn print(result: Result<i32, ParseIntError>) { match result { Ok(n) => println!(\"n is {}\", n), Err(e) => println!(\"Error: {}\", e), }\n} fn main() { // This still presents a reasonable answer. let twenty = multiply(\"10\", \"2\"); print(twenty); // The following now provides a much more helpful error message. let tt = multiply(\"t\", \"2\"); print(tt);\n}","breadcrumbs":"Error handling » Result » map for Result » map for Result","id":"237","title":"map for Result"},"238":{"body":"How about when we want to reuse a specific Result type many times? Recall that Rust allows us to create aliases . Conveniently, we can define one for the specific Result in question. At a module level, creating aliases can be particularly helpful. Errors found in a specific module often have the same Err type, so a single alias can succinctly define all associated Results. This is so useful that the std library even supplies one: io::Result ! Here's a quick example to show off the syntax: use std::num::ParseIntError; // Define a generic alias for a `Result` with the error type `ParseIntError`.\ntype AliasedResult<T> = Result<T, ParseIntError>; // Use the above alias to refer to our specific `Result` type.\nfn multiply(first_number_str: &str, second_number_str: &str) -> AliasedResult<i32> { first_number_str.parse::<i32>().and_then(|first_number| { second_number_str.parse::<i32>().map(|second_number| first_number * second_number) })\n} // Here, the alias again allows us to save some space.\nfn print(result: AliasedResult<i32>) { match result { Ok(n) => println!(\"n is {}\", n), Err(e) => println!(\"Error: {}\", e), }\n} fn main() { print(multiply(\"10\", \"2\")); print(multiply(\"t\", \"2\"));\n}","breadcrumbs":"Error handling » Result » aliases for Result » aliases for Result","id":"238","title":"aliases for Result"},"239":{"body":"io::Result","breadcrumbs":"Error handling » Result » aliases for Result » See also:","id":"239","title":"See also:"},"24":{"body":"A tuple is a collection of values of different types. Tuples are constructed using parentheses (), and each tuple itself is a value with type signature (T1, T2, ...), where T1, T2 are the types of its members. Functions can use tuples to return multiple values, as tuples can hold any number of values. // Tuples can be used as function arguments and as return values.\nfn reverse(pair: (i32, bool)) -> (bool, i32) { // `let` can be used to bind the members of a tuple to variables. let (int_param, bool_param) = pair; (bool_param, int_param)\n} // The following struct is for the activity.\n#[derive(Debug)]\nstruct Matrix(f32, f32, f32, f32); fn main() { // A tuple with a bunch of different types. let long_tuple = (1u8, 2u16, 3u32, 4u64, -1i8, -2i16, -3i32, -4i64, 0.1f32, 0.2f64, 'a', true); // Values can be extracted from the tuple using tuple indexing. println!(\"Long tuple first value: {}\", long_tuple.0); println!(\"Long tuple second value: {}\", long_tuple.1); // Tuples can be tuple members. let tuple_of_tuples = ((1u8, 2u16, 2u32), (4u64, -1i8), -2i16); // Tuples are printable. println!(\"tuple of tuples: {:?}\", tuple_of_tuples); // But long Tuples (more than 12 elements) cannot be printed. //let too_long_tuple = (1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13); //println!(\"Too long tuple: {:?}\", too_long_tuple); // TODO ^ Uncomment the above 2 lines to see the compiler error let pair = (1, true); println!(\"Pair is {:?}\", pair); println!(\"The reversed pair is {:?}\", reverse(pair)); // To create one element tuples, the comma is required to tell them apart // from a literal surrounded by parentheses. println!(\"One element tuple: {:?}\", (5u32,)); println!(\"Just an integer: {:?}\", (5u32)); // Tuples can be destructured to create bindings. let tuple = (1, \"hello\", 4.5, true); let (a, b, c, d) = tuple; println!(\"{:?}, {:?}, {:?}, {:?}\", a, b, c, d); let matrix = Matrix(1.1, 1.2, 2.1, 2.2); println!(\"{:?}\", matrix);\n}","breadcrumbs":"Primitives » Tuples » Tuples","id":"24","title":"Tuples"},"240":{"body":"In the previous example, we explicitly handled the errors using combinators. Another way to deal with this case analysis is to use a combination of match statements and early returns . That is, we can simply stop executing the function and return the error if one occurs. For some, this form of code can be easier to both read and write. Consider this version of the previous example, rewritten using early returns: use std::num::ParseIntError; fn multiply(first_number_str: &str, second_number_str: &str) -> Result<i32, ParseIntError> { let first_number = match first_number_str.parse::<i32>() { Ok(first_number) => first_number, Err(e) => return Err(e), }; let second_number = match second_number_str.parse::<i32>() { Ok(second_number) => second_number, Err(e) => return Err(e), }; Ok(first_number * second_number)\n} fn print(result: Result<i32, ParseIntError>) { match result { Ok(n) => println!(\"n is {}\", n), Err(e) => println!(\"Error: {}\", e), }\n} fn main() { print(multiply(\"10\", \"2\")); print(multiply(\"t\", \"2\"));\n} At this point, we've learned to explicitly handle errors using combinators and early returns. While we generally want to avoid panicking, explicitly handling all of our errors is cumbersome. In the next section, we'll introduce ? for the cases where we simply need to unwrap without possibly inducing panic.","breadcrumbs":"Error handling » Result » Early returns » Early returns","id":"240","title":"Early returns"},"241":{"body":"Sometimes we just want the simplicity of unwrap without the possibility of a panic. Until now, unwrap has forced us to nest deeper and deeper when what we really wanted was to get the variable out . This is exactly the purpose of ?. Upon finding an Err, there are two valid actions to take: panic! which we already decided to try to avoid if possible return because an Err means it cannot be handled ? is almost [1] exactly equivalent to an unwrap which returns instead of panicking on Errs. Let's see how we can simplify the earlier example that used combinators: use std::num::ParseIntError; fn multiply(first_number_str: &str, second_number_str: &str) -> Result<i32, ParseIntError> { let first_number = first_number_str.parse::<i32>()?; let second_number = second_number_str.parse::<i32>()?; Ok(first_number * second_number)\n} fn print(result: Result<i32, ParseIntError>) { match result { Ok(n) => println!(\"n is {}\", n), Err(e) => println!(\"Error: {}\", e), }\n} fn main() { print(multiply(\"10\", \"2\")); print(multiply(\"t\", \"2\"));\n}","breadcrumbs":"Error handling » Result » Introducing ? » Introducing ?","id":"241","title":"Introducing ?"},"242":{"body":"Before there was ?, the same functionality was achieved with the try! macro. The ? operator is now recommended, but you may still find try! when looking at older code. The same multiply function from the previous example would look like this using try!: // To compile and run this example without errors, while using Cargo, change the value // of the `edition` field, in the `[package]` section of the `Cargo.toml` file, to \"2015\". use std::num::ParseIntError; fn multiply(first_number_str: &str, second_number_str: &str) -> Result<i32, ParseIntError> { let first_number = try!(first_number_str.parse::<i32>()); let second_number = try!(second_number_str.parse::<i32>()); Ok(first_number * second_number)\n} fn print(result: Result<i32, ParseIntError>) { match result { Ok(n) => println!(\"n is {}\", n), Err(e) => println!(\"Error: {}\", e), }\n} fn main() { print(multiply(\"10\", \"2\")); print(multiply(\"t\", \"2\"));\n} See re-enter ? for more details.","breadcrumbs":"Error handling » Result » Introducing ? » The try! macro","id":"242","title":"The try! macro"},"243":{"body":"The previous examples have always been very convenient; Results interact with other Results and Options interact with other Options. Sometimes an Option needs to interact with a Result, or a Result<T, Error1> needs to interact with a Result<T, Error2>. In those cases, we want to manage our different error types in a way that makes them composable and easy to interact with. In the following code, two instances of unwrap generate different error types. Vec::first returns an Option, while parse::<i32> returns a Result<i32, ParseIntError>: fn double_first(vec: Vec<&str>) -> i32 { let first = vec.first().unwrap(); // Generate error 1 2 * first.parse::<i32>().unwrap() // Generate error 2\n} fn main() { let numbers = vec![\"42\", \"93\", \"18\"]; let empty = vec![]; let strings = vec![\"tofu\", \"93\", \"18\"]; println!(\"The first doubled is {}\", double_first(numbers)); println!(\"The first doubled is {}\", double_first(empty)); // Error 1: the input vector is empty println!(\"The first doubled is {}\", double_first(strings)); // Error 2: the element doesn't parse to a number\n} Over the next sections, we'll see several strategies for handling these kind of problems.","breadcrumbs":"Error handling » Multiple error types » Multiple error types","id":"243","title":"Multiple error types"},"244":{"body":"The most basic way of handling mixed error types is to just embed them in each other. use std::num::ParseIntError; fn double_first(vec: Vec<&str>) -> Option<Result<i32, ParseIntError>> { vec.first().map(|first| { first.parse::<i32>().map(|n| 2 * n) })\n} fn main() { let numbers = vec![\"42\", \"93\", \"18\"]; let empty = vec![]; let strings = vec![\"tofu\", \"93\", \"18\"]; println!(\"The first doubled is {:?}\", double_first(numbers)); println!(\"The first doubled is {:?}\", double_first(empty)); // Error 1: the input vector is empty println!(\"The first doubled is {:?}\", double_first(strings)); // Error 2: the element doesn't parse to a number\n} There are times when we'll want to stop processing on errors (like with ? ) but keep going when the Option is None. A couple of combinators come in handy to swap the Result and Option. use std::num::ParseIntError; fn double_first(vec: Vec<&str>) -> Result<Option<i32>, ParseIntError> { let opt = vec.first().map(|first| { first.parse::<i32>().map(|n| 2 * n) }); opt.map_or(Ok(None), |r| r.map(Some))\n} fn main() { let numbers = vec![\"42\", \"93\", \"18\"]; let empty = vec![]; let strings = vec![\"tofu\", \"93\", \"18\"]; println!(\"The first doubled is {:?}\", double_first(numbers)); println!(\"The first doubled is {:?}\", double_first(empty)); println!(\"The first doubled is {:?}\", double_first(strings));\n}","breadcrumbs":"Error handling » Multiple error types » Pulling Results out of Options » Pulling Results out of Options","id":"244","title":"Pulling Results out of Options"},"245":{"body":"Sometimes it simplifies the code to mask all of the different errors with a single type of error. We'll show this with a custom error. Rust allows us to define our own error types. In general, a \"good\" error type: Represents different errors with the same type Presents nice error messages to the user Is easy to compare with other types Good: Err(EmptyVec) Bad: Err(\"Please use a vector with at least one element\".to_owned()) Can hold information about the error Good: Err(BadChar(c, position)) Bad: Err(\"+ cannot be used here\".to_owned()) Composes well with other errors use std::fmt; type Result<T> = std::result::Result<T, DoubleError>; // Define our error types. These may be customized for our error handling cases.\n// Now we will be able to write our own errors, defer to an underlying error\n// implementation, or do something in between.\n#[derive(Debug, Clone)]\nstruct DoubleError; // Generation of an error is completely separate from how it is displayed.\n// There's no need to be concerned about cluttering complex logic with the display style.\n//\n// Note that we don't store any extra info about the errors. This means we can't state\n// which string failed to parse without modifying our types to carry that information.\nimpl fmt::Display for DoubleError { fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result { write!(f, \"invalid first item to double\") }\n} fn double_first(vec: Vec<&str>) -> Result<i32> { vec.first() // Change the error to our new type. .ok_or(DoubleError) .and_then(|s| { s.parse::<i32>() // Update to the new error type here also. .map_err(|_| DoubleError) .map(|i| 2 * i) })\n} fn print(result: Result<i32>) { match result { Ok(n) => println!(\"The first doubled is {}\", n), Err(e) => println!(\"Error: {}\", e), }\n} fn main() { let numbers = vec![\"42\", \"93\", \"18\"]; let empty = vec![]; let strings = vec![\"tofu\", \"93\", \"18\"]; print(double_first(numbers)); print(double_first(empty)); print(double_first(strings));\n}","breadcrumbs":"Error handling » Multiple error types » Defining an error type » Defining an error type","id":"245","title":"Defining an error type"},"246":{"body":"A way to write simple code while preserving the original errors is to Box them. The drawback is that the underlying error type is only known at runtime and not statically determined . The stdlib helps in boxing our errors by having Box implement conversion from any type that implements the Error trait into the trait object Box<Error>, via From . use std::error;\nuse std::fmt; // Change the alias to use `Box<dyn error::Error>`.\ntype Result<T> = std::result::Result<T, Box<dyn error::Error>>; #[derive(Debug, Clone)]\nstruct EmptyVec; impl fmt::Display for EmptyVec { fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result { write!(f, \"invalid first item to double\") }\n} impl error::Error for EmptyVec {} fn double_first(vec: Vec<&str>) -> Result<i32> { vec.first() .ok_or_else(|| EmptyVec.into()) // Converts to Box .and_then(|s| { s.parse::<i32>() .map_err(|e| e.into()) // Converts to Box .map(|i| 2 * i) })\n} fn print(result: Result<i32>) { match result { Ok(n) => println!(\"The first doubled is {}\", n), Err(e) => println!(\"Error: {}\", e), }\n} fn main() { let numbers = vec![\"42\", \"93\", \"18\"]; let empty = vec![]; let strings = vec![\"tofu\", \"93\", \"18\"]; print(double_first(numbers)); print(double_first(empty)); print(double_first(strings));\n}","breadcrumbs":"Error handling » Multiple error types » Boxing errors » Boxing errors","id":"246","title":"Boxing errors"},"247":{"body":"Dynamic dispatch and Error trait","breadcrumbs":"Error handling » Multiple error types » Boxing errors » See also:","id":"247","title":"See also:"},"248":{"body":"Notice in the previous example that our immediate reaction to calling parse is to map the error from a library error into a boxed error: .and_then(|s| s.parse::<i32>()) .map_err(|e| e.into()) Since this is a simple and common operation, it would be convenient if it could be elided. Alas, because and_then is not sufficiently flexible, it cannot. However, we can instead use ?. ? was previously explained as either unwrap or return Err(err). This is only mostly true. It actually means unwrap or return Err(From::from(err)). Since From::from is a conversion utility between different types, this means that if you ? where the error is convertible to the return type, it will convert automatically. Here, we rewrite the previous example using ?. As a result, the map_err will go away when From::from is implemented for our error type: use std::error;\nuse std::fmt; // Change the alias to use `Box<dyn error::Error>`.\ntype Result<T> = std::result::Result<T, Box<dyn error::Error>>; #[derive(Debug)]\nstruct EmptyVec; impl fmt::Display for EmptyVec { fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result { write!(f, \"invalid first item to double\") }\n} impl error::Error for EmptyVec {} // The same structure as before but rather than chain all `Results`\n// and `Options` along, we `?` to get the inner value out immediately.\nfn double_first(vec: Vec<&str>) -> Result<i32> { let first = vec.first().ok_or(EmptyVec)?; let parsed = first.parse::<i32>()?; Ok(2 * parsed)\n} fn print(result: Result<i32>) { match result { Ok(n) => println!(\"The first doubled is {}\", n), Err(e) => println!(\"Error: {}\", e), }\n} fn main() { let numbers = vec![\"42\", \"93\", \"18\"]; let empty = vec![]; let strings = vec![\"tofu\", \"93\", \"18\"]; print(double_first(numbers)); print(double_first(empty)); print(double_first(strings));\n} This is actually fairly clean now. Compared with the original panic, it is very similar to replacing the unwrap calls with ? except that the return types are Result. As a result, they must be destructured at the top level.","breadcrumbs":"Error handling » Multiple error types » Other uses of ? » Other uses of ?","id":"248","title":"Other uses of ?"},"249":{"body":"From::from and ?","breadcrumbs":"Error handling » Multiple error types » Other uses of ? » See also:","id":"249","title":"See also:"},"25":{"body":"Recap : Add the fmt::Display trait to the Matrix struct in the above example, so that if you switch from printing the debug format {:?} to the display format {}, you see the following output: ( 1.1 1.2 )\n( 2.1 2.2 ) You may want to refer back to the example for print display . Add a transpose function using the reverse function as a template, which accepts a matrix as an argument, and returns a matrix in which two elements have been swapped. For example: println!(\"Matrix:\\n{}\", matrix);\nprintln!(\"Transpose:\\n{}\", transpose(matrix)); Results in the output: Matrix:\n( 1.1 1.2 )\n( 2.1 2.2 )\nTranspose:\n( 1.1 2.1 )\n( 1.2 2.2 )","breadcrumbs":"Primitives » Tuples » Activity","id":"25","title":"Activity"},"250":{"body":"An alternative to boxing errors is to wrap them in your own error type. use std::error;\nuse std::error::Error;\nuse std::num::ParseIntError;\nuse std::fmt; type Result<T> = std::result::Result<T, DoubleError>; #[derive(Debug)]\nenum DoubleError { EmptyVec, // We will defer to the parse error implementation for their error. // Supplying extra info requires adding more data to the type. Parse(ParseIntError),\n} impl fmt::Display for DoubleError { fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result { match *self { DoubleError::EmptyVec => write!(f, \"please use a vector with at least one element\"), // The wrapped error contains additional information and is available // via the source() method. DoubleError::Parse(..) => write!(f, \"the provided string could not be parsed as int\"), } }\n} impl error::Error for DoubleError { fn source(&self) -> Option<&(dyn error::Error + 'static)> { match *self { DoubleError::EmptyVec => None, // The cause is the underlying implementation error type. Is implicitly // cast to the trait object `&error::Error`. This works because the // underlying type already implements the `Error` trait. DoubleError::Parse(ref e) => Some(e), } }\n} // Implement the conversion from `ParseIntError` to `DoubleError`.\n// This will be automatically called by `?` if a `ParseIntError`\n// needs to be converted into a `DoubleError`.\nimpl From<ParseIntError> for DoubleError { fn from(err: ParseIntError) -> DoubleError { DoubleError::Parse(err) }\n} fn double_first(vec: Vec<&str>) -> Result<i32> { let first = vec.first().ok_or(DoubleError::EmptyVec)?; // Here we implicitly use the `ParseIntError` implementation of `From` (which // we defined above) in order to create a `DoubleError`. let parsed = first.parse::<i32>()?; Ok(2 * parsed)\n} fn print(result: Result<i32>) { match result { Ok(n) => println!(\"The first doubled is {}\", n), Err(e) => { println!(\"Error: {}\", e); if let Some(source) = e.source() { println!(\" Caused by: {}\", source); } }, }\n} fn main() { let numbers = vec![\"42\", \"93\", \"18\"]; let empty = vec![]; let strings = vec![\"tofu\", \"93\", \"18\"]; print(double_first(numbers)); print(double_first(empty)); print(double_first(strings));\n} This adds a bit more boilerplate for handling errors and might not be needed in all applications. There are some libraries that can take care of the boilerplate for you.","breadcrumbs":"Error handling » Multiple error types » Wrapping errors » Wrapping errors","id":"250","title":"Wrapping errors"},"251":{"body":"From::from and Enums","breadcrumbs":"Error handling » Multiple error types » Wrapping errors » See also:","id":"251","title":"See also:"},"252":{"body":"An Iter::map operation might fail, for example: fn main() { let strings = vec![\"tofu\", \"93\", \"18\"]; let numbers: Vec<_> = strings .into_iter() .map(|s| s.parse::<i32>()) .collect(); println!(\"Results: {:?}\", numbers);\n} Let's step through strategies for handling this.","breadcrumbs":"Error handling » Iterating over Results » Iterating over Results","id":"252","title":"Iterating over Results"},"253":{"body":"filter_map calls a function and filters out the results that are None. fn main() { let strings = vec![\"tofu\", \"93\", \"18\"]; let numbers: Vec<_> = strings .into_iter() .filter_map(|s| s.parse::<i32>().ok()) .collect(); println!(\"Results: {:?}\", numbers);\n}","breadcrumbs":"Error handling » Iterating over Results » Ignore the failed items with filter_map()","id":"253","title":"Ignore the failed items with filter_map()"},"254":{"body":"map_err calls a function with the error, so by adding that to the previous filter_map solution we can save them off to the side while iterating. fn main() { let strings = vec![\"42\", \"tofu\", \"93\", \"999\", \"18\"]; let mut errors = vec![]; let numbers: Vec<_> = strings .into_iter() .map(|s| s.parse::<u8>()) .filter_map(|r| r.map_err(|e| errors.push(e)).ok()) .collect(); println!(\"Numbers: {:?}\", numbers); println!(\"Errors: {:?}\", errors);\n}","breadcrumbs":"Error handling » Iterating over Results » Collect the failed items with map_err() and filter_map()","id":"254","title":"Collect the failed items with map_err() and filter_map()"},"255":{"body":"Result implements FromIterator so that a vector of results (Vec<Result<T, E>>) can be turned into a result with a vector (Result<Vec<T>, E>). Once an Result::Err is found, the iteration will terminate. fn main() { let strings = vec![\"tofu\", \"93\", \"18\"]; let numbers: Result<Vec<_>, _> = strings .into_iter() .map(|s| s.parse::<i32>()) .collect(); println!(\"Results: {:?}\", numbers);\n} This same technique can be used with Option.","breadcrumbs":"Error handling » Iterating over Results » Fail the entire operation with collect()","id":"255","title":"Fail the entire operation with collect()"},"256":{"body":"fn main() { let strings = vec![\"tofu\", \"93\", \"18\"]; let (numbers, errors): (Vec<_>, Vec<_>) = strings .into_iter() .map(|s| s.parse::<i32>()) .partition(Result::is_ok); println!(\"Numbers: {:?}\", numbers); println!(\"Errors: {:?}\", errors);\n} When you look at the results, you'll note that everything is still wrapped in Result. A little more boilerplate is needed for this. fn main() { let strings = vec![\"tofu\", \"93\", \"18\"]; let (numbers, errors): (Vec<_>, Vec<_>) = strings .into_iter() .map(|s| s.parse::<i32>()) .partition(Result::is_ok); let numbers: Vec<_> = numbers.into_iter().map(Result::unwrap).collect(); let errors: Vec<_> = errors.into_iter().map(Result::unwrap_err).collect(); println!(\"Numbers: {:?}\", numbers); println!(\"Errors: {:?}\", errors);\n}","breadcrumbs":"Error handling » Iterating over Results » Collect all valid values and failures with partition()","id":"256","title":"Collect all valid values and failures with partition()"},"257":{"body":"The std library provides many custom types which expands drastically on the primitives. Some of these include: growable Strings like: \"hello world\" growable vectors: [1, 2, 3] optional types: Option<i32> error handling types: Result<i32, i32> heap allocated pointers: Box<i32>","breadcrumbs":"Std library types » Std library types","id":"257","title":"Std library types"},"258":{"body":"primitives and the std library","breadcrumbs":"Std library types » See also:","id":"258","title":"See also:"},"259":{"body":"All values in Rust are stack allocated by default. Values can be boxed (allocated on the heap) by creating a Box<T>. A box is a smart pointer to a heap allocated value of type T. When a box goes out of scope, its destructor is called, the inner object is destroyed, and the memory on the heap is freed. Boxed values can be dereferenced using the * operator; this removes one layer of indirection. use std::mem; #[allow(dead_code)]\n#[derive(Debug, Clone, Copy)]\nstruct Point { x: f64, y: f64,\n} // A Rectangle can be specified by where its top left and bottom right // corners are in space\n#[allow(dead_code)]\nstruct Rectangle { top_left: Point, bottom_right: Point,\n} fn origin() -> Point { Point { x: 0.0, y: 0.0 }\n} fn boxed_origin() -> Box<Point> { // Allocate this point on the heap, and return a pointer to it Box::new(Point { x: 0.0, y: 0.0 })\n} fn main() { // (all the type annotations are superfluous) // Stack allocated variables let point: Point = origin(); let rectangle: Rectangle = Rectangle { top_left: origin(), bottom_right: Point { x: 3.0, y: -4.0 } }; // Heap allocated rectangle let boxed_rectangle: Box<Rectangle> = Box::new(Rectangle { top_left: origin(), bottom_right: Point { x: 3.0, y: -4.0 }, }); // The output of functions can be boxed let boxed_point: Box<Point> = Box::new(origin()); // Double indirection let box_in_a_box: Box<Box<Point>> = Box::new(boxed_origin()); println!(\"Point occupies {} bytes on the stack\", mem::size_of_val(&point)); println!(\"Rectangle occupies {} bytes on the stack\", mem::size_of_val(&rectangle)); // box size == pointer size println!(\"Boxed point occupies {} bytes on the stack\", mem::size_of_val(&boxed_point)); println!(\"Boxed rectangle occupies {} bytes on the stack\", mem::size_of_val(&boxed_rectangle)); println!(\"Boxed box occupies {} bytes on the stack\", mem::size_of_val(&box_in_a_box)); // Copy the data contained in `boxed_point` into `unboxed_point` let unboxed_point: Point = *boxed_point; println!(\"Unboxed point occupies {} bytes on the stack\", mem::size_of_val(&unboxed_point));\n}","breadcrumbs":"Std library types » Box, stack and heap » Box, stack and heap","id":"259","title":"Box, stack and heap"},"26":{"body":"An array is a collection of objects of the same type T, stored in contiguous memory. Arrays are created using brackets [], and their length, which is known at compile time, is part of their type signature [T; length]. Slices are similar to arrays, but their length is not known at compile time. Instead, a slice is a two-word object; the first word is a pointer to the data, the second word is the length of the slice. The word size is the same as usize, determined by the processor architecture, e.g. 64 bits on an x86-64. Slices can be used to borrow a section of an array and have the type signature &[T]. use std::mem; // This function borrows a slice.\nfn analyze_slice(slice: &[i32]) { println!(\"First element of the slice: {}\", slice[0]); println!(\"The slice has {} elements\", slice.len());\n} fn main() { // Fixed-size array (type signature is superfluous). let xs: [i32; 5] = [1, 2, 3, 4, 5]; // All elements can be initialized to the same value. let ys: [i32; 500] = [0; 500]; // Indexing starts at 0. println!(\"First element of the array: {}\", xs[0]); println!(\"Second element of the array: {}\", xs[1]); // `len` returns the count of elements in the array. println!(\"Number of elements in array: {}\", xs.len()); // Arrays are stack allocated. println!(\"Array occupies {} bytes\", mem::size_of_val(&xs)); // Arrays can be automatically borrowed as slices. println!(\"Borrow the whole array as a slice.\"); analyze_slice(&xs); // Slices can point to a section of an array. // They are of the form [starting_index..ending_index]. // `starting_index` is the first position in the slice. // `ending_index` is one more than the last position in the slice. println!(\"Borrow a section of the array as a slice.\"); analyze_slice(&ys[1 .. 4]); // Example of empty slice `&[]`: let empty_array: [u32; 0] = []; assert_eq!(&empty_array, &[]); assert_eq!(&empty_array, &[][..]); // Same but more verbose // Arrays can be safely accessed using `.get`, which returns an // `Option`. This can be matched as shown below, or used with // `.expect()` if you would like the program to exit with a nice // message instead of happily continue. for i in 0..xs.len() + 1 { // Oops, one element too far! match xs.get(i) { Some(xval) => println!(\"{}: {}\", i, xval), None => println!(\"Slow down! {} is too far!\", i), } } // Out of bound indexing on array causes compile time error. //println!(\"{}\", xs[5]); // Out of bound indexing on slice causes runtime error. //println!(\"{}\", xs[..][5]);\n}","breadcrumbs":"Primitives » Arrays and Slices » Arrays and Slices","id":"26","title":"Arrays and Slices"},"260":{"body":"Vectors are re-sizable arrays. Like slices, their size is not known at compile time, but they can grow or shrink at any time. A vector is represented using 3 parameters: pointer to the data length capacity The capacity indicates how much memory is reserved for the vector. The vector can grow as long as the length is smaller than the capacity. When this threshold needs to be surpassed, the vector is reallocated with a larger capacity. fn main() { // Iterators can be collected into vectors let collected_iterator: Vec<i32> = (0..10).collect(); println!(\"Collected (0..10) into: {:?}\", collected_iterator); // The `vec!` macro can be used to initialize a vector let mut xs = vec![1i32, 2, 3]; println!(\"Initial vector: {:?}\", xs); // Insert new element at the end of the vector println!(\"Push 4 into the vector\"); xs.push(4); println!(\"Vector: {:?}\", xs); // Error! Immutable vectors can't grow collected_iterator.push(0); // FIXME ^ Comment out this line // The `len` method yields the number of elements currently stored in a vector println!(\"Vector length: {}\", xs.len()); // Indexing is done using the square brackets (indexing starts at 0) println!(\"Second element: {}\", xs[1]); // `pop` removes the last element from the vector and returns it println!(\"Pop last element: {:?}\", xs.pop()); // Out of bounds indexing yields a panic println!(\"Fourth element: {}\", xs[3]); // FIXME ^ Comment out this line // `Vector`s can be easily iterated over println!(\"Contents of xs:\"); for x in xs.iter() { println!(\"> {}\", x); } // A `Vector` can also be iterated over while the iteration // count is enumerated in a separate variable (`i`) for (i, x) in xs.iter().enumerate() { println!(\"In position {} we have value {}\", i, x); } // Thanks to `iter_mut`, mutable `Vector`s can also be iterated // over in a way that allows modifying each value for x in xs.iter_mut() { *x *= 3; } println!(\"Updated vector: {:?}\", xs);\n} More Vec methods can be found under the std::vec module","breadcrumbs":"Std library types » Vectors » Vectors","id":"260","title":"Vectors"},"261":{"body":"There are two types of strings in Rust: String and &str. A String is stored as a vector of bytes (Vec<u8>), but guaranteed to always be a valid UTF-8 sequence. String is heap allocated, growable and not null terminated. &str is a slice (&[u8]) that always points to a valid UTF-8 sequence, and can be used to view into a String, just like &[T] is a view into Vec<T>. fn main() { // (all the type annotations are superfluous) // A reference to a string allocated in read only memory let pangram: &'static str = \"the quick brown fox jumps over the lazy dog\"; println!(\"Pangram: {}\", pangram); // Iterate over words in reverse, no new string is allocated println!(\"Words in reverse\"); for word in pangram.split_whitespace().rev() { println!(\"> {}\", word); } // Copy chars into a vector, sort and remove duplicates let mut chars: Vec<char> = pangram.chars().collect(); chars.sort(); chars.dedup(); // Create an empty and growable `String` let mut string = String::new(); for c in chars { // Insert a char at the end of string string.push(c); // Insert a string at the end of string string.push_str(\", \"); } // The trimmed string is a slice to the original string, hence no new // allocation is performed let chars_to_trim: &[char] = &[' ', ',']; let trimmed_str: &str = string.trim_matches(chars_to_trim); println!(\"Used characters: {}\", trimmed_str); // Heap allocate a string let alice = String::from(\"I like dogs\"); // Allocate new memory and store the modified string there let bob: String = alice.replace(\"dog\", \"cat\"); println!(\"Alice says: {}\", alice); println!(\"Bob says: {}\", bob);\n} More str/String methods can be found under the std::str and std::string modules","breadcrumbs":"Std library types » Strings » Strings","id":"261","title":"Strings"},"262":{"body":"There are multiple ways to write string literals with special characters in them. All result in a similar &str so it's best to use the form that is the most convenient to write. Similarly there are multiple ways to write byte string literals, which all result in &[u8; N]. Generally special characters are escaped with a backslash character: \\. This way you can add any character to your string, even unprintable ones and ones that you don't know how to type. If you want a literal backslash, escape it with another one: \\\\ String or character literal delimiters occurring within a literal must be escaped: \"\\\"\", '\\''. fn main() { // You can use escapes to write bytes by their hexadecimal values... let byte_escape = \"I'm writing \\x52\\x75\\x73\\x74!\"; println!(\"What are you doing\\x3F (\\\\x3F means ?) {}\", byte_escape); // ...or Unicode code points. let unicode_codepoint = \"\\u{211D}\"; let character_name = \"\\\"DOUBLE-STRUCK CAPITAL R\\\"\"; println!(\"Unicode character {} (U+211D) is called {}\", unicode_codepoint, character_name ); let long_string = \"String literals can span multiple lines. The linebreak and indentation here ->\\ <- can be escaped too!\"; println!(\"{}\", long_string);\n} Sometimes there are just too many characters that need to be escaped or it's just much more convenient to write a string out as-is. This is where raw string literals come into play. fn main() { let raw_str = r\"Escapes don't work here: \\x3F \\u{211D}\"; println!(\"{}\", raw_str); // If you need quotes in a raw string, add a pair of #s let quotes = r#\"And then I said: \"There is no escape!\"\"#; println!(\"{}\", quotes); // If you need \"# in your string, just use more #s in the delimiter. // You can use up to 65535 #s. let longer_delimiter = r###\"A string with \"# in it. And even \"##!\"###; println!(\"{}\", longer_delimiter);\n} Want a string that's not UTF-8? (Remember, str and String must be valid UTF-8). Or maybe you want an array of bytes that's mostly text? Byte strings to the rescue! use std::str; fn main() { // Note that this is not actually a `&str` let bytestring: &[u8; 21] = b\"this is a byte string\"; // Byte arrays don't have the `Display` trait, so printing them is a bit limited println!(\"A byte string: {:?}\", bytestring); // Byte strings can have byte escapes... let escaped = b\"\\x52\\x75\\x73\\x74 as bytes\"; // ...but no unicode escapes // let escaped = b\"\\u{211D} is not allowed\"; println!(\"Some escaped bytes: {:?}\", escaped); // Raw byte strings work just like raw strings let raw_bytestring = br\"\\u{211D} is not escaped here\"; println!(\"{:?}\", raw_bytestring); // Converting a byte array to `str` can fail if let Ok(my_str) = str::from_utf8(raw_bytestring) { println!(\"And the same as text: '{}'\", my_str); } let _quotes = br#\"You can also use \"fancier\" formatting, \\ like with normal raw strings\"#; // Byte strings don't have to be UTF-8 let shift_jis = b\"\\x82\\xe6\\x82\\xa8\\x82\\xb1\\x82\\xbb\"; // \"ようこそ\" in SHIFT-JIS // But then they can't always be converted to `str` match str::from_utf8(shift_jis) { Ok(my_str) => println!(\"Conversion successful: '{}'\", my_str), Err(e) => println!(\"Conversion failed: {:?}\", e), };\n} For conversions between character encodings check out the encoding crate. A more detailed listing of the ways to write string literals and escape characters is given in the 'Tokens' chapter of the Rust Reference.","breadcrumbs":"Std library types » Strings » Literals and escapes","id":"262","title":"Literals and escapes"},"263":{"body":"Sometimes it's desirable to catch the failure of some parts of a program instead of calling panic!; this can be accomplished using the Option enum. The Option<T> enum has two variants: None, to indicate failure or lack of value, and Some(value), a tuple struct that wraps a value with type T. // An integer division that doesn't `panic!`\nfn checked_division(dividend: i32, divisor: i32) -> Option<i32> { if divisor == 0 { // Failure is represented as the `None` variant None } else { // Result is wrapped in a `Some` variant Some(dividend / divisor) }\n} // This function handles a division that may not succeed\nfn try_division(dividend: i32, divisor: i32) { // `Option` values can be pattern matched, just like other enums match checked_division(dividend, divisor) { None => println!(\"{} / {} failed!\", dividend, divisor), Some(quotient) => { println!(\"{} / {} = {}\", dividend, divisor, quotient) }, }\n} fn main() { try_division(4, 2); try_division(1, 0); // Binding `None` to a variable needs to be type annotated let none: Option<i32> = None; let _equivalent_none = None::<i32>; let optional_float = Some(0f32); // Unwrapping a `Some` variant will extract the value wrapped. println!(\"{:?} unwraps to {:?}\", optional_float, optional_float.unwrap()); // Unwrapping a `None` variant will `panic!` println!(\"{:?} unwraps to {:?}\", none, none.unwrap());\n}","breadcrumbs":"Std library types » Option » Option","id":"263","title":"Option"},"264":{"body":"We've seen that the Option enum can be used as a return value from functions that may fail, where None can be returned to indicate failure. However, sometimes it is important to express why an operation failed. To do this we have the Result enum. The Result<T, E> enum has two variants: Ok(value) which indicates that the operation succeeded, and wraps the value returned by the operation. (value has type T) Err(why), which indicates that the operation failed, and wraps why, which (hopefully) explains the cause of the failure. (why has type E) mod checked { // Mathematical \"errors\" we want to catch #[derive(Debug)] pub enum MathError { DivisionByZero, NonPositiveLogarithm, NegativeSquareRoot, } pub type MathResult = Result<f64, MathError>; pub fn div(x: f64, y: f64) -> MathResult { if y == 0.0 { // This operation would `fail`, instead let's return the reason of // the failure wrapped in `Err` Err(MathError::DivisionByZero) } else { // This operation is valid, return the result wrapped in `Ok` Ok(x / y) } } pub fn sqrt(x: f64) -> MathResult { if x < 0.0 { Err(MathError::NegativeSquareRoot) } else { Ok(x.sqrt()) } } pub fn ln(x: f64) -> MathResult { if x <= 0.0 { Err(MathError::NonPositiveLogarithm) } else { Ok(x.ln()) } }\n} // `op(x, y)` === `sqrt(ln(x / y))`\nfn op(x: f64, y: f64) -> f64 { // This is a three level match pyramid! match checked::div(x, y) { Err(why) => panic!(\"{:?}\", why), Ok(ratio) => match checked::ln(ratio) { Err(why) => panic!(\"{:?}\", why), Ok(ln) => match checked::sqrt(ln) { Err(why) => panic!(\"{:?}\", why), Ok(sqrt) => sqrt, }, }, }\n} fn main() { // Will this fail? println!(\"{}\", op(1.0, 10.0));\n}","breadcrumbs":"Std library types » Result » Result","id":"264","title":"Result"},"265":{"body":"Chaining results using match can get pretty untidy; luckily, the ? operator can be used to make things pretty again. ? is used at the end of an expression returning a Result, and is equivalent to a match expression, where the Err(err) branch expands to an early return Err(From::from(err)), and the Ok(ok) branch expands to an ok expression. mod checked { #[derive(Debug)] enum MathError { DivisionByZero, NonPositiveLogarithm, NegativeSquareRoot, } type MathResult = Result<f64, MathError>; fn div(x: f64, y: f64) -> MathResult { if y == 0.0 { Err(MathError::DivisionByZero) } else { Ok(x / y) } } fn sqrt(x: f64) -> MathResult { if x < 0.0 { Err(MathError::NegativeSquareRoot) } else { Ok(x.sqrt()) } } fn ln(x: f64) -> MathResult { if x <= 0.0 { Err(MathError::NonPositiveLogarithm) } else { Ok(x.ln()) } } // Intermediate function fn op_(x: f64, y: f64) -> MathResult { // if `div` \"fails\", then `DivisionByZero` will be `return`ed let ratio = div(x, y)?; // if `ln` \"fails\", then `NonPositiveLogarithm` will be `return`ed let ln = ln(ratio)?; sqrt(ln) } pub fn op(x: f64, y: f64) { match op_(x, y) { Err(why) => panic!(\"{}\", match why { MathError::NonPositiveLogarithm => \"logarithm of non-positive number\", MathError::DivisionByZero => \"division by zero\", MathError::NegativeSquareRoot => \"square root of negative number\", }), Ok(value) => println!(\"{}\", value), } }\n} fn main() { checked::op(1.0, 10.0);\n} Be sure to check the documentation , as there are many methods to map/compose Result.","breadcrumbs":"Std library types » Result » ? » ?","id":"265","title":"?"},"266":{"body":"The panic! macro can be used to generate a panic and start unwinding its stack. While unwinding, the runtime will take care of freeing all the resources owned by the thread by calling the destructor of all its objects. Since we are dealing with programs with only one thread, panic! will cause the program to report the panic message and exit. // Re-implementation of integer division (/)\nfn division(dividend: i32, divisor: i32) -> i32 { if divisor == 0 { // Division by zero triggers a panic panic!(\"division by zero\"); } else { dividend / divisor }\n} // The `main` task\nfn main() { // Heap allocated integer let _x = Box::new(0i32); // This operation will trigger a task failure division(3, 0); println!(\"This point won't be reached!\"); // `_x` should get destroyed at this point\n} Let's check that panic! doesn't leak memory. $ rustc panic.rs && valgrind ./panic\n==4401== Memcheck, a memory error detector\n==4401== Copyright (C) 2002-2013, and GNU GPL'd, by Julian Seward et al.\n==4401== Using Valgrind-3.10.0.SVN and LibVEX; rerun with -h for copyright info\n==4401== Command: ./panic\n==4401== thread '<main>' panicked at 'division by zero', panic.rs:5\n==4401== ==4401== HEAP SUMMARY:\n==4401== in use at exit: 0 bytes in 0 blocks\n==4401== total heap usage: 18 allocs, 18 frees, 1,648 bytes allocated\n==4401== ==4401== All heap blocks were freed -- no leaks are possible\n==4401== ==4401== For counts of detected and suppressed errors, rerun with: -v\n==4401== ERROR SUMMARY: 0 errors from 0 contexts (suppressed: 0 from 0)","breadcrumbs":"Std library types » panic! » panic!","id":"266","title":"panic!"},"267":{"body":"Where vectors store values by an integer index, HashMaps store values by key. HashMap keys can be booleans, integers, strings, or any other type that implements the Eq and Hash traits. More on this in the next section. Like vectors, HashMaps are growable, but HashMaps can also shrink themselves when they have excess space. You can create a HashMap with a certain starting capacity using HashMap::with_capacity(uint), or use HashMap::new() to get a HashMap with a default initial capacity (recommended). use std::collections::HashMap; fn call(number: &str) -> &str { match number { \"798-1364\" => \"We're sorry, the call cannot be completed as dialed. Please hang up and try again.\", \"645-7689\" => \"Hello, this is Mr. Awesome's Pizza. My name is Fred. What can I get for you today?\", _ => \"Hi! Who is this again?\" }\n} fn main() { let mut contacts = HashMap::new(); contacts.insert(\"Daniel\", \"798-1364\"); contacts.insert(\"Ashley\", \"645-7689\"); contacts.insert(\"Katie\", \"435-8291\"); contacts.insert(\"Robert\", \"956-1745\"); // Takes a reference and returns Option<&V> match contacts.get(&\"Daniel\") { Some(&number) => println!(\"Calling Daniel: {}\", call(number)), _ => println!(\"Don't have Daniel's number.\"), } // `HashMap::insert()` returns `None` // if the inserted value is new, `Some(value)` otherwise contacts.insert(\"Daniel\", \"164-6743\"); match contacts.get(&\"Ashley\") { Some(&number) => println!(\"Calling Ashley: {}\", call(number)), _ => println!(\"Don't have Ashley's number.\"), } contacts.remove(&\"Ashley\"); // `HashMap::iter()` returns an iterator that yields // (&'a key, &'a value) pairs in arbitrary order. for (contact, &number) in contacts.iter() { println!(\"Calling {}: {}\", contact, call(number)); }\n} For more information on how hashing and hash maps (sometimes called hash tables) work, have a look at Hash Table Wikipedia","breadcrumbs":"Std library types » HashMap » HashMap","id":"267","title":"HashMap"},"268":{"body":"Any type that implements the Eq and Hash traits can be a key in HashMap. This includes: bool (though not very useful since there are only two possible keys) int, uint, and all variations thereof String and &str (protip: you can have a HashMap keyed by String and call .get() with an &str) Note that f32 and f64 do not implement Hash, likely because floating-point precision errors would make using them as hashmap keys horribly error-prone. All collection classes implement Eq and Hash if their contained type also respectively implements Eq and Hash. For example, Vec<T> will implement Hash if T implements Hash. You can easily implement Eq and Hash for a custom type with just one line: #[derive(PartialEq, Eq, Hash)] The compiler will do the rest. If you want more control over the details, you can implement Eq and/or Hash yourself. This guide will not cover the specifics of implementing Hash. To play around with using a struct in HashMap, let's try making a very simple user logon system: use std::collections::HashMap; // Eq requires that you derive PartialEq on the type.\n#[derive(PartialEq, Eq, Hash)]\nstruct Account<'a>{ username: &'a str, password: &'a str,\n} struct AccountInfo<'a>{ name: &'a str, email: &'a str,\n} type Accounts<'a> = HashMap<Account<'a>, AccountInfo<'a>>; fn try_logon<'a>(accounts: &Accounts<'a>, username: &'a str, password: &'a str){ println!(\"Username: {}\", username); println!(\"Password: {}\", password); println!(\"Attempting logon...\"); let logon = Account { username, password, }; match accounts.get(&logon) { Some(account_info) => { println!(\"Successful logon!\"); println!(\"Name: {}\", account_info.name); println!(\"Email: {}\", account_info.email); }, _ => println!(\"Login failed!\"), }\n} fn main(){ let mut accounts: Accounts = HashMap::new(); let account = Account { username: \"j.everyman\", password: \"password123\", }; let account_info = AccountInfo { name: \"John Everyman\", email: \"j.everyman@email.com\", }; accounts.insert(account, account_info); try_logon(&accounts, \"j.everyman\", \"psasword123\"); try_logon(&accounts, \"j.everyman\", \"password123\");\n}","breadcrumbs":"Std library types » HashMap » Alternate/custom key types » Alternate/custom key types","id":"268","title":"Alternate/custom key types"},"269":{"body":"Consider a HashSet as a HashMap where we just care about the keys ( HashSet<T> is, in actuality, just a wrapper around HashMap<T, ()>). \"What's the point of that?\" you ask. \"I could just store the keys in a Vec.\" A HashSet's unique feature is that it is guaranteed to not have duplicate elements. That's the contract that any set collection fulfills. HashSet is just one implementation. (see also: BTreeSet ) If you insert a value that is already present in the HashSet, (i.e. the new value is equal to the existing and they both have the same hash), then the new value will replace the old. This is great for when you never want more than one of something, or when you want to know if you've already got something. But sets can do more than that. Sets have 4 primary operations (all of the following calls return an iterator): union: get all the unique elements in both sets. difference: get all the elements that are in the first set but not the second. intersection: get all the elements that are only in both sets. symmetric_difference: get all the elements that are in one set or the other, but not both. Try all of these in the following example: use std::collections::HashSet; fn main() { let mut a: HashSet<i32> = vec![1i32, 2, 3].into_iter().collect(); let mut b: HashSet<i32> = vec![2i32, 3, 4].into_iter().collect(); assert!(a.insert(4)); assert!(a.contains(&4)); // `HashSet::insert()` returns false if // there was a value already present. assert!(b.insert(4), \"Value 4 is already in set B!\"); // FIXME ^ Comment out this line b.insert(5); // If a collection's element type implements `Debug`, // then the collection implements `Debug`. // It usually prints its elements in the format `[elem1, elem2, ...]` println!(\"A: {:?}\", a); println!(\"B: {:?}\", b); // Print [1, 2, 3, 4, 5] in arbitrary order println!(\"Union: {:?}\", a.union(&b).collect::<Vec<&i32>>()); // This should print [1] println!(\"Difference: {:?}\", a.difference(&b).collect::<Vec<&i32>>()); // Print [2, 3, 4] in arbitrary order. println!(\"Intersection: {:?}\", a.intersection(&b).collect::<Vec<&i32>>()); // Print [1, 5] println!(\"Symmetric Difference: {:?}\", a.symmetric_difference(&b).collect::<Vec<&i32>>());\n} (Examples are adapted from the documentation. )","breadcrumbs":"Std library types » HashMap » HashSet » HashSet","id":"269","title":"HashSet"},"27":{"body":"Rust custom data types are formed mainly through the two keywords: struct: define a structure enum: define an enumeration Constants can also be created via the const and static keywords.","breadcrumbs":"Custom Types » Custom Types","id":"27","title":"Custom Types"},"270":{"body":"When multiple ownership is needed, Rc(Reference Counting) can be used. Rc keeps track of the number of the references which means the number of owners of the value wrapped inside an Rc. Reference count of an Rc increases by 1 whenever an Rc is cloned, and decreases by 1 whenever one cloned Rc is dropped out of the scope. When an Rc's reference count becomes zero (which means there are no remaining owners), both the Rc and the value are all dropped. Cloning an Rc never performs a deep copy. Cloning creates just another pointer to the wrapped value, and increments the count. use std::rc::Rc; fn main() { let rc_examples = \"Rc examples\".to_string(); { println!(\"--- rc_a is created ---\"); let rc_a: Rc<String> = Rc::new(rc_examples); println!(\"Reference Count of rc_a: {}\", Rc::strong_count(&rc_a)); { println!(\"--- rc_a is cloned to rc_b ---\"); let rc_b: Rc<String> = Rc::clone(&rc_a); println!(\"Reference Count of rc_b: {}\", Rc::strong_count(&rc_b)); println!(\"Reference Count of rc_a: {}\", Rc::strong_count(&rc_a)); // Two `Rc`s are equal if their inner values are equal println!(\"rc_a and rc_b are equal: {}\", rc_a.eq(&rc_b)); // We can use methods of a value directly println!(\"Length of the value inside rc_a: {}\", rc_a.len()); println!(\"Value of rc_b: {}\", rc_b); println!(\"--- rc_b is dropped out of scope ---\"); } println!(\"Reference Count of rc_a: {}\", Rc::strong_count(&rc_a)); println!(\"--- rc_a is dropped out of scope ---\"); } // Error! `rc_examples` already moved into `rc_a` // And when `rc_a` is dropped, `rc_examples` is dropped together // println!(\"rc_examples: {}\", rc_examples); // TODO ^ Try uncommenting this line\n}","breadcrumbs":"Std library types » Rc » Rc","id":"270","title":"Rc"},"271":{"body":"std::rc and std::sync::arc .","breadcrumbs":"Std library types » Rc » See also:","id":"271","title":"See also:"},"272":{"body":"When shared ownership between threads is needed, Arc(Atomically Reference Counted) can be used. This struct, via the Clone implementation can create a reference pointer for the location of a value in the memory heap while increasing the reference counter. As it shares ownership between threads, when the last reference pointer to a value is out of scope, the variable is dropped. use std::time::Duration;\nuse std::sync::Arc;\nuse std::thread; fn main() { // This variable declaration is where its value is specified. let apple = Arc::new(\"the same apple\"); for _ in 0..10 { // Here there is no value specification as it is a pointer to a // reference in the memory heap. let apple = Arc::clone(&apple); thread::spawn(move || { // As Arc was used, threads can be spawned using the value allocated // in the Arc variable pointer's location. println!(\"{:?}\", apple); }); } // Make sure all Arc instances are printed from spawned threads. thread::sleep(Duration::from_secs(1));\n}","breadcrumbs":"Std library types » Arc » Arc","id":"272","title":"Arc"},"273":{"body":"Many other types are provided by the std library to support things such as: Threads Channels File I/O These expand beyond what the primitives provide.","breadcrumbs":"Std misc » Std misc","id":"273","title":"Std misc"},"274":{"body":"primitives and the std library","breadcrumbs":"Std misc » See also:","id":"274","title":"See also:"},"275":{"body":"Rust provides a mechanism for spawning native OS threads via the spawn function, the argument of this function is a moving closure. use std::thread; const NTHREADS: u32 = 10; // This is the `main` thread\nfn main() { // Make a vector to hold the children which are spawned. let mut children = vec![]; for i in 0..NTHREADS { // Spin up another thread children.push(thread::spawn(move || { println!(\"this is thread number {}\", i); })); } for child in children { // Wait for the thread to finish. Returns a result. let _ = child.join(); }\n} These threads will be scheduled by the OS.","breadcrumbs":"Std misc » Threads » Threads","id":"275","title":"Threads"},"276":{"body":"Rust makes it very easy to parallelise data processing, without many of the headaches traditionally associated with such an attempt. The standard library provides great threading primitives out of the box. These, combined with Rust's concept of Ownership and aliasing rules, automatically prevent data races. The aliasing rules (one writable reference XOR many readable references) automatically prevent you from manipulating state that is visible to other threads. (Where synchronisation is needed, there are synchronisation primitives like Mutexes or Channels.) In this example, we will calculate the sum of all digits in a block of numbers. We will do this by parcelling out chunks of the block into different threads. Each thread will sum its tiny block of digits, and subsequently we will sum the intermediate sums produced by each thread. Note that, although we're passing references across thread boundaries, Rust understands that we're only passing read-only references, and that thus no unsafety or data races can occur. Also because the references we're passing have 'static lifetimes, Rust understands that our data won't be destroyed while these threads are still running. (When you need to share non-static data between threads, you can use a smart pointer like Arc to keep the data alive and avoid non-static lifetimes.) use std::thread; // This is the `main` thread\nfn main() { // This is our data to process. // We will calculate the sum of all digits via a threaded map-reduce algorithm. // Each whitespace separated chunk will be handled in a different thread. // // TODO: see what happens to the output if you insert spaces! let data = \"86967897737416471853297327050364959\n11861322575564723963297542624962850\n70856234701860851907960690014725639\n38397966707106094172783238747669219\n52380795257888236525459303330302837\n58495327135744041048897885734297812\n69920216438980873548808413720956532\n16278424637452589860345374828574668\"; // Make a vector to hold the child-threads which we will spawn. let mut children = vec![]; /************************************************************************* * \"Map\" phase * * Divide our data into segments, and apply initial processing ************************************************************************/ // split our data into segments for individual calculation // each chunk will be a reference (&str) into the actual data let chunked_data = data.split_whitespace(); // Iterate over the data segments. // .enumerate() adds the current loop index to whatever is iterated // the resulting tuple \"(index, element)\" is then immediately // \"destructured\" into two variables, \"i\" and \"data_segment\" with a // \"destructuring assignment\" for (i, data_segment) in chunked_data.enumerate() { println!(\"data segment {} is \\\"{}\\\"\", i, data_segment); // Process each data segment in a separate thread // // spawn() returns a handle to the new thread, // which we MUST keep to access the returned value // // 'move || -> u32' is syntax for a closure that: // * takes no arguments ('||') // * takes ownership of its captured variables ('move') and // * returns an unsigned 32-bit integer ('-> u32') // // Rust is smart enough to infer the '-> u32' from // the closure itself so we could have left that out. // // TODO: try removing the 'move' and see what happens children.push(thread::spawn(move || -> u32 { // Calculate the intermediate sum of this segment: let result = data_segment // iterate over the characters of our segment.. .chars() // .. convert text-characters to their number value.. .map(|c| c.to_digit(10).expect(\"should be a digit\")) // .. and sum the resulting iterator of numbers .sum(); // println! locks stdout, so no text-interleaving occurs println!(\"processed segment {}, result={}\", i, result); // \"return\" not needed, because Rust is an \"expression language\", the // last evaluated expression in each block is automatically its value. result })); } /************************************************************************* * \"Reduce\" phase * * Collect our intermediate results, and combine them into a final result ************************************************************************/ // combine each thread's intermediate results into a single final sum. // // we use the \"turbofish\" ::<> to provide sum() with a type hint. // // TODO: try without the turbofish, by instead explicitly // specifying the type of final_result let final_result = children.into_iter().map(|c| c.join().unwrap()).sum::<u32>(); println!(\"Final sum result: {}\", final_result);\n}","breadcrumbs":"Std misc » Threads » Testcase: map-reduce » Testcase: map-reduce","id":"276","title":"Testcase: map-reduce"},"277":{"body":"It is not wise to let our number of threads depend on user inputted data. What if the user decides to insert a lot of spaces? Do we really want to spawn 2,000 threads? Modify the program so that the data is always chunked into a limited number of chunks, defined by a static constant at the beginning of the program.","breadcrumbs":"Std misc » Threads » Testcase: map-reduce » Assignments","id":"277","title":"Assignments"},"278":{"body":"Threads vectors and iterators closures , move semantics and move closures destructuring assignments turbofish notation to help type inference unwrap vs. expect enumerate","breadcrumbs":"Std misc » Threads » Testcase: map-reduce » See also:","id":"278","title":"See also:"},"279":{"body":"Rust provides asynchronous channels for communication between threads. Channels allow a unidirectional flow of information between two end-points: the Sender and the Receiver. use std::sync::mpsc::{Sender, Receiver};\nuse std::sync::mpsc;\nuse std::thread; static NTHREADS: i32 = 3; fn main() { // Channels have two endpoints: the `Sender<T>` and the `Receiver<T>`, // where `T` is the type of the message to be transferred // (type annotation is superfluous) let (tx, rx): (Sender<i32>, Receiver<i32>) = mpsc::channel(); let mut children = Vec::new(); for id in 0..NTHREADS { // The sender endpoint can be copied let thread_tx = tx.clone(); // Each thread will send its id via the channel let child = thread::spawn(move || { // The thread takes ownership over `thread_tx` // Each thread queues a message in the channel thread_tx.send(id).unwrap(); // Sending is a non-blocking operation, the thread will continue // immediately after sending its message println!(\"thread {} finished\", id); }); children.push(child); } // Here, all the messages are collected let mut ids = Vec::with_capacity(NTHREADS as usize); for _ in 0..NTHREADS { // The `recv` method picks a message from the channel // `recv` will block the current thread if there are no messages available ids.push(rx.recv()); } // Wait for the threads to complete any remaining work for child in children { child.join().expect(\"oops! the child thread panicked\"); } // Show the order in which the messages were sent println!(\"{:?}\", ids);\n}","breadcrumbs":"Std misc » Channels » Channels","id":"279","title":"Channels"},"28":{"body":"There are three types of structures (\"structs\") that can be created using the struct keyword: Tuple structs, which are, basically, named tuples. The classic C structs Unit structs, which are field-less, are useful for generics. // An attribute to hide warnings for unused code.\n#![allow(dead_code)] #[derive(Debug)]\nstruct Person { name: String, age: u8,\n} // A unit struct\nstruct Unit; // A tuple struct\nstruct Pair(i32, f32); // A struct with two fields\nstruct Point { x: f32, y: f32,\n} // Structs can be reused as fields of another struct\nstruct Rectangle { // A rectangle can be specified by where the top left and bottom right // corners are in space. top_left: Point, bottom_right: Point,\n} fn main() { // Create struct with field init shorthand let name = String::from(\"Peter\"); let age = 27; let peter = Person { name, age }; // Print debug struct println!(\"{:?}\", peter); // Instantiate a `Point` let point: Point = Point { x: 10.3, y: 0.4 }; // Access the fields of the point println!(\"point coordinates: ({}, {})\", point.x, point.y); // Make a new point by using struct update syntax to use the fields of our // other one let bottom_right = Point { x: 5.2, ..point }; // `bottom_right.y` will be the same as `point.y` because we used that field // from `point` println!(\"second point: ({}, {})\", bottom_right.x, bottom_right.y); // Destructure the point using a `let` binding let Point { x: left_edge, y: top_edge } = point; let _rectangle = Rectangle { // struct instantiation is an expression too top_left: Point { x: left_edge, y: top_edge }, bottom_right: bottom_right, }; // Instantiate a unit struct let _unit = Unit; // Instantiate a tuple struct let pair = Pair(1, 0.1); // Access the fields of a tuple struct println!(\"pair contains {:?} and {:?}\", pair.0, pair.1); // Destructure a tuple struct let Pair(integer, decimal) = pair; println!(\"pair contains {:?} and {:?}\", integer, decimal);\n}","breadcrumbs":"Custom Types » Structures » Structures","id":"28","title":"Structures"},"280":{"body":"The Path struct represents file paths in the underlying filesystem. There are two flavors of Path: posix::Path, for UNIX-like systems, and windows::Path, for Windows. The prelude exports the appropriate platform-specific Path variant. A Path can be created from an OsStr, and provides several methods to get information from the file/directory the path points to. A Path is immutable. The owned version of Path is PathBuf. The relation between Path and PathBuf is similar to that of str and String: a PathBuf can be mutated in-place, and can be dereferenced to a Path. Note that a Path is not internally represented as an UTF-8 string, but instead is stored as an OsString. Therefore, converting a Path to a &str is not free and may fail (an Option is returned). However, a Path can be freely converted to an OsString or &OsStr using into_os_string and as_os_str, respectively. use std::path::Path; fn main() { // Create a `Path` from an `&'static str` let path = Path::new(\".\"); // The `display` method returns a `Display`able structure let _display = path.display(); // `join` merges a path with a byte container using the OS specific // separator, and returns a `PathBuf` let mut new_path = path.join(\"a\").join(\"b\"); // `push` extends the `PathBuf` with a `&Path` new_path.push(\"c\"); new_path.push(\"myfile.tar.gz\"); // `set_file_name` updates the file name of the `PathBuf` new_path.set_file_name(\"package.tgz\"); // Convert the `PathBuf` into a string slice match new_path.to_str() { None => panic!(\"new path is not a valid UTF-8 sequence\"), Some(s) => println!(\"new path is {}\", s), }\n} Be sure to check at other Path methods (posix::Path or windows::Path) and the Metadata struct.","breadcrumbs":"Std misc » Path » Path","id":"280","title":"Path"},"281":{"body":"OsStr and Metadata .","breadcrumbs":"Std misc » Path » See also:","id":"281","title":"See also:"},"282":{"body":"The File struct represents a file that has been opened (it wraps a file descriptor), and gives read and/or write access to the underlying file. Since many things can go wrong when doing file I/O, all the File methods return the io::Result<T> type, which is an alias for Result<T, io::Error>. This makes the failure of all I/O operations explicit . Thanks to this, the programmer can see all the failure paths, and is encouraged to handle them in a proactive manner.","breadcrumbs":"Std misc » File I/O » File I/O","id":"282","title":"File I/O"},"283":{"body":"The open function can be used to open a file in read-only mode. A File owns a resource, the file descriptor and takes care of closing the file when it is droped. use std::fs::File;\nuse std::io::prelude::*;\nuse std::path::Path; fn main() { // Create a path to the desired file let path = Path::new(\"hello.txt\"); let display = path.display(); // Open the path in read-only mode, returns `io::Result<File>` let mut file = match File::open(&path) { Err(why) => panic!(\"couldn't open {}: {}\", display, why), Ok(file) => file, }; // Read the file contents into a string, returns `io::Result<usize>` let mut s = String::new(); match file.read_to_string(&mut s) { Err(why) => panic!(\"couldn't read {}: {}\", display, why), Ok(_) => print!(\"{} contains:\\n{}\", display, s), } // `file` goes out of scope, and the \"hello.txt\" file gets closed\n} Here's the expected successful output: $ echo \"Hello World!\" > hello.txt\n$ rustc open.rs && ./open\nhello.txt contains:\nHello World! (You are encouraged to test the previous example under different failure conditions: hello.txt doesn't exist, or hello.txt is not readable, etc.)","breadcrumbs":"Std misc » File I/O » open » open","id":"283","title":"open"},"284":{"body":"The create function opens a file in write-only mode. If the file already existed, the old content is destroyed. Otherwise, a new file is created. static LOREM_IPSUM: &str = \"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod\ntempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,\nquis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo\nconsequat. Duis aute irure dolor in reprehenderit in voluptate velit esse\ncillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non\nproident, sunt in culpa qui officia deserunt mollit anim id est laborum.\n\"; use std::fs::File;\nuse std::io::prelude::*;\nuse std::path::Path; fn main() { let path = Path::new(\"lorem_ipsum.txt\"); let display = path.display(); // Open a file in write-only mode, returns `io::Result<File>` let mut file = match File::create(&path) { Err(why) => panic!(\"couldn't create {}: {}\", display, why), Ok(file) => file, }; // Write the `LOREM_IPSUM` string to `file`, returns `io::Result<()>` match file.write_all(LOREM_IPSUM.as_bytes()) { Err(why) => panic!(\"couldn't write to {}: {}\", display, why), Ok(_) => println!(\"successfully wrote to {}\", display), }\n} Here's the expected successful output: $ rustc create.rs && ./create\nsuccessfully wrote to lorem_ipsum.txt\n$ cat lorem_ipsum.txt\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod\ntempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,\nquis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo\nconsequat. Duis aute irure dolor in reprehenderit in voluptate velit esse\ncillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non\nproident, sunt in culpa qui officia deserunt mollit anim id est laborum. (As in the previous example, you are encouraged to test this example under failure conditions.) The OpenOptions struct can be used to configure how a file is opened.","breadcrumbs":"Std misc » File I/O » create » create","id":"284","title":"create"},"285":{"body":"","breadcrumbs":"Std misc » File I/O » read_lines » read_lines","id":"285","title":"read_lines"},"286":{"body":"This might be a reasonable first attempt for a beginner's first implementation for reading lines from a file. use std::fs::read_to_string; fn read_lines(filename: &str) -> Vec<String> { let mut result = Vec::new(); for line in read_to_string(filename).unwrap().lines() { result.push(line.to_string()) } result\n} Since the method lines() returns an iterator over the lines in the file, we can also perform a map inline and collect the results, yielding a more concise and fluent expression. use std::fs::read_to_string; fn read_lines(filename: &str) -> Vec<String> { read_to_string(filename) .unwrap() // panic on possible file-reading errors .lines() // split the string into an iterator of string slices .map(String::from) // make each slice into a string .collect() // gather them together into a vector\n} Note that in both examples above, we must convert the &str reference returned from lines() to the owned type String, using .to_string() and String::from respectively.","breadcrumbs":"Std misc » File I/O » read_lines » A naive approach","id":"286","title":"A naive approach"},"287":{"body":"Here we pass ownership of the open File to a BufReader struct. BufReader uses an internal buffer to reduce intermediate allocations. We also update read_lines to return an iterator instead of allocating new String objects in memory for each line. use std::fs::File;\nuse std::io::{self, BufRead};\nuse std::path::Path; fn main() { // File hosts.txt must exist in the current path if let Ok(lines) = read_lines(\"./hosts.txt\") { // Consumes the iterator, returns an (Optional) String for line in lines.flatten() { println!(\"{}\", line); } }\n} // The output is wrapped in a Result to allow matching on errors.\n// Returns an Iterator to the Reader of the lines of the file.\nfn read_lines<P>(filename: P) -> io::Result<io::Lines<io::BufReader<File>>>\nwhere P: AsRef<Path>, { let file = File::open(filename)?; Ok(io::BufReader::new(file).lines())\n} Running this program simply prints the lines individually. $ echo -e \"127.0.0.1\\n192.168.0.1\\n\" > hosts.txt\n$ rustc read_lines.rs && ./read_lines\n127.0.0.1\n192.168.0.1 (Note that since File::open expects a generic AsRef<Path> as argument, we define our generic read_lines() method with the same generic constraint, using the where keyword.) This process is more efficient than creating a String in memory with all of the file's contents. This can especially cause performance issues when working with larger files.","breadcrumbs":"Std misc » File I/O » read_lines » A more efficient approach","id":"287","title":"A more efficient approach"},"288":{"body":"The process::Output struct represents the output of a finished child process, and the process::Command struct is a process builder. use std::process::Command; fn main() { let output = Command::new(\"rustc\") .arg(\"--version\") .output().unwrap_or_else(|e| { panic!(\"failed to execute process: {}\", e) }); if output.status.success() { let s = String::from_utf8_lossy(&output.stdout); print!(\"rustc succeeded and stdout was:\\n{}\", s); } else { let s = String::from_utf8_lossy(&output.stderr); print!(\"rustc failed and stderr was:\\n{}\", s); }\n} (You are encouraged to try the previous example with an incorrect flag passed to rustc)","breadcrumbs":"Std misc » Child processes » Child processes","id":"288","title":"Child processes"},"289":{"body":"The std::Child struct represents a running child process, and exposes the stdin, stdout and stderr handles for interaction with the underlying process via pipes. use std::io::prelude::*;\nuse std::process::Stdio; static PANGRAM: &'static str =\n\"the quick brown fox jumped over the lazy dog\\n\"; fn main() { // Spawn the `wc` command let mut cmd = if cfg!(target_family = \"windows\") { let mut cmd = Command::new(\"powershell\"); cmd.arg(\"-Command\").arg(\"$input | Measure-Object -Line -Word -Character\"); cmd } else { Command::new(\"wc\") }; let process = match cmd .stdin(Stdio::piped()) .stdout(Stdio::piped()) .spawn() { Err(why) => panic!(\"couldn't spawn wc: {}\", why), Ok(process) => process, }; // Write a string to the `stdin` of `wc`. // // `stdin` has type `Option<ChildStdin>`, but since we know this instance // must have one, we can directly `unwrap` it. match process.stdin.unwrap().write_all(PANGRAM.as_bytes()) { Err(why) => panic!(\"couldn't write to wc stdin: {}\", why), Ok(_) => println!(\"sent pangram to wc\"), } // Because `stdin` does not live after the above calls, it is `drop`ed, // and the pipe is closed. // // This is very important, otherwise `wc` wouldn't start processing the // input we just sent. // The `stdout` field also has type `Option<ChildStdout>` so must be unwrapped. let mut s = String::new(); match process.stdout.unwrap().read_to_string(&mut s) { Err(why) => panic!(\"couldn't read wc stdout: {}\", why), Ok(_) => print!(\"wc responded with:\\n{}\", s), }\n}","breadcrumbs":"Std misc » Child processes » Pipes » Pipes","id":"289","title":"Pipes"},"29":{"body":"Add a function rect_area which calculates the area of a Rectangle (try using nested destructuring). Add a function square which takes a Point and a f32 as arguments, and returns a Rectangle with its top left corner on the point, and a width and height corresponding to the f32.","breadcrumbs":"Custom Types » Structures » Activity","id":"29","title":"Activity"},"290":{"body":"If you'd like to wait for a process::Child to finish, you must call Child::wait, which will return a process::ExitStatus. use std::process::Command; fn main() { let mut child = Command::new(\"sleep\").arg(\"5\").spawn().unwrap(); let _result = child.wait().unwrap(); println!(\"reached end of main\");\n} $ rustc wait.rs && ./wait\n# `wait` keeps running for 5 seconds until the `sleep 5` command finishes\nreached end of main","breadcrumbs":"Std misc » Child processes » Wait » Wait","id":"290","title":"Wait"},"291":{"body":"The std::fs module contains several functions that deal with the filesystem. use std::fs;\nuse std::fs::{File, OpenOptions};\nuse std::io;\nuse std::io::prelude::*;\n#[cfg(target_family = \"unix\")]\nuse std::os::unix;\n#[cfg(target_family = \"windows\")]\nuse std::os::windows;\nuse std::path::Path; // A simple implementation of `% cat path`\nfn cat(path: &Path) -> io::Result<String> { let mut f = File::open(path)?; let mut s = String::new(); match f.read_to_string(&mut s) { Ok(_) => Ok(s), Err(e) => Err(e), }\n} // A simple implementation of `% echo s > path`\nfn echo(s: &str, path: &Path) -> io::Result<()> { let mut f = File::create(path)?; f.write_all(s.as_bytes())\n} // A simple implementation of `% touch path` (ignores existing files)\nfn touch(path: &Path) -> io::Result<()> { match OpenOptions::new().create(true).write(true).open(path) { Ok(_) => Ok(()), Err(e) => Err(e), }\n} fn main() { println!(\"`mkdir a`\"); // Create a directory, returns `io::Result<()>` match fs::create_dir(\"a\") { Err(why) => println!(\"! {:?}\", why.kind()), Ok(_) => {}, } println!(\"`echo hello > a/b.txt`\"); // The previous match can be simplified using the `unwrap_or_else` method echo(\"hello\", &Path::new(\"a/b.txt\")).unwrap_or_else(|why| { println!(\"! {:?}\", why.kind()); }); println!(\"`mkdir -p a/c/d`\"); // Recursively create a directory, returns `io::Result<()>` fs::create_dir_all(\"a/c/d\").unwrap_or_else(|why| { println!(\"! {:?}\", why.kind()); }); println!(\"`touch a/c/e.txt`\"); touch(&Path::new(\"a/c/e.txt\")).unwrap_or_else(|why| { println!(\"! {:?}\", why.kind()); }); println!(\"`ln -s ../b.txt a/c/b.txt`\"); // Create a symbolic link, returns `io::Result<()>` #[cfg(target_family = \"unix\")] { unix::fs::symlink(\"../b.txt\", \"a/c/b.txt\").unwrap_or_else(|why| { println!(\"! {:?}\", why.kind()); }); } #[cfg(target_family = \"windows\")] { windows::fs::symlink_file(\"../b.txt\", \"a/c/b.txt\").unwrap_or_else(|why| { println!(\"! {:?}\", why.to_string()); }); } println!(\"`cat a/c/b.txt`\"); match cat(&Path::new(\"a/c/b.txt\")) { Err(why) => println!(\"! {:?}\", why.kind()), Ok(s) => println!(\"> {}\", s), } println!(\"`ls a`\"); // Read the contents of a directory, returns `io::Result<Vec<Path>>` match fs::read_dir(\"a\") { Err(why) => println!(\"! {:?}\", why.kind()), Ok(paths) => for path in paths { println!(\"> {:?}\", path.unwrap().path()); }, } println!(\"`rm a/c/e.txt`\"); // Remove a file, returns `io::Result<()>` fs::remove_file(\"a/c/e.txt\").unwrap_or_else(|why| { println!(\"! {:?}\", why.kind()); }); println!(\"`rmdir a/c/d`\"); // Remove an empty directory, returns `io::Result<()>` fs::remove_dir(\"a/c/d\").unwrap_or_else(|why| { println!(\"! {:?}\", why.kind()); });\n} Here's the expected successful output: $ rustc fs.rs && ./fs\n`mkdir a`\n`echo hello > a/b.txt`\n`mkdir -p a/c/d`\n`touch a/c/e.txt`\n`ln -s ../b.txt a/c/b.txt`\n`cat a/c/b.txt`\n> hello\n`ls a`\n> \"a/b.txt\"\n> \"a/c\"\n`rm a/c/e.txt`\n`rmdir a/c/d` And the final state of the a directory is: $ tree a\na\n|-- b.txt\n`-- c `-- b.txt -> ../b.txt 1 directory, 2 files An alternative way to define the function cat is with ? notation: fn cat(path: &Path) -> io::Result<String> { let mut f = File::open(path)?; let mut s = String::new(); f.read_to_string(&mut s)?; Ok(s)\n}","breadcrumbs":"Std misc » Filesystem Operations » Filesystem Operations","id":"291","title":"Filesystem Operations"},"292":{"body":"cfg!","breadcrumbs":"Std misc » Filesystem Operations » See also:","id":"292","title":"See also:"},"293":{"body":"","breadcrumbs":"Std misc » Program arguments » Program arguments","id":"293","title":"Program arguments"},"294":{"body":"The command line arguments can be accessed using std::env::args, which returns an iterator that yields a String for each argument: use std::env; fn main() { let args: Vec<String> = env::args().collect(); // The first argument is the path that was used to call the program. println!(\"My path is {}.\", args[0]); // The rest of the arguments are the passed command line parameters. // Call the program like this: // $ ./args arg1 arg2 println!(\"I got {:?} arguments: {:?}.\", args.len() - 1, &args[1..]);\n} $ ./args 1 2 3\nMy path is ./args.\nI got 3 arguments: [\"1\", \"2\", \"3\"].","breadcrumbs":"Std misc » Program arguments » Standard Library","id":"294","title":"Standard Library"},"295":{"body":"Alternatively, there are numerous crates that can provide extra functionality when creating command-line applications. One of the more popular command line argument crates being clap .","breadcrumbs":"Std misc » Program arguments » Crates","id":"295","title":"Crates"},"296":{"body":"Matching can be used to parse simple arguments: use std::env; fn increase(number: i32) { println!(\"{}\", number + 1);\n} fn decrease(number: i32) { println!(\"{}\", number - 1);\n} fn help() { println!(\"usage:\nmatch_args <string> Check whether given string is the answer.\nmatch_args {{increase|decrease}} <integer> Increase or decrease given integer by one.\");\n} fn main() { let args: Vec<String> = env::args().collect(); match args.len() { // no arguments passed 1 => { println!(\"My name is 'match_args'. Try passing some arguments!\"); }, // one argument passed 2 => { match args[1].parse() { Ok(42) => println!(\"This is the answer!\"), _ => println!(\"This is not the answer.\"), } }, // one command and one argument passed 3 => { let cmd = &args[1]; let num = &args[2]; // parse the number let number: i32 = match num.parse() { Ok(n) => { n }, Err(_) => { eprintln!(\"error: second argument not an integer\"); help(); return; }, }; // parse the command match &cmd[..] { \"increase\" => increase(number), \"decrease\" => decrease(number), _ => { eprintln!(\"error: invalid command\"); help(); }, } }, // all the other cases _ => { // show a help message help(); } }\n} If you named your program match_args.rs and compile it like this rustc match_args.rs, you can execute it as follows: $ ./match_args Rust\nThis is not the answer.\n$ ./match_args 42\nThis is the answer!\n$ ./match_args do something\nerror: second argument not an integer\nusage:\nmatch_args <string> Check whether given string is the answer.\nmatch_args {increase|decrease} <integer> Increase or decrease given integer by one.\n$ ./match_args do 42\nerror: invalid command\nusage:\nmatch_args <string> Check whether given string is the answer.\nmatch_args {increase|decrease} <integer> Increase or decrease given integer by one.\n$ ./match_args increase 42\n43","breadcrumbs":"Std misc » Program arguments » Argument parsing » Argument parsing","id":"296","title":"Argument parsing"},"297":{"body":"Rust provides a Foreign Function Interface (FFI) to C libraries. Foreign functions must be declared inside an extern block annotated with a #[link] attribute containing the name of the foreign library. use std::fmt; // this extern block links to the libm library\n#[cfg(target_family = \"windows\")]\n#[link(name = \"msvcrt\")]\nextern { // this is a foreign function // that computes the square root of a single precision complex number fn csqrtf(z: Complex) -> Complex; fn ccosf(z: Complex) -> Complex;\n}\n#[cfg(target_family = \"unix\")]\n#[link(name = \"m\")]\nextern { // this is a foreign function // that computes the square root of a single precision complex number fn csqrtf(z: Complex) -> Complex; fn ccosf(z: Complex) -> Complex;\n} // Since calling foreign functions is considered unsafe,\n// it's common to write safe wrappers around them.\nfn cos(z: Complex) -> Complex { unsafe { ccosf(z) }\n} fn main() { // z = -1 + 0i let z = Complex { re: -1., im: 0. }; // calling a foreign function is an unsafe operation let z_sqrt = unsafe { csqrtf(z) }; println!(\"the square root of {:?} is {:?}\", z, z_sqrt); // calling safe API wrapped around unsafe operation println!(\"cos({:?}) = {:?}\", z, cos(z));\n} // Minimal implementation of single precision complex numbers\n#[repr(C)]\n#[derive(Clone, Copy)]\nstruct Complex { re: f32, im: f32,\n} impl fmt::Debug for Complex { fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result { if self.im < 0. { write!(f, \"{}-{}i\", self.re, -self.im) } else { write!(f, \"{}+{}i\", self.re, self.im) } }\n}","breadcrumbs":"Std misc » Foreign Function Interface » Foreign Function Interface","id":"297","title":"Foreign Function Interface"},"298":{"body":"Rust is a programming language that cares a lot about correctness and it includes support for writing software tests within the language itself. Testing comes in three styles: Unit testing. Doc testing. Integration testing. Also Rust has support for specifying additional dependencies for tests: Dev-dependencies","breadcrumbs":"Testing » Testing","id":"298","title":"Testing"},"299":{"body":"The Book chapter on testing API Guidelines on doc-testing","breadcrumbs":"Testing » See Also","id":"299","title":"See Also"},"3":{"body":"Any program requires comments, and Rust supports a few different varieties: Regular comments which are ignored by the compiler: // Line comments which go to the end of the line. /* Block comments which go to the closing delimiter. */ Doc comments which are parsed into HTML library documentation : /// Generate library docs for the following item. //! Generate library docs for the enclosing item. fn main() { // This is an example of a line comment. // There are two slashes at the beginning of the line. // And nothing written after these will be read by the compiler. // println!(\"Hello, world!\"); // Run it. See? Now try deleting the two slashes, and run it again. /* * This is another type of comment, a block comment. In general, * line comments are the recommended comment style. But block comments * are extremely useful for temporarily disabling chunks of code. * /* Block comments can be /* nested, */ */ so it takes only a few * keystrokes to comment out everything in this main() function. * /*/*/* Try it yourself! */*/*/ */ /* Note: The previous column of `*` was entirely for style. There's no actual need for it. */ // You can manipulate expressions more easily with block comments // than with line comments. Try deleting the comment delimiters // to change the result: let x = 5 + /* 90 + */ 5; println!(\"Is `x` 10 or 100? x = {}\", x);\n}","breadcrumbs":"Hello World » Comments » Comments","id":"3","title":"Comments"},"30":{"body":"attributes , and destructuring","breadcrumbs":"Custom Types » Structures » See also","id":"30","title":"See also"},"300":{"body":"Tests are Rust functions that verify that the non-test code is functioning in the expected manner. The bodies of test functions typically perform some setup, run the code we want to test, then assert whether the results are what we expect. Most unit tests go into a tests mod with the #[cfg(test)] attribute . Test functions are marked with the #[test] attribute. Tests fail when something in the test function panics . There are some helper macros : assert!(expression) - panics if expression evaluates to false. assert_eq!(left, right) and assert_ne!(left, right) - testing left and right expressions for equality and inequality respectively. pub fn add(a: i32, b: i32) -> i32 { a + b\n} // This is a really bad adding function, its purpose is to fail in this\n// example.\n#[allow(dead_code)]\nfn bad_add(a: i32, b: i32) -> i32 { a - b\n} #[cfg(test)]\nmod tests { // Note this useful idiom: importing names from outer (for mod tests) scope. use super::*; #[test] fn test_add() { assert_eq!(add(1, 2), 3); } #[test] fn test_bad_add() { // This assert would fire and test will fail. // Please note, that private functions can be tested too! assert_eq!(bad_add(1, 2), 3); }\n} Tests can be run with cargo test. $ cargo test running 2 tests\ntest tests::test_bad_add ... FAILED\ntest tests::test_add ... ok failures: ---- tests::test_bad_add stdout ---- thread 'tests::test_bad_add' panicked at 'assertion failed: `(left == right)` left: `-1`, right: `3`', src/lib.rs:21:8\nnote: Run with `RUST_BACKTRACE=1` for a backtrace. failures: tests::test_bad_add test result: FAILED. 1 passed; 1 failed; 0 ignored; 0 measured; 0 filtered out","breadcrumbs":"Testing » Unit testing » Unit testing","id":"300","title":"Unit testing"},"301":{"body":"None of the previous unit test examples had a return type. But in Rust 2018, your unit tests can return Result<()>, which lets you use ? in them! This can make them much more concise. fn sqrt(number: f64) -> Result<f64, String> { if number >= 0.0 { Ok(number.powf(0.5)) } else { Err(\"negative floats don't have square roots\".to_owned()) }\n} #[cfg(test)]\nmod tests { use super::*; #[test] fn test_sqrt() -> Result<(), String> { let x = 4.0; assert_eq!(sqrt(x)?.powf(2.0), x); Ok(()) }\n} See \"The Edition Guide\" for more details.","breadcrumbs":"Testing » Unit testing » Tests and ?","id":"301","title":"Tests and ?"},"302":{"body":"To check functions that should panic under certain circumstances, use attribute #[should_panic]. This attribute accepts optional parameter expected = with the text of the panic message. If your function can panic in multiple ways, it helps make sure your test is testing the correct panic. pub fn divide_non_zero_result(a: u32, b: u32) -> u32 { if b == 0 { panic!(\"Divide-by-zero error\"); } else if a < b { panic!(\"Divide result is zero\"); } a / b\n} #[cfg(test)]\nmod tests { use super::*; #[test] fn test_divide() { assert_eq!(divide_non_zero_result(10, 2), 5); } #[test] #[should_panic] fn test_any_panic() { divide_non_zero_result(1, 0); } #[test] #[should_panic(expected = \"Divide result is zero\")] fn test_specific_panic() { divide_non_zero_result(1, 10); }\n} Running these tests gives us: $ cargo test running 3 tests\ntest tests::test_any_panic ... ok\ntest tests::test_divide ... ok\ntest tests::test_specific_panic ... ok test result: ok. 3 passed; 0 failed; 0 ignored; 0 measured; 0 filtered out Doc-tests tmp-test-should-panic running 0 tests test result: ok. 0 passed; 0 failed; 0 ignored; 0 measured; 0 filtered out","breadcrumbs":"Testing » Unit testing » Testing panics","id":"302","title":"Testing panics"},"303":{"body":"To run specific tests one may specify the test name to cargo test command. $ cargo test test_any_panic\nrunning 1 test\ntest tests::test_any_panic ... ok test result: ok. 1 passed; 0 failed; 0 ignored; 0 measured; 2 filtered out Doc-tests tmp-test-should-panic running 0 tests test result: ok. 0 passed; 0 failed; 0 ignored; 0 measured; 0 filtered out To run multiple tests one may specify part of a test name that matches all the tests that should be run. $ cargo test panic\nrunning 2 tests\ntest tests::test_any_panic ... ok\ntest tests::test_specific_panic ... ok test result: ok. 2 passed; 0 failed; 0 ignored; 0 measured; 1 filtered out Doc-tests tmp-test-should-panic running 0 tests test result: ok. 0 passed; 0 failed; 0 ignored; 0 measured; 0 filtered out","breadcrumbs":"Testing » Unit testing » Running specific tests","id":"303","title":"Running specific tests"},"304":{"body":"Tests can be marked with the #[ignore] attribute to exclude some tests. Or to run them with command cargo test -- --ignored pub fn add(a: i32, b: i32) -> i32 { a + b\n} #[cfg(test)]\nmod tests { use super::*; #[test] fn test_add() { assert_eq!(add(2, 2), 4); } #[test] fn test_add_hundred() { assert_eq!(add(100, 2), 102); assert_eq!(add(2, 100), 102); } #[test] #[ignore] fn ignored_test() { assert_eq!(add(0, 0), 0); }\n} $ cargo test\nrunning 3 tests\ntest tests::ignored_test ... ignored\ntest tests::test_add ... ok\ntest tests::test_add_hundred ... ok test result: ok. 2 passed; 0 failed; 1 ignored; 0 measured; 0 filtered out Doc-tests tmp-ignore running 0 tests test result: ok. 0 passed; 0 failed; 0 ignored; 0 measured; 0 filtered out $ cargo test -- --ignored\nrunning 1 test\ntest tests::ignored_test ... ok test result: ok. 1 passed; 0 failed; 0 ignored; 0 measured; 0 filtered out Doc-tests tmp-ignore running 0 tests test result: ok. 0 passed; 0 failed; 0 ignored; 0 measured; 0 filtered out","breadcrumbs":"Testing » Unit testing » Ignoring tests","id":"304","title":"Ignoring tests"},"305":{"body":"The primary way of documenting a Rust project is through annotating the source code. Documentation comments are written in CommonMark Markdown specification and support code blocks in them. Rust takes care about correctness, so these code blocks are compiled and used as documentation tests. /// First line is a short summary describing function.\n///\n/// The next lines present detailed documentation. Code blocks start with\n/// triple backquotes and have implicit `fn main()` inside\n/// and `extern crate <cratename>`. Assume we're testing `doccomments` crate:\n///\n/// ```\n/// let result = doccomments::add(2, 3);\n/// assert_eq!(result, 5);\n/// ```\npub fn add(a: i32, b: i32) -> i32 { a + b\n} /// Usually doc comments may include sections \"Examples\", \"Panics\" and \"Failures\".\n///\n/// The next function divides two numbers.\n///\n/// # Examples\n///\n/// ```\n/// let result = doccomments::div(10, 2);\n/// assert_eq!(result, 5);\n/// ```\n///\n/// # Panics\n///\n/// The function panics if the second argument is zero.\n///\n/// ```rust,should_panic\n/// // panics on division by zero\n/// doccomments::div(10, 0);\n/// ```\npub fn div(a: i32, b: i32) -> i32 { if b == 0 { panic!(\"Divide-by-zero error\"); } a / b\n} Code blocks in documentation are automatically tested when running the regular cargo test command: $ cargo test\nrunning 0 tests test result: ok. 0 passed; 0 failed; 0 ignored; 0 measured; 0 filtered out Doc-tests doccomments running 3 tests\ntest src/lib.rs - add (line 7) ... ok\ntest src/lib.rs - div (line 21) ... ok\ntest src/lib.rs - div (line 31) ... ok test result: ok. 3 passed; 0 failed; 0 ignored; 0 measured; 0 filtered out","breadcrumbs":"Testing » Documentation testing » Documentation testing","id":"305","title":"Documentation testing"},"306":{"body":"The main purpose of documentation tests is to serve as examples that exercise the functionality, which is one of the most important guidelines . It allows using examples from docs as complete code snippets. But using ? makes compilation fail since main returns unit. The ability to hide some source lines from documentation comes to the rescue: one may write fn try_main() -> Result<(), ErrorType>, hide it and unwrap it in hidden main. Sounds complicated? Here's an example: /// Using hidden `try_main` in doc tests.\n///\n/// ```\n/// # // hidden lines start with `#` symbol, but they're still compilable!\n/// # fn try_main() -> Result<(), String> { // line that wraps the body shown in doc\n/// let res = doccomments::try_div(10, 2)?;\n/// # Ok(()) // returning from try_main\n/// # }\n/// # fn main() { // starting main that'll unwrap()\n/// # try_main().unwrap(); // calling try_main and unwrapping\n/// # // so that test will panic in case of error\n/// # }\n/// ```\npub fn try_div(a: i32, b: i32) -> Result<i32, String> { if b == 0 { Err(String::from(\"Divide-by-zero\")) } else { Ok(a / b) }\n}","breadcrumbs":"Testing » Documentation testing » Motivation behind documentation tests","id":"306","title":"Motivation behind documentation tests"},"307":{"body":"RFC505 on documentation style API Guidelines on documentation guidelines","breadcrumbs":"Testing » Documentation testing » See Also","id":"307","title":"See Also"},"308":{"body":"Unit tests are testing one module in isolation at a time: they're small and can test private code. Integration tests are external to your crate and use only its public interface in the same way any other code would. Their purpose is to test that many parts of your library work correctly together. Cargo looks for integration tests in tests directory next to src. File src/lib.rs: // Define this in a crate called `adder`.\npub fn add(a: i32, b: i32) -> i32 { a + b\n} File with test: tests/integration_test.rs: #[test]\nfn test_add() { assert_eq!(adder::add(3, 2), 5);\n} Running tests with cargo test command: $ cargo test\nrunning 0 tests test result: ok. 0 passed; 0 failed; 0 ignored; 0 measured; 0 filtered out Running target/debug/deps/integration_test-bcd60824f5fbfe19 running 1 test\ntest test_add ... ok test result: ok. 1 passed; 0 failed; 0 ignored; 0 measured; 0 filtered out Doc-tests adder running 0 tests test result: ok. 0 passed; 0 failed; 0 ignored; 0 measured; 0 filtered out Each Rust source file in the tests directory is compiled as a separate crate. In order to share some code between integration tests we can make a module with public functions, importing and using it within tests. File tests/common/mod.rs: pub fn setup() { // some setup code, like creating required files/directories, starting // servers, etc.\n} File with test: tests/integration_test.rs // importing common module.\nmod common; #[test]\nfn test_add() { // using common code. common::setup(); assert_eq!(adder::add(3, 2), 5);\n} Creating the module as tests/common.rs also works, but is not recommended because the test runner will treat the file as a test crate and try to run tests inside it.","breadcrumbs":"Testing » Integration testing » Integration testing","id":"308","title":"Integration testing"},"309":{"body":"Sometimes there is a need to have dependencies for tests (or examples, or benchmarks) only. Such dependencies are added to Cargo.toml in the [dev-dependencies] section. These dependencies are not propagated to other packages which depend on this package. One such example is pretty_assertions , which extends standard assert_eq! and assert_ne! macros, to provide colorful diff. File Cargo.toml: # standard crate data is left out\n[dev-dependencies]\npretty_assertions = \"1\" File src/lib.rs: pub fn add(a: i32, b: i32) -> i32 { a + b\n} #[cfg(test)]\nmod tests { use super::*; use pretty_assertions::assert_eq; // crate for test-only use. Cannot be used in non-test code. #[test] fn test_add() { assert_eq!(add(2, 3), 5); }\n}","breadcrumbs":"Testing » Dev-dependencies » Development dependencies","id":"309","title":"Development dependencies"},"31":{"body":"The enum keyword allows the creation of a type which may be one of a few different variants. Any variant which is valid as a struct is also valid in an enum. // Create an `enum` to classify a web event. Note how both\n// names and type information together specify the variant:\n// `PageLoad != PageUnload` and `KeyPress(char) != Paste(String)`.\n// Each is different and independent.\nenum WebEvent { // An `enum` variant may either be `unit-like`, PageLoad, PageUnload, // like tuple structs, KeyPress(char), Paste(String), // or c-like structures. Click { x: i64, y: i64 },\n} // A function which takes a `WebEvent` enum as an argument and\n// returns nothing.\nfn inspect(event: WebEvent) { match event { WebEvent::PageLoad => println!(\"page loaded\"), WebEvent::PageUnload => println!(\"page unloaded\"), // Destructure `c` from inside the `enum` variant. WebEvent::KeyPress(c) => println!(\"pressed '{}'.\", c), WebEvent::Paste(s) => println!(\"pasted \\\"{}\\\".\", s), // Destructure `Click` into `x` and `y`. WebEvent::Click { x, y } => { println!(\"clicked at x={}, y={}.\", x, y); }, }\n} fn main() { let pressed = WebEvent::KeyPress('x'); // `to_owned()` creates an owned `String` from a string slice. let pasted = WebEvent::Paste(\"my text\".to_owned()); let click = WebEvent::Click { x: 20, y: 80 }; let load = WebEvent::PageLoad; let unload = WebEvent::PageUnload; inspect(pressed); inspect(pasted); inspect(click); inspect(load); inspect(unload);\n}","breadcrumbs":"Custom Types » Enums » Enums","id":"31","title":"Enums"},"310":{"body":"Cargo docs on specifying dependencies.","breadcrumbs":"Testing » Dev-dependencies » See Also","id":"310","title":"See Also"},"311":{"body":"As an introduction to this section, to borrow from the official docs , \"one should try to minimize the amount of unsafe code in a code base.\" With that in mind, let's get started! Unsafe annotations in Rust are used to bypass protections put in place by the compiler; specifically, there are four primary things that unsafe is used for: dereferencing raw pointers calling functions or methods which are unsafe (including calling a function over FFI, see a previous chapter of the book) accessing or modifying static mutable variables implementing unsafe traits","breadcrumbs":"Unsafe Operations » Unsafe Operations","id":"311","title":"Unsafe Operations"},"312":{"body":"Raw pointers * and references &T function similarly, but references are always safe because they are guaranteed to point to valid data due to the borrow checker. Dereferencing a raw pointer can only be done through an unsafe block. fn main() { let raw_p: *const u32 = &10; unsafe { assert!(*raw_p == 10); }\n}","breadcrumbs":"Unsafe Operations » Raw Pointers","id":"312","title":"Raw Pointers"},"313":{"body":"Some functions can be declared as unsafe, meaning it is the programmer's responsibility to ensure correctness instead of the compiler's. One example of this is std::slice::from_raw_parts which will create a slice given a pointer to the first element and a length. use std::slice; fn main() { let some_vector = vec![1, 2, 3, 4]; let pointer = some_vector.as_ptr(); let length = some_vector.len(); unsafe { let my_slice: &[u32] = slice::from_raw_parts(pointer, length); assert_eq!(some_vector.as_slice(), my_slice); }\n} For slice::from_raw_parts, one of the assumptions which must be upheld is that the pointer passed in points to valid memory and that the memory pointed to is of the correct type. If these invariants aren't upheld then the program's behaviour is undefined and there is no knowing what will happen.","breadcrumbs":"Unsafe Operations » Calling Unsafe Functions","id":"313","title":"Calling Unsafe Functions"},"314":{"body":"Rust provides support for inline assembly via the asm! macro. It can be used to embed handwritten assembly in the assembly output generated by the compiler. Generally this should not be necessary, but might be where the required performance or timing cannot be otherwise achieved. Accessing low level hardware primitives, e.g. in kernel code, may also demand this functionality. Note : the examples here are given in x86/x86-64 assembly, but other architectures are also supported. Inline assembly is currently supported on the following architectures: x86 and x86-64 ARM AArch64 RISC-V","breadcrumbs":"Unsafe Operations » Inline assembly » Inline assembly","id":"314","title":"Inline assembly"},"315":{"body":"Let us start with the simplest possible example: # #[cfg(target_arch = \"x86_64\")] {\nuse std::arch::asm; unsafe { asm!(\"nop\");\n}\n# } This will insert a NOP (no operation) instruction into the assembly generated by the compiler. Note that all asm! invocations have to be inside an unsafe block, as they could insert arbitrary instructions and break various invariants. The instructions to be inserted are listed in the first argument of the asm! macro as a string literal.","breadcrumbs":"Unsafe Operations » Inline assembly » Basic usage","id":"315","title":"Basic usage"},"316":{"body":"Now inserting an instruction that does nothing is rather boring. Let us do something that actually acts on data: # #[cfg(target_arch = \"x86_64\")] {\nuse std::arch::asm; let x: u64;\nunsafe { asm!(\"mov {}, 5\", out(reg) x);\n}\nassert_eq!(x, 5);\n# } This will write the value 5 into the u64 variable x. You can see that the string literal we use to specify instructions is actually a template string. It is governed by the same rules as Rust format strings . The arguments that are inserted into the template however look a bit different than you may be familiar with. First we need to specify if the variable is an input or an output of the inline assembly. In this case it is an output. We declared this by writing out. We also need to specify in what kind of register the assembly expects the variable. In this case we put it in an arbitrary general purpose register by specifying reg. The compiler will choose an appropriate register to insert into the template and will read the variable from there after the inline assembly finishes executing. Let us see another example that also uses an input: # #[cfg(target_arch = \"x86_64\")] {\nuse std::arch::asm; let i: u64 = 3;\nlet o: u64;\nunsafe { asm!( \"mov {0}, {1}\", \"add {0}, 5\", out(reg) o, in(reg) i, );\n}\nassert_eq!(o, 8);\n# } This will add 5 to the input in variable i and write the result to variable o. The particular way this assembly does this is first copying the value from i to the output, and then adding 5 to it. The example shows a few things: First, we can see that asm! allows multiple template string arguments; each one is treated as a separate line of assembly code, as if they were all joined together with newlines between them. This makes it easy to format assembly code. Second, we can see that inputs are declared by writing in instead of out. Third, we can see that we can specify an argument number, or name as in any format string. For inline assembly templates this is particularly useful as arguments are often used more than once. For more complex inline assembly using this facility is generally recommended, as it improves readability, and allows reordering instructions without changing the argument order. We can further refine the above example to avoid the mov instruction: # #[cfg(target_arch = \"x86_64\")] {\nuse std::arch::asm; let mut x: u64 = 3;\nunsafe { asm!(\"add {0}, 5\", inout(reg) x);\n}\nassert_eq!(x, 8);\n# } We can see that inout is used to specify an argument that is both input and output. This is different from specifying an input and output separately in that it is guaranteed to assign both to the same register. It is also possible to specify different variables for the input and output parts of an inout operand: # #[cfg(target_arch = \"x86_64\")] {\nuse std::arch::asm; let x: u64 = 3;\nlet y: u64;\nunsafe { asm!(\"add {0}, 5\", inout(reg) x => y);\n}\nassert_eq!(y, 8);\n# }","breadcrumbs":"Unsafe Operations » Inline assembly » Inputs and outputs","id":"316","title":"Inputs and outputs"},"317":{"body":"The Rust compiler is conservative with its allocation of operands. It is assumed that an out can be written at any time, and can therefore not share its location with any other argument. However, to guarantee optimal performance it is important to use as few registers as possible, so they won't have to be saved and reloaded around the inline assembly block. To achieve this Rust provides a lateout specifier. This can be used on any output that is written only after all inputs have been consumed. There is also an inlateout variant of this specifier. Here is an example where inlateout cannot be used in release mode or other optimized cases: # #[cfg(target_arch = \"x86_64\")] {\nuse std::arch::asm; let mut a: u64 = 4;\nlet b: u64 = 4;\nlet c: u64 = 4;\nunsafe { asm!( \"add {0}, {1}\", \"add {0}, {2}\", inout(reg) a, in(reg) b, in(reg) c, );\n}\nassert_eq!(a, 12);\n# } In unoptimized cases (e.g. Debug mode), replacing inout(reg) a with inlateout(reg) a in the above example can continue to give the expected result. However, with release mode or other optimized cases, using inlateout(reg) a can instead lead to the final value a = 16, causing the assertion to fail. This is because in optimized cases, the compiler is free to allocate the same register for inputs b and c since it knows that they have the same value. Furthermore, when inlateout is used, a and c could be allocated to the same register, in which case the first add instruction would overwrite the initial load from variable c. This is in contrast to how using inout(reg) a ensures a separate register is allocated for a. However, the following example can use inlateout since the output is only modified after all input registers have been read: # #[cfg(target_arch = \"x86_64\")] {\nuse std::arch::asm; let mut a: u64 = 4;\nlet b: u64 = 4;\nunsafe { asm!(\"add {0}, {1}\", inlateout(reg) a, in(reg) b);\n}\nassert_eq!(a, 8);\n# } As you can see, this assembly fragment will still work correctly if a and b are assigned to the same register.","breadcrumbs":"Unsafe Operations » Inline assembly » Late output operands","id":"317","title":"Late output operands"},"318":{"body":"Some instructions require that the operands be in a specific register. Therefore, Rust inline assembly provides some more specific constraint specifiers. While reg is generally available on any architecture, explicit registers are highly architecture specific. E.g. for x86 the general purpose registers eax, ebx, ecx, edx, ebp, esi, and edi among others can be addressed by their name. # #[cfg(target_arch = \"x86_64\")] {\nuse std::arch::asm; let cmd = 0xd1;\nunsafe { asm!(\"out 0x64, eax\", in(\"eax\") cmd);\n}\n# } In this example we call the out instruction to output the content of the cmd variable to port 0x64. Since the out instruction only accepts eax (and its sub registers) as operand we had to use the eax constraint specifier. Note : unlike other operand types, explicit register operands cannot be used in the template string: you can't use {} and should write the register name directly instead. Also, they must appear at the end of the operand list after all other operand types. Consider this example which uses the x86 mul instruction: # #[cfg(target_arch = \"x86_64\")] {\nuse std::arch::asm; fn mul(a: u64, b: u64) -> u128 { let lo: u64; let hi: u64; unsafe { asm!( // The x86 mul instruction takes rax as an implicit input and writes // the 128-bit result of the multiplication to rax:rdx. \"mul {}\", in(reg) a, inlateout(\"rax\") b => lo, lateout(\"rdx\") hi ); } ((hi as u128) << 64) + lo as u128\n}\n# } This uses the mul instruction to multiply two 64-bit inputs with a 128-bit result. The only explicit operand is a register, that we fill from the variable a. The second operand is implicit, and must be the rax register, which we fill from the variable b. The lower 64 bits of the result are stored in rax from which we fill the variable lo. The higher 64 bits are stored in rdx from which we fill the variable hi.","breadcrumbs":"Unsafe Operations » Inline assembly » Explicit register operands","id":"318","title":"Explicit register operands"},"319":{"body":"In many cases inline assembly will modify state that is not needed as an output. Usually this is either because we have to use a scratch register in the assembly or because instructions modify state that we don't need to further examine. This state is generally referred to as being \"clobbered\". We need to tell the compiler about this since it may need to save and restore this state around the inline assembly block. use std::arch::asm; # #[cfg(target_arch = \"x86_64\")]\nfn main() { // three entries of four bytes each let mut name_buf = [0_u8; 12]; // String is stored as ascii in ebx, edx, ecx in order // Because ebx is reserved, the asm needs to preserve the value of it. // So we push and pop it around the main asm. // 64 bit mode on 64 bit processors does not allow pushing/popping of // 32 bit registers (like ebx), so we have to use the extended rbx register instead. unsafe { asm!( \"push rbx\", \"cpuid\", \"mov [rdi], ebx\", \"mov [rdi + 4], edx\", \"mov [rdi + 8], ecx\", \"pop rbx\", // We use a pointer to an array for storing the values to simplify // the Rust code at the cost of a couple more asm instructions // This is more explicit with how the asm works however, as opposed // to explicit register outputs such as `out(\"ecx\") val` // The *pointer itself* is only an input even though it's written behind in(\"rdi\") name_buf.as_mut_ptr(), // select cpuid 0, also specify eax as clobbered inout(\"eax\") 0 => _, // cpuid clobbers these registers too out(\"ecx\") _, out(\"edx\") _, ); } let name = core::str::from_utf8(&name_buf).unwrap(); println!(\"CPU Manufacturer ID: {}\", name);\n} # #[cfg(not(target_arch = \"x86_64\"))]\n# fn main() {} In the example above we use the cpuid instruction to read the CPU manufacturer ID. This instruction writes to eax with the maximum supported cpuid argument and ebx, edx, and ecx with the CPU manufacturer ID as ASCII bytes in that order. Even though eax is never read we still need to tell the compiler that the register has been modified so that the compiler can save any values that were in these registers before the asm. This is done by declaring it as an output but with _ instead of a variable name, which indicates that the output value is to be discarded. This code also works around the limitation that ebx is a reserved register by LLVM. That means that LLVM assumes that it has full control over the register and it must be restored to its original state before exiting the asm block, so it cannot be used as an input or output except if the compiler uses it to fulfill a general register class (e.g. in(reg)). This makes reg operands dangerous when using reserved registers as we could unknowingly corrupt our input or output because they share the same register. To work around this we use rdi to store the pointer to the output array, save ebx via push, read from ebx inside the asm block into the array and then restore ebx to its original state via pop. The push and pop use the full 64-bit rbx version of the register to ensure that the entire register is saved. On 32 bit targets the code would instead use ebx in the push/pop. This can also be used with a general register class to obtain a scratch register for use inside the asm code: # #[cfg(target_arch = \"x86_64\")] {\nuse std::arch::asm; // Multiply x by 6 using shifts and adds\nlet mut x: u64 = 4;\nunsafe { asm!( \"mov {tmp}, {x}\", \"shl {tmp}, 1\", \"shl {x}, 2\", \"add {x}, {tmp}\", x = inout(reg) x, tmp = out(reg) _, );\n}\nassert_eq!(x, 4 * 6);\n# }","breadcrumbs":"Unsafe Operations » Inline assembly » Clobbered registers","id":"319","title":"Clobbered registers"},"32":{"body":"If you use a type alias, you can refer to each enum variant via its alias. This might be useful if the enum's name is too long or too generic, and you want to rename it. enum VeryVerboseEnumOfThingsToDoWithNumbers { Add, Subtract,\n} // Creates a type alias\ntype Operations = VeryVerboseEnumOfThingsToDoWithNumbers; fn main() { // We can refer to each variant via its alias, not its long and inconvenient // name. let x = Operations::Add;\n} The most common place you'll see this is in impl blocks using the Self alias. enum VeryVerboseEnumOfThingsToDoWithNumbers { Add, Subtract,\n} impl VeryVerboseEnumOfThingsToDoWithNumbers { fn run(&self, x: i32, y: i32) -> i32 { match self { Self::Add => x + y, Self::Subtract => x - y, } }\n} To learn more about enums and type aliases, you can read the stabilization report from when this feature was stabilized into Rust.","breadcrumbs":"Custom Types » Enums » Type aliases","id":"32","title":"Type aliases"},"320":{"body":"By default, asm! assumes that any register not specified as an output will have its contents preserved by the assembly code. The clobber_abi argument to asm! tells the compiler to automatically insert the necessary clobber operands according to the given calling convention ABI: any register which is not fully preserved in that ABI will be treated as clobbered. Multiple clobber_abi arguments may be provided and all clobbers from all specified ABIs will be inserted. # #[cfg(target_arch = \"x86_64\")] {\nuse std::arch::asm; extern \"C\" fn foo(arg: i32) -> i32 { println!(\"arg = {}\", arg); arg * 2\n} fn call_foo(arg: i32) -> i32 { unsafe { let result; asm!( \"call {}\", // Function pointer to call in(reg) foo, // 1st argument in rdi in(\"rdi\") arg, // Return value in rax out(\"rax\") result, // Mark all registers which are not preserved by the \"C\" calling // convention as clobbered. clobber_abi(\"C\"), ); result }\n}\n# }","breadcrumbs":"Unsafe Operations » Inline assembly » Symbol operands and ABI clobbers","id":"320","title":"Symbol operands and ABI clobbers"},"321":{"body":"In some cases, fine control is needed over the way a register name is formatted when inserted into the template string. This is needed when an architecture's assembly language has several names for the same register, each typically being a \"view\" over a subset of the register (e.g. the low 32 bits of a 64-bit register). By default the compiler will always choose the name that refers to the full register size (e.g. rax on x86-64, eax on x86, etc). This default can be overridden by using modifiers on the template string operands, just like you would with format strings: # #[cfg(target_arch = \"x86_64\")] {\nuse std::arch::asm; let mut x: u16 = 0xab; unsafe { asm!(\"mov {0:h}, {0:l}\", inout(reg_abcd) x);\n} assert_eq!(x, 0xabab);\n# } In this example, we use the reg_abcd register class to restrict the register allocator to the 4 legacy x86 registers (ax, bx, cx, dx) of which the first two bytes can be addressed independently. Let us assume that the register allocator has chosen to allocate x in the ax register. The h modifier will emit the register name for the high byte of that register and the l modifier will emit the register name for the low byte. The asm code will therefore be expanded as mov ah, al which copies the low byte of the value into the high byte. If you use a smaller data type (e.g. u16) with an operand and forget to use template modifiers, the compiler will emit a warning and suggest the correct modifier to use.","breadcrumbs":"Unsafe Operations » Inline assembly » Register template modifiers","id":"321","title":"Register template modifiers"},"322":{"body":"Sometimes assembly instructions require operands passed via memory addresses/memory locations. You have to manually use the memory address syntax specified by the target architecture. For example, on x86/x86_64 using Intel assembly syntax, you should wrap inputs/outputs in [] to indicate they are memory operands: # #[cfg(target_arch = \"x86_64\")] {\nuse std::arch::asm; fn load_fpu_control_word(control: u16) { unsafe { asm!(\"fldcw [{}]\", in(reg) &control, options(nostack)); }\n}\n# }","breadcrumbs":"Unsafe Operations » Inline assembly » Memory address operands","id":"322","title":"Memory address operands"},"323":{"body":"Any reuse of a named label, local or otherwise, can result in an assembler or linker error or may cause other strange behavior. Reuse of a named label can happen in a variety of ways including: explicitly: using a label more than once in one asm! block, or multiple times across blocks. implicitly via inlining: the compiler is allowed to instantiate multiple copies of an asm! block, for example when the function containing it is inlined in multiple places. implicitly via LTO: LTO can cause code from other crates to be placed in the same codegen unit, and so could bring in arbitrary labels. As a consequence, you should only use GNU assembler numeric local labels inside inline assembly code. Defining symbols in assembly code may lead to assembler and/or linker errors due to duplicate symbol definitions. Moreover, on x86 when using the default Intel syntax, due to an LLVM bug , you shouldn't use labels exclusively made of 0 and 1 digits, e.g. 0, 11 or 101010, as they may end up being interpreted as binary values. Using options(att_syntax) will avoid any ambiguity, but that affects the syntax of the entire asm! block. (See Options , below, for more on options.) # #[cfg(target_arch = \"x86_64\")] {\nuse std::arch::asm; let mut a = 0;\nunsafe { asm!( \"mov {0}, 10\", \"2:\", \"sub {0}, 1\", \"cmp {0}, 3\", \"jle 2f\", \"jmp 2b\", \"2:\", \"add {0}, 2\", out(reg) a );\n}\nassert_eq!(a, 5);\n# } This will decrement the {0} register value from 10 to 3, then add 2 and store it in a. This example shows a few things: First, that the same number can be used as a label multiple times in the same inline block. Second, that when a numeric label is used as a reference (as an instruction operand, for example), the suffixes “b” (“backward”) or ”f” (“forward”) should be added to the numeric label. It will then refer to the nearest label defined by this number in this direction.","breadcrumbs":"Unsafe Operations » Inline assembly » Labels","id":"323","title":"Labels"},"324":{"body":"By default, an inline assembly block is treated the same way as an external FFI function call with a custom calling convention: it may read/write memory, have observable side effects, etc. However, in many cases it is desirable to give the compiler more information about what the assembly code is actually doing so that it can optimize better. Let's take our previous example of an add instruction: # #[cfg(target_arch = \"x86_64\")] {\nuse std::arch::asm; let mut a: u64 = 4;\nlet b: u64 = 4;\nunsafe { asm!( \"add {0}, {1}\", inlateout(reg) a, in(reg) b, options(pure, nomem, nostack), );\n}\nassert_eq!(a, 8);\n# } Options can be provided as an optional final argument to the asm! macro. We specified three options here: pure means that the asm code has no observable side effects and that its output depends only on its inputs. This allows the compiler optimizer to call the inline asm fewer times or even eliminate it entirely. nomem means that the asm code does not read or write to memory. By default the compiler will assume that inline assembly can read or write any memory address that is accessible to it (e.g. through a pointer passed as an operand, or a global). nostack means that the asm code does not push any data onto the stack. This allows the compiler to use optimizations such as the stack red zone on x86-64 to avoid stack pointer adjustments. These allow the compiler to better optimize code using asm!, for example by eliminating pure asm! blocks whose outputs are not needed. See the reference for the full list of available options and their effects.","breadcrumbs":"Unsafe Operations » Inline assembly » Options","id":"324","title":"Options"},"325":{"body":"The Rust language is fastly evolving, and because of this certain compatibility issues can arise, despite efforts to ensure forwards-compatibility wherever possible. Raw identifiers","breadcrumbs":"Compatibility » Compatibility","id":"325","title":"Compatibility"},"326":{"body":"Rust, like many programming languages, has the concept of \"keywords\". These identifiers mean something to the language, and so you cannot use them in places like variable names, function names, and other places. Raw identifiers let you use keywords where they would not normally be allowed. This is particularly useful when Rust introduces new keywords, and a library using an older edition of Rust has a variable or function with the same name as a keyword introduced in a newer edition. For example, consider a crate foo compiled with the 2015 edition of Rust that exports a function named try. This keyword is reserved for a new feature in the 2018 edition, so without raw identifiers, we would have no way to name the function. extern crate foo; fn main() { foo::try();\n} You'll get this error: error: expected identifier, found keyword `try` --> src/main.rs:4:4 |\n4 | foo::try(); | ^^^ expected identifier, found keyword You can write this with a raw identifier: extern crate foo; fn main() { foo::r#try();\n}","breadcrumbs":"Compatibility » Raw identifiers » Raw identifiers","id":"326","title":"Raw identifiers"},"327":{"body":"Some topics aren't exactly relevant to how you program but provide you tooling or infrastructure support which just makes things better for everyone. These topics include: Documentation : Generate library documentation for users via the included rustdoc. Playground : Integrate the Rust Playground in your documentation.","breadcrumbs":"Meta » Meta","id":"327","title":"Meta"},"328":{"body":"Use cargo doc to build documentation in target/doc. Use cargo test to run all tests (including documentation tests), and cargo test --doc to only run documentation tests. These commands will appropriately invoke rustdoc (and rustc) as required.","breadcrumbs":"Meta » Documentation » Documentation","id":"328","title":"Documentation"},"329":{"body":"Doc comments are very useful for big projects that require documentation. When running rustdoc, these are the comments that get compiled into documentation. They are denoted by a ///, and support Markdown . #![crate_name = \"doc\"] /// A human being is represented here\npub struct Person { /// A person must have a name, no matter how much Juliet may hate it name: String,\n} impl Person { /// Returns a person with the name given them /// /// # Arguments /// /// * `name` - A string slice that holds the name of the person /// /// # Examples /// /// ``` /// // You can have rust code between fences inside the comments /// // If you pass --test to `rustdoc`, it will even test it for you! /// use doc::Person; /// let person = Person::new(\"name\"); /// ``` pub fn new(name: &str) -> Person { Person { name: name.to_string(), } } /// Gives a friendly hello! /// /// Says \"Hello, [name](Person::name)\" to the `Person` it is called on. pub fn hello(&self) { println!(\"Hello, {}!\", self.name); }\n} fn main() { let john = Person::new(\"John\"); john.hello();\n} To run the tests, first build the code as a library, then tell rustdoc where to find the library so it can link it into each doctest program: $ rustc doc.rs --crate-type lib\n$ rustdoc --test --extern doc=\"libdoc.rlib\" doc.rs","breadcrumbs":"Meta » Documentation » Doc comments","id":"329","title":"Doc comments"},"33":{"body":"match , fn , and String , \"Type alias enum variants\" RFC","breadcrumbs":"Custom Types » Enums » See also:","id":"33","title":"See also:"},"330":{"body":"Below are a few examples of the most common #[doc] attributes used with rustdoc.","breadcrumbs":"Meta » Documentation » Doc attributes","id":"330","title":"Doc attributes"},"331":{"body":"Used to inline docs, instead of linking out to separate page. #[doc(inline)]\npub use bar::Bar; /// bar docs\npub mod bar { /// the docs for Bar pub struct Bar;\n}","breadcrumbs":"Meta » Documentation » inline","id":"331","title":"inline"},"332":{"body":"Used to prevent linking out to separate page or anywhere. // Example from libcore/prelude\n#[doc(no_inline)]\npub use crate::mem::drop;","breadcrumbs":"Meta » Documentation » no_inline","id":"332","title":"no_inline"},"333":{"body":"Using this tells rustdoc not to include this in documentation: // Example from the futures-rs library\n#[doc(hidden)]\npub use self::async_await::*; For documentation, rustdoc is widely used by the community. It's what is used to generate the std library docs .","breadcrumbs":"Meta » Documentation » hidden","id":"333","title":"hidden"},"334":{"body":"The Rust Book: Making Useful Documentation Comments The rustdoc Book The Reference: Doc comments RFC 1574: API Documentation Conventions RFC 1946: Relative links to other items from doc comments (intra-rustdoc links) Is there any documentation style guide for comments? (reddit)","breadcrumbs":"Meta » Documentation » See also:","id":"334","title":"See also:"},"335":{"body":"The Rust Playground is a way to experiment with Rust code through a web interface.","breadcrumbs":"Meta » Playground » Playground","id":"335","title":"Playground"},"336":{"body":"In mdbook , you can make code examples playable and editable. fn main() { println!(\"Hello World!\");\n} This allows the reader to both run your code sample, but also modify and tweak it. The key here is the adding of the word editable to your codefence block separated by a comma. ```rust,editable\n//...place your code here\n``` Additionally, you can add ignore if you want mdbook to skip your code when it builds and tests. ```rust,editable,ignore\n//...place your code here\n```","breadcrumbs":"Meta » Playground » Using it with mdbook","id":"336","title":"Using it with mdbook"},"337":{"body":"You may have noticed in some of the official Rust docs a button that says \"Run\", which opens the code sample up in a new tab in Rust Playground. This feature is enabled if you use the #[doc] attribute called html_playground_url . #![doc(html_playground_url = \"https://play.rust-lang.org/\")]\n//! ```\n//! println!(\"Hello Wolrd\");\n//! ```","breadcrumbs":"Meta » Playground » Using it with docs","id":"337","title":"Using it with docs"},"338":{"body":"The Rust Playground The Rust Playground On Github The rustdoc Book","breadcrumbs":"Meta » Playground » See also:","id":"338","title":"See also:"},"34":{"body":"The use declaration can be used so manual scoping isn't needed: // An attribute to hide warnings for unused code.\n#![allow(dead_code)] enum Status { Rich, Poor,\n} enum Work { Civilian, Soldier,\n} fn main() { // Explicitly `use` each name so they are available without // manual scoping. use crate::Status::{Poor, Rich}; // Automatically `use` each name inside `Work`. use crate::Work::*; // Equivalent to `Status::Poor`. let status = Poor; // Equivalent to `Work::Civilian`. let work = Civilian; match status { // Note the lack of scoping because of the explicit `use` above. Rich => println!(\"The rich have lots of money!\"), Poor => println!(\"The poor have no money...\"), } match work { // Note again the lack of scoping. Civilian => println!(\"Civilians work!\"), Soldier => println!(\"Soldiers fight!\"), }\n}","breadcrumbs":"Custom Types » Enums » use » use","id":"34","title":"use"},"35":{"body":"match and use","breadcrumbs":"Custom Types » Enums » use » See also:","id":"35","title":"See also:"},"36":{"body":"enum can also be used as C-like enums. // An attribute to hide warnings for unused code.\n#![allow(dead_code)] // enum with implicit discriminator (starts at 0)\nenum Number { Zero, One, Two,\n} // enum with explicit discriminator\nenum Color { Red = 0xff0000, Green = 0x00ff00, Blue = 0x0000ff,\n} fn main() { // `enums` can be cast as integers. println!(\"zero is {}\", Number::Zero as i32); println!(\"one is {}\", Number::One as i32); println!(\"roses are #{:06x}\", Color::Red as i32); println!(\"violets are #{:06x}\", Color::Blue as i32);\n}","breadcrumbs":"Custom Types » Enums » C-like » C-like","id":"36","title":"C-like"},"37":{"body":"casting","breadcrumbs":"Custom Types » Enums » C-like » See also:","id":"37","title":"See also:"},"38":{"body":"A common way to implement a linked-list is via enums: use crate::List::*; enum List { // Cons: Tuple struct that wraps an element and a pointer to the next node Cons(u32, Box<List>), // Nil: A node that signifies the end of the linked list Nil,\n} // Methods can be attached to an enum\nimpl List { // Create an empty list fn new() -> List { // `Nil` has type `List` Nil } // Consume a list, and return the same list with a new element at its front fn prepend(self, elem: u32) -> List { // `Cons` also has type List Cons(elem, Box::new(self)) } // Return the length of the list fn len(&self) -> u32 { // `self` has to be matched, because the behavior of this method // depends on the variant of `self` // `self` has type `&List`, and `*self` has type `List`, matching on a // concrete type `T` is preferred over a match on a reference `&T` // after Rust 2018 you can use self here and tail (with no ref) below as well, // rust will infer &s and ref tail. // See https://doc.rust-lang.org/edition-guide/rust-2018/ownership-and-lifetimes/default-match-bindings.html match *self { // Can't take ownership of the tail, because `self` is borrowed; // instead take a reference to the tail Cons(_, ref tail) => 1 + tail.len(), // Base Case: An empty list has zero length Nil => 0 } } // Return representation of the list as a (heap allocated) string fn stringify(&self) -> String { match *self { Cons(head, ref tail) => { // `format!` is similar to `print!`, but returns a heap // allocated string instead of printing to the console format!(\"{}, {}\", head, tail.stringify()) }, Nil => { format!(\"Nil\") }, } }\n} fn main() { // Create an empty linked list let mut list = List::new(); // Prepend some elements list = list.prepend(1); list = list.prepend(2); list = list.prepend(3); // Show the final state of the list println!(\"linked list has length: {}\", list.len()); println!(\"{}\", list.stringify());\n}","breadcrumbs":"Custom Types » Enums » Testcase: linked-list » Testcase: linked-list","id":"38","title":"Testcase: linked-list"},"39":{"body":"Box and methods","breadcrumbs":"Custom Types » Enums » Testcase: linked-list » See also:","id":"39","title":"See also:"},"4":{"body":"Library documentation","breadcrumbs":"Hello World » Comments » See also:","id":"4","title":"See also:"},"40":{"body":"Rust has two different types of constants which can be declared in any scope including global. Both require explicit type annotation: const: An unchangeable value (the common case). static: A possibly mutable variable with 'static lifetime. The static lifetime is inferred and does not have to be specified. Accessing or modifying a mutable static variable is unsafe . // Globals are declared outside all other scopes.\nstatic LANGUAGE: &str = \"Rust\";\nconst THRESHOLD: i32 = 10; fn is_big(n: i32) -> bool { // Access constant in some function n > THRESHOLD\n} fn main() { let n = 16; // Access constant in the main thread println!(\"This is {}\", LANGUAGE); println!(\"The threshold is {}\", THRESHOLD); println!(\"{} is {}\", n, if is_big(n) { \"big\" } else { \"small\" }); // Error! Cannot modify a `const`. THRESHOLD = 5; // FIXME ^ Comment out this line\n}","breadcrumbs":"Custom Types » constants » constants","id":"40","title":"constants"},"41":{"body":"The const/static RFC , 'static lifetime","breadcrumbs":"Custom Types » constants » See also:","id":"41","title":"See also:"},"42":{"body":"Rust provides type safety via static typing. Variable bindings can be type annotated when declared. However, in most cases, the compiler will be able to infer the type of the variable from the context, heavily reducing the annotation burden. Values (like literals) can be bound to variables, using the let binding. fn main() { let an_integer = 1u32; let a_boolean = true; let unit = (); // copy `an_integer` into `copied_integer` let copied_integer = an_integer; println!(\"An integer: {:?}\", copied_integer); println!(\"A boolean: {:?}\", a_boolean); println!(\"Meet the unit value: {:?}\", unit); // The compiler warns about unused variable bindings; these warnings can // be silenced by prefixing the variable name with an underscore let _unused_variable = 3u32; let noisy_unused_variable = 2u32; // FIXME ^ Prefix with an underscore to suppress the warning // Please note that warnings may not be shown in a browser\n}","breadcrumbs":"Variable Bindings » Variable Bindings","id":"42","title":"Variable Bindings"},"43":{"body":"Variable bindings are immutable by default, but this can be overridden using the mut modifier. fn main() { let _immutable_binding = 1; let mut mutable_binding = 1; println!(\"Before mutation: {}\", mutable_binding); // Ok mutable_binding += 1; println!(\"After mutation: {}\", mutable_binding); // Error! Cannot assign a new value to an immutable variable _immutable_binding += 1;\n} The compiler will throw a detailed diagnostic about mutability errors.","breadcrumbs":"Variable Bindings » Mutability » Mutability","id":"43","title":"Mutability"},"44":{"body":"Variable bindings have a scope, and are constrained to live in a block . A block is a collection of statements enclosed by braces {}. fn main() { // This binding lives in the main function let long_lived_binding = 1; // This is a block, and has a smaller scope than the main function { // This binding only exists in this block let short_lived_binding = 2; println!(\"inner short: {}\", short_lived_binding); } // End of the block // Error! `short_lived_binding` doesn't exist in this scope println!(\"outer short: {}\", short_lived_binding); // FIXME ^ Comment out this line println!(\"outer long: {}\", long_lived_binding);\n} Also, variable shadowing is allowed. fn main() { let shadowed_binding = 1; { println!(\"before being shadowed: {}\", shadowed_binding); // This binding *shadows* the outer one let shadowed_binding = \"abc\"; println!(\"shadowed in inner block: {}\", shadowed_binding); } println!(\"outside inner block: {}\", shadowed_binding); // This binding *shadows* the previous binding let shadowed_binding = 2; println!(\"shadowed in outer block: {}\", shadowed_binding);\n}","breadcrumbs":"Variable Bindings » Scope and Shadowing » Scope and Shadowing","id":"44","title":"Scope and Shadowing"},"45":{"body":"It's possible to declare variable bindings first, and initialize them later. However, this form is seldom used, as it may lead to the use of uninitialized variables. fn main() { // Declare a variable binding let a_binding; { let x = 2; // Initialize the binding a_binding = x * x; } println!(\"a binding: {}\", a_binding); let another_binding; // Error! Use of uninitialized binding println!(\"another binding: {}\", another_binding); // FIXME ^ Comment out this line another_binding = 1; println!(\"another binding: {}\", another_binding);\n} The compiler forbids use of uninitialized variables, as this would lead to undefined behavior.","breadcrumbs":"Variable Bindings » Declare first » Declare first","id":"45","title":"Declare first"},"46":{"body":"When data is bound by the same name immutably, it also freezes . Frozen data can't be modified until the immutable binding goes out of scope: fn main() { let mut _mutable_integer = 7i32; { // Shadowing by immutable `_mutable_integer` let _mutable_integer = _mutable_integer; // Error! `_mutable_integer` is frozen in this scope _mutable_integer = 50; // FIXME ^ Comment out this line // `_mutable_integer` goes out of scope } // Ok! `_mutable_integer` is not frozen in this scope _mutable_integer = 3;\n}","breadcrumbs":"Variable Bindings » Freezing » Freezing","id":"46","title":"Freezing"},"47":{"body":"Rust provides several mechanisms to change or define the type of primitive and user defined types. The following sections cover: Casting between primitive types Specifying the desired type of literals Using type inference Aliasing types","breadcrumbs":"Types » Types","id":"47","title":"Types"},"48":{"body":"Rust provides no implicit type conversion (coercion) between primitive types. But, explicit type conversion (casting) can be performed using the as keyword. Rules for converting between integral types follow C conventions generally, except in cases where C has undefined behavior. The behavior of all casts between integral types is well defined in Rust. // Suppress all warnings from casts which overflow.\n#![allow(overflowing_literals)] fn main() { let decimal = 65.4321_f32; // Error! No implicit conversion let integer: u8 = decimal; // FIXME ^ Comment out this line // Explicit conversion let integer = decimal as u8; let character = integer as char; // Error! There are limitations in conversion rules. // A float cannot be directly converted to a char. let character = decimal as char; // FIXME ^ Comment out this line println!(\"Casting: {} -> {} -> {}\", decimal, integer, character); // when casting any value to an unsigned type, T, // T::MAX + 1 is added or subtracted until the value // fits into the new type // 1000 already fits in a u16 println!(\"1000 as a u16 is: {}\", 1000 as u16); // 1000 - 256 - 256 - 256 = 232 // Under the hood, the first 8 least significant bits (LSB) are kept, // while the rest towards the most significant bit (MSB) get truncated. println!(\"1000 as a u8 is : {}\", 1000 as u8); // -1 + 256 = 255 println!(\" -1 as a u8 is : {}\", (-1i8) as u8); // For positive numbers, this is the same as the modulus println!(\"1000 mod 256 is : {}\", 1000 % 256); // When casting to a signed type, the (bitwise) result is the same as // first casting to the corresponding unsigned type. If the most significant // bit of that value is 1, then the value is negative. // Unless it already fits, of course. println!(\" 128 as a i16 is: {}\", 128 as i16); // In boundary case 128 value in 8-bit two's complement representation is -128 println!(\" 128 as a i8 is : {}\", 128 as i8); // repeating the example above // 1000 as u8 -> 232 println!(\"1000 as a u8 is : {}\", 1000 as u8); // and the value of 232 in 8-bit two's complement representation is -24 println!(\" 232 as a i8 is : {}\", 232 as i8); // Since Rust 1.45, the `as` keyword performs a *saturating cast* // when casting from float to int. If the floating point value exceeds // the upper bound or is less than the lower bound, the returned value // will be equal to the bound crossed. // 300.0 as u8 is 255 println!(\" 300.0 as u8 is : {}\", 300.0_f32 as u8); // -100.0 as u8 is 0 println!(\"-100.0 as u8 is : {}\", -100.0_f32 as u8); // nan as u8 is 0 println!(\" nan as u8 is : {}\", f32::NAN as u8); // This behavior incurs a small runtime cost and can be avoided // with unsafe methods, however the results might overflow and // return **unsound values**. Use these methods wisely: unsafe { // 300.0 as u8 is 44 println!(\" 300.0 as u8 is : {}\", 300.0_f32.to_int_unchecked::<u8>()); // -100.0 as u8 is 156 println!(\"-100.0 as u8 is : {}\", (-100.0_f32).to_int_unchecked::<u8>()); // nan as u8 is 0 println!(\" nan as u8 is : {}\", f32::NAN.to_int_unchecked::<u8>()); }\n}","breadcrumbs":"Types » Casting » Casting","id":"48","title":"Casting"},"49":{"body":"Numeric literals can be type annotated by adding the type as a suffix. As an example, to specify that the literal 42 should have the type i32, write 42i32. The type of unsuffixed numeric literals will depend on how they are used. If no constraint exists, the compiler will use i32 for integers, and f64 for floating-point numbers. fn main() { // Suffixed literals, their types are known at initialization let x = 1u8; let y = 2u32; let z = 3f32; // Unsuffixed literals, their types depend on how they are used let i = 1; let f = 1.0; // `size_of_val` returns the size of a variable in bytes println!(\"size of `x` in bytes: {}\", std::mem::size_of_val(&x)); println!(\"size of `y` in bytes: {}\", std::mem::size_of_val(&y)); println!(\"size of `z` in bytes: {}\", std::mem::size_of_val(&z)); println!(\"size of `i` in bytes: {}\", std::mem::size_of_val(&i)); println!(\"size of `f` in bytes: {}\", std::mem::size_of_val(&f));\n} There are some concepts used in the previous code that haven't been explained yet, here's a brief explanation for the impatient readers: std::mem::size_of_val is a function, but called with its full path . Code can be split in logical units called modules . In this case, the size_of_val function is defined in the mem module, and the mem module is defined in the std crate . For more details, see modules and crates .","breadcrumbs":"Types » Literals » Literals","id":"49","title":"Literals"},"5":{"body":"Printing is handled by a series of macros defined in std::fmt some of which include: format!: write formatted text to String print!: same as format! but the text is printed to the console (io::stdout). println!: same as print! but a newline is appended. eprint!: same as print! but the text is printed to the standard error (io::stderr). eprintln!: same as eprint! but a newline is appended. All parse text in the same fashion. As a plus, Rust checks formatting correctness at compile time. fn main() { // In general, the `{}` will be automatically replaced with any // arguments. These will be stringified. println!(\"{} days\", 31); // Positional arguments can be used. Specifying an integer inside `{}` // determines which additional argument will be replaced. Arguments start // at 0 immediately after the format string. println!(\"{0}, this is {1}. {1}, this is {0}\", \"Alice\", \"Bob\"); // As can named arguments. println!(\"{subject} {verb} {object}\", object=\"the lazy dog\", subject=\"the quick brown fox\", verb=\"jumps over\"); // Different formatting can be invoked by specifying the format character // after a `:`. println!(\"Base 10: {}\", 69420); // 69420 println!(\"Base 2 (binary): {:b}\", 69420); // 10000111100101100 println!(\"Base 8 (octal): {:o}\", 69420); // 207454 println!(\"Base 16 (hexadecimal): {:x}\", 69420); // 10f2c println!(\"Base 16 (hexadecimal): {:X}\", 69420); // 10F2C // You can right-justify text with a specified width. This will // output \" 1\". (Four white spaces and a \"1\", for a total width of 5.) println!(\"{number:>5}\", number=1); // You can pad numbers with extra zeroes, println!(\"{number:0>5}\", number=1); // 00001 // and left-adjust by flipping the sign. This will output \"10000\". println!(\"{number:0<5}\", number=1); // 10000 // You can use named arguments in the format specifier by appending a `$`. println!(\"{number:0>width$}\", number=1, width=5); // Rust even checks to make sure the correct number of arguments are used. println!(\"My name is {0}, {1} {0}\", \"Bond\"); // FIXME ^ Add the missing argument: \"James\" // Only types that implement fmt::Display can be formatted with `{}`. User- // defined types do not implement fmt::Display by default. #[allow(dead_code)] // disable `dead_code` which warn against unused module struct Structure(i32); // This will not compile because `Structure` does not implement // fmt::Display. // println!(\"This struct `{}` won't print...\", Structure(3)); // TODO ^ Try uncommenting this line // For Rust 1.58 and above, you can directly capture the argument from a // surrounding variable. Just like the above, this will output // \" 1\", 4 white spaces and a \"1\". let number: f64 = 1.0; let width: usize = 5; println!(\"{number:>width$}\");\n} std::fmt contains many traits which govern the display of text. The base form of two important ones are listed below: fmt::Debug: Uses the {:?} marker. Format text for debugging purposes. fmt::Display: Uses the {} marker. Format text in a more elegant, user friendly fashion. Here, we used fmt::Display because the std library provides implementations for these types. To print text for custom types, more steps are required. Implementing the fmt::Display trait automatically implements the ToString trait which allows us to convert the type to String . In line 43 , #[allow(dead_code)] is an attribute which only apply to the module after it.","breadcrumbs":"Hello World » Formatted print » Formatted print","id":"5","title":"Formatted print"},"50":{"body":"The type inference engine is pretty smart. It does more than looking at the type of the value expression during an initialization. It also looks at how the variable is used afterwards to infer its type. Here's an advanced example of type inference: fn main() { // Because of the annotation, the compiler knows that `elem` has type u8. let elem = 5u8; // Create an empty vector (a growable array). let mut vec = Vec::new(); // At this point the compiler doesn't know the exact type of `vec`, it // just knows that it's a vector of something (`Vec<_>`). // Insert `elem` in the vector. vec.push(elem); // Aha! Now the compiler knows that `vec` is a vector of `u8`s (`Vec<u8>`) // TODO ^ Try commenting out the `vec.push(elem)` line println!(\"{:?}\", vec);\n} No type annotation of variables was needed, the compiler is happy and so is the programmer!","breadcrumbs":"Types » Inference » Inference","id":"50","title":"Inference"},"51":{"body":"The type statement can be used to give a new name to an existing type. Types must have UpperCamelCase names, or the compiler will raise a warning. The exception to this rule are the primitive types: usize, f32, etc. // `NanoSecond`, `Inch`, and `U64` are new names for `u64`.\ntype NanoSecond = u64;\ntype Inch = u64;\ntype U64 = u64; fn main() { // `NanoSecond` = `Inch` = `U64` = `u64`. let nanoseconds: NanoSecond = 5 as U64; let inches: Inch = 2 as U64; // Note that type aliases *don't* provide any extra type safety, because // aliases are *not* new types println!(\"{} nanoseconds + {} inches = {} unit?\", nanoseconds, inches, nanoseconds + inches);\n} The main use of aliases is to reduce boilerplate; for example the io::Result<T> type is an alias for the Result<T, io::Error> type.","breadcrumbs":"Types » Aliasing » Aliasing","id":"51","title":"Aliasing"},"52":{"body":"Attributes","breadcrumbs":"Types » Aliasing » See also:","id":"52","title":"See also:"},"53":{"body":"Primitive types can be converted to each other through casting . Rust addresses conversion between custom types (i.e., struct and enum) by the use of traits . The generic conversions will use the From and Into traits. However there are more specific ones for the more common cases, in particular when converting to and from Strings.","breadcrumbs":"Conversion » Conversion","id":"53","title":"Conversion"},"54":{"body":"The From and Into traits are inherently linked, and this is actually part of its implementation. If you are able to convert type A from type B, then it should be easy to believe that we should be able to convert type B to type A.","breadcrumbs":"Conversion » From and Into » From and Into","id":"54","title":"From and Into"},"55":{"body":"The From trait allows for a type to define how to create itself from another type, hence providing a very simple mechanism for converting between several types. There are numerous implementations of this trait within the standard library for conversion of primitive and common types. For example we can easily convert a str into a String let my_str = \"hello\";\nlet my_string = String::from(my_str); We can do similar for defining a conversion for our own type. use std::convert::From; #[derive(Debug)]\nstruct Number { value: i32,\n} impl From<i32> for Number { fn from(item: i32) -> Self { Number { value: item } }\n} fn main() { let num = Number::from(30); println!(\"My number is {:?}\", num);\n}","breadcrumbs":"Conversion » From and Into » From","id":"55","title":"From"},"56":{"body":"The Into trait is simply the reciprocal of the From trait. That is, if you have implemented the From trait for your type, Into will call it when necessary. Using the Into trait will typically require specification of the type to convert into as the compiler is unable to determine this most of the time. However this is a small trade-off considering we get the functionality for free. use std::convert::Into; #[derive(Debug)]\nstruct Number { value: i32,\n} impl Into<Number> for i32 { fn into(self) -> Number { Number { value: self } }\n} fn main() { let int = 5; // Try removing the type annotation let num: Number = int.into(); println!(\"My number is {:?}\", num);\n}","breadcrumbs":"Conversion » From and Into » Into","id":"56","title":"Into"},"57":{"body":"Similar to From and Into , TryFrom and TryInto are generic traits for converting between types. Unlike From/Into, the TryFrom/TryInto traits are used for fallible conversions, and as such, return Result s. use std::convert::TryFrom;\nuse std::convert::TryInto; #[derive(Debug, PartialEq)]\nstruct EvenNumber(i32); impl TryFrom<i32> for EvenNumber { type Error = (); fn try_from(value: i32) -> Result<Self, Self::Error> { if value % 2 == 0 { Ok(EvenNumber(value)) } else { Err(()) } }\n} fn main() { // TryFrom assert_eq!(EvenNumber::try_from(8), Ok(EvenNumber(8))); assert_eq!(EvenNumber::try_from(5), Err(())); // TryInto let result: Result<EvenNumber, ()> = 8i32.try_into(); assert_eq!(result, Ok(EvenNumber(8))); let result: Result<EvenNumber, ()> = 5i32.try_into(); assert_eq!(result, Err(()));\n}","breadcrumbs":"Conversion » TryFrom and TryInto » TryFrom and TryInto","id":"57","title":"TryFrom and TryInto"},"58":{"body":"","breadcrumbs":"Conversion » To and from Strings » To and from Strings","id":"58","title":"To and from Strings"},"59":{"body":"To convert any type to a String is as simple as implementing the ToString trait for the type. Rather than doing so directly, you should implement the fmt::Display trait which automagically provides ToString and also allows printing the type as discussed in the section on print! . use std::fmt; struct Circle { radius: i32\n} impl fmt::Display for Circle { fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result { write!(f, \"Circle of radius {}\", self.radius) }\n} fn main() { let circle = Circle { radius: 6 }; println!(\"{}\", circle.to_string());\n}","breadcrumbs":"Conversion » To and from Strings » Converting to String","id":"59","title":"Converting to String"},"6":{"body":"Fix the issue in the above code (see FIXME) so that it runs without error. Try uncommenting the line that attempts to format the Structure struct (see TODO) Add a println! macro call that prints: Pi is roughly 3.142 by controlling the number of decimal places shown. For the purposes of this exercise, use let pi = 3.141592 as an estimate for pi. (Hint: you may need to check the std::fmt documentation for setting the number of decimals to display)","breadcrumbs":"Hello World » Formatted print » Activities","id":"6","title":"Activities"},"60":{"body":"One of the more common types to convert a string into is a number. The idiomatic approach to this is to use the parse function and either to arrange for type inference or to specify the type to parse using the 'turbofish' syntax. Both alternatives are shown in the following example. This will convert the string into the type specified as long as the FromStr trait is implemented for that type. This is implemented for numerous types within the standard library. To obtain this functionality on a user defined type simply implement the FromStr trait for that type. fn main() { let parsed: i32 = \"5\".parse().unwrap(); let turbo_parsed = \"10\".parse::<i32>().unwrap(); let sum = parsed + turbo_parsed; println!(\"Sum: {:?}\", sum);\n}","breadcrumbs":"Conversion » To and from Strings » Parsing a String","id":"60","title":"Parsing a String"},"61":{"body":"A Rust program is (mostly) made up of a series of statements: fn main() { // statement // statement // statement\n} There are a few kinds of statements in Rust. The most common two are declaring a variable binding, and using a ; with an expression: fn main() { // variable binding let x = 5; // expression; x; x + 1; 15;\n} Blocks are expressions too, so they can be used as values in assignments. The last expression in the block will be assigned to the place expression such as a local variable. However, if the last expression of the block ends with a semicolon, the return value will be (). fn main() { let x = 5u32; let y = { let x_squared = x * x; let x_cube = x_squared * x; // This expression will be assigned to `y` x_cube + x_squared + x }; let z = { // The semicolon suppresses this expression and `()` is assigned to `z` 2 * x; }; println!(\"x is {:?}\", x); println!(\"y is {:?}\", y); println!(\"z is {:?}\", z);\n}","breadcrumbs":"Expressions » Expressions","id":"61","title":"Expressions"},"62":{"body":"An integral part of any programming language are ways to modify control flow: if/else, for, and others. Let's talk about them in Rust.","breadcrumbs":"Flow of Control » Flow of Control","id":"62","title":"Flow of Control"},"63":{"body":"Branching with if-else is similar to other languages. Unlike many of them, the boolean condition doesn't need to be surrounded by parentheses, and each condition is followed by a block. if-else conditionals are expressions, and, all branches must return the same type. fn main() { let n = 5; if n < 0 { print!(\"{} is negative\", n); } else if n > 0 { print!(\"{} is positive\", n); } else { print!(\"{} is zero\", n); } let big_n = if n < 10 && n > -10 { println!(\", and is a small number, increase ten-fold\"); // This expression returns an `i32`. 10 * n } else { println!(\", and is a big number, halve the number\"); // This expression must return an `i32` as well. n / 2 // TODO ^ Try suppressing this expression with a semicolon. }; // ^ Don't forget to put a semicolon here! All `let` bindings need it. println!(\"{} -> {}\", n, big_n);\n}","breadcrumbs":"Flow of Control » if/else » if/else","id":"63","title":"if/else"},"64":{"body":"Rust provides a loop keyword to indicate an infinite loop. The break statement can be used to exit a loop at anytime, whereas the continue statement can be used to skip the rest of the iteration and start a new one. fn main() { let mut count = 0u32; println!(\"Let's count until infinity!\"); // Infinite loop loop { count += 1; if count == 3 { println!(\"three\"); // Skip the rest of this iteration continue; } println!(\"{}\", count); if count == 5 { println!(\"OK, that's enough\"); // Exit this loop break; } }\n}","breadcrumbs":"Flow of Control » loop » loop","id":"64","title":"loop"},"65":{"body":"It's possible to break or continue outer loops when dealing with nested loops. In these cases, the loops must be annotated with some 'label, and the label must be passed to the break/continue statement. #![allow(unreachable_code, unused_labels)] fn main() { 'outer: loop { println!(\"Entered the outer loop\"); 'inner: loop { println!(\"Entered the inner loop\"); // This would break only the inner loop //break; // This breaks the outer loop break 'outer; } println!(\"This point will never be reached\"); } println!(\"Exited the outer loop\");\n}","breadcrumbs":"Flow of Control » loop » Nesting and labels » Nesting and labels","id":"65","title":"Nesting and labels"},"66":{"body":"One of the uses of a loop is to retry an operation until it succeeds. If the operation returns a value though, you might need to pass it to the rest of the code: put it after the break, and it will be returned by the loop expression. fn main() { let mut counter = 0; let result = loop { counter += 1; if counter == 10 { break counter * 2; } }; assert_eq!(result, 20);\n}","breadcrumbs":"Flow of Control » loop » Returning from loops » Returning from loops","id":"66","title":"Returning from loops"},"67":{"body":"The while keyword can be used to run a loop while a condition is true. Let's write the infamous FizzBuzz using a while loop. fn main() { // A counter variable let mut n = 1; // Loop while `n` is less than 101 while n < 101 { if n % 15 == 0 { println!(\"fizzbuzz\"); } else if n % 3 == 0 { println!(\"fizz\"); } else if n % 5 == 0 { println!(\"buzz\"); } else { println!(\"{}\", n); } // Increment counter n += 1; }\n}","breadcrumbs":"Flow of Control » while » while","id":"67","title":"while"},"68":{"body":"","breadcrumbs":"Flow of Control » for and range » for loops","id":"68","title":"for loops"},"69":{"body":"The for in construct can be used to iterate through an Iterator. One of the easiest ways to create an iterator is to use the range notation a..b. This yields values from a (inclusive) to b (exclusive) in steps of one. Let's write FizzBuzz using for instead of while. fn main() { // `n` will take the values: 1, 2, ..., 100 in each iteration for n in 1..101 { if n % 15 == 0 { println!(\"fizzbuzz\"); } else if n % 3 == 0 { println!(\"fizz\"); } else if n % 5 == 0 { println!(\"buzz\"); } else { println!(\"{}\", n); } }\n} Alternatively, a..=b can be used for a range that is inclusive on both ends. The above can be written as: fn main() { // `n` will take the values: 1, 2, ..., 100 in each iteration for n in 1..=100 { if n % 15 == 0 { println!(\"fizzbuzz\"); } else if n % 3 == 0 { println!(\"fizz\"); } else if n % 5 == 0 { println!(\"buzz\"); } else { println!(\"{}\", n); } }\n}","breadcrumbs":"Flow of Control » for and range » for and range","id":"69","title":"for and range"},"7":{"body":"std::fmt , macros , struct , traits , and dead_code","breadcrumbs":"Hello World » Formatted print » See also:","id":"7","title":"See also:"},"70":{"body":"The for in construct is able to interact with an Iterator in several ways. As discussed in the section on the Iterator trait, by default the for loop will apply the into_iter function to the collection. However, this is not the only means of converting collections into iterators. into_iter, iter and iter_mut all handle the conversion of a collection into an iterator in different ways, by providing different views on the data within. iter - This borrows each element of the collection through each iteration. Thus leaving the collection untouched and available for reuse after the loop. fn main() { let names = vec![\"Bob\", \"Frank\", \"Ferris\"]; for name in names.iter() { match name { &\"Ferris\" => println!(\"There is a rustacean among us!\"), // TODO ^ Try deleting the & and matching just \"Ferris\" _ => println!(\"Hello {}\", name), } } println!(\"names: {:?}\", names);\n} into_iter - This consumes the collection so that on each iteration the exact data is provided. Once the collection has been consumed it is no longer available for reuse as it has been 'moved' within the loop. fn main() { let names = vec![\"Bob\", \"Frank\", \"Ferris\"]; for name in names.into_iter() { match name { \"Ferris\" => println!(\"There is a rustacean among us!\"), _ => println!(\"Hello {}\", name), } } println!(\"names: {:?}\", names); // FIXME ^ Comment out this line\n} iter_mut - This mutably borrows each element of the collection, allowing for the collection to be modified in place. fn main() { let mut names = vec![\"Bob\", \"Frank\", \"Ferris\"]; for name in names.iter_mut() { *name = match name { &mut \"Ferris\" => \"There is a rustacean among us!\", _ => \"Hello\", } } println!(\"names: {:?}\", names);\n} In the above snippets note the type of match branch, that is the key difference in the types of iteration. The difference in type then of course implies differing actions that are able to be performed.","breadcrumbs":"Flow of Control » for and range » for and iterators","id":"70","title":"for and iterators"},"71":{"body":"Iterator","breadcrumbs":"Flow of Control » for and range » See also:","id":"71","title":"See also:"},"72":{"body":"Rust provides pattern matching via the match keyword, which can be used like a C switch. The first matching arm is evaluated and all possible values must be covered. fn main() { let number = 13; // TODO ^ Try different values for `number` println!(\"Tell me about {}\", number); match number { // Match a single value 1 => println!(\"One!\"), // Match several values 2 | 3 | 5 | 7 | 11 => println!(\"This is a prime\"), // TODO ^ Try adding 13 to the list of prime values // Match an inclusive range 13..=19 => println!(\"A teen\"), // Handle the rest of cases _ => println!(\"Ain't special\"), // TODO ^ Try commenting out this catch-all arm } let boolean = true; // Match is an expression too let binary = match boolean { // The arms of a match must cover all the possible values false => 0, true => 1, // TODO ^ Try commenting out one of these arms }; println!(\"{} -> {}\", boolean, binary);\n}","breadcrumbs":"Flow of Control » match » match","id":"72","title":"match"},"73":{"body":"A match block can destructure items in a variety of ways. Destructuring Tuples Destructuring Arrays and Slices Destructuring Enums Destructuring Pointers Destructuring Structures","breadcrumbs":"Flow of Control » match » Destructuring » Destructuring","id":"73","title":"Destructuring"},"74":{"body":"Tuples can be destructured in a match as follows: fn main() { let triple = (0, -2, 3); // TODO ^ Try different values for `triple` println!(\"Tell me about {:?}\", triple); // Match can be used to destructure a tuple match triple { // Destructure the second and third elements (0, y, z) => println!(\"First is `0`, `y` is {:?}, and `z` is {:?}\", y, z), (1, ..) => println!(\"First is `1` and the rest doesn't matter\"), (.., 2) => println!(\"last is `2` and the rest doesn't matter\"), (3, .., 4) => println!(\"First is `3`, last is `4`, and the rest doesn't matter\"), // `..` can be used to ignore the rest of the tuple _ => println!(\"It doesn't matter what they are\"), // `_` means don't bind the value to a variable }\n}","breadcrumbs":"Flow of Control » match » Destructuring » tuples » tuples","id":"74","title":"tuples"},"75":{"body":"Tuples","breadcrumbs":"Flow of Control » match » Destructuring » tuples » See also:","id":"75","title":"See also:"},"76":{"body":"Like tuples, arrays and slices can be destructured this way: fn main() { // Try changing the values in the array, or make it a slice! let array = [1, -2, 6]; match array { // Binds the second and the third elements to the respective variables [0, second, third] => println!(\"array[0] = 0, array[1] = {}, array[2] = {}\", second, third), // Single values can be ignored with _ [1, _, third] => println!( \"array[0] = 1, array[2] = {} and array[1] was ignored\", third ), // You can also bind some and ignore the rest [-1, second, ..] => println!( \"array[0] = -1, array[1] = {} and all the other ones were ignored\", second ), // The code below would not compile // [-1, second] => ... // Or store them in another array/slice (the type depends on // that of the value that is being matched against) [3, second, tail @ ..] => println!( \"array[0] = 3, array[1] = {} and the other elements were {:?}\", second, tail ), // Combining these patterns, we can, for example, bind the first and // last values, and store the rest of them in a single array [first, middle @ .., last] => println!( \"array[0] = {}, middle = {:?}, array[2] = {}\", first, middle, last ), }\n}","breadcrumbs":"Flow of Control » match » Destructuring » arrays/slices » arrays/slices","id":"76","title":"arrays/slices"},"77":{"body":"Arrays and Slices and Binding for @ sigil","breadcrumbs":"Flow of Control » match » Destructuring » arrays/slices » See also:","id":"77","title":"See also:"},"78":{"body":"An enum is destructured similarly: // `allow` required to silence warnings because only\n// one variant is used.\n#[allow(dead_code)]\nenum Color { // These 3 are specified solely by their name. Red, Blue, Green, // These likewise tie `u32` tuples to different names: color models. RGB(u32, u32, u32), HSV(u32, u32, u32), HSL(u32, u32, u32), CMY(u32, u32, u32), CMYK(u32, u32, u32, u32),\n} fn main() { let color = Color::RGB(122, 17, 40); // TODO ^ Try different variants for `color` println!(\"What color is it?\"); // An `enum` can be destructured using a `match`. match color { Color::Red => println!(\"The color is Red!\"), Color::Blue => println!(\"The color is Blue!\"), Color::Green => println!(\"The color is Green!\"), Color::RGB(r, g, b) => println!(\"Red: {}, green: {}, and blue: {}!\", r, g, b), Color::HSV(h, s, v) => println!(\"Hue: {}, saturation: {}, value: {}!\", h, s, v), Color::HSL(h, s, l) => println!(\"Hue: {}, saturation: {}, lightness: {}!\", h, s, l), Color::CMY(c, m, y) => println!(\"Cyan: {}, magenta: {}, yellow: {}!\", c, m, y), Color::CMYK(c, m, y, k) => println!(\"Cyan: {}, magenta: {}, yellow: {}, key (black): {}!\", c, m, y, k), // Don't need another arm because all variants have been examined }\n}","breadcrumbs":"Flow of Control » match » Destructuring » enums » enums","id":"78","title":"enums"},"79":{"body":"#[allow(...)] , color models and enum","breadcrumbs":"Flow of Control » match » Destructuring » enums » See also:","id":"79","title":"See also:"},"8":{"body":"All types which want to use std::fmt formatting traits require an implementation to be printable. Automatic implementations are only provided for types such as in the std library. All others must be manually implemented somehow. The fmt::Debug trait makes this very straightforward. All types can derive (automatically create) the fmt::Debug implementation. This is not true for fmt::Display which must be manually implemented. // This structure cannot be printed either with `fmt::Display` or\n// with `fmt::Debug`.\nstruct UnPrintable(i32); // The `derive` attribute automatically creates the implementation\n// required to make this `struct` printable with `fmt::Debug`.\n#[derive(Debug)]\nstruct DebugPrintable(i32); All std library types are automatically printable with {:?} too: // Derive the `fmt::Debug` implementation for `Structure`. `Structure`\n// is a structure which contains a single `i32`.\n#[derive(Debug)]\nstruct Structure(i32); // Put a `Structure` inside of the structure `Deep`. Make it printable\n// also.\n#[derive(Debug)]\nstruct Deep(Structure); fn main() { // Printing with `{:?}` is similar to with `{}`. println!(\"{:?} months in a year.\", 12); println!(\"{1:?} {0:?} is the {actor:?} name.\", \"Slater\", \"Christian\", actor=\"actor's\"); // `Structure` is printable! println!(\"Now {:?} will print!\", Structure(3)); // The problem with `derive` is there is no control over how // the results look. What if I want this to just show a `7`? println!(\"Now {:?} will print!\", Deep(Structure(7)));\n} So fmt::Debug definitely makes this printable but sacrifices some elegance. Rust also provides \"pretty printing\" with {:#?}. #[derive(Debug)]\nstruct Person<'a> { name: &'a str, age: u8\n} fn main() { let name = \"Peter\"; let age = 27; let peter = Person { name, age }; // Pretty print println!(\"{:#?}\", peter);\n} One can manually implement fmt::Display to control the display.","breadcrumbs":"Hello World » Formatted print » Debug » Debug","id":"8","title":"Debug"},"80":{"body":"For pointers, a distinction needs to be made between destructuring and dereferencing as they are different concepts which are used differently from languages like C/C++. Dereferencing uses * Destructuring uses &, ref, and ref mut fn main() { // Assign a reference of type `i32`. The `&` signifies there // is a reference being assigned. let reference = &4; match reference { // If `reference` is pattern matched against `&val`, it results // in a comparison like: // `&i32` // `&val` // ^ We see that if the matching `&`s are dropped, then the `i32` // should be assigned to `val`. &val => println!(\"Got a value via destructuring: {:?}\", val), } // To avoid the `&`, you dereference before matching. match *reference { val => println!(\"Got a value via dereferencing: {:?}\", val), } // What if you don't start with a reference? `reference` was a `&` // because the right side was already a reference. This is not // a reference because the right side is not one. let _not_a_reference = 3; // Rust provides `ref` for exactly this purpose. It modifies the // assignment so that a reference is created for the element; this // reference is assigned. let ref _is_a_reference = 3; // Accordingly, by defining 2 values without references, references // can be retrieved via `ref` and `ref mut`. let value = 5; let mut mut_value = 6; // Use `ref` keyword to create a reference. match value { ref r => println!(\"Got a reference to a value: {:?}\", r), } // Use `ref mut` similarly. match mut_value { ref mut m => { // Got a reference. Gotta dereference it before we can // add anything to it. *m += 10; println!(\"We added 10. `mut_value`: {:?}\", m); }, }\n}","breadcrumbs":"Flow of Control » match » Destructuring » pointers/ref » pointers/ref","id":"80","title":"pointers/ref"},"81":{"body":"The ref pattern","breadcrumbs":"Flow of Control » match » Destructuring » pointers/ref » See also:","id":"81","title":"See also:"},"82":{"body":"Similarly, a struct can be destructured as shown: fn main() { struct Foo { x: (u32, u32), y: u32, } // Try changing the values in the struct to see what happens let foo = Foo { x: (1, 2), y: 3 }; match foo { Foo { x: (1, b), y } => println!(\"First of x is 1, b = {}, y = {} \", b, y), // you can destructure structs and rename the variables, // the order is not important Foo { y: 2, x: i } => println!(\"y is 2, i = {:?}\", i), // and you can also ignore some variables: Foo { y, .. } => println!(\"y = {}, we don't care about x\", y), // this will give an error: pattern does not mention field `x` //Foo { y } => println!(\"y = {}\", y), } let faa = Foo { x: (1, 2), y: 3 }; // You do not need a match block to destructure structs: let Foo { x : x0, y: y0 } = faa; println!(\"Outside: x0 = {x0:?}, y0 = {y0}\"); // Destructuring works with nested structs as well: struct Bar { foo: Foo, } let bar = Bar { foo: faa }; let Bar { foo: Foo { x: nested_x, y: nested_y } } = bar; println!(\"Nested: nested_x = {nested_x:?}, nested_y = {nested_y:?}\");\n}","breadcrumbs":"Flow of Control » match » Destructuring » structs » structs","id":"82","title":"structs"},"83":{"body":"Structs","breadcrumbs":"Flow of Control » match » Destructuring » structs » See also:","id":"83","title":"See also:"},"84":{"body":"A match guard can be added to filter the arm. #[allow(dead_code)]\nenum Temperature { Celsius(i32), Fahrenheit(i32),\n} fn main() { let temperature = Temperature::Celsius(35); // ^ TODO try different values for `temperature` match temperature { Temperature::Celsius(t) if t > 30 => println!(\"{}C is above 30 Celsius\", t), // The `if condition` part ^ is a guard Temperature::Celsius(t) => println!(\"{}C is equal to or below 30 Celsius\", t), Temperature::Fahrenheit(t) if t > 86 => println!(\"{}F is above 86 Fahrenheit\", t), Temperature::Fahrenheit(t) => println!(\"{}F is equal to or below 86 Fahrenheit\", t), }\n} Note that the compiler won't take guard conditions into account when checking if all patterns are covered by the match expression. fn main() { let number: u8 = 4; match number { i if i == 0 => println!(\"Zero\"), i if i > 0 => println!(\"Greater than zero\"), // _ => unreachable!(\"Should never happen.\"), // TODO ^ uncomment to fix compilation }\n}","breadcrumbs":"Flow of Control » match » Guards » Guards","id":"84","title":"Guards"},"85":{"body":"Tuples Enums","breadcrumbs":"Flow of Control » match » Guards » See also:","id":"85","title":"See also:"},"86":{"body":"Indirectly accessing a variable makes it impossible to branch and use that variable without re-binding. match provides the @ sigil for binding values to names: // A function `age` which returns a `u32`.\nfn age() -> u32 { 15\n} fn main() { println!(\"Tell me what type of person you are\"); match age() { 0 => println!(\"I haven't celebrated my first birthday yet\"), // Could `match` 1 ..= 12 directly but then what age // would the child be? Instead, bind to `n` for the // sequence of 1 ..= 12. Now the age can be reported. n @ 1 ..= 12 => println!(\"I'm a child of age {:?}\", n), n @ 13 ..= 19 => println!(\"I'm a teen of age {:?}\", n), // Nothing bound. Return the result. n => println!(\"I'm an old person of age {:?}\", n), }\n} You can also use binding to \"destructure\" enum variants, such as Option: fn some_number() -> Option<u32> { Some(42)\n} fn main() { match some_number() { // Got `Some` variant, match if its value, bound to `n`, // is equal to 42. Some(n @ 42) => println!(\"The Answer: {}!\", n), // Match any other number. Some(n) => println!(\"Not interesting... {}\", n), // Match anything else (`None` variant). _ => (), }\n}","breadcrumbs":"Flow of Control » match » Binding » Binding","id":"86","title":"Binding"},"87":{"body":"functions , enums and Option","breadcrumbs":"Flow of Control » match » Binding » See also:","id":"87","title":"See also:"},"88":{"body":"For some use cases, when matching enums, match is awkward. For example: // Make `optional` of type `Option<i32>`\nlet optional = Some(7); match optional { Some(i) => { println!(\"This is a really long string and `{:?}`\", i); // ^ Needed 2 indentations just so we could destructure // `i` from the option. }, _ => {}, // ^ Required because `match` is exhaustive. Doesn't it seem // like wasted space?\n}; if let is cleaner for this use case and in addition allows various failure options to be specified: fn main() { // All have type `Option<i32>` let number = Some(7); let letter: Option<i32> = None; let emoticon: Option<i32> = None; // The `if let` construct reads: \"if `let` destructures `number` into // `Some(i)`, evaluate the block (`{}`). if let Some(i) = number { println!(\"Matched {:?}!\", i); } // If you need to specify a failure, use an else: if let Some(i) = letter { println!(\"Matched {:?}!\", i); } else { // Destructure failed. Change to the failure case. println!(\"Didn't match a number. Let's go with a letter!\"); } // Provide an altered failing condition. let i_like_letters = false; if let Some(i) = emoticon { println!(\"Matched {:?}!\", i); // Destructure failed. Evaluate an `else if` condition to see if the // alternate failure branch should be taken: } else if i_like_letters { println!(\"Didn't match a number. Let's go with a letter!\"); } else { // The condition evaluated false. This branch is the default: println!(\"I don't like letters. Let's go with an emoticon :)!\"); }\n} In the same way, if let can be used to match any enum value: // Our example enum\nenum Foo { Bar, Baz, Qux(u32)\n} fn main() { // Create example variables let a = Foo::Bar; let b = Foo::Baz; let c = Foo::Qux(100); // Variable a matches Foo::Bar if let Foo::Bar = a { println!(\"a is foobar\"); } // Variable b does not match Foo::Bar // So this will print nothing if let Foo::Bar = b { println!(\"b is foobar\"); } // Variable c matches Foo::Qux which has a value // Similar to Some() in the previous example if let Foo::Qux(value) = c { println!(\"c is {}\", value); } // Binding also works with `if let` if let Foo::Qux(value @ 100) = c { println!(\"c is one hundred\"); }\n} Another benefit is that if let allows us to match non-parameterized enum variants. This is true even in cases where the enum doesn't implement or derive PartialEq. In such cases if Foo::Bar == a would fail to compile, because instances of the enum cannot be equated, however if let will continue to work. Would you like a challenge? Fix the following example to use if let: // This enum purposely neither implements nor derives PartialEq.\n// That is why comparing Foo::Bar == a fails below.\nenum Foo {Bar} fn main() { let a = Foo::Bar; // Variable a matches Foo::Bar if Foo::Bar == a { // ^-- this causes a compile-time error. Use `if let` instead. println!(\"a is foobar\"); }\n}","breadcrumbs":"Flow of Control » if let » if let","id":"88","title":"if let"},"89":{"body":"enum , Option , and the RFC","breadcrumbs":"Flow of Control » if let » See also:","id":"89","title":"See also:"},"9":{"body":"attributes , derive , std::fmt , and struct","breadcrumbs":"Hello World » Formatted print » Debug » See also:","id":"9","title":"See also:"},"90":{"body":"🛈 stable since: rust 1.65 🛈 you can target specific edition by compiling like this rustc --edition=2021 main.rs With let-else, a refutable pattern can match and bind variables in the surrounding scope like a normal let, or else diverge (e.g. break, return, panic!) when the pattern doesn't match. use std::str::FromStr; fn get_count_item(s: &str) -> (u64, &str) { let mut it = s.split(' '); let (Some(count_str), Some(item)) = (it.next(), it.next()) else { panic!(\"Can't segment count item pair: '{s}'\"); }; let Ok(count) = u64::from_str(count_str) else { panic!(\"Can't parse integer: '{count_str}'\"); }; (count, item)\n} fn main() { assert_eq!(get_count_item(\"3 chairs\"), (3, \"chairs\"));\n} The scope of name bindings is the main thing that makes this different from match or if let-else expressions. You could previously approximate these patterns with an unfortunate bit of repetition and an outer let: # use std::str::FromStr;\n# # fn get_count_item(s: &str) -> (u64, &str) {\n# let mut it = s.split(' '); let (count_str, item) = match (it.next(), it.next()) { (Some(count_str), Some(item)) => (count_str, item), _ => panic!(\"Can't segment count item pair: '{s}'\"), }; let count = if let Ok(count) = u64::from_str(count_str) { count } else { panic!(\"Can't parse integer: '{count_str}'\"); };\n# (count, item)\n# }\n# # assert_eq!(get_count_item(\"3 chairs\"), (3, \"chairs\"));","breadcrumbs":"Flow of Control » let-else » let-else","id":"90","title":"let-else"},"91":{"body":"option , match , if let and the let-else RFC .","breadcrumbs":"Flow of Control » let-else » See also:","id":"91","title":"See also:"},"92":{"body":"Similar to if let, while let can make awkward match sequences more tolerable. Consider the following sequence that increments i: // Make `optional` of type `Option<i32>`\nlet mut optional = Some(0); // Repeatedly try this test.\nloop { match optional { // If `optional` destructures, evaluate the block. Some(i) => { if i > 9 { println!(\"Greater than 9, quit!\"); optional = None; } else { println!(\"`i` is `{:?}`. Try again.\", i); optional = Some(i + 1); } // ^ Requires 3 indentations! }, // Quit the loop when the destructure fails: _ => { break; } // ^ Why should this be required? There must be a better way! }\n} Using while let makes this sequence much nicer: // Make `optional` of type `Option<i32>`\nlet mut optional = Some(0); // This reads: \"while `let` destructures `optional` into\n// `Some(i)`, evaluate the block (`{}`). Else `break`.\nwhile let Some(i) = optional { if i > 9 { println!(\"Greater than 9, quit!\"); optional = None; } else { println!(\"`i` is `{:?}`. Try again.\", i); optional = Some(i + 1); } // ^ Less rightward drift and doesn't require // explicitly handling the failing case.\n}\n// ^ `if let` had additional optional `else`/`else if`\n// clauses. `while let` does not have these.","breadcrumbs":"Flow of Control » while let » while let","id":"92","title":"while let"},"93":{"body":"enum , Option , and the RFC","breadcrumbs":"Flow of Control » while let » See also:","id":"93","title":"See also:"},"94":{"body":"Functions are declared using the fn keyword. Its arguments are type annotated, just like variables, and, if the function returns a value, the return type must be specified after an arrow ->. The final expression in the function will be used as return value. Alternatively, the return statement can be used to return a value earlier from within the function, even from inside loops or if statements. Let's rewrite FizzBuzz using functions! // Unlike C/C++, there's no restriction on the order of function definitions\nfn main() { // We can use this function here, and define it somewhere later fizzbuzz_to(100);\n} // Function that returns a boolean value\nfn is_divisible_by(lhs: u32, rhs: u32) -> bool { // Corner case, early return if rhs == 0 { return false; } // This is an expression, the `return` keyword is not necessary here lhs % rhs == 0\n} // Functions that \"don't\" return a value, actually return the unit type `()`\nfn fizzbuzz(n: u32) -> () { if is_divisible_by(n, 15) { println!(\"fizzbuzz\"); } else if is_divisible_by(n, 3) { println!(\"fizz\"); } else if is_divisible_by(n, 5) { println!(\"buzz\"); } else { println!(\"{}\", n); }\n} // When a function returns `()`, the return type can be omitted from the\n// signature\nfn fizzbuzz_to(n: u32) { for n in 1..=n { fizzbuzz(n); }\n}","breadcrumbs":"Functions » Functions","id":"94","title":"Functions"},"95":{"body":"Some functions are connected to a particular type. These come in two forms: associated functions, and methods. Associated functions are functions that are defined on a type generally, while methods are associated functions that are called on a particular instance of a type. struct Point { x: f64, y: f64,\n} // Implementation block, all `Point` associated functions & methods go in here\nimpl Point { // This is an \"associated function\" because this function is associated with // a particular type, that is, Point. // // Associated functions don't need to be called with an instance. // These functions are generally used like constructors. fn origin() -> Point { Point { x: 0.0, y: 0.0 } } // Another associated function, taking two arguments: fn new(x: f64, y: f64) -> Point { Point { x: x, y: y } }\n} struct Rectangle { p1: Point, p2: Point,\n} impl Rectangle { // This is a method // `&self` is sugar for `self: &Self`, where `Self` is the type of the // caller object. In this case `Self` = `Rectangle` fn area(&self) -> f64 { // `self` gives access to the struct fields via the dot operator let Point { x: x1, y: y1 } = self.p1; let Point { x: x2, y: y2 } = self.p2; // `abs` is a `f64` method that returns the absolute value of the // caller ((x1 - x2) * (y1 - y2)).abs() } fn perimeter(&self) -> f64 { let Point { x: x1, y: y1 } = self.p1; let Point { x: x2, y: y2 } = self.p2; 2.0 * ((x1 - x2).abs() + (y1 - y2).abs()) } // This method requires the caller object to be mutable // `&mut self` desugars to `self: &mut Self` fn translate(&mut self, x: f64, y: f64) { self.p1.x += x; self.p2.x += x; self.p1.y += y; self.p2.y += y; }\n} // `Pair` owns resources: two heap allocated integers\nstruct Pair(Box<i32>, Box<i32>); impl Pair { // This method \"consumes\" the resources of the caller object // `self` desugars to `self: Self` fn destroy(self) { // Destructure `self` let Pair(first, second) = self; println!(\"Destroying Pair({}, {})\", first, second); // `first` and `second` go out of scope and get freed }\n} fn main() { let rectangle = Rectangle { // Associated functions are called using double colons p1: Point::origin(), p2: Point::new(3.0, 4.0), }; // Methods are called using the dot operator // Note that the first argument `&self` is implicitly passed, i.e. // `rectangle.perimeter()` === `Rectangle::perimeter(&rectangle)` println!(\"Rectangle perimeter: {}\", rectangle.perimeter()); println!(\"Rectangle area: {}\", rectangle.area()); let mut square = Rectangle { p1: Point::origin(), p2: Point::new(1.0, 1.0), }; // Error! `rectangle` is immutable, but this method requires a mutable // object //rectangle.translate(1.0, 0.0); // TODO ^ Try uncommenting this line // Okay! Mutable objects can call mutable methods square.translate(1.0, 1.0); let pair = Pair(Box::new(1), Box::new(2)); pair.destroy(); // Error! Previous `destroy` call \"consumed\" `pair` //pair.destroy(); // TODO ^ Try uncommenting this line\n}","breadcrumbs":"Functions » Methods » Associated functions & Methods","id":"95","title":"Associated functions & Methods"},"96":{"body":"Closures are functions that can capture the enclosing environment. For example, a closure that captures the x variable: |val| val + x The syntax and capabilities of closures make them very convenient for on the fly usage. Calling a closure is exactly like calling a function. However, both input and return types can be inferred and input variable names must be specified. Other characteristics of closures include: using || instead of () around input variables. optional body delimitation ({}) for a single line expression (mandatory otherwise). the ability to capture the outer environment variables. fn main() { let outer_var = 42; // A regular function can't refer to variables in the enclosing environment //fn function(i: i32) -> i32 { i + outer_var } // TODO: uncomment the line above and see the compiler error. The compiler // suggests that we define a closure instead. // Closures are anonymous, here we are binding them to references. // Annotation is identical to function annotation but is optional // as are the `{}` wrapping the body. These nameless functions // are assigned to appropriately named variables. let closure_annotated = |i: i32| -> i32 { i + outer_var }; let closure_inferred = |i | i + outer_var ; // Call the closures. println!(\"closure_annotated: {}\", closure_annotated(1)); println!(\"closure_inferred: {}\", closure_inferred(1)); // Once closure's type has been inferred, it cannot be inferred again with another type. //println!(\"cannot reuse closure_inferred with another type: {}\", closure_inferred(42i64)); // TODO: uncomment the line above and see the compiler error. // A closure taking no arguments which returns an `i32`. // The return type is inferred. let one = || 1; println!(\"closure returning one: {}\", one()); }","breadcrumbs":"Functions » Closures » Closures","id":"96","title":"Closures"},"97":{"body":"Closures are inherently flexible and will do what the functionality requires to make the closure work without annotation. This allows capturing to flexibly adapt to the use case, sometimes moving and sometimes borrowing. Closures can capture variables: by reference: &T by mutable reference: &mut T by value: T They preferentially capture variables by reference and only go lower when required. fn main() { use std::mem; let color = String::from(\"green\"); // A closure to print `color` which immediately borrows (`&`) `color` and // stores the borrow and closure in the `print` variable. It will remain // borrowed until `print` is used the last time. // // `println!` only requires arguments by immutable reference so it doesn't // impose anything more restrictive. let print = || println!(\"`color`: {}\", color); // Call the closure using the borrow. print(); // `color` can be borrowed immutably again, because the closure only holds // an immutable reference to `color`. let _reborrow = &color; print(); // A move or reborrow is allowed after the final use of `print` let _color_moved = color; let mut count = 0; // A closure to increment `count` could take either `&mut count` or `count` // but `&mut count` is less restrictive so it takes that. Immediately // borrows `count`. // // A `mut` is required on `inc` because a `&mut` is stored inside. Thus, // calling the closure mutates `count` which requires a `mut`. let mut inc = || { count += 1; println!(\"`count`: {}\", count); }; // Call the closure using a mutable borrow. inc(); // The closure still mutably borrows `count` because it is called later. // An attempt to reborrow will lead to an error. // let _reborrow = &count; // ^ TODO: try uncommenting this line. inc(); // The closure no longer needs to borrow `&mut count`. Therefore, it is // possible to reborrow without an error let _count_reborrowed = &mut count; // A non-copy type. let movable = Box::new(3); // `mem::drop` requires `T` so this must take by value. A copy type // would copy into the closure leaving the original untouched. // A non-copy must move and so `movable` immediately moves into // the closure. let consume = || { println!(\"`movable`: {:?}\", movable); mem::drop(movable); }; // `consume` consumes the variable so this can only be called once. consume(); // consume(); // ^ TODO: Try uncommenting this line.\n} Using move before vertical pipes forces closure to take ownership of captured variables: fn main() { // `Vec` has non-copy semantics. let haystack = vec![1, 2, 3]; let contains = move |needle| haystack.contains(needle); println!(\"{}\", contains(&1)); println!(\"{}\", contains(&4)); // println!(\"There're {} elements in vec\", haystack.len()); // ^ Uncommenting above line will result in compile-time error // because borrow checker doesn't allow re-using variable after it // has been moved. // Removing `move` from closure's signature will cause closure // to borrow _haystack_ variable immutably, hence _haystack_ is still // available and uncommenting above line will not cause an error.\n}","breadcrumbs":"Functions » Closures » Capturing » Capturing","id":"97","title":"Capturing"},"98":{"body":"Box and std::mem::drop","breadcrumbs":"Functions » Closures » Capturing » See also:","id":"98","title":"See also:"},"99":{"body":"While Rust chooses how to capture variables on the fly mostly without type annotation, this ambiguity is not allowed when writing functions. When taking a closure as an input parameter, the closure's complete type must be annotated using one of a few traits, and they're determined by what the closure does with captured value. In order of decreasing restriction, they are: Fn: the closure uses the captured value by reference (&T) FnMut: the closure uses the captured value by mutable reference (&mut T) FnOnce: the closure uses the captured value by value (T) On a variable-by-variable basis, the compiler will capture variables in the least restrictive manner possible. For instance, consider a parameter annotated as FnOnce. This specifies that the closure may capture by &T, &mut T, or T, but the compiler will ultimately choose based on how the captured variables are used in the closure. This is because if a move is possible, then any type of borrow should also be possible. Note that the reverse is not true. If the parameter is annotated as Fn, then capturing variables by &mut T or T are not allowed. However, &T is allowed. In the following example, try swapping the usage of Fn, FnMut, and FnOnce to see what happens: // A function which takes a closure as an argument and calls it.\n// <F> denotes that F is a \"Generic type parameter\"\nfn apply<F>(f: F) where // The closure takes no input and returns nothing. F: FnOnce() { // ^ TODO: Try changing this to `Fn` or `FnMut`. f();\n} // A function which takes a closure and returns an `i32`.\nfn apply_to_3<F>(f: F) -> i32 where // The closure takes an `i32` and returns an `i32`. F: Fn(i32) -> i32 { f(3)\n} fn main() { use std::mem; let greeting = \"hello\"; // A non-copy type. // `to_owned` creates owned data from borrowed one let mut farewell = \"goodbye\".to_owned(); // Capture 2 variables: `greeting` by reference and // `farewell` by value. let diary = || { // `greeting` is by reference: requires `Fn`. println!(\"I said {}.\", greeting); // Mutation forces `farewell` to be captured by // mutable reference. Now requires `FnMut`. farewell.push_str(\"!!!\"); println!(\"Then I screamed {}.\", farewell); println!(\"Now I can sleep. zzzzz\"); // Manually calling drop forces `farewell` to // be captured by value. Now requires `FnOnce`. mem::drop(farewell); }; // Call the function which applies the closure. apply(diary); // `double` satisfies `apply_to_3`'s trait bound let double = |x| 2 * x; println!(\"3 doubled: {}\", apply_to_3(double));\n}","breadcrumbs":"Functions » Closures » As input parameters » As input parameters","id":"99","title":"As input parameters"}},"length":339,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{".":{".":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"n":{"df":1,"docs":{"112":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"1":{"0":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"260":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"260":{"tf":1.0},"272":{"tf":1.0}}},"df":0,"docs":{}},"3":{"df":1,"docs":{"203":{"tf":2.23606797749979}}},"5":{"df":1,"docs":{"127":{"tf":1.4142135623730951}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"275":{"tf":1.0},"279":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"113":{"tf":1.0}}}}},"df":0,"docs":{}}},"x":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"0":{"0":{"0":{"0":{"0":{"1":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"0":{"0":{"1":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"16":{"tf":1.4142135623730951},"259":{"tf":2.0},"264":{"tf":1.7320508075688772},"265":{"tf":1.7320508075688772},"301":{"tf":1.0},"95":{"tf":1.7320508075688772}}},"1":{".":{"0":{"df":1,"docs":{"125":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"28":{"tf":1.0}},"f":{"3":{"2":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"2":{"3":{"4":{"df":1,"docs":{"199":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"6":{"4":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"3":{"5":{"df":1,"docs":{"127":{"tf":1.0}}},"df":0,"docs":{}},"4":{"df":1,"docs":{"28":{"tf":1.0}}},"5":{"df":1,"docs":{"199":{"tf":1.0}}},"8":{"9":{"df":1,"docs":{"127":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"0":{"1":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"0":{"1":{"df":1,"docs":{"23":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"b":{"df":1,"docs":{"23":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"6":{"df":0,"docs":{},"x":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}},":":{"df":0,"docs":{},"h":{"df":1,"docs":{"321":{"tf":1.0}}},"l":{"df":1,"docs":{"321":{"tf":1.0}}}},">":{"2":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"u":{"8":{"df":1,"docs":{"319":{"tf":1.0}}},"df":0,"docs":{}}},"b":{"0":{"0":{"1":{"1":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"23":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"0":{"1":{"df":1,"docs":{"23":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"23":{"tf":1.0}}},"df":49,"docs":{"110":{"tf":1.4142135623730951},"112":{"tf":1.7320508075688772},"113":{"tf":1.0},"127":{"tf":2.6457513110645907},"13":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":2.0},"164":{"tf":2.0},"17":{"tf":2.0},"174":{"tf":1.7320508075688772},"175":{"tf":1.4142135623730951},"203":{"tf":1.4142135623730951},"206":{"tf":1.0},"217":{"tf":1.7320508075688772},"218":{"tf":1.0},"26":{"tf":1.7320508075688772},"260":{"tf":1.0},"263":{"tf":1.4142135623730951},"266":{"tf":2.8284271247461903},"297":{"tf":1.4142135623730951},"300":{"tf":1.7320508075688772},"302":{"tf":3.4641016151377544},"303":{"tf":4.242640687119285},"304":{"tf":4.58257569495584},"305":{"tf":3.4641016151377544},"306":{"tf":1.0},"308":{"tf":4.0},"316":{"tf":2.0},"317":{"tf":1.7320508075688772},"319":{"tf":1.4142135623730951},"323":{"tf":2.8284271247461903},"324":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"48":{"tf":1.7320508075688772},"5":{"tf":2.0},"57":{"tf":1.0},"63":{"tf":1.4142135623730951},"66":{"tf":1.0},"67":{"tf":1.7320508075688772},"69":{"tf":2.449489742783178},"72":{"tf":1.0},"74":{"tf":1.7320508075688772},"76":{"tf":1.4142135623730951},"8":{"tf":1.0},"84":{"tf":1.4142135623730951},"86":{"tf":1.0},"94":{"tf":1.4142135623730951},"97":{"tf":1.0}},"i":{"df":1,"docs":{"297":{"tf":1.0}}},"o":{"3":{"3":{"6":{"5":{"3":{"3":{"3":{"7":{"3":{"5":{"7":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"23":{"tf":1.0}}},"u":{"3":{"2":{".":{".":{"1":{"_":{"0":{"0":{"0":{"df":1,"docs":{"164":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{".":{".":{"1":{"0":{"df":1,"docs":{"217":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"x":{"0":{"0":{"0":{"0":{"0":{"0":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"36":{"tf":1.0}}}}},"3":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"0":{"0":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"318":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"8":{"0":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"5":{"a":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"3":{"2":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"a":{"b":{"a":{"b":{"df":1,"docs":{"321":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"321":{"tf":1.0}}},"df":0,"docs":{}},"d":{"1":{"df":1,"docs":{"318":{"tf":1.0}}},"df":0,"docs":{},"e":{"a":{"d":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"23":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"0":{"0":{"0":{"0":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"{":{":":{"df":0,"docs":{},"x":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}}}},"1":{",":{"0":{"1":{"3":{"df":1,"docs":{"164":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{",":{"3":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"4":{"8":{"df":1,"docs":{"266":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},".":{".":{"1":{"0":{"1":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"=":{"1":{"0":{"0":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":1,"docs":{"94":{"tf":1.0}}}},"df":0,"docs":{}},"0":{"df":4,"docs":{"21":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0},"95":{"tf":1.4142135623730951}}},"1":{"df":1,"docs":{"25":{"tf":1.7320508075688772}}},"2":{"df":3,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.7320508075688772}}},"4":{"5":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"5":{"8":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"6":{"5":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"\"":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"i":{"3":{"2":{">":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},".":{"0":{"df":2,"docs":{"264":{"tf":1.0},"265":{"tf":1.0}}},"3":{"df":1,"docs":{"28":{"tf":1.0}}},"7":{"5":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{".":{"0":{"_":{"df":0,"docs":{},"f":{"3":{"2":{")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{":":{":":{"<":{"df":0,"docs":{},"u":{"8":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"48":{"tf":2.0}}},"df":0,"docs":{}},"0":{"0":{"1":{"1":{"1":{"1":{"0":{"0":{"1":{"0":{"1":{"1":{"0":{"0":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"5":{"tf":1.4142135623730951}}},"df":3,"docs":{"112":{"tf":1.4142135623730951},"23":{"tf":1.0},"48":{"tf":2.6457513110645907}}},"df":5,"docs":{"191":{"tf":2.0},"3":{"tf":1.0},"304":{"tf":1.0},"69":{"tf":1.4142135623730951},"88":{"tf":1.0}}},"1":{"0":{"1":{"0":{"df":1,"docs":{"323":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"304":{"tf":1.4142135623730951}}},"df":15,"docs":{"156":{"tf":1.0},"158":{"tf":1.0},"185":{"tf":1.0},"236":{"tf":1.0},"24":{"tf":1.0},"275":{"tf":1.0},"3":{"tf":1.0},"302":{"tf":1.0},"312":{"tf":1.4142135623730951},"323":{"tf":1.4142135623730951},"40":{"tf":1.0},"5":{"tf":1.0},"63":{"tf":1.7320508075688772},"66":{"tf":1.0},"80":{"tf":1.4142135623730951}},"f":{"2":{"c":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"1":{"8":{"6":{"1":{"3":{"2":{"2":{"5":{"7":{"5":{"5":{"6":{"4":{"7":{"2":{"3":{"9":{"6":{"3":{"2":{"9":{"7":{"5":{"4":{"2":{"6":{"2":{"4":{"9":{"6":{"2":{"8":{"5":{"0":{"df":1,"docs":{"276":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"24":{"tf":1.0},"323":{"tf":1.0},"72":{"tf":1.0}}},"2":{"3":{".":{"1":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{".":{"0":{".":{"0":{".":{"1":{"\\":{"df":0,"docs":{},"n":{"1":{"9":{"2":{".":{"1":{"6":{"8":{".":{"0":{".":{"1":{"\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"287":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"287":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"df":4,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"318":{"tf":1.4142135623730951},"48":{"tf":2.449489742783178}}},"df":7,"docs":{"177":{"tf":1.0},"21":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"317":{"tf":1.0},"319":{"tf":1.0},"8":{"tf":1.0},"86":{"tf":1.7320508075688772}}},"3":{".":{".":{"=":{"1":{"9":{"df":1,"docs":{"72":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"267":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":4,"docs":{"110":{"tf":1.0},"24":{"tf":1.0},"72":{"tf":1.4142135623730951},"86":{"tf":1.0}}},"4":{"df":1,"docs":{"10":{"tf":1.0}}},"5":{"6":{"df":1,"docs":{"48":{"tf":1.0}}},"7":{"4":{"df":1,"docs":{"334":{"tf":1.0}}},"df":0,"docs":{}},"df":7,"docs":{"183":{"tf":1.0},"192":{"tf":1.0},"61":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.4142135623730951},"86":{"tf":1.0},"94":{"tf":1.0}}},"6":{"2":{"7":{"8":{"4":{"2":{"4":{"6":{"3":{"7":{"4":{"5":{"2":{"5":{"8":{"9":{"8":{"6":{"0":{"3":{"4":{"5":{"3":{"7":{"4":{"8":{"2":{"8":{"5":{"7":{"4":{"6":{"6":{"8":{"df":1,"docs":{"276":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"df":1,"docs":{"267":{"tf":1.0}}},"df":4,"docs":{"192":{"tf":1.0},"317":{"tf":1.0},"40":{"tf":1.0},"5":{"tf":1.4142135623730951}}},"7":{"4":{"5":{"df":1,"docs":{"267":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"78":{"tf":1.0}}},"8":{"df":15,"docs":{"152":{"tf":1.0},"183":{"tf":1.0},"191":{"tf":1.0},"243":{"tf":1.4142135623730951},"244":{"tf":2.0},"245":{"tf":1.4142135623730951},"246":{"tf":1.4142135623730951},"248":{"tf":1.4142135623730951},"250":{"tf":1.4142135623730951},"252":{"tf":1.0},"253":{"tf":1.0},"254":{"tf":1.0},"255":{"tf":1.0},"256":{"tf":1.4142135623730951},"266":{"tf":1.4142135623730951}}},"9":{"2":{".":{"1":{"6":{"8":{".":{"0":{".":{"1":{"df":1,"docs":{"287":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"6":{"df":1,"docs":{"334":{"tf":1.0}}},"df":0,"docs":{}},"7":{"9":{"df":1,"docs":{"172":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"86":{"tf":1.0}}},"_":{"0":{"0":{"0":{"_":{"0":{"0":{"0":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":61,"docs":{"108":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.4142135623730951},"113":{"tf":1.0},"14":{"tf":1.4142135623730951},"148":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.0},"177":{"tf":1.0},"179":{"tf":1.0},"181":{"tf":1.0},"203":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"214":{"tf":1.4142135623730951},"215":{"tf":1.0},"218":{"tf":2.0},"219":{"tf":2.0},"224":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.7320508075688772},"241":{"tf":1.0},"243":{"tf":1.4142135623730951},"244":{"tf":1.0},"257":{"tf":1.0},"26":{"tf":1.4142135623730951},"269":{"tf":1.7320508075688772},"270":{"tf":1.4142135623730951},"291":{"tf":1.0},"294":{"tf":1.7320508075688772},"296":{"tf":1.7320508075688772},"297":{"tf":1.4142135623730951},"300":{"tf":1.7320508075688772},"303":{"tf":1.7320508075688772},"304":{"tf":1.7320508075688772},"308":{"tf":1.4142135623730951},"309":{"tf":1.0},"316":{"tf":1.0},"317":{"tf":1.4142135623730951},"319":{"tf":1.0},"323":{"tf":1.4142135623730951},"324":{"tf":1.0},"38":{"tf":1.0},"43":{"tf":2.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"48":{"tf":2.0},"49":{"tf":1.0},"5":{"tf":2.6457513110645907},"61":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"76":{"tf":2.449489742783178},"82":{"tf":2.0},"86":{"tf":1.7320508075688772},"92":{"tf":1.4142135623730951},"96":{"tf":1.0},"97":{"tf":1.0}},"e":{"4":{"df":1,"docs":{"23":{"tf":1.0}}},"6":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}},"i":{"3":{"2":{"df":1,"docs":{"23":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"8":{"df":2,"docs":{"24":{"tf":1.4142135623730951},"48":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"320":{"tf":1.0}}}},"u":{"3":{"2":{"df":5,"docs":{"203":{"tf":1.0},"214":{"tf":1.0},"217":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"42":{"tf":1.0}}},"df":0,"docs":{}},"8":{"df":2,"docs":{"24":{"tf":1.4142135623730951},"49":{"tf":1.0}}},"df":0,"docs":{}}},"2":{",":{"0":{"0":{"0":{"df":1,"docs":{"277":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"0":{"df":1,"docs":{"95":{"tf":1.0}}},"1":{"df":2,"docs":{"24":{"tf":1.0},"25":{"tf":1.7320508075688772}}},"2":{"7":{".":{"1":{"df":1,"docs":{"125":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"24":{"tf":1.0},"25":{"tf":1.7320508075688772}}},"5":{"4":{"df":1,"docs":{"197":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"23":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"0":{"0":{"2":{"df":2,"docs":{"164":{"tf":1.0},"266":{"tf":1.0}}},"df":0,"docs":{}},"1":{"3":{"df":2,"docs":{"164":{"tf":1.0},"266":{"tf":1.0}}},"4":{"df":1,"docs":{"172":{"tf":1.4142135623730951}}},"5":{"df":3,"docs":{"123":{"tf":1.0},"242":{"tf":1.0},"326":{"tf":1.0}}},"8":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}}}}}},"df":3,"docs":{"301":{"tf":1.0},"326":{"tf":1.0},"38":{"tf":1.0}}},"df":0,"docs":{}},"7":{"4":{"5":{"4":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"31":{"tf":1.0},"66":{"tf":1.0}}},"1":{"df":3,"docs":{"21":{"tf":1.0},"262":{"tf":1.0},"305":{"tf":1.0}}},"3":{"2":{"df":1,"docs":{"48":{"tf":2.23606797749979}}},"df":0,"docs":{}},"4":{"df":1,"docs":{"48":{"tf":1.0}}},"5":{"4":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.0}}},"5":{"df":3,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"48":{"tf":1.4142135623730951}}},"6":{"df":1,"docs":{"48":{"tf":2.449489742783178}}},"df":0,"docs":{}},"6":{"8":{"7":{"3":{"df":1,"docs":{"164":{"tf":3.7416573867739413}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"df":2,"docs":{"28":{"tf":1.0},"8":{"tf":1.0}}},"8":{"df":1,"docs":{"210":{"tf":1.0}}},"b":{"df":1,"docs":{"323":{"tf":1.0}}},"df":71,"docs":{"108":{"tf":2.449489742783178},"110":{"tf":3.4641016151377544},"112":{"tf":1.4142135623730951},"127":{"tf":1.7320508075688772},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"148":{"tf":1.4142135623730951},"150":{"tf":1.0},"156":{"tf":1.0},"158":{"tf":1.0},"164":{"tf":1.4142135623730951},"17":{"tf":1.0},"174":{"tf":1.0},"189":{"tf":1.0},"203":{"tf":1.0},"206":{"tf":2.0},"21":{"tf":1.0},"214":{"tf":1.0},"215":{"tf":1.0},"216":{"tf":1.7320508075688772},"218":{"tf":2.0},"219":{"tf":2.0},"23":{"tf":2.449489742783178},"235":{"tf":1.4142135623730951},"237":{"tf":2.0},"238":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"240":{"tf":1.4142135623730951},"241":{"tf":1.4142135623730951},"242":{"tf":1.4142135623730951},"243":{"tf":1.7320508075688772},"244":{"tf":1.7320508075688772},"245":{"tf":1.0},"246":{"tf":1.0},"257":{"tf":1.0},"26":{"tf":1.0},"260":{"tf":1.0},"263":{"tf":1.0},"269":{"tf":1.7320508075688772},"291":{"tf":1.0},"294":{"tf":1.4142135623730951},"296":{"tf":1.0},"300":{"tf":1.7320508075688772},"302":{"tf":1.0},"303":{"tf":1.7320508075688772},"304":{"tf":1.7320508075688772},"305":{"tf":1.0},"306":{"tf":1.0},"308":{"tf":1.4142135623730951},"313":{"tf":1.0},"317":{"tf":1.0},"319":{"tf":1.0},"320":{"tf":1.0},"323":{"tf":2.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"5":{"tf":1.0},"51":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.4142135623730951},"72":{"tf":1.0},"74":{"tf":1.7320508075688772},"76":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":2.0},"88":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.4142135623730951}},"f":{"df":1,"docs":{"323":{"tf":1.0}}},"i":{"1":{"6":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"3":{"2":{"df":1,"docs":{"215":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"1":{"6":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"3":{"2":{"df":5,"docs":{"175":{"tf":1.0},"217":{"tf":1.7320508075688772},"24":{"tf":1.0},"42":{"tf":1.0},"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"3":{".":{"0":{"df":4,"docs":{"140":{"tf":1.0},"144":{"tf":1.4142135623730951},"21":{"tf":1.0},"259":{"tf":1.4142135623730951}}},"1":{"0":{".":{"0":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"df":0,"docs":{},"n":{"df":1,"docs":{"266":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"1":{"5":{"9":{"2":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"df":2,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951}}},"9":{".":{"0":{"df":1,"docs":{"164":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{".":{"0":{"_":{"df":0,"docs":{},"f":{"3":{"2":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{":":{":":{"<":{"df":0,"docs":{},"u":{"8":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"48":{"tf":2.0}}},"df":0,"docs":{}},"df":1,"docs":{"10":{"tf":1.4142135623730951}}},"df":1,"docs":{"84":{"tf":1.7320508075688772}}},"1":{"df":2,"docs":{"305":{"tf":1.0},"5":{"tf":1.0}}},"2":{"df":4,"docs":{"23":{"tf":1.4142135623730951},"276":{"tf":1.0},"319":{"tf":1.4142135623730951},"321":{"tf":1.0}}},"6":{"5":{"df":1,"docs":{"152":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"7":{"3":{"5":{"9":{"2":{"8":{"5":{"5":{"9":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"3":{"9":{"7":{"9":{"6":{"6":{"7":{"0":{"7":{"1":{"0":{"6":{"0":{"9":{"4":{"1":{"7":{"2":{"7":{"8":{"3":{"2":{"3":{"8":{"7":{"4":{"7":{"6":{"6":{"9":{"2":{"1":{"9":{"df":1,"docs":{"276":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"]":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"269":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":54,"docs":{"10":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951},"110":{"tf":2.0},"13":{"tf":1.0},"130":{"tf":1.0},"14":{"tf":1.0},"148":{"tf":1.4142135623730951},"150":{"tf":1.0},"156":{"tf":1.0},"158":{"tf":1.0},"16":{"tf":1.7320508075688772},"17":{"tf":1.0},"176":{"tf":1.0},"179":{"tf":1.0},"189":{"tf":1.0},"194":{"tf":1.0},"203":{"tf":1.4142135623730951},"206":{"tf":2.0},"21":{"tf":1.0},"216":{"tf":1.0},"217":{"tf":1.4142135623730951},"218":{"tf":1.7320508075688772},"219":{"tf":2.23606797749979},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"257":{"tf":1.0},"26":{"tf":1.0},"260":{"tf":1.7320508075688772},"269":{"tf":1.7320508075688772},"279":{"tf":1.0},"294":{"tf":1.7320508075688772},"296":{"tf":1.0},"300":{"tf":1.7320508075688772},"302":{"tf":1.4142135623730951},"304":{"tf":1.0},"305":{"tf":1.7320508075688772},"309":{"tf":1.0},"313":{"tf":1.0},"316":{"tf":1.7320508075688772},"323":{"tf":1.4142135623730951},"46":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.4142135623730951},"72":{"tf":1.0},"74":{"tf":1.7320508075688772},"76":{"tf":1.4142135623730951},"78":{"tf":1.0},"80":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951},"92":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}},"f":{"3":{"2":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"3":{"2":{"df":2,"docs":{"140":{"tf":1.0},"24":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"3":{"2":{"df":4,"docs":{"175":{"tf":1.0},"217":{"tf":1.7320508075688772},"24":{"tf":1.0},"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"4":{".":{"0":{"df":4,"docs":{"144":{"tf":1.4142135623730951},"259":{"tf":1.4142135623730951},"301":{"tf":1.0},"95":{"tf":1.0}}},"5":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}},"0":{"df":1,"docs":{"78":{"tf":1.0}}},"2":{"9":{"4":{"9":{"6":{"7":{"2":{"9":{"6":{"df":0,"docs":{},"i":{"6":{"4":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":4,"docs":{"296":{"tf":1.7320508075688772},"49":{"tf":1.0},"86":{"tf":1.4142135623730951},"96":{"tf":1.0}},"i":{"3":{"2":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"3":{"5":{"df":1,"docs":{"267":{"tf":1.0}}},"9":{"2":{"2":{"2":{"2":{"2":{"2":{"df":1,"docs":{"224":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"296":{"tf":1.0},"5":{"tf":1.0}}},"4":{"0":{"1":{"df":1,"docs":{"266":{"tf":3.7416573867739413}}},"df":0,"docs":{}},"df":1,"docs":{"48":{"tf":1.0}}},"9":{".":{"2":{"5":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"]":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"269":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":25,"docs":{"108":{"tf":1.0},"110":{"tf":1.0},"127":{"tf":1.4142135623730951},"168":{"tf":1.4142135623730951},"177":{"tf":1.0},"20":{"tf":1.0},"216":{"tf":1.0},"218":{"tf":1.4142135623730951},"219":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.4142135623730951},"260":{"tf":1.0},"269":{"tf":2.0},"304":{"tf":1.0},"313":{"tf":1.0},"317":{"tf":2.23606797749979},"319":{"tf":1.7320508075688772},"321":{"tf":1.0},"324":{"tf":1.4142135623730951},"326":{"tf":1.0},"5":{"tf":1.0},"74":{"tf":1.4142135623730951},"80":{"tf":1.0},"84":{"tf":1.0}},"i":{"3":{"2":{"df":1,"docs":{"215":{"tf":1.0}}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"6":{"4":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"5":{"\"":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},".":{"2":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"0":{"0":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}},"df":1,"docs":{"46":{"tf":1.0}}},"2":{"3":{"8":{"0":{"7":{"9":{"5":{"2":{"5":{"7":{"8":{"8":{"8":{"2":{"3":{"6":{"5":{"2":{"5":{"4":{"5":{"9":{"3":{"0":{"3":{"3":{"3":{"0":{"3":{"0":{"2":{"8":{"3":{"7":{"df":1,"docs":{"276":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{".":{"3":{"4":{"7":{"7":{"7":{"8":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"4":{"9":{"5":{"3":{"2":{"7":{"1":{"3":{"5":{"7":{"4":{"4":{"0":{"4":{"1":{"0":{"4":{"8":{"8":{"9":{"7":{"8":{"8":{"5":{"7":{"3":{"4":{"2":{"9":{"7":{"8":{"1":{"2":{"df":1,"docs":{"276":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{".":{"9":{"5":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"171":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":30,"docs":{"108":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951},"127":{"tf":1.4142135623730951},"174":{"tf":1.0},"192":{"tf":1.0},"206":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"26":{"tf":1.4142135623730951},"269":{"tf":1.4142135623730951},"290":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"302":{"tf":1.0},"305":{"tf":1.4142135623730951},"308":{"tf":1.4142135623730951},"309":{"tf":1.0},"316":{"tf":2.8284271247461903},"323":{"tf":1.0},"40":{"tf":1.0},"5":{"tf":1.4142135623730951},"51":{"tf":1.0},"56":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.4142135623730951},"72":{"tf":1.0},"80":{"tf":1.0},"94":{"tf":1.0}},"i":{"3":{"2":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"57":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":2,"docs":{"171":{"tf":1.0},"21":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"3":{"2":{"df":3,"docs":{"167":{"tf":1.0},"24":{"tf":1.4142135623730951},"61":{"tf":1.0}}},"df":0,"docs":{}},"8":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}}},"6":{".":{"2":{"5":{"9":{"7":{"2":{"2":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"5":{"df":1,"docs":{"267":{"tf":1.4142135623730951}}},"df":6,"docs":{"26":{"tf":1.4142135623730951},"314":{"tf":1.4142135623730951},"318":{"tf":2.0},"319":{"tf":1.7320508075688772},"321":{"tf":1.4142135623730951},"324":{"tf":1.0}}},"5":{".":{"4":{"3":{"2":{"1":{"_":{"df":0,"docs":{},"f":{"3":{"2":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"3":{"5":{"df":1,"docs":{"262":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"4":{"3":{"df":1,"docs":{"267":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"4":{"2":{"0":{"df":1,"docs":{"5":{"tf":2.449489742783178}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"2":{"0":{"2":{"1":{"6":{"4":{"3":{"8":{"9":{"8":{"0":{"8":{"7":{"3":{"5":{"4":{"8":{"8":{"0":{"8":{"4":{"1":{"3":{"7":{"2":{"0":{"9":{"5":{"6":{"5":{"3":{"2":{"df":1,"docs":{"276":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"171":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":8,"docs":{"108":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951},"206":{"tf":1.0},"24":{"tf":1.0},"319":{"tf":1.4142135623730951},"59":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.0}},"u":{"3":{"2":{"df":1,"docs":{"217":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"7":{".":{"2":{"df":2,"docs":{"10":{"tf":1.0},"11":{"tf":1.0}},"i":{"df":1,"docs":{"11":{"tf":1.0}}}},"6":{"df":0,"docs":{},"e":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}},"0":{"8":{"5":{"6":{"2":{"3":{"4":{"7":{"0":{"1":{"8":{"6":{"0":{"8":{"5":{"1":{"9":{"0":{"7":{"9":{"6":{"0":{"6":{"9":{"0":{"0":{"1":{"4":{"7":{"2":{"5":{"6":{"3":{"9":{"df":1,"docs":{"276":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"8":{"9":{"df":1,"docs":{"267":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"8":{"df":1,"docs":{"267":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":10,"docs":{"101":{"tf":1.0},"179":{"tf":1.0},"187":{"tf":1.0},"203":{"tf":1.0},"21":{"tf":1.0},"219":{"tf":1.4142135623730951},"24":{"tf":1.0},"305":{"tf":1.0},"72":{"tf":1.0},"8":{"tf":1.0}},"i":{"3":{"2":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"8":{",":{"6":{"9":{"6":{"df":1,"docs":{"164":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":1,"docs":{"31":{"tf":1.0}}},"2":{"9":{"1":{"df":1,"docs":{"267":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"9":{"6":{"7":{"8":{"9":{"7":{"7":{"3":{"7":{"4":{"1":{"6":{"4":{"7":{"1":{"8":{"5":{"3":{"2":{"9":{"7":{"3":{"2":{"7":{"0":{"5":{"0":{"3":{"6":{"4":{"9":{"5":{"9":{"df":1,"docs":{"276":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"84":{"tf":1.7320508075688772}}},"df":10,"docs":{"24":{"tf":1.0},"261":{"tf":1.4142135623730951},"262":{"tf":1.7320508075688772},"280":{"tf":1.4142135623730951},"316":{"tf":1.7320508075688772},"317":{"tf":1.0},"319":{"tf":1.0},"324":{"tf":1.0},"48":{"tf":1.7320508075688772},"5":{"tf":1.0}},"i":{"3":{"2":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"57":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"9":{"0":{"df":3,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"3":{"tf":1.0}}},"3":{"df":11,"docs":{"243":{"tf":1.4142135623730951},"244":{"tf":2.0},"245":{"tf":1.4142135623730951},"246":{"tf":1.4142135623730951},"248":{"tf":1.4142135623730951},"250":{"tf":1.4142135623730951},"252":{"tf":1.0},"253":{"tf":1.0},"254":{"tf":1.0},"255":{"tf":1.0},"256":{"tf":1.4142135623730951}}},"5":{"6":{"df":1,"docs":{"267":{"tf":1.0}}},"df":0,"docs":{}},"9":{"9":{"df":1,"docs":{"254":{"tf":1.0}}},"df":0,"docs":{}},"df":7,"docs":{"110":{"tf":1.0},"113":{"tf":1.0},"177":{"tf":1.0},"179":{"tf":1.0},"191":{"tf":1.0},"24":{"tf":1.0},"92":{"tf":2.0}}},"_":{"a":{"df":2,"docs":{"113":{"tf":1.0},"202":{"tf":1.4142135623730951}}},"b":{"df":1,"docs":{"202":{"tf":1.0}},"o":{"df":0,"docs":{},"x":{"1":{"df":1,"docs":{"164":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"164":{"tf":1.4142135623730951}}},"3":{"df":1,"docs":{"164":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"c":{"df":1,"docs":{"202":{"tf":1.0}},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"136":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"116":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"x":{"df":1,"docs":{"175":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"97":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"d":{"df":1,"docs":{"202":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"280":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":26,"docs":{"127":{"tf":1.4142135623730951},"142":{"tf":1.4142135623730951},"156":{"tf":1.4142135623730951},"158":{"tf":2.0},"164":{"tf":1.0},"175":{"tf":1.7320508075688772},"179":{"tf":1.0},"189":{"tf":1.0},"227":{"tf":1.4142135623730951},"255":{"tf":1.0},"267":{"tf":1.7320508075688772},"268":{"tf":1.0},"272":{"tf":1.0},"275":{"tf":1.0},"279":{"tf":1.0},"296":{"tf":1.7320508075688772},"319":{"tf":2.23606797749979},"70":{"tf":1.7320508075688772},"72":{"tf":1.0},"74":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"84":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0}},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"263":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"h":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"k":{"_":{"df":1,"docs":{"97":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"p":{"_":{"df":1,"docs":{"167":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"i":{"3":{"2":{"df":1,"docs":{"136":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"_":{"a":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"80":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"46":{"tf":3.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"a":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"80":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"218":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"197":{"tf":2.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"262":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"97":{"tf":1.4142135623730951}}}}}}}},"c":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"171":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"290":{"tf":1.0}}}}}}},"h":{"df":1,"docs":{"200":{"tf":1.4142135623730951}}}},"s":{"df":2,"docs":{"136":{"tf":1.0},"138":{"tf":2.0}},"t":{"a":{"c":{"df":0,"docs":{},"k":{"_":{"df":1,"docs":{"167":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"1":{"df":1,"docs":{"159":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"159":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"df":1,"docs":{"136":{"tf":1.0}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"197":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"144":{"tf":1.0}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"159":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"159":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"146":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"42":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"x":{"df":2,"docs":{"177":{"tf":2.0},"266":{"tf":1.4142135623730951}}},"y":{"df":1,"docs":{"177":{"tf":1.4142135623730951}}}},"a":{".":{".":{"=":{"b":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"b":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"a":{"d":{"d":{"(":{"b":{"df":1,"docs":{"200":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"(":{"&":{"b":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{":":{":":{"<":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"<":{"&":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"269":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"&":{"b":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{":":{":":{"<":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"<":{"&":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"269":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"217":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"(":{"&":{"b":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{":":{":":{"<":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"<":{"&":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"269":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"&":{"b":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{":":{":":{"<":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"<":{"&":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"269":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"/":{"b":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"291":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"c":{"/":{"b":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"\"":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"291":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"291":{"tf":2.0}}}}}},"df":0,"docs":{}},"d":{"df":1,"docs":{"291":{"tf":2.0}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"291":{"tf":2.0}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"291":{"tf":1.0}}},"df":0,"docs":{}},":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"217":{"tf":1.0}}}}}}},">":{"(":{"&":{"'":{"a":{"df":1,"docs":{"187":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"45":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"42":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}}}},"a":{"a":{"df":1,"docs":{"136":{"tf":1.0}}},"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"6":{"4":{"df":1,"docs":{"314":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"b":{"c":{"df":2,"docs":{"23":{"tf":1.0},"44":{"tf":1.0}}},"df":1,"docs":{"95":{"tf":1.0}},"i":{"df":1,"docs":{"320":{"tf":2.0}},"l":{"df":2,"docs":{"306":{"tf":1.0},"96":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"222":{"tf":2.0}}}},"v":{"df":33,"docs":{"108":{"tf":1.0},"11":{"tf":1.0},"125":{"tf":1.0},"127":{"tf":1.0},"136":{"tf":1.0},"140":{"tf":1.0},"169":{"tf":1.0},"17":{"tf":1.0},"179":{"tf":1.0},"187":{"tf":1.0},"2":{"tf":1.0},"214":{"tf":1.0},"230":{"tf":1.4142135623730951},"232":{"tf":1.0},"237":{"tf":1.0},"238":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"250":{"tf":1.0},"286":{"tf":1.0},"289":{"tf":1.0},"316":{"tf":1.0},"317":{"tf":1.0},"319":{"tf":1.0},"34":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.4142135623730951},"6":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"84":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"223":{"tf":1.0},"235":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"220":{"tf":1.0},"95":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"113":{"tf":1.0},"212":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"c":{"df":2,"docs":{"112":{"tf":1.7320508075688772},"113":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":6,"docs":{"136":{"tf":1.0},"179":{"tf":1.0},"215":{"tf":1.0},"25":{"tf":1.0},"302":{"tf":1.0},"318":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":23,"docs":{"115":{"tf":2.0},"116":{"tf":1.7320508075688772},"118":{"tf":1.4142135623730951},"119":{"tf":1.7320508075688772},"144":{"tf":1.4142135623730951},"167":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0},"174":{"tf":1.0},"19":{"tf":1.0},"191":{"tf":1.0},"196":{"tf":1.0},"26":{"tf":1.0},"276":{"tf":1.0},"28":{"tf":1.4142135623730951},"282":{"tf":1.0},"294":{"tf":1.0},"311":{"tf":1.0},"314":{"tf":1.0},"324":{"tf":1.0},"40":{"tf":1.7320508075688772},"86":{"tf":1.0},"95":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":4,"docs":{"0":{"tf":1.0},"171":{"tf":1.0},"200":{"tf":1.0},"263":{"tf":1.0}}}}}}}},"r":{"d":{"df":1,"docs":{"320":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"80":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"<":{"'":{"a":{"df":1,"docs":{"268":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"268":{"tf":1.0}}}}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"268":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"268":{"tf":1.4142135623730951}}}}}}},"df":2,"docs":{"268":{"tf":2.23606797749979},"84":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"<":{"'":{"a":{"df":1,"docs":{"268":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"268":{"tf":1.0}}}}}},"s":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"268":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"a":{"c":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"268":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"<":{"'":{"a":{"df":1,"docs":{"268":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"112":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":3,"docs":{"242":{"tf":1.0},"314":{"tf":1.0},"317":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"164":{"tf":1.0}}}}}}}},"t":{"df":2,"docs":{"159":{"tf":1.0},"316":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":6,"docs":{"136":{"tf":1.0},"167":{"tf":1.0},"187":{"tf":1.0},"223":{"tf":1.0},"241":{"tf":1.0},"70":{"tf":1.0}}}},"v":{"df":8,"docs":{"11":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.0},"6":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"=":{"\"":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"8":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":11,"docs":{"127":{"tf":1.0},"136":{"tf":1.0},"248":{"tf":1.4142135623730951},"262":{"tf":1.0},"269":{"tf":1.0},"276":{"tf":1.0},"3":{"tf":1.0},"316":{"tf":1.4142135623730951},"324":{"tf":1.0},"54":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"269":{"tf":1.0},"97":{"tf":1.0}}}}},"d":{"(":{"a":{"df":5,"docs":{"300":{"tf":1.0},"304":{"tf":1.0},"305":{"tf":1.0},"308":{"tf":1.0},"309":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"161":{"tf":1.4142135623730951},"200":{"tf":1.4142135623730951}}}}}}},"<":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"200":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"200":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"h":{"df":1,"docs":{"161":{"tf":1.0}}}}},"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"217":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"179":{"tf":1.0}}}}}},"df":0,"docs":{}},"<":{"'":{"a":{">":{"(":{"&":{"'":{"a":{"df":1,"docs":{"181":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"x":{"df":1,"docs":{"179":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":31,"docs":{"11":{"tf":1.0},"125":{"tf":1.7320508075688772},"126":{"tf":1.0},"128":{"tf":1.0},"13":{"tf":1.0},"131":{"tf":1.0},"161":{"tf":3.0},"17":{"tf":1.0},"196":{"tf":1.0},"2":{"tf":1.0},"200":{"tf":2.23606797749979},"201":{"tf":1.0},"202":{"tf":1.4142135623730951},"206":{"tf":1.0},"217":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"250":{"tf":1.0},"262":{"tf":1.4142135623730951},"276":{"tf":1.0},"29":{"tf":1.4142135623730951},"305":{"tf":1.0},"316":{"tf":1.4142135623730951},"317":{"tf":1.7320508075688772},"319":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"323":{"tf":1.4142135623730951},"324":{"tf":1.4142135623730951},"336":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"80":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"308":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"t":{"df":16,"docs":{"103":{"tf":1.0},"113":{"tf":1.7320508075688772},"126":{"tf":1.4142135623730951},"142":{"tf":1.0},"144":{"tf":1.0},"161":{"tf":1.0},"187":{"tf":1.0},"197":{"tf":1.0},"200":{"tf":1.7320508075688772},"218":{"tf":1.0},"23":{"tf":1.0},"250":{"tf":1.0},"298":{"tf":1.0},"5":{"tf":1.0},"88":{"tf":1.0},"92":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":8,"docs":{"0":{"tf":1.0},"150":{"tf":1.0},"177":{"tf":1.0},"179":{"tf":1.0},"187":{"tf":1.0},"21":{"tf":1.0},"235":{"tf":1.0},"336":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":6,"docs":{"167":{"tf":1.0},"318":{"tf":1.0},"321":{"tf":1.0},"322":{"tf":1.4142135623730951},"324":{"tf":1.0},"53":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"322":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}}},"df":16,"docs":{"16":{"tf":1.0},"171":{"tf":1.0},"194":{"tf":1.0},"250":{"tf":1.0},"254":{"tf":1.0},"284":{"tf":1.4142135623730951},"300":{"tf":1.0},"309":{"tf":1.0},"316":{"tf":1.0},"323":{"tf":1.0},"336":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"72":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}}}}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"324":{"tf":1.0},"5":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"223":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"10":{"tf":1.0},"113":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"323":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"169":{"tf":1.0},"50":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":14,"docs":{"108":{"tf":1.4142135623730951},"156":{"tf":1.0},"164":{"tf":1.0},"171":{"tf":1.0},"174":{"tf":1.4142135623730951},"202":{"tf":1.0},"238":{"tf":1.0},"265":{"tf":1.0},"267":{"tf":1.4142135623730951},"3":{"tf":1.0},"34":{"tf":1.0},"92":{"tf":1.4142135623730951},"96":{"tf":1.0},"97":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"164":{"tf":1.0},"223":{"tf":1.0},"5":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.0}}}}}}},"df":6,"docs":{"152":{"tf":1.7320508075688772},"169":{"tf":3.1622776601683795},"210":{"tf":2.23606797749979},"28":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772},"86":{"tf":2.8284271247461903}},"e":{".":{"0":{"df":1,"docs":{"152":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"d":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"152":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"_":{"d":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"152":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{">":{":":{":":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"210":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"210":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}}},"h":{"a":{"df":1,"docs":{"50":{"tf":1.0}}},"df":2,"docs":{"222":{"tf":1.7320508075688772},"321":{"tf":1.0}}},"l":{"a":{"df":1,"docs":{"248":{"tf":1.0}}},"df":3,"docs":{"164":{"tf":1.0},"266":{"tf":1.0},"321":{"tf":1.0}},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":1,"docs":{"276":{"tf":1.0}}}}}}}}},"i":{"a":{"df":7,"docs":{"238":{"tf":2.0},"246":{"tf":1.0},"248":{"tf":1.0},"282":{"tf":1.0},"32":{"tf":2.23606797749979},"33":{"tf":1.0},"51":{"tf":1.0}},"s":{"df":7,"docs":{"158":{"tf":1.0},"174":{"tf":1.0},"238":{"tf":1.7320508075688772},"276":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"47":{"tf":1.0},"51":{"tf":2.0}},"e":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"238":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":1,"docs":{"238":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"c":{"df":2,"docs":{"261":{"tf":1.4142135623730951},"5":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"e":{"(":{"\"":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"261":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"a":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}}}}},"v":{"df":1,"docs":{"276":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":17,"docs":{"159":{"tf":1.0},"164":{"tf":2.23606797749979},"167":{"tf":2.23606797749979},"172":{"tf":1.0},"199":{"tf":1.4142135623730951},"206":{"tf":1.0},"257":{"tf":1.0},"259":{"tf":2.449489742783178},"26":{"tf":1.0},"261":{"tf":2.449489742783178},"266":{"tf":1.7320508075688772},"272":{"tf":1.0},"287":{"tf":1.4142135623730951},"317":{"tf":2.0},"321":{"tf":1.7320508075688772},"38":{"tf":1.4142135623730951},"95":{"tf":1.0}}},"df":0,"docs":{},"w":{"(":{"d":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":15,"docs":{"115":{"tf":1.7320508075688772},"120":{"tf":1.4142135623730951},"131":{"tf":1.4142135623730951},"144":{"tf":1.0},"172":{"tf":1.0},"225":{"tf":1.0},"227":{"tf":1.0},"259":{"tf":1.4142135623730951},"28":{"tf":1.0},"300":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0},"5":{"tf":1.4142135623730951},"78":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"48":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"130":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"130":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":40,"docs":{"101":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"131":{"tf":1.0},"133":{"tf":1.0},"144":{"tf":1.0},"154":{"tf":1.0},"156":{"tf":1.0},"159":{"tf":1.4142135623730951},"174":{"tf":1.0},"194":{"tf":1.0},"196":{"tf":1.0},"205":{"tf":1.0},"212":{"tf":1.4142135623730951},"217":{"tf":1.0},"218":{"tf":1.0},"238":{"tf":1.4142135623730951},"245":{"tf":1.0},"260":{"tf":1.0},"262":{"tf":1.0},"279":{"tf":1.0},"287":{"tf":1.0},"306":{"tf":1.0},"31":{"tf":1.0},"316":{"tf":1.4142135623730951},"319":{"tf":1.0},"323":{"tf":1.0},"324":{"tf":1.7320508075688772},"326":{"tf":1.0},"336":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"88":{"tf":1.4142135623730951},"97":{"tf":1.7320508075688772},"99":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"214":{"tf":1.0},"248":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":12,"docs":{"125":{"tf":1.0},"161":{"tf":1.0},"177":{"tf":1.0},"196":{"tf":1.0},"202":{"tf":1.0},"241":{"tf":1.0},"250":{"tf":1.0},"269":{"tf":2.0},"270":{"tf":1.0},"284":{"tf":1.0},"48":{"tf":1.4142135623730951},"80":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"88":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"268":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":9,"docs":{"23":{"tf":1.0},"231":{"tf":1.0},"250":{"tf":1.0},"291":{"tf":1.0},"295":{"tf":1.0},"60":{"tf":1.0},"69":{"tf":1.0},"88":{"tf":1.0},"94":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":3,"docs":{"113":{"tf":1.4142135623730951},"127":{"tf":1.0},"276":{"tf":1.0}}}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":12,"docs":{"1":{"tf":1.0},"171":{"tf":1.0},"192":{"tf":1.0},"203":{"tf":1.0},"21":{"tf":1.0},"235":{"tf":1.0},"243":{"tf":1.0},"261":{"tf":1.4142135623730951},"262":{"tf":1.0},"277":{"tf":1.0},"312":{"tf":1.0},"321":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":5,"docs":{"10":{"tf":1.0},"101":{"tf":1.0},"119":{"tf":1.0},"323":{"tf":1.0},"99":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"199":{"tf":1.0},"311":{"tf":1.0}}}}}}},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":2,"docs":{"21":{"tf":1.0},"42":{"tf":1.7320508075688772}}}}}}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":2,"docs":{"102":{"tf":1.0},"240":{"tf":1.0}}}},"z":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"x":{"df":1,"docs":{"26":{"tf":1.0}}},"y":{"df":0,"docs":{},"s":{"[":{"1":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"115":{"tf":1.0}}}}}}}},"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":5,"docs":{"112":{"tf":1.0},"217":{"tf":1.0},"268":{"tf":1.0},"282":{"tf":1.0},"323":{"tf":1.0}}}}},"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"|":{"df":3,"docs":{"245":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.0}}}},"df":3,"docs":{"227":{"tf":2.23606797749979},"237":{"tf":1.0},"248":{"tf":1.0}}}}}}},"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"118":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"136":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"199":{"tf":1.0}}}}}}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"\"":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"196":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":3,"docs":{"196":{"tf":2.449489742783178},"199":{"tf":3.7416573867739413},"284":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"x":{"df":1,"docs":{"194":{"tf":1.0}}}},"df":0,"docs":{}},"<":{"'":{"a":{">":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"194":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"194":{"tf":1.0}}}}}}},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"(":{"&":{"df":0,"docs":{},"x":{"df":1,"docs":{"194":{"tf":1.0}}}},"df":0,"docs":{}},"<":{"'":{"a":{">":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"194":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"194":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":26,"docs":{"176":{"tf":1.0},"177":{"tf":2.8284271247461903},"179":{"tf":1.0},"181":{"tf":1.4142135623730951},"183":{"tf":1.0},"185":{"tf":2.0},"196":{"tf":1.4142135623730951},"21":{"tf":2.23606797749979},"214":{"tf":1.0},"259":{"tf":1.0},"261":{"tf":1.0},"263":{"tf":1.0},"279":{"tf":1.0},"297":{"tf":1.0},"305":{"tf":1.0},"311":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.4142135623730951},"56":{"tf":1.0},"65":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.4142135623730951},"97":{"tf":1.0},"99":{"tf":2.0}}},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"202":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":3,"docs":{"101":{"tf":1.7320508075688772},"105":{"tf":1.0},"96":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":23,"docs":{"119":{"tf":1.0},"122":{"tf":1.0},"129":{"tf":1.0},"144":{"tf":1.0},"150":{"tf":1.0},"208":{"tf":1.0},"21":{"tf":1.0},"222":{"tf":1.0},"227":{"tf":1.0},"231":{"tf":1.0},"240":{"tf":1.0},"262":{"tf":1.0},"270":{"tf":1.0},"275":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.0},"316":{"tf":1.0},"55":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0},"88":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"45":{"tf":2.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"i":{"df":1,"docs":{"174":{"tf":1.4142135623730951}}}},"df":1,"docs":{"174":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"237":{"tf":1.4142135623730951},"296":{"tf":2.6457513110645907},"86":{"tf":1.0}}}}}},"y":{"(":{"df":0,"docs":{},"|":{"&":{"df":0,"docs":{},"x":{"df":1,"docs":{"108":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"<":{"df":0,"docs":{},"f":{">":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"108":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"230":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":5,"docs":{"129":{"tf":1.0},"136":{"tf":1.4142135623730951},"80":{"tf":1.0},"86":{"tf":1.0},"97":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"64":{"tf":1.0}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"220":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"115":{"tf":1.0},"125":{"tf":1.0},"332":{"tf":1.0}}}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":5,"docs":{"218":{"tf":1.0},"297":{"tf":1.0},"299":{"tf":1.0},"307":{"tf":1.0},"334":{"tf":1.0}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"177":{"tf":1.0}}}}}}}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"318":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"127":{"tf":1.4142135623730951}}}}}},"df":1,"docs":{"5":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"l":{"df":6,"docs":{"225":{"tf":1.4142135623730951},"230":{"tf":2.23606797749979},"231":{"tf":1.0},"232":{"tf":2.449489742783178},"233":{"tf":1.4142135623730951},"272":{"tf":2.0}},"i":{"c":{"df":2,"docs":{"250":{"tf":1.0},"295":{"tf":1.0}}},"df":10,"docs":{"0":{"tf":1.0},"130":{"tf":2.6457513110645907},"138":{"tf":1.0},"144":{"tf":1.0},"148":{"tf":1.0},"150":{"tf":1.0},"276":{"tf":1.0},"5":{"tf":1.0},"70":{"tf":1.0},"99":{"tf":1.0}}},"y":{"(":{"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"99":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"101":{"tf":1.0}}}}}}}},"<":{"df":0,"docs":{},"f":{">":{"(":{"df":0,"docs":{},"f":{"df":2,"docs":{"101":{"tf":1.4142135623730951},"99":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"3":{"(":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"f":{">":{"(":{"df":0,"docs":{},"f":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"`":{"'":{"df":1,"docs":{"99":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"a":{"c":{"df":0,"docs":{},"h":{"df":5,"docs":{"112":{"tf":1.4142135623730951},"150":{"tf":1.0},"286":{"tf":1.0},"287":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"280":{"tf":1.0},"316":{"tf":1.0},"328":{"tf":1.0},"96":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"90":{"tf":1.0}}}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":8,"docs":{"150":{"tf":1.0},"171":{"tf":1.0},"219":{"tf":1.4142135623730951},"267":{"tf":1.0},"269":{"tf":1.4142135623730951},"315":{"tf":1.0},"316":{"tf":1.0},"323":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"c":{"(":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"272":{"tf":1.0}}}}}},"df":0,"docs":{}},":":{":":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{"&":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"272":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"272":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":2,"docs":{"272":{"tf":2.0},"276":{"tf":1.0}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"26":{"tf":1.0},"314":{"tf":1.4142135623730951},"318":{"tf":1.4142135623730951},"322":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"321":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"x":{"df":1,"docs":{"133":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"a":{"(":{"&":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"144":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"144":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"144":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"144":{"tf":1.0}}}},"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"224":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":4,"docs":{"144":{"tf":1.0},"224":{"tf":1.0},"29":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"313":{"tf":1.0},"327":{"tf":1.0}}}},"df":0,"docs":{}}},"g":{"1":{"df":1,"docs":{"294":{"tf":1.0}}},"2":{"df":1,"docs":{"294":{"tf":1.0}}},"df":5,"docs":{"136":{"tf":1.0},"288":{"tf":1.0},"294":{"tf":2.0},"296":{"tf":1.0},"320":{"tf":1.7320508075688772}},"s":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"294":{"tf":1.0},"296":{"tf":1.0}}}}}},"[":{"0":{"df":1,"docs":{"294":{"tf":1.0}}},"1":{"]":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"296":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"294":{"tf":1.0},"296":{"tf":1.0}}},"2":{"df":1,"docs":{"296":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":48,"docs":{"0":{"tf":1.0},"103":{"tf":1.4142135623730951},"108":{"tf":1.0},"110":{"tf":1.0},"130":{"tf":1.0},"133":{"tf":1.0},"136":{"tf":1.0},"138":{"tf":2.0},"142":{"tf":1.0},"16":{"tf":2.23606797749979},"167":{"tf":1.0},"177":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.0},"200":{"tf":1.0},"204":{"tf":1.0},"205":{"tf":1.7320508075688772},"212":{"tf":1.7320508075688772},"214":{"tf":1.4142135623730951},"215":{"tf":1.4142135623730951},"216":{"tf":2.0},"219":{"tf":1.4142135623730951},"230":{"tf":1.7320508075688772},"24":{"tf":1.0},"25":{"tf":1.0},"275":{"tf":1.0},"276":{"tf":1.0},"287":{"tf":1.0},"29":{"tf":1.0},"293":{"tf":1.0},"294":{"tf":2.449489742783178},"295":{"tf":1.0},"296":{"tf":2.8284271247461903},"305":{"tf":1.0},"31":{"tf":1.0},"315":{"tf":1.0},"316":{"tf":2.449489742783178},"317":{"tf":1.0},"319":{"tf":1.0},"320":{"tf":1.7320508075688772},"324":{"tf":1.0},"329":{"tf":1.0},"5":{"tf":3.0},"94":{"tf":1.0},"95":{"tf":1.4142135623730951},"96":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"325":{"tf":1.0}}}},"m":{"df":5,"docs":{"215":{"tf":1.0},"314":{"tf":1.0},"72":{"tf":2.0},"78":{"tf":1.0},"84":{"tf":1.0}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":6,"docs":{"268":{"tf":1.0},"269":{"tf":1.0},"297":{"tf":1.4142135623730951},"317":{"tf":1.0},"319":{"tf":2.0},"96":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"60":{"tf":1.0}}}},"y":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"203":{"tf":1.0}}}}},"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"203":{"tf":1.0},"76":{"tf":1.0}}},"df":0,"docs":{}}}}},"1":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"108":{"tf":1.0},"110":{"tf":1.0}}}}},"df":2,"docs":{"108":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951}}},"2":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"x":{"df":1,"docs":{"108":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"(":{"df":0,"docs":{},"|":{"&":{"df":0,"docs":{},"x":{"df":1,"docs":{"110":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"108":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951}}},"[":{"0":{"df":1,"docs":{"76":{"tf":2.0}}},"1":{"df":1,"docs":{"76":{"tf":2.0}}},"2":{"df":1,"docs":{"76":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":13,"docs":{"108":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951},"148":{"tf":1.0},"203":{"tf":2.23606797749979},"21":{"tf":1.0},"26":{"tf":4.123105625617661},"260":{"tf":1.0},"262":{"tf":1.7320508075688772},"319":{"tf":1.7320508075688772},"50":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":2.23606797749979},"77":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"94":{"tf":1.0}}}}}},"s":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"280":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"i":{"df":1,"docs":{"319":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"267":{"tf":1.0}}},"df":1,"docs":{"267":{"tf":1.0}}}}}},"k":{"df":1,"docs":{"269":{"tf":1.0}}},"m":{"!":{"(":{"\"":{"a":{"d":{"d":{"df":2,"docs":{"316":{"tf":1.4142135623730951},"317":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"d":{"c":{"df":0,"docs":{},"w":{"df":1,"docs":{"322":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"316":{"tf":1.0},"321":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"315":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"318":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":10,"docs":{"314":{"tf":1.0},"315":{"tf":1.4142135623730951},"316":{"tf":1.4142135623730951},"317":{"tf":1.0},"318":{"tf":1.0},"319":{"tf":3.1622776601683795},"320":{"tf":1.7320508075688772},"321":{"tf":1.0},"323":{"tf":2.0},"324":{"tf":2.8284271247461903}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"236":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"<":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"287":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":11,"docs":{"314":{"tf":2.449489742783178},"315":{"tf":1.0},"316":{"tf":2.8284271247461903},"317":{"tf":1.4142135623730951},"318":{"tf":1.0},"319":{"tf":1.7320508075688772},"320":{"tf":1.0},"321":{"tf":1.0},"322":{"tf":1.4142135623730951},"323":{"tf":2.23606797749979},"324":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"!":{"(":{"$":{"a":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"217":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"*":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"p":{"df":1,"docs":{"312":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"a":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"(":{"&":{"4":{"df":1,"docs":{"269":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"4":{"df":1,"docs":{"269":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"b":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"4":{"df":1,"docs":{"269":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"300":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"!":{"(":{"\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"210":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"&":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"2":{"8":{"df":1,"docs":{"210":{"tf":1.0}}},"df":0,"docs":{}},"a":{"d":{"d":{"(":{"0":{"df":1,"docs":{"304":{"tf":1.0}}},"1":{"0":{"0":{"df":1,"docs":{"304":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"300":{"tf":1.0}}},"2":{"df":2,"docs":{"304":{"tf":1.4142135623730951},"309":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"a":{"d":{"d":{"(":{"3":{"df":1,"docs":{"308":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":3,"docs":{"317":{"tf":1.4142135623730951},"323":{"tf":1.0},"324":{"tf":1.0}}},"b":{"a":{"d":{"_":{"a":{"d":{"d":{"(":{"1":{"df":1,"docs":{"300":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"(":{"1":{"0":{"df":1,"docs":{"302":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{":":{":":{"<":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"206":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"5":{"df":1,"docs":{"57":{"tf":1.0}}},"8":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"(":{"\"":{"3":{"df":1,"docs":{"90":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"i":{"df":1,"docs":{"316":{"tf":1.0}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"110":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"110":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"300":{"tf":1.0}}}}}},"o":{"df":1,"docs":{"316":{"tf":1.0}}},"p":{".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"224":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{"2":{"df":1,"docs":{"206":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":3,"docs":{"305":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"66":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"1":{"df":1,"docs":{"206":{"tf":1.0}}},"2":{"df":1,"docs":{"206":{"tf":1.0}}},"3":{"df":1,"docs":{"206":{"tf":1.0}}},"4":{"df":1,"docs":{"206":{"tf":1.0}}},"5":{"df":1,"docs":{"206":{"tf":1.0}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"313":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"x":{")":{"?":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"f":{"(":{"2":{".":{"0":{"df":1,"docs":{"301":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"x":{"df":4,"docs":{"217":{"tf":1.0},"316":{"tf":1.4142135623730951},"319":{"tf":1.0},"321":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"309":{"tf":1.0}},"u":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"!":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"217":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"217":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"n":{"df":1,"docs":{"309":{"tf":1.0}},"e":{"!":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"191":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"300":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":2,"docs":{"300":{"tf":1.7320508075688772},"317":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":15,"docs":{"101":{"tf":1.0},"167":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.0},"207":{"tf":1.0},"224":{"tf":1.0},"276":{"tf":1.0},"277":{"tf":1.0},"278":{"tf":1.0},"316":{"tf":1.0},"317":{"tf":1.0},"43":{"tf":1.0},"61":{"tf":2.0},"80":{"tf":2.23606797749979},"96":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":9,"docs":{"154":{"tf":1.7320508075688772},"156":{"tf":1.0},"158":{"tf":2.23606797749979},"196":{"tf":1.0},"23":{"tf":1.0},"235":{"tf":1.0},"238":{"tf":1.0},"276":{"tf":1.0},"95":{"tf":3.1622776601683795}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":8,"docs":{"123":{"tf":1.0},"125":{"tf":1.0},"305":{"tf":1.0},"317":{"tf":1.0},"319":{"tf":1.0},"320":{"tf":1.0},"321":{"tf":1.0},"324":{"tf":1.0}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"313":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"279":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":6,"docs":{"171":{"tf":1.0},"177":{"tf":1.0},"276":{"tf":1.0},"286":{"tf":1.0},"6":{"tf":1.0},"97":{"tf":1.0}}}}},"n":{"d":{"df":1,"docs":{"208":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":21,"docs":{"0":{"tf":1.4142135623730951},"122":{"tf":1.0},"130":{"tf":3.0},"131":{"tf":1.7320508075688772},"132":{"tf":2.0},"133":{"tf":1.4142135623730951},"197":{"tf":1.4142135623730951},"28":{"tf":1.0},"297":{"tf":1.0},"30":{"tf":1.0},"300":{"tf":1.4142135623730951},"302":{"tf":1.4142135623730951},"304":{"tf":1.0},"330":{"tf":1.4142135623730951},"337":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"130":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"130":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"284":{"tf":1.4142135623730951}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"125":{"tf":2.0},"172":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"59":{"tf":1.0}}},"t":{"df":11,"docs":{"202":{"tf":1.0},"203":{"tf":1.0},"248":{"tf":1.0},"250":{"tf":1.0},"26":{"tf":1.0},"276":{"tf":1.7320508075688772},"305":{"tf":1.0},"320":{"tf":1.0},"34":{"tf":1.0},"5":{"tf":1.4142135623730951},"8":{"tf":2.0}}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":13,"docs":{"10":{"tf":1.0},"125":{"tf":1.0},"13":{"tf":1.0},"214":{"tf":1.0},"222":{"tf":1.0},"23":{"tf":1.0},"250":{"tf":1.0},"279":{"tf":1.0},"318":{"tf":1.0},"324":{"tf":1.0},"34":{"tf":1.0},"70":{"tf":1.4142135623730951},"97":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":10,"docs":{"167":{"tf":1.0},"212":{"tf":1.0},"240":{"tf":1.0},"241":{"tf":1.0},"276":{"tf":1.0},"316":{"tf":1.0},"323":{"tf":1.0},"324":{"tf":1.0},"48":{"tf":1.0},"80":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"124":{"tf":1.4142135623730951}}},"y":{"df":1,"docs":{"248":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"267":{"tf":1.0}}},"df":0,"docs":{}}}}}},"k":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"88":{"tf":1.0},"92":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"x":{"df":1,"docs":{"321":{"tf":1.4142135623730951}}}},"b":{"\"":{"\\":{"df":0,"docs":{},"u":{"df":0,"docs":{},"{":{"2":{"1":{"1":{"d":{"df":1,"docs":{"262":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"x":{"5":{"2":{"\\":{"df":0,"docs":{},"x":{"7":{"5":{"\\":{"df":0,"docs":{},"x":{"7":{"3":{"\\":{"df":0,"docs":{},"x":{"7":{"4":{"df":1,"docs":{"262":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"2":{"\\":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"6":{"\\":{"df":0,"docs":{},"x":{"8":{"2":{"\\":{"df":0,"docs":{},"x":{"a":{"8":{"\\":{"df":0,"docs":{},"x":{"8":{"2":{"\\":{"df":0,"docs":{},"x":{"b":{"1":{"\\":{"df":0,"docs":{},"x":{"8":{"2":{"\\":{"df":0,"docs":{},"x":{"b":{"b":{"df":1,"docs":{"262":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"262":{"tf":1.0}}}}}},".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"5":{"df":1,"docs":{"269":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"217":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"291":{"tf":2.23606797749979}}}}}},":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"217":{"tf":1.0}}}}}}},">":{"(":{"a":{"df":1,"docs":{"159":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"189":{"tf":1.0}}}}}}},"x":{"df":2,"docs":{"177":{"tf":1.0},"179":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"a":{"a":{"a":{"a":{"a":{"df":0,"docs":{},"h":{"df":2,"docs":{"196":{"tf":1.4142135623730951},"199":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"172":{"tf":1.0}}},"k":{"df":4,"docs":{"113":{"tf":1.0},"229":{"tf":1.0},"233":{"tf":1.0},"25":{"tf":1.0}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"305":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"262":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":1,"docs":{"300":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"323":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"d":{"_":{"a":{"d":{"d":{"(":{"a":{"df":1,"docs":{"300":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":4,"docs":{"220":{"tf":1.0},"223":{"tf":1.0},"245":{"tf":1.4142135623730951},"300":{"tf":1.0}}},"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"n":{"a":{"df":4,"docs":{"230":{"tf":1.0},"231":{"tf":1.0},"232":{"tf":1.0},"233":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"179":{"tf":1.0}},"g":{"df":1,"docs":{"212":{"tf":1.0}}}},"r":{".":{"a":{"d":{"d":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"200":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"331":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"125":{"tf":2.0},"200":{"tf":3.0},"214":{"tf":1.4142135623730951},"331":{"tf":2.0},"82":{"tf":2.23606797749979},"88":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"200":{"tf":2.23606797749979}}}}}},"s":{"df":0,"docs":{},"e":{"df":8,"docs":{"152":{"tf":1.0},"200":{"tf":1.0},"216":{"tf":1.0},"222":{"tf":1.0},"311":{"tf":1.0},"38":{"tf":1.0},"5":{"tf":1.0},"99":{"tf":1.0}}},"i":{"c":{"df":8,"docs":{"0":{"tf":1.0},"124":{"tf":1.0},"185":{"tf":1.0},"197":{"tf":1.0},"213":{"tf":1.0},"244":{"tf":1.0},"28":{"tf":1.0},"315":{"tf":1.0}}},"df":1,"docs":{"99":{"tf":1.0}}}},"z":{"df":1,"docs":{"88":{"tf":1.0}}}},"b":{"b":{"df":1,"docs":{"136":{"tf":1.0}}},"df":0,"docs":{}},"c":{"d":{"6":{"0":{"8":{"2":{"4":{"df":0,"docs":{},"f":{"5":{"df":0,"docs":{},"f":{"b":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"1":{"9":{"df":1,"docs":{"308":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":32,"docs":{"10":{"tf":1.4142135623730951},"138":{"tf":1.0},"156":{"tf":3.4641016151377544},"158":{"tf":2.8284271247461903},"159":{"tf":2.23606797749979},"167":{"tf":2.449489742783178},"17":{"tf":1.0},"177":{"tf":2.23606797749979},"179":{"tf":1.4142135623730951},"185":{"tf":1.4142135623730951},"189":{"tf":2.6457513110645907},"200":{"tf":1.0},"202":{"tf":2.0},"24":{"tf":1.4142135623730951},"269":{"tf":1.7320508075688772},"300":{"tf":2.0},"302":{"tf":2.0},"304":{"tf":1.4142135623730951},"305":{"tf":2.23606797749979},"306":{"tf":1.7320508075688772},"308":{"tf":1.4142135623730951},"309":{"tf":1.4142135623730951},"317":{"tf":2.449489742783178},"318":{"tf":1.7320508075688772},"323":{"tf":1.0},"324":{"tf":1.4142135623730951},"5":{"tf":1.0},"54":{"tf":1.4142135623730951},"69":{"tf":1.0},"78":{"tf":1.4142135623730951},"82":{"tf":1.7320508075688772},"88":{"tf":1.7320508075688772}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":4,"docs":{"138":{"tf":1.0},"192":{"tf":1.0},"227":{"tf":1.0},"270":{"tf":1.0}}}}},"df":21,"docs":{"0":{"tf":1.0},"108":{"tf":1.0},"110":{"tf":1.0},"127":{"tf":1.0},"130":{"tf":1.0},"136":{"tf":1.0},"150":{"tf":1.0},"165":{"tf":1.0},"167":{"tf":1.0},"179":{"tf":1.0},"20":{"tf":1.0},"208":{"tf":1.0},"224":{"tf":1.0},"295":{"tf":1.0},"319":{"tf":1.0},"321":{"tf":1.0},"323":{"tf":1.0},"329":{"tf":1.0},"44":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":14,"docs":{"120":{"tf":1.0},"121":{"tf":1.0},"126":{"tf":1.0},"128":{"tf":1.0},"150":{"tf":1.0},"176":{"tf":1.0},"206":{"tf":1.0},"223":{"tf":1.0},"225":{"tf":1.0},"242":{"tf":1.0},"248":{"tf":1.0},"319":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"97":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"0":{"tf":1.0},"176":{"tf":1.0},"277":{"tf":1.0},"3":{"tf":1.0}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"286":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"123":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":10,"docs":{"121":{"tf":1.0},"159":{"tf":1.0},"161":{"tf":1.0},"164":{"tf":1.0},"197":{"tf":1.0},"207":{"tf":1.0},"323":{"tf":1.0},"38":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.7320508075688772}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"313":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"306":{"tf":1.0},"319":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"54":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"w":{"df":20,"docs":{"112":{"tf":1.0},"127":{"tf":1.0},"156":{"tf":1.0},"161":{"tf":1.0},"165":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.0},"177":{"tf":1.0},"187":{"tf":1.0},"191":{"tf":1.0},"196":{"tf":1.0},"237":{"tf":1.0},"26":{"tf":1.0},"323":{"tf":1.0},"330":{"tf":1.0},"38":{"tf":1.0},"5":{"tf":1.0},"76":{"tf":1.0},"84":{"tf":1.4142135623730951},"88":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":5,"docs":{"0":{"tf":1.0},"124":{"tf":1.0},"126":{"tf":1.0},"130":{"tf":1.0},"309":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"262":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"220":{"tf":1.0},"324":{"tf":1.4142135623730951},"327":{"tf":1.0},"92":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":22,"docs":{"0":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"130":{"tf":1.0},"210":{"tf":1.0},"235":{"tf":1.0},"245":{"tf":1.0},"248":{"tf":1.0},"262":{"tf":1.0},"272":{"tf":1.4142135623730951},"276":{"tf":1.0},"279":{"tf":1.4142135623730951},"280":{"tf":1.0},"308":{"tf":1.0},"316":{"tf":1.0},"329":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.7320508075688772},"53":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":1.0},"80":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"221":{"tf":1.7320508075688772},"222":{"tf":2.23606797749979}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"105":{"tf":1.0},"273":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"n":{"df":1,"docs":{"63":{"tf":1.4142135623730951}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":4,"docs":{"10":{"tf":1.7320508075688772},"329":{"tf":1.0},"40":{"tf":1.0},"63":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"115":{"tf":1.0},"197":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":12,"docs":{"1":{"tf":1.7320508075688772},"10":{"tf":1.0},"121":{"tf":1.4142135623730951},"125":{"tf":1.7320508075688772},"126":{"tf":2.449489742783178},"130":{"tf":1.0},"132":{"tf":1.0},"191":{"tf":1.4142135623730951},"23":{"tf":1.0},"323":{"tf":1.0},"5":{"tf":1.0},"72":{"tf":1.4142135623730951}}}}},"d":{"df":22,"docs":{"0":{"tf":1.4142135623730951},"118":{"tf":2.0},"119":{"tf":1.0},"169":{"tf":1.0},"175":{"tf":1.0},"24":{"tf":1.4142135623730951},"263":{"tf":1.0},"28":{"tf":1.0},"42":{"tf":2.0},"43":{"tf":1.0},"44":{"tf":2.449489742783178},"45":{"tf":2.6457513110645907},"46":{"tf":1.0},"61":{"tf":1.4142135623730951},"63":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.7320508075688772},"77":{"tf":1.0},"86":{"tf":2.23606797749979},"88":{"tf":1.0},"90":{"tf":1.4142135623730951},"96":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"126":{"tf":1.7320508075688772}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"d":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"86":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":11,"docs":{"23":{"tf":1.4142135623730951},"250":{"tf":1.0},"26":{"tf":1.0},"262":{"tf":1.0},"276":{"tf":1.0},"316":{"tf":1.0},"318":{"tf":2.23606797749979},"319":{"tf":2.23606797749979},"321":{"tf":1.4142135623730951},"48":{"tf":2.23606797749979},"90":{"tf":1.0}},"e":{"df":1,"docs":{"235":{"tf":1.0}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"23":{"tf":1.0},"48":{"tf":1.0}}}}}}},"l":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"127":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":1,"docs":{"227":{"tf":1.0}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":34,"docs":{"0":{"tf":1.0},"114":{"tf":1.0},"118":{"tf":1.7320508075688772},"133":{"tf":1.0},"164":{"tf":1.4142135623730951},"200":{"tf":1.4142135623730951},"202":{"tf":2.449489742783178},"203":{"tf":1.0},"210":{"tf":1.0},"212":{"tf":1.0},"214":{"tf":1.4142135623730951},"215":{"tf":1.0},"266":{"tf":1.4142135623730951},"276":{"tf":2.0},"279":{"tf":1.4142135623730951},"297":{"tf":1.4142135623730951},"3":{"tf":2.23606797749979},"305":{"tf":2.0},"312":{"tf":1.0},"315":{"tf":1.0},"317":{"tf":1.0},"319":{"tf":1.7320508075688772},"32":{"tf":1.0},"323":{"tf":2.23606797749979},"324":{"tf":1.4142135623730951},"336":{"tf":1.0},"44":{"tf":2.8284271247461903},"61":{"tf":1.7320508075688772},"63":{"tf":1.0},"73":{"tf":1.0},"82":{"tf":1.0},"88":{"tf":1.0},"92":{"tf":1.4142135623730951},"95":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"e":{"(":{"&":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"j":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"146":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"146":{"tf":1.0}}}},">":{"(":{"_":{"df":1,"docs":{"146":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"j":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"146":{"tf":1.0}}}},"df":0,"docs":{}}},"df":5,"docs":{"146":{"tf":2.23606797749979},"16":{"tf":2.0},"17":{"tf":1.0},"36":{"tf":1.0},"78":{"tf":1.7320508075688772}},"j":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"146":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"o":{"b":{"df":2,"docs":{"261":{"tf":1.4142135623730951},"5":{"tf":1.0}}},"d":{"df":0,"docs":{},"i":{"df":3,"docs":{"300":{"tf":1.0},"306":{"tf":1.0},"96":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"250":{"tf":1.4142135623730951},"256":{"tf":1.0},"51":{"tf":1.0}}}}}}}},"n":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"172":{"tf":1.4142135623730951}}}}}},"y":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"172":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"df":8,"docs":{"124":{"tf":1.0},"172":{"tf":2.6457513110645907},"194":{"tf":1.0},"220":{"tf":1.0},"299":{"tf":1.0},"311":{"tf":1.0},"334":{"tf":1.4142135623730951},"338":{"tf":1.0}}},"l":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":13,"docs":{"108":{"tf":1.4142135623730951},"110":{"tf":1.0},"112":{"tf":1.0},"152":{"tf":1.0},"156":{"tf":1.4142135623730951},"158":{"tf":1.7320508075688772},"196":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":1.4142135623730951},"268":{"tf":1.0},"40":{"tf":1.0},"94":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":7,"docs":{"133":{"tf":1.0},"23":{"tf":1.4142135623730951},"267":{"tf":1.0},"42":{"tf":1.0},"63":{"tf":1.0},"72":{"tf":1.7320508075688772},"94":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"316":{"tf":1.0}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"1":{"df":1,"docs":{"176":{"tf":2.449489742783178}}},"2":{"df":1,"docs":{"176":{"tf":2.449489742783178}}},"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"(":{"&":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"172":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"172":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"172":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"3":{"2":{"(":{"&":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"171":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"171":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"171":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"171":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":23,"docs":{"0":{"tf":1.0},"108":{"tf":1.4142135623730951},"110":{"tf":1.0},"162":{"tf":1.0},"163":{"tf":1.4142135623730951},"169":{"tf":1.0},"171":{"tf":3.0},"172":{"tf":3.1622776601683795},"174":{"tf":3.1622776601683795},"175":{"tf":1.4142135623730951},"176":{"tf":2.449489742783178},"177":{"tf":2.23606797749979},"183":{"tf":2.449489742783178},"185":{"tf":1.0},"192":{"tf":1.7320508075688772},"194":{"tf":1.0},"26":{"tf":1.7320508075688772},"311":{"tf":1.0},"312":{"tf":1.0},"38":{"tf":1.0},"70":{"tf":1.4142135623730951},"97":{"tf":3.4641016151377544},"99":{"tf":1.4142135623730951}},"e":{"d":{"(":{"&":{"df":0,"docs":{},"x":{"df":1,"docs":{"183":{"tf":1.0}}}},"df":0,"docs":{}},"<":{"'":{"a":{">":{"(":{"&":{"'":{"a":{"df":1,"docs":{"183":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"185":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"171":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"x":{"df":1,"docs":{"174":{"tf":1.4142135623730951}}}},"df":1,"docs":{"174":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"h":{"df":29,"docs":{"10":{"tf":1.0},"119":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":1.0},"142":{"tf":1.4142135623730951},"167":{"tf":1.4142135623730951},"169":{"tf":1.0},"176":{"tf":1.0},"177":{"tf":1.4142135623730951},"179":{"tf":1.0},"183":{"tf":1.0},"190":{"tf":1.0},"191":{"tf":1.0},"207":{"tf":1.0},"208":{"tf":1.4142135623730951},"210":{"tf":1.4142135623730951},"227":{"tf":1.0},"237":{"tf":1.0},"240":{"tf":1.0},"269":{"tf":2.0},"270":{"tf":1.0},"286":{"tf":1.0},"31":{"tf":1.0},"316":{"tf":1.4142135623730951},"336":{"tf":1.0},"40":{"tf":1.0},"60":{"tf":1.0},"69":{"tf":1.0},"96":{"tf":1.0}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}},"x":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":2,"docs":{"259":{"tf":1.7320508075688772},"28":{"tf":2.0}}}}}}}},"df":2,"docs":{"259":{"tf":1.0},"28":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"d":{":":{":":{"$":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"(":{"*":{"df":0,"docs":{},"x":{"df":1,"docs":{"217":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"217":{"tf":1.0}}},"df":0,"docs":{}}},"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"217":{"tf":1.0}}}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"276":{"tf":1.0},"48":{"tf":1.0}}}}},"df":20,"docs":{"101":{"tf":1.0},"103":{"tf":2.0},"144":{"tf":3.0},"146":{"tf":2.0},"148":{"tf":1.4142135623730951},"150":{"tf":2.449489742783178},"162":{"tf":1.0},"187":{"tf":2.23606797749979},"188":{"tf":1.4142135623730951},"190":{"tf":1.0},"192":{"tf":1.7320508075688772},"203":{"tf":1.0},"218":{"tf":1.0},"26":{"tf":1.4142135623730951},"260":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.7320508075688772},"86":{"tf":1.4142135623730951},"99":{"tf":1.0}}},"df":0,"docs":{}}},"x":{":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"191":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"191":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"0":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"266":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"2":{"0":{"df":1,"docs":{"169":{"tf":1.0}}},"df":2,"docs":{"207":{"tf":1.0},"95":{"tf":1.0}}},"3":{"df":1,"docs":{"97":{"tf":1.0}},"i":{"3":{"2":{"df":1,"docs":{"164":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"4":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"164":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"5":{"_":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"171":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"3":{"2":{"df":2,"docs":{"164":{"tf":1.0},"167":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"3":{"2":{"df":2,"docs":{"168":{"tf":1.0},"175":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"[":{"0":{"df":1,"docs":{"191":{"tf":1.0}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"259":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"199":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"259":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"259":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"259":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"38":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"199":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"259":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":3,"docs":{"199":{"tf":1.4142135623730951},"246":{"tf":1.4142135623730951},"248":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"246":{"tf":1.0}}}}}}},"i":{"3":{"2":{"df":5,"docs":{"167":{"tf":1.0},"171":{"tf":1.0},"207":{"tf":1.0},"257":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"259":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"259":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":2,"docs":{"164":{"tf":1.0},"259":{"tf":1.0}}},"u":{"8":{"df":1,"docs":{"169":{"tf":1.0}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"a":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"259":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":16,"docs":{"116":{"tf":1.4142135623730951},"164":{"tf":1.0},"166":{"tf":1.0},"167":{"tf":1.0},"168":{"tf":1.4142135623730951},"171":{"tf":2.23606797749979},"191":{"tf":1.0},"199":{"tf":1.4142135623730951},"202":{"tf":1.0},"246":{"tf":2.449489742783178},"248":{"tf":1.0},"250":{"tf":1.0},"259":{"tf":2.8284271247461903},"276":{"tf":1.0},"39":{"tf":1.0},"98":{"tf":1.0}},"e":{"d":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"191":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"_":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"171":{"tf":2.23606797749979}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"259":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"259":{"tf":1.7320508075688772}}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"259":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"\"":{"\\":{"df":0,"docs":{},"u":{"df":0,"docs":{},"{":{"2":{"1":{"1":{"d":{"df":1,"docs":{"262":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"#":{"\"":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"262":{"tf":1.0}}}}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"218":{"tf":1.0},"44":{"tf":1.0}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":4,"docs":{"13":{"tf":1.0},"136":{"tf":1.0},"26":{"tf":1.0},"260":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"113":{"tf":1.0},"265":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"70":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"65":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":8,"docs":{"112":{"tf":1.4142135623730951},"120":{"tf":1.0},"315":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":2.23606797749979},"66":{"tf":1.4142135623730951},"90":{"tf":1.0},"92":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"49":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"196":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"323":{"tf":1.0}}}}},"o":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"136":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":3,"docs":{"261":{"tf":1.0},"289":{"tf":1.0},"5":{"tf":1.0}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"42":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"269":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"16":{"tf":1.4142135623730951},"287":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"205":{"tf":1.0},"287":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"205":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"g":{"df":3,"docs":{"164":{"tf":1.0},"212":{"tf":1.0},"323":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"128":{"tf":1.4142135623730951}}}},"df":7,"docs":{"125":{"tf":2.0},"128":{"tf":2.23606797749979},"129":{"tf":1.4142135623730951},"222":{"tf":1.0},"328":{"tf":1.0},"329":{"tf":1.0},"336":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"288":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":2,"docs":{"125":{"tf":1.0},"225":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"42":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"337":{"tf":1.0}}}}}}},"x":{"df":1,"docs":{"321":{"tf":1.0}}},"y":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"311":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"262":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":11,"docs":{"164":{"tf":1.4142135623730951},"20":{"tf":1.0},"259":{"tf":2.449489742783178},"26":{"tf":1.0},"261":{"tf":1.0},"262":{"tf":3.7416573867739413},"266":{"tf":1.4142135623730951},"280":{"tf":1.0},"319":{"tf":1.4142135623730951},"321":{"tf":2.23606797749979},"49":{"tf":2.449489742783178}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"262":{"tf":1.4142135623730951}}}}}}}}},"c":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"(":{")":{")":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{":":{":":{"<":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"276":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"o":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"1":{"0":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"276":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"/":{"c":{"df":2,"docs":{"80":{"tf":1.0},"94":{"tf":1.0}}},"df":0,"docs":{}},">":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"156":{"tf":1.0},"158":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":6,"docs":{"17":{"tf":1.4142135623730951},"216":{"tf":1.0},"218":{"tf":2.0},"219":{"tf":2.449489742783178},"276":{"tf":2.0},"29":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"267":{"tf":2.0}}},"df":0,"docs":{}}}}},"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"320":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"e":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"103":{"tf":1.0}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"103":{"tf":1.0}}}},"df":0,"docs":{}}}}},"<":{"df":0,"docs":{},"f":{"df":1,"docs":{"103":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"115":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":60,"docs":{"1":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":1.0},"113":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"120":{"tf":2.23606797749979},"121":{"tf":1.0},"123":{"tf":1.7320508075688772},"127":{"tf":1.0},"136":{"tf":1.0},"138":{"tf":1.4142135623730951},"154":{"tf":1.0},"161":{"tf":1.4142135623730951},"164":{"tf":1.0},"165":{"tf":1.0},"172":{"tf":1.4142135623730951},"200":{"tf":2.0},"202":{"tf":1.4142135623730951},"203":{"tf":1.0},"207":{"tf":1.0},"210":{"tf":1.0},"212":{"tf":1.4142135623730951},"214":{"tf":1.0},"216":{"tf":1.0},"221":{"tf":1.7320508075688772},"223":{"tf":1.0},"225":{"tf":1.4142135623730951},"227":{"tf":1.7320508075688772},"248":{"tf":1.4142135623730951},"250":{"tf":1.0},"253":{"tf":1.0},"254":{"tf":1.0},"259":{"tf":1.0},"262":{"tf":1.0},"263":{"tf":1.0},"266":{"tf":1.0},"267":{"tf":1.4142135623730951},"268":{"tf":1.0},"269":{"tf":1.0},"289":{"tf":1.0},"290":{"tf":1.0},"294":{"tf":1.4142135623730951},"297":{"tf":1.7320508075688772},"306":{"tf":1.0},"308":{"tf":1.0},"311":{"tf":1.4142135623730951},"313":{"tf":1.0},"318":{"tf":1.0},"320":{"tf":2.0},"324":{"tf":1.7320508075688772},"329":{"tf":1.0},"337":{"tf":1.0},"49":{"tf":1.4142135623730951},"56":{"tf":1.0},"6":{"tf":1.0},"95":{"tf":2.449489742783178},"96":{"tf":1.7320508075688772},"97":{"tf":2.23606797749979},"99":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"108":{"tf":1.0},"110":{"tf":1.0},"113":{"tf":1.0},"142":{"tf":1.4142135623730951},"220":{"tf":1.0},"237":{"tf":1.0},"95":{"tf":2.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"136":{"tf":1.0}}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":13,"docs":{"171":{"tf":1.0},"174":{"tf":2.0},"197":{"tf":1.4142135623730951},"199":{"tf":1.0},"206":{"tf":1.4142135623730951},"21":{"tf":1.0},"245":{"tf":1.0},"260":{"tf":1.0},"262":{"tf":1.0},"318":{"tf":1.0},"38":{"tf":1.0},"46":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"156":{"tf":1.0},"197":{"tf":1.0},"96":{"tf":1.0}}}},"c":{"df":2,"docs":{"260":{"tf":2.0},"267":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"262":{"tf":1.0}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":10,"docs":{"101":{"tf":1.7320508075688772},"103":{"tf":1.0},"105":{"tf":1.4142135623730951},"108":{"tf":1.0},"110":{"tf":1.0},"276":{"tf":1.0},"5":{"tf":1.0},"96":{"tf":1.7320508075688772},"97":{"tf":2.23606797749979},"99":{"tf":3.4641016151377544}}}}}},"r":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"146":{"tf":2.23606797749979}}}}},"df":0,"docs":{},"e":{"df":9,"docs":{"136":{"tf":1.0},"140":{"tf":1.0},"250":{"tf":1.0},"266":{"tf":1.0},"269":{"tf":1.0},"283":{"tf":1.0},"298":{"tf":1.0},"305":{"tf":1.0},"82":{"tf":1.0}}},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":6,"docs":{"125":{"tf":2.23606797749979},"126":{"tf":1.4142135623730951},"127":{"tf":1.0},"128":{"tf":1.0},"242":{"tf":1.0},"309":{"tf":1.4142135623730951}}}}}}},"df":17,"docs":{"0":{"tf":1.0},"124":{"tf":1.7320508075688772},"125":{"tf":3.0},"126":{"tf":2.0},"127":{"tf":2.6457513110645907},"128":{"tf":2.0},"129":{"tf":2.0},"132":{"tf":1.4142135623730951},"242":{"tf":1.0},"300":{"tf":1.4142135623730951},"302":{"tf":1.0},"303":{"tf":1.7320508075688772},"304":{"tf":1.7320508075688772},"305":{"tf":1.4142135623730951},"308":{"tf":1.7320508075688772},"310":{"tf":1.0},"328":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"245":{"tf":1.0}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"225":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"e":{"df":43,"docs":{"10":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.4142135623730951},"136":{"tf":1.7320508075688772},"138":{"tf":1.0},"144":{"tf":1.0},"150":{"tf":1.0},"16":{"tf":1.0},"169":{"tf":1.0},"176":{"tf":1.0},"177":{"tf":1.7320508075688772},"179":{"tf":1.4142135623730951},"191":{"tf":1.0},"196":{"tf":1.0},"212":{"tf":1.0},"216":{"tf":1.4142135623730951},"220":{"tf":2.0},"223":{"tf":2.0},"225":{"tf":1.4142135623730951},"235":{"tf":1.4142135623730951},"240":{"tf":1.4142135623730951},"243":{"tf":1.0},"245":{"tf":1.0},"296":{"tf":1.0},"306":{"tf":1.0},"316":{"tf":1.4142135623730951},"317":{"tf":2.23606797749979},"319":{"tf":1.0},"321":{"tf":1.0},"324":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.0},"53":{"tf":1.0},"65":{"tf":1.0},"72":{"tf":1.0},"88":{"tf":2.23606797749979},"92":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.0}}},"t":{"df":7,"docs":{"113":{"tf":1.0},"250":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":3.0},"53":{"tf":1.0}}}},"t":{"(":{"&":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"\"":{"a":{"/":{"c":{"/":{"b":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"291":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"291":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"263":{"tf":1.0},"264":{"tf":1.0},"72":{"tf":1.0}}}},"df":4,"docs":{"127":{"tf":1.4142135623730951},"261":{"tf":1.0},"284":{"tf":1.0},"291":{"tf":1.7320508075688772}}},"u":{"df":0,"docs":{},"s":{"df":10,"docs":{"127":{"tf":1.0},"250":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"264":{"tf":1.0},"266":{"tf":1.0},"287":{"tf":1.0},"317":{"tf":1.0},"323":{"tf":1.4142135623730951},"88":{"tf":1.0},"97":{"tf":1.4142135623730951}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"127":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"(":{"df":0,"docs":{},"z":{"df":1,"docs":{"297":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"df":24,"docs":{"156":{"tf":2.0},"158":{"tf":2.0},"164":{"tf":1.0},"167":{"tf":1.4142135623730951},"175":{"tf":1.7320508075688772},"202":{"tf":1.0},"212":{"tf":1.0},"220":{"tf":1.0},"222":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"261":{"tf":1.0},"266":{"tf":1.0},"28":{"tf":1.0},"291":{"tf":1.0},"297":{"tf":1.0},"31":{"tf":1.7320508075688772},"317":{"tf":2.23606797749979},"320":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"72":{"tf":1.0},"78":{"tf":1.4142135623730951},"88":{"tf":2.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"r":{"df":1,"docs":{"86":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"u":{"df":1,"docs":{"84":{"tf":1.4142135623730951}},"s":{"(":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"197":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"(":{"1":{"0":{"0":{".":{"0":{"df":1,"docs":{"197":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"6":{"4":{"df":1,"docs":{"197":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"197":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"220":{"tf":1.0},"267":{"tf":1.0},"302":{"tf":1.0},"325":{"tf":1.0}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"!":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"222":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"289":{"tf":1.0}}}}}}},"df":0,"docs":{}},"o":{"df":1,"docs":{"133":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"222":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"319":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":1,"docs":{"133":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"222":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"135":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":10,"docs":{"315":{"tf":1.0},"316":{"tf":2.0},"317":{"tf":1.4142135623730951},"318":{"tf":1.4142135623730951},"319":{"tf":1.4142135623730951},"320":{"tf":1.0},"321":{"tf":1.0},"322":{"tf":1.0},"323":{"tf":1.0},"324":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"291":{"tf":2.0},"297":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"o":{"df":1,"docs":{"133":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":6,"docs":{"127":{"tf":1.0},"300":{"tf":1.4142135623730951},"301":{"tf":1.0},"302":{"tf":1.0},"304":{"tf":1.0},"309":{"tf":1.0}}}}}}},"df":4,"docs":{"133":{"tf":3.0},"134":{"tf":1.0},"135":{"tf":2.0},"292":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"227":{"tf":1.0},"230":{"tf":1.4142135623730951},"231":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":5,"docs":{"224":{"tf":1.0},"225":{"tf":1.4142135623730951},"227":{"tf":1.4142135623730951},"248":{"tf":1.0},"265":{"tf":1.0}}},"r":{"df":1,"docs":{"90":{"tf":2.0}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"88":{"tf":1.0}}}}}}},"n":{"c":{"df":1,"docs":{"220":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":20,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"168":{"tf":1.4142135623730951},"172":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.0},"203":{"tf":1.0},"21":{"tf":1.4142135623730951},"23":{"tf":1.0},"242":{"tf":1.0},"245":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.0},"3":{"tf":1.0},"316":{"tf":1.0},"47":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0},"88":{"tf":1.0},"99":{"tf":1.0}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":3,"docs":{"273":{"tf":1.0},"276":{"tf":1.0},"279":{"tf":2.6457513110645907}}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":10,"docs":{"124":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.4142135623730951},"127":{"tf":1.7320508075688772},"209":{"tf":1.0},"211":{"tf":1.0},"212":{"tf":1.0},"262":{"tf":1.0},"299":{"tf":1.0},"311":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":9,"docs":{"177":{"tf":1.0},"187":{"tf":1.0},"23":{"tf":1.0},"261":{"tf":1.0},"262":{"tf":3.0},"276":{"tf":1.4142135623730951},"289":{"tf":1.0},"48":{"tf":1.7320508075688772},"5":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"262":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":7,"docs":{"136":{"tf":1.0},"138":{"tf":1.4142135623730951},"159":{"tf":2.0},"20":{"tf":1.0},"261":{"tf":2.23606797749979},"276":{"tf":1.0},"48":{"tf":1.7320508075688772}},"g":{"df":1,"docs":{"167":{"tf":1.0}}},"s":{".":{"d":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"261":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"261":{"tf":1.0}}}}}}},"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"261":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":20,"docs":{"0":{"tf":1.4142135623730951},"11":{"tf":1.0},"120":{"tf":1.0},"133":{"tf":1.4142135623730951},"152":{"tf":1.0},"156":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.4142135623730951},"164":{"tf":1.0},"225":{"tf":1.0},"262":{"tf":1.0},"264":{"tf":1.0},"265":{"tf":1.4142135623730951},"266":{"tf":1.0},"280":{"tf":1.0},"296":{"tf":1.7320508075688772},"302":{"tf":1.0},"5":{"tf":1.4142135623730951},"6":{"tf":1.0},"84":{"tf":1.0}},"e":{"d":{":":{":":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"264":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"264":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"p":{"(":{"1":{".":{"0":{"df":1,"docs":{"265":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"n":{"df":1,"docs":{"264":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"263":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":6,"docs":{"171":{"tf":1.0},"176":{"tf":1.0},"177":{"tf":1.0},"194":{"tf":1.0},"312":{"tf":1.0},"97":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"l":{"d":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"279":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"275":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"290":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},":":{":":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"290":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":8,"docs":{"115":{"tf":1.0},"275":{"tf":1.0},"276":{"tf":1.0},"279":{"tf":1.7320508075688772},"288":{"tf":1.4142135623730951},"289":{"tf":1.0},"290":{"tf":1.0},"86":{"tf":1.4142135623730951}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"|":{"c":{"df":1,"docs":{"276":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"279":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"275":{"tf":1.0},"276":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":3,"docs":{"275":{"tf":1.7320508075688772},"276":{"tf":1.0},"279":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"125":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":4,"docs":{"229":{"tf":1.0},"316":{"tf":1.0},"321":{"tf":1.0},"99":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"189":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"<":{"'":{"a":{"df":1,"docs":{"189":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"p":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"225":{"tf":1.0}}}}}}},"df":1,"docs":{"225":{"tf":1.7320508075688772}},"p":{"df":0,"docs":{},"e":{"d":{"(":{"df":0,"docs":{},"f":{"df":1,"docs":{"225":{"tf":1.0}},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"225":{"tf":1.0}}},"df":0,"docs":{}}}}},".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"|":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"225":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"199":{"tf":1.0},"321":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":3,"docs":{"276":{"tf":1.7320508075688772},"277":{"tf":1.4142135623730951},"3":{"tf":1.0}},"e":{"d":{"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"276":{"tf":1.0}}}}}}}}},"df":1,"docs":{"276":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}}}}},"r":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"59":{"tf":2.23606797749979}},"e":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"302":{"tf":1.0}}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":2.6457513110645907}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"34":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}}},"l":{"a":{"df":0,"docs":{},"p":{"df":3,"docs":{"125":{"tf":2.23606797749979},"218":{"tf":1.0},"295":{"tf":1.0}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"161":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"127":{"tf":1.0},"268":{"tf":1.0},"319":{"tf":1.4142135623730951},"321":{"tf":1.0}},"i":{"c":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"116":{"tf":1.0},"31":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":3,"docs":{"144":{"tf":1.0},"150":{"tf":2.8284271247461903},"92":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.0},"248":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"88":{"tf":1.0}}}}},"r":{"df":1,"docs":{"210":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"150":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"220":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"1":{"tf":1.4142135623730951},"2":{"tf":1.0},"31":{"tf":1.7320508075688772}}}},"df":1,"docs":{"125":{"tf":1.0}}},"o":{"b":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"a":{"b":{"df":0,"docs":{},"i":{"(":{"\"":{"c":{"df":1,"docs":{"320":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"320":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"319":{"tf":2.0},"320":{"tf":2.23606797749979}}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"207":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":8,"docs":{"161":{"tf":2.0},"197":{"tf":1.0},"207":{"tf":2.8284271247461903},"245":{"tf":1.0},"246":{"tf":1.0},"259":{"tf":1.0},"270":{"tf":2.23606797749979},"272":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"d":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"116":{"tf":1.0}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.7320508075688772}}}},"df":1,"docs":{"116":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":6,"docs":{"116":{"tf":1.0},"126":{"tf":1.0},"13":{"tf":1.0},"283":{"tf":1.4142135623730951},"289":{"tf":1.0},"3":{"tf":1.0}}},"u":{"df":0,"docs":{},"r":{"df":20,"docs":{"0":{"tf":1.0},"101":{"tf":2.0},"103":{"tf":2.6457513110645907},"105":{"tf":2.23606797749979},"107":{"tf":1.0},"108":{"tf":1.0},"110":{"tf":1.0},"177":{"tf":1.0},"178":{"tf":1.0},"206":{"tf":2.6457513110645907},"226":{"tf":1.0},"228":{"tf":1.0},"233":{"tf":1.7320508075688772},"234":{"tf":1.0},"275":{"tf":1.0},"276":{"tf":1.4142135623730951},"278":{"tf":1.4142135623730951},"96":{"tf":3.1622776601683795},"97":{"tf":4.0},"99":{"tf":3.4641016151377544}},"e":{"'":{"df":3,"docs":{"96":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.0}}},"_":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"(":{"1":{"df":1,"docs":{"96":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"96":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"96":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"(":{"1":{"df":1,"docs":{"96":{"tf":1.0}}},"4":{"2":{"df":0,"docs":{},"i":{"6":{"4":{"df":1,"docs":{"96":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"245":{"tf":1.0}}}}}}}},"m":{"d":{".":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"289":{"tf":1.0}}}}},"df":0,"docs":{}},"df":3,"docs":{"289":{"tf":2.0},"296":{"tf":1.4142135623730951},"318":{"tf":1.7320508075688772}}},"df":0,"docs":{},"p":{"df":2,"docs":{"197":{"tf":1.4142135623730951},"323":{"tf":1.0}}},"y":{"(":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":53,"docs":{"0":{"tf":2.0},"1":{"tf":2.0},"113":{"tf":1.0},"114":{"tf":1.0},"124":{"tf":1.0},"128":{"tf":1.4142135623730951},"130":{"tf":1.0},"131":{"tf":1.4142135623730951},"133":{"tf":1.0},"136":{"tf":1.0},"158":{"tf":1.0},"169":{"tf":1.0},"174":{"tf":1.4142135623730951},"194":{"tf":1.0},"205":{"tf":1.0},"212":{"tf":1.4142135623730951},"217":{"tf":1.0},"222":{"tf":1.4142135623730951},"224":{"tf":1.7320508075688772},"225":{"tf":1.0},"236":{"tf":1.0},"237":{"tf":1.4142135623730951},"240":{"tf":1.0},"242":{"tf":1.0},"243":{"tf":1.0},"245":{"tf":1.0},"246":{"tf":1.0},"262":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.0},"300":{"tf":1.4142135623730951},"305":{"tf":2.23606797749979},"306":{"tf":1.0},"308":{"tf":2.23606797749979},"309":{"tf":1.0},"311":{"tf":1.4142135623730951},"314":{"tf":1.0},"316":{"tf":1.4142135623730951},"319":{"tf":2.0},"320":{"tf":1.0},"321":{"tf":1.0},"323":{"tf":1.7320508075688772},"324":{"tf":2.23606797749979},"329":{"tf":1.4142135623730951},"335":{"tf":1.0},"336":{"tf":2.23606797749979},"337":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0},"49":{"tf":1.4142135623730951},"6":{"tf":1.0},"66":{"tf":1.0},"76":{"tf":1.0}},"f":{"df":1,"docs":{"336":{"tf":1.0}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"323":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":3,"docs":{"177":{"tf":1.0},"189":{"tf":1.4142135623730951},"191":{"tf":1.7320508075688772}},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"191":{"tf":1.0}},"i":{"c":{"(":{"&":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"191":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"<":{"'":{"a":{">":{"(":{"_":{"df":1,"docs":{"191":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"d":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"191":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"189":{"tf":1.7320508075688772},"48":{"tf":1.0}}}}}},"df":0,"docs":{}}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"223":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":20,"docs":{"0":{"tf":1.7320508075688772},"114":{"tf":1.0},"196":{"tf":1.0},"203":{"tf":1.4142135623730951},"205":{"tf":2.8284271247461903},"24":{"tf":1.0},"252":{"tf":1.0},"253":{"tf":1.0},"254":{"tf":1.4142135623730951},"255":{"tf":1.4142135623730951},"256":{"tf":1.0},"26":{"tf":1.0},"260":{"tf":1.0},"268":{"tf":1.0},"269":{"tf":1.4142135623730951},"276":{"tf":1.0},"279":{"tf":1.0},"286":{"tf":1.4142135623730951},"44":{"tf":1.0},"70":{"tf":3.0}},"e":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"0":{"df":1,"docs":{"260":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"260":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"269":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"95":{"tf":1.0}}},"r":{":":{":":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":2,"docs":{"36":{"tf":1.0},"78":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"(":{"c":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"k":{"(":{"c":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"78":{"tf":1.0}}}}}}},"h":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"h":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}},"v":{"(":{"df":0,"docs":{},"h":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":2,"docs":{"36":{"tf":1.0},"78":{"tf":1.0}},"g":{"b":{"(":{"1":{"2":{"2":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":7,"docs":{"16":{"tf":2.449489742783178},"17":{"tf":2.23606797749979},"309":{"tf":1.0},"36":{"tf":1.0},"78":{"tf":3.0},"79":{"tf":1.0},"97":{"tf":2.8284271247461903}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":12,"docs":{"159":{"tf":1.0},"206":{"tf":1.0},"215":{"tf":1.0},"225":{"tf":1.7320508075688772},"227":{"tf":1.4142135623730951},"235":{"tf":1.0},"237":{"tf":1.4142135623730951},"240":{"tf":1.7320508075688772},"241":{"tf":1.0},"244":{"tf":1.0},"276":{"tf":1.7320508075688772},"76":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"206":{"tf":1.0}},"s":{"(":{"df":0,"docs":{},"v":{"1":{"df":1,"docs":{"206":{"tf":1.0}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"206":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":9,"docs":{"125":{"tf":1.0},"189":{"tf":1.0},"210":{"tf":1.0},"227":{"tf":1.0},"244":{"tf":1.0},"262":{"tf":1.0},"298":{"tf":1.0},"306":{"tf":1.0},"95":{"tf":1.0}}},"m":{"a":{"df":6,"docs":{"13":{"tf":1.0},"205":{"tf":1.4142135623730951},"215":{"tf":1.0},"216":{"tf":1.0},"24":{"tf":1.0},"336":{"tf":1.0}},"n":{"d":{"\"":{")":{".":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"(":{"\"":{"$":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"289":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"\"":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"289":{"tf":1.0}}}}}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"288":{"tf":1.0}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"\"":{")":{".":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"(":{"\"":{"5":{"\"":{")":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"290":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"w":{"c":{"df":1,"docs":{"289":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":14,"docs":{"125":{"tf":1.4142135623730951},"164":{"tf":1.0},"222":{"tf":1.0},"266":{"tf":1.0},"289":{"tf":1.0},"290":{"tf":1.0},"294":{"tf":1.4142135623730951},"295":{"tf":1.4142135623730951},"296":{"tf":2.0},"303":{"tf":1.0},"304":{"tf":1.0},"305":{"tf":1.0},"308":{"tf":1.0},"328":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":18,"docs":{"1":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0},"202":{"tf":1.0},"260":{"tf":1.4142135623730951},"269":{"tf":1.0},"3":{"tf":4.123105625617661},"305":{"tf":1.4142135623730951},"329":{"tf":2.0},"334":{"tf":2.0},"40":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.4142135623730951},"50":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.4142135623730951}}}}},"o":{"d":{"df":0,"docs":{},"o":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"308":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":18,"docs":{"136":{"tf":1.0},"16":{"tf":1.0},"190":{"tf":1.0},"191":{"tf":1.0},"194":{"tf":1.4142135623730951},"203":{"tf":1.0},"217":{"tf":1.0},"248":{"tf":1.0},"297":{"tf":1.0},"308":{"tf":1.7320508075688772},"32":{"tf":1.0},"330":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"207":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"305":{"tf":1.0}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":2,"docs":{"279":{"tf":1.0},"333":{"tf":1.0}}},"t":{"df":1,"docs":{"200":{"tf":1.0}}}}},"p":{"_":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"i":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"208":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"225":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"227":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"df":7,"docs":{"159":{"tf":1.4142135623730951},"176":{"tf":1.0},"197":{"tf":1.4142135623730951},"215":{"tf":1.0},"245":{"tf":1.0},"248":{"tf":1.0},"88":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"(":{"&":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"148":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"148":{"tf":1.0}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"148":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"(":{"&":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"148":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"148":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"10":{"tf":1.0},"197":{"tf":1.0},"80":{"tf":1.0}}}}}}},"t":{"df":2,"docs":{"0":{"tf":1.4142135623730951},"325":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":71,"docs":{"0":{"tf":1.0},"1":{"tf":1.7320508075688772},"101":{"tf":1.0},"108":{"tf":1.0},"121":{"tf":2.23606797749979},"123":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.4142135623730951},"128":{"tf":1.4142135623730951},"129":{"tf":1.7320508075688772},"130":{"tf":1.4142135623730951},"131":{"tf":1.0},"132":{"tf":1.0},"133":{"tf":1.7320508075688772},"138":{"tf":1.0},"152":{"tf":1.0},"159":{"tf":2.0},"161":{"tf":1.0},"163":{"tf":1.0},"167":{"tf":1.0},"171":{"tf":1.0},"176":{"tf":1.0},"189":{"tf":1.0},"192":{"tf":1.0},"194":{"tf":1.0},"197":{"tf":1.0},"199":{"tf":1.7320508075688772},"212":{"tf":1.0},"222":{"tf":1.0},"223":{"tf":1.0},"23":{"tf":1.0},"230":{"tf":1.4142135623730951},"232":{"tf":1.0},"24":{"tf":1.0},"242":{"tf":1.0},"26":{"tf":1.7320508075688772},"260":{"tf":1.0},"268":{"tf":1.0},"296":{"tf":1.0},"3":{"tf":1.4142135623730951},"305":{"tf":1.0},"306":{"tf":1.4142135623730951},"308":{"tf":1.0},"311":{"tf":1.0},"314":{"tf":1.0},"315":{"tf":1.0},"316":{"tf":1.0},"317":{"tf":1.4142135623730951},"319":{"tf":2.0},"320":{"tf":1.0},"321":{"tf":1.4142135623730951},"323":{"tf":1.0},"324":{"tf":2.23606797749979},"326":{"tf":1.0},"329":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":1.0},"45":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.4142135623730951},"50":{"tf":2.0},"51":{"tf":1.0},"56":{"tf":1.0},"76":{"tf":1.0},"84":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"90":{"tf":1.0},"96":{"tf":1.7320508075688772},"97":{"tf":1.0},"99":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"313":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}}}}},"t":{"df":8,"docs":{"214":{"tf":1.0},"218":{"tf":1.0},"237":{"tf":1.0},"245":{"tf":1.0},"267":{"tf":1.0},"279":{"tf":1.0},"306":{"tf":1.0},"99":{"tf":1.0}}},"x":{"df":7,"docs":{"11":{"tf":1.4142135623730951},"179":{"tf":1.0},"197":{"tf":1.0},"218":{"tf":1.0},"245":{"tf":1.0},"297":{"tf":4.0},"316":{"tf":1.0}}}},"i":{"c":{"df":2,"docs":{"206":{"tf":1.0},"306":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"243":{"tf":1.0},"245":{"tf":1.0}}},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"20":{"tf":1.0},"21":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":2,"docs":{"124":{"tf":1.0},"194":{"tf":1.0}}}}}}}},"s":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"208":{"tf":2.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"159":{"tf":1.0},"197":{"tf":1.0},"208":{"tf":1.0},"297":{"tf":1.4142135623730951}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":8,"docs":{"0":{"tf":1.0},"113":{"tf":1.0},"125":{"tf":1.0},"159":{"tf":1.0},"276":{"tf":1.0},"326":{"tf":1.0},"49":{"tf":1.0},"80":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"245":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"s":{"df":3,"docs":{"218":{"tf":1.0},"286":{"tf":1.0},"301":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":6,"docs":{"136":{"tf":2.23606797749979},"138":{"tf":1.7320508075688772},"140":{"tf":1.0},"199":{"tf":1.0},"206":{"tf":1.0},"38":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"127":{"tf":1.4142135623730951}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":12,"docs":{"110":{"tf":1.4142135623730951},"130":{"tf":1.0},"133":{"tf":1.7320508075688772},"135":{"tf":1.7320508075688772},"220":{"tf":1.0},"221":{"tf":1.0},"283":{"tf":1.0},"284":{"tf":1.0},"63":{"tf":1.7320508075688772},"67":{"tf":1.0},"84":{"tf":1.4142135623730951},"88":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"135":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":2,"docs":{"133":{"tf":1.0},"222":{"tf":1.0}}}}}}}},"df":1,"docs":{"38":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"125":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"125":{"tf":1.0},"133":{"tf":1.0},"284":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"144":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"190":{"tf":1.0},"227":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"(":{"_":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"3":{"2":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}}}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"203":{"tf":1.0}}}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}}},"df":3,"docs":{"101":{"tf":1.0},"146":{"tf":1.0},"323":{"tf":1.0}}}},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"317":{"tf":1.0}}}}},"i":{"d":{"df":13,"docs":{"136":{"tf":1.4142135623730951},"20":{"tf":1.0},"205":{"tf":1.0},"229":{"tf":1.0},"235":{"tf":1.0},"240":{"tf":1.0},"269":{"tf":1.0},"297":{"tf":1.0},"318":{"tf":1.0},"326":{"tf":1.0},"56":{"tf":1.0},"92":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":5,"docs":{"1":{"tf":1.4142135623730951},"202":{"tf":1.4142135623730951},"218":{"tf":1.0},"38":{"tf":1.0},"5":{"tf":1.0}}}},"t":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}}}},"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"130":{"tf":1.0},"191":{"tf":1.4142135623730951},"193":{"tf":1.0},"214":{"tf":1.0},"27":{"tf":1.0},"277":{"tf":1.0},"40":{"tf":2.0}}}}},"df":4,"docs":{"27":{"tf":1.0},"275":{"tf":1.0},"312":{"tf":1.0},"40":{"tf":1.7320508075688772}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"177":{"tf":1.0},"44":{"tf":1.0}},"t":{"df":4,"docs":{"179":{"tf":1.0},"287":{"tf":1.0},"318":{"tf":1.4142135623730951},"49":{"tf":1.0}}}}}},"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":9,"docs":{"116":{"tf":1.4142135623730951},"161":{"tf":1.0},"176":{"tf":1.0},"203":{"tf":1.0},"218":{"tf":1.0},"24":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"88":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"116":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"m":{"df":9,"docs":{"108":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951},"161":{"tf":1.0},"287":{"tf":1.0},"317":{"tf":1.0},"38":{"tf":1.0},"70":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951},"97":{"tf":2.23606797749979}}}}},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"267":{"tf":1.7320508075688772}},"s":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"&":{"\"":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"267":{"tf":1.0}}}}}}}},"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"267":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"\"":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"267":{"tf":1.0}}}}}}}},"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"267":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"267":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"267":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"t":{"df":1,"docs":{"267":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"(":{"&":{"\"":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"267":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":31,"docs":{"10":{"tf":1.7320508075688772},"107":{"tf":1.0},"116":{"tf":1.4142135623730951},"13":{"tf":1.0},"154":{"tf":1.0},"156":{"tf":3.1622776601683795},"158":{"tf":3.0},"159":{"tf":1.0},"161":{"tf":1.0},"167":{"tf":2.0},"168":{"tf":1.7320508075688772},"171":{"tf":1.4142135623730951},"177":{"tf":1.0},"187":{"tf":1.0},"192":{"tf":1.4142135623730951},"199":{"tf":1.0},"20":{"tf":1.0},"232":{"tf":1.0},"237":{"tf":1.0},"250":{"tf":1.0},"259":{"tf":1.0},"268":{"tf":1.0},"28":{"tf":1.4142135623730951},"280":{"tf":1.0},"283":{"tf":1.0},"291":{"tf":1.0},"297":{"tf":1.0},"323":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0},"97":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"3":{"2":{"df":2,"docs":{"156":{"tf":1.0},"158":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"1":{"df":2,"docs":{"156":{"tf":1.0},"158":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"(":{"&":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"1":{"df":2,"docs":{"156":{"tf":1.0},"158":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"156":{"tf":1.4142135623730951},"158":{"tf":1.4142135623730951}}}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"156":{"tf":1.4142135623730951},"158":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"s":{"(":{"&":{"1":{"df":1,"docs":{"97":{"tf":1.0}}},"4":{"df":1,"docs":{"97":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"156":{"tf":1.4142135623730951},"158":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},":":{"\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"283":{"tf":1.0}}}},"df":0,"docs":{}},"<":{"a":{"df":2,"docs":{"156":{"tf":1.4142135623730951},"158":{"tf":1.0}}},"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"156":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},">":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"158":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"196":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"df":12,"docs":{"116":{"tf":2.6457513110645907},"120":{"tf":1.0},"121":{"tf":1.0},"168":{"tf":1.0},"171":{"tf":1.4142135623730951},"212":{"tf":1.0},"283":{"tf":1.0},"284":{"tf":1.0},"287":{"tf":1.0},"291":{"tf":1.0},"318":{"tf":1.0},"320":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":5,"docs":{"158":{"tf":1.0},"164":{"tf":1.0},"21":{"tf":1.4142135623730951},"266":{"tf":1.0},"42":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"26":{"tf":1.0}}}},"n":{"df":0,"docs":{},"u":{"df":9,"docs":{"113":{"tf":1.4142135623730951},"13":{"tf":1.0},"220":{"tf":1.0},"26":{"tf":1.0},"279":{"tf":1.0},"317":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"88":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"269":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"172":{"tf":1.0},"317":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":11,"docs":{"0":{"tf":1.0},"113":{"tf":1.0},"223":{"tf":1.0},"225":{"tf":1.0},"268":{"tf":1.0},"319":{"tf":1.0},"321":{"tf":1.0},"322":{"tf":1.0},"6":{"tf":1.0},"62":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":7,"docs":{"203":{"tf":1.0},"227":{"tf":1.0},"238":{"tf":1.0},"243":{"tf":1.0},"248":{"tf":1.0},"262":{"tf":1.4142135623730951},"96":{"tf":1.0}}},"t":{"df":6,"docs":{"126":{"tf":1.0},"235":{"tf":1.0},"320":{"tf":1.4142135623730951},"324":{"tf":1.0},"334":{"tf":1.0},"48":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":11,"docs":{"0":{"tf":1.0},"161":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.0},"250":{"tf":1.0},"262":{"tf":1.0},"48":{"tf":2.23606797749979},"53":{"tf":1.7320508075688772},"55":{"tf":1.4142135623730951},"57":{"tf":1.0},"70":{"tf":1.0}}},"t":{"df":19,"docs":{"0":{"tf":1.0},"214":{"tf":1.4142135623730951},"246":{"tf":1.4142135623730951},"248":{"tf":1.4142135623730951},"250":{"tf":1.0},"262":{"tf":1.4142135623730951},"276":{"tf":1.0},"280":{"tf":1.7320508075688772},"286":{"tf":1.0},"48":{"tf":1.4142135623730951},"5":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"70":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"k":{"(":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"(":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"225":{"tf":1.0}}}}}},"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"225":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":1,"docs":{"225":{"tf":1.0}}}}}},"df":0,"docs":{}},"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"v":{"1":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"227":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"2":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"227":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"3":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"227":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":1,"docs":{"227":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"225":{"tf":1.4142135623730951}},"e":{"d":{"(":{"df":0,"docs":{},"f":{"df":1,"docs":{"225":{"tf":1.0}},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"225":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"_":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"225":{"tf":1.0}}}}}},"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"225":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"225":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"119":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"119":{"tf":1.4142135623730951}}},"r":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"174":{"tf":2.23606797749979},"28":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"i":{"df":20,"docs":{"146":{"tf":1.0},"161":{"tf":2.449489742783178},"167":{"tf":1.4142135623730951},"169":{"tf":1.0},"172":{"tf":1.4142135623730951},"175":{"tf":1.7320508075688772},"197":{"tf":1.7320508075688772},"207":{"tf":1.7320508075688772},"224":{"tf":1.4142135623730951},"259":{"tf":1.4142135623730951},"261":{"tf":1.0},"270":{"tf":1.0},"279":{"tf":1.0},"297":{"tf":1.0},"316":{"tf":1.0},"321":{"tf":1.0},"323":{"tf":1.0},"42":{"tf":1.0},"97":{"tf":2.23606797749979},"99":{"tf":1.0}},"e":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"42":{"tf":1.7320508075688772}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"207":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"y":{">":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"217":{"tf":1.0}}}},"df":0,"docs":{}},"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"142":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"164":{"tf":1.4142135623730951},"266":{"tf":1.4142135623730951}}}}}}}}},"r":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":1,"docs":{"227":{"tf":1.0}}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":1,"docs":{"227":{"tf":1.0}}}}}},"df":1,"docs":{"227":{"tf":1.0}}}}},"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"200":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"8":{"(":{"&":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"319":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"259":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"94":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":7,"docs":{"179":{"tf":1.0},"298":{"tf":1.0},"302":{"tf":1.0},"305":{"tf":1.0},"313":{"tf":1.4142135623730951},"321":{"tf":1.0},"5":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"308":{"tf":1.0},"317":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"29":{"tf":1.0},"48":{"tf":1.0}}},"df":0,"docs":{}}}}}},"o":{"df":1,"docs":{"127":{"tf":3.3166247903554}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"319":{"tf":1.0}}}}}}},"s":{"(":{"df":0,"docs":{},"z":{"df":1,"docs":{"297":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"t":{"df":2,"docs":{"319":{"tf":1.0},"48":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"90":{"tf":2.0}}}}}},"df":10,"docs":{"13":{"tf":2.0},"164":{"tf":1.0},"26":{"tf":1.0},"260":{"tf":1.0},"266":{"tf":1.0},"270":{"tf":2.8284271247461903},"272":{"tf":1.0},"64":{"tf":2.449489742783178},"90":{"tf":2.449489742783178},"97":{"tf":3.605551275463989}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"272":{"tf":1.0},"66":{"tf":2.0},"67":{"tf":1.4142135623730951}}}}}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"244":{"tf":1.0},"319":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":5,"docs":{"142":{"tf":1.0},"164":{"tf":1.0},"223":{"tf":1.0},"48":{"tf":1.0},"70":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"236":{"tf":1.0},"268":{"tf":1.0},"47":{"tf":1.0},"72":{"tf":1.4142135623730951},"84":{"tf":1.0}}}}},"w":{"df":1,"docs":{"199":{"tf":1.7320508075688772}}}},"p":{"df":0,"docs":{},"u":{"df":1,"docs":{"319":{"tf":1.4142135623730951}},"i":{"d":{"df":1,"docs":{"319":{"tf":2.23606797749979}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"119":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}},"e":{"d":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{":":{":":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"332":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"y":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"115":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":3,"docs":{"122":{"tf":1.0},"132":{"tf":2.0},"329":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"132":{"tf":2.23606797749979}}}}}},"df":22,"docs":{"0":{"tf":1.7320508075688772},"115":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"121":{"tf":2.8284271247461903},"122":{"tf":2.0},"123":{"tf":1.4142135623730951},"125":{"tf":2.23606797749979},"127":{"tf":1.0},"128":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":2.0},"132":{"tf":2.23606797749979},"191":{"tf":1.0},"262":{"tf":1.0},"295":{"tf":1.7320508075688772},"305":{"tf":1.4142135623730951},"308":{"tf":2.0},"309":{"tf":1.4142135623730951},"323":{"tf":1.0},"326":{"tf":1.7320508075688772},"329":{"tf":1.0},"49":{"tf":1.4142135623730951}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"305":{"tf":1.0}}}},"df":0,"docs":{}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":2,"docs":{"124":{"tf":1.0},"125":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":51,"docs":{"0":{"tf":1.0},"101":{"tf":1.0},"116":{"tf":1.0},"122":{"tf":1.4142135623730951},"125":{"tf":1.0},"127":{"tf":1.4142135623730951},"13":{"tf":1.0},"136":{"tf":1.0},"159":{"tf":1.0},"161":{"tf":1.0},"163":{"tf":1.0},"164":{"tf":1.0},"167":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.4142135623730951},"176":{"tf":1.0},"177":{"tf":1.0},"179":{"tf":1.0},"191":{"tf":1.4142135623730951},"197":{"tf":1.4142135623730951},"212":{"tf":1.0},"214":{"tf":1.4142135623730951},"238":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"250":{"tf":1.0},"259":{"tf":1.0},"26":{"tf":1.0},"261":{"tf":1.0},"267":{"tf":1.0},"27":{"tf":1.0},"270":{"tf":1.4142135623730951},"272":{"tf":1.0},"28":{"tf":1.4142135623730951},"280":{"tf":1.4142135623730951},"283":{"tf":1.0},"284":{"tf":2.23606797749979},"287":{"tf":1.0},"291":{"tf":1.7320508075688772},"295":{"tf":1.0},"308":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"313":{"tf":1.0},"32":{"tf":1.0},"38":{"tf":1.4142135623730951},"50":{"tf":1.0},"55":{"tf":1.0},"69":{"tf":1.0},"8":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"88":{"tf":1.0},"99":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"127":{"tf":1.4142135623730951}}}}}},".":{"df":0,"docs":{},"r":{"df":1,"docs":{"284":{"tf":1.0}}}},"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"164":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":1,"docs":{"105":{"tf":1.4142135623730951}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"105":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"105":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"214":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"!":{"(":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"214":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"214":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"176":{"tf":1.0},"31":{"tf":1.0}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"(":{"df":0,"docs":{},"z":{"df":1,"docs":{"297":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"a":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"237":{"tf":1.0},"240":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"0":{"tf":1.0}}}}},"r":{"df":1,"docs":{"203":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"224":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":10,"docs":{"115":{"tf":1.4142135623730951},"119":{"tf":1.0},"174":{"tf":1.4142135623730951},"203":{"tf":1.4142135623730951},"222":{"tf":1.0},"260":{"tf":1.0},"276":{"tf":1.0},"279":{"tf":1.0},"287":{"tf":1.0},"314":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"135":{"tf":1.0}}}},"df":13,"docs":{"0":{"tf":1.7320508075688772},"10":{"tf":1.4142135623730951},"135":{"tf":2.23606797749979},"165":{"tf":1.0},"202":{"tf":1.0},"223":{"tf":1.0},"245":{"tf":1.4142135623730951},"257":{"tf":1.0},"268":{"tf":1.0},"27":{"tf":1.4142135623730951},"324":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0}}}}}}},"x":{"df":1,"docs":{"321":{"tf":1.0}}}},"d":{"3":{"b":{"3":{"2":{"b":{"9":{"7":{"2":{"7":{"5":{"df":0,"docs":{},"e":{"c":{"4":{"7":{"2":{"df":1,"docs":{"127":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"319":{"tf":1.0}}}},"l":{"df":1,"docs":{"167":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"267":{"tf":1.0}}},"df":1,"docs":{"267":{"tf":1.0}}}}}},"t":{"a":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"276":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"276":{"tf":2.0}}}}}},"df":31,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"159":{"tf":1.4142135623730951},"164":{"tf":1.0},"167":{"tf":1.7320508075688772},"168":{"tf":1.0},"169":{"tf":1.0},"171":{"tf":1.4142135623730951},"172":{"tf":1.7320508075688772},"174":{"tf":2.23606797749979},"179":{"tf":1.7320508075688772},"191":{"tf":1.4142135623730951},"192":{"tf":1.4142135623730951},"196":{"tf":1.4142135623730951},"197":{"tf":1.0},"202":{"tf":1.0},"250":{"tf":1.0},"259":{"tf":1.0},"26":{"tf":1.0},"260":{"tf":1.0},"27":{"tf":1.0},"276":{"tf":3.605551275463989},"277":{"tf":1.4142135623730951},"309":{"tf":1.0},"312":{"tf":1.0},"316":{"tf":1.0},"321":{"tf":1.0},"324":{"tf":1.0},"46":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"99":{"tf":1.0}}},"df":0,"docs":{}},"y":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"227":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"d":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"227":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"d":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"227":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":3,"docs":{"152":{"tf":1.4142135623730951},"227":{"tf":2.23606797749979},"5":{"tf":1.0}},"s":{"(":{"df":0,"docs":{},"i":{"6":{"4":{"df":1,"docs":{"152":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"0":{"df":1,"docs":{"152":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"150":{"tf":2.23606797749979},"202":{"tf":1.0},"24":{"tf":1.4142135623730951}},"e":{"a":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":3,"docs":{"131":{"tf":1.7320508075688772},"5":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"131":{"tf":1.4142135623730951}}},"df":0,"docs":{},"l":{"df":8,"docs":{"13":{"tf":1.0},"207":{"tf":1.0},"220":{"tf":2.23606797749979},"237":{"tf":1.0},"240":{"tf":1.0},"266":{"tf":1.0},"291":{"tf":1.0},"65":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"142":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{">":{"(":{"df":0,"docs":{},"t":{"df":2,"docs":{"144":{"tf":1.0},"148":{"tf":1.0}}}},"df":0,"docs":{}},"df":16,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"144":{"tf":1.4142135623730951},"148":{"tf":1.4142135623730951},"150":{"tf":1.7320508075688772},"187":{"tf":2.0},"192":{"tf":1.0},"197":{"tf":1.4142135623730951},"207":{"tf":1.0},"236":{"tf":1.4142135623730951},"25":{"tf":1.0},"269":{"tf":1.4142135623730951},"28":{"tf":1.0},"317":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"127":{"tf":1.4142135623730951}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"c":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"237":{"tf":1.0},"241":{"tf":1.0},"277":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":3,"docs":{"28":{"tf":1.4142135623730951},"48":{"tf":2.23606797749979},"6":{"tf":1.4142135623730951}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":23,"docs":{"103":{"tf":1.0},"112":{"tf":1.0},"115":{"tf":2.0},"118":{"tf":1.4142135623730951},"120":{"tf":1.0},"121":{"tf":1.4142135623730951},"130":{"tf":1.0},"176":{"tf":1.0},"189":{"tf":1.0},"191":{"tf":1.0},"196":{"tf":1.0},"205":{"tf":1.4142135623730951},"272":{"tf":1.0},"297":{"tf":1.0},"313":{"tf":1.0},"316":{"tf":1.4142135623730951},"319":{"tf":1.0},"34":{"tf":1.0},"40":{"tf":1.4142135623730951},"42":{"tf":1.0},"45":{"tf":1.7320508075688772},"61":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"219":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"270":{"tf":1.0},"296":{"tf":2.0},"99":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"296":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"323":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}},"e":{"(":{"7":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"270":{"tf":1.0},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"241":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"118":{"tf":1.0}}},"y":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":2.23606797749979}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"185":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}},"df":24,"docs":{"115":{"tf":1.7320508075688772},"116":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.4142135623730951},"126":{"tf":1.0},"128":{"tf":1.0},"161":{"tf":1.0},"177":{"tf":1.0},"185":{"tf":1.4142135623730951},"196":{"tf":1.4142135623730951},"197":{"tf":1.0},"207":{"tf":1.0},"21":{"tf":1.7320508075688772},"229":{"tf":1.4142135623730951},"259":{"tf":1.0},"267":{"tf":1.0},"320":{"tf":1.0},"321":{"tf":1.4142135623730951},"323":{"tf":1.0},"324":{"tf":1.4142135623730951},"43":{"tf":1.0},"5":{"tf":1.0},"70":{"tf":1.0},"88":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"245":{"tf":1.0},"250":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":42,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"103":{"tf":1.7320508075688772},"116":{"tf":1.0},"129":{"tf":1.0},"13":{"tf":1.0},"136":{"tf":2.449489742783178},"138":{"tf":2.0},"140":{"tf":1.0},"142":{"tf":1.4142135623730951},"144":{"tf":1.0},"154":{"tf":1.0},"158":{"tf":1.4142135623730951},"161":{"tf":1.4142135623730951},"192":{"tf":1.0},"196":{"tf":1.4142135623730951},"203":{"tf":2.23606797749979},"207":{"tf":1.0},"208":{"tf":1.0},"212":{"tf":1.4142135623730951},"213":{"tf":1.0},"218":{"tf":1.4142135623730951},"238":{"tf":1.7320508075688772},"245":{"tf":1.7320508075688772},"250":{"tf":1.0},"27":{"tf":1.4142135623730951},"277":{"tf":1.0},"287":{"tf":1.0},"291":{"tf":1.0},"308":{"tf":1.0},"323":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"60":{"tf":1.0},"80":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":9,"docs":{"105":{"tf":1.0},"133":{"tf":1.4142135623730951},"158":{"tf":1.0},"169":{"tf":1.0},"191":{"tf":1.0},"196":{"tf":1.0},"323":{"tf":1.0},"8":{"tf":1.0},"94":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"169":{"tf":1.0},"3":{"tf":1.4142135623730951},"70":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"262":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"96":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"314":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"191":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":4,"docs":{"10":{"tf":1.0},"176":{"tf":1.0},"329":{"tf":1.0},"99":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":14,"docs":{"124":{"tf":1.0},"125":{"tf":3.605551275463989},"127":{"tf":1.0},"16":{"tf":1.0},"212":{"tf":1.0},"215":{"tf":1.0},"277":{"tf":1.0},"298":{"tf":1.4142135623730951},"309":{"tf":2.6457513110645907},"310":{"tf":1.0},"324":{"tf":1.0},"38":{"tf":1.0},"49":{"tf":1.4142135623730951},"76":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"80":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"c":{"df":6,"docs":{"167":{"tf":1.0},"259":{"tf":1.0},"280":{"tf":1.0},"311":{"tf":1.0},"312":{"tf":1.0},"80":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}}}},"i":{"df":0,"docs":{},"v":{"df":9,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"160":{"tf":1.0},"197":{"tf":1.7320508075688772},"198":{"tf":1.0},"268":{"tf":1.0},"8":{"tf":2.0},"88":{"tf":1.4142135623730951},"9":{"tf":1.0}},"e":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"172":{"tf":1.0},"175":{"tf":1.0},"207":{"tf":1.0},"224":{"tf":1.4142135623730951},"297":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":31,"docs":{"10":{"tf":1.4142135623730951},"130":{"tf":1.4142135623730951},"144":{"tf":1.0},"16":{"tf":1.0},"161":{"tf":1.7320508075688772},"169":{"tf":1.0},"183":{"tf":1.7320508075688772},"185":{"tf":1.0},"187":{"tf":1.0},"197":{"tf":1.0},"200":{"tf":1.4142135623730951},"207":{"tf":1.0},"225":{"tf":2.0},"227":{"tf":1.4142135623730951},"230":{"tf":1.0},"231":{"tf":1.0},"232":{"tf":1.0},"233":{"tf":1.0},"24":{"tf":1.0},"245":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.0},"250":{"tf":1.0},"259":{"tf":1.0},"264":{"tf":1.0},"265":{"tf":1.0},"28":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"8":{"tf":2.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":3,"docs":{"159":{"tf":1.4142135623730951},"197":{"tf":1.0},"268":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":5,"docs":{"136":{"tf":1.0},"220":{"tf":1.0},"227":{"tf":1.0},"235":{"tf":1.0},"305":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"194":{"tf":1.0},"220":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"282":{"tf":1.0},"283":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":3,"docs":{"213":{"tf":1.0},"214":{"tf":2.449489742783178},"217":{"tf":1.0}}}},"r":{"df":5,"docs":{"223":{"tf":1.0},"263":{"tf":1.0},"283":{"tf":1.0},"324":{"tf":1.0},"47":{"tf":1.0}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"20":{"tf":1.0},"325":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"95":{"tf":1.0}}}}}}},"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"(":{"b":{"df":1,"docs":{"167":{"tf":1.0}}},"c":{"df":1,"docs":{"167":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":10,"docs":{"163":{"tf":1.0},"164":{"tf":1.7320508075688772},"167":{"tf":1.0},"171":{"tf":2.23606797749979},"176":{"tf":1.4142135623730951},"259":{"tf":1.0},"266":{"tf":1.0},"276":{"tf":1.0},"284":{"tf":1.0},"95":{"tf":1.0}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"176":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"164":{"tf":1.0},"165":{"tf":2.23606797749979},"259":{"tf":1.0},"266":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":24,"docs":{"108":{"tf":1.4142135623730951},"110":{"tf":2.0},"152":{"tf":1.4142135623730951},"169":{"tf":1.0},"170":{"tf":1.0},"175":{"tf":1.7320508075688772},"24":{"tf":1.0},"248":{"tf":1.0},"276":{"tf":1.4142135623730951},"278":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.4142135623730951},"73":{"tf":2.6457513110645907},"74":{"tf":1.7320508075688772},"76":{"tf":1.0},"78":{"tf":1.4142135623730951},"80":{"tf":1.7320508075688772},"82":{"tf":2.0},"86":{"tf":1.0},"88":{"tf":2.0},"92":{"tf":1.7320508075688772},"95":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":8,"docs":{"10":{"tf":1.0},"242":{"tf":1.0},"262":{"tf":1.0},"268":{"tf":1.0},"301":{"tf":1.0},"305":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"164":{"tf":1.0},"266":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"164":{"tf":1.0},"266":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":12,"docs":{"125":{"tf":1.0},"156":{"tf":1.0},"158":{"tf":1.0},"176":{"tf":1.4142135623730951},"177":{"tf":1.4142135623730951},"219":{"tf":1.0},"237":{"tf":1.0},"246":{"tf":1.0},"26":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.0},"99":{"tf":1.0}}}}}}}},"v":{"df":3,"docs":{"127":{"tf":1.4142135623730951},"298":{"tf":1.0},"309":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":3,"docs":{"124":{"tf":1.0},"218":{"tf":1.0},"309":{"tf":1.0}}}}}}}},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"l":{"df":1,"docs":{"267":{"tf":1.0}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"99":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"103":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"309":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":43,"docs":{"0":{"tf":1.0},"113":{"tf":1.0},"118":{"tf":1.0},"127":{"tf":1.0},"130":{"tf":1.4142135623730951},"133":{"tf":1.0},"148":{"tf":1.0},"156":{"tf":1.7320508075688772},"158":{"tf":1.4142135623730951},"159":{"tf":1.0},"16":{"tf":1.0},"176":{"tf":1.0},"177":{"tf":1.4142135623730951},"179":{"tf":1.4142135623730951},"187":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"199":{"tf":1.4142135623730951},"200":{"tf":1.0},"210":{"tf":1.4142135623730951},"212":{"tf":1.0},"215":{"tf":1.4142135623730951},"220":{"tf":1.4142135623730951},"222":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"243":{"tf":1.4142135623730951},"245":{"tf":1.4142135623730951},"248":{"tf":1.0},"269":{"tf":1.4142135623730951},"276":{"tf":1.4142135623730951},"283":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.4142135623730951},"316":{"tf":1.7320508075688772},"40":{"tf":1.0},"5":{"tf":1.0},"70":{"tf":2.23606797749979},"72":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"84":{"tf":1.0},"90":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"(":{"&":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"156":{"tf":1.0},"158":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"a":{"df":2,"docs":{"156":{"tf":1.0},"158":{"tf":1.0}}},"c":{"df":1,"docs":{"158":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"276":{"tf":2.0},"323":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"217":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"323":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":12,"docs":{"115":{"tf":1.0},"119":{"tf":1.0},"129":{"tf":1.0},"150":{"tf":1.0},"199":{"tf":1.0},"270":{"tf":1.0},"289":{"tf":1.0},"318":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"59":{"tf":1.0},"86":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":8,"docs":{"123":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.4142135623730951},"127":{"tf":1.0},"128":{"tf":1.0},"220":{"tf":1.0},"291":{"tf":2.449489742783178},"308":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"130":{"tf":1.0},"131":{"tf":1.4142135623730951},"3":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":2,"docs":{"115":{"tf":1.0},"210":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"319":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"220":{"tf":1.0},"59":{"tf":1.0},"70":{"tf":1.0}}}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"227":{"tf":1.0}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"176":{"tf":1.0}}}}}}},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"247":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{">":{"(":{"df":0,"docs":{},"t":{"df":2,"docs":{"144":{"tf":1.4142135623730951},"148":{"tf":1.0}}}},"df":0,"docs":{}},"`":{"df":1,"docs":{"280":{"tf":1.0}}},"df":16,"docs":{"10":{"tf":2.449489742783178},"11":{"tf":1.0},"144":{"tf":2.23606797749979},"148":{"tf":1.0},"16":{"tf":1.7320508075688772},"17":{"tf":1.0},"191":{"tf":1.0},"245":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"262":{"tf":1.0},"280":{"tf":1.0},"283":{"tf":2.0},"284":{"tf":2.0},"5":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"(":{"a":{"df":1,"docs":{"305":{"tf":1.0}}},"df":0,"docs":{},"x":{"df":2,"docs":{"264":{"tf":1.0},"265":{"tf":1.4142135623730951}}}},"df":2,"docs":{"265":{"tf":1.0},"305":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"113":{"tf":1.4142135623730951},"90":{"tf":1.0}}}}},"i":{"d":{"df":3,"docs":{"276":{"tf":1.0},"302":{"tf":1.0},"305":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"(":{"1":{"df":1,"docs":{"302":{"tf":1.4142135623730951}}},"a":{"df":1,"docs":{"302":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"263":{"tf":1.4142135623730951},"266":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":4,"docs":{"263":{"tf":1.4142135623730951},"265":{"tf":1.0},"266":{"tf":1.7320508075688772},"305":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"3":{"df":1,"docs":{"266":{"tf":1.0}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"266":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":2,"docs":{"264":{"tf":1.0},"265":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"263":{"tf":2.6457513110645907},"266":{"tf":1.7320508075688772}}}}}}}},"o":{"c":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"333":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"337":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"331":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"332":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},".":{"df":0,"docs":{},"r":{"df":1,"docs":{"329":{"tf":1.4142135623730951}}}},":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"329":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"=":{"\"":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"d":{"df":0,"docs":{},"o":{"c":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"329":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"305":{"tf":1.4142135623730951}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{":":{":":{"a":{"d":{"d":{"(":{"2":{"df":1,"docs":{"305":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"(":{"1":{"0":{"df":1,"docs":{"305":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"(":{"1":{"0":{"df":1,"docs":{"306":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":21,"docs":{"0":{"tf":1.0},"124":{"tf":1.0},"127":{"tf":1.0},"298":{"tf":1.0},"299":{"tf":1.0},"3":{"tf":1.7320508075688772},"302":{"tf":1.0},"303":{"tf":1.4142135623730951},"304":{"tf":1.4142135623730951},"305":{"tf":1.4142135623730951},"306":{"tf":1.7320508075688772},"308":{"tf":1.0},"310":{"tf":1.0},"311":{"tf":1.0},"328":{"tf":1.4142135623730951},"329":{"tf":1.7320508075688772},"330":{"tf":1.4142135623730951},"331":{"tf":1.7320508075688772},"333":{"tf":1.0},"334":{"tf":1.4142135623730951},"337":{"tf":1.7320508075688772}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"329":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":15,"docs":{"0":{"tf":1.0},"16":{"tf":1.0},"265":{"tf":1.0},"269":{"tf":1.0},"3":{"tf":1.0},"305":{"tf":2.449489742783178},"306":{"tf":1.7320508075688772},"307":{"tf":1.4142135623730951},"327":{"tf":1.7320508075688772},"328":{"tf":2.0},"329":{"tf":1.4142135623730951},"333":{"tf":1.4142135623730951},"334":{"tf":1.7320508075688772},"4":{"tf":1.0},"6":{"tf":1.0}}}}}}}},"df":7,"docs":{"150":{"tf":1.0},"167":{"tf":1.0},"169":{"tf":1.0},"175":{"tf":1.0},"282":{"tf":1.0},"324":{"tf":1.0},"59":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":22,"docs":{"10":{"tf":1.0},"127":{"tf":1.4142135623730951},"138":{"tf":1.0},"146":{"tf":1.0},"156":{"tf":1.4142135623730951},"159":{"tf":1.0},"191":{"tf":1.0},"197":{"tf":1.4142135623730951},"208":{"tf":1.0},"243":{"tf":1.0},"244":{"tf":1.0},"263":{"tf":1.0},"266":{"tf":1.0},"283":{"tf":1.0},"44":{"tf":1.0},"50":{"tf":1.0},"63":{"tf":1.0},"74":{"tf":2.0},"88":{"tf":1.4142135623730951},"90":{"tf":1.0},"92":{"tf":1.0},"97":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"g":{"\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"289":{"tf":1.0}}}},"df":2,"docs":{"261":{"tf":1.4142135623730951},"5":{"tf":1.0}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"\\":{"df":0,"docs":{},"x":{"3":{"df":0,"docs":{},"f":{"df":1,"docs":{"262":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"214":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"196":{"tf":1.0}}},"y":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"196":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"196":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"284":{"tf":2.8284271247461903}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"212":{"tf":1.0},"218":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"'":{"df":0,"docs":{},"t":{"df":24,"docs":{"0":{"tf":1.0},"127":{"tf":1.0},"199":{"tf":1.0},"205":{"tf":1.0},"206":{"tf":1.0},"212":{"tf":1.4142135623730951},"215":{"tf":1.0},"217":{"tf":1.0},"220":{"tf":1.4142135623730951},"223":{"tf":1.0},"227":{"tf":1.4142135623730951},"245":{"tf":1.0},"262":{"tf":2.0},"301":{"tf":1.0},"319":{"tf":1.0},"51":{"tf":1.0},"63":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0},"88":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":5,"docs":{"10":{"tf":1.0},"206":{"tf":1.0},"260":{"tf":1.0},"312":{"tf":1.0},"319":{"tf":1.0}}}},"t":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}},"u":{"b":{"df":0,"docs":{},"l":{"df":13,"docs":{"164":{"tf":1.0},"183":{"tf":1.4142135623730951},"206":{"tf":1.0},"243":{"tf":1.7320508075688772},"244":{"tf":2.449489742783178},"245":{"tf":1.4142135623730951},"246":{"tf":1.4142135623730951},"248":{"tf":1.4142135623730951},"250":{"tf":1.0},"259":{"tf":1.0},"262":{"tf":1.0},"95":{"tf":1.0},"99":{"tf":1.7320508075688772}},"e":{"_":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"142":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"243":{"tf":1.0},"244":{"tf":1.4142135623730951}}}}}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":2,"docs":{"243":{"tf":1.0},"244":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"243":{"tf":1.0},"244":{"tf":1.4142135623730951}}}}},"v":{"df":0,"docs":{},"e":{"c":{"df":6,"docs":{"243":{"tf":1.0},"244":{"tf":1.4142135623730951},"245":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.0},"250":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"206":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"<":{"'":{"a":{">":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"206":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"142":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"250":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"250":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"250":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"250":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"245":{"tf":2.0},"250":{"tf":3.0}}}}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"a":{"df":1,"docs":{"172":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"120":{"tf":1.0},"26":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"125":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"257":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"246":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":1,"docs":{"217":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"92":{"tf":1.0}}}},"n":{"df":0,"docs":{},"k":{"(":{"\"":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"d":{"df":2,"docs":{"221":{"tf":1.0},"222":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"221":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"221":{"tf":1.0},"222":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"221":{"tf":1.0},"222":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"223":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"223":{"tf":1.0}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"223":{"tf":1.0}}}}}}},".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"223":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":3,"docs":{"221":{"tf":1.4142135623730951},"222":{"tf":1.4142135623730951},"223":{"tf":3.1622776601683795}}}}},"o":{"df":0,"docs":{},"p":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"165":{"tf":1.0},"202":{"tf":1.0}}}}}},"_":{"a":{"df":1,"docs":{"202":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"207":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"`":{"df":2,"docs":{"202":{"tf":1.4142135623730951},"289":{"tf":1.0}}},"df":13,"docs":{"105":{"tf":1.0},"142":{"tf":1.4142135623730951},"143":{"tf":1.0},"165":{"tf":2.0},"179":{"tf":1.0},"192":{"tf":1.4142135623730951},"202":{"tf":3.4641016151377544},"203":{"tf":1.0},"207":{"tf":1.7320508075688772},"270":{"tf":2.449489742783178},"272":{"tf":1.0},"80":{"tf":1.0},"99":{"tf":1.0}},"e":{"df":1,"docs":{"283":{"tf":1.0}}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"202":{"tf":2.449489742783178}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"y":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"217":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"218":{"tf":1.4142135623730951}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":2,"docs":{"312":{"tf":1.0},"323":{"tf":1.4142135623730951}}},"i":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":4,"docs":{"136":{"tf":1.0},"261":{"tf":1.0},"269":{"tf":1.0},"323":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"176":{"tf":1.0},"191":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":2,"docs":{"207":{"tf":1.0},"50":{"tf":1.0}}}}},"x":{"df":1,"docs":{"321":{"tf":1.0}}},"y":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"191":{"tf":1.0},"247":{"tf":1.0}}}},"df":2,"docs":{"199":{"tf":1.4142135623730951},"208":{"tf":1.0}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":14,"docs":{"113":{"tf":1.4142135623730951},"164":{"tf":1.0},"167":{"tf":1.0},"199":{"tf":1.0},"23":{"tf":1.4142135623730951},"26":{"tf":1.0},"314":{"tf":1.0},"317":{"tf":1.0},"318":{"tf":1.0},"319":{"tf":1.0},"321":{"tf":1.7320508075688772},"323":{"tf":1.0},"324":{"tf":1.0},"90":{"tf":1.0}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":2,"docs":{"246":{"tf":1.0},"248":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"250":{"tf":1.0}}},"df":0,"docs":{}}}}}},":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":2,"docs":{"218":{"tf":1.0},"219":{"tf":1.4142135623730951}}}}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":35,"docs":{"10":{"tf":1.4142135623730951},"127":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"176":{"tf":1.0},"190":{"tf":1.0},"191":{"tf":1.0},"20":{"tf":1.0},"203":{"tf":1.0},"205":{"tf":1.4142135623730951},"210":{"tf":1.0},"215":{"tf":1.0},"223":{"tf":1.0},"24":{"tf":1.0},"244":{"tf":1.0},"260":{"tf":1.0},"276":{"tf":2.6457513110645907},"279":{"tf":1.4142135623730951},"286":{"tf":1.0},"287":{"tf":1.0},"294":{"tf":1.0},"308":{"tf":1.0},"31":{"tf":1.0},"316":{"tf":1.0},"319":{"tf":1.0},"32":{"tf":1.4142135623730951},"321":{"tf":1.0},"329":{"tf":1.0},"34":{"tf":1.4142135623730951},"53":{"tf":1.0},"63":{"tf":1.0},"69":{"tf":1.4142135623730951},"70":{"tf":2.0}}}},"df":1,"docs":{"284":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"229":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"230":{"tf":1.7320508075688772},"232":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"240":{"tf":2.0},"265":{"tf":1.0},"94":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"123":{"tf":1.0},"241":{"tf":1.0},"94":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":7,"docs":{"127":{"tf":1.0},"199":{"tf":1.0},"243":{"tf":1.0},"245":{"tf":1.0},"276":{"tf":1.0},"316":{"tf":1.0},"54":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"118":{"tf":1.4142135623730951},"206":{"tf":1.0},"224":{"tf":1.4142135623730951},"240":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"206":{"tf":1.0},"260":{"tf":1.0},"268":{"tf":1.0},"3":{"tf":1.0},"55":{"tf":1.0}}}}}},"t":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"_":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"225":{"tf":1.0}}}}}},"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"225":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"225":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":1,"docs":{"227":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"225":{"tf":1.0},"227":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"227":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"227":{"tf":1.0}}}}}}}},"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"i":{"3":{"2":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"171":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"171":{"tf":1.0}}}}},"df":0,"docs":{}},"df":2,"docs":{"225":{"tf":1.0},"227":{"tf":1.7320508075688772}}},"x":{"df":3,"docs":{"318":{"tf":2.0},"319":{"tf":1.7320508075688772},"321":{"tf":1.0}}}},"b":{"df":0,"docs":{},"p":{"df":1,"docs":{"318":{"tf":1.0}}},"x":{"df":2,"docs":{"318":{"tf":1.0},"319":{"tf":3.1622776601683795}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"(":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"291":{"tf":1.0}}}}}}}},"df":1,"docs":{"291":{"tf":1.0}}},"df":3,"docs":{"283":{"tf":1.0},"287":{"tf":1.0},"291":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"125":{"tf":1.0}}}}}}}}},"x":{"df":2,"docs":{"318":{"tf":1.0},"319":{"tf":1.7320508075688772}}}},"d":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"225":{"tf":1.0}}}},"df":1,"docs":{"318":{"tf":1.0}},"t":{"df":8,"docs":{"1":{"tf":1.0},"123":{"tf":1.0},"172":{"tf":1.4142135623730951},"242":{"tf":1.0},"301":{"tf":1.0},"326":{"tf":2.0},"336":{"tf":1.4142135623730951},"90":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"=":{"2":{"0":{"2":{"1":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"x":{"df":2,"docs":{"318":{"tf":1.0},"319":{"tf":1.7320508075688772}}}},"df":19,"docs":{"16":{"tf":1.0},"218":{"tf":1.0},"219":{"tf":1.4142135623730951},"23":{"tf":1.0},"235":{"tf":1.4142135623730951},"237":{"tf":1.4142135623730951},"238":{"tf":1.0},"240":{"tf":1.0},"241":{"tf":1.0},"242":{"tf":1.0},"245":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.0},"250":{"tf":1.4142135623730951},"255":{"tf":1.4142135623730951},"262":{"tf":1.0},"264":{"tf":1.4142135623730951},"287":{"tf":1.0},"288":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"132":{"tf":1.0},"144":{"tf":1.0},"324":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"287":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"325":{"tf":1.0}}}}}}},"g":{"df":1,"docs":{"192":{"tf":1.0}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"183":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{"&":{"df":0,"docs":{},"x":{"df":1,"docs":{"183":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"'":{"a":{"df":1,"docs":{"183":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"l":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"127":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":2,"docs":{"5":{"tf":1.0},"8":{"tf":1.0}}},"m":{"1":{"df":1,"docs":{"269":{"tf":1.0}}},"2":{"df":1,"docs":{"269":{"tf":1.0}}},"df":2,"docs":{"38":{"tf":1.0},"50":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"245":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":24,"docs":{"10":{"tf":1.0},"108":{"tf":2.23606797749979},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"179":{"tf":1.0},"203":{"tf":1.4142135623730951},"223":{"tf":1.7320508075688772},"235":{"tf":1.7320508075688772},"24":{"tf":1.7320508075688772},"243":{"tf":1.0},"244":{"tf":1.0},"25":{"tf":1.0},"250":{"tf":1.0},"26":{"tf":2.8284271247461903},"260":{"tf":2.449489742783178},"269":{"tf":2.6457513110645907},"276":{"tf":1.0},"313":{"tf":1.0},"38":{"tf":1.7320508075688772},"70":{"tf":1.4142135623730951},"74":{"tf":1.0},"76":{"tf":1.4142135623730951},"80":{"tf":1.0},"97":{"tf":1.0}}}}}}},"i":{"d":{"df":2,"docs":{"177":{"tf":1.0},"248":{"tf":1.0}},"e":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"x":{"df":1,"docs":{"194":{"tf":1.0}}}},"df":0,"docs":{},"x":{"df":1,"docs":{"194":{"tf":1.0}}}},"df":1,"docs":{"194":{"tf":1.4142135623730951}}}}}}},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"(":{"&":{"df":0,"docs":{},"x":{"df":1,"docs":{"194":{"tf":1.0}}}},"df":0,"docs":{},"x":{"df":1,"docs":{"194":{"tf":1.0}}}},"df":1,"docs":{"194":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"131":{"tf":1.0},"324":{"tf":1.4142135623730951}}}}},"s":{"df":4,"docs":{"177":{"tf":1.0},"179":{"tf":1.0},"194":{"tf":2.449489742783178},"195":{"tf":1.0}}},"t":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"`":{"/":{"`":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"92":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"268":{"tf":1.4142135623730951}}}}},"b":{"df":2,"docs":{"244":{"tf":1.0},"314":{"tf":1.0}},"e":{"d":{"df":1,"docs":{"218":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"321":{"tf":1.7320508075688772}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"88":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":21,"docs":{"113":{"tf":1.4142135623730951},"142":{"tf":2.23606797749979},"146":{"tf":1.4142135623730951},"197":{"tf":1.0},"20":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.0},"231":{"tf":1.0},"232":{"tf":1.0},"233":{"tf":1.0},"243":{"tf":1.4142135623730951},"244":{"tf":1.7320508075688772},"245":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.0},"250":{"tf":1.0},"26":{"tf":1.0},"261":{"tf":1.0},"291":{"tf":1.0},"38":{"tf":1.7320508075688772},"50":{"tf":1.0}}},"y":{".":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"142":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"246":{"tf":1.0}}}}}}},"df":3,"docs":{"246":{"tf":1.7320508075688772},"248":{"tf":1.7320508075688772},"250":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"130":{"tf":1.0},"133":{"tf":1.0},"337":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"116":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":7,"docs":{"101":{"tf":1.0},"103":{"tf":1.0},"130":{"tf":1.0},"176":{"tf":1.0},"3":{"tf":1.0},"44":{"tf":1.0},"96":{"tf":1.4142135623730951}}}}},"o":{"d":{"df":1,"docs":{"262":{"tf":1.4142135623730951}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"190":{"tf":1.0},"235":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"282":{"tf":1.0},"283":{"tf":1.0},"284":{"tf":1.0},"288":{"tf":1.0}}}},"df":0,"docs":{}}}}},"d":{"df":16,"docs":{"176":{"tf":2.23606797749979},"200":{"tf":1.0},"212":{"tf":1.0},"215":{"tf":1.0},"260":{"tf":1.0},"261":{"tf":1.4142135623730951},"265":{"tf":1.0},"279":{"tf":1.0},"290":{"tf":1.4142135623730951},"3":{"tf":1.0},"318":{"tf":1.0},"323":{"tf":1.0},"38":{"tf":1.0},"44":{"tf":1.0},"61":{"tf":1.0},"69":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"203":{"tf":1.0},"279":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"164":{"tf":1.0}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"50":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":7,"docs":{"128":{"tf":1.0},"138":{"tf":1.0},"152":{"tf":1.7320508075688772},"177":{"tf":1.0},"192":{"tf":1.4142135623730951},"276":{"tf":1.0},"64":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"176":{"tf":1.0},"313":{"tf":1.0},"317":{"tf":1.0},"319":{"tf":1.0},"325":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"242":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":8,"docs":{"130":{"tf":1.0},"176":{"tf":1.0},"191":{"tf":1.0},"255":{"tf":1.0},"3":{"tf":1.0},"319":{"tf":1.0},"323":{"tf":1.0},"324":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"319":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"32":{"tf":1.0}}},"df":35,"docs":{"0":{"tf":1.0},"130":{"tf":1.0},"161":{"tf":1.4142135623730951},"162":{"tf":1.0},"183":{"tf":1.4142135623730951},"223":{"tf":1.0},"225":{"tf":1.0},"227":{"tf":1.4142135623730951},"230":{"tf":1.0},"231":{"tf":1.0},"232":{"tf":1.0},"233":{"tf":1.0},"250":{"tf":1.0},"251":{"tf":1.0},"263":{"tf":1.7320508075688772},"264":{"tf":2.0},"265":{"tf":1.0},"27":{"tf":1.0},"31":{"tf":2.8284271247461903},"32":{"tf":2.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"36":{"tf":2.6457513110645907},"38":{"tf":1.7320508075688772},"53":{"tf":1.0},"73":{"tf":1.0},"78":{"tf":2.0},"79":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":3.0},"89":{"tf":1.0},"93":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"13":{"tf":1.0},"161":{"tf":1.0},"260":{"tf":1.0},"27":{"tf":1.0},"276":{"tf":1.0},"278":{"tf":1.0}}}}}},"v":{":":{":":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"(":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"294":{"tf":1.0},"296":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"129":{"tf":1.0},"96":{"tf":1.7320508075688772}}}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"296":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"5":{"tf":1.0}}}}}}}}},"q":{"df":4,"docs":{"146":{"tf":1.0},"197":{"tf":1.0},"267":{"tf":1.0},"268":{"tf":2.8284271247461903}},"u":{"a":{"df":0,"docs":{},"l":{"df":10,"docs":{"156":{"tf":1.0},"159":{"tf":1.4142135623730951},"175":{"tf":1.0},"197":{"tf":1.0},"269":{"tf":1.0},"270":{"tf":1.7320508075688772},"300":{"tf":1.0},"48":{"tf":1.0},"84":{"tf":1.4142135623730951},"86":{"tf":1.0}}},"t":{"df":1,"docs":{"88":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"118":{"tf":1.0},"175":{"tf":1.0},"241":{"tf":1.0},"265":{"tf":1.0},"34":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"(":{"\"":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"301":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"245":{"tf":1.0}}}},"df":0,"docs":{}}}}},"_":{"df":1,"docs":{"296":{"tf":1.0}}},"b":{"a":{"d":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"(":{"c":{"df":1,"docs":{"245":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":13,"docs":{"235":{"tf":1.0},"236":{"tf":1.4142135623730951},"237":{"tf":2.449489742783178},"238":{"tf":1.0},"240":{"tf":2.23606797749979},"241":{"tf":1.0},"242":{"tf":1.0},"245":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.0},"250":{"tf":1.0},"262":{"tf":1.0},"291":{"tf":2.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"245":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"r":{"df":2,"docs":{"248":{"tf":1.0},"265":{"tf":1.0}}}}},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":2,"docs":{"248":{"tf":1.0},"265":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":2,"docs":{"264":{"tf":1.0},"265":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"264":{"tf":1.0},"265":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":2,"docs":{"264":{"tf":1.0},"265":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"\"":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"306":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":6,"docs":{"264":{"tf":2.0},"265":{"tf":1.0},"283":{"tf":1.4142135623730951},"284":{"tf":1.4142135623730951},"289":{"tf":1.7320508075688772},"291":{"tf":1.7320508075688772}}}}}},"df":7,"docs":{"235":{"tf":1.0},"237":{"tf":1.4142135623730951},"238":{"tf":1.0},"241":{"tf":1.7320508075688772},"245":{"tf":1.0},"264":{"tf":1.0},"57":{"tf":1.7320508075688772}},"o":{"df":0,"docs":{},"r":{"1":{"df":1,"docs":{"243":{"tf":1.0}}},"2":{"df":1,"docs":{"243":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"246":{"tf":1.7320508075688772},"248":{"tf":1.7320508075688772},"250":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{}},"[":{"df":0,"docs":{},"e":{"0":{"5":{"9":{"7":{"df":1,"docs":{"192":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":73,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"108":{"tf":1.0},"115":{"tf":2.23606797749979},"116":{"tf":1.4142135623730951},"123":{"tf":1.0},"13":{"tf":2.0},"144":{"tf":1.4142135623730951},"159":{"tf":1.4142135623730951},"161":{"tf":1.0},"164":{"tf":2.23606797749979},"167":{"tf":1.7320508075688772},"168":{"tf":1.0},"169":{"tf":1.4142135623730951},"171":{"tf":1.0},"172":{"tf":1.0},"174":{"tf":1.7320508075688772},"177":{"tf":1.0},"197":{"tf":1.4142135623730951},"205":{"tf":1.4142135623730951},"207":{"tf":1.4142135623730951},"21":{"tf":1.0},"210":{"tf":1.0},"220":{"tf":3.0},"221":{"tf":1.7320508075688772},"222":{"tf":1.0},"230":{"tf":1.0},"232":{"tf":1.0},"235":{"tf":2.449489742783178},"236":{"tf":1.7320508075688772},"237":{"tf":2.449489742783178},"238":{"tf":1.4142135623730951},"24":{"tf":1.0},"240":{"tf":2.0},"242":{"tf":1.0},"243":{"tf":2.6457513110645907},"244":{"tf":2.0},"245":{"tf":4.242640687119285},"246":{"tf":2.23606797749979},"247":{"tf":1.0},"248":{"tf":2.23606797749979},"250":{"tf":3.0},"254":{"tf":1.7320508075688772},"256":{"tf":2.23606797749979},"257":{"tf":1.0},"26":{"tf":1.4142135623730951},"260":{"tf":1.0},"264":{"tf":1.0},"266":{"tf":2.0},"268":{"tf":1.4142135623730951},"270":{"tf":1.0},"286":{"tf":1.0},"287":{"tf":1.0},"296":{"tf":1.4142135623730951},"302":{"tf":1.0},"305":{"tf":1.0},"306":{"tf":1.0},"323":{"tf":1.4142135623730951},"326":{"tf":1.4142135623730951},"40":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.4142135623730951},"5":{"tf":1.0},"57":{"tf":1.0},"6":{"tf":1.0},"82":{"tf":1.0},"88":{"tf":1.0},"95":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951},"97":{"tf":2.0}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"256":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"e":{")":{")":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"254":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"306":{"tf":1.0}}}}}}}}},"s":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"219":{"tf":1.0}}}}}}},"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"262":{"tf":4.0}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"172":{"tf":1.0}}}}}},"df":1,"docs":{"219":{"tf":1.0}},"i":{"df":1,"docs":{"318":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"225":{"tf":1.0},"287":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":1,"docs":{"284":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"194":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"284":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"t":{"c":{":":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{":":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":6,"docs":{"130":{"tf":1.0},"283":{"tf":1.0},"308":{"tf":1.0},"321":{"tf":1.0},"324":{"tf":1.0},"51":{"tf":1.0}}},"df":3,"docs":{"164":{"tf":1.0},"266":{"tf":1.0},"284":{"tf":1.4142135623730951}}},"u":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}},"v":{"a":{"df":0,"docs":{},"l":{"`":{"df":1,"docs":{"219":{"tf":1.0}}},"df":2,"docs":{"218":{"tf":2.0},"219":{"tf":3.0}},"u":{"df":12,"docs":{"133":{"tf":1.7320508075688772},"224":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.7320508075688772},"231":{"tf":1.4142135623730951},"232":{"tf":1.4142135623730951},"233":{"tf":1.0},"276":{"tf":1.0},"300":{"tf":1.0},"72":{"tf":1.0},"88":{"tf":1.7320508075688772},"92":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":16,"docs":{"0":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.7320508075688772},"132":{"tf":1.0},"136":{"tf":1.0},"146":{"tf":1.0},"210":{"tf":1.0},"225":{"tf":1.0},"238":{"tf":1.0},"262":{"tf":1.4142135623730951},"319":{"tf":1.4142135623730951},"324":{"tf":1.0},"329":{"tf":1.0},"5":{"tf":1.0},"88":{"tf":1.0},"94":{"tf":1.0}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"57":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"31":{"tf":1.4142135623730951}},"u":{"df":1,"docs":{"225":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"268":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"327":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":5,"docs":{"125":{"tf":1.0},"136":{"tf":1.0},"227":{"tf":1.0},"256":{"tf":1.0},"3":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"v":{"df":1,"docs":{"325":{"tf":1.0}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"10":{"tf":1.0},"113":{"tf":1.0},"206":{"tf":1.0},"50":{"tf":1.0},"70":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":9,"docs":{"101":{"tf":1.0},"113":{"tf":1.0},"13":{"tf":1.0},"156":{"tf":1.0},"207":{"tf":1.0},"241":{"tf":1.4142135623730951},"327":{"tf":1.0},"80":{"tf":1.0},"96":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"161":{"tf":1.4142135623730951},"319":{"tf":1.0},"78":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":103,"docs":{"0":{"tf":2.0},"10":{"tf":1.0},"107":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"113":{"tf":1.0},"120":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.7320508075688772},"131":{"tf":1.4142135623730951},"133":{"tf":1.0},"136":{"tf":1.4142135623730951},"144":{"tf":1.7320508075688772},"146":{"tf":1.0},"150":{"tf":1.0},"152":{"tf":1.0},"156":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"165":{"tf":1.0},"169":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.4142135623730951},"177":{"tf":1.0},"179":{"tf":1.0},"187":{"tf":1.0},"190":{"tf":1.0},"191":{"tf":1.4142135623730951},"194":{"tf":1.0},"196":{"tf":1.4142135623730951},"200":{"tf":1.0},"202":{"tf":1.4142135623730951},"205":{"tf":1.4142135623730951},"206":{"tf":1.0},"208":{"tf":1.0},"210":{"tf":1.0},"212":{"tf":1.0},"216":{"tf":1.0},"217":{"tf":1.0},"218":{"tf":1.0},"219":{"tf":1.0},"220":{"tf":1.7320508075688772},"222":{"tf":1.4142135623730951},"223":{"tf":1.4142135623730951},"225":{"tf":1.0},"227":{"tf":1.0},"230":{"tf":1.4142135623730951},"231":{"tf":1.0},"232":{"tf":1.0},"235":{"tf":1.0},"236":{"tf":1.0},"237":{"tf":1.0},"238":{"tf":1.0},"240":{"tf":1.4142135623730951},"241":{"tf":1.0},"242":{"tf":1.4142135623730951},"243":{"tf":1.0},"248":{"tf":1.4142135623730951},"25":{"tf":1.7320508075688772},"252":{"tf":1.0},"26":{"tf":1.0},"268":{"tf":1.0},"269":{"tf":1.4142135623730951},"276":{"tf":1.0},"283":{"tf":1.0},"284":{"tf":1.4142135623730951},"286":{"tf":1.0},"288":{"tf":1.0},"3":{"tf":1.0},"300":{"tf":1.0},"301":{"tf":1.0},"305":{"tf":1.4142135623730951},"306":{"tf":1.7320508075688772},"309":{"tf":1.4142135623730951},"313":{"tf":1.0},"314":{"tf":1.0},"315":{"tf":1.0},"316":{"tf":1.7320508075688772},"317":{"tf":1.7320508075688772},"318":{"tf":1.4142135623730951},"319":{"tf":1.0},"321":{"tf":1.0},"322":{"tf":1.0},"323":{"tf":1.7320508075688772},"324":{"tf":1.4142135623730951},"326":{"tf":1.0},"329":{"tf":1.0},"330":{"tf":1.0},"332":{"tf":1.0},"333":{"tf":1.0},"336":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.0},"76":{"tf":1.0},"88":{"tf":2.23606797749979},"96":{"tf":1.0},"99":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"237":{"tf":1.0}}},"df":0,"docs":{},"s":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"270":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"c":{"df":0,"docs":{},"e":{"df":3,"docs":{"177":{"tf":1.4142135623730951},"187":{"tf":1.0},"48":{"tf":1.0}},"e":{"d":{"df":1,"docs":{"112":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"t":{"df":7,"docs":{"13":{"tf":1.0},"212":{"tf":1.0},"227":{"tf":1.0},"248":{"tf":1.0},"319":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0}},"e":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}}}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"267":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":2,"docs":{"113":{"tf":1.0},"304":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"323":{"tf":1.0},"69":{"tf":1.0}}}}}},"df":1,"docs":{"284":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"123":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":9,"docs":{"1":{"tf":1.4142135623730951},"123":{"tf":1.0},"125":{"tf":1.0},"191":{"tf":1.0},"224":{"tf":1.0},"240":{"tf":1.0},"288":{"tf":1.0},"296":{"tf":1.0},"316":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":3,"docs":{"222":{"tf":1.0},"306":{"tf":1.0},"6":{"tf":1.0}}},"t":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"h":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":12,"docs":{"127":{"tf":1.4142135623730951},"171":{"tf":1.0},"194":{"tf":1.0},"224":{"tf":1.0},"269":{"tf":1.0},"283":{"tf":1.0},"284":{"tf":1.0},"287":{"tf":1.0},"291":{"tf":1.0},"44":{"tf":1.4142135623730951},"49":{"tf":1.0},"51":{"tf":1.0}}}},"t":{"df":11,"docs":{"105":{"tf":1.0},"113":{"tf":1.0},"164":{"tf":1.0},"179":{"tf":1.0},"202":{"tf":1.4142135623730951},"221":{"tf":1.0},"235":{"tf":1.0},"26":{"tf":1.0},"266":{"tf":1.4142135623730951},"319":{"tf":1.0},"64":{"tf":1.4142135623730951}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":6,"docs":{"212":{"tf":2.0},"218":{"tf":1.0},"257":{"tf":1.0},"265":{"tf":1.4142135623730951},"273":{"tf":1.0},"321":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"127":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"127":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":15,"docs":{"2":{"tf":1.0},"220":{"tf":1.4142135623730951},"223":{"tf":1.4142135623730951},"235":{"tf":1.0},"26":{"tf":1.0},"278":{"tf":1.0},"283":{"tf":1.0},"284":{"tf":1.0},"287":{"tf":1.0},"291":{"tf":1.0},"300":{"tf":1.4142135623730951},"302":{"tf":1.0},"316":{"tf":1.0},"317":{"tf":1.0},"326":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"335":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"248":{"tf":1.0},"264":{"tf":1.0},"49":{"tf":1.0}}}},"n":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":12,"docs":{"177":{"tf":2.449489742783178},"199":{"tf":1.0},"206":{"tf":1.0},"220":{"tf":1.0},"223":{"tf":1.4142135623730951},"282":{"tf":1.0},"318":{"tf":2.0},"319":{"tf":1.4142135623730951},"34":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"48":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":18,"docs":{"136":{"tf":1.4142135623730951},"138":{"tf":2.23606797749979},"140":{"tf":1.0},"156":{"tf":2.0},"177":{"tf":1.0},"205":{"tf":1.0},"220":{"tf":1.4142135623730951},"221":{"tf":1.0},"222":{"tf":1.4142135623730951},"223":{"tf":1.4142135623730951},"233":{"tf":1.0},"235":{"tf":1.0},"236":{"tf":1.0},"240":{"tf":1.7320508075688772},"276":{"tf":1.0},"323":{"tf":1.0},"34":{"tf":1.0},"92":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"280":{"tf":1.0},"326":{"tf":1.0}}}},"s":{"df":1,"docs":{"289":{"tf":1.0}}}},"r":{"df":1,"docs":{"214":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":27,"docs":{"0":{"tf":1.4142135623730951},"113":{"tf":1.7320508075688772},"133":{"tf":1.4142135623730951},"144":{"tf":1.0},"150":{"tf":2.23606797749979},"156":{"tf":1.4142135623730951},"158":{"tf":1.0},"214":{"tf":2.449489742783178},"216":{"tf":1.0},"218":{"tf":1.0},"23":{"tf":1.4142135623730951},"264":{"tf":1.0},"265":{"tf":1.7320508075688772},"276":{"tf":1.4142135623730951},"28":{"tf":1.0},"286":{"tf":1.0},"3":{"tf":1.0},"300":{"tf":1.4142135623730951},"50":{"tf":1.0},"61":{"tf":3.0},"63":{"tf":2.0},"66":{"tf":1.0},"72":{"tf":1.0},"84":{"tf":1.0},"90":{"tf":1.0},"94":{"tf":1.4142135623730951},"96":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"214":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"219":{"tf":1.0},"280":{"tf":1.0},"309":{"tf":1.0},"319":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"154":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":9,"docs":{"123":{"tf":1.7320508075688772},"191":{"tf":1.0},"297":{"tf":2.0},"305":{"tf":1.0},"308":{"tf":1.0},"320":{"tf":1.0},"324":{"tf":1.0},"326":{"tf":1.4142135623730951},"329":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"13":{"tf":1.0},"24":{"tf":1.0},"263":{"tf":1.0}}}},"df":8,"docs":{"116":{"tf":1.0},"126":{"tf":1.0},"159":{"tf":1.4142135623730951},"245":{"tf":1.0},"250":{"tf":1.0},"295":{"tf":1.0},"5":{"tf":1.0},"51":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"136":{"tf":1.0},"3":{"tf":1.0}}}}}}}},"f":{"(":{"3":{"df":1,"docs":{"99":{"tf":1.0}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"291":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"s":{".":{"a":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"291":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"3":{"2":{":":{":":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{":":{":":{"<":{"df":0,"docs":{},"u":{"8":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":10,"docs":{"140":{"tf":1.0},"159":{"tf":2.23606797749979},"16":{"tf":1.4142135623730951},"20":{"tf":1.0},"24":{"tf":1.7320508075688772},"268":{"tf":1.0},"28":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"297":{"tf":1.4142135623730951},"51":{"tf":1.0}}},"df":0,"docs":{}},"6":{"4":{"df":18,"docs":{"10":{"tf":1.4142135623730951},"140":{"tf":1.4142135623730951},"144":{"tf":2.6457513110645907},"159":{"tf":2.23606797749979},"161":{"tf":1.7320508075688772},"197":{"tf":1.0},"199":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.7320508075688772},"23":{"tf":1.0},"259":{"tf":1.4142135623730951},"264":{"tf":2.6457513110645907},"265":{"tf":2.8284271247461903},"268":{"tf":1.0},"301":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0},"95":{"tf":3.0}}},"df":0,"docs":{}},"a":{"a":{"df":1,"docs":{"82":{"tf":1.7320508075688772}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"316":{"tf":1.0}}}},"t":{"df":2,"docs":{"113":{"tf":1.0},"146":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"217":{"tf":1.0}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"84":{"tf":1.4142135623730951}}}}}}}}}},"i":{"df":0,"docs":{},"l":{"df":29,"docs":{"10":{"tf":1.0},"127":{"tf":1.4142135623730951},"144":{"tf":1.0},"161":{"tf":1.0},"177":{"tf":1.0},"217":{"tf":1.0},"220":{"tf":1.4142135623730951},"245":{"tf":1.0},"252":{"tf":1.0},"253":{"tf":1.0},"254":{"tf":1.0},"255":{"tf":1.0},"262":{"tf":1.4142135623730951},"263":{"tf":1.0},"264":{"tf":2.23606797749979},"265":{"tf":1.4142135623730951},"268":{"tf":1.0},"280":{"tf":1.0},"288":{"tf":1.0},"300":{"tf":2.6457513110645907},"302":{"tf":1.4142135623730951},"303":{"tf":2.0},"304":{"tf":2.0},"305":{"tf":1.4142135623730951},"306":{"tf":1.0},"308":{"tf":1.7320508075688772},"317":{"tf":1.0},"88":{"tf":2.23606797749979},"92":{"tf":1.4142135623730951}},"e":{"d":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"<":{"'":{"a":{"df":1,"docs":{"177":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"177":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"df":14,"docs":{"0":{"tf":1.0},"220":{"tf":1.0},"223":{"tf":1.0},"235":{"tf":1.0},"256":{"tf":1.0},"263":{"tf":1.7320508075688772},"264":{"tf":1.7320508075688772},"266":{"tf":1.0},"282":{"tf":1.4142135623730951},"283":{"tf":1.0},"284":{"tf":1.0},"300":{"tf":1.4142135623730951},"305":{"tf":1.0},"88":{"tf":2.0}}}}},"r":{"df":1,"docs":{"112":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"248":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"231":{"tf":1.7320508075688772},"232":{"tf":1.0},"233":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"229":{"tf":1.0},"233":{"tf":1.0}},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":12,"docs":{"108":{"tf":1.0},"113":{"tf":1.0},"133":{"tf":1.4142135623730951},"196":{"tf":1.0},"20":{"tf":1.0},"215":{"tf":1.0},"23":{"tf":2.0},"269":{"tf":1.0},"300":{"tf":1.0},"72":{"tf":1.0},"88":{"tf":1.4142135623730951},"94":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"316":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"262":{"tf":1.0}}}}}},"df":0,"docs":{}},"r":{"df":1,"docs":{"26":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"99":{"tf":2.23606797749979}},"l":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"99":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"225":{"tf":1.0},"5":{"tf":1.4142135623730951}}}}}},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"325":{"tf":1.0}}}}}},"v":{"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"208":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"208":{"tf":1.0}}}}}}}},"df":16,"docs":{"10":{"tf":2.0},"101":{"tf":2.8284271247461903},"103":{"tf":1.7320508075688772},"108":{"tf":1.7320508075688772},"13":{"tf":1.0},"16":{"tf":1.4142135623730951},"245":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.0},"250":{"tf":1.0},"291":{"tf":1.7320508075688772},"297":{"tf":1.0},"323":{"tf":1.0},"49":{"tf":1.4142135623730951},"59":{"tf":1.0},"99":{"tf":2.6457513110645907}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":8,"docs":{"0":{"tf":1.0},"124":{"tf":1.0},"126":{"tf":1.0},"130":{"tf":1.0},"269":{"tf":1.0},"32":{"tf":1.0},"326":{"tf":1.0},"337":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"113":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}},"n":{"c":{"df":1,"docs":{"329":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"127":{"tf":3.3166247903554},"70":{"tf":2.6457513110645907}},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"127":{"tf":3.0}}}}}},"df":0,"docs":{}}}}},"w":{"df":13,"docs":{"107":{"tf":1.0},"175":{"tf":1.0},"179":{"tf":1.0},"190":{"tf":1.0},"194":{"tf":1.0},"3":{"tf":1.4142135623730951},"31":{"tf":1.0},"316":{"tf":1.0},"317":{"tf":1.0},"323":{"tf":1.0},"330":{"tf":1.0},"61":{"tf":1.0},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"324":{"tf":1.0}}}}}},"f":{"df":0,"docs":{},"i":{"df":3,"docs":{"297":{"tf":1.0},"311":{"tf":1.0},"324":{"tf":1.0}}}},"i":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"c":{"c":{"df":0,"docs":{},"i":{"(":{")":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"(":{"4":{")":{".":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"(":{"4":{"df":1,"docs":{"203":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"(":{"4":{"df":1,"docs":{"203":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"203":{"tf":3.1622776601683795}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":9,"docs":{"10":{"tf":1.0},"116":{"tf":3.3166247903554},"125":{"tf":1.7320508075688772},"175":{"tf":2.0},"242":{"tf":1.0},"28":{"tf":2.8284271247461903},"289":{"tf":1.0},"82":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"287":{"tf":1.0}}},".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"283":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"\"":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"\\":{"df":0,"docs":{},"n":{"\"":{".":{"a":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"127":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"\\":{"df":0,"docs":{},"n":{"\"":{".":{"a":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"127":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{".":{"a":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"284":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"120":{"tf":1.0},"280":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},":":{"/":{"/":{"/":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"/":{"b":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"h":{"df":1,"docs":{"127":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},":":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"284":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"291":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"&":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"283":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"287":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"291":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":1,"docs":{"287":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":21,"docs":{"0":{"tf":1.0},"120":{"tf":2.0},"121":{"tf":1.7320508075688772},"122":{"tf":1.0},"125":{"tf":1.7320508075688772},"127":{"tf":2.8284271247461903},"128":{"tf":1.0},"129":{"tf":1.0},"202":{"tf":1.0},"220":{"tf":1.0},"242":{"tf":1.0},"273":{"tf":1.0},"280":{"tf":1.4142135623730951},"282":{"tf":2.6457513110645907},"283":{"tf":3.1622776601683795},"284":{"tf":2.8284271247461903},"286":{"tf":1.7320508075688772},"287":{"tf":2.23606797749979},"291":{"tf":1.7320508075688772},"308":{"tf":2.449489742783178},"309":{"tf":1.4142135623730951}},"s":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"308":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":3,"docs":{"125":{"tf":1.0},"280":{"tf":1.0},"291":{"tf":1.4142135623730951}}}}}}}}},"l":{"df":1,"docs":{"318":{"tf":2.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"|":{"&":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"x":{"df":1,"docs":{"206":{"tf":1.0}}}}},"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"|":{"df":1,"docs":{"253":{"tf":1.0}},"r":{"df":1,"docs":{"254":{"tf":1.0}}}}},"df":2,"docs":{"253":{"tf":1.4142135623730951},"254":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":10,"docs":{"127":{"tf":1.4142135623730951},"206":{"tf":1.4142135623730951},"253":{"tf":1.0},"300":{"tf":1.0},"302":{"tf":1.4142135623730951},"303":{"tf":2.0},"304":{"tf":2.0},"305":{"tf":1.4142135623730951},"308":{"tf":1.7320508075688772},"84":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"276":{"tf":1.7320508075688772}}}}}}}}},"df":7,"docs":{"276":{"tf":1.4142135623730951},"291":{"tf":1.0},"317":{"tf":1.0},"324":{"tf":1.0},"38":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}}}},"d":{"(":{"df":0,"docs":{},"|":{"&":{"&":{"df":0,"docs":{},"x":{"df":1,"docs":{"110":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"<":{"df":0,"docs":{},"p":{">":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"110":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"!":{"(":{"$":{"(":{"$":{"df":0,"docs":{},"i":{"df":1,"docs":{"216":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"df":1,"docs":{"216":{"tf":1.4142135623730951}}},"5":{"df":1,"docs":{"216":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"216":{"tf":1.7320508075688772}}}}}},"df":7,"docs":{"110":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.0},"225":{"tf":1.0},"241":{"tf":1.0},"242":{"tf":1.0},"329":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":4,"docs":{"113":{"tf":1.4142135623730951},"179":{"tf":1.0},"220":{"tf":1.0},"321":{"tf":1.0}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":7,"docs":{"127":{"tf":1.4142135623730951},"203":{"tf":1.0},"275":{"tf":1.0},"279":{"tf":1.0},"288":{"tf":1.0},"290":{"tf":1.4142135623730951},"316":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"300":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"156":{"tf":1.4142135623730951},"158":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"i":{"3":{"2":{">":{"(":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"n":{"df":1,"docs":{"244":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"243":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"248":{"tf":1.0},"250":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"_":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"230":{"tf":1.7320508075688772},"231":{"tf":1.7320508075688772},"232":{"tf":1.7320508075688772},"233":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":6,"docs":{"235":{"tf":1.4142135623730951},"237":{"tf":1.0},"238":{"tf":1.0},"240":{"tf":1.4142135623730951},"241":{"tf":1.0},"242":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"i":{"3":{"2":{">":{"(":{")":{".":{"a":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":2,"docs":{"237":{"tf":1.0},"238":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"235":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"237":{"tf":1.0},"240":{"tf":1.0},"241":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":40,"docs":{"10":{"tf":1.0},"110":{"tf":1.0},"127":{"tf":1.0},"13":{"tf":1.0},"136":{"tf":1.7320508075688772},"150":{"tf":1.0},"156":{"tf":1.4142135623730951},"158":{"tf":1.4142135623730951},"159":{"tf":1.7320508075688772},"16":{"tf":1.0},"189":{"tf":2.0},"191":{"tf":1.0},"203":{"tf":1.7320508075688772},"221":{"tf":1.0},"237":{"tf":1.0},"24":{"tf":1.0},"243":{"tf":2.0},"244":{"tf":2.449489742783178},"245":{"tf":1.4142135623730951},"246":{"tf":1.4142135623730951},"248":{"tf":1.7320508075688772},"250":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"269":{"tf":1.0},"286":{"tf":1.4142135623730951},"294":{"tf":1.0},"305":{"tf":1.0},"313":{"tf":1.0},"315":{"tf":1.0},"316":{"tf":1.7320508075688772},"317":{"tf":1.0},"321":{"tf":1.0},"323":{"tf":1.0},"329":{"tf":1.0},"45":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"72":{"tf":1.0},"76":{"tf":1.7320508075688772},"86":{"tf":1.0},"95":{"tf":1.7320508075688772}}}}},"t":{"df":1,"docs":{"48":{"tf":1.7320508075688772}}},"x":{"df":4,"docs":{"26":{"tf":1.0},"6":{"tf":1.0},"84":{"tf":1.0},"88":{"tf":1.0}},"m":{"df":14,"docs":{"131":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0},"260":{"tf":1.4142135623730951},"269":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.4142135623730951},"5":{"tf":1.0},"6":{"tf":1.0},"70":{"tf":1.0}}}},"z":{"df":0,"docs":{},"z":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"z":{"df":0,"docs":{},"z":{"(":{"df":0,"docs":{},"n":{"df":1,"docs":{"94":{"tf":1.4142135623730951}}}},"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"(":{"1":{"0":{"0":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":1,"docs":{"94":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":3,"docs":{"67":{"tf":1.0},"69":{"tf":1.0},"94":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":6,"docs":{"121":{"tf":1.0},"123":{"tf":1.0},"126":{"tf":1.0},"132":{"tf":1.0},"135":{"tf":1.7320508075688772},"288":{"tf":1.0}}},"t":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"227":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"227":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"112":{"tf":1.0},"280":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"225":{"tf":1.0},"248":{"tf":1.0},"97":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"i":{"df":2,"docs":{"96":{"tf":1.0},"99":{"tf":1.0}},"p":{"df":1,"docs":{"5":{"tf":1.0}}}},"o":{"a":{"df":0,"docs":{},"t":{"df":8,"docs":{"0":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"268":{"tf":1.0},"301":{"tf":1.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.0}}}},"df":0,"docs":{},"w":{"df":4,"docs":{"0":{"tf":1.0},"225":{"tf":1.0},"279":{"tf":1.0},"62":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"286":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":9,"docs":{"10":{"tf":1.7320508075688772},"13":{"tf":1.0},"16":{"tf":1.0},"245":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.0},"250":{"tf":1.0},"297":{"tf":1.0},"59":{"tf":1.0}}}}}}},"df":0,"docs":{}},":":{":":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":4,"docs":{"10":{"tf":1.7320508075688772},"297":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":2.449489742783178}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":12,"docs":{"10":{"tf":3.1622776601683795},"13":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":1.0},"245":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.0},"25":{"tf":1.0},"250":{"tf":1.0},"5":{"tf":2.449489742783178},"59":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":8,"docs":{"10":{"tf":1.7320508075688772},"13":{"tf":1.0},"245":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.0},"250":{"tf":1.0},"297":{"tf":1.0},"59":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":9,"docs":{"10":{"tf":2.0},"13":{"tf":1.7320508075688772},"16":{"tf":1.0},"245":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.0},"250":{"tf":1.0},"297":{"tf":1.0},"59":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"10":{"tf":1.7320508075688772},"13":{"tf":1.0}}}},"n":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"105":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"(":{")":{">":{"(":{"df":0,"docs":{},"f":{"df":1,"docs":{"103":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"3":{"2":{"df":2,"docs":{"206":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"105":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"105":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"105":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":205,"docs":{"1":{"tf":1.0},"10":{"tf":2.0},"100":{"tf":1.0},"101":{"tf":2.8284271247461903},"102":{"tf":1.0},"103":{"tf":2.6457513110645907},"104":{"tf":1.0},"105":{"tf":2.449489742783178},"106":{"tf":1.0},"108":{"tf":1.4142135623730951},"110":{"tf":1.7320508075688772},"112":{"tf":1.4142135623730951},"113":{"tf":2.449489742783178},"115":{"tf":3.7416573867739413},"116":{"tf":1.4142135623730951},"118":{"tf":2.0},"119":{"tf":2.449489742783178},"120":{"tf":2.8284271247461903},"122":{"tf":1.7320508075688772},"123":{"tf":1.0},"127":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"130":{"tf":1.0},"131":{"tf":2.0},"132":{"tf":1.7320508075688772},"133":{"tf":1.7320508075688772},"135":{"tf":1.4142135623730951},"136":{"tf":1.4142135623730951},"138":{"tf":2.23606797749979},"140":{"tf":1.7320508075688772},"142":{"tf":1.7320508075688772},"144":{"tf":2.449489742783178},"146":{"tf":1.7320508075688772},"148":{"tf":1.7320508075688772},"150":{"tf":1.7320508075688772},"152":{"tf":2.23606797749979},"156":{"tf":3.1622776601683795},"158":{"tf":3.3166247903554},"159":{"tf":1.0},"16":{"tf":1.4142135623730951},"161":{"tf":1.7320508075688772},"164":{"tf":1.4142135623730951},"165":{"tf":1.4142135623730951},"167":{"tf":1.4142135623730951},"168":{"tf":1.0},"169":{"tf":1.0},"171":{"tf":1.7320508075688772},"172":{"tf":1.7320508075688772},"174":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.0},"177":{"tf":1.7320508075688772},"179":{"tf":2.449489742783178},"181":{"tf":1.7320508075688772},"183":{"tf":1.0},"185":{"tf":1.4142135623730951},"187":{"tf":1.7320508075688772},"189":{"tf":1.7320508075688772},"190":{"tf":1.0},"191":{"tf":2.0},"192":{"tf":1.4142135623730951},"194":{"tf":2.23606797749979},"196":{"tf":3.3166247903554},"197":{"tf":1.4142135623730951},"199":{"tf":2.23606797749979},"200":{"tf":1.7320508075688772},"202":{"tf":1.4142135623730951},"203":{"tf":1.7320508075688772},"205":{"tf":1.4142135623730951},"206":{"tf":2.6457513110645907},"207":{"tf":1.0},"208":{"tf":2.449489742783178},"21":{"tf":1.0},"210":{"tf":2.23606797749979},"212":{"tf":1.0},"214":{"tf":1.4142135623730951},"215":{"tf":1.0},"216":{"tf":1.0},"217":{"tf":1.4142135623730951},"218":{"tf":1.0},"219":{"tf":1.0},"221":{"tf":1.4142135623730951},"222":{"tf":2.449489742783178},"223":{"tf":1.7320508075688772},"224":{"tf":1.7320508075688772},"225":{"tf":2.449489742783178},"227":{"tf":2.6457513110645907},"23":{"tf":1.0},"230":{"tf":1.0},"231":{"tf":1.0},"232":{"tf":1.0},"233":{"tf":1.0},"235":{"tf":1.4142135623730951},"236":{"tf":1.4142135623730951},"237":{"tf":2.449489742783178},"238":{"tf":1.7320508075688772},"24":{"tf":1.4142135623730951},"240":{"tf":1.7320508075688772},"241":{"tf":1.7320508075688772},"242":{"tf":1.7320508075688772},"243":{"tf":1.4142135623730951},"244":{"tf":2.0},"245":{"tf":2.0},"246":{"tf":2.0},"248":{"tf":2.0},"250":{"tf":2.449489742783178},"252":{"tf":1.0},"253":{"tf":1.0},"254":{"tf":1.0},"255":{"tf":1.0},"256":{"tf":1.4142135623730951},"259":{"tf":1.7320508075688772},"26":{"tf":1.4142135623730951},"260":{"tf":1.0},"261":{"tf":1.0},"262":{"tf":1.7320508075688772},"263":{"tf":1.7320508075688772},"264":{"tf":2.23606797749979},"265":{"tf":2.449489742783178},"266":{"tf":1.4142135623730951},"267":{"tf":1.4142135623730951},"268":{"tf":1.4142135623730951},"269":{"tf":1.0},"270":{"tf":1.0},"272":{"tf":1.0},"275":{"tf":1.0},"276":{"tf":1.0},"279":{"tf":1.0},"28":{"tf":1.0},"280":{"tf":1.0},"283":{"tf":1.0},"284":{"tf":1.0},"286":{"tf":1.4142135623730951},"287":{"tf":1.4142135623730951},"288":{"tf":1.0},"289":{"tf":1.0},"290":{"tf":1.0},"291":{"tf":2.23606797749979},"294":{"tf":1.0},"296":{"tf":2.0},"297":{"tf":2.6457513110645907},"3":{"tf":1.0},"300":{"tf":2.0},"301":{"tf":1.4142135623730951},"302":{"tf":2.0},"304":{"tf":2.0},"305":{"tf":1.7320508075688772},"306":{"tf":2.0},"308":{"tf":2.0},"309":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"312":{"tf":1.0},"313":{"tf":1.0},"318":{"tf":1.0},"319":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"320":{"tf":1.4142135623730951},"322":{"tf":1.0},"326":{"tf":1.4142135623730951},"329":{"tf":1.7320508075688772},"33":{"tf":1.0},"336":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":2.23606797749979},"40":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"55":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"60":{"tf":1.0},"61":{"tf":1.7320508075688772},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.4142135623730951},"70":{"tf":1.7320508075688772},"72":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.4142135623730951},"86":{"tf":2.0},"88":{"tf":1.7320508075688772},"90":{"tf":1.7320508075688772},"94":{"tf":2.23606797749979},"95":{"tf":2.6457513110645907},"96":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951},"99":{"tf":2.8284271247461903}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"105":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"110":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"108":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":10,"docs":{"100":{"tf":1.0},"101":{"tf":1.4142135623730951},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"106":{"tf":1.0},"108":{"tf":1.0},"110":{"tf":1.0},"99":{"tf":2.0}}}}},"o":{"df":0,"docs":{},"n":{"c":{"df":7,"docs":{"100":{"tf":1.0},"101":{"tf":1.7320508075688772},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"99":{"tf":2.23606797749979}},"e":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"105":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"0":{"tf":1.0},"222":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":50,"docs":{"115":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.0},"128":{"tf":1.0},"130":{"tf":1.0},"138":{"tf":1.0},"144":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"176":{"tf":1.0},"177":{"tf":1.4142135623730951},"179":{"tf":1.4142135623730951},"187":{"tf":1.0},"191":{"tf":1.0},"194":{"tf":1.0},"197":{"tf":1.0},"200":{"tf":1.0},"202":{"tf":1.0},"203":{"tf":1.0},"205":{"tf":1.0},"213":{"tf":1.0},"216":{"tf":1.4142135623730951},"220":{"tf":1.0},"223":{"tf":1.0},"225":{"tf":1.0},"227":{"tf":1.0},"229":{"tf":1.0},"230":{"tf":1.0},"231":{"tf":1.0},"232":{"tf":1.0},"233":{"tf":1.4142135623730951},"236":{"tf":1.4142135623730951},"237":{"tf":1.4142135623730951},"24":{"tf":1.0},"243":{"tf":1.0},"25":{"tf":1.0},"269":{"tf":1.4142135623730951},"296":{"tf":1.0},"3":{"tf":1.0},"314":{"tf":1.0},"317":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"74":{"tf":1.0},"88":{"tf":1.0},"92":{"tf":1.0},"99":{"tf":1.0}}}}}},"o":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"320":{"tf":1.0}}}}},"df":0,"docs":{},"x":{"df":1,"docs":{"167":{"tf":1.0}}}},".":{"a":{"d":{"d":{"(":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"200":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"88":{"tf":3.1622776601683795}}},"z":{"df":1,"docs":{"88":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"x":{"(":{"1":{"0":{"0":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":1,"docs":{"88":{"tf":1.0}}}}},"r":{"#":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"326":{"tf":1.0}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"326":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"<":{"'":{"a":{"df":1,"docs":{"177":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{">":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"136":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"b":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"200":{"tf":2.23606797749979},"88":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"d":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"f":{"df":1,"docs":{"225":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":1,"docs":{"227":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"227":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"227":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"225":{"tf":3.3166247903554},"227":{"tf":3.1622776601683795}}},"df":13,"docs":{"113":{"tf":1.0},"125":{"tf":2.23606797749979},"126":{"tf":1.4142135623730951},"127":{"tf":1.0},"136":{"tf":1.0},"16":{"tf":2.0},"177":{"tf":2.0},"200":{"tf":3.0},"214":{"tf":1.4142135623730951},"320":{"tf":1.0},"326":{"tf":1.7320508075688772},"82":{"tf":3.872983346207417},"88":{"tf":1.4142135623730951}},"t":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"197":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":2,"docs":{"161":{"tf":1.0},"197":{"tf":2.0}}}},"r":{"b":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"167":{"tf":1.0}}}}},"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}}},"c":{"df":7,"docs":{"156":{"tf":1.0},"177":{"tf":1.0},"218":{"tf":1.0},"219":{"tf":1.0},"241":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":2,"docs":{"130":{"tf":1.0},"297":{"tf":2.8284271247461903}}}}},"v":{"df":1,"docs":{"113":{"tf":1.0}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"321":{"tf":1.0},"63":{"tf":1.0}}}}},"m":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"210":{"tf":1.0}}}}}},"a":{"df":0,"docs":{},"t":{"!":{"(":{"\"":{"0":{"df":0,"docs":{},"o":{"df":0,"docs":{},"{":{":":{"df":0,"docs":{},"o":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}},"x":{"df":0,"docs":{},"{":{":":{"df":0,"docs":{},"x":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":16,"docs":{"125":{"tf":1.0},"16":{"tf":3.3166247903554},"17":{"tf":1.0},"197":{"tf":1.0},"208":{"tf":1.0},"212":{"tf":1.0},"219":{"tf":1.0},"25":{"tf":1.4142135623730951},"262":{"tf":1.0},"269":{"tf":1.0},"316":{"tf":1.7320508075688772},"321":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"5":{"tf":3.4641016151377544},"6":{"tf":1.0},"8":{"tf":1.0}},"t":{"df":2,"docs":{"16":{"tf":1.4142135623730951},"197":{"tf":1.0}}}}},"df":13,"docs":{"177":{"tf":1.0},"179":{"tf":1.0},"189":{"tf":1.4142135623730951},"205":{"tf":1.0},"210":{"tf":2.8284271247461903},"236":{"tf":1.0},"240":{"tf":1.0},"26":{"tf":1.0},"262":{"tf":1.0},"27":{"tf":1.0},"45":{"tf":1.0},"5":{"tf":1.0},"95":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"133":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"323":{"tf":1.0},"325":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"df":10,"docs":{"121":{"tf":1.0},"200":{"tf":1.0},"210":{"tf":1.0},"223":{"tf":1.4142135623730951},"235":{"tf":1.4142135623730951},"238":{"tf":1.0},"255":{"tf":1.0},"260":{"tf":1.0},"261":{"tf":1.0},"326":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"r":{"df":5,"docs":{"177":{"tf":1.4142135623730951},"203":{"tf":1.4142135623730951},"311":{"tf":1.0},"319":{"tf":1.0},"5":{"tf":1.0}}}},"x":{"df":3,"docs":{"261":{"tf":1.0},"289":{"tf":1.0},"5":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"317":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"70":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"267":{"tf":1.0}}},"df":0,"docs":{},"e":{"d":{"df":6,"docs":{"163":{"tf":1.0},"164":{"tf":2.23606797749979},"167":{"tf":2.0},"259":{"tf":1.0},"266":{"tf":1.0},"95":{"tf":1.0}}},"df":9,"docs":{"1":{"tf":1.0},"138":{"tf":1.0},"164":{"tf":1.7320508075688772},"167":{"tf":1.0},"202":{"tf":1.4142135623730951},"266":{"tf":1.4142135623730951},"280":{"tf":1.0},"317":{"tf":1.0},"56":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"280":{"tf":1.0}}}},"z":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"329":{"tf":1.0},"5":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"250":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"55":{"tf":1.0}}}}}}},"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"57":{"tf":1.0}}}}}}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"248":{"tf":1.4142135623730951},"249":{"tf":1.0},"251":{"tf":1.0}}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"250":{"tf":1.0}}}}}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"255":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"237":{"tf":1.0},"60":{"tf":1.4142135623730951}}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"46":{"tf":1.7320508075688772}}}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{":":{":":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"232":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"233":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":4,"docs":{"230":{"tf":1.0},"231":{"tf":1.0},"232":{"tf":1.0},"233":{"tf":1.0}}}}}},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"291":{"tf":1.0}}}},":":{":":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"(":{"\"":{"a":{"df":1,"docs":{"291":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"\"":{"a":{"/":{"c":{"/":{"d":{"\"":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"291":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"(":{"\"":{"a":{"df":1,"docs":{"291":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"(":{"\"":{"a":{"/":{"c":{"/":{"d":{"\"":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"291":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"(":{"\"":{"a":{"/":{"c":{"/":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"\"":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"291":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"291":{"tf":1.0}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"129":{"tf":1.0},"269":{"tf":1.0},"319":{"tf":1.0}}}}},"l":{"df":6,"docs":{"118":{"tf":1.0},"16":{"tf":1.0},"319":{"tf":1.4142135623730951},"321":{"tf":1.0},"324":{"tf":1.0},"49":{"tf":1.0}},"i":{"df":3,"docs":{"210":{"tf":1.0},"211":{"tf":1.0},"320":{"tf":1.0}}}}},"n":{":":{":":{"<":{"a":{"df":1,"docs":{"138":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{":":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"217":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"217":{"tf":1.0}}}},"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"214":{"tf":1.4142135623730951}},"e":{":":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"214":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":1,"docs":{"217":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"199":{"tf":1.0}}},"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"96":{"tf":1.0}}}},"df":103,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.0},"101":{"tf":1.7320508075688772},"103":{"tf":2.8284271247461903},"105":{"tf":1.0},"108":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":2.6457513110645907},"113":{"tf":2.6457513110645907},"114":{"tf":1.0},"115":{"tf":3.3166247903554},"118":{"tf":2.8284271247461903},"119":{"tf":3.1622776601683795},"120":{"tf":2.449489742783178},"130":{"tf":1.7320508075688772},"131":{"tf":1.0},"133":{"tf":1.4142135623730951},"136":{"tf":1.4142135623730951},"138":{"tf":3.7416573867739413},"139":{"tf":1.0},"140":{"tf":1.0},"141":{"tf":1.0},"144":{"tf":1.7320508075688772},"146":{"tf":1.4142135623730951},"152":{"tf":1.0},"158":{"tf":1.0},"16":{"tf":1.0},"165":{"tf":1.0},"167":{"tf":1.7320508075688772},"171":{"tf":1.4142135623730951},"172":{"tf":1.4142135623730951},"177":{"tf":2.23606797749979},"179":{"tf":2.23606797749979},"180":{"tf":1.0},"181":{"tf":1.4142135623730951},"183":{"tf":1.0},"185":{"tf":1.0},"187":{"tf":1.4142135623730951},"196":{"tf":1.0},"199":{"tf":2.23606797749979},"200":{"tf":1.0},"202":{"tf":1.7320508075688772},"203":{"tf":1.0},"205":{"tf":2.0},"206":{"tf":2.23606797749979},"207":{"tf":1.0},"210":{"tf":1.0},"212":{"tf":1.7320508075688772},"214":{"tf":1.4142135623730951},"217":{"tf":1.4142135623730951},"218":{"tf":1.0},"220":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.4142135623730951},"227":{"tf":1.4142135623730951},"236":{"tf":1.7320508075688772},"237":{"tf":1.0},"24":{"tf":1.4142135623730951},"240":{"tf":1.0},"242":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"253":{"tf":1.0},"254":{"tf":1.0},"259":{"tf":1.0},"26":{"tf":1.0},"263":{"tf":1.0},"264":{"tf":1.0},"265":{"tf":1.0},"275":{"tf":1.4142135623730951},"283":{"tf":1.0},"284":{"tf":1.0},"29":{"tf":1.4142135623730951},"291":{"tf":1.4142135623730951},"295":{"tf":1.0},"297":{"tf":2.6457513110645907},"3":{"tf":1.0},"300":{"tf":2.6457513110645907},"302":{"tf":1.4142135623730951},"305":{"tf":1.7320508075688772},"306":{"tf":1.0},"308":{"tf":1.0},"31":{"tf":1.0},"311":{"tf":1.4142135623730951},"312":{"tf":1.0},"313":{"tf":1.4142135623730951},"314":{"tf":1.0},"320":{"tf":1.0},"323":{"tf":1.0},"324":{"tf":1.0},"326":{"tf":2.0},"40":{"tf":1.0},"44":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"56":{"tf":1.0},"60":{"tf":1.4142135623730951},"70":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"94":{"tf":3.3166247903554},"95":{"tf":3.605551275463989},"96":{"tf":2.23606797749979},"97":{"tf":1.0},"99":{"tf":2.0}}}}}}},"df":1,"docs":{"164":{"tf":1.0}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"10":{"tf":1.0},"129":{"tf":1.4142135623730951},"316":{"tf":1.0},"319":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"317":{"tf":1.0}}}}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"333":{"tf":1.0}}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"b":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"286":{"tf":1.0}}}}}}},"df":2,"docs":{"17":{"tf":1.0},"78":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"_":{"df":0,"docs":{},"i":{"3":{"2":{"(":{"_":{"df":1,"docs":{"138":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"6":{"df":1,"docs":{"138":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":1,"docs":{"138":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"(":{"_":{"df":1,"docs":{"138":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"a":{"df":1,"docs":{"138":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":1,"docs":{"138":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"140":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":55,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"10":{"tf":1.7320508075688772},"100":{"tf":1.0},"101":{"tf":1.7320508075688772},"103":{"tf":1.0},"106":{"tf":1.0},"116":{"tf":1.4142135623730951},"117":{"tf":1.0},"123":{"tf":1.0},"128":{"tf":1.0},"13":{"tf":1.0},"136":{"tf":4.242640687119285},"138":{"tf":3.7416573867739413},"140":{"tf":2.0},"142":{"tf":2.0},"144":{"tf":2.23606797749979},"150":{"tf":1.0},"154":{"tf":1.4142135623730951},"156":{"tf":2.23606797749979},"158":{"tf":1.4142135623730951},"159":{"tf":2.0},"161":{"tf":1.0},"177":{"tf":1.0},"178":{"tf":1.0},"187":{"tf":2.0},"188":{"tf":1.7320508075688772},"192":{"tf":1.0},"203":{"tf":1.4142135623730951},"205":{"tf":1.4142135623730951},"212":{"tf":1.0},"237":{"tf":1.0},"238":{"tf":1.0},"240":{"tf":1.0},"243":{"tf":1.7320508075688772},"245":{"tf":1.4142135623730951},"262":{"tf":1.0},"266":{"tf":1.0},"28":{"tf":1.0},"287":{"tf":1.7320508075688772},"3":{"tf":1.7320508075688772},"314":{"tf":1.4142135623730951},"315":{"tf":1.0},"316":{"tf":1.4142135623730951},"318":{"tf":1.4142135623730951},"319":{"tf":1.7320508075688772},"32":{"tf":1.0},"327":{"tf":1.0},"333":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0},"57":{"tf":1.0},"95":{"tf":1.4142135623730951},"99":{"tf":1.0}},"i":{"c":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"'":{"c":{"df":1,"docs":{"138":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},":":{":":{"<":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{">":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"'":{"a":{"df":1,"docs":{"138":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{">":{"(":{"_":{"df":1,"docs":{"138":{"tf":1.0}}},"df":0,"docs":{},"x":{"df":1,"docs":{"190":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"<":{"df":1,"docs":{"140":{"tf":1.0}},"f":{"3":{"2":{"df":1,"docs":{"140":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{">":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"140":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"140":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"140":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"140":{"tf":1.4142135623730951}}}},"df":1,"docs":{"140":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"210":{"tf":2.0}}}}}}},"df":0,"docs":{}},"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"(":{"df":1,"docs":{"90":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"_":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"231":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"231":{"tf":1.0},"233":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"233":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":2,"docs":{"233":{"tf":1.4142135623730951},"234":{"tf":1.0}}}}}}},"df":2,"docs":{"232":{"tf":1.7320508075688772},"234":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":8,"docs":{"127":{"tf":1.0},"133":{"tf":1.4142135623730951},"164":{"tf":1.7320508075688772},"196":{"tf":1.0},"210":{"tf":1.0},"212":{"tf":1.0},"224":{"tf":1.4142135623730951},"283":{"tf":1.0}}}},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"208":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":2,"docs":{"125":{"tf":1.0},"208":{"tf":1.0}},"h":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"338":{"tf":1.0}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"_":{"a":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"(":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"223":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"d":{"df":1,"docs":{"223":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"223":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"223":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":17,"docs":{"110":{"tf":1.0},"112":{"tf":1.0},"119":{"tf":1.0},"136":{"tf":1.0},"152":{"tf":1.0},"169":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0},"197":{"tf":1.0},"282":{"tf":1.0},"302":{"tf":1.0},"317":{"tf":1.0},"324":{"tf":1.0},"329":{"tf":1.0},"51":{"tf":1.0},"82":{"tf":1.0},"95":{"tf":1.0}},"n":{"df":10,"docs":{"115":{"tf":1.0},"138":{"tf":1.4142135623730951},"152":{"tf":1.0},"227":{"tf":1.0},"262":{"tf":1.0},"296":{"tf":2.449489742783178},"313":{"tf":1.0},"314":{"tf":1.0},"320":{"tf":1.0},"329":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"324":{"tf":1.0},"40":{"tf":1.4142135623730951}}}},"df":1,"docs":{"130":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"u":{"df":3,"docs":{"164":{"tf":1.0},"266":{"tf":1.0},"323":{"tf":1.0}}}},"o":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"0":{"tf":1.0},"116":{"tf":1.0}}}},"df":12,"docs":{"0":{"tf":1.0},"124":{"tf":1.0},"138":{"tf":1.0},"220":{"tf":1.0},"244":{"tf":1.0},"248":{"tf":1.0},"282":{"tf":1.0},"3":{"tf":1.4142135623730951},"300":{"tf":1.0},"88":{"tf":1.7320508075688772},"95":{"tf":1.4142135623730951},"97":{"tf":1.0}},"e":{"df":9,"docs":{"164":{"tf":1.0},"165":{"tf":1.4142135623730951},"171":{"tf":1.0},"191":{"tf":1.0},"202":{"tf":1.0},"220":{"tf":1.0},"259":{"tf":1.0},"283":{"tf":1.0},"46":{"tf":1.4142135623730951}}},"o":{"d":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"e":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"99":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":2,"docs":{"210":{"tf":1.0},"245":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"80":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"316":{"tf":1.0},"5":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"l":{"'":{"d":{"df":2,"docs":{"164":{"tf":1.0},"266":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"a":{"b":{"df":2,"docs":{"156":{"tf":1.4142135623730951},"158":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"125":{"tf":1.4142135623730951},"136":{"tf":1.0},"269":{"tf":1.0},"276":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"16":{"tf":2.0},"17":{"tf":1.0},"36":{"tf":1.0},"78":{"tf":1.7320508075688772}}},"t":{"df":1,"docs":{"99":{"tf":2.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"196":{"tf":1.0}}}},"w":{"a":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"257":{"tf":1.4142135623730951},"261":{"tf":1.4142135623730951},"267":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"260":{"tf":1.7320508075688772}}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":9,"docs":{"152":{"tf":1.0},"171":{"tf":1.0},"199":{"tf":1.0},"220":{"tf":1.0},"261":{"tf":1.0},"269":{"tf":1.0},"312":{"tf":1.0},"316":{"tf":1.0},"317":{"tf":1.0}}}}}},"d":{"df":1,"docs":{"84":{"tf":2.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"11":{"tf":1.0},"268":{"tf":1.0},"301":{"tf":1.0},"334":{"tf":1.0}},"e":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"299":{"tf":1.0},"306":{"tf":1.0},"307":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"ö":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"172":{"tf":1.0}}}}},"df":0,"docs":{}}},"h":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"196":{"tf":1.0}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"63":{"tf":1.0}}}},"n":{"d":{"df":3,"docs":{"113":{"tf":1.0},"125":{"tf":1.0},"174":{"tf":1.0}},"i":{"df":2,"docs":{"113":{"tf":1.0},"244":{"tf":1.0}}},"l":{"df":25,"docs":{"0":{"tf":2.0},"13":{"tf":1.4142135623730951},"16":{"tf":1.0},"220":{"tf":2.23606797749979},"221":{"tf":1.0},"222":{"tf":1.0},"223":{"tf":2.8284271247461903},"225":{"tf":1.4142135623730951},"235":{"tf":1.4142135623730951},"240":{"tf":1.7320508075688772},"241":{"tf":1.0},"243":{"tf":1.0},"244":{"tf":1.0},"245":{"tf":1.0},"250":{"tf":1.0},"252":{"tf":1.0},"257":{"tf":1.0},"263":{"tf":1.0},"276":{"tf":1.4142135623730951},"282":{"tf":1.0},"289":{"tf":1.0},"5":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"92":{"tf":1.0}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"314":{"tf":1.0}}}}}}}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"267":{"tf":1.0}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":8,"docs":{"135":{"tf":1.0},"235":{"tf":1.0},"276":{"tf":1.4142135623730951},"313":{"tf":1.0},"323":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0},"99":{"tf":1.0}}}},"i":{"df":1,"docs":{"50":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"r":{"d":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"119":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"314":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{">":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"144":{"tf":1.0}}}},"df":0,"docs":{}},"`":{"'":{"df":1,"docs":{"144":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"144":{"tf":2.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"h":{"df":4,"docs":{"197":{"tf":1.4142135623730951},"267":{"tf":2.23606797749979},"268":{"tf":3.3166247903554},"269":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"p":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"267":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"267":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"267":{"tf":1.4142135623730951},"268":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"c":{"a":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"267":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"<":{"a":{"c":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"<":{"'":{"a":{"df":1,"docs":{"268":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":1,"docs":{"269":{"tf":1.0}}}},"df":3,"docs":{"267":{"tf":2.6457513110645907},"268":{"tf":2.0},"269":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"269":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"269":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"269":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":1,"docs":{"269":{"tf":1.0}}}},"df":1,"docs":{"269":{"tf":2.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"329":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"227":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{")":{".":{"a":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"227":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{")":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"227":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"227":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"156":{"tf":1.0},"203":{"tf":1.0},"246":{"tf":1.0}},"n":{"'":{"df":0,"docs":{},"t":{"df":3,"docs":{"220":{"tf":1.0},"49":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"k":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"97":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"df":1,"docs":{"97":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":4,"docs":{"164":{"tf":1.0},"266":{"tf":1.0},"321":{"tf":1.0},"78":{"tf":1.4142135623730951}},"e":{"a":{"d":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"276":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":13,"docs":{"164":{"tf":2.6457513110645907},"167":{"tf":2.23606797749979},"169":{"tf":1.0},"171":{"tf":1.0},"199":{"tf":2.0},"206":{"tf":1.0},"257":{"tf":1.0},"259":{"tf":2.449489742783178},"261":{"tf":1.4142135623730951},"266":{"tf":2.0},"272":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"95":{"tf":1.0}}},"v":{"df":0,"docs":{},"i":{"df":1,"docs":{"225":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"42":{"tf":1.0}}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":1,"docs":{"218":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":3,"docs":{"130":{"tf":1.0},"144":{"tf":2.0},"29":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"329":{"tf":1.0}}}}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"283":{"tf":2.23606797749979}}}}}},"df":13,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":2.23606797749979},"190":{"tf":1.0},"2":{"tf":1.0},"24":{"tf":1.0},"257":{"tf":1.0},"267":{"tf":1.0},"283":{"tf":1.4142135623730951},"291":{"tf":1.7320508075688772},"329":{"tf":1.4142135623730951},"55":{"tf":1.0},"70":{"tf":1.0},"99":{"tf":1.0}}}},"p":{"df":8,"docs":{"206":{"tf":1.0},"207":{"tf":1.0},"237":{"tf":1.4142135623730951},"238":{"tf":1.0},"246":{"tf":1.0},"278":{"tf":1.0},"296":{"tf":2.23606797749979},"302":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"300":{"tf":1.0}}}}}},"n":{"c":{"df":5,"docs":{"129":{"tf":1.4142135623730951},"200":{"tf":1.0},"261":{"tf":1.0},"55":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"245":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"'":{"df":8,"docs":{"164":{"tf":1.0},"238":{"tf":1.0},"283":{"tf":1.0},"284":{"tf":1.0},"291":{"tf":1.0},"306":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0}}},"df":44,"docs":{"1":{"tf":1.0},"120":{"tf":1.0},"123":{"tf":1.0},"125":{"tf":1.0},"129":{"tf":1.0},"130":{"tf":1.4142135623730951},"136":{"tf":2.0},"142":{"tf":1.0},"158":{"tf":1.4142135623730951},"159":{"tf":1.0},"164":{"tf":2.0},"174":{"tf":1.0},"179":{"tf":1.0},"183":{"tf":1.0},"187":{"tf":1.4142135623730951},"189":{"tf":1.4142135623730951},"190":{"tf":1.0},"192":{"tf":1.0},"200":{"tf":1.4142135623730951},"202":{"tf":1.0},"203":{"tf":1.4142135623730951},"217":{"tf":1.0},"221":{"tf":1.0},"222":{"tf":1.0},"225":{"tf":1.0},"238":{"tf":1.0},"245":{"tf":1.0},"248":{"tf":1.0},"250":{"tf":1.0},"262":{"tf":1.7320508075688772},"272":{"tf":1.0},"279":{"tf":1.0},"287":{"tf":1.0},"314":{"tf":1.0},"317":{"tf":1.0},"324":{"tf":1.0},"329":{"tf":1.0},"336":{"tf":1.7320508075688772},"38":{"tf":1.0},"5":{"tf":1.0},"63":{"tf":1.0},"94":{"tf":1.4142135623730951},"95":{"tf":1.0},"96":{"tf":1.0}}}},"x":{"a":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"23":{"tf":1.0},"262":{"tf":1.0},"5":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"159":{"tf":1.7320508075688772},"306":{"tf":1.7320508075688772},"333":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":5,"docs":{"116":{"tf":1.0},"28":{"tf":1.0},"306":{"tf":1.4142135623730951},"34":{"tf":1.0},"36":{"tf":1.0}}}},"df":2,"docs":{"267":{"tf":1.0},"318":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"114":{"tf":1.0}},"i":{"df":3,"docs":{"120":{"tf":1.4142135623730951},"125":{"tf":1.0},"126":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"321":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"0":{"tf":1.0},"112":{"tf":1.4142135623730951},"318":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"318":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.0},"276":{"tf":1.0},"6":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"f":{"df":1,"docs":{"112":{"tf":1.7320508075688772}},"s":{"df":0,"docs":{},"t":{"a":{"d":{"df":0,"docs":{},"t":{"df":1,"docs":{"172":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"d":{"df":10,"docs":{"10":{"tf":1.0},"159":{"tf":1.0},"164":{"tf":1.0},"192":{"tf":1.0},"24":{"tf":1.0},"245":{"tf":1.0},"275":{"tf":1.0},"276":{"tf":1.0},"329":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{}},"o":{"d":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"264":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"268":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"287":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"183":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"v":{"(":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"337":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"3":{"tf":1.0}}}},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"d":{"df":0,"docs":{},"o":{"c":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"125":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"337":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"329":{"tf":1.0}}}},"df":0,"docs":{}},"n":{"d":{"df":0,"docs":{},"r":{"df":1,"docs":{"88":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"%":{"2":{"df":1,"docs":{"113":{"tf":1.0}}},"df":0,"docs":{}},"'":{"df":0,"docs":{},"m":{"df":3,"docs":{"191":{"tf":1.0},"2":{"tf":1.0},"262":{"tf":1.0}}}},".":{"df":5,"docs":{"127":{"tf":1.0},"205":{"tf":1.0},"269":{"tf":1.0},"53":{"tf":1.0},"95":{"tf":1.0}}},"/":{"df":0,"docs":{},"o":{"df":2,"docs":{"273":{"tf":1.0},"282":{"tf":1.7320508075688772}}}},"1":{"2":{"8":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"6":{"df":2,"docs":{"20":{"tf":1.0},"48":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"3":{"2":{"df":52,"docs":{"10":{"tf":1.0},"108":{"tf":2.23606797749979},"110":{"tf":3.7416573867739413},"136":{"tf":1.0},"138":{"tf":1.7320508075688772},"156":{"tf":3.1622776601683795},"158":{"tf":3.872983346207417},"171":{"tf":2.23606797749979},"174":{"tf":1.7320508075688772},"175":{"tf":1.4142135623730951},"177":{"tf":2.0},"179":{"tf":2.6457513110645907},"183":{"tf":2.6457513110645907},"185":{"tf":1.0},"189":{"tf":2.8284271247461903},"191":{"tf":1.7320508075688772},"194":{"tf":2.449489742783178},"20":{"tf":1.0},"206":{"tf":2.0},"21":{"tf":1.7320508075688772},"23":{"tf":1.0},"235":{"tf":1.0},"237":{"tf":1.0},"24":{"tf":1.4142135623730951},"243":{"tf":1.0},"257":{"tf":1.0},"26":{"tf":1.7320508075688772},"263":{"tf":2.0},"266":{"tf":1.7320508075688772},"279":{"tf":1.0},"296":{"tf":1.7320508075688772},"300":{"tf":2.449489742783178},"304":{"tf":1.7320508075688772},"305":{"tf":2.449489742783178},"306":{"tf":1.4142135623730951},"308":{"tf":1.7320508075688772},"309":{"tf":1.7320508075688772},"32":{"tf":1.7320508075688772},"320":{"tf":2.0},"36":{"tf":2.0},"40":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.4142135623730951},"8":{"tf":1.0},"80":{"tf":1.7320508075688772},"96":{"tf":2.23606797749979},"99":{"tf":2.23606797749979}}},"df":0,"docs":{}},"6":{"4":{"df":5,"docs":{"10":{"tf":1.0},"152":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"31":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"8":{"df":2,"docs":{"20":{"tf":1.0},"48":{"tf":2.0}}},"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}},"d":{"df":3,"docs":{"279":{"tf":2.23606797749979},"284":{"tf":1.4142135623730951},"319":{"tf":1.7320508075688772}},"e":{"a":{"df":1,"docs":{"213":{"tf":1.0}},"l":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"133":{"tf":1.0},"194":{"tf":1.4142135623730951},"214":{"tf":2.0},"237":{"tf":1.0},"96":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"325":{"tf":1.0},"326":{"tf":2.6457513110645907}}}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":2,"docs":{"152":{"tf":1.4142135623730951},"300":{"tf":1.0}}}}},"s":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"v":{"df":1,"docs":{"279":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":4,"docs":{"0":{"tf":1.0},"133":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0}}}}}},"df":0,"docs":{}},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":17,"docs":{"1":{"tf":1.0},"127":{"tf":1.4142135623730951},"179":{"tf":1.0},"217":{"tf":1.0},"253":{"tf":1.0},"291":{"tf":1.0},"3":{"tf":1.0},"300":{"tf":1.0},"302":{"tf":1.4142135623730951},"303":{"tf":2.0},"304":{"tf":3.4641016151377544},"305":{"tf":1.4142135623730951},"308":{"tf":1.7320508075688772},"336":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":2.0},"82":{"tf":1.0}},"e":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"304":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":3,"docs":{"0":{"tf":1.0},"169":{"tf":1.0},"222":{"tf":1.0}}}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":1,"docs":{"297":{"tf":1.4142135623730951}},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":8,"docs":{"130":{"tf":1.0},"138":{"tf":1.0},"150":{"tf":1.0},"248":{"tf":1.4142135623730951},"276":{"tf":1.0},"279":{"tf":1.0},"5":{"tf":1.0},"97":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"168":{"tf":2.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"172":{"tf":2.23606797749979}}}}}},"df":0,"docs":{}},"df":8,"docs":{"172":{"tf":2.6457513110645907},"174":{"tf":2.6457513110645907},"260":{"tf":1.0},"280":{"tf":1.0},"43":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"95":{"tf":1.0},"97":{"tf":2.0}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"49":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"112":{"tf":1.0}}}},"l":{"<":{"'":{"a":{"df":1,"docs":{"185":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":4,"docs":{"116":{"tf":1.0},"140":{"tf":1.4142135623730951},"142":{"tf":1.0},"150":{"tf":1.0}}},"u":{"df":1,"docs":{"161":{"tf":1.0}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"161":{"tf":1.0}}}}}}},"df":44,"docs":{"10":{"tf":1.7320508075688772},"105":{"tf":2.0},"106":{"tf":1.0},"114":{"tf":1.0},"13":{"tf":1.0},"140":{"tf":2.449489742783178},"141":{"tf":1.0},"144":{"tf":1.0},"146":{"tf":1.4142135623730951},"150":{"tf":1.7320508075688772},"152":{"tf":1.4142135623730951},"156":{"tf":1.0},"158":{"tf":1.0},"16":{"tf":1.0},"162":{"tf":1.0},"165":{"tf":1.0},"181":{"tf":1.0},"185":{"tf":1.4142135623730951},"192":{"tf":1.0},"196":{"tf":1.4142135623730951},"197":{"tf":1.0},"199":{"tf":1.4142135623730951},"200":{"tf":1.4142135623730951},"202":{"tf":1.0},"203":{"tf":1.4142135623730951},"204":{"tf":1.4142135623730951},"205":{"tf":1.7320508075688772},"206":{"tf":2.8284271247461903},"208":{"tf":1.4142135623730951},"210":{"tf":1.7320508075688772},"224":{"tf":1.0},"245":{"tf":1.0},"246":{"tf":1.4142135623730951},"248":{"tf":1.4142135623730951},"250":{"tf":1.7320508075688772},"297":{"tf":1.0},"32":{"tf":1.4142135623730951},"329":{"tf":1.0},"38":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"95":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":52,"docs":{"10":{"tf":3.605551275463989},"101":{"tf":2.0},"112":{"tf":1.0},"13":{"tf":1.4142135623730951},"140":{"tf":1.4142135623730951},"142":{"tf":1.0},"144":{"tf":2.8284271247461903},"146":{"tf":1.0},"156":{"tf":1.0},"16":{"tf":1.4142135623730951},"161":{"tf":2.6457513110645907},"165":{"tf":1.4142135623730951},"17":{"tf":1.0},"187":{"tf":1.4142135623730951},"196":{"tf":1.7320508075688772},"197":{"tf":2.0},"199":{"tf":2.0},"200":{"tf":1.7320508075688772},"202":{"tf":1.7320508075688772},"203":{"tf":1.4142135623730951},"205":{"tf":1.0},"206":{"tf":1.0},"207":{"tf":1.0},"208":{"tf":1.4142135623730951},"210":{"tf":1.7320508075688772},"217":{"tf":1.4142135623730951},"220":{"tf":1.0},"237":{"tf":1.4142135623730951},"245":{"tf":1.0},"246":{"tf":1.4142135623730951},"248":{"tf":1.0},"250":{"tf":2.23606797749979},"255":{"tf":1.0},"266":{"tf":1.0},"267":{"tf":1.0},"268":{"tf":3.0},"269":{"tf":1.7320508075688772},"272":{"tf":1.0},"286":{"tf":1.0},"291":{"tf":1.7320508075688772},"297":{"tf":1.0},"311":{"tf":1.0},"38":{"tf":1.0},"5":{"tf":2.449489742783178},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.7320508075688772},"8":{"tf":2.8284271247461903},"88":{"tf":1.4142135623730951},"95":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"196":{"tf":1.0}}},"df":3,"docs":{"196":{"tf":1.7320508075688772},"200":{"tf":1.0},"202":{"tf":1.0}}}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"223":{"tf":1.0},"305":{"tf":1.0},"318":{"tf":1.4142135623730951},"36":{"tf":1.0},"48":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":10,"docs":{"101":{"tf":1.0},"135":{"tf":1.0},"136":{"tf":1.0},"138":{"tf":1.7320508075688772},"177":{"tf":1.0},"194":{"tf":1.0},"223":{"tf":1.4142135623730951},"250":{"tf":1.4142135623730951},"323":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}}}},"df":1,"docs":{"70":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"206":{"tf":1.0}}}}}}},"df":20,"docs":{"0":{"tf":1.0},"10":{"tf":1.4142135623730951},"118":{"tf":1.0},"123":{"tf":1.0},"127":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":1.0},"132":{"tf":1.0},"163":{"tf":1.0},"192":{"tf":1.0},"205":{"tf":1.0},"23":{"tf":1.0},"264":{"tf":1.0},"289":{"tf":1.0},"300":{"tf":1.0},"306":{"tf":1.0},"308":{"tf":1.4142135623730951},"317":{"tf":1.0},"5":{"tf":1.0},"82":{"tf":1.0}}}},"s":{"df":2,"docs":{"161":{"tf":1.0},"97":{"tf":1.0}},"s":{"df":1,"docs":{"86":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":6,"docs":{"124":{"tf":1.0},"158":{"tf":1.0},"194":{"tf":1.0},"23":{"tf":1.4142135623730951},"235":{"tf":1.0},"316":{"tf":1.0}}}}}}},"n":{"(":{"\"":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"318":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"319":{"tf":1.0},"320":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":7,"docs":{"316":{"tf":1.0},"317":{"tf":1.7320508075688772},"318":{"tf":1.0},"319":{"tf":1.0},"320":{"tf":1.0},"322":{"tf":1.0},"324":{"tf":1.0}}}}}},"a":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"120":{"tf":1.4142135623730951}},"i":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"120":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":1,"docs":{"97":{"tf":2.0}},"h":{"df":3,"docs":{"161":{"tf":1.4142135623730951},"197":{"tf":1.4142135623730951},"51":{"tf":2.8284271247461903}},"e":{"df":0,"docs":{},"s":{"(":{"1":{"2":{"df":1,"docs":{"197":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"197":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"197":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"i":{"d":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"u":{"d":{"df":20,"docs":{"115":{"tf":1.0},"124":{"tf":1.0},"125":{"tf":1.4142135623730951},"136":{"tf":1.0},"146":{"tf":1.0},"175":{"tf":1.0},"19":{"tf":1.0},"207":{"tf":1.0},"257":{"tf":1.0},"268":{"tf":1.0},"298":{"tf":1.0},"305":{"tf":1.0},"311":{"tf":1.0},"323":{"tf":1.0},"327":{"tf":1.4142135623730951},"328":{"tf":1.0},"333":{"tf":1.0},"40":{"tf":1.0},"5":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"69":{"tf":1.4142135623730951},"72":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"32":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"288":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":4,"docs":{"270":{"tf":1.0},"272":{"tf":1.0},"296":{"tf":2.23606797749979},"63":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"296":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"|":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"296":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"270":{"tf":1.0},"67":{"tf":1.0},"92":{"tf":1.0},"97":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"48":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"103":{"tf":1.0}},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"262":{"tf":1.0},"88":{"tf":1.0},"92":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"167":{"tf":1.0},"207":{"tf":1.0},"31":{"tf":1.0},"321":{"tf":1.0}}},"df":0,"docs":{}}}},"x":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"110":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"110":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":9,"docs":{"110":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"201":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.7320508075688772},"260":{"tf":1.7320508075688772},"267":{"tf":1.0},"276":{"tf":1.4142135623730951}}}},"i":{"c":{"df":14,"docs":{"10":{"tf":1.0},"163":{"tf":1.0},"177":{"tf":1.0},"191":{"tf":1.0},"212":{"tf":1.0},"216":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"235":{"tf":1.0},"260":{"tf":1.0},"263":{"tf":1.0},"264":{"tf":1.7320508075688772},"319":{"tf":1.0},"322":{"tf":1.0},"64":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"a":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"115":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":1.4142135623730951},"123":{"tf":1.0},"132":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"119":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"150":{"tf":1.0},"259":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":3,"docs":{"121":{"tf":1.0},"276":{"tf":1.0},"287":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"c":{"df":2,"docs":{"223":{"tf":1.0},"240":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"300":{"tf":1.0}}}}},"f":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":14,"docs":{"138":{"tf":1.0},"189":{"tf":1.4142135623730951},"194":{"tf":1.0},"21":{"tf":1.7320508075688772},"22":{"tf":1.0},"276":{"tf":1.0},"278":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"50":{"tf":2.0},"60":{"tf":1.0},"96":{"tf":2.0}},"r":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"112":{"tf":1.0},"64":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}}}},"o":{"df":4,"docs":{"164":{"tf":1.0},"245":{"tf":1.0},"250":{"tf":1.0},"266":{"tf":1.0}},"r":{"df":0,"docs":{},"m":{"df":10,"docs":{"113":{"tf":1.0},"116":{"tf":2.0},"138":{"tf":1.0},"245":{"tf":1.4142135623730951},"250":{"tf":1.0},"267":{"tf":1.0},"279":{"tf":1.0},"280":{"tf":1.0},"31":{"tf":1.0},"324":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"327":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"227":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"54":{"tf":1.0},"97":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"208":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}},"i":{"df":9,"docs":{"164":{"tf":1.0},"26":{"tf":1.0},"260":{"tf":1.0},"267":{"tf":1.0},"276":{"tf":1.0},"317":{"tf":1.0},"45":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"318":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":2,"docs":{"317":{"tf":1.7320508075688772},"324":{"tf":1.0}}}}}},"df":1,"docs":{"317":{"tf":2.0}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":9,"docs":{"286":{"tf":1.0},"314":{"tf":1.7320508075688772},"316":{"tf":2.0},"317":{"tf":1.0},"318":{"tf":1.0},"319":{"tf":1.4142135623730951},"323":{"tf":2.0},"324":{"tf":1.7320508075688772},"331":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":9,"docs":{"158":{"tf":1.0},"171":{"tf":1.4142135623730951},"223":{"tf":1.4142135623730951},"224":{"tf":1.0},"248":{"tf":1.0},"259":{"tf":1.0},"270":{"tf":1.0},"44":{"tf":1.4142135623730951},"65":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"319":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"_":{"a":{"b":{"c":{"d":{"df":1,"docs":{"321":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"316":{"tf":1.4142135623730951},"317":{"tf":1.7320508075688772},"319":{"tf":1.0}}}}}},"df":1,"docs":{"316":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":27,"docs":{"101":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":1.0},"129":{"tf":1.0},"142":{"tf":1.0},"156":{"tf":1.0},"158":{"tf":1.0},"177":{"tf":1.0},"179":{"tf":1.7320508075688772},"191":{"tf":1.0},"192":{"tf":1.4142135623730951},"200":{"tf":1.0},"206":{"tf":1.0},"220":{"tf":1.0},"225":{"tf":1.0},"227":{"tf":1.0},"243":{"tf":1.0},"244":{"tf":1.0},"277":{"tf":1.0},"289":{"tf":1.0},"316":{"tf":2.8284271247461903},"317":{"tf":1.7320508075688772},"318":{"tf":1.4142135623730951},"319":{"tf":1.7320508075688772},"324":{"tf":1.0},"96":{"tf":1.7320508075688772},"99":{"tf":1.7320508075688772}},"s":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"322":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":14,"docs":{"120":{"tf":1.4142135623730951},"121":{"tf":1.0},"23":{"tf":1.0},"260":{"tf":1.0},"261":{"tf":1.4142135623730951},"267":{"tf":1.0},"269":{"tf":1.0},"276":{"tf":1.0},"277":{"tf":1.0},"315":{"tf":1.7320508075688772},"316":{"tf":1.7320508075688772},"320":{"tf":1.4142135623730951},"321":{"tf":1.0},"50":{"tf":1.0}}}}},"i":{"d":{"df":25,"docs":{"101":{"tf":1.0},"115":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.0},"125":{"tf":1.0},"156":{"tf":1.0},"158":{"tf":1.0},"171":{"tf":1.0},"177":{"tf":1.0},"189":{"tf":1.0},"223":{"tf":1.7320508075688772},"270":{"tf":1.4142135623730951},"297":{"tf":1.0},"305":{"tf":1.0},"308":{"tf":1.0},"31":{"tf":1.0},"315":{"tf":1.0},"319":{"tf":1.4142135623730951},"323":{"tf":1.0},"329":{"tf":1.0},"34":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"31":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}},"n":{"c":{"df":13,"docs":{"113":{"tf":1.0},"144":{"tf":1.0},"16":{"tf":1.0},"175":{"tf":1.0},"197":{"tf":1.0},"199":{"tf":1.0},"202":{"tf":1.0},"243":{"tf":1.0},"272":{"tf":1.0},"289":{"tf":1.0},"88":{"tf":1.0},"95":{"tf":1.4142135623730951},"99":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":4,"docs":{"113":{"tf":1.0},"207":{"tf":1.4142135623730951},"28":{"tf":2.0},"323":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":28,"docs":{"171":{"tf":1.0},"197":{"tf":1.0},"199":{"tf":1.0},"212":{"tf":1.0},"223":{"tf":1.0},"225":{"tf":1.0},"227":{"tf":1.4142135623730951},"233":{"tf":1.0},"235":{"tf":1.0},"241":{"tf":1.0},"248":{"tf":1.0},"26":{"tf":1.4142135623730951},"263":{"tf":1.0},"264":{"tf":1.0},"276":{"tf":1.0},"280":{"tf":1.0},"287":{"tf":1.0},"313":{"tf":1.0},"316":{"tf":1.0},"317":{"tf":1.0},"318":{"tf":1.0},"319":{"tf":1.7320508075688772},"331":{"tf":1.0},"38":{"tf":1.4142135623730951},"69":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"96":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":8,"docs":{"315":{"tf":1.7320508075688772},"316":{"tf":2.0},"317":{"tf":1.0},"318":{"tf":2.449489742783178},"319":{"tf":2.0},"322":{"tf":1.0},"323":{"tf":1.0},"324":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"a":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"229":{"tf":1.0},"230":{"tf":1.0},"231":{"tf":1.0}}}},"df":0,"docs":{}},"df":5,"docs":{"171":{"tf":1.0},"250":{"tf":1.0},"268":{"tf":1.0},"48":{"tf":1.0},"56":{"tf":1.0}},"e":{"df":0,"docs":{},"g":{"df":23,"docs":{"0":{"tf":1.7320508075688772},"164":{"tf":1.7320508075688772},"167":{"tf":1.4142135623730951},"191":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"218":{"tf":1.0},"219":{"tf":1.0},"23":{"tf":2.449489742783178},"24":{"tf":1.0},"263":{"tf":1.0},"266":{"tf":1.4142135623730951},"267":{"tf":1.4142135623730951},"276":{"tf":1.0},"28":{"tf":1.0},"296":{"tf":2.8284271247461903},"36":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":2.0},"49":{"tf":1.0},"5":{"tf":1.0},"90":{"tf":1.4142135623730951},"95":{"tf":1.0}},"r":{"df":7,"docs":{"124":{"tf":1.0},"127":{"tf":2.449489742783178},"298":{"tf":1.0},"308":{"tf":2.0},"327":{"tf":1.0},"48":{"tf":1.4142135623730951},"62":{"tf":1.0}}}},"l":{"df":2,"docs":{"322":{"tf":1.0},"323":{"tf":1.0}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"127":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"131":{"tf":1.0},"243":{"tf":2.23606797749979},"289":{"tf":1.0},"70":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"86":{"tf":1.0}}}}},"f":{"a":{"c":{"df":6,"docs":{"212":{"tf":1.4142135623730951},"218":{"tf":1.0},"219":{"tf":1.4142135623730951},"297":{"tf":1.4142135623730951},"308":{"tf":1.0},"335":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"276":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":3,"docs":{"265":{"tf":1.0},"276":{"tf":2.0},"287":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":3,"docs":{"154":{"tf":1.0},"280":{"tf":1.0},"287":{"tf":1.0}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"129":{"tf":1.0},"130":{"tf":1.0},"323":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"269":{"tf":1.0}}}},"df":0,"docs":{}}}}},"o":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"<":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}}}}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":9,"docs":{"108":{"tf":1.7320508075688772},"110":{"tf":2.23606797749979},"203":{"tf":1.0},"252":{"tf":1.0},"253":{"tf":1.0},"254":{"tf":1.0},"255":{"tf":1.0},"256":{"tf":1.4142135623730951},"70":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"110":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"280":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"206":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"r":{"a":{"df":1,"docs":{"334":{"tf":1.0}}},"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":4,"docs":{"177":{"tf":1.0},"240":{"tf":1.0},"241":{"tf":1.0},"326":{"tf":1.4142135623730951}},"t":{"df":1,"docs":{"311":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"218":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"<":{"'":{"a":{"df":1,"docs":{"179":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":8,"docs":{"105":{"tf":1.0},"179":{"tf":1.7320508075688772},"192":{"tf":1.0},"227":{"tf":1.0},"245":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.0},"296":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"313":{"tf":1.0},"315":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"315":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":7,"docs":{"129":{"tf":1.0},"165":{"tf":1.0},"215":{"tf":1.0},"230":{"tf":1.0},"233":{"tf":1.4142135623730951},"328":{"tf":1.0},"5":{"tf":1.0}}},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"136":{"tf":1.0}}}}}}},"o":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"282":{"tf":1.0},"51":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"283":{"tf":1.0},"284":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{":":{":":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"287":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"291":{"tf":1.4142135623730951}}}}},"t":{"df":2,"docs":{"282":{"tf":1.0},"51":{"tf":1.0}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"283":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"c":{"<":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"291":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":4,"docs":{"238":{"tf":1.0},"239":{"tf":1.0},"284":{"tf":1.0},"291":{"tf":2.6457513110645907}}}}}}}},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"5":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"146":{"tf":1.0},"176":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}}}},"s":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"h":{"df":1,"docs":{"94":{"tf":1.0}}}},"n":{"df":1,"docs":{"94":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"d":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"196":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"d":{"d":{"(":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"112":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"20":{"tf":1.0}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"225":{"tf":1.4142135623730951},"34":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"308":{"tf":1.0}}}},"s":{"df":0,"docs":{},"u":{"df":5,"docs":{"0":{"tf":1.0},"127":{"tf":1.0},"287":{"tf":1.0},"325":{"tf":1.0},"6":{"tf":1.0}}}}},"t":{"'":{"df":21,"docs":{"112":{"tf":1.0},"123":{"tf":1.0},"130":{"tf":1.0},"133":{"tf":1.4142135623730951},"167":{"tf":1.0},"174":{"tf":1.4142135623730951},"192":{"tf":1.7320508075688772},"205":{"tf":1.0},"210":{"tf":1.0},"220":{"tf":1.4142135623730951},"223":{"tf":1.0},"224":{"tf":1.0},"23":{"tf":1.0},"262":{"tf":1.4142135623730951},"263":{"tf":1.0},"297":{"tf":1.0},"319":{"tf":1.0},"333":{"tf":1.0},"45":{"tf":1.0},"50":{"tf":1.0},"65":{"tf":1.0}}},".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":2.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":23,"docs":{"0":{"tf":1.0},"108":{"tf":1.0},"110":{"tf":2.23606797749979},"114":{"tf":1.0},"115":{"tf":3.4641016151377544},"119":{"tf":1.0},"123":{"tf":1.0},"130":{"tf":2.0},"154":{"tf":2.23606797749979},"156":{"tf":1.0},"158":{"tf":1.0},"203":{"tf":1.0},"214":{"tf":1.0},"245":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.0},"253":{"tf":1.0},"254":{"tf":1.0},"3":{"tf":1.4142135623730951},"334":{"tf":1.0},"55":{"tf":1.0},"73":{"tf":1.0},"90":{"tf":2.449489742783178}}},"r":{":":{":":{"c":{"df":0,"docs":{},"y":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"206":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"252":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"(":{"$":{"df":0,"docs":{},"x":{")":{".":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"217":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"y":{")":{".":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"217":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"z":{")":{".":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"217":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"260":{"tf":1.0},"70":{"tf":1.4142135623730951}}}}}},"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"108":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"110":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"110":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"=":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"206":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"206":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":22,"docs":{"108":{"tf":2.449489742783178},"110":{"tf":3.3166247903554},"112":{"tf":1.7320508075688772},"13":{"tf":1.4142135623730951},"203":{"tf":3.872983346207417},"206":{"tf":2.0},"252":{"tf":1.0},"254":{"tf":1.0},"255":{"tf":1.0},"260":{"tf":2.23606797749979},"261":{"tf":1.0},"267":{"tf":1.0},"269":{"tf":1.0},"276":{"tf":2.0},"278":{"tf":1.0},"286":{"tf":1.4142135623730951},"287":{"tf":1.7320508075688772},"294":{"tf":1.0},"64":{"tf":1.4142135623730951},"69":{"tf":2.23606797749979},"70":{"tf":3.1622776601683795},"71":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":7,"docs":{"142":{"tf":1.0},"223":{"tf":1.0},"24":{"tf":1.0},"276":{"tf":1.0},"298":{"tf":1.0},"319":{"tf":1.0},"55":{"tf":1.0}}}}}}}},"j":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"@":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"268":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":1,"docs":{"268":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}}}}},"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"5":{"tf":1.0}}}},"y":{"df":1,"docs":{"146":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"262":{"tf":1.0}}},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"323":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"323":{"tf":1.0}}}},"o":{"b":{"df":1,"docs":{"224":{"tf":2.0}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"329":{"tf":1.0}}}}}}}},"df":2,"docs":{"268":{"tf":1.0},"329":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"280":{"tf":1.0},"316":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"164":{"tf":1.0},"266":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"329":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"p":{"df":2,"docs":{"261":{"tf":1.0},"289":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}}}}}}}},"k":{"df":1,"docs":{"78":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":7,"docs":{"229":{"tf":1.0},"230":{"tf":1.0},"231":{"tf":1.0},"244":{"tf":1.0},"270":{"tf":1.0},"276":{"tf":1.4142135623730951},"290":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"314":{"tf":1.0}}}}}},"y":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":6,"docs":{"267":{"tf":1.7320508075688772},"268":{"tf":2.23606797749979},"269":{"tf":1.4142135623730951},"336":{"tf":1.0},"70":{"tf":1.0},"78":{"tf":1.0}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"(":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":20,"docs":{"105":{"tf":1.0},"118":{"tf":1.0},"119":{"tf":1.7320508075688772},"158":{"tf":1.0},"175":{"tf":1.0},"187":{"tf":1.0},"199":{"tf":1.0},"218":{"tf":1.0},"222":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"287":{"tf":1.0},"31":{"tf":1.0},"326":{"tf":2.6457513110645907},"48":{"tf":1.4142135623730951},"64":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":1.0},"80":{"tf":1.0},"94":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"237":{"tf":1.0},"243":{"tf":1.0},"316":{"tf":1.0},"61":{"tf":1.0}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"i":{"df":4,"docs":{"230":{"tf":1.0},"231":{"tf":1.7320508075688772},"232":{"tf":1.0},"233":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":10,"docs":{"125":{"tf":1.0},"127":{"tf":1.0},"199":{"tf":1.4142135623730951},"237":{"tf":1.0},"262":{"tf":1.0},"269":{"tf":1.0},"289":{"tf":1.0},"313":{"tf":1.0},"317":{"tf":1.0},"50":{"tf":2.0}},"n":{"df":9,"docs":{"0":{"tf":1.0},"167":{"tf":1.0},"194":{"tf":1.0},"199":{"tf":1.0},"227":{"tf":1.0},"246":{"tf":1.0},"26":{"tf":1.4142135623730951},"260":{"tf":1.0},"49":{"tf":1.0}}}}}}},"l":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":3,"docs":{"176":{"tf":1.0},"323":{"tf":3.3166247903554},"65":{"tf":1.7320508075688772}}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"284":{"tf":1.4142135623730951}},"i":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}}}}}},"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"220":{"tf":1.0},"263":{"tf":1.0},"34":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":1,"docs":{"337":{"tf":1.0}}}}}},"df":1,"docs":{"125":{"tf":1.0}},"u":{"a":{"df":0,"docs":{},"g":{"df":18,"docs":{"0":{"tf":1.0},"199":{"tf":1.0},"208":{"tf":1.0},"209":{"tf":1.0},"211":{"tf":1.0},"212":{"tf":1.4142135623730951},"218":{"tf":1.7320508075688772},"227":{"tf":1.0},"23":{"tf":1.0},"276":{"tf":1.0},"298":{"tf":1.4142135623730951},"321":{"tf":1.0},"325":{"tf":1.0},"326":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.0},"80":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"260":{"tf":1.0},"287":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"156":{"tf":1.4142135623730951},"158":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":15,"docs":{"152":{"tf":1.0},"156":{"tf":1.4142135623730951},"158":{"tf":1.4142135623730951},"174":{"tf":1.0},"175":{"tf":1.7320508075688772},"216":{"tf":1.0},"223":{"tf":1.0},"26":{"tf":1.0},"260":{"tf":1.4142135623730951},"272":{"tf":1.0},"276":{"tf":1.0},"61":{"tf":1.4142135623730951},"74":{"tf":1.0},"76":{"tf":1.7320508075688772},"97":{"tf":1.0}}}},"t":{"_":{"c":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"16":{"tf":2.0}},"e":{"df":1,"docs":{"317":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"318":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"317":{"tf":1.0}}}}},"r":{"df":6,"docs":{"125":{"tf":1.0},"171":{"tf":1.0},"212":{"tf":1.7320508075688772},"45":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"133":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"259":{"tf":1.0}}}}},"z":{"df":0,"docs":{},"i":{"df":5,"docs":{"112":{"tf":1.0},"229":{"tf":1.0},"261":{"tf":1.0},"289":{"tf":1.0},"5":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"231":{"tf":1.4142135623730951},"233":{"tf":1.0}}}}},"y":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"218":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":2,"docs":{"321":{"tf":1.0},"78":{"tf":1.4142135623730951}},"e":{"a":{"d":{"df":6,"docs":{"205":{"tf":1.4142135623730951},"237":{"tf":1.0},"317":{"tf":1.0},"323":{"tf":1.0},"45":{"tf":1.4142135623730951},"97":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":3,"docs":{"164":{"tf":2.0},"191":{"tf":1.0},"266":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"0":{"tf":3.0},"190":{"tf":1.0},"240":{"tf":1.0},"32":{"tf":1.0}}}},"v":{"df":7,"docs":{"105":{"tf":1.0},"115":{"tf":1.0},"179":{"tf":1.0},"223":{"tf":1.0},"235":{"tf":1.0},"70":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"215":{"tf":1.4142135623730951}}}}}}},"_":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":11,"docs":{"16":{"tf":1.0},"175":{"tf":1.0},"215":{"tf":1.7320508075688772},"233":{"tf":1.0},"259":{"tf":1.0},"276":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"300":{"tf":1.7320508075688772},"309":{"tf":1.0},"5":{"tf":1.0}}}},"g":{"a":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"321":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"d":{"df":3,"docs":{"221":{"tf":1.0},"222":{"tf":1.7320508075688772},"223":{"tf":2.0}},"e":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"222":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":4,"docs":{"230":{"tf":1.0},"231":{"tf":1.4142135623730951},"232":{"tf":1.0},"233":{"tf":2.0}}}}},"n":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"176":{"tf":1.0}}}}},"df":3,"docs":{"108":{"tf":1.4142135623730951},"26":{"tf":1.0},"260":{"tf":1.0}},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"(":{"1":{"0":{"0":{"0":{".":{"0":{"df":1,"docs":{"161":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{".":{"0":{"df":1,"docs":{"161":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"0":{"df":1,"docs":{"161":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"161":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"m":{"df":1,"docs":{"161":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{">":{"(":{"df":0,"docs":{},"f":{"6":{"4":{"df":1,"docs":{"161":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"161":{"tf":2.23606797749979}}}}}}},"df":6,"docs":{"144":{"tf":2.0},"161":{"tf":2.0},"26":{"tf":2.0},"260":{"tf":1.7320508075688772},"313":{"tf":1.7320508075688772},"38":{"tf":1.7320508075688772}}}}}},"s":{"df":0,"docs":{},"s":{"df":7,"docs":{"220":{"tf":1.0},"223":{"tf":1.0},"28":{"tf":1.0},"48":{"tf":1.0},"67":{"tf":1.0},"92":{"tf":1.0},"97":{"tf":1.0}}}},"t":{"'":{"df":21,"docs":{"0":{"tf":1.0},"119":{"tf":1.0},"120":{"tf":1.4142135623730951},"122":{"tf":1.0},"125":{"tf":1.0},"158":{"tf":1.0},"223":{"tf":1.0},"225":{"tf":1.0},"235":{"tf":1.4142135623730951},"241":{"tf":1.0},"252":{"tf":1.0},"264":{"tf":1.0},"266":{"tf":1.0},"268":{"tf":1.0},"311":{"tf":1.0},"324":{"tf":1.0},"62":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"88":{"tf":1.7320508075688772},"94":{"tf":1.0}}},"df":3,"docs":{"125":{"tf":1.0},"220":{"tf":1.0},"301":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"88":{"tf":2.23606797749979}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":5,"docs":{"116":{"tf":1.0},"238":{"tf":1.0},"248":{"tf":1.0},"264":{"tf":1.0},"314":{"tf":1.0}}}}}},"h":{"df":1,"docs":{"94":{"tf":1.0}}},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":3,"docs":{"125":{"tf":1.0},"127":{"tf":1.0},"132":{"tf":1.0}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"332":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":5,"docs":{"121":{"tf":1.0},"122":{"tf":1.4142135623730951},"125":{"tf":1.0},"132":{"tf":1.4142135623730951},"329":{"tf":1.0}},"m":{"df":1,"docs":{"297":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":34,"docs":{"0":{"tf":2.0},"10":{"tf":1.7320508075688772},"107":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.7320508075688772},"123":{"tf":2.0},"125":{"tf":1.7320508075688772},"127":{"tf":1.0},"130":{"tf":1.4142135623730951},"132":{"tf":2.0},"146":{"tf":1.0},"22":{"tf":1.0},"223":{"tf":1.0},"238":{"tf":1.0},"248":{"tf":1.0},"250":{"tf":1.0},"257":{"tf":1.4142135623730951},"258":{"tf":1.0},"273":{"tf":1.0},"274":{"tf":1.0},"276":{"tf":1.0},"294":{"tf":1.0},"297":{"tf":1.7320508075688772},"3":{"tf":1.7320508075688772},"308":{"tf":1.0},"326":{"tf":1.0},"327":{"tf":1.0},"329":{"tf":1.4142135623730951},"333":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.0},"8":{"tf":1.4142135623730951}}},"y":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":3,"docs":{"122":{"tf":1.0},"123":{"tf":1.0},"132":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":2,"docs":{"164":{"tf":1.0},"266":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"191":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":17,"docs":{"0":{"tf":1.0},"163":{"tf":1.0},"176":{"tf":3.7416573867739413},"177":{"tf":4.69041575982343},"179":{"tf":3.1622776601683795},"181":{"tf":1.0},"183":{"tf":1.0},"185":{"tf":2.0},"187":{"tf":2.0},"189":{"tf":2.6457513110645907},"190":{"tf":1.4142135623730951},"191":{"tf":2.8284271247461903},"192":{"tf":1.4142135623730951},"194":{"tf":2.0},"276":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"41":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"191":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"s":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"156":{"tf":1.0},"78":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"78":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":6,"docs":{"112":{"tf":1.4142135623730951},"132":{"tf":1.0},"262":{"tf":1.0},"277":{"tf":1.0},"319":{"tf":1.0},"48":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"205":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"205":{"tf":1.4142135623730951}}}}}}}},"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"262":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":50,"docs":{"108":{"tf":1.0},"113":{"tf":1.4142135623730951},"115":{"tf":2.23606797749979},"116":{"tf":1.4142135623730951},"129":{"tf":1.4142135623730951},"130":{"tf":1.0},"142":{"tf":1.0},"146":{"tf":1.0},"167":{"tf":1.4142135623730951},"171":{"tf":1.0},"172":{"tf":1.0},"174":{"tf":1.7320508075688772},"176":{"tf":1.0},"197":{"tf":1.4142135623730951},"2":{"tf":1.0},"202":{"tf":1.0},"205":{"tf":2.8284271247461903},"207":{"tf":1.4142135623730951},"21":{"tf":1.0},"210":{"tf":1.0},"222":{"tf":1.4142135623730951},"230":{"tf":1.4142135623730951},"232":{"tf":1.0},"24":{"tf":1.0},"260":{"tf":1.4142135623730951},"262":{"tf":1.0},"268":{"tf":1.0},"269":{"tf":1.0},"270":{"tf":1.0},"286":{"tf":2.449489742783178},"287":{"tf":2.23606797749979},"289":{"tf":1.0},"294":{"tf":1.4142135623730951},"295":{"tf":1.4142135623730951},"3":{"tf":2.449489742783178},"305":{"tf":2.23606797749979},"306":{"tf":1.7320508075688772},"316":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"50":{"tf":1.0},"6":{"tf":1.0},"70":{"tf":1.0},"95":{"tf":1.4142135623730951},"96":{"tf":1.7320508075688772},"97":{"tf":2.0}},"s":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"287":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"k":{"(":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"297":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":12,"docs":{"122":{"tf":1.0},"123":{"tf":1.0},"127":{"tf":1.0},"130":{"tf":1.0},"291":{"tf":1.0},"297":{"tf":1.4142135623730951},"329":{"tf":1.0},"331":{"tf":1.0},"332":{"tf":1.0},"334":{"tf":1.4142135623730951},"38":{"tf":2.0},"54":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"323":{"tf":1.4142135623730951}}}}},"t":{"df":2,"docs":{"130":{"tf":1.0},"131":{"tf":1.7320508075688772}}},"u":{"df":0,"docs":{},"x":{"df":1,"docs":{"133":{"tf":3.0}}}}},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"!":{"[":{"1":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"(":{"1":{"df":1,"docs":{"38":{"tf":1.0}}},"2":{"df":1,"docs":{"38":{"tf":1.0}}},"3":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}}}}}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":16,"docs":{"125":{"tf":1.4142135623730951},"13":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":1.0},"197":{"tf":1.0},"200":{"tf":1.0},"214":{"tf":1.0},"216":{"tf":1.0},"237":{"tf":1.0},"262":{"tf":1.0},"315":{"tf":1.0},"318":{"tf":1.0},"324":{"tf":1.0},"38":{"tf":4.898979485566356},"5":{"tf":1.0},"72":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":12,"docs":{"133":{"tf":1.0},"172":{"tf":1.0},"191":{"tf":1.4142135623730951},"214":{"tf":1.4142135623730951},"23":{"tf":2.23606797749979},"24":{"tf":1.0},"262":{"tf":3.0},"315":{"tf":1.0},"316":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":2.449489742783178}}}},"t":{"df":0,"docs":{},"l":{"df":2,"docs":{"218":{"tf":1.0},"256":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":6,"docs":{"177":{"tf":1.0},"179":{"tf":1.4142135623730951},"191":{"tf":1.4142135623730951},"192":{"tf":1.4142135623730951},"289":{"tf":1.0},"44":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"df":2,"docs":{"319":{"tf":1.4142135623730951},"323":{"tf":1.0}}}}},"n":{"(":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"265":{"tf":1.0}}}}}},"df":0,"docs":{}},"x":{"df":2,"docs":{"264":{"tf":1.0},"265":{"tf":1.0}}}},"df":2,"docs":{"265":{"tf":1.4142135623730951},"291":{"tf":1.0}}},"o":{"a":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"322":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":2,"docs":{"31":{"tf":1.4142135623730951},"317":{"tf":1.0}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":6,"docs":{"0":{"tf":1.0},"118":{"tf":1.0},"125":{"tf":1.0},"158":{"tf":1.0},"323":{"tf":1.4142135623730951},"61":{"tf":1.0}}},"t":{"df":5,"docs":{"120":{"tf":1.0},"204":{"tf":1.0},"272":{"tf":1.4142135623730951},"317":{"tf":1.0},"322":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"276":{"tf":1.0}}}},"df":1,"docs":{"318":{"tf":2.0}},"g":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":1,"docs":{"265":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"c":{"df":7,"docs":{"114":{"tf":1.0},"165":{"tf":1.0},"21":{"tf":1.0},"227":{"tf":1.0},"23":{"tf":1.0},"245":{"tf":1.0},"49":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"268":{"tf":2.0}}}}},"n":{"_":{"c":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"16":{"tf":2.0}},"g":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"d":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"262":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.0}},"e":{".":{"0":{"df":1,"docs":{"24":{"tf":1.0}}},"1":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":11,"docs":{"176":{"tf":1.0},"177":{"tf":1.7320508075688772},"179":{"tf":1.0},"189":{"tf":1.0},"192":{"tf":1.7320508075688772},"24":{"tf":1.4142135623730951},"260":{"tf":1.0},"32":{"tf":1.4142135623730951},"44":{"tf":1.0},"60":{"tf":1.0},"88":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"262":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}},"df":11,"docs":{"132":{"tf":1.0},"158":{"tf":1.0},"167":{"tf":1.7320508075688772},"171":{"tf":1.0},"174":{"tf":1.4142135623730951},"177":{"tf":2.0},"179":{"tf":1.0},"189":{"tf":1.4142135623730951},"191":{"tf":1.0},"70":{"tf":1.0},"97":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"176":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"k":{"df":23,"docs":{"10":{"tf":1.7320508075688772},"120":{"tf":1.0},"125":{"tf":1.0},"126":{"tf":1.0},"128":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":1.0},"138":{"tf":1.0},"14":{"tf":1.0},"197":{"tf":1.0},"206":{"tf":1.4142135623730951},"212":{"tf":1.0},"218":{"tf":1.0},"219":{"tf":1.0},"225":{"tf":1.0},"237":{"tf":1.0},"242":{"tf":1.4142135623730951},"256":{"tf":1.0},"267":{"tf":1.0},"308":{"tf":1.0},"316":{"tf":1.0},"50":{"tf":1.4142135623730951},"8":{"tf":1.0}}},"p":{"df":11,"docs":{"112":{"tf":1.0},"113":{"tf":1.4142135623730951},"276":{"tf":1.0},"64":{"tf":2.6457513110645907},"65":{"tf":3.1622776601683795},"66":{"tf":2.0},"67":{"tf":1.7320508075688772},"68":{"tf":1.0},"70":{"tf":1.7320508075688772},"92":{"tf":1.4142135623730951},"94":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}}}}},"df":1,"docs":{"284":{"tf":1.4142135623730951}}}}}}}},"df":1,"docs":{"284":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"207":{"tf":1.0}}}},"t":{"df":8,"docs":{"124":{"tf":1.0},"125":{"tf":1.0},"164":{"tf":1.0},"206":{"tf":1.0},"224":{"tf":1.0},"277":{"tf":1.0},"298":{"tf":1.0},"34":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"223":{"tf":1.0},"225":{"tf":1.0}}}},"w":{"df":2,"docs":{"314":{"tf":1.0},"321":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"318":{"tf":1.0},"48":{"tf":1.0},"97":{"tf":1.0}}}}}},"s":{"b":{"df":1,"docs":{"48":{"tf":1.0}}},"df":3,"docs":{"122":{"tf":1.0},"132":{"tf":1.0},"291":{"tf":1.0}}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"323":{"tf":1.4142135623730951}}}},"u":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"125":{"tf":1.0},"237":{"tf":1.0},"265":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":7,"docs":{"212":{"tf":1.7320508075688772},"214":{"tf":1.4142135623730951},"215":{"tf":1.4142135623730951},"216":{"tf":1.0},"217":{"tf":1.7320508075688772},"218":{"tf":1.4142135623730951},"219":{"tf":1.0}}}}}},"df":26,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"12":{"tf":1.0},"130":{"tf":1.4142135623730951},"133":{"tf":1.0},"134":{"tf":1.0},"2":{"tf":1.0},"212":{"tf":3.605551275463989},"213":{"tf":1.0},"214":{"tf":2.23606797749979},"215":{"tf":1.0},"216":{"tf":1.0},"217":{"tf":1.0},"218":{"tf":1.7320508075688772},"219":{"tf":1.0},"242":{"tf":1.4142135623730951},"260":{"tf":1.0},"266":{"tf":1.0},"300":{"tf":1.0},"309":{"tf":1.0},"314":{"tf":1.0},"315":{"tf":1.0},"324":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":3,"docs":{"323":{"tf":1.0},"61":{"tf":1.0},"80":{"tf":1.0}}}},"df":1,"docs":{"219":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"n":{"a":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":5,"docs":{"125":{"tf":1.4142135623730951},"126":{"tf":1.4142135623730951},"127":{"tf":1.0},"130":{"tf":1.0},"90":{"tf":1.0}}}},"df":185,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":1.0},"105":{"tf":1.0},"108":{"tf":1.0},"110":{"tf":1.4142135623730951},"112":{"tf":1.0},"113":{"tf":2.0},"115":{"tf":1.0},"116":{"tf":1.0},"118":{"tf":1.4142135623730951},"119":{"tf":1.0},"120":{"tf":1.0},"123":{"tf":1.0},"126":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":1.0},"131":{"tf":1.0},"133":{"tf":1.0},"135":{"tf":1.0},"136":{"tf":1.0},"138":{"tf":1.0},"140":{"tf":1.0},"142":{"tf":1.0},"144":{"tf":1.0},"146":{"tf":1.0},"148":{"tf":1.0},"150":{"tf":1.0},"152":{"tf":1.4142135623730951},"156":{"tf":1.0},"158":{"tf":1.0},"159":{"tf":1.0},"16":{"tf":1.0},"161":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.4142135623730951},"167":{"tf":1.0},"168":{"tf":1.0},"169":{"tf":1.0},"171":{"tf":1.0},"172":{"tf":1.0},"174":{"tf":1.0},"175":{"tf":1.0},"176":{"tf":1.0},"177":{"tf":1.0},"179":{"tf":1.0},"181":{"tf":1.0},"183":{"tf":1.0},"185":{"tf":1.0},"187":{"tf":1.0},"189":{"tf":1.0},"191":{"tf":1.4142135623730951},"192":{"tf":1.4142135623730951},"194":{"tf":1.0},"196":{"tf":1.0},"197":{"tf":1.0},"199":{"tf":1.0},"200":{"tf":1.0},"202":{"tf":1.7320508075688772},"203":{"tf":1.0},"206":{"tf":1.7320508075688772},"207":{"tf":1.0},"208":{"tf":1.0},"21":{"tf":1.0},"210":{"tf":1.0},"212":{"tf":1.0},"214":{"tf":1.0},"215":{"tf":1.0},"216":{"tf":1.0},"218":{"tf":1.0},"219":{"tf":1.0},"221":{"tf":1.0},"222":{"tf":1.4142135623730951},"223":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.0},"227":{"tf":1.0},"23":{"tf":1.0},"230":{"tf":1.0},"231":{"tf":1.0},"232":{"tf":1.0},"233":{"tf":1.0},"235":{"tf":1.0},"236":{"tf":2.6457513110645907},"237":{"tf":1.4142135623730951},"238":{"tf":1.0},"24":{"tf":1.0},"240":{"tf":1.0},"241":{"tf":1.0},"242":{"tf":1.0},"243":{"tf":1.0},"244":{"tf":1.4142135623730951},"245":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.0},"250":{"tf":1.0},"252":{"tf":1.0},"253":{"tf":1.0},"254":{"tf":1.0},"255":{"tf":1.0},"256":{"tf":1.4142135623730951},"259":{"tf":1.0},"26":{"tf":1.0},"260":{"tf":1.0},"261":{"tf":1.0},"262":{"tf":1.7320508075688772},"263":{"tf":1.0},"264":{"tf":1.0},"265":{"tf":1.0},"266":{"tf":1.7320508075688772},"267":{"tf":1.0},"268":{"tf":1.0},"269":{"tf":1.0},"270":{"tf":1.0},"272":{"tf":1.0},"275":{"tf":1.4142135623730951},"276":{"tf":1.4142135623730951},"279":{"tf":1.0},"28":{"tf":1.0},"280":{"tf":1.0},"283":{"tf":1.0},"284":{"tf":1.0},"287":{"tf":1.0},"288":{"tf":1.0},"289":{"tf":1.0},"290":{"tf":1.7320508075688772},"291":{"tf":1.0},"294":{"tf":1.0},"296":{"tf":1.0},"297":{"tf":1.0},"3":{"tf":1.4142135623730951},"305":{"tf":1.0},"306":{"tf":2.23606797749979},"31":{"tf":1.0},"312":{"tf":1.0},"313":{"tf":1.0},"319":{"tf":1.7320508075688772},"32":{"tf":1.0},"326":{"tf":1.4142135623730951},"329":{"tf":1.0},"336":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":2.0},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.7320508075688772},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.4142135623730951},"70":{"tf":1.7320508075688772},"72":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"88":{"tf":1.7320508075688772},"90":{"tf":1.4142135623730951},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.4142135623730951},"99":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"220":{"tf":1.0},"27":{"tf":1.0}}}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"132":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"_":{"a":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"1":{"df":1,"docs":{"206":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":1,"docs":{"206":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":39,"docs":{"10":{"tf":1.0},"115":{"tf":1.0},"125":{"tf":1.4142135623730951},"127":{"tf":1.0},"191":{"tf":2.449489742783178},"200":{"tf":1.4142135623730951},"206":{"tf":1.0},"207":{"tf":1.0},"224":{"tf":1.0},"227":{"tf":1.4142135623730951},"232":{"tf":1.0},"237":{"tf":1.0},"243":{"tf":1.0},"265":{"tf":1.0},"268":{"tf":1.4142135623730951},"272":{"tf":1.0},"275":{"tf":1.0},"276":{"tf":1.4142135623730951},"28":{"tf":1.0},"282":{"tf":1.0},"286":{"tf":1.0},"301":{"tf":1.0},"302":{"tf":1.0},"306":{"tf":1.0},"308":{"tf":1.0},"316":{"tf":1.0},"319":{"tf":1.0},"327":{"tf":1.0},"334":{"tf":1.0},"336":{"tf":1.0},"5":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":2.0},"86":{"tf":1.0},"88":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":2.0},"96":{"tf":1.0},"97":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":8,"docs":{"0":{"tf":1.0},"114":{"tf":1.0},"124":{"tf":1.4142135623730951},"125":{"tf":1.7320508075688772},"132":{"tf":1.0},"220":{"tf":1.0},"225":{"tf":1.0},"243":{"tf":1.0}}}},"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"96":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":21,"docs":{"10":{"tf":1.0},"136":{"tf":1.0},"200":{"tf":1.0},"210":{"tf":1.4142135623730951},"212":{"tf":1.0},"224":{"tf":1.4142135623730951},"235":{"tf":1.4142135623730951},"237":{"tf":1.0},"238":{"tf":1.0},"257":{"tf":1.0},"262":{"tf":1.0},"265":{"tf":1.0},"273":{"tf":1.0},"276":{"tf":1.4142135623730951},"282":{"tf":1.0},"308":{"tf":1.0},"319":{"tf":1.0},"324":{"tf":1.0},"326":{"tf":1.0},"5":{"tf":1.0},"63":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"223":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"276":{"tf":1.0},"3":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"282":{"tf":1.0},"300":{"tf":1.0},"99":{"tf":1.0}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":10,"docs":{"10":{"tf":1.4142135623730951},"164":{"tf":1.4142135623730951},"197":{"tf":1.0},"202":{"tf":1.7320508075688772},"203":{"tf":1.0},"223":{"tf":1.0},"322":{"tf":1.0},"34":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"99":{"tf":1.0}}}},"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"319":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"286":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"|":{"c":{"df":1,"docs":{"276":{"tf":1.0}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"(":{"df":0,"docs":{},"f":{"df":1,"docs":{"225":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":4,"docs":{"252":{"tf":1.0},"254":{"tf":1.0},"255":{"tf":1.0},"256":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"205":{"tf":1.4142135623730951}}}}}}},"i":{"df":2,"docs":{"245":{"tf":1.0},"246":{"tf":1.0}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"205":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"d":{"(":{"df":0,"docs":{},"f":{"df":1,"docs":{"225":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"x":{"df":1,"docs":{"206":{"tf":1.0}}}}},"/":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"265":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"|":{"_":{"df":1,"docs":{"245":{"tf":1.0}}},"df":2,"docs":{"246":{"tf":1.0},"248":{"tf":1.0}}}},"df":2,"docs":{"248":{"tf":1.0},"254":{"tf":1.4142135623730951}}}}}},"df":9,"docs":{"120":{"tf":1.0},"206":{"tf":1.4142135623730951},"225":{"tf":2.449489742783178},"227":{"tf":1.7320508075688772},"237":{"tf":1.7320508075688772},"248":{"tf":1.0},"267":{"tf":1.0},"276":{"tf":1.7320508075688772},"286":{"tf":1.0}}},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"305":{"tf":1.0},"329":{"tf":1.0}}}}}},"df":6,"docs":{"113":{"tf":1.0},"125":{"tf":1.4142135623730951},"130":{"tf":1.4142135623730951},"300":{"tf":1.0},"304":{"tf":1.0},"320":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"10":{"tf":1.4142135623730951},"144":{"tf":1.0},"159":{"tf":1.0},"5":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"245":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"296":{"tf":3.4641016151377544}},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"296":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"`":{"df":1,"docs":{"227":{"tf":1.0}}},"df":54,"docs":{"113":{"tf":2.0},"127":{"tf":1.0},"175":{"tf":1.0},"215":{"tf":1.0},"216":{"tf":1.0},"223":{"tf":1.7320508075688772},"224":{"tf":1.4142135623730951},"225":{"tf":2.23606797749979},"227":{"tf":2.23606797749979},"236":{"tf":1.0},"237":{"tf":2.449489742783178},"238":{"tf":1.0},"240":{"tf":2.0},"241":{"tf":1.0},"242":{"tf":1.0},"245":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.0},"250":{"tf":1.7320508075688772},"26":{"tf":1.4142135623730951},"262":{"tf":1.0},"263":{"tf":1.4142135623730951},"264":{"tf":2.0},"265":{"tf":2.0},"267":{"tf":1.7320508075688772},"268":{"tf":1.0},"280":{"tf":1.0},"283":{"tf":1.4142135623730951},"284":{"tf":1.4142135623730951},"287":{"tf":1.0},"289":{"tf":1.7320508075688772},"291":{"tf":2.449489742783178},"296":{"tf":2.23606797749979},"303":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"38":{"tf":2.449489742783178},"70":{"tf":2.23606797749979},"72":{"tf":3.3166247903554},"73":{"tf":1.0},"74":{"tf":1.7320508075688772},"76":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"80":{"tf":2.6457513110645907},"82":{"tf":1.4142135623730951},"84":{"tf":2.0},"86":{"tf":2.6457513110645907},"88":{"tf":3.4641016151377544},"90":{"tf":2.0},"91":{"tf":1.0},"92":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"216":{"tf":1.0}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"264":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"265":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"265":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":1,"docs":{"265":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}}}}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"264":{"tf":1.4142135623730951},"265":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"264":{"tf":2.0},"265":{"tf":2.23606797749979}}}}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"(":{"1":{".":{"1":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"3":{"2":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":2,"docs":{"24":{"tf":1.4142135623730951},"25":{"tf":2.23606797749979}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"116":{"tf":1.0},"329":{"tf":1.0},"74":{"tf":2.0}}}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"319":{"tf":1.0}}}}}}},"y":{"b":{"df":1,"docs":{"262":{"tf":1.0}}},"df":0,"docs":{}}},"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"336":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"df":3,"docs":{"297":{"tf":1.0},"78":{"tf":2.0},"80":{"tf":1.7320508075688772}},"e":{"a":{"df":0,"docs":{},"n":{"df":19,"docs":{"108":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951},"132":{"tf":1.0},"169":{"tf":1.0},"187":{"tf":1.0},"192":{"tf":1.4142135623730951},"199":{"tf":1.0},"205":{"tf":1.0},"241":{"tf":1.0},"245":{"tf":1.0},"248":{"tf":1.4142135623730951},"262":{"tf":1.0},"270":{"tf":1.4142135623730951},"313":{"tf":1.0},"319":{"tf":1.0},"324":{"tf":1.7320508075688772},"326":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"223":{"tf":1.0}}}}},"t":{"df":1,"docs":{"127":{"tf":1.0}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"101":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":9,"docs":{"127":{"tf":1.4142135623730951},"217":{"tf":1.0},"289":{"tf":1.0},"300":{"tf":1.0},"302":{"tf":1.4142135623730951},"303":{"tf":2.0},"304":{"tf":2.0},"305":{"tf":1.4142135623730951},"308":{"tf":1.7320508075688772}}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":6,"docs":{"171":{"tf":1.0},"221":{"tf":1.0},"222":{"tf":1.0},"275":{"tf":1.0},"47":{"tf":1.0},"55":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"144":{"tf":1.0},"229":{"tf":1.0}}}},"m":{":":{":":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"99":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"df":1,"docs":{"97":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"(":{"&":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"a":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"259":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"259":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"259":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"259":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"259":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"259":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"x":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"24":{"tf":1.7320508075688772}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"164":{"tf":1.0},"266":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":1,"docs":{"49":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":16,"docs":{"0":{"tf":1.0},"164":{"tf":3.0},"167":{"tf":2.449489742783178},"172":{"tf":1.0},"191":{"tf":1.4142135623730951},"199":{"tf":1.7320508075688772},"259":{"tf":1.0},"26":{"tf":1.0},"260":{"tf":1.0},"261":{"tf":1.4142135623730951},"266":{"tf":1.4142135623730951},"272":{"tf":1.4142135623730951},"287":{"tf":1.4142135623730951},"313":{"tf":1.4142135623730951},"322":{"tf":2.0},"324":{"tf":1.7320508075688772}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"150":{"tf":1.0},"82":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"280":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":10,"docs":{"220":{"tf":1.0},"221":{"tf":1.0},"235":{"tf":1.4142135623730951},"237":{"tf":1.4142135623730951},"245":{"tf":1.0},"26":{"tf":1.0},"266":{"tf":1.0},"279":{"tf":2.6457513110645907},"296":{"tf":1.0},"302":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":4,"docs":{"0":{"tf":1.0},"130":{"tf":1.4142135623730951},"280":{"tf":1.0},"281":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"0":{"tf":1.0},"327":{"tf":1.0}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"0":{"tf":1.0},"212":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"135":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"161":{"tf":1.0},"197":{"tf":1.7320508075688772}}}},"h":{"df":0,"docs":{},"o":{"d":{":":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"217":{"tf":1.0}}},"df":0,"docs":{}}},"df":38,"docs":{"0":{"tf":1.4142135623730951},"116":{"tf":1.0},"117":{"tf":1.0},"142":{"tf":1.7320508075688772},"144":{"tf":1.0},"150":{"tf":1.0},"158":{"tf":1.0},"16":{"tf":1.0},"161":{"tf":1.4142135623730951},"181":{"tf":1.4142135623730951},"182":{"tf":1.0},"185":{"tf":1.0},"191":{"tf":1.0},"196":{"tf":3.0},"199":{"tf":1.0},"200":{"tf":1.7320508075688772},"202":{"tf":1.0},"203":{"tf":2.449489742783178},"207":{"tf":1.0},"210":{"tf":2.0},"225":{"tf":1.4142135623730951},"235":{"tf":1.7320508075688772},"250":{"tf":1.0},"260":{"tf":1.4142135623730951},"261":{"tf":1.0},"265":{"tf":1.0},"270":{"tf":1.0},"279":{"tf":1.0},"280":{"tf":1.7320508075688772},"282":{"tf":1.0},"286":{"tf":1.0},"287":{"tf":1.0},"291":{"tf":1.0},"311":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"48":{"tf":1.4142135623730951},"95":{"tf":3.3166247903554}}},"df":0,"docs":{}}}}},"i":{"d":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"76":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"23":{"tf":1.0}}}}}}},"n":{"d":{"df":2,"docs":{"205":{"tf":1.0},"311":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":1,"docs":{"218":{"tf":1.0}},"m":{"df":3,"docs":{"284":{"tf":1.4142135623730951},"297":{"tf":1.0},"311":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"216":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"x":{"(":{"0":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{},"i":{"6":{"4":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"10":{"tf":2.6457513110645907}}}},"df":0,"docs":{}}},"s":{"c":{"df":2,"docs":{"0":{"tf":1.0},"273":{"tf":1.0}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"159":{"tf":1.4142135623730951},"161":{"tf":1.0},"217":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":1,"docs":{"5":{"tf":1.0}}}},"x":{"df":1,"docs":{"244":{"tf":1.0}}}},"k":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"291":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"m":{"df":1,"docs":{"161":{"tf":1.7320508075688772}}},"o":{"d":{"df":18,"docs":{"115":{"tf":1.7320508075688772},"116":{"tf":1.0},"118":{"tf":1.4142135623730951},"119":{"tf":1.7320508075688772},"120":{"tf":2.23606797749979},"121":{"tf":1.4142135623730951},"127":{"tf":1.0},"217":{"tf":1.0},"264":{"tf":1.0},"265":{"tf":1.0},"300":{"tf":1.7320508075688772},"301":{"tf":1.0},"302":{"tf":1.0},"304":{"tf":1.0},"308":{"tf":1.0},"309":{"tf":1.0},"331":{"tf":1.0},"48":{"tf":1.0}},"e":{"df":4,"docs":{"283":{"tf":1.4142135623730951},"284":{"tf":1.4142135623730951},"317":{"tf":1.7320508075688772},"319":{"tf":1.0}},"l":{"df":2,"docs":{"78":{"tf":1.0},"79":{"tf":1.0}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":24,"docs":{"108":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"116":{"tf":1.0},"168":{"tf":1.0},"172":{"tf":1.0},"229":{"tf":1.0},"232":{"tf":1.4142135623730951},"233":{"tf":1.0},"245":{"tf":1.0},"260":{"tf":1.0},"261":{"tf":1.0},"277":{"tf":1.0},"311":{"tf":1.0},"317":{"tf":1.0},"319":{"tf":1.7320508075688772},"321":{"tf":2.449489742783178},"336":{"tf":1.0},"40":{"tf":1.4142135623730951},"43":{"tf":1.0},"46":{"tf":1.0},"62":{"tf":1.0},"70":{"tf":1.0},"80":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"225":{"tf":1.0}}}},"df":19,"docs":{"0":{"tf":1.7320508075688772},"10":{"tf":1.0},"114":{"tf":2.23606797749979},"115":{"tf":4.358898943540674},"116":{"tf":1.0},"119":{"tf":1.7320508075688772},"120":{"tf":1.7320508075688772},"121":{"tf":1.4142135623730951},"123":{"tf":1.7320508075688772},"127":{"tf":1.4142135623730951},"13":{"tf":1.0},"130":{"tf":1.7320508075688772},"238":{"tf":1.4142135623730951},"260":{"tf":1.0},"261":{"tf":1.0},"291":{"tf":1.0},"308":{"tf":2.0},"49":{"tf":2.0},"5":{"tf":1.4142135623730951}},"u":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}}}}},"n":{"d":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"227":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"34":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"8":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"199":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":55,"docs":{"0":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"125":{"tf":1.4142135623730951},"126":{"tf":1.4142135623730951},"136":{"tf":1.0},"144":{"tf":1.0},"150":{"tf":1.0},"164":{"tf":1.0},"167":{"tf":1.0},"17":{"tf":1.4142135623730951},"176":{"tf":1.0},"179":{"tf":1.0},"194":{"tf":1.0},"197":{"tf":1.0},"206":{"tf":1.0},"212":{"tf":1.7320508075688772},"216":{"tf":1.4142135623730951},"218":{"tf":1.0},"220":{"tf":2.0},"223":{"tf":1.0},"224":{"tf":1.4142135623730951},"225":{"tf":1.0},"227":{"tf":1.0},"229":{"tf":1.0},"235":{"tf":1.0},"237":{"tf":1.7320508075688772},"24":{"tf":1.0},"242":{"tf":1.0},"250":{"tf":1.4142135623730951},"256":{"tf":1.0},"26":{"tf":1.4142135623730951},"260":{"tf":1.0},"261":{"tf":1.0},"262":{"tf":1.7320508075688772},"267":{"tf":1.4142135623730951},"268":{"tf":1.0},"269":{"tf":1.4142135623730951},"286":{"tf":1.0},"287":{"tf":1.4142135623730951},"295":{"tf":1.0},"3":{"tf":1.0},"301":{"tf":1.4142135623730951},"316":{"tf":1.4142135623730951},"318":{"tf":1.0},"319":{"tf":1.4142135623730951},"32":{"tf":1.0},"323":{"tf":1.4142135623730951},"324":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.4142135623730951},"50":{"tf":1.0},"53":{"tf":1.4142135623730951},"60":{"tf":1.0},"92":{"tf":1.0},"97":{"tf":1.0}},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"323":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"248":{"tf":1.0},"262":{"tf":1.0},"61":{"tf":1.0},"99":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"306":{"tf":1.0}}}}},"v":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"97":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":4,"docs":{"316":{"tf":1.4142135623730951},"319":{"tf":2.0},"321":{"tf":1.0},"323":{"tf":1.0}},"e":{"d":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"207":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"207":{"tf":2.449489742783178}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":19,"docs":{"105":{"tf":2.0},"108":{"tf":1.0},"158":{"tf":1.0},"167":{"tf":2.23606797749979},"168":{"tf":1.0},"169":{"tf":3.4641016151377544},"197":{"tf":1.0},"206":{"tf":1.0},"207":{"tf":2.0},"230":{"tf":2.0},"232":{"tf":1.4142135623730951},"234":{"tf":1.0},"270":{"tf":1.0},"275":{"tf":1.0},"276":{"tf":1.7320508075688772},"278":{"tf":1.4142135623730951},"70":{"tf":1.0},"97":{"tf":2.8284271247461903},"99":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"s":{"c":{":":{":":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"279":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":1,"docs":{"267":{"tf":1.0}}},"s":{"b":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{},"v":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"297":{"tf":1.0}}}}},"df":0,"docs":{}}},"u":{"c":{"df":0,"docs":{},"h":{"df":13,"docs":{"125":{"tf":1.0},"199":{"tf":1.0},"206":{"tf":1.0},"218":{"tf":1.0},"221":{"tf":1.0},"222":{"tf":1.0},"224":{"tf":1.0},"237":{"tf":1.4142135623730951},"260":{"tf":1.0},"262":{"tf":1.0},"301":{"tf":1.0},"329":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{},"l":{"(":{"a":{"df":1,"docs":{"318":{"tf":1.0}}},"df":0,"docs":{}},"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"217":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"217":{"tf":1.7320508075688772},"318":{"tf":2.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":23,"docs":{"0":{"tf":1.0},"127":{"tf":1.0},"130":{"tf":1.4142135623730951},"148":{"tf":1.4142135623730951},"177":{"tf":1.0},"179":{"tf":1.0},"188":{"tf":1.0},"20":{"tf":1.0},"210":{"tf":1.4142135623730951},"212":{"tf":1.0},"219":{"tf":1.0},"225":{"tf":1.4142135623730951},"227":{"tf":1.0},"24":{"tf":1.0},"243":{"tf":1.0},"262":{"tf":1.7320508075688772},"270":{"tf":1.0},"302":{"tf":1.0},"303":{"tf":1.0},"316":{"tf":1.0},"318":{"tf":1.0},"320":{"tf":1.0},"323":{"tf":2.0}},"i":{"df":4,"docs":{"237":{"tf":1.4142135623730951},"242":{"tf":1.0},"318":{"tf":1.0},"319":{"tf":1.0}}},"y":{"(":{"\"":{"1":{"0":{"df":2,"docs":{"235":{"tf":1.0},"237":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":2,"docs":{"235":{"tf":1.0},"237":{"tf":1.4142135623730951}}}},"&":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"189":{"tf":1.0}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":6,"docs":{"235":{"tf":1.0},"237":{"tf":1.4142135623730951},"238":{"tf":1.0},"240":{"tf":1.0},"241":{"tf":1.0},"242":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"<":{"'":{"a":{">":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"189":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"t":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":1,"docs":{"175":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"80":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"a":{"b":{"df":0,"docs":{},"l":{"df":15,"docs":{"0":{"tf":1.0},"168":{"tf":2.0},"172":{"tf":3.3166247903554},"174":{"tf":3.0},"175":{"tf":2.0},"179":{"tf":1.0},"21":{"tf":2.449489742783178},"260":{"tf":1.0},"311":{"tf":1.0},"40":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"70":{"tf":1.0},"95":{"tf":2.0},"97":{"tf":1.7320508075688772},"99":{"tf":1.4142135623730951}},"e":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"43":{"tf":2.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"i":{"df":1,"docs":{"174":{"tf":1.4142135623730951}}},"x":{"df":1,"docs":{"174":{"tf":1.4142135623730951}}},"z":{"df":1,"docs":{"174":{"tf":1.4142135623730951}}}},"df":1,"docs":{"174":{"tf":1.4142135623730951}}}}}},"x":{"df":1,"docs":{"168":{"tf":2.0}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"i":{"df":1,"docs":{"175":{"tf":1.0}}},"x":{"df":1,"docs":{"175":{"tf":1.0}}}},"df":1,"docs":{"175":{"tf":1.7320508075688772}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"175":{"tf":2.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"172":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"t":{"df":5,"docs":{"175":{"tf":1.0},"280":{"tf":1.0},"43":{"tf":1.4142135623730951},"97":{"tf":1.0},"99":{"tf":1.0}}}},"df":66,"docs":{"10":{"tf":1.7320508075688772},"105":{"tf":1.0},"108":{"tf":1.0},"110":{"tf":1.7320508075688772},"112":{"tf":1.0},"113":{"tf":1.0},"127":{"tf":1.4142135623730951},"13":{"tf":1.0},"16":{"tf":1.0},"168":{"tf":1.0},"172":{"tf":1.7320508075688772},"174":{"tf":1.7320508075688772},"175":{"tf":2.23606797749979},"179":{"tf":1.4142135623730951},"181":{"tf":1.4142135623730951},"191":{"tf":1.4142135623730951},"196":{"tf":1.0},"203":{"tf":1.0},"206":{"tf":1.0},"21":{"tf":1.4142135623730951},"217":{"tf":1.4142135623730951},"22":{"tf":1.0},"232":{"tf":1.0},"233":{"tf":1.4142135623730951},"245":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.0},"250":{"tf":1.0},"254":{"tf":1.0},"260":{"tf":1.0},"261":{"tf":1.4142135623730951},"267":{"tf":1.0},"268":{"tf":1.0},"269":{"tf":1.4142135623730951},"275":{"tf":1.0},"276":{"tf":1.0},"279":{"tf":1.4142135623730951},"280":{"tf":1.0},"283":{"tf":1.4142135623730951},"284":{"tf":1.0},"286":{"tf":1.0},"289":{"tf":1.7320508075688772},"290":{"tf":1.0},"291":{"tf":2.23606797749979},"297":{"tf":1.0},"316":{"tf":1.0},"317":{"tf":1.4142135623730951},"319":{"tf":1.4142135623730951},"321":{"tf":1.0},"323":{"tf":1.0},"324":{"tf":1.0},"38":{"tf":1.0},"43":{"tf":1.4142135623730951},"46":{"tf":1.0},"50":{"tf":1.0},"59":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.4142135623730951},"80":{"tf":2.23606797749979},"90":{"tf":1.4142135623730951},"92":{"tf":1.4142135623730951},"95":{"tf":1.7320508075688772},"97":{"tf":3.1622776601683795},"99":{"tf":2.0}},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"276":{"tf":1.0}}}}}},"y":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"120":{"tf":1.7320508075688772}}}},"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"120":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"120":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},":":{":":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"\"":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"116":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"116":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"119":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"119":{"tf":1.0},"120":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"a":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"120":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"a":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"120":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"119":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"120":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"120":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"116":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"120":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"_":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"233":{"tf":1.7320508075688772}},"e":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"233":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"232":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":2,"docs":{"232":{"tf":1.7320508075688772},"233":{"tf":2.0}}}}}}},"m":{"df":0,"docs":{},"o":{"d":{":":{":":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"a":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"115":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"c":{"df":0,"docs":{},"r":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"115":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"126":{"tf":1.0}}}},"df":1,"docs":{"126":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"127":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"313":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"262":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"127":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"<":{"a":{"df":1,"docs":{"150":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"206":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"112":{"tf":2.0}}}},"df":0,"docs":{}}}}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"286":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"196":{"tf":1.7320508075688772}}}},"m":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"196":{"tf":1.4142135623730951},"208":{"tf":1.0}}}}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"329":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"]":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"329":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"319":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"319":{"tf":1.0}}}}},"df":0,"docs":{}},"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}},"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"183":{"tf":1.0}},"e":{"d":{"<":{"'":{"a":{"df":1,"docs":{"183":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":57,"docs":{"10":{"tf":1.0},"115":{"tf":1.4142135623730951},"116":{"tf":1.0},"118":{"tf":1.4142135623730951},"119":{"tf":1.0},"120":{"tf":1.4142135623730951},"122":{"tf":1.7320508075688772},"123":{"tf":1.0},"125":{"tf":2.23606797749979},"126":{"tf":1.4142135623730951},"127":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":1.0},"132":{"tf":1.4142135623730951},"136":{"tf":1.4142135623730951},"16":{"tf":2.0},"169":{"tf":2.449489742783178},"172":{"tf":1.0},"176":{"tf":1.0},"190":{"tf":1.0},"196":{"tf":1.7320508075688772},"202":{"tf":2.23606797749979},"206":{"tf":1.0},"208":{"tf":1.0},"210":{"tf":1.7320508075688772},"212":{"tf":1.4142135623730951},"214":{"tf":2.0},"230":{"tf":1.0},"232":{"tf":1.0},"267":{"tf":1.0},"268":{"tf":1.4142135623730951},"28":{"tf":2.0},"280":{"tf":1.0},"296":{"tf":1.4142135623730951},"297":{"tf":1.0},"300":{"tf":1.0},"303":{"tf":1.4142135623730951},"31":{"tf":1.0},"316":{"tf":1.0},"318":{"tf":1.4142135623730951},"319":{"tf":1.7320508075688772},"32":{"tf":1.4142135623730951},"321":{"tf":2.23606797749979},"323":{"tf":1.4142135623730951},"326":{"tf":2.23606797749979},"329":{"tf":2.449489742783178},"34":{"tf":1.4142135623730951},"42":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.7320508075688772},"51":{"tf":1.7320508075688772},"70":{"tf":3.872983346207417},"78":{"tf":1.4142135623730951},"8":{"tf":2.0},"86":{"tf":1.0},"90":{"tf":1.0},"96":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"96":{"tf":1.0}}}}}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"70":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"n":{"df":1,"docs":{"48":{"tf":2.0}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"51":{"tf":2.8284271247461903}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"128":{"tf":1.0},"275":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"112":{"tf":1.0},"127":{"tf":1.0},"131":{"tf":1.0}}}}}},"df":21,"docs":{"112":{"tf":2.449489742783178},"16":{"tf":1.0},"203":{"tf":1.4142135623730951},"237":{"tf":1.4142135623730951},"238":{"tf":1.0},"240":{"tf":1.0},"241":{"tf":1.0},"242":{"tf":1.0},"244":{"tf":1.4142135623730951},"245":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.0},"250":{"tf":1.0},"262":{"tf":1.0},"296":{"tf":1.0},"40":{"tf":1.7320508075688772},"63":{"tf":3.3166247903554},"67":{"tf":2.8284271247461903},"69":{"tf":3.4641016151377544},"86":{"tf":3.1622776601683795},"94":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"323":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":8,"docs":{"101":{"tf":1.0},"127":{"tf":1.0},"138":{"tf":1.0},"196":{"tf":1.0},"314":{"tf":1.0},"320":{"tf":1.0},"56":{"tf":1.0},"94":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":47,"docs":{"125":{"tf":1.0},"128":{"tf":1.4142135623730951},"132":{"tf":1.0},"133":{"tf":1.0},"164":{"tf":1.0},"17":{"tf":1.0},"191":{"tf":1.0},"199":{"tf":1.7320508075688772},"207":{"tf":1.0},"212":{"tf":1.0},"215":{"tf":1.0},"221":{"tf":1.0},"222":{"tf":1.4142135623730951},"223":{"tf":1.0},"224":{"tf":1.0},"227":{"tf":1.4142135623730951},"229":{"tf":2.0},"23":{"tf":1.0},"237":{"tf":1.0},"240":{"tf":1.0},"243":{"tf":1.4142135623730951},"245":{"tf":1.0},"250":{"tf":1.4142135623730951},"256":{"tf":1.0},"260":{"tf":1.0},"262":{"tf":1.7320508075688772},"263":{"tf":1.0},"270":{"tf":1.0},"272":{"tf":1.0},"276":{"tf":1.7320508075688772},"3":{"tf":1.0},"309":{"tf":1.0},"316":{"tf":1.4142135623730951},"319":{"tf":2.449489742783178},"321":{"tf":1.4142135623730951},"324":{"tf":1.0},"34":{"tf":1.0},"50":{"tf":1.0},"6":{"tf":1.0},"63":{"tf":1.4142135623730951},"66":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0},"88":{"tf":1.4142135623730951},"95":{"tf":1.0},"97":{"tf":1.0}},"l":{"df":1,"docs":{"97":{"tf":1.0}}}},"df":0,"docs":{}},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"264":{"tf":1.0},"265":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}}}}}},"df":3,"docs":{"265":{"tf":1.0},"48":{"tf":1.0},"63":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":11,"docs":{"115":{"tf":2.23606797749979},"118":{"tf":1.0},"120":{"tf":1.4142135623730951},"164":{"tf":1.0},"224":{"tf":1.0},"227":{"tf":1.0},"241":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"65":{"tf":1.4142135623730951},"82":{"tf":1.0}},"e":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"120":{"tf":1.4142135623730951}}}},":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"115":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"115":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"i":{"df":1,"docs":{"82":{"tf":1.7320508075688772}}},"x":{"df":1,"docs":{"82":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"113":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":11,"docs":{"113":{"tf":2.449489742783178},"164":{"tf":1.0},"177":{"tf":1.0},"192":{"tf":1.0},"203":{"tf":1.0},"221":{"tf":1.0},"269":{"tf":1.0},"270":{"tf":1.0},"319":{"tf":1.0},"65":{"tf":1.0},"84":{"tf":1.0}}}}},"w":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"196":{"tf":1.4142135623730951},"329":{"tf":1.0}}}},"df":0,"docs":{}},"x":{"df":1,"docs":{"95":{"tf":1.0}}}},"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"i":{"df":1,"docs":{"174":{"tf":1.0}}},"x":{"df":1,"docs":{"174":{"tf":1.0}}},"z":{"df":1,"docs":{"174":{"tf":1.0}}}},"df":1,"docs":{"174":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"172":{"tf":1.4142135623730951}}}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"172":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"\"":{"c":{"df":1,"docs":{"280":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"z":{"df":1,"docs":{"280":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"\"":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"g":{"df":0,"docs":{},"z":{"df":1,"docs":{"280":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"280":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"280":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":28,"docs":{"10":{"tf":1.0},"101":{"tf":1.4142135623730951},"118":{"tf":1.0},"123":{"tf":1.0},"125":{"tf":2.23606797749979},"14":{"tf":1.0},"152":{"tf":1.0},"154":{"tf":1.0},"158":{"tf":1.0},"161":{"tf":1.0},"2":{"tf":1.0},"210":{"tf":1.0},"245":{"tf":1.4142135623730951},"260":{"tf":1.0},"261":{"tf":1.7320508075688772},"267":{"tf":1.0},"269":{"tf":1.4142135623730951},"276":{"tf":1.0},"28":{"tf":1.0},"284":{"tf":1.0},"287":{"tf":1.0},"326":{"tf":1.4142135623730951},"337":{"tf":1.0},"38":{"tf":1.4142135623730951},"43":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.7320508075688772},"64":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"326":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"316":{"tf":1.0},"5":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"152":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"152":{"tf":1.0}}},"df":0,"docs":{}}}}}},"x":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"203":{"tf":1.0}}}}}},"df":0,"docs":{}},"_":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"224":{"tf":1.7320508075688772}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"d":{"a":{"df":0,"docs":{},"y":{"(":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"224":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":10,"docs":{"126":{"tf":1.0},"156":{"tf":1.0},"2":{"tf":1.0},"203":{"tf":2.8284271247461903},"240":{"tf":1.0},"243":{"tf":1.0},"267":{"tf":1.0},"305":{"tf":1.4142135623730951},"308":{"tf":1.0},"38":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":3,"docs":{"223":{"tf":1.0},"245":{"tf":1.0},"26":{"tf":1.0}},"r":{"df":1,"docs":{"92":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":2.449489742783178}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"177":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}}}},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{")":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"230":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":2,"docs":{"230":{"tf":1.0},"231":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"332":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"196":{"tf":1.4142135623730951},"199":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"y":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"131":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"42":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"324":{"tf":1.4142135623730951}}}}},"n":{"df":14,"docs":{"136":{"tf":1.0},"138":{"tf":1.0},"142":{"tf":1.0},"192":{"tf":1.0},"200":{"tf":1.0},"265":{"tf":1.0},"276":{"tf":1.4142135623730951},"279":{"tf":1.0},"284":{"tf":1.4142135623730951},"300":{"tf":1.0},"309":{"tf":1.0},"88":{"tf":1.0},"97":{"tf":1.7320508075688772},"99":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"263":{"tf":1.0}}}},"df":0,"docs":{}}}}}},":":{":":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"263":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":23,"docs":{"110":{"tf":1.7320508075688772},"203":{"tf":1.7320508075688772},"223":{"tf":2.23606797749979},"224":{"tf":1.7320508075688772},"225":{"tf":3.1622776601683795},"227":{"tf":2.6457513110645907},"229":{"tf":1.0},"230":{"tf":1.0},"231":{"tf":1.0},"232":{"tf":1.0},"233":{"tf":1.0},"244":{"tf":1.0},"250":{"tf":1.0},"253":{"tf":1.0},"26":{"tf":1.0},"263":{"tf":3.0},"264":{"tf":1.0},"267":{"tf":1.0},"280":{"tf":1.0},"301":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.4142135623730951},"92":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":2,"docs":{"264":{"tf":1.0},"265":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}}}}}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"161":{"tf":1.0}}}}}}},"p":{"df":1,"docs":{"315":{"tf":1.0}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":10,"docs":{"116":{"tf":1.0},"128":{"tf":1.0},"130":{"tf":1.0},"148":{"tf":1.0},"150":{"tf":1.0},"189":{"tf":1.0},"218":{"tf":1.0},"262":{"tf":1.0},"326":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"324":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"23":{"tf":1.7320508075688772},"278":{"tf":1.0},"291":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":43,"docs":{"10":{"tf":1.0},"103":{"tf":1.0},"113":{"tf":1.0},"125":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0},"144":{"tf":1.0},"158":{"tf":1.4142135623730951},"159":{"tf":1.0},"167":{"tf":1.0},"176":{"tf":1.0},"179":{"tf":1.0},"185":{"tf":1.0},"187":{"tf":1.0},"205":{"tf":1.0},"21":{"tf":1.0},"216":{"tf":1.0},"218":{"tf":1.0},"223":{"tf":1.0},"230":{"tf":1.0},"232":{"tf":1.0},"233":{"tf":1.0},"245":{"tf":1.0},"256":{"tf":1.0},"262":{"tf":1.0},"268":{"tf":1.0},"276":{"tf":1.0},"280":{"tf":1.0},"286":{"tf":1.0},"287":{"tf":1.0},"3":{"tf":1.0},"300":{"tf":1.7320508075688772},"31":{"tf":1.0},"314":{"tf":1.0},"315":{"tf":1.0},"318":{"tf":1.0},"34":{"tf":1.4142135623730951},"42":{"tf":1.0},"51":{"tf":1.0},"70":{"tf":1.0},"84":{"tf":1.0},"95":{"tf":1.0},"99":{"tf":1.0}}},"h":{"df":10,"docs":{"101":{"tf":1.0},"125":{"tf":1.0},"142":{"tf":1.0},"223":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.0},"316":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"99":{"tf":1.0}}},"i":{"c":{"df":5,"docs":{"113":{"tf":1.0},"125":{"tf":1.0},"220":{"tf":1.0},"248":{"tf":1.0},"337":{"tf":1.0}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"165":{"tf":1.0}}}}}},"w":{"df":18,"docs":{"0":{"tf":1.0},"167":{"tf":1.4142135623730951},"168":{"tf":1.0},"171":{"tf":1.0},"174":{"tf":1.0},"206":{"tf":1.0},"225":{"tf":1.0},"23":{"tf":1.0},"237":{"tf":1.4142135623730951},"241":{"tf":1.0},"242":{"tf":1.0},"245":{"tf":1.0},"248":{"tf":1.0},"3":{"tf":1.0},"316":{"tf":1.0},"50":{"tf":1.0},"86":{"tf":1.0},"99":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"275":{"tf":1.0},"279":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"156":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"l":{"a":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}},"df":3,"docs":{"142":{"tf":2.23606797749979},"223":{"tf":1.0},"261":{"tf":1.0}}}},"m":{"(":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"183":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"296":{"tf":1.0}}}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"3":{"0":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}},"=":{"1":{"df":1,"docs":{"5":{"tf":2.0}}},"df":0,"docs":{}},"_":{"1":{"df":2,"docs":{"156":{"tf":2.0},"158":{"tf":2.0}}},"2":{"df":2,"docs":{"156":{"tf":2.449489742783178},"158":{"tf":2.449489742783178}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"236":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":1,"docs":{"236":{"tf":1.0}}}}}},"df":55,"docs":{"10":{"tf":1.0},"112":{"tf":1.7320508075688772},"113":{"tf":1.0},"125":{"tf":1.0},"156":{"tf":2.23606797749979},"158":{"tf":2.0},"171":{"tf":1.0},"174":{"tf":1.0},"183":{"tf":1.4142135623730951},"206":{"tf":1.0},"21":{"tf":1.0},"212":{"tf":1.4142135623730951},"216":{"tf":1.0},"219":{"tf":1.4142135623730951},"224":{"tf":1.7320508075688772},"235":{"tf":1.0},"236":{"tf":1.7320508075688772},"24":{"tf":1.0},"243":{"tf":1.4142135623730951},"244":{"tf":1.7320508075688772},"245":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.0},"250":{"tf":1.0},"252":{"tf":1.4142135623730951},"253":{"tf":1.4142135623730951},"254":{"tf":1.4142135623730951},"255":{"tf":1.4142135623730951},"256":{"tf":2.23606797749979},"260":{"tf":1.0},"265":{"tf":1.4142135623730951},"267":{"tf":2.0},"270":{"tf":1.4142135623730951},"275":{"tf":1.0},"276":{"tf":1.7320508075688772},"277":{"tf":1.4142135623730951},"296":{"tf":2.0},"297":{"tf":1.7320508075688772},"301":{"tf":1.0},"305":{"tf":1.0},"316":{"tf":1.0},"323":{"tf":1.4142135623730951},"36":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.7320508075688772},"55":{"tf":2.0},"56":{"tf":2.23606797749979},"6":{"tf":1.4142135623730951},"60":{"tf":1.0},"63":{"tf":1.7320508075688772},"72":{"tf":2.0},"84":{"tf":1.4142135623730951},"86":{"tf":1.0},"88":{"tf":2.23606797749979}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"256":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":4,"docs":{"191":{"tf":2.23606797749979},"296":{"tf":1.0},"55":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"23":{"tf":1.0},"295":{"tf":1.0},"323":{"tf":1.7320508075688772},"49":{"tf":1.4142135623730951},"55":{"tf":1.0},"60":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"/":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"125":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"=":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"5":{"tf":1.0}}}}},"df":0,"docs":{}},"df":14,"docs":{"164":{"tf":1.0},"171":{"tf":2.23606797749979},"172":{"tf":2.0},"199":{"tf":1.0},"202":{"tf":1.0},"246":{"tf":1.0},"250":{"tf":1.0},"259":{"tf":1.0},"26":{"tf":1.4142135623730951},"266":{"tf":1.0},"287":{"tf":1.0},"289":{"tf":1.0},"5":{"tf":1.0},"95":{"tf":2.23606797749979}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":3,"docs":{"101":{"tf":1.0},"152":{"tf":1.0},"324":{"tf":1.4142135623730951}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"152":{"tf":1.0},"319":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{"c":{"a":{"df":0,"docs":{},"e":{"c":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"259":{"tf":2.449489742783178},"26":{"tf":1.0}}}},"r":{"df":6,"docs":{"105":{"tf":1.0},"169":{"tf":1.0},"236":{"tf":1.0},"240":{"tf":1.0},"262":{"tf":1.0},"276":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"23":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"d":{"df":2,"docs":{"112":{"tf":1.7320508075688772},"113":{"tf":1.0}}},"df":0,"docs":{}},"df":3,"docs":{"16":{"tf":1.0},"316":{"tf":1.7320508075688772},"5":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}},"df":6,"docs":{"0":{"tf":1.4142135623730951},"124":{"tf":1.4142135623730951},"125":{"tf":1.0},"220":{"tf":1.0},"311":{"tf":1.0},"337":{"tf":1.0}}}},"df":0,"docs":{}}}},"h":{"df":1,"docs":{"223":{"tf":1.0}}},"k":{"(":{"2":{"df":2,"docs":{"248":{"tf":1.0},"250":{"tf":1.0}}},"4":{"2":{"df":1,"docs":{"296":{"tf":1.0}}},"df":0,"docs":{}},"_":{"df":4,"docs":{"283":{"tf":1.0},"284":{"tf":1.0},"289":{"tf":1.4142135623730951},"291":{"tf":1.7320508075688772}}},"a":{"df":1,"docs":{"306":{"tf":1.0}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.4142135623730951}}}}}}},"df":1,"docs":{"291":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"8":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}},"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"57":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"283":{"tf":1.0},"284":{"tf":1.0}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":4,"docs":{"237":{"tf":1.4142135623730951},"240":{"tf":1.4142135623730951},"241":{"tf":1.0},"242":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"o":{":":{":":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{")":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"287":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"287":{"tf":1.0}}}},"n":{"df":1,"docs":{"264":{"tf":1.0}}}},"m":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"262":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"n":{"df":10,"docs":{"237":{"tf":1.4142135623730951},"238":{"tf":1.0},"240":{"tf":1.0},"241":{"tf":1.0},"242":{"tf":1.0},"245":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.0},"250":{"tf":1.0},"296":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"236":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"f":{"(":{"0":{".":{"5":{"df":1,"docs":{"301":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"265":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"291":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"289":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"264":{"tf":1.0}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":2,"docs":{"237":{"tf":1.0},"240":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"264":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"235":{"tf":1.0}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":2,"docs":{"264":{"tf":1.0},"265":{"tf":1.0}}}}},"df":0,"docs":{}},"x":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"n":{"df":2,"docs":{"264":{"tf":1.0},"265":{"tf":1.0}}}},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"264":{"tf":1.0},"265":{"tf":1.0}}}}}}},"df":2,"docs":{"264":{"tf":1.0},"265":{"tf":1.0}}}},"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"245":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"246":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":18,"docs":{"127":{"tf":2.8284271247461903},"174":{"tf":1.0},"217":{"tf":2.0},"235":{"tf":1.0},"236":{"tf":1.0},"264":{"tf":1.0},"265":{"tf":1.0},"291":{"tf":1.0},"300":{"tf":1.0},"301":{"tf":1.0},"302":{"tf":2.23606797749979},"303":{"tf":2.6457513110645907},"304":{"tf":2.6457513110645907},"305":{"tf":2.23606797749979},"306":{"tf":1.0},"308":{"tf":2.0},"43":{"tf":1.0},"46":{"tf":1.0}}},"l":{"d":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"(":{"&":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"152":{"tf":1.0}},"e":{"_":{"d":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"152":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"y":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"152":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"152":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":3,"docs":{"269":{"tf":1.0},"284":{"tf":1.0},"86":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"242":{"tf":1.0},"326":{"tf":1.0}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"194":{"tf":1.0},"94":{"tf":1.0}}}}},"n":{"c":{"df":10,"docs":{"16":{"tf":1.0},"167":{"tf":1.0},"17":{"tf":1.0},"216":{"tf":1.0},"255":{"tf":1.0},"316":{"tf":1.0},"323":{"tf":1.0},"70":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}}},"df":72,"docs":{"10":{"tf":1.0},"101":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951},"112":{"tf":1.0},"113":{"tf":1.7320508075688772},"118":{"tf":1.0},"125":{"tf":1.0},"127":{"tf":2.0},"136":{"tf":1.0},"142":{"tf":1.0},"154":{"tf":1.0},"159":{"tf":1.0},"16":{"tf":1.0},"167":{"tf":1.0},"174":{"tf":1.0},"177":{"tf":1.0},"179":{"tf":1.0},"183":{"tf":1.0},"189":{"tf":1.0},"190":{"tf":1.0},"197":{"tf":1.0},"199":{"tf":1.0},"202":{"tf":1.0},"216":{"tf":1.4142135623730951},"218":{"tf":1.0},"220":{"tf":1.0},"223":{"tf":1.4142135623730951},"229":{"tf":1.4142135623730951},"235":{"tf":1.0},"237":{"tf":1.0},"238":{"tf":1.4142135623730951},"24":{"tf":1.0},"240":{"tf":1.0},"245":{"tf":1.0},"250":{"tf":1.0},"259":{"tf":1.0},"26":{"tf":1.4142135623730951},"262":{"tf":1.7320508075688772},"266":{"tf":1.0},"268":{"tf":1.0},"269":{"tf":1.7320508075688772},"270":{"tf":1.0},"276":{"tf":1.0},"28":{"tf":1.0},"289":{"tf":1.0},"295":{"tf":1.0},"296":{"tf":2.449489742783178},"303":{"tf":1.4142135623730951},"306":{"tf":1.4142135623730951},"308":{"tf":1.0},"309":{"tf":1.0},"31":{"tf":1.0},"311":{"tf":1.0},"313":{"tf":1.4142135623730951},"316":{"tf":1.0},"323":{"tf":1.0},"36":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0},"60":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.4142135623730951},"72":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"88":{"tf":1.0},"96":{"tf":1.7320508075688772},"99":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"161":{"tf":1.0}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"161":{"tf":2.6457513110645907}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"161":{"tf":2.6457513110645907}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"125":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"324":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"191":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"192":{"tf":1.0},"26":{"tf":1.0}}}},"p":{"!":{"(":{"a":{"d":{"d":{"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"217":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"217":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"u":{"b":{"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"217":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"(":{"1":{".":{"0":{"df":1,"docs":{"264":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"x":{"df":2,"docs":{"264":{"tf":1.4142135623730951},"265":{"tf":1.0}}}},":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"217":{"tf":1.4142135623730951}}}}},"_":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"265":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":1,"docs":{"217":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"(":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"127":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"r":{"df":1,"docs":{"283":{"tf":1.0}}}},"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"116":{"tf":1.0}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"116":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":9,"docs":{"116":{"tf":1.0},"127":{"tf":2.0},"13":{"tf":1.0},"150":{"tf":1.0},"282":{"tf":1.0},"283":{"tf":2.449489742783178},"284":{"tf":1.7320508075688772},"287":{"tf":1.0},"337":{"tf":1.0}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"284":{"tf":1.0},"291":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{")":{".":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{")":{".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{")":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"291":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"127":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":9,"docs":{"316":{"tf":1.0},"317":{"tf":1.4142135623730951},"318":{"tf":3.0},"319":{"tf":1.0},"320":{"tf":1.4142135623730951},"321":{"tf":1.4142135623730951},"322":{"tf":1.7320508075688772},"323":{"tf":1.0},"324":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{":":{":":{"a":{"d":{"d":{"df":1,"docs":{"32":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":28,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0},"13":{"tf":1.4142135623730951},"133":{"tf":1.0},"161":{"tf":1.4142135623730951},"200":{"tf":3.0},"217":{"tf":1.4142135623730951},"224":{"tf":1.4142135623730951},"225":{"tf":1.0},"23":{"tf":1.7320508075688772},"242":{"tf":1.0},"248":{"tf":1.0},"252":{"tf":1.0},"255":{"tf":1.0},"259":{"tf":1.0},"264":{"tf":2.449489742783178},"265":{"tf":1.0},"266":{"tf":1.0},"269":{"tf":1.0},"279":{"tf":1.0},"282":{"tf":1.0},"291":{"tf":1.0},"297":{"tf":1.4142135623730951},"311":{"tf":1.0},"315":{"tf":1.0},"32":{"tf":1.0},"66":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"113":{"tf":1.4142135623730951},"319":{"tf":1.0}}}}},"s":{":":{":":{"a":{"d":{"d":{"<":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"200":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"200":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"244":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":1,"docs":{"244":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"317":{"tf":2.0},"324":{"tf":2.0}}},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"237":{"tf":1.0}}},":":{":":{"a":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"228":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"228":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"226":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"<":{"&":{"(":{"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":1,"docs":{"250":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"223":{"tf":1.4142135623730951}}}}},"v":{"df":1,"docs":{"267":{"tf":1.0}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"289":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"289":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"225":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"225":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"225":{"tf":1.4142135623730951},"227":{"tf":2.6457513110645907}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"230":{"tf":1.0},"231":{"tf":1.0},"232":{"tf":1.0},"233":{"tf":1.0}}}}}}},"i":{"3":{"2":{"df":4,"docs":{"257":{"tf":1.0},"263":{"tf":1.4142135623730951},"88":{"tf":2.0},"92":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"j":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"224":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"227":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"227":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"225":{"tf":1.4142135623730951}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"224":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"244":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"110":{"tf":1.0},"203":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"224":{"tf":1.0}}}}},"t":{"df":5,"docs":{"150":{"tf":1.4142135623730951},"203":{"tf":1.0},"223":{"tf":1.0},"227":{"tf":1.0},"263":{"tf":1.0}}},"u":{"3":{"2":{"df":1,"docs":{"86":{"tf":1.0}}},"df":0,"docs":{}},"8":{"df":1,"docs":{"224":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"263":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"263":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":37,"docs":{"112":{"tf":1.0},"122":{"tf":1.0},"125":{"tf":1.0},"216":{"tf":1.0},"220":{"tf":1.7320508075688772},"223":{"tf":1.7320508075688772},"224":{"tf":1.7320508075688772},"225":{"tf":1.4142135623730951},"226":{"tf":1.0},"227":{"tf":1.0},"228":{"tf":1.0},"229":{"tf":1.4142135623730951},"232":{"tf":1.0},"233":{"tf":1.0},"235":{"tf":1.7320508075688772},"237":{"tf":1.0},"243":{"tf":2.0},"244":{"tf":1.7320508075688772},"248":{"tf":1.0},"255":{"tf":1.0},"257":{"tf":1.0},"26":{"tf":1.0},"263":{"tf":1.7320508075688772},"264":{"tf":1.0},"280":{"tf":1.0},"287":{"tf":1.0},"302":{"tf":1.0},"323":{"tf":1.4142135623730951},"324":{"tf":2.23606797749979},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":2.23606797749979},"89":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":3.605551275463989},"93":{"tf":1.0},"96":{"tf":1.4142135623730951}},"s":{"(":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"323":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"322":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"324":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"r":{"'":{"df":1,"docs":{"230":{"tf":1.0}}},"(":{")":{"df":0,"docs":{},"i":{"df":1,"docs":{"230":{"tf":1.0}}}},"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"230":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"230":{"tf":1.0}}}}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":2,"docs":{"231":{"tf":1.4142135623730951},"234":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"_":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"231":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"231":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":4,"docs":{"230":{"tf":1.4142135623730951},"231":{"tf":1.0},"232":{"tf":1.0},"233":{"tf":1.0}}}}},"d":{"df":1,"docs":{"197":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":13,"docs":{"0":{"tf":1.0},"112":{"tf":1.4142135623730951},"206":{"tf":1.0},"250":{"tf":1.0},"267":{"tf":1.0},"269":{"tf":1.4142135623730951},"279":{"tf":1.0},"308":{"tf":1.0},"316":{"tf":1.0},"319":{"tf":1.4142135623730951},"82":{"tf":1.0},"94":{"tf":1.0},"99":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}},"i":{"df":0,"docs":{},"z":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"127":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":11,"docs":{"1":{"tf":1.0},"174":{"tf":1.7320508075688772},"207":{"tf":1.0},"229":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.0},"259":{"tf":2.0},"261":{"tf":1.0},"319":{"tf":1.4142135623730951},"95":{"tf":1.0},"97":{"tf":1.0}}}}}}},"s":{"df":3,"docs":{"133":{"tf":1.4142135623730951},"275":{"tf":1.4142135623730951},"280":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"16":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"280":{"tf":2.0},"281":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"df":5,"docs":{"0":{"tf":1.0},"223":{"tf":1.0},"318":{"tf":1.0},"62":{"tf":1.0},"8":{"tf":1.0}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":16,"docs":{"108":{"tf":1.0},"128":{"tf":1.0},"13":{"tf":1.0},"150":{"tf":1.4142135623730951},"203":{"tf":1.0},"223":{"tf":1.0},"224":{"tf":1.0},"225":{"tf":1.4142135623730951},"227":{"tf":1.0},"237":{"tf":1.4142135623730951},"267":{"tf":1.0},"284":{"tf":1.0},"289":{"tf":1.0},"314":{"tf":1.0},"323":{"tf":1.0},"96":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"x":{"df":1,"docs":{"319":{"tf":1.4142135623730951}}}},"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"319":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"320":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":3,"docs":{"316":{"tf":1.4142135623730951},"319":{"tf":1.0},"323":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"235":{"tf":1.7320508075688772}}}}},"df":52,"docs":{"0":{"tf":1.7320508075688772},"126":{"tf":1.0},"127":{"tf":1.4142135623730951},"138":{"tf":1.0},"164":{"tf":1.0},"165":{"tf":1.4142135623730951},"169":{"tf":1.0},"171":{"tf":1.4142135623730951},"172":{"tf":1.0},"191":{"tf":1.0},"202":{"tf":1.0},"206":{"tf":1.4142135623730951},"210":{"tf":1.4142135623730951},"217":{"tf":1.0},"222":{"tf":1.4142135623730951},"223":{"tf":1.0},"235":{"tf":1.0},"241":{"tf":1.0},"244":{"tf":1.0},"248":{"tf":1.0},"253":{"tf":1.0},"259":{"tf":1.0},"26":{"tf":1.4142135623730951},"260":{"tf":1.7320508075688772},"262":{"tf":1.4142135623730951},"269":{"tf":1.0},"270":{"tf":1.7320508075688772},"272":{"tf":1.0},"276":{"tf":1.7320508075688772},"283":{"tf":1.0},"3":{"tf":1.0},"300":{"tf":1.0},"302":{"tf":1.4142135623730951},"303":{"tf":2.0},"304":{"tf":2.0},"305":{"tf":1.4142135623730951},"308":{"tf":1.7320508075688772},"309":{"tf":1.0},"316":{"tf":1.4142135623730951},"317":{"tf":1.0},"318":{"tf":1.4142135623730951},"331":{"tf":1.0},"332":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.7320508075688772},"48":{"tf":1.4142135623730951},"50":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.4142135623730951},"95":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"130":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"96":{"tf":2.0}}}},"df":0,"docs":{}}},"df":7,"docs":{"118":{"tf":1.0},"218":{"tf":1.0},"300":{"tf":1.0},"44":{"tf":1.4142135623730951},"65":{"tf":2.449489742783178},"90":{"tf":1.0},"96":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"119":{"tf":1.0}}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":3,"docs":{"177":{"tf":1.0},"183":{"tf":1.4142135623730951},"187":{"tf":2.23606797749979}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"|":{"df":1,"docs":{"288":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"288":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"=":{"df":0,"docs":{},"t":{"df":1,"docs":{"217":{"tf":1.0}}}},"df":32,"docs":{"10":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"125":{"tf":1.0},"127":{"tf":1.4142135623730951},"129":{"tf":1.0},"14":{"tf":1.0},"158":{"tf":1.4142135623730951},"161":{"tf":2.23606797749979},"17":{"tf":1.0},"2":{"tf":1.4142135623730951},"200":{"tf":1.4142135623730951},"218":{"tf":1.4142135623730951},"219":{"tf":1.0},"223":{"tf":1.0},"233":{"tf":1.0},"25":{"tf":1.4142135623730951},"259":{"tf":1.0},"276":{"tf":1.0},"283":{"tf":1.0},"284":{"tf":1.0},"287":{"tf":1.0},"288":{"tf":1.4142135623730951},"291":{"tf":1.0},"314":{"tf":1.0},"316":{"tf":2.6457513110645907},"317":{"tf":1.7320508075688772},"318":{"tf":1.0},"319":{"tf":2.6457513110645907},"320":{"tf":1.0},"324":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"115":{"tf":1.4142135623730951},"116":{"tf":1.0},"119":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"158":{"tf":1.0},"237":{"tf":1.0}}}},"df":32,"docs":{"1":{"tf":1.0},"108":{"tf":1.0},"110":{"tf":1.4142135623730951},"121":{"tf":1.0},"13":{"tf":1.0},"130":{"tf":1.0},"136":{"tf":1.0},"138":{"tf":1.0},"142":{"tf":1.0},"154":{"tf":1.0},"156":{"tf":1.0},"159":{"tf":1.4142135623730951},"161":{"tf":1.0},"171":{"tf":1.0},"203":{"tf":1.4142135623730951},"205":{"tf":1.0},"206":{"tf":1.0},"243":{"tf":1.0},"252":{"tf":1.0},"260":{"tf":1.7320508075688772},"261":{"tf":1.4142135623730951},"268":{"tf":1.0},"276":{"tf":1.4142135623730951},"279":{"tf":1.0},"286":{"tf":1.0},"289":{"tf":1.0},"311":{"tf":1.0},"319":{"tf":1.0},"321":{"tf":1.4142135623730951},"38":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0}},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"48":{"tf":1.4142135623730951}}}}}},"l":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"210":{"tf":1.0},"235":{"tf":1.0}}}},"df":0,"docs":{},"o":{"a":{"d":{"df":4,"docs":{"162":{"tf":1.0},"200":{"tf":1.7320508075688772},"213":{"tf":1.0},"215":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":7,"docs":{"115":{"tf":1.0},"116":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"196":{"tf":1.0},"321":{"tf":1.0},"43":{"tf":1.0}}}}},"df":1,"docs":{"115":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"194":{"tf":1.0}}}}}}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"317":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}}}}}},"w":{"df":0,"docs":{},"n":{"df":11,"docs":{"164":{"tf":1.4142135623730951},"167":{"tf":1.4142135623730951},"192":{"tf":1.7320508075688772},"202":{"tf":1.0},"266":{"tf":1.0},"280":{"tf":1.0},"283":{"tf":1.0},"286":{"tf":1.0},"31":{"tf":1.0},"95":{"tf":1.0},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"(":{"1":{"8":{"df":1,"docs":{"181":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"181":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},".":{"a":{"d":{"d":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"181":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"181":{"tf":1.0}}}}}}}},"df":4,"docs":{"167":{"tf":1.4142135623730951},"174":{"tf":1.0},"181":{"tf":1.4142135623730951},"270":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":15,"docs":{"0":{"tf":1.0},"138":{"tf":1.0},"142":{"tf":1.0},"163":{"tf":1.0},"167":{"tf":2.0},"168":{"tf":1.4142135623730951},"169":{"tf":1.0},"171":{"tf":2.0},"270":{"tf":1.0},"272":{"tf":1.4142135623730951},"276":{"tf":1.4142135623730951},"279":{"tf":1.0},"287":{"tf":1.0},"38":{"tf":1.0},"97":{"tf":1.0}}}}}}}}}}},"p":{"1":{"df":1,"docs":{"95":{"tf":1.7320508075688772}}},"2":{"df":1,"docs":{"95":{"tf":1.7320508075688772}}},"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":8,"docs":{"0":{"tf":1.0},"124":{"tf":1.4142135623730951},"125":{"tf":2.23606797749979},"128":{"tf":1.4142135623730951},"129":{"tf":1.0},"132":{"tf":1.0},"242":{"tf":1.0},"309":{"tf":1.4142135623730951}},"e":{"'":{"df":1,"docs":{"129":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"d":{"df":2,"docs":{"17":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":2,"docs":{"331":{"tf":1.0},"332":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"125":{"tf":1.0}}},"r":{"(":{"1":{"df":1,"docs":{"28":{"tf":1.0}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"1":{"df":2,"docs":{"207":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":2,"docs":{"207":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}}}},"i":{"3":{"2":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}},".":{"0":{"df":1,"docs":{"28":{"tf":1.0}}},"1":{"df":1,"docs":{"28":{"tf":1.0}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}},"df":9,"docs":{"175":{"tf":1.0},"207":{"tf":2.8284271247461903},"218":{"tf":1.0},"24":{"tf":2.0},"262":{"tf":1.0},"267":{"tf":1.0},"28":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951},"95":{"tf":2.23606797749979}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{".":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"(":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"261":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"(":{")":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"261":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}}},"df":2,"docs":{"261":{"tf":1.4142135623730951},"289":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"i":{"c":{"!":{"(":{"\"":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"a":{"df":2,"docs":{"221":{"tf":1.0},"223":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":2.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":3,"docs":{"283":{"tf":1.4142135623730951},"284":{"tf":1.4142135623730951},"289":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"302":{"tf":1.4142135623730951},"305":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"266":{"tf":1.0}}}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"288":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"280":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"113":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"df":0,"docs":{},"r":{"df":1,"docs":{"266":{"tf":1.0}},"s":{":":{"5":{"df":1,"docs":{"266":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"=":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"222":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":20,"docs":{"220":{"tf":1.4142135623730951},"221":{"tf":2.0},"222":{"tf":2.0},"223":{"tf":2.449489742783178},"235":{"tf":1.7320508075688772},"240":{"tf":1.0},"241":{"tf":1.4142135623730951},"248":{"tf":1.0},"260":{"tf":1.0},"263":{"tf":1.7320508075688772},"264":{"tf":1.7320508075688772},"265":{"tf":1.0},"266":{"tf":3.0},"286":{"tf":1.0},"300":{"tf":1.4142135623730951},"302":{"tf":2.449489742783178},"303":{"tf":1.7320508075688772},"305":{"tf":2.0},"306":{"tf":1.0},"90":{"tf":1.0}},"k":{"df":6,"docs":{"237":{"tf":1.0},"240":{"tf":1.0},"241":{"tf":1.0},"266":{"tf":1.0},"279":{"tf":1.0},"300":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"276":{"tf":1.0}}}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":18,"docs":{"101":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951},"105":{"tf":1.7320508075688772},"129":{"tf":1.0},"136":{"tf":3.0},"138":{"tf":3.1622776601683795},"140":{"tf":1.0},"142":{"tf":1.4142135623730951},"144":{"tf":1.0},"150":{"tf":1.0},"159":{"tf":2.8284271247461903},"161":{"tf":2.0},"177":{"tf":1.7320508075688772},"232":{"tf":1.0},"260":{"tf":1.0},"294":{"tf":1.0},"302":{"tf":1.0},"99":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"88":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"276":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"115":{"tf":2.0},"119":{"tf":1.0},"169":{"tf":1.0},"220":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":2,"docs":{"24":{"tf":1.4142135623730951},"63":{"tf":1.0}}}}}}}},"i":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"s":{"df":12,"docs":{"235":{"tf":2.23606797749979},"237":{"tf":1.4142135623730951},"243":{"tf":1.0},"244":{"tf":1.0},"245":{"tf":1.0},"248":{"tf":1.7320508075688772},"250":{"tf":2.0},"296":{"tf":2.0},"3":{"tf":1.0},"5":{"tf":1.0},"60":{"tf":2.23606797749979},"90":{"tf":1.4142135623730951}},"e":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"250":{"tf":1.0}}}}}}}}}}}}}},"df":0,"docs":{}}},":":{":":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"243":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"205":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"205":{"tf":1.0}}},"df":0,"docs":{}}}},":":{":":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{">":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"205":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"r":{"df":1,"docs":{"205":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":9,"docs":{"236":{"tf":1.0},"237":{"tf":2.23606797749979},"238":{"tf":1.4142135623730951},"240":{"tf":1.4142135623730951},"241":{"tf":1.4142135623730951},"242":{"tf":1.4142135623730951},"243":{"tf":1.0},"244":{"tf":1.4142135623730951},"250":{"tf":2.0}}}}}}}}}}}},"t":{"df":16,"docs":{"0":{"tf":1.0},"130":{"tf":1.0},"163":{"tf":1.0},"169":{"tf":1.7320508075688772},"190":{"tf":1.0},"200":{"tf":1.0},"217":{"tf":1.0},"218":{"tf":1.0},"26":{"tf":1.0},"263":{"tf":1.0},"303":{"tf":1.0},"308":{"tf":1.0},"316":{"tf":1.0},"54":{"tf":1.0},"62":{"tf":1.0},"84":{"tf":1.0}},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"152":{"tf":1.0},"169":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"q":{"df":4,"docs":{"197":{"tf":1.4142135623730951},"268":{"tf":1.0},"57":{"tf":1.0},"88":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"197":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"316":{"tf":1.0},"53":{"tf":1.0},"95":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"238":{"tf":1.0},"316":{"tf":1.0},"326":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"222":{"tf":1.4142135623730951}},"t":{"df":1,"docs":{"256":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"256":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"x":{"(":{"&":{"df":0,"docs":{},"x":{"df":1,"docs":{"179":{"tf":1.0}}}},"df":0,"docs":{}},"<":{"'":{"a":{"df":1,"docs":{"179":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":38,"docs":{"103":{"tf":1.0},"108":{"tf":1.0},"121":{"tf":1.0},"122":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.4142135623730951},"132":{"tf":1.0},"135":{"tf":1.0},"138":{"tf":1.0},"142":{"tf":1.0},"167":{"tf":1.0},"171":{"tf":1.4142135623730951},"174":{"tf":1.0},"177":{"tf":1.0},"179":{"tf":1.0},"192":{"tf":1.4142135623730951},"217":{"tf":1.0},"230":{"tf":1.0},"233":{"tf":1.0},"237":{"tf":1.0},"276":{"tf":1.7320508075688772},"287":{"tf":1.0},"288":{"tf":1.0},"294":{"tf":1.0},"296":{"tf":2.0},"300":{"tf":1.0},"302":{"tf":1.4142135623730951},"303":{"tf":2.0},"304":{"tf":2.0},"305":{"tf":1.4142135623730951},"308":{"tf":1.7320508075688772},"313":{"tf":1.0},"322":{"tf":1.0},"324":{"tf":1.0},"329":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"95":{"tf":1.0}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"1":{"2":{"3":{"df":1,"docs":{"268":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"268":{"tf":2.23606797749979}}},"df":0,"docs":{}}}}},"t":{"df":1,"docs":{"31":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"214":{"tf":1.0}},"h":{".":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"280":{"tf":1.0},"283":{"tf":1.0},"284":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"\"":{"a":{"\"":{")":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"\"":{"b":{"df":1,"docs":{"280":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"(":{")":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"291":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"\"":{"a":{"/":{"b":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"\"":{")":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"291":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"283":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"284":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"280":{"tf":1.0}}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":1,"docs":{"280":{"tf":2.6457513110645907}}}}},"df":15,"docs":{"115":{"tf":2.0},"118":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"123":{"tf":1.0},"125":{"tf":1.4142135623730951},"214":{"tf":1.0},"222":{"tf":1.0},"280":{"tf":4.58257569495584},"282":{"tf":1.0},"283":{"tf":1.7320508075688772},"284":{"tf":1.0},"287":{"tf":1.0},"291":{"tf":3.1622776601683795},"294":{"tf":1.7320508075688772},"49":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":17,"docs":{"127":{"tf":1.0},"154":{"tf":1.0},"169":{"tf":1.0},"175":{"tf":1.4142135623730951},"194":{"tf":1.4142135623730951},"213":{"tf":1.0},"214":{"tf":1.0},"219":{"tf":1.0},"237":{"tf":1.0},"263":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0},"90":{"tf":1.7320508075688772}}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"196":{"tf":1.0}}}}},"df":4,"docs":{"110":{"tf":1.4142135623730951},"224":{"tf":1.0},"287":{"tf":1.4142135623730951},"291":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"225":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"225":{"tf":2.0}},"e":{"d":{"(":{"df":0,"docs":{},"f":{"df":1,"docs":{"225":{"tf":1.0}},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"225":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"113":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":10,"docs":{"159":{"tf":1.0},"261":{"tf":1.0},"270":{"tf":1.0},"286":{"tf":1.0},"287":{"tf":1.0},"300":{"tf":1.0},"314":{"tf":1.0},"317":{"tf":1.0},"48":{"tf":1.4142135623730951},"70":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"128":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"95":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":2,"docs":{"169":{"tf":1.7320508075688772},"224":{"tf":1.0}}},".":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"169":{"tf":2.23606797749979}}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"\"":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":1,"docs":{"329":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"329":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"'":{"a":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":7,"docs":{"169":{"tf":3.3166247903554},"208":{"tf":2.0},"224":{"tf":1.7320508075688772},"28":{"tf":1.4142135623730951},"329":{"tf":3.0},"8":{"tf":1.0},"86":{"tf":1.4142135623730951}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"154":{"tf":1.0}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"28":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}}}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"<":{"b":{"df":1,"docs":{"159":{"tf":1.4142135623730951}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"161":{"tf":1.0}}}}}}},"df":2,"docs":{"159":{"tf":2.0},"161":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"159":{"tf":2.8284271247461903},"161":{"tf":2.0}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"<":{"a":{"df":1,"docs":{"159":{"tf":1.0}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"159":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"159":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"159":{"tf":1.4142135623730951}},"e":{"(":{"'":{"df":0,"docs":{},"q":{"df":1,"docs":{"159":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"<":{"a":{"df":1,"docs":{"159":{"tf":1.0}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"159":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"276":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"224":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":1,"docs":{"224":{"tf":1.0}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"224":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"279":{"tf":1.0}}}},"df":1,"docs":{"6":{"tf":1.7320508075688772}},"e":{"c":{"df":1,"docs":{"127":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"289":{"tf":1.7320508075688772},"97":{"tf":1.0}}}},"t":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"220":{"tf":1.0}}}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"z":{"a":{"df":1,"docs":{"267":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":19,"docs":{"113":{"tf":1.0},"121":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.0},"130":{"tf":1.4142135623730951},"131":{"tf":1.0},"212":{"tf":1.0},"229":{"tf":1.0},"232":{"tf":1.4142135623730951},"233":{"tf":1.0},"280":{"tf":1.0},"311":{"tf":1.0},"32":{"tf":1.0},"323":{"tf":1.4142135623730951},"326":{"tf":1.4142135623730951},"336":{"tf":1.4142135623730951},"6":{"tf":1.0},"61":{"tf":1.0},"70":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"280":{"tf":1.0}}}}}}},"y":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"336":{"tf":1.0}}}},"df":0,"docs":{}},"df":4,"docs":{"0":{"tf":1.0},"163":{"tf":1.0},"262":{"tf":1.0},"268":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"327":{"tf":1.4142135623730951},"335":{"tf":1.4142135623730951},"337":{"tf":1.0},"338":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":5,"docs":{"220":{"tf":1.0},"250":{"tf":1.0},"267":{"tf":1.0},"300":{"tf":1.0},"42":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":1,"docs":{"5":{"tf":1.0}},"s":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"206":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"i":{"df":3,"docs":{"174":{"tf":1.0},"175":{"tf":1.0},"28":{"tf":1.4142135623730951}}},"x":{"df":2,"docs":{"175":{"tf":1.0},"28":{"tf":1.0}}},"z":{"df":1,"docs":{"174":{"tf":1.7320508075688772}}}},"2":{"d":{"df":2,"docs":{"10":{"tf":2.23606797749979},"11":{"tf":1.0}}},"df":0,"docs":{}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"1":{".":{"0":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{".":{"0":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}},"df":29,"docs":{"10":{"tf":2.449489742783178},"167":{"tf":1.0},"171":{"tf":1.0},"174":{"tf":3.1622776601683795},"175":{"tf":3.1622776601683795},"191":{"tf":1.4142135623730951},"199":{"tf":1.0},"20":{"tf":1.0},"203":{"tf":1.0},"223":{"tf":1.0},"240":{"tf":1.0},"259":{"tf":3.605551275463989},"26":{"tf":1.0},"261":{"tf":1.0},"262":{"tf":1.0},"266":{"tf":1.4142135623730951},"268":{"tf":1.0},"269":{"tf":1.0},"279":{"tf":1.0},"28":{"tf":4.123105625617661},"280":{"tf":1.0},"29":{"tf":1.4142135623730951},"312":{"tf":1.0},"313":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"65":{"tf":1.0},"95":{"tf":3.7416573867739413}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"272":{"tf":1.0}}},"df":20,"docs":{"167":{"tf":2.0},"175":{"tf":1.0},"199":{"tf":1.0},"20":{"tf":1.4142135623730951},"257":{"tf":1.0},"259":{"tf":1.7320508075688772},"26":{"tf":1.0},"260":{"tf":1.0},"270":{"tf":1.0},"272":{"tf":1.7320508075688772},"276":{"tf":1.0},"311":{"tf":1.0},"312":{"tf":1.7320508075688772},"313":{"tf":1.7320508075688772},"319":{"tf":1.7320508075688772},"320":{"tf":1.0},"324":{"tf":1.4142135623730951},"38":{"tf":1.0},"73":{"tf":1.0},"80":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"80":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":2.0}}}},"p":{"df":2,"docs":{"260":{"tf":1.0},"319":{"tf":2.0}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"125":{"tf":1.0},"295":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"318":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":10,"docs":{"10":{"tf":1.0},"110":{"tf":1.4142135623730951},"133":{"tf":1.0},"245":{"tf":1.0},"26":{"tf":1.4142135623730951},"260":{"tf":1.0},"265":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"63":{"tf":1.0}}},"x":{":":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"280":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":28,"docs":{"105":{"tf":1.4142135623730951},"113":{"tf":1.4142135623730951},"133":{"tf":1.0},"164":{"tf":1.0},"174":{"tf":1.4142135623730951},"179":{"tf":1.0},"189":{"tf":1.0},"199":{"tf":1.0},"20":{"tf":1.0},"200":{"tf":1.0},"220":{"tf":1.0},"223":{"tf":1.4142135623730951},"235":{"tf":2.0},"240":{"tf":1.0},"241":{"tf":1.4142135623730951},"266":{"tf":1.0},"268":{"tf":1.0},"286":{"tf":1.0},"315":{"tf":1.0},"316":{"tf":1.0},"317":{"tf":1.0},"325":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.0},"65":{"tf":1.0},"72":{"tf":1.4142135623730951},"97":{"tf":1.0},"99":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"225":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"114":{"tf":1.0},"212":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"156":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":5,"docs":{"136":{"tf":1.4142135623730951},"138":{"tf":1.4142135623730951},"140":{"tf":1.0},"212":{"tf":1.0},"23":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"268":{"tf":1.0},"297":{"tf":1.7320508075688772}}}}},"d":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"108":{"tf":1.0},"110":{"tf":1.0}}},"df":0,"docs":{}}},"df":2,"docs":{"128":{"tf":1.0},"129":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"1":{"tf":1.0},"38":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"97":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"x":{"df":5,"docs":{"122":{"tf":1.0},"129":{"tf":1.0},"214":{"tf":1.0},"23":{"tf":1.0},"42":{"tf":1.4142135623730951}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"280":{"tf":1.0}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"212":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"10":{"tf":1.0},"237":{"tf":1.4142135623730951},"245":{"tf":1.0},"269":{"tf":1.4142135623730951},"305":{"tf":1.0}}}},"r":{"df":0,"docs":{},"v":{"df":3,"docs":{"246":{"tf":1.0},"319":{"tf":1.0},"320":{"tf":1.7320508075688772}}}}},"s":{"df":1,"docs":{"31":{"tf":1.0}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":3,"docs":{"265":{"tf":1.4142135623730951},"50":{"tf":1.0},"8":{"tf":1.4142135623730951}}},"y":{"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"309":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{":":{":":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":1,"docs":{"309":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"119":{"tf":1.0},"167":{"tf":1.0},"276":{"tf":1.4142135623730951},"332":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":25,"docs":{"126":{"tf":1.0},"158":{"tf":1.0},"167":{"tf":1.4142135623730951},"212":{"tf":1.0},"219":{"tf":1.0},"222":{"tf":1.0},"225":{"tf":1.0},"237":{"tf":1.0},"240":{"tf":1.4142135623730951},"242":{"tf":1.0},"243":{"tf":1.0},"248":{"tf":1.4142135623730951},"254":{"tf":1.0},"283":{"tf":1.0},"284":{"tf":1.0},"288":{"tf":1.0},"291":{"tf":1.0},"3":{"tf":1.0},"301":{"tf":1.0},"311":{"tf":1.0},"324":{"tf":1.0},"44":{"tf":1.0},"49":{"tf":1.0},"88":{"tf":1.0},"95":{"tf":1.0}},"s":{"df":3,"docs":{"136":{"tf":1.0},"248":{"tf":1.0},"90":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"269":{"tf":1.0},"305":{"tf":1.0},"311":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"72":{"tf":1.4142135623730951}}},"i":{"df":0,"docs":{},"t":{"df":13,"docs":{"0":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"257":{"tf":1.0},"258":{"tf":1.0},"273":{"tf":1.0},"274":{"tf":1.0},"276":{"tf":1.4142135623730951},"314":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"!":{"(":{"\"":{"c":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"115":{"tf":1.7320508075688772},"119":{"tf":1.0},"120":{"tf":1.0},"122":{"tf":1.0},"132":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"288":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"w":{"c":{"df":1,"docs":{"289":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"(":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":4,"docs":{"245":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.0},"250":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":4,"docs":{"245":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.0},"250":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":4,"docs":{"245":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.0},"250":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"(":{"\"":{"1":{"0":{"df":4,"docs":{"238":{"tf":1.0},"240":{"tf":1.0},"241":{"tf":1.0},"242":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":4,"docs":{"238":{"tf":1.0},"240":{"tf":1.0},"241":{"tf":1.0},"242":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"x":{"df":1,"docs":{"187":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":9,"docs":{"237":{"tf":1.4142135623730951},"238":{"tf":1.0},"240":{"tf":1.0},"241":{"tf":1.0},"242":{"tf":1.0},"245":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.0},"250":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"237":{"tf":1.4142135623730951}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"237":{"tf":1.4142135623730951}}}}}}}}},"<":{"'":{"a":{">":{"(":{"&":{"'":{"a":{"df":1,"docs":{"181":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"t":{">":{"(":{"df":0,"docs":{},"t":{"df":1,"docs":{"187":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"_":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"(":{"&":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"144":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"144":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"144":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"150":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"t":{"(":{"&":{"df":0,"docs":{},"i":{"df":1,"docs":{"192":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"192":{"tf":1.0}}}},"df":1,"docs":{"192":{"tf":1.0}}}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"(":{"&":{"df":0,"docs":{},"x":{"df":1,"docs":{"179":{"tf":1.0}}}},"df":0,"docs":{}},"<":{"'":{"a":{"df":1,"docs":{"179":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"t":{"df":1,"docs":{"179":{"tf":1.0}}},"x":{"df":1,"docs":{"179":{"tf":1.0}}}},"df":0,"docs":{},"z":{"df":1,"docs":{"179":{"tf":1.0}}}},"<":{"'":{"a":{">":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"179":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{"&":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"x":{"df":1,"docs":{"187":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"'":{"a":{"df":1,"docs":{"187":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"177":{"tf":1.7320508075688772}},"s":{"(":{"&":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"177":{"tf":1.0}}}}}}},"df":0,"docs":{}},"<":{"'":{"a":{"df":1,"docs":{"177":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"!":{"(":{"1":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"214":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"214":{"tf":1.4142135623730951}}}}}}}}},"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"24":{"tf":1.0},"8":{"tf":2.449489742783178}}}},"df":0,"docs":{}},"df":36,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":1.0},"101":{"tf":1.7320508075688772},"11":{"tf":1.0},"115":{"tf":1.0},"127":{"tf":1.4142135623730951},"129":{"tf":1.0},"14":{"tf":1.0},"144":{"tf":1.4142135623730951},"150":{"tf":1.0},"152":{"tf":1.0},"174":{"tf":1.0},"187":{"tf":1.0},"191":{"tf":1.0},"197":{"tf":1.4142135623730951},"202":{"tf":1.4142135623730951},"214":{"tf":1.0},"218":{"tf":1.0},"221":{"tf":1.0},"236":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.4142135623730951},"262":{"tf":1.0},"269":{"tf":2.23606797749979},"272":{"tf":1.0},"28":{"tf":1.0},"283":{"tf":1.0},"287":{"tf":1.0},"38":{"tf":1.4142135623730951},"5":{"tf":3.0},"59":{"tf":1.4142135623730951},"6":{"tf":1.0},"63":{"tf":1.7320508075688772},"8":{"tf":2.449489742783178},"88":{"tf":1.0},"97":{"tf":2.6457513110645907}},"e":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"144":{"tf":1.0}}}},"df":1,"docs":{"144":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"150":{"tf":1.4142135623730951}}}}}}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"0":{"0":{"1":{"1":{"df":1,"docs":{"23":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"x":{"8":{"0":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"1":{"0":{"0":{"0":{"df":1,"docs":{"48":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"23":{"tf":1.7320508075688772}},"e":{"4":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}}},"2":{"df":1,"docs":{"108":{"tf":2.0}}},"3":{"df":1,"docs":{"99":{"tf":1.0}}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"1":{"df":1,"docs":{"159":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"159":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"`":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"194":{"tf":1.0}}}}}}},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"194":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"c":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"291":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"97":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"97":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":1,"docs":{"291":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"194":{"tf":1.0}}}}}}},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"194":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"i":{"df":1,"docs":{"92":{"tf":1.4142135623730951}}},"l":{"df":1,"docs":{"291":{"tf":1.0}},"n":{"df":1,"docs":{"291":{"tf":1.0}}}},"m":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"291":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"97":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"179":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"179":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"187":{"tf":1.0}}}}}},"df":2,"docs":{"181":{"tf":1.0},"187":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"m":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"291":{"tf":1.0}}}}},"df":1,"docs":{"291":{"tf":1.0}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"291":{"tf":1.0}}}},"df":0,"docs":{}}}}},"a":{"df":8,"docs":{"146":{"tf":1.7320508075688772},"167":{"tf":1.4142135623730951},"262":{"tf":1.0},"269":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"72":{"tf":1.0},"88":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"df":1,"docs":{"206":{"tf":1.0}},"i":{"c":{"df":1,"docs":{"261":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"d":{"df":1,"docs":{"262":{"tf":1.0}}},"df":1,"docs":{"42":{"tf":1.0}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"45":{"tf":1.4142135623730951}}}}}},"r":{"df":1,"docs":{"133":{"tf":1.0}},"e":{"a":{"df":1,"docs":{"144":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"g":{"df":1,"docs":{"320":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"y":{"[":{"0":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"268":{"tf":1.0}}}}}}}}},"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"200":{"tf":1.0}}},"s":{"df":1,"docs":{"5":{"tf":2.23606797749979}}}},"df":4,"docs":{"167":{"tf":1.0},"185":{"tf":1.0},"269":{"tf":1.0},"88":{"tf":1.0}},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"43":{"tf":1.0},"44":{"tf":1.0}}}}}},"o":{"b":{"df":1,"docs":{"261":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"1":{"df":1,"docs":{"176":{"tf":1.0}}},"2":{"df":1,"docs":{"176":{"tf":1.0}}},"df":1,"docs":{"26":{"tf":1.4142135623730951}}}}}},"x":{"df":1,"docs":{"259":{"tf":1.7320508075688772}}}},"u":{"df":0,"docs":{},"z":{"df":0,"docs":{},"z":{"df":3,"docs":{"67":{"tf":1.0},"69":{"tf":1.4142135623730951},"94":{"tf":1.0}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":7,"docs":{"115":{"tf":3.1622776601683795},"118":{"tf":1.4142135623730951},"119":{"tf":2.0},"120":{"tf":2.449489742783178},"122":{"tf":1.4142135623730951},"132":{"tf":1.4142135623730951},"267":{"tf":1.7320508075688772}}},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":1,"docs":{"88":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"207":{"tf":1.0}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"96":{"tf":1.0}},"e":{"_":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"96":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"o":{"df":1,"docs":{"297":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"191":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"260":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"135":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"260":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"262":{"tf":1.4142135623730951}}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"207":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":1,"docs":{"319":{"tf":1.0}}}},"y":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"276":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"148":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":3,"docs":{"167":{"tf":1.0},"171":{"tf":1.0},"95":{"tf":1.0}}}}}}}},"i":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"269":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"148":{"tf":1.0}}}},"df":0,"docs":{}}}}},"o":{"df":2,"docs":{"156":{"tf":1.0},"158":{"tf":1.0}},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"267":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"235":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"268":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"d":{"df":1,"docs":{"202":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":2,"docs":{"118":{"tf":1.0},"65":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":11,"docs":{"237":{"tf":1.4142135623730951},"238":{"tf":1.0},"240":{"tf":1.0},"241":{"tf":1.0},"242":{"tf":1.0},"245":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.0},"250":{"tf":1.0},"254":{"tf":1.0},"256":{"tf":1.4142135623730951}}}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"202":{"tf":1.4142135623730951},"65":{"tf":1.0}}}}}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"110":{"tf":2.0},"112":{"tf":1.0}}},"df":1,"docs":{"276":{"tf":1.0}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"230":{"tf":1.0},"231":{"tf":1.0},"232":{"tf":1.0},"233":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":6,"docs":{"108":{"tf":1.4142135623730951},"156":{"tf":1.0},"158":{"tf":1.0},"26":{"tf":1.4142135623730951},"74":{"tf":1.7320508075688772},"82":{"tf":1.0}}}}},"z":{"df":0,"docs":{},"z":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"z":{"df":0,"docs":{},"z":{"df":3,"docs":{"67":{"tf":1.0},"69":{"tf":1.4142135623730951},"94":{"tf":1.0}}}}}},"df":3,"docs":{"67":{"tf":1.0},"69":{"tf":1.4142135623730951},"94":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"200":{"tf":1.0}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"203":{"tf":1.0}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"260":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"84":{"tf":1.0},"92":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":8,"docs":{"1":{"tf":1.0},"212":{"tf":1.4142135623730951},"236":{"tf":1.0},"3":{"tf":1.0},"329":{"tf":1.0},"336":{"tf":1.0},"337":{"tf":1.0},"70":{"tf":1.4142135623730951}}}}}},"u":{"df":1,"docs":{"78":{"tf":1.4142135623730951}}}},"i":{"'":{"df":0,"docs":{},"m":{"df":2,"docs":{"103":{"tf":1.4142135623730951},"86":{"tf":1.7320508075688772}}}},"df":10,"docs":{"172":{"tf":1.4142135623730951},"183":{"tf":1.0},"223":{"tf":1.0},"294":{"tf":1.0},"3":{"tf":1.0},"61":{"tf":1.0},"82":{"tf":1.7320508075688772},"86":{"tf":1.0},"88":{"tf":1.0},"99":{"tf":1.0}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"168":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"df":1,"docs":{"112":{"tf":1.0}}}},"n":{"df":1,"docs":{"260":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"260":{"tf":1.0}}}}},"n":{"df":1,"docs":{"44":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"269":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"t":{"df":1,"docs":{"74":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"203":{"tf":1.4142135623730951}}}}}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"202":{"tf":1.4142135623730951},"24":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"156":{"tf":1.0},"158":{"tf":1.0},"74":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"118":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"270":{"tf":1.0}}}}}},"t":{"'":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"38":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"268":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}}},"m":{"a":{"d":{"df":1,"docs":{"165":{"tf":1.0}}},"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"88":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{":":{"\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}}},"i":{"df":5,"docs":{"294":{"tf":1.0},"296":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0}}},"m":{"df":0,"docs":{},"m":{"df":1,"docs":{"225":{"tf":1.0}}}},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"207":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"168":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"175":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"y":{"_":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"233":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"232":{"tf":1.0},"233":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"268":{"tf":1.0},"70":{"tf":1.7320508075688772}}}},"df":5,"docs":{"237":{"tf":1.4142135623730951},"238":{"tf":1.0},"240":{"tf":1.0},"241":{"tf":1.0},"242":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}},"w":{"df":1,"docs":{"280":{"tf":1.0}}}},"o":{"df":1,"docs":{"223":{"tf":1.0}},"t":{"df":2,"docs":{"23":{"tf":1.0},"86":{"tf":1.0}}},"w":{"df":2,"docs":{"8":{"tf":1.4142135623730951},"99":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":3,"docs":{"254":{"tf":1.0},"256":{"tf":1.4142135623730951},"26":{"tf":1.0}}},"df":1,"docs":{"191":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"h":{"df":2,"docs":{"225":{"tf":1.0},"227":{"tf":1.0}}},"k":{"df":1,"docs":{"64":{"tf":1.0}}},"l":{"d":{"df":1,"docs":{"152":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"n":{"df":6,"docs":{"161":{"tf":1.4142135623730951},"197":{"tf":1.7320508075688772},"23":{"tf":1.0},"24":{"tf":1.0},"36":{"tf":1.0},"72":{"tf":1.0}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"207":{"tf":1.7320508075688772}}}}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"44":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}}}}}},"p":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"24":{"tf":1.0},"28":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"261":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"268":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"174":{"tf":2.23606797749979},"175":{"tf":1.0},"259":{"tf":1.0},"28":{"tf":1.0}}}}},"p":{"df":1,"docs":{"260":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"31":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"276":{"tf":1.0}}}}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"231":{"tf":1.4142135623730951},"233":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"260":{"tf":1.0}}}}}},"r":{"c":{"_":{"a":{"df":1,"docs":{"270":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"270":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"78":{"tf":1.0}},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"290":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"259":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"_":{"c":{"1":{"df":1,"docs":{"175":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"270":{"tf":2.0}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":3,"docs":{"252":{"tf":1.0},"253":{"tf":1.0},"255":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"26":{"tf":1.0},"260":{"tf":1.0},"28":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"289":{"tf":1.0}}}}},"h":{"a":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"_":{"b":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"233":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"49":{"tf":2.23606797749979}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"26":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"df":3,"docs":{"221":{"tf":1.0},"222":{"tf":1.4142135623730951},"262":{"tf":1.0}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"222":{"tf":1.4142135623730951}}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"191":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"u":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"268":{"tf":1.0}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"284":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":2,"docs":{"113":{"tf":1.0},"60":{"tf":1.0}}}},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"269":{"tf":1.0}}}}}}}}},"t":{"df":1,"docs":{"148":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":3,"docs":{"72":{"tf":1.0},"74":{"tf":1.0},"86":{"tf":1.0}}}},"h":{"df":20,"docs":{"10":{"tf":1.0},"116":{"tf":1.4142135623730951},"156":{"tf":1.0},"158":{"tf":1.0},"169":{"tf":2.0},"189":{"tf":1.0},"203":{"tf":1.4142135623730951},"24":{"tf":1.0},"243":{"tf":1.7320508075688772},"244":{"tf":2.449489742783178},"245":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.0},"250":{"tf":1.0},"26":{"tf":1.0},"297":{"tf":1.0},"34":{"tf":1.4142135623730951},"40":{"tf":1.0},"78":{"tf":1.7320508075688772},"86":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"99":{"tf":1.0}}},"r":{"df":1,"docs":{"70":{"tf":1.4142135623730951}},"e":{"'":{"df":0,"docs":{},"r":{"df":1,"docs":{"97":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"df":12,"docs":{"105":{"tf":1.7320508075688772},"113":{"tf":1.0},"171":{"tf":1.0},"222":{"tf":1.4142135623730951},"266":{"tf":1.0},"275":{"tf":1.0},"296":{"tf":1.4142135623730951},"40":{"tf":1.0},"5":{"tf":1.0},"65":{"tf":1.0},"72":{"tf":1.0},"88":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"279":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"64":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"165":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":1,"docs":{"24":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{"\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"u":{"df":1,"docs":{"23":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"175":{"tf":1.0},"24":{"tf":1.0}}}}}},"u":{"df":1,"docs":{"148":{"tf":1.0}},"n":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"259":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"262":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"269":{"tf":1.0}}}}}},"p":{"d":{"df":1,"docs":{"260":{"tf":1.0}}},"df":0,"docs":{}},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"296":{"tf":1.0}}}},"df":1,"docs":{"261":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"268":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"270":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"230":{"tf":1.0},"232":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"1":{"df":1,"docs":{"108":{"tf":1.0}}},"2":{"df":1,"docs":{"108":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"260":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"w":{"df":1,"docs":{"80":{"tf":1.0}},"h":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"262":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"261":{"tf":1.0}}},"df":0,"docs":{}}}},"x":{"df":4,"docs":{"167":{"tf":1.0},"177":{"tf":1.0},"183":{"tf":1.7320508075688772},"61":{"tf":1.0}}},"y":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"227":{"tf":1.0}}}},"df":1,"docs":{"133":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"u":{"'":{"df":0,"docs":{},"v":{"df":1,"docs":{"199":{"tf":1.0}}}},"df":3,"docs":{"113":{"tf":1.0},"133":{"tf":1.4142135623730951},"214":{"tf":1.0}}}},"u":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"223":{"tf":1.0}}}},"df":0,"docs":{}}},"z":{"df":1,"docs":{"61":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":2,"docs":{"36":{"tf":1.0},"84":{"tf":1.0}}}}}},"{":{"0":{"df":1,"docs":{"5":{"tf":1.0}}},"1":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{"0":{"<":{"5":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},">":{"5":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"5":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},">":{"5":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"5":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"}":{"c":{"df":1,"docs":{"84":{"tf":1.4142135623730951}}},"df":0,"docs":{},"f":{"df":1,"docs":{"84":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":59,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"101":{"tf":1.0},"13":{"tf":1.0},"140":{"tf":1.0},"144":{"tf":1.4142135623730951},"150":{"tf":1.0},"16":{"tf":1.4142135623730951},"174":{"tf":1.4142135623730951},"189":{"tf":1.0},"192":{"tf":1.0},"196":{"tf":2.0},"2":{"tf":1.0},"200":{"tf":1.4142135623730951},"202":{"tf":1.0},"203":{"tf":2.8284271247461903},"210":{"tf":1.0},"212":{"tf":1.0},"214":{"tf":1.0},"215":{"tf":1.4142135623730951},"216":{"tf":1.7320508075688772},"218":{"tf":1.0},"219":{"tf":1.4142135623730951},"223":{"tf":1.0},"236":{"tf":1.0},"24":{"tf":1.4142135623730951},"250":{"tf":1.0},"26":{"tf":1.7320508075688772},"260":{"tf":1.0},"261":{"tf":1.0},"262":{"tf":2.23606797749979},"263":{"tf":2.0},"264":{"tf":1.0},"265":{"tf":1.0},"270":{"tf":2.0},"272":{"tf":1.0},"276":{"tf":1.0},"279":{"tf":1.0},"28":{"tf":1.0},"287":{"tf":1.0},"291":{"tf":3.4641016151377544},"296":{"tf":1.4142135623730951},"38":{"tf":1.0},"40":{"tf":1.0},"48":{"tf":3.1622776601683795},"5":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"63":{"tf":1.7320508075688772},"64":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.4142135623730951},"72":{"tf":1.0},"76":{"tf":2.0},"8":{"tf":1.4142135623730951},"94":{"tf":1.0},"97":{"tf":1.7320508075688772}}}}}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"129":{"tf":1.0},"222":{"tf":1.0}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"115":{"tf":3.3166247903554},"116":{"tf":2.6457513110645907},"123":{"tf":1.0},"300":{"tf":1.0},"308":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"115":{"tf":2.23606797749979},"120":{"tf":1.7320508075688772},"122":{"tf":1.7320508075688772},"123":{"tf":1.4142135623730951},"132":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"o":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"282":{"tf":1.0}}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"220":{"tf":1.0}}}},"df":7,"docs":{"10":{"tf":1.4142135623730951},"128":{"tf":1.0},"13":{"tf":1.0},"156":{"tf":1.0},"220":{"tf":1.0},"243":{"tf":1.0},"8":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"225":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"225":{"tf":1.0}}}}},"df":0,"docs":{}}}}},".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"(":{")":{".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{".":{"a":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"289":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"(":{")":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"289":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},":":{":":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"290":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"288":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":1,"docs":{"290":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"288":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":10,"docs":{"113":{"tf":1.0},"202":{"tf":1.0},"205":{"tf":1.4142135623730951},"220":{"tf":1.0},"225":{"tf":1.4142135623730951},"244":{"tf":1.0},"276":{"tf":2.0},"287":{"tf":1.0},"288":{"tf":2.0},"289":{"tf":2.23606797749979}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":1.0},"319":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":5,"docs":{"1":{"tf":1.0},"112":{"tf":1.0},"121":{"tf":1.0},"203":{"tf":1.0},"276":{"tf":1.0}},"t":{"df":1,"docs":{"189":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"'":{"df":2,"docs":{"191":{"tf":1.0},"313":{"tf":1.0}}},"df":29,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"125":{"tf":2.0},"131":{"tf":1.0},"14":{"tf":1.0},"152":{"tf":1.0},"191":{"tf":1.4142135623730951},"209":{"tf":1.0},"211":{"tf":1.0},"212":{"tf":1.0},"220":{"tf":1.0},"221":{"tf":1.0},"223":{"tf":1.4142135623730951},"235":{"tf":1.0},"26":{"tf":1.0},"263":{"tf":1.0},"266":{"tf":1.4142135623730951},"277":{"tf":1.4142135623730951},"287":{"tf":1.0},"293":{"tf":1.0},"294":{"tf":1.4142135623730951},"296":{"tf":1.0},"298":{"tf":1.0},"3":{"tf":1.0},"326":{"tf":1.0},"327":{"tf":1.0},"329":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0}},"m":{"df":3,"docs":{"208":{"tf":1.7320508075688772},"282":{"tf":1.0},"50":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"313":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":6,"docs":{"125":{"tf":2.8284271247461903},"126":{"tf":1.0},"128":{"tf":1.0},"132":{"tf":1.0},"305":{"tf":1.0},"329":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"268":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"309":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"144":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"311":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"268":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"220":{"tf":1.7320508075688772}}}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":49,"docs":{"0":{"tf":1.0},"112":{"tf":1.0},"114":{"tf":1.0},"127":{"tf":1.0},"129":{"tf":1.4142135623730951},"13":{"tf":1.0},"131":{"tf":1.0},"135":{"tf":1.0},"154":{"tf":1.0},"156":{"tf":1.0},"165":{"tf":1.0},"19":{"tf":1.0},"196":{"tf":1.0},"197":{"tf":1.0},"212":{"tf":1.0},"231":{"tf":1.0},"233":{"tf":1.4142135623730951},"235":{"tf":1.0},"237":{"tf":1.4142135623730951},"250":{"tf":1.0},"257":{"tf":1.0},"273":{"tf":1.4142135623730951},"275":{"tf":1.0},"276":{"tf":1.4142135623730951},"279":{"tf":1.0},"280":{"tf":1.0},"295":{"tf":1.0},"297":{"tf":1.0},"309":{"tf":1.0},"314":{"tf":1.0},"317":{"tf":1.0},"318":{"tf":1.0},"320":{"tf":1.0},"324":{"tf":1.0},"327":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"51":{"tf":1.0},"55":{"tf":1.0},"59":{"tf":1.0},"64":{"tf":1.0},"70":{"tf":1.4142135623730951},"72":{"tf":1.0},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}}}}},"s":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"1":{"2":{"3":{"df":1,"docs":{"268":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"u":{"b":{"(":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":2.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"115":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}}}},"df":24,"docs":{"108":{"tf":1.0},"110":{"tf":1.0},"115":{"tf":2.8284271247461903},"116":{"tf":2.23606797749979},"118":{"tf":1.4142135623730951},"119":{"tf":1.7320508075688772},"120":{"tf":2.23606797749979},"122":{"tf":1.4142135623730951},"132":{"tf":1.4142135623730951},"152":{"tf":1.4142135623730951},"161":{"tf":1.0},"264":{"tf":2.23606797749979},"265":{"tf":1.0},"300":{"tf":1.0},"302":{"tf":1.0},"304":{"tf":1.0},"305":{"tf":1.4142135623730951},"306":{"tf":1.0},"308":{"tf":1.4142135623730951},"309":{"tf":1.0},"329":{"tf":1.7320508075688772},"331":{"tf":1.7320508075688772},"332":{"tf":1.0},"333":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"c":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"114":{"tf":1.0}}}}}}},"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"120":{"tf":1.0},"122":{"tf":1.4142135623730951},"123":{"tf":1.0},"132":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"c":{"df":0,"docs":{},"r":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"115":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":3,"docs":{"115":{"tf":1.7320508075688772},"116":{"tf":3.1622776601683795},"308":{"tf":1.4142135623730951}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"125":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"244":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"324":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":12,"docs":{"13":{"tf":1.0},"212":{"tf":1.0},"241":{"tf":1.0},"300":{"tf":1.0},"306":{"tf":1.0},"308":{"tf":1.0},"316":{"tf":1.0},"318":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"80":{"tf":1.0},"88":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"319":{"tf":1.0}}}}}},"df":3,"docs":{"280":{"tf":1.0},"319":{"tf":2.0},"324":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"319":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"t":{"df":6,"docs":{"127":{"tf":1.0},"311":{"tf":1.0},"316":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0},"8":{"tf":1.0}}}},"y":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"264":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"q":{"df":2,"docs":{"159":{"tf":1.4142135623730951},"175":{"tf":1.0}},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":3,"docs":{"210":{"tf":1.0},"211":{"tf":1.0},"214":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"124":{"tf":1.0},"235":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"238":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"279":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":7,"docs":{"124":{"tf":1.0},"164":{"tf":1.0},"220":{"tf":1.0},"238":{"tf":1.0},"261":{"tf":1.0},"289":{"tf":1.0},"5":{"tf":1.0}}}},"df":1,"docs":{"284":{"tf":2.0}},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"196":{"tf":1.0}}}},"t":{"df":2,"docs":{"206":{"tf":1.0},"92":{"tf":1.7320508075688772}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"262":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"263":{"tf":1.0}}}}}}}},"x":{"(":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"\"":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"262":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"#":{"\"":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"262":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"#":{"#":{"\"":{"a":{"df":1,"docs":{"262":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"*":{"6":{"5":{"5":{"3":{"6":{")":{"+":{"(":{"df":0,"docs":{},"g":{"*":{"2":{"5":{"6":{")":{"+":{"b":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"244":{"tf":1.0}}}}}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"|":{"df":1,"docs":{"254":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"127":{"tf":1.0},"276":{"tf":1.4142135623730951}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"u":{"df":1,"docs":{"59":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"i":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"164":{"tf":1.4142135623730951}}}},"df":1,"docs":{"164":{"tf":2.0}}},"s":{"df":1,"docs":{"51":{"tf":1.0}}}},"n":{"d":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"191":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"191":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":2,"docs":{"125":{"tf":1.0},"191":{"tf":1.0}},"o":{"df":0,"docs":{},"m":{"_":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"199":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"199":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"191":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"199":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{"df":4,"docs":{"10":{"tf":1.0},"203":{"tf":1.0},"69":{"tf":1.7320508075688772},"72":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"123":{"tf":1.0},"132":{"tf":1.4142135623730951}}},"y":{"'":{"df":3,"docs":{"122":{"tf":1.7320508075688772},"123":{"tf":1.7320508075688772},"132":{"tf":1.7320508075688772}}},".":{"df":0,"docs":{},"r":{"df":1,"docs":{"122":{"tf":1.4142135623730951}}}},":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"a":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"123":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"123":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"123":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"=":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"123":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"265":{"tf":1.0}}}}},"w":{"_":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"262":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{},"p":{"df":1,"docs":{"312":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"262":{"tf":1.4142135623730951}}}}}},"df":5,"docs":{"262":{"tf":2.23606797749979},"311":{"tf":1.0},"312":{"tf":1.7320508075688772},"325":{"tf":1.0},"326":{"tf":2.0}}},"x":{":":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"x":{"df":1,"docs":{"318":{"tf":1.0}}}},"df":0,"docs":{}}},"df":3,"docs":{"318":{"tf":1.7320508075688772},"320":{"tf":1.0},"321":{"tf":1.0}}}},"b":{"df":0,"docs":{},"e":{"df":1,"docs":{"0":{"tf":1.0}}},"x":{"df":1,"docs":{"319":{"tf":2.0}}}},"c":{"'":{"df":1,"docs":{"270":{"tf":1.0}}},"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"270":{"tf":1.0}}}}}}}},":":{":":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"r":{"c":{"_":{"a":{"df":1,"docs":{"270":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"r":{"c":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"270":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"r":{"c":{"_":{"a":{"df":1,"docs":{"270":{"tf":1.7320508075688772}}},"b":{"df":1,"docs":{"270":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"270":{"tf":1.4142135623730951}}}}}}}}},"_":{"a":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"(":{"&":{"df":0,"docs":{},"r":{"c":{"_":{"b":{"df":1,"docs":{"270":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"270":{"tf":1.0}}}}}},"df":1,"docs":{"270":{"tf":3.1622776601683795}}},"b":{"df":1,"docs":{"270":{"tf":2.6457513110645907}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"270":{"tf":2.0}}}}}},"df":0,"docs":{}}}},"`":{"df":1,"docs":{"270":{"tf":1.0}}},"df":1,"docs":{"270":{"tf":3.0}}},"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"319":{"tf":2.0},"320":{"tf":1.0}}},"x":{"df":1,"docs":{"318":{"tf":1.0}}}},"df":6,"docs":{"17":{"tf":1.0},"205":{"tf":1.7320508075688772},"244":{"tf":1.0},"262":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.4142135623730951}},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"266":{"tf":1.0},"290":{"tf":1.0},"65":{"tf":1.0}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"248":{"tf":1.0}}}}}}},"d":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"172":{"tf":1.0},"324":{"tf":1.0}}}}}}},"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"285":{"tf":1.0},"287":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"s":{"(":{"\"":{".":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"287":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"286":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}},".":{"df":0,"docs":{},"r":{"df":1,"docs":{"287":{"tf":1.0}}}},"<":{"df":0,"docs":{},"p":{">":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"287":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"286":{"tf":1.0}},"e":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"(":{")":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"286":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"a":{"b":{"df":0,"docs":{},"l":{"df":8,"docs":{"158":{"tf":1.0},"171":{"tf":1.0},"194":{"tf":1.0},"224":{"tf":1.0},"23":{"tf":1.4142135623730951},"276":{"tf":1.0},"283":{"tf":1.0},"316":{"tf":1.0}}}},"df":0,"docs":{}},"df":24,"docs":{"129":{"tf":1.0},"172":{"tf":1.4142135623730951},"187":{"tf":1.0},"189":{"tf":1.0},"191":{"tf":1.4142135623730951},"205":{"tf":1.4142135623730951},"220":{"tf":1.0},"237":{"tf":1.0},"240":{"tf":1.0},"261":{"tf":1.0},"276":{"tf":1.0},"282":{"tf":1.0},"283":{"tf":2.0},"286":{"tf":1.4142135623730951},"289":{"tf":1.0},"291":{"tf":1.0},"3":{"tf":1.0},"316":{"tf":1.0},"317":{"tf":1.0},"319":{"tf":1.7320508075688772},"32":{"tf":1.0},"324":{"tf":1.4142135623730951},"88":{"tf":1.0},"92":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"287":{"tf":1.0},"336":{"tf":1.0},"49":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":3,"docs":{"11":{"tf":1.0},"131":{"tf":1.0},"132":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"124":{"tf":1.0},"241":{"tf":1.0},"277":{"tf":1.0},"300":{"tf":1.0},"88":{"tf":1.0}}},"o":{"c":{"df":1,"docs":{"260":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"167":{"tf":1.0},"220":{"tf":1.0},"237":{"tf":1.4142135623730951},"264":{"tf":1.0},"286":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"174":{"tf":1.4142135623730951},"97":{"tf":1.7320508075688772}}}}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"125":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"214":{"tf":1.0},"238":{"tf":1.0}}},"p":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":3,"docs":{"192":{"tf":1.0},"223":{"tf":1.4142135623730951},"279":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"279":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":1,"docs":{"279":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"125":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"227":{"tf":1.4142135623730951}},"r":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"242":{"tf":1.0},"267":{"tf":1.0},"3":{"tf":1.0},"308":{"tf":1.0},"316":{"tf":1.0}}},"df":0,"docs":{}}}}}},"t":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":6,"docs":{"130":{"tf":1.4142135623730951},"144":{"tf":2.0},"259":{"tf":2.6457513110645907},"28":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"95":{"tf":2.6457513110645907}},"e":{".":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}}}}}}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"1":{".":{"0":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"219":{"tf":1.0},"291":{"tf":1.0}}}}},"v":{"df":1,"docs":{"279":{"tf":1.4142135623730951}}}},"d":{"(":{"&":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"146":{"tf":1.0}}}}}}}}},"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"146":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"146":{"tf":1.0}}}},">":{"(":{"_":{"df":1,"docs":{"146":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"334":{"tf":1.0}}}}},"df":6,"docs":{"146":{"tf":2.0},"16":{"tf":2.0},"17":{"tf":1.0},"324":{"tf":1.0},"36":{"tf":1.0},"78":{"tf":1.4142135623730951}},"u":{"c":{"df":6,"docs":{"136":{"tf":1.0},"203":{"tf":1.0},"276":{"tf":1.7320508075688772},"287":{"tf":1.0},"42":{"tf":1.0},"51":{"tf":1.0}}},"df":0,"docs":{}}},"df":7,"docs":{"242":{"tf":1.0},"260":{"tf":1.0},"266":{"tf":1.0},"297":{"tf":1.4142135623730951},"306":{"tf":1.0},"86":{"tf":1.0},"97":{"tf":1.0}},"f":{"(":{"&":{"'":{"a":{"df":1,"docs":{"183":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"x":{"df":1,"docs":{"187":{"tf":1.0}}}},"df":0,"docs":{}},"<":{"'":{"a":{"df":1,"docs":{"187":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"c":{"1":{"df":1,"docs":{"175":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"175":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"x":{"df":1,"docs":{"175":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"x":{"df":1,"docs":{"187":{"tf":1.0}}}},"df":8,"docs":{"15":{"tf":1.0},"162":{"tf":1.0},"169":{"tf":1.7320508075688772},"175":{"tf":3.0},"187":{"tf":1.4142135623730951},"38":{"tf":2.0},"80":{"tf":3.1622776601683795},"81":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":50,"docs":{"10":{"tf":1.0},"105":{"tf":1.4142135623730951},"110":{"tf":2.449489742783178},"119":{"tf":1.7320508075688772},"13":{"tf":1.0},"134":{"tf":1.0},"141":{"tf":1.0},"154":{"tf":1.0},"158":{"tf":1.0},"167":{"tf":1.0},"169":{"tf":1.0},"171":{"tf":2.0},"172":{"tf":2.23606797749979},"174":{"tf":2.8284271247461903},"175":{"tf":2.0},"176":{"tf":1.4142135623730951},"177":{"tf":2.0},"179":{"tf":3.0},"183":{"tf":2.449489742783178},"187":{"tf":2.449489742783178},"189":{"tf":1.0},"190":{"tf":1.0},"191":{"tf":2.6457513110645907},"192":{"tf":1.7320508075688772},"196":{"tf":1.0},"199":{"tf":1.4142135623730951},"203":{"tf":1.0},"214":{"tf":1.0},"220":{"tf":1.0},"238":{"tf":1.0},"25":{"tf":1.0},"261":{"tf":1.0},"262":{"tf":1.0},"267":{"tf":1.0},"270":{"tf":1.7320508075688772},"272":{"tf":2.23606797749979},"276":{"tf":2.449489742783178},"286":{"tf":1.0},"312":{"tf":1.4142135623730951},"319":{"tf":1.0},"32":{"tf":1.4142135623730951},"321":{"tf":1.0},"323":{"tf":1.4142135623730951},"324":{"tf":1.0},"334":{"tf":1.0},"38":{"tf":1.4142135623730951},"80":{"tf":4.123105625617661},"96":{"tf":1.4142135623730951},"97":{"tf":2.23606797749979},"99":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"169":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"316":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"221":{"tf":1.0},"222":{"tf":1.4142135623730951}}}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.0}}}}},"g":{"_":{"a":{"b":{"c":{"d":{"df":1,"docs":{"321":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"(":{"_":{"df":1,"docs":{"138":{"tf":1.0}}},"df":0,"docs":{},"s":{"(":{"a":{"df":1,"docs":{"138":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"138":{"tf":1.0}}}}},"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"215":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"133":{"tf":1.0},"144":{"tf":1.0},"230":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":3,"docs":{"316":{"tf":1.0},"318":{"tf":1.0},"319":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":7,"docs":{"316":{"tf":2.0},"317":{"tf":2.449489742783178},"318":{"tf":3.0},"319":{"tf":4.123105625617661},"320":{"tf":1.7320508075688772},"321":{"tf":3.7416573867739413},"323":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"124":{"tf":1.0},"125":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"21":{"tf":1.0},"3":{"tf":1.0},"305":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"142":{"tf":1.0}}}}}}}}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"176":{"tf":1.0},"190":{"tf":1.0},"280":{"tf":1.0}}}},"df":2,"docs":{"132":{"tf":1.0},"334":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"317":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"v":{"df":1,"docs":{"327":{"tf":1.0}}}},"o":{"a":{"d":{"df":1,"docs":{"317":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"191":{"tf":1.0}}},"df":5,"docs":{"140":{"tf":1.4142135623730951},"191":{"tf":1.4142135623730951},"270":{"tf":1.0},"279":{"tf":1.0},"97":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":2,"docs":{"171":{"tf":1.0},"262":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"v":{"df":11,"docs":{"119":{"tf":1.0},"133":{"tf":1.0},"196":{"tf":1.0},"205":{"tf":1.4142135623730951},"259":{"tf":1.0},"260":{"tf":1.0},"261":{"tf":1.0},"276":{"tf":1.0},"291":{"tf":1.4142135623730951},"56":{"tf":1.0},"97":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"32":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"316":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"212":{"tf":1.4142135623730951},"216":{"tf":1.7320508075688772},"217":{"tf":1.0},"48":{"tf":1.0}},"e":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"92":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"213":{"tf":1.0},"90":{"tf":1.0}}}}}},"l":{"a":{"c":{"df":5,"docs":{"225":{"tf":1.0},"248":{"tf":1.0},"269":{"tf":1.0},"317":{"tf":1.0},"5":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":1,"docs":{"125":{"tf":1.0}},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"266":{"tf":1.0},"32":{"tf":1.0},"86":{"tf":1.0}}}}},"r":{"(":{"c":{"df":1,"docs":{"297":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"s":{"df":10,"docs":{"136":{"tf":1.0},"227":{"tf":1.0},"245":{"tf":1.0},"260":{"tf":1.0},"263":{"tf":1.0},"280":{"tf":1.4142135623730951},"282":{"tf":1.0},"288":{"tf":1.0},"289":{"tf":1.0},"329":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"236":{"tf":1.0},"38":{"tf":1.0},"48":{"tf":1.4142135623730951}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":44,"docs":{"10":{"tf":1.7320508075688772},"101":{"tf":1.7320508075688772},"105":{"tf":1.0},"108":{"tf":1.0},"113":{"tf":1.4142135623730951},"123":{"tf":1.0},"13":{"tf":1.0},"136":{"tf":1.0},"138":{"tf":1.0},"140":{"tf":1.0},"144":{"tf":1.0},"150":{"tf":1.0},"156":{"tf":2.0},"158":{"tf":1.0},"165":{"tf":1.4142135623730951},"169":{"tf":1.0},"177":{"tf":1.4142135623730951},"179":{"tf":1.0},"192":{"tf":1.0},"197":{"tf":1.0},"199":{"tf":1.0},"203":{"tf":1.4142135623730951},"208":{"tf":1.4142135623730951},"210":{"tf":1.0},"24":{"tf":1.0},"250":{"tf":1.0},"268":{"tf":1.0},"3":{"tf":1.0},"308":{"tf":1.0},"314":{"tf":1.0},"318":{"tf":1.0},"322":{"tf":1.0},"328":{"tf":1.0},"329":{"tf":1.0},"40":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.4142135623730951},"88":{"tf":1.0},"92":{"tf":1.7320508075688772},"95":{"tf":1.4142135623730951},"97":{"tf":2.449489742783178},"99":{"tf":1.7320508075688772}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"128":{"tf":1.0},"129":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":2,"docs":{"164":{"tf":1.4142135623730951},"266":{"tf":1.4142135623730951}}}}},"s":{"c":{"df":0,"docs":{},"u":{"df":2,"docs":{"262":{"tf":1.0},"306":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":4,"docs":{"190":{"tf":1.0},"260":{"tf":1.0},"319":{"tf":1.7320508075688772},"326":{"tf":1.0}}}},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"125":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":9,"docs":{"163":{"tf":1.0},"164":{"tf":2.0},"165":{"tf":1.0},"167":{"tf":2.6457513110645907},"202":{"tf":1.4142135623730951},"207":{"tf":2.8284271247461903},"266":{"tf":1.0},"283":{"tf":1.0},"95":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":7,"docs":{"120":{"tf":1.0},"23":{"tf":1.0},"268":{"tf":1.0},"280":{"tf":1.0},"286":{"tf":1.0},"300":{"tf":1.0},"76":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"237":{"tf":1.0},"289":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"313":{"tf":1.0}}}}}},"t":{"df":13,"docs":{"125":{"tf":1.0},"174":{"tf":1.4142135623730951},"176":{"tf":1.0},"212":{"tf":1.0},"220":{"tf":1.0},"268":{"tf":1.0},"294":{"tf":1.0},"48":{"tf":1.0},"64":{"tf":1.4142135623730951},"66":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":2.0},"76":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"319":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":7,"docs":{"115":{"tf":1.0},"144":{"tf":1.0},"176":{"tf":1.0},"321":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}},"e":{"d":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"286":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"255":{"tf":1.0}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}}},"f":{"6":{"4":{"df":3,"docs":{"264":{"tf":1.0},"265":{"tf":1.0},"301":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"3":{"2":{"df":11,"docs":{"237":{"tf":2.0},"240":{"tf":1.4142135623730951},"241":{"tf":1.4142135623730951},"242":{"tf":1.4142135623730951},"243":{"tf":1.0},"245":{"tf":1.4142135623730951},"246":{"tf":1.4142135623730951},"248":{"tf":1.4142135623730951},"250":{"tf":1.4142135623730951},"257":{"tf":1.0},"306":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"244":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"t":{"df":10,"docs":{"235":{"tf":1.0},"238":{"tf":1.0},"243":{"tf":1.4142135623730951},"245":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.0},"250":{"tf":1.0},"264":{"tf":1.0},"282":{"tf":1.0},"51":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"c":{"<":{"_":{"df":1,"docs":{"255":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":1,"docs":{"255":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":63,"docs":{"10":{"tf":1.0},"119":{"tf":1.0},"127":{"tf":1.4142135623730951},"13":{"tf":1.0},"15":{"tf":1.0},"167":{"tf":1.0},"169":{"tf":1.0},"176":{"tf":1.0},"179":{"tf":1.0},"189":{"tf":1.0},"207":{"tf":1.0},"214":{"tf":1.0},"217":{"tf":1.0},"220":{"tf":1.0},"223":{"tf":1.0},"227":{"tf":1.7320508075688772},"235":{"tf":2.449489742783178},"236":{"tf":2.0},"237":{"tf":2.449489742783178},"238":{"tf":2.6457513110645907},"240":{"tf":1.0},"241":{"tf":1.0},"242":{"tf":1.0},"243":{"tf":1.7320508075688772},"244":{"tf":1.4142135623730951},"245":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":2.23606797749979},"25":{"tf":1.0},"250":{"tf":1.0},"252":{"tf":1.0},"253":{"tf":1.0},"255":{"tf":1.7320508075688772},"256":{"tf":1.4142135623730951},"262":{"tf":1.4142135623730951},"263":{"tf":1.0},"264":{"tf":1.7320508075688772},"265":{"tf":1.7320508075688772},"275":{"tf":1.0},"276":{"tf":3.1622776601683795},"286":{"tf":1.7320508075688772},"287":{"tf":1.0},"3":{"tf":1.0},"300":{"tf":1.4142135623730951},"301":{"tf":1.4142135623730951},"302":{"tf":2.0},"303":{"tf":2.0},"304":{"tf":2.0},"305":{"tf":2.0},"306":{"tf":1.4142135623730951},"308":{"tf":1.7320508075688772},"316":{"tf":1.0},"317":{"tf":1.0},"318":{"tf":1.7320508075688772},"320":{"tf":1.7320508075688772},"323":{"tf":1.0},"48":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772},"66":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0},"97":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"223":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"66":{"tf":1.0}},"e":{"df":0,"docs":{},"v":{"df":3,"docs":{"156":{"tf":1.0},"158":{"tf":1.0},"80":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"`":{"df":1,"docs":{"265":{"tf":1.4142135623730951}}},"df":74,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"101":{"tf":1.0},"105":{"tf":1.7320508075688772},"108":{"tf":1.0},"110":{"tf":1.0},"113":{"tf":3.3166247903554},"13":{"tf":1.7320508075688772},"138":{"tf":1.0},"141":{"tf":1.0},"161":{"tf":1.0},"175":{"tf":1.0},"179":{"tf":2.449489742783178},"189":{"tf":1.0},"191":{"tf":1.0},"196":{"tf":1.0},"199":{"tf":3.1622776601683795},"203":{"tf":2.8284271247461903},"204":{"tf":1.0},"205":{"tf":1.4142135623730951},"206":{"tf":3.3166247903554},"210":{"tf":1.0},"223":{"tf":1.4142135623730951},"224":{"tf":1.7320508075688772},"225":{"tf":2.0},"227":{"tf":1.7320508075688772},"230":{"tf":1.0},"235":{"tf":1.7320508075688772},"236":{"tf":2.0},"237":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"240":{"tf":2.6457513110645907},"241":{"tf":1.4142135623730951},"243":{"tf":1.4142135623730951},"248":{"tf":2.0},"25":{"tf":1.0},"259":{"tf":1.0},"26":{"tf":1.4142135623730951},"260":{"tf":1.0},"264":{"tf":2.23606797749979},"265":{"tf":1.4142135623730951},"267":{"tf":1.7320508075688772},"269":{"tf":1.4142135623730951},"275":{"tf":1.0},"276":{"tf":2.0},"280":{"tf":1.7320508075688772},"282":{"tf":1.0},"283":{"tf":1.4142135623730951},"284":{"tf":1.4142135623730951},"286":{"tf":1.4142135623730951},"287":{"tf":1.7320508075688772},"29":{"tf":1.0},"290":{"tf":1.0},"291":{"tf":2.449489742783178},"294":{"tf":1.0},"296":{"tf":1.0},"301":{"tf":1.4142135623730951},"306":{"tf":1.4142135623730951},"31":{"tf":1.0},"320":{"tf":1.0},"329":{"tf":1.0},"38":{"tf":2.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.7320508075688772},"66":{"tf":1.7320508075688772},"86":{"tf":1.4142135623730951},"90":{"tf":1.0},"94":{"tf":3.605551275463989},"95":{"tf":1.0},"96":{"tf":2.0},"99":{"tf":1.7320508075688772}}}}}},"u":{"df":0,"docs":{},"s":{"df":5,"docs":{"238":{"tf":1.0},"28":{"tf":1.0},"323":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"96":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":5,"docs":{"200":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"261":{"tf":1.4142135623730951},"99":{"tf":1.0}},"e":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"158":{"tf":1.0},"222":{"tf":1.0},"248":{"tf":1.0},"94":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"227":{"tf":1.0},"237":{"tf":1.0},"240":{"tf":1.0}}}}}}}}}},"f":{"c":{"5":{"0":{"5":{"df":1,"docs":{"307":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":8,"docs":{"151":{"tf":1.0},"155":{"tf":1.0},"33":{"tf":1.0},"334":{"tf":1.4142135623730951},"41":{"tf":1.0},"89":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}},"g":{"b":{"(":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"17":{"tf":2.449489742783178}}},"df":0,"docs":{}},"h":{"df":3,"docs":{"161":{"tf":2.449489742783178},"200":{"tf":1.4142135623730951},"94":{"tf":1.7320508075688772}},"s":{".":{"0":{"df":1,"docs":{"161":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"34":{"tf":2.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"235":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"215":{"tf":1.4142135623730951}}}}}}},"df":9,"docs":{"152":{"tf":1.0},"175":{"tf":1.0},"215":{"tf":1.7320508075688772},"237":{"tf":1.0},"259":{"tf":1.0},"28":{"tf":1.0},"300":{"tf":2.23606797749979},"5":{"tf":1.0},"80":{"tf":1.4142135623730951}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"92":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"220":{"tf":1.0}}}}},"s":{"c":{"df":1,"docs":{"314":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"291":{"tf":1.0}}}}},"df":1,"docs":{"291":{"tf":1.0}}},"n":{"df":0,"docs":{},"g":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"191":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"191":{"tf":1.0}}}},"o":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"237":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"119":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":3,"docs":{"125":{"tf":1.0},"265":{"tf":1.0},"297":{"tf":1.7320508075688772}},"s":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"301":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"w":{"df":1,"docs":{"205":{"tf":1.4142135623730951}}}},"s":{"df":1,"docs":{"333":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":10,"docs":{"0":{"tf":1.0},"115":{"tf":1.0},"138":{"tf":1.0},"154":{"tf":1.0},"163":{"tf":1.0},"220":{"tf":1.0},"276":{"tf":1.4142135623730951},"316":{"tf":1.0},"48":{"tf":1.4142135623730951},"51":{"tf":1.0}}}},"n":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"32":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":31,"docs":{"1":{"tf":1.0},"121":{"tf":1.0},"125":{"tf":1.4142135623730951},"126":{"tf":1.0},"127":{"tf":2.6457513110645907},"128":{"tf":1.0},"133":{"tf":1.7320508075688772},"135":{"tf":1.0},"165":{"tf":1.0},"191":{"tf":1.0},"2":{"tf":1.0},"217":{"tf":1.0},"222":{"tf":1.4142135623730951},"242":{"tf":1.0},"276":{"tf":1.0},"287":{"tf":1.0},"289":{"tf":1.0},"290":{"tf":1.0},"3":{"tf":1.4142135623730951},"300":{"tf":2.0},"302":{"tf":1.7320508075688772},"303":{"tf":2.8284271247461903},"304":{"tf":2.23606797749979},"305":{"tf":1.7320508075688772},"308":{"tf":2.449489742783178},"328":{"tf":1.4142135623730951},"329":{"tf":1.4142135623730951},"336":{"tf":1.0},"337":{"tf":1.0},"6":{"tf":1.0},"67":{"tf":1.0}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"308":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":5,"docs":{"159":{"tf":1.4142135623730951},"246":{"tf":1.0},"26":{"tf":1.0},"266":{"tf":1.0},"48":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"'":{"df":2,"docs":{"0":{"tf":1.0},"276":{"tf":1.0}}},",":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{",":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"336":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"336":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"305":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"e":{"=":{"1":{"df":1,"docs":{"300":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"\"":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"210":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":2,"docs":{"2":{"tf":1.0},"70":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"c":{"'":{"df":1,"docs":{"123":{"tf":1.0}}},"df":21,"docs":{"1":{"tf":1.7320508075688772},"120":{"tf":1.0},"121":{"tf":1.4142135623730951},"122":{"tf":1.4142135623730951},"123":{"tf":1.0},"132":{"tf":1.4142135623730951},"135":{"tf":1.7320508075688772},"164":{"tf":1.0},"217":{"tf":1.0},"222":{"tf":1.0},"266":{"tf":1.0},"283":{"tf":1.0},"284":{"tf":1.0},"287":{"tf":1.0},"288":{"tf":1.0},"290":{"tf":1.0},"291":{"tf":1.0},"296":{"tf":1.0},"328":{"tf":1.0},"329":{"tf":1.0},"90":{"tf":1.0}}},"d":{"df":0,"docs":{},"o":{"c":{"df":7,"docs":{"327":{"tf":1.0},"328":{"tf":1.0},"329":{"tf":2.0},"330":{"tf":1.0},"333":{"tf":1.4142135623730951},"334":{"tf":1.4142135623730951},"338":{"tf":1.0}}},"df":0,"docs":{}}},"df":84,"docs":{"0":{"tf":3.0},"1":{"tf":1.0},"112":{"tf":1.4142135623730951},"114":{"tf":1.0},"121":{"tf":1.0},"123":{"tf":1.0},"124":{"tf":1.4142135623730951},"125":{"tf":1.7320508075688772},"127":{"tf":1.0},"129":{"tf":1.0},"13":{"tf":1.0},"132":{"tf":1.4142135623730951},"136":{"tf":1.0},"164":{"tf":1.4142135623730951},"165":{"tf":1.0},"167":{"tf":1.0},"171":{"tf":1.0},"177":{"tf":1.0},"189":{"tf":1.4142135623730951},"19":{"tf":1.0},"190":{"tf":1.4142135623730951},"194":{"tf":1.0},"199":{"tf":1.4142135623730951},"200":{"tf":1.0},"206":{"tf":1.0},"208":{"tf":1.0},"209":{"tf":1.0},"21":{"tf":1.0},"211":{"tf":1.0},"212":{"tf":1.4142135623730951},"213":{"tf":1.0},"214":{"tf":1.0},"218":{"tf":2.0},"220":{"tf":1.0},"223":{"tf":1.0},"23":{"tf":1.4142135623730951},"235":{"tf":1.0},"238":{"tf":1.0},"245":{"tf":1.0},"259":{"tf":1.0},"261":{"tf":1.0},"262":{"tf":1.0},"27":{"tf":1.0},"275":{"tf":1.0},"276":{"tf":2.23606797749979},"279":{"tf":1.0},"296":{"tf":1.0},"297":{"tf":1.0},"298":{"tf":1.4142135623730951},"3":{"tf":1.0},"300":{"tf":1.0},"301":{"tf":1.0},"305":{"tf":1.4142135623730951},"308":{"tf":1.0},"311":{"tf":1.0},"314":{"tf":1.0},"316":{"tf":1.0},"317":{"tf":1.4142135623730951},"318":{"tf":1.0},"319":{"tf":1.0},"32":{"tf":1.0},"325":{"tf":1.0},"326":{"tf":2.0},"327":{"tf":1.0},"329":{"tf":1.0},"334":{"tf":1.0},"335":{"tf":1.4142135623730951},"337":{"tf":1.4142135623730951},"338":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"42":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.7320508075688772},"5":{"tf":1.7320508075688772},"53":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"64":{"tf":1.0},"72":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"90":{"tf":1.0},"99":{"tf":1.0}}}}},"x":{"df":1,"docs":{"279":{"tf":1.0}}}},"s":{"(":{"a":{"df":1,"docs":{"138":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"!":{"[":{"1":{"df":1,"docs":{"144":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"i":{"3":{"2":{">":{"(":{")":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"253":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"245":{"tf":1.0},"246":{"tf":1.0},"248":{"tf":1.0},"252":{"tf":1.0},"255":{"tf":1.0},"256":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"8":{"df":1,"docs":{"254":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.4142135623730951}}}}}}}},"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"144":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":4,"docs":{"0":{"tf":1.0},"26":{"tf":1.0},"297":{"tf":1.4142135623730951},"312":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":3,"docs":{"0":{"tf":1.0},"42":{"tf":1.0},"51":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":45,"docs":{"103":{"tf":1.0},"11":{"tf":1.0},"115":{"tf":2.23606797749979},"119":{"tf":1.4142135623730951},"123":{"tf":1.7320508075688772},"125":{"tf":1.0},"126":{"tf":1.0},"127":{"tf":1.0},"138":{"tf":1.0},"16":{"tf":1.0},"167":{"tf":1.4142135623730951},"169":{"tf":1.0},"171":{"tf":1.0},"176":{"tf":1.0},"179":{"tf":1.4142135623730951},"187":{"tf":1.0},"196":{"tf":1.0},"206":{"tf":1.0},"210":{"tf":1.0},"23":{"tf":1.4142135623730951},"238":{"tf":1.0},"242":{"tf":1.4142135623730951},"245":{"tf":1.0},"248":{"tf":1.0},"255":{"tf":1.0},"26":{"tf":2.0},"262":{"tf":1.0},"269":{"tf":1.0},"272":{"tf":1.0},"28":{"tf":1.0},"287":{"tf":1.0},"308":{"tf":1.0},"316":{"tf":1.4142135623730951},"317":{"tf":2.0},"319":{"tf":1.0},"321":{"tf":1.0},"323":{"tf":1.7320508075688772},"324":{"tf":1.0},"326":{"tf":1.0},"38":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.4142135623730951},"5":{"tf":2.23606797749979},"63":{"tf":1.0},"88":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"125":{"tf":1.0},"19":{"tf":1.0},"336":{"tf":1.0},"337":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":4,"docs":{"103":{"tf":1.7320508075688772},"108":{"tf":1.0},"110":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"48":{"tf":1.0},"78":{"tf":1.4142135623730951}}}}},"v":{"df":0,"docs":{},"e":{"df":6,"docs":{"194":{"tf":1.0},"220":{"tf":1.0},"238":{"tf":1.0},"254":{"tf":1.0},"317":{"tf":1.0},"319":{"tf":2.0}}}},"w":{"df":1,"docs":{"126":{"tf":1.4142135623730951}}},"y":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"212":{"tf":1.7320508075688772}}}}}}}},"df":1,"docs":{"210":{"tf":1.0}}}},"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"236":{"tf":1.0}}}}}},"df":0,"docs":{}}},"h":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"275":{"tf":1.0}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"208":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"23":{"tf":1.4142135623730951}}}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":30,"docs":{"0":{"tf":1.7320508075688772},"101":{"tf":1.0},"103":{"tf":1.0},"115":{"tf":1.4142135623730951},"118":{"tf":1.0},"119":{"tf":2.449489742783178},"120":{"tf":1.0},"130":{"tf":1.0},"138":{"tf":1.0},"163":{"tf":1.4142135623730951},"164":{"tf":1.4142135623730951},"165":{"tf":1.4142135623730951},"171":{"tf":1.4142135623730951},"176":{"tf":2.0},"179":{"tf":1.0},"189":{"tf":1.0},"191":{"tf":1.0},"192":{"tf":1.0},"202":{"tf":1.0},"259":{"tf":1.0},"270":{"tf":1.7320508075688772},"272":{"tf":1.0},"283":{"tf":1.0},"300":{"tf":1.0},"34":{"tf":2.0},"40":{"tf":1.4142135623730951},"44":{"tf":2.0},"46":{"tf":2.0},"90":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"319":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"128":{"tf":1.7320508075688772},"129":{"tf":2.0}}}}}}},"df":20,"docs":{"138":{"tf":1.7320508075688772},"140":{"tf":1.7320508075688772},"144":{"tf":1.0},"154":{"tf":1.0},"16":{"tf":1.0},"190":{"tf":1.0},"223":{"tf":1.0},"224":{"tf":1.0},"262":{"tf":1.7320508075688772},"280":{"tf":1.0},"283":{"tf":1.7320508075688772},"288":{"tf":2.0},"289":{"tf":1.7320508075688772},"291":{"tf":2.8284271247461903},"31":{"tf":1.0},"38":{"tf":1.0},"57":{"tf":1.0},"78":{"tf":2.0},"80":{"tf":1.0},"90":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"110":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"c":{"df":1,"docs":{"127":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":6,"docs":{"235":{"tf":1.4142135623730951},"237":{"tf":1.4142135623730951},"238":{"tf":1.0},"240":{"tf":1.7320508075688772},"241":{"tf":1.4142135623730951},"242":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"i":{"3":{"2":{">":{"(":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":2,"docs":{"237":{"tf":1.0},"238":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"235":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"237":{"tf":1.0},"240":{"tf":1.0},"241":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":6,"docs":{"235":{"tf":1.0},"237":{"tf":1.4142135623730951},"238":{"tf":1.0},"240":{"tf":1.0},"241":{"tf":1.0},"242":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":18,"docs":{"189":{"tf":2.23606797749979},"191":{"tf":1.4142135623730951},"197":{"tf":2.0},"2":{"tf":1.0},"205":{"tf":1.0},"221":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"269":{"tf":1.0},"290":{"tf":1.0},"296":{"tf":1.4142135623730951},"305":{"tf":1.0},"316":{"tf":1.0},"318":{"tf":1.0},"323":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":2.8284271247461903},"95":{"tf":1.7320508075688772}},"s":{"(":{"1":{"df":1,"docs":{"197":{"tf":1.0}}},"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"197":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":20,"docs":{"107":{"tf":1.0},"125":{"tf":1.0},"156":{"tf":1.0},"158":{"tf":1.0},"176":{"tf":1.0},"219":{"tf":1.0},"220":{"tf":1.0},"222":{"tf":1.0},"236":{"tf":1.0},"240":{"tf":1.0},"242":{"tf":1.0},"243":{"tf":1.0},"26":{"tf":1.7320508075688772},"267":{"tf":1.0},"305":{"tf":1.0},"309":{"tf":1.0},"311":{"tf":1.0},"47":{"tf":1.0},"59":{"tf":1.0},"70":{"tf":1.0}}}}}}},"d":{"df":1,"docs":{"284":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{"df":126,"docs":{"100":{"tf":1.0},"102":{"tf":1.0},"104":{"tf":1.0},"106":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":1.4142135623730951},"117":{"tf":1.0},"12":{"tf":1.0},"122":{"tf":1.0},"125":{"tf":1.4142135623730951},"127":{"tf":1.7320508075688772},"13":{"tf":1.0},"134":{"tf":1.0},"135":{"tf":1.0},"137":{"tf":1.0},"139":{"tf":1.0},"141":{"tf":1.0},"143":{"tf":1.0},"145":{"tf":1.0},"147":{"tf":1.0},"149":{"tf":1.0},"15":{"tf":1.0},"151":{"tf":1.0},"153":{"tf":1.0},"155":{"tf":1.0},"156":{"tf":1.0},"157":{"tf":1.0},"160":{"tf":1.0},"162":{"tf":1.0},"165":{"tf":1.0},"166":{"tf":1.0},"17":{"tf":1.0},"170":{"tf":1.0},"173":{"tf":1.0},"176":{"tf":1.4142135623730951},"177":{"tf":1.0},"178":{"tf":1.0},"18":{"tf":1.0},"180":{"tf":1.0},"182":{"tf":1.0},"184":{"tf":1.0},"186":{"tf":1.0},"188":{"tf":1.0},"191":{"tf":1.0},"193":{"tf":1.0},"194":{"tf":1.0},"195":{"tf":1.0},"198":{"tf":1.0},"2":{"tf":1.0},"201":{"tf":1.0},"209":{"tf":1.0},"211":{"tf":1.0},"214":{"tf":1.0},"22":{"tf":1.0},"221":{"tf":1.0},"224":{"tf":1.0},"226":{"tf":1.0},"228":{"tf":1.0},"23":{"tf":1.0},"230":{"tf":1.0},"232":{"tf":1.0},"234":{"tf":1.0},"235":{"tf":1.0},"239":{"tf":1.0},"24":{"tf":1.0},"241":{"tf":1.0},"242":{"tf":1.0},"243":{"tf":1.0},"247":{"tf":1.0},"249":{"tf":1.0},"25":{"tf":1.0},"251":{"tf":1.0},"258":{"tf":1.0},"269":{"tf":1.0},"271":{"tf":1.0},"274":{"tf":1.0},"276":{"tf":1.4142135623730951},"278":{"tf":1.0},"281":{"tf":1.0},"282":{"tf":1.0},"292":{"tf":1.0},"299":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"301":{"tf":1.0},"307":{"tf":1.0},"310":{"tf":1.0},"311":{"tf":1.0},"316":{"tf":2.449489742783178},"317":{"tf":1.0},"32":{"tf":1.0},"323":{"tf":1.0},"324":{"tf":1.0},"33":{"tf":1.0},"334":{"tf":1.0},"338":{"tf":1.0},"35":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"9":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.4142135623730951},"98":{"tf":1.0},"99":{"tf":1.0}},"m":{"df":2,"docs":{"113":{"tf":1.0},"88":{"tf":1.0}}},"n":{"df":4,"docs":{"16":{"tf":1.0},"212":{"tf":1.0},"223":{"tf":1.0},"264":{"tf":1.0}}}},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"276":{"tf":2.8284271247461903},"90":{"tf":1.4142135623730951}}}}}}},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"45":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"210":{"tf":1.4142135623730951},"319":{"tf":1.0}}}},"df":0,"docs":{}},"f":{".":{"0":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":1.0},"156":{"tf":1.4142135623730951},"158":{"tf":1.4142135623730951},"181":{"tf":1.4142135623730951}}},"1":{"df":3,"docs":{"10":{"tf":1.0},"156":{"tf":1.4142135623730951},"158":{"tf":1.4142135623730951}}},"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"210":{"tf":1.0}}}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"203":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"v":{"df":1,"docs":{"140":{"tf":1.0}}}},"df":0,"docs":{}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"144":{"tf":1.0}}}}}}}},"i":{"df":1,"docs":{"10":{"tf":1.0}},"m":{"df":1,"docs":{"297":{"tf":1.7320508075688772}}},"s":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"196":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"o":{"b":{"?":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"?":{".":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"224":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"t":{".":{"a":{"b":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df"