# Eclipse Angus - Activation

[![Build Status](https://github.com/eclipse-ee4j/angus-activation/actions/workflows/maven.yml/badge.svg?branch=master)](https://github.com/eclipse-ee4j/angus-activation/actions/workflows/maven.yml?branch=master)
[![Jakarta Staging (Snapshots)](https://img.shields.io/nexus/s/https/jakarta.oss.sonatype.org/org.eclipse.angus/angus-activation.svg)](https://jakarta.oss.sonatype.org/content/repositories/staging/org/eclipse/angus/angus-activation/)

This project provides the implementation of Jakarta Activation Specification
which lets you take advantage of standard services to: determine the type of an arbitrary piece of data;
encapsulate access to it; discover the operations available on it; and instantiate the
appropriate bean to perform the operation(s).

This project is part of [Eclipse Angus project](https://projects.eclipse.org/projects/ee4j.angus).

## License

* Most of the Eclipse Angus Activation project source code is licensed
under the [Eclipse Distribution License (EDL) v1.0.](https://www.eclipse.org/org/documents/edl-v10.php);
see the license information at the top of each source file.
* The binary jar files published to the Maven repository are licensed
under the same licenses as the corresponding source code;
see the file `META-INF/LICENSE.*` in each jar file.

You'll find the text of the licenses in the workspace in various `LICENSE.txt` or `LICENSE.md` files.
Don't let the presence of these license files in the workspace confuse you into thinking
that they apply to all files in the workspace.

You should always read the license file included with every download, and read
the license text included in every source file.

## Contributing

We use [contribution policy](CONTRIBUTING.md), which means we can only accept contributions under
the terms of [Eclipse Contributor Agreement](http://www.eclipse.org/legal/ECA.php).

## Links

* [Jakarta Activation Specification project](https://github.com/eclipse-ee4j/jaf).
* [Jakarta Activation web site](https://eclipse-ee4j.github.io/jaf/).
* [Javadoc](https://javadoc.io/doc/org.eclipse.angus/angus-activation/latest/com.sun.activation.registries/module-summary.html)
* [Mailing list](https://accounts.eclipse.org/mailing-list/angus-dev)
* [Nightly build job](https://ci.eclipse.org/angus/job/angus-master-build/)
