/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.Strings;
import com.google.common.base.VerifyException;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Verify {
    public static void verify(boolean expression) {
        if (!expression) {
            throw new VerifyException();
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, char p12) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p12)));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, int p12) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, long p12) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, @CheckForNull Object p12) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, char p12, char p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p12), Character.valueOf(p22)));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, int p12, char p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12, Character.valueOf(p22)));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, long p12, char p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12, Character.valueOf(p22)));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, @CheckForNull Object p12, char p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12, Character.valueOf(p22)));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, char p12, int p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p12), p22));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, int p12, int p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, long p12, int p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, @CheckForNull Object p12, int p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, char p12, long p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p12), p22));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, int p12, long p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, long p12, long p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, @CheckForNull Object p12, long p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, char p12, @CheckForNull Object p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p12), p22));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, int p12, @CheckForNull Object p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, long p12, @CheckForNull Object p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, @CheckForNull Object p12, @CheckForNull Object p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, @CheckForNull Object p12, @CheckForNull Object p22, @CheckForNull Object p32) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12, p22, p32));
        }
    }

    public static void verify(boolean expression, String errorMessageTemplate, @CheckForNull Object p12, @CheckForNull Object p22, @CheckForNull Object p32, @CheckForNull Object p42) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12, p22, p32, p42));
        }
    }

    @CanIgnoreReturnValue
    public static <T> T verifyNotNull(@CheckForNull T reference) {
        return Verify.verifyNotNull(reference, "expected a non-null reference", new Object[0]);
    }

    @CanIgnoreReturnValue
    public static <T> T verifyNotNull(@CheckForNull T reference, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (reference == null) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, errorMessageArgs));
        }
        return reference;
    }

    private Verify() {
    }
}

