package ecdsautil

import (
	"bytes"
	"crypto/x509"
	"encoding/json"
	"encoding/pem"
	"testing"
)

func TestKeyConversions(t *testing.T) {

	const ECPrivateKey = `-----BEGIN PRIVATE KEY-----
MHcCAQEEIModxWofWpbtNo6KlPEUzX6M5BoqVhcriHM/jtQYcDMDoAoGCCqGSM49
AwEHoUQDQgAE2mFHYH1k9QGmpzTirHWgGtRRKmFh8deqKNZVUuxEH4sIQrj2zOkP
7YzeEixA9G+d7ZEPp221fqA5i0u+PchowA==
-----END PRIVATE KEY-----`

	expectedECRawKeyBytes := []byte{123, 34, 99, 114, 118, 34, 58, 123, 34, 67, 117, 114, 118, 101, 34, 58, 123, 34, 80, 34, 58, 49, 49, 53, 55, 57, 50, 48, 56, 57, 50, 49, 48, 51, 53, 54, 50, 52, 56, 55, 54, 50, 54, 57, 55, 52, 52, 54, 57, 52, 57, 52, 48, 55, 53, 55, 51, 53, 51, 48, 48, 56, 54, 49, 52, 51, 52, 49, 53, 50, 57, 48, 51, 49, 52, 49, 57, 53, 53, 51, 51, 54, 51, 49, 51, 48, 56, 56, 54, 55, 48, 57, 55, 56, 53, 51, 57, 53, 49, 44, 34, 78, 34, 58, 49, 49, 53, 55, 57, 50, 48, 56, 57, 50, 49, 48, 51, 53, 54, 50, 52, 56, 55, 54, 50, 54, 57, 55, 52, 52, 54, 57, 52, 57, 52, 48, 55, 53, 55, 51, 53, 50, 57, 57, 57, 54, 57, 53, 53, 50, 50, 52, 49, 51, 53, 55, 54, 48, 51, 52, 50, 52, 50, 50, 50, 53, 57, 48, 54, 49, 48, 54, 56, 53, 49, 50, 48, 52, 52, 51, 54, 57, 44, 34, 66, 34, 58, 52, 49, 48, 53, 56, 51, 54, 51, 55, 50, 53, 49, 53, 50, 49, 52, 50, 49, 50, 57, 51, 50, 54, 49, 50, 57, 55, 56, 48, 48, 52, 55, 50, 54, 56, 52, 48, 57, 49, 49, 52, 52, 52, 49, 48, 49, 53, 57, 57, 51, 55, 50, 53, 53, 53, 52, 56, 51, 53, 50, 53, 54, 51, 49, 52, 48, 51, 57, 52, 54, 55, 52, 48, 49, 50, 57, 49, 44, 34, 71, 120, 34, 58, 52, 56, 52, 51, 57, 53, 54, 49, 50, 57, 51, 57, 48, 54, 52, 53, 49, 55, 53, 57, 48, 53, 50, 53, 56, 53, 50, 53, 50, 55, 57, 55, 57, 49, 52, 50, 48, 50, 55, 54, 50, 57, 52, 57, 53, 50, 54, 48, 52, 49, 55, 52, 55, 57, 57, 53, 56, 52, 52, 48, 56, 48, 55, 49, 55, 48, 56, 50, 52, 48, 52, 54, 51, 53, 50, 56, 54, 44, 34, 71, 121, 34, 58, 51, 54, 49, 51, 52, 50, 53, 48, 57, 53, 54, 55, 52, 57, 55, 57, 53, 55, 57, 56, 53, 56, 53, 49, 50, 55, 57, 49, 57, 53, 56, 55, 56, 56, 49, 57, 53, 54, 54, 49, 49, 49, 48, 54, 54, 55, 50, 57, 56, 53, 48, 49, 53, 48, 55, 49, 56, 55, 55, 49, 57, 56, 50, 53, 51, 53, 54, 56, 52, 49, 52, 52, 48, 53, 49, 48, 57, 44, 34, 66, 105, 116, 83, 105, 122, 101, 34, 58, 50, 53, 54, 44, 34, 78, 97, 109, 101, 34, 58, 34, 80, 45, 50, 53, 54, 34, 125, 125, 44, 34, 100, 34, 58, 34, 121, 104, 51, 70, 97, 104, 57, 97, 108, 117, 48, 50, 106, 111, 113, 85, 56, 82, 84, 78, 102, 111, 122, 107, 71, 105, 112, 87, 70, 121, 117, 73, 99, 122, 45, 79, 49, 66, 104, 119, 77, 119, 77, 34, 44, 34, 120, 34, 58, 34, 50, 109, 70, 72, 89, 72, 49, 107, 57, 81, 71, 109, 112, 122, 84, 105, 114, 72, 87, 103, 71, 116, 82, 82, 75, 109, 70, 104, 56, 100, 101, 113, 75, 78, 90, 86, 85, 117, 120, 69, 72, 52, 115, 34, 44, 34, 121, 34, 58, 34, 67, 69, 75, 52, 57, 115, 122, 112, 68, 45, 50, 77, 51, 104, 73, 115, 81, 80, 82, 118, 110, 101, 50, 82, 68, 54, 100, 116, 116, 88, 54, 103, 79, 89, 116, 76, 118, 106, 51, 73, 97, 77, 65, 34, 125}

	t.Run("RawKeyFromPrivateKey", func(t *testing.T) {

		block, _ := pem.Decode([]byte(ECPrivateKey))
		privateKey, err := x509.ParseECPrivateKey(block.Bytes)
		if err != nil {
			t.Fatal("Failed to parse EC Private Key")
		}
		rawKey := NewRawKeyFromPrivateKey(privateKey)
		rawKeyBytes, err := json.Marshal(rawKey)
		if err != nil {
			t.Fatal("Failed to json marshal EC Raw Key")
		}
		if bytes.Compare(expectedECRawKeyBytes, rawKeyBytes) != 0 {
			t.Fatal("Keys do not match")
		}
	})

}
