/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.bundle.Config;
import com.android.tools.build.bundletool.androidtools.Aapt2Command;
import com.android.tools.build.bundletool.io.ApkSerializerHelper;
import com.android.tools.build.bundletool.io.ConcurrencyUtils;
import com.android.tools.build.bundletool.io.ModuleEntriesPack;
import com.android.tools.build.bundletool.io.ModuleEntriesPacker;
import com.android.tools.build.bundletool.io.SerializationFilesManager;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.io.Zipper;
import com.android.tools.build.bundletool.model.Bundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.ZipUtils;
import com.android.zipflinger.ZipArchive;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import javax.inject.Inject;

class Aapt2ResourceConverter {
    private final Aapt2Command aapt2Command;
    private final ListeningExecutorService executorService;
    private final Config.ResourceOptimizations.CollapsedResourceNames collapsedResourceNames;
    private final Supplier<Optional<Path>> resourceConfigSupplier;

    @Inject
    Aapt2ResourceConverter(Aapt2Command aapt2Command, ListeningExecutorService executorService, Bundle bundle, Config.BundleConfig bundleConfig, TempDirectory tempDirectory) {
        this.aapt2Command = aapt2Command;
        this.executorService = executorService;
        this.collapsedResourceNames = bundleConfig.getOptimizations().getResourceOptimizations().getCollapsedResourceNames();
        this.resourceConfigSupplier = Suppliers.memoize(() -> Aapt2ResourceConverter.createResourceConfig(tempDirectory, bundle, this.collapsedResourceNames));
    }

    public ImmutableList<ModuleSplit> convert(Collection<ModuleSplit> allSplits, SerializationFilesManager filesManager) {
        ModuleEntriesPacker packer = new ModuleEntriesPacker(filesManager.getResourcesEntriesPackPath(), "r_");
        allSplits.stream().flatMap(split -> split.getEntries().stream()).filter(entry -> ApkSerializerHelper.requiresAapt2Conversion(ApkSerializerHelper.toApkEntryPath(entry.getPath()))).forEach(packer::add);
        ModuleEntriesPack allResourcesUncompressedPack = packer.pack(Zipper.uncompressedZip());
        ResourceConverter resourceConverter = new ResourceConverter(filesManager, allResourcesUncompressedPack);
        ImmutableList binarySplitFutures = allSplits.stream().map(split -> this.executorService.submit(() -> resourceConverter.convertResourcesToBinary((ModuleSplit)split))).collect(ImmutableList.toImmutableList());
        return ConcurrencyUtils.waitForAll(binarySplitFutures);
    }

    private static Optional<Path> createResourceConfig(TempDirectory tempDirectory, Bundle bundle, Config.ResourceOptimizations.CollapsedResourceNames collapsedResourceNames) {
        if (!collapsedResourceNames.getCollapseResourceNames() || collapsedResourceNames.getNoCollapseResourcesCount() == 0 && collapsedResourceNames.getNoCollapseResourceTypesCount() == 0) {
            return Optional.empty();
        }
        try {
            Path resourceConfigPath = Files.createTempFile(tempDirectory.getPath(), "aapt2-resource", ".cfg", new FileAttribute[0]);
            ImmutableList configLines = Stream.concat(collapsedResourceNames.getNoCollapseResourcesList().stream(), Aapt2ResourceConverter.expandExcludedResourceTypes(bundle, collapsedResourceNames).stream()).map(typeAndName -> String.format("%s/%s#no_collapse", typeAndName.getType(), typeAndName.getName())).collect(ImmutableList.toImmutableList());
            Files.write(resourceConfigPath, configLines, new OpenOption[0]);
            return Optional.of(resourceConfigPath);
        }
        catch (IOException e11) {
            throw new UncheckedIOException(e11);
        }
    }

    private static ImmutableList<Config.ResourceOptimizations.ResourceTypeAndName> expandExcludedResourceTypes(Bundle bundle, Config.ResourceOptimizations.CollapsedResourceNames collapsedResourceNames) {
        if (collapsedResourceNames.getNoCollapseResourceTypesCount() == 0) {
            return ImmutableList.of();
        }
        ImmutableSet<String> excludedTypes = ImmutableSet.copyOf(collapsedResourceNames.getNoCollapseResourceTypesList());
        return bundle.getModules().values().stream().filter(bundleModule -> bundleModule.getResourceTable().isPresent()).map(bundleModule -> bundleModule.getResourceTable().get()).flatMap(resourceTable -> resourceTable.getPackageList().stream()).flatMap(resourcePackage -> resourcePackage.getTypeList().stream()).filter(type -> excludedTypes.contains(type.getName())).flatMap(type -> type.getEntryList().stream().map(entry -> Config.ResourceOptimizations.ResourceTypeAndName.newBuilder().setName(entry.getName()).setType(type.getName()).build())).collect(ImmutableList.toImmutableList());
    }

    private class ResourceConverter {
        private final SerializationFilesManager filesManager;
        private final ModuleEntriesPack packWithResourceEntries;

        ResourceConverter(SerializationFilesManager filesManager, ModuleEntriesPack packWithResourceEntries) {
            this.filesManager = filesManager;
            this.packWithResourceEntries = packWithResourceEntries;
        }

        public ModuleSplit convertResourcesToBinary(ModuleSplit split) {
            try {
                Path protoApkPath = this.writePartialProtoApk(split);
                Path binaryApkPath = this.convertAndOptimizeProtoApk(split, protoApkPath);
                Files.delete(protoApkPath);
                return this.withConvertedEntries(split, binaryApkPath);
            }
            catch (IOException e11) {
                throw new UncheckedIOException(e11);
            }
        }

        private Path writePartialProtoApk(ModuleSplit split) throws IOException {
            Path protoApkPath = this.filesManager.getNextAapt2ProtoApkPath();
            try (ZipArchive protoApk = new ZipArchive(protoApkPath);){
                ImmutableList<ModuleEntry> entriesToConvert = split.getEntries().stream().filter(entry -> ApkSerializerHelper.requiresAapt2Conversion(ApkSerializerHelper.toApkEntryPath(entry.getPath()))).collect(ImmutableList.toImmutableList());
                protoApk.add(this.packWithResourceEntries.select(entriesToConvert, entry -> ApkSerializerHelper.toApkEntryPath(entry.getPath()).toString()));
            }
            return protoApkPath;
        }

        private Path convertAndOptimizeProtoApk(ModuleSplit split, Path protoApkPath) {
            Path binaryApkPath = this.filesManager.getNextAapt2BinaryApkPath();
            Aapt2ResourceConverter.this.aapt2Command.convertApkProtoToBinary(protoApkPath, binaryApkPath, Aapt2Command.ConvertOptions.builder().setForceSparseEncoding(split.getSparseEncoding()).setCollapseResourceNames(Aapt2ResourceConverter.this.collapsedResourceNames.getCollapseResourceNames()).setDeduplicateResourceEntries(Aapt2ResourceConverter.this.collapsedResourceNames.getDeduplicateResourceEntries()).setResourceConfigPath((Optional)Aapt2ResourceConverter.this.resourceConfigSupplier.get()).build());
            return binaryApkPath;
        }

        private ModuleSplit withConvertedEntries(ModuleSplit split, Path binaryApkPath) {
            ZipFile binaryZip = this.filesManager.openBinaryApk(binaryApkPath);
            Stream<ModuleEntry> otherEntriesStream = split.getEntries().stream().filter(entry -> !ApkSerializerHelper.requiresAapt2Conversion(ApkSerializerHelper.toApkEntryPath(entry.getPath())));
            Stream<ModuleEntry> resourceEntriesStream = binaryZip.stream().filter(zipEntry -> zipEntry.getName().startsWith("res/")).map(zipEntry -> ModuleEntry.builder().setPath(ZipPath.create(zipEntry.getName())).setContent(ZipUtils.asByteSource(binaryZip, zipEntry)).build());
            ModuleEntry manifestEntry = ModuleEntry.builder().setContent(ZipUtils.asByteSource(binaryZip, binaryZip.getEntry("AndroidManifest.xml"))).setPath(BundleModule.SpecialModuleEntry.ANDROID_MANIFEST.getPath()).setForceUncompressed(false).build();
            Optional<ModuleEntry> resourceTableEntry = Optional.ofNullable(binaryZip.getEntry("resources.arsc")).map(zipEntry -> ModuleEntry.builder().setContent(ZipUtils.asByteSource(binaryZip, zipEntry)).setPath(BundleModule.SpecialModuleEntry.RESOURCE_TABLE.getPath()).setForceUncompressed(true).build());
            ImmutableList<ModuleEntry> allEntries = Streams.concat(Stream.of(manifestEntry), Streams.stream(resourceTableEntry), resourceEntriesStream, otherEntriesStream).collect(ImmutableList.toImmutableList());
            return split.toBuilder().setEntries(allEntries).build();
        }
    }
}

