#include "gimme_config_h.h"

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif

#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif

#include "cdstatus.h"
#include "cdstatus_cddb.h"
#include "build_output_filename.h"
#include "cdstatus_output.h"

void buildOutputFilename(const cdstatus_args * cdsargs, unsigned int counter, char *filename_out)
{
    char filename[CDSTATUS_PATH_MAX];
    char scratch[3];
    char pathname[CDSTATUS_PATH_MAX];
    unsigned int index = 0;

	filename[0] = '\0';
    pathname[0] = '\0';

    if (cdsargs->cddb == 0)
    {
        (void)snprintf(filename, sizeof(filename), "%s%02u", cdsargs->basename, counter);
    }
    else
    {

        /* If you're using --cddb and/or --format WITHOUT .wav output, you're either crazy
         * or doing something really complicated, but I'll support your nutso self */
        if (cdsargs->format_on==0)
        {
            (void)snprintf(filename, sizeof(filename), "%s/%s/%s_-_%s_-_%02u_-_%s", artist_name, album_name, artist_name, album_name, counter, trackinfo[counter].title);
        }

        /* Parse format string */
        else
        {
            filename[0] = '\0';

            while (index < (unsigned int)strlen(cdsargs->format))
            {
                if (cdsargs->format[index] != '#')
                {
                    strncat(filename, &(cdsargs->format[index]), 1);
                    ++index;
                }
                else
                {
                    if (!strncasecmp(&(cdsargs->format[index]), "#artist#", strlen("#artist#")))
                    {
                        strncat(filename, artist_name, (sizeof(filename)-strlen(filename))-1);
                        index += strlen("#artist#");
                    }
                    else if (!strncasecmp(&(cdsargs->format[index]), "#album#", strlen("#album#")))
                    {
                        strncat(filename, album_name, (sizeof(filename)-strlen(filename))-1);
                        index += strlen("#album#");
                    }
                    else if (!strncasecmp(&(cdsargs->format[index]), "#trknum#", strlen("#trknum#")))
                    {
                        (void)snprintf(scratch, sizeof(scratch), "%02u", counter);
                        strncat(filename, scratch, (sizeof(filename)-strlen(filename))-1);
                        index += strlen("#trknum#");
                    }
                    else if (!strncasecmp(&(cdsargs->format[index]), "#trkname#", strlen("#trkname#")))
                    {
                        strncat(filename, trackinfo[counter].title, (sizeof(filename)-strlen(filename))-1);
                        index += strlen("#trkname#");
                    }
                    else
                    {
                        strncat(filename, &(cdsargs->format[index]), (sizeof(filename)-strlen(filename))-1);
                        ++index;
                    }
                }
            }
        }
    }

	switch(cdsargs->encoder) {
		case ENC_NULL:
		{
			/* we'll be throwing away the bits */
			strncpy(filename_out, "/dev/null", CDSTATUS_PATH_MAX-1);
			filename_out[CDSTATUS_PATH_MAX - 1] = '\0';
			break;
		}
		case ENC_RAW:
		{
       		strncat(filename, ".raw", (sizeof(filename)-strlen(filename))-1);
			break;
		}
       	case ENC_WAVE:
       	{
           	strncat(filename, ".wav", (sizeof(filename)-strlen(filename))-1);
            break;
       	}
       	case ENC_LAME:
		{
            strncat(filename, ".mp3", (sizeof(filename)-strlen(filename))-1);
			break;
        }
		case ENC_TOOLAME:
		{
            strncat(filename, ".mp2", (sizeof(filename)-strlen(filename))-1);
			break;
        }
		case ENC_OGGENC:
		{
            strncat(filename, ".ogg", (sizeof(filename)-strlen(filename))-1);
			break;
        }
		default:
		{
			conditional_perror(CRITICAL, "Unknown encoder type encountered in build_output_filename.c.  Please examine encoder options. Exiting.");
			exit(EXIT_FAILURE);
		}
	}

	if(cdsargs->encoder != ENC_NULL)
	{
    	if((unsigned)snprintf(filename_out, CDSTATUS_PATH_MAX, "%s/%s", cdsargs->outputdir, filename) > CDSTATUS_PATH_MAX)
		{
			conditional_printf(WARNING, "Warning, total output path and filename length exceeds maximum (%u), truncated to: %s\n", CDSTATUS_PATH_MAX, filename_out);
		}
	}

    return;
}
