// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Specifies the precise location within a source document where cited content can be found. This can include character-level positions, page numbers, or document chunks depending on the document type and indexing method.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub enum CitationLocation {
    /// <p>The character-level location within the document where the cited content is found.</p>
    DocumentChar(crate::types::DocumentCharLocation),
    /// <p>The chunk-level location within the document where the cited content is found, typically used for documents that have been segmented into logical chunks.</p>
    DocumentChunk(crate::types::DocumentChunkLocation),
    /// <p>The page-level location within the document where the cited content is found.</p>
    DocumentPage(crate::types::DocumentPageLocation),
    /// <p>The web URL that was cited for this reference.</p>
    Web(crate::types::WebLocation),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl CitationLocation {
    /// Tries to convert the enum instance into [`DocumentChar`](crate::types::CitationLocation::DocumentChar), extracting the inner [`DocumentCharLocation`](crate::types::DocumentCharLocation).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_document_char(&self) -> ::std::result::Result<&crate::types::DocumentCharLocation, &Self> {
        if let CitationLocation::DocumentChar(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`DocumentChar`](crate::types::CitationLocation::DocumentChar).
    pub fn is_document_char(&self) -> bool {
        self.as_document_char().is_ok()
    }
    /// Tries to convert the enum instance into [`DocumentChunk`](crate::types::CitationLocation::DocumentChunk), extracting the inner [`DocumentChunkLocation`](crate::types::DocumentChunkLocation).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_document_chunk(&self) -> ::std::result::Result<&crate::types::DocumentChunkLocation, &Self> {
        if let CitationLocation::DocumentChunk(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`DocumentChunk`](crate::types::CitationLocation::DocumentChunk).
    pub fn is_document_chunk(&self) -> bool {
        self.as_document_chunk().is_ok()
    }
    /// Tries to convert the enum instance into [`DocumentPage`](crate::types::CitationLocation::DocumentPage), extracting the inner [`DocumentPageLocation`](crate::types::DocumentPageLocation).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_document_page(&self) -> ::std::result::Result<&crate::types::DocumentPageLocation, &Self> {
        if let CitationLocation::DocumentPage(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`DocumentPage`](crate::types::CitationLocation::DocumentPage).
    pub fn is_document_page(&self) -> bool {
        self.as_document_page().is_ok()
    }
    /// Tries to convert the enum instance into [`Web`](crate::types::CitationLocation::Web), extracting the inner [`WebLocation`](crate::types::WebLocation).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_web(&self) -> ::std::result::Result<&crate::types::WebLocation, &Self> {
        if let CitationLocation::Web(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`Web`](crate::types::CitationLocation::Web).
    pub fn is_web(&self) -> bool {
        self.as_web().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}
