// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Provides the URL and domain information for the website that was cited when performing a web search.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct WebLocation {
    /// <p>The URL that was cited when performing a web search.</p>
    pub url: ::std::option::Option<::std::string::String>,
    /// <p>The domain that was cited when performing a web search.</p>
    pub domain: ::std::option::Option<::std::string::String>,
}
impl WebLocation {
    /// <p>The URL that was cited when performing a web search.</p>
    pub fn url(&self) -> ::std::option::Option<&str> {
        self.url.as_deref()
    }
    /// <p>The domain that was cited when performing a web search.</p>
    pub fn domain(&self) -> ::std::option::Option<&str> {
        self.domain.as_deref()
    }
}
impl WebLocation {
    /// Creates a new builder-style object to manufacture [`WebLocation`](crate::types::WebLocation).
    pub fn builder() -> crate::types::builders::WebLocationBuilder {
        crate::types::builders::WebLocationBuilder::default()
    }
}

/// A builder for [`WebLocation`](crate::types::WebLocation).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct WebLocationBuilder {
    pub(crate) url: ::std::option::Option<::std::string::String>,
    pub(crate) domain: ::std::option::Option<::std::string::String>,
}
impl WebLocationBuilder {
    /// <p>The URL that was cited when performing a web search.</p>
    pub fn url(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.url = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The URL that was cited when performing a web search.</p>
    pub fn set_url(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.url = input;
        self
    }
    /// <p>The URL that was cited when performing a web search.</p>
    pub fn get_url(&self) -> &::std::option::Option<::std::string::String> {
        &self.url
    }
    /// <p>The domain that was cited when performing a web search.</p>
    pub fn domain(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.domain = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The domain that was cited when performing a web search.</p>
    pub fn set_domain(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.domain = input;
        self
    }
    /// <p>The domain that was cited when performing a web search.</p>
    pub fn get_domain(&self) -> &::std::option::Option<::std::string::String> {
        &self.domain
    }
    /// Consumes the builder and constructs a [`WebLocation`](crate::types::WebLocation).
    pub fn build(self) -> crate::types::WebLocation {
        crate::types::WebLocation {
            url: self.url,
            domain: self.domain,
        }
    }
}
