// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: ccl/backupccl/backup.proto

/*
	Package backupccl is a generated protocol buffer package.

	It is generated from these files:
		ccl/backupccl/backup.proto

	It has these top-level messages:
		BackupDescriptor
*/
package backupccl

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import cockroach_build "github.com/cockroachdb/cockroach/pkg/build"
import cockroach_roachpb3 "github.com/cockroachdb/cockroach/pkg/roachpb"
import cockroach_roachpb1 "github.com/cockroachdb/cockroach/pkg/roachpb"
import cockroach_sql_sqlbase1 "github.com/cockroachdb/cockroach/pkg/sql/sqlbase"
import cockroach_util_hlc "github.com/cockroachdb/cockroach/pkg/util/hlc"

import github_com_cockroachdb_cockroach_pkg_sql_sqlbase "github.com/cockroachdb/cockroach/pkg/sql/sqlbase"
import github_com_cockroachdb_cockroach_pkg_util_uuid "github.com/cockroachdb/cockroach/pkg/util/uuid"
import github_com_cockroachdb_cockroach_pkg_roachpb "github.com/cockroachdb/cockroach/pkg/roachpb"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type MVCCFilter int32

const (
	MVCCFilter_Latest MVCCFilter = 0
	MVCCFilter_All    MVCCFilter = 1
)

var MVCCFilter_name = map[int32]string{
	0: "Latest",
	1: "All",
}
var MVCCFilter_value = map[string]int32{
	"Latest": 0,
	"All":    1,
}

func (x MVCCFilter) String() string {
	return proto.EnumName(MVCCFilter_name, int32(x))
}
func (MVCCFilter) EnumDescriptor() ([]byte, []int) { return fileDescriptorBackup, []int{0} }

// BackupDescriptor represents a consistent snapshot of ranges.
//
// Each range snapshot includes a path to data that is a diff of the data in
// that key range between a start and end timestamp. The end timestamp of all
// ranges in a backup is the same, but the start may vary (to allow individual
// tables to be backed up on different schedules).
type BackupDescriptor struct {
	StartTime  cockroach_util_hlc.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime" json:"start_time"`
	EndTime    cockroach_util_hlc.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime" json:"end_time"`
	MVCCFilter MVCCFilter                   `protobuf:"varint,13,opt,name=mvcc_filter,json=mvccFilter,proto3,enum=cockroach.ccl.backupccl.MVCCFilter" json:"mvcc_filter,omitempty"`
	// Even if StartTime is zero, we only get revisions since gc threshold, so
	// do not allow AS OF SYSTEM TIME before revision_start_time.
	RevisionStartTime cockroach_util_hlc.Timestamp `protobuf:"bytes,17,opt,name=revision_start_time,json=revisionStartTime" json:"revision_start_time"`
	// Spans contains the spans requested for backup. The keyranges covered by
	// `files` may be a subset of this if there were ranges with no changes since
	// the last backup. For all tables in the backup descriptor, these spans must
	// completely cover each table's span. For example, if a table with ID 51 were
	// being backed up, then the span `/Table/5{1-2}` must be completely covered.
	Spans []cockroach_roachpb1.Span `protobuf:"bytes,3,rep,name=spans" json:"spans"`
	// IntroducedSpans are a subset of spans, set only when creating incremental
	// backups that cover spans not included in a previous backup. Spans contained
	// here are covered in the interval (0, startTime], which, in conjunction with
	// the coverage from (startTime, endTime] implied for all spans in Spans,
	// results in coverage from [0, endTime] for these spans.
	IntroducedSpans   []cockroach_roachpb1.Span             `protobuf:"bytes,15,rep,name=introduced_spans,json=introducedSpans" json:"introduced_spans"`
	DescriptorChanges []BackupDescriptor_DescriptorRevision `protobuf:"bytes,16,rep,name=descriptor_changes,json=descriptorChanges" json:"descriptor_changes"`
	Files             []BackupDescriptor_File               `protobuf:"bytes,4,rep,name=files" json:"files"`
	Descriptors       []cockroach_sql_sqlbase1.Descriptor   `protobuf:"bytes,5,rep,name=descriptors" json:"descriptors"`
	// databases in descriptors that have all tables also in descriptors.
	CompleteDbs   []github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID `protobuf:"varint,14,rep,packed,name=complete_dbs,json=completeDbs,casttype=github.com/cockroachdb/cockroach/pkg/sql/sqlbase.ID" json:"complete_dbs,omitempty"`
	EntryCounts   cockroach_roachpb3.BulkOpSummary                      `protobuf:"bytes,12,opt,name=entry_counts,json=entryCounts" json:"entry_counts"`
	Dir           cockroach_roachpb3.ExportStorage                      `protobuf:"bytes,7,opt,name=dir" json:"dir"`
	FormatVersion uint32                                                `protobuf:"varint,8,opt,name=format_version,json=formatVersion,proto3" json:"format_version,omitempty"`
	ClusterID     github_com_cockroachdb_cockroach_pkg_util_uuid.UUID   `protobuf:"bytes,9,opt,name=cluster_id,json=clusterId,proto3,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"cluster_id"`
	// node_id and build_info of the gateway node (which writes the descriptor).
	NodeID    github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,10,opt,name=node_id,json=nodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id,omitempty"`
	BuildInfo cockroach_build.Info                                `protobuf:"bytes,11,opt,name=build_info,json=buildInfo" json:"build_info"`
}

func (m *BackupDescriptor) Reset()                    { *m = BackupDescriptor{} }
func (m *BackupDescriptor) String() string            { return proto.CompactTextString(m) }
func (*BackupDescriptor) ProtoMessage()               {}
func (*BackupDescriptor) Descriptor() ([]byte, []int) { return fileDescriptorBackup, []int{0} }

// BackupDescriptor_File represents a file that contains the diff for a key
// range between two timestamps.
type BackupDescriptor_File struct {
	Span        cockroach_roachpb1.Span          `protobuf:"bytes,1,opt,name=span" json:"span"`
	Path        string                           `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	Sha512      []byte                           `protobuf:"bytes,4,opt,name=sha512,proto3" json:"sha512,omitempty"`
	EntryCounts cockroach_roachpb3.BulkOpSummary `protobuf:"bytes,6,opt,name=entry_counts,json=entryCounts" json:"entry_counts"`
	// StartTime 0 is sometimes legitimately used, so it is only meaningful if
	// EndTime is non-zero, otherwise both just inherit from containing backup.
	StartTime cockroach_util_hlc.Timestamp `protobuf:"bytes,7,opt,name=start_time,json=startTime" json:"start_time"`
	EndTime   cockroach_util_hlc.Timestamp `protobuf:"bytes,8,opt,name=end_time,json=endTime" json:"end_time"`
}

func (m *BackupDescriptor_File) Reset()                    { *m = BackupDescriptor_File{} }
func (m *BackupDescriptor_File) String() string            { return proto.CompactTextString(m) }
func (*BackupDescriptor_File) ProtoMessage()               {}
func (*BackupDescriptor_File) Descriptor() ([]byte, []int) { return fileDescriptorBackup, []int{0, 0} }

type BackupDescriptor_DescriptorRevision struct {
	Time cockroach_util_hlc.Timestamp                        `protobuf:"bytes,1,opt,name=time" json:"time"`
	ID   github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID `protobuf:"varint,2,opt,name=ID,proto3,casttype=github.com/cockroachdb/cockroach/pkg/sql/sqlbase.ID" json:"ID,omitempty"`
	Desc *cockroach_sql_sqlbase1.Descriptor                  `protobuf:"bytes,3,opt,name=desc" json:"desc,omitempty"`
}

func (m *BackupDescriptor_DescriptorRevision) Reset()         { *m = BackupDescriptor_DescriptorRevision{} }
func (m *BackupDescriptor_DescriptorRevision) String() string { return proto.CompactTextString(m) }
func (*BackupDescriptor_DescriptorRevision) ProtoMessage()    {}
func (*BackupDescriptor_DescriptorRevision) Descriptor() ([]byte, []int) {
	return fileDescriptorBackup, []int{0, 1}
}

func init() {
	proto.RegisterType((*BackupDescriptor)(nil), "cockroach.ccl.backupccl.BackupDescriptor")
	proto.RegisterType((*BackupDescriptor_File)(nil), "cockroach.ccl.backupccl.BackupDescriptor.File")
	proto.RegisterType((*BackupDescriptor_DescriptorRevision)(nil), "cockroach.ccl.backupccl.BackupDescriptor.DescriptorRevision")
	proto.RegisterEnum("cockroach.ccl.backupccl.MVCCFilter", MVCCFilter_name, MVCCFilter_value)
}
func (m *BackupDescriptor) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BackupDescriptor) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintBackup(dAtA, i, uint64(m.StartTime.Size()))
	n1, err := m.StartTime.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	dAtA[i] = 0x12
	i++
	i = encodeVarintBackup(dAtA, i, uint64(m.EndTime.Size()))
	n2, err := m.EndTime.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	if len(m.Spans) > 0 {
		for _, msg := range m.Spans {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintBackup(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Files) > 0 {
		for _, msg := range m.Files {
			dAtA[i] = 0x22
			i++
			i = encodeVarintBackup(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Descriptors) > 0 {
		for _, msg := range m.Descriptors {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintBackup(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x3a
	i++
	i = encodeVarintBackup(dAtA, i, uint64(m.Dir.Size()))
	n3, err := m.Dir.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	if m.FormatVersion != 0 {
		dAtA[i] = 0x40
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.FormatVersion))
	}
	dAtA[i] = 0x4a
	i++
	i = encodeVarintBackup(dAtA, i, uint64(m.ClusterID.Size()))
	n4, err := m.ClusterID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n4
	if m.NodeID != 0 {
		dAtA[i] = 0x50
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.NodeID))
	}
	dAtA[i] = 0x5a
	i++
	i = encodeVarintBackup(dAtA, i, uint64(m.BuildInfo.Size()))
	n5, err := m.BuildInfo.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	dAtA[i] = 0x62
	i++
	i = encodeVarintBackup(dAtA, i, uint64(m.EntryCounts.Size()))
	n6, err := m.EntryCounts.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n6
	if m.MVCCFilter != 0 {
		dAtA[i] = 0x68
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.MVCCFilter))
	}
	if len(m.CompleteDbs) > 0 {
		dAtA8 := make([]byte, len(m.CompleteDbs)*10)
		var j7 int
		for _, num := range m.CompleteDbs {
			for num >= 1<<7 {
				dAtA8[j7] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j7++
			}
			dAtA8[j7] = uint8(num)
			j7++
		}
		dAtA[i] = 0x72
		i++
		i = encodeVarintBackup(dAtA, i, uint64(j7))
		i += copy(dAtA[i:], dAtA8[:j7])
	}
	if len(m.IntroducedSpans) > 0 {
		for _, msg := range m.IntroducedSpans {
			dAtA[i] = 0x7a
			i++
			i = encodeVarintBackup(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.DescriptorChanges) > 0 {
		for _, msg := range m.DescriptorChanges {
			dAtA[i] = 0x82
			i++
			dAtA[i] = 0x1
			i++
			i = encodeVarintBackup(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x8a
	i++
	dAtA[i] = 0x1
	i++
	i = encodeVarintBackup(dAtA, i, uint64(m.RevisionStartTime.Size()))
	n9, err := m.RevisionStartTime.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n9
	return i, nil
}

func (m *BackupDescriptor_File) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BackupDescriptor_File) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintBackup(dAtA, i, uint64(m.Span.Size()))
	n10, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n10
	if len(m.Path) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Path)))
		i += copy(dAtA[i:], m.Path)
	}
	if len(m.Sha512) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Sha512)))
		i += copy(dAtA[i:], m.Sha512)
	}
	dAtA[i] = 0x32
	i++
	i = encodeVarintBackup(dAtA, i, uint64(m.EntryCounts.Size()))
	n11, err := m.EntryCounts.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n11
	dAtA[i] = 0x3a
	i++
	i = encodeVarintBackup(dAtA, i, uint64(m.StartTime.Size()))
	n12, err := m.StartTime.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n12
	dAtA[i] = 0x42
	i++
	i = encodeVarintBackup(dAtA, i, uint64(m.EndTime.Size()))
	n13, err := m.EndTime.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n13
	return i, nil
}

func (m *BackupDescriptor_DescriptorRevision) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BackupDescriptor_DescriptorRevision) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintBackup(dAtA, i, uint64(m.Time.Size()))
	n14, err := m.Time.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n14
	if m.ID != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.ID))
	}
	if m.Desc != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.Desc.Size()))
		n15, err := m.Desc.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	return i, nil
}

func encodeVarintBackup(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *BackupDescriptor) Size() (n int) {
	var l int
	_ = l
	l = m.StartTime.Size()
	n += 1 + l + sovBackup(uint64(l))
	l = m.EndTime.Size()
	n += 1 + l + sovBackup(uint64(l))
	if len(m.Spans) > 0 {
		for _, e := range m.Spans {
			l = e.Size()
			n += 1 + l + sovBackup(uint64(l))
		}
	}
	if len(m.Files) > 0 {
		for _, e := range m.Files {
			l = e.Size()
			n += 1 + l + sovBackup(uint64(l))
		}
	}
	if len(m.Descriptors) > 0 {
		for _, e := range m.Descriptors {
			l = e.Size()
			n += 1 + l + sovBackup(uint64(l))
		}
	}
	l = m.Dir.Size()
	n += 1 + l + sovBackup(uint64(l))
	if m.FormatVersion != 0 {
		n += 1 + sovBackup(uint64(m.FormatVersion))
	}
	l = m.ClusterID.Size()
	n += 1 + l + sovBackup(uint64(l))
	if m.NodeID != 0 {
		n += 1 + sovBackup(uint64(m.NodeID))
	}
	l = m.BuildInfo.Size()
	n += 1 + l + sovBackup(uint64(l))
	l = m.EntryCounts.Size()
	n += 1 + l + sovBackup(uint64(l))
	if m.MVCCFilter != 0 {
		n += 1 + sovBackup(uint64(m.MVCCFilter))
	}
	if len(m.CompleteDbs) > 0 {
		l = 0
		for _, e := range m.CompleteDbs {
			l += sovBackup(uint64(e))
		}
		n += 1 + sovBackup(uint64(l)) + l
	}
	if len(m.IntroducedSpans) > 0 {
		for _, e := range m.IntroducedSpans {
			l = e.Size()
			n += 1 + l + sovBackup(uint64(l))
		}
	}
	if len(m.DescriptorChanges) > 0 {
		for _, e := range m.DescriptorChanges {
			l = e.Size()
			n += 2 + l + sovBackup(uint64(l))
		}
	}
	l = m.RevisionStartTime.Size()
	n += 2 + l + sovBackup(uint64(l))
	return n
}

func (m *BackupDescriptor_File) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovBackup(uint64(l))
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.Sha512)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = m.EntryCounts.Size()
	n += 1 + l + sovBackup(uint64(l))
	l = m.StartTime.Size()
	n += 1 + l + sovBackup(uint64(l))
	l = m.EndTime.Size()
	n += 1 + l + sovBackup(uint64(l))
	return n
}

func (m *BackupDescriptor_DescriptorRevision) Size() (n int) {
	var l int
	_ = l
	l = m.Time.Size()
	n += 1 + l + sovBackup(uint64(l))
	if m.ID != 0 {
		n += 1 + sovBackup(uint64(m.ID))
	}
	if m.Desc != nil {
		l = m.Desc.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	return n
}

func sovBackup(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozBackup(x uint64) (n int) {
	return sovBackup(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *BackupDescriptor) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BackupDescriptor: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BackupDescriptor: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.StartTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.EndTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spans", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Spans = append(m.Spans, cockroach_roachpb1.Span{})
			if err := m.Spans[len(m.Spans)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Files", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Files = append(m.Files, BackupDescriptor_File{})
			if err := m.Files[len(m.Files)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Descriptors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Descriptors = append(m.Descriptors, cockroach_sql_sqlbase1.Descriptor{})
			if err := m.Descriptors[len(m.Descriptors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dir", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Dir.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FormatVersion", wireType)
			}
			m.FormatVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FormatVersion |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ClusterID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BuildInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.BuildInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EntryCounts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.EntryCounts.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MVCCFilter", wireType)
			}
			m.MVCCFilter = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MVCCFilter |= (MVCCFilter(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 14:
			if wireType == 0 {
				var v github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowBackup
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.CompleteDbs = append(m.CompleteDbs, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowBackup
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthBackup
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowBackup
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.CompleteDbs = append(m.CompleteDbs, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field CompleteDbs", wireType)
			}
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntroducedSpans", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IntroducedSpans = append(m.IntroducedSpans, cockroach_roachpb1.Span{})
			if err := m.IntroducedSpans[len(m.IntroducedSpans)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DescriptorChanges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DescriptorChanges = append(m.DescriptorChanges, BackupDescriptor_DescriptorRevision{})
			if err := m.DescriptorChanges[len(m.DescriptorChanges)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RevisionStartTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RevisionStartTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BackupDescriptor_File) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: File: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: File: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sha512", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sha512 = append(m.Sha512[:0], dAtA[iNdEx:postIndex]...)
			if m.Sha512 == nil {
				m.Sha512 = []byte{}
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EntryCounts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.EntryCounts.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.StartTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.EndTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BackupDescriptor_DescriptorRevision) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DescriptorRevision: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DescriptorRevision: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Time", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Time.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			m.ID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ID |= (github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Desc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Desc == nil {
				m.Desc = &cockroach_sql_sqlbase1.Descriptor{}
			}
			if err := m.Desc.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipBackup(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthBackup
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowBackup
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipBackup(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthBackup = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowBackup   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("ccl/backupccl/backup.proto", fileDescriptorBackup) }

var fileDescriptorBackup = []byte{
	// 869 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x55, 0x4d, 0x6f, 0xdb, 0x46,
	0x10, 0x35, 0x2d, 0x5a, 0x1f, 0x23, 0xcb, 0xa1, 0xb7, 0x1f, 0x21, 0x84, 0x56, 0x52, 0x1a, 0x14,
	0x10, 0x7a, 0x20, 0x11, 0x1b, 0x41, 0x8a, 0xa2, 0x28, 0x10, 0x4a, 0x4d, 0x43, 0xa3, 0x1f, 0x00,
	0x95, 0xe4, 0xe0, 0x0b, 0x41, 0x2e, 0x57, 0x12, 0xe1, 0x15, 0x97, 0xde, 0x5d, 0x1a, 0xcd, 0xbf,
	0xe8, 0x4f, 0xea, 0xd1, 0x97, 0x02, 0x3d, 0x16, 0x3d, 0x08, 0xad, 0x7a, 0xed, 0x2f, 0xe8, 0xa9,
	0xe0, 0x92, 0x34, 0xd5, 0xa6, 0x46, 0x94, 0xe6, 0x36, 0x1c, 0xce, 0x7b, 0xb3, 0x3b, 0x7c, 0x6f,
	0x08, 0x7d, 0x8c, 0xa9, 0x1d, 0x06, 0xf8, 0x22, 0x4b, 0xeb, 0xc8, 0x4a, 0x39, 0x93, 0x0c, 0xdd,
	0xc5, 0x0c, 0x5f, 0x70, 0x16, 0xe0, 0xa5, 0x85, 0x31, 0xb5, 0x6e, 0xaa, 0xfa, 0x46, 0x98, 0xc5,
	0x34, 0xb2, 0xe3, 0x64, 0xce, 0x8a, 0xd2, 0xfe, 0xb1, 0x2a, 0x4b, 0x43, 0x3b, 0x48, 0xe3, 0x32,
	0x85, 0xaa, 0x54, 0x14, 0xc8, 0xa0, 0xcc, 0x7d, 0x20, 0x2e, 0xa9, 0x2d, 0x2e, 0x69, 0x18, 0x08,
	0x62, 0x0b, 0xc9, 0x33, 0x2c, 0x33, 0x4e, 0xa2, 0xf2, 0xad, 0x99, 0xc9, 0x98, 0xda, 0x4b, 0x8a,
	0x6d, 0x19, 0xaf, 0x88, 0x90, 0xc1, 0xaa, 0x3c, 0x49, 0xff, 0xdd, 0x05, 0x5b, 0x30, 0x15, 0xda,
	0x79, 0x54, 0x64, 0x3f, 0xfa, 0xb3, 0x07, 0x86, 0xa3, 0x0e, 0x35, 0x25, 0x02, 0xf3, 0x38, 0x95,
	0x8c, 0x23, 0x07, 0x40, 0xc8, 0x80, 0x4b, 0x3f, 0xe7, 0x30, 0xb5, 0x91, 0x36, 0xee, 0x9e, 0x7c,
	0x68, 0xd5, 0x37, 0xc9, 0x7b, 0x58, 0x4b, 0x8a, 0xad, 0x67, 0x55, 0x0f, 0x47, 0xbf, 0x5e, 0x0f,
	0xf7, 0xbc, 0x8e, 0x82, 0xe5, 0x59, 0xf4, 0x05, 0xb4, 0x49, 0x12, 0x15, 0x0c, 0xfb, 0xbb, 0x33,
	0xb4, 0x48, 0x12, 0x29, 0xfc, 0x29, 0x1c, 0x88, 0x34, 0x48, 0x84, 0xd9, 0x18, 0x35, 0xc6, 0xdd,
	0x93, 0xbb, 0x5b, 0xe0, 0x72, 0x28, 0xd6, 0x2c, 0x0d, 0x92, 0x12, 0x56, 0xd4, 0xa2, 0x33, 0x38,
	0x98, 0xc7, 0x94, 0x08, 0x53, 0x57, 0x20, 0xcb, 0xba, 0x65, 0xfa, 0xd6, 0xbf, 0xaf, 0x6c, 0x3d,
	0x89, 0x29, 0xa9, 0xb8, 0x14, 0x05, 0x72, 0xa1, 0x1b, 0xdd, 0xbc, 0x17, 0xe6, 0x81, 0x62, 0xbc,
	0xb7, 0xc5, 0x28, 0x2e, 0xa9, 0x55, 0x7e, 0x07, 0xab, 0x66, 0x2a, 0x49, 0xb6, 0xb1, 0xe8, 0x53,
	0x68, 0x44, 0x31, 0x37, 0x5b, 0x6a, 0x0c, 0xa3, 0xff, 0xb8, 0xc9, 0x97, 0xdf, 0xa7, 0x8c, 0xcb,
	0x99, 0x64, 0x3c, 0x58, 0x54, 0xc7, 0xc8, 0x21, 0xe8, 0x63, 0x38, 0x9a, 0x33, 0xbe, 0x0a, 0xa4,
	0x7f, 0x45, 0xb8, 0x88, 0x59, 0x62, 0xb6, 0x47, 0xda, 0xb8, 0xe7, 0xf5, 0x8a, 0xec, 0x8b, 0x22,
	0x89, 0x16, 0x00, 0x98, 0x66, 0x42, 0x12, 0xee, 0xc7, 0x91, 0xd9, 0x19, 0x69, 0xe3, 0x43, 0xe7,
	0x69, 0xce, 0xf2, 0xeb, 0x7a, 0x78, 0xba, 0x88, 0xe5, 0x32, 0x0b, 0x2d, 0xcc, 0x56, 0xf6, 0x4d,
	0xe7, 0x28, 0xac, 0x63, 0x3b, 0xbd, 0x58, 0xd8, 0x4a, 0x36, 0x59, 0x16, 0x47, 0xd6, 0xf3, 0xe7,
	0xee, 0x74, 0xb3, 0x1e, 0x76, 0x26, 0x05, 0xa1, 0x3b, 0xf5, 0x3a, 0x25, 0xb7, 0x1b, 0xa1, 0x73,
	0x68, 0x25, 0x2c, 0x22, 0x79, 0x17, 0x18, 0x69, 0xe3, 0x03, 0xe7, 0xf1, 0x66, 0x3d, 0x6c, 0x7e,
	0xcb, 0x22, 0xe2, 0x4e, 0xff, 0xda, 0xb5, 0x57, 0x75, 0xeb, 0x02, 0xe6, 0x35, 0x73, 0x46, 0x37,
	0x42, 0x9f, 0x01, 0x28, 0x4f, 0xf8, 0xb9, 0x27, 0xcc, 0xae, 0x1a, 0xd6, 0x7b, 0x5b, 0xc3, 0x52,
	0x2f, 0x2d, 0x37, 0x99, 0xb3, 0x4a, 0x6d, 0x2a, 0x93, 0x27, 0x90, 0x0b, 0x87, 0x24, 0x91, 0xfc,
	0xa5, 0x8f, 0x59, 0x96, 0x48, 0x61, 0x1e, 0xde, 0x3a, 0x6a, 0x27, 0xa3, 0x17, 0xdf, 0xa5, 0xb3,
	0x6c, 0xb5, 0x0a, 0xf8, 0xcb, 0xea, 0x63, 0x29, 0xec, 0x44, 0x41, 0xd1, 0x33, 0xe8, 0xae, 0xae,
	0x30, 0xf6, 0xe7, 0x31, 0x95, 0x84, 0x9b, 0xbd, 0x91, 0x36, 0x3e, 0x3a, 0xb9, 0x7f, 0xab, 0x92,
	0xbe, 0x79, 0x31, 0x99, 0x3c, 0x51, 0xa5, 0xce, 0xd1, 0x66, 0x3d, 0x84, 0xfa, 0xd9, 0x83, 0x9c,
	0xa7, 0x88, 0xd1, 0x39, 0x1c, 0x62, 0xb6, 0x4a, 0x29, 0x91, 0xc4, 0x8f, 0x42, 0x61, 0x1e, 0x8d,
	0x1a, 0xe3, 0x9e, 0xf3, 0x68, 0xe7, 0x99, 0x6d, 0x99, 0xde, 0x72, 0xa7, 0x5e, 0xb7, 0x22, 0x9b,
	0x86, 0x02, 0x3d, 0x05, 0x23, 0x4e, 0x24, 0x67, 0x51, 0x86, 0x49, 0xe4, 0x17, 0xae, 0xb9, 0xb3,
	0x8b, 0x6b, 0xee, 0xd4, 0xb0, 0x99, 0xf2, 0xcf, 0x25, 0xa0, 0x5a, 0xb7, 0x3e, 0x5e, 0x06, 0xc9,
	0x82, 0x08, 0xd3, 0x50, 0x5c, 0x9f, 0xef, 0x6e, 0xa6, 0x3a, 0xf4, 0xc8, 0x55, 0x9c, 0x2b, 0xb4,
	0x6c, 0x78, 0x5c, 0xb3, 0x4f, 0x0a, 0x72, 0x34, 0x83, 0x77, 0x78, 0x59, 0xe4, 0x6f, 0x2d, 0x9d,
	0xe3, 0xdd, 0x57, 0xc6, 0x71, 0x85, 0x9f, 0x55, 0xcb, 0xa7, 0xff, 0xe3, 0x3e, 0xe8, 0xb9, 0xa3,
	0xd1, 0x03, 0xd0, 0xf3, 0x79, 0x94, 0x3b, 0xec, 0x35, 0xe3, 0x50, 0xa5, 0x08, 0x81, 0x9e, 0x06,
	0x72, 0xa9, 0x96, 0x56, 0xc7, 0x53, 0x31, 0x7a, 0x1f, 0x9a, 0x62, 0x19, 0x3c, 0x7c, 0x70, 0x62,
	0xea, 0xb9, 0xb7, 0xbc, 0xf2, 0xe9, 0x15, 0xd9, 0x35, 0xff, 0xbf, 0xec, 0xfe, 0xb9, 0x73, 0x5b,
	0x6f, 0xbd, 0x73, 0xdb, 0x6f, 0xbe, 0x73, 0xcf, 0xf4, 0x76, 0xc3, 0xd0, 0xcf, 0xf4, 0xf6, 0x81,
	0xd1, 0xec, 0xff, 0xa4, 0x01, 0x7a, 0xf5, 0x3b, 0xa2, 0x47, 0xa0, 0xbf, 0xe9, 0x4f, 0x41, 0x01,
	0xd0, 0x57, 0xb0, 0xef, 0x4e, 0xd5, 0x50, 0xdf, 0x42, 0xf6, 0xfb, 0xee, 0x14, 0x3d, 0x04, 0x3d,
	0x57, 0x91, 0xd9, 0x50, 0x27, 0x78, 0xfd, 0x42, 0xf6, 0x54, 0xf9, 0x99, 0xde, 0x6e, 0x1a, 0xad,
	0x4f, 0xee, 0xc1, 0x96, 0x41, 0x11, 0x40, 0xf3, 0xeb, 0x40, 0x12, 0x21, 0x8d, 0x3d, 0xd4, 0x82,
	0xc6, 0x63, 0x4a, 0x0d, 0xcd, 0xb9, 0x7f, 0xfd, 0xfb, 0x60, 0xef, 0x7a, 0x33, 0xd0, 0x7e, 0xde,
	0x0c, 0xb4, 0x5f, 0x36, 0x03, 0xed, 0xb7, 0xcd, 0x40, 0xfb, 0xe1, 0x8f, 0xc1, 0xde, 0x79, 0xe7,
	0x46, 0xf2, 0x61, 0x53, 0xfd, 0x3d, 0x4f, 0xff, 0x0e, 0x00, 0x00, 0xff, 0xff, 0x47, 0x06, 0x10,
	0x8e, 0xfb, 0x07, 0x00, 0x00,
}
