// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: roachpb/api.proto

/*
	Package roachpb is a generated protocol buffer package.

	It is generated from these files:
		roachpb/api.proto
		roachpb/app_stats.proto
		roachpb/data.proto
		roachpb/errors.proto
		roachpb/internal.proto
		roachpb/internal_raft.proto
		roachpb/io-formats.proto
		roachpb/metadata.proto

	It has these top-level messages:
		RangeInfo
		RequestHeader
		ResponseHeader
		GetRequest
		GetResponse
		PutRequest
		PutResponse
		ConditionalPutRequest
		ConditionalPutResponse
		InitPutRequest
		InitPutResponse
		IncrementRequest
		IncrementResponse
		DeleteRequest
		DeleteResponse
		DeleteRangeRequest
		DeleteRangeResponse
		ClearRangeRequest
		ClearRangeResponse
		ScanOptions
		ScanRequest
		ScanResponse
		ReverseScanRequest
		ReverseScanResponse
		CheckConsistencyRequest
		CheckConsistencyResponse
		RecomputeStatsRequest
		RecomputeStatsResponse
		BeginTransactionRequest
		BeginTransactionResponse
		EndTransactionRequest
		EndTransactionResponse
		AdminSplitRequest
		AdminSplitResponse
		AdminMergeRequest
		AdminMergeResponse
		AdminTransferLeaseRequest
		AdminTransferLeaseResponse
		AdminChangeReplicasRequest
		AdminChangeReplicasResponse
		AdminRelocateRangeRequest
		AdminRelocateRangeResponse
		HeartbeatTxnRequest
		HeartbeatTxnResponse
		GCRequest
		GCResponse
		PushTxnRequest
		PushTxnResponse
		QueryTxnRequest
		QueryTxnResponse
		QueryIntentRequest
		QueryIntentResponse
		ResolveIntentRequest
		ResolveIntentResponse
		ResolveIntentRangeRequest
		ResolveIntentRangeResponse
		MergeRequest
		MergeResponse
		TruncateLogRequest
		TruncateLogResponse
		RequestLeaseRequest
		TransferLeaseRequest
		LeaseInfoRequest
		LeaseInfoResponse
		RequestLeaseResponse
		ComputeChecksumRequest
		ComputeChecksumResponse
		ExportStorage
		WriteBatchRequest
		WriteBatchResponse
		ExportRequest
		BulkOpSummary
		ExportResponse
		ImportRequest
		ImportResponse
		AdminScatterRequest
		AdminScatterResponse
		AddSSTableRequest
		AddSSTableResponse
		RefreshRequest
		RefreshResponse
		RefreshRangeRequest
		RefreshRangeResponse
		SubsumeRequest
		SubsumeResponse
		RangeStatsRequest
		RangeStatsResponse
		RequestUnion
		ResponseUnion
		Header
		BatchRequest
		BatchResponse
		RangeFeedRequest
		RangeFeedValue
		RangeFeedCheckpoint
		RangeFeedError
		RangeFeedEvent
		StatementStatistics
		NumericStat
		StatementStatisticsKey
		CollectedStatementStatistics
		Span
		Value
		KeyValue
		StoreIdent
		SplitTrigger
		MergeTrigger
		ChangeReplicasTrigger
		ModifiedSpanTrigger
		InternalCommitTrigger
		ObservedTimestamp
		Transaction
		Intent
		SequencedWrite
		Lease
		AbortSpanEntry
		TxnCoordMeta
		NotLeaseHolderError
		NodeUnavailableError
		UnsupportedRequestError
		RangeNotFoundError
		RangeKeyMismatchError
		ReadWithinUncertaintyIntervalError
		TransactionAbortedError
		TransactionPushError
		TransactionRetryError
		TransactionStatusError
		WriteIntentError
		WriteTooOldError
		OpRequiresTxnError
		ConditionFailedError
		LeaseRejectedError
		SendError
		AmbiguousResultError
		RaftGroupDeletedError
		ReplicaCorruptionError
		ReplicaTooOldError
		StoreNotFoundError
		UnhandledRetryableError
		HandledRetryableTxnError
		TxnAlreadyEncounteredErrorError
		IntegerOverflowError
		MixedSuccessError
		BatchTimestampBeforeGCError
		IntentMissingError
		MergeInProgressError
		RangeFeedRetryError
		ErrorDetail
		ErrPosition
		Error
		InternalTimeSeriesData
		InternalTimeSeriesSample
		RaftTruncatedState
		RaftTombstone
		RaftSnapshotData
		IOFileFormat
		CSVOptions
		MySQLOutfileOptions
		PgCopyOptions
		PgDumpOptions
		Attributes
		ReplicationTarget
		ReplicaDescriptor
		ReplicaIdent
		RangeDescriptor
		Percentiles
		StoreCapacity
		NodeDescriptor
		LocalityAddress
		StoreDescriptor
		StoreDeadReplicas
		Locality
		Tier
		Version
*/
package roachpb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import cockroach_storage_engine_enginepb1 "github.com/cockroachdb/cockroach/pkg/storage/engine/enginepb"
import cockroach_storage_engine_enginepb "github.com/cockroachdb/cockroach/pkg/storage/engine/enginepb"
import cockroach_util_hlc "github.com/cockroachdb/cockroach/pkg/util/hlc"
import cockroach_util_tracing "github.com/cockroachdb/cockroach/pkg/util/tracing"

import github_com_cockroachdb_cockroach_pkg_util_uuid "github.com/cockroachdb/cockroach/pkg/util/uuid"

import bytes "bytes"

import context "context"
import grpc "google.golang.org/grpc"

import binary "encoding/binary"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// ReadConsistencyType specifies what type of consistency is observed
// during read operations.
type ReadConsistencyType int32

const (
	// CONSISTENT reads are guaranteed to read committed data; the
	// mechanism relies on clocks to determine lease expirations.
	CONSISTENT ReadConsistencyType = 0
	// READ_UNCOMMITTED reads return both committed and uncommitted data.
	// The consistency type is similar to INCONSISTENT in that using it
	// can result in dirty reads. However, like the CONSISTENT type, it
	// requires the replica performing the read to hold a valid read lease,
	// meaning that it can't return arbitrarily stale data.
	READ_UNCOMMITTED ReadConsistencyType = 1
	// INCONSISTENT reads return the latest available, committed values.
	// They are more efficient, but may read stale values as pending
	// intents are ignored.
	INCONSISTENT ReadConsistencyType = 2
)

var ReadConsistencyType_name = map[int32]string{
	0: "CONSISTENT",
	1: "READ_UNCOMMITTED",
	2: "INCONSISTENT",
}
var ReadConsistencyType_value = map[string]int32{
	"CONSISTENT":       0,
	"READ_UNCOMMITTED": 1,
	"INCONSISTENT":     2,
}

func (x ReadConsistencyType) String() string {
	return proto.EnumName(ReadConsistencyType_name, int32(x))
}
func (ReadConsistencyType) EnumDescriptor() ([]byte, []int) { return fileDescriptorApi, []int{0} }

// ScanFormat is an enumeration of the available response formats for MVCCScan
// operations.
type ScanFormat int32

const (
	// The standard MVCCScan format: a slice of KeyValue messages.
	KEY_VALUES ScanFormat = 0
	// The batch_response format: a byte slice of alternating keys and values,
	// each prefixed by their length as a varint.
	BATCH_RESPONSE ScanFormat = 1
)

var ScanFormat_name = map[int32]string{
	0: "KEY_VALUES",
	1: "BATCH_RESPONSE",
}
var ScanFormat_value = map[string]int32{
	"KEY_VALUES":     0,
	"BATCH_RESPONSE": 1,
}

func (x ScanFormat) String() string {
	return proto.EnumName(ScanFormat_name, int32(x))
}
func (ScanFormat) EnumDescriptor() ([]byte, []int) { return fileDescriptorApi, []int{1} }

// TxnPushType determines what action to take when pushing a transaction.
type PushTxnType int32

const (
	// Push the timestamp forward if possible to accommodate a concurrent reader.
	PUSH_TIMESTAMP PushTxnType = 0
	// Abort the transaction if possible to accommodate a concurrent writer.
	PUSH_ABORT PushTxnType = 1
	// Abort the transaction if it's abandoned, but don't attempt to mutate it
	// otherwise.
	PUSH_TOUCH PushTxnType = 2
	// Deprecated. Use QueryTxn instead.
	PUSH_QUERY PushTxnType = 3
)

var PushTxnType_name = map[int32]string{
	0: "PUSH_TIMESTAMP",
	1: "PUSH_ABORT",
	2: "PUSH_TOUCH",
	3: "PUSH_QUERY",
}
var PushTxnType_value = map[string]int32{
	"PUSH_TIMESTAMP": 0,
	"PUSH_ABORT":     1,
	"PUSH_TOUCH":     2,
	"PUSH_QUERY":     3,
}

func (x PushTxnType) String() string {
	return proto.EnumName(PushTxnType_name, int32(x))
}
func (PushTxnType) EnumDescriptor() ([]byte, []int) { return fileDescriptorApi, []int{2} }

type ExportStorageProvider int32

const (
	ExportStorageProvider_Unknown     ExportStorageProvider = 0
	ExportStorageProvider_LocalFile   ExportStorageProvider = 1
	ExportStorageProvider_Http        ExportStorageProvider = 2
	ExportStorageProvider_S3          ExportStorageProvider = 3
	ExportStorageProvider_GoogleCloud ExportStorageProvider = 4
	ExportStorageProvider_Azure       ExportStorageProvider = 5
)

var ExportStorageProvider_name = map[int32]string{
	0: "Unknown",
	1: "LocalFile",
	2: "Http",
	3: "S3",
	4: "GoogleCloud",
	5: "Azure",
}
var ExportStorageProvider_value = map[string]int32{
	"Unknown":     0,
	"LocalFile":   1,
	"Http":        2,
	"S3":          3,
	"GoogleCloud": 4,
	"Azure":       5,
}

func (x ExportStorageProvider) String() string {
	return proto.EnumName(ExportStorageProvider_name, int32(x))
}
func (ExportStorageProvider) EnumDescriptor() ([]byte, []int) { return fileDescriptorApi, []int{3} }

type MVCCFilter int32

const (
	MVCCFilter_Latest MVCCFilter = 0
	MVCCFilter_All    MVCCFilter = 1
)

var MVCCFilter_name = map[int32]string{
	0: "Latest",
	1: "All",
}
var MVCCFilter_value = map[string]int32{
	"Latest": 0,
	"All":    1,
}

func (x MVCCFilter) String() string {
	return proto.EnumName(MVCCFilter_name, int32(x))
}
func (MVCCFilter) EnumDescriptor() ([]byte, []int) { return fileDescriptorApi, []int{4} }

type ResponseHeader_ResumeReason int32

const (
	// Zero value; no resume.
	RESUME_UNKNOWN ResponseHeader_ResumeReason = 0
	// The spanning operation didn't finish because the key limit was
	// exceeded.
	RESUME_KEY_LIMIT ResponseHeader_ResumeReason = 1
	// The spanning operation didn't finish because a range boundary
	// was encountered and the command was configured to stop at range
	// boundaries.
	RESUME_RANGE_BOUNDARY ResponseHeader_ResumeReason = 2
)

var ResponseHeader_ResumeReason_name = map[int32]string{
	0: "RESUME_UNKNOWN",
	1: "RESUME_KEY_LIMIT",
	2: "RESUME_RANGE_BOUNDARY",
}
var ResponseHeader_ResumeReason_value = map[string]int32{
	"RESUME_UNKNOWN":        0,
	"RESUME_KEY_LIMIT":      1,
	"RESUME_RANGE_BOUNDARY": 2,
}

func (x ResponseHeader_ResumeReason) String() string {
	return proto.EnumName(ResponseHeader_ResumeReason_name, int32(x))
}
func (ResponseHeader_ResumeReason) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorApi, []int{2, 0}
}

type QueryIntentRequest_IfMissingBehavior int32

const (
	// Don't do anything special, just note that the intent was not found in the
	// response.
	QueryIntentRequest_DO_NOTHING QueryIntentRequest_IfMissingBehavior = 0
	// Return an IntentMissingError. Special-cased to return a SERIALIZABLE
	// retry error if a SERIALIZABLE transaction queries its own intent and
	// finds it has been pushed.
	QueryIntentRequest_RETURN_ERROR QueryIntentRequest_IfMissingBehavior = 1
	// Prevent the intent from ever being written in the future. If set as the
	// behavior, a response with found_intent=false implies that an intent will
	// never be writtable at the key at the transaction's timestamp or below.
	//
	// Cannot be used with SNAPSHOT transactions.
	QueryIntentRequest_PREVENT QueryIntentRequest_IfMissingBehavior = 2
)

var QueryIntentRequest_IfMissingBehavior_name = map[int32]string{
	0: "DO_NOTHING",
	1: "RETURN_ERROR",
	2: "PREVENT",
}
var QueryIntentRequest_IfMissingBehavior_value = map[string]int32{
	"DO_NOTHING":   0,
	"RETURN_ERROR": 1,
	"PREVENT":      2,
}

func (x QueryIntentRequest_IfMissingBehavior) String() string {
	return proto.EnumName(QueryIntentRequest_IfMissingBehavior_name, int32(x))
}
func (QueryIntentRequest_IfMissingBehavior) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorApi, []int{50, 0}
}

// RangeInfo describes a range which executed a request. It contains
// the range descriptor and lease information at the time of execution.
type RangeInfo struct {
	Desc  RangeDescriptor `protobuf:"bytes,1,opt,name=desc" json:"desc"`
	Lease Lease           `protobuf:"bytes,2,opt,name=lease" json:"lease"`
}

func (m *RangeInfo) Reset()                    { *m = RangeInfo{} }
func (m *RangeInfo) String() string            { return proto.CompactTextString(m) }
func (*RangeInfo) ProtoMessage()               {}
func (*RangeInfo) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{0} }

// RequestHeader is supplied with every storage node request.
type RequestHeader struct {
	// The key for request. If the request operates on a range, this
	// represents the starting key for the range.
	Key Key `protobuf:"bytes,3,opt,name=key,proto3,casttype=Key" json:"key,omitempty"`
	// The end key is empty if the request spans only a single key. Otherwise,
	// it must order strictly after Key. In such a case, the header indicates
	// that the operation takes place on the key range from Key to EndKey,
	// including Key and excluding EndKey.
	EndKey Key `protobuf:"bytes,4,opt,name=end_key,json=endKey,proto3,casttype=Key" json:"end_key,omitempty"`
	// A one-indexed transactional sequence number.
	Sequence int32 `protobuf:"varint,5,opt,name=sequence,proto3" json:"sequence,omitempty"`
}

func (m *RequestHeader) Reset()                    { *m = RequestHeader{} }
func (m *RequestHeader) String() string            { return proto.CompactTextString(m) }
func (*RequestHeader) ProtoMessage()               {}
func (*RequestHeader) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{1} }

// ResponseHeader is returned with every storage node response.
type ResponseHeader struct {
	// txn is non-nil if the request specified a non-nil transaction.
	// The transaction timestamp and/or priority may have been updated,
	// depending on the outcome of the request.
	Txn *Transaction `protobuf:"bytes,3,opt,name=txn" json:"txn,omitempty"`
	// The next span to resume from when the response doesn't cover the full span
	// requested. This can happen when a bound on the keys is set through
	// max_span_request_keys in the batch header or when a scan has been stopped
	// before covering the requested data because of scan_options.
	//
	// ResumeSpan is unset when the entire span of keys have been
	// operated on. The span is set to the original span if the request
	// was ignored because max_span_request_keys was hit due to another
	// request in the batch. For a reverse scan the end_key is updated.
	ResumeSpan *Span `protobuf:"bytes,4,opt,name=resume_span,json=resumeSpan" json:"resume_span,omitempty"`
	// When resume_span is populated, this specifies the reason why the operation
	// wasn't completed and needs to be resumed.
	// This field appeared in v2.0. Responses from storage coming from older
	// servers will not contain it, but the conversion from a BatchResponse to a
	// client.Result always fills it in.
	ResumeReason ResponseHeader_ResumeReason `protobuf:"varint,7,opt,name=resume_reason,json=resumeReason,proto3,enum=cockroach.roachpb.ResponseHeader_ResumeReason" json:"resume_reason,omitempty"`
	// The number of keys operated on.
	NumKeys int64 `protobuf:"varint,5,opt,name=num_keys,json=numKeys,proto3" json:"num_keys,omitempty"`
	// Range or list of ranges used to execute the request. Multiple
	// ranges may be returned for Scan, ReverseScan or DeleteRange.
	RangeInfos []RangeInfo `protobuf:"bytes,6,rep,name=range_infos,json=rangeInfos" json:"range_infos"`
}

func (m *ResponseHeader) Reset()                    { *m = ResponseHeader{} }
func (m *ResponseHeader) String() string            { return proto.CompactTextString(m) }
func (*ResponseHeader) ProtoMessage()               {}
func (*ResponseHeader) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{2} }

// A GetRequest is the argument for the Get() method.
type GetRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *GetRequest) Reset()                    { *m = GetRequest{} }
func (m *GetRequest) String() string            { return proto.CompactTextString(m) }
func (*GetRequest) ProtoMessage()               {}
func (*GetRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{3} }

// A GetResponse is the return value from the Get() method.
// If the key doesn't exist, Value will be nil.
type GetResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Value          *Value `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	// The intent seen, if any, when using the READ_UNCOMMITTED consistency level.
	IntentValue *Value `protobuf:"bytes,3,opt,name=intent_value,json=intentValue" json:"intent_value,omitempty"`
}

func (m *GetResponse) Reset()                    { *m = GetResponse{} }
func (m *GetResponse) String() string            { return proto.CompactTextString(m) }
func (*GetResponse) ProtoMessage()               {}
func (*GetResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{4} }

// A PutRequest is the argument to the Put() method.
type PutRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Value         Value `protobuf:"bytes,2,opt,name=value" json:"value"`
	// Specify as true to put the value without a corresponding
	// timestamp. This option should be used with care as it precludes
	// the use of this value with transactions.
	Inline bool `protobuf:"varint,3,opt,name=inline,proto3" json:"inline,omitempty"`
	// NOTE: For internal use only! Set to indicate that the put is
	// writing to virgin keyspace and no reads are necessary to
	// rationalize MVCC.
	Blind bool `protobuf:"varint,4,opt,name=blind,proto3" json:"blind,omitempty"`
}

func (m *PutRequest) Reset()                    { *m = PutRequest{} }
func (m *PutRequest) String() string            { return proto.CompactTextString(m) }
func (*PutRequest) ProtoMessage()               {}
func (*PutRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{5} }

// A PutResponse is the return value from the Put() method.
type PutResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *PutResponse) Reset()                    { *m = PutResponse{} }
func (m *PutResponse) String() string            { return proto.CompactTextString(m) }
func (*PutResponse) ProtoMessage()               {}
func (*PutResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{6} }

// A ConditionalPutRequest is the argument to the ConditionalPut() method.
//
// - Returns true and sets value if exp_value equals existing value.
// - If key doesn't exist and exp_value is nil, sets value.
// - If key exists, but value is empty and exp_value is not nil but empty, sets value.
// - Otherwise, returns an error containing the actual value of the key.
type ConditionalPutRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// The value to put.
	Value Value `protobuf:"bytes,2,opt,name=value" json:"value"`
	// Set exp_value.bytes empty to test for non-existence. Specify as nil
	// to indicate there should be no existing entry. This is different
	// from the expectation that the value exists but is empty.
	ExpValue *Value `protobuf:"bytes,3,opt,name=exp_value,json=expValue" json:"exp_value,omitempty"`
	// NOTE: For internal use only! Set to indicate that the put is
	// writing to virgin keyspace and no reads are necessary to
	// rationalize MVCC.
	Blind bool `protobuf:"varint,4,opt,name=blind,proto3" json:"blind,omitempty"`
}

func (m *ConditionalPutRequest) Reset()                    { *m = ConditionalPutRequest{} }
func (m *ConditionalPutRequest) String() string            { return proto.CompactTextString(m) }
func (*ConditionalPutRequest) ProtoMessage()               {}
func (*ConditionalPutRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{7} }

// A ConditionalPutResponse is the return value from the
// ConditionalPut() method.
type ConditionalPutResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *ConditionalPutResponse) Reset()                    { *m = ConditionalPutResponse{} }
func (m *ConditionalPutResponse) String() string            { return proto.CompactTextString(m) }
func (*ConditionalPutResponse) ProtoMessage()               {}
func (*ConditionalPutResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{8} }

// An InitPutRequest is the argument to the InitPut() method.
//
// - If key doesn't exist, sets value.
// - If key exists, returns a ConditionFailedError if value != existing value
//   If failOnTombstones is set to true, tombstone values count as mismatched
//   values and will cause a ConditionFailedError.
type InitPutRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Value         Value `protobuf:"bytes,2,opt,name=value" json:"value"`
	// NOTE: For internal use only! Set to indicate that the put is
	// writing to virgin keyspace and no reads are necessary to
	// rationalize MVCC.
	Blind bool `protobuf:"varint,3,opt,name=blind,proto3" json:"blind,omitempty"`
	// If true, tombstones cause ConditionFailedErrors.
	FailOnTombstones bool `protobuf:"varint,4,opt,name=failOnTombstones,proto3" json:"failOnTombstones,omitempty"`
}

func (m *InitPutRequest) Reset()                    { *m = InitPutRequest{} }
func (m *InitPutRequest) String() string            { return proto.CompactTextString(m) }
func (*InitPutRequest) ProtoMessage()               {}
func (*InitPutRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{9} }

// A InitPutResponse is the return value from the InitPut() method.
type InitPutResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *InitPutResponse) Reset()                    { *m = InitPutResponse{} }
func (m *InitPutResponse) String() string            { return proto.CompactTextString(m) }
func (*InitPutResponse) ProtoMessage()               {}
func (*InitPutResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{10} }

// An IncrementRequest is the argument to the Increment() method. It
// increments the value for key, and returns the new value. If no
// value exists for a key, incrementing by 0 is not a noop, but will
// create a zero value. IncrementRequest cannot be called on a key set
// by Put() or ConditionalPut(). Similarly, Put() and ConditionalPut()
// cannot be invoked on an incremented key.
type IncrementRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Increment     int64 `protobuf:"varint,2,opt,name=increment,proto3" json:"increment,omitempty"`
}

func (m *IncrementRequest) Reset()                    { *m = IncrementRequest{} }
func (m *IncrementRequest) String() string            { return proto.CompactTextString(m) }
func (*IncrementRequest) ProtoMessage()               {}
func (*IncrementRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{11} }

// An IncrementResponse is the return value from the Increment
// method. The new value after increment is specified in NewValue. If
// the value could not be decoded as specified, Error will be set.
type IncrementResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	NewValue       int64 `protobuf:"varint,2,opt,name=new_value,json=newValue,proto3" json:"new_value,omitempty"`
}

func (m *IncrementResponse) Reset()                    { *m = IncrementResponse{} }
func (m *IncrementResponse) String() string            { return proto.CompactTextString(m) }
func (*IncrementResponse) ProtoMessage()               {}
func (*IncrementResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{12} }

// A DeleteRequest is the argument to the Delete() method.
type DeleteRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *DeleteRequest) Reset()                    { *m = DeleteRequest{} }
func (m *DeleteRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteRequest) ProtoMessage()               {}
func (*DeleteRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{13} }

// A DeleteResponse is the return value from the Delete() method.
type DeleteResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *DeleteResponse) Reset()                    { *m = DeleteResponse{} }
func (m *DeleteResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteResponse) ProtoMessage()               {}
func (*DeleteResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{14} }

// A DeleteRangeRequest is the argument to the DeleteRange() method. It
// specifies the range of keys to delete.
type DeleteRangeRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// return the keys that are deleted in the response.
	ReturnKeys bool `protobuf:"varint,3,opt,name=return_keys,json=returnKeys,proto3" json:"return_keys,omitempty"`
	// delete "inline" keys which are stored without MVCC timestamps. Note that
	// an "inline" DeleteRange will fail if it attempts to delete any keys which
	// contain timestamped (non-inline) values; this option should only be used on
	// keys which are known to store inline values, such as data in cockroach's
	// time series system.
	//
	// Similarly, attempts to delete keys with inline values will fail unless this
	// flag is set to true; the setting must match the data being deleted.
	//
	// Inline values cannot be deleted transactionally; a DeleteRange with
	// "inline" set to true will fail if it is executed within a transaction.
	Inline bool `protobuf:"varint,4,opt,name=inline,proto3" json:"inline,omitempty"`
}

func (m *DeleteRangeRequest) Reset()                    { *m = DeleteRangeRequest{} }
func (m *DeleteRangeRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteRangeRequest) ProtoMessage()               {}
func (*DeleteRangeRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{15} }

// A DeleteRangeResponse is the return value from the DeleteRange()
// method.
type DeleteRangeResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// All the deleted keys if return_keys is set.
	Keys []Key `protobuf:"bytes,2,rep,name=keys,casttype=Key" json:"keys,omitempty"`
}

func (m *DeleteRangeResponse) Reset()                    { *m = DeleteRangeResponse{} }
func (m *DeleteRangeResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteRangeResponse) ProtoMessage()               {}
func (*DeleteRangeResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{16} }

// A ClearRangeRequest is the argument to the ClearRange() method. It
// specifies a range of keys to clear from the underlying engine. Note
// that this differs from the behavior of DeleteRange, which sets
// transactional intents and writes tombstones to the deleted
// keys. ClearRange is used when permanently dropping or truncating
// table data.
//
// ClearRange also updates the GC threshold for the range to the
// timestamp at which this command executes, to prevent reads at
// earlier timestamps from incorrectly returning empty results.
//
// NOTE: it is important that this method only be invoked on a key
// range which is guaranteed to be both inactive and not see future
// writes. Ignoring this warning may result in data loss.
type ClearRangeRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *ClearRangeRequest) Reset()                    { *m = ClearRangeRequest{} }
func (m *ClearRangeRequest) String() string            { return proto.CompactTextString(m) }
func (*ClearRangeRequest) ProtoMessage()               {}
func (*ClearRangeRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{17} }

// A ClearRangeResponse is the return value from the ClearRange() method.
type ClearRangeResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *ClearRangeResponse) Reset()                    { *m = ClearRangeResponse{} }
func (m *ClearRangeResponse) String() string            { return proto.CompactTextString(m) }
func (*ClearRangeResponse) ProtoMessage()               {}
func (*ClearRangeResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{18} }

// ScanOptions is a collection of options for a batch of scans. The options
// apply to all the scans in the batch.
//
// If ScanOptions is present on a batch, the batch can only be made up of scan
// requests (i.e.  {Reverse,}ScanReques), except for
// {Begin,End}TransactionRequest which are still allowed. Moreover, the batch
// cannot mix forward and reverse scans.
//
// TODO(andrei): add option to stop scan(s) when an intent is encountered.
type ScanOptions struct {
	// stop_at_range_boundary, if set, means that the scans will stop at the first
	// range boundary after min_results is specified (if it is
	// specified). If the end of a range stops the scans, the resume_span returned
	// (for all the scans whose spans weren't fully scanned) represents the
	// beginning of the next range (as ranges were at the time of the read).
	//
	// This flag can be combined with header.max_span_request_keys but that means
	// that the desired number of keys may not be scanned.
	//
	// stop_at_range_boundary implies that DistSender will no longer parallelize
	// the execution of requests between ranges; instead, either we're only
	// speaking about scanning one range (if min_results is not set) or
	// it executes the scan serially over different ranges. Note that this is
	// also the case when max_span_request_keys is set (as the scan needs to
	// return results in order), and SQL always sets max_span_request_keys.
	StopAtRangeBoundary bool `protobuf:"varint,1,opt,name=stop_at_range_boundary,json=stopAtRangeBoundary,proto3" json:"stop_at_range_boundary,omitempty"`
	// min_results, if != 0, prevents the stop_at_range_boundary option from
	// terminating the scans before this many keys have been touched. The
	// counting is done across all the scans in the batch.
	//
	// A common value is 1, used if either the client knows that one key will be
	// sufficient for its purposes or if the client wants to skip a prefix of
	// empty ranges and seek to the point where some data is present.
	//
	// This can only be set if stop_at_range_boundary is set. If
	// header.max_span_request_keys is set, min_results needs to be <=
	// header.max_span_request_keys.
	MinResults int64 `protobuf:"varint,2,opt,name=min_results,json=minResults,proto3" json:"min_results,omitempty"`
}

func (m *ScanOptions) Reset()                    { *m = ScanOptions{} }
func (m *ScanOptions) String() string            { return proto.CompactTextString(m) }
func (*ScanOptions) ProtoMessage()               {}
func (*ScanOptions) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{19} }

// A ScanRequest is the argument to the Scan() method. It specifies the
// start and end keys for an ascending scan of [start,end) and the maximum
// number of results (unbounded if zero).
type ScanRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// The desired format for the response. If set to BATCH_RESPONSE, the server
	// will set the batch_response field in the ScanResponse instead of the rows
	// field.
	ScanFormat ScanFormat `protobuf:"varint,4,opt,name=scan_format,json=scanFormat,proto3,enum=cockroach.roachpb.ScanFormat" json:"scan_format,omitempty"`
}

func (m *ScanRequest) Reset()                    { *m = ScanRequest{} }
func (m *ScanRequest) String() string            { return proto.CompactTextString(m) }
func (*ScanRequest) ProtoMessage()               {}
func (*ScanRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{20} }

// A ScanResponse is the return value from the Scan() method.
type ScanResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// Empty if no rows were scanned.
	Rows []KeyValue `protobuf:"bytes,2,rep,name=rows" json:"rows"`
	// The intent rows seen when performing a scan at the READ_UNCOMMITTED
	// consistency level. These rows do not count against the MaxSpanRequestKeys
	// count.
	IntentRows []KeyValue `protobuf:"bytes,3,rep,name=intent_rows,json=intentRows" json:"intent_rows"`
	// If set, the results of the scan in batch format - the key/value pairs are
	// a buffer of varint-prefixed slices, alternating from key to value. There
	// are num_keys pairs, as defined by the ResponseHeader. If set, rows will not
	// be set and vice versa.
	BatchResponse []byte `protobuf:"bytes,4,opt,name=batch_response,json=batchResponse,proto3" json:"batch_response,omitempty"`
}

func (m *ScanResponse) Reset()                    { *m = ScanResponse{} }
func (m *ScanResponse) String() string            { return proto.CompactTextString(m) }
func (*ScanResponse) ProtoMessage()               {}
func (*ScanResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{21} }

// A ReverseScanRequest is the argument to the ReverseScan() method. It specifies the
// start and end keys for a descending scan of [start,end) and the maximum
// number of results (unbounded if zero).
type ReverseScanRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// The desired format for the response. If set to BATCH_RESPONSE, the server
	// will set the batch_response field in the ScanResponse instead of the rows
	// field.
	ScanFormat ScanFormat `protobuf:"varint,4,opt,name=scan_format,json=scanFormat,proto3,enum=cockroach.roachpb.ScanFormat" json:"scan_format,omitempty"`
}

func (m *ReverseScanRequest) Reset()                    { *m = ReverseScanRequest{} }
func (m *ReverseScanRequest) String() string            { return proto.CompactTextString(m) }
func (*ReverseScanRequest) ProtoMessage()               {}
func (*ReverseScanRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{22} }

// A ReverseScanResponse is the return value from the ReverseScan() method.
type ReverseScanResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// Empty if no rows were scanned.
	Rows []KeyValue `protobuf:"bytes,2,rep,name=rows" json:"rows"`
	// The intent rows seen when performing a scan at the READ_UNCOMMITTED
	// consistency level. These rows do not count against the MaxSpanRequestKeys
	// count.
	IntentRows []KeyValue `protobuf:"bytes,3,rep,name=intent_rows,json=intentRows" json:"intent_rows"`
	// If set, the results of the scan in batch format - the key/value pairs are
	// a buffer of varint-prefixed slices, alternating from key to value. There
	// are num_keys pairs, as defined by the ResponseHeader. If set, rows will not
	// be set and vice versa.
	BatchResponse []byte `protobuf:"bytes,4,opt,name=batch_response,json=batchResponse,proto3" json:"batch_response,omitempty"`
}

func (m *ReverseScanResponse) Reset()                    { *m = ReverseScanResponse{} }
func (m *ReverseScanResponse) String() string            { return proto.CompactTextString(m) }
func (*ReverseScanResponse) ProtoMessage()               {}
func (*ReverseScanResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{23} }

// A CheckConsistencyRequest is the argument to the CheckConsistency() method.
// It specifies the start and end keys for a span of ranges to which a
// consistency check should be applied. A consistency check on a range involves
// running a ComputeChecksum on the range followed by a storage.CollectChecksum.
type CheckConsistencyRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// log a diff of inconsistencies if such inconsistencies are found.
	WithDiff bool `protobuf:"varint,2,opt,name=with_diff,json=withDiff,proto3" json:"with_diff,omitempty"`
}

func (m *CheckConsistencyRequest) Reset()                    { *m = CheckConsistencyRequest{} }
func (m *CheckConsistencyRequest) String() string            { return proto.CompactTextString(m) }
func (*CheckConsistencyRequest) ProtoMessage()               {}
func (*CheckConsistencyRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{24} }

// A CheckConsistencyResponse is the return value from the CheckConsistency() method.
// If a replica finds itself to be inconsistent with its lease holder it will panic.
type CheckConsistencyResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *CheckConsistencyResponse) Reset()                    { *m = CheckConsistencyResponse{} }
func (m *CheckConsistencyResponse) String() string            { return proto.CompactTextString(m) }
func (*CheckConsistencyResponse) ProtoMessage()               {}
func (*CheckConsistencyResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{25} }

// An RecomputeStatsRequest triggers a stats recomputation on the Range addressed by
// the request.
//
// An error will be returned if the start key does not match the start key of the
// target Range.
//
// The stats recomputation touches essentially the whole range, but the command
// avoids having to block other commands by taking care to not interleave
// with splits, and by using the commutativity of stats updates. As a result,
// it is safe to invoke at any time, including repeatedly, though it should be
// used conservatively due to performing a full scan of the Range.
type RecomputeStatsRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// When dry_run is true, the stats delta is computed, but no stats adjustment
	// is performed. This isn't useful outside of testing since RecomputeStats is
	// safe and idempotent.
	DryRun bool `protobuf:"varint,2,opt,name=dry_run,json=dryRun,proto3" json:"dry_run,omitempty"`
}

func (m *RecomputeStatsRequest) Reset()                    { *m = RecomputeStatsRequest{} }
func (m *RecomputeStatsRequest) String() string            { return proto.CompactTextString(m) }
func (*RecomputeStatsRequest) ProtoMessage()               {}
func (*RecomputeStatsRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{26} }

// An RecomputeStatsResponse is the response to an RecomputeStatsRequest.
type RecomputeStatsResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// added_delta is the adjustment made to the range's stats, i.e. `new_stats = old_stats + added_delta`.
	AddedDelta cockroach_storage_engine_enginepb.MVCCStatsDelta `protobuf:"bytes,2,opt,name=added_delta,json=addedDelta" json:"added_delta"`
}

func (m *RecomputeStatsResponse) Reset()                    { *m = RecomputeStatsResponse{} }
func (m *RecomputeStatsResponse) String() string            { return proto.CompactTextString(m) }
func (*RecomputeStatsResponse) ProtoMessage()               {}
func (*RecomputeStatsResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{27} }

// A BeginTransactionRequest is the argument to the BeginTransaction() method.
type BeginTransactionRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *BeginTransactionRequest) Reset()                    { *m = BeginTransactionRequest{} }
func (m *BeginTransactionRequest) String() string            { return proto.CompactTextString(m) }
func (*BeginTransactionRequest) ProtoMessage()               {}
func (*BeginTransactionRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{28} }

// A BeginTransactionResponse is the return value from the BeginTransaction() method.
type BeginTransactionResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *BeginTransactionResponse) Reset()                    { *m = BeginTransactionResponse{} }
func (m *BeginTransactionResponse) String() string            { return proto.CompactTextString(m) }
func (*BeginTransactionResponse) ProtoMessage()               {}
func (*BeginTransactionResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{29} }

// An EndTransactionRequest is the argument to the EndTransaction() method. It
// specifies whether to commit or roll back an extant transaction.
type EndTransactionRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// False to abort and rollback.
	Commit bool `protobuf:"varint,2,opt,name=commit,proto3" json:"commit,omitempty"`
	// If set, deadline represents the maximum timestamp at which the transaction
	// can commit (i.e. the maximum timestamp for the txn's writes). If
	// EndTransaction(Commit=true) finds that the txn's timestamp has been pushed
	// above this deadline, an error will be returned and the client is supposed
	// to rollback the txn.
	// N.B. Assuming that the deadline was valid to begin with (i.e. it was higher
	// than the txn's OrigTimestamp), only Snapshot transactions can get in
	// trouble with the deadline check. A Serializable txn that has had its
	// timestamp pushed has already lost before the deadline check: it will be
	// forced to restart.
	Deadline *cockroach_util_hlc.Timestamp `protobuf:"bytes,3,opt,name=deadline" json:"deadline,omitempty"`
	// commit triggers. Note that commit triggers are for
	// internal use only and will cause an error if requested through the
	// external-facing KV API.
	InternalCommitTrigger *InternalCommitTrigger `protobuf:"bytes,4,opt,name=internal_commit_trigger,json=internalCommitTrigger" json:"internal_commit_trigger,omitempty"`
	// List of intents written by the transaction. These are spans where
	// write intents have been written which must be resolved on txn
	// completion. Note that these spans may be condensed to cover
	// aggregate spans if the keys written by the transaction exceeded
	// a size threshold.
	IntentSpans []Span `protobuf:"bytes,5,rep,name=intent_spans,json=intentSpans" json:"intent_spans"`
	// Requires that the transaction completes as a 1 phase commit. This
	// guarantees that all writes are to the same range and that no
	// intents are left in the event of an error.
	Require1PC bool `protobuf:"varint,6,opt,name=require_1pc,json=require1pc,proto3" json:"require_1pc,omitempty"`
	// Set to true if this transaction is serializable isolation but has
	// accummulated no refresh spans. This allows the executing server
	// to retry it locally on the fast path.
	NoRefreshSpans bool `protobuf:"varint,8,opt,name=no_refresh_spans,json=noRefreshSpans,proto3" json:"no_refresh_spans,omitempty"`
	// True to indicate that intent spans should be resolved with
	// poison=true.  This is used when the transaction is being aborted
	// independently of the main thread of client operation, as in the
	// case of an asynchronous abort from the TxnCoordSender on a failed
	// heartbeat.
	Poison bool `protobuf:"varint,9,opt,name=poison,proto3" json:"poison,omitempty"`
}

func (m *EndTransactionRequest) Reset()                    { *m = EndTransactionRequest{} }
func (m *EndTransactionRequest) String() string            { return proto.CompactTextString(m) }
func (*EndTransactionRequest) ProtoMessage()               {}
func (*EndTransactionRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{30} }

// An EndTransactionResponse is the return value from the
// EndTransaction() method. The final transaction record is returned
// as part of the response header. In particular, transaction status
// and timestamp will be updated to reflect final committed
// values. Clients may propagate the transaction timestamp as the
// final txn commit timestamp in order to preserve causal ordering
// between subsequent transactions.
type EndTransactionResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// True if the transaction committed on the one phase commit path.
	// This means that all writes which were part of the transaction
	// were written as a single, atomic write batch to just one range.
	OnePhaseCommit bool `protobuf:"varint,4,opt,name=one_phase_commit,json=onePhaseCommit,proto3" json:"one_phase_commit,omitempty"`
}

func (m *EndTransactionResponse) Reset()                    { *m = EndTransactionResponse{} }
func (m *EndTransactionResponse) String() string            { return proto.CompactTextString(m) }
func (*EndTransactionResponse) ProtoMessage()               {}
func (*EndTransactionResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{31} }

// An AdminSplitRequest is the argument to the AdminSplit() method. The
// existing range which contains header.key is split by
// split_key. If split_key is not specified, then this method will
// determine a split key that is roughly halfway through the
// range. The existing range is resized to cover only its start key to
// the split key. The new range created by the split starts at the
// split key and extends to the original range's end key. If split_key
// is known, header.key should also be set to split_key.
//
// New range IDs for each of the split range's replica and a new Raft
// ID are generated by the operation. Split requests are done in the
// context of a distributed transaction which updates range addressing
// records, range metadata and finally, provides a commit trigger to
// update bookkeeping and instantiate the new range on commit.
//
// The new range contains range replicas located on the same stores;
// no range data is moved during this operation. The split can be
// thought of as a mostly logical operation, though some other
// metadata (e.g. abort span and range stats must be copied or
// recomputed).
type AdminSplitRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	SplitKey      Key `protobuf:"bytes,2,opt,name=split_key,json=splitKey,proto3,casttype=Key" json:"split_key,omitempty"`
}

func (m *AdminSplitRequest) Reset()                    { *m = AdminSplitRequest{} }
func (m *AdminSplitRequest) String() string            { return proto.CompactTextString(m) }
func (*AdminSplitRequest) ProtoMessage()               {}
func (*AdminSplitRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{32} }

// An AdminSplitResponse is the return value from the AdminSplit()
// method.
type AdminSplitResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *AdminSplitResponse) Reset()                    { *m = AdminSplitResponse{} }
func (m *AdminSplitResponse) String() string            { return proto.CompactTextString(m) }
func (*AdminSplitResponse) ProtoMessage()               {}
func (*AdminSplitResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{33} }

// An AdminMergeRequest is the argument to the AdminMerge() method. A
// merge is performed by calling AdminMerge on the left-hand range of
// two consecutive ranges (i.e. the range which contains keys which
// sort first). This range will be the subsuming range and the right
// hand range will be subsumed. After the merge operation, the
// subsumed range will no longer exist and the subsuming range will
// now encompass all keys from its original start key to the end key
// of the subsumed range. If AdminMerge is called on the final range
// in the key space, it is a noop.
type AdminMergeRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *AdminMergeRequest) Reset()                    { *m = AdminMergeRequest{} }
func (m *AdminMergeRequest) String() string            { return proto.CompactTextString(m) }
func (*AdminMergeRequest) ProtoMessage()               {}
func (*AdminMergeRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{34} }

// An AdminMergeResponse is the return value from the AdminMerge()
// method.
type AdminMergeResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *AdminMergeResponse) Reset()                    { *m = AdminMergeResponse{} }
func (m *AdminMergeResponse) String() string            { return proto.CompactTextString(m) }
func (*AdminMergeResponse) ProtoMessage()               {}
func (*AdminMergeResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{35} }

// An AdminTransferLeaseRequest is the argument to the AdminTransferLease()
// method. A lease transfer allows an external entity to control the lease
// holder for a range. The target of the lease transfer needs to be a valid
// replica of the range.
type AdminTransferLeaseRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Target        StoreID `protobuf:"varint,2,opt,name=target,proto3,casttype=StoreID" json:"target,omitempty"`
}

func (m *AdminTransferLeaseRequest) Reset()                    { *m = AdminTransferLeaseRequest{} }
func (m *AdminTransferLeaseRequest) String() string            { return proto.CompactTextString(m) }
func (*AdminTransferLeaseRequest) ProtoMessage()               {}
func (*AdminTransferLeaseRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{36} }

type AdminTransferLeaseResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *AdminTransferLeaseResponse) Reset()                    { *m = AdminTransferLeaseResponse{} }
func (m *AdminTransferLeaseResponse) String() string            { return proto.CompactTextString(m) }
func (*AdminTransferLeaseResponse) ProtoMessage()               {}
func (*AdminTransferLeaseResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{37} }

// An AdminChangeReplicasRequest is the argument to the AdminChangeReplicas()
// method. A change replicas operation allows adding or removing a set of
// replicas for a range.
type AdminChangeReplicasRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	ChangeType    ReplicaChangeType   `protobuf:"varint,2,opt,name=change_type,json=changeType,proto3,enum=cockroach.roachpb.ReplicaChangeType" json:"change_type,omitempty"`
	Targets       []ReplicationTarget `protobuf:"bytes,3,rep,name=targets" json:"targets"`
}

func (m *AdminChangeReplicasRequest) Reset()                    { *m = AdminChangeReplicasRequest{} }
func (m *AdminChangeReplicasRequest) String() string            { return proto.CompactTextString(m) }
func (*AdminChangeReplicasRequest) ProtoMessage()               {}
func (*AdminChangeReplicasRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{38} }

type AdminChangeReplicasResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *AdminChangeReplicasResponse) Reset()                    { *m = AdminChangeReplicasResponse{} }
func (m *AdminChangeReplicasResponse) String() string            { return proto.CompactTextString(m) }
func (*AdminChangeReplicasResponse) ProtoMessage()               {}
func (*AdminChangeReplicasResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{39} }

// An AdminRelocateRangeRequest is the argument to the AdminRelocateRange()
// method. Relocates the replicas for a range to the specified target stores.
// The first store in the list of targets becomes the new leaseholder.
type AdminRelocateRangeRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Targets       []ReplicationTarget `protobuf:"bytes,2,rep,name=targets" json:"targets"`
}

func (m *AdminRelocateRangeRequest) Reset()                    { *m = AdminRelocateRangeRequest{} }
func (m *AdminRelocateRangeRequest) String() string            { return proto.CompactTextString(m) }
func (*AdminRelocateRangeRequest) ProtoMessage()               {}
func (*AdminRelocateRangeRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{40} }

type AdminRelocateRangeResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *AdminRelocateRangeResponse) Reset()                    { *m = AdminRelocateRangeResponse{} }
func (m *AdminRelocateRangeResponse) String() string            { return proto.CompactTextString(m) }
func (*AdminRelocateRangeResponse) ProtoMessage()               {}
func (*AdminRelocateRangeResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{41} }

// A HeartbeatTxnRequest is arguments to the HeartbeatTxn()
// method. It's sent by transaction coordinators to let the system
// know that the transaction is still ongoing. Note that this
// heartbeat message is different from the heartbeat message in the
// gossip protocol.
type HeartbeatTxnRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Now           cockroach_util_hlc.Timestamp `protobuf:"bytes,2,opt,name=now" json:"now"`
}

func (m *HeartbeatTxnRequest) Reset()                    { *m = HeartbeatTxnRequest{} }
func (m *HeartbeatTxnRequest) String() string            { return proto.CompactTextString(m) }
func (*HeartbeatTxnRequest) ProtoMessage()               {}
func (*HeartbeatTxnRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{42} }

// A HeartbeatTxnResponse is the return value from the HeartbeatTxn()
// method. It returns the transaction info in the response header. The
// returned transaction lets the coordinator know the disposition of
// the transaction (i.e. aborted, committed, or pending).
type HeartbeatTxnResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *HeartbeatTxnResponse) Reset()                    { *m = HeartbeatTxnResponse{} }
func (m *HeartbeatTxnResponse) String() string            { return proto.CompactTextString(m) }
func (*HeartbeatTxnResponse) ProtoMessage()               {}
func (*HeartbeatTxnResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{43} }

// A GCRequest is arguments to the GC() method. It's sent by range
// lease holders after scanning range data to find expired MVCC values.
type GCRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Keys          []GCRequest_GCKey `protobuf:"bytes,3,rep,name=keys" json:"keys"`
	// Threshold is the expiration timestamp.
	Threshold cockroach_util_hlc.Timestamp `protobuf:"bytes,4,opt,name=threshold" json:"threshold"`
	// TxnSpanGCThreshold is the timestamp below which inactive transactions were
	// considered for GC (and thus might have been removed).
	TxnSpanGCThreshold cockroach_util_hlc.Timestamp `protobuf:"bytes,5,opt,name=txn_span_gc_threshold,json=txnSpanGcThreshold" json:"txn_span_gc_threshold"`
}

func (m *GCRequest) Reset()                    { *m = GCRequest{} }
func (m *GCRequest) String() string            { return proto.CompactTextString(m) }
func (*GCRequest) ProtoMessage()               {}
func (*GCRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{44} }

type GCRequest_GCKey struct {
	Key       Key                          `protobuf:"bytes,1,opt,name=key,proto3,casttype=Key" json:"key,omitempty"`
	Timestamp cockroach_util_hlc.Timestamp `protobuf:"bytes,2,opt,name=timestamp" json:"timestamp"`
}

func (m *GCRequest_GCKey) Reset()                    { *m = GCRequest_GCKey{} }
func (m *GCRequest_GCKey) String() string            { return proto.CompactTextString(m) }
func (*GCRequest_GCKey) ProtoMessage()               {}
func (*GCRequest_GCKey) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{44, 0} }

// A GCResponse is the return value from the GC() method.
type GCResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *GCResponse) Reset()                    { *m = GCResponse{} }
func (m *GCResponse) String() string            { return proto.CompactTextString(m) }
func (*GCResponse) ProtoMessage()               {}
func (*GCResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{45} }

// A PushTxnRequest is arguments to the PushTxn() method. It's sent by
// readers or writers which have encountered an "intent" laid down by
// another transaction. The goal is to resolve the conflict. Note that
// args.Key should be set to the txn ID of args.PusheeTxn, not
// args.PusherTxn. This RPC is addressed to the range which owns the pushee's
// txn record.
//
// Resolution is trivial if the txn which owns the intent has either
// been committed or aborted already. Otherwise, the existing txn can
// either be aborted (for write/write conflicts), or its commit
// timestamp can be moved forward (for read/write conflicts). The
// course of action is determined by the specified push type, and by
// the owning txn's status and priority.
type PushTxnRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// Transaction which encountered the intent, if applicable. For a
	// non-transactional pusher, pusher_txn will only have the priority set (in
	// particular, ID won't be set). Used to compare priorities and timestamps if
	// priorities are equal.
	PusherTxn Transaction `protobuf:"bytes,2,opt,name=pusher_txn,json=pusherTxn" json:"pusher_txn"`
	// Transaction to be pushed, as specified at the intent which led to
	// the push transaction request. Note that this may not be the most
	// up-to-date value of the transaction record, but will be set or
	// merged as appropriate.
	PusheeTxn cockroach_storage_engine_enginepb.TxnMeta `protobuf:"bytes,3,opt,name=pushee_txn,json=pusheeTxn" json:"pushee_txn"`
	// PushTo is the timestamp just after which PusheeTxn is attempted to be
	// pushed. During conflict resolution, it should be set to the timestamp
	// of the its conflicting write.
	PushTo cockroach_util_hlc.Timestamp `protobuf:"bytes,4,opt,name=push_to,json=pushTo" json:"push_to"`
	// Now holds the timestamp used to compare the last heartbeat of the pushee
	// against. This is necessary since the request header's timestamp does not
	// necessarily advance with the node clock across retries and hence cannot
	// detect abandoned transactions.
	Now cockroach_util_hlc.Timestamp `protobuf:"bytes,5,opt,name=now" json:"now"`
	// Readers set this to PUSH_TIMESTAMP to move pushee_txn's provisional
	// commit timestamp forward. Writers set this to PUSH_ABORT to request
	// that pushee_txn be aborted if possible. Inconsistent readers set
	// this to PUSH_TOUCH to determine whether the pushee can be aborted
	// due to inactivity (based on the now field).
	PushType PushTxnType `protobuf:"varint,6,opt,name=push_type,json=pushType,proto3,enum=cockroach.roachpb.PushTxnType" json:"push_type,omitempty"`
	// Forces the push by overriding the normal checks in PushTxn to
	// either abort or push the timestamp.
	Force bool `protobuf:"varint,7,opt,name=force,proto3" json:"force,omitempty"`
}

func (m *PushTxnRequest) Reset()                    { *m = PushTxnRequest{} }
func (m *PushTxnRequest) String() string            { return proto.CompactTextString(m) }
func (*PushTxnRequest) ProtoMessage()               {}
func (*PushTxnRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{46} }

// A PushTxnResponse is the return value from the PushTxn() method. It
// returns success and the resulting state of PusheeTxn if the
// conflict was resolved in favor of the caller; the caller should
// subsequently invoke ResolveIntent() on the conflicted key. It
// returns an error otherwise.
type PushTxnResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// pushee_txn is non-nil if the transaction was pushed and contains
	// the current value of the transaction.
	// TODO(tschottdorf): Maybe this can be a TxnMeta instead; probably requires
	// factoring out the new Priority.
	PusheeTxn Transaction `protobuf:"bytes,2,opt,name=pushee_txn,json=pusheeTxn" json:"pushee_txn"`
}

func (m *PushTxnResponse) Reset()                    { *m = PushTxnResponse{} }
func (m *PushTxnResponse) String() string            { return proto.CompactTextString(m) }
func (*PushTxnResponse) ProtoMessage()               {}
func (*PushTxnResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{47} }

// A QueryTxnResponse is arguments to the QueryTxn() method. It's sent
// by transactions which are waiting to push another transaction because
// of conflicting write intents to fetch updates to either the pusher's
// or the pushee's transaction records.
type QueryTxnRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// Transaction record to query.
	Txn cockroach_storage_engine_enginepb.TxnMeta `protobuf:"bytes,2,opt,name=txn" json:"txn"`
	// If true, the query will not return until there are changes to either the
	// transaction status or priority -OR- to the set of dependent transactions.
	WaitForUpdate bool `protobuf:"varint,3,opt,name=wait_for_update,json=waitForUpdate,proto3" json:"wait_for_update,omitempty"`
	// Set of known dependent transactions.
	KnownWaitingTxns []github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,4,rep,name=known_waiting_txns,json=knownWaitingTxns,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"known_waiting_txns,omitempty"`
}

func (m *QueryTxnRequest) Reset()                    { *m = QueryTxnRequest{} }
func (m *QueryTxnRequest) String() string            { return proto.CompactTextString(m) }
func (*QueryTxnRequest) ProtoMessage()               {}
func (*QueryTxnRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{48} }

// A QueryTxnResponse is the return value from the QueryTxn() method.
type QueryTxnResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// Contains the current state of the queried transaction. If the queried
	// transaction record does not exist, this will be empty.
	QueriedTxn Transaction `protobuf:"bytes,2,opt,name=queried_txn,json=queriedTxn" json:"queried_txn"`
	// Specifies a list of transaction IDs which are waiting on the txn.
	WaitingTxns []github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,3,rep,name=waiting_txns,json=waitingTxns,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"waiting_txns,omitempty"`
}

func (m *QueryTxnResponse) Reset()                    { *m = QueryTxnResponse{} }
func (m *QueryTxnResponse) String() string            { return proto.CompactTextString(m) }
func (*QueryTxnResponse) ProtoMessage()               {}
func (*QueryTxnResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{49} }

// A QueryIntentRequest is arguments to the QueryIntent() method. It visits
// the specified key and checks whether an intent is present for the given
// transaction.
type QueryIntentRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// The TxnMeta that the intent is expected to have. Specifically, whether an
	// intent is a match or not is defined as whether an intent exists that could
	// be committed by the provided transaction. If an intent is found at the
	// specified key, the intent is only considered a match if it has the same ID,
	// the same epoch, and a provisional commit timestamp that is equal to or less
	// than that in the provided transaction. For SERIALIZABLE transactions, if
	// the intent's timestamp is greater than that in the provided transaction, it
	// would prevent the transaction from committing and is therefore not a match.
	// However, for SNAPSHOT transactions, if the intent's timestamp is greater
	// than that in the provided transaction, it would not prevent the transaction
	// from committing and therefore is a match.
	//
	// Additionally, the intent is only considered a match if its sequence number
	// is equal to or greater than the expected txn's sequence number. The
	// requests doesn't require an exact sequence number match because the
	// transaction could have performed overlapping writes, in which case only the
	// latest sequence number will remain. We assume that if a transaction has
	// successfully written an intent at a larger sequence number then it must
	// have succeeeded in writing an intent at the smaller sequence number as
	// well.
	Txn cockroach_storage_engine_enginepb.TxnMeta `protobuf:"bytes,2,opt,name=txn" json:"txn"`
	// The behavior of the request if the expected intent is found to be not
	// present.
	IfMissing QueryIntentRequest_IfMissingBehavior `protobuf:"varint,3,opt,name=if_missing,json=ifMissing,proto3,enum=cockroach.roachpb.QueryIntentRequest_IfMissingBehavior" json:"if_missing,omitempty"`
}

func (m *QueryIntentRequest) Reset()                    { *m = QueryIntentRequest{} }
func (m *QueryIntentRequest) String() string            { return proto.CompactTextString(m) }
func (*QueryIntentRequest) ProtoMessage()               {}
func (*QueryIntentRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{50} }

// A QueryIntentResponse is the return value from the QueryIntent() method.
type QueryIntentResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// Whether an intent matching the expected transaction was found at the key.
	FoundIntent bool `protobuf:"varint,2,opt,name=found_intent,json=foundIntent,proto3" json:"found_intent,omitempty"`
}

func (m *QueryIntentResponse) Reset()                    { *m = QueryIntentResponse{} }
func (m *QueryIntentResponse) String() string            { return proto.CompactTextString(m) }
func (*QueryIntentResponse) ProtoMessage()               {}
func (*QueryIntentResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{51} }

// A ResolveIntentRequest is arguments to the ResolveIntent()
// method. It is sent by transaction coordinators after success
// calling PushTxn to clean up write intents: either to remove, commit
// or move them forward in time.
type ResolveIntentRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// The transaction whose intent is being resolved.
	IntentTxn cockroach_storage_engine_enginepb.TxnMeta `protobuf:"bytes,2,opt,name=intent_txn,json=intentTxn" json:"intent_txn"`
	// The status of the transaction.
	Status TransactionStatus `protobuf:"varint,3,opt,name=status,proto3,enum=cockroach.roachpb.TransactionStatus" json:"status,omitempty"`
	// Optionally poison the abort span for the transaction the intent's
	// range.
	Poison bool `protobuf:"varint,4,opt,name=poison,proto3" json:"poison,omitempty"`
}

func (m *ResolveIntentRequest) Reset()                    { *m = ResolveIntentRequest{} }
func (m *ResolveIntentRequest) String() string            { return proto.CompactTextString(m) }
func (*ResolveIntentRequest) ProtoMessage()               {}
func (*ResolveIntentRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{52} }

// A ResolveIntentResponse is the return value from the
// ResolveIntent() method.
type ResolveIntentResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *ResolveIntentResponse) Reset()                    { *m = ResolveIntentResponse{} }
func (m *ResolveIntentResponse) String() string            { return proto.CompactTextString(m) }
func (*ResolveIntentResponse) ProtoMessage()               {}
func (*ResolveIntentResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{53} }

// A ResolveIntentRangeRequest is arguments to the ResolveIntentRange() method.
// It is sent by transaction coordinators after success calling PushTxn to
// clean up write intents: either to remove, commit or move them forward in
// time.
type ResolveIntentRangeRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// The transaction whose intents are being resolved.
	IntentTxn cockroach_storage_engine_enginepb.TxnMeta `protobuf:"bytes,2,opt,name=intent_txn,json=intentTxn" json:"intent_txn"`
	// The status of the transaction.
	Status TransactionStatus `protobuf:"varint,3,opt,name=status,proto3,enum=cockroach.roachpb.TransactionStatus" json:"status,omitempty"`
	// Optionally poison the abort span for the transaction on all ranges
	// on which the intents reside.
	Poison bool `protobuf:"varint,4,opt,name=poison,proto3" json:"poison,omitempty"`
	// The minimum timestamp for any intents written by this
	// transaction. If present, this value can be used to optimize the
	// iteration over the span to find intents to resolve.
	MinTimestamp cockroach_util_hlc.Timestamp `protobuf:"bytes,5,opt,name=min_timestamp,json=minTimestamp" json:"min_timestamp"`
}

func (m *ResolveIntentRangeRequest) Reset()                    { *m = ResolveIntentRangeRequest{} }
func (m *ResolveIntentRangeRequest) String() string            { return proto.CompactTextString(m) }
func (*ResolveIntentRangeRequest) ProtoMessage()               {}
func (*ResolveIntentRangeRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{54} }

// A ResolveIntentRangeResponse is the return value from the
// ResolveIntent() method.
type ResolveIntentRangeResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *ResolveIntentRangeResponse) Reset()                    { *m = ResolveIntentRangeResponse{} }
func (m *ResolveIntentRangeResponse) String() string            { return proto.CompactTextString(m) }
func (*ResolveIntentRangeResponse) ProtoMessage()               {}
func (*ResolveIntentRangeResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{55} }

// A MergeRequest contains arguments to the Merge() method. It
// specifies a key and a value which should be merged into the
// existing value at that key.
type MergeRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Value         Value `protobuf:"bytes,2,opt,name=value" json:"value"`
}

func (m *MergeRequest) Reset()                    { *m = MergeRequest{} }
func (m *MergeRequest) String() string            { return proto.CompactTextString(m) }
func (*MergeRequest) ProtoMessage()               {}
func (*MergeRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{56} }

// MergeResponse is the response to a Merge() operation.
type MergeResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *MergeResponse) Reset()                    { *m = MergeResponse{} }
func (m *MergeResponse) String() string            { return proto.CompactTextString(m) }
func (*MergeResponse) ProtoMessage()               {}
func (*MergeResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{57} }

// TruncateLogRequest is used to remove a prefix of the raft log. While there
// is no requirement for correctness that the raft log truncation be synchronized across
// replicas, it is nice to preserve the property that all replicas of a range are as close
// to identical as possible. The raft leader can also inform decisions about the cutoff point
// with its knowledge of the replicas' acknowledgment status.
type TruncateLogRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// Log entries < this index are to be discarded.
	Index uint64 `protobuf:"varint,2,opt,name=index,proto3" json:"index,omitempty"`
	// RangeID is used to double check that the correct range is being truncated.
	// The header specifies a span, start and end keys, but not the range id
	// itself. The range may have changed from the one specified in the header
	// in the case of a merge.
	RangeID RangeID `protobuf:"varint,3,opt,name=range_id,json=rangeId,proto3,casttype=RangeID" json:"range_id,omitempty"`
}

func (m *TruncateLogRequest) Reset()                    { *m = TruncateLogRequest{} }
func (m *TruncateLogRequest) String() string            { return proto.CompactTextString(m) }
func (*TruncateLogRequest) ProtoMessage()               {}
func (*TruncateLogRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{58} }

// TruncateLogResponse is the response to a TruncateLog() operation.
type TruncateLogResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *TruncateLogResponse) Reset()                    { *m = TruncateLogResponse{} }
func (m *TruncateLogResponse) String() string            { return proto.CompactTextString(m) }
func (*TruncateLogResponse) ProtoMessage()               {}
func (*TruncateLogResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{59} }

// A RequestLeaseRequest is arguments to the RequestLease()
// method. It is sent by the store on behalf of one of its ranges upon receipt
// of a command requiring a lease when none is found.
type RequestLeaseRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Lease         Lease `protobuf:"bytes,2,opt,name=lease" json:"lease"`
	// The previous lease is specified by the caller to verify
	// it has not changed when executing this command.
	PrevLease Lease `protobuf:"bytes,3,opt,name=prev_lease,json=prevLease" json:"prev_lease"`
	// The MinLeaseProposedTS of the proposing replica to make sure that leases
	// issued after a node restart receive a new sequence number (instead of
	// counting as a lease extension). See #23204.
	MinProposedTS *cockroach_util_hlc.Timestamp `protobuf:"bytes,4,opt,name=min_proposed_ts,json=minProposedTs" json:"min_proposed_ts,omitempty"`
}

func (m *RequestLeaseRequest) Reset()                    { *m = RequestLeaseRequest{} }
func (m *RequestLeaseRequest) String() string            { return proto.CompactTextString(m) }
func (*RequestLeaseRequest) ProtoMessage()               {}
func (*RequestLeaseRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{60} }

// A TransferLeaseRequest represents the arguments to the TransferLease()
// method. It is sent by a replica that currently holds the range lease and
// wants to transfer it away.
//
// Like a RequestLeaseRequest, this request has the effect of instituting a new
// lease. The difference is that the new lease is allowed to overlap the
// existing one. It is a separate request because the RequestLeaseRequest is
// special - it's not subject to the same replay protection restrictions as
// other requests, instead being protected from replays by the fact that leases
// are not generally allowed to overlap. The TransferLeaseRequest is not
// special in this respect (for example, the proposer of this command is
// checked to have been holding the lease when the proposal was made).
type TransferLeaseRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Lease         Lease `protobuf:"bytes,2,opt,name=lease" json:"lease"`
	// The previous lease is specified by the caller to verify
	// it has not changed when executing this command.
	PrevLease Lease `protobuf:"bytes,3,opt,name=prev_lease,json=prevLease" json:"prev_lease"`
}

func (m *TransferLeaseRequest) Reset()                    { *m = TransferLeaseRequest{} }
func (m *TransferLeaseRequest) String() string            { return proto.CompactTextString(m) }
func (*TransferLeaseRequest) ProtoMessage()               {}
func (*TransferLeaseRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{61} }

// LeaseInfoRequest is the argument to the LeaseInfo() method, for getting
// information about a range's lease.
// It's a point request, so it addresses one single range, and returns the lease
// currently in effect for that range.
type LeaseInfoRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *LeaseInfoRequest) Reset()                    { *m = LeaseInfoRequest{} }
func (m *LeaseInfoRequest) String() string            { return proto.CompactTextString(m) }
func (*LeaseInfoRequest) ProtoMessage()               {}
func (*LeaseInfoRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{62} }

// LeaseInfoResponse is the response to a LeaseInfo() operation.
type LeaseInfoResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// The last lease known by the replica serving the request. It can also be the
	// tentative future lease, if a lease transfer is in progress.
	Lease Lease `protobuf:"bytes,2,opt,name=lease" json:"lease"`
}

func (m *LeaseInfoResponse) Reset()                    { *m = LeaseInfoResponse{} }
func (m *LeaseInfoResponse) String() string            { return proto.CompactTextString(m) }
func (*LeaseInfoResponse) ProtoMessage()               {}
func (*LeaseInfoResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{63} }

// A RequestLeaseResponse is the response to a RequestLease() or TransferLease()
// operation.
type RequestLeaseResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *RequestLeaseResponse) Reset()                    { *m = RequestLeaseResponse{} }
func (m *RequestLeaseResponse) String() string            { return proto.CompactTextString(m) }
func (*RequestLeaseResponse) ProtoMessage()               {}
func (*RequestLeaseResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{64} }

// A ComputeChecksumRequest is arguments to the ComputeChecksum() method, to
// start computing the checksum for the specified range at the snapshot for this
// request command. A response is returned without the checksum. The computed
// checksum is retrieved via a storage.CollectChecksumRequest.
type ComputeChecksumRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// The version used to pick the checksum method. It allows us to use a
	// consistent checksumming method across replicas.
	Version uint32 `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
	// Compute a checksum along with a snapshot of the entire range, that will be
	// used in logging a diff during checksum verification.
	Snapshot bool `protobuf:"varint,4,opt,name=snapshot,proto3" json:"snapshot,omitempty"`
}

func (m *ComputeChecksumRequest) Reset()                    { *m = ComputeChecksumRequest{} }
func (m *ComputeChecksumRequest) String() string            { return proto.CompactTextString(m) }
func (*ComputeChecksumRequest) ProtoMessage()               {}
func (*ComputeChecksumRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{65} }

// A ComputeChecksumResponse is the response to a ComputeChecksum() operation.
type ComputeChecksumResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// ChecksumID is the unique identifier that can be used to get the computed
	// checksum in a future storage.CollectChecksumRequest.
	ChecksumID github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,2,opt,name=checksum_id,json=checksumId,proto3,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"checksum_id"`
}

func (m *ComputeChecksumResponse) Reset()                    { *m = ComputeChecksumResponse{} }
func (m *ComputeChecksumResponse) String() string            { return proto.CompactTextString(m) }
func (*ComputeChecksumResponse) ProtoMessage()               {}
func (*ComputeChecksumResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{66} }

type ExportStorage struct {
	Provider          ExportStorageProvider       `protobuf:"varint,1,opt,name=provider,proto3,enum=cockroach.roachpb.ExportStorageProvider" json:"provider,omitempty"`
	LocalFile         ExportStorage_LocalFilePath `protobuf:"bytes,2,opt,name=LocalFile" json:"LocalFile"`
	HttpPath          ExportStorage_Http          `protobuf:"bytes,3,opt,name=HttpPath" json:"HttpPath"`
	GoogleCloudConfig *ExportStorage_GCS          `protobuf:"bytes,4,opt,name=GoogleCloudConfig" json:"GoogleCloudConfig,omitempty"`
	S3Config          *ExportStorage_S3           `protobuf:"bytes,5,opt,name=S3Config" json:"S3Config,omitempty"`
	AzureConfig       *ExportStorage_Azure        `protobuf:"bytes,6,opt,name=AzureConfig" json:"AzureConfig,omitempty"`
}

func (m *ExportStorage) Reset()                    { *m = ExportStorage{} }
func (m *ExportStorage) String() string            { return proto.CompactTextString(m) }
func (*ExportStorage) ProtoMessage()               {}
func (*ExportStorage) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{67} }

type ExportStorage_LocalFilePath struct {
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
}

func (m *ExportStorage_LocalFilePath) Reset()         { *m = ExportStorage_LocalFilePath{} }
func (m *ExportStorage_LocalFilePath) String() string { return proto.CompactTextString(m) }
func (*ExportStorage_LocalFilePath) ProtoMessage()    {}
func (*ExportStorage_LocalFilePath) Descriptor() ([]byte, []int) {
	return fileDescriptorApi, []int{67, 0}
}

type ExportStorage_Http struct {
	BaseUri string `protobuf:"bytes,1,opt,name=baseUri,proto3" json:"baseUri,omitempty"`
}

func (m *ExportStorage_Http) Reset()                    { *m = ExportStorage_Http{} }
func (m *ExportStorage_Http) String() string            { return proto.CompactTextString(m) }
func (*ExportStorage_Http) ProtoMessage()               {}
func (*ExportStorage_Http) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{67, 1} }

type ExportStorage_S3 struct {
	Bucket    string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	Prefix    string `protobuf:"bytes,2,opt,name=prefix,proto3" json:"prefix,omitempty"`
	AccessKey string `protobuf:"bytes,3,opt,name=access_key,json=accessKey,proto3" json:"access_key,omitempty"`
	Secret    string `protobuf:"bytes,4,opt,name=secret,proto3" json:"secret,omitempty"`
	TempToken string `protobuf:"bytes,5,opt,name=temp_token,json=tempToken,proto3" json:"temp_token,omitempty"`
	Endpoint  string `protobuf:"bytes,6,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	Region    string `protobuf:"bytes,7,opt,name=region,proto3" json:"region,omitempty"`
}

func (m *ExportStorage_S3) Reset()                    { *m = ExportStorage_S3{} }
func (m *ExportStorage_S3) String() string            { return proto.CompactTextString(m) }
func (*ExportStorage_S3) ProtoMessage()               {}
func (*ExportStorage_S3) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{67, 2} }

type ExportStorage_GCS struct {
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	Prefix string `protobuf:"bytes,2,opt,name=prefix,proto3" json:"prefix,omitempty"`
	Auth   string `protobuf:"bytes,3,opt,name=auth,proto3" json:"auth,omitempty"`
	// BillingProject if non-empty, is the Google Cloud project to bill for all storage requests.
	// This is required to be set if using a "requestor pays" bucket.
	BillingProject string `protobuf:"bytes,4,opt,name=billing_project,json=billingProject,proto3" json:"billing_project,omitempty"`
}

func (m *ExportStorage_GCS) Reset()                    { *m = ExportStorage_GCS{} }
func (m *ExportStorage_GCS) String() string            { return proto.CompactTextString(m) }
func (*ExportStorage_GCS) ProtoMessage()               {}
func (*ExportStorage_GCS) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{67, 3} }

type ExportStorage_Azure struct {
	Container   string `protobuf:"bytes,1,opt,name=container,proto3" json:"container,omitempty"`
	Prefix      string `protobuf:"bytes,2,opt,name=prefix,proto3" json:"prefix,omitempty"`
	AccountName string `protobuf:"bytes,3,opt,name=account_name,json=accountName,proto3" json:"account_name,omitempty"`
	AccountKey  string `protobuf:"bytes,4,opt,name=account_key,json=accountKey,proto3" json:"account_key,omitempty"`
}

func (m *ExportStorage_Azure) Reset()                    { *m = ExportStorage_Azure{} }
func (m *ExportStorage_Azure) String() string            { return proto.CompactTextString(m) }
func (*ExportStorage_Azure) ProtoMessage()               {}
func (*ExportStorage_Azure) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{67, 4} }

// WriteBatchRequest is arguments to the WriteBatch() method, to apply the
// operations encoded in a BatchRepr.
type WriteBatchRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// The span of keys encoded in data, duplicated because the header span can
	// be modified by DistSender and we use this one to fail fast.
	DataSpan Span `protobuf:"bytes,2,opt,name=data_span,json=dataSpan" json:"data_span"`
	// A BatchRepr, the serialized form of a RocksDB Batch.
	Data []byte `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *WriteBatchRequest) Reset()                    { *m = WriteBatchRequest{} }
func (m *WriteBatchRequest) String() string            { return proto.CompactTextString(m) }
func (*WriteBatchRequest) ProtoMessage()               {}
func (*WriteBatchRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{68} }

// WriteBatchResponse is the response to a WriteBatch() operation.
type WriteBatchResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *WriteBatchResponse) Reset()                    { *m = WriteBatchResponse{} }
func (m *WriteBatchResponse) String() string            { return proto.CompactTextString(m) }
func (*WriteBatchResponse) ProtoMessage()               {}
func (*WriteBatchResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{69} }

// ExportRequest is the argument to the Export() method, to dump a keyrange into
// files under a basepath.
type ExportRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Storage       ExportStorage                `protobuf:"bytes,2,opt,name=storage" json:"storage"`
	StartTime     cockroach_util_hlc.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime" json:"start_time"`
	MVCCFilter    MVCCFilter                   `protobuf:"varint,4,opt,name=mvcc_filter,json=mvccFilter,proto3,enum=cockroach.roachpb.MVCCFilter" json:"mvcc_filter,omitempty"`
	// Return the exported SST data in the response.
	ReturnSST bool `protobuf:"varint,5,opt,name=return_sst,json=returnSst,proto3" json:"return_sst,omitempty"`
	// OmitChecksum, if true, will skip checksumming the sst and leave the
	// `Sha512` field empty in the response. During a rolling upgrade to 2.1, it
	// may still be set if the request is served by an old node, but since the
	// caller has declare they're not going to use it, that's okay.
	OmitChecksum bool `protobuf:"varint,6,opt,name=omit_checksum,json=omitChecksum,proto3" json:"omit_checksum,omitempty"`
}

func (m *ExportRequest) Reset()                    { *m = ExportRequest{} }
func (m *ExportRequest) String() string            { return proto.CompactTextString(m) }
func (*ExportRequest) ProtoMessage()               {}
func (*ExportRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{70} }

type BulkOpSummary struct {
	DataSize      int64 `protobuf:"varint,1,opt,name=data_size,json=dataSize,proto3" json:"data_size,omitempty"`
	Rows          int64 `protobuf:"varint,2,opt,name=rows,proto3" json:"rows,omitempty"`
	IndexEntries  int64 `protobuf:"varint,3,opt,name=index_entries,json=indexEntries,proto3" json:"index_entries,omitempty"`
	SystemRecords int64 `protobuf:"varint,4,opt,name=system_records,json=systemRecords,proto3" json:"system_records,omitempty"`
}

func (m *BulkOpSummary) Reset()                    { *m = BulkOpSummary{} }
func (m *BulkOpSummary) String() string            { return proto.CompactTextString(m) }
func (*BulkOpSummary) ProtoMessage()               {}
func (*BulkOpSummary) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{71} }

// ExportResponse is the response to an Export() operation.
type ExportResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Files          []ExportResponse_File        `protobuf:"bytes,2,rep,name=files" json:"files"`
	StartTime      cockroach_util_hlc.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime" json:"start_time"`
}

func (m *ExportResponse) Reset()                    { *m = ExportResponse{} }
func (m *ExportResponse) String() string            { return proto.CompactTextString(m) }
func (*ExportResponse) ProtoMessage()               {}
func (*ExportResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{72} }

// File describes a keyrange that has been dumped to a file at the given
// path.
type ExportResponse_File struct {
	Span     Span          `protobuf:"bytes,1,opt,name=span" json:"span"`
	Path     string        `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	Sha512   []byte        `protobuf:"bytes,5,opt,name=sha512,proto3" json:"sha512,omitempty"`
	Exported BulkOpSummary `protobuf:"bytes,6,opt,name=exported" json:"exported"`
	SST      []byte        `protobuf:"bytes,7,opt,name=sst,proto3" json:"sst,omitempty"`
}

func (m *ExportResponse_File) Reset()                    { *m = ExportResponse_File{} }
func (m *ExportResponse_File) String() string            { return proto.CompactTextString(m) }
func (*ExportResponse_File) ProtoMessage()               {}
func (*ExportResponse_File) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{72, 0} }

// ImportRequest is the argument to the Import() method, to bulk load key/value
// entries.
type ImportRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// Files contains an ordered list of files, each containing kv entries to
	// import. Entries in later files with the same key override earlier ones.
	Files []ImportRequest_File `protobuf:"bytes,2,rep,name=files" json:"files"`
	// DataSpan is the pre-rewrite keyrange of the data in `Files`.
	DataSpan Span `protobuf:"bytes,3,opt,name=data_span,json=dataSpan" json:"data_span"`
	// EndTime, if not the zero value, will cause only entries before it to be
	// imported.
	EndTime cockroach_util_hlc.Timestamp `protobuf:"bytes,6,opt,name=end_time,json=endTime" json:"end_time"`
	// Rekeys contains the descriptors for the data being Imported and the
	// previous ID for each (which is the ID used in the source data pointed to by
	// `files`).
	// TODO(dan): This field is a superset of the information represented by
	// `key_rewrites` and will supercede it once rekeying of interleaved tables is
	// fixed.
	Rekeys []ImportRequest_TableRekey `protobuf:"bytes,5,rep,name=rekeys" json:"rekeys"`
}

func (m *ImportRequest) Reset()                    { *m = ImportRequest{} }
func (m *ImportRequest) String() string            { return proto.CompactTextString(m) }
func (*ImportRequest) ProtoMessage()               {}
func (*ImportRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{73} }

type ImportRequest_File struct {
	Dir    ExportStorage `protobuf:"bytes,1,opt,name=dir" json:"dir"`
	Path   string        `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	Sha512 []byte        `protobuf:"bytes,4,opt,name=sha512,proto3" json:"sha512,omitempty"`
}

func (m *ImportRequest_File) Reset()                    { *m = ImportRequest_File{} }
func (m *ImportRequest_File) String() string            { return proto.CompactTextString(m) }
func (*ImportRequest_File) ProtoMessage()               {}
func (*ImportRequest_File) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{73, 0} }

type ImportRequest_TableRekey struct {
	// OldID is the previous ID of `new_desc`.
	OldID uint32 `protobuf:"varint,1,opt,name=old_id,json=oldId,proto3" json:"old_id,omitempty"`
	// NewDesc is an encoded Descriptor message.
	NewDesc []byte `protobuf:"bytes,2,opt,name=new_desc,json=newDesc,proto3" json:"new_desc,omitempty"`
}

func (m *ImportRequest_TableRekey) Reset()                    { *m = ImportRequest_TableRekey{} }
func (m *ImportRequest_TableRekey) String() string            { return proto.CompactTextString(m) }
func (*ImportRequest_TableRekey) ProtoMessage()               {}
func (*ImportRequest_TableRekey) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{73, 1} }

// ImportResponse is the response to a Import() operation.
type ImportResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Imported       BulkOpSummary `protobuf:"bytes,3,opt,name=imported" json:"imported"`
}

func (m *ImportResponse) Reset()                    { *m = ImportResponse{} }
func (m *ImportResponse) String() string            { return proto.CompactTextString(m) }
func (*ImportResponse) ProtoMessage()               {}
func (*ImportResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{74} }

// AdminScatterRequest is the argument to the AdminScatter() method, which moves
// replicas and leaseholders for a selection of ranges. Scatter is best-effort;
// ranges that cannot be moved will include an error detail in the response and
// won't fail the request.
type AdminScatterRequest struct {
	RequestHeader   `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	RandomizeLeases bool `protobuf:"varint,2,opt,name=randomize_leases,json=randomizeLeases,proto3" json:"randomize_leases,omitempty"`
}

func (m *AdminScatterRequest) Reset()                    { *m = AdminScatterRequest{} }
func (m *AdminScatterRequest) String() string            { return proto.CompactTextString(m) }
func (*AdminScatterRequest) ProtoMessage()               {}
func (*AdminScatterRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{75} }

// ScatterResponse is the response to a Scatter() operation.
type AdminScatterResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Ranges         []AdminScatterResponse_Range `protobuf:"bytes,2,rep,name=ranges" json:"ranges"`
}

func (m *AdminScatterResponse) Reset()                    { *m = AdminScatterResponse{} }
func (m *AdminScatterResponse) String() string            { return proto.CompactTextString(m) }
func (*AdminScatterResponse) ProtoMessage()               {}
func (*AdminScatterResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{76} }

type AdminScatterResponse_Range struct {
	Span Span `protobuf:"bytes,1,opt,name=span" json:"span"`
}

func (m *AdminScatterResponse_Range) Reset()         { *m = AdminScatterResponse_Range{} }
func (m *AdminScatterResponse_Range) String() string { return proto.CompactTextString(m) }
func (*AdminScatterResponse_Range) ProtoMessage()    {}
func (*AdminScatterResponse_Range) Descriptor() ([]byte, []int) {
	return fileDescriptorApi, []int{76, 0}
}

// AddSSTableRequest is arguments to the AddSSTable() method, to link a file
// into the RocksDB log-structured merge-tree.
type AddSSTableRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Data          []byte `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *AddSSTableRequest) Reset()                    { *m = AddSSTableRequest{} }
func (m *AddSSTableRequest) String() string            { return proto.CompactTextString(m) }
func (*AddSSTableRequest) ProtoMessage()               {}
func (*AddSSTableRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{77} }

// AddSSTableResponse is the response to a AddSSTable() operation.
type AddSSTableResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *AddSSTableResponse) Reset()                    { *m = AddSSTableResponse{} }
func (m *AddSSTableResponse) String() string            { return proto.CompactTextString(m) }
func (*AddSSTableResponse) ProtoMessage()               {}
func (*AddSSTableResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{78} }

// RefreshRequest is arguments to the Refresh() method, which verifies
// that no write has occurred since the transaction's orig timestamp
// to the specified key. Either the read or write timestamp cache is
// updated according to the write parameter. A transaction must be
// supplied with this request. If the key has been written more
// recently than the original txn timestamp, an error is returned
// and the timestamp cache is not updated.
type RefreshRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// If set, indicates that the write timestamp cache should be
	// updated. This handles the case of DeleteRange, which must set the
	// write too old flag on transactions which attempt earlier writes.
	Write bool `protobuf:"varint,2,opt,name=write,proto3" json:"write,omitempty"`
}

func (m *RefreshRequest) Reset()                    { *m = RefreshRequest{} }
func (m *RefreshRequest) String() string            { return proto.CompactTextString(m) }
func (*RefreshRequest) ProtoMessage()               {}
func (*RefreshRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{79} }

// RefreshResponse is the response to a Refresh() operation.
type RefreshResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *RefreshResponse) Reset()                    { *m = RefreshResponse{} }
func (m *RefreshResponse) String() string            { return proto.CompactTextString(m) }
func (*RefreshResponse) ProtoMessage()               {}
func (*RefreshResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{80} }

// RefreshRangeRequest is arguments to the RefreshRange() method, which
// is similar to RefreshRequest (see comments above), but operates on
// a key span instead of a single key.
type RefreshRangeRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// If set, indicates that the write timestamp cache should be
	// updated. This handles the case of DeleteRange, which must set the
	// write too old flag on transactions which attempt earlier writes.
	Write bool `protobuf:"varint,2,opt,name=write,proto3" json:"write,omitempty"`
}

func (m *RefreshRangeRequest) Reset()                    { *m = RefreshRangeRequest{} }
func (m *RefreshRangeRequest) String() string            { return proto.CompactTextString(m) }
func (*RefreshRangeRequest) ProtoMessage()               {}
func (*RefreshRangeRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{81} }

// RefreshRangeResponse is the response to a RefreshRange() operation.
type RefreshRangeResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *RefreshRangeResponse) Reset()                    { *m = RefreshRangeResponse{} }
func (m *RefreshRangeResponse) String() string            { return proto.CompactTextString(m) }
func (*RefreshRangeResponse) ProtoMessage()               {}
func (*RefreshRangeResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{82} }

// SubsumeRequest is the argument to the Subsume() method, which freezes a range
// for merging with its left-hand neighbor.
//
// Subsume, when called correctly, provides important guarantees that ensure
// there is no moment in time where the ranges involved in the merge could both
// process commands for the same keys. See the comment on Subsume for details.
//
// Subsume may return stale MVCC statistics when used outside of a merge
// transaction. As a rule of thumb, it is incorrect to call Subsume, except from
// its carefully-chosen location within a merge transaction.
type SubsumeRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// The range descriptor for the left-hand side of the merge. Used by the
	// right-hand side to sanity-check the validity of the merge.
	LeftRange RangeDescriptor `protobuf:"bytes,2,opt,name=left_range,json=leftRange" json:"left_range"`
}

func (m *SubsumeRequest) Reset()                    { *m = SubsumeRequest{} }
func (m *SubsumeRequest) String() string            { return proto.CompactTextString(m) }
func (*SubsumeRequest) ProtoMessage()               {}
func (*SubsumeRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{83} }

// SubsumeResponse is the response to a SubsumeRequest.
type SubsumeResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// MVCCStats are the MVCC statistics for the range.
	MVCCStats cockroach_storage_engine_enginepb1.MVCCStats `protobuf:"bytes,3,opt,name=mvcc_stats,json=mvccStats" json:"mvcc_stats"`
	// LeaseAppliedIndex is the lease index of the last applied command at the
	// time that the Subsume request executed.
	LeaseAppliedIndex uint64 `protobuf:"varint,4,opt,name=lease_applied_index,json=leaseAppliedIndex,proto3" json:"lease_applied_index,omitempty"`
	// FreezeStart is a timestamp that is guaranteed to be greater than the
	// timestamps at which any requests were serviced by the responding replica
	// before it stopped responding to requests altogether (in anticipation of
	// being subsumed). It is suitable for use as the timestamp cache's low water
	// mark for the keys previously owned by the subsumed range.
	FreezeStart cockroach_util_hlc.Timestamp `protobuf:"bytes,5,opt,name=freeze_start,json=freezeStart" json:"freeze_start"`
}

func (m *SubsumeResponse) Reset()                    { *m = SubsumeResponse{} }
func (m *SubsumeResponse) String() string            { return proto.CompactTextString(m) }
func (*SubsumeResponse) ProtoMessage()               {}
func (*SubsumeResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{84} }

// RangeStatsRequest is the argument to the RangeStats() method. It requests the
// MVCC statistics of the receiving range.
type RangeStatsRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *RangeStatsRequest) Reset()                    { *m = RangeStatsRequest{} }
func (m *RangeStatsRequest) String() string            { return proto.CompactTextString(m) }
func (*RangeStatsRequest) ProtoMessage()               {}
func (*RangeStatsRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{85} }

// RangeStatsResponse is the response to a RangeStatsRequest.
type RangeStatsResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// MVCCStats are the MVCC statistics for the range that processed the
	// request.
	MVCCStats cockroach_storage_engine_enginepb1.MVCCStats `protobuf:"bytes,2,opt,name=mvcc_stats,json=mvccStats" json:"mvcc_stats"`
}

func (m *RangeStatsResponse) Reset()                    { *m = RangeStatsResponse{} }
func (m *RangeStatsResponse) String() string            { return proto.CompactTextString(m) }
func (*RangeStatsResponse) ProtoMessage()               {}
func (*RangeStatsResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{86} }

// A RequestUnion contains exactly one of the requests.
// The values added here must match those in ResponseUnion.
//
// Be cautious about deprecating fields as doing so can lead to inconsistencies
// between replicas.
type RequestUnion struct {
	// Types that are valid to be assigned to Value:
	//	*RequestUnion_Get
	//	*RequestUnion_Put
	//	*RequestUnion_ConditionalPut
	//	*RequestUnion_Increment
	//	*RequestUnion_Delete
	//	*RequestUnion_DeleteRange
	//	*RequestUnion_ClearRange
	//	*RequestUnion_Scan
	//	*RequestUnion_BeginTransaction
	//	*RequestUnion_EndTransaction
	//	*RequestUnion_AdminSplit
	//	*RequestUnion_AdminMerge
	//	*RequestUnion_AdminTransferLease
	//	*RequestUnion_AdminChangeReplicas
	//	*RequestUnion_AdminRelocateRange
	//	*RequestUnion_HeartbeatTxn
	//	*RequestUnion_Gc
	//	*RequestUnion_PushTxn
	//	*RequestUnion_ResolveIntent
	//	*RequestUnion_ResolveIntentRange
	//	*RequestUnion_Merge
	//	*RequestUnion_TruncateLog
	//	*RequestUnion_RequestLease
	//	*RequestUnion_ReverseScan
	//	*RequestUnion_ComputeChecksum
	//	*RequestUnion_CheckConsistency
	//	*RequestUnion_InitPut
	//	*RequestUnion_TransferLease
	//	*RequestUnion_LeaseInfo
	//	*RequestUnion_WriteBatch
	//	*RequestUnion_Export
	//	*RequestUnion_Import
	//	*RequestUnion_QueryTxn
	//	*RequestUnion_QueryIntent
	//	*RequestUnion_AdminScatter
	//	*RequestUnion_AddSstable
	//	*RequestUnion_RecomputeStats
	//	*RequestUnion_Refresh
	//	*RequestUnion_RefreshRange
	//	*RequestUnion_Subsume
	//	*RequestUnion_RangeStats
	Value isRequestUnion_Value `protobuf_oneof:"value"`
}

func (m *RequestUnion) Reset()                    { *m = RequestUnion{} }
func (m *RequestUnion) String() string            { return proto.CompactTextString(m) }
func (*RequestUnion) ProtoMessage()               {}
func (*RequestUnion) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{87} }

type isRequestUnion_Value interface {
	isRequestUnion_Value()
	MarshalTo([]byte) (int, error)
	Size() int
}

type RequestUnion_Get struct {
	Get *GetRequest `protobuf:"bytes,1,opt,name=get,oneof"`
}
type RequestUnion_Put struct {
	Put *PutRequest `protobuf:"bytes,2,opt,name=put,oneof"`
}
type RequestUnion_ConditionalPut struct {
	ConditionalPut *ConditionalPutRequest `protobuf:"bytes,3,opt,name=conditional_put,json=conditionalPut,oneof"`
}
type RequestUnion_Increment struct {
	Increment *IncrementRequest `protobuf:"bytes,4,opt,name=increment,oneof"`
}
type RequestUnion_Delete struct {
	Delete *DeleteRequest `protobuf:"bytes,5,opt,name=delete,oneof"`
}
type RequestUnion_DeleteRange struct {
	DeleteRange *DeleteRangeRequest `protobuf:"bytes,6,opt,name=delete_range,json=deleteRange,oneof"`
}
type RequestUnion_ClearRange struct {
	ClearRange *ClearRangeRequest `protobuf:"bytes,38,opt,name=clear_range,json=clearRange,oneof"`
}
type RequestUnion_Scan struct {
	Scan *ScanRequest `protobuf:"bytes,7,opt,name=scan,oneof"`
}
type RequestUnion_BeginTransaction struct {
	BeginTransaction *BeginTransactionRequest `protobuf:"bytes,8,opt,name=begin_transaction,json=beginTransaction,oneof"`
}
type RequestUnion_EndTransaction struct {
	EndTransaction *EndTransactionRequest `protobuf:"bytes,9,opt,name=end_transaction,json=endTransaction,oneof"`
}
type RequestUnion_AdminSplit struct {
	AdminSplit *AdminSplitRequest `protobuf:"bytes,10,opt,name=admin_split,json=adminSplit,oneof"`
}
type RequestUnion_AdminMerge struct {
	AdminMerge *AdminMergeRequest `protobuf:"bytes,11,opt,name=admin_merge,json=adminMerge,oneof"`
}
type RequestUnion_AdminTransferLease struct {
	AdminTransferLease *AdminTransferLeaseRequest `protobuf:"bytes,29,opt,name=admin_transfer_lease,json=adminTransferLease,oneof"`
}
type RequestUnion_AdminChangeReplicas struct {
	AdminChangeReplicas *AdminChangeReplicasRequest `protobuf:"bytes,35,opt,name=admin_change_replicas,json=adminChangeReplicas,oneof"`
}
type RequestUnion_AdminRelocateRange struct {
	AdminRelocateRange *AdminRelocateRangeRequest `protobuf:"bytes,45,opt,name=admin_relocate_range,json=adminRelocateRange,oneof"`
}
type RequestUnion_HeartbeatTxn struct {
	HeartbeatTxn *HeartbeatTxnRequest `protobuf:"bytes,12,opt,name=heartbeat_txn,json=heartbeatTxn,oneof"`
}
type RequestUnion_Gc struct {
	Gc *GCRequest `protobuf:"bytes,13,opt,name=gc,oneof"`
}
type RequestUnion_PushTxn struct {
	PushTxn *PushTxnRequest `protobuf:"bytes,14,opt,name=push_txn,json=pushTxn,oneof"`
}
type RequestUnion_ResolveIntent struct {
	ResolveIntent *ResolveIntentRequest `protobuf:"bytes,16,opt,name=resolve_intent,json=resolveIntent,oneof"`
}
type RequestUnion_ResolveIntentRange struct {
	ResolveIntentRange *ResolveIntentRangeRequest `protobuf:"bytes,17,opt,name=resolve_intent_range,json=resolveIntentRange,oneof"`
}
type RequestUnion_Merge struct {
	Merge *MergeRequest `protobuf:"bytes,18,opt,name=merge,oneof"`
}
type RequestUnion_TruncateLog struct {
	TruncateLog *TruncateLogRequest `protobuf:"bytes,19,opt,name=truncate_log,json=truncateLog,oneof"`
}
type RequestUnion_RequestLease struct {
	RequestLease *RequestLeaseRequest `protobuf:"bytes,20,opt,name=request_lease,json=requestLease,oneof"`
}
type RequestUnion_ReverseScan struct {
	ReverseScan *ReverseScanRequest `protobuf:"bytes,21,opt,name=reverse_scan,json=reverseScan,oneof"`
}
type RequestUnion_ComputeChecksum struct {
	ComputeChecksum *ComputeChecksumRequest `protobuf:"bytes,22,opt,name=compute_checksum,json=computeChecksum,oneof"`
}
type RequestUnion_CheckConsistency struct {
	CheckConsistency *CheckConsistencyRequest `protobuf:"bytes,24,opt,name=check_consistency,json=checkConsistency,oneof"`
}
type RequestUnion_InitPut struct {
	InitPut *InitPutRequest `protobuf:"bytes,26,opt,name=init_put,json=initPut,oneof"`
}
type RequestUnion_TransferLease struct {
	TransferLease *TransferLeaseRequest `protobuf:"bytes,28,opt,name=transfer_lease,json=transferLease,oneof"`
}
type RequestUnion_LeaseInfo struct {
	LeaseInfo *LeaseInfoRequest `protobuf:"bytes,30,opt,name=lease_info,json=leaseInfo,oneof"`
}
type RequestUnion_WriteBatch struct {
	WriteBatch *WriteBatchRequest `protobuf:"bytes,31,opt,name=write_batch,json=writeBatch,oneof"`
}
type RequestUnion_Export struct {
	Export *ExportRequest `protobuf:"bytes,32,opt,name=export,oneof"`
}
type RequestUnion_Import struct {
	Import *ImportRequest `protobuf:"bytes,34,opt,name=import,oneof"`
}
type RequestUnion_QueryTxn struct {
	QueryTxn *QueryTxnRequest `protobuf:"bytes,33,opt,name=query_txn,json=queryTxn,oneof"`
}
type RequestUnion_QueryIntent struct {
	QueryIntent *QueryIntentRequest `protobuf:"bytes,42,opt,name=query_intent,json=queryIntent,oneof"`
}
type RequestUnion_AdminScatter struct {
	AdminScatter *AdminScatterRequest `protobuf:"bytes,36,opt,name=admin_scatter,json=adminScatter,oneof"`
}
type RequestUnion_AddSstable struct {
	AddSstable *AddSSTableRequest `protobuf:"bytes,37,opt,name=add_sstable,json=addSstable,oneof"`
}
type RequestUnion_RecomputeStats struct {
	RecomputeStats *RecomputeStatsRequest `protobuf:"bytes,39,opt,name=recompute_stats,json=recomputeStats,oneof"`
}
type RequestUnion_Refresh struct {
	Refresh *RefreshRequest `protobuf:"bytes,40,opt,name=refresh,oneof"`
}
type RequestUnion_RefreshRange struct {
	RefreshRange *RefreshRangeRequest `protobuf:"bytes,41,opt,name=refresh_range,json=refreshRange,oneof"`
}
type RequestUnion_Subsume struct {
	Subsume *SubsumeRequest `protobuf:"bytes,43,opt,name=subsume,oneof"`
}
type RequestUnion_RangeStats struct {
	RangeStats *RangeStatsRequest `protobuf:"bytes,44,opt,name=range_stats,json=rangeStats,oneof"`
}

func (*RequestUnion_Get) isRequestUnion_Value()                 {}
func (*RequestUnion_Put) isRequestUnion_Value()                 {}
func (*RequestUnion_ConditionalPut) isRequestUnion_Value()      {}
func (*RequestUnion_Increment) isRequestUnion_Value()           {}
func (*RequestUnion_Delete) isRequestUnion_Value()              {}
func (*RequestUnion_DeleteRange) isRequestUnion_Value()         {}
func (*RequestUnion_ClearRange) isRequestUnion_Value()          {}
func (*RequestUnion_Scan) isRequestUnion_Value()                {}
func (*RequestUnion_BeginTransaction) isRequestUnion_Value()    {}
func (*RequestUnion_EndTransaction) isRequestUnion_Value()      {}
func (*RequestUnion_AdminSplit) isRequestUnion_Value()          {}
func (*RequestUnion_AdminMerge) isRequestUnion_Value()          {}
func (*RequestUnion_AdminTransferLease) isRequestUnion_Value()  {}
func (*RequestUnion_AdminChangeReplicas) isRequestUnion_Value() {}
func (*RequestUnion_AdminRelocateRange) isRequestUnion_Value()  {}
func (*RequestUnion_HeartbeatTxn) isRequestUnion_Value()        {}
func (*RequestUnion_Gc) isRequestUnion_Value()                  {}
func (*RequestUnion_PushTxn) isRequestUnion_Value()             {}
func (*RequestUnion_ResolveIntent) isRequestUnion_Value()       {}
func (*RequestUnion_ResolveIntentRange) isRequestUnion_Value()  {}
func (*RequestUnion_Merge) isRequestUnion_Value()               {}
func (*RequestUnion_TruncateLog) isRequestUnion_Value()         {}
func (*RequestUnion_RequestLease) isRequestUnion_Value()        {}
func (*RequestUnion_ReverseScan) isRequestUnion_Value()         {}
func (*RequestUnion_ComputeChecksum) isRequestUnion_Value()     {}
func (*RequestUnion_CheckConsistency) isRequestUnion_Value()    {}
func (*RequestUnion_InitPut) isRequestUnion_Value()             {}
func (*RequestUnion_TransferLease) isRequestUnion_Value()       {}
func (*RequestUnion_LeaseInfo) isRequestUnion_Value()           {}
func (*RequestUnion_WriteBatch) isRequestUnion_Value()          {}
func (*RequestUnion_Export) isRequestUnion_Value()              {}
func (*RequestUnion_Import) isRequestUnion_Value()              {}
func (*RequestUnion_QueryTxn) isRequestUnion_Value()            {}
func (*RequestUnion_QueryIntent) isRequestUnion_Value()         {}
func (*RequestUnion_AdminScatter) isRequestUnion_Value()        {}
func (*RequestUnion_AddSstable) isRequestUnion_Value()          {}
func (*RequestUnion_RecomputeStats) isRequestUnion_Value()      {}
func (*RequestUnion_Refresh) isRequestUnion_Value()             {}
func (*RequestUnion_RefreshRange) isRequestUnion_Value()        {}
func (*RequestUnion_Subsume) isRequestUnion_Value()             {}
func (*RequestUnion_RangeStats) isRequestUnion_Value()          {}

func (m *RequestUnion) GetValue() isRequestUnion_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *RequestUnion) GetGet() *GetRequest {
	if x, ok := m.GetValue().(*RequestUnion_Get); ok {
		return x.Get
	}
	return nil
}

func (m *RequestUnion) GetPut() *PutRequest {
	if x, ok := m.GetValue().(*RequestUnion_Put); ok {
		return x.Put
	}
	return nil
}

func (m *RequestUnion) GetConditionalPut() *ConditionalPutRequest {
	if x, ok := m.GetValue().(*RequestUnion_ConditionalPut); ok {
		return x.ConditionalPut
	}
	return nil
}

func (m *RequestUnion) GetIncrement() *IncrementRequest {
	if x, ok := m.GetValue().(*RequestUnion_Increment); ok {
		return x.Increment
	}
	return nil
}

func (m *RequestUnion) GetDelete() *DeleteRequest {
	if x, ok := m.GetValue().(*RequestUnion_Delete); ok {
		return x.Delete
	}
	return nil
}

func (m *RequestUnion) GetDeleteRange() *DeleteRangeRequest {
	if x, ok := m.GetValue().(*RequestUnion_DeleteRange); ok {
		return x.DeleteRange
	}
	return nil
}

func (m *RequestUnion) GetClearRange() *ClearRangeRequest {
	if x, ok := m.GetValue().(*RequestUnion_ClearRange); ok {
		return x.ClearRange
	}
	return nil
}

func (m *RequestUnion) GetScan() *ScanRequest {
	if x, ok := m.GetValue().(*RequestUnion_Scan); ok {
		return x.Scan
	}
	return nil
}

func (m *RequestUnion) GetBeginTransaction() *BeginTransactionRequest {
	if x, ok := m.GetValue().(*RequestUnion_BeginTransaction); ok {
		return x.BeginTransaction
	}
	return nil
}

func (m *RequestUnion) GetEndTransaction() *EndTransactionRequest {
	if x, ok := m.GetValue().(*RequestUnion_EndTransaction); ok {
		return x.EndTransaction
	}
	return nil
}

func (m *RequestUnion) GetAdminSplit() *AdminSplitRequest {
	if x, ok := m.GetValue().(*RequestUnion_AdminSplit); ok {
		return x.AdminSplit
	}
	return nil
}

func (m *RequestUnion) GetAdminMerge() *AdminMergeRequest {
	if x, ok := m.GetValue().(*RequestUnion_AdminMerge); ok {
		return x.AdminMerge
	}
	return nil
}

func (m *RequestUnion) GetAdminTransferLease() *AdminTransferLeaseRequest {
	if x, ok := m.GetValue().(*RequestUnion_AdminTransferLease); ok {
		return x.AdminTransferLease
	}
	return nil
}

func (m *RequestUnion) GetAdminChangeReplicas() *AdminChangeReplicasRequest {
	if x, ok := m.GetValue().(*RequestUnion_AdminChangeReplicas); ok {
		return x.AdminChangeReplicas
	}
	return nil
}

func (m *RequestUnion) GetAdminRelocateRange() *AdminRelocateRangeRequest {
	if x, ok := m.GetValue().(*RequestUnion_AdminRelocateRange); ok {
		return x.AdminRelocateRange
	}
	return nil
}

func (m *RequestUnion) GetHeartbeatTxn() *HeartbeatTxnRequest {
	if x, ok := m.GetValue().(*RequestUnion_HeartbeatTxn); ok {
		return x.HeartbeatTxn
	}
	return nil
}

func (m *RequestUnion) GetGc() *GCRequest {
	if x, ok := m.GetValue().(*RequestUnion_Gc); ok {
		return x.Gc
	}
	return nil
}

func (m *RequestUnion) GetPushTxn() *PushTxnRequest {
	if x, ok := m.GetValue().(*RequestUnion_PushTxn); ok {
		return x.PushTxn
	}
	return nil
}

func (m *RequestUnion) GetResolveIntent() *ResolveIntentRequest {
	if x, ok := m.GetValue().(*RequestUnion_ResolveIntent); ok {
		return x.ResolveIntent
	}
	return nil
}

func (m *RequestUnion) GetResolveIntentRange() *ResolveIntentRangeRequest {
	if x, ok := m.GetValue().(*RequestUnion_ResolveIntentRange); ok {
		return x.ResolveIntentRange
	}
	return nil
}

func (m *RequestUnion) GetMerge() *MergeRequest {
	if x, ok := m.GetValue().(*RequestUnion_Merge); ok {
		return x.Merge
	}
	return nil
}

func (m *RequestUnion) GetTruncateLog() *TruncateLogRequest {
	if x, ok := m.GetValue().(*RequestUnion_TruncateLog); ok {
		return x.TruncateLog
	}
	return nil
}

func (m *RequestUnion) GetRequestLease() *RequestLeaseRequest {
	if x, ok := m.GetValue().(*RequestUnion_RequestLease); ok {
		return x.RequestLease
	}
	return nil
}

func (m *RequestUnion) GetReverseScan() *ReverseScanRequest {
	if x, ok := m.GetValue().(*RequestUnion_ReverseScan); ok {
		return x.ReverseScan
	}
	return nil
}

func (m *RequestUnion) GetComputeChecksum() *ComputeChecksumRequest {
	if x, ok := m.GetValue().(*RequestUnion_ComputeChecksum); ok {
		return x.ComputeChecksum
	}
	return nil
}

func (m *RequestUnion) GetCheckConsistency() *CheckConsistencyRequest {
	if x, ok := m.GetValue().(*RequestUnion_CheckConsistency); ok {
		return x.CheckConsistency
	}
	return nil
}

func (m *RequestUnion) GetInitPut() *InitPutRequest {
	if x, ok := m.GetValue().(*RequestUnion_InitPut); ok {
		return x.InitPut
	}
	return nil
}

func (m *RequestUnion) GetTransferLease() *TransferLeaseRequest {
	if x, ok := m.GetValue().(*RequestUnion_TransferLease); ok {
		return x.TransferLease
	}
	return nil
}

func (m *RequestUnion) GetLeaseInfo() *LeaseInfoRequest {
	if x, ok := m.GetValue().(*RequestUnion_LeaseInfo); ok {
		return x.LeaseInfo
	}
	return nil
}

func (m *RequestUnion) GetWriteBatch() *WriteBatchRequest {
	if x, ok := m.GetValue().(*RequestUnion_WriteBatch); ok {
		return x.WriteBatch
	}
	return nil
}

func (m *RequestUnion) GetExport() *ExportRequest {
	if x, ok := m.GetValue().(*RequestUnion_Export); ok {
		return x.Export
	}
	return nil
}

func (m *RequestUnion) GetImport() *ImportRequest {
	if x, ok := m.GetValue().(*RequestUnion_Import); ok {
		return x.Import
	}
	return nil
}

func (m *RequestUnion) GetQueryTxn() *QueryTxnRequest {
	if x, ok := m.GetValue().(*RequestUnion_QueryTxn); ok {
		return x.QueryTxn
	}
	return nil
}

func (m *RequestUnion) GetQueryIntent() *QueryIntentRequest {
	if x, ok := m.GetValue().(*RequestUnion_QueryIntent); ok {
		return x.QueryIntent
	}
	return nil
}

func (m *RequestUnion) GetAdminScatter() *AdminScatterRequest {
	if x, ok := m.GetValue().(*RequestUnion_AdminScatter); ok {
		return x.AdminScatter
	}
	return nil
}

func (m *RequestUnion) GetAddSstable() *AddSSTableRequest {
	if x, ok := m.GetValue().(*RequestUnion_AddSstable); ok {
		return x.AddSstable
	}
	return nil
}

func (m *RequestUnion) GetRecomputeStats() *RecomputeStatsRequest {
	if x, ok := m.GetValue().(*RequestUnion_RecomputeStats); ok {
		return x.RecomputeStats
	}
	return nil
}

func (m *RequestUnion) GetRefresh() *RefreshRequest {
	if x, ok := m.GetValue().(*RequestUnion_Refresh); ok {
		return x.Refresh
	}
	return nil
}

func (m *RequestUnion) GetRefreshRange() *RefreshRangeRequest {
	if x, ok := m.GetValue().(*RequestUnion_RefreshRange); ok {
		return x.RefreshRange
	}
	return nil
}

func (m *RequestUnion) GetSubsume() *SubsumeRequest {
	if x, ok := m.GetValue().(*RequestUnion_Subsume); ok {
		return x.Subsume
	}
	return nil
}

func (m *RequestUnion) GetRangeStats() *RangeStatsRequest {
	if x, ok := m.GetValue().(*RequestUnion_RangeStats); ok {
		return x.RangeStats
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RequestUnion) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RequestUnion_OneofMarshaler, _RequestUnion_OneofUnmarshaler, _RequestUnion_OneofSizer, []interface{}{
		(*RequestUnion_Get)(nil),
		(*RequestUnion_Put)(nil),
		(*RequestUnion_ConditionalPut)(nil),
		(*RequestUnion_Increment)(nil),
		(*RequestUnion_Delete)(nil),
		(*RequestUnion_DeleteRange)(nil),
		(*RequestUnion_ClearRange)(nil),
		(*RequestUnion_Scan)(nil),
		(*RequestUnion_BeginTransaction)(nil),
		(*RequestUnion_EndTransaction)(nil),
		(*RequestUnion_AdminSplit)(nil),
		(*RequestUnion_AdminMerge)(nil),
		(*RequestUnion_AdminTransferLease)(nil),
		(*RequestUnion_AdminChangeReplicas)(nil),
		(*RequestUnion_AdminRelocateRange)(nil),
		(*RequestUnion_HeartbeatTxn)(nil),
		(*RequestUnion_Gc)(nil),
		(*RequestUnion_PushTxn)(nil),
		(*RequestUnion_ResolveIntent)(nil),
		(*RequestUnion_ResolveIntentRange)(nil),
		(*RequestUnion_Merge)(nil),
		(*RequestUnion_TruncateLog)(nil),
		(*RequestUnion_RequestLease)(nil),
		(*RequestUnion_ReverseScan)(nil),
		(*RequestUnion_ComputeChecksum)(nil),
		(*RequestUnion_CheckConsistency)(nil),
		(*RequestUnion_InitPut)(nil),
		(*RequestUnion_TransferLease)(nil),
		(*RequestUnion_LeaseInfo)(nil),
		(*RequestUnion_WriteBatch)(nil),
		(*RequestUnion_Export)(nil),
		(*RequestUnion_Import)(nil),
		(*RequestUnion_QueryTxn)(nil),
		(*RequestUnion_QueryIntent)(nil),
		(*RequestUnion_AdminScatter)(nil),
		(*RequestUnion_AddSstable)(nil),
		(*RequestUnion_RecomputeStats)(nil),
		(*RequestUnion_Refresh)(nil),
		(*RequestUnion_RefreshRange)(nil),
		(*RequestUnion_Subsume)(nil),
		(*RequestUnion_RangeStats)(nil),
	}
}

func _RequestUnion_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RequestUnion)
	// value
	switch x := m.Value.(type) {
	case *RequestUnion_Get:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Get); err != nil {
			return err
		}
	case *RequestUnion_Put:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Put); err != nil {
			return err
		}
	case *RequestUnion_ConditionalPut:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ConditionalPut); err != nil {
			return err
		}
	case *RequestUnion_Increment:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Increment); err != nil {
			return err
		}
	case *RequestUnion_Delete:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Delete); err != nil {
			return err
		}
	case *RequestUnion_DeleteRange:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DeleteRange); err != nil {
			return err
		}
	case *RequestUnion_ClearRange:
		_ = b.EncodeVarint(38<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ClearRange); err != nil {
			return err
		}
	case *RequestUnion_Scan:
		_ = b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Scan); err != nil {
			return err
		}
	case *RequestUnion_BeginTransaction:
		_ = b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BeginTransaction); err != nil {
			return err
		}
	case *RequestUnion_EndTransaction:
		_ = b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.EndTransaction); err != nil {
			return err
		}
	case *RequestUnion_AdminSplit:
		_ = b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdminSplit); err != nil {
			return err
		}
	case *RequestUnion_AdminMerge:
		_ = b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdminMerge); err != nil {
			return err
		}
	case *RequestUnion_AdminTransferLease:
		_ = b.EncodeVarint(29<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdminTransferLease); err != nil {
			return err
		}
	case *RequestUnion_AdminChangeReplicas:
		_ = b.EncodeVarint(35<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdminChangeReplicas); err != nil {
			return err
		}
	case *RequestUnion_AdminRelocateRange:
		_ = b.EncodeVarint(45<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdminRelocateRange); err != nil {
			return err
		}
	case *RequestUnion_HeartbeatTxn:
		_ = b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HeartbeatTxn); err != nil {
			return err
		}
	case *RequestUnion_Gc:
		_ = b.EncodeVarint(13<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Gc); err != nil {
			return err
		}
	case *RequestUnion_PushTxn:
		_ = b.EncodeVarint(14<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PushTxn); err != nil {
			return err
		}
	case *RequestUnion_ResolveIntent:
		_ = b.EncodeVarint(16<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ResolveIntent); err != nil {
			return err
		}
	case *RequestUnion_ResolveIntentRange:
		_ = b.EncodeVarint(17<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ResolveIntentRange); err != nil {
			return err
		}
	case *RequestUnion_Merge:
		_ = b.EncodeVarint(18<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Merge); err != nil {
			return err
		}
	case *RequestUnion_TruncateLog:
		_ = b.EncodeVarint(19<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TruncateLog); err != nil {
			return err
		}
	case *RequestUnion_RequestLease:
		_ = b.EncodeVarint(20<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RequestLease); err != nil {
			return err
		}
	case *RequestUnion_ReverseScan:
		_ = b.EncodeVarint(21<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ReverseScan); err != nil {
			return err
		}
	case *RequestUnion_ComputeChecksum:
		_ = b.EncodeVarint(22<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ComputeChecksum); err != nil {
			return err
		}
	case *RequestUnion_CheckConsistency:
		_ = b.EncodeVarint(24<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CheckConsistency); err != nil {
			return err
		}
	case *RequestUnion_InitPut:
		_ = b.EncodeVarint(26<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.InitPut); err != nil {
			return err
		}
	case *RequestUnion_TransferLease:
		_ = b.EncodeVarint(28<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TransferLease); err != nil {
			return err
		}
	case *RequestUnion_LeaseInfo:
		_ = b.EncodeVarint(30<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.LeaseInfo); err != nil {
			return err
		}
	case *RequestUnion_WriteBatch:
		_ = b.EncodeVarint(31<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.WriteBatch); err != nil {
			return err
		}
	case *RequestUnion_Export:
		_ = b.EncodeVarint(32<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Export); err != nil {
			return err
		}
	case *RequestUnion_Import:
		_ = b.EncodeVarint(34<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Import); err != nil {
			return err
		}
	case *RequestUnion_QueryTxn:
		_ = b.EncodeVarint(33<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.QueryTxn); err != nil {
			return err
		}
	case *RequestUnion_QueryIntent:
		_ = b.EncodeVarint(42<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.QueryIntent); err != nil {
			return err
		}
	case *RequestUnion_AdminScatter:
		_ = b.EncodeVarint(36<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdminScatter); err != nil {
			return err
		}
	case *RequestUnion_AddSstable:
		_ = b.EncodeVarint(37<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AddSstable); err != nil {
			return err
		}
	case *RequestUnion_RecomputeStats:
		_ = b.EncodeVarint(39<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RecomputeStats); err != nil {
			return err
		}
	case *RequestUnion_Refresh:
		_ = b.EncodeVarint(40<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Refresh); err != nil {
			return err
		}
	case *RequestUnion_RefreshRange:
		_ = b.EncodeVarint(41<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RefreshRange); err != nil {
			return err
		}
	case *RequestUnion_Subsume:
		_ = b.EncodeVarint(43<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Subsume); err != nil {
			return err
		}
	case *RequestUnion_RangeStats:
		_ = b.EncodeVarint(44<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RangeStats); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("RequestUnion.Value has unexpected type %T", x)
	}
	return nil
}

func _RequestUnion_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RequestUnion)
	switch tag {
	case 1: // value.get
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GetRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_Get{msg}
		return true, err
	case 2: // value.put
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PutRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_Put{msg}
		return true, err
	case 3: // value.conditional_put
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ConditionalPutRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_ConditionalPut{msg}
		return true, err
	case 4: // value.increment
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(IncrementRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_Increment{msg}
		return true, err
	case 5: // value.delete
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DeleteRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_Delete{msg}
		return true, err
	case 6: // value.delete_range
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DeleteRangeRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_DeleteRange{msg}
		return true, err
	case 38: // value.clear_range
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ClearRangeRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_ClearRange{msg}
		return true, err
	case 7: // value.scan
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ScanRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_Scan{msg}
		return true, err
	case 8: // value.begin_transaction
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BeginTransactionRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_BeginTransaction{msg}
		return true, err
	case 9: // value.end_transaction
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(EndTransactionRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_EndTransaction{msg}
		return true, err
	case 10: // value.admin_split
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AdminSplitRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_AdminSplit{msg}
		return true, err
	case 11: // value.admin_merge
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AdminMergeRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_AdminMerge{msg}
		return true, err
	case 29: // value.admin_transfer_lease
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AdminTransferLeaseRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_AdminTransferLease{msg}
		return true, err
	case 35: // value.admin_change_replicas
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AdminChangeReplicasRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_AdminChangeReplicas{msg}
		return true, err
	case 45: // value.admin_relocate_range
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AdminRelocateRangeRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_AdminRelocateRange{msg}
		return true, err
	case 12: // value.heartbeat_txn
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HeartbeatTxnRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_HeartbeatTxn{msg}
		return true, err
	case 13: // value.gc
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GCRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_Gc{msg}
		return true, err
	case 14: // value.push_txn
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PushTxnRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_PushTxn{msg}
		return true, err
	case 16: // value.resolve_intent
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ResolveIntentRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_ResolveIntent{msg}
		return true, err
	case 17: // value.resolve_intent_range
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ResolveIntentRangeRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_ResolveIntentRange{msg}
		return true, err
	case 18: // value.merge
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MergeRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_Merge{msg}
		return true, err
	case 19: // value.truncate_log
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TruncateLogRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_TruncateLog{msg}
		return true, err
	case 20: // value.request_lease
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RequestLeaseRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_RequestLease{msg}
		return true, err
	case 21: // value.reverse_scan
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ReverseScanRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_ReverseScan{msg}
		return true, err
	case 22: // value.compute_checksum
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ComputeChecksumRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_ComputeChecksum{msg}
		return true, err
	case 24: // value.check_consistency
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CheckConsistencyRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_CheckConsistency{msg}
		return true, err
	case 26: // value.init_put
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(InitPutRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_InitPut{msg}
		return true, err
	case 28: // value.transfer_lease
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TransferLeaseRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_TransferLease{msg}
		return true, err
	case 30: // value.lease_info
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(LeaseInfoRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_LeaseInfo{msg}
		return true, err
	case 31: // value.write_batch
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(WriteBatchRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_WriteBatch{msg}
		return true, err
	case 32: // value.export
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ExportRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_Export{msg}
		return true, err
	case 34: // value.import
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ImportRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_Import{msg}
		return true, err
	case 33: // value.query_txn
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(QueryTxnRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_QueryTxn{msg}
		return true, err
	case 42: // value.query_intent
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(QueryIntentRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_QueryIntent{msg}
		return true, err
	case 36: // value.admin_scatter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AdminScatterRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_AdminScatter{msg}
		return true, err
	case 37: // value.add_sstable
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AddSSTableRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_AddSstable{msg}
		return true, err
	case 39: // value.recompute_stats
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RecomputeStatsRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_RecomputeStats{msg}
		return true, err
	case 40: // value.refresh
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RefreshRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_Refresh{msg}
		return true, err
	case 41: // value.refresh_range
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RefreshRangeRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_RefreshRange{msg}
		return true, err
	case 43: // value.subsume
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SubsumeRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_Subsume{msg}
		return true, err
	case 44: // value.range_stats
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RangeStatsRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_RangeStats{msg}
		return true, err
	default:
		return false, nil
	}
}

func _RequestUnion_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RequestUnion)
	// value
	switch x := m.Value.(type) {
	case *RequestUnion_Get:
		s := proto.Size(x.Get)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_Put:
		s := proto.Size(x.Put)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_ConditionalPut:
		s := proto.Size(x.ConditionalPut)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_Increment:
		s := proto.Size(x.Increment)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_Delete:
		s := proto.Size(x.Delete)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_DeleteRange:
		s := proto.Size(x.DeleteRange)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_ClearRange:
		s := proto.Size(x.ClearRange)
		n += proto.SizeVarint(38<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_Scan:
		s := proto.Size(x.Scan)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_BeginTransaction:
		s := proto.Size(x.BeginTransaction)
		n += proto.SizeVarint(8<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_EndTransaction:
		s := proto.Size(x.EndTransaction)
		n += proto.SizeVarint(9<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_AdminSplit:
		s := proto.Size(x.AdminSplit)
		n += proto.SizeVarint(10<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_AdminMerge:
		s := proto.Size(x.AdminMerge)
		n += proto.SizeVarint(11<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_AdminTransferLease:
		s := proto.Size(x.AdminTransferLease)
		n += proto.SizeVarint(29<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_AdminChangeReplicas:
		s := proto.Size(x.AdminChangeReplicas)
		n += proto.SizeVarint(35<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_AdminRelocateRange:
		s := proto.Size(x.AdminRelocateRange)
		n += proto.SizeVarint(45<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_HeartbeatTxn:
		s := proto.Size(x.HeartbeatTxn)
		n += proto.SizeVarint(12<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_Gc:
		s := proto.Size(x.Gc)
		n += proto.SizeVarint(13<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_PushTxn:
		s := proto.Size(x.PushTxn)
		n += proto.SizeVarint(14<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_ResolveIntent:
		s := proto.Size(x.ResolveIntent)
		n += proto.SizeVarint(16<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_ResolveIntentRange:
		s := proto.Size(x.ResolveIntentRange)
		n += proto.SizeVarint(17<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_Merge:
		s := proto.Size(x.Merge)
		n += proto.SizeVarint(18<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_TruncateLog:
		s := proto.Size(x.TruncateLog)
		n += proto.SizeVarint(19<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_RequestLease:
		s := proto.Size(x.RequestLease)
		n += proto.SizeVarint(20<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_ReverseScan:
		s := proto.Size(x.ReverseScan)
		n += proto.SizeVarint(21<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_ComputeChecksum:
		s := proto.Size(x.ComputeChecksum)
		n += proto.SizeVarint(22<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_CheckConsistency:
		s := proto.Size(x.CheckConsistency)
		n += proto.SizeVarint(24<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_InitPut:
		s := proto.Size(x.InitPut)
		n += proto.SizeVarint(26<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_TransferLease:
		s := proto.Size(x.TransferLease)
		n += proto.SizeVarint(28<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_LeaseInfo:
		s := proto.Size(x.LeaseInfo)
		n += proto.SizeVarint(30<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_WriteBatch:
		s := proto.Size(x.WriteBatch)
		n += proto.SizeVarint(31<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_Export:
		s := proto.Size(x.Export)
		n += proto.SizeVarint(32<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_Import:
		s := proto.Size(x.Import)
		n += proto.SizeVarint(34<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_QueryTxn:
		s := proto.Size(x.QueryTxn)
		n += proto.SizeVarint(33<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_QueryIntent:
		s := proto.Size(x.QueryIntent)
		n += proto.SizeVarint(42<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_AdminScatter:
		s := proto.Size(x.AdminScatter)
		n += proto.SizeVarint(36<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_AddSstable:
		s := proto.Size(x.AddSstable)
		n += proto.SizeVarint(37<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_RecomputeStats:
		s := proto.Size(x.RecomputeStats)
		n += proto.SizeVarint(39<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_Refresh:
		s := proto.Size(x.Refresh)
		n += proto.SizeVarint(40<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_RefreshRange:
		s := proto.Size(x.RefreshRange)
		n += proto.SizeVarint(41<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_Subsume:
		s := proto.Size(x.Subsume)
		n += proto.SizeVarint(43<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_RangeStats:
		s := proto.Size(x.RangeStats)
		n += proto.SizeVarint(44<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A ResponseUnion contains exactly one of the responses.
// The values added here must match those in RequestUnion.
type ResponseUnion struct {
	// Types that are valid to be assigned to Value:
	//	*ResponseUnion_Get
	//	*ResponseUnion_Put
	//	*ResponseUnion_ConditionalPut
	//	*ResponseUnion_Increment
	//	*ResponseUnion_Delete
	//	*ResponseUnion_DeleteRange
	//	*ResponseUnion_ClearRange
	//	*ResponseUnion_Scan
	//	*ResponseUnion_BeginTransaction
	//	*ResponseUnion_EndTransaction
	//	*ResponseUnion_AdminSplit
	//	*ResponseUnion_AdminMerge
	//	*ResponseUnion_AdminTransferLease
	//	*ResponseUnion_AdminChangeReplicas
	//	*ResponseUnion_AdminRelocateRange
	//	*ResponseUnion_HeartbeatTxn
	//	*ResponseUnion_Gc
	//	*ResponseUnion_PushTxn
	//	*ResponseUnion_ResolveIntent
	//	*ResponseUnion_ResolveIntentRange
	//	*ResponseUnion_Merge
	//	*ResponseUnion_TruncateLog
	//	*ResponseUnion_RequestLease
	//	*ResponseUnion_ReverseScan
	//	*ResponseUnion_ComputeChecksum
	//	*ResponseUnion_CheckConsistency
	//	*ResponseUnion_InitPut
	//	*ResponseUnion_LeaseInfo
	//	*ResponseUnion_WriteBatch
	//	*ResponseUnion_Export
	//	*ResponseUnion_Import
	//	*ResponseUnion_QueryTxn
	//	*ResponseUnion_QueryIntent
	//	*ResponseUnion_AdminScatter
	//	*ResponseUnion_AddSstable
	//	*ResponseUnion_RecomputeStats
	//	*ResponseUnion_Refresh
	//	*ResponseUnion_RefreshRange
	//	*ResponseUnion_Subsume
	//	*ResponseUnion_RangeStats
	Value isResponseUnion_Value `protobuf_oneof:"value"`
}

func (m *ResponseUnion) Reset()                    { *m = ResponseUnion{} }
func (m *ResponseUnion) String() string            { return proto.CompactTextString(m) }
func (*ResponseUnion) ProtoMessage()               {}
func (*ResponseUnion) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{88} }

type isResponseUnion_Value interface {
	isResponseUnion_Value()
	MarshalTo([]byte) (int, error)
	Size() int
}

type ResponseUnion_Get struct {
	Get *GetResponse `protobuf:"bytes,1,opt,name=get,oneof"`
}
type ResponseUnion_Put struct {
	Put *PutResponse `protobuf:"bytes,2,opt,name=put,oneof"`
}
type ResponseUnion_ConditionalPut struct {
	ConditionalPut *ConditionalPutResponse `protobuf:"bytes,3,opt,name=conditional_put,json=conditionalPut,oneof"`
}
type ResponseUnion_Increment struct {
	Increment *IncrementResponse `protobuf:"bytes,4,opt,name=increment,oneof"`
}
type ResponseUnion_Delete struct {
	Delete *DeleteResponse `protobuf:"bytes,5,opt,name=delete,oneof"`
}
type ResponseUnion_DeleteRange struct {
	DeleteRange *DeleteRangeResponse `protobuf:"bytes,6,opt,name=delete_range,json=deleteRange,oneof"`
}
type ResponseUnion_ClearRange struct {
	ClearRange *ClearRangeResponse `protobuf:"bytes,38,opt,name=clear_range,json=clearRange,oneof"`
}
type ResponseUnion_Scan struct {
	Scan *ScanResponse `protobuf:"bytes,7,opt,name=scan,oneof"`
}
type ResponseUnion_BeginTransaction struct {
	BeginTransaction *BeginTransactionResponse `protobuf:"bytes,8,opt,name=begin_transaction,json=beginTransaction,oneof"`
}
type ResponseUnion_EndTransaction struct {
	EndTransaction *EndTransactionResponse `protobuf:"bytes,9,opt,name=end_transaction,json=endTransaction,oneof"`
}
type ResponseUnion_AdminSplit struct {
	AdminSplit *AdminSplitResponse `protobuf:"bytes,10,opt,name=admin_split,json=adminSplit,oneof"`
}
type ResponseUnion_AdminMerge struct {
	AdminMerge *AdminMergeResponse `protobuf:"bytes,11,opt,name=admin_merge,json=adminMerge,oneof"`
}
type ResponseUnion_AdminTransferLease struct {
	AdminTransferLease *AdminTransferLeaseResponse `protobuf:"bytes,29,opt,name=admin_transfer_lease,json=adminTransferLease,oneof"`
}
type ResponseUnion_AdminChangeReplicas struct {
	AdminChangeReplicas *AdminChangeReplicasResponse `protobuf:"bytes,35,opt,name=admin_change_replicas,json=adminChangeReplicas,oneof"`
}
type ResponseUnion_AdminRelocateRange struct {
	AdminRelocateRange *AdminRelocateRangeResponse `protobuf:"bytes,45,opt,name=admin_relocate_range,json=adminRelocateRange,oneof"`
}
type ResponseUnion_HeartbeatTxn struct {
	HeartbeatTxn *HeartbeatTxnResponse `protobuf:"bytes,12,opt,name=heartbeat_txn,json=heartbeatTxn,oneof"`
}
type ResponseUnion_Gc struct {
	Gc *GCResponse `protobuf:"bytes,13,opt,name=gc,oneof"`
}
type ResponseUnion_PushTxn struct {
	PushTxn *PushTxnResponse `protobuf:"bytes,14,opt,name=push_txn,json=pushTxn,oneof"`
}
type ResponseUnion_ResolveIntent struct {
	ResolveIntent *ResolveIntentResponse `protobuf:"bytes,16,opt,name=resolve_intent,json=resolveIntent,oneof"`
}
type ResponseUnion_ResolveIntentRange struct {
	ResolveIntentRange *ResolveIntentRangeResponse `protobuf:"bytes,17,opt,name=resolve_intent_range,json=resolveIntentRange,oneof"`
}
type ResponseUnion_Merge struct {
	Merge *MergeResponse `protobuf:"bytes,18,opt,name=merge,oneof"`
}
type ResponseUnion_TruncateLog struct {
	TruncateLog *TruncateLogResponse `protobuf:"bytes,19,opt,name=truncate_log,json=truncateLog,oneof"`
}
type ResponseUnion_RequestLease struct {
	RequestLease *RequestLeaseResponse `protobuf:"bytes,20,opt,name=request_lease,json=requestLease,oneof"`
}
type ResponseUnion_ReverseScan struct {
	ReverseScan *ReverseScanResponse `protobuf:"bytes,21,opt,name=reverse_scan,json=reverseScan,oneof"`
}
type ResponseUnion_ComputeChecksum struct {
	ComputeChecksum *ComputeChecksumResponse `protobuf:"bytes,22,opt,name=compute_checksum,json=computeChecksum,oneof"`
}
type ResponseUnion_CheckConsistency struct {
	CheckConsistency *CheckConsistencyResponse `protobuf:"bytes,24,opt,name=check_consistency,json=checkConsistency,oneof"`
}
type ResponseUnion_InitPut struct {
	InitPut *InitPutResponse `protobuf:"bytes,26,opt,name=init_put,json=initPut,oneof"`
}
type ResponseUnion_LeaseInfo struct {
	LeaseInfo *LeaseInfoResponse `protobuf:"bytes,30,opt,name=lease_info,json=leaseInfo,oneof"`
}
type ResponseUnion_WriteBatch struct {
	WriteBatch *WriteBatchResponse `protobuf:"bytes,31,opt,name=write_batch,json=writeBatch,oneof"`
}
type ResponseUnion_Export struct {
	Export *ExportResponse `protobuf:"bytes,32,opt,name=export,oneof"`
}
type ResponseUnion_Import struct {
	Import *ImportResponse `protobuf:"bytes,34,opt,name=import,oneof"`
}
type ResponseUnion_QueryTxn struct {
	QueryTxn *QueryTxnResponse `protobuf:"bytes,33,opt,name=query_txn,json=queryTxn,oneof"`
}
type ResponseUnion_QueryIntent struct {
	QueryIntent *QueryIntentResponse `protobuf:"bytes,42,opt,name=query_intent,json=queryIntent,oneof"`
}
type ResponseUnion_AdminScatter struct {
	AdminScatter *AdminScatterResponse `protobuf:"bytes,36,opt,name=admin_scatter,json=adminScatter,oneof"`
}
type ResponseUnion_AddSstable struct {
	AddSstable *AddSSTableResponse `protobuf:"bytes,37,opt,name=add_sstable,json=addSstable,oneof"`
}
type ResponseUnion_RecomputeStats struct {
	RecomputeStats *RecomputeStatsResponse `protobuf:"bytes,39,opt,name=recompute_stats,json=recomputeStats,oneof"`
}
type ResponseUnion_Refresh struct {
	Refresh *RefreshResponse `protobuf:"bytes,40,opt,name=refresh,oneof"`
}
type ResponseUnion_RefreshRange struct {
	RefreshRange *RefreshRangeResponse `protobuf:"bytes,41,opt,name=refresh_range,json=refreshRange,oneof"`
}
type ResponseUnion_Subsume struct {
	Subsume *SubsumeResponse `protobuf:"bytes,43,opt,name=subsume,oneof"`
}
type ResponseUnion_RangeStats struct {
	RangeStats *RangeStatsResponse `protobuf:"bytes,44,opt,name=range_stats,json=rangeStats,oneof"`
}

func (*ResponseUnion_Get) isResponseUnion_Value()                 {}
func (*ResponseUnion_Put) isResponseUnion_Value()                 {}
func (*ResponseUnion_ConditionalPut) isResponseUnion_Value()      {}
func (*ResponseUnion_Increment) isResponseUnion_Value()           {}
func (*ResponseUnion_Delete) isResponseUnion_Value()              {}
func (*ResponseUnion_DeleteRange) isResponseUnion_Value()         {}
func (*ResponseUnion_ClearRange) isResponseUnion_Value()          {}
func (*ResponseUnion_Scan) isResponseUnion_Value()                {}
func (*ResponseUnion_BeginTransaction) isResponseUnion_Value()    {}
func (*ResponseUnion_EndTransaction) isResponseUnion_Value()      {}
func (*ResponseUnion_AdminSplit) isResponseUnion_Value()          {}
func (*ResponseUnion_AdminMerge) isResponseUnion_Value()          {}
func (*ResponseUnion_AdminTransferLease) isResponseUnion_Value()  {}
func (*ResponseUnion_AdminChangeReplicas) isResponseUnion_Value() {}
func (*ResponseUnion_AdminRelocateRange) isResponseUnion_Value()  {}
func (*ResponseUnion_HeartbeatTxn) isResponseUnion_Value()        {}
func (*ResponseUnion_Gc) isResponseUnion_Value()                  {}
func (*ResponseUnion_PushTxn) isResponseUnion_Value()             {}
func (*ResponseUnion_ResolveIntent) isResponseUnion_Value()       {}
func (*ResponseUnion_ResolveIntentRange) isResponseUnion_Value()  {}
func (*ResponseUnion_Merge) isResponseUnion_Value()               {}
func (*ResponseUnion_TruncateLog) isResponseUnion_Value()         {}
func (*ResponseUnion_RequestLease) isResponseUnion_Value()        {}
func (*ResponseUnion_ReverseScan) isResponseUnion_Value()         {}
func (*ResponseUnion_ComputeChecksum) isResponseUnion_Value()     {}
func (*ResponseUnion_CheckConsistency) isResponseUnion_Value()    {}
func (*ResponseUnion_InitPut) isResponseUnion_Value()             {}
func (*ResponseUnion_LeaseInfo) isResponseUnion_Value()           {}
func (*ResponseUnion_WriteBatch) isResponseUnion_Value()          {}
func (*ResponseUnion_Export) isResponseUnion_Value()              {}
func (*ResponseUnion_Import) isResponseUnion_Value()              {}
func (*ResponseUnion_QueryTxn) isResponseUnion_Value()            {}
func (*ResponseUnion_QueryIntent) isResponseUnion_Value()         {}
func (*ResponseUnion_AdminScatter) isResponseUnion_Value()        {}
func (*ResponseUnion_AddSstable) isResponseUnion_Value()          {}
func (*ResponseUnion_RecomputeStats) isResponseUnion_Value()      {}
func (*ResponseUnion_Refresh) isResponseUnion_Value()             {}
func (*ResponseUnion_RefreshRange) isResponseUnion_Value()        {}
func (*ResponseUnion_Subsume) isResponseUnion_Value()             {}
func (*ResponseUnion_RangeStats) isResponseUnion_Value()          {}

func (m *ResponseUnion) GetValue() isResponseUnion_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *ResponseUnion) GetGet() *GetResponse {
	if x, ok := m.GetValue().(*ResponseUnion_Get); ok {
		return x.Get
	}
	return nil
}

func (m *ResponseUnion) GetPut() *PutResponse {
	if x, ok := m.GetValue().(*ResponseUnion_Put); ok {
		return x.Put
	}
	return nil
}

func (m *ResponseUnion) GetConditionalPut() *ConditionalPutResponse {
	if x, ok := m.GetValue().(*ResponseUnion_ConditionalPut); ok {
		return x.ConditionalPut
	}
	return nil
}

func (m *ResponseUnion) GetIncrement() *IncrementResponse {
	if x, ok := m.GetValue().(*ResponseUnion_Increment); ok {
		return x.Increment
	}
	return nil
}

func (m *ResponseUnion) GetDelete() *DeleteResponse {
	if x, ok := m.GetValue().(*ResponseUnion_Delete); ok {
		return x.Delete
	}
	return nil
}

func (m *ResponseUnion) GetDeleteRange() *DeleteRangeResponse {
	if x, ok := m.GetValue().(*ResponseUnion_DeleteRange); ok {
		return x.DeleteRange
	}
	return nil
}

func (m *ResponseUnion) GetClearRange() *ClearRangeResponse {
	if x, ok := m.GetValue().(*ResponseUnion_ClearRange); ok {
		return x.ClearRange
	}
	return nil
}

func (m *ResponseUnion) GetScan() *ScanResponse {
	if x, ok := m.GetValue().(*ResponseUnion_Scan); ok {
		return x.Scan
	}
	return nil
}

func (m *ResponseUnion) GetBeginTransaction() *BeginTransactionResponse {
	if x, ok := m.GetValue().(*ResponseUnion_BeginTransaction); ok {
		return x.BeginTransaction
	}
	return nil
}

func (m *ResponseUnion) GetEndTransaction() *EndTransactionResponse {
	if x, ok := m.GetValue().(*ResponseUnion_EndTransaction); ok {
		return x.EndTransaction
	}
	return nil
}

func (m *ResponseUnion) GetAdminSplit() *AdminSplitResponse {
	if x, ok := m.GetValue().(*ResponseUnion_AdminSplit); ok {
		return x.AdminSplit
	}
	return nil
}

func (m *ResponseUnion) GetAdminMerge() *AdminMergeResponse {
	if x, ok := m.GetValue().(*ResponseUnion_AdminMerge); ok {
		return x.AdminMerge
	}
	return nil
}

func (m *ResponseUnion) GetAdminTransferLease() *AdminTransferLeaseResponse {
	if x, ok := m.GetValue().(*ResponseUnion_AdminTransferLease); ok {
		return x.AdminTransferLease
	}
	return nil
}

func (m *ResponseUnion) GetAdminChangeReplicas() *AdminChangeReplicasResponse {
	if x, ok := m.GetValue().(*ResponseUnion_AdminChangeReplicas); ok {
		return x.AdminChangeReplicas
	}
	return nil
}

func (m *ResponseUnion) GetAdminRelocateRange() *AdminRelocateRangeResponse {
	if x, ok := m.GetValue().(*ResponseUnion_AdminRelocateRange); ok {
		return x.AdminRelocateRange
	}
	return nil
}

func (m *ResponseUnion) GetHeartbeatTxn() *HeartbeatTxnResponse {
	if x, ok := m.GetValue().(*ResponseUnion_HeartbeatTxn); ok {
		return x.HeartbeatTxn
	}
	return nil
}

func (m *ResponseUnion) GetGc() *GCResponse {
	if x, ok := m.GetValue().(*ResponseUnion_Gc); ok {
		return x.Gc
	}
	return nil
}

func (m *ResponseUnion) GetPushTxn() *PushTxnResponse {
	if x, ok := m.GetValue().(*ResponseUnion_PushTxn); ok {
		return x.PushTxn
	}
	return nil
}

func (m *ResponseUnion) GetResolveIntent() *ResolveIntentResponse {
	if x, ok := m.GetValue().(*ResponseUnion_ResolveIntent); ok {
		return x.ResolveIntent
	}
	return nil
}

func (m *ResponseUnion) GetResolveIntentRange() *ResolveIntentRangeResponse {
	if x, ok := m.GetValue().(*ResponseUnion_ResolveIntentRange); ok {
		return x.ResolveIntentRange
	}
	return nil
}

func (m *ResponseUnion) GetMerge() *MergeResponse {
	if x, ok := m.GetValue().(*ResponseUnion_Merge); ok {
		return x.Merge
	}
	return nil
}

func (m *ResponseUnion) GetTruncateLog() *TruncateLogResponse {
	if x, ok := m.GetValue().(*ResponseUnion_TruncateLog); ok {
		return x.TruncateLog
	}
	return nil
}

func (m *ResponseUnion) GetRequestLease() *RequestLeaseResponse {
	if x, ok := m.GetValue().(*ResponseUnion_RequestLease); ok {
		return x.RequestLease
	}
	return nil
}

func (m *ResponseUnion) GetReverseScan() *ReverseScanResponse {
	if x, ok := m.GetValue().(*ResponseUnion_ReverseScan); ok {
		return x.ReverseScan
	}
	return nil
}

func (m *ResponseUnion) GetComputeChecksum() *ComputeChecksumResponse {
	if x, ok := m.GetValue().(*ResponseUnion_ComputeChecksum); ok {
		return x.ComputeChecksum
	}
	return nil
}

func (m *ResponseUnion) GetCheckConsistency() *CheckConsistencyResponse {
	if x, ok := m.GetValue().(*ResponseUnion_CheckConsistency); ok {
		return x.CheckConsistency
	}
	return nil
}

func (m *ResponseUnion) GetInitPut() *InitPutResponse {
	if x, ok := m.GetValue().(*ResponseUnion_InitPut); ok {
		return x.InitPut
	}
	return nil
}

func (m *ResponseUnion) GetLeaseInfo() *LeaseInfoResponse {
	if x, ok := m.GetValue().(*ResponseUnion_LeaseInfo); ok {
		return x.LeaseInfo
	}
	return nil
}

func (m *ResponseUnion) GetWriteBatch() *WriteBatchResponse {
	if x, ok := m.GetValue().(*ResponseUnion_WriteBatch); ok {
		return x.WriteBatch
	}
	return nil
}

func (m *ResponseUnion) GetExport() *ExportResponse {
	if x, ok := m.GetValue().(*ResponseUnion_Export); ok {
		return x.Export
	}
	return nil
}

func (m *ResponseUnion) GetImport() *ImportResponse {
	if x, ok := m.GetValue().(*ResponseUnion_Import); ok {
		return x.Import
	}
	return nil
}

func (m *ResponseUnion) GetQueryTxn() *QueryTxnResponse {
	if x, ok := m.GetValue().(*ResponseUnion_QueryTxn); ok {
		return x.QueryTxn
	}
	return nil
}

func (m *ResponseUnion) GetQueryIntent() *QueryIntentResponse {
	if x, ok := m.GetValue().(*ResponseUnion_QueryIntent); ok {
		return x.QueryIntent
	}
	return nil
}

func (m *ResponseUnion) GetAdminScatter() *AdminScatterResponse {
	if x, ok := m.GetValue().(*ResponseUnion_AdminScatter); ok {
		return x.AdminScatter
	}
	return nil
}

func (m *ResponseUnion) GetAddSstable() *AddSSTableResponse {
	if x, ok := m.GetValue().(*ResponseUnion_AddSstable); ok {
		return x.AddSstable
	}
	return nil
}

func (m *ResponseUnion) GetRecomputeStats() *RecomputeStatsResponse {
	if x, ok := m.GetValue().(*ResponseUnion_RecomputeStats); ok {
		return x.RecomputeStats
	}
	return nil
}

func (m *ResponseUnion) GetRefresh() *RefreshResponse {
	if x, ok := m.GetValue().(*ResponseUnion_Refresh); ok {
		return x.Refresh
	}
	return nil
}

func (m *ResponseUnion) GetRefreshRange() *RefreshRangeResponse {
	if x, ok := m.GetValue().(*ResponseUnion_RefreshRange); ok {
		return x.RefreshRange
	}
	return nil
}

func (m *ResponseUnion) GetSubsume() *SubsumeResponse {
	if x, ok := m.GetValue().(*ResponseUnion_Subsume); ok {
		return x.Subsume
	}
	return nil
}

func (m *ResponseUnion) GetRangeStats() *RangeStatsResponse {
	if x, ok := m.GetValue().(*ResponseUnion_RangeStats); ok {
		return x.RangeStats
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ResponseUnion) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ResponseUnion_OneofMarshaler, _ResponseUnion_OneofUnmarshaler, _ResponseUnion_OneofSizer, []interface{}{
		(*ResponseUnion_Get)(nil),
		(*ResponseUnion_Put)(nil),
		(*ResponseUnion_ConditionalPut)(nil),
		(*ResponseUnion_Increment)(nil),
		(*ResponseUnion_Delete)(nil),
		(*ResponseUnion_DeleteRange)(nil),
		(*ResponseUnion_ClearRange)(nil),
		(*ResponseUnion_Scan)(nil),
		(*ResponseUnion_BeginTransaction)(nil),
		(*ResponseUnion_EndTransaction)(nil),
		(*ResponseUnion_AdminSplit)(nil),
		(*ResponseUnion_AdminMerge)(nil),
		(*ResponseUnion_AdminTransferLease)(nil),
		(*ResponseUnion_AdminChangeReplicas)(nil),
		(*ResponseUnion_AdminRelocateRange)(nil),
		(*ResponseUnion_HeartbeatTxn)(nil),
		(*ResponseUnion_Gc)(nil),
		(*ResponseUnion_PushTxn)(nil),
		(*ResponseUnion_ResolveIntent)(nil),
		(*ResponseUnion_ResolveIntentRange)(nil),
		(*ResponseUnion_Merge)(nil),
		(*ResponseUnion_TruncateLog)(nil),
		(*ResponseUnion_RequestLease)(nil),
		(*ResponseUnion_ReverseScan)(nil),
		(*ResponseUnion_ComputeChecksum)(nil),
		(*ResponseUnion_CheckConsistency)(nil),
		(*ResponseUnion_InitPut)(nil),
		(*ResponseUnion_LeaseInfo)(nil),
		(*ResponseUnion_WriteBatch)(nil),
		(*ResponseUnion_Export)(nil),
		(*ResponseUnion_Import)(nil),
		(*ResponseUnion_QueryTxn)(nil),
		(*ResponseUnion_QueryIntent)(nil),
		(*ResponseUnion_AdminScatter)(nil),
		(*ResponseUnion_AddSstable)(nil),
		(*ResponseUnion_RecomputeStats)(nil),
		(*ResponseUnion_Refresh)(nil),
		(*ResponseUnion_RefreshRange)(nil),
		(*ResponseUnion_Subsume)(nil),
		(*ResponseUnion_RangeStats)(nil),
	}
}

func _ResponseUnion_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ResponseUnion)
	// value
	switch x := m.Value.(type) {
	case *ResponseUnion_Get:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Get); err != nil {
			return err
		}
	case *ResponseUnion_Put:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Put); err != nil {
			return err
		}
	case *ResponseUnion_ConditionalPut:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ConditionalPut); err != nil {
			return err
		}
	case *ResponseUnion_Increment:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Increment); err != nil {
			return err
		}
	case *ResponseUnion_Delete:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Delete); err != nil {
			return err
		}
	case *ResponseUnion_DeleteRange:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DeleteRange); err != nil {
			return err
		}
	case *ResponseUnion_ClearRange:
		_ = b.EncodeVarint(38<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ClearRange); err != nil {
			return err
		}
	case *ResponseUnion_Scan:
		_ = b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Scan); err != nil {
			return err
		}
	case *ResponseUnion_BeginTransaction:
		_ = b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BeginTransaction); err != nil {
			return err
		}
	case *ResponseUnion_EndTransaction:
		_ = b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.EndTransaction); err != nil {
			return err
		}
	case *ResponseUnion_AdminSplit:
		_ = b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdminSplit); err != nil {
			return err
		}
	case *ResponseUnion_AdminMerge:
		_ = b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdminMerge); err != nil {
			return err
		}
	case *ResponseUnion_AdminTransferLease:
		_ = b.EncodeVarint(29<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdminTransferLease); err != nil {
			return err
		}
	case *ResponseUnion_AdminChangeReplicas:
		_ = b.EncodeVarint(35<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdminChangeReplicas); err != nil {
			return err
		}
	case *ResponseUnion_AdminRelocateRange:
		_ = b.EncodeVarint(45<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdminRelocateRange); err != nil {
			return err
		}
	case *ResponseUnion_HeartbeatTxn:
		_ = b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HeartbeatTxn); err != nil {
			return err
		}
	case *ResponseUnion_Gc:
		_ = b.EncodeVarint(13<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Gc); err != nil {
			return err
		}
	case *ResponseUnion_PushTxn:
		_ = b.EncodeVarint(14<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PushTxn); err != nil {
			return err
		}
	case *ResponseUnion_ResolveIntent:
		_ = b.EncodeVarint(16<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ResolveIntent); err != nil {
			return err
		}
	case *ResponseUnion_ResolveIntentRange:
		_ = b.EncodeVarint(17<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ResolveIntentRange); err != nil {
			return err
		}
	case *ResponseUnion_Merge:
		_ = b.EncodeVarint(18<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Merge); err != nil {
			return err
		}
	case *ResponseUnion_TruncateLog:
		_ = b.EncodeVarint(19<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TruncateLog); err != nil {
			return err
		}
	case *ResponseUnion_RequestLease:
		_ = b.EncodeVarint(20<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RequestLease); err != nil {
			return err
		}
	case *ResponseUnion_ReverseScan:
		_ = b.EncodeVarint(21<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ReverseScan); err != nil {
			return err
		}
	case *ResponseUnion_ComputeChecksum:
		_ = b.EncodeVarint(22<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ComputeChecksum); err != nil {
			return err
		}
	case *ResponseUnion_CheckConsistency:
		_ = b.EncodeVarint(24<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CheckConsistency); err != nil {
			return err
		}
	case *ResponseUnion_InitPut:
		_ = b.EncodeVarint(26<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.InitPut); err != nil {
			return err
		}
	case *ResponseUnion_LeaseInfo:
		_ = b.EncodeVarint(30<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.LeaseInfo); err != nil {
			return err
		}
	case *ResponseUnion_WriteBatch:
		_ = b.EncodeVarint(31<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.WriteBatch); err != nil {
			return err
		}
	case *ResponseUnion_Export:
		_ = b.EncodeVarint(32<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Export); err != nil {
			return err
		}
	case *ResponseUnion_Import:
		_ = b.EncodeVarint(34<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Import); err != nil {
			return err
		}
	case *ResponseUnion_QueryTxn:
		_ = b.EncodeVarint(33<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.QueryTxn); err != nil {
			return err
		}
	case *ResponseUnion_QueryIntent:
		_ = b.EncodeVarint(42<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.QueryIntent); err != nil {
			return err
		}
	case *ResponseUnion_AdminScatter:
		_ = b.EncodeVarint(36<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdminScatter); err != nil {
			return err
		}
	case *ResponseUnion_AddSstable:
		_ = b.EncodeVarint(37<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AddSstable); err != nil {
			return err
		}
	case *ResponseUnion_RecomputeStats:
		_ = b.EncodeVarint(39<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RecomputeStats); err != nil {
			return err
		}
	case *ResponseUnion_Refresh:
		_ = b.EncodeVarint(40<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Refresh); err != nil {
			return err
		}
	case *ResponseUnion_RefreshRange:
		_ = b.EncodeVarint(41<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RefreshRange); err != nil {
			return err
		}
	case *ResponseUnion_Subsume:
		_ = b.EncodeVarint(43<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Subsume); err != nil {
			return err
		}
	case *ResponseUnion_RangeStats:
		_ = b.EncodeVarint(44<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RangeStats); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ResponseUnion.Value has unexpected type %T", x)
	}
	return nil
}

func _ResponseUnion_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ResponseUnion)
	switch tag {
	case 1: // value.get
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GetResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_Get{msg}
		return true, err
	case 2: // value.put
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PutResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_Put{msg}
		return true, err
	case 3: // value.conditional_put
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ConditionalPutResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_ConditionalPut{msg}
		return true, err
	case 4: // value.increment
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(IncrementResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_Increment{msg}
		return true, err
	case 5: // value.delete
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DeleteResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_Delete{msg}
		return true, err
	case 6: // value.delete_range
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DeleteRangeResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_DeleteRange{msg}
		return true, err
	case 38: // value.clear_range
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ClearRangeResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_ClearRange{msg}
		return true, err
	case 7: // value.scan
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ScanResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_Scan{msg}
		return true, err
	case 8: // value.begin_transaction
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BeginTransactionResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_BeginTransaction{msg}
		return true, err
	case 9: // value.end_transaction
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(EndTransactionResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_EndTransaction{msg}
		return true, err
	case 10: // value.admin_split
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AdminSplitResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_AdminSplit{msg}
		return true, err
	case 11: // value.admin_merge
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AdminMergeResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_AdminMerge{msg}
		return true, err
	case 29: // value.admin_transfer_lease
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AdminTransferLeaseResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_AdminTransferLease{msg}
		return true, err
	case 35: // value.admin_change_replicas
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AdminChangeReplicasResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_AdminChangeReplicas{msg}
		return true, err
	case 45: // value.admin_relocate_range
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AdminRelocateRangeResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_AdminRelocateRange{msg}
		return true, err
	case 12: // value.heartbeat_txn
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HeartbeatTxnResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_HeartbeatTxn{msg}
		return true, err
	case 13: // value.gc
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GCResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_Gc{msg}
		return true, err
	case 14: // value.push_txn
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PushTxnResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_PushTxn{msg}
		return true, err
	case 16: // value.resolve_intent
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ResolveIntentResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_ResolveIntent{msg}
		return true, err
	case 17: // value.resolve_intent_range
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ResolveIntentRangeResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_ResolveIntentRange{msg}
		return true, err
	case 18: // value.merge
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MergeResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_Merge{msg}
		return true, err
	case 19: // value.truncate_log
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TruncateLogResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_TruncateLog{msg}
		return true, err
	case 20: // value.request_lease
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RequestLeaseResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_RequestLease{msg}
		return true, err
	case 21: // value.reverse_scan
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ReverseScanResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_ReverseScan{msg}
		return true, err
	case 22: // value.compute_checksum
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ComputeChecksumResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_ComputeChecksum{msg}
		return true, err
	case 24: // value.check_consistency
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CheckConsistencyResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_CheckConsistency{msg}
		return true, err
	case 26: // value.init_put
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(InitPutResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_InitPut{msg}
		return true, err
	case 30: // value.lease_info
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(LeaseInfoResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_LeaseInfo{msg}
		return true, err
	case 31: // value.write_batch
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(WriteBatchResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_WriteBatch{msg}
		return true, err
	case 32: // value.export
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ExportResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_Export{msg}
		return true, err
	case 34: // value.import
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ImportResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_Import{msg}
		return true, err
	case 33: // value.query_txn
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(QueryTxnResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_QueryTxn{msg}
		return true, err
	case 42: // value.query_intent
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(QueryIntentResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_QueryIntent{msg}
		return true, err
	case 36: // value.admin_scatter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AdminScatterResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_AdminScatter{msg}
		return true, err
	case 37: // value.add_sstable
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AddSSTableResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_AddSstable{msg}
		return true, err
	case 39: // value.recompute_stats
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RecomputeStatsResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_RecomputeStats{msg}
		return true, err
	case 40: // value.refresh
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RefreshResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_Refresh{msg}
		return true, err
	case 41: // value.refresh_range
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RefreshRangeResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_RefreshRange{msg}
		return true, err
	case 43: // value.subsume
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SubsumeResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_Subsume{msg}
		return true, err
	case 44: // value.range_stats
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RangeStatsResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_RangeStats{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ResponseUnion_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ResponseUnion)
	// value
	switch x := m.Value.(type) {
	case *ResponseUnion_Get:
		s := proto.Size(x.Get)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_Put:
		s := proto.Size(x.Put)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_ConditionalPut:
		s := proto.Size(x.ConditionalPut)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_Increment:
		s := proto.Size(x.Increment)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_Delete:
		s := proto.Size(x.Delete)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_DeleteRange:
		s := proto.Size(x.DeleteRange)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_ClearRange:
		s := proto.Size(x.ClearRange)
		n += proto.SizeVarint(38<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_Scan:
		s := proto.Size(x.Scan)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_BeginTransaction:
		s := proto.Size(x.BeginTransaction)
		n += proto.SizeVarint(8<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_EndTransaction:
		s := proto.Size(x.EndTransaction)
		n += proto.SizeVarint(9<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_AdminSplit:
		s := proto.Size(x.AdminSplit)
		n += proto.SizeVarint(10<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_AdminMerge:
		s := proto.Size(x.AdminMerge)
		n += proto.SizeVarint(11<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_AdminTransferLease:
		s := proto.Size(x.AdminTransferLease)
		n += proto.SizeVarint(29<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_AdminChangeReplicas:
		s := proto.Size(x.AdminChangeReplicas)
		n += proto.SizeVarint(35<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_AdminRelocateRange:
		s := proto.Size(x.AdminRelocateRange)
		n += proto.SizeVarint(45<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_HeartbeatTxn:
		s := proto.Size(x.HeartbeatTxn)
		n += proto.SizeVarint(12<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_Gc:
		s := proto.Size(x.Gc)
		n += proto.SizeVarint(13<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_PushTxn:
		s := proto.Size(x.PushTxn)
		n += proto.SizeVarint(14<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_ResolveIntent:
		s := proto.Size(x.ResolveIntent)
		n += proto.SizeVarint(16<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_ResolveIntentRange:
		s := proto.Size(x.ResolveIntentRange)
		n += proto.SizeVarint(17<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_Merge:
		s := proto.Size(x.Merge)
		n += proto.SizeVarint(18<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_TruncateLog:
		s := proto.Size(x.TruncateLog)
		n += proto.SizeVarint(19<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_RequestLease:
		s := proto.Size(x.RequestLease)
		n += proto.SizeVarint(20<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_ReverseScan:
		s := proto.Size(x.ReverseScan)
		n += proto.SizeVarint(21<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_ComputeChecksum:
		s := proto.Size(x.ComputeChecksum)
		n += proto.SizeVarint(22<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_CheckConsistency:
		s := proto.Size(x.CheckConsistency)
		n += proto.SizeVarint(24<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_InitPut:
		s := proto.Size(x.InitPut)
		n += proto.SizeVarint(26<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_LeaseInfo:
		s := proto.Size(x.LeaseInfo)
		n += proto.SizeVarint(30<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_WriteBatch:
		s := proto.Size(x.WriteBatch)
		n += proto.SizeVarint(31<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_Export:
		s := proto.Size(x.Export)
		n += proto.SizeVarint(32<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_Import:
		s := proto.Size(x.Import)
		n += proto.SizeVarint(34<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_QueryTxn:
		s := proto.Size(x.QueryTxn)
		n += proto.SizeVarint(33<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_QueryIntent:
		s := proto.Size(x.QueryIntent)
		n += proto.SizeVarint(42<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_AdminScatter:
		s := proto.Size(x.AdminScatter)
		n += proto.SizeVarint(36<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_AddSstable:
		s := proto.Size(x.AddSstable)
		n += proto.SizeVarint(37<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_RecomputeStats:
		s := proto.Size(x.RecomputeStats)
		n += proto.SizeVarint(39<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_Refresh:
		s := proto.Size(x.Refresh)
		n += proto.SizeVarint(40<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_RefreshRange:
		s := proto.Size(x.RefreshRange)
		n += proto.SizeVarint(41<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_Subsume:
		s := proto.Size(x.Subsume)
		n += proto.SizeVarint(43<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_RangeStats:
		s := proto.Size(x.RangeStats)
		n += proto.SizeVarint(44<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A Header is attached to a BatchRequest, encapsulating routing and auxiliary
// information required for executing it.
type Header struct {
	// timestamp specifies time at which read or writes should be
	// performed. If the timestamp is set to zero value, its value
	// is initialized to the wall time of the receiving node.
	Timestamp cockroach_util_hlc.Timestamp `protobuf:"bytes,1,opt,name=timestamp" json:"timestamp"`
	// replica specifies the destination of the request.
	Replica ReplicaDescriptor `protobuf:"bytes,2,opt,name=replica" json:"replica"`
	// range_id specifies the ID of the Raft consensus group which the key
	// range belongs to. This is used by the receiving node to route the
	// request to the correct range.
	RangeID RangeID `protobuf:"varint,3,opt,name=range_id,json=rangeId,proto3,casttype=RangeID" json:"range_id,omitempty"`
	// user_priority allows any command's priority to be biased from the
	// default random priority. It specifies a multiple. If set to 0.5,
	// the chosen priority will be 1/2x as likely to beat any default
	// random priority. If set to 1, a default random priority is
	// chosen. If set to 2, the chosen priority will be 2x as likely to
	// beat any default random priority, and so on. As a special case, 0
	// priority is treated the same as 1. This value is ignored if txn
	// is specified. The min and max user priorities are set via
	// MinUserPriority and MaxUserPriority in data.go.
	UserPriority UserPriority `protobuf:"fixed64,4,opt,name=user_priority,json=userPriority,proto3,casttype=UserPriority" json:"user_priority,omitempty"`
	// txn is set non-nil if a transaction is underway. To start a txn,
	// the first request should set this field to non-nil with name and
	// isolation level set as desired. The response will contain the
	// fully-initialized transaction with txn ID, priority, initial
	// timestamp, and maximum timestamp.
	Txn *Transaction `protobuf:"bytes,5,opt,name=txn" json:"txn,omitempty"`
	// read_consistency specifies the consistency for read
	// operations. The default is CONSISTENT. This value is ignored for
	// write operations.
	ReadConsistency ReadConsistencyType `protobuf:"varint,6,opt,name=read_consistency,json=readConsistency,proto3,enum=cockroach.roachpb.ReadConsistencyType" json:"read_consistency,omitempty"`
	// If set to a non-zero value, it limits the total number of keys touched
	// by span requests in the batch. Span requests are requests like
	// Scan, ReverseScan, and DelRange. If two requests touch the
	// same key it is double counted.
	//
	// If a batch limit is used with Scan requests, the spans for the requests
	// must be non-overlapping and in increasing order.
	//
	// If a batch limit is used with ReverseScan requests, the spans for the
	// requests must be non-overlapping and in decreasing order.
	MaxSpanRequestKeys int64 `protobuf:"varint,8,opt,name=max_span_request_keys,json=maxSpanRequestKeys,proto3" json:"max_span_request_keys,omitempty"`
	// If set, all of the spans in the batch are distinct. Note that the
	// calculation of distinct spans does not include intents in an
	// EndTransactionRequest. Currently set conservatively: a request
	// might be composed of distinct spans yet have this field set to
	// false.
	DistinctSpans bool `protobuf:"varint,9,opt,name=distinct_spans,json=distinctSpans,proto3" json:"distinct_spans,omitempty"`
	// If set, return_range_info causes RangeInfo details to be returned with
	// each ResponseHeader.
	ReturnRangeInfo bool `protobuf:"varint,10,opt,name=return_range_info,json=returnRangeInfo,proto3" json:"return_range_info,omitempty"`
	// gateway_node_id is the ID of the gateway node where the request originated.
	GatewayNodeID NodeID       `protobuf:"varint,11,opt,name=gateway_node_id,json=gatewayNodeId,proto3,casttype=NodeID" json:"gateway_node_id,omitempty"`
	ScanOptions   *ScanOptions `protobuf:"bytes,12,opt,name=scan_options,json=scanOptions" json:"scan_options,omitempty"`
	// If set, the request will return to the client before proposing the
	// request into Raft. All consensus processing will be performed
	// asynchronously. Because consensus may fail, this means that the
	// request cannot be expected to succeed. Instead, its success must
	// be verified.
	// TODO(nvanbenschoten): Handling cases where consensus fails would
	// be much more straightforward if all transactional requests were
	// idempotent. We could just re-issue requests. See #26915.
	AsyncConsensus bool `protobuf:"varint,13,opt,name=async_consensus,json=asyncConsensus,proto3" json:"async_consensus,omitempty"`
}

func (m *Header) Reset()                    { *m = Header{} }
func (m *Header) String() string            { return proto.CompactTextString(m) }
func (*Header) ProtoMessage()               {}
func (*Header) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{89} }

// A BatchRequest contains one or more requests to be executed in
// parallel, or if applicable (based on write-only commands and
// range-locality), as a single update.
type BatchRequest struct {
	Header   `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Requests []RequestUnion `protobuf:"bytes,2,rep,name=requests" json:"requests"`
}

func (m *BatchRequest) Reset()                    { *m = BatchRequest{} }
func (*BatchRequest) ProtoMessage()               {}
func (*BatchRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{90} }

// A BatchResponse contains one or more responses, one per request
// corresponding to the requests in the matching BatchRequest. The
// error in the response header is set to the first error from the
// slice of responses, if applicable.
type BatchResponse struct {
	BatchResponse_Header `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Responses            []ResponseUnion `protobuf:"bytes,2,rep,name=responses" json:"responses"`
}

func (m *BatchResponse) Reset()                    { *m = BatchResponse{} }
func (*BatchResponse) ProtoMessage()               {}
func (*BatchResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{91} }

type BatchResponse_Header struct {
	// error communicates a structured error (i.e. one originating from a Node)
	// while the BatchResponse is sent over the network. If the code were
	// written today, the RPC endpoint would return a message containing both a
	// BatchResponse and an Error, and this embedding would go away. However, it
	// returns only a BatchResponse, and so the Error needs to be tucked away
	// somewhere (the structured error cannot be communicated via an RPC-level
	// error).
	//
	// Outside of the RPC boundaries, this field is nil and must neither be
	// checked nor populated (it is reset by the DistSender, which extracts this
	// error and returns it separately). In effect, nearly no usage of
	// BatchResponse needs to care about this field.
	Error *Error `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	// timestamp is set only for non-transactional responses and denotes the
	// timestamp at which the batch executed. The timestamp cache is updated
	// at this timestamp.
	Timestamp cockroach_util_hlc.Timestamp `protobuf:"bytes,2,opt,name=Timestamp" json:"Timestamp"`
	// txn is non-nil if the request specified a non-nil
	// transaction. The transaction timestamp and/or priority may have
	// been updated, depending on the outcome of the request.
	Txn *Transaction `protobuf:"bytes,3,opt,name=txn" json:"txn,omitempty"`
	// now is the highest current time from any node contacted during the request.
	// It can be used by the receiver to update its local HLC.
	Now cockroach_util_hlc.Timestamp `protobuf:"bytes,5,opt,name=now" json:"now"`
	// collected_spans stores trace spans recorded during the execution of this
	// request.
	CollectedSpans []cockroach_util_tracing.RecordedSpan `protobuf:"bytes,6,rep,name=collected_spans,json=collectedSpans" json:"collected_spans"`
}

func (m *BatchResponse_Header) Reset()                    { *m = BatchResponse_Header{} }
func (m *BatchResponse_Header) String() string            { return proto.CompactTextString(m) }
func (*BatchResponse_Header) ProtoMessage()               {}
func (*BatchResponse_Header) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{91, 0} }

// RangeFeedRequest is a request that expresses the intention to establish a
// RangeFeed stream over the provided span, starting at the specified timestamp.
type RangeFeedRequest struct {
	Header `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Span   Span `protobuf:"bytes,2,opt,name=span" json:"span"`
}

func (m *RangeFeedRequest) Reset()                    { *m = RangeFeedRequest{} }
func (m *RangeFeedRequest) String() string            { return proto.CompactTextString(m) }
func (*RangeFeedRequest) ProtoMessage()               {}
func (*RangeFeedRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{92} }

// RangeFeedValue is a variant of RangeFeedEvent that represents an update to
// the specified key with the provided value.
type RangeFeedValue struct {
	Key   Key   `protobuf:"bytes,1,opt,name=key,proto3,casttype=Key" json:"key,omitempty"`
	Value Value `protobuf:"bytes,2,opt,name=value" json:"value"`
}

func (m *RangeFeedValue) Reset()                    { *m = RangeFeedValue{} }
func (m *RangeFeedValue) String() string            { return proto.CompactTextString(m) }
func (*RangeFeedValue) ProtoMessage()               {}
func (*RangeFeedValue) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{93} }

// RangeFeedCheckpoint is a variant of RangeFeedEvent that represents the
// promise that no more RangeFeedValue events with keys in the specified span
// with timestamps less than or equal to the specified resolved timestamp will
// be emitted on the RangeFeed response stream.
type RangeFeedCheckpoint struct {
	Span       Span                         `protobuf:"bytes,1,opt,name=span" json:"span"`
	ResolvedTS cockroach_util_hlc.Timestamp `protobuf:"bytes,2,opt,name=resolved_ts,json=resolvedTs" json:"resolved_ts"`
}

func (m *RangeFeedCheckpoint) Reset()                    { *m = RangeFeedCheckpoint{} }
func (m *RangeFeedCheckpoint) String() string            { return proto.CompactTextString(m) }
func (*RangeFeedCheckpoint) ProtoMessage()               {}
func (*RangeFeedCheckpoint) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{94} }

// RangeFeedError is a variant of RangeFeedEvent that indicates that an error
// occurred during the processing of the RangeFeed. If emitted, a RangeFeedError
// event will always be the final event on a RangeFeed response stream before
// it is torn down.
type RangeFeedError struct {
	Error Error `protobuf:"bytes,1,opt,name=error" json:"error"`
}

func (m *RangeFeedError) Reset()                    { *m = RangeFeedError{} }
func (m *RangeFeedError) String() string            { return proto.CompactTextString(m) }
func (*RangeFeedError) ProtoMessage()               {}
func (*RangeFeedError) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{95} }

// RangeFeedEvent is a union of all event types that may be returned on a
// RangeFeed response stream.
type RangeFeedEvent struct {
	Val        *RangeFeedValue      `protobuf:"bytes,1,opt,name=val" json:"val,omitempty"`
	Checkpoint *RangeFeedCheckpoint `protobuf:"bytes,2,opt,name=checkpoint" json:"checkpoint,omitempty"`
	Error      *RangeFeedError      `protobuf:"bytes,3,opt,name=error" json:"error,omitempty"`
}

func (m *RangeFeedEvent) Reset()                    { *m = RangeFeedEvent{} }
func (m *RangeFeedEvent) String() string            { return proto.CompactTextString(m) }
func (*RangeFeedEvent) ProtoMessage()               {}
func (*RangeFeedEvent) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{96} }

func init() {
	proto.RegisterType((*RangeInfo)(nil), "cockroach.roachpb.RangeInfo")
	proto.RegisterType((*RequestHeader)(nil), "cockroach.roachpb.RequestHeader")
	proto.RegisterType((*ResponseHeader)(nil), "cockroach.roachpb.ResponseHeader")
	proto.RegisterType((*GetRequest)(nil), "cockroach.roachpb.GetRequest")
	proto.RegisterType((*GetResponse)(nil), "cockroach.roachpb.GetResponse")
	proto.RegisterType((*PutRequest)(nil), "cockroach.roachpb.PutRequest")
	proto.RegisterType((*PutResponse)(nil), "cockroach.roachpb.PutResponse")
	proto.RegisterType((*ConditionalPutRequest)(nil), "cockroach.roachpb.ConditionalPutRequest")
	proto.RegisterType((*ConditionalPutResponse)(nil), "cockroach.roachpb.ConditionalPutResponse")
	proto.RegisterType((*InitPutRequest)(nil), "cockroach.roachpb.InitPutRequest")
	proto.RegisterType((*InitPutResponse)(nil), "cockroach.roachpb.InitPutResponse")
	proto.RegisterType((*IncrementRequest)(nil), "cockroach.roachpb.IncrementRequest")
	proto.RegisterType((*IncrementResponse)(nil), "cockroach.roachpb.IncrementResponse")
	proto.RegisterType((*DeleteRequest)(nil), "cockroach.roachpb.DeleteRequest")
	proto.RegisterType((*DeleteResponse)(nil), "cockroach.roachpb.DeleteResponse")
	proto.RegisterType((*DeleteRangeRequest)(nil), "cockroach.roachpb.DeleteRangeRequest")
	proto.RegisterType((*DeleteRangeResponse)(nil), "cockroach.roachpb.DeleteRangeResponse")
	proto.RegisterType((*ClearRangeRequest)(nil), "cockroach.roachpb.ClearRangeRequest")
	proto.RegisterType((*ClearRangeResponse)(nil), "cockroach.roachpb.ClearRangeResponse")
	proto.RegisterType((*ScanOptions)(nil), "cockroach.roachpb.ScanOptions")
	proto.RegisterType((*ScanRequest)(nil), "cockroach.roachpb.ScanRequest")
	proto.RegisterType((*ScanResponse)(nil), "cockroach.roachpb.ScanResponse")
	proto.RegisterType((*ReverseScanRequest)(nil), "cockroach.roachpb.ReverseScanRequest")
	proto.RegisterType((*ReverseScanResponse)(nil), "cockroach.roachpb.ReverseScanResponse")
	proto.RegisterType((*CheckConsistencyRequest)(nil), "cockroach.roachpb.CheckConsistencyRequest")
	proto.RegisterType((*CheckConsistencyResponse)(nil), "cockroach.roachpb.CheckConsistencyResponse")
	proto.RegisterType((*RecomputeStatsRequest)(nil), "cockroach.roachpb.RecomputeStatsRequest")
	proto.RegisterType((*RecomputeStatsResponse)(nil), "cockroach.roachpb.RecomputeStatsResponse")
	proto.RegisterType((*BeginTransactionRequest)(nil), "cockroach.roachpb.BeginTransactionRequest")
	proto.RegisterType((*BeginTransactionResponse)(nil), "cockroach.roachpb.BeginTransactionResponse")
	proto.RegisterType((*EndTransactionRequest)(nil), "cockroach.roachpb.EndTransactionRequest")
	proto.RegisterType((*EndTransactionResponse)(nil), "cockroach.roachpb.EndTransactionResponse")
	proto.RegisterType((*AdminSplitRequest)(nil), "cockroach.roachpb.AdminSplitRequest")
	proto.RegisterType((*AdminSplitResponse)(nil), "cockroach.roachpb.AdminSplitResponse")
	proto.RegisterType((*AdminMergeRequest)(nil), "cockroach.roachpb.AdminMergeRequest")
	proto.RegisterType((*AdminMergeResponse)(nil), "cockroach.roachpb.AdminMergeResponse")
	proto.RegisterType((*AdminTransferLeaseRequest)(nil), "cockroach.roachpb.AdminTransferLeaseRequest")
	proto.RegisterType((*AdminTransferLeaseResponse)(nil), "cockroach.roachpb.AdminTransferLeaseResponse")
	proto.RegisterType((*AdminChangeReplicasRequest)(nil), "cockroach.roachpb.AdminChangeReplicasRequest")
	proto.RegisterType((*AdminChangeReplicasResponse)(nil), "cockroach.roachpb.AdminChangeReplicasResponse")
	proto.RegisterType((*AdminRelocateRangeRequest)(nil), "cockroach.roachpb.AdminRelocateRangeRequest")
	proto.RegisterType((*AdminRelocateRangeResponse)(nil), "cockroach.roachpb.AdminRelocateRangeResponse")
	proto.RegisterType((*HeartbeatTxnRequest)(nil), "cockroach.roachpb.HeartbeatTxnRequest")
	proto.RegisterType((*HeartbeatTxnResponse)(nil), "cockroach.roachpb.HeartbeatTxnResponse")
	proto.RegisterType((*GCRequest)(nil), "cockroach.roachpb.GCRequest")
	proto.RegisterType((*GCRequest_GCKey)(nil), "cockroach.roachpb.GCRequest.GCKey")
	proto.RegisterType((*GCResponse)(nil), "cockroach.roachpb.GCResponse")
	proto.RegisterType((*PushTxnRequest)(nil), "cockroach.roachpb.PushTxnRequest")
	proto.RegisterType((*PushTxnResponse)(nil), "cockroach.roachpb.PushTxnResponse")
	proto.RegisterType((*QueryTxnRequest)(nil), "cockroach.roachpb.QueryTxnRequest")
	proto.RegisterType((*QueryTxnResponse)(nil), "cockroach.roachpb.QueryTxnResponse")
	proto.RegisterType((*QueryIntentRequest)(nil), "cockroach.roachpb.QueryIntentRequest")
	proto.RegisterType((*QueryIntentResponse)(nil), "cockroach.roachpb.QueryIntentResponse")
	proto.RegisterType((*ResolveIntentRequest)(nil), "cockroach.roachpb.ResolveIntentRequest")
	proto.RegisterType((*ResolveIntentResponse)(nil), "cockroach.roachpb.ResolveIntentResponse")
	proto.RegisterType((*ResolveIntentRangeRequest)(nil), "cockroach.roachpb.ResolveIntentRangeRequest")
	proto.RegisterType((*ResolveIntentRangeResponse)(nil), "cockroach.roachpb.ResolveIntentRangeResponse")
	proto.RegisterType((*MergeRequest)(nil), "cockroach.roachpb.MergeRequest")
	proto.RegisterType((*MergeResponse)(nil), "cockroach.roachpb.MergeResponse")
	proto.RegisterType((*TruncateLogRequest)(nil), "cockroach.roachpb.TruncateLogRequest")
	proto.RegisterType((*TruncateLogResponse)(nil), "cockroach.roachpb.TruncateLogResponse")
	proto.RegisterType((*RequestLeaseRequest)(nil), "cockroach.roachpb.RequestLeaseRequest")
	proto.RegisterType((*TransferLeaseRequest)(nil), "cockroach.roachpb.TransferLeaseRequest")
	proto.RegisterType((*LeaseInfoRequest)(nil), "cockroach.roachpb.LeaseInfoRequest")
	proto.RegisterType((*LeaseInfoResponse)(nil), "cockroach.roachpb.LeaseInfoResponse")
	proto.RegisterType((*RequestLeaseResponse)(nil), "cockroach.roachpb.RequestLeaseResponse")
	proto.RegisterType((*ComputeChecksumRequest)(nil), "cockroach.roachpb.ComputeChecksumRequest")
	proto.RegisterType((*ComputeChecksumResponse)(nil), "cockroach.roachpb.ComputeChecksumResponse")
	proto.RegisterType((*ExportStorage)(nil), "cockroach.roachpb.ExportStorage")
	proto.RegisterType((*ExportStorage_LocalFilePath)(nil), "cockroach.roachpb.ExportStorage.LocalFilePath")
	proto.RegisterType((*ExportStorage_Http)(nil), "cockroach.roachpb.ExportStorage.Http")
	proto.RegisterType((*ExportStorage_S3)(nil), "cockroach.roachpb.ExportStorage.S3")
	proto.RegisterType((*ExportStorage_GCS)(nil), "cockroach.roachpb.ExportStorage.GCS")
	proto.RegisterType((*ExportStorage_Azure)(nil), "cockroach.roachpb.ExportStorage.Azure")
	proto.RegisterType((*WriteBatchRequest)(nil), "cockroach.roachpb.WriteBatchRequest")
	proto.RegisterType((*WriteBatchResponse)(nil), "cockroach.roachpb.WriteBatchResponse")
	proto.RegisterType((*ExportRequest)(nil), "cockroach.roachpb.ExportRequest")
	proto.RegisterType((*BulkOpSummary)(nil), "cockroach.roachpb.BulkOpSummary")
	proto.RegisterType((*ExportResponse)(nil), "cockroach.roachpb.ExportResponse")
	proto.RegisterType((*ExportResponse_File)(nil), "cockroach.roachpb.ExportResponse.File")
	proto.RegisterType((*ImportRequest)(nil), "cockroach.roachpb.ImportRequest")
	proto.RegisterType((*ImportRequest_File)(nil), "cockroach.roachpb.ImportRequest.File")
	proto.RegisterType((*ImportRequest_TableRekey)(nil), "cockroach.roachpb.ImportRequest.TableRekey")
	proto.RegisterType((*ImportResponse)(nil), "cockroach.roachpb.ImportResponse")
	proto.RegisterType((*AdminScatterRequest)(nil), "cockroach.roachpb.AdminScatterRequest")
	proto.RegisterType((*AdminScatterResponse)(nil), "cockroach.roachpb.AdminScatterResponse")
	proto.RegisterType((*AdminScatterResponse_Range)(nil), "cockroach.roachpb.AdminScatterResponse.Range")
	proto.RegisterType((*AddSSTableRequest)(nil), "cockroach.roachpb.AddSSTableRequest")
	proto.RegisterType((*AddSSTableResponse)(nil), "cockroach.roachpb.AddSSTableResponse")
	proto.RegisterType((*RefreshRequest)(nil), "cockroach.roachpb.RefreshRequest")
	proto.RegisterType((*RefreshResponse)(nil), "cockroach.roachpb.RefreshResponse")
	proto.RegisterType((*RefreshRangeRequest)(nil), "cockroach.roachpb.RefreshRangeRequest")
	proto.RegisterType((*RefreshRangeResponse)(nil), "cockroach.roachpb.RefreshRangeResponse")
	proto.RegisterType((*SubsumeRequest)(nil), "cockroach.roachpb.SubsumeRequest")
	proto.RegisterType((*SubsumeResponse)(nil), "cockroach.roachpb.SubsumeResponse")
	proto.RegisterType((*RangeStatsRequest)(nil), "cockroach.roachpb.RangeStatsRequest")
	proto.RegisterType((*RangeStatsResponse)(nil), "cockroach.roachpb.RangeStatsResponse")
	proto.RegisterType((*RequestUnion)(nil), "cockroach.roachpb.RequestUnion")
	proto.RegisterType((*ResponseUnion)(nil), "cockroach.roachpb.ResponseUnion")
	proto.RegisterType((*Header)(nil), "cockroach.roachpb.Header")
	proto.RegisterType((*BatchRequest)(nil), "cockroach.roachpb.BatchRequest")
	proto.RegisterType((*BatchResponse)(nil), "cockroach.roachpb.BatchResponse")
	proto.RegisterType((*BatchResponse_Header)(nil), "cockroach.roachpb.BatchResponse.Header")
	proto.RegisterType((*RangeFeedRequest)(nil), "cockroach.roachpb.RangeFeedRequest")
	proto.RegisterType((*RangeFeedValue)(nil), "cockroach.roachpb.RangeFeedValue")
	proto.RegisterType((*RangeFeedCheckpoint)(nil), "cockroach.roachpb.RangeFeedCheckpoint")
	proto.RegisterType((*RangeFeedError)(nil), "cockroach.roachpb.RangeFeedError")
	proto.RegisterType((*RangeFeedEvent)(nil), "cockroach.roachpb.RangeFeedEvent")
	proto.RegisterEnum("cockroach.roachpb.ReadConsistencyType", ReadConsistencyType_name, ReadConsistencyType_value)
	proto.RegisterEnum("cockroach.roachpb.ScanFormat", ScanFormat_name, ScanFormat_value)
	proto.RegisterEnum("cockroach.roachpb.PushTxnType", PushTxnType_name, PushTxnType_value)
	proto.RegisterEnum("cockroach.roachpb.ExportStorageProvider", ExportStorageProvider_name, ExportStorageProvider_value)
	proto.RegisterEnum("cockroach.roachpb.MVCCFilter", MVCCFilter_name, MVCCFilter_value)
	proto.RegisterEnum("cockroach.roachpb.ResponseHeader_ResumeReason", ResponseHeader_ResumeReason_name, ResponseHeader_ResumeReason_value)
	proto.RegisterEnum("cockroach.roachpb.QueryIntentRequest_IfMissingBehavior", QueryIntentRequest_IfMissingBehavior_name, QueryIntentRequest_IfMissingBehavior_value)
}
func (this *RequestHeader) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RequestHeader)
	if !ok {
		that2, ok := that.(RequestHeader)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.Key, that1.Key) {
		return false
	}
	if !bytes.Equal(this.EndKey, that1.EndKey) {
		return false
	}
	if this.Sequence != that1.Sequence {
		return false
	}
	return true
}
func (this *GetRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetRequest)
	if !ok {
		that2, ok := that.(GetRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	return true
}
func (this *PutRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PutRequest)
	if !ok {
		that2, ok := that.(PutRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !this.Value.Equal(&that1.Value) {
		return false
	}
	if this.Inline != that1.Inline {
		return false
	}
	if this.Blind != that1.Blind {
		return false
	}
	return true
}
func (this *ConditionalPutRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ConditionalPutRequest)
	if !ok {
		that2, ok := that.(ConditionalPutRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !this.Value.Equal(&that1.Value) {
		return false
	}
	if !this.ExpValue.Equal(that1.ExpValue) {
		return false
	}
	if this.Blind != that1.Blind {
		return false
	}
	return true
}
func (this *InitPutRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*InitPutRequest)
	if !ok {
		that2, ok := that.(InitPutRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !this.Value.Equal(&that1.Value) {
		return false
	}
	if this.Blind != that1.Blind {
		return false
	}
	if this.FailOnTombstones != that1.FailOnTombstones {
		return false
	}
	return true
}
func (this *IncrementRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*IncrementRequest)
	if !ok {
		that2, ok := that.(IncrementRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if this.Increment != that1.Increment {
		return false
	}
	return true
}
func (this *DeleteRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DeleteRequest)
	if !ok {
		that2, ok := that.(DeleteRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	return true
}
func (this *DeleteRangeRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DeleteRangeRequest)
	if !ok {
		that2, ok := that.(DeleteRangeRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if this.ReturnKeys != that1.ReturnKeys {
		return false
	}
	if this.Inline != that1.Inline {
		return false
	}
	return true
}
func (this *ClearRangeRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ClearRangeRequest)
	if !ok {
		that2, ok := that.(ClearRangeRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	return true
}
func (this *ScanOptions) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ScanOptions)
	if !ok {
		that2, ok := that.(ScanOptions)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.StopAtRangeBoundary != that1.StopAtRangeBoundary {
		return false
	}
	if this.MinResults != that1.MinResults {
		return false
	}
	return true
}
func (this *ScanRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ScanRequest)
	if !ok {
		that2, ok := that.(ScanRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if this.ScanFormat != that1.ScanFormat {
		return false
	}
	return true
}
func (this *ReverseScanRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReverseScanRequest)
	if !ok {
		that2, ok := that.(ReverseScanRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if this.ScanFormat != that1.ScanFormat {
		return false
	}
	return true
}
func (this *CheckConsistencyRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CheckConsistencyRequest)
	if !ok {
		that2, ok := that.(CheckConsistencyRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if this.WithDiff != that1.WithDiff {
		return false
	}
	return true
}
func (this *RecomputeStatsRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RecomputeStatsRequest)
	if !ok {
		that2, ok := that.(RecomputeStatsRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if this.DryRun != that1.DryRun {
		return false
	}
	return true
}
func (this *BeginTransactionRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*BeginTransactionRequest)
	if !ok {
		that2, ok := that.(BeginTransactionRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	return true
}
func (this *EndTransactionRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*EndTransactionRequest)
	if !ok {
		that2, ok := that.(EndTransactionRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if this.Commit != that1.Commit {
		return false
	}
	if !this.Deadline.Equal(that1.Deadline) {
		return false
	}
	if !this.InternalCommitTrigger.Equal(that1.InternalCommitTrigger) {
		return false
	}
	if len(this.IntentSpans) != len(that1.IntentSpans) {
		return false
	}
	for i := range this.IntentSpans {
		if !this.IntentSpans[i].Equal(&that1.IntentSpans[i]) {
			return false
		}
	}
	if this.Require1PC != that1.Require1PC {
		return false
	}
	if this.NoRefreshSpans != that1.NoRefreshSpans {
		return false
	}
	if this.Poison != that1.Poison {
		return false
	}
	return true
}
func (this *AdminSplitRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AdminSplitRequest)
	if !ok {
		that2, ok := that.(AdminSplitRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !bytes.Equal(this.SplitKey, that1.SplitKey) {
		return false
	}
	return true
}
func (this *AdminMergeRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AdminMergeRequest)
	if !ok {
		that2, ok := that.(AdminMergeRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	return true
}
func (this *AdminTransferLeaseRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AdminTransferLeaseRequest)
	if !ok {
		that2, ok := that.(AdminTransferLeaseRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if this.Target != that1.Target {
		return false
	}
	return true
}
func (this *AdminChangeReplicasRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AdminChangeReplicasRequest)
	if !ok {
		that2, ok := that.(AdminChangeReplicasRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if this.ChangeType != that1.ChangeType {
		return false
	}
	if len(this.Targets) != len(that1.Targets) {
		return false
	}
	for i := range this.Targets {
		if !this.Targets[i].Equal(&that1.Targets[i]) {
			return false
		}
	}
	return true
}
func (this *AdminRelocateRangeRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AdminRelocateRangeRequest)
	if !ok {
		that2, ok := that.(AdminRelocateRangeRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if len(this.Targets) != len(that1.Targets) {
		return false
	}
	for i := range this.Targets {
		if !this.Targets[i].Equal(&that1.Targets[i]) {
			return false
		}
	}
	return true
}
func (this *HeartbeatTxnRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HeartbeatTxnRequest)
	if !ok {
		that2, ok := that.(HeartbeatTxnRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !this.Now.Equal(&that1.Now) {
		return false
	}
	return true
}
func (this *GCRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GCRequest)
	if !ok {
		that2, ok := that.(GCRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if len(this.Keys) != len(that1.Keys) {
		return false
	}
	for i := range this.Keys {
		if !this.Keys[i].Equal(&that1.Keys[i]) {
			return false
		}
	}
	if !this.Threshold.Equal(&that1.Threshold) {
		return false
	}
	if !this.TxnSpanGCThreshold.Equal(&that1.TxnSpanGCThreshold) {
		return false
	}
	return true
}
func (this *GCRequest_GCKey) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GCRequest_GCKey)
	if !ok {
		that2, ok := that.(GCRequest_GCKey)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.Key, that1.Key) {
		return false
	}
	if !this.Timestamp.Equal(&that1.Timestamp) {
		return false
	}
	return true
}
func (this *PushTxnRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PushTxnRequest)
	if !ok {
		that2, ok := that.(PushTxnRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !this.PusherTxn.Equal(&that1.PusherTxn) {
		return false
	}
	if !this.PusheeTxn.Equal(&that1.PusheeTxn) {
		return false
	}
	if !this.PushTo.Equal(&that1.PushTo) {
		return false
	}
	if !this.Now.Equal(&that1.Now) {
		return false
	}
	if this.PushType != that1.PushType {
		return false
	}
	if this.Force != that1.Force {
		return false
	}
	return true
}
func (this *QueryTxnRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryTxnRequest)
	if !ok {
		that2, ok := that.(QueryTxnRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !this.Txn.Equal(&that1.Txn) {
		return false
	}
	if this.WaitForUpdate != that1.WaitForUpdate {
		return false
	}
	if len(this.KnownWaitingTxns) != len(that1.KnownWaitingTxns) {
		return false
	}
	for i := range this.KnownWaitingTxns {
		if !this.KnownWaitingTxns[i].Equal(that1.KnownWaitingTxns[i]) {
			return false
		}
	}
	return true
}
func (this *QueryIntentRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryIntentRequest)
	if !ok {
		that2, ok := that.(QueryIntentRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !this.Txn.Equal(&that1.Txn) {
		return false
	}
	if this.IfMissing != that1.IfMissing {
		return false
	}
	return true
}
func (this *ResolveIntentRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ResolveIntentRequest)
	if !ok {
		that2, ok := that.(ResolveIntentRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !this.IntentTxn.Equal(&that1.IntentTxn) {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	if this.Poison != that1.Poison {
		return false
	}
	return true
}
func (this *ResolveIntentRangeRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ResolveIntentRangeRequest)
	if !ok {
		that2, ok := that.(ResolveIntentRangeRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !this.IntentTxn.Equal(&that1.IntentTxn) {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	if this.Poison != that1.Poison {
		return false
	}
	if !this.MinTimestamp.Equal(&that1.MinTimestamp) {
		return false
	}
	return true
}
func (this *MergeRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MergeRequest)
	if !ok {
		that2, ok := that.(MergeRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !this.Value.Equal(&that1.Value) {
		return false
	}
	return true
}
func (this *TruncateLogRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TruncateLogRequest)
	if !ok {
		that2, ok := that.(TruncateLogRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if this.Index != that1.Index {
		return false
	}
	if this.RangeID != that1.RangeID {
		return false
	}
	return true
}
func (this *RequestLeaseRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RequestLeaseRequest)
	if !ok {
		that2, ok := that.(RequestLeaseRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !this.Lease.Equal(&that1.Lease) {
		return false
	}
	if !this.PrevLease.Equal(&that1.PrevLease) {
		return false
	}
	if !this.MinProposedTS.Equal(that1.MinProposedTS) {
		return false
	}
	return true
}
func (this *TransferLeaseRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TransferLeaseRequest)
	if !ok {
		that2, ok := that.(TransferLeaseRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !this.Lease.Equal(&that1.Lease) {
		return false
	}
	if !this.PrevLease.Equal(&that1.PrevLease) {
		return false
	}
	return true
}
func (this *LeaseInfoRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LeaseInfoRequest)
	if !ok {
		that2, ok := that.(LeaseInfoRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	return true
}
func (this *ComputeChecksumRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ComputeChecksumRequest)
	if !ok {
		that2, ok := that.(ComputeChecksumRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.Snapshot != that1.Snapshot {
		return false
	}
	return true
}
func (this *ExportStorage) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ExportStorage)
	if !ok {
		that2, ok := that.(ExportStorage)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Provider != that1.Provider {
		return false
	}
	if !this.LocalFile.Equal(&that1.LocalFile) {
		return false
	}
	if !this.HttpPath.Equal(&that1.HttpPath) {
		return false
	}
	if !this.GoogleCloudConfig.Equal(that1.GoogleCloudConfig) {
		return false
	}
	if !this.S3Config.Equal(that1.S3Config) {
		return false
	}
	if !this.AzureConfig.Equal(that1.AzureConfig) {
		return false
	}
	return true
}
func (this *ExportStorage_LocalFilePath) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ExportStorage_LocalFilePath)
	if !ok {
		that2, ok := that.(ExportStorage_LocalFilePath)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	return true
}
func (this *ExportStorage_Http) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ExportStorage_Http)
	if !ok {
		that2, ok := that.(ExportStorage_Http)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.BaseUri != that1.BaseUri {
		return false
	}
	return true
}
func (this *ExportStorage_S3) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ExportStorage_S3)
	if !ok {
		that2, ok := that.(ExportStorage_S3)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Bucket != that1.Bucket {
		return false
	}
	if this.Prefix != that1.Prefix {
		return false
	}
	if this.AccessKey != that1.AccessKey {
		return false
	}
	if this.Secret != that1.Secret {
		return false
	}
	if this.TempToken != that1.TempToken {
		return false
	}
	if this.Endpoint != that1.Endpoint {
		return false
	}
	if this.Region != that1.Region {
		return false
	}
	return true
}
func (this *ExportStorage_GCS) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ExportStorage_GCS)
	if !ok {
		that2, ok := that.(ExportStorage_GCS)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Bucket != that1.Bucket {
		return false
	}
	if this.Prefix != that1.Prefix {
		return false
	}
	if this.Auth != that1.Auth {
		return false
	}
	if this.BillingProject != that1.BillingProject {
		return false
	}
	return true
}
func (this *ExportStorage_Azure) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ExportStorage_Azure)
	if !ok {
		that2, ok := that.(ExportStorage_Azure)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Container != that1.Container {
		return false
	}
	if this.Prefix != that1.Prefix {
		return false
	}
	if this.AccountName != that1.AccountName {
		return false
	}
	if this.AccountKey != that1.AccountKey {
		return false
	}
	return true
}
func (this *WriteBatchRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*WriteBatchRequest)
	if !ok {
		that2, ok := that.(WriteBatchRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !this.DataSpan.Equal(&that1.DataSpan) {
		return false
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return false
	}
	return true
}
func (this *ExportRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ExportRequest)
	if !ok {
		that2, ok := that.(ExportRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !this.Storage.Equal(&that1.Storage) {
		return false
	}
	if !this.StartTime.Equal(&that1.StartTime) {
		return false
	}
	if this.MVCCFilter != that1.MVCCFilter {
		return false
	}
	if this.ReturnSST != that1.ReturnSST {
		return false
	}
	if this.OmitChecksum != that1.OmitChecksum {
		return false
	}
	return true
}
func (this *ImportRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ImportRequest)
	if !ok {
		that2, ok := that.(ImportRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if len(this.Files) != len(that1.Files) {
		return false
	}
	for i := range this.Files {
		if !this.Files[i].Equal(&that1.Files[i]) {
			return false
		}
	}
	if !this.DataSpan.Equal(&that1.DataSpan) {
		return false
	}
	if !this.EndTime.Equal(&that1.EndTime) {
		return false
	}
	if len(this.Rekeys) != len(that1.Rekeys) {
		return false
	}
	for i := range this.Rekeys {
		if !this.Rekeys[i].Equal(&that1.Rekeys[i]) {
			return false
		}
	}
	return true
}
func (this *ImportRequest_File) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ImportRequest_File)
	if !ok {
		that2, ok := that.(ImportRequest_File)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Dir.Equal(&that1.Dir) {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	if !bytes.Equal(this.Sha512, that1.Sha512) {
		return false
	}
	return true
}
func (this *ImportRequest_TableRekey) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ImportRequest_TableRekey)
	if !ok {
		that2, ok := that.(ImportRequest_TableRekey)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.OldID != that1.OldID {
		return false
	}
	if !bytes.Equal(this.NewDesc, that1.NewDesc) {
		return false
	}
	return true
}
func (this *AdminScatterRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AdminScatterRequest)
	if !ok {
		that2, ok := that.(AdminScatterRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if this.RandomizeLeases != that1.RandomizeLeases {
		return false
	}
	return true
}
func (this *AddSSTableRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AddSSTableRequest)
	if !ok {
		that2, ok := that.(AddSSTableRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return false
	}
	return true
}
func (this *RefreshRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RefreshRequest)
	if !ok {
		that2, ok := that.(RefreshRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if this.Write != that1.Write {
		return false
	}
	return true
}
func (this *RefreshRangeRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RefreshRangeRequest)
	if !ok {
		that2, ok := that.(RefreshRangeRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if this.Write != that1.Write {
		return false
	}
	return true
}
func (this *SubsumeRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SubsumeRequest)
	if !ok {
		that2, ok := that.(SubsumeRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !this.LeftRange.Equal(&that1.LeftRange) {
		return false
	}
	return true
}
func (this *RangeStatsRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RangeStatsRequest)
	if !ok {
		that2, ok := that.(RangeStatsRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	return true
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Internal service

type InternalClient interface {
	Batch(ctx context.Context, in *BatchRequest, opts ...grpc.CallOption) (*BatchResponse, error)
	RangeFeed(ctx context.Context, in *RangeFeedRequest, opts ...grpc.CallOption) (Internal_RangeFeedClient, error)
}

type internalClient struct {
	cc *grpc.ClientConn
}

func NewInternalClient(cc *grpc.ClientConn) InternalClient {
	return &internalClient{cc}
}

func (c *internalClient) Batch(ctx context.Context, in *BatchRequest, opts ...grpc.CallOption) (*BatchResponse, error) {
	out := new(BatchResponse)
	err := grpc.Invoke(ctx, "/cockroach.roachpb.Internal/Batch", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *internalClient) RangeFeed(ctx context.Context, in *RangeFeedRequest, opts ...grpc.CallOption) (Internal_RangeFeedClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Internal_serviceDesc.Streams[0], c.cc, "/cockroach.roachpb.Internal/RangeFeed", opts...)
	if err != nil {
		return nil, err
	}
	x := &internalRangeFeedClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Internal_RangeFeedClient interface {
	Recv() (*RangeFeedEvent, error)
	grpc.ClientStream
}

type internalRangeFeedClient struct {
	grpc.ClientStream
}

func (x *internalRangeFeedClient) Recv() (*RangeFeedEvent, error) {
	m := new(RangeFeedEvent)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for Internal service

type InternalServer interface {
	Batch(context.Context, *BatchRequest) (*BatchResponse, error)
	RangeFeed(*RangeFeedRequest, Internal_RangeFeedServer) error
}

func RegisterInternalServer(s *grpc.Server, srv InternalServer) {
	s.RegisterService(&_Internal_serviceDesc, srv)
}

func _Internal_Batch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InternalServer).Batch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.roachpb.Internal/Batch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InternalServer).Batch(ctx, req.(*BatchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Internal_RangeFeed_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(RangeFeedRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(InternalServer).RangeFeed(m, &internalRangeFeedServer{stream})
}

type Internal_RangeFeedServer interface {
	Send(*RangeFeedEvent) error
	grpc.ServerStream
}

type internalRangeFeedServer struct {
	grpc.ServerStream
}

func (x *internalRangeFeedServer) Send(m *RangeFeedEvent) error {
	return x.ServerStream.SendMsg(m)
}

var _Internal_serviceDesc = grpc.ServiceDesc{
	ServiceName: "cockroach.roachpb.Internal",
	HandlerType: (*InternalServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Batch",
			Handler:    _Internal_Batch_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "RangeFeed",
			Handler:       _Internal_RangeFeed_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "roachpb/api.proto",
}

func (m *RangeInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Desc.Size()))
	n1, err := m.Desc.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Lease.Size()))
	n2, err := m.Lease.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	return i, nil
}

func (m *RequestHeader) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestHeader) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	if len(m.EndKey) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.EndKey)))
		i += copy(dAtA[i:], m.EndKey)
	}
	if m.Sequence != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Sequence))
	}
	return i, nil
}

func (m *ResponseHeader) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResponseHeader) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Txn != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Txn.Size()))
		n3, err := m.Txn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.ResumeSpan != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ResumeSpan.Size()))
		n4, err := m.ResumeSpan.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.NumKeys != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.NumKeys))
	}
	if len(m.RangeInfos) > 0 {
		for _, msg := range m.RangeInfos {
			dAtA[i] = 0x32
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.ResumeReason != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ResumeReason))
	}
	return i, nil
}

func (m *GetRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n5, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	return i, nil
}

func (m *GetResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n6, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n6
	if m.Value != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Value.Size()))
		n7, err := m.Value.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.IntentValue != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.IntentValue.Size()))
		n8, err := m.IntentValue.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	return i, nil
}

func (m *PutRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PutRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n9, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n9
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Value.Size()))
	n10, err := m.Value.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n10
	if m.Inline {
		dAtA[i] = 0x18
		i++
		if m.Inline {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Blind {
		dAtA[i] = 0x20
		i++
		if m.Blind {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *PutResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PutResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n11, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n11
	return i, nil
}

func (m *ConditionalPutRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConditionalPutRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n12, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n12
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Value.Size()))
	n13, err := m.Value.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n13
	if m.ExpValue != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ExpValue.Size()))
		n14, err := m.ExpValue.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if m.Blind {
		dAtA[i] = 0x20
		i++
		if m.Blind {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *ConditionalPutResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConditionalPutResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n15, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n15
	return i, nil
}

func (m *InitPutRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InitPutRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n16, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n16
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Value.Size()))
	n17, err := m.Value.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n17
	if m.Blind {
		dAtA[i] = 0x18
		i++
		if m.Blind {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.FailOnTombstones {
		dAtA[i] = 0x20
		i++
		if m.FailOnTombstones {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *InitPutResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InitPutResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n18, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n18
	return i, nil
}

func (m *IncrementRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IncrementRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n19, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n19
	if m.Increment != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Increment))
	}
	return i, nil
}

func (m *IncrementResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IncrementResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n20, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n20
	if m.NewValue != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.NewValue))
	}
	return i, nil
}

func (m *DeleteRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeleteRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n21, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n21
	return i, nil
}

func (m *DeleteResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeleteResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n22, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n22
	return i, nil
}

func (m *DeleteRangeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeleteRangeRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n23, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n23
	if m.ReturnKeys {
		dAtA[i] = 0x18
		i++
		if m.ReturnKeys {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Inline {
		dAtA[i] = 0x20
		i++
		if m.Inline {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *DeleteRangeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeleteRangeResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n24, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n24
	if len(m.Keys) > 0 {
		for _, b := range m.Keys {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApi(dAtA, i, uint64(len(b)))
			i += copy(dAtA[i:], b)
		}
	}
	return i, nil
}

func (m *ClearRangeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClearRangeRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n25, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n25
	return i, nil
}

func (m *ClearRangeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClearRangeResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n26, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n26
	return i, nil
}

func (m *ScanOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScanOptions) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.StopAtRangeBoundary {
		dAtA[i] = 0x8
		i++
		if m.StopAtRangeBoundary {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.MinResults != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.MinResults))
	}
	return i, nil
}

func (m *ScanRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScanRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n27, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n27
	if m.ScanFormat != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ScanFormat))
	}
	return i, nil
}

func (m *ScanResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScanResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n28, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n28
	if len(m.Rows) > 0 {
		for _, msg := range m.Rows {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.IntentRows) > 0 {
		for _, msg := range m.IntentRows {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.BatchResponse) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.BatchResponse)))
		i += copy(dAtA[i:], m.BatchResponse)
	}
	return i, nil
}

func (m *ReverseScanRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReverseScanRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n29, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n29
	if m.ScanFormat != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ScanFormat))
	}
	return i, nil
}

func (m *ReverseScanResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReverseScanResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n30, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n30
	if len(m.Rows) > 0 {
		for _, msg := range m.Rows {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.IntentRows) > 0 {
		for _, msg := range m.IntentRows {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.BatchResponse) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.BatchResponse)))
		i += copy(dAtA[i:], m.BatchResponse)
	}
	return i, nil
}

func (m *CheckConsistencyRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckConsistencyRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n31, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n31
	if m.WithDiff {
		dAtA[i] = 0x10
		i++
		if m.WithDiff {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *CheckConsistencyResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckConsistencyResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n32, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n32
	return i, nil
}

func (m *RecomputeStatsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RecomputeStatsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n33, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n33
	if m.DryRun {
		dAtA[i] = 0x10
		i++
		if m.DryRun {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *RecomputeStatsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RecomputeStatsResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n34, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n34
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.AddedDelta.Size()))
	n35, err := m.AddedDelta.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n35
	return i, nil
}

func (m *BeginTransactionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BeginTransactionRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n36, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n36
	return i, nil
}

func (m *BeginTransactionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BeginTransactionResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n37, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n37
	return i, nil
}

func (m *EndTransactionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EndTransactionRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n38, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n38
	if m.Commit {
		dAtA[i] = 0x10
		i++
		if m.Commit {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Deadline != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Deadline.Size()))
		n39, err := m.Deadline.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n39
	}
	if m.InternalCommitTrigger != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.InternalCommitTrigger.Size()))
		n40, err := m.InternalCommitTrigger.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n40
	}
	if len(m.IntentSpans) > 0 {
		for _, msg := range m.IntentSpans {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Require1PC {
		dAtA[i] = 0x30
		i++
		if m.Require1PC {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.NoRefreshSpans {
		dAtA[i] = 0x40
		i++
		if m.NoRefreshSpans {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Poison {
		dAtA[i] = 0x48
		i++
		if m.Poison {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *EndTransactionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EndTransactionResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n41, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n41
	if m.OnePhaseCommit {
		dAtA[i] = 0x20
		i++
		if m.OnePhaseCommit {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *AdminSplitRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminSplitRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n42, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n42
	if len(m.SplitKey) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.SplitKey)))
		i += copy(dAtA[i:], m.SplitKey)
	}
	return i, nil
}

func (m *AdminSplitResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminSplitResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n43, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n43
	return i, nil
}

func (m *AdminMergeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminMergeRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n44, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n44
	return i, nil
}

func (m *AdminMergeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminMergeResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n45, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n45
	return i, nil
}

func (m *AdminTransferLeaseRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminTransferLeaseRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n46, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n46
	if m.Target != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Target))
	}
	return i, nil
}

func (m *AdminTransferLeaseResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminTransferLeaseResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n47, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n47
	return i, nil
}

func (m *AdminChangeReplicasRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminChangeReplicasRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n48, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n48
	if m.ChangeType != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ChangeType))
	}
	if len(m.Targets) > 0 {
		for _, msg := range m.Targets {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *AdminChangeReplicasResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminChangeReplicasResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n49, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n49
	return i, nil
}

func (m *AdminRelocateRangeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminRelocateRangeRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n50, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n50
	if len(m.Targets) > 0 {
		for _, msg := range m.Targets {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *AdminRelocateRangeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminRelocateRangeResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n51, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n51
	return i, nil
}

func (m *HeartbeatTxnRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HeartbeatTxnRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n52, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n52
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Now.Size()))
	n53, err := m.Now.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n53
	return i, nil
}

func (m *HeartbeatTxnResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HeartbeatTxnResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n54, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n54
	return i, nil
}

func (m *GCRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GCRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n55, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n55
	if len(m.Keys) > 0 {
		for _, msg := range m.Keys {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Threshold.Size()))
	n56, err := m.Threshold.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n56
	dAtA[i] = 0x2a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.TxnSpanGCThreshold.Size()))
	n57, err := m.TxnSpanGCThreshold.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n57
	return i, nil
}

func (m *GCRequest_GCKey) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GCRequest_GCKey) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Timestamp.Size()))
	n58, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n58
	return i, nil
}

func (m *GCResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GCResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n59, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n59
	return i, nil
}

func (m *PushTxnRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PushTxnRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n60, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n60
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.PusherTxn.Size()))
	n61, err := m.PusherTxn.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n61
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.PusheeTxn.Size()))
	n62, err := m.PusheeTxn.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n62
	dAtA[i] = 0x22
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.PushTo.Size()))
	n63, err := m.PushTo.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n63
	dAtA[i] = 0x2a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Now.Size()))
	n64, err := m.Now.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n64
	if m.PushType != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.PushType))
	}
	if m.Force {
		dAtA[i] = 0x38
		i++
		if m.Force {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *PushTxnResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PushTxnResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n65, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n65
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.PusheeTxn.Size()))
	n66, err := m.PusheeTxn.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n66
	return i, nil
}

func (m *QueryTxnRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryTxnRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n67, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n67
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Txn.Size()))
	n68, err := m.Txn.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n68
	if m.WaitForUpdate {
		dAtA[i] = 0x18
		i++
		if m.WaitForUpdate {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.KnownWaitingTxns) > 0 {
		for _, msg := range m.KnownWaitingTxns {
			dAtA[i] = 0x22
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *QueryTxnResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryTxnResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n69, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n69
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.QueriedTxn.Size()))
	n70, err := m.QueriedTxn.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n70
	if len(m.WaitingTxns) > 0 {
		for _, msg := range m.WaitingTxns {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *QueryIntentRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryIntentRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n71, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n71
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Txn.Size()))
	n72, err := m.Txn.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n72
	if m.IfMissing != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.IfMissing))
	}
	return i, nil
}

func (m *QueryIntentResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryIntentResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n73, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n73
	if m.FoundIntent {
		dAtA[i] = 0x10
		i++
		if m.FoundIntent {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *ResolveIntentRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResolveIntentRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n74, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n74
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.IntentTxn.Size()))
	n75, err := m.IntentTxn.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n75
	if m.Status != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Status))
	}
	if m.Poison {
		dAtA[i] = 0x20
		i++
		if m.Poison {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *ResolveIntentResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResolveIntentResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n76, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n76
	return i, nil
}

func (m *ResolveIntentRangeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResolveIntentRangeRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n77, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n77
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.IntentTxn.Size()))
	n78, err := m.IntentTxn.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n78
	if m.Status != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Status))
	}
	if m.Poison {
		dAtA[i] = 0x20
		i++
		if m.Poison {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	dAtA[i] = 0x2a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.MinTimestamp.Size()))
	n79, err := m.MinTimestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n79
	return i, nil
}

func (m *ResolveIntentRangeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResolveIntentRangeResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n80, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n80
	return i, nil
}

func (m *MergeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MergeRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n81, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n81
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Value.Size()))
	n82, err := m.Value.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n82
	return i, nil
}

func (m *MergeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MergeResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n83, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n83
	return i, nil
}

func (m *TruncateLogRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TruncateLogRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n84, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n84
	if m.Index != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Index))
	}
	if m.RangeID != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.RangeID))
	}
	return i, nil
}

func (m *TruncateLogResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TruncateLogResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n85, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n85
	return i, nil
}

func (m *RequestLeaseRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestLeaseRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n86, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n86
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Lease.Size()))
	n87, err := m.Lease.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n87
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.PrevLease.Size()))
	n88, err := m.PrevLease.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n88
	if m.MinProposedTS != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.MinProposedTS.Size()))
		n89, err := m.MinProposedTS.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n89
	}
	return i, nil
}

func (m *TransferLeaseRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TransferLeaseRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n90, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n90
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Lease.Size()))
	n91, err := m.Lease.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n91
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.PrevLease.Size()))
	n92, err := m.PrevLease.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n92
	return i, nil
}

func (m *LeaseInfoRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LeaseInfoRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n93, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n93
	return i, nil
}

func (m *LeaseInfoResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LeaseInfoResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n94, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n94
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Lease.Size()))
	n95, err := m.Lease.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n95
	return i, nil
}

func (m *RequestLeaseResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestLeaseResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n96, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n96
	return i, nil
}

func (m *ComputeChecksumRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ComputeChecksumRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n97, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n97
	if m.Version != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Version))
	}
	if m.Snapshot {
		dAtA[i] = 0x20
		i++
		if m.Snapshot {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *ComputeChecksumResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ComputeChecksumResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n98, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n98
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ChecksumID.Size()))
	n99, err := m.ChecksumID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n99
	return i, nil
}

func (m *ExportStorage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportStorage) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Provider != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Provider))
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.LocalFile.Size()))
	n100, err := m.LocalFile.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n100
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.HttpPath.Size()))
	n101, err := m.HttpPath.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n101
	if m.GoogleCloudConfig != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.GoogleCloudConfig.Size()))
		n102, err := m.GoogleCloudConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n102
	}
	if m.S3Config != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.S3Config.Size()))
		n103, err := m.S3Config.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n103
	}
	if m.AzureConfig != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AzureConfig.Size()))
		n104, err := m.AzureConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n104
	}
	return i, nil
}

func (m *ExportStorage_LocalFilePath) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportStorage_LocalFilePath) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Path) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Path)))
		i += copy(dAtA[i:], m.Path)
	}
	return i, nil
}

func (m *ExportStorage_Http) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportStorage_Http) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.BaseUri) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.BaseUri)))
		i += copy(dAtA[i:], m.BaseUri)
	}
	return i, nil
}

func (m *ExportStorage_S3) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportStorage_S3) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Bucket) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Bucket)))
		i += copy(dAtA[i:], m.Bucket)
	}
	if len(m.Prefix) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Prefix)))
		i += copy(dAtA[i:], m.Prefix)
	}
	if len(m.AccessKey) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.AccessKey)))
		i += copy(dAtA[i:], m.AccessKey)
	}
	if len(m.Secret) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Secret)))
		i += copy(dAtA[i:], m.Secret)
	}
	if len(m.TempToken) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.TempToken)))
		i += copy(dAtA[i:], m.TempToken)
	}
	if len(m.Endpoint) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Endpoint)))
		i += copy(dAtA[i:], m.Endpoint)
	}
	if len(m.Region) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Region)))
		i += copy(dAtA[i:], m.Region)
	}
	return i, nil
}

func (m *ExportStorage_GCS) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportStorage_GCS) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Bucket) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Bucket)))
		i += copy(dAtA[i:], m.Bucket)
	}
	if len(m.Prefix) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Prefix)))
		i += copy(dAtA[i:], m.Prefix)
	}
	if len(m.Auth) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Auth)))
		i += copy(dAtA[i:], m.Auth)
	}
	if len(m.BillingProject) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.BillingProject)))
		i += copy(dAtA[i:], m.BillingProject)
	}
	return i, nil
}

func (m *ExportStorage_Azure) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportStorage_Azure) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Container) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Container)))
		i += copy(dAtA[i:], m.Container)
	}
	if len(m.Prefix) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Prefix)))
		i += copy(dAtA[i:], m.Prefix)
	}
	if len(m.AccountName) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.AccountName)))
		i += copy(dAtA[i:], m.AccountName)
	}
	if len(m.AccountKey) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.AccountKey)))
		i += copy(dAtA[i:], m.AccountKey)
	}
	return i, nil
}

func (m *WriteBatchRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WriteBatchRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n105, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n105
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.DataSpan.Size()))
	n106, err := m.DataSpan.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n106
	if len(m.Data) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	return i, nil
}

func (m *WriteBatchResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WriteBatchResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n107, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n107
	return i, nil
}

func (m *ExportRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n108, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n108
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Storage.Size()))
	n109, err := m.Storage.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n109
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.StartTime.Size()))
	n110, err := m.StartTime.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n110
	if m.MVCCFilter != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.MVCCFilter))
	}
	if m.ReturnSST {
		dAtA[i] = 0x28
		i++
		if m.ReturnSST {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.OmitChecksum {
		dAtA[i] = 0x30
		i++
		if m.OmitChecksum {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *BulkOpSummary) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BulkOpSummary) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.DataSize != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.DataSize))
	}
	if m.Rows != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Rows))
	}
	if m.IndexEntries != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.IndexEntries))
	}
	if m.SystemRecords != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.SystemRecords))
	}
	return i, nil
}

func (m *ExportResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n111, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n111
	if len(m.Files) > 0 {
		for _, msg := range m.Files {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.StartTime.Size()))
	n112, err := m.StartTime.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n112
	return i, nil
}

func (m *ExportResponse_File) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportResponse_File) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n113, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n113
	if len(m.Path) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Path)))
		i += copy(dAtA[i:], m.Path)
	}
	if len(m.Sha512) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Sha512)))
		i += copy(dAtA[i:], m.Sha512)
	}
	dAtA[i] = 0x32
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Exported.Size()))
	n114, err := m.Exported.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n114
	if len(m.SST) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.SST)))
		i += copy(dAtA[i:], m.SST)
	}
	return i, nil
}

func (m *ImportRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImportRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n115, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n115
	if len(m.Files) > 0 {
		for _, msg := range m.Files {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.DataSpan.Size()))
	n116, err := m.DataSpan.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n116
	if len(m.Rekeys) > 0 {
		for _, msg := range m.Rekeys {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x32
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.EndTime.Size()))
	n117, err := m.EndTime.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n117
	return i, nil
}

func (m *ImportRequest_File) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImportRequest_File) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Dir.Size()))
	n118, err := m.Dir.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n118
	if len(m.Path) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Path)))
		i += copy(dAtA[i:], m.Path)
	}
	if len(m.Sha512) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Sha512)))
		i += copy(dAtA[i:], m.Sha512)
	}
	return i, nil
}

func (m *ImportRequest_TableRekey) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImportRequest_TableRekey) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.OldID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.OldID))
	}
	if len(m.NewDesc) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.NewDesc)))
		i += copy(dAtA[i:], m.NewDesc)
	}
	return i, nil
}

func (m *ImportResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImportResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n119, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n119
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Imported.Size()))
	n120, err := m.Imported.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n120
	return i, nil
}

func (m *AdminScatterRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminScatterRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n121, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n121
	if m.RandomizeLeases {
		dAtA[i] = 0x10
		i++
		if m.RandomizeLeases {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *AdminScatterResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminScatterResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n122, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n122
	if len(m.Ranges) > 0 {
		for _, msg := range m.Ranges {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *AdminScatterResponse_Range) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminScatterResponse_Range) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n123, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n123
	return i, nil
}

func (m *AddSSTableRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AddSSTableRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n124, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n124
	if len(m.Data) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	return i, nil
}

func (m *AddSSTableResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AddSSTableResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n125, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n125
	return i, nil
}

func (m *RefreshRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RefreshRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n126, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n126
	if m.Write {
		dAtA[i] = 0x10
		i++
		if m.Write {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *RefreshResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RefreshResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n127, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n127
	return i, nil
}

func (m *RefreshRangeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RefreshRangeRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n128, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n128
	if m.Write {
		dAtA[i] = 0x10
		i++
		if m.Write {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *RefreshRangeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RefreshRangeResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n129, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n129
	return i, nil
}

func (m *SubsumeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SubsumeRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n130, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n130
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.LeftRange.Size()))
	n131, err := m.LeftRange.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n131
	return i, nil
}

func (m *SubsumeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SubsumeResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n132, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n132
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.MVCCStats.Size()))
	n133, err := m.MVCCStats.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n133
	if m.LeaseAppliedIndex != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.LeaseAppliedIndex))
	}
	dAtA[i] = 0x2a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.FreezeStart.Size()))
	n134, err := m.FreezeStart.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n134
	return i, nil
}

func (m *RangeStatsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeStatsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n135, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n135
	return i, nil
}

func (m *RangeStatsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeStatsResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n136, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n136
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.MVCCStats.Size()))
	n137, err := m.MVCCStats.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n137
	return i, nil
}

func (m *RequestUnion) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestUnion) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		nn138, err := m.Value.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn138
	}
	return i, nil
}

func (m *RequestUnion_Get) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Get != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Get.Size()))
		n139, err := m.Get.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n139
	}
	return i, nil
}
func (m *RequestUnion_Put) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Put != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Put.Size()))
		n140, err := m.Put.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n140
	}
	return i, nil
}
func (m *RequestUnion_ConditionalPut) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ConditionalPut != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ConditionalPut.Size()))
		n141, err := m.ConditionalPut.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n141
	}
	return i, nil
}
func (m *RequestUnion_Increment) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Increment != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Increment.Size()))
		n142, err := m.Increment.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n142
	}
	return i, nil
}
func (m *RequestUnion_Delete) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Delete != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Delete.Size()))
		n143, err := m.Delete.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n143
	}
	return i, nil
}
func (m *RequestUnion_DeleteRange) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.DeleteRange != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.DeleteRange.Size()))
		n144, err := m.DeleteRange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n144
	}
	return i, nil
}
func (m *RequestUnion_Scan) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Scan != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Scan.Size()))
		n145, err := m.Scan.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n145
	}
	return i, nil
}
func (m *RequestUnion_BeginTransaction) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.BeginTransaction != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.BeginTransaction.Size()))
		n146, err := m.BeginTransaction.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n146
	}
	return i, nil
}
func (m *RequestUnion_EndTransaction) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.EndTransaction != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.EndTransaction.Size()))
		n147, err := m.EndTransaction.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n147
	}
	return i, nil
}
func (m *RequestUnion_AdminSplit) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AdminSplit != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminSplit.Size()))
		n148, err := m.AdminSplit.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n148
	}
	return i, nil
}
func (m *RequestUnion_AdminMerge) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AdminMerge != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminMerge.Size()))
		n149, err := m.AdminMerge.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n149
	}
	return i, nil
}
func (m *RequestUnion_HeartbeatTxn) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.HeartbeatTxn != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.HeartbeatTxn.Size()))
		n150, err := m.HeartbeatTxn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n150
	}
	return i, nil
}
func (m *RequestUnion_Gc) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Gc != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Gc.Size()))
		n151, err := m.Gc.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n151
	}
	return i, nil
}
func (m *RequestUnion_PushTxn) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.PushTxn != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.PushTxn.Size()))
		n152, err := m.PushTxn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n152
	}
	return i, nil
}
func (m *RequestUnion_ResolveIntent) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ResolveIntent != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ResolveIntent.Size()))
		n153, err := m.ResolveIntent.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n153
	}
	return i, nil
}
func (m *RequestUnion_ResolveIntentRange) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ResolveIntentRange != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ResolveIntentRange.Size()))
		n154, err := m.ResolveIntentRange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n154
	}
	return i, nil
}
func (m *RequestUnion_Merge) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Merge != nil {
		dAtA[i] = 0x92
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Merge.Size()))
		n155, err := m.Merge.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n155
	}
	return i, nil
}
func (m *RequestUnion_TruncateLog) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.TruncateLog != nil {
		dAtA[i] = 0x9a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.TruncateLog.Size()))
		n156, err := m.TruncateLog.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n156
	}
	return i, nil
}
func (m *RequestUnion_RequestLease) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RequestLease != nil {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.RequestLease.Size()))
		n157, err := m.RequestLease.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n157
	}
	return i, nil
}
func (m *RequestUnion_ReverseScan) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ReverseScan != nil {
		dAtA[i] = 0xaa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ReverseScan.Size()))
		n158, err := m.ReverseScan.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n158
	}
	return i, nil
}
func (m *RequestUnion_ComputeChecksum) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ComputeChecksum != nil {
		dAtA[i] = 0xb2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ComputeChecksum.Size()))
		n159, err := m.ComputeChecksum.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n159
	}
	return i, nil
}
func (m *RequestUnion_CheckConsistency) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.CheckConsistency != nil {
		dAtA[i] = 0xc2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.CheckConsistency.Size()))
		n160, err := m.CheckConsistency.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n160
	}
	return i, nil
}
func (m *RequestUnion_InitPut) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.InitPut != nil {
		dAtA[i] = 0xd2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.InitPut.Size()))
		n161, err := m.InitPut.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n161
	}
	return i, nil
}
func (m *RequestUnion_TransferLease) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.TransferLease != nil {
		dAtA[i] = 0xe2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.TransferLease.Size()))
		n162, err := m.TransferLease.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n162
	}
	return i, nil
}
func (m *RequestUnion_AdminTransferLease) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AdminTransferLease != nil {
		dAtA[i] = 0xea
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminTransferLease.Size()))
		n163, err := m.AdminTransferLease.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n163
	}
	return i, nil
}
func (m *RequestUnion_LeaseInfo) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.LeaseInfo != nil {
		dAtA[i] = 0xf2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.LeaseInfo.Size()))
		n164, err := m.LeaseInfo.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n164
	}
	return i, nil
}
func (m *RequestUnion_WriteBatch) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.WriteBatch != nil {
		dAtA[i] = 0xfa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.WriteBatch.Size()))
		n165, err := m.WriteBatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n165
	}
	return i, nil
}
func (m *RequestUnion_Export) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Export != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Export.Size()))
		n166, err := m.Export.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n166
	}
	return i, nil
}
func (m *RequestUnion_QueryTxn) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.QueryTxn != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.QueryTxn.Size()))
		n167, err := m.QueryTxn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n167
	}
	return i, nil
}
func (m *RequestUnion_Import) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Import != nil {
		dAtA[i] = 0x92
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Import.Size()))
		n168, err := m.Import.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n168
	}
	return i, nil
}
func (m *RequestUnion_AdminChangeReplicas) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AdminChangeReplicas != nil {
		dAtA[i] = 0x9a
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminChangeReplicas.Size()))
		n169, err := m.AdminChangeReplicas.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n169
	}
	return i, nil
}
func (m *RequestUnion_AdminScatter) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AdminScatter != nil {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminScatter.Size()))
		n170, err := m.AdminScatter.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n170
	}
	return i, nil
}
func (m *RequestUnion_AddSstable) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AddSstable != nil {
		dAtA[i] = 0xaa
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AddSstable.Size()))
		n171, err := m.AddSstable.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n171
	}
	return i, nil
}
func (m *RequestUnion_ClearRange) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ClearRange != nil {
		dAtA[i] = 0xb2
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ClearRange.Size()))
		n172, err := m.ClearRange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n172
	}
	return i, nil
}
func (m *RequestUnion_RecomputeStats) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RecomputeStats != nil {
		dAtA[i] = 0xba
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.RecomputeStats.Size()))
		n173, err := m.RecomputeStats.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n173
	}
	return i, nil
}
func (m *RequestUnion_Refresh) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Refresh != nil {
		dAtA[i] = 0xc2
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Refresh.Size()))
		n174, err := m.Refresh.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n174
	}
	return i, nil
}
func (m *RequestUnion_RefreshRange) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RefreshRange != nil {
		dAtA[i] = 0xca
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.RefreshRange.Size()))
		n175, err := m.RefreshRange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n175
	}
	return i, nil
}
func (m *RequestUnion_QueryIntent) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.QueryIntent != nil {
		dAtA[i] = 0xd2
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.QueryIntent.Size()))
		n176, err := m.QueryIntent.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n176
	}
	return i, nil
}
func (m *RequestUnion_Subsume) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Subsume != nil {
		dAtA[i] = 0xda
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Subsume.Size()))
		n177, err := m.Subsume.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n177
	}
	return i, nil
}
func (m *RequestUnion_RangeStats) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RangeStats != nil {
		dAtA[i] = 0xe2
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.RangeStats.Size()))
		n178, err := m.RangeStats.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n178
	}
	return i, nil
}
func (m *RequestUnion_AdminRelocateRange) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AdminRelocateRange != nil {
		dAtA[i] = 0xea
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminRelocateRange.Size()))
		n179, err := m.AdminRelocateRange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n179
	}
	return i, nil
}
func (m *ResponseUnion) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResponseUnion) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		nn180, err := m.Value.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn180
	}
	return i, nil
}

func (m *ResponseUnion_Get) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Get != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Get.Size()))
		n181, err := m.Get.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n181
	}
	return i, nil
}
func (m *ResponseUnion_Put) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Put != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Put.Size()))
		n182, err := m.Put.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n182
	}
	return i, nil
}
func (m *ResponseUnion_ConditionalPut) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ConditionalPut != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ConditionalPut.Size()))
		n183, err := m.ConditionalPut.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n183
	}
	return i, nil
}
func (m *ResponseUnion_Increment) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Increment != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Increment.Size()))
		n184, err := m.Increment.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n184
	}
	return i, nil
}
func (m *ResponseUnion_Delete) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Delete != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Delete.Size()))
		n185, err := m.Delete.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n185
	}
	return i, nil
}
func (m *ResponseUnion_DeleteRange) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.DeleteRange != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.DeleteRange.Size()))
		n186, err := m.DeleteRange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n186
	}
	return i, nil
}
func (m *ResponseUnion_Scan) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Scan != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Scan.Size()))
		n187, err := m.Scan.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n187
	}
	return i, nil
}
func (m *ResponseUnion_BeginTransaction) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.BeginTransaction != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.BeginTransaction.Size()))
		n188, err := m.BeginTransaction.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n188
	}
	return i, nil
}
func (m *ResponseUnion_EndTransaction) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.EndTransaction != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.EndTransaction.Size()))
		n189, err := m.EndTransaction.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n189
	}
	return i, nil
}
func (m *ResponseUnion_AdminSplit) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AdminSplit != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminSplit.Size()))
		n190, err := m.AdminSplit.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n190
	}
	return i, nil
}
func (m *ResponseUnion_AdminMerge) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AdminMerge != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminMerge.Size()))
		n191, err := m.AdminMerge.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n191
	}
	return i, nil
}
func (m *ResponseUnion_HeartbeatTxn) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.HeartbeatTxn != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.HeartbeatTxn.Size()))
		n192, err := m.HeartbeatTxn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n192
	}
	return i, nil
}
func (m *ResponseUnion_Gc) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Gc != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Gc.Size()))
		n193, err := m.Gc.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n193
	}
	return i, nil
}
func (m *ResponseUnion_PushTxn) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.PushTxn != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.PushTxn.Size()))
		n194, err := m.PushTxn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n194
	}
	return i, nil
}
func (m *ResponseUnion_ResolveIntent) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ResolveIntent != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ResolveIntent.Size()))
		n195, err := m.ResolveIntent.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n195
	}
	return i, nil
}
func (m *ResponseUnion_ResolveIntentRange) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ResolveIntentRange != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ResolveIntentRange.Size()))
		n196, err := m.ResolveIntentRange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n196
	}
	return i, nil
}
func (m *ResponseUnion_Merge) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Merge != nil {
		dAtA[i] = 0x92
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Merge.Size()))
		n197, err := m.Merge.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n197
	}
	return i, nil
}
func (m *ResponseUnion_TruncateLog) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.TruncateLog != nil {
		dAtA[i] = 0x9a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.TruncateLog.Size()))
		n198, err := m.TruncateLog.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n198
	}
	return i, nil
}
func (m *ResponseUnion_RequestLease) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RequestLease != nil {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.RequestLease.Size()))
		n199, err := m.RequestLease.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n199
	}
	return i, nil
}
func (m *ResponseUnion_ReverseScan) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ReverseScan != nil {
		dAtA[i] = 0xaa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ReverseScan.Size()))
		n200, err := m.ReverseScan.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n200
	}
	return i, nil
}
func (m *ResponseUnion_ComputeChecksum) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ComputeChecksum != nil {
		dAtA[i] = 0xb2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ComputeChecksum.Size()))
		n201, err := m.ComputeChecksum.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n201
	}
	return i, nil
}
func (m *ResponseUnion_CheckConsistency) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.CheckConsistency != nil {
		dAtA[i] = 0xc2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.CheckConsistency.Size()))
		n202, err := m.CheckConsistency.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n202
	}
	return i, nil
}
func (m *ResponseUnion_InitPut) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.InitPut != nil {
		dAtA[i] = 0xd2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.InitPut.Size()))
		n203, err := m.InitPut.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n203
	}
	return i, nil
}
func (m *ResponseUnion_AdminTransferLease) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AdminTransferLease != nil {
		dAtA[i] = 0xea
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminTransferLease.Size()))
		n204, err := m.AdminTransferLease.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n204
	}
	return i, nil
}
func (m *ResponseUnion_LeaseInfo) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.LeaseInfo != nil {
		dAtA[i] = 0xf2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.LeaseInfo.Size()))
		n205, err := m.LeaseInfo.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n205
	}
	return i, nil
}
func (m *ResponseUnion_WriteBatch) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.WriteBatch != nil {
		dAtA[i] = 0xfa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.WriteBatch.Size()))
		n206, err := m.WriteBatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n206
	}
	return i, nil
}
func (m *ResponseUnion_Export) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Export != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Export.Size()))
		n207, err := m.Export.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n207
	}
	return i, nil
}
func (m *ResponseUnion_QueryTxn) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.QueryTxn != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.QueryTxn.Size()))
		n208, err := m.QueryTxn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n208
	}
	return i, nil
}
func (m *ResponseUnion_Import) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Import != nil {
		dAtA[i] = 0x92
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Import.Size()))
		n209, err := m.Import.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n209
	}
	return i, nil
}
func (m *ResponseUnion_AdminChangeReplicas) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AdminChangeReplicas != nil {
		dAtA[i] = 0x9a
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminChangeReplicas.Size()))
		n210, err := m.AdminChangeReplicas.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n210
	}
	return i, nil
}
func (m *ResponseUnion_AdminScatter) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AdminScatter != nil {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminScatter.Size()))
		n211, err := m.AdminScatter.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n211
	}
	return i, nil
}
func (m *ResponseUnion_AddSstable) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AddSstable != nil {
		dAtA[i] = 0xaa
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AddSstable.Size()))
		n212, err := m.AddSstable.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n212
	}
	return i, nil
}
func (m *ResponseUnion_ClearRange) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ClearRange != nil {
		dAtA[i] = 0xb2
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ClearRange.Size()))
		n213, err := m.ClearRange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n213
	}
	return i, nil
}
func (m *ResponseUnion_RecomputeStats) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RecomputeStats != nil {
		dAtA[i] = 0xba
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.RecomputeStats.Size()))
		n214, err := m.RecomputeStats.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n214
	}
	return i, nil
}
func (m *ResponseUnion_Refresh) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Refresh != nil {
		dAtA[i] = 0xc2
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Refresh.Size()))
		n215, err := m.Refresh.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n215
	}
	return i, nil
}
func (m *ResponseUnion_RefreshRange) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RefreshRange != nil {
		dAtA[i] = 0xca
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.RefreshRange.Size()))
		n216, err := m.RefreshRange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n216
	}
	return i, nil
}
func (m *ResponseUnion_QueryIntent) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.QueryIntent != nil {
		dAtA[i] = 0xd2
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.QueryIntent.Size()))
		n217, err := m.QueryIntent.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n217
	}
	return i, nil
}
func (m *ResponseUnion_Subsume) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Subsume != nil {
		dAtA[i] = 0xda
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Subsume.Size()))
		n218, err := m.Subsume.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n218
	}
	return i, nil
}
func (m *ResponseUnion_RangeStats) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RangeStats != nil {
		dAtA[i] = 0xe2
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.RangeStats.Size()))
		n219, err := m.RangeStats.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n219
	}
	return i, nil
}
func (m *ResponseUnion_AdminRelocateRange) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AdminRelocateRange != nil {
		dAtA[i] = 0xea
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminRelocateRange.Size()))
		n220, err := m.AdminRelocateRange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n220
	}
	return i, nil
}
func (m *Header) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Header) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Timestamp.Size()))
	n221, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n221
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Replica.Size()))
	n222, err := m.Replica.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n222
	if m.RangeID != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.RangeID))
	}
	if m.UserPriority != 0 {
		dAtA[i] = 0x21
		i++
		binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.UserPriority))))
		i += 8
	}
	if m.Txn != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Txn.Size()))
		n223, err := m.Txn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n223
	}
	if m.ReadConsistency != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ReadConsistency))
	}
	if m.MaxSpanRequestKeys != 0 {
		dAtA[i] = 0x40
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.MaxSpanRequestKeys))
	}
	if m.DistinctSpans {
		dAtA[i] = 0x48
		i++
		if m.DistinctSpans {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.ReturnRangeInfo {
		dAtA[i] = 0x50
		i++
		if m.ReturnRangeInfo {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.GatewayNodeID != 0 {
		dAtA[i] = 0x58
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.GatewayNodeID))
	}
	if m.ScanOptions != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ScanOptions.Size()))
		n224, err := m.ScanOptions.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n224
	}
	if m.AsyncConsensus {
		dAtA[i] = 0x68
		i++
		if m.AsyncConsensus {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *BatchRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BatchRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Header.Size()))
	n225, err := m.Header.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n225
	if len(m.Requests) > 0 {
		for _, msg := range m.Requests {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *BatchResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BatchResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.BatchResponse_Header.Size()))
	n226, err := m.BatchResponse_Header.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n226
	if len(m.Responses) > 0 {
		for _, msg := range m.Responses {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *BatchResponse_Header) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BatchResponse_Header) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Error != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Error.Size()))
		n227, err := m.Error.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n227
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Timestamp.Size()))
	n228, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n228
	if m.Txn != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Txn.Size()))
		n229, err := m.Txn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n229
	}
	dAtA[i] = 0x2a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Now.Size()))
	n230, err := m.Now.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n230
	if len(m.CollectedSpans) > 0 {
		for _, msg := range m.CollectedSpans {
			dAtA[i] = 0x32
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *RangeFeedRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeFeedRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Header.Size()))
	n231, err := m.Header.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n231
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n232, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n232
	return i, nil
}

func (m *RangeFeedValue) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeFeedValue) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Value.Size()))
	n233, err := m.Value.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n233
	return i, nil
}

func (m *RangeFeedCheckpoint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeFeedCheckpoint) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n234, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n234
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResolvedTS.Size()))
	n235, err := m.ResolvedTS.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n235
	return i, nil
}

func (m *RangeFeedError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeFeedError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Error.Size()))
	n236, err := m.Error.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n236
	return i, nil
}

func (m *RangeFeedEvent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeFeedEvent) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Val != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Val.Size()))
		n237, err := m.Val.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n237
	}
	if m.Checkpoint != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Checkpoint.Size()))
		n238, err := m.Checkpoint.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n238
	}
	if m.Error != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Error.Size()))
		n239, err := m.Error.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n239
	}
	return i, nil
}

func encodeVarintApi(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *RangeInfo) Size() (n int) {
	var l int
	_ = l
	l = m.Desc.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Lease.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *RequestHeader) Size() (n int) {
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Sequence != 0 {
		n += 1 + sovApi(uint64(m.Sequence))
	}
	return n
}

func (m *ResponseHeader) Size() (n int) {
	var l int
	_ = l
	if m.Txn != nil {
		l = m.Txn.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.ResumeSpan != nil {
		l = m.ResumeSpan.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.NumKeys != 0 {
		n += 1 + sovApi(uint64(m.NumKeys))
	}
	if len(m.RangeInfos) > 0 {
		for _, e := range m.RangeInfos {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if m.ResumeReason != 0 {
		n += 1 + sovApi(uint64(m.ResumeReason))
	}
	return n
}

func (m *GetRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *GetResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Value != nil {
		l = m.Value.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.IntentValue != nil {
		l = m.IntentValue.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *PutRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Value.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Inline {
		n += 2
	}
	if m.Blind {
		n += 2
	}
	return n
}

func (m *PutResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ConditionalPutRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Value.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.ExpValue != nil {
		l = m.ExpValue.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Blind {
		n += 2
	}
	return n
}

func (m *ConditionalPutResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *InitPutRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Value.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Blind {
		n += 2
	}
	if m.FailOnTombstones {
		n += 2
	}
	return n
}

func (m *InitPutResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *IncrementRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Increment != 0 {
		n += 1 + sovApi(uint64(m.Increment))
	}
	return n
}

func (m *IncrementResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.NewValue != 0 {
		n += 1 + sovApi(uint64(m.NewValue))
	}
	return n
}

func (m *DeleteRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *DeleteResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *DeleteRangeRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.ReturnKeys {
		n += 2
	}
	if m.Inline {
		n += 2
	}
	return n
}

func (m *DeleteRangeResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Keys) > 0 {
		for _, b := range m.Keys {
			l = len(b)
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *ClearRangeRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ClearRangeResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ScanOptions) Size() (n int) {
	var l int
	_ = l
	if m.StopAtRangeBoundary {
		n += 2
	}
	if m.MinResults != 0 {
		n += 1 + sovApi(uint64(m.MinResults))
	}
	return n
}

func (m *ScanRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.ScanFormat != 0 {
		n += 1 + sovApi(uint64(m.ScanFormat))
	}
	return n
}

func (m *ScanResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Rows) > 0 {
		for _, e := range m.Rows {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if len(m.IntentRows) > 0 {
		for _, e := range m.IntentRows {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	l = len(m.BatchResponse)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ReverseScanRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.ScanFormat != 0 {
		n += 1 + sovApi(uint64(m.ScanFormat))
	}
	return n
}

func (m *ReverseScanResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Rows) > 0 {
		for _, e := range m.Rows {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if len(m.IntentRows) > 0 {
		for _, e := range m.IntentRows {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	l = len(m.BatchResponse)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *CheckConsistencyRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.WithDiff {
		n += 2
	}
	return n
}

func (m *CheckConsistencyResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *RecomputeStatsRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.DryRun {
		n += 2
	}
	return n
}

func (m *RecomputeStatsResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.AddedDelta.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *BeginTransactionRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *BeginTransactionResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *EndTransactionRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Commit {
		n += 2
	}
	if m.Deadline != nil {
		l = m.Deadline.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.InternalCommitTrigger != nil {
		l = m.InternalCommitTrigger.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.IntentSpans) > 0 {
		for _, e := range m.IntentSpans {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if m.Require1PC {
		n += 2
	}
	if m.NoRefreshSpans {
		n += 2
	}
	if m.Poison {
		n += 2
	}
	return n
}

func (m *EndTransactionResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.OnePhaseCommit {
		n += 2
	}
	return n
}

func (m *AdminSplitRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = len(m.SplitKey)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *AdminSplitResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *AdminMergeRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *AdminMergeResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *AdminTransferLeaseRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Target != 0 {
		n += 1 + sovApi(uint64(m.Target))
	}
	return n
}

func (m *AdminTransferLeaseResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *AdminChangeReplicasRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.ChangeType != 0 {
		n += 1 + sovApi(uint64(m.ChangeType))
	}
	if len(m.Targets) > 0 {
		for _, e := range m.Targets {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *AdminChangeReplicasResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *AdminRelocateRangeRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Targets) > 0 {
		for _, e := range m.Targets {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *AdminRelocateRangeResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *HeartbeatTxnRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Now.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *HeartbeatTxnResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *GCRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Keys) > 0 {
		for _, e := range m.Keys {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	l = m.Threshold.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.TxnSpanGCThreshold.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *GCRequest_GCKey) Size() (n int) {
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = m.Timestamp.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *GCResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *PushTxnRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.PusherTxn.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.PusheeTxn.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.PushTo.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Now.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.PushType != 0 {
		n += 1 + sovApi(uint64(m.PushType))
	}
	if m.Force {
		n += 2
	}
	return n
}

func (m *PushTxnResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.PusheeTxn.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *QueryTxnRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Txn.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.WaitForUpdate {
		n += 2
	}
	if len(m.KnownWaitingTxns) > 0 {
		for _, e := range m.KnownWaitingTxns {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *QueryTxnResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.QueriedTxn.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.WaitingTxns) > 0 {
		for _, e := range m.WaitingTxns {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *QueryIntentRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Txn.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.IfMissing != 0 {
		n += 1 + sovApi(uint64(m.IfMissing))
	}
	return n
}

func (m *QueryIntentResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.FoundIntent {
		n += 2
	}
	return n
}

func (m *ResolveIntentRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.IntentTxn.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Status != 0 {
		n += 1 + sovApi(uint64(m.Status))
	}
	if m.Poison {
		n += 2
	}
	return n
}

func (m *ResolveIntentResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ResolveIntentRangeRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.IntentTxn.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Status != 0 {
		n += 1 + sovApi(uint64(m.Status))
	}
	if m.Poison {
		n += 2
	}
	l = m.MinTimestamp.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ResolveIntentRangeResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *MergeRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Value.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *MergeResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *TruncateLogRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Index != 0 {
		n += 1 + sovApi(uint64(m.Index))
	}
	if m.RangeID != 0 {
		n += 1 + sovApi(uint64(m.RangeID))
	}
	return n
}

func (m *TruncateLogResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *RequestLeaseRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Lease.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.PrevLease.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.MinProposedTS != nil {
		l = m.MinProposedTS.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *TransferLeaseRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Lease.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.PrevLease.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *LeaseInfoRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *LeaseInfoResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Lease.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *RequestLeaseResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ComputeChecksumRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Version != 0 {
		n += 1 + sovApi(uint64(m.Version))
	}
	if m.Snapshot {
		n += 2
	}
	return n
}

func (m *ComputeChecksumResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.ChecksumID.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ExportStorage) Size() (n int) {
	var l int
	_ = l
	if m.Provider != 0 {
		n += 1 + sovApi(uint64(m.Provider))
	}
	l = m.LocalFile.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.HttpPath.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.GoogleCloudConfig != nil {
		l = m.GoogleCloudConfig.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.S3Config != nil {
		l = m.S3Config.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.AzureConfig != nil {
		l = m.AzureConfig.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ExportStorage_LocalFilePath) Size() (n int) {
	var l int
	_ = l
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ExportStorage_Http) Size() (n int) {
	var l int
	_ = l
	l = len(m.BaseUri)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ExportStorage_S3) Size() (n int) {
	var l int
	_ = l
	l = len(m.Bucket)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Prefix)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.AccessKey)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Secret)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.TempToken)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Endpoint)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Region)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ExportStorage_GCS) Size() (n int) {
	var l int
	_ = l
	l = len(m.Bucket)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Prefix)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Auth)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.BillingProject)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ExportStorage_Azure) Size() (n int) {
	var l int
	_ = l
	l = len(m.Container)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Prefix)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.AccountName)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.AccountKey)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *WriteBatchRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.DataSpan.Size()
	n += 1 + l + sovApi(uint64(l))
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *WriteBatchResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ExportRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Storage.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.StartTime.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.MVCCFilter != 0 {
		n += 1 + sovApi(uint64(m.MVCCFilter))
	}
	if m.ReturnSST {
		n += 2
	}
	if m.OmitChecksum {
		n += 2
	}
	return n
}

func (m *BulkOpSummary) Size() (n int) {
	var l int
	_ = l
	if m.DataSize != 0 {
		n += 1 + sovApi(uint64(m.DataSize))
	}
	if m.Rows != 0 {
		n += 1 + sovApi(uint64(m.Rows))
	}
	if m.IndexEntries != 0 {
		n += 1 + sovApi(uint64(m.IndexEntries))
	}
	if m.SystemRecords != 0 {
		n += 1 + sovApi(uint64(m.SystemRecords))
	}
	return n
}

func (m *ExportResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Files) > 0 {
		for _, e := range m.Files {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	l = m.StartTime.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ExportResponse_File) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Sha512)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = m.Exported.Size()
	n += 1 + l + sovApi(uint64(l))
	l = len(m.SST)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ImportRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Files) > 0 {
		for _, e := range m.Files {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	l = m.DataSpan.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Rekeys) > 0 {
		for _, e := range m.Rekeys {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	l = m.EndTime.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ImportRequest_File) Size() (n int) {
	var l int
	_ = l
	l = m.Dir.Size()
	n += 1 + l + sovApi(uint64(l))
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Sha512)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ImportRequest_TableRekey) Size() (n int) {
	var l int
	_ = l
	if m.OldID != 0 {
		n += 1 + sovApi(uint64(m.OldID))
	}
	l = len(m.NewDesc)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ImportResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Imported.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *AdminScatterRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.RandomizeLeases {
		n += 2
	}
	return n
}

func (m *AdminScatterResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Ranges) > 0 {
		for _, e := range m.Ranges {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *AdminScatterResponse_Range) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *AddSSTableRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *AddSSTableResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *RefreshRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Write {
		n += 2
	}
	return n
}

func (m *RefreshResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *RefreshRangeRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Write {
		n += 2
	}
	return n
}

func (m *RefreshRangeResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *SubsumeRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.LeftRange.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *SubsumeResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.MVCCStats.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.LeaseAppliedIndex != 0 {
		n += 1 + sovApi(uint64(m.LeaseAppliedIndex))
	}
	l = m.FreezeStart.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *RangeStatsRequest) Size() (n int) {
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *RangeStatsResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.MVCCStats.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *RequestUnion) Size() (n int) {
	var l int
	_ = l
	if m.Value != nil {
		n += m.Value.Size()
	}
	return n
}

func (m *RequestUnion_Get) Size() (n int) {
	var l int
	_ = l
	if m.Get != nil {
		l = m.Get.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_Put) Size() (n int) {
	var l int
	_ = l
	if m.Put != nil {
		l = m.Put.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_ConditionalPut) Size() (n int) {
	var l int
	_ = l
	if m.ConditionalPut != nil {
		l = m.ConditionalPut.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_Increment) Size() (n int) {
	var l int
	_ = l
	if m.Increment != nil {
		l = m.Increment.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_Delete) Size() (n int) {
	var l int
	_ = l
	if m.Delete != nil {
		l = m.Delete.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_DeleteRange) Size() (n int) {
	var l int
	_ = l
	if m.DeleteRange != nil {
		l = m.DeleteRange.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_Scan) Size() (n int) {
	var l int
	_ = l
	if m.Scan != nil {
		l = m.Scan.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_BeginTransaction) Size() (n int) {
	var l int
	_ = l
	if m.BeginTransaction != nil {
		l = m.BeginTransaction.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_EndTransaction) Size() (n int) {
	var l int
	_ = l
	if m.EndTransaction != nil {
		l = m.EndTransaction.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_AdminSplit) Size() (n int) {
	var l int
	_ = l
	if m.AdminSplit != nil {
		l = m.AdminSplit.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_AdminMerge) Size() (n int) {
	var l int
	_ = l
	if m.AdminMerge != nil {
		l = m.AdminMerge.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_HeartbeatTxn) Size() (n int) {
	var l int
	_ = l
	if m.HeartbeatTxn != nil {
		l = m.HeartbeatTxn.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_Gc) Size() (n int) {
	var l int
	_ = l
	if m.Gc != nil {
		l = m.Gc.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_PushTxn) Size() (n int) {
	var l int
	_ = l
	if m.PushTxn != nil {
		l = m.PushTxn.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_ResolveIntent) Size() (n int) {
	var l int
	_ = l
	if m.ResolveIntent != nil {
		l = m.ResolveIntent.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_ResolveIntentRange) Size() (n int) {
	var l int
	_ = l
	if m.ResolveIntentRange != nil {
		l = m.ResolveIntentRange.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_Merge) Size() (n int) {
	var l int
	_ = l
	if m.Merge != nil {
		l = m.Merge.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_TruncateLog) Size() (n int) {
	var l int
	_ = l
	if m.TruncateLog != nil {
		l = m.TruncateLog.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_RequestLease) Size() (n int) {
	var l int
	_ = l
	if m.RequestLease != nil {
		l = m.RequestLease.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_ReverseScan) Size() (n int) {
	var l int
	_ = l
	if m.ReverseScan != nil {
		l = m.ReverseScan.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_ComputeChecksum) Size() (n int) {
	var l int
	_ = l
	if m.ComputeChecksum != nil {
		l = m.ComputeChecksum.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_CheckConsistency) Size() (n int) {
	var l int
	_ = l
	if m.CheckConsistency != nil {
		l = m.CheckConsistency.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_InitPut) Size() (n int) {
	var l int
	_ = l
	if m.InitPut != nil {
		l = m.InitPut.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_TransferLease) Size() (n int) {
	var l int
	_ = l
	if m.TransferLease != nil {
		l = m.TransferLease.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_AdminTransferLease) Size() (n int) {
	var l int
	_ = l
	if m.AdminTransferLease != nil {
		l = m.AdminTransferLease.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_LeaseInfo) Size() (n int) {
	var l int
	_ = l
	if m.LeaseInfo != nil {
		l = m.LeaseInfo.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_WriteBatch) Size() (n int) {
	var l int
	_ = l
	if m.WriteBatch != nil {
		l = m.WriteBatch.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_Export) Size() (n int) {
	var l int
	_ = l
	if m.Export != nil {
		l = m.Export.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_QueryTxn) Size() (n int) {
	var l int
	_ = l
	if m.QueryTxn != nil {
		l = m.QueryTxn.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_Import) Size() (n int) {
	var l int
	_ = l
	if m.Import != nil {
		l = m.Import.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_AdminChangeReplicas) Size() (n int) {
	var l int
	_ = l
	if m.AdminChangeReplicas != nil {
		l = m.AdminChangeReplicas.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_AdminScatter) Size() (n int) {
	var l int
	_ = l
	if m.AdminScatter != nil {
		l = m.AdminScatter.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_AddSstable) Size() (n int) {
	var l int
	_ = l
	if m.AddSstable != nil {
		l = m.AddSstable.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_ClearRange) Size() (n int) {
	var l int
	_ = l
	if m.ClearRange != nil {
		l = m.ClearRange.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_RecomputeStats) Size() (n int) {
	var l int
	_ = l
	if m.RecomputeStats != nil {
		l = m.RecomputeStats.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_Refresh) Size() (n int) {
	var l int
	_ = l
	if m.Refresh != nil {
		l = m.Refresh.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_RefreshRange) Size() (n int) {
	var l int
	_ = l
	if m.RefreshRange != nil {
		l = m.RefreshRange.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_QueryIntent) Size() (n int) {
	var l int
	_ = l
	if m.QueryIntent != nil {
		l = m.QueryIntent.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_Subsume) Size() (n int) {
	var l int
	_ = l
	if m.Subsume != nil {
		l = m.Subsume.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_RangeStats) Size() (n int) {
	var l int
	_ = l
	if m.RangeStats != nil {
		l = m.RangeStats.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_AdminRelocateRange) Size() (n int) {
	var l int
	_ = l
	if m.AdminRelocateRange != nil {
		l = m.AdminRelocateRange.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion) Size() (n int) {
	var l int
	_ = l
	if m.Value != nil {
		n += m.Value.Size()
	}
	return n
}

func (m *ResponseUnion_Get) Size() (n int) {
	var l int
	_ = l
	if m.Get != nil {
		l = m.Get.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_Put) Size() (n int) {
	var l int
	_ = l
	if m.Put != nil {
		l = m.Put.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_ConditionalPut) Size() (n int) {
	var l int
	_ = l
	if m.ConditionalPut != nil {
		l = m.ConditionalPut.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_Increment) Size() (n int) {
	var l int
	_ = l
	if m.Increment != nil {
		l = m.Increment.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_Delete) Size() (n int) {
	var l int
	_ = l
	if m.Delete != nil {
		l = m.Delete.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_DeleteRange) Size() (n int) {
	var l int
	_ = l
	if m.DeleteRange != nil {
		l = m.DeleteRange.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_Scan) Size() (n int) {
	var l int
	_ = l
	if m.Scan != nil {
		l = m.Scan.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_BeginTransaction) Size() (n int) {
	var l int
	_ = l
	if m.BeginTransaction != nil {
		l = m.BeginTransaction.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_EndTransaction) Size() (n int) {
	var l int
	_ = l
	if m.EndTransaction != nil {
		l = m.EndTransaction.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_AdminSplit) Size() (n int) {
	var l int
	_ = l
	if m.AdminSplit != nil {
		l = m.AdminSplit.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_AdminMerge) Size() (n int) {
	var l int
	_ = l
	if m.AdminMerge != nil {
		l = m.AdminMerge.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_HeartbeatTxn) Size() (n int) {
	var l int
	_ = l
	if m.HeartbeatTxn != nil {
		l = m.HeartbeatTxn.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_Gc) Size() (n int) {
	var l int
	_ = l
	if m.Gc != nil {
		l = m.Gc.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_PushTxn) Size() (n int) {
	var l int
	_ = l
	if m.PushTxn != nil {
		l = m.PushTxn.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_ResolveIntent) Size() (n int) {
	var l int
	_ = l
	if m.ResolveIntent != nil {
		l = m.ResolveIntent.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_ResolveIntentRange) Size() (n int) {
	var l int
	_ = l
	if m.ResolveIntentRange != nil {
		l = m.ResolveIntentRange.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_Merge) Size() (n int) {
	var l int
	_ = l
	if m.Merge != nil {
		l = m.Merge.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_TruncateLog) Size() (n int) {
	var l int
	_ = l
	if m.TruncateLog != nil {
		l = m.TruncateLog.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_RequestLease) Size() (n int) {
	var l int
	_ = l
	if m.RequestLease != nil {
		l = m.RequestLease.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_ReverseScan) Size() (n int) {
	var l int
	_ = l
	if m.ReverseScan != nil {
		l = m.ReverseScan.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_ComputeChecksum) Size() (n int) {
	var l int
	_ = l
	if m.ComputeChecksum != nil {
		l = m.ComputeChecksum.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_CheckConsistency) Size() (n int) {
	var l int
	_ = l
	if m.CheckConsistency != nil {
		l = m.CheckConsistency.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_InitPut) Size() (n int) {
	var l int
	_ = l
	if m.InitPut != nil {
		l = m.InitPut.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_AdminTransferLease) Size() (n int) {
	var l int
	_ = l
	if m.AdminTransferLease != nil {
		l = m.AdminTransferLease.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_LeaseInfo) Size() (n int) {
	var l int
	_ = l
	if m.LeaseInfo != nil {
		l = m.LeaseInfo.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_WriteBatch) Size() (n int) {
	var l int
	_ = l
	if m.WriteBatch != nil {
		l = m.WriteBatch.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_Export) Size() (n int) {
	var l int
	_ = l
	if m.Export != nil {
		l = m.Export.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_QueryTxn) Size() (n int) {
	var l int
	_ = l
	if m.QueryTxn != nil {
		l = m.QueryTxn.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_Import) Size() (n int) {
	var l int
	_ = l
	if m.Import != nil {
		l = m.Import.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_AdminChangeReplicas) Size() (n int) {
	var l int
	_ = l
	if m.AdminChangeReplicas != nil {
		l = m.AdminChangeReplicas.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_AdminScatter) Size() (n int) {
	var l int
	_ = l
	if m.AdminScatter != nil {
		l = m.AdminScatter.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_AddSstable) Size() (n int) {
	var l int
	_ = l
	if m.AddSstable != nil {
		l = m.AddSstable.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_ClearRange) Size() (n int) {
	var l int
	_ = l
	if m.ClearRange != nil {
		l = m.ClearRange.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_RecomputeStats) Size() (n int) {
	var l int
	_ = l
	if m.RecomputeStats != nil {
		l = m.RecomputeStats.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_Refresh) Size() (n int) {
	var l int
	_ = l
	if m.Refresh != nil {
		l = m.Refresh.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_RefreshRange) Size() (n int) {
	var l int
	_ = l
	if m.RefreshRange != nil {
		l = m.RefreshRange.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_QueryIntent) Size() (n int) {
	var l int
	_ = l
	if m.QueryIntent != nil {
		l = m.QueryIntent.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_Subsume) Size() (n int) {
	var l int
	_ = l
	if m.Subsume != nil {
		l = m.Subsume.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_RangeStats) Size() (n int) {
	var l int
	_ = l
	if m.RangeStats != nil {
		l = m.RangeStats.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_AdminRelocateRange) Size() (n int) {
	var l int
	_ = l
	if m.AdminRelocateRange != nil {
		l = m.AdminRelocateRange.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *Header) Size() (n int) {
	var l int
	_ = l
	l = m.Timestamp.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Replica.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.RangeID != 0 {
		n += 1 + sovApi(uint64(m.RangeID))
	}
	if m.UserPriority != 0 {
		n += 9
	}
	if m.Txn != nil {
		l = m.Txn.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.ReadConsistency != 0 {
		n += 1 + sovApi(uint64(m.ReadConsistency))
	}
	if m.MaxSpanRequestKeys != 0 {
		n += 1 + sovApi(uint64(m.MaxSpanRequestKeys))
	}
	if m.DistinctSpans {
		n += 2
	}
	if m.ReturnRangeInfo {
		n += 2
	}
	if m.GatewayNodeID != 0 {
		n += 1 + sovApi(uint64(m.GatewayNodeID))
	}
	if m.ScanOptions != nil {
		l = m.ScanOptions.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.AsyncConsensus {
		n += 2
	}
	return n
}

func (m *BatchRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Header.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Requests) > 0 {
		for _, e := range m.Requests {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *BatchResponse) Size() (n int) {
	var l int
	_ = l
	l = m.BatchResponse_Header.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Responses) > 0 {
		for _, e := range m.Responses {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *BatchResponse_Header) Size() (n int) {
	var l int
	_ = l
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	l = m.Timestamp.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Txn != nil {
		l = m.Txn.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	l = m.Now.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.CollectedSpans) > 0 {
		for _, e := range m.CollectedSpans {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *RangeFeedRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Header.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *RangeFeedValue) Size() (n int) {
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = m.Value.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *RangeFeedCheckpoint) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.ResolvedTS.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *RangeFeedError) Size() (n int) {
	var l int
	_ = l
	l = m.Error.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *RangeFeedEvent) Size() (n int) {
	var l int
	_ = l
	if m.Val != nil {
		l = m.Val.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Checkpoint != nil {
		l = m.Checkpoint.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func sovApi(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozApi(x uint64) (n int) {
	return sovApi(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *RangeFeedEvent) GetValue() interface{} {
	if this.Val != nil {
		return this.Val
	}
	if this.Checkpoint != nil {
		return this.Checkpoint
	}
	if this.Error != nil {
		return this.Error
	}
	return nil
}

func (this *RangeFeedEvent) SetValue(value interface{}) bool {
	switch vt := value.(type) {
	case *RangeFeedValue:
		this.Val = vt
	case *RangeFeedCheckpoint:
		this.Checkpoint = vt
	case *RangeFeedError:
		this.Error = vt
	default:
		return false
	}
	return true
}
func (m *RangeInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Desc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Desc.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Lease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestHeader) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestHeader: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestHeader: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sequence", wireType)
			}
			m.Sequence = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Sequence |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResponseHeader) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResponseHeader: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResponseHeader: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Txn == nil {
				m.Txn = &Transaction{}
			}
			if err := m.Txn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResumeSpan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResumeSpan == nil {
				m.ResumeSpan = &Span{}
			}
			if err := m.ResumeSpan.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumKeys", wireType)
			}
			m.NumKeys = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumKeys |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeInfos", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RangeInfos = append(m.RangeInfos, RangeInfo{})
			if err := m.RangeInfos[len(m.RangeInfos)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResumeReason", wireType)
			}
			m.ResumeReason = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ResumeReason |= (ResponseHeader_ResumeReason(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Value == nil {
				m.Value = &Value{}
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IntentValue == nil {
				m.IntentValue = &Value{}
			}
			if err := m.IntentValue.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PutRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PutRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PutRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Inline", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Inline = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Blind", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Blind = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PutResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PutResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PutResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConditionalPutRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConditionalPutRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConditionalPutRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExpValue == nil {
				m.ExpValue = &Value{}
			}
			if err := m.ExpValue.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Blind", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Blind = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConditionalPutResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConditionalPutResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConditionalPutResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InitPutRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InitPutRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InitPutRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Blind", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Blind = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailOnTombstones", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.FailOnTombstones = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InitPutResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InitPutResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InitPutResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IncrementRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IncrementRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IncrementRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Increment", wireType)
			}
			m.Increment = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Increment |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IncrementResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IncrementResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IncrementResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NewValue", wireType)
			}
			m.NewValue = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NewValue |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeleteRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeleteRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeleteRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeleteResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeleteResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeleteResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeleteRangeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeleteRangeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeleteRangeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReturnKeys", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ReturnKeys = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Inline", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Inline = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeleteRangeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeleteRangeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeleteRangeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Keys = append(m.Keys, make([]byte, postIndex-iNdEx))
			copy(m.Keys[len(m.Keys)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClearRangeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClearRangeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClearRangeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClearRangeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClearRangeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClearRangeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScanOptions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScanOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScanOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StopAtRangeBoundary", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.StopAtRangeBoundary = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinResults", wireType)
			}
			m.MinResults = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MinResults |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScanRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScanRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScanRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScanFormat", wireType)
			}
			m.ScanFormat = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ScanFormat |= (ScanFormat(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScanResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScanResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScanResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rows", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Rows = append(m.Rows, KeyValue{})
			if err := m.Rows[len(m.Rows)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentRows", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IntentRows = append(m.IntentRows, KeyValue{})
			if err := m.IntentRows[len(m.IntentRows)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BatchResponse", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BatchResponse = append(m.BatchResponse[:0], dAtA[iNdEx:postIndex]...)
			if m.BatchResponse == nil {
				m.BatchResponse = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReverseScanRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReverseScanRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReverseScanRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScanFormat", wireType)
			}
			m.ScanFormat = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ScanFormat |= (ScanFormat(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReverseScanResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReverseScanResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReverseScanResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rows", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Rows = append(m.Rows, KeyValue{})
			if err := m.Rows[len(m.Rows)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentRows", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IntentRows = append(m.IntentRows, KeyValue{})
			if err := m.IntentRows[len(m.IntentRows)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BatchResponse", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BatchResponse = append(m.BatchResponse[:0], dAtA[iNdEx:postIndex]...)
			if m.BatchResponse == nil {
				m.BatchResponse = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckConsistencyRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckConsistencyRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckConsistencyRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WithDiff", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.WithDiff = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckConsistencyResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckConsistencyResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckConsistencyResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RecomputeStatsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RecomputeStatsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RecomputeStatsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DryRun", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DryRun = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RecomputeStatsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RecomputeStatsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RecomputeStatsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AddedDelta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.AddedDelta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BeginTransactionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BeginTransactionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BeginTransactionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BeginTransactionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BeginTransactionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BeginTransactionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EndTransactionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EndTransactionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EndTransactionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Commit", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Commit = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deadline", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Deadline == nil {
				m.Deadline = &cockroach_util_hlc.Timestamp{}
			}
			if err := m.Deadline.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InternalCommitTrigger", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.InternalCommitTrigger == nil {
				m.InternalCommitTrigger = &InternalCommitTrigger{}
			}
			if err := m.InternalCommitTrigger.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentSpans", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IntentSpans = append(m.IntentSpans, Span{})
			if err := m.IntentSpans[len(m.IntentSpans)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Require1PC", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Require1PC = bool(v != 0)
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NoRefreshSpans", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NoRefreshSpans = bool(v != 0)
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Poison", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Poison = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EndTransactionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EndTransactionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EndTransactionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OnePhaseCommit", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.OnePhaseCommit = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminSplitRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminSplitRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminSplitRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SplitKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SplitKey = append(m.SplitKey[:0], dAtA[iNdEx:postIndex]...)
			if m.SplitKey == nil {
				m.SplitKey = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminSplitResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminSplitResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminSplitResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminMergeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminMergeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminMergeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminMergeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminMergeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminMergeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminTransferLeaseRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminTransferLeaseRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminTransferLeaseRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Target", wireType)
			}
			m.Target = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Target |= (StoreID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminTransferLeaseResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminTransferLeaseResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminTransferLeaseResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminChangeReplicasRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminChangeReplicasRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminChangeReplicasRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChangeType", wireType)
			}
			m.ChangeType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ChangeType |= (ReplicaChangeType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Targets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Targets = append(m.Targets, ReplicationTarget{})
			if err := m.Targets[len(m.Targets)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminChangeReplicasResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminChangeReplicasResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminChangeReplicasResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminRelocateRangeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminRelocateRangeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminRelocateRangeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Targets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Targets = append(m.Targets, ReplicationTarget{})
			if err := m.Targets[len(m.Targets)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminRelocateRangeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminRelocateRangeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminRelocateRangeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HeartbeatTxnRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HeartbeatTxnRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HeartbeatTxnRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Now", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Now.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HeartbeatTxnResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HeartbeatTxnResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HeartbeatTxnResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GCRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GCRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GCRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Keys = append(m.Keys, GCRequest_GCKey{})
			if err := m.Keys[len(m.Keys)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Threshold", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Threshold.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnSpanGCThreshold", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TxnSpanGCThreshold.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GCRequest_GCKey) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GCKey: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GCKey: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GCResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GCResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GCResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PushTxnRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PushTxnRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PushTxnRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PusherTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PusherTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PusheeTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PusheeTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PushTo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PushTo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Now", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Now.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PushType", wireType)
			}
			m.PushType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PushType |= (PushTxnType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Force", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Force = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PushTxnResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PushTxnResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PushTxnResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PusheeTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PusheeTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryTxnRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryTxnRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryTxnRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Txn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WaitForUpdate", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.WaitForUpdate = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KnownWaitingTxns", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v github_com_cockroachdb_cockroach_pkg_util_uuid.UUID
			m.KnownWaitingTxns = append(m.KnownWaitingTxns, v)
			if err := m.KnownWaitingTxns[len(m.KnownWaitingTxns)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryTxnResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryTxnResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryTxnResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueriedTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.QueriedTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WaitingTxns", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v github_com_cockroachdb_cockroach_pkg_util_uuid.UUID
			m.WaitingTxns = append(m.WaitingTxns, v)
			if err := m.WaitingTxns[len(m.WaitingTxns)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryIntentRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryIntentRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryIntentRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Txn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IfMissing", wireType)
			}
			m.IfMissing = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IfMissing |= (QueryIntentRequest_IfMissingBehavior(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryIntentResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryIntentResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryIntentResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FoundIntent", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.FoundIntent = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResolveIntentRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResolveIntentRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResolveIntentRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.IntentTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= (TransactionStatus(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Poison", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Poison = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResolveIntentResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResolveIntentResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResolveIntentResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResolveIntentRangeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResolveIntentRangeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResolveIntentRangeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.IntentTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= (TransactionStatus(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Poison", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Poison = bool(v != 0)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.MinTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResolveIntentRangeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResolveIntentRangeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResolveIntentRangeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MergeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MergeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MergeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MergeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MergeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MergeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TruncateLogRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TruncateLogRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TruncateLogRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Index", wireType)
			}
			m.Index = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Index |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeID", wireType)
			}
			m.RangeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeID |= (RangeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TruncateLogResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TruncateLogResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TruncateLogResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestLeaseRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestLeaseRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestLeaseRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Lease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrevLease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PrevLease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinProposedTS", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MinProposedTS == nil {
				m.MinProposedTS = &cockroach_util_hlc.Timestamp{}
			}
			if err := m.MinProposedTS.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TransferLeaseRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TransferLeaseRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TransferLeaseRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Lease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrevLease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PrevLease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LeaseInfoRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LeaseInfoRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LeaseInfoRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LeaseInfoResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LeaseInfoResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LeaseInfoResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Lease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestLeaseResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestLeaseResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestLeaseResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ComputeChecksumRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ComputeChecksumRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ComputeChecksumRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Snapshot", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Snapshot = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ComputeChecksumResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ComputeChecksumResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ComputeChecksumResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChecksumID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ChecksumID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExportStorage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExportStorage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExportStorage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Provider", wireType)
			}
			m.Provider = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Provider |= (ExportStorageProvider(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalFile", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.LocalFile.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpPath", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.HttpPath.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GoogleCloudConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GoogleCloudConfig == nil {
				m.GoogleCloudConfig = &ExportStorage_GCS{}
			}
			if err := m.GoogleCloudConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field S3Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.S3Config == nil {
				m.S3Config = &ExportStorage_S3{}
			}
			if err := m.S3Config.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AzureConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AzureConfig == nil {
				m.AzureConfig = &ExportStorage_Azure{}
			}
			if err := m.AzureConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExportStorage_LocalFilePath) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LocalFilePath: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LocalFilePath: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExportStorage_Http) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Http: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Http: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BaseUri", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BaseUri = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExportStorage_S3) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: S3: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: S3: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bucket", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bucket = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Prefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccessKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Secret", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Secret = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TempToken", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TempToken = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Region", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Region = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExportStorage_GCS) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GCS: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GCS: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bucket", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bucket = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Prefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Auth", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Auth = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BillingProject", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BillingProject = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExportStorage_Azure) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Azure: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Azure: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Container", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Container = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Prefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccountName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccountName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccountKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccountKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WriteBatchRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WriteBatchRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WriteBatchRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataSpan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.DataSpan.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WriteBatchResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WriteBatchResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WriteBatchResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExportRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExportRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExportRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Storage", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Storage.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.StartTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MVCCFilter", wireType)
			}
			m.MVCCFilter = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MVCCFilter |= (MVCCFilter(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReturnSST", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ReturnSST = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OmitChecksum", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.OmitChecksum = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BulkOpSummary) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BulkOpSummary: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BulkOpSummary: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataSize", wireType)
			}
			m.DataSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DataSize |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rows", wireType)
			}
			m.Rows = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Rows |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IndexEntries", wireType)
			}
			m.IndexEntries = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IndexEntries |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SystemRecords", wireType)
			}
			m.SystemRecords = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SystemRecords |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExportResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExportResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExportResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Files", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Files = append(m.Files, ExportResponse_File{})
			if err := m.Files[len(m.Files)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.StartTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExportResponse_File) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: File: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: File: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sha512", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sha512 = append(m.Sha512[:0], dAtA[iNdEx:postIndex]...)
			if m.Sha512 == nil {
				m.Sha512 = []byte{}
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Exported", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Exported.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SST", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SST = append(m.SST[:0], dAtA[iNdEx:postIndex]...)
			if m.SST == nil {
				m.SST = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ImportRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ImportRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ImportRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Files", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Files = append(m.Files, ImportRequest_File{})
			if err := m.Files[len(m.Files)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataSpan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.DataSpan.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rekeys", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Rekeys = append(m.Rekeys, ImportRequest_TableRekey{})
			if err := m.Rekeys[len(m.Rekeys)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.EndTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ImportRequest_File) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: File: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: File: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dir", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Dir.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sha512", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sha512 = append(m.Sha512[:0], dAtA[iNdEx:postIndex]...)
			if m.Sha512 == nil {
				m.Sha512 = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ImportRequest_TableRekey) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TableRekey: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TableRekey: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OldID", wireType)
			}
			m.OldID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.OldID |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NewDesc", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NewDesc = append(m.NewDesc[:0], dAtA[iNdEx:postIndex]...)
			if m.NewDesc == nil {
				m.NewDesc = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ImportResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ImportResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ImportResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Imported", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Imported.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminScatterRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminScatterRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminScatterRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RandomizeLeases", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RandomizeLeases = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminScatterResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminScatterResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminScatterResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ranges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ranges = append(m.Ranges, AdminScatterResponse_Range{})
			if err := m.Ranges[len(m.Ranges)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminScatterResponse_Range) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Range: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Range: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AddSSTableRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AddSSTableRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AddSSTableRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AddSSTableResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AddSSTableResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AddSSTableResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RefreshRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RefreshRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RefreshRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Write", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Write = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RefreshResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RefreshResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RefreshResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RefreshRangeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RefreshRangeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RefreshRangeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Write", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Write = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RefreshRangeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RefreshRangeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RefreshRangeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SubsumeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SubsumeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SubsumeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeftRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.LeftRange.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SubsumeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SubsumeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SubsumeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MVCCStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.MVCCStats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeaseAppliedIndex", wireType)
			}
			m.LeaseAppliedIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LeaseAppliedIndex |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FreezeStart", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.FreezeStart.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeStatsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeStatsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeStatsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeStatsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeStatsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeStatsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MVCCStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.MVCCStats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestUnion) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestUnion: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestUnion: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Get", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &GetRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_Get{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Put", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &PutRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_Put{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConditionalPut", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ConditionalPutRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_ConditionalPut{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Increment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &IncrementRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_Increment{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Delete", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &DeleteRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_Delete{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeleteRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &DeleteRangeRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_DeleteRange{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ScanRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_Scan{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BeginTransaction", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &BeginTransactionRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_BeginTransaction{v}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTransaction", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &EndTransactionRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_EndTransaction{v}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminSplit", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AdminSplitRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_AdminSplit{v}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminMerge", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AdminMergeRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_AdminMerge{v}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeartbeatTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &HeartbeatTxnRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_HeartbeatTxn{v}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &GCRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_Gc{v}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PushTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &PushTxnRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_PushTxn{v}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResolveIntent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ResolveIntentRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_ResolveIntent{v}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResolveIntentRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ResolveIntentRangeRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_ResolveIntentRange{v}
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Merge", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MergeRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_Merge{v}
			iNdEx = postIndex
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TruncateLog", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TruncateLogRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_TruncateLog{v}
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestLease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RequestLeaseRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_RequestLease{v}
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReverseScan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ReverseScanRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_ReverseScan{v}
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ComputeChecksum", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ComputeChecksumRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_ComputeChecksum{v}
			iNdEx = postIndex
		case 24:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CheckConsistency", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &CheckConsistencyRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_CheckConsistency{v}
			iNdEx = postIndex
		case 26:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitPut", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &InitPutRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_InitPut{v}
			iNdEx = postIndex
		case 28:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TransferLease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TransferLeaseRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_TransferLease{v}
			iNdEx = postIndex
		case 29:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminTransferLease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AdminTransferLeaseRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_AdminTransferLease{v}
			iNdEx = postIndex
		case 30:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeaseInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &LeaseInfoRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_LeaseInfo{v}
			iNdEx = postIndex
		case 31:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WriteBatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &WriteBatchRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_WriteBatch{v}
			iNdEx = postIndex
		case 32:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Export", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ExportRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_Export{v}
			iNdEx = postIndex
		case 33:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueryTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &QueryTxnRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_QueryTxn{v}
			iNdEx = postIndex
		case 34:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Import", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ImportRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_Import{v}
			iNdEx = postIndex
		case 35:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminChangeReplicas", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AdminChangeReplicasRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_AdminChangeReplicas{v}
			iNdEx = postIndex
		case 36:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminScatter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AdminScatterRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_AdminScatter{v}
			iNdEx = postIndex
		case 37:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AddSstable", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AddSSTableRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_AddSstable{v}
			iNdEx = postIndex
		case 38:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClearRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ClearRangeRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_ClearRange{v}
			iNdEx = postIndex
		case 39:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RecomputeStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RecomputeStatsRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_RecomputeStats{v}
			iNdEx = postIndex
		case 40:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Refresh", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RefreshRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_Refresh{v}
			iNdEx = postIndex
		case 41:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RefreshRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RefreshRangeRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_RefreshRange{v}
			iNdEx = postIndex
		case 42:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueryIntent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &QueryIntentRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_QueryIntent{v}
			iNdEx = postIndex
		case 43:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subsume", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &SubsumeRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_Subsume{v}
			iNdEx = postIndex
		case 44:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RangeStatsRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_RangeStats{v}
			iNdEx = postIndex
		case 45:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminRelocateRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AdminRelocateRangeRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_AdminRelocateRange{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResponseUnion) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResponseUnion: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResponseUnion: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Get", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &GetResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_Get{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Put", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &PutResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_Put{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConditionalPut", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ConditionalPutResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_ConditionalPut{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Increment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &IncrementResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_Increment{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Delete", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &DeleteResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_Delete{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeleteRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &DeleteRangeResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_DeleteRange{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ScanResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_Scan{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BeginTransaction", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &BeginTransactionResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_BeginTransaction{v}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTransaction", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &EndTransactionResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_EndTransaction{v}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminSplit", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AdminSplitResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_AdminSplit{v}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminMerge", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AdminMergeResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_AdminMerge{v}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeartbeatTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &HeartbeatTxnResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_HeartbeatTxn{v}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &GCResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_Gc{v}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PushTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &PushTxnResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_PushTxn{v}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResolveIntent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ResolveIntentResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_ResolveIntent{v}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResolveIntentRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ResolveIntentRangeResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_ResolveIntentRange{v}
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Merge", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MergeResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_Merge{v}
			iNdEx = postIndex
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TruncateLog", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TruncateLogResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_TruncateLog{v}
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestLease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RequestLeaseResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_RequestLease{v}
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReverseScan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ReverseScanResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_ReverseScan{v}
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ComputeChecksum", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ComputeChecksumResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_ComputeChecksum{v}
			iNdEx = postIndex
		case 24:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CheckConsistency", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &CheckConsistencyResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_CheckConsistency{v}
			iNdEx = postIndex
		case 26:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitPut", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &InitPutResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_InitPut{v}
			iNdEx = postIndex
		case 29:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminTransferLease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AdminTransferLeaseResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_AdminTransferLease{v}
			iNdEx = postIndex
		case 30:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeaseInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &LeaseInfoResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_LeaseInfo{v}
			iNdEx = postIndex
		case 31:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WriteBatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &WriteBatchResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_WriteBatch{v}
			iNdEx = postIndex
		case 32:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Export", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ExportResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_Export{v}
			iNdEx = postIndex
		case 33:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueryTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &QueryTxnResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_QueryTxn{v}
			iNdEx = postIndex
		case 34:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Import", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ImportResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_Import{v}
			iNdEx = postIndex
		case 35:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminChangeReplicas", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AdminChangeReplicasResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_AdminChangeReplicas{v}
			iNdEx = postIndex
		case 36:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminScatter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AdminScatterResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_AdminScatter{v}
			iNdEx = postIndex
		case 37:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AddSstable", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AddSSTableResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_AddSstable{v}
			iNdEx = postIndex
		case 38:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClearRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ClearRangeResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_ClearRange{v}
			iNdEx = postIndex
		case 39:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RecomputeStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RecomputeStatsResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_RecomputeStats{v}
			iNdEx = postIndex
		case 40:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Refresh", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RefreshResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_Refresh{v}
			iNdEx = postIndex
		case 41:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RefreshRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RefreshRangeResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_RefreshRange{v}
			iNdEx = postIndex
		case 42:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueryIntent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &QueryIntentResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_QueryIntent{v}
			iNdEx = postIndex
		case 43:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subsume", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &SubsumeResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_Subsume{v}
			iNdEx = postIndex
		case 44:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RangeStatsResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_RangeStats{v}
			iNdEx = postIndex
		case 45:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminRelocateRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AdminRelocateRangeResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_AdminRelocateRange{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Header) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Header: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Header: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Replica", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Replica.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeID", wireType)
			}
			m.RangeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeID |= (RangeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserPriority", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.UserPriority = UserPriority(math.Float64frombits(v))
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Txn == nil {
				m.Txn = &Transaction{}
			}
			if err := m.Txn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadConsistency", wireType)
			}
			m.ReadConsistency = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReadConsistency |= (ReadConsistencyType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxSpanRequestKeys", wireType)
			}
			m.MaxSpanRequestKeys = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxSpanRequestKeys |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DistinctSpans", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DistinctSpans = bool(v != 0)
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReturnRangeInfo", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ReturnRangeInfo = bool(v != 0)
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GatewayNodeID", wireType)
			}
			m.GatewayNodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GatewayNodeID |= (NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScanOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ScanOptions == nil {
				m.ScanOptions = &ScanOptions{}
			}
			if err := m.ScanOptions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AsyncConsensus", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AsyncConsensus = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BatchRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BatchRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BatchRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Header", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Header.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Requests", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Requests = append(m.Requests, RequestUnion{})
			if err := m.Requests[len(m.Requests)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BatchResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BatchResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BatchResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BatchResponse_Header", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.BatchResponse_Header.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Responses", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Responses = append(m.Responses, ResponseUnion{})
			if err := m.Responses[len(m.Responses)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BatchResponse_Header) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Header: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Header: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &Error{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Txn == nil {
				m.Txn = &Transaction{}
			}
			if err := m.Txn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Now", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Now.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CollectedSpans", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CollectedSpans = append(m.CollectedSpans, cockroach_util_tracing.RecordedSpan{})
			if err := m.CollectedSpans[len(m.CollectedSpans)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeFeedRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeFeedRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeFeedRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Header", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Header.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeFeedValue) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeFeedValue: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeFeedValue: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeFeedCheckpoint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeFeedCheckpoint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeFeedCheckpoint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResolvedTS", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResolvedTS.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeFeedError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeFeedError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeFeedError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeFeedEvent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeFeedEvent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeFeedEvent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Val", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Val == nil {
				m.Val = &RangeFeedValue{}
			}
			if err := m.Val.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Checkpoint", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Checkpoint == nil {
				m.Checkpoint = &RangeFeedCheckpoint{}
			}
			if err := m.Checkpoint.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &RangeFeedError{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipApi(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowApi
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowApi
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowApi
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthApi
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowApi
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipApi(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthApi = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowApi   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("roachpb/api.proto", fileDescriptorApi) }

var fileDescriptorApi = []byte{
	// 6008 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0x3d, 0x4b, 0x6c, 0x23, 0xc9,
	0x75, 0x6c, 0x92, 0x92, 0xc8, 0x47, 0x91, 0xa2, 0x4a, 0xf3, 0xe1, 0x68, 0x66, 0x47, 0x1a, 0xce,
	0x7f, 0xd6, 0xab, 0xf1, 0x68, 0xbc, 0x59, 0x67, 0xd7, 0x5e, 0x5b, 0xa4, 0x34, 0xa2, 0x46, 0xa3,
	0xcf, 0x16, 0xa9, 0x59, 0xcf, 0x3a, 0x9b, 0x76, 0xab, 0xbb, 0x44, 0xb5, 0x87, 0xec, 0xe6, 0x74,
	0x37, 0x47, 0xd2, 0x00, 0x41, 0x02, 0xe7, 0xe0, 0xc0, 0x30, 0x8c, 0x20, 0x09, 0x82, 0x00, 0xf9,
	0x19, 0xf0, 0x21, 0x40, 0x82, 0x18, 0x31, 0x60, 0x20, 0x48, 0x80, 0xd8, 0x97, 0x1c, 0x16, 0x41,
	0x0e, 0x4e, 0x80, 0x04, 0x41, 0x0e, 0x42, 0xa2, 0xe4, 0x60, 0xe4, 0x92, 0x43, 0xe0, 0xcb, 0x22,
	0x87, 0xa0, 0x3e, 0xfd, 0x21, 0xd9, 0xfc, 0x8c, 0xb6, 0x07, 0xd9, 0x20, 0x27, 0xb1, 0x5f, 0xd5,
	0x7b, 0x55, 0xf5, 0xde, 0xab, 0x57, 0xef, 0x55, 0xbd, 0x2a, 0xc1, 0xb4, 0x65, 0x2a, 0xea, 0x7e,
	0x6b, 0xf7, 0xae, 0xd2, 0xd2, 0x17, 0x5a, 0x96, 0xe9, 0x98, 0x68, 0x5a, 0x35, 0xd5, 0xa7, 0x0c,
	0xbc, 0x20, 0x0a, 0x67, 0x91, 0x5b, 0x4b, 0x53, 0x1c, 0x85, 0x57, 0x9b, 0x3d, 0xe3, 0xc2, 0x88,
	0x65, 0x99, 0x96, 0x2d, 0xa0, 0xe7, 0x5c, 0x68, 0x93, 0x38, 0x4a, 0xa0, 0x76, 0xd1, 0x76, 0x4c,
	0x4b, 0xa9, 0x93, 0xbb, 0xc4, 0xa8, 0xeb, 0x86, 0xfb, 0x87, 0xd6, 0x7b, 0xae, 0xaa, 0xa2, 0xce,
	0xd5, 0x41, 0x75, 0xee, 0x8b, 0x4a, 0x85, 0xb6, 0xa3, 0x37, 0xee, 0xee, 0x37, 0xd4, 0xbb, 0x8e,
	0xde, 0x24, 0xb6, 0xa3, 0x34, 0x5b, 0xa2, 0x64, 0x9e, 0x95, 0x38, 0x96, 0xa2, 0xea, 0x46, 0xfd,
	0xae, 0x45, 0x54, 0xd3, 0xd2, 0x88, 0x26, 0xdb, 0x2d, 0xc5, 0x70, 0xbb, 0x5c, 0x37, 0xeb, 0x26,
	0xfb, 0x79, 0x97, 0xfe, 0xe2, 0xd0, 0xe2, 0x2f, 0x43, 0x1a, 0x2b, 0x46, 0x9d, 0xac, 0x19, 0x7b,
	0x26, 0xfa, 0x02, 0x24, 0x35, 0x62, 0xab, 0x05, 0x69, 0x5e, 0xba, 0x95, 0x59, 0x2c, 0x2e, 0xf4,
	0xf0, 0x62, 0x81, 0xd5, 0x5d, 0x26, 0xb6, 0x6a, 0xe9, 0x2d, 0xc7, 0xb4, 0x4a, 0xc9, 0x8f, 0x8e,
	0xe7, 0x62, 0x98, 0x61, 0xa1, 0xcf, 0xc1, 0x58, 0x83, 0x28, 0x36, 0x29, 0xc4, 0x19, 0x7a, 0x21,
	0x04, 0xfd, 0x11, 0x2d, 0x17, 0x48, 0xbc, 0x72, 0xf1, 0x05, 0x64, 0x31, 0x79, 0xd6, 0x26, 0xb6,
	0x53, 0x21, 0x8a, 0x46, 0x2c, 0x74, 0x01, 0x12, 0x4f, 0xc9, 0x51, 0x21, 0x31, 0x2f, 0xdd, 0x9a,
	0x2c, 0x4d, 0x7c, 0x7c, 0x3c, 0x97, 0x58, 0x27, 0x47, 0x98, 0xc2, 0xd0, 0x3c, 0x4c, 0x10, 0x43,
	0x93, 0x69, 0x71, 0xb2, 0xb3, 0x78, 0x9c, 0x18, 0xda, 0x3a, 0x39, 0x42, 0xb3, 0x90, 0xb2, 0x29,
	0x35, 0x43, 0x25, 0x85, 0xb1, 0x79, 0xe9, 0xd6, 0x18, 0xf6, 0xbe, 0xdf, 0x4e, 0xfe, 0xf4, 0xbb,
	0x73, 0xd2, 0xc3, 0x64, 0x4a, 0xca, 0xc7, 0x1f, 0x26, 0x53, 0xf1, 0x7c, 0xa2, 0xf8, 0xed, 0x04,
	0xe4, 0x30, 0xb1, 0x5b, 0xa6, 0x61, 0x13, 0xd1, 0xfa, 0x67, 0x21, 0xe1, 0x1c, 0x1a, 0xac, 0xf5,
	0xcc, 0xe2, 0xe5, 0x90, 0x21, 0xd4, 0x2c, 0xc5, 0xb0, 0x15, 0xd5, 0xd1, 0x4d, 0x03, 0xd3, 0xaa,
	0xe8, 0xf3, 0x90, 0xb1, 0x88, 0xdd, 0x6e, 0x12, 0xc6, 0x6c, 0xd6, 0xb1, 0xcc, 0xe2, 0xf9, 0x10,
	0xcc, 0x6a, 0x4b, 0x31, 0x30, 0xf0, 0xba, 0xf4, 0x37, 0xba, 0x00, 0x29, 0xa3, 0xdd, 0xa4, 0xc3,
	0xb1, 0x59, 0x67, 0x13, 0x78, 0xc2, 0x68, 0x37, 0xd7, 0xc9, 0x91, 0x8d, 0xca, 0x90, 0xb1, 0x28,
	0xab, 0x65, 0xdd, 0xd8, 0x33, 0xed, 0xc2, 0xf8, 0x7c, 0xe2, 0x56, 0x66, 0xf1, 0x52, 0x3f, 0x81,
	0x50, 0xe1, 0x09, 0xae, 0x82, 0xe5, 0x02, 0x6c, 0x54, 0x85, 0xac, 0xe8, 0x99, 0x45, 0x14, 0xdb,
	0x34, 0x0a, 0x13, 0xf3, 0xd2, 0xad, 0xdc, 0xe2, 0x42, 0x18, 0x99, 0x0e, 0x2e, 0xd0, 0xcf, 0x76,
	0x93, 0x60, 0x86, 0x85, 0x27, 0xad, 0xc0, 0x57, 0xf1, 0x09, 0x4c, 0x06, 0x4b, 0x11, 0x82, 0x1c,
	0x5e, 0xa9, 0xee, 0x6c, 0xac, 0xc8, 0x3b, 0x9b, 0xeb, 0x9b, 0x5b, 0xef, 0x6f, 0xe6, 0x63, 0xe8,
	0x0c, 0xe4, 0x05, 0x6c, 0x7d, 0xe5, 0x89, 0xfc, 0x68, 0x6d, 0x63, 0xad, 0x96, 0x97, 0xd0, 0x05,
	0x38, 0x2b, 0xa0, 0x78, 0x69, 0x73, 0x75, 0x45, 0x2e, 0x6d, 0xed, 0x6c, 0x2e, 0x2f, 0xe1, 0x27,
	0xf9, 0xf8, 0x6c, 0xf2, 0xd7, 0xbe, 0x77, 0x39, 0x56, 0x7c, 0x0c, 0xb0, 0x4a, 0x1c, 0xa1, 0x0d,
	0xa8, 0x04, 0xe3, 0xfb, 0xac, 0x37, 0x42, 0x1d, 0xe7, 0x43, 0xbb, 0x1d, 0xd0, 0x9c, 0x52, 0x8a,
	0x72, 0xe0, 0x27, 0xc7, 0x73, 0x12, 0x16, 0x98, 0x5c, 0xe4, 0xc5, 0x1f, 0x4b, 0x90, 0x61, 0x84,
	0xf9, 0x18, 0x51, 0xb9, 0x8b, 0xf2, 0x95, 0xa1, 0x0c, 0xe9, 0x25, 0x8d, 0x16, 0x60, 0xec, 0xb9,
	0xd2, 0x68, 0x0f, 0xd2, 0xf6, 0xc7, 0xb4, 0x1c, 0xf3, 0x6a, 0xe8, 0x1d, 0x98, 0xd4, 0x0d, 0x87,
	0x18, 0x8e, 0xcc, 0xd1, 0x12, 0x43, 0xd0, 0x32, 0xbc, 0x36, 0xfb, 0x28, 0xfe, 0xa5, 0x04, 0xb0,
	0xdd, 0x8e, 0x92, 0x35, 0x74, 0xb6, 0x8e, 0xd4, 0x7f, 0x77, 0xb6, 0xf2, 0x51, 0x9c, 0x83, 0x71,
	0xdd, 0x68, 0xe8, 0x06, 0xef, 0x7f, 0x0a, 0x8b, 0x2f, 0x74, 0x06, 0xc6, 0x76, 0x1b, 0xba, 0xa1,
	0x31, 0xf5, 0x4f, 0x61, 0xfe, 0x21, 0xd8, 0x8f, 0x21, 0xc3, 0xfa, 0x1e, 0x21, 0xf7, 0x8b, 0xff,
	0x2e, 0xc1, 0xd9, 0xb2, 0x69, 0x68, 0x3a, 0x9d, 0x87, 0x4a, 0xe3, 0x53, 0xc1, 0x9b, 0x37, 0x21,
	0x4d, 0x0e, 0x5b, 0x23, 0x8a, 0x37, 0x45, 0x0e, 0x5b, 0xec, 0xd7, 0x40, 0xd6, 0x7d, 0x08, 0xe7,
	0xba, 0x47, 0x19, 0x25, 0x17, 0xff, 0x5e, 0x82, 0xdc, 0x9a, 0xa1, 0x3b, 0x9f, 0x0a, 0xf6, 0x79,
	0x7c, 0x48, 0x04, 0xf8, 0x80, 0xee, 0x40, 0x7e, 0x4f, 0xd1, 0x1b, 0x5b, 0x46, 0xcd, 0x6c, 0xee,
	0xda, 0x8e, 0x69, 0x10, 0x5b, 0x30, 0xaa, 0x07, 0x2e, 0x78, 0xf6, 0x18, 0xa6, 0xbc, 0x31, 0x45,
	0xc9, 0xac, 0x17, 0x90, 0x5f, 0x33, 0x54, 0x8b, 0x34, 0x89, 0x11, 0x29, 0xb7, 0x2e, 0x41, 0x5a,
	0x77, 0xe9, 0x32, 0x8e, 0x25, 0xb0, 0x0f, 0x10, 0x63, 0x6a, 0xc3, 0x74, 0xa0, 0xed, 0x28, 0xcd,
	0xd8, 0x45, 0x48, 0x1b, 0xe4, 0x40, 0xf6, 0xe5, 0x95, 0xc0, 0x29, 0x83, 0x1c, 0x70, 0xb3, 0xf3,
	0x04, 0xb2, 0xcb, 0xa4, 0x41, 0x1c, 0x12, 0xbd, 0x4d, 0xde, 0x81, 0x9c, 0x4b, 0x3a, 0x4a, 0x21,
	0xfd, 0xbe, 0x04, 0x48, 0xd0, 0xa5, 0xeb, 0x60, 0x94, 0x72, 0x9a, 0xa3, 0xeb, 0xbc, 0xd3, 0xb6,
	0x0c, 0xbe, 0x60, 0x73, 0x2d, 0x05, 0x0e, 0x62, 0x6b, 0xb6, 0x6f, 0x1b, 0x93, 0x41, 0xdb, 0xe8,
	0xf9, 0x1d, 0xd4, 0xe3, 0x38, 0x80, 0x99, 0x8e, 0xee, 0x45, 0x2b, 0xca, 0x24, 0xeb, 0x59, 0x7c,
	0x3e, 0x11, 0x74, 0x8d, 0x18, 0xb0, 0xf8, 0x21, 0x4c, 0x97, 0x1b, 0x44, 0xb1, 0xa2, 0x66, 0x8b,
	0x10, 0xe7, 0x13, 0x40, 0x41, 0xf2, 0x51, 0x8a, 0x54, 0x87, 0x4c, 0x55, 0x55, 0x8c, 0xad, 0x16,
	0x35, 0x82, 0x36, 0xba, 0x0f, 0xe7, 0x6c, 0xc7, 0x6c, 0xc9, 0x8a, 0x23, 0x73, 0x0f, 0x69, 0xd7,
	0x6c, 0x1b, 0x9a, 0x62, 0x1d, 0xb1, 0x36, 0x52, 0x78, 0x86, 0x96, 0x2e, 0x39, 0xac, 0x23, 0x25,
	0x51, 0x44, 0x65, 0xd7, 0xd4, 0x0d, 0x99, 0x3a, 0x32, 0x0d, 0xc7, 0x16, 0x7a, 0x0e, 0x4d, 0xdd,
	0xc0, 0x1c, 0x22, 0x46, 0xf1, 0x3d, 0x89, 0xb7, 0x15, 0xa5, 0xda, 0xbc, 0x0b, 0x19, 0x5b, 0x55,
	0x0c, 0x79, 0xcf, 0xb4, 0x9a, 0x8a, 0xc3, 0x54, 0x23, 0xb7, 0xf8, 0x5a, 0x98, 0x7b, 0xa8, 0x2a,
	0xc6, 0x03, 0x56, 0x09, 0x83, 0xed, 0xfd, 0x0e, 0x6a, 0xcf, 0xc3, 0x64, 0x2a, 0x91, 0x4f, 0x16,
	0x7f, 0x26, 0xc1, 0x24, 0xef, 0x65, 0x94, 0xda, 0xf3, 0x26, 0x24, 0x2d, 0xf3, 0x80, 0x6b, 0x4f,
	0x66, 0xf1, 0x62, 0x08, 0x89, 0x75, 0x72, 0x14, 0x34, 0xdb, 0xac, 0x3a, 0x2a, 0x81, 0x70, 0x54,
	0x64, 0x86, 0x9d, 0x18, 0x15, 0x1b, 0x38, 0x16, 0xa6, 0x34, 0xae, 0x43, 0x6e, 0x57, 0x71, 0xd4,
	0x7d, 0x2a, 0x1f, 0xd6, 0x49, 0xee, 0xdd, 0xe3, 0x2c, 0x83, 0xba, 0x3d, 0x2f, 0xfe, 0xb1, 0x04,
	0x08, 0x93, 0xe7, 0xc4, 0xb2, 0xc9, 0xa7, 0x5f, 0x48, 0xff, 0x2d, 0xc1, 0x4c, 0x47, 0x67, 0xff,
	0x7f, 0xc9, 0xea, 0x57, 0x24, 0x38, 0x5f, 0xde, 0x27, 0xea, 0xd3, 0xb2, 0x69, 0xd8, 0xba, 0xed,
	0x10, 0x43, 0x3d, 0x8a, 0x52, 0x60, 0x17, 0x21, 0x7d, 0xa0, 0x3b, 0xfb, 0xb2, 0xa6, 0xef, 0xed,
	0xb1, 0xe9, 0x9c, 0xc2, 0x29, 0x0a, 0x58, 0xd6, 0xf7, 0xf6, 0xc4, 0x64, 0x96, 0xa1, 0xd0, 0xdb,
	0x83, 0x68, 0x1d, 0x82, 0xb3, 0x98, 0xa8, 0x66, 0xb3, 0xd5, 0x76, 0x48, 0xd5, 0x51, 0x1c, 0x3b,
	0xca, 0x01, 0x9e, 0x87, 0x09, 0xcd, 0x3a, 0x92, 0xad, 0xb6, 0x21, 0x86, 0x37, 0xae, 0x59, 0x47,
	0xb8, 0x6d, 0x88, 0xc1, 0xfd, 0xb9, 0x04, 0xe7, 0xba, 0x1b, 0x8f, 0x52, 0xc3, 0xbe, 0x02, 0x19,
	0x45, 0xd3, 0x88, 0x26, 0x6b, 0xa4, 0xe1, 0x28, 0xc2, 0x91, 0xbb, 0x17, 0xa0, 0x24, 0x76, 0x2b,
	0x16, 0xf8, 0x36, 0xc5, 0x82, 0xbb, 0x5b, 0xb1, 0xb0, 0xf1, 0xb8, 0x5c, 0x66, 0xfd, 0x59, 0xa6,
	0x88, 0xae, 0x02, 0x31, 0x5a, 0x0c, 0x52, 0x54, 0xe1, 0x7c, 0x89, 0xd4, 0x75, 0x23, 0x18, 0x47,
	0x47, 0xbe, 0x1c, 0xc9, 0x50, 0xe8, 0x6d, 0x24, 0x4a, 0xd9, 0xff, 0x5d, 0x02, 0xce, 0xae, 0x18,
	0xda, 0xab, 0x19, 0x04, 0xf5, 0x24, 0x54, 0xb3, 0xd9, 0xd4, 0x1d, 0x57, 0xf6, 0xfc, 0x0b, 0xfd,
	0x3c, 0xa4, 0x34, 0xa2, 0x68, 0x5e, 0xfc, 0x95, 0xe9, 0xb0, 0x51, 0x6d, 0x47, 0x6f, 0x2c, 0xec,
	0x37, 0xd4, 0x85, 0x9a, 0xbb, 0x37, 0x84, 0xbd, 0xea, 0xe8, 0x6b, 0x70, 0x9e, 0xce, 0x62, 0xcb,
	0x50, 0x1a, 0x32, 0xa7, 0x26, 0x3b, 0x96, 0x5e, 0xaf, 0x13, 0x4b, 0xec, 0x58, 0xdc, 0x0a, 0xe9,
	0xe7, 0x9a, 0xc0, 0x28, 0x33, 0x84, 0x1a, 0xaf, 0x8f, 0xcf, 0xea, 0x61, 0x60, 0xf4, 0x65, 0x2f,
	0xc0, 0xb5, 0x5b, 0x8a, 0x61, 0x17, 0xc6, 0x98, 0x79, 0xe9, 0xb7, 0x11, 0x22, 0x34, 0x43, 0x18,
	0x24, 0x0a, 0xb1, 0xd1, 0x5d, 0xea, 0x61, 0x3d, 0x6b, 0xeb, 0x16, 0x91, 0xef, 0xb5, 0xd4, 0xc2,
	0x38, 0x1d, 0x7b, 0x29, 0x77, 0x72, 0x3c, 0x07, 0x98, 0x83, 0xef, 0x6d, 0x97, 0xa9, 0xc7, 0xc5,
	0x7f, 0xb7, 0x54, 0x74, 0x0b, 0xf2, 0x86, 0x29, 0x5b, 0x64, 0xcf, 0x22, 0xf6, 0xbe, 0x68, 0x36,
	0xc5, 0x38, 0x96, 0x33, 0x4c, 0xcc, 0xc1, 0x9c, 0xf4, 0x39, 0x18, 0x6f, 0x99, 0xba, 0x6d, 0x1a,
	0x85, 0x34, 0xe7, 0x28, 0xff, 0xf2, 0x0c, 0xf7, 0x44, 0x3e, 0x55, 0xfc, 0x4d, 0x09, 0xce, 0x75,
	0xcb, 0x34, 0xca, 0x39, 0x75, 0x0b, 0xf2, 0xa6, 0x41, 0xe4, 0xd6, 0xbe, 0x62, 0x13, 0x21, 0x03,
	0xe1, 0x29, 0xe6, 0x4c, 0x83, 0x6c, 0x53, 0x30, 0xe7, 0x68, 0xc7, 0x42, 0xf2, 0xab, 0x12, 0x4c,
	0x2f, 0x69, 0x4d, 0xdd, 0xa8, 0xb6, 0x1a, 0x7a, 0xa4, 0x81, 0xc7, 0x35, 0x48, 0xdb, 0x94, 0x26,
	0xdb, 0x4f, 0x8b, 0x77, 0xee, 0xa7, 0xa5, 0x58, 0xc9, 0x3a, 0x39, 0xf2, 0xfd, 0xbb, 0x60, 0x27,
	0xa2, 0x9c, 0x4a, 0x1f, 0x8a, 0xf1, 0x6d, 0x10, 0xeb, 0x15, 0x79, 0xa6, 0x41, 0xf2, 0x51, 0xf6,
	0xfc, 0x5b, 0x12, 0x5c, 0x60, 0xb4, 0x99, 0xca, 0xec, 0x11, 0x8b, 0x6d, 0x6f, 0x46, 0x29, 0xa2,
	0xab, 0x30, 0xee, 0x28, 0x56, 0x9d, 0x70, 0x43, 0x30, 0x56, 0xca, 0x7c, 0x7c, 0x3c, 0x37, 0x51,
	0x75, 0x4c, 0x8b, 0xac, 0x2d, 0x63, 0x51, 0x24, 0xc6, 0xa9, 0xc0, 0x6c, 0x58, 0x5f, 0xa2, 0x1c,
	0xef, 0x7f, 0x49, 0xa2, 0x8d, 0xf2, 0x3e, 0x77, 0xf3, 0x5b, 0x0d, 0x5d, 0x55, 0x22, 0x5d, 0xf6,
	0x56, 0x20, 0xa3, 0x32, 0xe2, 0xb2, 0x73, 0xd4, 0xe2, 0x01, 0x69, 0x6e, 0xf1, 0x5a, 0x28, 0x21,
	0xd6, 0x38, 0xef, 0x49, 0xed, 0xa8, 0x45, 0x30, 0xa8, 0xde, 0x6f, 0xb4, 0x0c, 0x13, 0x9c, 0x39,
	0xae, 0x97, 0x33, 0x80, 0x04, 0x9d, 0xe8, 0x35, 0x56, 0x59, 0xd8, 0x24, 0x17, 0x55, 0x30, 0x76,
	0x17, 0x2e, 0x86, 0x0e, 0x3a, 0x4a, 0xce, 0xfe, 0x89, 0xab, 0x49, 0x98, 0x34, 0x4c, 0x55, 0x79,
	0x05, 0xd1, 0x6b, 0x80, 0x23, 0xf1, 0x4f, 0xca, 0x11, 0x57, 0xd5, 0xba, 0x3a, 0x1b, 0x25, 0x43,
	0x7e, 0x5b, 0x82, 0x99, 0x0a, 0x51, 0x2c, 0x67, 0x97, 0x28, 0x4e, 0xed, 0x30, 0xd2, 0xd5, 0xf5,
	0x4d, 0x48, 0x18, 0xe6, 0x81, 0xf0, 0x69, 0x06, 0x2f, 0xa0, 0x62, 0xfc, 0xb4, 0xbe, 0x18, 0xfb,
	0x57, 0xe1, 0x4c, 0x67, 0xbf, 0xa2, 0x1c, 0xf5, 0x0f, 0x12, 0x90, 0x5e, 0x2d, 0x47, 0x39, 0xd6,
	0x2f, 0x88, 0x3d, 0x01, 0x3e, 0x0b, 0xc2, 0x4e, 0x74, 0xbc, 0xf6, 0x16, 0x56, 0xcb, 0xeb, 0xe4,
	0xc8, 0x0d, 0x18, 0x28, 0x16, 0x5a, 0x82, 0xb4, 0xb3, 0x4f, 0x17, 0x51, 0xb3, 0xa1, 0x09, 0x37,
	0x61, 0x24, 0x7e, 0xf9, 0x58, 0xa8, 0x01, 0x67, 0x9d, 0x43, 0x83, 0xad, 0xcd, 0x72, 0x5d, 0x95,
	0x7d, 0x72, 0x63, 0xa3, 0x90, 0x9b, 0xa5, 0xe4, 0x4e, 0x8e, 0xe7, 0x50, 0xed, 0xd0, 0xa0, 0x0b,
	0xf9, 0x6a, 0xb9, 0xe6, 0x12, 0xc0, 0xc8, 0x11, 0x30, 0xd5, 0x83, 0xcd, 0x3e, 0x85, 0x31, 0x36,
	0x0a, 0xf7, 0x10, 0x49, 0x0a, 0x39, 0x44, 0xa2, 0x83, 0x72, 0x1b, 0x78, 0x19, 0x25, 0xf0, 0xb1,
	0xb8, 0x2a, 0x08, 0x85, 0x78, 0x0f, 0x80, 0xb2, 0x30, 0x4a, 0x35, 0xf8, 0x51, 0x02, 0x72, 0xdb,
	0x6d, 0x7b, 0x3f, 0x62, 0xbd, 0x2f, 0x03, 0xb4, 0xda, 0xf6, 0x3e, 0xb1, 0x64, 0xe7, 0xd0, 0x10,
	0x23, 0x1f, 0x72, 0xc2, 0xe5, 0x0e, 0x9d, 0xe3, 0xd5, 0x0e, 0x0d, 0xb4, 0x25, 0x88, 0x10, 0xd9,
	0x3f, 0x26, 0xbb, 0x33, 0x42, 0x5c, 0x50, 0x3b, 0x34, 0x36, 0x88, 0x17, 0x10, 0x70, 0x82, 0x84,
	0x12, 0xfc, 0x02, 0x4c, 0xd0, 0x0f, 0xd9, 0x31, 0x5f, 0x46, 0xc3, 0xc6, 0x29, 0x4e, 0xcd, 0x74,
	0xe7, 0xf2, 0xd8, 0xcb, 0xcd, 0x65, 0xf4, 0x0e, 0xa4, 0x79, 0xa3, 0x74, 0x91, 0x19, 0x67, 0x8b,
	0x4c, 0x18, 0x27, 0x84, 0x10, 0xd8, 0xf2, 0x92, 0x62, 0x2d, 0xd2, 0xc5, 0xe5, 0x0c, 0x8c, 0xed,
	0x99, 0x96, 0x4a, 0xd8, 0x71, 0x5a, 0x0a, 0xf3, 0x0f, 0xcf, 0x93, 0x4c, 0xe5, 0xd3, 0xc5, 0xdf,
	0x95, 0x60, 0xca, 0x13, 0x60, 0x94, 0x2e, 0x64, 0xb9, 0x83, 0xfb, 0x2f, 0x2f, 0x42, 0xca, 0xf1,
	0xe2, 0xf7, 0xe3, 0x30, 0xf5, 0x5e, 0x9b, 0x58, 0x47, 0x11, 0xeb, 0x57, 0x89, 0x1f, 0x9d, 0xc6,
	0x4f, 0xa9, 0x13, 0xec, 0x30, 0xf5, 0x06, 0x4c, 0x1d, 0x28, 0xba, 0x23, 0xef, 0x99, 0x96, 0xdc,
	0x6e, 0x69, 0x8a, 0xe3, 0x1e, 0x34, 0x65, 0x29, 0xf8, 0x81, 0x69, 0xed, 0x30, 0x20, 0x22, 0x80,
	0x9e, 0x1a, 0xe6, 0x81, 0x21, 0x53, 0xb0, 0x6e, 0xd4, 0x29, 0x3f, 0xec, 0x42, 0x92, 0xed, 0x7c,
	0xbe, 0xf5, 0xcf, 0xc7, 0x73, 0xf7, 0xeb, 0xba, 0xb3, 0xdf, 0xde, 0x5d, 0x50, 0xcd, 0xe6, 0x5d,
	0xaf, 0x23, 0xda, 0xae, 0xff, 0xfb, 0x6e, 0xeb, 0x69, 0xfd, 0x2e, 0x3b, 0x33, 0x6f, 0xb7, 0x75,
	0x6d, 0x61, 0x67, 0x67, 0x6d, 0x19, 0xe7, 0x19, 0xc9, 0xf7, 0x39, 0xc5, 0xda, 0xa1, 0xe1, 0xae,
	0x77, 0x1f, 0x4b, 0x90, 0xf7, 0x19, 0x16, 0xa5, 0x3c, 0x57, 0x20, 0xf3, 0xac, 0x4d, 0x2c, 0x9d,
	0x68, 0x2f, 0x2d, 0x50, 0x10, 0x88, 0x74, 0x0e, 0x7d, 0x00, 0x93, 0x1d, 0x7c, 0x48, 0x7c, 0x32,
	0x3e, 0x64, 0x0e, 0x7c, 0x16, 0x14, 0x7f, 0x14, 0x07, 0xc4, 0x06, 0xbf, 0xc6, 0x37, 0x81, 0x3e,
	0x65, 0x0a, 0xf3, 0x18, 0x40, 0xdf, 0x93, 0x9b, 0xba, 0x6d, 0xeb, 0x46, 0x9d, 0xe9, 0x4a, 0x6e,
	0xf1, 0xad, 0x90, 0xbe, 0xf4, 0x0e, 0x61, 0x61, 0x6d, 0x6f, 0x83, 0xa3, 0x95, 0xc8, 0xbe, 0xf2,
	0x5c, 0x37, 0x2d, 0x9c, 0xd6, 0x5d, 0x50, 0xb1, 0x04, 0xd3, 0x3d, 0xe5, 0x28, 0x07, 0xb0, 0xbc,
	0x25, 0x6f, 0x6e, 0xd5, 0x2a, 0x6b, 0x9b, 0xab, 0xf9, 0x18, 0xca, 0xc3, 0x24, 0x5e, 0xa9, 0xed,
	0xe0, 0x4d, 0x79, 0x05, 0xe3, 0x2d, 0x9c, 0x97, 0x50, 0x06, 0x26, 0xb6, 0xf1, 0xca, 0xe3, 0x95,
	0xcd, 0x5a, 0x3e, 0x2e, 0xb4, 0xe7, 0x97, 0x60, 0xa6, 0xa3, 0xf1, 0x28, 0xf5, 0xe7, 0x0a, 0x4c,
	0xee, 0x99, 0x6d, 0x43, 0x93, 0x79, 0x18, 0x2d, 0xb6, 0x0b, 0x32, 0x0c, 0xc6, 0xdb, 0x2b, 0x7e,
	0x33, 0x0e, 0x67, 0x30, 0xb1, 0xcd, 0xc6, 0x73, 0x12, 0xbd, 0x04, 0xb7, 0x40, 0xec, 0x0d, 0xca,
	0x9f, 0x44, 0x90, 0x69, 0x4e, 0x83, 0xaf, 0x06, 0xe3, 0xb6, 0xa3, 0x38, 0x6d, 0x5b, 0x88, 0xf2,
	0xda, 0xe0, 0xb9, 0x50, 0x65, 0x75, 0xb1, 0xc0, 0x09, 0x44, 0xf9, 0xc9, 0xde, 0x28, 0xbf, 0xf8,
	0x0b, 0x70, 0xb6, 0x8b, 0x11, 0x51, 0x2e, 0xda, 0xff, 0x18, 0x87, 0x0b, 0x9d, 0xe4, 0xa3, 0x76,
	0xe1, 0xff, 0x6f, 0x30, 0x1b, 0x55, 0x20, 0xdb, 0xd4, 0x0d, 0xd9, 0xf7, 0xb1, 0x5e, 0x62, 0x71,
	0x9e, 0xa4, 0x01, 0x6c, 0xa7, 0x9b, 0x45, 0xa3, 0x8d, 0x30, 0xbe, 0x46, 0x29, 0xbb, 0xef, 0x48,
	0x30, 0x19, 0xf5, 0xf6, 0xc3, 0xe9, 0x4e, 0xc1, 0xc5, 0x98, 0x6b, 0x90, 0x7d, 0x05, 0xfb, 0x15,
	0x7f, 0x24, 0x01, 0xaa, 0x59, 0x6d, 0x83, 0xc6, 0x6c, 0x8f, 0xcc, 0x7a, 0x94, 0x83, 0x3d, 0x03,
	0x63, 0xba, 0xa1, 0x91, 0x43, 0x36, 0xd8, 0x24, 0xe6, 0x1f, 0xe8, 0x1e, 0xa4, 0x44, 0x16, 0x13,
	0x3f, 0xd5, 0x4f, 0x94, 0xce, 0x9d, 0x1c, 0xcf, 0x4d, 0xf0, 0x9c, 0xa5, 0xe5, 0x8f, 0xfd, 0x9f,
	0x78, 0x82, 0xa7, 0x2d, 0xb9, 0x79, 0x0f, 0x1f, 0xc0, 0x4c, 0x47, 0x47, 0xa3, 0xe4, 0xc2, 0xf7,
	0xe3, 0x30, 0x23, 0x86, 0x13, 0xf9, 0x7e, 0xcd, 0xa9, 0x52, 0xe0, 0xd0, 0x17, 0x01, 0x5a, 0x16,
	0x79, 0x2e, 0x73, 0xd4, 0xc4, 0x48, 0xa8, 0x69, 0x8a, 0xc1, 0x00, 0xe8, 0x2b, 0x30, 0x45, 0x27,
	0x5c, 0xcb, 0x32, 0x5b, 0xa6, 0x4d, 0x3d, 0x09, 0x7b, 0x34, 0x4f, 0x7a, 0xfa, 0xe4, 0x78, 0x2e,
	0xbb, 0xa1, 0x1b, 0xdb, 0x02, 0xb1, 0x56, 0xc5, 0x74, 0xe6, 0x7a, 0x9f, 0xae, 0xfb, 0xf3, 0x0f,
	0x12, 0x9c, 0x79, 0x65, 0x3b, 0x5c, 0xff, 0x1b, 0x1c, 0xf3, 0xd6, 0x83, 0x3c, 0xfb, 0x5c, 0x33,
	0xf6, 0xcc, 0xe8, 0xf7, 0x1d, 0xbf, 0x23, 0xc1, 0x74, 0x80, 0x7c, 0x94, 0xab, 0xfe, 0xe9, 0x12,
	0x2d, 0xbf, 0x4a, 0xfd, 0x80, 0xa0, 0xda, 0x47, 0x39, 0xa9, 0xfe, 0x40, 0x82, 0x73, 0x65, 0x7e,
	0x1a, 0xc5, 0x0e, 0xdd, 0xec, 0x76, 0x33, 0x4a, 0x2d, 0x29, 0xc0, 0xc4, 0x73, 0x62, 0xd9, 0xba,
	0xc9, 0xd7, 0xbd, 0x2c, 0x76, 0x3f, 0x59, 0xc2, 0xa7, 0xa1, 0xb4, 0xec, 0x7d, 0xd3, 0xdd, 0x4c,
	0xf7, 0xbe, 0xbd, 0x90, 0x2c, 0x91, 0x4f, 0x16, 0xff, 0x46, 0x82, 0xf3, 0x3d, 0x1d, 0x8c, 0x52,
	0x28, 0x5f, 0x87, 0x8c, 0x2a, 0x08, 0x53, 0x73, 0xc7, 0xf7, 0xd3, 0xd7, 0x68, 0xb5, 0x53, 0xba,
	0xe1, 0x27, 0xc7, 0x73, 0xe0, 0x76, 0x75, 0x6d, 0x19, 0x83, 0x4b, 0x7d, 0x4d, 0x2b, 0xfe, 0x6c,
	0x02, 0xb2, 0x2b, 0x87, 0x2d, 0xd3, 0x72, 0xaa, 0x7c, 0xcd, 0x47, 0xcb, 0x90, 0x6a, 0x59, 0xe6,
	0x73, 0xdd, 0x1d, 0x44, 0x2e, 0xf4, 0x3c, 0xa7, 0x03, 0x67, 0x5b, 0xd4, 0xc7, 0x1e, 0x26, 0xc2,
	0x90, 0x7e, 0x64, 0xaa, 0x4a, 0xe3, 0x81, 0xde, 0x70, 0x95, 0x6b, 0x61, 0x18, 0x99, 0x05, 0x0f,
	0x63, 0x5b, 0x71, 0xf6, 0xdd, 0xb9, 0xe6, 0x01, 0xd1, 0x2a, 0xa4, 0x2a, 0x8e, 0xd3, 0xa2, 0x85,
	0x62, 0xa2, 0x5e, 0x1f, 0x4a, 0x92, 0x22, 0x08, 0x4a, 0x1e, 0x32, 0xc2, 0x30, 0xbd, 0x6a, 0x9a,
	0xf5, 0x06, 0x29, 0x37, 0xcc, 0xb6, 0x56, 0x36, 0x8d, 0x3d, 0xbd, 0x2e, 0x0c, 0xdd, 0xb5, 0xa1,
	0x14, 0x57, 0xcb, 0x55, 0xdc, 0x8b, 0x8e, 0xbe, 0x04, 0xa9, 0xea, 0x7d, 0x41, 0x8a, 0xbb, 0x29,
	0x57, 0x87, 0x92, 0xaa, 0xde, 0xc7, 0x1e, 0x12, 0xaa, 0x40, 0x66, 0xe9, 0x45, 0xdb, 0x22, 0x82,
	0xc6, 0x38, 0xa3, 0x71, 0x63, 0x28, 0x0d, 0x86, 0x83, 0x83, 0xa8, 0xb3, 0xb7, 0x21, 0xdb, 0xc1,
	0x49, 0x84, 0x20, 0xd9, 0xa2, 0x4c, 0xa3, 0xe2, 0x4c, 0x63, 0xf6, 0x9b, 0x6b, 0xf4, 0xec, 0x0d,
	0x48, 0x52, 0xae, 0xd0, 0x59, 0xb1, 0xab, 0xd8, 0x64, 0xc7, 0xd2, 0x45, 0x25, 0xf7, 0x53, 0xd4,
	0xfb, 0x6b, 0x09, 0xe2, 0xd5, 0xfb, 0xd4, 0x51, 0xdb, 0x6d, 0xab, 0x4f, 0x89, 0x23, 0x6a, 0x89,
	0x2f, 0xe6, 0xc0, 0x59, 0x64, 0x4f, 0xe7, 0x8b, 0x76, 0x1a, 0x8b, 0x2f, 0xf4, 0x1a, 0x80, 0xa2,
	0xaa, 0xc4, 0xb6, 0x65, 0x37, 0x0f, 0x3b, 0x8d, 0xd3, 0x1c, 0xb2, 0x4e, 0x8e, 0x28, 0x9a, 0x4d,
	0x54, 0x8b, 0xf0, 0xf9, 0x96, 0xc6, 0xe2, 0x8b, 0xa2, 0x39, 0xa4, 0xd9, 0x92, 0x1d, 0xf3, 0x29,
	0x31, 0x18, 0x37, 0xd3, 0x38, 0x4d, 0x21, 0x35, 0x0a, 0xa0, 0x13, 0x95, 0x18, 0x5a, 0xcb, 0xd4,
	0x0d, 0x87, 0xb1, 0x29, 0x8d, 0xbd, 0x6f, 0x4a, 0xd2, 0x22, 0x75, 0x5d, 0x64, 0x28, 0xa7, 0xb1,
	0xf8, 0x12, 0xc3, 0x38, 0x84, 0xc4, 0x6a, 0xb9, 0xfa, 0xd2, 0xc3, 0x40, 0x90, 0x54, 0xda, 0x42,
	0xe9, 0xd2, 0x98, 0xfd, 0x46, 0x37, 0x61, 0x6a, 0x57, 0x6f, 0x34, 0x68, 0xa0, 0xdc, 0xb2, 0xcc,
	0xaf, 0x13, 0xd5, 0x1d, 0x44, 0x4e, 0x80, 0xb7, 0x39, 0x54, 0xb4, 0xfc, 0x4d, 0x09, 0xc6, 0x98,
	0x8c, 0xd0, 0x25, 0x48, 0xab, 0xa6, 0xe1, 0x28, 0xba, 0x21, 0x26, 0x58, 0x1a, 0xfb, 0x80, 0xbe,
	0x5d, 0xb8, 0x02, 0x93, 0x8a, 0xaa, 0x9a, 0x6d, 0xc3, 0x91, 0x0d, 0xa5, 0x49, 0x44, 0x57, 0x32,
	0x02, 0xb6, 0xa9, 0x34, 0x09, 0x9a, 0x03, 0xf7, 0xd3, 0x4b, 0x6b, 0x4f, 0x63, 0x10, 0x20, 0xef,
	0xfc, 0x4d, 0xac, 0x29, 0x7f, 0x2a, 0xc1, 0xf4, 0xfb, 0x96, 0xee, 0x90, 0x12, 0x4f, 0xb6, 0x88,
	0xce, 0xc0, 0xbe, 0x0d, 0x69, 0x4d, 0x71, 0x14, 0x9e, 0xc2, 0x1e, 0x1f, 0x98, 0xc2, 0xee, 0x4e,
	0x4c, 0x5a, 0x9f, 0xa5, 0xb1, 0x23, 0x48, 0xd2, 0xdf, 0x3c, 0x63, 0x1f, 0xb3, 0xdf, 0xfe, 0xd9,
	0x5b, 0xb0, 0xbb, 0x51, 0x2e, 0x38, 0xdf, 0x48, 0xb8, 0x26, 0x30, 0x4a, 0x36, 0x7c, 0x19, 0x26,
	0x44, 0x14, 0x25, 0x98, 0x30, 0x3f, 0x6c, 0x2a, 0xbb, 0x27, 0x24, 0x02, 0x0d, 0x95, 0x00, 0x6c,
	0x47, 0xb1, 0x1c, 0x16, 0xff, 0x8c, 0x74, 0x48, 0xef, 0x9a, 0x4c, 0x86, 0x46, 0xa1, 0x68, 0x13,
	0x32, 0xcd, 0xe7, 0xaa, 0x2a, 0xef, 0xe9, 0x0d, 0x47, 0x9c, 0xcf, 0x87, 0x67, 0x23, 0x6d, 0x3c,
	0x2e, 0x97, 0x1f, 0xb0, 0x4a, 0xfc, 0x98, 0xdc, 0xff, 0xc6, 0x40, 0x29, 0xf0, 0xdf, 0xe8, 0x33,
	0x20, 0xd2, 0x14, 0x65, 0xdb, 0x76, 0xd8, 0xcc, 0x4c, 0x95, 0xb2, 0x27, 0xc7, 0x73, 0x69, 0xcc,
	0xa0, 0xd5, 0x6a, 0x0d, 0xa7, 0x79, 0x85, 0xaa, 0xed, 0xa0, 0xab, 0x90, 0x35, 0x9b, 0xba, 0x23,
	0xbb, 0xeb, 0x0d, 0x3f, 0x87, 0xc7, 0x93, 0x14, 0xe8, 0xae, 0x47, 0x42, 0xbe, 0xdf, 0x96, 0x20,
	0x5b, 0x6a, 0x37, 0x9e, 0x6e, 0xb5, 0xaa, 0xed, 0x66, 0x53, 0xb1, 0x8e, 0xd0, 0x45, 0x57, 0x8f,
	0xf4, 0x17, 0x84, 0xc9, 0x21, 0x21, 0x14, 0x45, 0x7f, 0x41, 0xa8, 0xa2, 0x88, 0xb4, 0x25, 0x0a,
	0xe7, 0x39, 0x49, 0x57, 0x21, 0xcb, 0x62, 0x05, 0x99, 0x18, 0x8e, 0xa5, 0x13, 0x1e, 0x8a, 0x26,
	0xf0, 0x24, 0x03, 0xae, 0x70, 0x18, 0xba, 0x0e, 0x39, 0xfb, 0xc8, 0x76, 0x48, 0x53, 0xe6, 0x17,
	0x5b, 0xb8, 0x83, 0x9b, 0xc0, 0x59, 0x0e, 0xc5, 0x1c, 0x58, 0xfc, 0xb3, 0x04, 0xe4, 0x5c, 0x9d,
	0x88, 0x72, 0x69, 0x2f, 0xc1, 0xd8, 0x9e, 0xde, 0x20, 0xee, 0xc9, 0x59, 0x7f, 0xf3, 0xee, 0x52,
	0x5a, 0xa0, 0x46, 0xdc, 0xf5, 0xbe, 0x18, 0x6a, 0x14, 0x7a, 0x31, 0xfb, 0x13, 0x09, 0x92, 0x6c,
	0x4d, 0xbd, 0x07, 0x49, 0x36, 0x51, 0xa5, 0x51, 0x26, 0x2a, 0xab, 0xea, 0xad, 0x26, 0x71, 0x7f,
	0x35, 0x61, 0x96, 0x7c, 0x5f, 0x79, 0xf3, 0xde, 0x22, 0xd3, 0x89, 0x49, 0x2c, 0xbe, 0x50, 0x09,
	0x52, 0x84, 0x8d, 0x87, 0x68, 0x62, 0x45, 0x0b, 0x9b, 0x06, 0x1d, 0x82, 0x77, 0x8d, 0x82, 0x8b,
	0x87, 0x2e, 0x40, 0x82, 0x2a, 0xdb, 0x04, 0x3f, 0x80, 0x39, 0x39, 0x9e, 0x4b, 0x50, 0x35, 0xa3,
	0x30, 0xee, 0x90, 0x3d, 0x4c, 0xa6, 0x92, 0xf9, 0xb1, 0xe2, 0x0f, 0x93, 0x90, 0x5d, 0x6b, 0x46,
	0x3d, 0x8d, 0x97, 0x3a, 0x05, 0x16, 0xe6, 0x70, 0x74, 0x34, 0x1a, 0x22, 0xaf, 0x0e, 0x83, 0x98,
	0x78, 0x39, 0x83, 0xb8, 0x46, 0x97, 0x33, 0x71, 0xab, 0x87, 0xb6, 0xff, 0xfa, 0xd0, 0xf6, 0x6b,
	0xca, 0x6e, 0x83, 0x60, 0x8a, 0xe3, 0x9e, 0x6f, 0x70, 0x02, 0xe8, 0x5d, 0xb6, 0x6a, 0x72, 0xa5,
	0x19, 0x1f, 0x5d, 0x69, 0x26, 0x88, 0xa1, 0x31, 0x95, 0x39, 0x14, 0x1a, 0xf3, 0x79, 0x48, 0x68,
	0xfa, 0x20, 0x96, 0x86, 0x19, 0x35, 0x8a, 0x32, 0x44, 0x71, 0x92, 0x41, 0xc5, 0x09, 0x3a, 0xdc,
	0xb3, 0x5b, 0x00, 0xfe, 0xa8, 0xd0, 0x3c, 0x8c, 0x9b, 0x0d, 0x8d, 0x3a, 0xc6, 0xb4, 0x0b, 0xd9,
	0x52, 0xfa, 0xe4, 0x78, 0x6e, 0x6c, 0xab, 0xa1, 0xad, 0x2d, 0xe3, 0x31, 0xb3, 0xa1, 0xad, 0x69,
	0xec, 0x32, 0x14, 0x39, 0x90, 0xd9, 0xfd, 0x33, 0xe6, 0x3c, 0xe3, 0x09, 0x83, 0x1c, 0x2c, 0x13,
	0x5b, 0x0d, 0x2e, 0x81, 0x42, 0x6d, 0xfe, 0x50, 0x82, 0x9c, 0xcb, 0xc1, 0x68, 0x67, 0x7a, 0x4a,
	0x6f, 0x0a, 0xcd, 0x4f, 0xbc, 0x9c, 0xe6, 0xbb, 0x78, 0x22, 0xd1, 0xfb, 0x5b, 0x12, 0xcc, 0xf0,
	0x8c, 0x19, 0x55, 0x71, 0xa8, 0x41, 0x8e, 0x50, 0xbd, 0x6f, 0x43, 0xde, 0x52, 0x0c, 0xcd, 0x6c,
	0xea, 0x2f, 0x08, 0x0f, 0x81, 0x6d, 0xb1, 0xf3, 0x3b, 0xe5, 0xc1, 0x59, 0x8c, 0xe7, 0x46, 0xf0,
	0xff, 0x21, 0xc1, 0x99, 0xce, 0xce, 0x44, 0xc9, 0xb4, 0x75, 0x18, 0x67, 0xbb, 0x37, 0xee, 0x74,
	0x7b, 0x23, 0x84, 0x48, 0x58, 0xeb, 0xfc, 0xee, 0x9a, 0xa7, 0xf0, 0x8c, 0xc4, 0xec, 0x97, 0x61,
	0x8c, 0x81, 0x4f, 0x61, 0xe3, 0x04, 0xe7, 0x9f, 0xc1, 0xf4, 0x92, 0xa6, 0x55, 0xab, 0x42, 0xfb,
	0xa2, 0x63, 0xbb, 0xeb, 0xe7, 0xc4, 0xc3, 0xfc, 0x9c, 0x60, 0x93, 0x51, 0xfa, 0x39, 0x2d, 0xc8,
	0x89, 0x44, 0xb6, 0x88, 0xb7, 0xeb, 0x0e, 0xa8, 0x63, 0x26, 0xd4, 0x86, 0x7f, 0xf8, 0xf7, 0x67,
	0xbc, 0x16, 0xa3, 0x1c, 0x49, 0x1b, 0x66, 0x5c, 0xba, 0x51, 0xef, 0x8c, 0x0f, 0x1a, 0x0e, 0xdb,
	0xf6, 0x08, 0x36, 0x1b, 0xe5, 0x98, 0xbe, 0x27, 0x41, 0xae, 0xda, 0xde, 0xe5, 0xd7, 0x21, 0xa3,
	0x1b, 0xcf, 0x2a, 0x40, 0x83, 0xec, 0x89, 0x0b, 0x0e, 0xc2, 0x13, 0x1d, 0xfd, 0x36, 0x6e, 0x9a,
	0xe2, 0xb2, 0x22, 0xc1, 0x82, 0x1f, 0xc6, 0x61, 0xca, 0xeb, 0x65, 0x94, 0x33, 0xff, 0x17, 0x81,
	0xb9, 0x99, 0xb2, 0xed, 0x28, 0x8e, 0x2d, 0x0c, 0xe6, 0x67, 0x5e, 0x26, 0x49, 0xb8, 0x34, 0x2d,
	0x12, 0x3c, 0xd2, 0x1e, 0x08, 0xa7, 0x29, 0x49, 0xf6, 0x13, 0x2d, 0xc0, 0x0c, 0x33, 0x6f, 0xb2,
	0xd2, 0x6a, 0x35, 0x74, 0xa2, 0xc9, 0x7c, 0x8f, 0x39, 0xc9, 0xf6, 0x98, 0xa7, 0x59, 0xd1, 0x12,
	0x2f, 0x59, 0x63, 0xfb, 0xcd, 0x0f, 0x60, 0x72, 0xcf, 0x22, 0xe4, 0x05, 0x91, 0x99, 0xd3, 0xf4,
	0x32, 0x27, 0x0f, 0x19, 0x8e, 0x58, 0xa5, 0x78, 0xc2, 0x90, 0x7c, 0x08, 0xd3, 0x8c, 0x8b, 0x51,
	0xe7, 0x76, 0x0b, 0xa9, 0xfc, 0x85, 0x04, 0x28, 0x48, 0xff, 0xd5, 0x09, 0x26, 0x1e, 0xb5, 0x60,
	0x8a, 0xbf, 0x51, 0x80, 0x49, 0x31, 0xca, 0x1d, 0x43, 0x37, 0x0d, 0x74, 0x0f, 0x12, 0x75, 0x11,
	0x99, 0x67, 0x42, 0x43, 0x15, 0xff, 0x62, 0x6f, 0x25, 0x86, 0x69, 0x5d, 0x8a, 0xd2, 0x6a, 0x3b,
	0x21, 0x19, 0x38, 0x7e, 0xf6, 0x45, 0x10, 0xa5, 0xd5, 0x76, 0x50, 0x15, 0xa6, 0x54, 0xff, 0x3a,
	0xa4, 0x4c, 0xd1, 0x13, 0x7d, 0x93, 0x97, 0x43, 0xaf, 0x87, 0x56, 0x62, 0x38, 0xa7, 0x76, 0x14,
	0xa0, 0x72, 0xf0, 0xfe, 0x5d, 0xb2, 0xef, 0x26, 0x50, 0xf7, 0xdd, 0xbf, 0x4a, 0x2c, 0x70, 0x4d,
	0x0f, 0xbd, 0x0d, 0xe3, 0x1a, 0xbb, 0xd7, 0x25, 0x74, 0x2e, 0x4c, 0x2d, 0x3a, 0xae, 0xd2, 0x55,
	0x62, 0x58, 0x60, 0xa0, 0x87, 0x30, 0xc9, 0x7f, 0x89, 0xf9, 0x3e, 0xde, 0x77, 0x97, 0xac, 0xf7,
	0x66, 0x5b, 0x25, 0x86, 0x33, 0x9a, 0x0f, 0x45, 0x9f, 0x83, 0xa4, 0xad, 0x2a, 0x7c, 0x1f, 0x25,
	0x3c, 0x93, 0x20, 0x70, 0x75, 0xa6, 0x42, 0x17, 0x4e, 0x55, 0x31, 0xd0, 0x13, 0x98, 0xde, 0x25,
	0x75, 0xdd, 0x90, 0x1d, 0xff, 0xb4, 0x8f, 0x25, 0x52, 0x77, 0x1e, 0x30, 0x7a, 0xfe, 0x4f, 0x78,
	0xfe, 0x7e, 0x25, 0x86, 0xf3, 0xbb, 0x5d, 0x45, 0x54, 0x64, 0xcc, 0x81, 0x0d, 0x10, 0x4e, 0xf7,
	0x15, 0x59, 0x68, 0x46, 0x3d, 0x15, 0x19, 0xe9, 0x28, 0x40, 0xab, 0x90, 0x51, 0xa8, 0x43, 0x21,
	0xb3, 0x2c, 0xe5, 0x02, 0xf4, 0xdd, 0x04, 0xec, 0x49, 0x9c, 0xae, 0xb0, 0xcb, 0x08, 0x2e, 0xd0,
	0x27, 0xd4, 0x24, 0x56, 0x9d, 0x14, 0x32, 0x83, 0x09, 0x05, 0x8f, 0x08, 0x3d, 0x42, 0x0c, 0x88,
	0x36, 0x20, 0xbb, 0xef, 0xa6, 0x05, 0xb2, 0xe3, 0xd9, 0xc9, 0xbe, 0x3b, 0x81, 0x21, 0x69, 0x8d,
	0x95, 0x18, 0x9e, 0xdc, 0x0f, 0x80, 0xd1, 0x02, 0xc4, 0xeb, 0x6a, 0x21, 0xcb, 0x68, 0x5c, 0x1a,
	0x94, 0xb4, 0x57, 0x89, 0xe1, 0x78, 0x5d, 0xa5, 0x61, 0x02, 0xcf, 0x67, 0x3a, 0x34, 0x0a, 0xb9,
	0xbe, 0x66, 0xa3, 0x33, 0xa7, 0xac, 0x12, 0xc3, 0x2c, 0xf3, 0x8a, 0xb6, 0xb7, 0x0d, 0x39, 0x8b,
	0x9f, 0xb1, 0xba, 0x99, 0x04, 0x79, 0x46, 0xe5, 0x66, 0xb8, 0xf1, 0xe9, 0x49, 0x26, 0xa8, 0xc4,
	0x70, 0xd6, 0x0a, 0xc2, 0xd1, 0xd7, 0xe0, 0x4c, 0x27, 0x45, 0xa1, 0xdc, 0xd3, 0x3d, 0xb6, 0x28,
	0x9c, 0x6e, 0xa7, 0x8e, 0x23, 0xab, 0xa7, 0x10, 0xbd, 0x05, 0x63, 0x5c, 0x6a, 0x88, 0x91, 0x9c,
	0x0b, 0xdb, 0x1f, 0xe9, 0x14, 0x18, 0xaf, 0x4f, 0xe7, 0x9b, 0x23, 0x0e, 0x17, 0xe5, 0x86, 0x59,
	0x2f, 0xcc, 0xf4, 0x9d, 0x6f, 0xbd, 0x87, 0xa5, 0x74, 0xbe, 0x39, 0x3e, 0x94, 0xca, 0xdd, 0xe2,
	0x25, 0xe2, 0x2c, 0xea, 0x4c, 0x5f, 0xb9, 0x87, 0x9c, 0x39, 0x52, 0xb9, 0x5b, 0x01, 0x30, 0xed,
	0x9a, 0xc5, 0x2f, 0x8d, 0xc9, 0x6c, 0x1a, 0x9f, 0xed, 0xdb, 0xb5, 0xde, 0x8b, 0x70, 0xb4, 0x6b,
	0x96, 0x0f, 0x45, 0x8f, 0x21, 0x2f, 0xee, 0x07, 0xf9, 0x5b, 0x39, 0xe7, 0x18, 0xbd, 0xdb, 0xa1,
	0xd6, 0x32, 0xec, 0xf0, 0xa6, 0x12, 0xc3, 0x53, 0x6a, 0x67, 0x09, 0x35, 0x16, 0x8c, 0x9e, 0xac,
	0xfa, 0x17, 0xab, 0x0a, 0x85, 0xbe, 0xc6, 0xa2, 0xcf, 0x2d, 0x30, 0x6a, 0x2c, 0xd4, 0xae, 0x22,
	0xaa, 0xc6, 0xba, 0xa1, 0x3b, 0xcc, 0xb0, 0xcf, 0xf6, 0x55, 0xe3, 0xce, 0x1b, 0xeb, 0x54, 0x8d,
	0x75, 0x0e, 0xa1, 0x6a, 0xec, 0x88, 0x83, 0x4a, 0x21, 0x8e, 0x4b, 0x7d, 0xd5, 0x38, 0xec, 0x44,
	0x93, 0xaa, 0xb1, 0x13, 0x84, 0x53, 0x35, 0xe6, 0x06, 0xa2, 0x8b, 0xee, 0x6b, 0x7d, 0xd5, 0xb8,
	0xef, 0x85, 0x00, 0xaa, 0xc6, 0x4a, 0x4f, 0x21, 0x5a, 0xa6, 0xbe, 0x1e, 0xf5, 0x71, 0x74, 0x63,
	0xcf, 0x2c, 0x5c, 0xee, 0xbb, 0xfe, 0x74, 0x1f, 0x55, 0x56, 0x98, 0xa3, 0x27, 0x60, 0xd4, 0x90,
	0x31, 0xa7, 0x57, 0x66, 0xd7, 0xf0, 0x0a, 0x73, 0x7d, 0x0d, 0x59, 0xcf, 0xf6, 0x31, 0x35, 0x64,
	0x07, 0x1e, 0x90, 0x2e, 0x64, 0x7c, 0x0f, 0xa7, 0x30, 0x3f, 0x64, 0xaf, 0x20, 0xb0, 0x90, 0x71,
	0x0c, 0xb4, 0x04, 0xe9, 0x67, 0x6d, 0x62, 0x1d, 0x31, 0x33, 0x74, 0xa5, 0xaf, 0xd7, 0xda, 0x95,
	0x7b, 0x58, 0x89, 0xe1, 0xd4, 0x33, 0x01, 0xa2, 0xcd, 0xf3, 0x40, 0xba, 0x50, 0xec, 0xdb, 0x7c,
	0xc7, 0xd6, 0x09, 0x6d, 0x9e, 0x63, 0x20, 0x15, 0xce, 0x72, 0x59, 0x89, 0x1b, 0x04, 0x96, 0x48,
	0xd5, 0x2f, 0x5c, 0x65, 0xa4, 0xfa, 0x86, 0xa5, 0xa1, 0xb7, 0x19, 0x2a, 0x31, 0x3c, 0xa3, 0xf4,
	0x96, 0xd2, 0x09, 0x2f, 0x96, 0x1e, 0x1e, 0xcc, 0x16, 0xae, 0xf5, 0x9d, 0xf0, 0x21, 0xe1, 0x3f,
	0x9d, 0xf0, 0x4a, 0x00, 0xcc, 0x17, 0x20, 0x4d, 0xb6, 0x6d, 0x87, 0x86, 0x8e, 0x85, 0xeb, 0x03,
	0x16, 0xa0, 0xae, 0x90, 0x96, 0x2f, 0x40, 0x5a, 0x95, 0x63, 0x52, 0x42, 0x6a, 0x83, 0x28, 0x96,
	0x30, 0xb3, 0x37, 0xfa, 0x12, 0xea, 0xb9, 0x05, 0x4e, 0x09, 0xa9, 0x1e, 0x90, 0x2e, 0xd8, 0x96,
	0x7b, 0xb1, 0x50, 0xf8, 0x8f, 0x37, 0xfb, 0x2e, 0xd8, 0xa1, 0xf7, 0x1f, 0xe9, 0x82, 0x6d, 0x75,
	0x14, 0xa0, 0x2f, 0xc2, 0x84, 0xb8, 0xa5, 0x55, 0xb8, 0x35, 0xc0, 0xab, 0x0d, 0xc6, 0xb9, 0x74,
	0x5e, 0x0b, 0x1c, 0x6e, 0x65, 0xf9, 0x25, 0x2f, 0x3e, 0xbc, 0xdb, 0x03, 0xac, 0x6c, 0x4f, 0x88,
	0xc9, 0xad, 0xac, 0x0f, 0xa6, 0x56, 0x96, 0xeb, 0xa9, 0x58, 0xeb, 0xee, 0xf4, 0xb5, 0xb2, 0xbd,
	0x59, 0x83, 0xd4, 0xca, 0x3e, 0xf3, 0xa1, 0x74, 0x64, 0x36, 0x0f, 0xad, 0x0a, 0xaf, 0xf7, 0x1d,
	0x59, 0x67, 0x88, 0x48, 0x47, 0x26, 0x70, 0xa8, 0xd8, 0x78, 0x86, 0x0c, 0xe7, 0xf4, 0x67, 0xfa,
	0x8a, 0xad, 0x27, 0x12, 0xa9, 0xb8, 0x6f, 0xfd, 0x70, 0x0e, 0x7b, 0x86, 0xca, 0x12, 0x97, 0x32,
	0x04, 0xa7, 0xde, 0x18, 0x6c, 0xa8, 0xc2, 0xee, 0x9b, 0x78, 0x86, 0xaa, 0xa3, 0xb0, 0x34, 0x21,
	0xf2, 0x99, 0x1e, 0x26, 0x53, 0x53, 0xf9, 0xfc, 0xc3, 0x64, 0xea, 0x7c, 0xbe, 0xf0, 0x30, 0x99,
	0xba, 0x90, 0x9f, 0x7d, 0x98, 0x4c, 0x5d, 0xcc, 0x5f, 0x2a, 0xfe, 0xe7, 0x79, 0xc8, 0xba, 0x91,
	0x09, 0x8f, 0x0a, 0x16, 0x83, 0x51, 0xc1, 0xe5, 0x7e, 0x51, 0x81, 0x88, 0x65, 0x44, 0x58, 0xb0,
	0x18, 0x0c, 0x0b, 0x2e, 0xf7, 0x0b, 0x0b, 0x7c, 0x1c, 0x1a, 0x17, 0xd4, 0xfa, 0xc5, 0x05, 0xb7,
	0x47, 0x88, 0x0b, 0x3c, 0x52, 0xdd, 0x81, 0xc1, 0x72, 0x6f, 0x60, 0x70, 0x6d, 0x70, 0x60, 0xe0,
	0x91, 0x0a, 0x44, 0x06, 0xef, 0x74, 0x45, 0x06, 0x57, 0x06, 0x44, 0x06, 0x1e, 0xbe, 0x1b, 0x1a,
	0xac, 0x87, 0x86, 0x06, 0x37, 0x86, 0x85, 0x06, 0x1e, 0x9d, 0x8e, 0xd8, 0xe0, 0xcd, 0x8e, 0xd8,
	0x60, 0xae, 0x6f, 0x6c, 0xe0, 0x61, 0xf3, 0xe0, 0xe0, 0x83, 0xfe, 0xc1, 0xc1, 0xeb, 0x23, 0x05,
	0x07, 0x1e, 0xbd, 0xde, 0xe8, 0xa0, 0xd6, 0x2f, 0x3a, 0xb8, 0x3d, 0x42, 0x74, 0xe0, 0x0b, 0xae,
	0x2b, 0x3c, 0xa8, 0x84, 0x85, 0x07, 0xd7, 0x87, 0x84, 0x07, 0x1e, 0xb5, 0x60, 0x7c, 0x50, 0x09,
	0x8b, 0x0f, 0xae, 0x0f, 0x89, 0x0f, 0xba, 0x28, 0xf1, 0x00, 0x61, 0x33, 0x3c, 0x40, 0xb8, 0x39,
	0x34, 0x40, 0xf0, 0xa8, 0x75, 0x46, 0x08, 0x77, 0x03, 0x11, 0xc2, 0x6b, 0x7d, 0x22, 0x04, 0x0f,
	0x95, 0x86, 0x08, 0x5f, 0xea, 0x09, 0x11, 0x8a, 0x83, 0x42, 0x04, 0x0f, 0xd7, 0x8b, 0x11, 0xde,
	0xeb, 0x13, 0x23, 0xdc, 0x1a, 0x1e, 0x23, 0x78, 0xc4, 0xba, 0x82, 0x04, 0x65, 0x60, 0x90, 0xf0,
	0xc6, 0x88, 0x41, 0x82, 0x47, 0x3d, 0x2c, 0x4a, 0xf8, 0x7c, 0x67, 0x94, 0x30, 0xdf, 0x3f, 0x4a,
	0xf0, 0xc8, 0x88, 0x30, 0x61, 0x3d, 0x34, 0x4c, 0xb8, 0x31, 0x2c, 0x4c, 0xf0, 0xe7, 0x5e, 0x30,
	0x4e, 0xd8, 0x0c, 0x8f, 0x13, 0x6e, 0x0e, 0x8d, 0x13, 0x7c, 0xf1, 0x77, 0x04, 0x0a, 0xeb, 0xa1,
	0x81, 0xc2, 0x8d, 0x61, 0x81, 0x82, 0xdf, 0xb9, 0x60, 0xa4, 0xf0, 0x7e, 0xdf, 0x48, 0xe1, 0xce,
	0x28, 0x91, 0x82, 0x47, 0xb4, 0x27, 0x54, 0xf8, 0xa0, 0x7f, 0xa8, 0xf0, 0xfa, 0x48, 0xa1, 0x82,
	0x6f, 0x3a, 0x7a, 0x62, 0x85, 0x2f, 0xf5, 0xc4, 0x0a, 0xc5, 0x41, 0xb1, 0x82, 0xaf, 0xcf, 0x6e,
	0xb0, 0xa0, 0x0c, 0x74, 0xed, 0xdf, 0x18, 0xd1, 0xb5, 0xf7, 0x95, 0x2f, 0xc4, 0xb7, 0x5f, 0x09,
	0xf1, 0xed, 0xaf, 0x0d, 0xf6, 0xed, 0xfd, 0x25, 0xc4, 0x77, 0xee, 0x2b, 0x61, 0xce, 0xfd, 0xf5,
	0x21, 0xce, 0xbd, 0x6f, 0x85, 0x02, 0xde, 0xfd, 0x3b, 0x5d, 0xde, 0xfd, 0x95, 0xa1, 0x47, 0xd9,
	0x01, 0xf7, 0xbe, 0xd4, 0xeb, 0xde, 0x5f, 0x1d, 0xe8, 0xde, 0x7b, 0x14, 0x7c, 0xff, 0xfe, 0x9d,
	0x2e, 0xff, 0xfe, 0xca, 0x00, 0xff, 0xde, 0xef, 0x80, 0x70, 0xf0, 0xb5, 0xc1, 0x0e, 0xfe, 0xc2,
	0xa8, 0x0e, 0xbe, 0x47, 0x38, 0xd4, 0xc3, 0xdf, 0x0c, 0xf7, 0xf0, 0x6f, 0x8e, 0x78, 0xaa, 0xd5,
	0xe3, 0xe2, 0x57, 0xc2, 0x5c, 0xfc, 0xeb, 0x43, 0x5c, 0xfc, 0xe0, 0x1a, 0xe2, 0xf9, 0xf8, 0x95,
	0x30, 0x1f, 0xff, 0xfa, 0x10, 0x1f, 0xdf, 0xa7, 0x14, 0x70, 0xf2, 0x6b, 0xfd, 0x9c, 0xfc, 0xdb,
	0x23, 0x38, 0xf9, 0xfe, 0xba, 0xdb, 0xe5, 0xe5, 0xbf, 0xdb, 0xed, 0xe5, 0x17, 0x07, 0x79, 0xf9,
	0xfe, 0x8c, 0x74, 0xdd, 0xfc, 0xcd, 0x70, 0x37, 0xff, 0xe6, 0x50, 0x37, 0x3f, 0x68, 0x24, 0x03,
	0x7e, 0xfe, 0x7a, 0xa8, 0x9f, 0x7f, 0x63, 0x98, 0x9f, 0xef, 0x1b, 0xc9, 0xa0, 0xa3, 0xff, 0x6e,
	0xb7, 0xa3, 0x5f, 0x1c, 0xe4, 0xe8, 0xfb, 0x83, 0x73, 0x3d, 0xfd, 0x4a, 0x98, 0xa7, 0x7f, 0x7d,
	0x88, 0xa7, 0xef, 0x0b, 0x2f, 0xe0, 0xea, 0x2b, 0x03, 0x5d, 0xfd, 0x37, 0x46, 0x74, 0xf5, 0xbb,
	0x0c, 0xd7, 0xcb, 0xf9, 0xfa, 0x0f, 0x93, 0xa9, 0x4b, 0xf9, 0xd7, 0x8a, 0x7f, 0x35, 0x06, 0xe3,
	0x15, 0x37, 0xe5, 0x22, 0x70, 0xab, 0x56, 0x3a, 0xcd, 0xad, 0x5a, 0xb4, 0x4c, 0xd5, 0x87, 0x4d,
	0x42, 0xe1, 0xfd, 0x0f, 0xb8, 0xa2, 0xde, 0x73, 0xe8, 0xe5, 0xa2, 0x9e, 0xe2, 0xce, 0x01, 0x7a,
	0x13, 0xb2, 0x6d, 0x9b, 0x58, 0x72, 0xcb, 0xd2, 0x4d, 0x4b, 0x77, 0x78, 0x16, 0x9e, 0x54, 0xca,
	0x7f, 0x7c, 0x3c, 0x37, 0xb9, 0x63, 0x13, 0x6b, 0x5b, 0xc0, 0xf1, 0x64, 0x3b, 0xf0, 0xe5, 0x3e,
	0x15, 0x3b, 0x36, 0xfa, 0x53, 0xb1, 0xef, 0x41, 0xde, 0x22, 0x8a, 0xd6, 0xb1, 0x1c, 0xf2, 0xdb,
	0xa7, 0xe1, 0x2b, 0xb7, 0xa2, 0x05, 0x56, 0x3c, 0x76, 0x0b, 0x75, 0xca, 0xea, 0x04, 0xa2, 0x7b,
	0x70, 0xb6, 0xa9, 0x1c, 0xf2, 0xfb, 0xd5, 0xae, 0x87, 0xc1, 0x52, 0x4f, 0x52, 0x2c, 0x43, 0x0a,
	0x35, 0x95, 0x43, 0xf6, 0xee, 0x2c, 0x2f, 0x62, 0xef, 0xd4, 0x5d, 0x87, 0x9c, 0xa6, 0xdb, 0x8e,
	0x6e, 0xa8, 0xee, 0x53, 0x2d, 0xfc, 0x4d, 0x94, 0xac, 0x0b, 0xe5, 0x4f, 0xa6, 0xdc, 0x81, 0x69,
	0x91, 0x35, 0xe6, 0xbf, 0x44, 0xcb, 0x7c, 0xe9, 0x14, 0xed, 0x05, 0x2d, 0xf0, 0x1f, 0x0e, 0x2e,
	0xc3, 0x54, 0x5d, 0x71, 0xc8, 0x81, 0x72, 0x24, 0x1b, 0xa6, 0xc6, 0x78, 0x9f, 0x61, 0x0f, 0x56,
	0x5c, 0x3c, 0x39, 0x9e, 0xcb, 0xae, 0xf2, 0xa2, 0x4d, 0x53, 0xe3, 0x12, 0x18, 0xe7, 0xbf, 0x70,
	0xb6, 0x1e, 0x28, 0xd0, 0xd0, 0x12, 0x4c, 0xb2, 0x47, 0xb8, 0x4c, 0xfe, 0xd2, 0x9b, 0xf0, 0x90,
	0xfb, 0x9d, 0x61, 0x88, 0xf7, 0xe0, 0x30, 0x7b, 0xb8, 0xcb, 0x7d, 0x1c, 0xee, 0x26, 0x4c, 0x29,
	0xf6, 0x91, 0xa1, 0x32, 0x0e, 0x13, 0xc3, 0x6e, 0xdb, 0xcc, 0x45, 0x4e, 0xe1, 0x1c, 0x03, 0x97,
	0x5d, 0xa8, 0x78, 0xf1, 0xe5, 0xb7, 0x24, 0x98, 0xec, 0x48, 0xa5, 0x7c, 0xa7, 0xeb, 0xf0, 0xed,
	0x42, 0xb8, 0x7b, 0xde, 0x2f, 0xeb, 0x28, 0x25, 0x24, 0xe0, 0x66, 0x42, 0xcc, 0xf5, 0x77, 0xef,
	0x58, 0x80, 0xec, 0xe6, 0x8e, 0xb8, 0x68, 0x6f, 0x27, 0x7f, 0xe7, 0xbb, 0x73, 0xb1, 0xe2, 0x4f,
	0x13, 0x90, 0xed, 0x4c, 0x99, 0x5c, 0xeb, 0xea, 0x57, 0x98, 0x49, 0xec, 0xc0, 0x58, 0x18, 0xf0,
	0x10, 0x44, 0xda, 0x7d, 0xba, 0xcb, 0xed, 0xe6, 0xfc, 0x80, 0x23, 0xc6, 0x60, 0x3f, 0x7d, 0xc4,
	0xd9, 0x1f, 0xc7, 0xbd, 0x99, 0xbf, 0x00, 0x63, 0xec, 0x11, 0x6c, 0xd1, 0xb5, 0xb0, 0xdb, 0x08,
	0x2b, 0xb4, 0x1c, 0xf3, 0x6a, 0xd4, 0x52, 0xd4, 0x4e, 0x75, 0xff, 0xde, 0x03, 0x9c, 0xe2, 0x91,
	0xe6, 0x53, 0xde, 0x13, 0x67, 0x07, 0x8e, 0x8d, 0x06, 0x51, 0x1d, 0xf1, 0x96, 0xb6, 0xfb, 0x14,
	0xf3, 0xb5, 0x6e, 0x12, 0xe2, 0xe5, 0xed, 0x05, 0x2c, 0x5e, 0xde, 0x0e, 0x24, 0xa7, 0xe4, 0x3c,
	0x12, 0x6c, 0x62, 0xf1, 0x14, 0x26, 0x21, 0xea, 0x6f, 0x48, 0x90, 0x67, 0xd3, 0xe8, 0x01, 0x21,
	0x5a, 0x24, 0x5a, 0xe8, 0xe6, 0xcd, 0xc4, 0x47, 0xce, 0x9b, 0x29, 0x2a, 0x90, 0xf3, 0xfa, 0xc0,
	0xdf, 0xa4, 0x1d, 0xf0, 0x7c, 0xc2, 0xa9, 0xae, 0xb5, 0x15, 0x7f, 0x4f, 0x82, 0x19, 0xaf, 0x0d,
	0xe6, 0xe7, 0xf3, 0xcc, 0xef, 0x53, 0x64, 0x32, 0x62, 0xf6, 0xde, 0x36, 0x8d, 0xf3, 0xd8, 0x55,
	0xa7, 0x91, 0x34, 0x08, 0x89, 0xd3, 0x6c, 0x10, 0xf1, 0xa3, 0x56, 0xab, 0xb2, 0x97, 0xb8, 0xf9,
	0x6f, 0xbb, 0xf8, 0x20, 0xc0, 0x01, 0xa6, 0xac, 0x74, 0x98, 0x23, 0x69, 0xb5, 0x3b, 0x4c, 0x56,
	0xb9, 0xf8, 0xb7, 0x52, 0x90, 0xd0, 0x73, 0xea, 0x37, 0xdc, 0x87, 0xc4, 0x73, 0xa5, 0x31, 0xe8,
	0x30, 0xbf, 0x83, 0xf5, 0x98, 0xd6, 0x46, 0x0f, 0x80, 0x5f, 0xf7, 0xe0, 0xe9, 0xf2, 0xf1, 0xfe,
	0xc1, 0x5d, 0x2f, 0x4b, 0x71, 0x00, 0x13, 0xbd, 0xe5, 0x8e, 0x22, 0x31, 0xbc, 0xf9, 0xe0, 0x24,
	0x7d, 0x3b, 0xf9, 0xd1, 0x77, 0xe7, 0xa4, 0x3b, 0x55, 0x98, 0x09, 0x59, 0x84, 0x50, 0x0e, 0xa0,
	0xbc, 0xb5, 0x59, 0x5d, 0xab, 0xd6, 0x56, 0x36, 0x6b, 0xee, 0x73, 0xdf, 0x4b, 0xcb, 0xf2, 0xce,
	0x66, 0x79, 0x6b, 0x63, 0x63, 0xad, 0x56, 0x5b, 0x59, 0xce, 0x4b, 0x28, 0x0f, 0x93, 0x6b, 0x9b,
	0x81, 0x7a, 0xe2, 0x95, 0xef, 0x3b, 0x3f, 0x07, 0xe0, 0xbf, 0xa2, 0x48, 0x69, 0xad, 0xaf, 0x3c,
	0x91, 0x1f, 0x2f, 0x3d, 0xda, 0x59, 0xa9, 0xe6, 0x63, 0x08, 0x41, 0xae, 0xb4, 0x54, 0x2b, 0x57,
	0x64, 0xbc, 0x52, 0xdd, 0xde, 0xda, 0xac, 0xae, 0xe4, 0x25, 0x81, 0xf7, 0x3e, 0x64, 0x02, 0xef,
	0x31, 0xd0, 0x8a, 0xdb, 0x3b, 0xd5, 0x8a, 0x5c, 0x5b, 0xdb, 0x58, 0xa9, 0xd6, 0x96, 0x36, 0xb6,
	0xf3, 0x31, 0x4a, 0x8c, 0xc1, 0x96, 0x4a, 0x5b, 0xb8, 0x96, 0x97, 0xbc, 0xef, 0xda, 0xd6, 0x4e,
	0xb9, 0x92, 0x8f, 0x7b, 0xdf, 0xef, 0xed, 0xac, 0xe0, 0x27, 0xf9, 0x84, 0x20, 0xac, 0xc0, 0xd9,
	0xd0, 0x8b, 0x31, 0x28, 0x03, 0x13, 0x3b, 0x06, 0x7b, 0x13, 0x20, 0x1f, 0x43, 0xd9, 0xc0, 0xdd,
	0x98, 0xbc, 0x84, 0x52, 0xfc, 0x0e, 0x46, 0x3e, 0x8e, 0xc6, 0x21, 0x5e, 0xbd, 0x9f, 0x4f, 0xa0,
	0x29, 0xc8, 0x04, 0x2e, 0x98, 0xe4, 0x93, 0x28, 0x2d, 0x2e, 0x0f, 0xe4, 0xc7, 0xee, 0x5c, 0x81,
	0x40, 0x6e, 0x36, 0x02, 0x18, 0x7f, 0xa4, 0x38, 0xc4, 0x76, 0xf2, 0x31, 0x34, 0x01, 0x89, 0xa5,
	0x46, 0x23, 0x2f, 0x2d, 0xfe, 0x40, 0x82, 0x94, 0xfb, 0xde, 0x1a, 0x7a, 0x04, 0x63, 0x3c, 0x60,
	0x9b, 0xeb, 0x6f, 0xe8, 0x99, 0xad, 0x98, 0x9d, 0x1f, 0xb6, 0x12, 0x14, 0x63, 0xe8, 0x7d, 0xf1,
	0xc6, 0x3f, 0x95, 0x32, 0xba, 0x3a, 0x48, 0x07, 0x5c, 0xaa, 0x83, 0x15, 0x85, 0xea, 0x75, 0x31,
	0xf6, 0x59, 0xa9, 0x74, 0xe5, 0xa3, 0x7f, 0xbd, 0x1c, 0xfb, 0xe8, 0xe4, 0xb2, 0xf4, 0x93, 0x93,
	0xcb, 0xd2, 0x3f, 0x9d, 0x5c, 0x96, 0xfe, 0xe5, 0xe4, 0xb2, 0xf4, 0xeb, 0xff, 0x76, 0x39, 0xf6,
	0xc1, 0x84, 0xc0, 0xda, 0x1d, 0x67, 0xff, 0x66, 0xe0, 0xfe, 0xff, 0x04, 0x00, 0x00, 0xff, 0xff,
	0x92, 0x79, 0x1f, 0xd9, 0x6b, 0x61, 0x00, 0x00,
}
