// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: server/serverpb/admin.proto

/*
	Package serverpb is a generated protocol buffer package.

	It is generated from these files:
		server/serverpb/admin.proto
		server/serverpb/authentication.proto
		server/serverpb/init.proto
		server/serverpb/status.proto

	It has these top-level messages:
		DatabasesRequest
		DatabasesResponse
		DatabaseDetailsRequest
		DatabaseDetailsResponse
		TableDetailsRequest
		TableDetailsResponse
		TableStatsRequest
		TableStatsResponse
		NonTableStatsRequest
		NonTableStatsResponse
		UsersRequest
		UsersResponse
		EventsRequest
		EventsResponse
		SetUIDataRequest
		SetUIDataResponse
		GetUIDataRequest
		GetUIDataResponse
		ClusterRequest
		ClusterResponse
		DrainRequest
		DrainResponse
		DecommissionStatusRequest
		DecommissionRequest
		DecommissionStatusResponse
		SettingsRequest
		SettingsResponse
		HealthRequest
		HealthResponse
		LivenessRequest
		LivenessResponse
		JobsRequest
		JobsResponse
		LocationsRequest
		LocationsResponse
		RangeLogRequest
		RangeLogResponse
		QueryPlanRequest
		QueryPlanResponse
		DataDistributionRequest
		DataDistributionResponse
		MetricMetadataRequest
		MetricMetadataResponse
		EnqueueRangeRequest
		EnqueueRangeResponse
		UserLoginRequest
		UserLoginResponse
		UserLogoutRequest
		UserLogoutResponse
		SessionCookie
		BootstrapRequest
		BootstrapResponse
		CertificatesRequest
		CertificateDetails
		CertificatesResponse
		DetailsRequest
		DetailsResponse
		NodesRequest
		NodesResponse
		NodeRequest
		RaftState
		RangeProblems
		RangeStatistics
		PrettySpan
		CommandQueueMetrics
		RangeInfo
		RangesRequest
		RangesResponse
		GossipRequest
		TraceEvent
		AllocatorDryRun
		AllocatorRangeRequest
		AllocatorRangeResponse
		AllocatorRequest
		AllocatorResponse
		JSONResponse
		LogsRequest
		LogEntriesResponse
		LogFilesListRequest
		LogFilesListResponse
		LogFileRequest
		StacksRequest
		File
		GetFilesRequest
		GetFilesResponse
		ProfileRequest
		MetricsRequest
		RaftRangeNode
		RaftRangeError
		RaftRangeStatus
		RaftDebugRequest
		RaftDebugResponse
		ActiveQuery
		ListSessionsRequest
		Session
		ListSessionsError
		ListSessionsResponse
		CancelQueryRequest
		CancelQueryResponse
		CancelSessionRequest
		CancelSessionResponse
		SpanStatsRequest
		SpanStatsResponse
		ProblemRangesRequest
		ProblemRangesResponse
		RangeRequest
		RangeResponse
		CommandQueueRequest
		CommandQueueResponse
		DiagnosticsRequest
		StoresRequest
		StoreDetails
		StoresResponse
		StatementsRequest
		StatementsResponse
*/
package serverpb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import cockroach_config "github.com/cockroachdb/cockroach/pkg/config"
import cockroach_sql_jobs_jobspb "github.com/cockroachdb/cockroach/pkg/jobs/jobspb"
import cockroach_storage_engine_enginepb1 "github.com/cockroachdb/cockroach/pkg/storage/engine/enginepb"
import cockroach_storage "github.com/cockroachdb/cockroach/pkg/storage"
import cockroach_storage2 "github.com/cockroachdb/cockroach/pkg/storage"
import cockroach_util_metric "github.com/cockroachdb/cockroach/pkg/util/metric"

import time "time"
import github_com_cockroachdb_cockroach_pkg_roachpb "github.com/cockroachdb/cockroach/pkg/roachpb"
import github_com_cockroachdb_cockroach_pkg_sql_sqlbase "github.com/cockroachdb/cockroach/pkg/sql/sqlbase"

import context "context"
import grpc "google.golang.org/grpc"

import sortkeys "github.com/gogo/protobuf/sortkeys"
import binary "encoding/binary"
import types "github.com/gogo/protobuf/types"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// ZoneConfigurationLevel indicates, for objects with a Zone Configuration,
// the object level at which the configuration is defined. This is needed
// because objects without a specifically indicated Zone Configuration will
// inherit the configuration of their "parent".
type ZoneConfigurationLevel int32

const (
	ZoneConfigurationLevel_UNKNOWN ZoneConfigurationLevel = 0
	// CLUSTER indicates that this object uses the cluster default Zone Configuration.
	ZoneConfigurationLevel_CLUSTER ZoneConfigurationLevel = 1
	// DATABASE indicates that this object uses a database-level Zone Configuration.
	ZoneConfigurationLevel_DATABASE ZoneConfigurationLevel = 2
	// TABLE indicates that this object uses a table-level Zone Configuration.
	ZoneConfigurationLevel_TABLE ZoneConfigurationLevel = 3
)

var ZoneConfigurationLevel_name = map[int32]string{
	0: "UNKNOWN",
	1: "CLUSTER",
	2: "DATABASE",
	3: "TABLE",
}
var ZoneConfigurationLevel_value = map[string]int32{
	"UNKNOWN":  0,
	"CLUSTER":  1,
	"DATABASE": 2,
	"TABLE":    3,
}

func (x ZoneConfigurationLevel) String() string {
	return proto.EnumName(ZoneConfigurationLevel_name, int32(x))
}
func (ZoneConfigurationLevel) EnumDescriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{0} }

type DrainMode int32

const (
	// CLIENT instructs the server to refuse new SQL clients.
	// TODO(tschottdorf): also terminate existing clients in a graceful manner.
	DrainMode_CLIENT DrainMode = 0
	// LEADERSHIP instructs the server to gracefully let all its Replicas'
	// range leases expire.
	DrainMode_LEASES DrainMode = 1
)

var DrainMode_name = map[int32]string{
	0: "CLIENT",
	1: "LEASES",
}
var DrainMode_value = map[string]int32{
	"CLIENT": 0,
	"LEASES": 1,
}

func (x DrainMode) String() string {
	return proto.EnumName(DrainMode_name, int32(x))
}
func (DrainMode) EnumDescriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{1} }

// DatabasesRequest requests a list of databases.
type DatabasesRequest struct {
}

func (m *DatabasesRequest) Reset()                    { *m = DatabasesRequest{} }
func (m *DatabasesRequest) String() string            { return proto.CompactTextString(m) }
func (*DatabasesRequest) ProtoMessage()               {}
func (*DatabasesRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{0} }

// DatabasesResponse contains a list of databases.
type DatabasesResponse struct {
	Databases []string `protobuf:"bytes,1,rep,name=databases" json:"databases,omitempty"`
}

func (m *DatabasesResponse) Reset()                    { *m = DatabasesResponse{} }
func (m *DatabasesResponse) String() string            { return proto.CompactTextString(m) }
func (*DatabasesResponse) ProtoMessage()               {}
func (*DatabasesResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{1} }

// DatabaseDetailsRequest requests detailed information about the specified
// database
type DatabaseDetailsRequest struct {
	// database is the name of the database we are querying.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
}

func (m *DatabaseDetailsRequest) Reset()                    { *m = DatabaseDetailsRequest{} }
func (m *DatabaseDetailsRequest) String() string            { return proto.CompactTextString(m) }
func (*DatabaseDetailsRequest) ProtoMessage()               {}
func (*DatabaseDetailsRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{2} }

// DatabaseDetailsResponse contains grant information and table names for a
// database.
type DatabaseDetailsResponse struct {
	// grants are the results of SHOW GRANTS for this database.
	Grants []DatabaseDetailsResponse_Grant `protobuf:"bytes,1,rep,name=grants" json:"grants"`
	// table_names contains the names of all tables (SHOW TABLES) in this
	// database.
	TableNames []string `protobuf:"bytes,2,rep,name=table_names,json=tableNames" json:"table_names,omitempty"`
	// descriptor_id is an identifier used to uniquely identify this database.
	// It can be used to find events pertaining to this database by filtering on
	// the 'target_id' field of events.
	DescriptorID int64 `protobuf:"varint,3,opt,name=descriptor_id,json=descriptorId,proto3" json:"descriptor_id,omitempty"`
	// The zone configuration in effect for this database.
	ZoneConfig cockroach_config.ZoneConfig `protobuf:"bytes,4,opt,name=zone_config,json=zoneConfig" json:"zone_config"`
	// The level at which this object's zone configuration is set.
	ZoneConfigLevel ZoneConfigurationLevel `protobuf:"varint,5,opt,name=zone_config_level,json=zoneConfigLevel,proto3,enum=cockroach.server.serverpb.ZoneConfigurationLevel" json:"zone_config_level,omitempty"`
}

func (m *DatabaseDetailsResponse) Reset()                    { *m = DatabaseDetailsResponse{} }
func (m *DatabaseDetailsResponse) String() string            { return proto.CompactTextString(m) }
func (*DatabaseDetailsResponse) ProtoMessage()               {}
func (*DatabaseDetailsResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{3} }

type DatabaseDetailsResponse_Grant struct {
	// user is the user that this grant applies to.
	User string `protobuf:"bytes,1,opt,name=user,proto3" json:"user,omitempty"`
	// privileges are the abilities this grant gives to the user.
	Privileges []string `protobuf:"bytes,2,rep,name=privileges" json:"privileges,omitempty"`
}

func (m *DatabaseDetailsResponse_Grant) Reset()         { *m = DatabaseDetailsResponse_Grant{} }
func (m *DatabaseDetailsResponse_Grant) String() string { return proto.CompactTextString(m) }
func (*DatabaseDetailsResponse_Grant) ProtoMessage()    {}
func (*DatabaseDetailsResponse_Grant) Descriptor() ([]byte, []int) {
	return fileDescriptorAdmin, []int{3, 0}
}

// TableDetailsRequest is a request for detailed information about a table.
type TableDetailsRequest struct {
	// database is the database that contains the table we're interested in.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// table is the name of the table that we're querying.
	Table string `protobuf:"bytes,2,opt,name=table,proto3" json:"table,omitempty"`
}

func (m *TableDetailsRequest) Reset()                    { *m = TableDetailsRequest{} }
func (m *TableDetailsRequest) String() string            { return proto.CompactTextString(m) }
func (*TableDetailsRequest) ProtoMessage()               {}
func (*TableDetailsRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{4} }

// TableDetailsResponse contains grants, column names, and indexes for
// a table.
type TableDetailsResponse struct {
	Grants  []TableDetailsResponse_Grant  `protobuf:"bytes,1,rep,name=grants" json:"grants"`
	Columns []TableDetailsResponse_Column `protobuf:"bytes,2,rep,name=columns" json:"columns"`
	Indexes []TableDetailsResponse_Index  `protobuf:"bytes,3,rep,name=indexes" json:"indexes"`
	// range_count is the size of the table in ranges. This provides a rough
	// estimate of the storage requirements for the table.
	// TODO(mrtracy): The TableStats method also returns a range_count field which
	// is more accurate than this one; TableDetails calculates this number using
	// a potentially faster method that is subject to cache staleness. We should
	// consider removing or renaming this field to reflect that difference. See
	// Github issue #5435 for more information.
	RangeCount int64 `protobuf:"varint,4,opt,name=range_count,json=rangeCount,proto3" json:"range_count,omitempty"`
	// create_table_statement is the output of "SHOW CREATE" for this table;
	// it is a SQL statement that would re-create the table's current schema if
	// executed.
	CreateTableStatement string `protobuf:"bytes,5,opt,name=create_table_statement,json=createTableStatement,proto3" json:"create_table_statement,omitempty"`
	// The zone configuration in effect for this table.
	ZoneConfig cockroach_config.ZoneConfig `protobuf:"bytes,6,opt,name=zone_config,json=zoneConfig" json:"zone_config"`
	// The level at which this object's zone configuration is set.
	ZoneConfigLevel ZoneConfigurationLevel `protobuf:"varint,7,opt,name=zone_config_level,json=zoneConfigLevel,proto3,enum=cockroach.server.serverpb.ZoneConfigurationLevel" json:"zone_config_level,omitempty"`
	// descriptor_id is an identifier used to uniquely identify this table.
	// It can be used to find events pertaining to this table by filtering on
	// the 'target_id' field of events.
	DescriptorID int64 `protobuf:"varint,8,opt,name=descriptor_id,json=descriptorId,proto3" json:"descriptor_id,omitempty"`
}

func (m *TableDetailsResponse) Reset()                    { *m = TableDetailsResponse{} }
func (m *TableDetailsResponse) String() string            { return proto.CompactTextString(m) }
func (*TableDetailsResponse) ProtoMessage()               {}
func (*TableDetailsResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{5} }

// Grant is an entry from SHOW GRANTS.
type TableDetailsResponse_Grant struct {
	// user is the user that this grant applies to.
	User string `protobuf:"bytes,1,opt,name=user,proto3" json:"user,omitempty"`
	// privileges are the abilities this grant gives to the user.
	Privileges []string `protobuf:"bytes,2,rep,name=privileges" json:"privileges,omitempty"`
}

func (m *TableDetailsResponse_Grant) Reset()         { *m = TableDetailsResponse_Grant{} }
func (m *TableDetailsResponse_Grant) String() string { return proto.CompactTextString(m) }
func (*TableDetailsResponse_Grant) ProtoMessage()    {}
func (*TableDetailsResponse_Grant) Descriptor() ([]byte, []int) {
	return fileDescriptorAdmin, []int{5, 0}
}

type TableDetailsResponse_Column struct {
	// name is the name of the column.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// type is the SQL type (INT, STRING, etc.) of this column.
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// nullable is whether this column can contain NULL.
	Nullable bool `protobuf:"varint,3,opt,name=nullable,proto3" json:"nullable,omitempty"`
	// default_value is the default value of this column.
	DefaultValue string `protobuf:"bytes,4,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
	// generation_expression is the generator expression if the column is computed.
	GenerationExpression string `protobuf:"bytes,5,opt,name=generation_expression,json=generationExpression,proto3" json:"generation_expression,omitempty"`
	// hidden is whether this column is hidden.
	Hidden bool `protobuf:"varint,6,opt,name=hidden,proto3" json:"hidden,omitempty"`
}

func (m *TableDetailsResponse_Column) Reset()         { *m = TableDetailsResponse_Column{} }
func (m *TableDetailsResponse_Column) String() string { return proto.CompactTextString(m) }
func (*TableDetailsResponse_Column) ProtoMessage()    {}
func (*TableDetailsResponse_Column) Descriptor() ([]byte, []int) {
	return fileDescriptorAdmin, []int{5, 1}
}

type TableDetailsResponse_Index struct {
	// name is the name of this index.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// unique is whether this a unique index (i.e. CREATE UNIQUE INDEX).
	Unique bool `protobuf:"varint,2,opt,name=unique,proto3" json:"unique,omitempty"`
	// seq is an internal variable that's passed along.
	Seq int64 `protobuf:"varint,3,opt,name=seq,proto3" json:"seq,omitempty"`
	// column is the column that this index indexes.
	Column string `protobuf:"bytes,4,opt,name=column,proto3" json:"column,omitempty"`
	// direction is either "ASC" (ascending) or "DESC" (descending).
	Direction string `protobuf:"bytes,5,opt,name=direction,proto3" json:"direction,omitempty"`
	// storing is an internal variable that's passed along.
	Storing bool `protobuf:"varint,6,opt,name=storing,proto3" json:"storing,omitempty"`
	// implicit is an internal variable that's passed along.
	Implicit bool `protobuf:"varint,7,opt,name=implicit,proto3" json:"implicit,omitempty"`
}

func (m *TableDetailsResponse_Index) Reset()         { *m = TableDetailsResponse_Index{} }
func (m *TableDetailsResponse_Index) String() string { return proto.CompactTextString(m) }
func (*TableDetailsResponse_Index) ProtoMessage()    {}
func (*TableDetailsResponse_Index) Descriptor() ([]byte, []int) {
	return fileDescriptorAdmin, []int{5, 2}
}

// TableStatsRequest is a request for detailed, computationally expensive
// information about a table.
type TableStatsRequest struct {
	// database is the database that contains the table we're interested in.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// table is the name of the table that we're querying.
	Table string `protobuf:"bytes,2,opt,name=table,proto3" json:"table,omitempty"`
}

func (m *TableStatsRequest) Reset()                    { *m = TableStatsRequest{} }
func (m *TableStatsRequest) String() string            { return proto.CompactTextString(m) }
func (*TableStatsRequest) ProtoMessage()               {}
func (*TableStatsRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{6} }

// TableStatsResponse contains detailed, computationally expensive information
// about a table.
type TableStatsResponse struct {
	// range_count is the number of ranges, as determined from a query of range
	// meta keys.
	RangeCount int64 `protobuf:"varint,1,opt,name=range_count,json=rangeCount,proto3" json:"range_count,omitempty"`
	// replica_count is the number of replicas of any range of this table, as
	// found by querying nodes which are known to have replicas. When compared
	// with range_count, this can be used to estimate the current replication
	// factor of the table.
	ReplicaCount int64 `protobuf:"varint,2,opt,name=replica_count,json=replicaCount,proto3" json:"replica_count,omitempty"`
	// node_count is the number of nodes which contain data for this table,
	// according to a query of range meta keys.
	NodeCount int64 `protobuf:"varint,3,opt,name=node_count,json=nodeCount,proto3" json:"node_count,omitempty"`
	// stats is the summation of MVCCStats for all replicas of this table
	// across the cluster.
	Stats cockroach_storage_engine_enginepb1.MVCCStats `protobuf:"bytes,4,opt,name=stats" json:"stats"`
	// approximate_disk_bytes is an approximation of the disk space (in bytes)
	// used for all replicas of this table across the cluster.
	ApproximateDiskBytes uint64 `protobuf:"varint,6,opt,name=approximate_disk_bytes,json=approximateDiskBytes,proto3" json:"approximate_disk_bytes,omitempty"`
	// A list of nodes which should contain data for this table (according to
	// cluster metadata), but could not be contacted during this request.
	MissingNodes []TableStatsResponse_MissingNode `protobuf:"bytes,5,rep,name=missing_nodes,json=missingNodes" json:"missing_nodes"`
}

func (m *TableStatsResponse) Reset()                    { *m = TableStatsResponse{} }
func (m *TableStatsResponse) String() string            { return proto.CompactTextString(m) }
func (*TableStatsResponse) ProtoMessage()               {}
func (*TableStatsResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{7} }

// MissingNode represents information on a node which should contain data
// for this table, but could not be contacted during this request.
type TableStatsResponse_MissingNode struct {
	// The ID of the missing node.
	NodeID string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	// The error message that resulted when the query sent to this node failed.
	ErrorMessage string `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
}

func (m *TableStatsResponse_MissingNode) Reset()         { *m = TableStatsResponse_MissingNode{} }
func (m *TableStatsResponse_MissingNode) String() string { return proto.CompactTextString(m) }
func (*TableStatsResponse_MissingNode) ProtoMessage()    {}
func (*TableStatsResponse_MissingNode) Descriptor() ([]byte, []int) {
	return fileDescriptorAdmin, []int{7, 0}
}

// NonTableStatsRequest requests statistics on cluster data ranges that do not
// belong to SQL tables.
type NonTableStatsRequest struct {
}

func (m *NonTableStatsRequest) Reset()                    { *m = NonTableStatsRequest{} }
func (m *NonTableStatsRequest) String() string            { return proto.CompactTextString(m) }
func (*NonTableStatsRequest) ProtoMessage()               {}
func (*NonTableStatsRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{8} }

// NonTableStatsResponse returns statistics on various cluster data ranges
// that do not belong to SQL tables. The statistics for each range are returned
// as a TableStatsResponse.
type NonTableStatsResponse struct {
	// Information on time series ranges,
	TimeSeriesStats *TableStatsResponse `protobuf:"bytes,1,opt,name=time_series_stats,json=timeSeriesStats" json:"time_series_stats,omitempty"`
}

func (m *NonTableStatsResponse) Reset()                    { *m = NonTableStatsResponse{} }
func (m *NonTableStatsResponse) String() string            { return proto.CompactTextString(m) }
func (*NonTableStatsResponse) ProtoMessage()               {}
func (*NonTableStatsResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{9} }

// UsersRequest requests a list of users.
type UsersRequest struct {
}

func (m *UsersRequest) Reset()                    { *m = UsersRequest{} }
func (m *UsersRequest) String() string            { return proto.CompactTextString(m) }
func (*UsersRequest) ProtoMessage()               {}
func (*UsersRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{10} }

// UsersResponse returns a list of users.
type UsersResponse struct {
	// usernames is a list of users for the CockroachDB cluster.
	Users []UsersResponse_User `protobuf:"bytes,1,rep,name=users" json:"users"`
}

func (m *UsersResponse) Reset()                    { *m = UsersResponse{} }
func (m *UsersResponse) String() string            { return proto.CompactTextString(m) }
func (*UsersResponse) ProtoMessage()               {}
func (*UsersResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{11} }

// User is a CockroachDB user.
type UsersResponse_User struct {
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
}

func (m *UsersResponse_User) Reset()                    { *m = UsersResponse_User{} }
func (m *UsersResponse_User) String() string            { return proto.CompactTextString(m) }
func (*UsersResponse_User) ProtoMessage()               {}
func (*UsersResponse_User) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{11, 0} }

// EventsRequest is a request for event log entries, optionally filtered
// by the specified event type and/or target_id.
type EventsRequest struct {
	Type     string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	TargetId int64  `protobuf:"varint,2,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// limit is the total number of results that are retrieved by the query. If
	// this is omitted or set to 0, the default maximum number of results are
	// returned. When set to > 0, at most only that number of results are
	// returned. When set to < 0, an unlimited number of results are returned.
	Limit int32 `protobuf:"varint,3,opt,name=limit,proto3" json:"limit,omitempty"`
}

func (m *EventsRequest) Reset()                    { *m = EventsRequest{} }
func (m *EventsRequest) String() string            { return proto.CompactTextString(m) }
func (*EventsRequest) ProtoMessage()               {}
func (*EventsRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{12} }

// EventsResponse contains a set of event log entries. This is always limited
// to the latest N entries (N is enforced in the associated endpoint).
type EventsResponse struct {
	Events []EventsResponse_Event `protobuf:"bytes,1,rep,name=events" json:"events"`
}

func (m *EventsResponse) Reset()                    { *m = EventsResponse{} }
func (m *EventsResponse) String() string            { return proto.CompactTextString(m) }
func (*EventsResponse) ProtoMessage()               {}
func (*EventsResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{13} }

type EventsResponse_Event struct {
	// timestamp is the time at which the event occurred.
	Timestamp time.Time `protobuf:"bytes,1,opt,name=timestamp,stdtime" json:"timestamp"`
	// event_type is the type of the event (e.g. "create_table", "drop_table".
	EventType string `protobuf:"bytes,2,opt,name=event_type,json=eventType,proto3" json:"event_type,omitempty"`
	// target_id is the target for this event.
	TargetID int64 `protobuf:"varint,3,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// reporting_id is the reporting ID for this event.
	ReportingID int64 `protobuf:"varint,4,opt,name=reporting_id,json=reportingId,proto3" json:"reporting_id,omitempty"`
	// info has more detailed information for the event. The contents vary
	// depending on the event.
	Info string `protobuf:"bytes,5,opt,name=info,proto3" json:"info,omitempty"`
	// unique_id is a unique identifier for this event.
	UniqueID []byte `protobuf:"bytes,6,opt,name=unique_id,json=uniqueId,proto3" json:"unique_id,omitempty"`
}

func (m *EventsResponse_Event) Reset()                    { *m = EventsResponse_Event{} }
func (m *EventsResponse_Event) String() string            { return proto.CompactTextString(m) }
func (*EventsResponse_Event) ProtoMessage()               {}
func (*EventsResponse_Event) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{13, 0} }

// SetUIDataRequest stores the given key/value pairs in the system.ui table.
type SetUIDataRequest struct {
	// key_values is a map of keys to bytes values. Each key will be stored
	// with its corresponding value as a separate row in system.ui.
	KeyValues map[string][]byte `protobuf:"bytes,1,rep,name=key_values,json=keyValues" json:"key_values,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *SetUIDataRequest) Reset()                    { *m = SetUIDataRequest{} }
func (m *SetUIDataRequest) String() string            { return proto.CompactTextString(m) }
func (*SetUIDataRequest) ProtoMessage()               {}
func (*SetUIDataRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{14} }

// SetUIDataResponse is currently an empty response.
type SetUIDataResponse struct {
}

func (m *SetUIDataResponse) Reset()                    { *m = SetUIDataResponse{} }
func (m *SetUIDataResponse) String() string            { return proto.CompactTextString(m) }
func (*SetUIDataResponse) ProtoMessage()               {}
func (*SetUIDataResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{15} }

// GETUIDataRequest requests the values for the given keys from the system.ui
// table.
type GetUIDataRequest struct {
	Keys []string `protobuf:"bytes,1,rep,name=keys" json:"keys,omitempty"`
}

func (m *GetUIDataRequest) Reset()                    { *m = GetUIDataRequest{} }
func (m *GetUIDataRequest) String() string            { return proto.CompactTextString(m) }
func (*GetUIDataRequest) ProtoMessage()               {}
func (*GetUIDataRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{16} }

// GetUIDataResponse contains the requested values and the times at which
// the values were last updated.
type GetUIDataResponse struct {
	// key_values maps keys to their retrieved values. If this doesn't contain a
	// a requested key, that key was not found.
	KeyValues map[string]GetUIDataResponse_Value `protobuf:"bytes,1,rep,name=key_values,json=keyValues" json:"key_values" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *GetUIDataResponse) Reset()                    { *m = GetUIDataResponse{} }
func (m *GetUIDataResponse) String() string            { return proto.CompactTextString(m) }
func (*GetUIDataResponse) ProtoMessage()               {}
func (*GetUIDataResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{17} }

type GetUIDataResponse_Value struct {
	// value is the value of the requested key.
	Value []byte `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// last_updated is the time at which the value was last updated.
	LastUpdated time.Time `protobuf:"bytes,2,opt,name=last_updated,json=lastUpdated,stdtime" json:"last_updated"`
}

func (m *GetUIDataResponse_Value) Reset()                    { *m = GetUIDataResponse_Value{} }
func (m *GetUIDataResponse_Value) String() string            { return proto.CompactTextString(m) }
func (*GetUIDataResponse_Value) ProtoMessage()               {}
func (*GetUIDataResponse_Value) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{17, 0} }

// ClusterRequest requests metadata for the cluster.
type ClusterRequest struct {
}

func (m *ClusterRequest) Reset()                    { *m = ClusterRequest{} }
func (m *ClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*ClusterRequest) ProtoMessage()               {}
func (*ClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{18} }

// ClusterResponse contains metadata for the cluster.
type ClusterResponse struct {
	// The unique ID used to identify this cluster.
	ClusterID string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// True if diagnostics reporting is enabled for the cluster.
	ReportingEnabled bool `protobuf:"varint,2,opt,name=reporting_enabled,json=reportingEnabled,proto3" json:"reporting_enabled,omitempty"`
	// True if enterprise features are enabled for the cluster.
	EnterpriseEnabled bool `protobuf:"varint,3,opt,name=enterprise_enabled,json=enterpriseEnabled,proto3" json:"enterprise_enabled,omitempty"`
}

func (m *ClusterResponse) Reset()                    { *m = ClusterResponse{} }
func (m *ClusterResponse) String() string            { return proto.CompactTextString(m) }
func (*ClusterResponse) ProtoMessage()               {}
func (*ClusterResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{19} }

// DrainRequest requests the server to enter the specified draining mode. The
// server first deactivates all the modes specified in 'off' and then activates
// all those in 'on'.
type DrainRequest struct {
	// These are actually of type DrainMode, but grpc-gateway does not support
	// proxying enum fields (yet:
	// https://github.com/grpc-ecosystem/grpc-gateway/issues/5) and it fails in
	// pretty dramatic ways (panics the server).
	On  []int32 `protobuf:"varint,1,rep,packed,name=on" json:"on,omitempty"`
	Off []int32 `protobuf:"varint,2,rep,packed,name=off" json:"off,omitempty"`
	// When true, terminates the process after the given drain modes have been
	// activated.
	Shutdown bool `protobuf:"varint,3,opt,name=shutdown,proto3" json:"shutdown,omitempty"`
}

func (m *DrainRequest) Reset()                    { *m = DrainRequest{} }
func (m *DrainRequest) String() string            { return proto.CompactTextString(m) }
func (*DrainRequest) ProtoMessage()               {}
func (*DrainRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{20} }

// DrainResponse is the response to a successful DrainRequest and lists the
// modes which are activated after having processing the request.
type DrainResponse struct {
	On []int32 `protobuf:"varint,1,rep,packed,name=on" json:"on,omitempty"`
}

func (m *DrainResponse) Reset()                    { *m = DrainResponse{} }
func (m *DrainResponse) String() string            { return proto.CompactTextString(m) }
func (*DrainResponse) ProtoMessage()               {}
func (*DrainResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{21} }

// DecommissionStatusRequest requests the decommissioning status for the
// specified or, if none are specified, all nodes.
type DecommissionStatusRequest struct {
	NodeIDs []github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,1,rep,packed,name=node_ids,json=nodeIds,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_ids,omitempty"`
}

func (m *DecommissionStatusRequest) Reset()                    { *m = DecommissionStatusRequest{} }
func (m *DecommissionStatusRequest) String() string            { return proto.CompactTextString(m) }
func (*DecommissionStatusRequest) ProtoMessage()               {}
func (*DecommissionStatusRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{22} }

// DecommissionRequest requests the server to set the Decommissioning flag on
// all nodes specified by 'node_id' to the value of 'decommissioning'.
//
// If no 'node_id' is given, targets the recipient node.
type DecommissionRequest struct {
	NodeIDs         []github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,1,rep,packed,name=node_ids,json=nodeIds,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_ids,omitempty"`
	Decommissioning bool                                                  `protobuf:"varint,2,opt,name=decommissioning,proto3" json:"decommissioning,omitempty"`
}

func (m *DecommissionRequest) Reset()                    { *m = DecommissionRequest{} }
func (m *DecommissionRequest) String() string            { return proto.CompactTextString(m) }
func (*DecommissionRequest) ProtoMessage()               {}
func (*DecommissionRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{23} }

// DecommissionStatusResponse lists decommissioning statuses for a number of NodeIDs.
type DecommissionStatusResponse struct {
	// Status of all affected nodes.
	Status []DecommissionStatusResponse_Status `protobuf:"bytes,2,rep,name=status" json:"status"`
}

func (m *DecommissionStatusResponse) Reset()                    { *m = DecommissionStatusResponse{} }
func (m *DecommissionStatusResponse) String() string            { return proto.CompactTextString(m) }
func (*DecommissionStatusResponse) ProtoMessage()               {}
func (*DecommissionStatusResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{24} }

type DecommissionStatusResponse_Status struct {
	NodeID github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,1,opt,name=node_id,json=nodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id,omitempty"`
	IsLive bool                                                `protobuf:"varint,2,opt,name=is_live,json=isLive,proto3" json:"is_live,omitempty"`
	// The number of replicas on the node, computed by scanning meta2 ranges.
	ReplicaCount    int64 `protobuf:"varint,3,opt,name=replica_count,json=replicaCount,proto3" json:"replica_count,omitempty"`
	Decommissioning bool  `protobuf:"varint,4,opt,name=decommissioning,proto3" json:"decommissioning,omitempty"`
	Draining        bool  `protobuf:"varint,5,opt,name=draining,proto3" json:"draining,omitempty"`
}

func (m *DecommissionStatusResponse_Status) Reset()         { *m = DecommissionStatusResponse_Status{} }
func (m *DecommissionStatusResponse_Status) String() string { return proto.CompactTextString(m) }
func (*DecommissionStatusResponse_Status) ProtoMessage()    {}
func (*DecommissionStatusResponse_Status) Descriptor() ([]byte, []int) {
	return fileDescriptorAdmin, []int{24, 0}
}

// SettingsRequest inquires what are the current settings in the cluster.
type SettingsRequest struct {
	// The array of setting names to retrieve.
	// An empty keys array means "all".
	Keys []string `protobuf:"bytes,1,rep,name=keys" json:"keys,omitempty"`
}

func (m *SettingsRequest) Reset()                    { *m = SettingsRequest{} }
func (m *SettingsRequest) String() string            { return proto.CompactTextString(m) }
func (*SettingsRequest) ProtoMessage()               {}
func (*SettingsRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{25} }

// SettingsResponse is the response to SettingsRequest.
type SettingsResponse struct {
	KeyValues map[string]SettingsResponse_Value `protobuf:"bytes,1,rep,name=key_values,json=keyValues" json:"key_values" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *SettingsResponse) Reset()                    { *m = SettingsResponse{} }
func (m *SettingsResponse) String() string            { return proto.CompactTextString(m) }
func (*SettingsResponse) ProtoMessage()               {}
func (*SettingsResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{26} }

type SettingsResponse_Value struct {
	Value       string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	Type        string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
}

func (m *SettingsResponse_Value) Reset()                    { *m = SettingsResponse_Value{} }
func (m *SettingsResponse_Value) String() string            { return proto.CompactTextString(m) }
func (*SettingsResponse_Value) ProtoMessage()               {}
func (*SettingsResponse_Value) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{26, 0} }

// HealthRequest inquires whether the addressed node is healthy.
type HealthRequest struct {
}

func (m *HealthRequest) Reset()                    { *m = HealthRequest{} }
func (m *HealthRequest) String() string            { return proto.CompactTextString(m) }
func (*HealthRequest) ProtoMessage()               {}
func (*HealthRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{27} }

// HealthResponse is the response to HealthRequest. It currently does not
// contain any information. The request fails however if the node is not live.
// TODO(tschottdorf): Should it contain information, and if so, what?
type HealthResponse struct {
}

func (m *HealthResponse) Reset()                    { *m = HealthResponse{} }
func (m *HealthResponse) String() string            { return proto.CompactTextString(m) }
func (*HealthResponse) ProtoMessage()               {}
func (*HealthResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{28} }

// LivenessRequest requests liveness data for all nodes on the cluster.
type LivenessRequest struct {
}

func (m *LivenessRequest) Reset()                    { *m = LivenessRequest{} }
func (m *LivenessRequest) String() string            { return proto.CompactTextString(m) }
func (*LivenessRequest) ProtoMessage()               {}
func (*LivenessRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{29} }

// LivenessResponse contains the liveness status of each node on the cluster.
type LivenessResponse struct {
	Livenesses []cockroach_storage.Liveness                                                                 `protobuf:"bytes,1,rep,name=livenesses" json:"livenesses"`
	Statuses   map[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID]cockroach_storage.NodeLivenessStatus `protobuf:"bytes,2,rep,name=statuses,castkey=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"statuses" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=cockroach.storage.NodeLivenessStatus"`
}

func (m *LivenessResponse) Reset()                    { *m = LivenessResponse{} }
func (m *LivenessResponse) String() string            { return proto.CompactTextString(m) }
func (*LivenessResponse) ProtoMessage()               {}
func (*LivenessResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{30} }

// JobsRequest requests system job information of the given status and type.
type JobsRequest struct {
	Limit  int32                          `protobuf:"varint,1,opt,name=limit,proto3" json:"limit,omitempty"`
	Status string                         `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	Type   cockroach_sql_jobs_jobspb.Type `protobuf:"varint,3,opt,name=type,proto3,enum=cockroach.sql.jobs.jobspb.Type" json:"type,omitempty"`
}

func (m *JobsRequest) Reset()                    { *m = JobsRequest{} }
func (m *JobsRequest) String() string            { return proto.CompactTextString(m) }
func (*JobsRequest) ProtoMessage()               {}
func (*JobsRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{31} }

// JobsResponse contains the job record for each matching job.
type JobsResponse struct {
	Jobs []JobsResponse_Job `protobuf:"bytes,1,rep,name=jobs" json:"jobs"`
}

func (m *JobsResponse) Reset()                    { *m = JobsResponse{} }
func (m *JobsResponse) String() string            { return proto.CompactTextString(m) }
func (*JobsResponse) ProtoMessage()               {}
func (*JobsResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{32} }

type JobsResponse_Job struct {
	ID                int64                                                 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Type              string                                                `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	Description       string                                                `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	Username          string                                                `protobuf:"bytes,4,opt,name=username,proto3" json:"username,omitempty"`
	DescriptorIDs     []github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID `protobuf:"varint,5,rep,packed,name=descriptor_ids,json=descriptorIds,casttype=github.com/cockroachdb/cockroach/pkg/sql/sqlbase.ID" json:"descriptor_ids,omitempty"`
	Status            string                                                `protobuf:"bytes,6,opt,name=status,proto3" json:"status,omitempty"`
	Created           *time.Time                                            `protobuf:"bytes,7,opt,name=created,stdtime" json:"created,omitempty"`
	Started           *time.Time                                            `protobuf:"bytes,8,opt,name=started,stdtime" json:"started,omitempty"`
	Finished          *time.Time                                            `protobuf:"bytes,9,opt,name=finished,stdtime" json:"finished,omitempty"`
	Modified          *time.Time                                            `protobuf:"bytes,10,opt,name=modified,stdtime" json:"modified,omitempty"`
	FractionCompleted float32                                               `protobuf:"fixed32,11,opt,name=fraction_completed,json=fractionCompleted,proto3" json:"fraction_completed,omitempty"`
	Error             string                                                `protobuf:"bytes,12,opt,name=error,proto3" json:"error,omitempty"`
	// highwater_timestamp is the highwater timestamp returned as normal
	// timestamp. This is appropriate for display to humans.
	HighwaterTimestamp *time.Time `protobuf:"bytes,13,opt,name=highwater_timestamp,json=highwaterTimestamp,stdtime" json:"highwater_timestamp,omitempty"`
	// highwater_decimal is the highwater timestamp in the proprietary decimal
	// form used by logical timestamps internally. This is appropriate to pass
	// to a "AS OF SYSTEM TIME" SQL statement.
	HighwaterDecimal string `protobuf:"bytes,14,opt,name=highwater_decimal,json=highwaterDecimal,proto3" json:"highwater_decimal,omitempty"`
}

func (m *JobsResponse_Job) Reset()                    { *m = JobsResponse_Job{} }
func (m *JobsResponse_Job) String() string            { return proto.CompactTextString(m) }
func (*JobsResponse_Job) ProtoMessage()               {}
func (*JobsResponse_Job) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{32, 0} }

// LocationsRequest requests system locality location information.
type LocationsRequest struct {
}

func (m *LocationsRequest) Reset()                    { *m = LocationsRequest{} }
func (m *LocationsRequest) String() string            { return proto.CompactTextString(m) }
func (*LocationsRequest) ProtoMessage()               {}
func (*LocationsRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{33} }

// JobsResponse contains the job record for each matching job.
type LocationsResponse struct {
	Locations []LocationsResponse_Location `protobuf:"bytes,1,rep,name=locations" json:"locations"`
}

func (m *LocationsResponse) Reset()                    { *m = LocationsResponse{} }
func (m *LocationsResponse) String() string            { return proto.CompactTextString(m) }
func (*LocationsResponse) ProtoMessage()               {}
func (*LocationsResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{34} }

type LocationsResponse_Location struct {
	LocalityKey   string  `protobuf:"bytes,1,opt,name=locality_key,json=localityKey,proto3" json:"locality_key,omitempty"`
	LocalityValue string  `protobuf:"bytes,2,opt,name=locality_value,json=localityValue,proto3" json:"locality_value,omitempty"`
	Latitude      float64 `protobuf:"fixed64,3,opt,name=latitude,proto3" json:"latitude,omitempty"`
	Longitude     float64 `protobuf:"fixed64,4,opt,name=longitude,proto3" json:"longitude,omitempty"`
}

func (m *LocationsResponse_Location) Reset()         { *m = LocationsResponse_Location{} }
func (m *LocationsResponse_Location) String() string { return proto.CompactTextString(m) }
func (*LocationsResponse_Location) ProtoMessage()    {}
func (*LocationsResponse_Location) Descriptor() ([]byte, []int) {
	return fileDescriptorAdmin, []int{34, 0}
}

// RangeLogRequest request the history of a range from the range log.
type RangeLogRequest struct {
	// TODO(tamird): use [(gogoproto.customname) = "RangeID"] below. Need to
	// figure out how to teach grpc-gateway about custom names.
	// If RangeID is 0, returns range log history without filtering by range.
	RangeId int64 `protobuf:"varint,1,opt,name=range_id,json=rangeId,proto3" json:"range_id,omitempty"`
	// limit is the total number of results that are retrieved by the query. If
	// this is omitted or set to 0, the default maximum number of results are
	// returned. When set to > 0, at most only that number of results are
	// returned. When set to < 0, an unlimited number of results are returned.
	Limit int32 `protobuf:"varint,2,opt,name=limit,proto3" json:"limit,omitempty"`
}

func (m *RangeLogRequest) Reset()                    { *m = RangeLogRequest{} }
func (m *RangeLogRequest) String() string            { return proto.CompactTextString(m) }
func (*RangeLogRequest) ProtoMessage()               {}
func (*RangeLogRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{35} }

// RangeLogResponse contains a list of entries from the range log table.
type RangeLogResponse struct {
	Events []RangeLogResponse_Event `protobuf:"bytes,2,rep,name=events" json:"events"`
}

func (m *RangeLogResponse) Reset()                    { *m = RangeLogResponse{} }
func (m *RangeLogResponse) String() string            { return proto.CompactTextString(m) }
func (*RangeLogResponse) ProtoMessage()               {}
func (*RangeLogResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{36} }

// To avoid porting the pretty printing of keys and descriptors to
// javascript, they will be precomputed on the serverside.
type RangeLogResponse_PrettyInfo struct {
	UpdatedDesc    string `protobuf:"bytes,1,opt,name=updated_desc,json=updatedDesc,proto3" json:"updated_desc,omitempty"`
	NewDesc        string `protobuf:"bytes,2,opt,name=new_desc,json=newDesc,proto3" json:"new_desc,omitempty"`
	AddedReplica   string `protobuf:"bytes,3,opt,name=added_replica,json=addedReplica,proto3" json:"added_replica,omitempty"`
	RemovedReplica string `protobuf:"bytes,4,opt,name=removed_replica,json=removedReplica,proto3" json:"removed_replica,omitempty"`
	Reason         string `protobuf:"bytes,5,opt,name=reason,proto3" json:"reason,omitempty"`
	Details        string `protobuf:"bytes,6,opt,name=details,proto3" json:"details,omitempty"`
}

func (m *RangeLogResponse_PrettyInfo) Reset()         { *m = RangeLogResponse_PrettyInfo{} }
func (m *RangeLogResponse_PrettyInfo) String() string { return proto.CompactTextString(m) }
func (*RangeLogResponse_PrettyInfo) ProtoMessage()    {}
func (*RangeLogResponse_PrettyInfo) Descriptor() ([]byte, []int) {
	return fileDescriptorAdmin, []int{36, 0}
}

type RangeLogResponse_Event struct {
	Event      cockroach_storage2.RangeLogEvent `protobuf:"bytes,1,opt,name=event" json:"event"`
	PrettyInfo RangeLogResponse_PrettyInfo      `protobuf:"bytes,2,opt,name=pretty_info,json=prettyInfo" json:"pretty_info"`
}

func (m *RangeLogResponse_Event) Reset()                    { *m = RangeLogResponse_Event{} }
func (m *RangeLogResponse_Event) String() string            { return proto.CompactTextString(m) }
func (*RangeLogResponse_Event) ProtoMessage()               {}
func (*RangeLogResponse_Event) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{36, 1} }

// QueryPlanRequest requests the query plans for a SQL string.
type QueryPlanRequest struct {
	// query is the SQL query string.
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
}

func (m *QueryPlanRequest) Reset()                    { *m = QueryPlanRequest{} }
func (m *QueryPlanRequest) String() string            { return proto.CompactTextString(m) }
func (*QueryPlanRequest) ProtoMessage()               {}
func (*QueryPlanRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{37} }

// QueryPlanResponse contains the query plans for a SQL string (currently only
// the distsql physical query plan).
type QueryPlanResponse struct {
	DistSQLPhysicalQueryPlan string `protobuf:"bytes,1,opt,name=distsql_physical_query_plan,json=distsqlPhysicalQueryPlan,proto3" json:"distsql_physical_query_plan,omitempty"`
}

func (m *QueryPlanResponse) Reset()                    { *m = QueryPlanResponse{} }
func (m *QueryPlanResponse) String() string            { return proto.CompactTextString(m) }
func (*QueryPlanResponse) ProtoMessage()               {}
func (*QueryPlanResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{38} }

type DataDistributionRequest struct {
}

func (m *DataDistributionRequest) Reset()                    { *m = DataDistributionRequest{} }
func (m *DataDistributionRequest) String() string            { return proto.CompactTextString(m) }
func (*DataDistributionRequest) ProtoMessage()               {}
func (*DataDistributionRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{39} }

type DataDistributionResponse struct {
	// By database name.
	DatabaseInfo map[string]DataDistributionResponse_DatabaseInfo `protobuf:"bytes,1,rep,name=database_info,json=databaseInfo" json:"database_info" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
	// By zone name.
	ZoneConfigs map[string]DataDistributionResponse_ZoneConfig `protobuf:"bytes,3,rep,name=zone_configs,json=zoneConfigs" json:"zone_configs" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *DataDistributionResponse) Reset()                    { *m = DataDistributionResponse{} }
func (m *DataDistributionResponse) String() string            { return proto.CompactTextString(m) }
func (*DataDistributionResponse) ProtoMessage()               {}
func (*DataDistributionResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{40} }

type DataDistributionResponse_ZoneConfig struct {
	// zone_name is ".default" for the default zone config.
	// Otherwise, it's of the form [database.]table[@index[.partition]]
	ZoneName string                      `protobuf:"bytes,1,opt,name=zone_name,json=zoneName,proto3" json:"zone_name,omitempty"`
	Config   cockroach_config.ZoneConfig `protobuf:"bytes,2,opt,name=config" json:"config"`
	// config_sql is the SQL representation of config.
	ConfigSQL string `protobuf:"bytes,4,opt,name=config_sql,json=configSql,proto3" json:"config_sql,omitempty"`
}

func (m *DataDistributionResponse_ZoneConfig) Reset()         { *m = DataDistributionResponse_ZoneConfig{} }
func (m *DataDistributionResponse_ZoneConfig) String() string { return proto.CompactTextString(m) }
func (*DataDistributionResponse_ZoneConfig) ProtoMessage()    {}
func (*DataDistributionResponse_ZoneConfig) Descriptor() ([]byte, []int) {
	return fileDescriptorAdmin, []int{40, 0}
}

type DataDistributionResponse_TableInfo struct {
	ReplicaCountByNodeId map[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID]int64 `protobuf:"bytes,1,rep,name=replica_count_by_node_id,json=replicaCountByNodeId,castkey=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"replica_count_by_node_id,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	ZoneConfigId         int64                                                         `protobuf:"varint,2,opt,name=zone_config_id,json=zoneConfigId,proto3" json:"zone_config_id,omitempty"`
	DroppedAt            *time.Time                                                    `protobuf:"bytes,3,opt,name=dropped_at,json=droppedAt,stdtime" json:"dropped_at,omitempty"`
}

func (m *DataDistributionResponse_TableInfo) Reset()         { *m = DataDistributionResponse_TableInfo{} }
func (m *DataDistributionResponse_TableInfo) String() string { return proto.CompactTextString(m) }
func (*DataDistributionResponse_TableInfo) ProtoMessage()    {}
func (*DataDistributionResponse_TableInfo) Descriptor() ([]byte, []int) {
	return fileDescriptorAdmin, []int{40, 1}
}

type DataDistributionResponse_DatabaseInfo struct {
	// By table name.
	TableInfo map[string]DataDistributionResponse_TableInfo `protobuf:"bytes,1,rep,name=table_info,json=tableInfo" json:"table_info" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *DataDistributionResponse_DatabaseInfo) Reset()         { *m = DataDistributionResponse_DatabaseInfo{} }
func (m *DataDistributionResponse_DatabaseInfo) String() string { return proto.CompactTextString(m) }
func (*DataDistributionResponse_DatabaseInfo) ProtoMessage()    {}
func (*DataDistributionResponse_DatabaseInfo) Descriptor() ([]byte, []int) {
	return fileDescriptorAdmin, []int{40, 2}
}

// MetricMetadataRequest requests metadata for all metrics.
type MetricMetadataRequest struct {
}

func (m *MetricMetadataRequest) Reset()                    { *m = MetricMetadataRequest{} }
func (m *MetricMetadataRequest) String() string            { return proto.CompactTextString(m) }
func (*MetricMetadataRequest) ProtoMessage()               {}
func (*MetricMetadataRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{41} }

// MetricMetadataResponse contains the metadata for all metics.
type MetricMetadataResponse struct {
	Metadata map[string]cockroach_util_metric.Metadata `protobuf:"bytes,1,rep,name=metadata" json:"metadata" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *MetricMetadataResponse) Reset()                    { *m = MetricMetadataResponse{} }
func (m *MetricMetadataResponse) String() string            { return proto.CompactTextString(m) }
func (*MetricMetadataResponse) ProtoMessage()               {}
func (*MetricMetadataResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{42} }

type EnqueueRangeRequest struct {
	// The node on which the queue should process the range. If node_id is 0,
	// the request will be forwarded to all other nodes.
	NodeID github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,1,opt,name=node_id,json=nodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id,omitempty"`
	// The name of the replica queue to run the range through. Matched against
	// each queue's name field. See the implementation of baseQueue for details.
	Queue string `protobuf:"bytes,2,opt,name=queue,proto3" json:"queue,omitempty"`
	// The ID of the range to run through the queue.
	RangeID github_com_cockroachdb_cockroach_pkg_roachpb.RangeID `protobuf:"varint,3,opt,name=range_id,json=rangeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RangeID" json:"range_id,omitempty"`
	// If set, run the queue's process method without first checking whether the
	// replica should be processed by calling shouldQueue.
	SkipShouldQueue bool `protobuf:"varint,4,opt,name=skip_should_queue,json=skipShouldQueue,proto3" json:"skip_should_queue,omitempty"`
}

func (m *EnqueueRangeRequest) Reset()                    { *m = EnqueueRangeRequest{} }
func (m *EnqueueRangeRequest) String() string            { return proto.CompactTextString(m) }
func (*EnqueueRangeRequest) ProtoMessage()               {}
func (*EnqueueRangeRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{43} }

type EnqueueRangeResponse struct {
	Details []*EnqueueRangeResponse_Details `protobuf:"bytes,1,rep,name=details" json:"details,omitempty"`
}

func (m *EnqueueRangeResponse) Reset()                    { *m = EnqueueRangeResponse{} }
func (m *EnqueueRangeResponse) String() string            { return proto.CompactTextString(m) }
func (*EnqueueRangeResponse) ProtoMessage()               {}
func (*EnqueueRangeResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{44} }

type EnqueueRangeResponse_Details struct {
	NodeID github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,1,opt,name=node_id,json=nodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id,omitempty"`
	// All trace events collected while processing the range in the queue.
	Events []*TraceEvent `protobuf:"bytes,2,rep,name=events" json:"events,omitempty"`
	// The error message from the queue's processing, if any.
	Error string `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
}

func (m *EnqueueRangeResponse_Details) Reset()         { *m = EnqueueRangeResponse_Details{} }
func (m *EnqueueRangeResponse_Details) String() string { return proto.CompactTextString(m) }
func (*EnqueueRangeResponse_Details) ProtoMessage()    {}
func (*EnqueueRangeResponse_Details) Descriptor() ([]byte, []int) {
	return fileDescriptorAdmin, []int{44, 0}
}

func init() {
	proto.RegisterType((*DatabasesRequest)(nil), "cockroach.server.serverpb.DatabasesRequest")
	proto.RegisterType((*DatabasesResponse)(nil), "cockroach.server.serverpb.DatabasesResponse")
	proto.RegisterType((*DatabaseDetailsRequest)(nil), "cockroach.server.serverpb.DatabaseDetailsRequest")
	proto.RegisterType((*DatabaseDetailsResponse)(nil), "cockroach.server.serverpb.DatabaseDetailsResponse")
	proto.RegisterType((*DatabaseDetailsResponse_Grant)(nil), "cockroach.server.serverpb.DatabaseDetailsResponse.Grant")
	proto.RegisterType((*TableDetailsRequest)(nil), "cockroach.server.serverpb.TableDetailsRequest")
	proto.RegisterType((*TableDetailsResponse)(nil), "cockroach.server.serverpb.TableDetailsResponse")
	proto.RegisterType((*TableDetailsResponse_Grant)(nil), "cockroach.server.serverpb.TableDetailsResponse.Grant")
	proto.RegisterType((*TableDetailsResponse_Column)(nil), "cockroach.server.serverpb.TableDetailsResponse.Column")
	proto.RegisterType((*TableDetailsResponse_Index)(nil), "cockroach.server.serverpb.TableDetailsResponse.Index")
	proto.RegisterType((*TableStatsRequest)(nil), "cockroach.server.serverpb.TableStatsRequest")
	proto.RegisterType((*TableStatsResponse)(nil), "cockroach.server.serverpb.TableStatsResponse")
	proto.RegisterType((*TableStatsResponse_MissingNode)(nil), "cockroach.server.serverpb.TableStatsResponse.MissingNode")
	proto.RegisterType((*NonTableStatsRequest)(nil), "cockroach.server.serverpb.NonTableStatsRequest")
	proto.RegisterType((*NonTableStatsResponse)(nil), "cockroach.server.serverpb.NonTableStatsResponse")
	proto.RegisterType((*UsersRequest)(nil), "cockroach.server.serverpb.UsersRequest")
	proto.RegisterType((*UsersResponse)(nil), "cockroach.server.serverpb.UsersResponse")
	proto.RegisterType((*UsersResponse_User)(nil), "cockroach.server.serverpb.UsersResponse.User")
	proto.RegisterType((*EventsRequest)(nil), "cockroach.server.serverpb.EventsRequest")
	proto.RegisterType((*EventsResponse)(nil), "cockroach.server.serverpb.EventsResponse")
	proto.RegisterType((*EventsResponse_Event)(nil), "cockroach.server.serverpb.EventsResponse.Event")
	proto.RegisterType((*SetUIDataRequest)(nil), "cockroach.server.serverpb.SetUIDataRequest")
	proto.RegisterType((*SetUIDataResponse)(nil), "cockroach.server.serverpb.SetUIDataResponse")
	proto.RegisterType((*GetUIDataRequest)(nil), "cockroach.server.serverpb.GetUIDataRequest")
	proto.RegisterType((*GetUIDataResponse)(nil), "cockroach.server.serverpb.GetUIDataResponse")
	proto.RegisterType((*GetUIDataResponse_Value)(nil), "cockroach.server.serverpb.GetUIDataResponse.Value")
	proto.RegisterType((*ClusterRequest)(nil), "cockroach.server.serverpb.ClusterRequest")
	proto.RegisterType((*ClusterResponse)(nil), "cockroach.server.serverpb.ClusterResponse")
	proto.RegisterType((*DrainRequest)(nil), "cockroach.server.serverpb.DrainRequest")
	proto.RegisterType((*DrainResponse)(nil), "cockroach.server.serverpb.DrainResponse")
	proto.RegisterType((*DecommissionStatusRequest)(nil), "cockroach.server.serverpb.DecommissionStatusRequest")
	proto.RegisterType((*DecommissionRequest)(nil), "cockroach.server.serverpb.DecommissionRequest")
	proto.RegisterType((*DecommissionStatusResponse)(nil), "cockroach.server.serverpb.DecommissionStatusResponse")
	proto.RegisterType((*DecommissionStatusResponse_Status)(nil), "cockroach.server.serverpb.DecommissionStatusResponse.Status")
	proto.RegisterType((*SettingsRequest)(nil), "cockroach.server.serverpb.SettingsRequest")
	proto.RegisterType((*SettingsResponse)(nil), "cockroach.server.serverpb.SettingsResponse")
	proto.RegisterType((*SettingsResponse_Value)(nil), "cockroach.server.serverpb.SettingsResponse.Value")
	proto.RegisterType((*HealthRequest)(nil), "cockroach.server.serverpb.HealthRequest")
	proto.RegisterType((*HealthResponse)(nil), "cockroach.server.serverpb.HealthResponse")
	proto.RegisterType((*LivenessRequest)(nil), "cockroach.server.serverpb.LivenessRequest")
	proto.RegisterType((*LivenessResponse)(nil), "cockroach.server.serverpb.LivenessResponse")
	proto.RegisterType((*JobsRequest)(nil), "cockroach.server.serverpb.JobsRequest")
	proto.RegisterType((*JobsResponse)(nil), "cockroach.server.serverpb.JobsResponse")
	proto.RegisterType((*JobsResponse_Job)(nil), "cockroach.server.serverpb.JobsResponse.Job")
	proto.RegisterType((*LocationsRequest)(nil), "cockroach.server.serverpb.LocationsRequest")
	proto.RegisterType((*LocationsResponse)(nil), "cockroach.server.serverpb.LocationsResponse")
	proto.RegisterType((*LocationsResponse_Location)(nil), "cockroach.server.serverpb.LocationsResponse.Location")
	proto.RegisterType((*RangeLogRequest)(nil), "cockroach.server.serverpb.RangeLogRequest")
	proto.RegisterType((*RangeLogResponse)(nil), "cockroach.server.serverpb.RangeLogResponse")
	proto.RegisterType((*RangeLogResponse_PrettyInfo)(nil), "cockroach.server.serverpb.RangeLogResponse.PrettyInfo")
	proto.RegisterType((*RangeLogResponse_Event)(nil), "cockroach.server.serverpb.RangeLogResponse.Event")
	proto.RegisterType((*QueryPlanRequest)(nil), "cockroach.server.serverpb.QueryPlanRequest")
	proto.RegisterType((*QueryPlanResponse)(nil), "cockroach.server.serverpb.QueryPlanResponse")
	proto.RegisterType((*DataDistributionRequest)(nil), "cockroach.server.serverpb.DataDistributionRequest")
	proto.RegisterType((*DataDistributionResponse)(nil), "cockroach.server.serverpb.DataDistributionResponse")
	proto.RegisterType((*DataDistributionResponse_ZoneConfig)(nil), "cockroach.server.serverpb.DataDistributionResponse.ZoneConfig")
	proto.RegisterType((*DataDistributionResponse_TableInfo)(nil), "cockroach.server.serverpb.DataDistributionResponse.TableInfo")
	proto.RegisterType((*DataDistributionResponse_DatabaseInfo)(nil), "cockroach.server.serverpb.DataDistributionResponse.DatabaseInfo")
	proto.RegisterType((*MetricMetadataRequest)(nil), "cockroach.server.serverpb.MetricMetadataRequest")
	proto.RegisterType((*MetricMetadataResponse)(nil), "cockroach.server.serverpb.MetricMetadataResponse")
	proto.RegisterType((*EnqueueRangeRequest)(nil), "cockroach.server.serverpb.EnqueueRangeRequest")
	proto.RegisterType((*EnqueueRangeResponse)(nil), "cockroach.server.serverpb.EnqueueRangeResponse")
	proto.RegisterType((*EnqueueRangeResponse_Details)(nil), "cockroach.server.serverpb.EnqueueRangeResponse.Details")
	proto.RegisterEnum("cockroach.server.serverpb.ZoneConfigurationLevel", ZoneConfigurationLevel_name, ZoneConfigurationLevel_value)
	proto.RegisterEnum("cockroach.server.serverpb.DrainMode", DrainMode_name, DrainMode_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Admin service

type AdminClient interface {
	// URL: /_admin/v1/users
	Users(ctx context.Context, in *UsersRequest, opts ...grpc.CallOption) (*UsersResponse, error)
	// URL: /_admin/v1/databases
	Databases(ctx context.Context, in *DatabasesRequest, opts ...grpc.CallOption) (*DatabasesResponse, error)
	// Example URL: /_admin/v1/databases/system
	DatabaseDetails(ctx context.Context, in *DatabaseDetailsRequest, opts ...grpc.CallOption) (*DatabaseDetailsResponse, error)
	// Example URL: /_admin/v1/databases/system/tables/ui
	TableDetails(ctx context.Context, in *TableDetailsRequest, opts ...grpc.CallOption) (*TableDetailsResponse, error)
	// Example URL: /_admin/v1/databases/system/tables/ui/stats
	TableStats(ctx context.Context, in *TableStatsRequest, opts ...grpc.CallOption) (*TableStatsResponse, error)
	// Example URL: /_admin/v1/nontablestats
	NonTableStats(ctx context.Context, in *NonTableStatsRequest, opts ...grpc.CallOption) (*NonTableStatsResponse, error)
	// Example URLs:
	// Example URLs:
	// - /_admin/v1/events
	// - /_admin/v1/events?limit=100
	// - /_admin/v1/events?type=create_table
	// - /_admin/v1/events?type=create_table&limit=100
	// - /_admin/v1/events?type=drop_table&target_id=4
	// - /_admin/v1/events?type=drop_table&target_id=4&limit=100
	Events(ctx context.Context, in *EventsRequest, opts ...grpc.CallOption) (*EventsResponse, error)
	// This requires a POST. Because of the libraries we're using, the POST body
	// must be in the following format:
	//
	// {"key_values":
	//   { "key1": "base64_encoded_value1"},
	//   ...
	//   { "keyN": "base64_encoded_valueN"},
	// }
	//
	// Note that all keys are quoted strings and that all values are base64-
	// encoded.
	//
	// Together, SetUIData and GetUIData provide access to a "cookie jar" for the
	// admin UI. The structure of the underlying data is meant to be opaque to the
	// server.
	SetUIData(ctx context.Context, in *SetUIDataRequest, opts ...grpc.CallOption) (*SetUIDataResponse, error)
	// Example URLs:
	// - /_admin/v1/uidata?keys=MYKEY
	// - /_admin/v1/uidata?keys=MYKEY1&keys=MYKEY2
	//
	// Yes, it's a little odd that the query parameter is named "keys" instead of
	// "key". I would've preferred that the URL parameter be named "key". However,
	// it's clearer for the protobuf field to be named "keys," which makes the URL
	// parameter "keys" as well.
	GetUIData(ctx context.Context, in *GetUIDataRequest, opts ...grpc.CallOption) (*GetUIDataResponse, error)
	// Cluster returns metadata for the cluster.
	Cluster(ctx context.Context, in *ClusterRequest, opts ...grpc.CallOption) (*ClusterResponse, error)
	// Settings returns the cluster-wide settings for the cluster.
	Settings(ctx context.Context, in *SettingsRequest, opts ...grpc.CallOption) (*SettingsResponse, error)
	// Health returns liveness for the node target of the request.
	Health(ctx context.Context, in *HealthRequest, opts ...grpc.CallOption) (*HealthResponse, error)
	// Liveness returns the liveness state of all nodes on the cluster.
	Liveness(ctx context.Context, in *LivenessRequest, opts ...grpc.CallOption) (*LivenessResponse, error)
	// Jobs returns the job records for all jobs of the given status and type.
	Jobs(ctx context.Context, in *JobsRequest, opts ...grpc.CallOption) (*JobsResponse, error)
	// Locations returns the locality location records.
	Locations(ctx context.Context, in *LocationsRequest, opts ...grpc.CallOption) (*LocationsResponse, error)
	// QueryPlan returns the query plans for a SQL string.
	QueryPlan(ctx context.Context, in *QueryPlanRequest, opts ...grpc.CallOption) (*QueryPlanResponse, error)
	// Drain puts the node into the specified drain mode(s) and optionally
	// instructs the process to terminate.
	Drain(ctx context.Context, in *DrainRequest, opts ...grpc.CallOption) (Admin_DrainClient, error)
	// Decommission puts the node(s) into the specified decommissioning state.
	Decommission(ctx context.Context, in *DecommissionRequest, opts ...grpc.CallOption) (*DecommissionStatusResponse, error)
	// DecommissionStatus retrieves the decommissioning status of the specified nodes.
	DecommissionStatus(ctx context.Context, in *DecommissionStatusRequest, opts ...grpc.CallOption) (*DecommissionStatusResponse, error)
	// URL: /_admin/v1/rangelog
	// URL: /_admin/v1/rangelog?limit=100
	// URL: /_admin/v1/rangelog/1
	// URL: /_admin/v1/rangelog/1?limit=100
	RangeLog(ctx context.Context, in *RangeLogRequest, opts ...grpc.CallOption) (*RangeLogResponse, error)
	DataDistribution(ctx context.Context, in *DataDistributionRequest, opts ...grpc.CallOption) (*DataDistributionResponse, error)
	// URL: /_admin/v1/metricmetadata
	AllMetricMetadata(ctx context.Context, in *MetricMetadataRequest, opts ...grpc.CallOption) (*MetricMetadataResponse, error)
	// EnqueueRange runs the specified range through the specified queue on the
	// range's leaseholder store, returning the detailed trace and error
	// information from doing so. Parameters must be provided in the body of the
	// POST request.
	// For example:
	//
	// {
	//   "queue": "raftlog",
	//   "rangeId": 10
	// }
	EnqueueRange(ctx context.Context, in *EnqueueRangeRequest, opts ...grpc.CallOption) (*EnqueueRangeResponse, error)
}

type adminClient struct {
	cc *grpc.ClientConn
}

func NewAdminClient(cc *grpc.ClientConn) AdminClient {
	return &adminClient{cc}
}

func (c *adminClient) Users(ctx context.Context, in *UsersRequest, opts ...grpc.CallOption) (*UsersResponse, error) {
	out := new(UsersResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/Users", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) Databases(ctx context.Context, in *DatabasesRequest, opts ...grpc.CallOption) (*DatabasesResponse, error) {
	out := new(DatabasesResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/Databases", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) DatabaseDetails(ctx context.Context, in *DatabaseDetailsRequest, opts ...grpc.CallOption) (*DatabaseDetailsResponse, error) {
	out := new(DatabaseDetailsResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/DatabaseDetails", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) TableDetails(ctx context.Context, in *TableDetailsRequest, opts ...grpc.CallOption) (*TableDetailsResponse, error) {
	out := new(TableDetailsResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/TableDetails", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) TableStats(ctx context.Context, in *TableStatsRequest, opts ...grpc.CallOption) (*TableStatsResponse, error) {
	out := new(TableStatsResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/TableStats", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) NonTableStats(ctx context.Context, in *NonTableStatsRequest, opts ...grpc.CallOption) (*NonTableStatsResponse, error) {
	out := new(NonTableStatsResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/NonTableStats", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) Events(ctx context.Context, in *EventsRequest, opts ...grpc.CallOption) (*EventsResponse, error) {
	out := new(EventsResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/Events", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) SetUIData(ctx context.Context, in *SetUIDataRequest, opts ...grpc.CallOption) (*SetUIDataResponse, error) {
	out := new(SetUIDataResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/SetUIData", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) GetUIData(ctx context.Context, in *GetUIDataRequest, opts ...grpc.CallOption) (*GetUIDataResponse, error) {
	out := new(GetUIDataResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/GetUIData", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) Cluster(ctx context.Context, in *ClusterRequest, opts ...grpc.CallOption) (*ClusterResponse, error) {
	out := new(ClusterResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/Cluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) Settings(ctx context.Context, in *SettingsRequest, opts ...grpc.CallOption) (*SettingsResponse, error) {
	out := new(SettingsResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/Settings", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) Health(ctx context.Context, in *HealthRequest, opts ...grpc.CallOption) (*HealthResponse, error) {
	out := new(HealthResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/Health", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) Liveness(ctx context.Context, in *LivenessRequest, opts ...grpc.CallOption) (*LivenessResponse, error) {
	out := new(LivenessResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/Liveness", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) Jobs(ctx context.Context, in *JobsRequest, opts ...grpc.CallOption) (*JobsResponse, error) {
	out := new(JobsResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/Jobs", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) Locations(ctx context.Context, in *LocationsRequest, opts ...grpc.CallOption) (*LocationsResponse, error) {
	out := new(LocationsResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/Locations", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) QueryPlan(ctx context.Context, in *QueryPlanRequest, opts ...grpc.CallOption) (*QueryPlanResponse, error) {
	out := new(QueryPlanResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/QueryPlan", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) Drain(ctx context.Context, in *DrainRequest, opts ...grpc.CallOption) (Admin_DrainClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Admin_serviceDesc.Streams[0], c.cc, "/cockroach.server.serverpb.Admin/Drain", opts...)
	if err != nil {
		return nil, err
	}
	x := &adminDrainClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Admin_DrainClient interface {
	Recv() (*DrainResponse, error)
	grpc.ClientStream
}

type adminDrainClient struct {
	grpc.ClientStream
}

func (x *adminDrainClient) Recv() (*DrainResponse, error) {
	m := new(DrainResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *adminClient) Decommission(ctx context.Context, in *DecommissionRequest, opts ...grpc.CallOption) (*DecommissionStatusResponse, error) {
	out := new(DecommissionStatusResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/Decommission", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) DecommissionStatus(ctx context.Context, in *DecommissionStatusRequest, opts ...grpc.CallOption) (*DecommissionStatusResponse, error) {
	out := new(DecommissionStatusResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/DecommissionStatus", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) RangeLog(ctx context.Context, in *RangeLogRequest, opts ...grpc.CallOption) (*RangeLogResponse, error) {
	out := new(RangeLogResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/RangeLog", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) DataDistribution(ctx context.Context, in *DataDistributionRequest, opts ...grpc.CallOption) (*DataDistributionResponse, error) {
	out := new(DataDistributionResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/DataDistribution", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) AllMetricMetadata(ctx context.Context, in *MetricMetadataRequest, opts ...grpc.CallOption) (*MetricMetadataResponse, error) {
	out := new(MetricMetadataResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/AllMetricMetadata", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) EnqueueRange(ctx context.Context, in *EnqueueRangeRequest, opts ...grpc.CallOption) (*EnqueueRangeResponse, error) {
	out := new(EnqueueRangeResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/EnqueueRange", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Admin service

type AdminServer interface {
	// URL: /_admin/v1/users
	Users(context.Context, *UsersRequest) (*UsersResponse, error)
	// URL: /_admin/v1/databases
	Databases(context.Context, *DatabasesRequest) (*DatabasesResponse, error)
	// Example URL: /_admin/v1/databases/system
	DatabaseDetails(context.Context, *DatabaseDetailsRequest) (*DatabaseDetailsResponse, error)
	// Example URL: /_admin/v1/databases/system/tables/ui
	TableDetails(context.Context, *TableDetailsRequest) (*TableDetailsResponse, error)
	// Example URL: /_admin/v1/databases/system/tables/ui/stats
	TableStats(context.Context, *TableStatsRequest) (*TableStatsResponse, error)
	// Example URL: /_admin/v1/nontablestats
	NonTableStats(context.Context, *NonTableStatsRequest) (*NonTableStatsResponse, error)
	// Example URLs:
	// Example URLs:
	// - /_admin/v1/events
	// - /_admin/v1/events?limit=100
	// - /_admin/v1/events?type=create_table
	// - /_admin/v1/events?type=create_table&limit=100
	// - /_admin/v1/events?type=drop_table&target_id=4
	// - /_admin/v1/events?type=drop_table&target_id=4&limit=100
	Events(context.Context, *EventsRequest) (*EventsResponse, error)
	// This requires a POST. Because of the libraries we're using, the POST body
	// must be in the following format:
	//
	// {"key_values":
	//   { "key1": "base64_encoded_value1"},
	//   ...
	//   { "keyN": "base64_encoded_valueN"},
	// }
	//
	// Note that all keys are quoted strings and that all values are base64-
	// encoded.
	//
	// Together, SetUIData and GetUIData provide access to a "cookie jar" for the
	// admin UI. The structure of the underlying data is meant to be opaque to the
	// server.
	SetUIData(context.Context, *SetUIDataRequest) (*SetUIDataResponse, error)
	// Example URLs:
	// - /_admin/v1/uidata?keys=MYKEY
	// - /_admin/v1/uidata?keys=MYKEY1&keys=MYKEY2
	//
	// Yes, it's a little odd that the query parameter is named "keys" instead of
	// "key". I would've preferred that the URL parameter be named "key". However,
	// it's clearer for the protobuf field to be named "keys," which makes the URL
	// parameter "keys" as well.
	GetUIData(context.Context, *GetUIDataRequest) (*GetUIDataResponse, error)
	// Cluster returns metadata for the cluster.
	Cluster(context.Context, *ClusterRequest) (*ClusterResponse, error)
	// Settings returns the cluster-wide settings for the cluster.
	Settings(context.Context, *SettingsRequest) (*SettingsResponse, error)
	// Health returns liveness for the node target of the request.
	Health(context.Context, *HealthRequest) (*HealthResponse, error)
	// Liveness returns the liveness state of all nodes on the cluster.
	Liveness(context.Context, *LivenessRequest) (*LivenessResponse, error)
	// Jobs returns the job records for all jobs of the given status and type.
	Jobs(context.Context, *JobsRequest) (*JobsResponse, error)
	// Locations returns the locality location records.
	Locations(context.Context, *LocationsRequest) (*LocationsResponse, error)
	// QueryPlan returns the query plans for a SQL string.
	QueryPlan(context.Context, *QueryPlanRequest) (*QueryPlanResponse, error)
	// Drain puts the node into the specified drain mode(s) and optionally
	// instructs the process to terminate.
	Drain(*DrainRequest, Admin_DrainServer) error
	// Decommission puts the node(s) into the specified decommissioning state.
	Decommission(context.Context, *DecommissionRequest) (*DecommissionStatusResponse, error)
	// DecommissionStatus retrieves the decommissioning status of the specified nodes.
	DecommissionStatus(context.Context, *DecommissionStatusRequest) (*DecommissionStatusResponse, error)
	// URL: /_admin/v1/rangelog
	// URL: /_admin/v1/rangelog?limit=100
	// URL: /_admin/v1/rangelog/1
	// URL: /_admin/v1/rangelog/1?limit=100
	RangeLog(context.Context, *RangeLogRequest) (*RangeLogResponse, error)
	DataDistribution(context.Context, *DataDistributionRequest) (*DataDistributionResponse, error)
	// URL: /_admin/v1/metricmetadata
	AllMetricMetadata(context.Context, *MetricMetadataRequest) (*MetricMetadataResponse, error)
	// EnqueueRange runs the specified range through the specified queue on the
	// range's leaseholder store, returning the detailed trace and error
	// information from doing so. Parameters must be provided in the body of the
	// POST request.
	// For example:
	//
	// {
	//   "queue": "raftlog",
	//   "rangeId": 10
	// }
	EnqueueRange(context.Context, *EnqueueRangeRequest) (*EnqueueRangeResponse, error)
}

func RegisterAdminServer(s *grpc.Server, srv AdminServer) {
	s.RegisterService(&_Admin_serviceDesc, srv)
}

func _Admin_Users_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UsersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).Users(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/Users",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).Users(ctx, req.(*UsersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_Databases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DatabasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).Databases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/Databases",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).Databases(ctx, req.(*DatabasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_DatabaseDetails_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DatabaseDetailsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).DatabaseDetails(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/DatabaseDetails",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).DatabaseDetails(ctx, req.(*DatabaseDetailsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_TableDetails_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TableDetailsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).TableDetails(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/TableDetails",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).TableDetails(ctx, req.(*TableDetailsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_TableStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TableStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).TableStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/TableStats",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).TableStats(ctx, req.(*TableStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_NonTableStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NonTableStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).NonTableStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/NonTableStats",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).NonTableStats(ctx, req.(*NonTableStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_Events_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).Events(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/Events",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).Events(ctx, req.(*EventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_SetUIData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetUIDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).SetUIData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/SetUIData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).SetUIData(ctx, req.(*SetUIDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_GetUIData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUIDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).GetUIData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/GetUIData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).GetUIData(ctx, req.(*GetUIDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_Cluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).Cluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/Cluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).Cluster(ctx, req.(*ClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_Settings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).Settings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/Settings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).Settings(ctx, req.(*SettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_Health_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HealthRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).Health(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/Health",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).Health(ctx, req.(*HealthRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_Liveness_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LivenessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).Liveness(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/Liveness",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).Liveness(ctx, req.(*LivenessRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_Jobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(JobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).Jobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/Jobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).Jobs(ctx, req.(*JobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_Locations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LocationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).Locations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/Locations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).Locations(ctx, req.(*LocationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_QueryPlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryPlanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).QueryPlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/QueryPlan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).QueryPlan(ctx, req.(*QueryPlanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_Drain_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(DrainRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(AdminServer).Drain(m, &adminDrainServer{stream})
}

type Admin_DrainServer interface {
	Send(*DrainResponse) error
	grpc.ServerStream
}

type adminDrainServer struct {
	grpc.ServerStream
}

func (x *adminDrainServer) Send(m *DrainResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Admin_Decommission_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DecommissionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).Decommission(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/Decommission",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).Decommission(ctx, req.(*DecommissionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_DecommissionStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DecommissionStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).DecommissionStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/DecommissionStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).DecommissionStatus(ctx, req.(*DecommissionStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_RangeLog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RangeLogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).RangeLog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/RangeLog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).RangeLog(ctx, req.(*RangeLogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_DataDistribution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DataDistributionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).DataDistribution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/DataDistribution",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).DataDistribution(ctx, req.(*DataDistributionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_AllMetricMetadata_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MetricMetadataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).AllMetricMetadata(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/AllMetricMetadata",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).AllMetricMetadata(ctx, req.(*MetricMetadataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_EnqueueRange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EnqueueRangeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).EnqueueRange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/EnqueueRange",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).EnqueueRange(ctx, req.(*EnqueueRangeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Admin_serviceDesc = grpc.ServiceDesc{
	ServiceName: "cockroach.server.serverpb.Admin",
	HandlerType: (*AdminServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Users",
			Handler:    _Admin_Users_Handler,
		},
		{
			MethodName: "Databases",
			Handler:    _Admin_Databases_Handler,
		},
		{
			MethodName: "DatabaseDetails",
			Handler:    _Admin_DatabaseDetails_Handler,
		},
		{
			MethodName: "TableDetails",
			Handler:    _Admin_TableDetails_Handler,
		},
		{
			MethodName: "TableStats",
			Handler:    _Admin_TableStats_Handler,
		},
		{
			MethodName: "NonTableStats",
			Handler:    _Admin_NonTableStats_Handler,
		},
		{
			MethodName: "Events",
			Handler:    _Admin_Events_Handler,
		},
		{
			MethodName: "SetUIData",
			Handler:    _Admin_SetUIData_Handler,
		},
		{
			MethodName: "GetUIData",
			Handler:    _Admin_GetUIData_Handler,
		},
		{
			MethodName: "Cluster",
			Handler:    _Admin_Cluster_Handler,
		},
		{
			MethodName: "Settings",
			Handler:    _Admin_Settings_Handler,
		},
		{
			MethodName: "Health",
			Handler:    _Admin_Health_Handler,
		},
		{
			MethodName: "Liveness",
			Handler:    _Admin_Liveness_Handler,
		},
		{
			MethodName: "Jobs",
			Handler:    _Admin_Jobs_Handler,
		},
		{
			MethodName: "Locations",
			Handler:    _Admin_Locations_Handler,
		},
		{
			MethodName: "QueryPlan",
			Handler:    _Admin_QueryPlan_Handler,
		},
		{
			MethodName: "Decommission",
			Handler:    _Admin_Decommission_Handler,
		},
		{
			MethodName: "DecommissionStatus",
			Handler:    _Admin_DecommissionStatus_Handler,
		},
		{
			MethodName: "RangeLog",
			Handler:    _Admin_RangeLog_Handler,
		},
		{
			MethodName: "DataDistribution",
			Handler:    _Admin_DataDistribution_Handler,
		},
		{
			MethodName: "AllMetricMetadata",
			Handler:    _Admin_AllMetricMetadata_Handler,
		},
		{
			MethodName: "EnqueueRange",
			Handler:    _Admin_EnqueueRange_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Drain",
			Handler:       _Admin_Drain_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "server/serverpb/admin.proto",
}

func (m *DatabasesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DatabasesRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *DatabasesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DatabasesResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Databases) > 0 {
		for _, s := range m.Databases {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *DatabaseDetailsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DatabaseDetailsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Database) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Database)))
		i += copy(dAtA[i:], m.Database)
	}
	return i, nil
}

func (m *DatabaseDetailsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DatabaseDetailsResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Grants) > 0 {
		for _, msg := range m.Grants {
			dAtA[i] = 0xa
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.TableNames) > 0 {
		for _, s := range m.TableNames {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.DescriptorID != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.DescriptorID))
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintAdmin(dAtA, i, uint64(m.ZoneConfig.Size()))
	n1, err := m.ZoneConfig.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	if m.ZoneConfigLevel != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.ZoneConfigLevel))
	}
	return i, nil
}

func (m *DatabaseDetailsResponse_Grant) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DatabaseDetailsResponse_Grant) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.User) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.User)))
		i += copy(dAtA[i:], m.User)
	}
	if len(m.Privileges) > 0 {
		for _, s := range m.Privileges {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *TableDetailsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TableDetailsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Database) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Database)))
		i += copy(dAtA[i:], m.Database)
	}
	if len(m.Table) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Table)))
		i += copy(dAtA[i:], m.Table)
	}
	return i, nil
}

func (m *TableDetailsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TableDetailsResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Grants) > 0 {
		for _, msg := range m.Grants {
			dAtA[i] = 0xa
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Columns) > 0 {
		for _, msg := range m.Columns {
			dAtA[i] = 0x12
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Indexes) > 0 {
		for _, msg := range m.Indexes {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.RangeCount != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.RangeCount))
	}
	if len(m.CreateTableStatement) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.CreateTableStatement)))
		i += copy(dAtA[i:], m.CreateTableStatement)
	}
	dAtA[i] = 0x32
	i++
	i = encodeVarintAdmin(dAtA, i, uint64(m.ZoneConfig.Size()))
	n2, err := m.ZoneConfig.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	if m.ZoneConfigLevel != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.ZoneConfigLevel))
	}
	if m.DescriptorID != 0 {
		dAtA[i] = 0x40
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.DescriptorID))
	}
	return i, nil
}

func (m *TableDetailsResponse_Grant) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TableDetailsResponse_Grant) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.User) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.User)))
		i += copy(dAtA[i:], m.User)
	}
	if len(m.Privileges) > 0 {
		for _, s := range m.Privileges {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *TableDetailsResponse_Column) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TableDetailsResponse_Column) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Type) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Type)))
		i += copy(dAtA[i:], m.Type)
	}
	if m.Nullable {
		dAtA[i] = 0x18
		i++
		if m.Nullable {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.DefaultValue) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.DefaultValue)))
		i += copy(dAtA[i:], m.DefaultValue)
	}
	if len(m.GenerationExpression) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.GenerationExpression)))
		i += copy(dAtA[i:], m.GenerationExpression)
	}
	if m.Hidden {
		dAtA[i] = 0x30
		i++
		if m.Hidden {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *TableDetailsResponse_Index) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TableDetailsResponse_Index) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.Unique {
		dAtA[i] = 0x10
		i++
		if m.Unique {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Seq != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.Seq))
	}
	if len(m.Column) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Column)))
		i += copy(dAtA[i:], m.Column)
	}
	if len(m.Direction) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Direction)))
		i += copy(dAtA[i:], m.Direction)
	}
	if m.Storing {
		dAtA[i] = 0x30
		i++
		if m.Storing {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Implicit {
		dAtA[i] = 0x38
		i++
		if m.Implicit {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *TableStatsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TableStatsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Database) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Database)))
		i += copy(dAtA[i:], m.Database)
	}
	if len(m.Table) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Table)))
		i += copy(dAtA[i:], m.Table)
	}
	return i, nil
}

func (m *TableStatsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TableStatsResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RangeCount != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.RangeCount))
	}
	if m.ReplicaCount != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.ReplicaCount))
	}
	if m.NodeCount != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.NodeCount))
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintAdmin(dAtA, i, uint64(m.Stats.Size()))
	n3, err := m.Stats.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	if len(m.MissingNodes) > 0 {
		for _, msg := range m.MissingNodes {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.ApproximateDiskBytes != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.ApproximateDiskBytes))
	}
	return i, nil
}

func (m *TableStatsResponse_MissingNode) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TableStatsResponse_MissingNode) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeID) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.NodeID)))
		i += copy(dAtA[i:], m.NodeID)
	}
	if len(m.ErrorMessage) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.ErrorMessage)))
		i += copy(dAtA[i:], m.ErrorMessage)
	}
	return i, nil
}

func (m *NonTableStatsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NonTableStatsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *NonTableStatsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NonTableStatsResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.TimeSeriesStats != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.TimeSeriesStats.Size()))
		n4, err := m.TimeSeriesStats.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}

func (m *UsersRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UsersRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *UsersResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UsersResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Users) > 0 {
		for _, msg := range m.Users {
			dAtA[i] = 0xa
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *UsersResponse_User) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UsersResponse_User) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Username) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Username)))
		i += copy(dAtA[i:], m.Username)
	}
	return i, nil
}

func (m *EventsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EventsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Type) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Type)))
		i += copy(dAtA[i:], m.Type)
	}
	if m.TargetId != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.TargetId))
	}
	if m.Limit != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.Limit))
	}
	return i, nil
}

func (m *EventsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EventsResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Events) > 0 {
		for _, msg := range m.Events {
			dAtA[i] = 0xa
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *EventsResponse_Event) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EventsResponse_Event) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintAdmin(dAtA, i, uint64(types.SizeOfStdTime(m.Timestamp)))
	n5, err := types.StdTimeMarshalTo(m.Timestamp, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	if len(m.EventType) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.EventType)))
		i += copy(dAtA[i:], m.EventType)
	}
	if m.TargetID != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.TargetID))
	}
	if m.ReportingID != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.ReportingID))
	}
	if len(m.Info) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Info)))
		i += copy(dAtA[i:], m.Info)
	}
	if len(m.UniqueID) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.UniqueID)))
		i += copy(dAtA[i:], m.UniqueID)
	}
	return i, nil
}

func (m *SetUIDataRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SetUIDataRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.KeyValues) > 0 {
		keysForKeyValues := make([]string, 0, len(m.KeyValues))
		for k := range m.KeyValues {
			keysForKeyValues = append(keysForKeyValues, string(k))
		}
		sortkeys.Strings(keysForKeyValues)
		for _, k := range keysForKeyValues {
			dAtA[i] = 0xa
			i++
			v := m.KeyValues[string(k)]
			byteSize := 0
			if len(v) > 0 {
				byteSize = 1 + len(v) + sovAdmin(uint64(len(v)))
			}
			mapSize := 1 + len(k) + sovAdmin(uint64(len(k))) + byteSize
			i = encodeVarintAdmin(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if len(v) > 0 {
				dAtA[i] = 0x12
				i++
				i = encodeVarintAdmin(dAtA, i, uint64(len(v)))
				i += copy(dAtA[i:], v)
			}
		}
	}
	return i, nil
}

func (m *SetUIDataResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SetUIDataResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *GetUIDataRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetUIDataRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Keys) > 0 {
		for _, s := range m.Keys {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *GetUIDataResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetUIDataResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.KeyValues) > 0 {
		keysForKeyValues := make([]string, 0, len(m.KeyValues))
		for k := range m.KeyValues {
			keysForKeyValues = append(keysForKeyValues, string(k))
		}
		sortkeys.Strings(keysForKeyValues)
		for _, k := range keysForKeyValues {
			dAtA[i] = 0xa
			i++
			v := m.KeyValues[string(k)]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovAdmin(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovAdmin(uint64(len(k))) + msgSize
			i = encodeVarintAdmin(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintAdmin(dAtA, i, uint64((&v).Size()))
			n6, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n6
		}
	}
	return i, nil
}

func (m *GetUIDataResponse_Value) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetUIDataResponse_Value) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Value) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Value)))
		i += copy(dAtA[i:], m.Value)
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintAdmin(dAtA, i, uint64(types.SizeOfStdTime(m.LastUpdated)))
	n7, err := types.StdTimeMarshalTo(m.LastUpdated, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n7
	return i, nil
}

func (m *ClusterRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *ClusterResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ClusterID) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.ClusterID)))
		i += copy(dAtA[i:], m.ClusterID)
	}
	if m.ReportingEnabled {
		dAtA[i] = 0x10
		i++
		if m.ReportingEnabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.EnterpriseEnabled {
		dAtA[i] = 0x18
		i++
		if m.EnterpriseEnabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *DrainRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DrainRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.On) > 0 {
		dAtA9 := make([]byte, len(m.On)*10)
		var j8 int
		for _, num1 := range m.On {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA9[j8] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j8++
			}
			dAtA9[j8] = uint8(num)
			j8++
		}
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(j8))
		i += copy(dAtA[i:], dAtA9[:j8])
	}
	if len(m.Off) > 0 {
		dAtA11 := make([]byte, len(m.Off)*10)
		var j10 int
		for _, num1 := range m.Off {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA11[j10] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j10++
			}
			dAtA11[j10] = uint8(num)
			j10++
		}
		dAtA[i] = 0x12
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(j10))
		i += copy(dAtA[i:], dAtA11[:j10])
	}
	if m.Shutdown {
		dAtA[i] = 0x18
		i++
		if m.Shutdown {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *DrainResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DrainResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.On) > 0 {
		dAtA13 := make([]byte, len(m.On)*10)
		var j12 int
		for _, num1 := range m.On {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA13[j12] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j12++
			}
			dAtA13[j12] = uint8(num)
			j12++
		}
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(j12))
		i += copy(dAtA[i:], dAtA13[:j12])
	}
	return i, nil
}

func (m *DecommissionStatusRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DecommissionStatusRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeIDs) > 0 {
		dAtA15 := make([]byte, len(m.NodeIDs)*10)
		var j14 int
		for _, num1 := range m.NodeIDs {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA15[j14] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j14++
			}
			dAtA15[j14] = uint8(num)
			j14++
		}
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(j14))
		i += copy(dAtA[i:], dAtA15[:j14])
	}
	return i, nil
}

func (m *DecommissionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DecommissionRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeIDs) > 0 {
		dAtA17 := make([]byte, len(m.NodeIDs)*10)
		var j16 int
		for _, num1 := range m.NodeIDs {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA17[j16] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j16++
			}
			dAtA17[j16] = uint8(num)
			j16++
		}
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(j16))
		i += copy(dAtA[i:], dAtA17[:j16])
	}
	if m.Decommissioning {
		dAtA[i] = 0x10
		i++
		if m.Decommissioning {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *DecommissionStatusResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DecommissionStatusResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Status) > 0 {
		for _, msg := range m.Status {
			dAtA[i] = 0x12
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *DecommissionStatusResponse_Status) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DecommissionStatusResponse_Status) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NodeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.NodeID))
	}
	if m.IsLive {
		dAtA[i] = 0x10
		i++
		if m.IsLive {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.ReplicaCount != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.ReplicaCount))
	}
	if m.Decommissioning {
		dAtA[i] = 0x20
		i++
		if m.Decommissioning {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Draining {
		dAtA[i] = 0x28
		i++
		if m.Draining {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *SettingsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SettingsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Keys) > 0 {
		for _, s := range m.Keys {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *SettingsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SettingsResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.KeyValues) > 0 {
		keysForKeyValues := make([]string, 0, len(m.KeyValues))
		for k := range m.KeyValues {
			keysForKeyValues = append(keysForKeyValues, string(k))
		}
		sortkeys.Strings(keysForKeyValues)
		for _, k := range keysForKeyValues {
			dAtA[i] = 0xa
			i++
			v := m.KeyValues[string(k)]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovAdmin(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovAdmin(uint64(len(k))) + msgSize
			i = encodeVarintAdmin(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintAdmin(dAtA, i, uint64((&v).Size()))
			n18, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n18
		}
	}
	return i, nil
}

func (m *SettingsResponse_Value) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SettingsResponse_Value) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Value) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Value)))
		i += copy(dAtA[i:], m.Value)
	}
	if len(m.Type) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Type)))
		i += copy(dAtA[i:], m.Type)
	}
	if len(m.Description) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Description)))
		i += copy(dAtA[i:], m.Description)
	}
	return i, nil
}

func (m *HealthRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HealthRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *HealthResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HealthResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *LivenessRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LivenessRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *LivenessResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LivenessResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Livenesses) > 0 {
		for _, msg := range m.Livenesses {
			dAtA[i] = 0xa
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Statuses) > 0 {
		keysForStatuses := make([]int32, 0, len(m.Statuses))
		for k := range m.Statuses {
			keysForStatuses = append(keysForStatuses, int32(k))
		}
		sortkeys.Int32s(keysForStatuses)
		for _, k := range keysForStatuses {
			dAtA[i] = 0x12
			i++
			v := m.Statuses[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(k)]
			mapSize := 1 + sovAdmin(uint64(k)) + 1 + sovAdmin(uint64(v))
			i = encodeVarintAdmin(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(k))
			dAtA[i] = 0x10
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(v))
		}
	}
	return i, nil
}

func (m *JobsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JobsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Limit != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.Limit))
	}
	if len(m.Status) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Status)))
		i += copy(dAtA[i:], m.Status)
	}
	if m.Type != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.Type))
	}
	return i, nil
}

func (m *JobsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JobsResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Jobs) > 0 {
		for _, msg := range m.Jobs {
			dAtA[i] = 0xa
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *JobsResponse_Job) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JobsResponse_Job) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.ID))
	}
	if len(m.Type) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Type)))
		i += copy(dAtA[i:], m.Type)
	}
	if len(m.Description) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Description)))
		i += copy(dAtA[i:], m.Description)
	}
	if len(m.Username) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Username)))
		i += copy(dAtA[i:], m.Username)
	}
	if len(m.DescriptorIDs) > 0 {
		dAtA20 := make([]byte, len(m.DescriptorIDs)*10)
		var j19 int
		for _, num := range m.DescriptorIDs {
			for num >= 1<<7 {
				dAtA20[j19] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j19++
			}
			dAtA20[j19] = uint8(num)
			j19++
		}
		dAtA[i] = 0x2a
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(j19))
		i += copy(dAtA[i:], dAtA20[:j19])
	}
	if len(m.Status) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Status)))
		i += copy(dAtA[i:], m.Status)
	}
	if m.Created != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(types.SizeOfStdTime(*m.Created)))
		n21, err := types.StdTimeMarshalTo(*m.Created, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	if m.Started != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(types.SizeOfStdTime(*m.Started)))
		n22, err := types.StdTimeMarshalTo(*m.Started, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n22
	}
	if m.Finished != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(types.SizeOfStdTime(*m.Finished)))
		n23, err := types.StdTimeMarshalTo(*m.Finished, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n23
	}
	if m.Modified != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(types.SizeOfStdTime(*m.Modified)))
		n24, err := types.StdTimeMarshalTo(*m.Modified, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n24
	}
	if m.FractionCompleted != 0 {
		dAtA[i] = 0x5d
		i++
		binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.FractionCompleted))))
		i += 4
	}
	if len(m.Error) > 0 {
		dAtA[i] = 0x62
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Error)))
		i += copy(dAtA[i:], m.Error)
	}
	if m.HighwaterTimestamp != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(types.SizeOfStdTime(*m.HighwaterTimestamp)))
		n25, err := types.StdTimeMarshalTo(*m.HighwaterTimestamp, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n25
	}
	if len(m.HighwaterDecimal) > 0 {
		dAtA[i] = 0x72
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.HighwaterDecimal)))
		i += copy(dAtA[i:], m.HighwaterDecimal)
	}
	return i, nil
}

func (m *LocationsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LocationsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *LocationsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LocationsResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Locations) > 0 {
		for _, msg := range m.Locations {
			dAtA[i] = 0xa
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *LocationsResponse_Location) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LocationsResponse_Location) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.LocalityKey) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.LocalityKey)))
		i += copy(dAtA[i:], m.LocalityKey)
	}
	if len(m.LocalityValue) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.LocalityValue)))
		i += copy(dAtA[i:], m.LocalityValue)
	}
	if m.Latitude != 0 {
		dAtA[i] = 0x19
		i++
		binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Latitude))))
		i += 8
	}
	if m.Longitude != 0 {
		dAtA[i] = 0x21
		i++
		binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Longitude))))
		i += 8
	}
	return i, nil
}

func (m *RangeLogRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeLogRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RangeId != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.RangeId))
	}
	if m.Limit != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.Limit))
	}
	return i, nil
}

func (m *RangeLogResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeLogResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Events) > 0 {
		for _, msg := range m.Events {
			dAtA[i] = 0x12
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *RangeLogResponse_PrettyInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeLogResponse_PrettyInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.UpdatedDesc) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.UpdatedDesc)))
		i += copy(dAtA[i:], m.UpdatedDesc)
	}
	if len(m.NewDesc) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.NewDesc)))
		i += copy(dAtA[i:], m.NewDesc)
	}
	if len(m.AddedReplica) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.AddedReplica)))
		i += copy(dAtA[i:], m.AddedReplica)
	}
	if len(m.RemovedReplica) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.RemovedReplica)))
		i += copy(dAtA[i:], m.RemovedReplica)
	}
	if len(m.Reason) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Reason)))
		i += copy(dAtA[i:], m.Reason)
	}
	if len(m.Details) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Details)))
		i += copy(dAtA[i:], m.Details)
	}
	return i, nil
}

func (m *RangeLogResponse_Event) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeLogResponse_Event) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintAdmin(dAtA, i, uint64(m.Event.Size()))
	n26, err := m.Event.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n26
	dAtA[i] = 0x12
	i++
	i = encodeVarintAdmin(dAtA, i, uint64(m.PrettyInfo.Size()))
	n27, err := m.PrettyInfo.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n27
	return i, nil
}

func (m *QueryPlanRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryPlanRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Query) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Query)))
		i += copy(dAtA[i:], m.Query)
	}
	return i, nil
}

func (m *QueryPlanResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryPlanResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.DistSQLPhysicalQueryPlan) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.DistSQLPhysicalQueryPlan)))
		i += copy(dAtA[i:], m.DistSQLPhysicalQueryPlan)
	}
	return i, nil
}

func (m *DataDistributionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DataDistributionRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *DataDistributionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DataDistributionResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.DatabaseInfo) > 0 {
		keysForDatabaseInfo := make([]string, 0, len(m.DatabaseInfo))
		for k := range m.DatabaseInfo {
			keysForDatabaseInfo = append(keysForDatabaseInfo, string(k))
		}
		sortkeys.Strings(keysForDatabaseInfo)
		for _, k := range keysForDatabaseInfo {
			dAtA[i] = 0xa
			i++
			v := m.DatabaseInfo[string(k)]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovAdmin(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovAdmin(uint64(len(k))) + msgSize
			i = encodeVarintAdmin(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintAdmin(dAtA, i, uint64((&v).Size()))
			n28, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n28
		}
	}
	if len(m.ZoneConfigs) > 0 {
		keysForZoneConfigs := make([]string, 0, len(m.ZoneConfigs))
		for k := range m.ZoneConfigs {
			keysForZoneConfigs = append(keysForZoneConfigs, string(k))
		}
		sortkeys.Strings(keysForZoneConfigs)
		for _, k := range keysForZoneConfigs {
			dAtA[i] = 0x1a
			i++
			v := m.ZoneConfigs[string(k)]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovAdmin(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovAdmin(uint64(len(k))) + msgSize
			i = encodeVarintAdmin(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintAdmin(dAtA, i, uint64((&v).Size()))
			n29, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n29
		}
	}
	return i, nil
}

func (m *DataDistributionResponse_ZoneConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DataDistributionResponse_ZoneConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ZoneName) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.ZoneName)))
		i += copy(dAtA[i:], m.ZoneName)
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintAdmin(dAtA, i, uint64(m.Config.Size()))
	n30, err := m.Config.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n30
	if len(m.ConfigSQL) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.ConfigSQL)))
		i += copy(dAtA[i:], m.ConfigSQL)
	}
	return i, nil
}

func (m *DataDistributionResponse_TableInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DataDistributionResponse_TableInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ReplicaCountByNodeId) > 0 {
		keysForReplicaCountByNodeId := make([]int32, 0, len(m.ReplicaCountByNodeId))
		for k := range m.ReplicaCountByNodeId {
			keysForReplicaCountByNodeId = append(keysForReplicaCountByNodeId, int32(k))
		}
		sortkeys.Int32s(keysForReplicaCountByNodeId)
		for _, k := range keysForReplicaCountByNodeId {
			dAtA[i] = 0xa
			i++
			v := m.ReplicaCountByNodeId[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(k)]
			mapSize := 1 + sovAdmin(uint64(k)) + 1 + sovAdmin(uint64(v))
			i = encodeVarintAdmin(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(k))
			dAtA[i] = 0x10
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(v))
		}
	}
	if m.ZoneConfigId != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.ZoneConfigId))
	}
	if m.DroppedAt != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(types.SizeOfStdTime(*m.DroppedAt)))
		n31, err := types.StdTimeMarshalTo(*m.DroppedAt, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n31
	}
	return i, nil
}

func (m *DataDistributionResponse_DatabaseInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DataDistributionResponse_DatabaseInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.TableInfo) > 0 {
		keysForTableInfo := make([]string, 0, len(m.TableInfo))
		for k := range m.TableInfo {
			keysForTableInfo = append(keysForTableInfo, string(k))
		}
		sortkeys.Strings(keysForTableInfo)
		for _, k := range keysForTableInfo {
			dAtA[i] = 0xa
			i++
			v := m.TableInfo[string(k)]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovAdmin(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovAdmin(uint64(len(k))) + msgSize
			i = encodeVarintAdmin(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintAdmin(dAtA, i, uint64((&v).Size()))
			n32, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n32
		}
	}
	return i, nil
}

func (m *MetricMetadataRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MetricMetadataRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *MetricMetadataResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MetricMetadataResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Metadata) > 0 {
		keysForMetadata := make([]string, 0, len(m.Metadata))
		for k := range m.Metadata {
			keysForMetadata = append(keysForMetadata, string(k))
		}
		sortkeys.Strings(keysForMetadata)
		for _, k := range keysForMetadata {
			dAtA[i] = 0xa
			i++
			v := m.Metadata[string(k)]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovAdmin(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovAdmin(uint64(len(k))) + msgSize
			i = encodeVarintAdmin(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintAdmin(dAtA, i, uint64((&v).Size()))
			n33, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n33
		}
	}
	return i, nil
}

func (m *EnqueueRangeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnqueueRangeRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NodeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.NodeID))
	}
	if len(m.Queue) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Queue)))
		i += copy(dAtA[i:], m.Queue)
	}
	if m.RangeID != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.RangeID))
	}
	if m.SkipShouldQueue {
		dAtA[i] = 0x20
		i++
		if m.SkipShouldQueue {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *EnqueueRangeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnqueueRangeResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Details) > 0 {
		for _, msg := range m.Details {
			dAtA[i] = 0xa
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *EnqueueRangeResponse_Details) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnqueueRangeResponse_Details) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NodeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.NodeID))
	}
	if len(m.Events) > 0 {
		for _, msg := range m.Events {
			dAtA[i] = 0x12
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Error) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Error)))
		i += copy(dAtA[i:], m.Error)
	}
	return i, nil
}

func encodeVarintAdmin(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *DatabasesRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *DatabasesResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Databases) > 0 {
		for _, s := range m.Databases {
			l = len(s)
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	return n
}

func (m *DatabaseDetailsRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.Database)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	return n
}

func (m *DatabaseDetailsResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Grants) > 0 {
		for _, e := range m.Grants {
			l = e.Size()
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	if len(m.TableNames) > 0 {
		for _, s := range m.TableNames {
			l = len(s)
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	if m.DescriptorID != 0 {
		n += 1 + sovAdmin(uint64(m.DescriptorID))
	}
	l = m.ZoneConfig.Size()
	n += 1 + l + sovAdmin(uint64(l))
	if m.ZoneConfigLevel != 0 {
		n += 1 + sovAdmin(uint64(m.ZoneConfigLevel))
	}
	return n
}

func (m *DatabaseDetailsResponse_Grant) Size() (n int) {
	var l int
	_ = l
	l = len(m.User)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	if len(m.Privileges) > 0 {
		for _, s := range m.Privileges {
			l = len(s)
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	return n
}

func (m *TableDetailsRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.Database)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = len(m.Table)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	return n
}

func (m *TableDetailsResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Grants) > 0 {
		for _, e := range m.Grants {
			l = e.Size()
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	if len(m.Columns) > 0 {
		for _, e := range m.Columns {
			l = e.Size()
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	if len(m.Indexes) > 0 {
		for _, e := range m.Indexes {
			l = e.Size()
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	if m.RangeCount != 0 {
		n += 1 + sovAdmin(uint64(m.RangeCount))
	}
	l = len(m.CreateTableStatement)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = m.ZoneConfig.Size()
	n += 1 + l + sovAdmin(uint64(l))
	if m.ZoneConfigLevel != 0 {
		n += 1 + sovAdmin(uint64(m.ZoneConfigLevel))
	}
	if m.DescriptorID != 0 {
		n += 1 + sovAdmin(uint64(m.DescriptorID))
	}
	return n
}

func (m *TableDetailsResponse_Grant) Size() (n int) {
	var l int
	_ = l
	l = len(m.User)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	if len(m.Privileges) > 0 {
		for _, s := range m.Privileges {
			l = len(s)
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	return n
}

func (m *TableDetailsResponse_Column) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	if m.Nullable {
		n += 2
	}
	l = len(m.DefaultValue)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = len(m.GenerationExpression)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	if m.Hidden {
		n += 2
	}
	return n
}

func (m *TableDetailsResponse_Index) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	if m.Unique {
		n += 2
	}
	if m.Seq != 0 {
		n += 1 + sovAdmin(uint64(m.Seq))
	}
	l = len(m.Column)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = len(m.Direction)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	if m.Storing {
		n += 2
	}
	if m.Implicit {
		n += 2
	}
	return n
}

func (m *TableStatsRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.Database)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = len(m.Table)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	return n
}

func (m *TableStatsResponse) Size() (n int) {
	var l int
	_ = l
	if m.RangeCount != 0 {
		n += 1 + sovAdmin(uint64(m.RangeCount))
	}
	if m.ReplicaCount != 0 {
		n += 1 + sovAdmin(uint64(m.ReplicaCount))
	}
	if m.NodeCount != 0 {
		n += 1 + sovAdmin(uint64(m.NodeCount))
	}
	l = m.Stats.Size()
	n += 1 + l + sovAdmin(uint64(l))
	if len(m.MissingNodes) > 0 {
		for _, e := range m.MissingNodes {
			l = e.Size()
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	if m.ApproximateDiskBytes != 0 {
		n += 1 + sovAdmin(uint64(m.ApproximateDiskBytes))
	}
	return n
}

func (m *TableStatsResponse_MissingNode) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeID)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = len(m.ErrorMessage)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	return n
}

func (m *NonTableStatsRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *NonTableStatsResponse) Size() (n int) {
	var l int
	_ = l
	if m.TimeSeriesStats != nil {
		l = m.TimeSeriesStats.Size()
		n += 1 + l + sovAdmin(uint64(l))
	}
	return n
}

func (m *UsersRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *UsersResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Users) > 0 {
		for _, e := range m.Users {
			l = e.Size()
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	return n
}

func (m *UsersResponse_User) Size() (n int) {
	var l int
	_ = l
	l = len(m.Username)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	return n
}

func (m *EventsRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	if m.TargetId != 0 {
		n += 1 + sovAdmin(uint64(m.TargetId))
	}
	if m.Limit != 0 {
		n += 1 + sovAdmin(uint64(m.Limit))
	}
	return n
}

func (m *EventsResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Events) > 0 {
		for _, e := range m.Events {
			l = e.Size()
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	return n
}

func (m *EventsResponse_Event) Size() (n int) {
	var l int
	_ = l
	l = types.SizeOfStdTime(m.Timestamp)
	n += 1 + l + sovAdmin(uint64(l))
	l = len(m.EventType)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	if m.TargetID != 0 {
		n += 1 + sovAdmin(uint64(m.TargetID))
	}
	if m.ReportingID != 0 {
		n += 1 + sovAdmin(uint64(m.ReportingID))
	}
	l = len(m.Info)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = len(m.UniqueID)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	return n
}

func (m *SetUIDataRequest) Size() (n int) {
	var l int
	_ = l
	if len(m.KeyValues) > 0 {
		for k, v := range m.KeyValues {
			_ = k
			_ = v
			l = 0
			if len(v) > 0 {
				l = 1 + len(v) + sovAdmin(uint64(len(v)))
			}
			mapEntrySize := 1 + len(k) + sovAdmin(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovAdmin(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *SetUIDataResponse) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *GetUIDataRequest) Size() (n int) {
	var l int
	_ = l
	if len(m.Keys) > 0 {
		for _, s := range m.Keys {
			l = len(s)
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	return n
}

func (m *GetUIDataResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.KeyValues) > 0 {
		for k, v := range m.KeyValues {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + len(k) + sovAdmin(uint64(len(k))) + 1 + l + sovAdmin(uint64(l))
			n += mapEntrySize + 1 + sovAdmin(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *GetUIDataResponse_Value) Size() (n int) {
	var l int
	_ = l
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = types.SizeOfStdTime(m.LastUpdated)
	n += 1 + l + sovAdmin(uint64(l))
	return n
}

func (m *ClusterRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *ClusterResponse) Size() (n int) {
	var l int
	_ = l
	l = len(m.ClusterID)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	if m.ReportingEnabled {
		n += 2
	}
	if m.EnterpriseEnabled {
		n += 2
	}
	return n
}

func (m *DrainRequest) Size() (n int) {
	var l int
	_ = l
	if len(m.On) > 0 {
		l = 0
		for _, e := range m.On {
			l += sovAdmin(uint64(e))
		}
		n += 1 + sovAdmin(uint64(l)) + l
	}
	if len(m.Off) > 0 {
		l = 0
		for _, e := range m.Off {
			l += sovAdmin(uint64(e))
		}
		n += 1 + sovAdmin(uint64(l)) + l
	}
	if m.Shutdown {
		n += 2
	}
	return n
}

func (m *DrainResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.On) > 0 {
		l = 0
		for _, e := range m.On {
			l += sovAdmin(uint64(e))
		}
		n += 1 + sovAdmin(uint64(l)) + l
	}
	return n
}

func (m *DecommissionStatusRequest) Size() (n int) {
	var l int
	_ = l
	if len(m.NodeIDs) > 0 {
		l = 0
		for _, e := range m.NodeIDs {
			l += sovAdmin(uint64(e))
		}
		n += 1 + sovAdmin(uint64(l)) + l
	}
	return n
}

func (m *DecommissionRequest) Size() (n int) {
	var l int
	_ = l
	if len(m.NodeIDs) > 0 {
		l = 0
		for _, e := range m.NodeIDs {
			l += sovAdmin(uint64(e))
		}
		n += 1 + sovAdmin(uint64(l)) + l
	}
	if m.Decommissioning {
		n += 2
	}
	return n
}

func (m *DecommissionStatusResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Status) > 0 {
		for _, e := range m.Status {
			l = e.Size()
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	return n
}

func (m *DecommissionStatusResponse_Status) Size() (n int) {
	var l int
	_ = l
	if m.NodeID != 0 {
		n += 1 + sovAdmin(uint64(m.NodeID))
	}
	if m.IsLive {
		n += 2
	}
	if m.ReplicaCount != 0 {
		n += 1 + sovAdmin(uint64(m.ReplicaCount))
	}
	if m.Decommissioning {
		n += 2
	}
	if m.Draining {
		n += 2
	}
	return n
}

func (m *SettingsRequest) Size() (n int) {
	var l int
	_ = l
	if len(m.Keys) > 0 {
		for _, s := range m.Keys {
			l = len(s)
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	return n
}

func (m *SettingsResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.KeyValues) > 0 {
		for k, v := range m.KeyValues {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + len(k) + sovAdmin(uint64(len(k))) + 1 + l + sovAdmin(uint64(l))
			n += mapEntrySize + 1 + sovAdmin(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *SettingsResponse_Value) Size() (n int) {
	var l int
	_ = l
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	return n
}

func (m *HealthRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *HealthResponse) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *LivenessRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *LivenessResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Livenesses) > 0 {
		for _, e := range m.Livenesses {
			l = e.Size()
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	if len(m.Statuses) > 0 {
		for k, v := range m.Statuses {
			_ = k
			_ = v
			mapEntrySize := 1 + sovAdmin(uint64(k)) + 1 + sovAdmin(uint64(v))
			n += mapEntrySize + 1 + sovAdmin(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *JobsRequest) Size() (n int) {
	var l int
	_ = l
	if m.Limit != 0 {
		n += 1 + sovAdmin(uint64(m.Limit))
	}
	l = len(m.Status)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	if m.Type != 0 {
		n += 1 + sovAdmin(uint64(m.Type))
	}
	return n
}

func (m *JobsResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Jobs) > 0 {
		for _, e := range m.Jobs {
			l = e.Size()
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	return n
}

func (m *JobsResponse_Job) Size() (n int) {
	var l int
	_ = l
	if m.ID != 0 {
		n += 1 + sovAdmin(uint64(m.ID))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = len(m.Username)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	if len(m.DescriptorIDs) > 0 {
		l = 0
		for _, e := range m.DescriptorIDs {
			l += sovAdmin(uint64(e))
		}
		n += 1 + sovAdmin(uint64(l)) + l
	}
	l = len(m.Status)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	if m.Created != nil {
		l = types.SizeOfStdTime(*m.Created)
		n += 1 + l + sovAdmin(uint64(l))
	}
	if m.Started != nil {
		l = types.SizeOfStdTime(*m.Started)
		n += 1 + l + sovAdmin(uint64(l))
	}
	if m.Finished != nil {
		l = types.SizeOfStdTime(*m.Finished)
		n += 1 + l + sovAdmin(uint64(l))
	}
	if m.Modified != nil {
		l = types.SizeOfStdTime(*m.Modified)
		n += 1 + l + sovAdmin(uint64(l))
	}
	if m.FractionCompleted != 0 {
		n += 5
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	if m.HighwaterTimestamp != nil {
		l = types.SizeOfStdTime(*m.HighwaterTimestamp)
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = len(m.HighwaterDecimal)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	return n
}

func (m *LocationsRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *LocationsResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Locations) > 0 {
		for _, e := range m.Locations {
			l = e.Size()
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	return n
}

func (m *LocationsResponse_Location) Size() (n int) {
	var l int
	_ = l
	l = len(m.LocalityKey)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = len(m.LocalityValue)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	if m.Latitude != 0 {
		n += 9
	}
	if m.Longitude != 0 {
		n += 9
	}
	return n
}

func (m *RangeLogRequest) Size() (n int) {
	var l int
	_ = l
	if m.RangeId != 0 {
		n += 1 + sovAdmin(uint64(m.RangeId))
	}
	if m.Limit != 0 {
		n += 1 + sovAdmin(uint64(m.Limit))
	}
	return n
}

func (m *RangeLogResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Events) > 0 {
		for _, e := range m.Events {
			l = e.Size()
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	return n
}

func (m *RangeLogResponse_PrettyInfo) Size() (n int) {
	var l int
	_ = l
	l = len(m.UpdatedDesc)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = len(m.NewDesc)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = len(m.AddedReplica)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = len(m.RemovedReplica)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = len(m.Reason)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = len(m.Details)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	return n
}

func (m *RangeLogResponse_Event) Size() (n int) {
	var l int
	_ = l
	l = m.Event.Size()
	n += 1 + l + sovAdmin(uint64(l))
	l = m.PrettyInfo.Size()
	n += 1 + l + sovAdmin(uint64(l))
	return n
}

func (m *QueryPlanRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.Query)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	return n
}

func (m *QueryPlanResponse) Size() (n int) {
	var l int
	_ = l
	l = len(m.DistSQLPhysicalQueryPlan)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	return n
}

func (m *DataDistributionRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *DataDistributionResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.DatabaseInfo) > 0 {
		for k, v := range m.DatabaseInfo {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + len(k) + sovAdmin(uint64(len(k))) + 1 + l + sovAdmin(uint64(l))
			n += mapEntrySize + 1 + sovAdmin(uint64(mapEntrySize))
		}
	}
	if len(m.ZoneConfigs) > 0 {
		for k, v := range m.ZoneConfigs {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + len(k) + sovAdmin(uint64(len(k))) + 1 + l + sovAdmin(uint64(l))
			n += mapEntrySize + 1 + sovAdmin(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *DataDistributionResponse_ZoneConfig) Size() (n int) {
	var l int
	_ = l
	l = len(m.ZoneName)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = m.Config.Size()
	n += 1 + l + sovAdmin(uint64(l))
	l = len(m.ConfigSQL)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	return n
}

func (m *DataDistributionResponse_TableInfo) Size() (n int) {
	var l int
	_ = l
	if len(m.ReplicaCountByNodeId) > 0 {
		for k, v := range m.ReplicaCountByNodeId {
			_ = k
			_ = v
			mapEntrySize := 1 + sovAdmin(uint64(k)) + 1 + sovAdmin(uint64(v))
			n += mapEntrySize + 1 + sovAdmin(uint64(mapEntrySize))
		}
	}
	if m.ZoneConfigId != 0 {
		n += 1 + sovAdmin(uint64(m.ZoneConfigId))
	}
	if m.DroppedAt != nil {
		l = types.SizeOfStdTime(*m.DroppedAt)
		n += 1 + l + sovAdmin(uint64(l))
	}
	return n
}

func (m *DataDistributionResponse_DatabaseInfo) Size() (n int) {
	var l int
	_ = l
	if len(m.TableInfo) > 0 {
		for k, v := range m.TableInfo {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + len(k) + sovAdmin(uint64(len(k))) + 1 + l + sovAdmin(uint64(l))
			n += mapEntrySize + 1 + sovAdmin(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *MetricMetadataRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *MetricMetadataResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Metadata) > 0 {
		for k, v := range m.Metadata {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + len(k) + sovAdmin(uint64(len(k))) + 1 + l + sovAdmin(uint64(l))
			n += mapEntrySize + 1 + sovAdmin(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *EnqueueRangeRequest) Size() (n int) {
	var l int
	_ = l
	if m.NodeID != 0 {
		n += 1 + sovAdmin(uint64(m.NodeID))
	}
	l = len(m.Queue)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	if m.RangeID != 0 {
		n += 1 + sovAdmin(uint64(m.RangeID))
	}
	if m.SkipShouldQueue {
		n += 2
	}
	return n
}

func (m *EnqueueRangeResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Details) > 0 {
		for _, e := range m.Details {
			l = e.Size()
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	return n
}

func (m *EnqueueRangeResponse_Details) Size() (n int) {
	var l int
	_ = l
	if m.NodeID != 0 {
		n += 1 + sovAdmin(uint64(m.NodeID))
	}
	if len(m.Events) > 0 {
		for _, e := range m.Events {
			l = e.Size()
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	return n
}

func sovAdmin(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozAdmin(x uint64) (n int) {
	return sovAdmin(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *DatabasesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DatabasesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DatabasesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DatabasesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DatabasesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DatabasesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Databases", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Databases = append(m.Databases, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DatabaseDetailsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DatabaseDetailsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DatabaseDetailsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Database", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Database = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DatabaseDetailsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DatabaseDetailsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DatabaseDetailsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Grants", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Grants = append(m.Grants, DatabaseDetailsResponse_Grant{})
			if err := m.Grants[len(m.Grants)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TableNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TableNames = append(m.TableNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DescriptorID", wireType)
			}
			m.DescriptorID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DescriptorID |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ZoneConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ZoneConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ZoneConfigLevel", wireType)
			}
			m.ZoneConfigLevel = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ZoneConfigLevel |= (ZoneConfigurationLevel(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DatabaseDetailsResponse_Grant) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Grant: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Grant: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.User = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Privileges", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Privileges = append(m.Privileges, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TableDetailsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TableDetailsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TableDetailsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Database", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Database = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Table", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Table = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TableDetailsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TableDetailsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TableDetailsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Grants", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Grants = append(m.Grants, TableDetailsResponse_Grant{})
			if err := m.Grants[len(m.Grants)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Columns", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Columns = append(m.Columns, TableDetailsResponse_Column{})
			if err := m.Columns[len(m.Columns)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Indexes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Indexes = append(m.Indexes, TableDetailsResponse_Index{})
			if err := m.Indexes[len(m.Indexes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeCount", wireType)
			}
			m.RangeCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeCount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreateTableStatement", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CreateTableStatement = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ZoneConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ZoneConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ZoneConfigLevel", wireType)
			}
			m.ZoneConfigLevel = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ZoneConfigLevel |= (ZoneConfigurationLevel(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DescriptorID", wireType)
			}
			m.DescriptorID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DescriptorID |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TableDetailsResponse_Grant) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Grant: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Grant: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.User = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Privileges", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Privileges = append(m.Privileges, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TableDetailsResponse_Column) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Column: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Column: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nullable", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Nullable = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultValue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DefaultValue = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GenerationExpression", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GenerationExpression = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hidden", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Hidden = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TableDetailsResponse_Index) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Index: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Index: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unique", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Unique = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Seq", wireType)
			}
			m.Seq = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Seq |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Column", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Column = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Direction", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Direction = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Storing", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Storing = bool(v != 0)
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Implicit", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Implicit = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TableStatsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TableStatsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TableStatsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Database", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Database = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Table", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Table = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TableStatsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TableStatsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TableStatsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeCount", wireType)
			}
			m.RangeCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeCount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicaCount", wireType)
			}
			m.ReplicaCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReplicaCount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeCount", wireType)
			}
			m.NodeCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeCount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Stats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MissingNodes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MissingNodes = append(m.MissingNodes, TableStatsResponse_MissingNode{})
			if err := m.MissingNodes[len(m.MissingNodes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApproximateDiskBytes", wireType)
			}
			m.ApproximateDiskBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ApproximateDiskBytes |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TableStatsResponse_MissingNode) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MissingNode: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MissingNode: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorMessage", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrorMessage = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NonTableStatsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NonTableStatsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NonTableStatsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NonTableStatsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NonTableStatsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NonTableStatsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeSeriesStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TimeSeriesStats == nil {
				m.TimeSeriesStats = &TableStatsResponse{}
			}
			if err := m.TimeSeriesStats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UsersRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UsersRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UsersRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UsersResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UsersResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UsersResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Users", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Users = append(m.Users, UsersResponse_User{})
			if err := m.Users[len(m.Users)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UsersResponse_User) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: User: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: User: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Username", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Username = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EventsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EventsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EventsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetId", wireType)
			}
			m.TargetId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TargetId |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			m.Limit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Limit |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EventsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EventsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EventsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Events", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Events = append(m.Events, EventsResponse_Event{})
			if err := m.Events[len(m.Events)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EventsResponse_Event) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Event: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Event: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := types.StdTimeUnmarshal(&m.Timestamp, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EventType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EventType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetID", wireType)
			}
			m.TargetID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TargetID |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReportingID", wireType)
			}
			m.ReportingID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReportingID |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Info", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Info = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UniqueID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UniqueID = append(m.UniqueID[:0], dAtA[iNdEx:postIndex]...)
			if m.UniqueID == nil {
				m.UniqueID = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SetUIDataRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SetUIDataRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SetUIDataRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyValues", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.KeyValues == nil {
				m.KeyValues = make(map[string][]byte)
			}
			var mapkey string
			mapvalue := []byte{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAdmin
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthAdmin
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapbyteLen uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAdmin
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapbyteLen |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intMapbyteLen := int(mapbyteLen)
					if intMapbyteLen < 0 {
						return ErrInvalidLengthAdmin
					}
					postbytesIndex := iNdEx + intMapbyteLen
					if postbytesIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = make([]byte, mapbyteLen)
					copy(mapvalue, dAtA[iNdEx:postbytesIndex])
					iNdEx = postbytesIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAdmin(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAdmin
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.KeyValues[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SetUIDataResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SetUIDataResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SetUIDataResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetUIDataRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetUIDataRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetUIDataRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Keys = append(m.Keys, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetUIDataResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetUIDataResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetUIDataResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyValues", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.KeyValues == nil {
				m.KeyValues = make(map[string]GetUIDataResponse_Value)
			}
			var mapkey string
			mapvalue := &GetUIDataResponse_Value{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAdmin
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthAdmin
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAdmin
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthAdmin
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthAdmin
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &GetUIDataResponse_Value{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAdmin(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAdmin
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.KeyValues[mapkey] = *mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetUIDataResponse_Value) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Value: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Value: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = append(m.Value[:0], dAtA[iNdEx:postIndex]...)
			if m.Value == nil {
				m.Value = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdated", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := types.StdTimeUnmarshal(&m.LastUpdated, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClusterRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClusterResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReportingEnabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ReportingEnabled = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnterpriseEnabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EnterpriseEnabled = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DrainRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DrainRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DrainRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v int32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (int32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.On = append(m.On, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthAdmin
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAdmin
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.On = append(m.On, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field On", wireType)
			}
		case 2:
			if wireType == 0 {
				var v int32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (int32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Off = append(m.Off, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthAdmin
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAdmin
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Off = append(m.Off, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Off", wireType)
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Shutdown", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Shutdown = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DrainResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DrainResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DrainResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v int32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (int32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.On = append(m.On, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthAdmin
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAdmin
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.On = append(m.On, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field On", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DecommissionStatusRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DecommissionStatusRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DecommissionStatusRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v github_com_cockroachdb_cockroach_pkg_roachpb.NodeID
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.NodeIDs = append(m.NodeIDs, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthAdmin
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v github_com_cockroachdb_cockroach_pkg_roachpb.NodeID
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAdmin
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.NodeIDs = append(m.NodeIDs, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeIDs", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DecommissionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DecommissionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DecommissionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v github_com_cockroachdb_cockroach_pkg_roachpb.NodeID
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.NodeIDs = append(m.NodeIDs, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthAdmin
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v github_com_cockroachdb_cockroach_pkg_roachpb.NodeID
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAdmin
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.NodeIDs = append(m.NodeIDs, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeIDs", wireType)
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Decommissioning", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Decommissioning = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DecommissionStatusResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DecommissionStatusResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DecommissionStatusResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Status = append(m.Status, DecommissionStatusResponse_Status{})
			if err := m.Status[len(m.Status)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DecommissionStatusResponse_Status) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Status: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Status: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsLive", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsLive = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicaCount", wireType)
			}
			m.ReplicaCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReplicaCount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Decommissioning", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Decommissioning = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Draining", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Draining = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SettingsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SettingsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SettingsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Keys = append(m.Keys, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SettingsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SettingsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SettingsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyValues", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.KeyValues == nil {
				m.KeyValues = make(map[string]SettingsResponse_Value)
			}
			var mapkey string
			mapvalue := &SettingsResponse_Value{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAdmin
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthAdmin
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAdmin
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthAdmin
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthAdmin
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &SettingsResponse_Value{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAdmin(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAdmin
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.KeyValues[mapkey] = *mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SettingsResponse_Value) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Value: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Value: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HealthRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HealthRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HealthRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HealthResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HealthResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HealthResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LivenessRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LivenessRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LivenessRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LivenessResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LivenessResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LivenessResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Livenesses", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Livenesses = append(m.Livenesses, cockroach_storage.Liveness{})
			if err := m.Livenesses[len(m.Livenesses)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Statuses", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Statuses == nil {
				m.Statuses = make(map[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID]cockroach_storage.NodeLivenessStatus)
			}
			var mapkey int32
			var mapvalue cockroach_storage.NodeLivenessStatus
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAdmin
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAdmin
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= (cockroach_storage.NodeLivenessStatus(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAdmin(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAdmin
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Statuses[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(mapkey)] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *JobsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: JobsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: JobsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			m.Limit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Limit |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Status = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (cockroach_sql_jobs_jobspb.Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *JobsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: JobsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: JobsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Jobs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Jobs = append(m.Jobs, JobsResponse_Job{})
			if err := m.Jobs[len(m.Jobs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *JobsResponse_Job) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Job: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Job: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			m.ID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ID |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Username", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Username = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType == 0 {
				var v github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.DescriptorIDs = append(m.DescriptorIDs, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthAdmin
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAdmin
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.DescriptorIDs = append(m.DescriptorIDs, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field DescriptorIDs", wireType)
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Status = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Created", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Created == nil {
				m.Created = new(time.Time)
			}
			if err := types.StdTimeUnmarshal(m.Created, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Started", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Started == nil {
				m.Started = new(time.Time)
			}
			if err := types.StdTimeUnmarshal(m.Started, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Finished", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Finished == nil {
				m.Finished = new(time.Time)
			}
			if err := types.StdTimeUnmarshal(m.Finished, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Modified", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Modified == nil {
				m.Modified = new(time.Time)
			}
			if err := types.StdTimeUnmarshal(m.Modified, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field FractionCompleted", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.FractionCompleted = float32(math.Float32frombits(v))
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HighwaterTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HighwaterTimestamp == nil {
				m.HighwaterTimestamp = new(time.Time)
			}
			if err := types.StdTimeUnmarshal(m.HighwaterTimestamp, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HighwaterDecimal", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HighwaterDecimal = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LocationsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LocationsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LocationsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LocationsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LocationsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LocationsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Locations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Locations = append(m.Locations, LocationsResponse_Location{})
			if err := m.Locations[len(m.Locations)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LocationsResponse_Location) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Location: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Location: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalityKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LocalityKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalityValue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LocalityValue = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Latitude", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Latitude = float64(math.Float64frombits(v))
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Longitude", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Longitude = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeLogRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeLogRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeLogRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeId", wireType)
			}
			m.RangeId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeId |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			m.Limit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Limit |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeLogResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeLogResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeLogResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Events", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Events = append(m.Events, RangeLogResponse_Event{})
			if err := m.Events[len(m.Events)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeLogResponse_PrettyInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PrettyInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PrettyInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdatedDesc", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UpdatedDesc = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NewDesc", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NewDesc = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AddedReplica", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AddedReplica = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RemovedReplica", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RemovedReplica = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reason", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Reason = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Details", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Details = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeLogResponse_Event) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Event: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Event: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Event", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Event.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrettyInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PrettyInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryPlanRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryPlanRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryPlanRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryPlanResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryPlanResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryPlanResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DistSQLPhysicalQueryPlan", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DistSQLPhysicalQueryPlan = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DataDistributionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DataDistributionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DataDistributionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DataDistributionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DataDistributionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DataDistributionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DatabaseInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DatabaseInfo == nil {
				m.DatabaseInfo = make(map[string]DataDistributionResponse_DatabaseInfo)
			}
			var mapkey string
			mapvalue := &DataDistributionResponse_DatabaseInfo{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAdmin
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthAdmin
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAdmin
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthAdmin
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthAdmin
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &DataDistributionResponse_DatabaseInfo{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAdmin(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAdmin
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.DatabaseInfo[mapkey] = *mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ZoneConfigs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ZoneConfigs == nil {
				m.ZoneConfigs = make(map[string]DataDistributionResponse_ZoneConfig)
			}
			var mapkey string
			mapvalue := &DataDistributionResponse_ZoneConfig{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAdmin
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthAdmin
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAdmin
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthAdmin
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthAdmin
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &DataDistributionResponse_ZoneConfig{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAdmin(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAdmin
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ZoneConfigs[mapkey] = *mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DataDistributionResponse_ZoneConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ZoneConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ZoneConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ZoneName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ZoneName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Config.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConfigSQL", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ConfigSQL = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DataDistributionResponse_TableInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TableInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TableInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicaCountByNodeId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReplicaCountByNodeId == nil {
				m.ReplicaCountByNodeId = make(map[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID]int64)
			}
			var mapkey int32
			var mapvalue int64
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAdmin
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAdmin
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= (int64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAdmin(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAdmin
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ReplicaCountByNodeId[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(mapkey)] = mapvalue
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ZoneConfigId", wireType)
			}
			m.ZoneConfigId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ZoneConfigId |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DroppedAt == nil {
				m.DroppedAt = new(time.Time)
			}
			if err := types.StdTimeUnmarshal(m.DroppedAt, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DataDistributionResponse_DatabaseInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DatabaseInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DatabaseInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TableInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TableInfo == nil {
				m.TableInfo = make(map[string]DataDistributionResponse_TableInfo)
			}
			var mapkey string
			mapvalue := &DataDistributionResponse_TableInfo{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAdmin
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthAdmin
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAdmin
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthAdmin
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthAdmin
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &DataDistributionResponse_TableInfo{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAdmin(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAdmin
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.TableInfo[mapkey] = *mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MetricMetadataRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MetricMetadataRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MetricMetadataRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MetricMetadataResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MetricMetadataResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MetricMetadataResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = make(map[string]cockroach_util_metric.Metadata)
			}
			var mapkey string
			mapvalue := &cockroach_util_metric.Metadata{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAdmin
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthAdmin
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAdmin
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthAdmin
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthAdmin
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &cockroach_util_metric.Metadata{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAdmin(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAdmin
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Metadata[mapkey] = *mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnqueueRangeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EnqueueRangeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EnqueueRangeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Queue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Queue = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeID", wireType)
			}
			m.RangeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SkipShouldQueue", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SkipShouldQueue = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnqueueRangeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EnqueueRangeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EnqueueRangeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Details", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Details = append(m.Details, &EnqueueRangeResponse_Details{})
			if err := m.Details[len(m.Details)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnqueueRangeResponse_Details) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Details: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Details: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Events", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Events = append(m.Events, &TraceEvent{})
			if err := m.Events[len(m.Events)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipAdmin(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthAdmin
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipAdmin(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthAdmin = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowAdmin   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("server/serverpb/admin.proto", fileDescriptorAdmin) }

var fileDescriptorAdmin = []byte{
	// 3861 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x3a, 0x5d, 0x73, 0x1b, 0x59,
	0x56, 0x69, 0xc9, 0xfa, 0x3a, 0x92, 0x6c, 0xe9, 0xc6, 0xe3, 0x51, 0x94, 0xac, 0xe5, 0xe9, 0xec,
	0xec, 0x78, 0x33, 0xb3, 0xd2, 0xc4, 0xc9, 0xcc, 0x2c, 0x99, 0x0c, 0x8b, 0x65, 0xb9, 0x3c, 0xca,
	0x38, 0x99, 0x49, 0xcb, 0xc9, 0xd4, 0x06, 0x06, 0xd1, 0x52, 0x5f, 0xcb, 0xbd, 0x6e, 0x75, 0xcb,
	0xdd, 0x2d, 0x27, 0x9e, 0x61, 0xb7, 0xd8, 0x85, 0xa2, 0xe0, 0x65, 0x6b, 0x8b, 0xe5, 0x85, 0xda,
	0x2a, 0xaa, 0xa0, 0x28, 0xa8, 0x82, 0x2a, 0xaa, 0xf6, 0x0d, 0x78, 0xe0, 0x79, 0x8a, 0x07, 0xa0,
	0x8a, 0x17, 0x78, 0xc0, 0x0b, 0x5e, 0x1e, 0x28, 0x7e, 0x02, 0x0f, 0x40, 0xdd, 0xaf, 0xee, 0x2b,
	0xb9, 0xa7, 0x23, 0x39, 0xbb, 0x3c, 0x24, 0xee, 0x7b, 0xce, 0xbd, 0xe7, 0x9e, 0x7b, 0xce, 0xb9,
	0xe7, 0x9e, 0x0f, 0xc1, 0x55, 0x0f, 0xbb, 0xc7, 0xd8, 0x6d, 0xb0, 0x3f, 0xa3, 0x5e, 0x43, 0x37,
	0x86, 0xa6, 0x5d, 0x1f, 0xb9, 0x8e, 0xef, 0xa0, 0x2b, 0x7d, 0xa7, 0x7f, 0xe8, 0x3a, 0x7a, 0xff,
	0xa0, 0xce, 0xf0, 0x75, 0x31, 0xad, 0x5a, 0xee, 0x3b, 0xf6, 0xbe, 0x39, 0x68, 0x7c, 0xea, 0xd8,
	0x98, 0xcd, 0xae, 0xae, 0x7c, 0xcb, 0xe9, 0x79, 0x0d, 0xf2, 0xdf, 0xa8, 0x47, 0xff, 0x70, 0xf8,
	0xb5, 0xe9, 0x2d, 0x3c, 0x5f, 0xf7, 0xc7, 0x02, 0xab, 0x7a, 0xbe, 0xe3, 0xea, 0x03, 0xdc, 0xc0,
	0xf6, 0xc0, 0xb4, 0xc5, 0x9f, 0x51, 0xaf, 0x31, 0x3c, 0xee, 0xf7, 0x05, 0x65, 0x31, 0xc7, 0x32,
	0x8f, 0xb1, 0x8d, 0x3d, 0xb1, 0xb6, 0x1c, 0xc0, 0x9d, 0x01, 0x07, 0x55, 0xc6, 0xbe, 0x69, 0x35,
	0x86, 0xd8, 0x77, 0xcd, 0x3e, 0xff, 0xc3, 0x31, 0xcb, 0x03, 0x67, 0xe0, 0xd0, 0xcf, 0x06, 0xf9,
	0x12, 0xcc, 0x0d, 0x1c, 0x67, 0x60, 0xe1, 0x86, 0x3e, 0x32, 0x1b, 0xba, 0x6d, 0x3b, 0xbe, 0xee,
	0x9b, 0x8e, 0x2d, 0x36, 0xa8, 0x71, 0x2c, 0x1d, 0xf5, 0xc6, 0xfb, 0x0d, 0xdf, 0x1c, 0x62, 0xcf,
	0xd7, 0x87, 0x23, 0x36, 0x41, 0x45, 0x50, 0x6a, 0xe9, 0xbe, 0xde, 0xd3, 0x3d, 0xec, 0x69, 0xf8,
	0x68, 0x8c, 0x3d, 0x5f, 0xbd, 0x09, 0x65, 0x09, 0xe6, 0x8d, 0x1c, 0xdb, 0xc3, 0xe8, 0x1a, 0xe4,
	0x0c, 0x01, 0xac, 0x28, 0x6b, 0xc9, 0xf5, 0x9c, 0x16, 0x02, 0xd4, 0xdb, 0xb0, 0x22, 0x96, 0xb4,
	0xb0, 0xaf, 0x9b, 0x96, 0x20, 0x86, 0xaa, 0x90, 0x15, 0xd3, 0x2a, 0xca, 0x9a, 0xb2, 0x9e, 0xd3,
	0x82, 0xb1, 0xfa, 0xe7, 0x49, 0x78, 0xf9, 0xdc, 0x32, 0xbe, 0xdf, 0x63, 0x48, 0x0f, 0x5c, 0xdd,
	0xf6, 0xd9, 0x66, 0xf9, 0x8d, 0xaf, 0xd7, 0xbf, 0x50, 0x97, 0xf5, 0x2f, 0xa0, 0x51, 0xdf, 0x21,
	0x04, 0x9a, 0x0b, 0x9f, 0x9f, 0xd6, 0x2e, 0x69, 0x9c, 0x1a, 0xaa, 0x41, 0xde, 0xd7, 0x7b, 0x16,
	0xee, 0xda, 0xfa, 0x10, 0x7b, 0x95, 0x04, 0x3d, 0x09, 0x50, 0xd0, 0x03, 0x02, 0x41, 0x6f, 0x41,
	0xd1, 0xc0, 0x5e, 0xdf, 0x35, 0x47, 0xbe, 0xe3, 0x76, 0x4d, 0xa3, 0x92, 0x5c, 0x53, 0xd6, 0x93,
	0xcd, 0xd2, 0xd9, 0x69, 0xad, 0xd0, 0x0a, 0x10, 0xed, 0x96, 0x56, 0x08, 0xa7, 0xb5, 0x0d, 0xb4,
	0x05, 0x79, 0x62, 0x4a, 0x5d, 0x66, 0x56, 0x95, 0x85, 0x35, 0x65, 0x3d, 0xbf, 0x71, 0x4d, 0x62,
	0x9a, 0x21, 0xea, 0x4f, 0x1c, 0x1b, 0x6f, 0xd1, 0x4f, 0xce, 0x18, 0x7c, 0x1a, 0x40, 0xd0, 0x27,
	0x50, 0x96, 0x88, 0x74, 0x2d, 0x7c, 0x8c, 0xad, 0x4a, 0x6a, 0x4d, 0x59, 0x5f, 0xdc, 0xb8, 0x19,
	0x73, 0xfe, 0x90, 0xe6, 0xd8, 0xa5, 0xea, 0xdf, 0x25, 0x0b, 0xb5, 0xa5, 0x90, 0x32, 0x05, 0x54,
	0xdf, 0x85, 0x14, 0x15, 0x09, 0x42, 0xb0, 0x30, 0xf6, 0xb0, 0xcb, 0x15, 0x42, 0xbf, 0xd1, 0x2a,
	0xc0, 0xc8, 0x35, 0x8f, 0x4d, 0x0b, 0x0f, 0x42, 0xb9, 0x84, 0x10, 0x75, 0x07, 0x2e, 0xef, 0x11,
	0x29, 0xcd, 0xae, 0x5f, 0xb4, 0x0c, 0x29, 0x2a, 0xd8, 0x4a, 0x82, 0x22, 0xd8, 0x40, 0xfd, 0x9f,
	0x0c, 0x2c, 0x4f, 0x52, 0xe2, 0x2a, 0xef, 0x4c, 0xa9, 0xfc, 0xad, 0x98, 0x23, 0x47, 0x11, 0x88,
	0xd4, 0xf7, 0x63, 0xc8, 0xf4, 0x1d, 0x6b, 0x3c, 0xb4, 0xd9, 0x99, 0xf2, 0x1b, 0x6f, 0xcf, 0x4b,
	0x75, 0x8b, 0x2e, 0xe7, 0x64, 0x05, 0x31, 0xf4, 0x08, 0x32, 0xa6, 0x6d, 0xe0, 0x67, 0xd8, 0xab,
	0x24, 0x2f, 0xc6, 0x6d, 0x9b, 0x2c, 0x17, 0x64, 0x39, 0x2d, 0x62, 0x9e, 0xae, 0x6e, 0x0f, 0x88,
	0x09, 0x8c, 0x6d, 0x9f, 0x9a, 0x51, 0x52, 0x03, 0x0a, 0xda, 0x22, 0x10, 0x74, 0x1b, 0x56, 0xfa,
	0x2e, 0xd6, 0x7d, 0xdc, 0x65, 0x66, 0x4c, 0x7c, 0x11, 0x1e, 0x62, 0xdb, 0xa7, 0x76, 0x92, 0xd3,
	0x96, 0x19, 0x96, 0xee, 0xd8, 0x11, 0xb8, 0x69, 0xeb, 0x4c, 0xff, 0xec, 0xac, 0x33, 0xf3, 0xb3,
	0xb2, 0xce, 0xf3, 0x17, 0x2f, 0x3b, 0xcb, 0xc5, 0x7b, 0x21, 0xa3, 0xae, 0xfe, 0xad, 0x02, 0x69,
	0xa6, 0x5f, 0xb2, 0x9c, 0xb8, 0x04, 0xb1, 0x9c, 0x7c, 0x13, 0x98, 0x7f, 0x32, 0x12, 0xf6, 0x4b,
	0xbf, 0x89, 0xc1, 0xdb, 0x63, 0xcb, 0xa2, 0x76, 0x4d, 0x5c, 0x43, 0x56, 0x0b, 0xc6, 0xe8, 0x3a,
	0x39, 0xc2, 0xbe, 0x3e, 0xb6, 0xfc, 0xee, 0xb1, 0x6e, 0x8d, 0x31, 0xd5, 0x5f, 0x8e, 0x30, 0x4c,
	0x81, 0x8f, 0x09, 0x0c, 0xdd, 0x82, 0x97, 0x06, 0xd8, 0xc6, 0x4c, 0x16, 0x5d, 0xfc, 0x6c, 0xe4,
	0x62, 0xcf, 0x33, 0x1d, 0x5b, 0x28, 0x30, 0x44, 0x6e, 0x07, 0x38, 0xb4, 0x02, 0xe9, 0x03, 0xd3,
	0x30, 0xb0, 0x4d, 0x75, 0x97, 0xd5, 0xf8, 0xa8, 0xfa, 0x63, 0x05, 0x52, 0xd4, 0x90, 0x22, 0xf9,
	0x5f, 0x81, 0xf4, 0xd8, 0x36, 0x8f, 0xc6, 0xec, 0x04, 0x59, 0x8d, 0x8f, 0x50, 0x09, 0x92, 0x1e,
	0x3e, 0x62, 0x9e, 0x4d, 0x23, 0x9f, 0x64, 0x26, 0xb3, 0x6c, 0xce, 0x32, 0x1f, 0x51, 0xb7, 0x6f,
	0xba, 0xb8, 0xef, 0x87, 0x0c, 0x86, 0x00, 0x54, 0x81, 0x0c, 0x79, 0xc1, 0x4c, 0x7b, 0xc0, 0xd9,
	0x12, 0x43, 0x22, 0x25, 0x73, 0x38, 0xb2, 0xcc, 0xbe, 0xe9, 0x53, 0x13, 0xc9, 0x6a, 0xc1, 0x58,
	0xdd, 0x86, 0x72, 0x60, 0x9e, 0x2f, 0xe0, 0x47, 0xfe, 0x2a, 0x09, 0x48, 0xa6, 0xc3, 0xbd, 0xc8,
	0xd4, 0x0d, 0x52, 0xce, 0xdd, 0xa0, 0xeb, 0x50, 0x74, 0x31, 0x61, 0x45, 0xe7, 0x53, 0x12, 0x74,
	0x4a, 0x81, 0x03, 0xd9, 0xa4, 0x2f, 0x01, 0xd8, 0x8e, 0x21, 0x88, 0x30, 0x41, 0xe5, 0x08, 0x84,
	0xa1, 0xdf, 0x87, 0x14, 0xb9, 0x78, 0x1e, 0xf7, 0xf3, 0x6f, 0xc8, 0xe6, 0xcf, 0x9e, 0xf4, 0x3a,
	0x8b, 0x03, 0xea, 0x22, 0x1c, 0xa8, 0xdf, 0x7f, 0xbc, 0xb5, 0x45, 0x39, 0xe5, 0x37, 0x8b, 0x11,
	0x40, 0x06, 0x14, 0x87, 0xa6, 0xe7, 0x99, 0xf6, 0xa0, 0x4b, 0xc8, 0x7b, 0x95, 0x14, 0xf5, 0x26,
	0xbf, 0xf0, 0x3c, 0x6f, 0x32, 0x71, 0xe8, 0xfa, 0x7d, 0x46, 0xe2, 0x81, 0x63, 0x60, 0x4e, 0xbe,
	0x30, 0x0c, 0x41, 0x1e, 0xf1, 0x1a, 0xfa, 0x68, 0xe4, 0x3a, 0xcf, 0xcc, 0x21, 0x71, 0x1d, 0x86,
	0xe9, 0x1d, 0x76, 0x7b, 0x27, 0x3e, 0xf6, 0xa8, 0xde, 0x16, 0xb4, 0x65, 0x09, 0xdb, 0x32, 0xbd,
	0xc3, 0x26, 0xc1, 0x55, 0x3f, 0x86, 0xbc, 0x44, 0x18, 0x5d, 0x87, 0x0c, 0x95, 0x89, 0x69, 0x30,
	0x0d, 0x35, 0xe1, 0xec, 0xb4, 0x96, 0x26, 0xa8, 0x76, 0x4b, 0x4b, 0x13, 0x54, 0xdb, 0x20, 0xd2,
	0xc5, 0xae, 0xeb, 0xb8, 0xdd, 0x21, 0xf6, 0x3c, 0x7d, 0x20, 0x74, 0x56, 0xa0, 0xc0, 0xfb, 0x0c,
	0xa6, 0xae, 0xc0, 0xf2, 0x03, 0xc7, 0x3e, 0x67, 0x04, 0xaa, 0x0b, 0x2f, 0x4d, 0xc1, 0xb9, 0x52,
	0xbf, 0x09, 0x65, 0x12, 0xb9, 0x74, 0x3d, 0xec, 0x9a, 0xd8, 0xeb, 0x32, 0xd9, 0x2b, 0x54, 0xf6,
	0x5f, 0x9b, 0x4b, 0x52, 0xda, 0x12, 0xa1, 0xd3, 0xa1, 0x64, 0x28, 0x42, 0x5d, 0x84, 0xc2, 0x23,
	0x0f, 0xbb, 0x01, 0x0f, 0xdf, 0x81, 0x22, 0x1f, 0xf3, 0xbd, 0xdb, 0x90, 0x22, 0xbe, 0x44, 0xbc,
	0x4a, 0x71, 0xfb, 0x4d, 0x2c, 0xa4, 0x23, 0xa1, 0x6c, 0x4a, 0xa1, 0xaa, 0xc2, 0x02, 0x01, 0x12,
	0x63, 0x27, 0x00, 0xe9, 0xbe, 0x06, 0x63, 0xf5, 0x31, 0x14, 0xb7, 0x8f, 0xb1, 0x1d, 0xde, 0x0c,
	0xe1, 0x84, 0x14, 0xc9, 0x09, 0x5d, 0x85, 0x9c, 0xaf, 0xbb, 0x03, 0xec, 0x13, 0x65, 0x30, 0xfb,
	0xcd, 0x32, 0x40, 0xdb, 0x20, 0xd7, 0xc5, 0x32, 0x87, 0x26, 0x33, 0xdb, 0x94, 0xc6, 0x06, 0xea,
	0x7f, 0x25, 0x60, 0x51, 0x10, 0xe6, 0x27, 0xbb, 0x0f, 0x69, 0x4c, 0x21, 0xfc, 0x68, 0x8d, 0x98,
	0xa3, 0x4d, 0x2e, 0x65, 0x43, 0xf1, 0xd4, 0x32, 0x22, 0xd5, 0xdf, 0x49, 0x40, 0x8a, 0xc2, 0x51,
	0x13, 0x72, 0x41, 0xa0, 0xc9, 0xd5, 0x54, 0xad, 0xb3, 0x50, 0xb4, 0x2e, 0x42, 0xd1, 0xfa, 0x9e,
	0x98, 0xd1, 0xcc, 0x12, 0x32, 0x3f, 0xf8, 0x49, 0x4d, 0xd1, 0xc2, 0x65, 0xe4, 0x06, 0x52, 0xba,
	0x5d, 0xc9, 0x03, 0xe7, 0x28, 0x64, 0x8f, 0x48, 0xe0, 0xab, 0xb2, 0x04, 0x58, 0x88, 0x56, 0x38,
	0x3b, 0xad, 0x65, 0xf7, 0x98, 0x14, 0x5a, 0x92, 0x3c, 0x36, 0x80, 0xdc, 0x6d, 0xc7, 0xf5, 0xc9,
	0x25, 0x33, 0x0d, 0xf6, 0xa8, 0x36, 0x97, 0xce, 0x4e, 0x6b, 0x79, 0x4d, 0xc0, 0xdb, 0x2d, 0x2d,
	0x1f, 0x4c, 0x6a, 0x1b, 0x44, 0xe8, 0xa6, 0xbd, 0xef, 0x70, 0x97, 0x47, 0xbf, 0xc9, 0x96, 0xcc,
	0x7f, 0x12, 0x22, 0xe4, 0xde, 0x14, 0xd8, 0x96, 0x8f, 0x28, 0x90, 0x6c, 0xc9, 0xd0, 0x6d, 0x43,
	0xfd, 0x0b, 0x05, 0x4a, 0x1d, 0xec, 0x3f, 0x6a, 0x93, 0xd0, 0x54, 0x28, 0xf2, 0x9b, 0x00, 0x87,
	0xf8, 0x84, 0xbd, 0x0c, 0x42, 0xe4, 0x77, 0x62, 0x44, 0x3e, 0x4d, 0xa0, 0xfe, 0x01, 0x3e, 0xa1,
	0x4f, 0x88, 0xb7, 0x6d, 0xfb, 0xee, 0x89, 0x96, 0x3b, 0x14, 0xe3, 0xea, 0x5d, 0x58, 0x9c, 0x44,
	0x12, 0x17, 0x7f, 0x88, 0x4f, 0xb8, 0xd1, 0x90, 0x4f, 0x62, 0x16, 0xec, 0x51, 0x22, 0xb2, 0x2c,
	0x68, 0x6c, 0x70, 0x27, 0xf1, 0x75, 0x45, 0xbd, 0x0c, 0x65, 0x69, 0x2f, 0xa6, 0x61, 0xf5, 0x2b,
	0x50, 0xda, 0x99, 0x3e, 0x01, 0x82, 0x85, 0x43, 0x7c, 0x22, 0xe2, 0x7f, 0xfa, 0xad, 0xfe, 0x43,
	0x02, 0xca, 0x3b, 0xd3, 0xab, 0xd1, 0xaf, 0x45, 0x9c, 0xf5, 0xdd, 0x98, 0xb3, 0x9e, 0xa3, 0x30,
	0x75, 0x58, 0x6e, 0x6a, 0xd2, 0x91, 0xf7, 0x21, 0xc5, 0xde, 0xd3, 0xe0, 0x5c, 0x8a, 0x74, 0x2e,
	0xb4, 0x03, 0x05, 0x4b, 0xf7, 0xfc, 0xee, 0x78, 0x64, 0xe8, 0x3e, 0x66, 0x97, 0x64, 0x56, 0x2b,
	0xcc, 0x93, 0x95, 0x8f, 0xd8, 0xc2, 0xea, 0x68, 0x06, 0xd1, 0xbe, 0x2f, 0x8b, 0x36, 0xbf, 0xb1,
	0x31, 0xd7, 0x41, 0x29, 0x69, 0x59, 0x1d, 0x25, 0x58, 0xdc, 0xb2, 0xc6, 0x9e, 0x8f, 0x5d, 0xe1,
	0x93, 0x7e, 0xa4, 0xc0, 0x52, 0x00, 0xe2, 0x12, 0x7e, 0x03, 0xa0, 0xcf, 0x40, 0xa1, 0x43, 0x2e,
	0x9e, 0x9d, 0xd6, 0x72, 0x7c, 0x62, 0xbb, 0xa5, 0xe5, 0xf8, 0x84, 0xb6, 0x81, 0x5e, 0x87, 0x72,
	0x78, 0x07, 0xb0, 0x4d, 0xfc, 0xa2, 0xc1, 0x83, 0x82, 0x52, 0x80, 0xd8, 0x66, 0x70, 0xf4, 0x35,
	0x40, 0xd8, 0xf6, 0xb1, 0x3b, 0x72, 0x4d, 0x0f, 0x07, 0xb3, 0x59, 0xb0, 0x53, 0x0e, 0x31, 0x7c,
	0xba, 0xba, 0x0b, 0x85, 0x96, 0xab, 0x9b, 0xb6, 0xb0, 0x92, 0x45, 0x48, 0x38, 0x36, 0xd5, 0x79,
	0x4a, 0x4b, 0x38, 0x36, 0x91, 0x97, 0xb3, 0xbf, 0x4f, 0xa3, 0xaf, 0x94, 0x46, 0x3e, 0x89, 0xff,
	0xf3, 0x0e, 0xc6, 0xbe, 0xe1, 0x3c, 0xb5, 0x45, 0x0c, 0x25, 0xc6, 0x6a, 0x0d, 0x8a, 0x9c, 0x1a,
	0x3f, 0xe8, 0x14, 0x39, 0xf5, 0x53, 0xb8, 0xd2, 0xc2, 0x7d, 0x67, 0x48, 0x1f, 0x38, 0xc7, 0xee,
	0xd0, 0x64, 0x5c, 0xec, 0xfd, 0x09, 0x64, 0xf9, 0x1b, 0xc5, 0xac, 0x2e, 0xd5, 0x6c, 0x9e, 0x9d,
	0xd6, 0x32, 0xec, 0x91, 0xf2, 0xfe, 0xfb, 0xb4, 0x76, 0x6b, 0x60, 0xfa, 0x07, 0xe3, 0x5e, 0xbd,
	0xef, 0x0c, 0x1b, 0x81, 0x96, 0x8c, 0x5e, 0xf8, 0xdd, 0x18, 0x1d, 0x0e, 0x1a, 0xf4, 0x6b, 0xd4,
	0xab, 0xf3, 0xc7, 0x2d, 0xc3, 0x1e, 0x37, 0x4f, 0xfd, 0x43, 0x05, 0x2e, 0xcb, 0x9b, 0xff, 0xff,
	0x6c, 0x8b, 0xd6, 0x61, 0xc9, 0x90, 0x76, 0x25, 0xf1, 0x16, 0xd3, 0xdd, 0x34, 0x58, 0xfd, 0x69,
	0x02, 0xaa, 0x51, 0xd2, 0xe1, 0xb2, 0x7c, 0x02, 0x69, 0x56, 0xbc, 0xe0, 0xc9, 0xd0, 0xdd, 0xb8,
	0xac, 0xfa, 0x0b, 0xc9, 0xd4, 0xd9, 0x50, 0xb8, 0x7f, 0x46, 0xb1, 0xfa, 0x9f, 0x0a, 0xa4, 0x19,
	0x02, 0x3d, 0x99, 0x8c, 0x14, 0x52, 0xcd, 0xcd, 0x30, 0x52, 0xb8, 0xa8, 0x30, 0x44, 0x80, 0xf1,
	0x32, 0x64, 0x4c, 0xaf, 0x6b, 0x99, 0xc7, 0x41, 0x50, 0x6b, 0x7a, 0xbb, 0xe6, 0x31, 0x3e, 0x1f,
	0xd7, 0x25, 0x23, 0xe2, 0xba, 0x08, 0x49, 0x2e, 0x44, 0x4a, 0x92, 0x06, 0xa4, 0xc4, 0x0e, 0xc9,
	0x94, 0x14, 0xb3, 0x51, 0x31, 0x56, 0x5f, 0x85, 0xa5, 0x0e, 0xf6, 0xc9, 0x95, 0xf1, 0xe2, 0x5c,
	0xe3, 0x5f, 0x27, 0xe8, 0x2b, 0xc0, 0xe7, 0x71, 0x15, 0x74, 0xe7, 0x7f, 0x05, 0x26, 0x08, 0x3c,
	0xd7, 0x31, 0x76, 0x22, 0x1d, 0x63, 0x4e, 0x38, 0xc6, 0xa8, 0x9c, 0x66, 0x0d, 0xf2, 0x22, 0xa7,
	0x22, 0x71, 0x7e, 0x92, 0xa2, 0x64, 0x50, 0xd5, 0x99, 0xc1, 0x0b, 0xee, 0x4c, 0x7a, 0xc1, 0x9b,
	0xf3, 0x1c, 0xea, 0x9c, 0x13, 0x5c, 0x82, 0xe2, 0xfb, 0x58, 0xb7, 0xfc, 0x03, 0xe1, 0x03, 0x4b,
	0xb0, 0x28, 0x00, 0xfc, 0x85, 0x2a, 0xc3, 0xd2, 0x2e, 0xaf, 0xa7, 0x89, 0x49, 0x7f, 0x9f, 0x80,
	0x52, 0x08, 0xe3, 0x12, 0xdf, 0x04, 0x10, 0x75, 0xb7, 0x40, 0xe2, 0x57, 0x23, 0x22, 0x76, 0xb1,
	0x50, 0xa4, 0xbe, 0xe1, 0x22, 0xf4, 0x7b, 0x0a, 0x64, 0x99, 0x99, 0x63, 0x71, 0x75, 0xe2, 0x22,
	0xf4, 0x69, 0x16, 0xf8, 0x85, 0x11, 0x2a, 0x7b, 0x97, 0xd0, 0xff, 0xde, 0x4f, 0x2e, 0x76, 0x0f,
	0x02, 0x3e, 0xaa, 0x3d, 0x28, 0x4e, 0xd0, 0x95, 0x55, 0x92, 0x62, 0x2a, 0x79, 0x57, 0x56, 0xc9,
	0xe2, 0xc6, 0xab, 0x11, 0xa7, 0x26, 0x64, 0x05, 0xbf, 0xfc, 0x9a, 0x4b, 0x6a, 0x18, 0x41, 0xfe,
	0x9e, 0xd3, 0x0b, 0xac, 0x3c, 0x08, 0x2d, 0x15, 0x29, 0xb4, 0x24, 0xc9, 0x63, 0xe0, 0x55, 0x68,
	0xf2, 0xc8, 0x46, 0xe8, 0x16, 0x37, 0xb5, 0x24, 0xdd, 0xbc, 0x26, 0x6f, 0x7e, 0x64, 0xd5, 0x69,
	0x85, 0x95, 0x55, 0x5b, 0xeb, 0x24, 0xa4, 0x63, 0xb6, 0xa8, 0xfe, 0x6e, 0x1a, 0x0a, 0x6c, 0x4b,
	0xae, 0xbe, 0x6d, 0x58, 0x20, 0xb3, 0xb8, 0xe2, 0x5e, 0x8f, 0x11, 0xbb, 0xbc, 0x8c, 0x0c, 0xb8,
	0x22, 0xe9, 0xf2, 0xea, 0x8f, 0x53, 0x90, 0xbc, 0xe7, 0xf4, 0xd0, 0x0a, 0x24, 0xb8, 0x5b, 0x4a,
	0x36, 0xd3, 0x67, 0xa7, 0xb5, 0x44, 0xbb, 0xa5, 0x25, 0x4c, 0xe3, 0x62, 0xf7, 0x62, 0x22, 0x92,
	0x5f, 0x98, 0x8c, 0xe4, 0x91, 0x03, 0x8b, 0x13, 0x05, 0x0d, 0x96, 0xdb, 0x15, 0x9b, 0xef, 0x9f,
	0x9d, 0xd6, 0x8a, 0x72, 0x45, 0x63, 0xf6, 0x07, 0xc2, 0x3b, 0xb2, 0xc8, 0x3f, 0x92, 0x15, 0xd7,
	0xdb, 0x2d, 0xad, 0x28, 0x57, 0x42, 0x3c, 0x49, 0x0f, 0xe9, 0x09, 0x3d, 0xdc, 0x81, 0x0c, 0xab,
	0x0a, 0x19, 0x34, 0x17, 0x8f, 0x0f, 0x83, 0x16, 0x68, 0x08, 0x24, 0x16, 0x90, 0xb5, 0x9e, 0xaf,
	0xbb, 0x64, 0x6d, 0x76, 0xd6, 0xb5, 0x7c, 0x01, 0xba, 0x0b, 0xd9, 0x7d, 0xd3, 0x36, 0xbd, 0x03,
	0x6c, 0x54, 0x72, 0x33, 0x2e, 0x0e, 0x56, 0x90, 0xd5, 0x43, 0xc7, 0x30, 0xf7, 0x4d, 0x6c, 0x54,
	0x60, 0xd6, 0xd5, 0x62, 0x05, 0x89, 0x61, 0xf6, 0x5d, 0x9d, 0x96, 0x29, 0xba, 0x7d, 0x67, 0x38,
	0xb2, 0x30, 0x39, 0x42, 0x7e, 0x4d, 0x59, 0x4f, 0x68, 0x65, 0x81, 0xd9, 0x12, 0x08, 0x62, 0xd8,
	0x34, 0x43, 0xad, 0x14, 0x98, 0xaf, 0xa4, 0x03, 0xf4, 0x10, 0x2e, 0x1f, 0x98, 0x83, 0x83, 0xa7,
	0x3a, 0x89, 0xb2, 0xc2, 0x8c, 0xa6, 0x38, 0x23, 0x37, 0x28, 0x58, 0x1c, 0x60, 0x48, 0x20, 0x16,
	0x92, 0x34, 0x70, 0xdf, 0x1c, 0xea, 0x56, 0x65, 0x91, 0x6e, 0x5a, 0x0a, 0x10, 0x2d, 0x06, 0x57,
	0x11, 0x94, 0x76, 0x9d, 0x3e, 0xab, 0xe8, 0x0b, 0x17, 0xf7, 0xbf, 0x0a, 0x94, 0x25, 0x60, 0x90,
	0x20, 0xe7, 0x2c, 0x01, 0x9c, 0xa1, 0x7c, 0x7a, 0x8e, 0x40, 0x00, 0x11, 0xef, 0x49, 0x40, 0xad,
	0xfa, 0x7d, 0x05, 0xb2, 0x02, 0x8b, 0x5e, 0x81, 0x02, 0xc1, 0x58, 0xa6, 0x7f, 0xd2, 0x0d, 0xdd,
	0x7f, 0x5e, 0xc0, 0x3e, 0xc0, 0x27, 0xe8, 0x55, 0x58, 0x0c, 0xa6, 0x84, 0xce, 0x27, 0xa7, 0x15,
	0x05, 0x94, 0xbd, 0x4e, 0x55, 0xc8, 0x5a, 0xba, 0x6f, 0xfa, 0x63, 0x83, 0x39, 0x08, 0x45, 0x0b,
	0xc6, 0xe8, 0x1a, 0x39, 0x8d, 0x3d, 0x60, 0xc8, 0x05, 0x8a, 0x0c, 0x01, 0x6a, 0x13, 0x96, 0x34,
	0xdd, 0x1e, 0xe0, 0x5d, 0x67, 0x20, 0xfc, 0xd2, 0x15, 0xc8, 0xb2, 0xa2, 0x8f, 0xb8, 0xda, 0x5a,
	0x86, 0x8e, 0xe5, 0x6c, 0x38, 0x21, 0x67, 0xc3, 0xff, 0x9a, 0x84, 0x52, 0x48, 0x84, 0x0b, 0xf1,
	0xc3, 0x20, 0x1f, 0x66, 0x2e, 0x3e, 0xee, 0x05, 0x9b, 0x5e, 0x1c, 0x99, 0x11, 0xff, 0x9d, 0x02,
	0xf0, 0x91, 0x8b, 0x7d, 0xff, 0xa4, 0x4d, 0x12, 0xc8, 0x57, 0xa0, 0xc0, 0xd3, 0x91, 0x2e, 0xb9,
	0xb8, 0x42, 0x78, 0x1c, 0x46, 0x3c, 0x02, 0x39, 0x88, 0x8d, 0x9f, 0x32, 0x34, 0x13, 0x5b, 0xc6,
	0xc6, 0x4f, 0x29, 0xea, 0x3a, 0x14, 0x75, 0xc3, 0xc0, 0x46, 0x97, 0x07, 0x34, 0xdc, 0x1d, 0x15,
	0x28, 0x50, 0x63, 0x30, 0xf4, 0x1a, 0x2c, 0xb9, 0x78, 0xe8, 0x1c, 0x4b, 0xd3, 0x98, 0x5b, 0x5a,
	0xe4, 0x60, 0x31, 0x71, 0x05, 0xd2, 0x2e, 0xd6, 0xbd, 0xa0, 0xaa, 0xc7, 0x47, 0xa8, 0x02, 0x19,
	0x83, 0x15, 0xaa, 0xb9, 0x13, 0x11, 0xc3, 0xea, 0x9f, 0x28, 0x22, 0xbd, 0xbf, 0x0b, 0x29, 0x7a,
	0x40, 0x9e, 0xda, 0xaf, 0x45, 0xbc, 0x2a, 0x42, 0x3c, 0xb2, 0x54, 0xd8, 0x22, 0xf4, 0x09, 0xe4,
	0x47, 0x54, 0x26, 0x5d, 0x9a, 0x61, 0xb3, 0x60, 0xe1, 0xed, 0x79, 0x44, 0x1d, 0x8a, 0x54, 0x3c,
	0xd5, 0xa3, 0x00, 0x72, 0x6f, 0x21, 0xab, 0x94, 0x12, 0xea, 0x3a, 0x94, 0x1e, 0x8e, 0xb1, 0x7b,
	0xf2, 0x91, 0xa5, 0xdb, 0xd2, 0xe3, 0x75, 0x44, 0x60, 0x22, 0x1e, 0xa2, 0x03, 0x75, 0x04, 0x65,
	0x69, 0x26, 0xb7, 0x84, 0x5f, 0x86, 0xab, 0x86, 0xe9, 0xf9, 0xde, 0x91, 0xd5, 0x1d, 0x1d, 0x9c,
	0x78, 0x66, 0x5f, 0xb7, 0xba, 0x74, 0x7a, 0x77, 0x64, 0xe9, 0x36, 0xcf, 0xb6, 0xae, 0x9d, 0x9d,
	0xd6, 0x2a, 0x2d, 0xd3, 0xf3, 0x3b, 0x0f, 0x77, 0x3f, 0xe2, 0xb3, 0x42, 0x52, 0x15, 0x4e, 0xe0,
	0x1c, 0x46, 0xbd, 0xc2, 0xba, 0x5e, 0x64, 0xa5, 0x6b, 0xf6, 0xc6, 0x7e, 0x98, 0x47, 0xa8, 0x7f,
	0x09, 0x50, 0x39, 0x8f, 0xe3, 0x4c, 0x8d, 0xa0, 0x28, 0x4a, 0xa2, 0x4c, 0x74, 0xec, 0x9e, 0x6f,
	0x3f, 0xa7, 0x33, 0x16, 0x45, 0x2b, 0x68, 0x99, 0x11, 0x91, 0xc9, 0x71, 0x64, 0xc1, 0x90, 0x10,
	0x68, 0x08, 0x05, 0xa9, 0xe2, 0x2f, 0x3a, 0x1d, 0xad, 0x8b, 0x6c, 0x18, 0x76, 0x01, 0x26, 0xe2,
	0xd6, 0x7c, 0xd8, 0x05, 0xf0, 0xaa, 0x7f, 0xa0, 0x00, 0x84, 0xf3, 0xd0, 0x55, 0xc8, 0xd1, 0xdd,
	0xe5, 0x32, 0x19, 0x01, 0x3c, 0x20, 0x8f, 0xeb, 0x1d, 0x48, 0xf3, 0x66, 0x46, 0x62, 0xe6, 0x66,
	0x06, 0x5f, 0x41, 0x53, 0x67, 0xd6, 0xc3, 0xf0, 0x8e, 0x2c, 0x76, 0x3f, 0x78, 0xea, 0x4c, 0xa1,
	0x9d, 0x87, 0xbb, 0x5a, 0x8e, 0x4d, 0xe8, 0x1c, 0x59, 0xf7, 0x16, 0xb2, 0xc9, 0xd2, 0x42, 0xf5,
	0xb7, 0x93, 0x90, 0xa3, 0xe5, 0x44, 0x2a, 0x98, 0xcf, 0x15, 0xa8, 0x4c, 0x24, 0x1b, 0xdd, 0xde,
	0x49, 0x37, 0x4c, 0x79, 0x88, 0x94, 0x3e, 0xbe, 0x88, 0x94, 0x82, 0x1d, 0xea, 0x9a, 0x94, 0xb5,
	0x34, 0x4f, 0x68, 0xec, 0x67, 0x30, 0xc1, 0xbd, 0x73, 0xd1, 0xc8, 0x71, 0xd9, 0x8d, 0xa0, 0x89,
	0xbe, 0x0c, 0x8b, 0x72, 0x57, 0x27, 0xa8, 0x27, 0x16, 0x42, 0xcd, 0xb4, 0x0d, 0xf4, 0x0d, 0x00,
	0xc3, 0x75, 0x46, 0x23, 0x6c, 0x74, 0x75, 0x96, 0x59, 0xcd, 0xf2, 0x00, 0xe6, 0xf8, 0x9a, 0x4d,
	0xbf, 0xba, 0x03, 0x57, 0xbe, 0xf0, 0x48, 0x11, 0x81, 0xeb, 0x44, 0xb1, 0x2a, 0x29, 0x45, 0xa4,
	0xd5, 0xef, 0x26, 0xa0, 0x20, 0x5b, 0x2f, 0xf2, 0x81, 0xb5, 0x6f, 0xe5, 0x3b, 0xf1, 0xe1, 0x8b,
	0xde, 0x89, 0x50, 0x13, 0x13, 0x59, 0x96, 0x2f, 0xa0, 0xd5, 0xcf, 0x60, 0x71, 0x72, 0x4a, 0x44,
	0x42, 0xd4, 0x99, 0x4c, 0x88, 0xde, 0x7b, 0x21, 0x8b, 0x98, 0x90, 0x81, 0x12, 0xb6, 0xe8, 0xe3,
	0x18, 0x78, 0x3c, 0xc9, 0xc0, 0x2f, 0xbd, 0xa8, 0x54, 0x64, 0x1e, 0xbe, 0x03, 0xa5, 0xe9, 0x3b,
	0x1d, 0xc1, 0xc1, 0xde, 0x24, 0x07, 0xbf, 0xf8, 0x62, 0xae, 0x43, 0xda, 0xff, 0xde, 0x42, 0x36,
	0x51, 0x4a, 0xaa, 0x2f, 0xc3, 0x4b, 0xf7, 0xe9, 0x8f, 0x24, 0xee, 0x63, 0x5f, 0x37, 0xc2, 0x52,
	0xa5, 0xfa, 0x2f, 0x0a, 0xac, 0x4c, 0x63, 0xb8, 0x1f, 0xd5, 0x21, 0x3b, 0xe4, 0x30, 0x6e, 0x2e,
	0xdf, 0x88, 0x61, 0x2b, 0x9a, 0x48, 0x5d, 0x00, 0x64, 0xf3, 0x08, 0xc8, 0x56, 0x7f, 0x05, 0x8a,
	0x13, 0x13, 0x22, 0x24, 0xf3, 0xd6, 0xa4, 0x64, 0xe4, 0xec, 0x68, 0xec, 0x9b, 0x56, 0x9d, 0xff,
	0xf6, 0x23, 0xd8, 0x58, 0x4a, 0xca, 0x7e, 0x98, 0x80, 0xcb, 0xdb, 0xf6, 0xd1, 0x18, 0x8f, 0x31,
	0x7d, 0x1b, 0xc5, 0x03, 0xf7, 0xf3, 0x2c, 0xbb, 0xb0, 0xc7, 0x33, 0x08, 0xe6, 0xd8, 0x00, 0xfd,
	0xaa, 0x14, 0x77, 0xd1, 0x6e, 0x43, 0x73, 0xeb, 0xec, 0xb4, 0x96, 0xa1, 0x5c, 0xd1, 0x3d, 0x6f,
	0xcf, 0xb5, 0x27, 0x5f, 0x17, 0x06, 0x6f, 0x37, 0xa0, 0xec, 0x1d, 0x9a, 0xa3, 0xae, 0x77, 0xe0,
	0x8c, 0x2d, 0xa3, 0xcb, 0x38, 0xe0, 0x05, 0x1b, 0x82, 0xe8, 0x50, 0xf8, 0x43, 0x02, 0x56, 0xff,
	0x34, 0x01, 0xcb, 0x93, 0x52, 0xe1, 0xfa, 0x7e, 0x18, 0x86, 0x34, 0x4c, 0xdd, 0xef, 0xc4, 0xf5,
	0x39, 0x22, 0x28, 0xd4, 0x45, 0xeb, 0x3e, 0x88, 0x85, 0xfe, 0x46, 0x81, 0x0c, 0x07, 0xfe, 0x5c,
	0xa5, 0xfe, 0xde, 0x54, 0x44, 0xfa, 0x6a, 0x5c, 0xb3, 0xcb, 0xd5, 0xfb, 0x98, 0xc6, 0x5b, 0x22,
	0xfe, 0x0c, 0xb3, 0x9a, 0xa4, 0x94, 0xd5, 0xdc, 0xf8, 0x00, 0x56, 0xa2, 0x7b, 0xf2, 0x28, 0x0f,
	0x99, 0x47, 0x0f, 0x3e, 0x78, 0xf0, 0xe1, 0xc7, 0x0f, 0x4a, 0x97, 0xc8, 0x60, 0x6b, 0xf7, 0x51,
	0x67, 0x6f, 0x5b, 0x2b, 0x29, 0xa8, 0x00, 0xd9, 0xd6, 0xe6, 0xde, 0x66, 0x73, 0xb3, 0xb3, 0x5d,
	0x4a, 0xa0, 0x1c, 0xa4, 0xf6, 0x36, 0x9b, 0xbb, 0xdb, 0xa5, 0xe4, 0x8d, 0xeb, 0x90, 0xa3, 0xe5,
	0xda, 0xfb, 0x8e, 0x81, 0x11, 0x40, 0x7a, 0x6b, 0xb7, 0xbd, 0xfd, 0x60, 0xaf, 0x74, 0x89, 0x7c,
	0xef, 0x6e, 0x6f, 0x76, 0xb6, 0x3b, 0x25, 0x65, 0xe3, 0xfb, 0x57, 0x20, 0xb5, 0x69, 0x0c, 0x4d,
	0x1b, 0xf9, 0x90, 0xa2, 0x4d, 0x32, 0xf4, 0xda, 0xf3, 0xdb, 0x68, 0xd4, 0xa8, 0xab, 0xeb, 0xb3,
	0xf6, 0xdb, 0xd4, 0xca, 0xf7, 0xfe, 0xe9, 0x3f, 0x7e, 0x98, 0x40, 0xa8, 0xd4, 0xe8, 0xd2, 0x1f,
	0x81, 0x35, 0x8e, 0x6f, 0x36, 0x68, 0xdf, 0x0d, 0xfd, 0x96, 0x02, 0xb9, 0xe0, 0x27, 0x4d, 0xe8,
	0xf5, 0x19, 0x7e, 0x4a, 0x14, 0x6c, 0xff, 0xc6, 0x6c, 0x93, 0x39, 0x0b, 0xd7, 0x28, 0x0b, 0x2b,
	0x68, 0x59, 0x62, 0x21, 0xf8, 0x95, 0x14, 0xfa, 0x23, 0x05, 0x96, 0xa6, 0x7e, 0xab, 0x84, 0x6e,
	0xce, 0xf3, 0xbb, 0x26, 0xc6, 0xd2, 0xc6, 0xfc, 0x3f, 0x85, 0x52, 0x5f, 0xa3, 0x8c, 0xbd, 0x82,
	0x6a, 0x51, 0x8c, 0x35, 0x3e, 0x13, 0x9f, 0xdf, 0x46, 0x7f, 0xa6, 0x40, 0x41, 0xfe, 0xb9, 0x0a,
	0xaa, 0xcf, 0xfc, 0xbb, 0x16, 0xc6, 0x5d, 0x63, 0xce, 0xdf, 0xc1, 0xa8, 0x6f, 0x53, 0xd6, 0xde,
	0x44, 0xf5, 0xe7, 0xb0, 0xd6, 0xa0, 0x8f, 0xaf, 0xd7, 0xf8, 0x8c, 0xfe, 0xa5, 0x9c, 0x42, 0xd8,
	0xe0, 0x45, 0x6f, 0xcc, 0xd8, 0x07, 0x66, 0x5c, 0xce, 0xd7, 0x35, 0x56, 0xef, 0x52, 0x1e, 0xdf,
	0x46, 0xb7, 0xe7, 0xe3, 0xb1, 0xc1, 0x7a, 0xfc, 0xbf, 0xaf, 0x40, 0x71, 0xa2, 0xaf, 0x8d, 0xe2,
	0x84, 0x14, 0xd5, 0x19, 0xaf, 0xbe, 0x39, 0xfb, 0x02, 0xce, 0xf2, 0x1a, 0x65, 0xb9, 0x8a, 0x2a,
	0x12, 0xcb, 0xb6, 0x63, 0x33, 0x06, 0x29, 0x13, 0xcf, 0x20, 0xcd, 0xba, 0xba, 0x68, 0x7d, 0x86,
	0xc6, 0x2f, 0xe3, 0xe3, 0xab, 0x33, 0xb7, 0x88, 0xd5, 0x2b, 0x94, 0x81, 0xcb, 0xa8, 0x2c, 0x31,
	0xc0, 0xfd, 0x12, 0xb9, 0x8f, 0x41, 0xc7, 0x31, 0xf6, 0x3e, 0x4e, 0xf7, 0x40, 0x63, 0xef, 0xe3,
	0xf9, 0x26, 0x26, 0xbf, 0x8f, 0xaa, 0xcc, 0xc3, 0xd8, 0x24, 0xea, 0xba, 0xa3, 0xdc, 0x40, 0xdf,
	0x55, 0x20, 0xb7, 0x33, 0x13, 0x1b, 0x3b, 0xf3, 0xb0, 0x71, 0xae, 0xc5, 0x17, 0x29, 0x0a, 0xc6,
	0x06, 0xfa, 0x75, 0xc8, 0xf0, 0x86, 0x1d, 0x8a, 0x93, 0xed, 0x64, 0x43, 0xb0, 0x7a, 0x63, 0x96,
	0xa9, 0x7c, 0xf3, 0x2a, 0xdd, 0x7c, 0x19, 0x21, 0x69, 0x73, 0xde, 0x18, 0x44, 0xbf, 0xa1, 0x40,
	0x56, 0xd4, 0xe2, 0xd1, 0x8d, 0x99, 0x0a, 0xf6, 0x8c, 0x81, 0xd7, 0xe7, 0x28, 0xee, 0xab, 0x57,
	0x29, 0x07, 0x2f, 0xa1, 0xcb, 0x12, 0x07, 0x9e, 0xd8, 0xf5, 0x19, 0xa4, 0x59, 0x5d, 0x3f, 0xd6,
	0x0a, 0x27, 0x7a, 0x01, 0xb1, 0x56, 0x38, 0xd5, 0x24, 0x88, 0x12, 0xfd, 0x01, 0xdb, 0x8f, 0x1c,
	0x5e, 0x54, 0xbe, 0x63, 0x0f, 0x3f, 0xd5, 0x65, 0x88, 0x3d, 0xfc, 0x74, 0xe9, 0x3f, 0xf2, 0xf0,
	0xa2, 0xb3, 0x80, 0x46, 0xb0, 0x70, 0xcf, 0xe9, 0x79, 0xe8, 0x2b, 0xcf, 0xad, 0x6a, 0xb3, 0x9d,
	0x5f, 0x9b, 0xb1, 0xfa, 0xad, 0xbe, 0x4c, 0x77, 0x2d, 0xa3, 0x25, 0x69, 0xd7, 0x6f, 0x91, 0x9d,
	0xc8, 0xd5, 0x0b, 0xaa, 0x7f, 0xb1, 0x36, 0x3f, 0x5d, 0x79, 0x8c, 0xb5, 0xf9, 0x73, 0x05, 0xc5,
	0xc8, 0xa7, 0x30, 0x28, 0x2a, 0x52, 0x36, 0x82, 0x8a, 0x48, 0x2c, 0x1b, 0xd3, 0x65, 0x9c, 0x58,
	0x36, 0xce, 0x55, 0x72, 0x22, 0xd9, 0xa0, 0x95, 0x9c, 0x11, 0xd9, 0xf8, 0x04, 0x52, 0x34, 0x7a,
	0x89, 0x0d, 0x47, 0xe4, 0xe6, 0x76, 0x6c, 0x38, 0x32, 0xd1, 0xb7, 0x16, 0x8a, 0x57, 0xe5, 0x70,
	0x84, 0x76, 0x10, 0xef, 0x28, 0x37, 0xde, 0x54, 0xd0, 0x53, 0x28, 0xc8, 0x1d, 0xd6, 0xd8, 0x77,
	0x36, 0xa2, 0xe5, 0x5c, 0x7d, 0xeb, 0x42, 0xad, 0x5b, 0xf5, 0x12, 0xfa, 0x4d, 0x05, 0xd0, 0xf9,
	0x09, 0xe8, 0xf6, 0x9c, 0xf4, 0x5e, 0x90, 0x8b, 0x3f, 0x56, 0x20, 0x2b, 0x0a, 0x7b, 0xb1, 0x97,
	0x6f, 0xaa, 0xd4, 0x1b, 0x7b, 0xf9, 0xa6, 0x2b, 0x85, 0xea, 0x7b, 0x54, 0x07, 0xef, 0x4c, 0x5c,
	0x3e, 0x9a, 0x5b, 0x58, 0xce, 0xe0, 0xc9, 0x1a, 0x5a, 0x8d, 0x00, 0x37, 0x3e, 0x13, 0x19, 0xcd,
	0xb7, 0x49, 0xc0, 0x56, 0x9a, 0x4e, 0x4b, 0xd1, 0xc6, 0x5c, 0x39, 0x2c, 0x63, 0xfa, 0xd6, 0x05,
	0xf2, 0x5e, 0xf5, 0xcb, 0x94, 0xf9, 0x55, 0x74, 0x6d, 0x2a, 0xe8, 0xe8, 0x1a, 0x32, 0x3b, 0x3f,
	0x52, 0xa0, 0xbc, 0x69, 0x59, 0x93, 0x69, 0x2a, 0x7a, 0x73, 0x8e, 0x8c, 0x96, 0xb1, 0x78, 0x73,
	0xee, 0x1c, 0x58, 0x7d, 0x85, 0x32, 0x78, 0x15, 0x5d, 0x91, 0x18, 0x64, 0x69, 0xab, 0x48, 0x84,
	0x49, 0xe8, 0x53, 0x90, 0x53, 0xaa, 0x58, 0x33, 0x8f, 0xc8, 0x69, 0x63, 0xc3, 0xc9, 0xa8, 0x5c,
	0x4d, 0xbd, 0x4e, 0x99, 0xfa, 0x92, 0x2a, 0xc7, 0x3d, 0x98, 0x4d, 0xec, 0x52, 0xcd, 0xde, 0x51,
	0x6e, 0x34, 0xd5, 0xcf, 0xff, 0x7d, 0xf5, 0xd2, 0xe7, 0x67, 0xab, 0xca, 0x3f, 0x9e, 0xad, 0x2a,
	0xff, 0x7c, 0xb6, 0xaa, 0xfc, 0xdb, 0xd9, 0xaa, 0xf2, 0x83, 0x9f, 0xae, 0x5e, 0x7a, 0x92, 0x15,
	0xd4, 0x7b, 0x69, 0x5a, 0xd6, 0xba, 0xf5, 0x7f, 0x01, 0x00, 0x00, 0xff, 0xff, 0x6b, 0xad, 0x0e,
	0x72, 0x62, 0x32, 0x00, 0x00,
}
