// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: server/status/status.proto

/*
	Package status is a generated protocol buffer package.

	It is generated from these files:
		server/status/status.proto

	It has these top-level messages:
		StoreStatus
		NodeStatus
		HealthAlert
		HealthCheckResult
*/
package status

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import cockroach_roachpb "github.com/cockroachdb/cockroach/pkg/roachpb"
import cockroach_build "github.com/cockroachdb/cockroach/pkg/build"

import github_com_cockroachdb_cockroach_pkg_roachpb "github.com/cockroachdb/cockroach/pkg/roachpb"

import sortkeys "github.com/gogo/protobuf/sortkeys"
import binary "encoding/binary"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type HealthAlert_Category int32

const (
	HealthAlert_METRICS HealthAlert_Category = 0
	HealthAlert_NETWORK HealthAlert_Category = 1
)

var HealthAlert_Category_name = map[int32]string{
	0: "METRICS",
	1: "NETWORK",
}
var HealthAlert_Category_value = map[string]int32{
	"METRICS": 0,
	"NETWORK": 1,
}

func (x HealthAlert_Category) String() string {
	return proto.EnumName(HealthAlert_Category_name, int32(x))
}
func (HealthAlert_Category) EnumDescriptor() ([]byte, []int) { return fileDescriptorStatus, []int{2, 0} }

// StoreStatus records the most recent values of metrics for a store.
type StoreStatus struct {
	Desc    cockroach_roachpb.StoreDescriptor `protobuf:"bytes,1,opt,name=desc" json:"desc"`
	Metrics map[string]float64                `protobuf:"bytes,2,rep,name=metrics" json:"metrics,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"fixed64,2,opt,name=value,proto3"`
}

func (m *StoreStatus) Reset()                    { *m = StoreStatus{} }
func (m *StoreStatus) String() string            { return proto.CompactTextString(m) }
func (*StoreStatus) ProtoMessage()               {}
func (*StoreStatus) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{0} }

// NodeStatus records the most recent values of metrics for a node.
type NodeStatus struct {
	Desc          cockroach_roachpb.NodeDescriptor `protobuf:"bytes,1,opt,name=desc" json:"desc"`
	BuildInfo     cockroach_build.Info             `protobuf:"bytes,2,opt,name=build_info,json=buildInfo" json:"build_info"`
	StartedAt     int64                            `protobuf:"varint,3,opt,name=started_at,json=startedAt,proto3" json:"started_at,omitempty"`
	UpdatedAt     int64                            `protobuf:"varint,4,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	Metrics       map[string]float64               `protobuf:"bytes,5,rep,name=metrics" json:"metrics,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"fixed64,2,opt,name=value,proto3"`
	StoreStatuses []StoreStatus                    `protobuf:"bytes,6,rep,name=store_statuses,json=storeStatuses" json:"store_statuses"`
	Args          []string                         `protobuf:"bytes,7,rep,name=args" json:"args,omitempty"`
	Env           []string                         `protobuf:"bytes,8,rep,name=env" json:"env,omitempty"`
	// latencies is a map of nodeIDs to nanoseconds which is the latency
	// between this node and the other node.
	//
	// NOTE: this is deprecated and is only set if the min supported
	//       cluster version is >= VersionRPCNetworkStats.
	Latencies map[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID]int64 `protobuf:"bytes,9,rep,name=latencies,castkey=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"latencies" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// activity is a map of nodeIDs to network statistics from this node
	// to other nodes.
	Activity map[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID]NodeStatus_NetworkActivity `protobuf:"bytes,10,rep,name=activity,castkey=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"activity" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
	// total_system_memory is the total RAM available to the system
	// (or, if possible, the memory available to the cgroup this process is in)
	// in bytes.
	TotalSystemMemory int64 `protobuf:"varint,11,opt,name=total_system_memory,json=totalSystemMemory,proto3" json:"total_system_memory,omitempty"`
	// num_cpus is the number of logical CPUs on this machine.
	NumCpus int32 `protobuf:"varint,12,opt,name=num_cpus,json=numCpus,proto3" json:"num_cpus,omitempty"`
}

func (m *NodeStatus) Reset()                    { *m = NodeStatus{} }
func (m *NodeStatus) String() string            { return proto.CompactTextString(m) }
func (*NodeStatus) ProtoMessage()               {}
func (*NodeStatus) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{1} }

type NodeStatus_NetworkActivity struct {
	Incoming int64 `protobuf:"varint,1,opt,name=incoming,proto3" json:"incoming,omitempty"`
	Outgoing int64 `protobuf:"varint,2,opt,name=outgoing,proto3" json:"outgoing,omitempty"`
	Latency  int64 `protobuf:"varint,3,opt,name=latency,proto3" json:"latency,omitempty"`
}

func (m *NodeStatus_NetworkActivity) Reset()         { *m = NodeStatus_NetworkActivity{} }
func (m *NodeStatus_NetworkActivity) String() string { return proto.CompactTextString(m) }
func (*NodeStatus_NetworkActivity) ProtoMessage()    {}
func (*NodeStatus_NetworkActivity) Descriptor() ([]byte, []int) {
	return fileDescriptorStatus, []int{1, 2}
}

// A HealthAlert is an undesired condition detected by a server which should be
// exposed to the operators.
type HealthAlert struct {
	// store_id is zero for alerts not specific to a store (i.e. apply at the node level).
	StoreID     github_com_cockroachdb_cockroach_pkg_roachpb.StoreID `protobuf:"varint,1,opt,name=store_id,json=storeId,proto3,customtype=github.com/cockroachdb/cockroach/pkg/roachpb.StoreID" json:"store_id"`
	Category    HealthAlert_Category                                 `protobuf:"varint,2,opt,name=category,proto3,enum=cockroach.server.status.HealthAlert_Category" json:"category,omitempty"`
	Description string                                               `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	Value       float64                                              `protobuf:"fixed64,4,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *HealthAlert) Reset()                    { *m = HealthAlert{} }
func (m *HealthAlert) String() string            { return proto.CompactTextString(m) }
func (*HealthAlert) ProtoMessage()               {}
func (*HealthAlert) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{2} }

// HealthCheckResult holds a number of HealthAlerts.
type HealthCheckResult struct {
	Alerts []HealthAlert `protobuf:"bytes,1,rep,name=alerts" json:"alerts"`
}

func (m *HealthCheckResult) Reset()                    { *m = HealthCheckResult{} }
func (m *HealthCheckResult) String() string            { return proto.CompactTextString(m) }
func (*HealthCheckResult) ProtoMessage()               {}
func (*HealthCheckResult) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{3} }

func init() {
	proto.RegisterType((*StoreStatus)(nil), "cockroach.server.status.StoreStatus")
	proto.RegisterType((*NodeStatus)(nil), "cockroach.server.status.NodeStatus")
	proto.RegisterType((*NodeStatus_NetworkActivity)(nil), "cockroach.server.status.NodeStatus.NetworkActivity")
	proto.RegisterType((*HealthAlert)(nil), "cockroach.server.status.HealthAlert")
	proto.RegisterType((*HealthCheckResult)(nil), "cockroach.server.status.HealthCheckResult")
	proto.RegisterEnum("cockroach.server.status.HealthAlert_Category", HealthAlert_Category_name, HealthAlert_Category_value)
}
func (m *StoreStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StoreStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintStatus(dAtA, i, uint64(m.Desc.Size()))
	n1, err := m.Desc.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	if len(m.Metrics) > 0 {
		keysForMetrics := make([]string, 0, len(m.Metrics))
		for k := range m.Metrics {
			keysForMetrics = append(keysForMetrics, string(k))
		}
		sortkeys.Strings(keysForMetrics)
		for _, k := range keysForMetrics {
			dAtA[i] = 0x12
			i++
			v := m.Metrics[string(k)]
			mapSize := 1 + len(k) + sovStatus(uint64(len(k))) + 1 + 8
			i = encodeVarintStatus(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintStatus(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x11
			i++
			binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(v))))
			i += 8
		}
	}
	return i, nil
}

func (m *NodeStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintStatus(dAtA, i, uint64(m.Desc.Size()))
	n2, err := m.Desc.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	dAtA[i] = 0x12
	i++
	i = encodeVarintStatus(dAtA, i, uint64(m.BuildInfo.Size()))
	n3, err := m.BuildInfo.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	if m.StartedAt != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.StartedAt))
	}
	if m.UpdatedAt != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.UpdatedAt))
	}
	if len(m.Metrics) > 0 {
		keysForMetrics := make([]string, 0, len(m.Metrics))
		for k := range m.Metrics {
			keysForMetrics = append(keysForMetrics, string(k))
		}
		sortkeys.Strings(keysForMetrics)
		for _, k := range keysForMetrics {
			dAtA[i] = 0x2a
			i++
			v := m.Metrics[string(k)]
			mapSize := 1 + len(k) + sovStatus(uint64(len(k))) + 1 + 8
			i = encodeVarintStatus(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintStatus(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x11
			i++
			binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(v))))
			i += 8
		}
	}
	if len(m.StoreStatuses) > 0 {
		for _, msg := range m.StoreStatuses {
			dAtA[i] = 0x32
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Args) > 0 {
		for _, s := range m.Args {
			dAtA[i] = 0x3a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Env) > 0 {
		for _, s := range m.Env {
			dAtA[i] = 0x42
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Latencies) > 0 {
		keysForLatencies := make([]int32, 0, len(m.Latencies))
		for k := range m.Latencies {
			keysForLatencies = append(keysForLatencies, int32(k))
		}
		sortkeys.Int32s(keysForLatencies)
		for _, k := range keysForLatencies {
			dAtA[i] = 0x4a
			i++
			v := m.Latencies[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(k)]
			mapSize := 1 + sovStatus(uint64(k)) + 1 + sovStatus(uint64(v))
			i = encodeVarintStatus(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintStatus(dAtA, i, uint64(k))
			dAtA[i] = 0x10
			i++
			i = encodeVarintStatus(dAtA, i, uint64(v))
		}
	}
	if len(m.Activity) > 0 {
		keysForActivity := make([]int32, 0, len(m.Activity))
		for k := range m.Activity {
			keysForActivity = append(keysForActivity, int32(k))
		}
		sortkeys.Int32s(keysForActivity)
		for _, k := range keysForActivity {
			dAtA[i] = 0x52
			i++
			v := m.Activity[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(k)]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovStatus(uint64(msgSize))
			}
			mapSize := 1 + sovStatus(uint64(k)) + msgSize
			i = encodeVarintStatus(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintStatus(dAtA, i, uint64(k))
			dAtA[i] = 0x12
			i++
			i = encodeVarintStatus(dAtA, i, uint64((&v).Size()))
			n4, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n4
		}
	}
	if m.TotalSystemMemory != 0 {
		dAtA[i] = 0x58
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.TotalSystemMemory))
	}
	if m.NumCpus != 0 {
		dAtA[i] = 0x60
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.NumCpus))
	}
	return i, nil
}

func (m *NodeStatus_NetworkActivity) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeStatus_NetworkActivity) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Incoming != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.Incoming))
	}
	if m.Outgoing != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.Outgoing))
	}
	if m.Latency != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.Latency))
	}
	return i, nil
}

func (m *HealthAlert) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HealthAlert) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.StoreID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.StoreID))
	}
	if m.Category != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.Category))
	}
	if len(m.Description) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.Description)))
		i += copy(dAtA[i:], m.Description)
	}
	if m.Value != 0 {
		dAtA[i] = 0x21
		i++
		binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Value))))
		i += 8
	}
	return i, nil
}

func (m *HealthCheckResult) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HealthCheckResult) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Alerts) > 0 {
		for _, msg := range m.Alerts {
			dAtA[i] = 0xa
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func encodeVarintStatus(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *StoreStatus) Size() (n int) {
	var l int
	_ = l
	l = m.Desc.Size()
	n += 1 + l + sovStatus(uint64(l))
	if len(m.Metrics) > 0 {
		for k, v := range m.Metrics {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovStatus(uint64(len(k))) + 1 + 8
			n += mapEntrySize + 1 + sovStatus(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *NodeStatus) Size() (n int) {
	var l int
	_ = l
	l = m.Desc.Size()
	n += 1 + l + sovStatus(uint64(l))
	l = m.BuildInfo.Size()
	n += 1 + l + sovStatus(uint64(l))
	if m.StartedAt != 0 {
		n += 1 + sovStatus(uint64(m.StartedAt))
	}
	if m.UpdatedAt != 0 {
		n += 1 + sovStatus(uint64(m.UpdatedAt))
	}
	if len(m.Metrics) > 0 {
		for k, v := range m.Metrics {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovStatus(uint64(len(k))) + 1 + 8
			n += mapEntrySize + 1 + sovStatus(uint64(mapEntrySize))
		}
	}
	if len(m.StoreStatuses) > 0 {
		for _, e := range m.StoreStatuses {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	if len(m.Args) > 0 {
		for _, s := range m.Args {
			l = len(s)
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	if len(m.Env) > 0 {
		for _, s := range m.Env {
			l = len(s)
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	if len(m.Latencies) > 0 {
		for k, v := range m.Latencies {
			_ = k
			_ = v
			mapEntrySize := 1 + sovStatus(uint64(k)) + 1 + sovStatus(uint64(v))
			n += mapEntrySize + 1 + sovStatus(uint64(mapEntrySize))
		}
	}
	if len(m.Activity) > 0 {
		for k, v := range m.Activity {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + sovStatus(uint64(k)) + 1 + l + sovStatus(uint64(l))
			n += mapEntrySize + 1 + sovStatus(uint64(mapEntrySize))
		}
	}
	if m.TotalSystemMemory != 0 {
		n += 1 + sovStatus(uint64(m.TotalSystemMemory))
	}
	if m.NumCpus != 0 {
		n += 1 + sovStatus(uint64(m.NumCpus))
	}
	return n
}

func (m *NodeStatus_NetworkActivity) Size() (n int) {
	var l int
	_ = l
	if m.Incoming != 0 {
		n += 1 + sovStatus(uint64(m.Incoming))
	}
	if m.Outgoing != 0 {
		n += 1 + sovStatus(uint64(m.Outgoing))
	}
	if m.Latency != 0 {
		n += 1 + sovStatus(uint64(m.Latency))
	}
	return n
}

func (m *HealthAlert) Size() (n int) {
	var l int
	_ = l
	if m.StoreID != 0 {
		n += 1 + sovStatus(uint64(m.StoreID))
	}
	if m.Category != 0 {
		n += 1 + sovStatus(uint64(m.Category))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	if m.Value != 0 {
		n += 9
	}
	return n
}

func (m *HealthCheckResult) Size() (n int) {
	var l int
	_ = l
	if len(m.Alerts) > 0 {
		for _, e := range m.Alerts {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	return n
}

func sovStatus(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozStatus(x uint64) (n int) {
	return sovStatus(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *StoreStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StoreStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StoreStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Desc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Desc.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metrics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metrics == nil {
				m.Metrics = make(map[string]float64)
			}
			var mapkey string
			var mapvalue float64
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStatus
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthStatus
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapvaluetemp uint64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					mapvaluetemp = uint64(binary.LittleEndian.Uint64(dAtA[iNdEx:]))
					iNdEx += 8
					mapvalue = math.Float64frombits(mapvaluetemp)
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipStatus(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthStatus
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Metrics[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodeStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Desc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Desc.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BuildInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.BuildInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedAt", wireType)
			}
			m.StartedAt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartedAt |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdatedAt", wireType)
			}
			m.UpdatedAt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.UpdatedAt |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metrics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metrics == nil {
				m.Metrics = make(map[string]float64)
			}
			var mapkey string
			var mapvalue float64
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStatus
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthStatus
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapvaluetemp uint64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					mapvaluetemp = uint64(binary.LittleEndian.Uint64(dAtA[iNdEx:]))
					iNdEx += 8
					mapvalue = math.Float64frombits(mapvaluetemp)
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipStatus(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthStatus
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Metrics[mapkey] = mapvalue
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreStatuses", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StoreStatuses = append(m.StoreStatuses, StoreStatus{})
			if err := m.StoreStatuses[len(m.StoreStatuses)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Args", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Args = append(m.Args, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Env", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Env = append(m.Env, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Latencies", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Latencies == nil {
				m.Latencies = make(map[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID]int64)
			}
			var mapkey int32
			var mapvalue int64
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStatus
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStatus
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= (int64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipStatus(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthStatus
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Latencies[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(mapkey)] = mapvalue
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Activity", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Activity == nil {
				m.Activity = make(map[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID]NodeStatus_NetworkActivity)
			}
			var mapkey int32
			mapvalue := &NodeStatus_NetworkActivity{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStatus
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStatus
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthStatus
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthStatus
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &NodeStatus_NetworkActivity{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipStatus(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthStatus
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Activity[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(mapkey)] = *mapvalue
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalSystemMemory", wireType)
			}
			m.TotalSystemMemory = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalSystemMemory |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumCpus", wireType)
			}
			m.NumCpus = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumCpus |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodeStatus_NetworkActivity) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkActivity: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkActivity: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Incoming", wireType)
			}
			m.Incoming = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Incoming |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Outgoing", wireType)
			}
			m.Outgoing = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Outgoing |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Latency", wireType)
			}
			m.Latency = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Latency |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HealthAlert) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HealthAlert: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HealthAlert: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreID", wireType)
			}
			m.StoreID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StoreID |= (github_com_cockroachdb_cockroach_pkg_roachpb.StoreID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Category", wireType)
			}
			m.Category = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Category |= (HealthAlert_Category(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Value = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HealthCheckResult) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HealthCheckResult: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HealthCheckResult: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Alerts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Alerts = append(m.Alerts, HealthAlert{})
			if err := m.Alerts[len(m.Alerts)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipStatus(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthStatus
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipStatus(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthStatus = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowStatus   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("server/status/status.proto", fileDescriptorStatus) }

var fileDescriptorStatus = []byte{
	// 800 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x55, 0xbf, 0x8f, 0xe3, 0x44,
	0x14, 0xce, 0xe4, 0xa7, 0xf3, 0x7c, 0xb7, 0xe4, 0x86, 0x03, 0x4c, 0x24, 0x12, 0x13, 0x5d, 0x91,
	0x06, 0x07, 0xb2, 0x14, 0x68, 0xef, 0x9a, 0x24, 0xbb, 0x82, 0x70, 0xec, 0x22, 0x9c, 0x93, 0x4e,
	0xa2, 0x89, 0x26, 0xf6, 0xac, 0x63, 0x25, 0xf6, 0x58, 0x9e, 0x71, 0x50, 0x5a, 0x4a, 0x24, 0x24,
	0x6a, 0xfe, 0x1b, 0xba, 0x2d, 0x29, 0x28, 0x10, 0xc5, 0x02, 0xe1, 0x1f, 0x41, 0x33, 0x76, 0x12,
	0x2f, 0x4a, 0xb4, 0x8b, 0xa0, 0xca, 0x9b, 0xf7, 0xf9, 0x7b, 0xef, 0x7b, 0x3f, 0x66, 0x02, 0x4d,
	0x4e, 0xe3, 0x15, 0x8d, 0x7b, 0x5c, 0x10, 0x91, 0xf0, 0xec, 0xc7, 0x8a, 0x62, 0x26, 0x18, 0x7e,
	0xc7, 0x61, 0xce, 0x22, 0x66, 0xc4, 0x99, 0x5b, 0xe9, 0x57, 0x56, 0x0a, 0x37, 0xdf, 0x56, 0xce,
	0x68, 0xd6, 0x0b, 0xa8, 0x20, 0x2e, 0x11, 0x24, 0x25, 0x34, 0x1b, 0xb3, 0xc4, 0x5f, 0xba, 0x3d,
	0x3f, 0xbc, 0x66, 0x99, 0xe7, 0xa9, 0xc7, 0x3c, 0xa6, 0xcc, 0x9e, 0xb4, 0x52, 0x6f, 0xe7, 0x17,
	0x04, 0xfa, 0x44, 0xb0, 0x98, 0x4e, 0x54, 0x3c, 0xfc, 0x02, 0xca, 0x2e, 0xe5, 0x8e, 0x81, 0x4c,
	0xd4, 0xd5, 0xfb, 0x1d, 0x6b, 0x9f, 0x37, 0x4b, 0x64, 0xa9, 0xaf, 0xcf, 0x29, 0x77, 0x62, 0x3f,
	0x12, 0x2c, 0x1e, 0x96, 0x6f, 0x6e, 0xdb, 0x05, 0x5b, 0xb1, 0xf0, 0x4b, 0xa8, 0x05, 0x54, 0xc4,
	0xbe, 0xc3, 0x8d, 0xa2, 0x59, 0xea, 0xea, 0xfd, 0x8f, 0xac, 0x23, 0xc2, 0xad, 0x5c, 0x52, 0xeb,
	0x32, 0xe5, 0x5c, 0x84, 0x22, 0x5e, 0xdb, 0xdb, 0x08, 0xcd, 0x33, 0x78, 0x94, 0x07, 0x70, 0x03,
	0x4a, 0x0b, 0xba, 0x56, 0xca, 0xea, 0xb6, 0x34, 0xf1, 0x53, 0xa8, 0xac, 0xc8, 0x32, 0xa1, 0x46,
	0xd1, 0x44, 0x5d, 0x64, 0xa7, 0x87, 0xb3, 0xe2, 0x27, 0xa8, 0xf3, 0x93, 0x06, 0x70, 0xc5, 0xdc,
	0x6d, 0x55, 0xcf, 0xef, 0x54, 0xf5, 0xfe, 0x81, 0xaa, 0xe4, 0xc7, 0x47, 0x8a, 0x3a, 0x03, 0x50,
	0xcd, 0x9c, 0xca, 0x66, 0xaa, 0x54, 0x7a, 0xff, 0xad, 0x5c, 0x08, 0x05, 0x5a, 0xe3, 0xf0, 0x9a,
	0x65, 0xb4, 0xba, 0xf2, 0x48, 0x07, 0x7e, 0x0f, 0x80, 0x0b, 0x12, 0x0b, 0xea, 0x4e, 0x89, 0x30,
	0x4a, 0x26, 0xea, 0x96, 0xec, 0x7a, 0xe6, 0x19, 0x08, 0x09, 0x27, 0x91, 0x4b, 0x32, 0xb8, 0x9c,
	0xc2, 0x99, 0x67, 0x20, 0xf0, 0xe7, 0xfb, 0x76, 0x56, 0x54, 0x3b, 0x3f, 0x3c, 0xda, 0xce, 0x7d,
	0xb1, 0x87, 0xbb, 0x89, 0xbf, 0x82, 0x13, 0x2e, 0x5b, 0x3e, 0x4d, 0x09, 0x94, 0x1b, 0x55, 0x15,
	0xf2, 0xd9, 0x43, 0x26, 0x94, 0x15, 0xf6, 0x98, 0xef, 0x5d, 0x94, 0x63, 0x0c, 0x65, 0x12, 0x7b,
	0xdc, 0xa8, 0x99, 0xa5, 0x6e, 0xdd, 0x56, 0xb6, 0x1c, 0x12, 0x0d, 0x57, 0x86, 0xa6, 0x5c, 0xd2,
	0xc4, 0xdf, 0x23, 0xa8, 0x2f, 0x89, 0xa0, 0xa1, 0xe3, 0x53, 0x6e, 0xd4, 0x55, 0xd2, 0xfe, 0x43,
	0xea, 0xf8, 0x62, 0x4b, 0x52, 0x95, 0x0c, 0x9f, 0x4b, 0x09, 0xdf, 0xfe, 0xde, 0x3e, 0xf5, 0x7c,
	0x31, 0x4f, 0x66, 0x96, 0xc3, 0x82, 0xde, 0x2e, 0x8a, 0x3b, 0xdb, 0xdb, 0xbd, 0x68, 0xe1, 0xf5,
	0xf2, 0x73, 0x1d, 0x9f, 0xdb, 0x7b, 0x05, 0xf8, 0x3b, 0x04, 0x1a, 0x71, 0x84, 0xbf, 0xf2, 0xc5,
	0xda, 0x80, 0x7b, 0xb6, 0x34, 0x27, 0x67, 0x90, 0x71, 0xfe, 0x07, 0x35, 0xbb, 0xfc, 0xd8, 0x82,
	0x37, 0x05, 0x13, 0x64, 0x39, 0xe5, 0x6b, 0x2e, 0x68, 0x30, 0x0d, 0x68, 0xc0, 0xe2, 0xb5, 0xa1,
	0xab, 0x4d, 0x78, 0xa2, 0xa0, 0x89, 0x42, 0x2e, 0x15, 0x80, 0xdf, 0x05, 0x2d, 0x4c, 0x82, 0xa9,
	0x13, 0x25, 0xdc, 0x78, 0x64, 0xa2, 0x6e, 0xc5, 0xae, 0x85, 0x49, 0x30, 0x8a, 0x92, 0xff, 0x74,
	0x5d, 0x9a, 0x2f, 0xe0, 0xe4, 0x6e, 0xb7, 0xf3, 0xec, 0xca, 0x01, 0x76, 0x29, 0xcf, 0x76, 0xe0,
	0x8d, 0x2b, 0x2a, 0xbe, 0x61, 0xf1, 0x62, 0xdb, 0x23, 0xdc, 0x04, 0xcd, 0x0f, 0x1d, 0x16, 0xf8,
	0xa1, 0xa7, 0x62, 0x94, 0xec, 0xdd, 0x59, 0x62, 0x2c, 0x11, 0x1e, 0x93, 0x58, 0x1a, 0x6b, 0x77,
	0xc6, 0x06, 0xd4, 0xd2, 0x49, 0xad, 0xb3, 0xcb, 0xb2, 0x3d, 0x36, 0x23, 0x78, 0x7c, 0x67, 0x02,
	0x07, 0x14, 0x8e, 0xf3, 0x0a, 0xf5, 0xfe, 0xe9, 0x43, 0xa6, 0xfa, 0x0f, 0xe1, 0xf9, 0x37, 0xe4,
	0xc7, 0x22, 0xe8, 0x9f, 0x51, 0xb2, 0x14, 0xf3, 0xc1, 0x92, 0xc6, 0x02, 0xcf, 0x40, 0x4b, 0x6f,
	0x90, 0xef, 0xa6, 0x59, 0x87, 0x9f, 0xca, 0x25, 0xf8, 0xed, 0xb6, 0xfd, 0xf1, 0xbf, 0x5a, 0x02,
	0x75, 0xaf, 0xc6, 0xe7, 0x9b, 0xdb, 0x76, 0x2d, 0x33, 0xed, 0x9a, 0x0a, 0x3c, 0x76, 0xf1, 0x18,
	0x34, 0x87, 0x08, 0xea, 0xc9, 0x25, 0x90, 0x55, 0x9c, 0xf4, 0x3f, 0x38, 0x5a, 0x45, 0x4e, 0x9b,
	0x35, 0xca, 0x48, 0xf6, 0x8e, 0x8e, 0x4d, 0xd0, 0xdd, 0xec, 0x41, 0xf3, 0x59, 0xa8, 0xda, 0x59,
	0xb7, 0xf3, 0xae, 0xfd, 0x44, 0xcb, 0xb9, 0x7d, 0xe8, 0x3c, 0x03, 0x6d, 0x1b, 0x0d, 0xeb, 0x50,
	0xbb, 0xbc, 0x78, 0x65, 0x8f, 0x47, 0x93, 0x46, 0x41, 0x1e, 0xae, 0x2e, 0x5e, 0xbd, 0xfe, 0xd2,
	0x7e, 0xd9, 0x40, 0x9d, 0xd7, 0xf0, 0x24, 0xcd, 0x3f, 0x9a, 0x53, 0x67, 0x61, 0x53, 0x9e, 0x2c,
	0x05, 0x1e, 0x42, 0x95, 0x48, 0x39, 0xdc, 0x40, 0xf7, 0xbc, 0x2d, 0x39, 0xed, 0xd9, 0xdb, 0x92,
	0x31, 0x87, 0xe6, 0xcd, 0x9f, 0xad, 0xc2, 0xcd, 0xa6, 0x85, 0x7e, 0xde, 0xb4, 0xd0, 0xaf, 0x9b,
	0x16, 0xfa, 0x63, 0xd3, 0x42, 0x3f, 0xfc, 0xd5, 0x2a, 0x7c, 0x5d, 0x4d, 0xb9, 0xb3, 0xaa, 0xfa,
	0xe7, 0x3a, 0xfd, 0x3b, 0x00, 0x00, 0xff, 0xff, 0xaa, 0xf8, 0x3a, 0xc1, 0x30, 0x07, 0x00, 0x00,
}
