// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: storage/storagebase/state.proto

package storagebase

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import cockroach_storage_engine_enginepb1 "github.com/cockroachdb/cockroach/pkg/storage/engine/enginepb"
import cockroach_roachpb2 "github.com/cockroachdb/cockroach/pkg/roachpb"
import cockroach_roachpb "github.com/cockroachdb/cockroach/pkg/roachpb"
import cockroach_roachpb1 "github.com/cockroachdb/cockroach/pkg/roachpb"
import cockroach_util_hlc "github.com/cockroachdb/cockroach/pkg/util/hlc"

import sortkeys "github.com/gogo/protobuf/sortkeys"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// ReplicaState is the part of the Range Raft state machine which is cached in
// memory and which is manipulated exclusively through consensus.
//
// The struct is also used to transfer state to Replicas in the context of
// proposer-evaluated Raft, in which case it does not represent a complete
// state but instead an update to be applied to an existing state, with each
// field specified in the update overwriting its counterpart on the receiving
// ReplicaState.
//
// For the ReplicaState persisted on the Replica, all optional fields are
// populated (i.e. no nil pointers or enums with the default value).
type ReplicaState struct {
	// The highest (and last) index applied to the state machine.
	RaftAppliedIndex uint64 `protobuf:"varint,1,opt,name=raft_applied_index,json=raftAppliedIndex,proto3" json:"raft_applied_index,omitempty"`
	// The highest (and last) lease index applied to the state machine.
	LeaseAppliedIndex uint64 `protobuf:"varint,2,opt,name=lease_applied_index,json=leaseAppliedIndex,proto3" json:"lease_applied_index,omitempty"`
	// The Range descriptor.
	// The pointer may change, but the referenced RangeDescriptor struct itself
	// must be treated as immutable; it is leaked out of the lock.
	//
	// Changes of the descriptor should always go through one of the
	// (*Replica).setDesc* methods.
	Desc *cockroach_roachpb.RangeDescriptor `protobuf:"bytes,3,opt,name=desc" json:"desc,omitempty"`
	// The latest range lease.
	//
	// Note that this message is both sent over the network and used to model
	// replica state in memory. In memory (storage.Replica.mu.state), the lease
	// is never nil (and never zero-valued), but it may be nil when sent over
	// the network as part of ReplicatedEvalResult.
	Lease *cockroach_roachpb1.Lease `protobuf:"bytes,4,opt,name=lease" json:"lease,omitempty"`
	// The truncation state of the Raft log.
	TruncatedState *cockroach_roachpb2.RaftTruncatedState `protobuf:"bytes,5,opt,name=truncated_state,json=truncatedState" json:"truncated_state,omitempty"`
	// gcThreshold is the GC threshold of the Range, typically updated when keys
	// are garbage collected. Reads and writes at timestamps <= this time will
	// not be served.
	GCThreshold *cockroach_util_hlc.Timestamp                 `protobuf:"bytes,6,opt,name=gc_threshold,json=gcThreshold" json:"gc_threshold,omitempty" cockroachdb:"randnullable"`
	Stats       *cockroach_storage_engine_enginepb1.MVCCStats `protobuf:"bytes,7,opt,name=stats" json:"stats,omitempty"`
	// txn_span_gc_threshold is the (maximum) timestamp below which transaction
	// records may have been garbage collected (as measured by txn.LastActive()).
	// Transaction at lower timestamps must not be allowed to write their initial
	// transaction entry.
	TxnSpanGCThreshold *cockroach_util_hlc.Timestamp `protobuf:"bytes,9,opt,name=txn_span_gc_threshold,json=txnSpanGcThreshold" json:"txn_span_gc_threshold,omitempty" cockroachdb:"randnullable"`
	// using_applied_state_key specifies whether the Range has been upgraded
	// to begin using the RangeAppliedState key. This key holds a combination
	// of the Raft applied index, the lease applied index, and the MVCC stats.
	//
	// When set to true in a ReplicatedEvalResult, the flag indicates that the
	// range should begin using the RangeAppliedState key. Handling of this flag
	// is idempotent by Replica state machines, meaning that it is ok for multiple
	// Raft commands to set it to true.
	UsingAppliedStateKey bool `protobuf:"varint,11,opt,name=using_applied_state_key,json=usingAppliedStateKey,proto3" json:"using_applied_state_key,omitempty"`
}

func (m *ReplicaState) Reset()                    { *m = ReplicaState{} }
func (m *ReplicaState) String() string            { return proto.CompactTextString(m) }
func (*ReplicaState) ProtoMessage()               {}
func (*ReplicaState) Descriptor() ([]byte, []int) { return fileDescriptorState, []int{0} }

// RangeInfo is used for reporting status information about a range out through
// the status server.
type RangeInfo struct {
	ReplicaState `protobuf:"bytes,1,opt,name=state,embedded=state" json:"state"`
	// The highest (and last) index in the Raft log.
	LastIndex  uint64 `protobuf:"varint,2,opt,name=last_index,json=lastIndex,proto3" json:"last_index,omitempty"`
	NumPending uint64 `protobuf:"varint,3,opt,name=num_pending,json=numPending,proto3" json:"num_pending,omitempty"`
	NumDropped uint64 `protobuf:"varint,5,opt,name=num_dropped,json=numDropped,proto3" json:"num_dropped,omitempty"`
	// raft_log_size may be initially inaccurate after a server restart.
	// See storage.Replica.mu.raftLogSize.
	RaftLogSize int64 `protobuf:"varint,6,opt,name=raft_log_size,json=raftLogSize,proto3" json:"raft_log_size,omitempty"`
	// Approximately the amount of quota available.
	ApproximateProposalQuota int64 `protobuf:"varint,7,opt,name=approximate_proposal_quota,json=approximateProposalQuota,proto3" json:"approximate_proposal_quota,omitempty"`
	// The max size the range can grow to before it will be split.
	RangeMaxBytes int64 `protobuf:"varint,8,opt,name=range_max_bytes,json=rangeMaxBytes,proto3" json:"range_max_bytes,omitempty"`
}

func (m *RangeInfo) Reset()                    { *m = RangeInfo{} }
func (m *RangeInfo) String() string            { return proto.CompactTextString(m) }
func (*RangeInfo) ProtoMessage()               {}
func (*RangeInfo) Descriptor() ([]byte, []int) { return fileDescriptorState, []int{1} }

// CommandQueueSnapshot is a snapshot of the command queue graph for rendering
// on an admin UI debug page. While the actual CommandQueue uses interval trees
// for fast mutation and lookups, all the UI needs is a simple map of commands.
type CommandQueuesSnapshot struct {
	// Timestamp in nanoseconds when this snapshot was taken.
	Timestamp cockroach_util_hlc.Timestamp `protobuf:"bytes,1,opt,name=timestamp" json:"timestamp"`
	// localScope and globalScope are maps from command ids to commands.
	LocalScope  map[int64]CommandQueuesSnapshot_Command `protobuf:"bytes,2,rep,name=localScope" json:"localScope" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
	GlobalScope map[int64]CommandQueuesSnapshot_Command `protobuf:"bytes,3,rep,name=globalScope" json:"globalScope" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *CommandQueuesSnapshot) Reset()                    { *m = CommandQueuesSnapshot{} }
func (m *CommandQueuesSnapshot) String() string            { return proto.CompactTextString(m) }
func (*CommandQueuesSnapshot) ProtoMessage()               {}
func (*CommandQueuesSnapshot) Descriptor() ([]byte, []int) { return fileDescriptorState, []int{2} }

type CommandQueuesSnapshot_Command struct {
	Id        int64                        `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Key       string                       `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	EndKey    string                       `protobuf:"bytes,3,opt,name=end_key,json=endKey,proto3" json:"end_key,omitempty"`
	Readonly  bool                         `protobuf:"varint,4,opt,name=readonly,proto3" json:"readonly,omitempty"`
	Timestamp cockroach_util_hlc.Timestamp `protobuf:"bytes,5,opt,name=timestamp" json:"timestamp"`
	Prereqs   []int64                      `protobuf:"varint,6,rep,packed,name=prereqs" json:"prereqs,omitempty"`
}

func (m *CommandQueuesSnapshot_Command) Reset()         { *m = CommandQueuesSnapshot_Command{} }
func (m *CommandQueuesSnapshot_Command) String() string { return proto.CompactTextString(m) }
func (*CommandQueuesSnapshot_Command) ProtoMessage()    {}
func (*CommandQueuesSnapshot_Command) Descriptor() ([]byte, []int) {
	return fileDescriptorState, []int{2, 0}
}

func init() {
	proto.RegisterType((*ReplicaState)(nil), "cockroach.storage.storagebase.ReplicaState")
	proto.RegisterType((*RangeInfo)(nil), "cockroach.storage.storagebase.RangeInfo")
	proto.RegisterType((*CommandQueuesSnapshot)(nil), "cockroach.storage.storagebase.CommandQueuesSnapshot")
	proto.RegisterType((*CommandQueuesSnapshot_Command)(nil), "cockroach.storage.storagebase.CommandQueuesSnapshot.Command")
}
func (this *ReplicaState) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReplicaState)
	if !ok {
		that2, ok := that.(ReplicaState)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.RaftAppliedIndex != that1.RaftAppliedIndex {
		return false
	}
	if this.LeaseAppliedIndex != that1.LeaseAppliedIndex {
		return false
	}
	if !this.Desc.Equal(that1.Desc) {
		return false
	}
	if !this.Lease.Equal(that1.Lease) {
		return false
	}
	if !this.TruncatedState.Equal(that1.TruncatedState) {
		return false
	}
	if !this.GCThreshold.Equal(that1.GCThreshold) {
		return false
	}
	if !this.Stats.Equal(that1.Stats) {
		return false
	}
	if !this.TxnSpanGCThreshold.Equal(that1.TxnSpanGCThreshold) {
		return false
	}
	if this.UsingAppliedStateKey != that1.UsingAppliedStateKey {
		return false
	}
	return true
}
func (this *RangeInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RangeInfo)
	if !ok {
		that2, ok := that.(RangeInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ReplicaState.Equal(&that1.ReplicaState) {
		return false
	}
	if this.LastIndex != that1.LastIndex {
		return false
	}
	if this.NumPending != that1.NumPending {
		return false
	}
	if this.NumDropped != that1.NumDropped {
		return false
	}
	if this.RaftLogSize != that1.RaftLogSize {
		return false
	}
	if this.ApproximateProposalQuota != that1.ApproximateProposalQuota {
		return false
	}
	if this.RangeMaxBytes != that1.RangeMaxBytes {
		return false
	}
	return true
}
func (m *ReplicaState) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicaState) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RaftAppliedIndex != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintState(dAtA, i, uint64(m.RaftAppliedIndex))
	}
	if m.LeaseAppliedIndex != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintState(dAtA, i, uint64(m.LeaseAppliedIndex))
	}
	if m.Desc != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintState(dAtA, i, uint64(m.Desc.Size()))
		n1, err := m.Desc.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.Lease != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintState(dAtA, i, uint64(m.Lease.Size()))
		n2, err := m.Lease.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.TruncatedState != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintState(dAtA, i, uint64(m.TruncatedState.Size()))
		n3, err := m.TruncatedState.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.GCThreshold != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintState(dAtA, i, uint64(m.GCThreshold.Size()))
		n4, err := m.GCThreshold.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.Stats != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintState(dAtA, i, uint64(m.Stats.Size()))
		n5, err := m.Stats.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.TxnSpanGCThreshold != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintState(dAtA, i, uint64(m.TxnSpanGCThreshold.Size()))
		n6, err := m.TxnSpanGCThreshold.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.UsingAppliedStateKey {
		dAtA[i] = 0x58
		i++
		if m.UsingAppliedStateKey {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *RangeInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintState(dAtA, i, uint64(m.ReplicaState.Size()))
	n7, err := m.ReplicaState.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n7
	if m.LastIndex != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintState(dAtA, i, uint64(m.LastIndex))
	}
	if m.NumPending != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintState(dAtA, i, uint64(m.NumPending))
	}
	if m.NumDropped != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintState(dAtA, i, uint64(m.NumDropped))
	}
	if m.RaftLogSize != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintState(dAtA, i, uint64(m.RaftLogSize))
	}
	if m.ApproximateProposalQuota != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintState(dAtA, i, uint64(m.ApproximateProposalQuota))
	}
	if m.RangeMaxBytes != 0 {
		dAtA[i] = 0x40
		i++
		i = encodeVarintState(dAtA, i, uint64(m.RangeMaxBytes))
	}
	return i, nil
}

func (m *CommandQueuesSnapshot) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandQueuesSnapshot) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintState(dAtA, i, uint64(m.Timestamp.Size()))
	n8, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n8
	if len(m.LocalScope) > 0 {
		keysForLocalScope := make([]int64, 0, len(m.LocalScope))
		for k := range m.LocalScope {
			keysForLocalScope = append(keysForLocalScope, int64(k))
		}
		sortkeys.Int64s(keysForLocalScope)
		for _, k := range keysForLocalScope {
			dAtA[i] = 0x12
			i++
			v := m.LocalScope[int64(k)]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovState(uint64(msgSize))
			}
			mapSize := 1 + sovState(uint64(k)) + msgSize
			i = encodeVarintState(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintState(dAtA, i, uint64(k))
			dAtA[i] = 0x12
			i++
			i = encodeVarintState(dAtA, i, uint64((&v).Size()))
			n9, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n9
		}
	}
	if len(m.GlobalScope) > 0 {
		keysForGlobalScope := make([]int64, 0, len(m.GlobalScope))
		for k := range m.GlobalScope {
			keysForGlobalScope = append(keysForGlobalScope, int64(k))
		}
		sortkeys.Int64s(keysForGlobalScope)
		for _, k := range keysForGlobalScope {
			dAtA[i] = 0x1a
			i++
			v := m.GlobalScope[int64(k)]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovState(uint64(msgSize))
			}
			mapSize := 1 + sovState(uint64(k)) + msgSize
			i = encodeVarintState(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintState(dAtA, i, uint64(k))
			dAtA[i] = 0x12
			i++
			i = encodeVarintState(dAtA, i, uint64((&v).Size()))
			n10, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n10
		}
	}
	return i, nil
}

func (m *CommandQueuesSnapshot_Command) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandQueuesSnapshot_Command) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintState(dAtA, i, uint64(m.Id))
	}
	if len(m.Key) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintState(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	if len(m.EndKey) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintState(dAtA, i, uint64(len(m.EndKey)))
		i += copy(dAtA[i:], m.EndKey)
	}
	if m.Readonly {
		dAtA[i] = 0x20
		i++
		if m.Readonly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	dAtA[i] = 0x2a
	i++
	i = encodeVarintState(dAtA, i, uint64(m.Timestamp.Size()))
	n11, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n11
	if len(m.Prereqs) > 0 {
		dAtA13 := make([]byte, len(m.Prereqs)*10)
		var j12 int
		for _, num1 := range m.Prereqs {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA13[j12] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j12++
			}
			dAtA13[j12] = uint8(num)
			j12++
		}
		dAtA[i] = 0x32
		i++
		i = encodeVarintState(dAtA, i, uint64(j12))
		i += copy(dAtA[i:], dAtA13[:j12])
	}
	return i, nil
}

func encodeVarintState(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *ReplicaState) Size() (n int) {
	var l int
	_ = l
	if m.RaftAppliedIndex != 0 {
		n += 1 + sovState(uint64(m.RaftAppliedIndex))
	}
	if m.LeaseAppliedIndex != 0 {
		n += 1 + sovState(uint64(m.LeaseAppliedIndex))
	}
	if m.Desc != nil {
		l = m.Desc.Size()
		n += 1 + l + sovState(uint64(l))
	}
	if m.Lease != nil {
		l = m.Lease.Size()
		n += 1 + l + sovState(uint64(l))
	}
	if m.TruncatedState != nil {
		l = m.TruncatedState.Size()
		n += 1 + l + sovState(uint64(l))
	}
	if m.GCThreshold != nil {
		l = m.GCThreshold.Size()
		n += 1 + l + sovState(uint64(l))
	}
	if m.Stats != nil {
		l = m.Stats.Size()
		n += 1 + l + sovState(uint64(l))
	}
	if m.TxnSpanGCThreshold != nil {
		l = m.TxnSpanGCThreshold.Size()
		n += 1 + l + sovState(uint64(l))
	}
	if m.UsingAppliedStateKey {
		n += 2
	}
	return n
}

func (m *RangeInfo) Size() (n int) {
	var l int
	_ = l
	l = m.ReplicaState.Size()
	n += 1 + l + sovState(uint64(l))
	if m.LastIndex != 0 {
		n += 1 + sovState(uint64(m.LastIndex))
	}
	if m.NumPending != 0 {
		n += 1 + sovState(uint64(m.NumPending))
	}
	if m.NumDropped != 0 {
		n += 1 + sovState(uint64(m.NumDropped))
	}
	if m.RaftLogSize != 0 {
		n += 1 + sovState(uint64(m.RaftLogSize))
	}
	if m.ApproximateProposalQuota != 0 {
		n += 1 + sovState(uint64(m.ApproximateProposalQuota))
	}
	if m.RangeMaxBytes != 0 {
		n += 1 + sovState(uint64(m.RangeMaxBytes))
	}
	return n
}

func (m *CommandQueuesSnapshot) Size() (n int) {
	var l int
	_ = l
	l = m.Timestamp.Size()
	n += 1 + l + sovState(uint64(l))
	if len(m.LocalScope) > 0 {
		for k, v := range m.LocalScope {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + sovState(uint64(k)) + 1 + l + sovState(uint64(l))
			n += mapEntrySize + 1 + sovState(uint64(mapEntrySize))
		}
	}
	if len(m.GlobalScope) > 0 {
		for k, v := range m.GlobalScope {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + sovState(uint64(k)) + 1 + l + sovState(uint64(l))
			n += mapEntrySize + 1 + sovState(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *CommandQueuesSnapshot_Command) Size() (n int) {
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovState(uint64(m.Id))
	}
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovState(uint64(l))
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovState(uint64(l))
	}
	if m.Readonly {
		n += 2
	}
	l = m.Timestamp.Size()
	n += 1 + l + sovState(uint64(l))
	if len(m.Prereqs) > 0 {
		l = 0
		for _, e := range m.Prereqs {
			l += sovState(uint64(e))
		}
		n += 1 + sovState(uint64(l)) + l
	}
	return n
}

func sovState(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozState(x uint64) (n int) {
	return sovState(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ReplicaState) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowState
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReplicaState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReplicaState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftAppliedIndex", wireType)
			}
			m.RaftAppliedIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RaftAppliedIndex |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeaseAppliedIndex", wireType)
			}
			m.LeaseAppliedIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LeaseAppliedIndex |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Desc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthState
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Desc == nil {
				m.Desc = &cockroach_roachpb.RangeDescriptor{}
			}
			if err := m.Desc.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthState
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Lease == nil {
				m.Lease = &cockroach_roachpb1.Lease{}
			}
			if err := m.Lease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TruncatedState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthState
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TruncatedState == nil {
				m.TruncatedState = &cockroach_roachpb2.RaftTruncatedState{}
			}
			if err := m.TruncatedState.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GCThreshold", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthState
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GCThreshold == nil {
				m.GCThreshold = &cockroach_util_hlc.Timestamp{}
			}
			if err := m.GCThreshold.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthState
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Stats == nil {
				m.Stats = &cockroach_storage_engine_enginepb1.MVCCStats{}
			}
			if err := m.Stats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnSpanGCThreshold", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthState
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TxnSpanGCThreshold == nil {
				m.TxnSpanGCThreshold = &cockroach_util_hlc.Timestamp{}
			}
			if err := m.TxnSpanGCThreshold.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UsingAppliedStateKey", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UsingAppliedStateKey = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipState(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthState
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowState
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicaState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthState
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ReplicaState.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastIndex", wireType)
			}
			m.LastIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastIndex |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumPending", wireType)
			}
			m.NumPending = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumPending |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumDropped", wireType)
			}
			m.NumDropped = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumDropped |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftLogSize", wireType)
			}
			m.RaftLogSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RaftLogSize |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApproximateProposalQuota", wireType)
			}
			m.ApproximateProposalQuota = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ApproximateProposalQuota |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeMaxBytes", wireType)
			}
			m.RangeMaxBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeMaxBytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipState(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthState
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandQueuesSnapshot) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowState
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandQueuesSnapshot: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandQueuesSnapshot: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthState
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalScope", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthState
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LocalScope == nil {
				m.LocalScope = make(map[int64]CommandQueuesSnapshot_Command)
			}
			var mapkey int64
			mapvalue := &CommandQueuesSnapshot_Command{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowState
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowState
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= (int64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowState
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthState
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthState
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &CommandQueuesSnapshot_Command{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipState(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthState
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.LocalScope[mapkey] = *mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GlobalScope", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthState
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GlobalScope == nil {
				m.GlobalScope = make(map[int64]CommandQueuesSnapshot_Command)
			}
			var mapkey int64
			mapvalue := &CommandQueuesSnapshot_Command{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowState
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowState
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= (int64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowState
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthState
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthState
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &CommandQueuesSnapshot_Command{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipState(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthState
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.GlobalScope[mapkey] = *mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipState(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthState
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandQueuesSnapshot_Command) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowState
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Command: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Command: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthState
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthState
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Readonly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Readonly = bool(v != 0)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowState
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthState
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType == 0 {
				var v int64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowState
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (int64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Prereqs = append(m.Prereqs, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowState
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthState
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowState
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (int64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Prereqs = append(m.Prereqs, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Prereqs", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipState(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthState
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipState(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowState
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowState
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowState
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthState
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowState
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipState(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthState = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowState   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("storage/storagebase/state.proto", fileDescriptorState) }

var fileDescriptorState = []byte{
	// 931 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x55, 0x3f, 0x6f, 0xdb, 0x46,
	0x1c, 0x35, 0x45, 0xca, 0x96, 0x8e, 0x49, 0xac, 0x5e, 0x93, 0x86, 0x50, 0x61, 0x49, 0x10, 0x90,
	0x42, 0x40, 0x53, 0x0a, 0x70, 0xff, 0xa0, 0x30, 0xb2, 0x44, 0x76, 0x10, 0xc4, 0x76, 0x8a, 0xe4,
	0x64, 0x74, 0xe8, 0x42, 0x9c, 0xc8, 0x33, 0xc5, 0xe6, 0x78, 0x77, 0x21, 0x8f, 0x81, 0x94, 0x76,
	0xee, 0xdc, 0x8f, 0xd0, 0xbd, 0x9f, 0xa1, 0xbb, 0xc7, 0x2c, 0x05, 0x3a, 0x09, 0xad, 0xba, 0x74,
	0x2c, 0xfa, 0x09, 0x8a, 0x3b, 0x92, 0x32, 0xe5, 0x1a, 0x8d, 0xe1, 0x21, 0x93, 0x8e, 0xef, 0xf7,
	0x7e, 0xff, 0xde, 0x3d, 0x52, 0xa0, 0x9b, 0x4a, 0x9e, 0xe0, 0x90, 0x0c, 0x8b, 0xdf, 0x09, 0x4e,
	0xd5, 0x19, 0x4b, 0xe2, 0x8a, 0x84, 0x4b, 0x0e, 0x77, 0x7c, 0xee, 0xbf, 0x48, 0x38, 0xf6, 0xa7,
	0x6e, 0x41, 0x71, 0x2b, 0xd4, 0x76, 0xbf, 0xcc, 0x27, 0x2c, 0x8c, 0x58, 0xf9, 0x23, 0x26, 0xc3,
	0xf8, 0x95, 0xef, 0xe7, 0x25, 0xda, 0x1f, 0xea, 0x74, 0x31, 0x19, 0x46, 0x4c, 0x92, 0x84, 0x61,
	0xea, 0x25, 0xf8, 0x54, 0x16, 0xc1, 0x0f, 0xca, 0x60, 0x4c, 0x24, 0x0e, 0xb0, 0xc4, 0x05, 0x0e,
	0x4b, 0xbc, 0x82, 0x39, 0x99, 0x8c, 0xe8, 0x70, 0x4a, 0xfd, 0xa1, 0x8c, 0x62, 0x92, 0x4a, 0x1c,
	0x8b, 0x22, 0x72, 0x3b, 0xe4, 0x21, 0xd7, 0xc7, 0xa1, 0x3a, 0xe5, 0x68, 0xff, 0xe7, 0x3a, 0xb8,
	0x81, 0x88, 0xa0, 0x91, 0x8f, 0xc7, 0x6a, 0x25, 0x78, 0x1f, 0x40, 0xd5, 0xda, 0xc3, 0x42, 0xd0,
	0x88, 0x04, 0x5e, 0xc4, 0x02, 0x32, 0x73, 0x8c, 0x9e, 0x31, 0xb0, 0x50, 0x4b, 0x45, 0x1e, 0xe6,
	0x81, 0x27, 0x0a, 0x87, 0x2e, 0x78, 0x9f, 0x12, 0x9c, 0x92, 0x0b, 0xf4, 0x9a, 0xa6, 0xbf, 0xa7,
	0x43, 0x6b, 0xfc, 0x2f, 0x80, 0x15, 0x90, 0xd4, 0x77, 0xcc, 0x9e, 0x31, 0xb0, 0x77, 0xfb, 0xee,
	0xb9, 0x72, 0xc5, 0x2e, 0x2e, 0xc2, 0x2c, 0x24, 0x07, 0x24, 0xf5, 0x93, 0x48, 0x48, 0x9e, 0x20,
	0xcd, 0x87, 0x2e, 0xa8, 0xeb, 0x62, 0x8e, 0xa5, 0x13, 0x9d, 0x4b, 0x12, 0x8f, 0x55, 0x1c, 0xe5,
	0x34, 0xf8, 0x15, 0xd8, 0x96, 0x49, 0xc6, 0x7c, 0x2c, 0x49, 0xe0, 0xe9, 0xbb, 0x72, 0xea, 0x3a,
	0xf3, 0xde, 0xa5, 0x2d, 0x4f, 0xe5, 0x49, 0xc9, 0xd6, 0x2a, 0xa0, 0x5b, 0x72, 0xed, 0x19, 0x72,
	0x70, 0x23, 0xf4, 0x3d, 0x39, 0x4d, 0x48, 0x3a, 0xe5, 0x34, 0x70, 0x36, 0x75, 0xb1, 0x9d, 0x4a,
	0x31, 0xa5, 0xbb, 0x3b, 0xa5, 0xbe, 0x7b, 0x52, 0xea, 0x3e, 0xfa, 0x64, 0xb9, 0xe8, 0xda, 0x8f,
	0xf7, 0x4f, 0xca, 0xac, 0x7f, 0x16, 0xdd, 0xf6, 0x2a, 0x21, 0x98, 0xec, 0xf5, 0x13, 0xcc, 0x02,
	0x96, 0x51, 0x8a, 0x27, 0x94, 0xf4, 0x91, 0x1d, 0xfa, 0x2b, 0x2a, 0x1c, 0x81, 0xba, 0x1a, 0x3b,
	0x75, 0xb6, 0x74, 0xa7, 0xfb, 0xee, 0x7f, 0x3d, 0x96, 0xfb, 0xc8, 0x2d, 0xed, 0xe4, 0x3e, 0xfd,
	0x7a, 0x7f, 0x5f, 0x4d, 0x9b, 0xa2, 0x3c, 0x15, 0xfe, 0x60, 0x80, 0x3b, 0x72, 0xc6, 0xbc, 0x54,
	0x60, 0xe6, 0xad, 0x8d, 0xdf, 0xbc, 0xca, 0xf8, 0x9f, 0x2d, 0x17, 0x5d, 0x78, 0x32, 0x63, 0x63,
	0x81, 0xd9, 0xd5, 0xb7, 0x80, 0xb2, 0xc8, 0xa8, 0x2c, 0xf3, 0x39, 0xb8, 0x9b, 0xa5, 0x11, 0x0b,
	0x57, 0x2e, 0xd1, 0x37, 0xe2, 0xbd, 0x20, 0x73, 0xc7, 0xee, 0x19, 0x83, 0x06, 0xba, 0xad, 0xc3,
	0x85, 0x53, 0xb4, 0xe2, 0x47, 0x64, 0xbe, 0x67, 0xfd, 0xf5, 0x53, 0xd7, 0x38, 0xb4, 0x1a, 0x8d,
	0x56, 0xf3, 0xd0, 0x6a, 0x80, 0x96, 0xdd, 0xff, 0xb5, 0x06, 0x9a, 0xda, 0x20, 0x4f, 0xd8, 0x29,
	0x87, 0x47, 0xb9, 0x46, 0x44, 0xbb, 0xd3, 0xde, 0xfd, 0xd8, 0xfd, 0xdf, 0xf7, 0xd0, 0xad, 0xda,
	0x7c, 0xd4, 0x38, 0x5b, 0x74, 0x37, 0xde, 0x2c, 0xba, 0x46, 0x2e, 0x16, 0x81, 0x3b, 0x00, 0x50,
	0x9c, 0xca, 0x35, 0x03, 0x37, 0x15, 0x92, 0x1b, 0xb7, 0x0b, 0x6c, 0x96, 0xc5, 0x9e, 0x20, 0x2c,
	0x88, 0x58, 0xa8, 0xfd, 0x6b, 0x21, 0xc0, 0xb2, 0xf8, 0x59, 0x8e, 0x94, 0x84, 0x20, 0xe1, 0x42,
	0x90, 0x40, 0xbb, 0x2d, 0x27, 0x1c, 0xe4, 0x08, 0xec, 0x83, 0x9b, 0xfa, 0xc5, 0xa2, 0x3c, 0xf4,
	0xd2, 0xe8, 0x35, 0xd1, 0x1e, 0x32, 0x91, 0xad, 0xc0, 0x63, 0x1e, 0x8e, 0xa3, 0xd7, 0x04, 0x3e,
	0x00, 0x6d, 0x2c, 0x44, 0xc2, 0x67, 0x51, 0xac, 0x04, 0x12, 0x09, 0x17, 0x3c, 0xc5, 0xd4, 0x7b,
	0x99, 0x71, 0x89, 0xb5, 0x15, 0x4c, 0xe4, 0x54, 0x18, 0xcf, 0x0a, 0xc2, 0x73, 0x15, 0x87, 0x1f,
	0x81, 0xed, 0x44, 0x89, 0xe3, 0xc5, 0x78, 0xe6, 0x4d, 0xe6, 0x92, 0xa4, 0x4e, 0x43, 0xa7, 0xdc,
	0xd4, 0xf0, 0x53, 0x3c, 0x1b, 0x29, 0x70, 0xa5, 0xab, 0xd5, 0xaa, 0x1f, 0x5a, 0x8d, 0x66, 0x0b,
	0xf4, 0xff, 0xae, 0x83, 0x3b, 0xfb, 0x3c, 0x8e, 0x31, 0x0b, 0x9e, 0x67, 0x24, 0x23, 0xe9, 0x98,
	0x61, 0x91, 0x4e, 0xb9, 0x84, 0x0f, 0x41, 0x73, 0xf5, 0x21, 0x29, 0x74, 0x7e, 0x8b, 0x6d, 0x2c,
	0xa5, 0x2c, 0x3a, 0xcf, 0x82, 0xdf, 0x02, 0x40, 0xb9, 0x8f, 0xe9, 0xd8, 0xe7, 0x82, 0x38, 0xb5,
	0x9e, 0x39, 0xb0, 0x77, 0x0f, 0xde, 0x72, 0x57, 0x97, 0x0e, 0xe3, 0x1e, 0xaf, 0xca, 0x3c, 0x62,
	0x32, 0x99, 0x17, 0xad, 0x2a, 0xd5, 0x61, 0x0c, 0xec, 0x90, 0xf2, 0x49, 0xd9, 0xcc, 0xd4, 0xcd,
	0x1e, 0x5d, 0xab, 0xd9, 0xe3, 0xf3, 0x3a, 0xd5, 0x6e, 0xd5, 0xfa, 0xed, 0x5f, 0x0c, 0xb0, 0x55,
	0x64, 0xc3, 0x5b, 0xa0, 0x16, 0x05, 0x5a, 0x22, 0x13, 0xd5, 0xa2, 0x00, 0xb6, 0x80, 0xa9, 0x0c,
	0xae, 0x9c, 0xd4, 0x44, 0xea, 0x08, 0xef, 0x82, 0x2d, 0xc2, 0x02, 0x6d, 0x7b, 0x53, 0xa3, 0x9b,
	0x84, 0x05, 0x47, 0x64, 0x0e, 0xdb, 0xa0, 0x91, 0x10, 0x1c, 0x70, 0x46, 0xe7, 0xfa, 0x03, 0xd7,
	0x40, 0xab, 0xe7, 0xf5, 0x0b, 0xa8, 0x5f, 0xeb, 0x02, 0x1c, 0xb0, 0x25, 0x12, 0x92, 0x90, 0x97,
	0xa9, 0xb3, 0xd9, 0x33, 0x07, 0x26, 0x2a, 0x1f, 0xdb, 0xdf, 0x81, 0xed, 0x0b, 0x9a, 0x96, 0x63,
	0xe7, 0x7b, 0xe8, 0xb1, 0x11, 0xa8, 0xbf, 0xc2, 0x34, 0x23, 0x7a, 0x15, 0x7b, 0xf7, 0xc1, 0xb5,
	0xd4, 0x2c, 0x50, 0x94, 0x97, 0xda, 0xab, 0x7d, 0x69, 0xb4, 0xbf, 0x07, 0xad, 0x8b, 0x1a, 0xbf,
	0xbb, 0xee, 0xa3, 0x7b, 0x67, 0x7f, 0x74, 0x36, 0xce, 0x96, 0x1d, 0xe3, 0xcd, 0xb2, 0x63, 0xfc,
	0xb6, 0xec, 0x18, 0xbf, 0x2f, 0x3b, 0xc6, 0x8f, 0x7f, 0x76, 0x36, 0xbe, 0xb1, 0x2b, 0xf5, 0x26,
	0x9b, 0xfa, 0x6f, 0xf2, 0xd3, 0x7f, 0x03, 0x00, 0x00, 0xff, 0xff, 0xb6, 0x43, 0xe5, 0xaf, 0x05,
	0x08, 0x00, 0x00,
}
