/*
 *   mwblapi.c -- Mwave Blacklist  Utility routines
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include <port_types.h>
#include <port_functions.h>

#include <stdio.h>
#include <malloc.h>
#include <memory.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#include <mwave.h> 

#include <blobject.h>    // The blacklist class object
#include <blwtt.h>       // The WTTsettings class object
#include <mwblapi.h>     // Public header file

//---- Global objects --------------------------------------------------------
//WTTsettings WTT;
BLobject    BL;

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//
//  BL_APIversion
//
//     This function returns the version number of API functions as defined
//     by BL_API_VERSION above.  This will force the library and users of the
//     library to be in sync and prevent build problems.  Users of the BlackList
//     library need to call this function and compare the result to
//     BL_API_VERSION.
//
//     Params:   none
//
//     Returns:  BL_API_VERSION defined above
//
//-----------------------------------------------------------------------------
ULONG APIENTRY BL_APIversion (void)
{
  MW_SYSLOG_1(TRACE_MWMBL,"mwmblapi::BL_APIversion entry+exit\n");
  return BL_API_VERSION;
}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//
//  BL_RegisterDevice
//
//     This function needs to be called first to register a device.  Each
//     device such as modem, fax, and voice needs to be registered.  The
//     handle returned is used to identify the memory structure used while
//     working with unsuccessful number status.  Also, some countries make
//     distictions in the call restrictions for certain devices.  In this
//     case there is typically a more severe restriction on fax machines
//     then on modems or voice calls.
//
//
//
//     Params:   ulDeviceType      - The device type defined above.
//
//               szDeviceName      - The name that the device is known by
//                                   in the system such as in the config.
//                                   This will be used by the blacklist viewer
//                                   in identifying status for a particular
//                                   device/line.
//
//               lpulDeviceHandle  - Pointer to where the ulDeviceHandle needs
//                                   to be returned.  This is the device
//                                   registration number.
//
//               ulReserved        - A reserved location for future API expansion.
//
//
//     Returns:  ULONG Successful:  0
//                     Error:       BLERR_.... from mwblapi.h
//
//-----------------------------------------------------------------------------
ULONG APIENTRY BL_RegisterDevice  (ULONG ulDeviceType,
                                   char FAR *lpszDeviceName,
                                   ULONG FAR *lpulDeviceHandle,
                                   ULONG ulReserved)
{
  ULONG ulRC=0;

  MW_SYSLOG_4(TRACE_MWMBL,"mwblapi::BL_RegisterDevice ulDeviceType %lx, lpszDeviceName %s, lpulDeviceHandle %p",ulDeviceType,lpszDeviceName,lpulDeviceHandle);

  return objRegisterDevice (&BL,ulDeviceType, lpszDeviceName, lpulDeviceHandle);
  MW_SYSLOG_2(TRACE_MWMBL,"mwblapi::BL_RegisterDevice exit ulRC %lx\n",ulRC);
  return ulRC;
} 


//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//
//  BL_Reset
//
//     This function resets the blacklist library and reloads the WT settings.
//
//
//     Params:   ulReserved - A reserved location for future API expansion.
//
//     Returns:  ULONG Successful:  0
//                     Error:       BLERR_.... from mwblapi.h
//
//-----------------------------------------------------------------------------
ULONG APIENTRY BL_Reset (ULONG ulReserved)
{
  ULONG ulRC=0;

  MW_SYSLOG_1(TRACE_MWMBL,"mwblapi::BL_Reset entry\n");

  return objReset(&BL);
  
  MW_SYSLOG_2(TRACE_MWMBL,"mwblapi::BL_Reset exit ulRC %lx\n",ulRC);
  return ulRC;
}


//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//
//  BL_ResetDevice
//
//     This function resets call restrictions for a device, it does not
//     reset the high level information about the device such as device
//     type and name.
//
//
//     Params:   ulDeviceHandle - The registered device handle.
//
//               ulReserved - A reserved location for future API expansion.
//
//     Returns:  ULONG Successful:  0
//                     Error:       BLERR_.... from mwblapi.h
//
//-----------------------------------------------------------------------------
ULONG APIENTRY BL_ResetDevice (ULONG ulDeviceHandle, ULONG ulReserved)
{
  ULONG ulRC=0;

  MW_SYSLOG_2(TRACE_MWMBL,"mwblapi::BL_ResetDevice entry ulDeviceHandle %lx\n",ulDeviceHandle);

  return objResetDevice(&BL,ulDeviceHandle);

  MW_SYSLOG_2(TRACE_MWMBL,"mwblapi::BL_ResetDevice exit ulRC %lx\n",ulRC);
  return ulRC;
} 


//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//
//  BL_RequestDialPermission
//
//     This function is used to request permission to dial.  Permission is
//     granted if BL_DIAL_GRANTED is returned.  In this case, a valid
//     ulDialHandle will be returned which needs to be used in reporting
//     BL_DialResults.
//
//     In the case of a manual dial, permission will always be granted.
//     This is used to obtain the ulDialHandle which can then be used
//     to clean calling restrictions for the number if the manual dial
//     succeeded.
//
//
//     Params:   ulDeviceHandle  - The registered device handle.
//               ulDialType      - The type of dial:  MANUAL_DIAL or AUTOMATIC_DIAL.
//               lpszPhoneNumber - A pointer to the phone number that dialing is requested for.
//               lpulDialStatus  - A pointer to return the status of the request:
//                                 BL_DIAL_GRANTED       - OK to dial
//                                 BL_NUMBER_BLACKLISTED - permission denied
//                                 BL_NUMBER_DELAYED     - permission denied for
//                                                         lpulDelayTime more seconds
//
//               lpulDialHandle  - A pointer to the returned dial handle.
//               lpulDelayTime   - A pointer to the returned delay time in seconds.
//               ulReserved      - A reserved location for future API expansion.
//
//
//     Returns:  ULONG Successful:  0
//                     Error:       BLERR_.... from mwblapi.h
//
//-----------------------------------------------------------------------------
ULONG APIENTRY BL_RequestDialPermission (ULONG ulDeviceHandle,
                                         ULONG ulDialType,
                                         char  FAR *lpszPhoneNumber,
                                         ULONG FAR *lpulDialStatus,
                                         ULONG FAR *lpulDialHandle,
                                         ULONG FAR *lpulDelayTime,
                                         ULONG ulReserved)
{
  ULONG ulRC=0;
  
  MW_SYSLOG_4(TRACE_MWMBL,"mwblapi::BL_RequestDialPermission, ulDeviceHandle %lx, ulDialType %lx, lpszPhoneNumber %s\n",ulDeviceHandle,ulDialType,lpszPhoneNumber);
  
  ulRC = objRequestDialPermission (&BL,ulDeviceHandle, ulDialType, lpszPhoneNumber,lpulDialStatus, lpulDialHandle, lpulDelayTime);
  
  MW_SYSLOG_5(TRACE_MWMBL,"mwblapi::BL_RequestDialPermission exit ulRC %lx ulDialStatus %lx ulDelayTime%lx ulDialHandle %lx\n",ulRC,*lpulDialStatus,*lpulDelayTime,*lpulDialHandle);
  
  return ulRC;
} 


//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//
//  BL_DialResults
//
//     This function is used to handle the results of a dial from the list
//     above.  For manual dials, unsuccessful results do not change any
//     phone number status, however, a successful result will clear call
//     restrictions for auto-dialing.
//
//
//
//     Params:   ulDeviceHandle - The registered device handle.
//               ulDialHandle   - The dial handle from BL_RequestDialPermission.
//               ulDialStatus   - The dial status defined above as:
//                                   SUCCESSFUL
//                                   NO_DIAL_TONE
//                                   LINE_BUSY
//                                   USER_ABORT
//                                   NO_CONNECT
//               ulReserved     - A reserved location for future API expansion.
//
//     Returns:  ULONG Successful:  0
//                     Error:       BLERR_.... from the list above
//
//-----------------------------------------------------------------------------
ULONG APIENTRY BL_DialResults (ULONG ulDeviceHandle, ULONG ulDialHandle,
                               ULONG ulDialStatus, ULONG ulReserved)
{
  ULONG ulRC=0;
  
  MW_SYSLOG_4(TRACE_MWMBL,"mwblapi::BL_DialResults entry ulDeviceHandle %lx ulDialHandle %lx ulDialStatus = %lx\n",ulDeviceHandle,ulDialHandle,ulDialStatus);
  
  ulRC=objDialResults (&BL,ulDeviceHandle, ulDialHandle, ulDialStatus);
  
  MW_SYSLOG_2(TRACE_MWMBL,"mwblapi::BL_DialResults exit ulRC %lx\n", ulRC);
  return ulRC;
} 





