/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.View;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.SceneHelper;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.Scene;

public abstract class Accessible {
    private EventHandler eventHandler;
    private View view;
    private GetAttribute getAttribute = new GetAttribute();
    private ExecuteAction executeAction = new ExecuteAction();

    public EventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void setEventHandler(EventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public void setView(View view) {
        this.view = view;
    }

    public View getView() {
        return this.view;
    }

    public void dispose() {
        this.eventHandler = null;
        this.view = null;
    }

    public boolean isDisposed() {
        return this.getNativeAccessible() == 0L;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (" + this.eventHandler + ")";
    }

    protected boolean isIgnored() {
        AccessibleRole role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
        if (role == null) {
            return true;
        }
        return role == AccessibleRole.NODE || role == AccessibleRole.PARENT;
    }

    protected abstract long getNativeAccessible();

    protected Accessible getAccessible(Scene scene) {
        if (scene == null) {
            return null;
        }
        return SceneHelper.getAccessible(scene);
    }

    protected Accessible getAccessible(Node node) {
        if (node == null) {
            return null;
        }
        return NodeHelper.getAccessible(node);
    }

    protected long getNativeAccessible(Node node) {
        if (node == null) {
            return 0L;
        }
        Accessible acc = this.getAccessible(node);
        if (acc == null) {
            return 0L;
        }
        return acc.getNativeAccessible();
    }

    protected Accessible getContainerAccessible(AccessibleRole targetRole) {
        Node node = (Node)this.getAttribute(AccessibleAttribute.PARENT, new Object[0]);
        while (node != null) {
            Accessible acc = this.getAccessible(node);
            AccessibleRole role = (AccessibleRole)((Object)acc.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
            if (role == targetRole) {
                return acc;
            }
            node = (Node)acc.getAttribute(AccessibleAttribute.PARENT, new Object[0]);
        }
        return null;
    }

    private final AccessControlContext getAccessControlContext() {
        AccessControlContext acc = null;
        try {
            acc = this.eventHandler.getAccessControlContext();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return acc;
    }

    public Object getAttribute(AccessibleAttribute attribute, Object ... parameters) {
        AccessControlContext acc = this.getAccessControlContext();
        if (acc == null) {
            return null;
        }
        return QuantumToolkit.runWithoutRenderLock(() -> {
            this.getAttribute.attribute = attribute;
            this.getAttribute.parameters = parameters;
            return AccessController.doPrivileged(this.getAttribute, acc);
        });
    }

    public void executeAction(AccessibleAction action, Object ... parameters) {
        AccessControlContext acc = this.getAccessControlContext();
        if (acc == null) {
            return;
        }
        QuantumToolkit.runWithoutRenderLock(() -> {
            this.executeAction.action = action;
            this.executeAction.parameters = parameters;
            return AccessController.doPrivileged(this.executeAction, acc);
        });
    }

    public abstract void sendNotification(AccessibleAttribute var1);

    private class ExecuteAction
    implements PrivilegedAction<Void> {
        AccessibleAction action;
        Object[] parameters;

        private ExecuteAction() {
        }

        @Override
        public Void run() {
            Accessible.this.eventHandler.executeAction(this.action, this.parameters);
            return null;
        }
    }

    private class GetAttribute
    implements PrivilegedAction<Object> {
        AccessibleAttribute attribute;
        Object[] parameters;

        private GetAttribute() {
        }

        @Override
        public Object run() {
            Class<?> clazz;
            Object result = Accessible.this.eventHandler.getAttribute(this.attribute, this.parameters);
            if (result != null && (clazz = this.attribute.getReturnType()) != null) {
                try {
                    clazz.cast(result);
                }
                catch (Exception e) {
                    String msg = "The expected return type for the " + (Object)((Object)this.attribute) + " attribute is " + clazz.getSimpleName() + " but found " + result.getClass().getSimpleName();
                    System.err.println(msg);
                    return null;
                }
            }
            return result;
        }
    }

    public static abstract class EventHandler {
        public Object getAttribute(AccessibleAttribute attribute, Object ... parameters) {
            return null;
        }

        public void executeAction(AccessibleAction action, Object ... parameters) {
        }

        public abstract AccessControlContext getAccessControlContext();
    }
}

