/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.nw.algorithms;

import org.nlogo.extensions.nw.Graph;
import scala.Function1;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;

public final class ClusteringMetrics$ {
    public static ClusteringMetrics$ MODULE$;

    static {
        new ClusteringMetrics$();
    }

    public <V, E> double clusteringCoefficient(Graph<V, E> graph, V node) {
        double d;
        Seq<V> neighbors = graph.outNeighbors(node);
        Set neighborSet = neighbors.toSet();
        if (neighbors.size() < 2) {
            d = 0.0;
        } else {
            Seq neighborLinkCounts = (Seq)neighbors.map((Function1 & java.io.Serializable & Serializable)t -> BoxesRunTime.boxToInteger((int)ClusteringMetrics$.$anonfun$clusteringCoefficient$1(graph, neighborSet, t)), Seq$.MODULE$.canBuildFrom());
            d = (double)BoxesRunTime.unboxToInt((Object)neighborLinkCounts.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / (double)(neighbors.size() * (neighbors.size() - 1));
        }
        return d;
    }

    public <V, E> double modularity(Graph<V, E> graph, Iterable<Set<V>> communities) {
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)communities.map((Function1 & java.io.Serializable & Serializable)c -> BoxesRunTime.boxToDouble((double)ClusteringMetrics$.MODULE$.communityModularity(graph, c)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public <V, E> double communityModularity(Graph<V, E> graph, Set<V> community) {
        DoubleRef totalIn = DoubleRef.create((double)0.0);
        DoubleRef totalOut = DoubleRef.create((double)0.0);
        DoubleRef internal = DoubleRef.create((double)0.0);
        community.foreach((Function1 & java.io.Serializable & Serializable)node -> {
            ClusteringMetrics$.$anonfun$communityModularity$1(graph, community, internal, totalOut, totalIn, node);
            return BoxedUnit.UNIT;
        });
        return (internal.elem - totalIn.elem * totalOut.elem / graph.totalArcWeight()) / graph.totalArcWeight();
    }

    public static final /* synthetic */ int $anonfun$clusteringCoefficient$1(Graph graph$1, Set neighborSet$1, Object t) {
        return graph$1.outNeighbors(t).count((Function1 & java.io.Serializable & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)neighborSet$1.contains(elem)));
    }

    public static final /* synthetic */ void $anonfun$communityModularity$2(Graph graph$3, Set community$1, Object node$1, DoubleRef internal$1, DoubleRef totalOut$1, Object edge) {
        double weight = graph$3.weight(edge);
        if (community$1.contains(graph$3.otherEnd(node$1, edge))) {
            internal$1.elem += weight;
        }
        totalOut$1.elem += weight;
    }

    public static final /* synthetic */ void $anonfun$communityModularity$3(DoubleRef totalIn$1, Graph graph$3, Object edge) {
        totalIn$1.elem += graph$3.weight(edge);
    }

    public static final /* synthetic */ void $anonfun$communityModularity$1(Graph graph$3, Set community$1, DoubleRef internal$1, DoubleRef totalOut$1, DoubleRef totalIn$1, Object node) {
        graph$3.outEdges(node).foreach((Function1 & java.io.Serializable & Serializable)edge -> {
            ClusteringMetrics$.$anonfun$communityModularity$2(graph$3, community$1, node, internal$1, totalOut$1, edge);
            return BoxedUnit.UNIT;
        });
        graph$3.inEdges(node).foreach((Function1 & java.io.Serializable & Serializable)edge -> {
            ClusteringMetrics$.$anonfun$communityModularity$3(totalIn$1, graph$3, edge);
            return BoxedUnit.UNIT;
        });
    }

    private ClusteringMetrics$() {
        MODULE$ = this;
    }
}

