/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.projection;

import com.vividsolutions.jts.geom.Coordinate;
import java.text.ParseException;
import org.myworldgis.projection.AbstractProjection;
import org.myworldgis.projection.Ellipsoid;
import org.myworldgis.projection.ProjectionParameters;
import org.ngs.ngunits.NonSI;
import org.ngs.ngunits.SI;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.UnitConverter;
import org.ngs.ngunits.quantity.Angle;
import org.ngs.ngunits.quantity.Length;

public strictfp abstract class AbstractProjectedProjection
extends AbstractProjection {
    public static final String FALSE_EASTING_PROPERTY = "false_easting";
    public static final String FALSE_NORTHING_PROPERTY = "false_northing";
    private Unit<Length> _units;
    private UnitConverter _toMeters;
    private UnitConverter _fromMeters;
    private double _falseEasting;
    private double _falseNorthing;

    public AbstractProjectedProjection(Ellipsoid ellipsoid, Coordinate center, Unit<Length> units, double falseEasting, double falseNorthing) {
        super(ellipsoid, center);
        this._units = units;
        this._toMeters = this._units.getConverterTo(SI.METRE);
        this._fromMeters = SI.METRE.getConverterTo(this._units);
        this._falseEasting = falseEasting;
        this._falseNorthing = falseNorthing;
    }

    public AbstractProjectedProjection(Ellipsoid ellipsoid, ProjectionParameters parameters) throws ParseException {
        super(ellipsoid, parameters.getCenterLongitude(), parameters.getCenterLatitude());
        this._units = parameters.getLinearUnits();
        this._toMeters = this._units.getConverterTo(SI.METRE);
        this._fromMeters = SI.METRE.getConverterTo(this._units);
        this._falseEasting = parameters.getLinearParameter(FALSE_EASTING_PROPERTY);
        this._falseNorthing = parameters.getLinearParameter(FALSE_NORTHING_PROPERTY);
    }

    protected abstract Coordinate forwardPointRaw(double var1, double var3, Coordinate var5);

    protected abstract Coordinate inversePointRaw(double var1, double var3, Coordinate var5);

    @Override
    protected Coordinate forwardPoint(double lon, double lat, Coordinate storage) {
        storage = this.forwardPointRaw(lon, lat, storage);
        storage.x = this._fromMeters.convert(storage.x) + this._falseEasting;
        storage.y = this._fromMeters.convert(storage.y) + this._falseNorthing;
        return storage;
    }

    @Override
    protected Coordinate inversePoint(double x, double y, Coordinate storage) {
        storage = this.inversePointRaw(this._toMeters.convert(x - this._falseEasting), this._toMeters.convert(y - this._falseNorthing), storage);
        return storage;
    }

    public Unit<Length> getUnits() {
        return this._units;
    }

    public void setUnits(Unit<Length> newUnits) {
        double falseEastingM = this._toMeters.convert(this._falseEasting);
        double falseNorthingM = this._toMeters.convert(this._falseNorthing);
        this._units = newUnits;
        this._toMeters = newUnits.getConverterTo(SI.METRE);
        this._fromMeters = SI.METRE.getConverterTo(newUnits);
        this.setFalseEasting(this._fromMeters.convert(falseEastingM));
        this.setFalseNorthing(this._fromMeters.convert(falseNorthingM));
    }

    public double getFalseEasting() {
        return this._falseEasting;
    }

    public void setFalseEasting(double newEasting) {
        if (newEasting != this._falseEasting) {
            this._falseEasting = newEasting;
        }
    }

    public double getFalseNorthing() {
        return this._falseNorthing;
    }

    public void setFalseNorthing(double newNorthing) {
        if (newNorthing != this._falseNorthing) {
            this._falseNorthing = newNorthing;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            AbstractProjectedProjection proj = (AbstractProjectedProjection)obj;
            return proj._units.equals(this._units) && StrictMath.abs(proj._falseEasting - this._falseEasting) < 1.567855942887398E-7 && StrictMath.abs(proj._falseNorthing - this._falseNorthing) < 1.567855942887398E-7;
        }
        return false;
    }

    @Override
    public double getCenterEasting() {
        return this._falseEasting;
    }

    @Override
    public double getCenterNorthing() {
        return this._falseNorthing;
    }

    @Override
    public ProjectionParameters getParameters() {
        ProjectionParameters result = new ProjectionParameters((Unit<Angle>)NonSI.DEGREE_ANGLE, this._units);
        result.addLinearParameter(FALSE_EASTING_PROPERTY, this._falseEasting, (Unit<Length>)SI.METRE);
        result.addLinearParameter(FALSE_NORTHING_PROPERTY, this._falseNorthing, (Unit<Length>)SI.METRE);
        return result;
    }
}

