/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.timecode;

import org.openimaj.audio.timecode.AudioTimecode;
import org.openimaj.audio.util.MusicUtils;

public class MeasuresBeatsTicksTimecode
extends AudioTimecode {
    public int beatsPerMeasure = 4;
    public int ticksPerBeat = 120;
    public float bpm = 140.0f;
    private int mpb = MusicUtils.millisPerBeat(this.bpm);

    public MeasuresBeatsTicksTimecode(float bpm) {
        super(0L);
        this.bpm = bpm;
        this.mpb = MusicUtils.millisPerBeat(bpm);
    }

    public MeasuresBeatsTicksTimecode(float bpm, long measures, int beats, int ticks) {
        this(bpm);
        int mpt = this.mpb / this.ticksPerBeat;
        this.milliseconds = (long)this.mpb * (measures * (long)this.beatsPerMeasure + (long)beats) + (long)(mpt * ticks);
    }

    public MeasuresBeatsTicksTimecode(float bpm, long measures, int beats, int ticks, int beatsPerMeasure) {
        this(bpm);
        this.beatsPerMeasure = beatsPerMeasure;
        int mpt = this.mpb / this.ticksPerBeat;
        this.milliseconds = (long)this.mpb * (measures * (long)beatsPerMeasure + (long)beats) + (long)(mpt * ticks);
    }

    public long getMeasures() {
        return this.milliseconds / (long)this.mpb / (long)this.beatsPerMeasure;
    }

    public int getBeats() {
        return (int)(this.milliseconds / (long)this.mpb) % this.beatsPerMeasure;
    }

    public int getTicks() {
        float mpt = (float)this.mpb / (float)this.ticksPerBeat;
        return (int)((float)this.milliseconds / mpt) % this.ticksPerBeat;
    }

    @Override
    public String toString() {
        return this.getMeasures() + ":" + this.getBeats() + ":" + this.getTicks();
    }
}

