/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.contour;

import java.awt.geom.Point2D;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Vertex;
import org.tinfour.contour.Contour;
import org.tinfour.contour.ContourRegion;
import org.tinfour.contour.ContourRegionMember;
import org.tinfour.contour.PerimeterLink;
import org.tinfour.contour.TipLink;
import org.tinfour.interpolation.IVertexValuator;

public class ContourBuilderForTin {
    private final IIncrementalTin tin;
    private final List<IQuadEdge> perimeter;
    private final IVertexValuator valuator;
    private final double[] zContour;
    private BitSet visited;
    private final ArrayList<Contour> closedContourList = new ArrayList();
    private final ArrayList<Contour> openContourList = new ArrayList();
    private final ArrayList<Contour> perimeterContourList = new ArrayList();
    private final ArrayList<ContourRegion> regionList = new ArrayList();
    private final ArrayList<ContourRegion> outerRegions = new ArrayList();
    private int nContour;
    private int nVertexTransit;
    private int nEdgeTransit;
    boolean regionsAreBuilt;
    private long timeToBuildContours;
    private long timeToBuildRegions;
    private final Map<Integer, PerimeterLink> perimeterMap = new HashMap<Integer, PerimeterLink>();
    private final List<PerimeterLink> perimeterList = new ArrayList<PerimeterLink>();

    public ContourBuilderForTin(IIncrementalTin tin, IVertexValuator vertexValuator, double[] zContour, boolean buildRegions) {
        if (tin == null) {
            throw new IllegalArgumentException("Null reference for input TIN");
        }
        if (!tin.isBootstrapped()) {
            throw new IllegalArgumentException("Input TIN is not properly populated");
        }
        if (zContour == null) {
            throw new IllegalArgumentException("Null reference for input contour list");
        }
        for (int i = 1; i < zContour.length; ++i) {
            if (zContour[i - 1] < zContour[i]) continue;
            throw new IllegalArgumentException("Input contours must be unique and specified in ascending order, zContours[ " + i + "] does not meet this requirement");
        }
        this.tin = tin;
        this.valuator = vertexValuator == null ? new DefaultValuator() : vertexValuator;
        this.zContour = zContour;
        int n = tin.getMaximumEdgeAllocationIndex();
        this.visited = new BitSet(n);
        this.perimeter = tin.getPerimeter();
        PerimeterLink prior = null;
        int k = 0;
        for (IQuadEdge p : this.perimeter) {
            PerimeterLink pLink = new PerimeterLink(k, p);
            this.perimeterMap.put(p.getIndex(), pLink);
            this.perimeterList.add(pLink);
            if (prior != null) {
                prior.next = pLink;
                pLink.prior = prior;
            }
            prior = pLink;
            ++k;
        }
        assert (!this.perimeterList.isEmpty() && prior != null) : "Missing perimeter data";
        PerimeterLink pFirst = this.perimeterList.get(0);
        pFirst.prior = prior;
        prior.next = pFirst;
        this.buildAllContours();
        if (buildRegions) {
            this.buildRegions();
        }
        this.visited = null;
    }

    public List<Contour> getContours() {
        int n = this.closedContourList.size() + this.openContourList.size() + this.perimeterContourList.size();
        ArrayList<Contour> cList = new ArrayList<Contour>(n);
        cList.addAll(this.openContourList);
        cList.addAll(this.closedContourList);
        cList.addAll(this.perimeterContourList);
        return cList;
    }

    public List<ContourRegion> getRegions() {
        ArrayList<ContourRegion> aList = new ArrayList<ContourRegion>(this.regionList.size());
        aList.addAll(this.regionList);
        return aList;
    }

    private boolean storeContour(Contour contour, boolean reachedPerimeter) {
        if (contour.closedLoop) {
            assert (!reachedPerimeter) : "Reached perimeter while building interior contour";
            contour.complete();
            this.closedContourList.add(contour);
        } else {
            assert (reachedPerimeter) : "Failed to reached perimeter while building perimeter-intersection contour";
            contour.complete();
            this.openContourList.add(contour);
        }
        return true;
    }

    private void buildAllContours() {
        long time0 = System.nanoTime();
        for (int i = 0; i < this.zContour.length; ++i) {
            this.visited.clear();
            this.buildOpenContours(i);
            this.buildClosedLoopContours(i);
        }
        long time1 = System.nanoTime();
        this.timeToBuildContours = time1 - time0;
    }

    private void buildClosedLoopContours(int iContour) {
        double z = this.zContour[iContour];
        for (IQuadEdge e : this.tin.edges()) {
            Contour contour;
            Contour contour2;
            int eIndex = e.getIndex();
            if (this.visited.get(eIndex)) continue;
            this.mark(e);
            Vertex A = e.getA();
            Vertex B = e.getB();
            double zA = this.valuator.value(A);
            double zB = this.valuator.value(B);
            if (zA > zB) {
                if (!(zA > z) || !(z > zB)) continue;
                contour2 = new Contour(this.nContour++, iContour + 1, iContour, z, true);
                contour2.add(e, zA, zB);
                this.followContour(contour2, z);
                continue;
            }
            if (zB > zA) {
                if (!(zB > z) || !(z > zA)) continue;
                contour2 = new Contour(this.nContour++, iContour + 1, iContour, z, true);
                contour2.add(e.getDual(), zB, zA);
                this.followContour(contour2, z);
                continue;
            }
            if (zA != z) continue;
            IQuadEdge f = e.getForward();
            IQuadEdge d = e.getDual();
            IQuadEdge g = d.getForward();
            Vertex C = f.getB();
            Vertex D = g.getB();
            double zC = this.valuator.value(C);
            double zD = this.valuator.value(D);
            if (zC >= z && z > zD) {
                this.mark(f);
                contour = new Contour(this.nContour++, iContour + 1, iContour, z, true);
                contour.add(e, A);
                contour.add(e, B);
                this.followContour(contour, z);
                continue;
            }
            if (!(zD >= z) || !(z > zC)) continue;
            this.mark(g);
            contour = new Contour(this.nContour++, iContour + 1, iContour, z, true);
            contour.add(d, B);
            contour.add(d, A);
            this.followContour(contour, z);
        }
    }

    private void buildOpenContours(int iContour) {
        double z = this.zContour[iContour];
        block0: for (IQuadEdge p : this.perimeter) {
            IQuadEdge e = p;
            int eIndex = e.getIndex();
            if (this.visited.get(eIndex)) continue;
            this.mark(e);
            Vertex A = e.getA();
            Vertex B = e.getB();
            double zA = this.valuator.value(A);
            double zB = this.valuator.value(B);
            if (zA > z && z > zB) {
                Contour contour = new Contour(this.nContour++, iContour + 1, iContour, z, false);
                contour.add(e, zA, zB);
                this.followContour(contour, z);
                continue;
            }
            if (!(zA > z) || zB != z) continue;
            IQuadEdge f = e.getForward();
            this.mark(f);
            Vertex C = f.getB();
            double zC = this.valuator.value(C);
            if (zC < z) {
                Contour contour = new Contour(this.nContour++, iContour + 1, iContour, z, false);
                contour.add(e, B);
                IQuadEdge n = e.getDualFromReverse();
                this.mark(n);
                contour.add(n, zA, zC);
                this.followContour(contour, z);
                continue;
            }
            while (true) {
                IQuadEdge g = f.getDual();
                IQuadEdge h = g.getForward();
                IQuadEdge k = h.getForward();
                Vertex G = h.getB();
                this.mark(g);
                this.mark(h);
                this.mark(k);
                if (G == null) continue block0;
                double zG = this.valuator.value(G);
                if (zG < z) {
                    Contour contour;
                    if (zC == z) {
                        contour = new Contour(this.nContour++, iContour + 1, iContour, z, false);
                        contour.add(e, B);
                        IQuadEdge n = e.getDualFromReverse();
                        this.mark(n);
                        contour.add(n, C);
                        this.followContour(contour, z);
                        continue block0;
                    }
                    assert (zC > z) : "Improper perimeter to vertex transition";
                    contour = new Contour(this.nContour++, iContour + 1, iContour, z, false);
                    contour.add(e, B);
                    IQuadEdge q = g.getDualFromReverse();
                    this.mark(q);
                    contour.add(q, zC, zG);
                    this.followContour(contour, z);
                    continue block0;
                }
                C = G;
                zC = zG;
                e = g;
                f = h;
            }
        }
    }

    private void mark(IQuadEdge e) {
        int index = e.getIndex();
        this.visited.set(index);
        this.visited.set(index ^ 1);
    }

    private boolean followContour(Contour contour, double z) {
        block0: while (true) {
            Vertex v = contour.terminalVertex;
            IQuadEdge e = contour.terminalEdge;
            IQuadEdge f = e.getForward();
            IQuadEdge r = e.getReverse();
            this.mark(e);
            this.mark(f);
            this.mark(r);
            Vertex A = e.getA();
            Vertex B = f.getA();
            Vertex C = r.getA();
            if (C == null) {
                return this.storeContour(contour, true);
            }
            double zA = this.valuator.value(A);
            double zB = this.valuator.value(B);
            double zC = this.valuator.value(C);
            if (v == null) {
                ++this.nEdgeTransit;
                assert (zA > z && z > zB) : "Entry not on a bracketed descending edge";
                if (zC < z) {
                    e = r.getDual();
                    if (e.equals(contour.startEdge)) {
                        return this.storeContour(contour, false);
                    }
                    contour.add(e, zA, zC);
                    continue;
                }
                if (zC > z) {
                    e = f.getDual();
                    if (e.equals(contour.startEdge)) {
                        return this.storeContour(contour, false);
                    }
                    contour.add(e, zC, zB);
                    continue;
                }
                if (zC == z) {
                    e = r.getDual();
                    contour.add(e, C);
                    if (!C.equals(contour.startVertex)) continue;
                    return this.storeContour(contour, false);
                }
                return false;
            }
            ++this.nVertexTransit;
            assert (zA >= z && z >= zB) : "transition vertex-to-edge failure";
            if (zA > z && z > zC) {
                e = r.getDual();
                if (e.equals(contour.startEdge)) {
                    return this.storeContour(contour, false);
                }
                contour.add(e, zA, zC);
                continue;
            }
            IQuadEdge e0 = e;
            IQuadEdge g = f.getDual();
            IQuadEdge h = g.getForward();
            IQuadEdge k = g.getReverse();
            Vertex G = h.getB();
            do {
                this.mark(g);
                this.mark(h);
                this.mark(k);
                if (G == null) {
                    return this.storeContour(contour, true);
                }
                double zG = this.valuator.value(G);
                if (zG < z) {
                    if (zC == z) {
                        if (C.equals(contour.startVertex)) {
                            return this.storeContour(contour, false);
                        }
                        IQuadEdge q = e.getDualFromReverse();
                        contour.add(q, C);
                        e = f;
                        continue block0;
                    }
                    assert (zC > z) : "zC must be > z, value=" + z;
                    e = k.getDual();
                    if (e.equals(contour.startEdge)) {
                        return this.storeContour(contour, false);
                    }
                    contour.add(e, zC, zG);
                    continue block0;
                }
                e = g;
                f = h;
                r = k;
                C = G;
                zC = zG;
                g = f.getDual();
                h = g.getForward();
                k = g.getReverse();
                G = h.getB();
            } while ($assertionsDisabled || !e0.equals(e));
            break;
        }
        throw new AssertionError((Object)"trans-vertex search loop failed");
    }

    private void buildRegions() {
        long time0 = System.nanoTime();
        this.buildRegionsUsingPerimeter();
        for (Contour contour : this.closedContourList) {
            ContourRegion region = new ContourRegion(contour);
            this.regionList.add(region);
        }
        this.organizeNestedRegions();
        long time1 = System.nanoTime();
        this.timeToBuildRegions = time1 - time0;
    }

    private void buildRegionsUsingPerimeter() {
        if (this.openContourList.isEmpty()) {
            Vertex A = this.perimeter.get(0).getA();
            double z = this.valuator.value(A);
            int leftIndex = this.zContour.length;
            for (int i = 0; i < this.zContour.length; ++i) {
                if (!(this.zContour[i] > z)) continue;
                leftIndex = i;
                break;
            }
            Contour contour = new Contour(this.nContour++, leftIndex, -1, z, true);
            for (IQuadEdge p : this.perimeter) {
                A = p.getA();
                contour.add(A.getX(), A.getY());
            }
            contour.complete();
            this.perimeterContourList.add(contour);
            ContourRegion region = new ContourRegion(contour);
            this.regionList.add(region);
            return;
        }
        for (Contour contour : this.openContourList) {
            int startIndex = contour.startEdge.getIndex();
            PerimeterLink pStart = this.perimeterMap.get(startIndex);
            pStart.addContourTip(contour, true);
            IQuadEdge termDual = contour.terminalEdge.getDual();
            int termIndex = termDual.getIndex();
            PerimeterLink pTerm = this.perimeterMap.get(termIndex);
            pTerm.addContourTip(contour, false);
        }
        for (PerimeterLink pLink : this.perimeterList) {
            if (pLink.tip0 == null) continue;
            TipLink node = pLink.tip0;
            while (node != null) {
                ContourRegion region;
                List<ContourRegionMember> mList;
                double z;
                if (node.start) {
                    if (!node.contour.traversedForward) {
                        int leftIndex = node.contour.leftIndex;
                        z = node.contour.z;
                        mList = this.traverseFromNode(node, leftIndex, z, true);
                        region = new ContourRegion(mList, leftIndex);
                        this.regionList.add(region);
                    }
                } else if (!node.contour.traversedBackward) {
                    int rightIndex = node.contour.rightIndex;
                    z = node.contour.z;
                    mList = this.traverseFromNode(node, rightIndex, z, false);
                    region = new ContourRegion(mList, rightIndex);
                    this.regionList.add(region);
                }
                node = node.next;
            }
        }
    }

    private List<ContourRegionMember> traverseFromNode(TipLink tipLink0, int leftIndex, double z, boolean forward0) {
        ArrayList<ContourRegionMember> mList = new ArrayList<ContourRegionMember>();
        TipLink node = tipLink0;
        boolean forward = forward0;
        do {
            double y;
            double x;
            Contour contour = node.contour;
            ContourRegionMember member = new ContourRegionMember(contour, forward);
            mList.add(member);
            Contour boundaryContour = new Contour(this.nContour++, leftIndex, -1, z, false);
            this.perimeterContourList.add(boundaryContour);
            member = new ContourRegionMember(boundaryContour, true);
            mList.add(member);
            if (forward) {
                contour.traversedForward = true;
                node = contour.terminalTip;
                x = contour.xy[contour.xy.length - 2];
                y = contour.xy[contour.xy.length - 1];
            } else {
                contour.traversedBackward = true;
                node = contour.startTip;
                x = contour.xy[0];
                y = contour.xy[1];
            }
            boundaryContour.add(x, y);
            if (node.next != null) {
                node = node.next;
            } else {
                PerimeterLink pLink = node.pLink.next;
                IQuadEdge pEdge = pLink.edge;
                Vertex A = pEdge.getA();
                boundaryContour.add(A.getX(), A.getY());
                while (pLink.tip0 == null) {
                    pLink = pLink.next;
                    pEdge = pLink.edge;
                    A = pEdge.getA();
                    boundaryContour.add(A.getX(), A.getY());
                }
                node = pLink.tip0;
            }
            contour = node.contour;
            if (node.start) {
                forward = true;
                x = contour.xy[0];
                y = contour.xy[1];
            } else {
                forward = false;
                x = contour.xy[contour.xy.length - 2];
                y = contour.xy[contour.xy.length - 1];
            }
            boundaryContour.add(x, y);
            boundaryContour.complete();
        } while (node != tipLink0);
        return mList;
    }

    private void organizeNestedRegions() {
        int nRegion = this.regionList.size();
        if (nRegion < 2) {
            return;
        }
        Collections.sort(this.regionList, (o1, o2) -> Double.compare(o2.absArea, o1.absArea));
        for (int i = 0; i < nRegion - 1; ++i) {
            ContourRegion rI = this.regionList.get(i);
            double[] xy = rI.getXY();
            for (int j = i + 1; j < nRegion; ++j) {
                Point2D testPoint;
                ContourRegion rJ = this.regionList.get(j);
                if (rJ.contourRegionType == ContourRegion.ContourRegionType.Perimeter || !rI.isPointInsideRegion(xy, (testPoint = rJ.getTestPoint()).getX(), testPoint.getY())) continue;
                rJ.setParent(rI);
            }
        }
        for (ContourRegion region : this.regionList) {
            if (region.parent == null) {
                this.outerRegions.add(region);
                continue;
            }
            region.parent.addChild(region);
        }
    }

    private int countPoints(List<Contour> cList) {
        int n = 0;
        for (Contour c : cList) {
            n += c.size();
        }
        return n;
    }

    public void summarize(PrintStream ps, double areaFactor) {
        ps.format("Summary of statistics for contour building%n", new Object[0]);
        ps.format("Time to build contours %7.1f ms%n", (double)this.timeToBuildContours / 1000000.0);
        ps.format("Time to build regions  %7.1f ms%n", (double)this.timeToBuildRegions / 1000000.0);
        ps.format("Open contours:      %8d,  %8d points%n", this.openContourList.size(), this.countPoints(this.openContourList));
        ps.format("Closed contours:    %8d,  %8d points%n", this.closedContourList.size(), this.countPoints(this.closedContourList));
        ps.format("Regions:            %8d%n", this.regionList.size());
        ps.format("Outer Regions:      %8d%n", this.outerRegions.size());
        ps.format("Edge transits:      %8d%n", this.nEdgeTransit);
        ps.format("Vertex transits:    %8d%n", this.nVertexTransit);
        ps.format("%n", new Object[0]);
    }

    private static class DefaultValuator
    implements IVertexValuator {
        private DefaultValuator() {
        }

        @Override
        public double value(Vertex v) {
            assert (v != null) : "Internal method failure, accessing value for null vertex";
            double z = v.getZ();
            if (Double.isNaN(z)) {
                throw new IllegalArgumentException("Input includes vertices with NaN z values");
            }
            return z;
        }
    }
}

