/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mkv.boxes;

import java.nio.ByteBuffer;
import org.jcodec.containers.mkv.boxes.EbmlBin;

public class EbmlUint
extends EbmlBin {
    public EbmlUint(byte[] id) {
        super(id);
    }

    public EbmlUint(byte[] id, long value) {
        super(id);
        this.set(value);
    }

    public void set(long value) {
        this.data = ByteBuffer.wrap(EbmlUint.longToBytes(value));
        this.dataLen = this.data.limit();
    }

    public long get() {
        long l = 0L;
        long tmp = 0L;
        for (int i = 0; i < this.data.limit(); ++i) {
            tmp = (long)this.data.get(this.data.limit() - 1 - i) << 56;
            l |= (tmp >>>= 56 - i * 8);
        }
        return l;
    }

    public static byte[] longToBytes(long value) {
        byte[] b = new byte[EbmlUint.calculatePayloadSize(value)];
        for (int i = b.length - 1; i >= 0; --i) {
            b[i] = (byte)(value >>> 8 * (b.length - i - 1));
        }
        return b;
    }

    public static int calculatePayloadSize(long value) {
        int i;
        if (value == 0L) {
            return 1;
        }
        long mask = -72057594037927936L;
        for (i = 0; (value & mask >>> 8 * i) == 0L && i < 8; ++i) {
        }
        return 8 - i;
    }
}

