/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.javadraw;

import java.awt.BorderLayout;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JApplet;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Tool;
import org.jhotdraw.framework.ViewChangeListener;
import org.jhotdraw.samples.javadraw.FollowURLTool;
import org.jhotdraw.standard.StandardDrawing;
import org.jhotdraw.standard.StandardDrawingView;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.UndoManager;

public class JavaDrawViewer
extends JApplet
implements DrawingEditor {
    private Drawing fDrawing;
    private Tool fTool;
    private StandardDrawingView fView;
    private transient UndoManager myUndoManager;

    public void init() {
        this.setUndoManager(new UndoManager());
        this.getContentPane().setLayout(new BorderLayout());
        this.fView = new StandardDrawingView(this, 400, 370);
        this.getContentPane().add("Center", this.fView);
        this.setTool(new FollowURLTool(this, this));
        String string = this.getParameter("Drawing");
        if (string != null) {
            this.loadDrawing(string);
            this.fView.setDrawing(this.fDrawing);
        } else {
            this.showStatus("Unable to load drawing");
        }
    }

    public void addViewChangeListener(ViewChangeListener viewChangeListener) {
    }

    public void removeViewChangeListener(ViewChangeListener viewChangeListener) {
    }

    private void loadDrawing(String string) {
        try {
            URL uRL = new URL(this.getCodeBase(), string);
            InputStream inputStream = uRL.openStream();
            StorableInput storableInput = new StorableInput(inputStream);
            this.fDrawing = (Drawing)storableInput.readStorable();
        }
        catch (IOException iOException) {
            this.fDrawing = this.createDrawing();
            System.err.println("Error when Loading: " + iOException);
            this.showStatus("Error when Loading: " + iOException);
        }
    }

    protected Drawing createDrawing() {
        return new StandardDrawing();
    }

    public DrawingView view() {
        return this.fView;
    }

    public DrawingView[] views() {
        return new DrawingView[]{this.view()};
    }

    public Drawing drawing() {
        return this.fDrawing;
    }

    public Tool tool() {
        return this.fTool;
    }

    public void setTool(Tool tool) {
        this.fTool = tool;
    }

    public void toolDone() {
    }

    public void figureSelectionChanged(DrawingView drawingView) {
    }

    protected void setUndoManager(UndoManager undoManager) {
        this.myUndoManager = undoManager;
    }

    public UndoManager getUndoManager() {
        return this.myUndoManager;
    }
}

