/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.image.Image;
import org.openimaj.video.ArrayBackedVideo;
import org.openimaj.video.Video;
import org.openimaj.video.VideoWriter;
import org.openimaj.video.timecode.VideoTimecode;

public class VideoCache<I extends Image<?, I>>
extends VideoWriter<I> {
    private List<I> frames = new ArrayList<I>();

    public VideoCache(int width, int height, double frameRate) {
        super(width, height, frameRate);
    }

    @Override
    public void addFrame(I frame) {
        this.frames.add(frame);
    }

    public ArrayBackedVideo<I> getArrayBackedVideo() {
        return new ArrayBackedVideo((Image[])this.frames.toArray(), this.frameRate);
    }

    public int getNumberOfFrames() {
        return this.frames.size();
    }

    public I getFrame(int i) {
        return (I)((Image)this.frames.get(i));
    }

    @Override
    public void reset() {
        this.frames.clear();
    }

    public static <I extends Image<?, I>> VideoCache<I> cacheVideo(Video<I> video) {
        VideoCache<Image> vc = new VideoCache<Image>(video.getWidth(), video.getHeight(), video.getFPS());
        video.reset();
        while (video.hasNextFrame()) {
            vc.addFrame(video.getNextFrame().clone());
        }
        return vc;
    }

    public static <I extends Image<?, I>> VideoCache<I> cacheVideo(Video<I> video, VideoTimecode start, VideoTimecode end) {
        VideoCache<Image> vc = new VideoCache<Image>(video.getWidth(), video.getHeight(), video.getFPS());
        video.setCurrentFrameIndex(start.getFrameNumber());
        while (video.hasNextFrame() && (long)video.getCurrentFrameIndex() < end.getFrameNumber()) {
            vc.addFrame(video.getNextFrame().clone());
        }
        return vc;
    }
}

