/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.context.typewrapper;

import java.lang.reflect.InvocationTargetException;
import net.sourceforge.jeuclid.context.typewrapper.AbstractSimpleTypeWrapper;
import net.sourceforge.jeuclid.context.typewrapper.TypeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnumTypeWrapper
extends AbstractSimpleTypeWrapper {
    private static final String FAILED_TO_RETRIEVE_VALUES_OF_ENUM_CLASS = "Failed to retrieve values of enum class ";
    private static final long serialVersionUID = 1L;

    private EnumTypeWrapper(Class<? extends Enum<?>> clazz) {
        super(clazz);
    }

    public static TypeWrapper getInstance(Class<? extends Enum<?>> clazz) {
        return new EnumTypeWrapper(clazz);
    }

    @Override
    public Object fromString(String string) {
        if (string == null) {
            return null;
        }
        return Enum.valueOf(this.getValueType(), string);
    }

    public Object[] values() {
        try {
            return (Object[])this.getValueType().getMethod("values", new Class[0]).invoke(null, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(FAILED_TO_RETRIEVE_VALUES_OF_ENUM_CLASS + this.getValueType(), invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(FAILED_TO_RETRIEVE_VALUES_OF_ENUM_CLASS + this.getValueType(), illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(FAILED_TO_RETRIEVE_VALUES_OF_ENUM_CLASS + this.getValueType(), noSuchMethodException);
        }
    }
}

