/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.logger;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class LoggerUtils {
    public static void prepareConsoleLogger() {
        String PATTERN = "%m\n";
        PatternLayout layout = PatternLayout.newBuilder().withPattern("%m\n").build();
        ThresholdFilter filter = ThresholdFilter.createFilter((Level)Level.DEBUG, (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.DENY);
        ConsoleAppender console = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().withName("default-consoleappender")).withLayout((Layout)layout)).withFilter((Filter)filter)).build();
        Logger root = LogManager.getRootLogger();
        if (root instanceof org.apache.logging.log4j.core.Logger) {
            ((org.apache.logging.log4j.core.Logger)root).addAppender((Appender)console);
        }
    }

    public static void debug(Logger logger, String message, boolean b) {
        if (b) {
            logger.debug(message);
        }
    }

    public static void debugFormat(Logger logger, String string, Object ... obj) {
        LoggerUtils.format(logger, string, Level.DEBUG, obj);
    }

    public static void format(Logger logger, String string, Level debug, Object ... obj) {
        Level l = logger.getLevel();
        if (debug.isMoreSpecificThan(l)) {
            logger.log(debug, String.format(string, obj));
        }
    }
}

