/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.typography.hershey;

import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import org.openimaj.image.DisplayUtilities;
import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.ColourSpace;
import org.openimaj.image.colour.RGBColour;
import org.openimaj.image.renderer.FImageRenderer;
import org.openimaj.image.renderer.ImageRenderer;
import org.openimaj.image.typography.Font;
import org.openimaj.image.typography.FontRenderer;
import org.openimaj.image.typography.FontStyle;
import org.openimaj.image.typography.hershey.HersheyFontData;
import org.openimaj.image.typography.hershey.HersheyFontRenderer;
import org.openimaj.image.typography.hershey.HersheyFontStyle;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.shape.Shape;

public enum HersheyFont implements Font<HersheyFont>
{
    ASTROLOGY("astrology.jhf", "Astrology"),
    CURSIVE("cursive.jhf", "Cursive"),
    CYRILLIC_1("cyrilc_1.jhf", "Cyrillic 1"),
    CYRILLIC("cyrillic.jhf", "Cyrillic"),
    FUTURA_LIGHT("futural.jhf", "Futura Light"),
    FUTURA_MEDIUM("futuram.jhf", "Futura Medium"),
    GOTHIC_ENGLISH_TRIPLEX("gothgbt.jhf", "Gothic English Triplex"),
    GOTHIC_GERMAN_TRIPLEX("gothgrt.jhf", "Gothic German Triplex"),
    GOTHIC_ENGLISH("gothiceng.jhf", "Gothic English"),
    GOTHIC_GERMAN("gothicger.jhf", "Gothic German"),
    GOTHIC_ITALIAN("gothicita.jhf", "Gothic Italian"),
    GOTHIC_ITALIAN_TRIPLEX("gothitt.jhf", "Gothic Italian Triplex"),
    GREEK("greek.jhf", "Greek"),
    GREEK_COMPLEX("greekc.jhf", "Greek Complex"),
    GREEK_SIMPLEX("greeks.jhf", "Greeks Simplex"),
    JAPANESE("japanese.jhf", "Japanese"),
    MARKERS("markers.jhf", "Markers"),
    MATH_LOWER("mathlow.jhf", "Math Lower"),
    MATH_UPPER("mathupp.jhf", "Math Upper"),
    METEOROLOGY("meteorology.jhf", "Meteorology"),
    MUSIC("music.jhf", "Music"),
    ROMAN_DUPLEX("rowmand.jhf", "Roman Duplex"),
    ROMAN_SIMPLEX("rowmans.jhf", "Roman Simplex"),
    ROMAN_TRIPLEX("rowmant.jhf", "Roman Triplex"),
    SCRIPT_COMPLEX("scriptc.jhf", "Script Complex"),
    SCRIPT_SIMPLEX("scripts.jhf", "Script Simplex"),
    SYMBOLIC("symbolic.jhf", "Symbolic"),
    TIMES_GREEK("timesg.jhf", "Times Greek"),
    TIMES_MEDIUM_ITALIC("timesi.jhf", "Times Medium Italic"),
    TIMES_BOLD_ITALIC("timesib.jhf", "Times Bold Italic"),
    TIMES_MEDIUM("timesr.jhf", "Times Medium"),
    TIMES_BOLD("timesrb.jhf", "Times Bold");

    protected HersheyFontData data;
    protected String name;

    private HersheyFont(String fntName, String name) {
        try {
            this.data = new HersheyFontData(fntName);
            this.name = name;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T, Q extends FontStyle<T>> FontRenderer<T, Q> getRenderer(ImageRenderer<T, ?> renderer) {
        return HersheyFontRenderer.INSTANCE;
    }

    @Override
    public <T> HersheyFontStyle<T> createStyle(ImageRenderer<T, ?> renderer) {
        return new HersheyFontStyle<T>(this, renderer);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static void main(String[] args) {
        FImage image = new FImage(500, HersheyFont.values().length * 30 + 30);
        FImageRenderer imRenderer = image.createRenderer();
        float i = 1.5f;
        for (HersheyFont f : HersheyFont.values()) {
            FontRenderer<Float, FontStyle> renderer = f.getRenderer(imRenderer);
            renderer.renderText(imRenderer, f.getName(), 30, (int)(i * 30.0f), f.createStyle((ImageRenderer)imRenderer));
            Rectangle bounds = renderer.getSize(f.getName(), f.createStyle((ImageRenderer)imRenderer));
            System.out.println(bounds);
            image.drawShape((Shape)bounds, Float.valueOf(1.0f));
            i += 1.0f;
        }
        DisplayUtilities.display(image);
        MBFImage mbfimage = new MBFImage(500, 500, ColourSpace.RGB);
        HashMap<AttributedCharacterIterator.Attribute, Object> redText = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        redText.put(FontStyle.FONT, TIMES_BOLD);
        redText.put(FontStyle.COLOUR, RGBColour.RED);
        HashMap<AttributedCharacterIterator.Attribute, Object> cursiveText = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        cursiveText.put(FontStyle.FONT, CURSIVE);
        cursiveText.put(FontStyle.COLOUR, RGBColour.YELLOW);
        cursiveText.put(HersheyFontStyle.HEIGHT_SCALE, Float.valueOf(3.0f));
        cursiveText.put(FontStyle.VERTICAL_ALIGNMENT, (Object)FontStyle.VerticalAlignment.VERTICAL_HALF);
        cursiveText.put(HersheyFontStyle.STROKE_WIDTH, 2);
        AttributedString str = new AttributedString("hello world!");
        str.addAttributes(redText, 4, 8);
        str.addAttributes(cursiveText, 8, 12);
        mbfimage.createRenderer().drawText(str, 150, 150);
        DisplayUtilities.display(mbfimage);
        FImage image2 = new FImage(500, 500);
        FImageRenderer imRenderer2 = image2.createRenderer();
        for (i = 1.0f; i < 40.0f; i += 2.0f) {
            FontRenderer<Float, FontStyle> renderer = ROMAN_TRIPLEX.getRenderer(imRenderer2);
            FontStyle sty = ROMAN_TRIPLEX.createStyle((ImageRenderer)imRenderer2);
            sty.setFontSize((int)i);
            renderer.renderText(imRenderer2, ROMAN_TRIPLEX.getName(), 30, (int)(i * 30.0f), sty);
        }
        DisplayUtilities.display(image2);
    }
}

