/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.point;

import Jama.Matrix;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.openimaj.math.geometry.point.Point2d;

public abstract class AbstractPoint2d
implements Point2d {
    @Override
    public int getDimensions() {
        return 2;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Point2d)) {
            return false;
        }
        Point2d p = (Point2d)o;
        return p.getOrdinate(0).equals(this.getOrdinate(0)) && p.getOrdinate(1).equals(this.getOrdinate(1));
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public void readASCII(Scanner in) throws IOException {
        this.setOrdinate(0, in.nextDouble());
        this.setOrdinate(1, in.nextDouble());
    }

    public String asciiHeader() {
        return "Point2d";
    }

    public void readBinary(DataInput in) throws IOException {
        this.setOrdinate(0, in.readDouble());
        this.setOrdinate(1, in.readDouble());
    }

    public byte[] binaryHeader() {
        return "PT2DD".getBytes();
    }

    public void writeASCII(PrintWriter out) throws IOException {
        out.format("%f %f", this.getOrdinate(0).doubleValue(), this.getOrdinate(1).doubleValue());
    }

    public void writeBinary(DataOutput out) throws IOException {
        out.writeDouble(this.getOrdinate(0).doubleValue());
        out.writeDouble(this.getOrdinate(1).doubleValue());
    }

    @Override
    public float getX() {
        return this.getOrdinate(0).floatValue();
    }

    @Override
    public void setX(float x) {
        this.setOrdinate(0, Float.valueOf(x));
    }

    @Override
    public float getY() {
        return this.getOrdinate(1).floatValue();
    }

    @Override
    public void setY(float y) {
        this.setOrdinate(1, Float.valueOf(y));
    }

    @Override
    public void copyFrom(Point2d p) {
        this.setOrdinate(0, p.getOrdinate(0));
        this.setOrdinate(1, p.getOrdinate(1));
    }

    @Override
    public void translate(float x, float y) {
        this.setOrdinate(0, this.getOrdinate(0).doubleValue() + (double)x);
        this.setOrdinate(0, this.getOrdinate(1).doubleValue() + (double)y);
    }

    @Override
    public Point2d transform(Matrix transform) {
        double yt;
        double xt;
        if (transform.getRowDimension() == 3) {
            xt = transform.get(0, 0) * (double)this.getX() + transform.get(0, 1) * (double)this.getY() + transform.get(0, 2);
            yt = transform.get(1, 0) * (double)this.getX() + transform.get(1, 1) * (double)this.getY() + transform.get(1, 2);
            double zt = transform.get(2, 0) * (double)this.getX() + transform.get(2, 1) * (double)this.getY() + transform.get(2, 2);
            xt /= zt;
            yt /= zt;
        } else if (transform.getRowDimension() == 2 && transform.getColumnDimension() == 2) {
            xt = transform.get(0, 0) * (double)this.getX() + transform.get(0, 1) * (double)this.getY();
            yt = transform.get(1, 0) * (double)this.getX() + transform.get(1, 1) * (double)this.getY();
        } else if (transform.getRowDimension() == 2 && transform.getColumnDimension() == 3) {
            xt = transform.get(0, 0) * (double)this.getX() + transform.get(0, 1) * (double)this.getY() + transform.get(0, 2);
            yt = transform.get(1, 0) * (double)this.getX() + transform.get(1, 1) * (double)this.getY() + transform.get(1, 2);
        } else {
            throw new IllegalArgumentException("Transform matrix has unexpected size");
        }
        Point2d cpy = this.copy();
        cpy.setOrdinate(0, xt);
        cpy.setOrdinate(1, yt);
        return cpy;
    }

    @Override
    public Point2d minus(Point2d a) {
        Point2d cpy = this.copy();
        cpy.setOrdinate(0, this.getOrdinate(0).doubleValue() - a.getOrdinate(0).doubleValue());
        cpy.setOrdinate(1, this.getOrdinate(1).doubleValue() - a.getOrdinate(1).doubleValue());
        return cpy;
    }

    @Override
    public void translate(Point2d v) {
        this.setOrdinate(0, this.getOrdinate(0).doubleValue() + v.getOrdinate(0).doubleValue());
        this.setOrdinate(1, this.getOrdinate(1).doubleValue() + v.getOrdinate(1).doubleValue());
    }
}

