#!/bin/ksh
# Marc Winiger <mw at msys.ch> 2005-10-13"
# Generate layouts to show disk usage provided by <marc at msys.ch>"

RRDPATH=/var/www/symon/rrds
TPL=df_bytes.tpl
BS=${BLOCKSIZE:-512}

usage() {
	print "Usage: generate_df_layout.sh -h host1,host2,... -p rrd_path"
}

while getopts "h:p:t:" arg
do
	case $arg in
		h)
			hosts=$(echo $OPTARG | tr "," " ");;
		p)
			RRDPATH=${OPTARG};;
		t)
			TPL=${OPTARG};;
		*)
			usage
			exit 1
			;;
	esac
done

if [ ${OPTIND} -lt 2 ] ; then
	usage
	exit 1
fi
if [ ! -d ${RRDPATH} ] ; then
	print "Path ${RRDPATH} does not exist!"
	exit 1
fi

echo "# group name=\"introduction\";"
echo "# text \"<div></div>\";"

for HOST in ${hosts} ; do

	echo "group name=\"${HOST}\", rrd_dir=${RRDPATH}/${HOST};"

	for PART in $(cd ${RRDPATH}/${HOST} && ls -1 df_* | cut -d _ -f 2 | cut -d . -f 1) ; do
		REGEX="	-e s/__TITLE__/$(mount | grep ${PART} | cut -d \  -f 3 | sed -e s/\\//\\\\\\\//g)/g
			-e s/__HOST__/${HOST}/g
			-e s/__BS__/${BS}/g
			-e s/__PART__/${PART}/g
			-e s/__RRD__/${PART}/g"
		sed ${REGEX} ${TPL}
	done
done



