#include <sys/types.h>
#include "vauth.h"

/*
   socket.c
*/
#undef SOCKET_DEBUG

#define POPFETCH_PORT 110
#define POPFETCH_ADDR "209.218.8.2"

#define MAX_READ_BUFFER 5000

int socket_init(void);
int socket_connect(void);
int socket_read(void);
char *socket_parse(void);
void socket_post_parse(void);
int socket_write(char *);

/*
   pop.c
*/
#undef POP_DEBUG

#define MAX_QUERY_BUFFER 255 /* Maximum size of query creation      */

#define MAX_ATTEMPTS 1       /* Number of attempts to download mail */

#define S_NONE  0      	     /* No status                           */
#define S_CONN  1            /* Connected to POP server             */
#define S_AUTH  2            /* Authenticated                       */
#define S_END   4            /* We're done (success, failure, etc)  */
#define S_LIST  8            /* Collecting message IDs  	    */
#define S_RETR 16            /* Retrieving messages		    */
#define S_DELE 32            /* Deleting messages from server	    */

#define F_NONE  0            /* No status			    */
#define F_WROTE 1            /* Wrote message successfully	    */
#define F_DELE  2            /* Deleted message from server	    */

struct msg_t {
  char *id,
       status;

  unsigned long bytes;

  struct msg_t *next;
};

int pop_init(struct vqpasswd *, char *);
int pop_loop(void);
int pop_none(void);
int pop_conn(void);
int pop_auth(void);
int pop_fail(void);
int pop_write(char *, char *);
int pop_list(void);
int pop_retr(void);
int pop_dele(void);

/* file.c */
#undef FILE_DEBUG

#define DEFAULT_HOSTNAME "popfetch" /* Default hostname if none found */
#define MAX_FILE_LEN 255            /* Maximum length of a filename   */

int file_init(void);
int file_open(void);
int file_close(void);
int file_write(char *);
