// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`GetBucketLogging`](crate::operation::get_bucket_logging::builders::GetBucketLoggingFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::get_bucket_logging::builders::GetBucketLoggingFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::get_bucket_logging::builders::GetBucketLoggingFluentBuilder::set_bucket):<br>required: **true**<br><p>The bucket name for which to get the logging information.</p><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::get_bucket_logging::builders::GetBucketLoggingFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::get_bucket_logging::builders::GetBucketLoggingFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><br>
    /// - On success, responds with [`GetBucketLoggingOutput`](crate::operation::get_bucket_logging::GetBucketLoggingOutput) with field(s):
    ///   - [`logging_enabled(Option<LoggingEnabled>)`](crate::operation::get_bucket_logging::GetBucketLoggingOutput::logging_enabled): <p>Describes where logs are stored and the prefix that Amazon S3 assigns to all log object keys for a bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlogging.html">PUT Bucket logging</a> in the <i>Amazon S3 API Reference</i>.</p>
    /// - On failure, responds with [`SdkError<GetBucketLoggingError>`](crate::operation::get_bucket_logging::GetBucketLoggingError)
    pub fn get_bucket_logging(&self) -> crate::operation::get_bucket_logging::builders::GetBucketLoggingFluentBuilder {
        crate::operation::get_bucket_logging::builders::GetBucketLoggingFluentBuilder::new(self.handle.clone())
    }
}
