#ifndef ATL_stGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,63,101,177,253,291,330,368,406,444,482,558,596,635,711,787,863,940,978,1016,1054,1093,1169,1246,1551,1857,2009,2162,2315,2468,3079,3690,4301,4912,7356,9800
 * N : 25,63,101,177,253,291,330,368,406,444,482,558,596,635,711,787,863,940,978,1016,1054,1093,1169,1246,1551,1857,2009,2162,2315,2468,3079,3690,4301,4912,7356,9800
 * NB : 1,1,2,2,1,1,11,23,35,36,43,42,40,51,55,59,63,75,75,76,76,77,77,83,78,95,96,97,98,99,107,195,222,384,384,672
 */
#define ATL_stGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 82) (nb_) = 1; \
   else if ((n_) < 215) (nb_) = 2; \
   else if ((n_) < 310) (nb_) = 1; \
   else if ((n_) < 349) (nb_) = 11; \
   else if ((n_) < 387) (nb_) = 23; \
   else if ((n_) < 425) (nb_) = 35; \
   else if ((n_) < 463) (nb_) = 36; \
   else if ((n_) < 520) (nb_) = 43; \
   else if ((n_) < 577) (nb_) = 42; \
   else if ((n_) < 615) (nb_) = 40; \
   else if ((n_) < 673) (nb_) = 51; \
   else if ((n_) < 749) (nb_) = 55; \
   else if ((n_) < 825) (nb_) = 59; \
   else if ((n_) < 901) (nb_) = 63; \
   else if ((n_) < 997) (nb_) = 75; \
   else if ((n_) < 1073) (nb_) = 76; \
   else if ((n_) < 1207) (nb_) = 77; \
   else if ((n_) < 1398) (nb_) = 83; \
   else if ((n_) < 1704) (nb_) = 78; \
   else if ((n_) < 1933) (nb_) = 95; \
   else if ((n_) < 2085) (nb_) = 96; \
   else if ((n_) < 2238) (nb_) = 97; \
   else if ((n_) < 2391) (nb_) = 98; \
   else if ((n_) < 2773) (nb_) = 99; \
   else if ((n_) < 3384) (nb_) = 107; \
   else if ((n_) < 3995) (nb_) = 195; \
   else if ((n_) < 4606) (nb_) = 222; \
   else if ((n_) < 8578) (nb_) = 384; \
   else (nb_) = 672; \
}


#endif    /* end ifndef ATL_stGetNB_geqrf */
