#ifndef ATL_cGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,506,988,1048,1108,1168,1229,1289,1349,1409,1470,1711,1952,2012,2072,2132,2193,2253,2313,2373,2434,2675,2795,2916,3398,3880
 * N : 25,506,988,1048,1108,1168,1229,1289,1349,1409,1470,1711,1952,2012,2072,2132,2193,2253,2313,2373,2434,2675,2795,2916,3398,3880
 * NB : 1,1,7,19,23,24,27,28,30,30,31,32,34,90,98,100,114,115,116,120,130,120,108,194,200,352
 */
#define ATL_cGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 747) (nb_) = 1; \
   else if ((n_) < 1018) (nb_) = 7; \
   else if ((n_) < 1078) (nb_) = 19; \
   else if ((n_) < 1138) (nb_) = 23; \
   else if ((n_) < 1198) (nb_) = 24; \
   else if ((n_) < 1259) (nb_) = 27; \
   else if ((n_) < 1319) (nb_) = 28; \
   else if ((n_) < 1439) (nb_) = 30; \
   else if ((n_) < 1590) (nb_) = 31; \
   else if ((n_) < 1831) (nb_) = 32; \
   else if ((n_) < 1982) (nb_) = 34; \
   else if ((n_) < 2042) (nb_) = 90; \
   else if ((n_) < 2102) (nb_) = 98; \
   else if ((n_) < 2162) (nb_) = 100; \
   else if ((n_) < 2223) (nb_) = 114; \
   else if ((n_) < 2283) (nb_) = 115; \
   else if ((n_) < 2343) (nb_) = 116; \
   else if ((n_) < 2403) (nb_) = 120; \
   else if ((n_) < 2554) (nb_) = 130; \
   else if ((n_) < 2735) (nb_) = 120; \
   else if ((n_) < 2855) (nb_) = 108; \
   else if ((n_) < 3157) (nb_) = 194; \
   else if ((n_) < 3639) (nb_) = 200; \
   else (nb_) = 352; \
}


#endif    /* end ifndef ATL_cGetNB_geqrf */
