// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentity

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateIdentityPool = "CreateIdentityPool"

// CreateIdentityPoolRequest generates a "aws/request.Request" representing the
// client's request for the CreateIdentityPool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIdentityPool for more information on using the CreateIdentityPool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateIdentityPoolRequest method.
//    req, resp := client.CreateIdentityPoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/CreateIdentityPool
func (c *CognitoIdentity) CreateIdentityPoolRequest(input *CreateIdentityPoolInput) (req *request.Request, output *IdentityPool) {
	op := &request.Operation{
		Name:       opCreateIdentityPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateIdentityPoolInput{}
	}

	output = &IdentityPool{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIdentityPool API operation for Amazon Cognito Identity.
//
// Creates a new identity pool. The identity pool is a store of user identity
// information that is specific to your AWS account. The limit on identity pools
// is 60 per account. The keys for SupportedLoginProviders are as follows:
//
//    * Facebook: graph.facebook.com
//
//    * Google: accounts.google.com
//
//    * Amazon: www.amazon.com
//
//    * Twitter: api.twitter.com
//
//    * Digits: www.digits.com
//
// You must use AWS Developer credentials to call this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity's
// API operation CreateIdentityPool for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   Thrown for missing or bad input parameter(s).
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   Thrown when a user is not authorized to access the requested resource.
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//   Thrown when a user tries to use a login which is already linked to another
//   account.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Thrown when a request is throttled.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   Thrown when the service encounters an error during processing the request.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Thrown when the total number of user pools has exceeded a preset limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/CreateIdentityPool
func (c *CognitoIdentity) CreateIdentityPool(input *CreateIdentityPoolInput) (*IdentityPool, error) {
	req, out := c.CreateIdentityPoolRequest(input)
	return out, req.Send()
}

// CreateIdentityPoolWithContext is the same as CreateIdentityPool with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIdentityPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentity) CreateIdentityPoolWithContext(ctx aws.Context, input *CreateIdentityPoolInput, opts ...request.Option) (*IdentityPool, error) {
	req, out := c.CreateIdentityPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIdentities = "DeleteIdentities"

// DeleteIdentitiesRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIdentities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIdentities for more information on using the DeleteIdentities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteIdentitiesRequest method.
//    req, resp := client.DeleteIdentitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/DeleteIdentities
func (c *CognitoIdentity) DeleteIdentitiesRequest(input *DeleteIdentitiesInput) (req *request.Request, output *DeleteIdentitiesOutput) {
	op := &request.Operation{
		Name:       opDeleteIdentities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIdentitiesInput{}
	}

	output = &DeleteIdentitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteIdentities API operation for Amazon Cognito Identity.
//
// Deletes identities from an identity pool. You can specify a list of 1-60
// identities that you want to delete.
//
// You must use AWS Developer credentials to call this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity's
// API operation DeleteIdentities for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   Thrown for missing or bad input parameter(s).
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Thrown when a request is throttled.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   Thrown when the service encounters an error during processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/DeleteIdentities
func (c *CognitoIdentity) DeleteIdentities(input *DeleteIdentitiesInput) (*DeleteIdentitiesOutput, error) {
	req, out := c.DeleteIdentitiesRequest(input)
	return out, req.Send()
}

// DeleteIdentitiesWithContext is the same as DeleteIdentities with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIdentities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentity) DeleteIdentitiesWithContext(ctx aws.Context, input *DeleteIdentitiesInput, opts ...request.Option) (*DeleteIdentitiesOutput, error) {
	req, out := c.DeleteIdentitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIdentityPool = "DeleteIdentityPool"

// DeleteIdentityPoolRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIdentityPool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIdentityPool for more information on using the DeleteIdentityPool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteIdentityPoolRequest method.
//    req, resp := client.DeleteIdentityPoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/DeleteIdentityPool
func (c *CognitoIdentity) DeleteIdentityPoolRequest(input *DeleteIdentityPoolInput) (req *request.Request, output *DeleteIdentityPoolOutput) {
	op := &request.Operation{
		Name:       opDeleteIdentityPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIdentityPoolInput{}
	}

	output = &DeleteIdentityPoolOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIdentityPool API operation for Amazon Cognito Identity.
//
// Deletes a user pool. Once a pool is deleted, users will not be able to authenticate
// with the pool.
//
// You must use AWS Developer credentials to call this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity's
// API operation DeleteIdentityPool for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   Thrown for missing or bad input parameter(s).
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Thrown when the requested resource (for example, a dataset or record) does
//   not exist.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   Thrown when a user is not authorized to access the requested resource.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Thrown when a request is throttled.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   Thrown when the service encounters an error during processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/DeleteIdentityPool
func (c *CognitoIdentity) DeleteIdentityPool(input *DeleteIdentityPoolInput) (*DeleteIdentityPoolOutput, error) {
	req, out := c.DeleteIdentityPoolRequest(input)
	return out, req.Send()
}

// DeleteIdentityPoolWithContext is the same as DeleteIdentityPool with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIdentityPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentity) DeleteIdentityPoolWithContext(ctx aws.Context, input *DeleteIdentityPoolInput, opts ...request.Option) (*DeleteIdentityPoolOutput, error) {
	req, out := c.DeleteIdentityPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIdentity = "DescribeIdentity"

// DescribeIdentityRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIdentity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIdentity for more information on using the DescribeIdentity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeIdentityRequest method.
//    req, resp := client.DescribeIdentityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/DescribeIdentity
func (c *CognitoIdentity) DescribeIdentityRequest(input *DescribeIdentityInput) (req *request.Request, output *IdentityDescription) {
	op := &request.Operation{
		Name:       opDescribeIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeIdentityInput{}
	}

	output = &IdentityDescription{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIdentity API operation for Amazon Cognito Identity.
//
// Returns metadata related to the given identity, including when the identity
// was created and any associated linked logins.
//
// You must use AWS Developer credentials to call this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity's
// API operation DescribeIdentity for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   Thrown for missing or bad input parameter(s).
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Thrown when the requested resource (for example, a dataset or record) does
//   not exist.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   Thrown when a user is not authorized to access the requested resource.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Thrown when a request is throttled.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   Thrown when the service encounters an error during processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/DescribeIdentity
func (c *CognitoIdentity) DescribeIdentity(input *DescribeIdentityInput) (*IdentityDescription, error) {
	req, out := c.DescribeIdentityRequest(input)
	return out, req.Send()
}

// DescribeIdentityWithContext is the same as DescribeIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentity) DescribeIdentityWithContext(ctx aws.Context, input *DescribeIdentityInput, opts ...request.Option) (*IdentityDescription, error) {
	req, out := c.DescribeIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIdentityPool = "DescribeIdentityPool"

// DescribeIdentityPoolRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIdentityPool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIdentityPool for more information on using the DescribeIdentityPool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeIdentityPoolRequest method.
//    req, resp := client.DescribeIdentityPoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/DescribeIdentityPool
func (c *CognitoIdentity) DescribeIdentityPoolRequest(input *DescribeIdentityPoolInput) (req *request.Request, output *IdentityPool) {
	op := &request.Operation{
		Name:       opDescribeIdentityPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeIdentityPoolInput{}
	}

	output = &IdentityPool{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIdentityPool API operation for Amazon Cognito Identity.
//
// Gets details about a particular identity pool, including the pool name, ID
// description, creation date, and current number of users.
//
// You must use AWS Developer credentials to call this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity's
// API operation DescribeIdentityPool for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   Thrown for missing or bad input parameter(s).
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Thrown when the requested resource (for example, a dataset or record) does
//   not exist.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   Thrown when a user is not authorized to access the requested resource.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Thrown when a request is throttled.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   Thrown when the service encounters an error during processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/DescribeIdentityPool
func (c *CognitoIdentity) DescribeIdentityPool(input *DescribeIdentityPoolInput) (*IdentityPool, error) {
	req, out := c.DescribeIdentityPoolRequest(input)
	return out, req.Send()
}

// DescribeIdentityPoolWithContext is the same as DescribeIdentityPool with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIdentityPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentity) DescribeIdentityPoolWithContext(ctx aws.Context, input *DescribeIdentityPoolInput, opts ...request.Option) (*IdentityPool, error) {
	req, out := c.DescribeIdentityPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCredentialsForIdentity = "GetCredentialsForIdentity"

// GetCredentialsForIdentityRequest generates a "aws/request.Request" representing the
// client's request for the GetCredentialsForIdentity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCredentialsForIdentity for more information on using the GetCredentialsForIdentity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCredentialsForIdentityRequest method.
//    req, resp := client.GetCredentialsForIdentityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/GetCredentialsForIdentity
func (c *CognitoIdentity) GetCredentialsForIdentityRequest(input *GetCredentialsForIdentityInput) (req *request.Request, output *GetCredentialsForIdentityOutput) {
	op := &request.Operation{
		Name:       opGetCredentialsForIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCredentialsForIdentityInput{}
	}

	output = &GetCredentialsForIdentityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCredentialsForIdentity API operation for Amazon Cognito Identity.
//
// Returns credentials for the provided identity ID. Any provided logins will
// be validated against supported login providers. If the token is for cognito-identity.amazonaws.com,
// it will be passed through to AWS Security Token Service with the appropriate
// role for the token.
//
// This is a public API. You do not need any credentials to call this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity's
// API operation GetCredentialsForIdentity for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   Thrown for missing or bad input parameter(s).
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Thrown when the requested resource (for example, a dataset or record) does
//   not exist.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   Thrown when a user is not authorized to access the requested resource.
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//   Thrown when a user tries to use a login which is already linked to another
//   account.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Thrown when a request is throttled.
//
//   * ErrCodeInvalidIdentityPoolConfigurationException "InvalidIdentityPoolConfigurationException"
//   Thrown if the identity pool has no role associated for the given auth type
//   (auth/unauth) or if the AssumeRole fails.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   Thrown when the service encounters an error during processing the request.
//
//   * ErrCodeExternalServiceException "ExternalServiceException"
//   An exception thrown when a dependent service such as Facebook or Twitter
//   is not responding
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/GetCredentialsForIdentity
func (c *CognitoIdentity) GetCredentialsForIdentity(input *GetCredentialsForIdentityInput) (*GetCredentialsForIdentityOutput, error) {
	req, out := c.GetCredentialsForIdentityRequest(input)
	return out, req.Send()
}

// GetCredentialsForIdentityWithContext is the same as GetCredentialsForIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See GetCredentialsForIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentity) GetCredentialsForIdentityWithContext(ctx aws.Context, input *GetCredentialsForIdentityInput, opts ...request.Option) (*GetCredentialsForIdentityOutput, error) {
	req, out := c.GetCredentialsForIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetId = "GetId"

// GetIdRequest generates a "aws/request.Request" representing the
// client's request for the GetId operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetId for more information on using the GetId
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetIdRequest method.
//    req, resp := client.GetIdRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/GetId
func (c *CognitoIdentity) GetIdRequest(input *GetIdInput) (req *request.Request, output *GetIdOutput) {
	op := &request.Operation{
		Name:       opGetId,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIdInput{}
	}

	output = &GetIdOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetId API operation for Amazon Cognito Identity.
//
// Generates (or retrieves) a Cognito ID. Supplying multiple logins will create
// an implicit linked account.
//
// This is a public API. You do not need any credentials to call this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity's
// API operation GetId for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   Thrown for missing or bad input parameter(s).
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Thrown when the requested resource (for example, a dataset or record) does
//   not exist.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   Thrown when a user is not authorized to access the requested resource.
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//   Thrown when a user tries to use a login which is already linked to another
//   account.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Thrown when a request is throttled.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   Thrown when the service encounters an error during processing the request.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Thrown when the total number of user pools has exceeded a preset limit.
//
//   * ErrCodeExternalServiceException "ExternalServiceException"
//   An exception thrown when a dependent service such as Facebook or Twitter
//   is not responding
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/GetId
func (c *CognitoIdentity) GetId(input *GetIdInput) (*GetIdOutput, error) {
	req, out := c.GetIdRequest(input)
	return out, req.Send()
}

// GetIdWithContext is the same as GetId with the addition of
// the ability to pass a context and additional request options.
//
// See GetId for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentity) GetIdWithContext(ctx aws.Context, input *GetIdInput, opts ...request.Option) (*GetIdOutput, error) {
	req, out := c.GetIdRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIdentityPoolRoles = "GetIdentityPoolRoles"

// GetIdentityPoolRolesRequest generates a "aws/request.Request" representing the
// client's request for the GetIdentityPoolRoles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIdentityPoolRoles for more information on using the GetIdentityPoolRoles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetIdentityPoolRolesRequest method.
//    req, resp := client.GetIdentityPoolRolesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/GetIdentityPoolRoles
func (c *CognitoIdentity) GetIdentityPoolRolesRequest(input *GetIdentityPoolRolesInput) (req *request.Request, output *GetIdentityPoolRolesOutput) {
	op := &request.Operation{
		Name:       opGetIdentityPoolRoles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIdentityPoolRolesInput{}
	}

	output = &GetIdentityPoolRolesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIdentityPoolRoles API operation for Amazon Cognito Identity.
//
// Gets the roles for an identity pool.
//
// You must use AWS Developer credentials to call this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity's
// API operation GetIdentityPoolRoles for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   Thrown for missing or bad input parameter(s).
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Thrown when the requested resource (for example, a dataset or record) does
//   not exist.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   Thrown when a user is not authorized to access the requested resource.
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//   Thrown when a user tries to use a login which is already linked to another
//   account.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Thrown when a request is throttled.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   Thrown when the service encounters an error during processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/GetIdentityPoolRoles
func (c *CognitoIdentity) GetIdentityPoolRoles(input *GetIdentityPoolRolesInput) (*GetIdentityPoolRolesOutput, error) {
	req, out := c.GetIdentityPoolRolesRequest(input)
	return out, req.Send()
}

// GetIdentityPoolRolesWithContext is the same as GetIdentityPoolRoles with the addition of
// the ability to pass a context and additional request options.
//
// See GetIdentityPoolRoles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentity) GetIdentityPoolRolesWithContext(ctx aws.Context, input *GetIdentityPoolRolesInput, opts ...request.Option) (*GetIdentityPoolRolesOutput, error) {
	req, out := c.GetIdentityPoolRolesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOpenIdToken = "GetOpenIdToken"

// GetOpenIdTokenRequest generates a "aws/request.Request" representing the
// client's request for the GetOpenIdToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOpenIdToken for more information on using the GetOpenIdToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetOpenIdTokenRequest method.
//    req, resp := client.GetOpenIdTokenRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/GetOpenIdToken
func (c *CognitoIdentity) GetOpenIdTokenRequest(input *GetOpenIdTokenInput) (req *request.Request, output *GetOpenIdTokenOutput) {
	op := &request.Operation{
		Name:       opGetOpenIdToken,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOpenIdTokenInput{}
	}

	output = &GetOpenIdTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOpenIdToken API operation for Amazon Cognito Identity.
//
// Gets an OpenID token, using a known Cognito ID. This known Cognito ID is
// returned by GetId. You can optionally add additional logins for the identity.
// Supplying multiple logins creates an implicit link.
//
// The OpenId token is valid for 15 minutes.
//
// This is a public API. You do not need any credentials to call this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity's
// API operation GetOpenIdToken for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   Thrown for missing or bad input parameter(s).
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Thrown when the requested resource (for example, a dataset or record) does
//   not exist.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   Thrown when a user is not authorized to access the requested resource.
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//   Thrown when a user tries to use a login which is already linked to another
//   account.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Thrown when a request is throttled.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   Thrown when the service encounters an error during processing the request.
//
//   * ErrCodeExternalServiceException "ExternalServiceException"
//   An exception thrown when a dependent service such as Facebook or Twitter
//   is not responding
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/GetOpenIdToken
func (c *CognitoIdentity) GetOpenIdToken(input *GetOpenIdTokenInput) (*GetOpenIdTokenOutput, error) {
	req, out := c.GetOpenIdTokenRequest(input)
	return out, req.Send()
}

// GetOpenIdTokenWithContext is the same as GetOpenIdToken with the addition of
// the ability to pass a context and additional request options.
//
// See GetOpenIdToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentity) GetOpenIdTokenWithContext(ctx aws.Context, input *GetOpenIdTokenInput, opts ...request.Option) (*GetOpenIdTokenOutput, error) {
	req, out := c.GetOpenIdTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOpenIdTokenForDeveloperIdentity = "GetOpenIdTokenForDeveloperIdentity"

// GetOpenIdTokenForDeveloperIdentityRequest generates a "aws/request.Request" representing the
// client's request for the GetOpenIdTokenForDeveloperIdentity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOpenIdTokenForDeveloperIdentity for more information on using the GetOpenIdTokenForDeveloperIdentity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetOpenIdTokenForDeveloperIdentityRequest method.
//    req, resp := client.GetOpenIdTokenForDeveloperIdentityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/GetOpenIdTokenForDeveloperIdentity
func (c *CognitoIdentity) GetOpenIdTokenForDeveloperIdentityRequest(input *GetOpenIdTokenForDeveloperIdentityInput) (req *request.Request, output *GetOpenIdTokenForDeveloperIdentityOutput) {
	op := &request.Operation{
		Name:       opGetOpenIdTokenForDeveloperIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOpenIdTokenForDeveloperIdentityInput{}
	}

	output = &GetOpenIdTokenForDeveloperIdentityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOpenIdTokenForDeveloperIdentity API operation for Amazon Cognito Identity.
//
// Registers (or retrieves) a Cognito IdentityId and an OpenID Connect token
// for a user authenticated by your backend authentication process. Supplying
// multiple logins will create an implicit linked account. You can only specify
// one developer provider as part of the Logins map, which is linked to the
// identity pool. The developer provider is the "domain" by which Cognito will
// refer to your users.
//
// You can use GetOpenIdTokenForDeveloperIdentity to create a new identity and
// to link new logins (that is, user credentials issued by a public provider
// or developer provider) to an existing identity. When you want to create a
// new identity, the IdentityId should be null. When you want to associate a
// new login with an existing authenticated/unauthenticated identity, you can
// do so by providing the existing IdentityId. This API will create the identity
// in the specified IdentityPoolId.
//
// You must use AWS Developer credentials to call this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity's
// API operation GetOpenIdTokenForDeveloperIdentity for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   Thrown for missing or bad input parameter(s).
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Thrown when the requested resource (for example, a dataset or record) does
//   not exist.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   Thrown when a user is not authorized to access the requested resource.
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//   Thrown when a user tries to use a login which is already linked to another
//   account.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Thrown when a request is throttled.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   Thrown when the service encounters an error during processing the request.
//
//   * ErrCodeDeveloperUserAlreadyRegisteredException "DeveloperUserAlreadyRegisteredException"
//   The provided developer user identifier is already registered with Cognito
//   under a different identity ID.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/GetOpenIdTokenForDeveloperIdentity
func (c *CognitoIdentity) GetOpenIdTokenForDeveloperIdentity(input *GetOpenIdTokenForDeveloperIdentityInput) (*GetOpenIdTokenForDeveloperIdentityOutput, error) {
	req, out := c.GetOpenIdTokenForDeveloperIdentityRequest(input)
	return out, req.Send()
}

// GetOpenIdTokenForDeveloperIdentityWithContext is the same as GetOpenIdTokenForDeveloperIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See GetOpenIdTokenForDeveloperIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentity) GetOpenIdTokenForDeveloperIdentityWithContext(ctx aws.Context, input *GetOpenIdTokenForDeveloperIdentityInput, opts ...request.Option) (*GetOpenIdTokenForDeveloperIdentityOutput, error) {
	req, out := c.GetOpenIdTokenForDeveloperIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIdentities = "ListIdentities"

// ListIdentitiesRequest generates a "aws/request.Request" representing the
// client's request for the ListIdentities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIdentities for more information on using the ListIdentities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListIdentitiesRequest method.
//    req, resp := client.ListIdentitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/ListIdentities
func (c *CognitoIdentity) ListIdentitiesRequest(input *ListIdentitiesInput) (req *request.Request, output *ListIdentitiesOutput) {
	op := &request.Operation{
		Name:       opListIdentities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListIdentitiesInput{}
	}

	output = &ListIdentitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIdentities API operation for Amazon Cognito Identity.
//
// Lists the identities in a pool.
//
// You must use AWS Developer credentials to call this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity's
// API operation ListIdentities for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   Thrown for missing or bad input parameter(s).
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Thrown when the requested resource (for example, a dataset or record) does
//   not exist.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   Thrown when a user is not authorized to access the requested resource.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Thrown when a request is throttled.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   Thrown when the service encounters an error during processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/ListIdentities
func (c *CognitoIdentity) ListIdentities(input *ListIdentitiesInput) (*ListIdentitiesOutput, error) {
	req, out := c.ListIdentitiesRequest(input)
	return out, req.Send()
}

// ListIdentitiesWithContext is the same as ListIdentities with the addition of
// the ability to pass a context and additional request options.
//
// See ListIdentities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentity) ListIdentitiesWithContext(ctx aws.Context, input *ListIdentitiesInput, opts ...request.Option) (*ListIdentitiesOutput, error) {
	req, out := c.ListIdentitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIdentityPools = "ListIdentityPools"

// ListIdentityPoolsRequest generates a "aws/request.Request" representing the
// client's request for the ListIdentityPools operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIdentityPools for more information on using the ListIdentityPools
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListIdentityPoolsRequest method.
//    req, resp := client.ListIdentityPoolsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/ListIdentityPools
func (c *CognitoIdentity) ListIdentityPoolsRequest(input *ListIdentityPoolsInput) (req *request.Request, output *ListIdentityPoolsOutput) {
	op := &request.Operation{
		Name:       opListIdentityPools,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListIdentityPoolsInput{}
	}

	output = &ListIdentityPoolsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIdentityPools API operation for Amazon Cognito Identity.
//
// Lists all of the Cognito identity pools registered for your account.
//
// You must use AWS Developer credentials to call this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity's
// API operation ListIdentityPools for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   Thrown for missing or bad input parameter(s).
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   Thrown when a user is not authorized to access the requested resource.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Thrown when a request is throttled.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   Thrown when the service encounters an error during processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/ListIdentityPools
func (c *CognitoIdentity) ListIdentityPools(input *ListIdentityPoolsInput) (*ListIdentityPoolsOutput, error) {
	req, out := c.ListIdentityPoolsRequest(input)
	return out, req.Send()
}

// ListIdentityPoolsWithContext is the same as ListIdentityPools with the addition of
// the ability to pass a context and additional request options.
//
// See ListIdentityPools for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentity) ListIdentityPoolsWithContext(ctx aws.Context, input *ListIdentityPoolsInput, opts ...request.Option) (*ListIdentityPoolsOutput, error) {
	req, out := c.ListIdentityPoolsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opLookupDeveloperIdentity = "LookupDeveloperIdentity"

// LookupDeveloperIdentityRequest generates a "aws/request.Request" representing the
// client's request for the LookupDeveloperIdentity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See LookupDeveloperIdentity for more information on using the LookupDeveloperIdentity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the LookupDeveloperIdentityRequest method.
//    req, resp := client.LookupDeveloperIdentityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/LookupDeveloperIdentity
func (c *CognitoIdentity) LookupDeveloperIdentityRequest(input *LookupDeveloperIdentityInput) (req *request.Request, output *LookupDeveloperIdentityOutput) {
	op := &request.Operation{
		Name:       opLookupDeveloperIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &LookupDeveloperIdentityInput{}
	}

	output = &LookupDeveloperIdentityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// LookupDeveloperIdentity API operation for Amazon Cognito Identity.
//
// Retrieves the IdentityID associated with a DeveloperUserIdentifier or the
// list of DeveloperUserIdentifiers associated with an IdentityId for an existing
// identity. Either IdentityID or DeveloperUserIdentifier must not be null.
// If you supply only one of these values, the other value will be searched
// in the database and returned as a part of the response. If you supply both,
// DeveloperUserIdentifier will be matched against IdentityID. If the values
// are verified against the database, the response returns both values and is
// the same as the request. Otherwise a ResourceConflictException is thrown.
//
// You must use AWS Developer credentials to call this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity's
// API operation LookupDeveloperIdentity for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   Thrown for missing or bad input parameter(s).
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Thrown when the requested resource (for example, a dataset or record) does
//   not exist.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   Thrown when a user is not authorized to access the requested resource.
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//   Thrown when a user tries to use a login which is already linked to another
//   account.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Thrown when a request is throttled.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   Thrown when the service encounters an error during processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/LookupDeveloperIdentity
func (c *CognitoIdentity) LookupDeveloperIdentity(input *LookupDeveloperIdentityInput) (*LookupDeveloperIdentityOutput, error) {
	req, out := c.LookupDeveloperIdentityRequest(input)
	return out, req.Send()
}

// LookupDeveloperIdentityWithContext is the same as LookupDeveloperIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See LookupDeveloperIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentity) LookupDeveloperIdentityWithContext(ctx aws.Context, input *LookupDeveloperIdentityInput, opts ...request.Option) (*LookupDeveloperIdentityOutput, error) {
	req, out := c.LookupDeveloperIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opMergeDeveloperIdentities = "MergeDeveloperIdentities"

// MergeDeveloperIdentitiesRequest generates a "aws/request.Request" representing the
// client's request for the MergeDeveloperIdentities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See MergeDeveloperIdentities for more information on using the MergeDeveloperIdentities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the MergeDeveloperIdentitiesRequest method.
//    req, resp := client.MergeDeveloperIdentitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/MergeDeveloperIdentities
func (c *CognitoIdentity) MergeDeveloperIdentitiesRequest(input *MergeDeveloperIdentitiesInput) (req *request.Request, output *MergeDeveloperIdentitiesOutput) {
	op := &request.Operation{
		Name:       opMergeDeveloperIdentities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &MergeDeveloperIdentitiesInput{}
	}

	output = &MergeDeveloperIdentitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// MergeDeveloperIdentities API operation for Amazon Cognito Identity.
//
// Merges two users having different IdentityIds, existing in the same identity
// pool, and identified by the same developer provider. You can use this action
// to request that discrete users be merged and identified as a single user
// in the Cognito environment. Cognito associates the given source user (SourceUserIdentifier)
// with the IdentityId of the DestinationUserIdentifier. Only developer-authenticated
// users can be merged. If the users to be merged are associated with the same
// public provider, but as two different users, an exception will be thrown.
//
// You must use AWS Developer credentials to call this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity's
// API operation MergeDeveloperIdentities for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   Thrown for missing or bad input parameter(s).
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Thrown when the requested resource (for example, a dataset or record) does
//   not exist.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   Thrown when a user is not authorized to access the requested resource.
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//   Thrown when a user tries to use a login which is already linked to another
//   account.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Thrown when a request is throttled.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   Thrown when the service encounters an error during processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/MergeDeveloperIdentities
func (c *CognitoIdentity) MergeDeveloperIdentities(input *MergeDeveloperIdentitiesInput) (*MergeDeveloperIdentitiesOutput, error) {
	req, out := c.MergeDeveloperIdentitiesRequest(input)
	return out, req.Send()
}

// MergeDeveloperIdentitiesWithContext is the same as MergeDeveloperIdentities with the addition of
// the ability to pass a context and additional request options.
//
// See MergeDeveloperIdentities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentity) MergeDeveloperIdentitiesWithContext(ctx aws.Context, input *MergeDeveloperIdentitiesInput, opts ...request.Option) (*MergeDeveloperIdentitiesOutput, error) {
	req, out := c.MergeDeveloperIdentitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetIdentityPoolRoles = "SetIdentityPoolRoles"

// SetIdentityPoolRolesRequest generates a "aws/request.Request" representing the
// client's request for the SetIdentityPoolRoles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetIdentityPoolRoles for more information on using the SetIdentityPoolRoles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetIdentityPoolRolesRequest method.
//    req, resp := client.SetIdentityPoolRolesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/SetIdentityPoolRoles
func (c *CognitoIdentity) SetIdentityPoolRolesRequest(input *SetIdentityPoolRolesInput) (req *request.Request, output *SetIdentityPoolRolesOutput) {
	op := &request.Operation{
		Name:       opSetIdentityPoolRoles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetIdentityPoolRolesInput{}
	}

	output = &SetIdentityPoolRolesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetIdentityPoolRoles API operation for Amazon Cognito Identity.
//
// Sets the roles for an identity pool. These roles are used when making calls
// to GetCredentialsForIdentity action.
//
// You must use AWS Developer credentials to call this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity's
// API operation SetIdentityPoolRoles for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   Thrown for missing or bad input parameter(s).
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Thrown when the requested resource (for example, a dataset or record) does
//   not exist.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   Thrown when a user is not authorized to access the requested resource.
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//   Thrown when a user tries to use a login which is already linked to another
//   account.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Thrown when a request is throttled.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   Thrown when the service encounters an error during processing the request.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Thrown if there are parallel requests to modify a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/SetIdentityPoolRoles
func (c *CognitoIdentity) SetIdentityPoolRoles(input *SetIdentityPoolRolesInput) (*SetIdentityPoolRolesOutput, error) {
	req, out := c.SetIdentityPoolRolesRequest(input)
	return out, req.Send()
}

// SetIdentityPoolRolesWithContext is the same as SetIdentityPoolRoles with the addition of
// the ability to pass a context and additional request options.
//
// See SetIdentityPoolRoles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentity) SetIdentityPoolRolesWithContext(ctx aws.Context, input *SetIdentityPoolRolesInput, opts ...request.Option) (*SetIdentityPoolRolesOutput, error) {
	req, out := c.SetIdentityPoolRolesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUnlinkDeveloperIdentity = "UnlinkDeveloperIdentity"

// UnlinkDeveloperIdentityRequest generates a "aws/request.Request" representing the
// client's request for the UnlinkDeveloperIdentity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UnlinkDeveloperIdentity for more information on using the UnlinkDeveloperIdentity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UnlinkDeveloperIdentityRequest method.
//    req, resp := client.UnlinkDeveloperIdentityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/UnlinkDeveloperIdentity
func (c *CognitoIdentity) UnlinkDeveloperIdentityRequest(input *UnlinkDeveloperIdentityInput) (req *request.Request, output *UnlinkDeveloperIdentityOutput) {
	op := &request.Operation{
		Name:       opUnlinkDeveloperIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UnlinkDeveloperIdentityInput{}
	}

	output = &UnlinkDeveloperIdentityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UnlinkDeveloperIdentity API operation for Amazon Cognito Identity.
//
// Unlinks a DeveloperUserIdentifier from an existing identity. Unlinked developer
// users will be considered new identities next time they are seen. If, for
// a given Cognito identity, you remove all federated identities as well as
// the developer user identifier, the Cognito identity becomes inaccessible.
//
// You must use AWS Developer credentials to call this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity's
// API operation UnlinkDeveloperIdentity for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   Thrown for missing or bad input parameter(s).
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Thrown when the requested resource (for example, a dataset or record) does
//   not exist.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   Thrown when a user is not authorized to access the requested resource.
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//   Thrown when a user tries to use a login which is already linked to another
//   account.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Thrown when a request is throttled.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   Thrown when the service encounters an error during processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/UnlinkDeveloperIdentity
func (c *CognitoIdentity) UnlinkDeveloperIdentity(input *UnlinkDeveloperIdentityInput) (*UnlinkDeveloperIdentityOutput, error) {
	req, out := c.UnlinkDeveloperIdentityRequest(input)
	return out, req.Send()
}

// UnlinkDeveloperIdentityWithContext is the same as UnlinkDeveloperIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See UnlinkDeveloperIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentity) UnlinkDeveloperIdentityWithContext(ctx aws.Context, input *UnlinkDeveloperIdentityInput, opts ...request.Option) (*UnlinkDeveloperIdentityOutput, error) {
	req, out := c.UnlinkDeveloperIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUnlinkIdentity = "UnlinkIdentity"

// UnlinkIdentityRequest generates a "aws/request.Request" representing the
// client's request for the UnlinkIdentity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UnlinkIdentity for more information on using the UnlinkIdentity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UnlinkIdentityRequest method.
//    req, resp := client.UnlinkIdentityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/UnlinkIdentity
func (c *CognitoIdentity) UnlinkIdentityRequest(input *UnlinkIdentityInput) (req *request.Request, output *UnlinkIdentityOutput) {
	op := &request.Operation{
		Name:       opUnlinkIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UnlinkIdentityInput{}
	}

	output = &UnlinkIdentityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UnlinkIdentity API operation for Amazon Cognito Identity.
//
// Unlinks a federated identity from an existing account. Unlinked logins will
// be considered new identities next time they are seen. Removing the last linked
// login will make this identity inaccessible.
//
// This is a public API. You do not need any credentials to call this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity's
// API operation UnlinkIdentity for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   Thrown for missing or bad input parameter(s).
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Thrown when the requested resource (for example, a dataset or record) does
//   not exist.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   Thrown when a user is not authorized to access the requested resource.
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//   Thrown when a user tries to use a login which is already linked to another
//   account.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Thrown when a request is throttled.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   Thrown when the service encounters an error during processing the request.
//
//   * ErrCodeExternalServiceException "ExternalServiceException"
//   An exception thrown when a dependent service such as Facebook or Twitter
//   is not responding
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/UnlinkIdentity
func (c *CognitoIdentity) UnlinkIdentity(input *UnlinkIdentityInput) (*UnlinkIdentityOutput, error) {
	req, out := c.UnlinkIdentityRequest(input)
	return out, req.Send()
}

// UnlinkIdentityWithContext is the same as UnlinkIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See UnlinkIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentity) UnlinkIdentityWithContext(ctx aws.Context, input *UnlinkIdentityInput, opts ...request.Option) (*UnlinkIdentityOutput, error) {
	req, out := c.UnlinkIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIdentityPool = "UpdateIdentityPool"

// UpdateIdentityPoolRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIdentityPool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIdentityPool for more information on using the UpdateIdentityPool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateIdentityPoolRequest method.
//    req, resp := client.UpdateIdentityPoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/UpdateIdentityPool
func (c *CognitoIdentity) UpdateIdentityPoolRequest(input *IdentityPool) (req *request.Request, output *IdentityPool) {
	op := &request.Operation{
		Name:       opUpdateIdentityPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &IdentityPool{}
	}

	output = &IdentityPool{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIdentityPool API operation for Amazon Cognito Identity.
//
// Updates a user pool.
//
// You must use AWS Developer credentials to call this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity's
// API operation UpdateIdentityPool for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   Thrown for missing or bad input parameter(s).
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Thrown when the requested resource (for example, a dataset or record) does
//   not exist.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   Thrown when a user is not authorized to access the requested resource.
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//   Thrown when a user tries to use a login which is already linked to another
//   account.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Thrown when a request is throttled.
//
//   * ErrCodeInternalErrorException "InternalErrorException"
//   Thrown when the service encounters an error during processing the request.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Thrown if there are parallel requests to modify a resource.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Thrown when the total number of user pools has exceeded a preset limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/UpdateIdentityPool
func (c *CognitoIdentity) UpdateIdentityPool(input *IdentityPool) (*IdentityPool, error) {
	req, out := c.UpdateIdentityPoolRequest(input)
	return out, req.Send()
}

// UpdateIdentityPoolWithContext is the same as UpdateIdentityPool with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIdentityPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CognitoIdentity) UpdateIdentityPoolWithContext(ctx aws.Context, input *IdentityPool, opts ...request.Option) (*IdentityPool, error) {
	req, out := c.UpdateIdentityPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Input to the CreateIdentityPool action.
type CreateIdentityPoolInput struct {
	_ struct{} `type:"structure"`

	// TRUE if the identity pool supports unauthenticated logins.
	//
	// AllowUnauthenticatedIdentities is a required field
	AllowUnauthenticatedIdentities *bool `type:"boolean" required:"true"`

	// An array of Amazon Cognito Identity user pools and their client IDs.
	CognitoIdentityProviders []*Provider `type:"list"`

	// The "domain" by which Cognito will refer to your users. This name acts as
	// a placeholder that allows your backend and the Cognito service to communicate
	// about the developer provider. For the DeveloperProviderName, you can use
	// letters as well as period (.), underscore (_), and dash (-).
	//
	// Once you have set a developer provider name, you cannot change it. Please
	// take care in setting this parameter.
	DeveloperProviderName *string `min:"1" type:"string"`

	// A string that you provide.
	//
	// IdentityPoolName is a required field
	IdentityPoolName *string `min:"1" type:"string" required:"true"`

	// A list of OpendID Connect provider ARNs.
	OpenIdConnectProviderARNs []*string `type:"list"`

	// An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
	// pool.
	SamlProviderARNs []*string `type:"list"`

	// Optional key:value pairs mapping provider names to provider app IDs.
	SupportedLoginProviders map[string]*string `type:"map"`
}

// String returns the string representation
func (s CreateIdentityPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIdentityPoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIdentityPoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIdentityPoolInput"}
	if s.AllowUnauthenticatedIdentities == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowUnauthenticatedIdentities"))
	}
	if s.DeveloperProviderName != nil && len(*s.DeveloperProviderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeveloperProviderName", 1))
	}
	if s.IdentityPoolName == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolName"))
	}
	if s.IdentityPoolName != nil && len(*s.IdentityPoolName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolName", 1))
	}
	if s.CognitoIdentityProviders != nil {
		for i, v := range s.CognitoIdentityProviders {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CognitoIdentityProviders", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowUnauthenticatedIdentities sets the AllowUnauthenticatedIdentities field's value.
func (s *CreateIdentityPoolInput) SetAllowUnauthenticatedIdentities(v bool) *CreateIdentityPoolInput {
	s.AllowUnauthenticatedIdentities = &v
	return s
}

// SetCognitoIdentityProviders sets the CognitoIdentityProviders field's value.
func (s *CreateIdentityPoolInput) SetCognitoIdentityProviders(v []*Provider) *CreateIdentityPoolInput {
	s.CognitoIdentityProviders = v
	return s
}

// SetDeveloperProviderName sets the DeveloperProviderName field's value.
func (s *CreateIdentityPoolInput) SetDeveloperProviderName(v string) *CreateIdentityPoolInput {
	s.DeveloperProviderName = &v
	return s
}

// SetIdentityPoolName sets the IdentityPoolName field's value.
func (s *CreateIdentityPoolInput) SetIdentityPoolName(v string) *CreateIdentityPoolInput {
	s.IdentityPoolName = &v
	return s
}

// SetOpenIdConnectProviderARNs sets the OpenIdConnectProviderARNs field's value.
func (s *CreateIdentityPoolInput) SetOpenIdConnectProviderARNs(v []*string) *CreateIdentityPoolInput {
	s.OpenIdConnectProviderARNs = v
	return s
}

// SetSamlProviderARNs sets the SamlProviderARNs field's value.
func (s *CreateIdentityPoolInput) SetSamlProviderARNs(v []*string) *CreateIdentityPoolInput {
	s.SamlProviderARNs = v
	return s
}

// SetSupportedLoginProviders sets the SupportedLoginProviders field's value.
func (s *CreateIdentityPoolInput) SetSupportedLoginProviders(v map[string]*string) *CreateIdentityPoolInput {
	s.SupportedLoginProviders = v
	return s
}

// Credentials for the provided identity ID.
type Credentials struct {
	_ struct{} `type:"structure"`

	// The Access Key portion of the credentials.
	AccessKeyId *string `type:"string"`

	// The date at which these credentials will expire.
	Expiration *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Secret Access Key portion of the credentials
	SecretKey *string `type:"string"`

	// The Session Token portion of the credentials
	SessionToken *string `type:"string"`
}

// String returns the string representation
func (s Credentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Credentials) GoString() string {
	return s.String()
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *Credentials) SetAccessKeyId(v string) *Credentials {
	s.AccessKeyId = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *Credentials) SetExpiration(v time.Time) *Credentials {
	s.Expiration = &v
	return s
}

// SetSecretKey sets the SecretKey field's value.
func (s *Credentials) SetSecretKey(v string) *Credentials {
	s.SecretKey = &v
	return s
}

// SetSessionToken sets the SessionToken field's value.
func (s *Credentials) SetSessionToken(v string) *Credentials {
	s.SessionToken = &v
	return s
}

// Input to the DeleteIdentities action.
type DeleteIdentitiesInput struct {
	_ struct{} `type:"structure"`

	// A list of 1-60 identities that you want to delete.
	//
	// IdentityIdsToDelete is a required field
	IdentityIdsToDelete []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteIdentitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIdentitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIdentitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIdentitiesInput"}
	if s.IdentityIdsToDelete == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityIdsToDelete"))
	}
	if s.IdentityIdsToDelete != nil && len(s.IdentityIdsToDelete) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityIdsToDelete", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityIdsToDelete sets the IdentityIdsToDelete field's value.
func (s *DeleteIdentitiesInput) SetIdentityIdsToDelete(v []*string) *DeleteIdentitiesInput {
	s.IdentityIdsToDelete = v
	return s
}

// Returned in response to a successful DeleteIdentities operation.
type DeleteIdentitiesOutput struct {
	_ struct{} `type:"structure"`

	// An array of UnprocessedIdentityId objects, each of which contains an ErrorCode
	// and IdentityId.
	UnprocessedIdentityIds []*UnprocessedIdentityId `type:"list"`
}

// String returns the string representation
func (s DeleteIdentitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIdentitiesOutput) GoString() string {
	return s.String()
}

// SetUnprocessedIdentityIds sets the UnprocessedIdentityIds field's value.
func (s *DeleteIdentitiesOutput) SetUnprocessedIdentityIds(v []*UnprocessedIdentityId) *DeleteIdentitiesOutput {
	s.UnprocessedIdentityIds = v
	return s
}

// Input to the DeleteIdentityPool action.
type DeleteIdentityPoolInput struct {
	_ struct{} `type:"structure"`

	// An identity pool ID in the format REGION:GUID.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteIdentityPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIdentityPoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIdentityPoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIdentityPoolInput"}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *DeleteIdentityPoolInput) SetIdentityPoolId(v string) *DeleteIdentityPoolInput {
	s.IdentityPoolId = &v
	return s
}

type DeleteIdentityPoolOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteIdentityPoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIdentityPoolOutput) GoString() string {
	return s.String()
}

// Input to the DescribeIdentity action.
type DescribeIdentityInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier in the format REGION:GUID.
	//
	// IdentityId is a required field
	IdentityId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeIdentityInput"}
	if s.IdentityId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityId"))
	}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityId sets the IdentityId field's value.
func (s *DescribeIdentityInput) SetIdentityId(v string) *DescribeIdentityInput {
	s.IdentityId = &v
	return s
}

// Input to the DescribeIdentityPool action.
type DescribeIdentityPoolInput struct {
	_ struct{} `type:"structure"`

	// An identity pool ID in the format REGION:GUID.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeIdentityPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIdentityPoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIdentityPoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeIdentityPoolInput"}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *DescribeIdentityPoolInput) SetIdentityPoolId(v string) *DescribeIdentityPoolInput {
	s.IdentityPoolId = &v
	return s
}

// Input to the GetCredentialsForIdentity action.
type GetCredentialsForIdentityInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the role to be assumed when multiple roles
	// were received in the token from the identity provider. For example, a SAML-based
	// identity provider. This parameter is optional for identity providers that
	// do not support role customization.
	CustomRoleArn *string `min:"20" type:"string"`

	// A unique identifier in the format REGION:GUID.
	//
	// IdentityId is a required field
	IdentityId *string `min:"1" type:"string" required:"true"`

	// A set of optional name-value pairs that map provider names to provider tokens.
	Logins map[string]*string `type:"map"`
}

// String returns the string representation
func (s GetCredentialsForIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCredentialsForIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCredentialsForIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCredentialsForIdentityInput"}
	if s.CustomRoleArn != nil && len(*s.CustomRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CustomRoleArn", 20))
	}
	if s.IdentityId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityId"))
	}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomRoleArn sets the CustomRoleArn field's value.
func (s *GetCredentialsForIdentityInput) SetCustomRoleArn(v string) *GetCredentialsForIdentityInput {
	s.CustomRoleArn = &v
	return s
}

// SetIdentityId sets the IdentityId field's value.
func (s *GetCredentialsForIdentityInput) SetIdentityId(v string) *GetCredentialsForIdentityInput {
	s.IdentityId = &v
	return s
}

// SetLogins sets the Logins field's value.
func (s *GetCredentialsForIdentityInput) SetLogins(v map[string]*string) *GetCredentialsForIdentityInput {
	s.Logins = v
	return s
}

// Returned in response to a successful GetCredentialsForIdentity operation.
type GetCredentialsForIdentityOutput struct {
	_ struct{} `type:"structure"`

	// Credentials for the provided identity ID.
	Credentials *Credentials `type:"structure"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetCredentialsForIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCredentialsForIdentityOutput) GoString() string {
	return s.String()
}

// SetCredentials sets the Credentials field's value.
func (s *GetCredentialsForIdentityOutput) SetCredentials(v *Credentials) *GetCredentialsForIdentityOutput {
	s.Credentials = v
	return s
}

// SetIdentityId sets the IdentityId field's value.
func (s *GetCredentialsForIdentityOutput) SetIdentityId(v string) *GetCredentialsForIdentityOutput {
	s.IdentityId = &v
	return s
}

// Input to the GetId action.
type GetIdInput struct {
	_ struct{} `type:"structure"`

	// A standard AWS account ID (9+ digits).
	AccountId *string `min:"1" type:"string"`

	// An identity pool ID in the format REGION:GUID.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `min:"1" type:"string" required:"true"`

	// A set of optional name-value pairs that map provider names to provider tokens.
	// The available provider names for Logins are as follows:
	//
	//    * Facebook: graph.facebook.com
	//
	//    * Amazon Cognito Identity Provider: cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789
	//
	//    * Google: accounts.google.com
	//
	//    * Amazon: www.amazon.com
	//
	//    * Twitter: api.twitter.com
	//
	//    * Digits: www.digits.com
	Logins map[string]*string `type:"map"`
}

// String returns the string representation
func (s GetIdInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIdInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIdInput"}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetIdInput) SetAccountId(v string) *GetIdInput {
	s.AccountId = &v
	return s
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *GetIdInput) SetIdentityPoolId(v string) *GetIdInput {
	s.IdentityPoolId = &v
	return s
}

// SetLogins sets the Logins field's value.
func (s *GetIdInput) SetLogins(v map[string]*string) *GetIdInput {
	s.Logins = v
	return s
}

// Returned in response to a GetId request.
type GetIdOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetIdOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdOutput) GoString() string {
	return s.String()
}

// SetIdentityId sets the IdentityId field's value.
func (s *GetIdOutput) SetIdentityId(v string) *GetIdOutput {
	s.IdentityId = &v
	return s
}

// Input to the GetIdentityPoolRoles action.
type GetIdentityPoolRolesInput struct {
	_ struct{} `type:"structure"`

	// An identity pool ID in the format REGION:GUID.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetIdentityPoolRolesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityPoolRolesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIdentityPoolRolesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIdentityPoolRolesInput"}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *GetIdentityPoolRolesInput) SetIdentityPoolId(v string) *GetIdentityPoolRolesInput {
	s.IdentityPoolId = &v
	return s
}

// Returned in response to a successful GetIdentityPoolRoles operation.
type GetIdentityPoolRolesOutput struct {
	_ struct{} `type:"structure"`

	// An identity pool ID in the format REGION:GUID.
	IdentityPoolId *string `min:"1" type:"string"`

	// How users for a specific identity provider are to mapped to roles. This is
	// a String-to-RoleMapping object map. The string identifies the identity provider,
	// for example, "graph.facebook.com" or "cognito-idp-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".
	RoleMappings map[string]*RoleMapping `type:"map"`

	// The map of roles associated with this pool. Currently only authenticated
	// and unauthenticated roles are supported.
	Roles map[string]*string `type:"map"`
}

// String returns the string representation
func (s GetIdentityPoolRolesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityPoolRolesOutput) GoString() string {
	return s.String()
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *GetIdentityPoolRolesOutput) SetIdentityPoolId(v string) *GetIdentityPoolRolesOutput {
	s.IdentityPoolId = &v
	return s
}

// SetRoleMappings sets the RoleMappings field's value.
func (s *GetIdentityPoolRolesOutput) SetRoleMappings(v map[string]*RoleMapping) *GetIdentityPoolRolesOutput {
	s.RoleMappings = v
	return s
}

// SetRoles sets the Roles field's value.
func (s *GetIdentityPoolRolesOutput) SetRoles(v map[string]*string) *GetIdentityPoolRolesOutput {
	s.Roles = v
	return s
}

// Input to the GetOpenIdTokenForDeveloperIdentity action.
type GetOpenIdTokenForDeveloperIdentityInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string"`

	// An identity pool ID in the format REGION:GUID.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `min:"1" type:"string" required:"true"`

	// A set of optional name-value pairs that map provider names to provider tokens.
	// Each name-value pair represents a user from a public provider or developer
	// provider. If the user is from a developer provider, the name-value pair will
	// follow the syntax "developer_provider_name": "developer_user_identifier".
	// The developer provider is the "domain" by which Cognito will refer to your
	// users; you provided this domain while creating/updating the identity pool.
	// The developer user identifier is an identifier from your backend that uniquely
	// identifies a user. When you create an identity pool, you can specify the
	// supported logins.
	//
	// Logins is a required field
	Logins map[string]*string `type:"map" required:"true"`

	// The expiration time of the token, in seconds. You can specify a custom expiration
	// time for the token so that you can cache it. If you don't provide an expiration
	// time, the token is valid for 15 minutes. You can exchange the token with
	// Amazon STS for temporary AWS credentials, which are valid for a maximum of
	// one hour. The maximum token duration you can set is 24 hours. You should
	// take care in setting the expiration time for a token, as there are significant
	// security implications: an attacker could use a leaked token to access your
	// AWS resources for the token's duration.
	TokenDuration *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s GetOpenIdTokenForDeveloperIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOpenIdTokenForDeveloperIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOpenIdTokenForDeveloperIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOpenIdTokenForDeveloperIdentityInput"}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityId", 1))
	}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}
	if s.Logins == nil {
		invalidParams.Add(request.NewErrParamRequired("Logins"))
	}
	if s.TokenDuration != nil && *s.TokenDuration < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TokenDuration", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityId sets the IdentityId field's value.
func (s *GetOpenIdTokenForDeveloperIdentityInput) SetIdentityId(v string) *GetOpenIdTokenForDeveloperIdentityInput {
	s.IdentityId = &v
	return s
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *GetOpenIdTokenForDeveloperIdentityInput) SetIdentityPoolId(v string) *GetOpenIdTokenForDeveloperIdentityInput {
	s.IdentityPoolId = &v
	return s
}

// SetLogins sets the Logins field's value.
func (s *GetOpenIdTokenForDeveloperIdentityInput) SetLogins(v map[string]*string) *GetOpenIdTokenForDeveloperIdentityInput {
	s.Logins = v
	return s
}

// SetTokenDuration sets the TokenDuration field's value.
func (s *GetOpenIdTokenForDeveloperIdentityInput) SetTokenDuration(v int64) *GetOpenIdTokenForDeveloperIdentityInput {
	s.TokenDuration = &v
	return s
}

// Returned in response to a successful GetOpenIdTokenForDeveloperIdentity request.
type GetOpenIdTokenForDeveloperIdentityOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string"`

	// An OpenID token.
	Token *string `type:"string"`
}

// String returns the string representation
func (s GetOpenIdTokenForDeveloperIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOpenIdTokenForDeveloperIdentityOutput) GoString() string {
	return s.String()
}

// SetIdentityId sets the IdentityId field's value.
func (s *GetOpenIdTokenForDeveloperIdentityOutput) SetIdentityId(v string) *GetOpenIdTokenForDeveloperIdentityOutput {
	s.IdentityId = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetOpenIdTokenForDeveloperIdentityOutput) SetToken(v string) *GetOpenIdTokenForDeveloperIdentityOutput {
	s.Token = &v
	return s
}

// Input to the GetOpenIdToken action.
type GetOpenIdTokenInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier in the format REGION:GUID.
	//
	// IdentityId is a required field
	IdentityId *string `min:"1" type:"string" required:"true"`

	// A set of optional name-value pairs that map provider names to provider tokens.
	// When using graph.facebook.com and www.amazon.com, supply the access_token
	// returned from the provider's authflow. For accounts.google.com, an Amazon
	// Cognito Identity Provider, or any other OpenId Connect provider, always include
	// the id_token.
	Logins map[string]*string `type:"map"`
}

// String returns the string representation
func (s GetOpenIdTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOpenIdTokenInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOpenIdTokenInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOpenIdTokenInput"}
	if s.IdentityId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityId"))
	}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityId sets the IdentityId field's value.
func (s *GetOpenIdTokenInput) SetIdentityId(v string) *GetOpenIdTokenInput {
	s.IdentityId = &v
	return s
}

// SetLogins sets the Logins field's value.
func (s *GetOpenIdTokenInput) SetLogins(v map[string]*string) *GetOpenIdTokenInput {
	s.Logins = v
	return s
}

// Returned in response to a successful GetOpenIdToken request.
type GetOpenIdTokenOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier in the format REGION:GUID. Note that the IdentityId returned
	// may not match the one passed on input.
	IdentityId *string `min:"1" type:"string"`

	// An OpenID token, valid for 15 minutes.
	Token *string `type:"string"`
}

// String returns the string representation
func (s GetOpenIdTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOpenIdTokenOutput) GoString() string {
	return s.String()
}

// SetIdentityId sets the IdentityId field's value.
func (s *GetOpenIdTokenOutput) SetIdentityId(v string) *GetOpenIdTokenOutput {
	s.IdentityId = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetOpenIdTokenOutput) SetToken(v string) *GetOpenIdTokenOutput {
	s.Token = &v
	return s
}

// A description of the identity.
type IdentityDescription struct {
	_ struct{} `type:"structure"`

	// Date on which the identity was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string"`

	// Date on which the identity was last modified.
	LastModifiedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A set of optional name-value pairs that map provider names to provider tokens.
	Logins []*string `type:"list"`
}

// String returns the string representation
func (s IdentityDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IdentityDescription) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *IdentityDescription) SetCreationDate(v time.Time) *IdentityDescription {
	s.CreationDate = &v
	return s
}

// SetIdentityId sets the IdentityId field's value.
func (s *IdentityDescription) SetIdentityId(v string) *IdentityDescription {
	s.IdentityId = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *IdentityDescription) SetLastModifiedDate(v time.Time) *IdentityDescription {
	s.LastModifiedDate = &v
	return s
}

// SetLogins sets the Logins field's value.
func (s *IdentityDescription) SetLogins(v []*string) *IdentityDescription {
	s.Logins = v
	return s
}

// An object representing an Amazon Cognito identity pool.
type IdentityPool struct {
	_ struct{} `type:"structure"`

	// TRUE if the identity pool supports unauthenticated logins.
	//
	// AllowUnauthenticatedIdentities is a required field
	AllowUnauthenticatedIdentities *bool `type:"boolean" required:"true"`

	// A list representing an Amazon Cognito Identity User Pool and its client ID.
	CognitoIdentityProviders []*Provider `type:"list"`

	// The "domain" by which Cognito will refer to your users.
	DeveloperProviderName *string `min:"1" type:"string"`

	// An identity pool ID in the format REGION:GUID.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `min:"1" type:"string" required:"true"`

	// A string that you provide.
	//
	// IdentityPoolName is a required field
	IdentityPoolName *string `min:"1" type:"string" required:"true"`

	// A list of OpendID Connect provider ARNs.
	OpenIdConnectProviderARNs []*string `type:"list"`

	// An array of Amazon Resource Names (ARNs) of the SAML provider for your identity
	// pool.
	SamlProviderARNs []*string `type:"list"`

	// Optional key:value pairs mapping provider names to provider app IDs.
	SupportedLoginProviders map[string]*string `type:"map"`
}

// String returns the string representation
func (s IdentityPool) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IdentityPool) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IdentityPool) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IdentityPool"}
	if s.AllowUnauthenticatedIdentities == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowUnauthenticatedIdentities"))
	}
	if s.DeveloperProviderName != nil && len(*s.DeveloperProviderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeveloperProviderName", 1))
	}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}
	if s.IdentityPoolName == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolName"))
	}
	if s.IdentityPoolName != nil && len(*s.IdentityPoolName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolName", 1))
	}
	if s.CognitoIdentityProviders != nil {
		for i, v := range s.CognitoIdentityProviders {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CognitoIdentityProviders", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowUnauthenticatedIdentities sets the AllowUnauthenticatedIdentities field's value.
func (s *IdentityPool) SetAllowUnauthenticatedIdentities(v bool) *IdentityPool {
	s.AllowUnauthenticatedIdentities = &v
	return s
}

// SetCognitoIdentityProviders sets the CognitoIdentityProviders field's value.
func (s *IdentityPool) SetCognitoIdentityProviders(v []*Provider) *IdentityPool {
	s.CognitoIdentityProviders = v
	return s
}

// SetDeveloperProviderName sets the DeveloperProviderName field's value.
func (s *IdentityPool) SetDeveloperProviderName(v string) *IdentityPool {
	s.DeveloperProviderName = &v
	return s
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *IdentityPool) SetIdentityPoolId(v string) *IdentityPool {
	s.IdentityPoolId = &v
	return s
}

// SetIdentityPoolName sets the IdentityPoolName field's value.
func (s *IdentityPool) SetIdentityPoolName(v string) *IdentityPool {
	s.IdentityPoolName = &v
	return s
}

// SetOpenIdConnectProviderARNs sets the OpenIdConnectProviderARNs field's value.
func (s *IdentityPool) SetOpenIdConnectProviderARNs(v []*string) *IdentityPool {
	s.OpenIdConnectProviderARNs = v
	return s
}

// SetSamlProviderARNs sets the SamlProviderARNs field's value.
func (s *IdentityPool) SetSamlProviderARNs(v []*string) *IdentityPool {
	s.SamlProviderARNs = v
	return s
}

// SetSupportedLoginProviders sets the SupportedLoginProviders field's value.
func (s *IdentityPool) SetSupportedLoginProviders(v map[string]*string) *IdentityPool {
	s.SupportedLoginProviders = v
	return s
}

// A description of the identity pool.
type IdentityPoolShortDescription struct {
	_ struct{} `type:"structure"`

	// An identity pool ID in the format REGION:GUID.
	IdentityPoolId *string `min:"1" type:"string"`

	// A string that you provide.
	IdentityPoolName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s IdentityPoolShortDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IdentityPoolShortDescription) GoString() string {
	return s.String()
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *IdentityPoolShortDescription) SetIdentityPoolId(v string) *IdentityPoolShortDescription {
	s.IdentityPoolId = &v
	return s
}

// SetIdentityPoolName sets the IdentityPoolName field's value.
func (s *IdentityPoolShortDescription) SetIdentityPoolName(v string) *IdentityPoolShortDescription {
	s.IdentityPoolName = &v
	return s
}

// Input to the ListIdentities action.
type ListIdentitiesInput struct {
	_ struct{} `type:"structure"`

	// An optional boolean parameter that allows you to hide disabled identities.
	// If omitted, the ListIdentities API will include disabled identities in the
	// response.
	HideDisabled *bool `type:"boolean"`

	// An identity pool ID in the format REGION:GUID.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `min:"1" type:"string" required:"true"`

	// The maximum number of identities to return.
	//
	// MaxResults is a required field
	MaxResults *int64 `min:"1" type:"integer" required:"true"`

	// A pagination token.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListIdentitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIdentitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIdentitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIdentitiesInput"}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}
	if s.MaxResults == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxResults"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHideDisabled sets the HideDisabled field's value.
func (s *ListIdentitiesInput) SetHideDisabled(v bool) *ListIdentitiesInput {
	s.HideDisabled = &v
	return s
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *ListIdentitiesInput) SetIdentityPoolId(v string) *ListIdentitiesInput {
	s.IdentityPoolId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIdentitiesInput) SetMaxResults(v int64) *ListIdentitiesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdentitiesInput) SetNextToken(v string) *ListIdentitiesInput {
	s.NextToken = &v
	return s
}

// The response to a ListIdentities request.
type ListIdentitiesOutput struct {
	_ struct{} `type:"structure"`

	// An object containing a set of identities and associated mappings.
	Identities []*IdentityDescription `type:"list"`

	// An identity pool ID in the format REGION:GUID.
	IdentityPoolId *string `min:"1" type:"string"`

	// A pagination token.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListIdentitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIdentitiesOutput) GoString() string {
	return s.String()
}

// SetIdentities sets the Identities field's value.
func (s *ListIdentitiesOutput) SetIdentities(v []*IdentityDescription) *ListIdentitiesOutput {
	s.Identities = v
	return s
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *ListIdentitiesOutput) SetIdentityPoolId(v string) *ListIdentitiesOutput {
	s.IdentityPoolId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdentitiesOutput) SetNextToken(v string) *ListIdentitiesOutput {
	s.NextToken = &v
	return s
}

// Input to the ListIdentityPools action.
type ListIdentityPoolsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of identities to return.
	//
	// MaxResults is a required field
	MaxResults *int64 `min:"1" type:"integer" required:"true"`

	// A pagination token.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListIdentityPoolsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIdentityPoolsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIdentityPoolsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIdentityPoolsInput"}
	if s.MaxResults == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxResults"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIdentityPoolsInput) SetMaxResults(v int64) *ListIdentityPoolsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdentityPoolsInput) SetNextToken(v string) *ListIdentityPoolsInput {
	s.NextToken = &v
	return s
}

// The result of a successful ListIdentityPools action.
type ListIdentityPoolsOutput struct {
	_ struct{} `type:"structure"`

	// The identity pools returned by the ListIdentityPools action.
	IdentityPools []*IdentityPoolShortDescription `type:"list"`

	// A pagination token.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListIdentityPoolsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIdentityPoolsOutput) GoString() string {
	return s.String()
}

// SetIdentityPools sets the IdentityPools field's value.
func (s *ListIdentityPoolsOutput) SetIdentityPools(v []*IdentityPoolShortDescription) *ListIdentityPoolsOutput {
	s.IdentityPools = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdentityPoolsOutput) SetNextToken(v string) *ListIdentityPoolsOutput {
	s.NextToken = &v
	return s
}

// Input to the LookupDeveloperIdentityInput action.
type LookupDeveloperIdentityInput struct {
	_ struct{} `type:"structure"`

	// A unique ID used by your backend authentication process to identify a user.
	// Typically, a developer identity provider would issue many developer user
	// identifiers, in keeping with the number of users.
	DeveloperUserIdentifier *string `min:"1" type:"string"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string"`

	// An identity pool ID in the format REGION:GUID.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `min:"1" type:"string" required:"true"`

	// The maximum number of identities to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// A pagination token. The first call you make will have NextToken set to null.
	// After that the service will return NextToken values as needed. For example,
	// let's say you make a request with MaxResults set to 10, and there are 20
	// matches in the database. The service will return a pagination token as a
	// part of the response. This token can be used to call the API again and get
	// results starting from the 11th match.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LookupDeveloperIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LookupDeveloperIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LookupDeveloperIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LookupDeveloperIdentityInput"}
	if s.DeveloperUserIdentifier != nil && len(*s.DeveloperUserIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeveloperUserIdentifier", 1))
	}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityId", 1))
	}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeveloperUserIdentifier sets the DeveloperUserIdentifier field's value.
func (s *LookupDeveloperIdentityInput) SetDeveloperUserIdentifier(v string) *LookupDeveloperIdentityInput {
	s.DeveloperUserIdentifier = &v
	return s
}

// SetIdentityId sets the IdentityId field's value.
func (s *LookupDeveloperIdentityInput) SetIdentityId(v string) *LookupDeveloperIdentityInput {
	s.IdentityId = &v
	return s
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *LookupDeveloperIdentityInput) SetIdentityPoolId(v string) *LookupDeveloperIdentityInput {
	s.IdentityPoolId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *LookupDeveloperIdentityInput) SetMaxResults(v int64) *LookupDeveloperIdentityInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *LookupDeveloperIdentityInput) SetNextToken(v string) *LookupDeveloperIdentityInput {
	s.NextToken = &v
	return s
}

// Returned in response to a successful LookupDeveloperIdentity action.
type LookupDeveloperIdentityOutput struct {
	_ struct{} `type:"structure"`

	// This is the list of developer user identifiers associated with an identity
	// ID. Cognito supports the association of multiple developer user identifiers
	// with an identity ID.
	DeveloperUserIdentifierList []*string `type:"list"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string"`

	// A pagination token. The first call you make will have NextToken set to null.
	// After that the service will return NextToken values as needed. For example,
	// let's say you make a request with MaxResults set to 10, and there are 20
	// matches in the database. The service will return a pagination token as a
	// part of the response. This token can be used to call the API again and get
	// results starting from the 11th match.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LookupDeveloperIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LookupDeveloperIdentityOutput) GoString() string {
	return s.String()
}

// SetDeveloperUserIdentifierList sets the DeveloperUserIdentifierList field's value.
func (s *LookupDeveloperIdentityOutput) SetDeveloperUserIdentifierList(v []*string) *LookupDeveloperIdentityOutput {
	s.DeveloperUserIdentifierList = v
	return s
}

// SetIdentityId sets the IdentityId field's value.
func (s *LookupDeveloperIdentityOutput) SetIdentityId(v string) *LookupDeveloperIdentityOutput {
	s.IdentityId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *LookupDeveloperIdentityOutput) SetNextToken(v string) *LookupDeveloperIdentityOutput {
	s.NextToken = &v
	return s
}

// A rule that maps a claim name, a claim value, and a match type to a role
// ARN.
type MappingRule struct {
	_ struct{} `type:"structure"`

	// The claim name that must be present in the token, for example, "isAdmin"
	// or "paid".
	//
	// Claim is a required field
	Claim *string `min:"1" type:"string" required:"true"`

	// The match condition that specifies how closely the claim value in the IdP
	// token must match Value.
	//
	// MatchType is a required field
	MatchType *string `type:"string" required:"true" enum:"MappingRuleMatchType"`

	// The role ARN.
	//
	// RoleARN is a required field
	RoleARN *string `min:"20" type:"string" required:"true"`

	// A brief string that the claim must match, for example, "paid" or "yes".
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s MappingRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MappingRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MappingRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MappingRule"}
	if s.Claim == nil {
		invalidParams.Add(request.NewErrParamRequired("Claim"))
	}
	if s.Claim != nil && len(*s.Claim) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Claim", 1))
	}
	if s.MatchType == nil {
		invalidParams.Add(request.NewErrParamRequired("MatchType"))
	}
	if s.RoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 20))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClaim sets the Claim field's value.
func (s *MappingRule) SetClaim(v string) *MappingRule {
	s.Claim = &v
	return s
}

// SetMatchType sets the MatchType field's value.
func (s *MappingRule) SetMatchType(v string) *MappingRule {
	s.MatchType = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *MappingRule) SetRoleARN(v string) *MappingRule {
	s.RoleARN = &v
	return s
}

// SetValue sets the Value field's value.
func (s *MappingRule) SetValue(v string) *MappingRule {
	s.Value = &v
	return s
}

// Input to the MergeDeveloperIdentities action.
type MergeDeveloperIdentitiesInput struct {
	_ struct{} `type:"structure"`

	// User identifier for the destination user. The value should be a DeveloperUserIdentifier.
	//
	// DestinationUserIdentifier is a required field
	DestinationUserIdentifier *string `min:"1" type:"string" required:"true"`

	// The "domain" by which Cognito will refer to your users. This is a (pseudo)
	// domain name that you provide while creating an identity pool. This name acts
	// as a placeholder that allows your backend and the Cognito service to communicate
	// about the developer provider. For the DeveloperProviderName, you can use
	// letters as well as period (.), underscore (_), and dash (-).
	//
	// DeveloperProviderName is a required field
	DeveloperProviderName *string `min:"1" type:"string" required:"true"`

	// An identity pool ID in the format REGION:GUID.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `min:"1" type:"string" required:"true"`

	// User identifier for the source user. The value should be a DeveloperUserIdentifier.
	//
	// SourceUserIdentifier is a required field
	SourceUserIdentifier *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s MergeDeveloperIdentitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MergeDeveloperIdentitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MergeDeveloperIdentitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MergeDeveloperIdentitiesInput"}
	if s.DestinationUserIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationUserIdentifier"))
	}
	if s.DestinationUserIdentifier != nil && len(*s.DestinationUserIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationUserIdentifier", 1))
	}
	if s.DeveloperProviderName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeveloperProviderName"))
	}
	if s.DeveloperProviderName != nil && len(*s.DeveloperProviderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeveloperProviderName", 1))
	}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}
	if s.SourceUserIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceUserIdentifier"))
	}
	if s.SourceUserIdentifier != nil && len(*s.SourceUserIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceUserIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationUserIdentifier sets the DestinationUserIdentifier field's value.
func (s *MergeDeveloperIdentitiesInput) SetDestinationUserIdentifier(v string) *MergeDeveloperIdentitiesInput {
	s.DestinationUserIdentifier = &v
	return s
}

// SetDeveloperProviderName sets the DeveloperProviderName field's value.
func (s *MergeDeveloperIdentitiesInput) SetDeveloperProviderName(v string) *MergeDeveloperIdentitiesInput {
	s.DeveloperProviderName = &v
	return s
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *MergeDeveloperIdentitiesInput) SetIdentityPoolId(v string) *MergeDeveloperIdentitiesInput {
	s.IdentityPoolId = &v
	return s
}

// SetSourceUserIdentifier sets the SourceUserIdentifier field's value.
func (s *MergeDeveloperIdentitiesInput) SetSourceUserIdentifier(v string) *MergeDeveloperIdentitiesInput {
	s.SourceUserIdentifier = &v
	return s
}

// Returned in response to a successful MergeDeveloperIdentities action.
type MergeDeveloperIdentitiesOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s MergeDeveloperIdentitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MergeDeveloperIdentitiesOutput) GoString() string {
	return s.String()
}

// SetIdentityId sets the IdentityId field's value.
func (s *MergeDeveloperIdentitiesOutput) SetIdentityId(v string) *MergeDeveloperIdentitiesOutput {
	s.IdentityId = &v
	return s
}

// A provider representing an Amazon Cognito Identity User Pool and its client
// ID.
type Provider struct {
	_ struct{} `type:"structure"`

	// The client ID for the Amazon Cognito Identity User Pool.
	ClientId *string `min:"1" type:"string"`

	// The provider name for an Amazon Cognito Identity User Pool. For example,
	// cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789.
	ProviderName *string `min:"1" type:"string"`

	// TRUE if server-side token validation is enabled for the identity provider’s
	// token.
	ServerSideTokenCheck *bool `type:"boolean"`
}

// String returns the string representation
func (s Provider) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Provider) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Provider) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Provider"}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.ProviderName != nil && len(*s.ProviderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProviderName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientId sets the ClientId field's value.
func (s *Provider) SetClientId(v string) *Provider {
	s.ClientId = &v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *Provider) SetProviderName(v string) *Provider {
	s.ProviderName = &v
	return s
}

// SetServerSideTokenCheck sets the ServerSideTokenCheck field's value.
func (s *Provider) SetServerSideTokenCheck(v bool) *Provider {
	s.ServerSideTokenCheck = &v
	return s
}

// A role mapping.
type RoleMapping struct {
	_ struct{} `type:"structure"`

	// If you specify Token or Rules as the Type, AmbiguousRoleResolution is required.
	//
	// Specifies the action to be taken if either no rules match the claim value
	// for the Rules type, or there is no cognito:preferred_role claim and there
	// are multiple cognito:roles matches for the Token type.
	AmbiguousRoleResolution *string `type:"string" enum:"AmbiguousRoleResolutionType"`

	// The rules to be used for mapping users to roles.
	//
	// If you specify Rules as the role mapping type, RulesConfiguration is required.
	RulesConfiguration *RulesConfigurationType `type:"structure"`

	// The role mapping type. Token will use cognito:roles and cognito:preferred_role
	// claims from the Cognito identity provider token to map groups to roles. Rules
	// will attempt to match claims from the token to map to a role.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"RoleMappingType"`
}

// String returns the string representation
func (s RoleMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RoleMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RoleMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RoleMapping"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.RulesConfiguration != nil {
		if err := s.RulesConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RulesConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmbiguousRoleResolution sets the AmbiguousRoleResolution field's value.
func (s *RoleMapping) SetAmbiguousRoleResolution(v string) *RoleMapping {
	s.AmbiguousRoleResolution = &v
	return s
}

// SetRulesConfiguration sets the RulesConfiguration field's value.
func (s *RoleMapping) SetRulesConfiguration(v *RulesConfigurationType) *RoleMapping {
	s.RulesConfiguration = v
	return s
}

// SetType sets the Type field's value.
func (s *RoleMapping) SetType(v string) *RoleMapping {
	s.Type = &v
	return s
}

// A container for rules.
type RulesConfigurationType struct {
	_ struct{} `type:"structure"`

	// An array of rules. You can specify up to 25 rules per identity provider.
	//
	// Rules are evaluated in order. The first one to match specifies the role.
	//
	// Rules is a required field
	Rules []*MappingRule `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s RulesConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RulesConfigurationType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RulesConfigurationType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RulesConfigurationType"}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil && len(s.Rules) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Rules", 1))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRules sets the Rules field's value.
func (s *RulesConfigurationType) SetRules(v []*MappingRule) *RulesConfigurationType {
	s.Rules = v
	return s
}

// Input to the SetIdentityPoolRoles action.
type SetIdentityPoolRolesInput struct {
	_ struct{} `type:"structure"`

	// An identity pool ID in the format REGION:GUID.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `min:"1" type:"string" required:"true"`

	// How users for a specific identity provider are to mapped to roles. This is
	// a string to RoleMapping object map. The string identifies the identity provider,
	// for example, "graph.facebook.com" or "cognito-idp-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id".
	//
	// Up to 25 rules can be specified per identity provider.
	RoleMappings map[string]*RoleMapping `type:"map"`

	// The map of roles associated with this pool. For a given role, the key will
	// be either "authenticated" or "unauthenticated" and the value will be the
	// Role ARN.
	//
	// Roles is a required field
	Roles map[string]*string `type:"map" required:"true"`
}

// String returns the string representation
func (s SetIdentityPoolRolesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetIdentityPoolRolesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetIdentityPoolRolesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetIdentityPoolRolesInput"}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}
	if s.Roles == nil {
		invalidParams.Add(request.NewErrParamRequired("Roles"))
	}
	if s.RoleMappings != nil {
		for i, v := range s.RoleMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RoleMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *SetIdentityPoolRolesInput) SetIdentityPoolId(v string) *SetIdentityPoolRolesInput {
	s.IdentityPoolId = &v
	return s
}

// SetRoleMappings sets the RoleMappings field's value.
func (s *SetIdentityPoolRolesInput) SetRoleMappings(v map[string]*RoleMapping) *SetIdentityPoolRolesInput {
	s.RoleMappings = v
	return s
}

// SetRoles sets the Roles field's value.
func (s *SetIdentityPoolRolesInput) SetRoles(v map[string]*string) *SetIdentityPoolRolesInput {
	s.Roles = v
	return s
}

type SetIdentityPoolRolesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetIdentityPoolRolesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetIdentityPoolRolesOutput) GoString() string {
	return s.String()
}

// Input to the UnlinkDeveloperIdentity action.
type UnlinkDeveloperIdentityInput struct {
	_ struct{} `type:"structure"`

	// The "domain" by which Cognito will refer to your users.
	//
	// DeveloperProviderName is a required field
	DeveloperProviderName *string `min:"1" type:"string" required:"true"`

	// A unique ID used by your backend authentication process to identify a user.
	//
	// DeveloperUserIdentifier is a required field
	DeveloperUserIdentifier *string `min:"1" type:"string" required:"true"`

	// A unique identifier in the format REGION:GUID.
	//
	// IdentityId is a required field
	IdentityId *string `min:"1" type:"string" required:"true"`

	// An identity pool ID in the format REGION:GUID.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UnlinkDeveloperIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnlinkDeveloperIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UnlinkDeveloperIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UnlinkDeveloperIdentityInput"}
	if s.DeveloperProviderName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeveloperProviderName"))
	}
	if s.DeveloperProviderName != nil && len(*s.DeveloperProviderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeveloperProviderName", 1))
	}
	if s.DeveloperUserIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DeveloperUserIdentifier"))
	}
	if s.DeveloperUserIdentifier != nil && len(*s.DeveloperUserIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeveloperUserIdentifier", 1))
	}
	if s.IdentityId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityId"))
	}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityId", 1))
	}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeveloperProviderName sets the DeveloperProviderName field's value.
func (s *UnlinkDeveloperIdentityInput) SetDeveloperProviderName(v string) *UnlinkDeveloperIdentityInput {
	s.DeveloperProviderName = &v
	return s
}

// SetDeveloperUserIdentifier sets the DeveloperUserIdentifier field's value.
func (s *UnlinkDeveloperIdentityInput) SetDeveloperUserIdentifier(v string) *UnlinkDeveloperIdentityInput {
	s.DeveloperUserIdentifier = &v
	return s
}

// SetIdentityId sets the IdentityId field's value.
func (s *UnlinkDeveloperIdentityInput) SetIdentityId(v string) *UnlinkDeveloperIdentityInput {
	s.IdentityId = &v
	return s
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *UnlinkDeveloperIdentityInput) SetIdentityPoolId(v string) *UnlinkDeveloperIdentityInput {
	s.IdentityPoolId = &v
	return s
}

type UnlinkDeveloperIdentityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UnlinkDeveloperIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnlinkDeveloperIdentityOutput) GoString() string {
	return s.String()
}

// Input to the UnlinkIdentity action.
type UnlinkIdentityInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier in the format REGION:GUID.
	//
	// IdentityId is a required field
	IdentityId *string `min:"1" type:"string" required:"true"`

	// A set of optional name-value pairs that map provider names to provider tokens.
	//
	// Logins is a required field
	Logins map[string]*string `type:"map" required:"true"`

	// Provider names to unlink from this identity.
	//
	// LoginsToRemove is a required field
	LoginsToRemove []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s UnlinkIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnlinkIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UnlinkIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UnlinkIdentityInput"}
	if s.IdentityId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityId"))
	}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityId", 1))
	}
	if s.Logins == nil {
		invalidParams.Add(request.NewErrParamRequired("Logins"))
	}
	if s.LoginsToRemove == nil {
		invalidParams.Add(request.NewErrParamRequired("LoginsToRemove"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityId sets the IdentityId field's value.
func (s *UnlinkIdentityInput) SetIdentityId(v string) *UnlinkIdentityInput {
	s.IdentityId = &v
	return s
}

// SetLogins sets the Logins field's value.
func (s *UnlinkIdentityInput) SetLogins(v map[string]*string) *UnlinkIdentityInput {
	s.Logins = v
	return s
}

// SetLoginsToRemove sets the LoginsToRemove field's value.
func (s *UnlinkIdentityInput) SetLoginsToRemove(v []*string) *UnlinkIdentityInput {
	s.LoginsToRemove = v
	return s
}

type UnlinkIdentityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UnlinkIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnlinkIdentityOutput) GoString() string {
	return s.String()
}

// An array of UnprocessedIdentityId objects, each of which contains an ErrorCode
// and IdentityId.
type UnprocessedIdentityId struct {
	_ struct{} `type:"structure"`

	// The error code indicating the type of error that occurred.
	ErrorCode *string `type:"string" enum:"ErrorCode"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UnprocessedIdentityId) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnprocessedIdentityId) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *UnprocessedIdentityId) SetErrorCode(v string) *UnprocessedIdentityId {
	s.ErrorCode = &v
	return s
}

// SetIdentityId sets the IdentityId field's value.
func (s *UnprocessedIdentityId) SetIdentityId(v string) *UnprocessedIdentityId {
	s.IdentityId = &v
	return s
}

const (
	// AmbiguousRoleResolutionTypeAuthenticatedRole is a AmbiguousRoleResolutionType enum value
	AmbiguousRoleResolutionTypeAuthenticatedRole = "AuthenticatedRole"

	// AmbiguousRoleResolutionTypeDeny is a AmbiguousRoleResolutionType enum value
	AmbiguousRoleResolutionTypeDeny = "Deny"
)

const (
	// ErrorCodeAccessDenied is a ErrorCode enum value
	ErrorCodeAccessDenied = "AccessDenied"

	// ErrorCodeInternalServerError is a ErrorCode enum value
	ErrorCodeInternalServerError = "InternalServerError"
)

const (
	// MappingRuleMatchTypeEquals is a MappingRuleMatchType enum value
	MappingRuleMatchTypeEquals = "Equals"

	// MappingRuleMatchTypeContains is a MappingRuleMatchType enum value
	MappingRuleMatchTypeContains = "Contains"

	// MappingRuleMatchTypeStartsWith is a MappingRuleMatchType enum value
	MappingRuleMatchTypeStartsWith = "StartsWith"

	// MappingRuleMatchTypeNotEqual is a MappingRuleMatchType enum value
	MappingRuleMatchTypeNotEqual = "NotEqual"
)

const (
	// RoleMappingTypeToken is a RoleMappingType enum value
	RoleMappingTypeToken = "Token"

	// RoleMappingTypeRules is a RoleMappingType enum value
	RoleMappingTypeRules = "Rules"
)
