/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.Serializable;
import org.gradle.api.internal.tasks.compile.CommandLineJavaCompileSpec;
import org.gradle.api.internal.tasks.compile.CommandLineJavaCompilerArgumentsGenerator;
import org.gradle.api.internal.tasks.compile.CompilationFailedException;
import org.gradle.api.internal.tasks.compile.CompileSpecToArguments;
import org.gradle.api.internal.tasks.compile.ExecSpecBackedArgCollector;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.internal.process.ArgCollector;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.ExecHandleBuilder;
import org.gradle.process.internal.ExecHandleFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLineJavaCompiler
implements Compiler<JavaCompileSpec>,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandLineJavaCompiler.class);
    private final CompileSpecToArguments<JavaCompileSpec> argumentsGenerator = new CommandLineJavaCompilerArgumentsGenerator();
    private final ExecHandleFactory execHandleFactory;

    public CommandLineJavaCompiler(ExecHandleFactory execHandleFactory) {
        this.execHandleFactory = execHandleFactory;
    }

    public WorkResult execute(JavaCompileSpec spec) {
        if (!(spec instanceof CommandLineJavaCompileSpec)) {
            throw new IllegalArgumentException(String.format("Expected a %s, but got %s", CommandLineJavaCompileSpec.class.getSimpleName(), spec.getClass().getSimpleName()));
        }
        String executable = ((CommandLineJavaCompileSpec)((Object)spec)).getExecutable().toString();
        LOGGER.info("Compiling with Java command line compiler '{}'.", (Object)executable);
        ExecHandle handle = this.createCompilerHandle(executable, spec);
        this.executeCompiler(handle);
        return WorkResults.didWork((boolean)true);
    }

    private ExecHandle createCompilerHandle(String executable, JavaCompileSpec spec) {
        ExecHandleBuilder builder = this.execHandleFactory.newExec();
        builder.setWorkingDir(spec.getWorkingDir());
        builder.setExecutable(executable);
        this.argumentsGenerator.collectArguments((Object)spec, (ArgCollector)new ExecSpecBackedArgCollector((ExecSpec)builder));
        builder.setIgnoreExitValue(true);
        return builder.build();
    }

    private void executeCompiler(ExecHandle handle) {
        handle.start();
        ExecResult result = handle.waitForFinish();
        if (result.getExitValue() != 0) {
            throw new CompilationFailedException(result.getExitValue());
        }
    }
}

