/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.annotation;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@StatelessCheck
public class SuppressWarningsCheck
extends AbstractCheck {
    public static final String MSG_KEY_SUPPRESSED_WARNING_NOT_ALLOWED = "suppressed.warning.not.allowed";
    private static final String SUPPRESS_WARNINGS = "SuppressWarnings";
    private static final String FQ_SUPPRESS_WARNINGS = "java.lang.SuppressWarnings";
    private Pattern format = Pattern.compile("^$|^\\s+$");

    public final void setFormat(Pattern pattern) {
        this.format = pattern;
    }

    @Override
    public final int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public final int[] getAcceptableTokens() {
        return new int[]{14, 15, 154, 157, 161, 155, 21, 10, 9, 8};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST annotation = SuppressWarningsCheck.getSuppressWarnings(ast);
        if (annotation != null) {
            DetailAST warningHolder = SuppressWarningsCheck.findWarningsHolder(annotation);
            DetailAST token = warningHolder.findFirstToken(160);
            DetailAST warning = token == null ? warningHolder.findFirstToken(28) : token.findFirstToken(28);
            if (warning == null) {
                this.logMatch(warningHolder, "");
            } else {
                while (warning != null) {
                    if (warning.getType() == 28) {
                        DetailAST fChild = warning.getFirstChild();
                        switch (fChild.getType()) {
                            case 139: {
                                String warningText = SuppressWarningsCheck.removeQuotes(warning.getFirstChild().getText());
                                this.logMatch(warning, warningText);
                                break;
                            }
                            case 109: {
                                this.walkConditional(fChild);
                                break;
                            }
                            case 58: 
                            case 59: {
                                break;
                            }
                        }
                    }
                    warning = warning.getNextSibling();
                }
            }
        }
    }

    private static DetailAST getSuppressWarnings(DetailAST ast) {
        DetailAST annotation = AnnotationUtil.getAnnotation(ast, SUPPRESS_WARNINGS);
        if (annotation == null) {
            annotation = AnnotationUtil.getAnnotation(ast, FQ_SUPPRESS_WARNINGS);
        }
        return annotation;
    }

    private void logMatch(DetailAST ast, String warningText) {
        Matcher matcher = this.format.matcher(warningText);
        if (matcher.matches()) {
            this.log(ast, MSG_KEY_SUPPRESSED_WARNING_NOT_ALLOWED, warningText);
        }
    }

    private static DetailAST findWarningsHolder(DetailAST annotation) {
        DetailAST annValuePair = annotation.findFirstToken(160);
        DetailAST annArrayInit = annValuePair == null ? annotation.findFirstToken(162) : annValuePair.findFirstToken(162);
        DetailAST warningsHolder = annotation;
        if (annArrayInit != null) {
            warningsHolder = annArrayInit;
        }
        return warningsHolder;
    }

    private static String removeQuotes(String warning) {
        return warning.substring(1, warning.length() - 1);
    }

    private void walkConditional(DetailAST cond) {
        if (cond.getType() == 109) {
            this.walkConditional(SuppressWarningsCheck.getCondLeft(cond));
            this.walkConditional(SuppressWarningsCheck.getCondRight(cond));
        } else {
            String warningText = SuppressWarningsCheck.removeQuotes(cond.getText());
            this.logMatch(cond, warningText);
        }
    }

    private static DetailAST getCondLeft(DetailAST cond) {
        DetailAST colon = cond.findFirstToken(82);
        return colon.getPreviousSibling();
    }

    private static DetailAST getCondRight(DetailAST cond) {
        DetailAST colon = cond.findFirstToken(82);
        return colon.getNextSibling();
    }
}

