/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.socket.RubyTCPSocket;
import org.jruby.ext.socket.SocketUtils;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.FilenoUtil;
import org.jruby.util.io.SelectorFactory;

@JRubyClass(name={"TCPServer"}, parent="TCPSocket")
public class RubyTCPServer
extends RubyTCPSocket {
    static void createTCPServer(Ruby runtime2) {
        RubyClass rb_cTCPServer = runtime2.defineClass("TCPServer", runtime2.getClass("TCPSocket"), RubyTCPServer::new);
        rb_cTCPServer.defineAnnotatedMethods(RubyTCPServer.class);
        runtime2.getObject().setConstant("TCPserver", rb_cTCPServer);
    }

    public RubyTCPServer(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    @Override
    @JRubyMethod(name={"initialize"}, required=1, optional=1, checkArity=false, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        IRubyObject _host;
        Ruby runtime2 = context.runtime;
        IRubyObject _port = null;
        String host = "0.0.0.0";
        switch (args2.length) {
            case 2: {
                _host = args2[0];
                _port = args2[1];
                if (_host.isNil()) break;
                if (_host instanceof RubyFixnum) {
                    throw runtime2.newTypeError(_host, runtime2.getString());
                }
                RubyString hostString = _host.convertToString();
                if (hostString.size() <= 0) break;
                host = hostString.toString();
                break;
            }
            case 1: {
                _host = context.nil;
                _port = args2[0];
                break;
            }
            default: {
                throw runtime2.newArgumentError(args2.length, 1, 2);
            }
        }
        int port = SocketUtils.getPortFrom(context, _port);
        try {
            InetAddress addr2 = InetAddress.getByName(host);
            ServerSocketChannel ssc = ServerSocketChannel.open();
            ssc.socket().setReuseAddress(true);
            InetSocketAddress socket_address = new InetSocketAddress(addr2, port);
            ssc.socket().bind(socket_address);
            this.initSocket(RubyTCPServer.newChannelFD(runtime2, ssc));
        }
        catch (UnknownHostException e) {
            throw SocketUtils.sockerr(runtime2, "initialize: name or service not known");
        }
        catch (BindException e) {
            throw runtime2.newErrnoFromBindException(e, RubyTCPServer.bindContextMessage(_host, port));
        }
        catch (SocketException e) {
            String msg = e.getMessage();
            if (msg.indexOf("Permission denied") != -1) {
                throw runtime2.newErrnoEACCESError("bind(2)");
            }
            throw SocketUtils.sockerr(runtime2, "initialize: name or service not known");
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
        catch (IllegalArgumentException iae) {
            throw SocketUtils.sockerr(runtime2, iae.getMessage());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"accept"})
    public IRubyObject accept(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        RubyTCPSocket socket2 = new RubyTCPSocket(runtime2, runtime2.getClass("TCPSocket"));
        try {
            SocketChannel connected;
            RubyThread thread2 = context.getThread();
            while (true) {
                boolean ready;
                if (!(ready = thread2.select(this, 16))) {
                    context.pollThreadEvents();
                    continue;
                }
                connected = this.getServerSocketChannel().accept();
                if (connected != null) break;
            }
            connected.finishConnect();
            Object object = connected.blockingLock();
            synchronized (object) {
                connected.configureBlocking(false);
                connected.configureBlocking(true);
            }
            socket2.initSocket(RubyTCPServer.newChannelFD(runtime2, connected));
            return socket2;
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
    }

    @JRubyMethod(name={"accept_nonblock"})
    public IRubyObject accept_nonblock(ThreadContext context) {
        return this.accept_nonblock(context, context.runtime, true);
    }

    @JRubyMethod(name={"accept_nonblock"})
    public IRubyObject accept_nonblock(ThreadContext context, IRubyObject opts) {
        return this.accept_nonblock(context, context.runtime, RubyTCPServer.extractExceptionArg(context, opts));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject accept_nonblock(ThreadContext context, Ruby runtime2, boolean ex) {
        RubyTCPSocket socket2 = new RubyTCPSocket(runtime2, runtime2.getClass("TCPSocket"));
        Selector selector = null;
        ServerSocketChannel ssc = this.getServerSocketChannel();
        Object object = ssc.blockingLock();
        synchronized (object) {
            RubyTCPSocket rubyTCPSocket;
            boolean oldBlocking;
            block24: {
                RubySymbol rubySymbol;
                block23: {
                    oldBlocking = ssc.isBlocking();
                    try {
                        ssc.configureBlocking(false);
                        selector = SelectorFactory.openWithRetryFrom(runtime2, SelectorProvider.provider());
                        boolean ready = context.getThread().select(this, 16, 0L);
                        if (!ready) {
                            if (ex) {
                                throw runtime2.newErrnoEAGAINReadableError("Resource temporarily unavailable");
                            }
                            rubySymbol = runtime2.newSymbol("wait_readable");
                            break block23;
                        }
                        socket2.initSocket(RubyTCPServer.newChannelFD(runtime2, ssc.accept()));
                        rubyTCPSocket = socket2;
                        break block24;
                    }
                    catch (IOException e) {
                        throw runtime2.newIOErrorFromException(e);
                    }
                }
                return rubySymbol;
            }
            return rubyTCPSocket;
            finally {
                try {
                    if (selector != null) {
                        selector.close();
                    }
                }
                catch (Exception exception2) {}
                try {
                    ssc.configureBlocking(oldBlocking);
                }
                catch (IOException iOException) {}
            }
        }
    }

    @JRubyMethod(name={"sysaccept"})
    public IRubyObject sysaccept(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        try {
            SocketChannel connected;
            RubyThread thread2 = context.getThread();
            while (true) {
                boolean ready;
                if (!(ready = thread2.select(this, 16))) {
                    context.pollThreadEvents();
                    continue;
                }
                connected = this.getServerSocketChannel().accept();
                if (connected != null) break;
            }
            connected.finishConnect();
            return runtime2.newFixnum(FilenoUtil.filenoFrom(connected));
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
    }

    @JRubyMethod(name={"listen"}, required=1)
    public IRubyObject listen(ThreadContext context, IRubyObject backlog) {
        return RubyFixnum.zero(context.runtime);
    }

    @JRubyMethod(name={"peeraddr"}, rest=true)
    public IRubyObject peeraddr(ThreadContext context, IRubyObject[] args2) {
        throw context.runtime.newNotImplementedError("not supported");
    }

    @JRubyMethod(name={"getpeername"}, rest=true)
    public IRubyObject getpeername(ThreadContext context, IRubyObject[] args2) {
        throw context.runtime.newNotImplementedError("not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(rest=true, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject tcpServer = recv2.callMethod(context, "new", args2);
        if (!block.isGiven()) {
            return tcpServer;
        }
        try {
            IRubyObject iRubyObject = block.yield(context, tcpServer);
            return iRubyObject;
        }
        finally {
            tcpServer.callMethod(context, "close");
        }
    }

    public ServerSocketChannel getServerSocketChannel() {
        return (ServerSocketChannel)this.getChannel();
    }

    @Override
    public IRubyObject shutdown(ThreadContext context, IRubyObject[] args2) {
        throw context.runtime.newErrnoENOTCONNError();
    }

    @Override
    public IRubyObject gets(ThreadContext context) {
        throw context.runtime.newErrnoENOTCONNError();
    }

    @Override
    public IRubyObject gets(ThreadContext context, IRubyObject sep) {
        throw context.runtime.newErrnoENOTCONNError();
    }

    @Override
    public IRubyObject gets(ThreadContext context, IRubyObject sep, IRubyObject limit2) {
        throw context.runtime.newErrnoENOTCONNError();
    }

    @Deprecated
    public IRubyObject accept() {
        return this.accept(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public IRubyObject listen(IRubyObject backlog) {
        return this.listen(this.getRuntime().getCurrentContext(), backlog);
    }

    @Deprecated
    public static IRubyObject open(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyTCPServer.open(recv2.getRuntime().getCurrentContext(), recv2, args2, block);
    }
}

