/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.components;

import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.components.Button;

public class RadioButton
extends Button {
    protected Icon selectedImage;
    protected Icon disabledSelectedImage;
    protected Icon focusedSelectedImage;

    public RadioButton() {
        this("");
    }

    public RadioButton(String label) {
        this(label, false);
    }

    public RadioButton(String string, boolean b) {
        super(string);
        this.setSelected(b);
        this.setHorizontalAlignment(4);
    }

    protected void toggleSelection() {
        this.setSelected(true);
    }

    public Icon getRolloverSelectedIcon() {
        if (this.focusedSelectedImage != null) {
            return this.focusedSelectedImage;
        }
        return (Icon)this.theme.getProperty("icon", 12);
    }

    public void setRolloverSelectedIcon(Icon focusedSelectedImage) {
        this.focusedSelectedImage = focusedSelectedImage;
    }

    public Icon getSelectedIcon() {
        if (this.selectedImage != null) {
            return this.selectedImage;
        }
        return (Icon)this.theme.getProperty("icon", 8);
    }

    public void setSelectedIcon(Icon selectedImage) {
        this.selectedImage = selectedImage;
    }

    public void setDisabledSelectedIcon(Icon disabledSelectedIcon) {
        this.disabledSelectedImage = disabledSelectedIcon;
    }

    public Icon getDisabledSelectedIcon() {
        if (this.disabledSelectedImage != null) {
            return this.disabledSelectedImage;
        }
        return (Icon)this.theme.getProperty("icon", 10);
    }

    public String getDefaultName() {
        return "RadioButton";
    }

    protected void paintIcon(Graphics2D g, int x, int y) {
        int cState = this.getCurrentState();
        boolean selected = (cState & 8) != 0;
        Icon disabledSelectedImage = this.getDisabledSelectedIcon();
        Icon focusedSelectedImage = this.getRolloverSelectedIcon();
        Icon selectedImage = this.getSelectedIcon();
        if (selected && (cState & 2) != 0 && disabledSelectedImage != null) {
            disabledSelectedImage.paintIcon(this, g, x, y);
        } else if (selected && (cState & 4) != 0 && focusedSelectedImage != null) {
            focusedSelectedImage.paintIcon(this, g, x, y);
        } else if (selected && selectedImage != null) {
            selectedImage.paintIcon(this, g, x, y);
        } else {
            super.paintIcon(g, x, y);
        }
    }
}

