/*
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 *  Some functions in this file use the VSOP87 solution by
 *  Messrs. Bretagnon and Francou.
 * 
 *  Copyright (C) 2000 - 2005 Liam Girdwood  <lgirdwood@gmail.com>
 */

#include <math.h>
#include <libnova/vsop87.h>
#include <libnova/solar.h>
#include <libnova/earth.h>
#include <libnova/transform.h>
#include <libnova/rise_set.h>
#include <libnova/utility.h>


#define LONG_L0 623
#define LONG_L1 379
#define LONG_L2 144
#define LONG_L3 23
#define LONG_L4 11
#define LONG_L5 4
#define LAT_B0 184
#define LAT_B1 134
#define LAT_B2 62
#define LAT_B3 14
#define LAT_B4 6
#define LAT_B5 2
#define RADIUS_R0 523
#define RADIUS_R1 290
#define RADIUS_R2 134
#define RADIUS_R3 20
#define RADIUS_R4 9
#define RADIUS_R5 2


/* cache variables */
static double cJD = 0.0, cL = 0.0, cB = 0.0, cR = 0.0;

static const struct ln_vsop ALIGN32 earth_longitude_l0[LONG_L0] = {
    {     1.75347045673,  0.00000000000,        0.00000000000}, 
    {     0.03341656453,  4.66925680415,     6283.07584999140}, 
    {     0.00034894275,  4.62610242189,    12566.15169998280}, 
    {     0.00003417572,  2.82886579754,        3.52311834900}, 
    {     0.00003497056,  2.74411783405,     5753.38488489680}, 
    {     0.00003135899,  3.62767041756,    77713.77146812050}, 
    {     0.00002676218,  4.41808345438,     7860.41939243920}, 
    {     0.00002342691,  6.13516214446,     3930.20969621960}, 
    {     0.00001273165,  2.03709657878,      529.69096509460}, 
    {     0.00001324294,  0.74246341673,    11506.76976979360}, 
    {     0.00000901854,  2.04505446477,       26.29831979980}, 
    {     0.00001199167,  1.10962946234,     1577.34354244780}, 
    {     0.00000857223,  3.50849152283,      398.14900340820}, 
    {     0.00000779786,  1.17882681962,     5223.69391980220}, 
    {     0.00000990250,  5.23268072088,     5884.92684658320}, 
    {     0.00000753141,  2.53339052847,     5507.55323866740}, 
    {     0.00000505267,  4.58292599973,    18849.22754997420}, 
    {     0.00000492392,  4.20505711826,      775.52261132400}, 
    {     0.00000356672,  2.91954114478,        0.06731030280}, 
    {     0.00000284125,  1.89869240932,      796.29800681640}, 
    {     0.00000242879,  0.34481445893,     5486.77784317500}, 
    {     0.00000317087,  5.84901948512,    11790.62908865880}, 
    {     0.00000271112,  0.31486255375,    10977.07880469900}, 
    {     0.00000206217,  4.80646631478,     2544.31441988340}, 
    {     0.00000205478,  1.86953770281,     5573.14280143310}, 
    {     0.00000202318,  2.45767790232,     6069.77675455340}, 
    {     0.00000126225,  1.08295459501,       20.77539549240}, 
    {     0.00000155516,  0.83306084617,      213.29909543800}, 
    {     0.00000115132,  0.64544911683,        0.98032106820}, 
    {     0.00000102851,  0.63599845579,     4694.00295470760}, 
    {     0.00000101724,  4.26679801980,        7.11354700080}, 
    {     0.00000099206,  6.20992926918,     2146.16541647520}, 
    {     0.00000132212,  3.41118292683,     2942.46342329160}, 
    {     0.00000097607,  0.68101342359,      155.42039943420}, 
    {     0.00000085128,  1.29870764804,     6275.96230299060}, 
    {     0.00000074651,  1.75508913300,     5088.62883976680}, 
    {     0.00000101895,  0.97569280312,    15720.83878487840}, 
    {     0.00000084711,  3.67080093031,    71430.69561812909}, 
    {     0.00000073547,  4.67926633877,      801.82093112380}, 
    {     0.00000073874,  3.50319414955,     3154.68708489560}, 
    {     0.00000078757,  3.03697458703,    12036.46073488820}, 
    {     0.00000079637,  1.80791287082,    17260.15465469040}, 
    {     0.00000085803,  5.98322631260,   161000.68573767410}, 
    {     0.00000056963,  2.78430458592,     6286.59896834040}, 
    {     0.00000061148,  1.81839892984,     7084.89678111520}, 
    {     0.00000069627,  0.83297621398,     9437.76293488700}, 
    {     0.00000056116,  4.38694865354,    14143.49524243060}, 
    {     0.00000062449,  3.97763912806,     8827.39026987480}, 
    {     0.00000051145,  0.28306832879,     5856.47765911540}, 
    {     0.00000055577,  3.47006059924,     6279.55273164240}, 
    {     0.00000041036,  5.36817592855,     8429.24126646660}, 
    {     0.00000051605,  1.33282739866,     1748.01641306700}, 
    {     0.00000051992,  0.18914947184,    12139.55350910680}, 
    {     0.00000049000,  0.48735014197,     1194.44701022460}, 
    {     0.00000039200,  6.16833020996,    10447.38783960440}, 
    {     0.00000035570,  1.77596889200,     6812.76681508600}, 
    {     0.00000036770,  6.04133863162,    10213.28554621100}, 
    {     0.00000036596,  2.56957481827,     1059.38193018920}, 
    {     0.00000033296,  0.59310278598,    17789.84561978500}, 
    {     0.00000035954,  1.70875808777,     2352.86615377180}, 
    {     0.00000040938,  2.39850938714,    19651.04848109800}, 
    {     0.00000030047,  2.73975124088,     1349.86740965880}, 
    {     0.00000030412,  0.44294464169,    83996.84731811189}, 
    {     0.00000023663,  0.48473622521,     8031.09226305840}, 
    {     0.00000023574,  2.06528133162,     3340.61242669980}, 
    {     0.00000021089,  4.14825468851,      951.71840625060}, 
    {     0.00000024738,  0.21484762138,        3.59042865180}, 
    {     0.00000025352,  3.16470891653,     4690.47983635860}, 
    {     0.00000022823,  5.22195230819,     4705.73230754360}, 
    {     0.00000021419,  1.42563910473,    16730.46368959580}, 
    {     0.00000021891,  5.55594302779,      553.56940284240}, 
    {     0.00000017481,  4.56052900312,      135.06508003540}, 
    {     0.00000019927,  5.22209149316,    12168.00269657460}, 
    {     0.00000019860,  5.77470242235,     6309.37416979120}, 
    {     0.00000020300,  0.37133792946,      283.85931886520}, 
    {     0.00000014421,  4.19315052005,      242.72860397400}, 
    {     0.00000016225,  5.98837767951,    11769.85369316640}, 
    {     0.00000015077,  4.19567163370,     6256.77753019160}, 
    {     0.00000019124,  3.82219958698,    23581.25817731760}, 
    {     0.00000018888,  5.38626892076,   149854.40013480789}, 
    {     0.00000014346,  3.72355084422,       38.02767263580}, 
    {     0.00000017898,  2.21490566029,    13367.97263110660}, 
    {     0.00000012054,  2.62229602614,      955.59974160860}, 
    {     0.00000011287,  0.17739329984,     4164.31198961300}, 
    {     0.00000013973,  4.40134615007,     6681.22485339960}, 
    {     0.00000013621,  1.88934516495,     7632.94325965020}, 
    {     0.00000012503,  1.13052412208,        5.52292430740}, 
    {     0.00000010498,  5.35909979317,     1592.59601363280}, 
    {     0.00000009803,  0.99948172646,    11371.70468975820}, 
    {     0.00000009220,  4.57138585348,     4292.33083295040}, 
    {     0.00000010327,  6.19982170609,     6438.49624942560}, 
    {     0.00000012003,  1.00351462266,      632.78373931320}, 
    {     0.00000010827,  0.32734523824,      103.09277421860}, 
    {     0.00000008356,  4.53902748706,    25132.30339996560}, 
    {     0.00000010005,  6.02914963280,     5746.27133789600}, 
    {     0.00000008409,  3.29946177848,     7234.79425624200}, 
    {     0.00000008006,  5.82145271855,       28.44918746780}, 
    {     0.00000010523,  0.93870455544,    11926.25441366880}, 
    {     0.00000007686,  3.12143640640,     7238.67559160000}, 
    {     0.00000009378,  2.62413793196,     5760.49843189760}, 
    {     0.00000008127,  6.11227839253,     4732.03062734340}, 
    {     0.00000009232,  0.48344234496,      522.57741809380}, 
    {     0.00000009802,  5.24413877132,    27511.46787353720}, 
    {     0.00000007871,  0.99590133077,     5643.17856367740}, 
    {     0.00000008123,  6.27053020099,      426.59819087600}, 
    {     0.00000009048,  5.33686323585,     6386.16862421000}, 
    {     0.00000008621,  4.16537179089,     7058.59846131540}, 
    {     0.00000006297,  4.71723143652,     6836.64525283380}, 
    {     0.00000007575,  3.97381357237,    11499.65622279280}, 
    {     0.00000007756,  2.95728422442,    23013.53953958720}, 
    {     0.00000007314,  0.60652522715,    11513.88331679440}, 
    {     0.00000005955,  2.87641047954,     6283.14316029419}, 
    {     0.00000006534,  5.79046406784,    18073.70493865020}, 
    {     0.00000007188,  3.99831461988,       74.78159856730}, 
    {     0.00000007346,  4.38582423903,      316.39186965660}, 
    {     0.00000005413,  5.39199023275,      419.48464387520}, 
    {     0.00000005127,  2.36059551778,    10973.55568635000}, 
    {     0.00000007056,  0.32258442532,      263.08392337280}, 
    {     0.00000006624,  3.66474165840,    17298.18232732620}, 
    {     0.00000006762,  5.91131766896,    90955.55169449610}, 
    {     0.00000004938,  5.73672172371,     9917.69687450980}, 
    {     0.00000005547,  2.45152589382,    12352.85260454480}, 
    {     0.00000005958,  3.32051344660,     6283.00853968860}, 
    {     0.00000004471,  2.06386138131,     7079.37385680780}, 
    {     0.00000006153,  1.45823347458,   233141.31440436149}, 
    {     0.00000004348,  4.42338625285,     5216.58037280140}, 
    {     0.00000006124,  1.07494838623,    19804.82729158280}, 
    {     0.00000004488,  3.65285033073,      206.18554843720}, 
    {     0.00000004020,  0.83995823171,       20.35531939880}, 
    {     0.00000005188,  4.06503864016,     6208.29425142410}, 
    {     0.00000005307,  0.38216728132,    31441.67756975680}, 
    {     0.00000003785,  2.34369213733,        3.88133535800}, 
    {     0.00000004497,  3.27230792447,    11015.10647733480}, 
    {     0.00000004132,  0.92129851256,     3738.76143010800}, 
    {     0.00000003521,  5.97844803610,     3894.18182954220}, 
    {     0.00000004215,  1.90601721876,      245.83164622940}, 
    {     0.00000003701,  5.03067498875,      536.80451209540}, 
    {     0.00000003866,  1.82632980909,    11856.21865142450}, 
    {     0.00000003652,  1.01840564429,    16200.77272450120}, 
    {     0.00000003390,  0.97784870142,     8635.94200376320}, 
    {     0.00000003737,  2.95378919570,     3128.38876509580}, 
    {     0.00000003507,  3.71291946317,     6290.18939699220}, 
    {     0.00000003086,  3.64646921512,       10.63666534980}, 
    {     0.00000003397,  1.10589356888,    14712.31711645800}, 
    {     0.00000003334,  0.83684903082,     6496.37494542940}, 
    {     0.00000002805,  2.58503711584,    14314.16811304980}, 
    {     0.00000003650,  1.08344142571,    88860.05707098669}, 
    {     0.00000003388,  3.20182380957,     5120.60114558360}, 
    {     0.00000003252,  3.47857474229,     6133.51265285680}, 
    {     0.00000002553,  3.94869027260,     1990.74501704100}, 
    {     0.00000003520,  2.05559692878,   244287.60000722769}, 
    {     0.00000002565,  1.56072409371,    23543.23050468179}, 
    {     0.00000002621,  3.85639359951,      266.60704172180}, 
    {     0.00000002954,  3.39692614359,     9225.53927328300}, 
    {     0.00000002876,  6.02633318445,   154717.60988768269}, 
    {     0.00000002395,  1.16130078696,    10984.19235169980}, 
    {     0.00000003161,  1.32798862116,    10873.98603048040}, 
    {     0.00000003163,  5.08946546862,    21228.39202354580}, 
    {     0.00000002361,  4.27212461943,     6040.34724601740}, 
    {     0.00000003030,  1.80210001168,    35371.88726597640}, 
    {     0.00000002343,  3.57688971514,    10969.96525769820}, 
    {     0.00000002618,  2.57870151918,    22483.84857449259}, 
    {     0.00000002113,  3.71711179417,    65147.61976813770}, 
    {     0.00000002019,  0.81393923319,      170.67287061920}, 
    {     0.00000002003,  0.38091017375,     6172.86952877200}, 
    {     0.00000002506,  3.74378169126,    10575.40668294180}, 
    {     0.00000002381,  0.10581361289,        7.04623669800}, 
    {     0.00000001949,  4.86892513469,       36.02786667740}, 
    {     0.00000002074,  4.22802468213,     5650.29211067820}, 
    {     0.00000001924,  5.59460549844,     6282.09552892320}, 
    {     0.00000001949,  1.06999605576,     5230.80746680300}, 
    {     0.00000001988,  5.19734705445,     6262.30045449900}, 
    {     0.00000001887,  3.74365662683,       23.87843774780}, 
    {     0.00000001787,  1.25929659066,    12559.03815298200}, 
    {     0.00000001883,  1.90364058477,       15.25247118500}, 
    {     0.00000001816,  3.68083794819,    15110.46611986620}, 
    {     0.00000001701,  4.41109562589,      110.20632121940}, 
    {     0.00000001990,  3.93295788548,     6206.80977871580}, 
    {     0.00000002103,  0.75354936681,    13521.75144159140}, 
    {     0.00000001774,  0.48750515837,     1551.04522264800}, 
    {     0.00000001882,  0.86685462305,    22003.91463486980}, 
    {     0.00000001924,  1.22901099088,      709.93304855830}, 
    {     0.00000002073,  4.62531597856,     6037.24420376200}, 
    {     0.00000001924,  0.60231842492,     6284.05617105960}, 
    {     0.00000001596,  3.98332879712,    13916.01910964160}, 
    {     0.00000001664,  4.41947015623,     8662.24032356300}, 
    {     0.00000001971,  1.04560686192,    18209.33026366019}, 
    {     0.00000001942,  4.31335979989,     6244.94281435360}, 
    {     0.00000001476,  0.93274523818,     2379.16447357160}, 
    {     0.00000001810,  0.49112137707,        1.48447270830}, 
    {     0.00000001346,  1.51574753411,     4136.91043351620}, 
    {     0.00000001528,  5.61833568587,     6127.65545055720}, 
    {     0.00000001791,  3.22191142746,    39302.09696219600}, 
    {     0.00000001747,  3.05595292589,    18319.53658487960}, 
    {     0.00000001432,  4.51123984264,    20426.57109242200}, 
    {     0.00000001695,  0.22049418623,    25158.60171976540}, 
    {     0.00000001242,  4.46665354536,    17256.63153634140}, 
    {     0.00000001463,  4.69248613506,    14945.31617355440}, 
    {     0.00000001205,  1.86911906771,     4590.91018048900}, 
    {     0.00000001190,  2.74169967367,    12569.67481833180}, 
    {     0.00000001222,  5.18120087481,     5333.90024102160}, 
    {     0.00000001390,  5.42888623322,   143571.32428481648}, 
    {     0.00000001473,  1.70487100866,    11712.95531823080}, 
    {     0.00000001362,  2.61069503292,     6062.66320755260}, 
    {     0.00000001148,  6.03008430610,     3634.62102451840}, 
    {     0.00000001198,  5.15296117339,    10177.25767953360}, 
    {     0.00000001266,  0.11422490557,    18422.62935909819}, 
    {     0.00000001411,  1.09910890045,     3496.03282613400}, 
    {     0.00000001349,  2.99804623019,    17654.78053974960}, 
    {     0.00000001253,  2.79844902576,   167283.76158766549}, 
    {     0.00000001311,  1.60941074300,     5481.25491886760}, 
    {     0.00000001079,  6.20304501787,        3.28635741780}, 
    {     0.00000001181,  1.20653777627,      131.54196168640}, 
    {     0.00000001254,  5.45103277799,     6076.89030155420}, 
    {     0.00000001036,  2.32136959491,     7342.45778018060}, 
    {     0.00000001117,  0.38842340979,      949.17560896980}, 
    {     0.00000000966,  3.18352079941,    11087.28512591840}, 
    {     0.00000001171,  3.39635167732,    12562.62858163380}, 
    {     0.00000001121,  0.72631814699,      220.41264243880}, 
    {     0.00000001024,  2.19381113265,    11403.67699557500}, 
    {     0.00000000888,  3.91167196431,     4686.88940770680}, 
    {     0.00000000910,  1.98802695087,      735.87651353180}, 
    {     0.00000000823,  0.48822202854,    24072.92146977640}, 
    {     0.00000001096,  6.17377835617,     5436.99301524020}, 
    {     0.00000000908,  0.44959148878,     7477.52286021600}, 
    {     0.00000000974,  1.52996313552,     9623.68827669120}, 
    {     0.00000000840,  1.79540573407,     5429.87946823940}, 
    {     0.00000000778,  6.17703744517,       38.13303563780}, 
    {     0.00000000776,  4.09859968447,       14.22709400160}, 
    {     0.00000001068,  4.64209577648,    43232.30665841560}, 
    {     0.00000000954,  1.49985885818,     1162.47470440780}, 
    {     0.00000000907,  0.86986870809,    10344.29506538580}, 
    {     0.00000000931,  4.06049877517,    28766.92442448400}, 
    {     0.00000000739,  5.04368192034,      639.89728631400}, 
    {     0.00000000965,  3.44286716197,     1589.07289528380}, 
    {     0.00000000763,  5.86304776787,    16858.48253293320}, 
    {     0.00000000953,  4.20801492835,    11190.37790013700}, 
    {     0.00000000708,  1.72432323967,    13095.84266507740}, 
    {     0.00000000969,  1.64437243011,    29088.81141598500}, 
    {     0.00000000717,  0.16688678895,       11.72935283600}, 
    {     0.00000000962,  3.53101876172,    12416.58850284820}, 
    {     0.00000000745,  5.77741082302,    12592.45001978260}, 
    {     0.00000000672,  1.91091228744,        3.93215326310}, 
    {     0.00000000671,  5.46240758839,    18052.92954315780}, 
    {     0.00000000675,  6.28311649798,     4535.05943692440}, 
    {     0.00000000684,  0.39975011401,     5849.36411211460}, 
    {     0.00000000799,  0.29859056777,    12132.43996210600}, 
    {     0.00000000758,  0.96370719224,     1052.26838318840}, 
    {     0.00000000782,  5.33875702541,    13517.87010623340}, 
    {     0.00000000730,  1.70114998543,    17267.26820169119}, 
    {     0.00000000749,  2.59607005624,    11609.86254401220}, 
    {     0.00000000734,  2.78420497780,      640.87760738220}, 
    {     0.00000000688,  5.15097673557,    16496.36139620240}, 
    {     0.00000000770,  1.62459252416,     4701.11650170840}, 
    {     0.00000000633,  2.20588443066,    25934.12433108940}, 
    {     0.00000000760,  4.21317219403,      377.37360791580}, 
    {     0.00000000584,  2.13420121623,    10557.59416082380}, 
    {     0.00000000572,  0.24649745829,     9779.10867612540}, 
    {     0.00000000573,  3.16435264609,      533.21408344360}, 
    {     0.00000000685,  3.19344289472,    12146.66705610760}, 
    {     0.00000000675,  0.96179234176,    10454.50138660520}, 
    {     0.00000000648,  1.46327342554,     6268.84875598980}, 
    {     0.00000000589,  2.50543543638,     3097.88382272579}, 
    {     0.00000000551,  5.28106257475,     9388.00590941520}, 
    {     0.00000000696,  3.65342155550,     4804.20927592700}, 
    {     0.00000000669,  2.51030059260,     2388.89402044920}, 
    {     0.00000000550,  0.06883090057,    20199.09495963300}, 
    {     0.00000000629,  4.13350997495,    45892.73043315699}, 
    {     0.00000000678,  6.09190163533,      135.62532501000}, 
    {     0.00000000593,  1.50129499103,   226858.23855437008}, 
    {     0.00000000542,  3.58582033525,     6148.01076995600}, 
    {     0.00000000599,  6.12058050643,    18875.52586977400}, 
    {     0.00000000682,  5.02213616830,    17253.04110768959}, 
    {     0.00000000565,  4.29309214275,    11933.36796066960}, 
    {     0.00000000486,  0.77746204893,       27.40155609680}, 
    {     0.00000000503,  0.58974557727,    15671.08175940660}, 
    {     0.00000000616,  4.06539884128,      227.47613278900}, 
    {     0.00000000537,  2.15064382406,    21954.15760939799}, 
    {     0.00000000669,  6.06995500278,    47162.51635463520}, 
    {     0.00000000540,  2.83444221432,     5326.78669402080}, 
    {     0.00000000474,  0.40346826846,     6915.85958930460}, 
    {     0.00000000532,  5.26131065063,    10988.80815753500}, 
    {     0.00000000582,  3.24533095664,      153.77881048480}, 
    {     0.00000000641,  3.24711790399,     2107.03450754240}, 
    {     0.00000000619,  3.08302108547,    33019.02111220460}, 
    {     0.00000000466,  3.14982369789,    10440.27429260360}, 
    {     0.00000000466,  0.90708835651,     5966.68398033480}, 
    {     0.00000000528,  0.81926454470,      813.55028395980}, 
    {     0.00000000603,  3.81378921927,   316428.22867391503}, 
    {     0.00000000559,  1.81894985730,    17996.03116822220}, 
    {     0.00000000437,  2.28631745987,     6303.85124548380}, 
    {     0.00000000518,  4.86068318058,    20597.24396304120}, 
    {     0.00000000424,  6.23520018697,     6489.26139842860}, 
    {     0.00000000518,  6.17617826756,        0.24381748350}, 
    {     0.00000000404,  5.72804304258,     5642.19824260920}, 
    {     0.00000000458,  1.34117773914,     6287.00800325450}, 
    {     0.00000000548,  5.68454458320,   155427.54293624099}, 
    {     0.00000000547,  1.03391472434,     3646.35037735440}, 
    {     0.00000000428,  4.69809687820,      846.08283475120}, 
    {     0.00000000413,  6.02520699390,     6279.48542133960}, 
    {     0.00000000534,  3.03030638223,    66567.48586525429}, 
    {     0.00000000383,  1.49055588040,    19800.94595622480}, 
    {     0.00000000411,  5.28384176408,    18451.07854656599}, 
    {     0.00000000352,  4.68891600525,     4907.30205014560}, 
    {     0.00000000480,  5.36572651091,      348.92442044800}, 
    {     0.00000000344,  5.89157452889,     6546.15977336420}, 
    {     0.00000000340,  0.37557440365,    13119.72110282519}, 
    {     0.00000000434,  4.98417856239,     6702.56049386660}, 
    {     0.00000000332,  2.68909344430,    29296.61538957860}, 
    {     0.00000000448,  2.16478480251,     5905.70224207560}, 
    {     0.00000000344,  2.06546633735,       49.75702547180}, 
    {     0.00000000315,  1.24023810969,     4061.21921539440}, 
    {     0.00000000324,  2.30897526929,     5017.50837136500}, 
    {     0.00000000413,  0.17171692945,     6286.66627864320}, 
    {     0.00000000431,  3.86601101380,    12489.88562870720}, 
    {     0.00000000349,  4.55372493131,     4933.20844033260}, 
    {     0.00000000323,  0.41971136084,    10770.89325626180}, 
    {     0.00000000341,  2.68612860807,       11.04570026390}, 
    {     0.00000000316,  3.52966641606,    17782.73207278420}, 
    {     0.00000000315,  5.63357264999,      568.82187402740}, 
    {     0.00000000340,  3.83571212349,    10660.68693504240}, 
    {     0.00000000296,  0.62703270489,    20995.39296644940}, 
    {     0.00000000405,  1.00084965393,    16460.33352952499}, 
    {     0.00000000414,  1.21998752076,    51092.72605085480}, 
    {     0.00000000336,  4.71465945215,     6179.98307577280}, 
    {     0.00000000361,  3.71235613733,    28237.23345938940}, 
    {     0.00000000327,  1.05606504715,    11919.14086666800}, 
    {     0.00000000327,  6.14222420980,     6254.62666252360}, 
    {     0.00000000268,  2.47224339737,      664.75604513000}, 
    {     0.00000000269,  1.86210872453,    23141.55838292460}, 
    {     0.00000000345,  0.93461290184,     6058.73105428950}, 
    {     0.00000000353,  4.50033650657,    36949.23080842420}, 
    {     0.00000000344,  6.26166140367,    24356.78078864160}, 
    {     0.00000000300,  4.46964001975,     6418.14093002680}, 
    {     0.00000000260,  4.04967464725,     6525.80445396540}, 
    {     0.00000000298,  2.20018811054,   156137.47598479928}, 
    {     0.00000000253,  3.49930797865,    29864.33402730900}, 
    {     0.00000000254,  2.44883530154,     5331.35744374080}, 
    {     0.00000000296,  0.84341183907,     5729.50644714900}, 
    {     0.00000000241,  2.00721298729,    16737.57723659660}, 
    {     0.00000000311,  1.23668016336,     6281.59137728310}, 
    {     0.00000000332,  3.55576945724,     7668.63742494250}, 
    {     0.00000000236,  2.47437156031,     6245.04817735560}, 
    {     0.00000000264,  4.43924412283,    12964.30070339100}, 
    {     0.00000000257,  1.79654471948,    11080.17157891760}, 
    {     0.00000000260,  3.33077596060,     5888.44996493220}, 
    {     0.00000000285,  0.30886361430,    11823.16163945020}, 
    {     0.00000000290,  5.70141882483,       77.67377042800}, 
    {     0.00000000255,  4.00939662024,     5881.40372823420}, 
    {     0.00000000253,  4.73318512715,    16723.35014259500}, 
    {     0.00000000228,  0.95333661324,     5540.08578945880}, 
    {     0.00000000281,  1.29199646396,    22805.73556599360}, 
    {     0.00000000319,  1.38633229189,   163096.18036118349}, 
    {     0.00000000224,  1.65156322696,    10027.90319572920}, 
    {     0.00000000226,  0.34125379653,    17796.95916678580}, 
    {     0.00000000236,  4.19817431922,       19.66976089979}, 
    {     0.00000000281,  4.14114899916,    12539.85338018300}, 
    {     0.00000000275,  5.50306930248,       32.53255079140}, 
    {     0.00000000223,  5.23334210294,       56.89837493560}, 
    {     0.00000000217,  6.08598789777,     6805.65326808520}, 
    {     0.00000000228,  5.17114391778,    11720.06886523160}, 
    {     0.00000000274,  4.50716805713,     6016.46880826960}, 
    {     0.00000000245,  3.96486270306,       22.77520145080}, 
    {     0.00000000220,  4.72078081970,        6.62855890001}, 
    {     0.00000000207,  5.71701403951,       41.55079098480}, 
    {     0.00000000204,  3.91227411250,     2699.73481931760}, 
    {     0.00000000209,  0.86881969024,     6321.10352262720}, 
    {     0.00000000200,  2.11984442601,     4274.51831083240}, 
    {     0.00000000200,  5.39839888151,     6019.99192661860}, 
    {     0.00000000209,  5.67606291663,    11293.47067435560}, 
    {     0.00000000252,  1.64965729350,     9380.95967271720}, 
    {     0.00000000275,  5.04826903506,       73.29712585900}, 
    {     0.00000000208,  1.88207277133,    11300.58422135640}, 
    {     0.00000000206,  5.07284889330,     6277.55292568400}, 
    {     0.00000000272,  0.74640924904,     1975.49254585600}, 
    {     0.00000000199,  3.30813142103,    22743.40937951640}, 
    {     0.00000000269,  4.48560812155,    64471.99124174489}, 
    {     0.00000000192,  2.17463565107,     5863.59120611620}, 
    {     0.00000000228,  5.85373115869,      128.01884333740}, 
    {     0.00000000261,  2.64321183295,    55022.93574707440}, 
    {     0.00000000196,  2.48537622320,    16062.18452611680}, 
    {     0.00000000187,  1.31891760280,    29826.30635467320}, 
    {     0.00000000220,  5.75012110079,       29.42950853600}, 
    {     0.00000000187,  4.03230554718,      467.96499035440}, 
    {     0.00000000200,  5.60555262896,     1066.49547719000}, 
    {     0.00000000231,  1.09802712785,    12341.80690428090}, 
    {     0.00000000198,  0.29474229005,      149.56319713460}, 
    {     0.00000000249,  5.10477023170,     7875.67186362420}, 
    {     0.00000000179,  0.87066197995,    12721.57209941700}, 
    {     0.00000000203,  1.56914310573,    28286.99048486120}, 
    {     0.00000000198,  3.54061588502,       30.91412563500}, 
    {     0.00000000171,  3.45366018621,     5327.47610838280}, 
    {     0.00000000183,  0.72325421604,     6272.03014972750}, 
    {     0.00000000216,  2.97175184412,    19402.79695281660}, 
    {     0.00000000168,  2.51559879907,    23937.85638974100}, 
    {     0.00000000195,  0.09045393425,      156.40072050240}, 
    {     0.00000000216,  0.42162375972,    23539.70738633280}, 
    {     0.00000000189,  0.37542530191,     9814.60410029120}, 
    {     0.00000000207,  2.01752547259,   238004.52415723629}, 
    {     0.00000000218,  2.36835893645,    16627.37091537720}, 
    {     0.00000000166,  4.23182960518,    16840.67001081519}, 
    {     0.00000000200,  2.02153258098,    16097.67995028260}, 
    {     0.00000000169,  0.91318727000,       95.97922721780}, 
    {     0.00000000211,  5.73370637657,      151.89728108520}, 
    {     0.00000000204,  0.42643085174,      515.46387109300}, 
    {     0.00000000212,  3.00223140894,    12043.57428188900}, 
    {     0.00000000192,  5.46153589821,     6379.05507720920}, 
    {     0.00000000160,  6.23798383332,      202.25339517410}, 
    {     0.00000000215,  0.20889073407,     5621.84292321040}, 
    {     0.00000000150,  3.12999753018,      799.82112516540}, 
    {     0.00000000187,  2.12345787867,      491.66329245880}, 
    {     0.00000000192,  1.33928820063,      394.62588505920}, 
    {     0.00000000149,  2.65697593276,       21.33564046700}, 
    {     0.00000000146,  5.58021191726,      412.37109687440}, 
    {     0.00000000156,  3.75657676380,    12323.42309600880}, 
    {     0.00000000143,  3.28248547724,       29.82143814880}, 
    {     0.00000000144,  1.07862546598,     1265.56747862640}, 
    {     0.00000000148,  0.23386631090,    10021.83728009940}, 
    {     0.00000000164,  0.94288727597,    14919.01785375460}, 
    {     0.00000000193,  5.92751083827,    40879.44050464380}, 
    {     0.00000000140,  4.97612440269,      158.94351778320}, 
    {     0.00000000148,  2.61651818006,    17157.06188047180}, 
    {     0.00000000140,  3.66947933935,    26084.02180621620}, 
    {     0.00000000147,  5.09968173403,      661.23292678100}, 
    {     0.00000000147,  1.36976712162,     4171.42553661380}, 
    {     0.00000000134,  4.79432636012,      111.18664228760}, 
    {     0.00000000140,  1.27748013377,      107.66352393860}, 
    {     0.00000000171,  2.77586207403,    26735.94526221320}, 
    {     0.00000000183,  5.43418358741,      369.69981594040}, 
    {     0.00000000134,  3.09132862833,       17.81252211800}, 
    {     0.00000000132,  3.05633896779,    22490.96212149340}, 
    {     0.00000000181,  4.22950689891,      966.97087743560}, 
    {     0.00000000166,  3.67660435776,    15508.61512327440}, 
    {     0.00000000152,  5.28885813387,    12669.24447420140}, 
    {     0.00000000150,  5.86819430895,    97238.62754448749}, 
    {     0.00000000145,  5.07330784304,       87.30820453981}, 
    {     0.00000000133,  5.65471067133,       31.97230581680}, 
    {     0.00000000124,  2.83326216907,    12566.21901028560}, 
    {     0.00000000140,  5.84212721453,    22476.73502749179}, 
    {     0.00000000134,  3.12858101887,    32217.20018108080}, 
    {     0.00000000137,  0.86487461904,     9924.81042151060}, 
    {     0.00000000172,  1.98369595114,   174242.46596404970}, 
    {     0.00000000170,  4.41115280254,   327574.51427678125}, 
    {     0.00000000128,  4.49087631612,    31415.37924995700}, 
    {     0.00000000151,  0.46542092001,    39609.65458316560}, 
    {     0.00000000153,  3.78801830344,    17363.24742890899}, 
    {     0.00000000165,  5.31654110459,    16943.76278503380}, 
    {     0.00000000165,  4.06747587817,    58953.14544329400}, 
    {     0.00000000118,  0.63846333239,        6.06591562980}, 
    {     0.00000000159,  0.86086959274,   221995.02880149524}, 
    {     0.00000000119,  5.96432932413,     1385.89527633620}, 
    {     0.00000000114,  5.16516114595,    25685.87280280800}, 
    {     0.00000000112,  4.92889233335,       56.80326216980}, 
    {     0.00000000119,  2.40626699328,    18635.92845453620}, 
    {     0.00000000115,  0.23374479051,      418.92439890060}, 
    {     0.00000000113,  2.79387576740,     6272.43918464160}, 
    {     0.00000000122,  0.93694072400,    24492.40611365159}, 
    {     0.00000000133,  4.87155573413,    22345.26037610820}, 
    {     0.00000000113,  3.80362889046,     6293.71251534120}, 
    {     0.00000000130,  3.72996018683,    12573.26524698360}, 
    {     0.00000000107,  3.40227152756,    21393.54196985760}, 
    {     0.00000000122,  1.00385670948,    95143.13292097810}, 
    {     0.00000000140,  1.09413075700,    44809.65020086340}, 
    {     0.00000000112,  6.05462382871,      433.71173787680}, 
    {     0.00000000123,  4.55640196386,   239424.39025435288}, 
    {     0.00000000104,  1.54931540602,      127.95153303460}, 
    {     0.00000000111,  3.04186517428,     8982.81066930900}, 
    {     0.00000000102,  4.12448497391,    15664.03552270859}, 
    {     0.00000000107,  4.67919356465,    77690.75950573849}, 
    {     0.00000000118,  4.52320170120,    19004.64794940840}, 
    {     0.00000000107,  5.71774478555,    77736.78343050249}, 
    {     0.00000000103,  4.79332126649,    33794.54372352860}, 
    {     0.00000000143,  1.81201813018,     4214.06901508480}, 
    {     0.00000000102,  3.75817786570,    58864.54391814630}, 
    {     0.00000000125,  1.14419195615,      625.67019231240}, 
    {     0.00000000124,  3.27736513892,    12566.08438968000}, 
    {     0.00000000110,  1.08705709966,     2787.04302385740}, 
    {     0.00000000102,  4.75119578149,    12242.64628332540}, 
    {     0.00000000101,  4.91289409429,      401.67212175720}, 
    {     0.00000000138,  2.89578979744,     9411.46461508720}, 
    {     0.00000000129,  1.23516042371,    12029.34718788740}, 
    {     0.00000000138,  2.45654707076,     7576.56007357400}, 
    {     0.00000000098,  5.44771765020,    29026.48522950779}, 
    {     0.00000000134,  1.43105174912,    86464.61331683119}, 
    {     0.00000000108,  0.98989774940,     5636.06501667660}, 
    {     0.00000000117,  5.17362847134,    34520.30930938080}, 
    {     0.00000000097,  3.34717130592,    16310.97904572060}, 
    {     0.00000000107,  2.94547931851,    24602.61243487099}, 
    {     0.00000000098,  4.37041908717,    34513.26307268280}, 
    {     0.00000000125,  2.72182830814,    24065.80792277559}, 
    {     0.00000000111,  0.58899131543,     6303.43116939020}, 
    {     0.00000000102,  0.66938025772,    10239.58386601080}, 
    {     0.00000000119,  1.21666517886,     1478.86657406440}, 
    {     0.00000000111,  1.04321934681,    16522.65971600220}, 
    {     0.00000000094,  4.31076339857,    26880.31981303260}, 
    {     0.00000000098,  4.14248433763,     6599.46771964800}, 
    {     0.00000000095,  2.89807657534,    34911.41207609100}, 
    {     0.00000000097,  0.89642320201,    71980.63357473118}, 
    {     0.00000000095,  0.65717727948,     6288.59877429880}, 
    {     0.00000000116,  4.19967201116,      206.70073729660}, 
    {     0.00000000095,  1.78315464297,    18139.29450141590}, 
    {     0.00000000099,  1.37437847718,     1039.02661079040}, 
    {     0.00000000126,  3.21642544972,   305281.94307104882}, 
    {     0.00000000094,  0.68995031860,     7834.12107263940}, 
    {     0.00000000095,  5.58111421744,     3104.93005942380}, 
    {     0.00000000108,  0.52696637156,      276.74577186440}, 
    {     0.00000000124,  3.43899862683,   172146.97134054029}, 
    {     0.00000000087,  1.18764938806,    18842.11400297339}, 
    {     0.00000000087,  0.09094166389,    15141.39079431200}, 
    {     0.00000000108,  1.03363414379,    82576.98122099529}, 
    {     0.00000000119,  2.86729109648,    90394.82301305079}, 
    {     0.00000000104,  3.39218586218,      290.97286586600}, 
    {     0.00000000094,  5.68284937444,    32367.09765620760}, 
    {     0.00000000117,  0.78475956902,    83286.91426955358}, 
    {     0.00000000105,  3.96551057233,     6357.85744855870}, 
    {     0.00000000094,  4.03443174853,    13341.67431130680}, 
    {     0.00000000096,  0.92742567538,     1062.90504853820}, 
    {     0.00000000089,  4.45371820659,      792.77488846740}, 
    {     0.00000000087,  0.40013481685,    90279.92316810328}, 
    {     0.00000000113,  2.48165313368,    48739.85989708300}, 
    {     0.00000000087,  3.43122851097,    27707.54249429480}, 
    {     0.00000000101,  5.32081603011,     2301.58581590939}, 
    {     0.00000000084,  0.67020912458,    28628.33622609960}, 
    {     0.00000000082,  0.87060089842,    10241.20229116720}, 
    {     0.00000000086,  4.62064792290,    36147.40987730040}, 
    {     0.00000000080,  4.77649625396,     6819.88036208680}, 
    {     0.00000000095,  2.87032913492,    23020.65308658799}, 
    {     0.00000000107,  5.77864921649,    34115.11406927460}, 
    {     0.00000000110,  3.32898859416,    72140.62866668739}, 
    {     0.00000000087,  4.40657711727,      142.17862703620}, 
    {     0.00000000103,  4.22506726810,    30666.15495843280}, 
    {     0.00000000082,  3.89404392552,     5547.19933645960}, 
    {     0.00000000109,  1.94546065204,    24279.10701821359}, 
    {     0.00000000087,  4.32472045435,      742.99006053260}, 
    {     0.00000000107,  4.91580912547,      277.03499374140}, 
    {     0.00000000088,  2.10180817713,    26482.17080962440}, 
    {     0.00000000086,  4.01895021483,    12491.37010141550}, 
    {     0.00000000106,  5.49092372854,    62883.35513951360}, 
    {     0.00000000080,  6.19785704950,     6709.67404086740}, 
    {     0.00000000105,  2.44166529175,     6298.32832117640}, 
    {     0.00000000083,  4.90662164029,       51.28033786241}, 
    {     0.00000000074,  2.34622575625,     7018.95236352320}, 
    {     0.00000000078,  6.06947270265,   148434.53403769129}, 
    {     0.00000000079,  3.03048221644,      838.96928775040}, 
    {     0.00000000073,  3.05008665738,      567.71863773040}, 
    {     0.00000000102,  3.59223815483,    22380.75580027400}, 
    {     0.00000000084,  0.46604373274,       45.14121963660}, 
    {     0.00000000092,  4.12917744733,    18216.44381066100}, 
    {     0.00000000091,  0.49382398887,     6453.74872061060}, 
    {     0.00000000073,  1.72446569088,    21424.46664430340}, 
    {     0.00000000069,  1.49372677730,    21548.96236929180}, 
    {     0.00000000069,  4.73181018058,     8858.31494432060}, 
    {     0.00000000077,  0.47683782532,    11520.99686379520}, 
    {     0.00000000078,  5.43942630990,    15265.88651930040}, 
    {     0.00000000077,  2.53773750372,       76.26607127560}, 
    {     0.00000000069,  2.53932635192,     9910.58332750900}, 
    {     0.00000000075,  0.15594729210,    23006.42599258639}, 
    {     0.00000000078,  2.41004950269,     6393.28217121080}, 
    {     0.00000000067,  5.05152846816,    57375.80190084620}, 
    {     0.00000000077,  3.91075604860,    24383.07910844140}, 
    {     0.00000000067,  0.78239147387,    12779.45079542080}, 
    {     0.00000000071,  1.24817900687,    10419.98628350760}, 
    {     0.00000000067,  5.77851227760,     6311.52503745920}, 
    {     0.00000000061,  2.66705754411,    18852.75066832320}, 
    {     0.00000000079,  1.89137330427,     6528.90749622080}, 
    {     0.00000000084,  5.11523704221,    50317.20343953080}, 
    {     0.00000000059,  3.38290426621,    35707.71008290740}, 
    {     0.00000000065,  4.66767908854,    26709.64694241340}, 
    {     0.00000000079,  5.59773848156,    71960.38658322369}, 
    {     0.00000000061,  3.30733768968,    18845.70443162520}, 
    {     0.00000000057,  3.90831298022,     5999.21653112620}, 
    {     0.00000000058,  3.92572820333,    30348.88377276700}, 
    {     0.00000000061,  0.05695045822,     7856.89627409019}, 
    {     0.00000000061,  5.63297960691,     7863.94251078820}, 
    {     0.00000000068,  2.53986117507,    20452.86941222180}, 
    {     0.00000000053,  5.44021645443,    32370.97899156560}, 
    {     0.00000000059,  4.95695131145,    11925.27409260060}, 
    {     0.00000000059,  5.34668243273,   137288.24843482509}, 
    {     0.00000000056,  4.05779957425,    17892.93839400359}, 
    {     0.00000000053,  3.94182462468,    18624.88275427230}, 
    {     0.00000000049,  2.11782803206,    22594.05489571199}, 
    {     0.00000000062,  2.47154086715,    12345.73905754400}, 
    {     0.00000000049,  5.76596937380,    18606.49894600020}, 
    {     0.00000000052,  6.20902099741,    21947.11137270000}, 
    {     0.00000000051,  3.13287981215,    33326.57873317420}, 
    {     0.00000000057,  6.17003357597,    61306.01159706580}, 
    {     0.00000000064,  5.66596451842,    34596.36465465240}, 
    {     0.00000000066,  3.92262335500,    69853.35207568129}, 
    {     0.00000000053,  5.51119362049,    77710.24834977149}, 
    {     0.00000000053,  4.88573986965,    77717.29458646949}, 
    {     0.00000000048,  2.71399112516,    20760.42703319140}, 
    {     0.00000000046,  6.08376164442,    29822.78323632420}, 
    {     0.00000000052,  0.31397481380,    37724.75341974820}, 
    {     0.00000000045,  5.53587248663,     6262.72053059260}, 
    {     0.00000000059,  2.45437896854,    69166.43098950500}, 
    {     0.00000000060,  5.24261569842,    56600.27928952220}, 
    {     0.00000000051,  6.15794342172,    11616.97609101300}, 
    {     0.00000000060,  1.74758109828,    44034.12758953940}, 
    {     0.00000000049,  5.08973141046,    33990.61834428620}, 
    {     0.00000000044,  3.28270864884,    29424.63423291600}, 
    {     0.00000000052,  5.34866947943,    28313.28880466100}, 
    {     0.00000000059,  2.12384971916,    36173.70819710020}, 
    {     0.00000000050,  0.46480931695,    25287.72379939980}, 
    {     0.00000000044,  2.05503517210,    63658.87775083760}, 
    {     0.00000000044,  1.71009200258,    13362.44970679920}, 
    {     0.00000000041,  3.91721318316,     6279.19451463340}, 
    {     0.00000000042,  1.52106001448,    23550.34405168259}, 
    {     0.00000000042,  3.10938258068,    84672.47584450469}, 
    {     0.00000000041,  3.78863023321,    35050.00027447539}, 
    {     0.00000000042,  5.57543459263,    38500.27603107220}, 
    {     0.00000000040,  5.55145719363,    12565.17137891460}, 
    {     0.00000000054,  0.88935492100,    50290.90511973100}, 
    {     0.00000000055,  2.50268487636,    77828.67131306800}, 
    {     0.00000000054,  4.16257918787,    22910.44676536859}, 
    {     0.00000000041,  2.32141215064,     6286.95718534940}, 
    {     0.00000000045,  3.18590576311,    45585.17281218740}, 
    {     0.00000000045,  2.24348941683,    23646.32327890039}, 
    {     0.00000000043,  3.87892110950,     6549.68289171320}, 
    {     0.00000000048,  2.11364139445,    31570.79964939120}, 
    {     0.00000000043,  5.55099558987,    12359.96615154560}, 
    {     0.00000000041,  4.88191569433,    23536.11695768099}, 
    {     0.00000000049,  2.44790922235,    13613.80427733600}, 
    {     0.00000000047,  3.58181693910,     4797.09572892620}, 
};


static const struct ln_vsop ALIGN32 earth_longitude_l1[LONG_L1] = {
    {  6283.07584999140,  0.00000000000,        0.00000000000}, 
    {     0.00206058863,  2.67823455808,     6283.07584999140}, 
    {     0.00004303419,  2.63512233481,    12566.15169998280}, 
    {     0.00000425264,  1.59046982018,        3.52311834900}, 
    {     0.00000109017,  2.96631010675,     1577.34354244780}, 
    {     0.00000093479,  2.59211109542,    18849.22754997420}, 
    {     0.00000119305,  5.79555765566,       26.29831979980}, 
    {     0.00000072121,  1.13840581212,      529.69096509460}, 
    {     0.00000067784,  1.87453300345,      398.14900340820}, 
    {     0.00000067350,  4.40932832004,     5507.55323866740}, 
    {     0.00000059045,  2.88815790631,     5223.69391980220}, 
    {     0.00000055976,  2.17471740035,      155.42039943420}, 
    {     0.00000045411,  0.39799502896,      796.29800681640}, 
    {     0.00000036298,  0.46875437227,      775.52261132400}, 
    {     0.00000028962,  2.64732254645,        7.11354700080}, 
    {     0.00000019097,  1.84628376049,     5486.77784317500}, 
    {     0.00000020844,  5.34138275149,        0.98032106820}, 
    {     0.00000018508,  4.96855179468,      213.29909543800}, 
    {     0.00000016233,  0.03216587315,     2544.31441988340}, 
    {     0.00000017293,  2.99116760630,     6275.96230299060}, 
    {     0.00000015832,  1.43049301283,     2146.16541647520}, 
    {     0.00000014608,  1.20469793690,    10977.07880469900}, 
    {     0.00000011877,  3.25805082007,     5088.62883976680}, 
    {     0.00000011514,  2.07502080082,     4694.00295470760}, 
    {     0.00000009721,  4.23925865260,     1349.86740965880}, 
    {     0.00000009969,  1.30263423409,     6286.59896834040}, 
    {     0.00000009452,  2.69956827011,      242.72860397400}, 
    {     0.00000012461,  2.83432282119,     1748.01641306700}, 
    {     0.00000011808,  5.27379760438,     1194.44701022460}, 
    {     0.00000008577,  5.64476085980,      951.71840625060}, 
    {     0.00000010641,  0.76614722966,      553.56940284240}, 
    {     0.00000007576,  5.30056172859,     2352.86615377180}, 
    {     0.00000005764,  1.77228445837,     1059.38193018920}, 
    {     0.00000006385,  2.65034514038,     9437.76293488700}, 
    {     0.00000005223,  5.66135782131,    71430.69561812909}, 
    {     0.00000005315,  0.91110018969,     3154.68708489560}, 
    {     0.00000006101,  4.66633726278,     4690.47983635860}, 
    {     0.00000004335,  0.23934560382,     6812.76681508600}, 
    {     0.00000005041,  1.42489704722,     6438.49624942560}, 
    {     0.00000004259,  0.77355543889,    10447.38783960440}, 
    {     0.00000005200,  1.85528830215,      801.82093112380}, 
    {     0.00000003744,  2.00119905572,     8031.09226305840}, 
    {     0.00000003553,  2.42789590229,    14143.49524243060}, 
    {     0.00000003372,  3.86210786421,     1592.59601363280}, 
    {     0.00000003380,  0.88545388924,    12036.46073488820}, 
    {     0.00000003196,  3.19713328141,     4705.73230754360}, 
    {     0.00000003221,  0.61601048990,     8429.24126646660}, 
    {     0.00000004132,  5.23992584671,     7084.89678111520}, 
    {     0.00000002970,  6.07029819073,     4292.33083295040}, 
    {     0.00000002900,  2.32464208411,       20.35531939880}, 
    {     0.00000003504,  4.79976712702,     6279.55273164240}, 
    {     0.00000002950,  1.43108874817,     5746.27133789600}, 
    {     0.00000002697,  4.80365209201,     7234.79425624200}, 
    {     0.00000002531,  6.22289990904,     6836.64525283380}, 
    {     0.00000002745,  0.93466065396,     5760.49843189760}, 
    {     0.00000003250,  3.39951915286,     7632.94325965020}, 
    {     0.00000002278,  5.00339914806,    17789.84561978500}, 
    {     0.00000002076,  3.95551309007,    10213.28554621100}, 
    {     0.00000002061,  2.22407719190,     5856.47765911540}, 
    {     0.00000002252,  5.67166717686,    11499.65622279280}, 
    {     0.00000002148,  5.20182663314,    11513.88331679440}, 
    {     0.00000001886,  0.53198539077,     3340.61242669980}, 
    {     0.00000001875,  4.73511969924,    83996.84731811189}, 
    {     0.00000002060,  2.54985307819,    25132.30339996560}, 
    {     0.00000001794,  1.47435300254,     4164.31198961300}, 
    {     0.00000001778,  3.02473091781,        5.52292430740}, 
    {     0.00000002036,  0.90908165072,     6256.77753019160}, 
    {     0.00000002064,  2.27051326957,      522.57741809380}, 
    {     0.00000001773,  3.03090500693,     5753.38488489680}, 
    {     0.00000001569,  6.12406216872,     5216.58037280140}, 
    {     0.00000001590,  4.63713748247,        3.28635741780}, 
    {     0.00000001533,  4.20305593883,    13367.97263110660}, 
    {     0.00000001427,  1.19087535126,     3894.18182954220}, 
    {     0.00000001376,  4.24955891338,      426.59819087600}, 
    {     0.00000001375,  3.09301252193,      135.06508003540}, 
    {     0.00000001308,  3.08492138890,     5643.17856367740}, 
    {     0.00000001340,  5.76513167968,     6040.34724601740}, 
    {     0.00000001250,  3.07748196332,    11926.25441366880}, 
    {     0.00000001551,  3.07664090662,     6681.22485339960}, 
    {     0.00000001148,  3.24144202282,    12168.00269657460}, 
    {     0.00000001268,  2.09201189992,     6290.18939699220}, 
    {     0.00000001248,  3.44506939791,      536.80451209540}, 
    {     0.00000001118,  2.31830078762,    16730.46368959580}, 
    {     0.00000001105,  5.31966001019,       23.87843774780}, 
    {     0.00000001012,  3.74953487087,     7860.41939243920}, 
    {     0.00000001025,  2.44683771610,     1990.74501704100}, 
    {     0.00000000962,  0.81771017882,        3.88133535800}, 
    {     0.00000000911,  0.41724352112,     7079.37385680780}, 
    {     0.00000001091,  3.98233608618,    11506.76976979360}, 
    {     0.00000000957,  4.07671436153,     6127.65545055720}, 
    {     0.00000000835,  5.28348689371,    11790.62908865880}, 
    {     0.00000000802,  3.88779080089,    10973.55568635000}, 
    {     0.00000000773,  2.41044394817,     1589.07289528380}, 
    {     0.00000000758,  1.30034365873,      103.09277421860}, 
    {     0.00000000749,  4.96281442361,     6496.37494542940}, 
    {     0.00000000765,  3.36312388424,       36.02786667740}, 
    {     0.00000000915,  5.41549763095,      206.18554843720}, 
    {     0.00000000776,  2.57589060224,    11371.70468975820}, 
    {     0.00000000772,  3.98363364977,      955.59974160860}, 
    {     0.00000000749,  5.17900231417,    10969.96525769820}, 
    {     0.00000000806,  0.34226117299,     9917.69687450980}, 
    {     0.00000000728,  5.20962563787,       38.02767263580}, 
    {     0.00000000685,  2.77592961854,       20.77539549240}, 
    {     0.00000000636,  4.28242193632,       28.44918746780}, 
    {     0.00000000608,  5.63278510221,    10984.19235169980}, 
    {     0.00000000704,  5.60739437733,     3738.76143010800}, 
    {     0.00000000685,  0.38876148682,       15.25247118500}, 
    {     0.00000000601,  0.73489602442,      419.48464387520}, 
    {     0.00000000716,  2.65286869987,     6309.37416979120}, 
    {     0.00000000584,  5.54508741381,    17298.18232732620}, 
    {     0.00000000628,  1.11733054796,     7058.59846131540}, 
    {     0.00000000688,  2.59684132401,     3496.03282613400}, 
    {     0.00000000485,  0.44470714066,    12352.85260454480}, 
    {     0.00000000562,  2.82510352358,     3930.20969621960}, 
    {     0.00000000597,  5.27675789973,    10575.40668294180}, 
    {     0.00000000583,  3.18931539860,     4732.03062734340}, 
    {     0.00000000526,  5.01737745304,     5884.92684658320}, 
    {     0.00000000540,  1.29182747488,      640.87760738220}, 
    {     0.00000000481,  5.49721461067,     5230.80746680300}, 
    {     0.00000000406,  5.21253018484,      220.41264243880}, 
    {     0.00000000395,  1.87489912123,    16200.77272450120}, 
    {     0.00000000367,  0.88533542945,     6283.14316029419}, 
    {     0.00000000369,  3.84778078192,    18073.70493865020}, 
    {     0.00000000379,  0.37991716505,    10177.25767953360}, 
    {     0.00000000356,  3.84152910109,    11712.95531823080}, 
    {     0.00000000374,  5.01577520608,        7.04623669800}, 
    {     0.00000000381,  4.30250406634,     6062.66320755260}, 
    {     0.00000000471,  0.86388942467,     6069.77675455340}, 
    {     0.00000000367,  1.32943839930,     6283.00853968860}, 
    {     0.00000000460,  5.19667219582,     6284.05617105960}, 
    {     0.00000000333,  5.54250425107,     4686.88940770680}, 
    {     0.00000000341,  4.36524495363,     7238.67559160000}, 
    {     0.00000000336,  4.00205876835,     3097.88382272579}, 
    {     0.00000000359,  6.22679790284,      245.83164622940}, 
    {     0.00000000307,  2.35299010924,      170.67287061920}, 
    {     0.00000000343,  3.77164927142,     6076.89030155420}, 
    {     0.00000000296,  5.44138799494,    17260.15465469040}, 
    {     0.00000000328,  0.13817705132,    11015.10647733480}, 
    {     0.00000000269,  1.13308244952,    12569.67481833180}, 
    {     0.00000000263,  0.00550737510,     4136.91043351620}, 
    {     0.00000000282,  5.04399588559,     7477.52286021600}, 
    {     0.00000000280,  3.13703211405,    12559.03815298200}, 
    {     0.00000000259,  0.93882269388,     5642.19824260920}, 
    {     0.00000000292,  1.98426314297,    12132.43996210600}, 
    {     0.00000000247,  3.84244798673,     5429.87946823940}, 
    {     0.00000000319,  5.04170148790,    90617.73743129970}, 
    {     0.00000000245,  5.70469737024,    65147.61976813770}, 
    {     0.00000000318,  1.35581968834,    78051.58573131690}, 
    {     0.00000000241,  0.99469787369,     3634.62102451840}, 
    {     0.00000000246,  3.06168069393,      110.20632121940}, 
    {     0.00000000239,  6.11854529589,    11856.21865142450}, 
    {     0.00000000267,  0.65297608414,    21228.39202354580}, 
    {     0.00000000262,  1.51070507866,    12146.66705610760}, 
    {     0.00000000230,  1.75923794017,     9779.10867612540}, 
    {     0.00000000223,  2.00967043606,     6172.86952877200}, 
    {     0.00000000246,  1.10411690861,     6282.09552892320}, 
    {     0.00000000214,  4.03840492266,    14314.16811304980}, 
    {     0.00000000212,  2.13695623228,     5849.36411211460}, 
    {     0.00000000207,  3.07724246401,       11.72935283600}, 
    {     0.00000000207,  6.10303325026,    23543.23050468179}, 
    {     0.00000000266,  1.00720021877,     2388.89402044920}, 
    {     0.00000000217,  6.27840212312,    17267.26820169119}, 
    {     0.00000000231,  5.37372783468,    13916.01910964160}, 
    {     0.00000000204,  2.34615348695,      266.60704172180}, 
    {     0.00000000195,  5.55015549753,     6133.51265285680}, 
    {     0.00000000203,  4.65616806503,    24072.92146977640}, 
    {     0.00000000188,  2.52682282169,     6525.80445396540}, 
    {     0.00000000177,  1.73426919199,   154717.60988768269}, 
    {     0.00000000187,  4.76501318048,     4535.05943692440}, 
    {     0.00000000186,  4.63080493407,    10440.27429260360}, 
    {     0.00000000183,  3.20060840641,     8635.94200376320}, 
    {     0.00000000172,  1.45551703877,     9225.53927328300}, 
    {     0.00000000162,  3.30665137166,      639.89728631400}, 
    {     0.00000000168,  2.17671416605,       27.40155609680}, 
    {     0.00000000160,  1.68168712750,    15110.46611986620}, 
    {     0.00000000194,  2.79243768345,     7342.45778018060}, 
    {     0.00000000183,  0.56273524797,    13517.87010623340}, 
    {     0.00000000172,  5.97039514134,     4701.11650170840}, 
    {     0.00000000179,  3.58450811616,       87.30820453981}, 
    {     0.00000000152,  2.84070476839,     5650.29211067820}, 
    {     0.00000000156,  1.07156076421,    18319.53658487960}, 
    {     0.00000000182,  0.44053620124,    17253.04110768959}, 
    {     0.00000000142,  1.46290137520,    11087.28512591840}, 
    {     0.00000000131,  5.40912137746,     2699.73481931760}, 
    {     0.00000000144,  2.07312089638,    25158.60171976540}, 
    {     0.00000000147,  6.15107800602,     9623.68827669120}, 
    {     0.00000000141,  5.55739979498,    10454.50138660520}, 
    {     0.00000000135,  0.06098129430,    16723.35014259500}, 
    {     0.00000000123,  5.81194797368,    17256.63153634140}, 
    {     0.00000000124,  2.36269386269,     4933.20844033260}, 
    {     0.00000000126,  3.47483886466,    22483.84857449259}, 
    {     0.00000000159,  5.63944722033,     5729.50644714900}, 
    {     0.00000000137,  1.93811728826,    20426.57109242200}, 
    {     0.00000000123,  3.92815962825,    17996.03116822220}, 
    {     0.00000000148,  3.02542567608,     1551.04522264800}, 
    {     0.00000000121,  0.05537321071,    13095.84266507740}, 
    {     0.00000000120,  5.91904349732,     6206.80977871580}, 
    {     0.00000000134,  3.11122937825,    21954.15760939799}, 
    {     0.00000000119,  5.52143897201,      709.93304855830}, 
    {     0.00000000122,  3.00840036775,    19800.94595622480}, 
    {     0.00000000127,  1.37534182407,    14945.31617355440}, 
    {     0.00000000141,  2.56886299638,     1052.26838318840}, 
    {     0.00000000123,  2.83671175442,    11919.14086666800}, 
    {     0.00000000118,  0.81918292547,     5331.35744374080}, 
    {     0.00000000151,  2.68728567951,    11769.85369316640}, 
    {     0.00000000119,  5.08654046247,     5481.25491886760}, 
    {     0.00000000113,  4.42675663942,    18422.62935909819}, 
    {     0.00000000153,  2.46021790779,    11933.36796066960}, 
    {     0.00000000108,  1.04936452151,    11403.67699557500}, 
    {     0.00000000128,  0.99810456461,     8827.39026987480}, 
    {     0.00000000144,  2.54869747042,      227.47613278900}, 
    {     0.00000000150,  4.50631437136,     2379.16447357160}, 
    {     0.00000000109,  0.29269062317,    16737.57723659660}, 
    {     0.00000000122,  4.23040027813,       29.42950853600}, 
    {     0.00000000111,  5.16970710025,    17782.73207278420}, 
    {     0.00000000105,  1.61738153441,    13119.72110282519}, 
    {     0.00000000100,  3.52204690579,    18052.92954315780}, 
    {     0.00000000108,  1.08493117155,    16858.48253293320}, 
    {     0.00000000135,  3.20160616970,     6262.30045449900}, 
    {     0.00000000106,  1.96085069786,       74.78159856730}, 
    {     0.00000000129,  4.85949366504,    16496.36139620240}, 
    {     0.00000000110,  2.30605777952,    16460.33352952499}, 
    {     0.00000000097,  3.50918940210,     5333.90024102160}, 
    {     0.00000000099,  3.56417337974,      735.87651353180}, 
    {     0.00000000096,  3.40918487598,    15720.83878487840}, 
    {     0.00000000094,  5.01601027363,     3128.38876509580}, 
    {     0.00000000097,  1.65579893894,      533.21408344360}, 
    {     0.00000000092,  0.89219199493,    29296.61538957860}, 
    {     0.00000000123,  3.16062062663,     9380.95967271720}, 
    {     0.00000000102,  1.20493500565,    23020.65308658799}, 
    {     0.00000000088,  2.21265504437,    12721.57209941700}, 
    {     0.00000000089,  1.54322669570,    20199.09495963300}, 
    {     0.00000000121,  6.19860353182,     9388.00590941520}, 
    {     0.00000000089,  4.08082274765,    22805.73556599360}, 
    {     0.00000000098,  1.09176668094,    12043.57428188900}, 
    {     0.00000000086,  1.13649001466,   143571.32428481648}, 
    {     0.00000000088,  5.96980472191,      107.66352393860}, 
    {     0.00000000082,  5.01561173481,    22003.91463486980}, 
    {     0.00000000094,  1.69615700473,    23006.42599258639}, 
    {     0.00000000081,  3.00664741995,     2118.76386037840}, 
    {     0.00000000098,  1.39215287161,     8662.24032356300}, 
    {     0.00000000080,  5.16340988714,    17796.95916678580}, 
    {     0.00000000082,  5.86893959287,     2787.04302385740}, 
    {     0.00000000077,  0.80723694712,   167283.76158766549}, 
    {     0.00000000091,  5.74902425304,    21424.46664430340}, 
    {     0.00000000076,  5.67183650604,       14.22709400160}, 
    {     0.00000000081,  6.16619455699,     1039.02661079040}, 
    {     0.00000000076,  3.21449884756,      111.18664228760}, 
    {     0.00000000078,  1.37531518377,    21947.11137270000}, 
    {     0.00000000074,  3.58814195051,    11609.86254401220}, 
    {     0.00000000077,  4.84846488388,    22743.40937951640}, 
    {     0.00000000090,  1.48869013606,    15671.08175940660}, 
    {     0.00000000082,  3.48618398216,    29088.81141598500}, 
    {     0.00000000071,  2.21591561190,    12029.34718788740}, 
    {     0.00000000069,  1.93625656075,      135.62532501000}, 
    {     0.00000000070,  2.66552760898,    18875.52586977400}, 
    {     0.00000000069,  5.41478093731,    26735.94526221320}, 
    {     0.00000000079,  5.15158156951,    12323.42309600880}, 
    {     0.00000000078,  4.17014063638,     1066.49547719000}, 
    {     0.00000000065,  5.64584720343,    12139.55350910680}, 
    {     0.00000000071,  3.89804774037,    22779.43724619380}, 
    {     0.00000000063,  4.53968787714,     8982.81066930900}, 
    {     0.00000000076,  3.29088891716,     2942.46342329160}, 
    {     0.00000000069,  0.94232113005,    14919.01785375460}, 
    {     0.00000000063,  4.09186535490,    16062.18452611680}, 
    {     0.00000000065,  3.34580407184,       51.28033786241}, 
    {     0.00000000065,  5.75757544877,    52670.06959330260}, 
    {     0.00000000057,  5.25050277534,    20995.39296644940}, 
    {     0.00000000061,  1.92290673861,     6805.65326808520}, 
    {     0.00000000061,  0.08878901558,    13362.44970679920}, 
    {     0.00000000076,  1.86947679415,    25287.72379939980}, 
    {     0.00000000056,  4.25396542622,     6709.67404086740}, 
    {     0.00000000058,  4.79429715781,     6286.36220740920}, 
    {     0.00000000073,  0.53299090807,     2301.58581590939}, 
    {     0.00000000070,  4.31243357502,    19402.79695281660}, 
    {     0.00000000067,  2.53852336668,      377.37360791580}, 
    {     0.00000000056,  3.20816844695,    24889.57479599160}, 
    {     0.00000000054,  5.17336469511,    26084.02180621620}, 
    {     0.00000000053,  3.17675406016,    18451.07854656599}, 
    {     0.00000000053,  3.61529270216,       77.67377042800}, 
    {     0.00000000053,  0.45467549335,    30666.15495843280}, 
    {     0.00000000053,  2.97761644192,    21548.96236929180}, 
    {     0.00000000061,  0.14805728543,    23013.53953958720}, 
    {     0.00000000051,  3.32803972907,       56.89837493560}, 
    {     0.00000000052,  3.41304011355,    23141.55838292460}, 
    {     0.00000000058,  3.13638677202,      309.27832265580}, 
    {     0.00000000054,  1.60896548545,    13341.67431130680}, 
    {     0.00000000053,  5.81426394852,    16193.65917750039}, 
    {     0.00000000067,  6.27917920454,    22345.26037610820}, 
    {     0.00000000050,  0.42577644151,    25685.87280280800}, 
    {     0.00000000048,  0.70204553352,     1162.47470440780}, 
    {     0.00000000066,  3.64350022359,    15265.88651930040}, 
    {     0.00000000050,  5.74382917440,       19.66976089979}, 
    {     0.00000000054,  1.97277370837,    23581.25817731760}, 
    {     0.00000000051,  1.23713196525,    12539.85338018300}, 
    {     0.00000000046,  5.41431704639,    33019.02111220460}, 
    {     0.00000000046,  4.80640843261,    19651.04848109800}, 
    {     0.00000000050,  1.23847511223,    22476.73502749179}, 
    {     0.00000000051,  4.91913434178,    12592.45001978260}, 
    {     0.00000000046,  2.41369976086,    98068.53671630539}, 
    {     0.00000000045,  3.45227074337,    30774.50164257480}, 
    {     0.00000000045,  4.39659083856,      433.71173787680}, 
    {     0.00000000045,  3.71921056816,    18209.33026366019}, 
    {     0.00000000044,  2.47683925106,    24356.78078864160}, 
    {     0.00000000049,  2.17835058609,    13521.75144159140}, 
    {     0.00000000046,  0.26142733448,       11.04570026390}, 
    {     0.00000000045,  2.46230645202,    51868.24866217880}, 
    {     0.00000000043,  4.29458463014,    28230.18722269139}, 
    {     0.00000000048,  0.89551707131,    56600.27928952220}, 
    {     0.00000000042,  3.63410684699,     4590.91018048900}, 
    {     0.00000000049,  3.17757670967,     6303.85124548380}, 
    {     0.00000000043,  4.93350349236,    10021.83728009940}, 
    {     0.00000000052,  3.65410195699,     7872.14874527520}, 
    {     0.00000000041,  4.82166756935,    10988.80815753500}, 
    {     0.00000000040,  1.81891629936,    34596.36465465240}, 
    {     0.00000000043,  1.94164978061,     1903.43681250120}, 
    {     0.00000000041,  0.74461854136,    23937.85638974100}, 
    {     0.00000000045,  5.45575017530,    60530.48898574180}, 
    {     0.00000000050,  5.67355640472,    18216.44381066100}, 
    {     0.00000000040,  0.04502010161,    38526.57435087200}, 
    {     0.00000000053,  3.64807615995,    11925.27409260060}, 
    {     0.00000000042,  5.19292937193,    19004.64794940840}, 
    {     0.00000000041,  0.94309683296,     9924.81042151060}, 
    {     0.00000000039,  4.61184303844,       95.97922721780}, 
    {     0.00000000049,  2.05532526216,    12573.26524698360}, 
    {     0.00000000045,  3.73717824543,     7875.67186362420}, 
    {     0.00000000043,  1.14078465002,       49.75702547180}, 
    {     0.00000000039,  1.70539366023,    32217.20018108080}, 
    {     0.00000000037,  1.29390383811,      310.84079886840}, 
    {     0.00000000038,  0.95970925950,      664.75604513000}, 
    {     0.00000000039,  0.85957361635,    16522.65971600220}, 
    {     0.00000000040,  1.00170796001,    36949.23080842420}, 
    {     0.00000000040,  3.78164718776,    55798.45835839840}, 
    {     0.00000000037,  5.42237070904,     6286.66627864320}, 
    {     0.00000000036,  1.68167662194,    10344.29506538580}, 
    {     0.00000000040,  5.13217319067,    15664.03552270859}, 
    {     0.00000000049,  3.62741283878,    77713.77146812050}, 
    {     0.00000000045,  6.15877872538,    28286.99048486120}, 
    {     0.00000000036,  3.32158458257,    16207.88627150200}, 
    {     0.00000000035,  5.83917764292,     6321.10352262720}, 
    {     0.00000000036,  1.80784164083,     6279.78949257360}, 
    {     0.00000000035,  4.60279245362,    28237.23345938940}, 
    {     0.00000000033,  0.47301775923,    18635.92845453620}, 
    {     0.00000000035,  4.36571027474,    48739.85989708300}, 
    {     0.00000000031,  3.06828028412,     6819.88036208680}, 
    {     0.00000000031,  2.40203198480,    28628.33622609960}, 
    {     0.00000000034,  1.90096411242,    12964.30070339100}, 
    {     0.00000000029,  6.09291010354,    18606.49894600020}, 
    {     0.00000000028,  3.42046112698,     6288.59877429880}, 
    {     0.00000000028,  3.43736140600,    34115.11406927460}, 
    {     0.00000000029,  1.48920816078,     6489.26139842860}, 
    {     0.00000000028,  3.07474749886,    29822.78323632420}, 
    {     0.00000000038,  2.44608264663,    31415.37924995700}, 
    {     0.00000000028,  2.98392582088,     6277.55292568400}, 
    {     0.00000000027,  5.03556015623,    12779.45079542080}, 
    {     0.00000000027,  5.40812977287,    26087.90314157420}, 
    {     0.00000000038,  5.56439937893,    27832.03821928320}, 
    {     0.00000000026,  3.87685883153,     6262.72053059260}, 
    {     0.00000000027,  6.15565392840,    28759.81087748319}, 
    {     0.00000000025,  5.17122153205,     6915.85958930460}, 
    {     0.00000000027,  4.03132006944,     9910.58332750900}, 
    {     0.00000000033,  3.97763407373,    12410.73130054860}, 
    {     0.00000000024,  5.31307120044,    29026.48522950779}, 
    {     0.00000000025,  0.81055213297,    36173.70819710020}, 
    {     0.00000000024,  1.28706101310,    24491.42579258340}, 
    {     0.00000000021,  2.02548478742,    28766.92442448400}, 
    {     0.00000000021,  6.07545114034,    18139.29450141590}, 
    {     0.00000000022,  2.31199937131,     6303.43116939020}, 
    {     0.00000000023,  1.35235057478,    49515.38250840700}, 
    {     0.00000000023,  2.92765926961,    65236.22129328540}, 
    {     0.00000000019,  0.03636659763,    29864.33402730900}, 
    {     0.00000000020,  0.91374066194,    45585.17281218740}, 
    {     0.00000000021,  4.45003013294,    22490.96212149340}, 
    {     0.00000000022,  1.97119365888,    34513.26307268280}, 
    {     0.00000000020,  4.11682669951,    17157.06188047180}, 
    {     0.00000000024,  1.40243942415,    14712.31711645800}, 
    {     0.00000000022,  2.19759737115,    31570.79964939120}, 
    {     0.00000000021,  1.48739821208,    61306.01159706580}, 
    {     0.00000000025,  5.71465573409,    25934.12433108940}, 
};


static const struct ln_vsop ALIGN32 earth_longitude_l2[LONG_L2] = {
    {     0.00008721859,  1.07253635559,     6283.07584999140}, 
    {     0.00000990990,  3.14159265359,        0.00000000000}, 
    {     0.00000294833,  0.43717350256,    12566.15169998280}, 
    {     0.00000027338,  0.05295636147,        3.52311834900}, 
    {     0.00000016333,  5.18820215724,       26.29831979980}, 
    {     0.00000015745,  3.68504712183,      155.42039943420}, 
    {     0.00000009425,  0.29667114694,    18849.22754997420}, 
    {     0.00000008938,  2.05706319592,    77713.77146812050}, 
    {     0.00000006940,  0.82691541038,      775.52261132400}, 
    {     0.00000005061,  4.66243231680,     1577.34354244780}, 
    {     0.00000004060,  1.03067032318,        7.11354700080}, 
    {     0.00000003464,  5.14021224609,      796.29800681640}, 
    {     0.00000003172,  6.05479318507,     5507.55323866740}, 
    {     0.00000003020,  1.19240008524,      242.72860397400}, 
    {     0.00000002885,  6.11705865396,      529.69096509460}, 
    {     0.00000003809,  3.44043369494,     5573.14280143310}, 
    {     0.00000002719,  0.30363248164,      398.14900340820}, 
    {     0.00000002365,  4.37666117992,     5223.69391980220}, 
    {     0.00000002538,  2.27966434314,      553.56940284240}, 
    {     0.00000002078,  3.75435095487,        0.98032106820}, 
    {     0.00000001675,  0.90149951436,      951.71840625060}, 
    {     0.00000001534,  5.75895831192,     1349.86740965880}, 
    {     0.00000001224,  2.97285792195,     2146.16541647520}, 
    {     0.00000001449,  4.36401639552,     1748.01641306700}, 
    {     0.00000001341,  3.72019379666,     1194.44701022460}, 
    {     0.00000001253,  2.94888726310,     6438.49624942560}, 
    {     0.00000000999,  5.98665341008,     6286.59896834040}, 
    {     0.00000000917,  4.79722195184,     5088.62883976680}, 
    {     0.00000000829,  3.31021398862,      213.29909543800}, 
    {     0.00000001102,  1.27094359244,   161000.68573767410}, 
    {     0.00000000764,  3.41231607038,     5486.77784317500}, 
    {     0.00000001046,  0.60374190029,     3154.68708489560}, 
    {     0.00000000887,  5.23364022595,     7084.89678111520}, 
    {     0.00000000644,  1.59974355582,     2544.31441988340}, 
    {     0.00000000681,  3.42742947469,     4694.00295470760}, 
    {     0.00000000606,  2.47688996663,    10977.07880469900}, 
    {     0.00000000706,  6.19369692903,     4690.47983635860}, 
    {     0.00000000643,  1.98119869589,      801.82093112380}, 
    {     0.00000000502,  1.44415463861,     6836.64525283380}, 
    {     0.00000000490,  2.33889753806,     1592.59601363280}, 
    {     0.00000000458,  1.30867922972,     4292.33083295040}, 
    {     0.00000000431,  0.03542536476,     7234.79425624200}, 
    {     0.00000000349,  0.98779272263,     6040.34724601740}, 
    {     0.00000000385,  1.57065592218,    71430.69561812909}, 
    {     0.00000000371,  3.16149051601,     6309.37416979120}, 
    {     0.00000000348,  0.64980950594,     1059.38193018920}, 
    {     0.00000000458,  3.81505682017,   149854.40013480789}, 
    {     0.00000000302,  1.91723873447,    10447.38783960440}, 
    {     0.00000000306,  3.55405857884,     8031.09226305840}, 
    {     0.00000000395,  4.93742673052,     7632.94325965020}, 
    {     0.00000000314,  3.18058352846,     2352.86615377180}, 
    {     0.00000000281,  4.41751404023,     9437.76293488700}, 
    {     0.00000000276,  2.71075791682,     3894.18182954220}, 
    {     0.00000000298,  2.52045757001,     6127.65545055720}, 
    {     0.00000000272,  0.24370191144,    25132.30339996560}, 
    {     0.00000000251,  0.55449375765,     6279.55273164240}, 
    {     0.00000000224,  1.40790249012,     4705.73230754360}, 
    {     0.00000000258,  5.29510765044,     6812.76681508600}, 
    {     0.00000000178,  0.92636669742,     1990.74501704100}, 
    {     0.00000000217,  0.68543630022,     6256.77753019160}, 
    {     0.00000000154,  0.77808632062,    14143.49524243060}, 
    {     0.00000000150,  2.40636982736,      426.59819087600}, 
    {     0.00000000196,  6.06877865012,      640.87760738220}, 
    {     0.00000000137,  2.21947617717,     8429.24126646660}, 
    {     0.00000000127,  5.47380312768,    12036.46073488820}, 
    {     0.00000000121,  3.32740512021,    17789.84561978500}, 
    {     0.00000000123,  2.16004509785,    10213.28554621100}, 
    {     0.00000000116,  0.49705139709,     7058.59846131540}, 
    {     0.00000000138,  2.36181661472,    11506.76976979360}, 
    {     0.00000000101,  0.86299995919,     6290.18939699220}, 
    {     0.00000000118,  5.82317768355,     7860.41939243920}, 
    {     0.00000000092,  5.11639978593,     7079.37385680780}, 
    {     0.00000000125,  2.65424538513,    88860.05707098669}, 
    {     0.00000000088,  4.31188236160,    83996.84731811189}, 
    {     0.00000000084,  3.57682769713,    16730.46368959580}, 
    {     0.00000000097,  5.58011309774,    13367.97263110660}, 
    {     0.00000000102,  2.05853060226,       87.30820453981}, 
    {     0.00000000080,  4.73827128421,    11926.25441366880}, 
    {     0.00000000080,  5.41344057121,    10973.55568635000}, 
    {     0.00000000106,  4.10978997399,     3496.03282613400}, 
    {     0.00000000075,  4.89166898876,     5643.17856367740}, 
    {     0.00000000100,  3.62645659087,   244287.60000722769}, 
    {     0.00000000096,  1.39443577787,     6681.22485339960}, 
    {     0.00000000069,  1.88399189965,    10177.25767953360}, 
    {     0.00000000087,  0.40842153208,    11015.10647733480}, 
    {     0.00000000066,  0.99444831932,     6525.80445396540}, 
    {     0.00000000066,  1.42471816453,     9917.69687450980}, 
    {     0.00000000067,  5.51240997070,     3097.88382272579}, 
    {     0.00000000076,  2.71564693510,     4164.31198961300}, 
    {     0.00000000085,  0.49655523670,    10575.40668294180}, 
    {     0.00000000077,  3.51693861509,    11856.21865142450}, 
    {     0.00000000062,  3.62587628690,    16496.36139620240}, 
    {     0.00000000054,  5.25957420065,     3340.61242669980}, 
    {     0.00000000053,  1.10902178415,     8635.94200376320}, 
    {     0.00000000049,  5.65761054625,    20426.57109242200}, 
    {     0.00000000064,  5.79211164779,     2388.89402044920}, 
    {     0.00000000046,  5.45092696155,     6275.96230299060}, 
    {     0.00000000057,  4.97077155798,    14945.31617355440}, 
    {     0.00000000043,  3.30685683359,     9779.10867612540}, 
    {     0.00000000042,  1.61412785248,    12168.00269657460}, 
    {     0.00000000049,  3.92715473768,     5729.50644714900}, 
    {     0.00000000042,  0.63481258930,     2699.73481931760}, 
    {     0.00000000056,  4.34038639086,    90955.55169449610}, 
    {     0.00000000040,  5.66871428338,    11712.95531823080}, 
    {     0.00000000039,  3.10911294009,    16200.77272450120}, 
    {     0.00000000040,  5.71338386146,      709.93304855830}, 
    {     0.00000000053,  6.17067257683,   233141.31440436149}, 
    {     0.00000000037,  0.32095173508,    24356.78078864160}, 
    {     0.00000000035,  0.95557073457,    17298.18232732620}, 
    {     0.00000000035,  0.64913397996,    25158.60171976540}, 
    {     0.00000000041,  1.53850422484,    65147.61976813770}, 
    {     0.00000000035,  0.77655626359,    13916.01910964160}, 
    {     0.00000000031,  5.35897350775,     5331.35744374080}, 
    {     0.00000000030,  4.48114682755,    23543.23050468179}, 
    {     0.00000000032,  3.45976963453,     7477.52286021600}, 
    {     0.00000000029,  3.46648040769,    13119.72110282519}, 
    {     0.00000000038,  2.90863974625,    12721.57209941700}, 
    {     0.00000000029,  3.13390968321,     4136.91043351620}, 
    {     0.00000000035,  3.79717126309,   143571.32428481648}, 
    {     0.00000000027,  0.95726093828,    12559.03815298200}, 
    {     0.00000000026,  4.95326877030,     5753.38488489680}, 
    {     0.00000000032,  3.49943896928,     6284.05617105960}, 
    {     0.00000000026,  4.59276256636,     5884.92684658320}, 
    {     0.00000000026,  1.53958920253,   154717.60988768269}, 
    {     0.00000000023,  4.88012908735,    13095.84266507740}, 
    {     0.00000000023,  0.35935706511,    31415.37924995700}, 
    {     0.00000000024,  5.11515116629,    18319.53658487960}, 
    {     0.00000000021,  5.73872879912,    12569.67481833180}, 
    {     0.00000000021,  1.32901200081,    10988.80815753500}, 
    {     0.00000000019,  2.24263229491,    18073.70493865020}, 
    {     0.00000000019,  3.14253175605,     6496.37494542940}, 
    {     0.00000000021,  2.80122025076,     6282.09552892320}, 
    {     0.00000000023,  0.14288760398,     6283.00853968860}, 
    {     0.00000000019,  4.28209473754,     3930.20969621960}, 
    {     0.00000000016,  0.25933207663,    11790.62908865880}, 
    {     0.00000000015,  6.09623501240,    13517.87010623340}, 
    {     0.00000000020,  5.06358906224,     6283.14316029419}, 
    {     0.00000000015,  1.07680663150,     4933.20844033260}, 
    {     0.00000000019,  5.74000581249,     3128.38876509580}, 
    {     0.00000000016,  6.18924226747,     7342.45778018060}, 
    {     0.00000000013,  1.69105044945,     4535.05943692440}, 
    {     0.00000000015,  3.36968394452,    17260.15465469040}, 
    {     0.00000000010,  3.78885035015,    22003.91463486980}, 
    {     0.00000000011,  2.12851973876,     7875.67186362420}, 
};


static const struct ln_vsop ALIGN32 earth_longitude_l3[LONG_L3] = {
    {     0.00000289058,  5.84173149732,     6283.07584999140}, 
    {     0.00000020712,  6.04983939020,    12566.15169998280}, 
    {     0.00000002962,  5.19560579570,      155.42039943420}, 
    {     0.00000002527,  3.14159265359,        0.00000000000}, 
    {     0.00000001288,  4.72197611970,        3.52311834900}, 
    {     0.00000000635,  5.96904899168,      242.72860397400}, 
    {     0.00000000570,  5.54182903238,    18849.22754997420}, 
    {     0.00000000402,  3.78606612895,      553.56940284240}, 
    {     0.00000000072,  4.37131884946,     6286.59896834040}, 
    {     0.00000000067,  0.91133898967,     6127.65545055720}, 
    {     0.00000000037,  5.28611190997,     6438.49624942560}, 
    {     0.00000000021,  2.94917211527,     6309.37416979120}, 
    {     0.00000000015,  3.63037493932,    71430.69561812909}, 
    {     0.00000000011,  4.83261533939,    25132.30339996560}, 
    {     0.00000000011,  5.84259014283,     6525.80445396540}, 
    {     0.00000000012,  3.82296977522,     7058.59846131540}, 
    {     0.00000000013,  2.39991715131,     5729.50644714900}, 
    {     0.00000000008,  0.55390332094,     6040.34724601740}, 
    {     0.00000000008,  1.46298993048,    11856.21865142450}, 
    {     0.00000000008,  5.07535888338,     6256.77753019160}, 
    {     0.00000000006,  2.88803526743,     5507.55323866740}, 
    {     0.00000000005,  3.87019253131,    12036.46073488820}, 
    {     0.00000000005,  2.70838853362,    83996.84731811189}, 
};


static const struct ln_vsop ALIGN32 earth_longitude_l4[LONG_L4] = {
    {     0.00000007714,  4.14117321449,     6283.07584999140}, 
    {     0.00000001016,  3.27573644241,    12566.15169998280}, 
    {     0.00000000420,  0.41892851415,      155.42039943420}, 
    {     0.00000000047,  3.50591071186,    18849.22754997420}, 
    {     0.00000000041,  3.14032562331,        3.52311834900}, 
    {     0.00000000035,  5.01110770000,     5573.14280143310}, 
    {     0.00000000010,  5.64816633449,     6127.65545055720}, 
    {     0.00000000013,  0.48609240774,    77713.77146812050}, 
    {     0.00000000007,  2.84139222289,   161000.68573767410}, 
    {     0.00000000004,  3.65509047070,    25132.30339996560}, 
    {     0.00000000002,  0.54880603487,     6438.49624942560}, 
};


static const struct ln_vsop ALIGN32 earth_longitude_l5[LONG_L5] = {
    {     0.00000000172,  2.74854172392,     6283.07584999140}, 
    {     0.00000000050,  2.01352986713,      155.42039943420}, 
    {     0.00000000028,  2.93369985477,    12566.15169998280}, 
    {     0.00000000005,  1.93829214518,    18849.22754997420}, 
};


static const struct ln_vsop ALIGN32 earth_latitude_b0[LAT_B0] = {
    {     0.00000279620,  3.19870156017,    84334.66158130829}, 
    {     0.00000101643,  5.42248619256,     5507.55323866740}, 
    {     0.00000080445,  3.88013204458,     5223.69391980220}, 
    {     0.00000043806,  3.70444689759,     2352.86615377180}, 
    {     0.00000031933,  4.00026369781,     1577.34354244780}, 
    {     0.00000022724,  3.98473831560,     1047.74731175470}, 
    {     0.00000016392,  3.56456119782,     5856.47765911540}, 
    {     0.00000018141,  4.98367470262,     6283.07584999140}, 
    {     0.00000014443,  3.70275614915,     9437.76293488700}, 
    {     0.00000014304,  3.41117857526,    10213.28554621100}, 
    {     0.00000011246,  4.82820690527,    14143.49524243060}, 
    {     0.00000010900,  2.08574562329,     6812.76681508600}, 
    {     0.00000009714,  3.47303947751,     4694.00295470760}, 
    {     0.00000010367,  4.05663927945,    71092.88135493269}, 
    {     0.00000008775,  4.44016515666,     5753.38488489680}, 
    {     0.00000008366,  4.99251512183,     7084.89678111520}, 
    {     0.00000006921,  4.32559054073,     6275.96230299060}, 
    {     0.00000009145,  1.14182646613,     6620.89011318780}, 
    {     0.00000007194,  3.60193205744,      529.69096509460}, 
    {     0.00000007698,  5.55425745881,   167621.57585086189}, 
    {     0.00000005285,  2.48446991536,     4705.73230754360}, 
    {     0.00000005208,  6.24992674532,    18073.70493865020}, 
    {     0.00000004529,  2.33827747356,     6309.37416979120}, 
    {     0.00000005579,  4.41023653719,     7860.41939243920}, 
    {     0.00000004743,  0.70995680136,     5884.92684658320}, 
    {     0.00000004301,  1.10255777773,     6681.22485339960}, 
    {     0.00000003849,  1.82229412532,     5486.77784317500}, 
    {     0.00000004093,  5.11700141197,    13367.97263110660}, 
    {     0.00000003681,  0.43793170336,     3154.68708489560}, 
    {     0.00000003420,  5.42034800952,     6069.77675455340}, 
    {     0.00000003617,  6.04641937568,     3930.20969621960}, 
    {     0.00000003670,  4.58210192227,    12194.03291462090}, 
    {     0.00000002918,  1.95463881136,    10977.07880469900}, 
    {     0.00000002797,  5.61259274877,    11790.62908865880}, 
    {     0.00000002502,  0.60499729368,     6496.37494542940}, 
    {     0.00000002319,  5.01648216088,     1059.38193018920}, 
    {     0.00000002684,  1.39470396487,    22003.91463486980}, 
    {     0.00000002428,  3.24183056545,    78051.58573131690}, 
    {     0.00000002120,  4.30691000285,     5643.17856367740}, 
    {     0.00000002257,  3.15557225087,    90617.73743129970}, 
    {     0.00000001813,  3.75574218286,     3340.61242669980}, 
    {     0.00000002226,  2.79699346673,    12036.46073488820}, 
    {     0.00000001888,  0.86991545944,     8635.94200376320}, 
    {     0.00000001517,  1.95852055710,      398.14900340820}, 
    {     0.00000001581,  3.19976230948,     5088.62883976680}, 
    {     0.00000001421,  6.25530883828,     2544.31441988340}, 
    {     0.00000001595,  0.25619915132,    17298.18232732620}, 
    {     0.00000001391,  4.69964175574,     7058.59846131540}, 
    {     0.00000001478,  2.81808207569,    25934.12433108940}, 
    {     0.00000001481,  3.65823554610,    11506.76976979360}, 
    {     0.00000001693,  4.95689385293,   156475.29024799570}, 
    {     0.00000001183,  1.29343060777,      775.52261132400}, 
    {     0.00000001114,  2.37889311847,     3738.76143010800}, 
    {     0.00000000994,  4.30088900425,     9225.53927328300}, 
    {     0.00000000924,  3.06451026809,     4164.31198961300}, 
    {     0.00000000867,  0.55606931068,     8429.24126646660}, 
    {     0.00000000988,  5.97286104208,     7079.37385680780}, 
    {     0.00000000824,  1.50984806177,    10447.38783960440}, 
    {     0.00000000915,  0.12635654605,    11015.10647733480}, 
    {     0.00000000742,  1.99159139281,    26087.90314157420}, 
    {     0.00000001039,  3.14159265359,        0.00000000000}, 
    {     0.00000000850,  4.24120016095,    29864.33402730900}, 
    {     0.00000000755,  2.89631873314,     4732.03062734340}, 
    {     0.00000000714,  1.37548118605,     2146.16541647520}, 
    {     0.00000000708,  1.91406542362,     8031.09226305840}, 
    {     0.00000000746,  0.57893808622,      796.29800681640}, 
    {     0.00000000802,  5.12339137235,     2942.46342329160}, 
    {     0.00000000751,  1.67479850166,    21228.39202354580}, 
    {     0.00000000602,  4.09976538900,    64809.80550494129}, 
    {     0.00000000594,  3.49580704849,    16496.36139620240}, 
    {     0.00000000592,  4.59481504319,     4690.47983635860}, 
    {     0.00000000530,  5.73979295194,     8827.39026987480}, 
    {     0.00000000503,  5.66433137112,    33794.54372352860}, 
    {     0.00000000483,  1.57106522322,      801.82093112380}, 
    {     0.00000000438,  0.06707733720,     3128.38876509580}, 
    {     0.00000000423,  2.86944596145,    12566.15169998280}, 
    {     0.00000000504,  3.26207669160,     7632.94325965020}, 
    {     0.00000000552,  1.02926440457,   239762.20451754928}, 
    {     0.00000000427,  3.67434378208,      213.29909543800}, 
    {     0.00000000404,  1.46193297360,    15720.83878487840}, 
    {     0.00000000503,  4.85802444134,     6290.18939699220}, 
    {     0.00000000417,  0.81920713533,     5216.58037280140}, 
    {     0.00000000365,  0.01002966145,    12168.00269657460}, 
    {     0.00000000363,  1.28376436579,     6206.80977871580}, 
    {     0.00000000353,  4.70059133110,     7234.79425624200}, 
    {     0.00000000415,  0.96862624176,     4136.91043351620}, 
    {     0.00000000387,  3.09145061418,    25158.60171976540}, 
    {     0.00000000373,  2.65119262808,     7342.45778018060}, 
    {     0.00000000361,  2.97762937735,     9623.68827669120}, 
    {     0.00000000418,  3.75759994446,     5230.80746680300}, 
    {     0.00000000396,  1.22507712354,     6438.49624942560}, 
    {     0.00000000322,  1.21162178805,     8662.24032356300}, 
    {     0.00000000284,  5.64170320179,     1589.07289528380}, 
    {     0.00000000379,  1.72248432756,    14945.31617355440}, 
    {     0.00000000320,  3.94161159658,     7330.82316174610}, 
    {     0.00000000313,  5.47602376451,     1194.44701022460}, 
    {     0.00000000292,  1.38971327568,    11769.85369316640}, 
    {     0.00000000305,  0.80429352049,    37724.75341974820}, 
    {     0.00000000257,  5.81382810029,      426.59819087600}, 
    {     0.00000000265,  6.10358507671,     6836.64525283380}, 
    {     0.00000000250,  4.56452895547,     7477.52286021600}, 
    {     0.00000000266,  2.62926282354,     7238.67559160000}, 
    {     0.00000000263,  6.22089501237,     6133.51265285680}, 
    {     0.00000000306,  2.79682380532,     1748.01641306700}, 
    {     0.00000000236,  2.46093023707,    11371.70468975820}, 
    {     0.00000000316,  1.62662805006,   250908.49012041549}, 
    {     0.00000000216,  3.68721275185,     5849.36411211460}, 
    {     0.00000000230,  0.36165162947,     5863.59120611620}, 
    {     0.00000000233,  5.03509933618,    20426.57109242200}, 
    {     0.00000000200,  5.86073159059,     4535.05943692440}, 
    {     0.00000000277,  4.65400292395,    82239.16695779889}, 
    {     0.00000000209,  3.72323200803,    10973.55568635000}, 
    {     0.00000000199,  5.05186622555,     5429.87946823940}, 
    {     0.00000000256,  2.40923279886,    19651.04848109800}, 
    {     0.00000000210,  4.50691909144,    29088.81141598500}, 
    {     0.00000000181,  6.00294783127,     4292.33083295040}, 
    {     0.00000000249,  0.12900984422,   154379.79562448629}, 
    {     0.00000000209,  3.87759458541,    17789.84561978500}, 
    {     0.00000000225,  3.18339652605,    18875.52586977400}, 
    {     0.00000000191,  4.53897489216,    18477.10876461230}, 
    {     0.00000000172,  2.09694182730,    13095.84266507740}, 
    {     0.00000000182,  3.16107943487,    16730.46368959580}, 
    {     0.00000000188,  2.22746128596,    41654.96311596780}, 
    {     0.00000000164,  5.18686274999,     5481.25491886760}, 
    {     0.00000000160,  2.49298855020,    12592.45001978260}, 
    {     0.00000000155,  1.59595438224,    10021.83728009940}, 
    {     0.00000000135,  0.21349051305,    10988.80815753500}, 
    {     0.00000000178,  3.80375178044,    23581.25817731760}, 
    {     0.00000000123,  1.66800739151,    15110.46611986620}, 
    {     0.00000000122,  2.72678272224,    18849.22754997420}, 
    {     0.00000000126,  1.17675512872,    14919.01785375460}, 
    {     0.00000000142,  3.95053440992,      337.81426319640}, 
    {     0.00000000116,  6.06340906212,     6709.67404086740}, 
    {     0.00000000137,  3.52143246244,    12139.55350910680}, 
    {     0.00000000136,  2.92179113491,    32217.20018108080}, 
    {     0.00000000110,  3.51203379263,    18052.92954315780}, 
    {     0.00000000147,  4.63371971408,    22805.73556599360}, 
    {     0.00000000108,  5.45280815225,        7.11354700080}, 
    {     0.00000000148,  0.65447253687,    95480.94718417450}, 
    {     0.00000000119,  5.92110458985,    33019.02111220460}, 
    {     0.00000000110,  5.34824206403,      639.89728631400}, 
    {     0.00000000106,  3.71081682614,    14314.16811304980}, 
    {     0.00000000139,  6.17607198262,    24356.78078864160}, 
    {     0.00000000118,  5.59738712949,   161338.50000087050}, 
    {     0.00000000117,  3.65065271640,    45585.17281218740}, 
    {     0.00000000127,  4.74596574209,    49515.38250840700}, 
    {     0.00000000120,  1.04211499785,     6915.85958930460}, 
    {     0.00000000120,  5.60638811846,     5650.29211067820}, 
    {     0.00000000115,  3.10668213303,    14712.31711645800}, 
    {     0.00000000099,  0.69018939930,    12779.45079542080}, 
    {     0.00000000097,  1.07908724794,     9917.69687450980}, 
    {     0.00000000093,  2.62295197146,    17260.15465469040}, 
    {     0.00000000099,  4.45774681732,     4933.20844033260}, 
    {     0.00000000123,  1.37488921994,    28286.99048486120}, 
    {     0.00000000121,  5.19767249869,    27511.46787353720}, 
    {     0.00000000105,  0.87192268229,    77375.95720492408}, 
    {     0.00000000087,  3.93637812950,    17654.78053974960}, 
    {     0.00000000122,  2.23956068680,    83997.09113559539}, 
    {     0.00000000087,  4.18201600921,    22779.43724619380}, 
    {     0.00000000104,  4.59580877285,     1349.86740965880}, 
    {     0.00000000102,  2.83545248595,    12352.85260454480}, 
    {     0.00000000102,  3.97386522171,    10818.13528691580}, 
    {     0.00000000101,  4.32892825818,    36147.40987730040}, 
    {     0.00000000094,  5.00001709338,   150192.21439800429}, 
    {     0.00000000077,  3.97199369300,     1592.59601363280}, 
    {     0.00000000100,  6.07733097102,    26735.94526221320}, 
    {     0.00000000086,  5.26029638250,    28313.28880466100}, 
    {     0.00000000093,  4.31900620254,    44809.65020086340}, 
    {     0.00000000076,  6.22743405935,    13521.75144159140}, 
    {     0.00000000072,  1.55820597747,     6256.77753019160}, 
    {     0.00000000082,  4.95202664555,    10575.40668294180}, 
    {     0.00000000082,  1.69647647075,     1990.74501704100}, 
    {     0.00000000075,  2.29836095644,     3634.62102451840}, 
    {     0.00000000075,  2.66367876557,    16200.77272450120}, 
    {     0.00000000087,  0.26630214764,    31441.67756975680}, 
    {     0.00000000077,  2.25530952876,     5235.32853823670}, 
    {     0.00000000076,  1.09869730334,    12903.96596317920}, 
    {     0.00000000058,  4.28246137794,    12559.03815298200}, 
    {     0.00000000064,  5.51112829602,   173904.65170085328}, 
    {     0.00000000056,  2.60133794851,    73188.37597844210}, 
    {     0.00000000055,  5.81483150022,   143233.51002162008}, 
    {     0.00000000054,  3.38482031504,   323049.11878710288}, 
    {     0.00000000039,  3.28500401937,    71768.50988132549}, 
    {     0.00000000039,  3.11239910096,    96900.81328129109}, 
};


static const struct ln_vsop ALIGN32 earth_latitude_b1[LAT_B1] = {
    {     0.00227777722,  3.41376620530,     6283.07584999140}, 
    {     0.00003805678,  3.37063423795,    12566.15169998280}, 
    {     0.00003619589,  0.00000000000,        0.00000000000}, 
    {     0.00000071542,  3.32777549735,    18849.22754997420}, 
    {     0.00000007655,  1.79489607186,     5223.69391980220}, 
    {     0.00000008107,  3.89190403643,     5507.55323866740}, 
    {     0.00000006456,  5.19789424750,     2352.86615377180}, 
    {     0.00000003894,  2.15568517178,     6279.55273164240}, 
    {     0.00000003892,  1.53021064904,     6286.59896834040}, 
    {     0.00000003897,  4.87293945629,    10213.28554621100}, 
    {     0.00000003812,  1.43523182316,    12036.46073488820}, 
    {     0.00000003577,  2.32913869227,    83996.84731811189}, 
    {     0.00000003570,  4.92637739003,    71430.69561812909}, 
    {     0.00000003494,  2.20864641831,      529.69096509460}, 
    {     0.00000002421,  6.22876183393,     7860.41939243920}, 
    {     0.00000002056,  3.06747139741,    14143.49524243060}, 
    {     0.00000001399,  0.50107877909,     6309.37416979120}, 
    {     0.00000001417,  3.28454570977,    25132.30339996560}, 
    {     0.00000001544,  1.82062047625,     5856.47765911540}, 
    {     0.00000001457,  1.75339303307,     5884.92684658320}, 
    {     0.00000001497,  2.19673914456,     9437.76293488700}, 
    {     0.00000001549,  5.73650061398,    17789.84561978500}, 
    {     0.00000001277,  3.96721717330,     4705.73230754360}, 
    {     0.00000001038,  2.94818701170,     6256.77753019160}, 
    {     0.00000001018,  2.24114547164,     6681.22485339960}, 
    {     0.00000001021,  1.46795026130,    11790.62908865880}, 
    {     0.00000000916,  3.72965830745,     1059.38193018920}, 
    {     0.00000001156,  6.04591336669,      398.14900340820}, 
    {     0.00000001240,  0.77195902957,     6812.76681508600}, 
    {     0.00000001115,  3.92255876225,    12168.00269657460}, 
    {     0.00000000908,  1.78447918237,     3930.20969621960}, 
    {     0.00000000833,  0.09941579828,    11506.76976979360}, 
    {     0.00000000790,  2.45555993228,      775.52261132400}, 
    {     0.00000000666,  4.40761401665,     5753.38488489680}, 
    {     0.00000000520,  1.60179602491,     4694.00295470760}, 
    {     0.00000000382,  0.26754532042,     1577.34354244780}, 
    {     0.00000000405,  1.97558286872,     6283.00853968860}, 
    {     0.00000000405,  1.53147989887,     6283.14316029419}, 
    {     0.00000000388,  2.59563818411,     7058.59846131540}, 
    {     0.00000000341,  3.61275156842,    13367.97263110660}, 
    {     0.00000000280,  4.63052251735,      796.29800681640}, 
    {     0.00000000276,  0.43350778219,     7079.37385680780}, 
    {     0.00000000311,  5.28219636656,    17260.15465469040}, 
    {     0.00000000275,  5.27597553634,    11769.85369316640}, 
    {     0.00000000286,  2.98639716345,     6275.96230299060}, 
    {     0.00000000251,  2.81315684448,     6290.18939699220}, 
    {     0.00000000239,  5.77837903893,    10977.07880469900}, 
    {     0.00000000228,  0.14375973844,     3738.76143010800}, 
    {     0.00000000227,  2.51020991853,     7084.89678111520}, 
    {     0.00000000211,  4.72029465470,     6496.37494542940}, 
    {     0.00000000234,  3.11535274010,      709.93304855830}, 
    {     0.00000000234,  0.57075817620,    11856.21865142450}, 
    {     0.00000000237,  2.38791907394,      213.29909543800}, 
    {     0.00000000227,  1.12059781634,    12352.85260454480}, 
    {     0.00000000169,  3.20148089605,     5486.77784317500}, 
    {     0.00000000159,  3.14604135756,     8827.39026987480}, 
    {     0.00000000160,  1.14784478002,     5643.17856367740}, 
    {     0.00000000144,  5.23285657431,    78051.58573131690}, 
    {     0.00000000144,  1.16454654602,    90617.73743129970}, 
    {     0.00000000144,  3.81203756929,     6262.30045449900}, 
    {     0.00000000143,  5.97809021355,     6303.85124548380}, 
    {     0.00000000138,  4.29829933273,     1589.07289528380}, 
    {     0.00000000161,  3.03298851492,    20426.57109242200}, 
    {     0.00000000165,  5.09134896587,    17298.18232732620}, 
    {     0.00000000128,  4.41590143012,     6127.65545055720}, 
    {     0.00000000158,  2.00984506334,     5230.80746680300}, 
    {     0.00000000130,  1.44170683802,    12569.67481833180}, 
    {     0.00000000125,  1.69950379498,     3128.38876509580}, 
    {     0.00000000152,  4.96946111415,    65147.61976813770}, 
    {     0.00000000131,  4.24961399629,     6282.09552892320}, 
    {     0.00000000131,  5.54051222995,     6284.05617105960}, 
    {     0.00000000161,  3.32421999691,     6283.31966747490}, 
    {     0.00000000123,  2.93221463795,    15720.83878487840}, 
    {     0.00000000152,  1.56488157456,    18319.53658487960}, 
    {     0.00000000114,  1.89110005546,    18073.70493865020}, 
    {     0.00000000113,  4.95214866677,     4136.91043351620}, 
    {     0.00000000111,  4.79699611405,     8429.24126646660}, 
    {     0.00000000118,  3.06184958762,    22003.91463486980}, 
    {     0.00000000128,  2.09693027395,    12562.62858163380}, 
    {     0.00000000138,  0.84648544836,     6069.77675455340}, 
    {     0.00000000100,  0.41938790104,     5481.25491886760}, 
    {     0.00000000101,  4.43791289246,    19651.04848109800}, 
    {     0.00000000116,  1.87002428935,    77713.77146812050}, 
    {     0.00000000095,  0.68638183645,     3340.61242669980}, 
    {     0.00000000104,  4.90822646457,     8635.94200376320}, 
    {     0.00000000114,  0.36008214928,    23543.23050468179}, 
    {     0.00000000091,  1.17611219310,     9225.53927328300}, 
    {     0.00000000091,  2.74682631104,     5216.58037280140}, 
    {     0.00000000086,  3.09315282195,     1194.44701022460}, 
    {     0.00000000093,  6.27643513190,    12559.03815298200}, 
    {     0.00000000087,  3.64926989547,        7.11354700080}, 
    {     0.00000000083,  0.37008971174,    11371.70468975820}, 
    {     0.00000000098,  4.68473306376,   167283.76158766549}, 
    {     0.00000000098,  0.99865886857,   154717.60988768269}, 
    {     0.00000000086,  4.41152307486,    25934.12433108940}, 
    {     0.00000000098,  4.98209568932,    16496.36139620240}, 
    {     0.00000000085,  2.35438163823,     3154.68708489560}, 
    {     0.00000000083,  0.24859477658,    21228.39202354580}, 
    {     0.00000000076,  5.46661600296,    29864.33402730900}, 
    {     0.00000000069,  3.22045334237,      801.82093112380}, 
    {     0.00000000068,  2.19928242745,    37724.75341974820}, 
    {     0.00000000070,  5.33711014698,     2544.31441988340}, 
    {     0.00000000055,  5.37872238211,    11015.10647733480}, 
    {     0.00000000051,  5.03600618727,     5863.59120611620}, 
    {     0.00000000059,  3.54984809612,     4535.05943692440}, 
    {     0.00000000053,  1.50812064137,     7342.45778018060}, 
    {     0.00000000044,  1.33712241647,     4164.31198961300}, 
    {     0.00000000055,  5.38460045253,     7477.52286021600}, 
    {     0.00000000049,  5.61844340512,    24072.92146977640}, 
    {     0.00000000057,  6.17973522898,     8031.09226305840}, 
    {     0.00000000052,  4.24379064407,     5088.62883976680}, 
    {     0.00000000041,  3.41960196246,    26087.90314157420}, 
    {     0.00000000052,  1.68150981131,    25158.60171976540}, 
    {     0.00000000053,  0.11041408311,    29088.81141598500}, 
    {     0.00000000043,  0.53354396923,     2146.16541647520}, 
    {     0.00000000050,  0.60270799844,    33794.54372352860}, 
    {     0.00000000045,  1.69577010458,     6702.56049386660}, 
    {     0.00000000037,  6.09033460795,    64809.80550494129}, 
    {     0.00000000044,  2.67993061247,    15110.46611986620}, 
    {     0.00000000047,  3.62555676035,    41654.96311596780}, 
    {     0.00000000036,  0.47219666269,    13095.84266507740}, 
    {     0.00000000035,  5.99520523215,    23581.25817731760}, 
    {     0.00000000043,  4.08726331262,   156137.47598479928}, 
    {     0.00000000043,  5.17376496602,    18422.62935909819}, 
    {     0.00000000034,  2.14460100274,     4933.20844033260}, 
    {     0.00000000030,  4.12992793541,      426.59819087600}, 
    {     0.00000000036,  2.28596930002,    90279.92316810328}, 
    {     0.00000000032,  0.81117747619,       26.29831979980}, 
    {     0.00000000028,  4.07036560467,    14712.31711645800}, 
    {     0.00000000025,  1.92905243842,     1748.01641306700}, 
    {     0.00000000024,  5.06152880842,    16730.46368959580}, 
    {     0.00000000023,  3.24047012195,    31415.37924995700}, 
    {     0.00000000027,  3.90672018305,    18451.07854656599}, 
    {     0.00000000021,  3.51419811826,    10447.38783960440}, 
};


static const struct ln_vsop ALIGN32 earth_latitude_b2[LAT_B2] = {
    {     0.00009721424,  5.15192809920,     6283.07584999140}, 
    {     0.00000233002,  3.14159265359,        0.00000000000}, 
    {     0.00000134188,  0.64406212977,    12566.15169998280}, 
    {     0.00000006504,  1.07333397797,    18849.22754997420}, 
    {     0.00000001662,  1.62746869551,    84334.66158130829}, 
    {     0.00000000635,  3.51985338656,     6279.55273164240}, 
    {     0.00000000492,  2.41382223971,     1047.74731175470}, 
    {     0.00000000307,  6.10181422085,     5223.69391980220}, 
    {     0.00000000322,  0.37660897389,     6286.59896834040}, 
    {     0.00000000326,  2.35727931602,     5507.55323866740}, 
    {     0.00000000274,  1.65307581765,     7860.41939243920}, 
    {     0.00000000228,  1.14082932988,    25132.30339996560}, 
    {     0.00000000202,  0.49836682530,     2352.86615377180}, 
    {     0.00000000201,  0.15552765600,    10213.28554621100}, 
    {     0.00000000167,  3.98005254015,      529.69096509460}, 
    {     0.00000000170,  5.28668290523,     6256.77753019160}, 
    {     0.00000000166,  3.04613930284,    12036.46073488820}, 
    {     0.00000000153,  4.06779216239,    83996.84731811189}, 
    {     0.00000000150,  3.18772213951,    71430.69561812909}, 
    {     0.00000000120,  3.13558669517,     5884.92684658320}, 
    {     0.00000000123,  4.17102530625,     6309.37416979120}, 
    {     0.00000000100,  1.46356761368,    11506.76976979360}, 
    {     0.00000000100,  3.00322421365,    11790.62908865880}, 
    {     0.00000000077,  1.65643898948,     4705.73230754360}, 
    {     0.00000000068,  6.03791904123,     6812.76681508600}, 
    {     0.00000000075,  4.85191600582,    14143.49524243060}, 
    {     0.00000000079,  4.12628805658,     5753.38488489680}, 
    {     0.00000000064,  2.71944160460,     6127.65545055720}, 
    {     0.00000000063,  0.78655326011,     6438.49624942560}, 
    {     0.00000000075,  0.84213523741,   167621.57585086189}, 
    {     0.00000000051,  4.55059044701,     5486.77784317500}, 
    {     0.00000000050,  5.29314320585,     7079.37385680780}, 
    {     0.00000000045,  0.33147576416,      775.52261132400}, 
    {     0.00000000043,  3.61793711640,     1577.34354244780}, 
    {     0.00000000057,  6.15295833679,    12194.03291462090}, 
    {     0.00000000045,  1.18274698508,    17789.84561978500}, 
    {     0.00000000047,  1.11643162773,      398.14900340820}, 
    {     0.00000000047,  5.52984238430,    12168.00269657460}, 
    {     0.00000000042,  2.64375300620,    10988.80815753500}, 
    {     0.00000000037,  0.31226891972,     6681.22485339960}, 
    {     0.00000000046,  3.38617099014,   156475.29024799570}, 
    {     0.00000000033,  1.26266496002,     6290.18939699220}, 
    {     0.00000000033,  2.25067065498,     6275.96230299060}, 
    {     0.00000000027,  1.72859626293,     1059.38193018920}, 
    {     0.00000000028,  2.88681054153,      796.29800681640}, 
    {     0.00000000030,  5.52021264181,     7058.59846131540}, 
    {     0.00000000021,  6.22275008403,     6069.77675455340}, 
    {     0.00000000024,  5.83690442827,     6282.09552892320}, 
    {     0.00000000024,  3.95322179797,     6284.05617105960}, 
    {     0.00000000021,  4.87022458966,     3738.76143010800}, 
    {     0.00000000021,  3.58048145762,     6496.37494542940}, 
    {     0.00000000022,  1.97770318395,        7.11354700080}, 
    {     0.00000000019,  3.45979888770,     4136.91043351620}, 
    {     0.00000000015,  2.81379880771,     1589.07289528380}, 
    {     0.00000000015,  1.61313151838,     1194.44701022460}, 
    {     0.00000000015,  0.63083434831,    11769.85369316640}, 
    {     0.00000000019,  0.28082047767,    17260.15465469040}, 
    {     0.00000000017,  1.35165136146,    78051.58573131690}, 
    {     0.00000000015,  2.30941599560,    11856.21865142450}, 
    {     0.00000000012,  1.12997370513,    90617.73743129970}, 
    {     0.00000000012,  0.00611601597,    18073.70493865020}, 
    {     0.00000000012,  1.70058636365,    12559.03815298200}, 
};


static const struct ln_vsop ALIGN32 earth_latitude_b3[LAT_B3] = {
    {     0.00000275993,  0.59480097092,     6283.07584999140}, 
    {     0.00000017034,  3.14159265359,        0.00000000000}, 
    {     0.00000003617,  0.11750575325,    12566.15169998280}, 
    {     0.00000000339,  5.66087461682,    18849.22754997420}, 
    {     0.00000000056,  5.02765554835,     6279.55273164240}, 
    {     0.00000000019,  5.99007646261,     6256.77753019160}, 
    {     0.00000000018,  3.80004734567,     6309.37416979120}, 
    {     0.00000000018,  1.21049250774,     6127.65545055720}, 
    {     0.00000000018,  2.29734567137,     6438.49624942560}, 
    {     0.00000000015,  4.72881467263,     6286.59896834040}, 
    {     0.00000000012,  0.41481671808,    83996.84731811189}, 
    {     0.00000000013,  5.54637369296,    25132.30339996560}, 
    {     0.00000000010,  2.91937214232,    71430.69561812909}, 
    {     0.00000000006,  2.14173241210,    11856.21865142450}, 
};


static const struct ln_vsop ALIGN32 earth_latitude_b4[LAT_B4] = {
    {     0.00000005745,  2.26734029843,     6283.07584999140}, 
    {     0.00000000870,  0.00000000000,        0.00000000000}, 
    {     0.00000000119,  4.26807972611,    12566.15169998280}, 
    {     0.00000000017,  4.07422620440,    18849.22754997420}, 
    {     0.00000000005,  0.84308705203,     1047.74731175470}, 
    {     0.00000000005,  0.05711572303,    84334.66158130829}, 
};


static const struct ln_vsop ALIGN32 earth_latitude_b5[LAT_B5] = {
    {     0.00000000114,  4.31455980099,     6283.07584999140}, 
    {     0.00000000024,  0.00000000000,        0.00000000000}, 
};


static const struct ln_vsop ALIGN32 earth_radius_r0[RADIUS_R0] = {
    {     1.00013988784,  0.00000000000,        0.00000000000}, 
    {     0.01670699632,  3.09846350258,     6283.07584999140}, 
    {     0.00013956024,  3.05524609456,    12566.15169998280}, 
    {     0.00003083720,  5.19846674381,    77713.77146812050}, 
    {     0.00001628463,  1.17387558054,     5753.38488489680}, 
    {     0.00001575572,  2.84685214877,     7860.41939243920}, 
    {     0.00000924799,  5.45292236722,    11506.76976979360}, 
    {     0.00000542439,  4.56409151453,     3930.20969621960}, 
    {     0.00000472110,  3.66100022149,     5884.92684658320}, 
    {     0.00000328780,  5.89983686142,     5223.69391980220}, 
    {     0.00000345969,  0.96368627272,     5507.55323866740}, 
    {     0.00000306784,  0.29867139512,     5573.14280143310}, 
    {     0.00000174844,  3.01193636733,    18849.22754997420}, 
    {     0.00000243181,  4.27349530790,    11790.62908865880}, 
    {     0.00000211836,  5.84714461348,     1577.34354244780}, 
    {     0.00000185740,  5.02199710705,    10977.07880469900}, 
    {     0.00000109835,  5.05510635860,     5486.77784317500}, 
    {     0.00000098316,  0.88681311278,     6069.77675455340}, 
    {     0.00000086500,  5.68956418946,    15720.83878487840}, 
    {     0.00000085831,  1.27079125277,   161000.68573767410}, 
    {     0.00000062917,  0.92177053978,      529.69096509460}, 
    {     0.00000057056,  2.01374292245,    83996.84731811189}, 
    {     0.00000064908,  0.27251341435,    17260.15465469040}, 
    {     0.00000049384,  3.24501240359,     2544.31441988340}, 
    {     0.00000055736,  5.24159799170,    71430.69561812909}, 
    {     0.00000042520,  6.01110257982,     6275.96230299060}, 
    {     0.00000046966,  2.57799853213,      775.52261132400}, 
    {     0.00000038963,  5.36063832897,     4694.00295470760}, 
    {     0.00000044666,  5.53715663816,     9437.76293488700}, 
    {     0.00000035661,  1.67447135798,    12036.46073488820}, 
    {     0.00000031922,  0.18368299942,     5088.62883976680}, 
    {     0.00000031846,  1.77775642078,      398.14900340820}, 
    {     0.00000033193,  0.24370221704,     7084.89678111520}, 
    {     0.00000038245,  2.39255343973,     8827.39026987480}, 
    {     0.00000028468,  1.21344887533,     6286.59896834040}, 
    {     0.00000037486,  0.82961281844,    19651.04848109800}, 
    {     0.00000036957,  4.90107587287,    12139.55350910680}, 
    {     0.00000034537,  1.84270693281,     2942.46342329160}, 
    {     0.00000026275,  4.58896863104,    10447.38783960440}, 
    {     0.00000024596,  3.78660838036,     8429.24126646660}, 
    {     0.00000023587,  0.26866098169,      796.29800681640}, 
    {     0.00000027795,  1.89934427832,     6279.55273164240}, 
    {     0.00000023927,  4.99598548145,     5856.47765911540}, 
    {     0.00000020345,  4.65282190725,     2146.16541647520}, 
    {     0.00000023287,  2.80783632869,    14143.49524243060}, 
    {     0.00000022099,  1.95002636847,     3154.68708489560}, 
    {     0.00000019509,  5.38233922479,     2352.86615377180}, 
    {     0.00000017958,  0.19871369960,     6812.76681508600}, 
    {     0.00000017178,  4.43322156854,    10213.28554621100}, 
    {     0.00000016190,  5.23159323213,    17789.84561978500}, 
    {     0.00000017315,  6.15224075188,    16730.46368959580}, 
    {     0.00000013814,  5.18962074032,     8031.09226305840}, 
    {     0.00000018834,  0.67280058021,   149854.40013480789}, 
    {     0.00000018330,  2.25348717053,    23581.25817731760}, 
    {     0.00000013639,  3.68511810757,     4705.73230754360}, 
    {     0.00000013142,  0.65267698994,    13367.97263110660}, 
    {     0.00000010414,  4.33285688501,    11769.85369316640}, 
    {     0.00000009978,  4.20126336356,     6309.37416979120}, 
    {     0.00000010170,  1.59366684542,     4690.47983635860}, 
    {     0.00000007564,  2.62560597391,     6256.77753019160}, 
    {     0.00000009654,  3.67583728703,    27511.46787353720}, 
    {     0.00000006743,  0.56269927047,     3340.61242669980}, 
    {     0.00000008743,  6.06359123461,     1748.01641306700}, 
    {     0.00000007786,  3.67371235367,    12168.00269657460}, 
    {     0.00000006633,  5.66149277789,    11371.70468975820}, 
    {     0.00000007712,  0.31242577788,     7632.94325965020}, 
    {     0.00000006586,  3.13580054586,      801.82093112380}, 
    {     0.00000007460,  5.64758066660,    11926.25441366880}, 
    {     0.00000006933,  2.92384586372,     6681.22485339960}, 
    {     0.00000006805,  1.42327153767,    23013.53953958720}, 
    {     0.00000006118,  5.13395999022,     1194.44701022460}, 
    {     0.00000006477,  2.64986648493,    19804.82729158280}, 
    {     0.00000005233,  4.62432817299,     6438.49624942560}, 
    {     0.00000006147,  3.02863936662,   233141.31440436149}, 
    {     0.00000004608,  1.72194702724,     7234.79425624200}, 
    {     0.00000004221,  1.55697533726,     7238.67559160000}, 
    {     0.00000005310,  2.40821524293,    11499.65622279280}, 
    {     0.00000005128,  5.32398965690,    11513.88331679440}, 
    {     0.00000004770,  0.25554311730,    11856.21865142450}, 
    {     0.00000005519,  2.09089153789,    17298.18232732620}, 
    {     0.00000005625,  4.34052903053,    90955.55169449610}, 
    {     0.00000004578,  4.46569641570,     5746.27133789600}, 
    {     0.00000003788,  4.90728294810,     4164.31198961300}, 
    {     0.00000005337,  5.09957905103,    31441.67756975680}, 
    {     0.00000003967,  1.20054555175,     1349.86740965880}, 
    {     0.00000004005,  3.02853885902,     1059.38193018920}, 
    {     0.00000003480,  0.76066308841,    10973.55568635000}, 
    {     0.00000004232,  1.05485713117,     5760.49843189760}, 
    {     0.00000004582,  3.76570026763,     6386.16862421000}, 
    {     0.00000003335,  3.13829943354,     6836.64525283380}, 
    {     0.00000003420,  3.00043974511,     4292.33083295040}, 
    {     0.00000003595,  5.70703236079,     5643.17856367740}, 
    {     0.00000003236,  4.16387400645,     9917.69687450980}, 
    {     0.00000004154,  2.59940749519,     7058.59846131540}, 
    {     0.00000003362,  4.54577164994,     4732.03062734340}, 
    {     0.00000002978,  1.30561268820,     6283.14316029419}, 
    {     0.00000002765,  0.51311975671,       26.29831979980}, 
    {     0.00000002807,  5.66230537649,     8635.94200376320}, 
    {     0.00000002927,  5.73787834080,    16200.77272450120}, 
    {     0.00000003167,  1.69181759900,    11015.10647733480}, 
    {     0.00000002598,  2.96244118358,    25132.30339996560}, 
    {     0.00000003519,  3.62639325753,   244287.60000722769}, 
    {     0.00000002676,  4.20727719487,    18073.70493865020}, 
    {     0.00000002978,  1.74971565805,     6283.00853968860}, 
    {     0.00000002287,  1.06976449088,    14314.16811304980}, 
    {     0.00000002863,  5.92838917309,    14712.31711645800}, 
    {     0.00000003071,  0.23793217000,    35371.88726597640}, 
    {     0.00000002656,  0.89959301615,    12352.85260454480}, 
    {     0.00000002415,  2.79975176800,      709.93304855830}, 
    {     0.00000002811,  3.51513864541,    21228.39202354580}, 
    {     0.00000001977,  2.61358297551,      951.71840625060}, 
    {     0.00000002548,  2.47684686575,     6208.29425142410}, 
    {     0.00000001999,  0.56090396506,     7079.37385680780}, 
    {     0.00000002305,  1.05376463592,    22483.84857449259}, 
    {     0.00000001855,  2.86093570752,     5216.58037280140}, 
    {     0.00000002157,  1.31395211105,   154717.60988768269}, 
    {     0.00000001970,  4.36931551625,   167283.76158766549}, 
    {     0.00000001754,  2.14452400686,     6290.18939699220}, 
    {     0.00000001628,  5.85704450617,    10984.19235169980}, 
    {     0.00000002154,  6.03828353794,    10873.98603048040}, 
    {     0.00000001714,  3.70158195222,     1592.59601363280}, 
    {     0.00000001541,  6.21599512982,    23543.23050468179}, 
    {     0.00000001602,  1.99860679677,    10969.96525769820}, 
    {     0.00000001712,  1.34295218697,     3128.38876509580}, 
    {     0.00000001647,  5.54948299069,     6496.37494542940}, 
    {     0.00000001495,  5.43980459648,      155.42039943420}, 
    {     0.00000001827,  5.91227480351,     3738.76143010800}, 
    {     0.00000001726,  2.16765465036,    10575.40668294180}, 
    {     0.00000001532,  5.35683107063,    13521.75144159140}, 
    {     0.00000001824,  1.66056145084,    39302.09696219600}, 
    {     0.00000001605,  1.90930973224,     6133.51265285680}, 
    {     0.00000001282,  2.46013372544,    13916.01910964160}, 
    {     0.00000001211,  4.41360631550,     3894.18182954220}, 
    {     0.00000001394,  1.77801929250,     9225.53927328300}, 
    {     0.00000001571,  4.95512957606,    25158.60171976540}, 
    {     0.00000001205,  1.19212756308,        3.52311834900}, 
    {     0.00000001132,  2.69830084955,     6040.34724601740}, 
    {     0.00000001504,  5.77577388271,    18209.33026366019}, 
    {     0.00000001393,  1.62625077326,     5120.60114558360}, 
    {     0.00000001081,  2.93726744446,    17256.63153634140}, 
    {     0.00000001232,  0.71651766504,   143571.32428481648}, 
    {     0.00000001087,  0.99769687961,      955.59974160860}, 
    {     0.00000001068,  5.28472576591,    65147.61976813770}, 
    {     0.00000001169,  3.11663802316,    14945.31617355440}, 
    {     0.00000000975,  5.10887260780,     6172.86952877200}, 
    {     0.00000001202,  4.02992510403,      553.56940284240}, 
    {     0.00000000979,  2.00000879106,    15110.46611986620}, 
    {     0.00000000962,  4.02380771400,     6282.09552892320}, 
    {     0.00000000999,  3.62643002790,     6262.30045449900}, 
    {     0.00000001030,  5.84987815239,      213.29909543800}, 
    {     0.00000001014,  2.84227679965,     8662.24032356300}, 
    {     0.00000001185,  1.51330629149,    17654.78053974960}, 
    {     0.00000000967,  2.67081017562,     5650.29211067820}, 
    {     0.00000001222,  2.65423784904,    88860.05707098669}, 
    {     0.00000000986,  2.36212814824,     6206.80977871580}, 
    {     0.00000001034,  0.13634950642,    11712.95531823080}, 
    {     0.00000001103,  3.08477302937,    43232.30665841560}, 
    {     0.00000000781,  2.53374971725,    16496.36139620240}, 
    {     0.00000001019,  3.04569392376,     6037.24420376200}, 
    {     0.00000000795,  5.80662989126,     5230.80746680300}, 
    {     0.00000000813,  3.57702871938,    10177.25767953360}, 
    {     0.00000000962,  5.31470594766,     6284.05617105960}, 
    {     0.00000000717,  5.95797471837,    12559.03815298200}, 
    {     0.00000000967,  2.74413738053,     6244.94281435360}, 
    {     0.00000000921,  0.10160160830,    29088.81141598500}, 
    {     0.00000000719,  5.91788189939,     4136.91043351620}, 
    {     0.00000000688,  3.89489045092,     1589.07289528380}, 
    {     0.00000000772,  4.05505380285,     6127.65545055720}, 
    {     0.00000000706,  5.49323197725,    22003.91463486980}, 
    {     0.00000000665,  1.60002747134,    11087.28512591840}, 
    {     0.00000000690,  4.50539825729,      426.59819087600}, 
    {     0.00000000854,  3.26104645060,    20426.57109242200}, 
    {     0.00000000656,  4.32410182940,    16858.48253293320}, 
    {     0.00000000840,  2.59572585212,    28766.92442448400}, 
    {     0.00000000686,  0.61944033771,    11403.67699557500}, 
    {     0.00000000700,  3.40901412473,        7.11354700080}, 
    {     0.00000000728,  0.04050185963,     5481.25491886760}, 
    {     0.00000000653,  1.03869451230,     6062.66320755260}, 
    {     0.00000000559,  4.79221805695,    20199.09495963300}, 
    {     0.00000000633,  5.70229959167,    45892.73043315699}, 
    {     0.00000000591,  6.10986487621,     9623.68827669120}, 
    {     0.00000000520,  3.62310356479,     5333.90024102160}, 
    {     0.00000000602,  5.58381898589,    10344.29506538580}, 
    {     0.00000000496,  2.21027756314,     1990.74501704100}, 
    {     0.00000000691,  1.96733114988,    12416.58850284820}, 
    {     0.00000000640,  1.59062417043,    18319.53658487960}, 
    {     0.00000000625,  3.82358168221,    13517.87010623340}, 
    {     0.00000000475,  1.17025904180,    12569.67481833180}, 
    {     0.00000000660,  5.08498512995,      283.85931886520}, 
    {     0.00000000664,  4.50029469969,    47162.51635463520}, 
    {     0.00000000569,  0.16318535463,    17267.26820169119}, 
    {     0.00000000568,  3.86100969474,     6076.89030155420}, 
    {     0.00000000462,  0.26368763517,     4590.91018048900}, 
    {     0.00000000535,  4.83225423196,    18422.62935909819}, 
    {     0.00000000466,  0.75873879417,     7342.45778018060}, 
    {     0.00000000541,  3.07212190556,   226858.23855437008}, 
    {     0.00000000610,  1.53597089605,    33019.02111220460}, 
    {     0.00000000617,  2.62356328726,    11190.37790013700}, 
    {     0.00000000548,  4.55798855803,    18875.52586977400}, 
    {     0.00000000633,  4.60110281228,    66567.48586525429}, 
    {     0.00000000587,  5.78087907808,      632.78373931320}, 
    {     0.00000000603,  5.38458554802,   316428.22867391503}, 
    {     0.00000000525,  5.01522072363,    12132.43996210600}, 
    {     0.00000000469,  0.59975173763,    21954.15760939799}, 
    {     0.00000000548,  3.50627043672,    17253.04110768959}, 
    {     0.00000000502,  0.98804327589,    11609.86254401220}, 
    {     0.00000000568,  1.98497313089,     7668.63742494250}, 
    {     0.00000000482,  1.62460405687,    12146.66705610760}, 
    {     0.00000000391,  3.68718382972,    18052.92954315780}, 
    {     0.00000000457,  3.77214896610,   156137.47598479928}, 
    {     0.00000000401,  5.29221540240,    15671.08175940660}, 
    {     0.00000000469,  1.80963351735,    12562.62858163380}, 
    {     0.00000000514,  3.37031288919,    20597.24396304120}, 
    {     0.00000000452,  5.66811219778,    10454.50138660520}, 
    {     0.00000000375,  4.98528185039,     9779.10867612540}, 
    {     0.00000000523,  0.97215560834,   155427.54293624099}, 
    {     0.00000000403,  5.13948189770,     1551.04522264800}, 
    {     0.00000000372,  3.69883738807,     9388.00590941520}, 
    {     0.00000000367,  4.43875659833,     4535.05943692440}, 
    {     0.00000000406,  4.20863156497,    12592.45001978260}, 
    {     0.00000000362,  2.55099560446,      242.72860397400}, 
    {     0.00000000471,  4.61907324819,     5436.99301524020}, 
    {     0.00000000388,  4.96020928400,    24356.78078864160}, 
    {     0.00000000441,  5.83872966262,     3496.03282613400}, 
    {     0.00000000349,  6.16307810648,    19800.94595622480}, 
    {     0.00000000356,  0.23819081240,     5429.87946823940}, 
    {     0.00000000346,  5.60809622572,     2379.16447357160}, 
    {     0.00000000380,  2.72105213132,    11933.36796066960}, 
    {     0.00000000432,  0.24215988572,    17996.03116822220}, 
    {     0.00000000378,  5.22516848076,     7477.52286021600}, 
    {     0.00000000337,  5.10885555836,     5849.36411211460}, 
    {     0.00000000315,  0.57827745123,    10557.59416082380}, 
    {     0.00000000318,  4.49949007320,     3634.62102451840}, 
    {     0.00000000323,  1.55850824803,    10440.27429260360}, 
    {     0.00000000314,  5.77154773334,       20.77539549240}, 
    {     0.00000000303,  2.34615580398,     4686.88940770680}, 
    {     0.00000000414,  5.93237602310,    51092.72605085480}, 
    {     0.00000000362,  2.17561997119,    28237.23345938940}, 
    {     0.00000000288,  0.18377405421,    13095.84266507740}, 
    {     0.00000000277,  5.12952205030,    13119.72110282519}, 
    {     0.00000000325,  6.18608287927,     6268.84875598980}, 
    {     0.00000000273,  0.30522428863,    23141.55838292460}, 
    {     0.00000000267,  5.76152585786,     5966.68398033480}, 
    {     0.00000000345,  2.94246040875,    36949.23080842420}, 
    {     0.00000000253,  5.20994580359,    24072.92146977640}, 
    {     0.00000000342,  5.76212804329,    16460.33352952499}, 
    {     0.00000000307,  6.01039067183,    22805.73556599360}, 
    {     0.00000000261,  2.00304796059,     6148.01076995600}, 
    {     0.00000000238,  5.08241964961,     6915.85958930460}, 
    {     0.00000000249,  2.94762789744,      135.06508003540}, 
    {     0.00000000306,  3.89765478921,    10988.80815753500}, 
    {     0.00000000308,  0.05451027736,     4701.11650170840}, 
    {     0.00000000319,  2.95712862064,   163096.18036118349}, 
    {     0.00000000272,  2.07967681309,     4804.20927592700}, 
    {     0.00000000209,  4.43768461442,     6546.15977336420}, 
    {     0.00000000217,  0.73691592312,     6303.85124548380}, 
    {     0.00000000203,  0.32033085531,    25934.12433108940}, 
    {     0.00000000205,  5.22936478995,    20995.39296644940}, 
    {     0.00000000213,  0.20671418919,    28286.99048486120}, 
    {     0.00000000197,  0.48286131290,    16737.57723659660}, 
    {     0.00000000230,  6.06567392849,     6287.00800325450}, 
    {     0.00000000219,  1.29194216300,     5326.78669402080}, 
    {     0.00000000201,  1.74700937253,    22743.40937951640}, 
    {     0.00000000207,  4.45440927276,     6279.48542133960}, 
    {     0.00000000269,  6.05640445030,    64471.99124174489}, 
    {     0.00000000190,  0.99261116842,    29296.61538957860}, 
    {     0.00000000194,  3.82656562755,      419.48464387520}, 
    {     0.00000000262,  5.26961924126,      522.57741809380}, 
    {     0.00000000210,  4.68618183158,     6254.62666252360}, 
    {     0.00000000197,  2.80624554186,     4933.20844033260}, 
    {     0.00000000252,  4.36220154620,    40879.44050464380}, 
    {     0.00000000261,  1.07241516738,    55022.93574707440}, 
    {     0.00000000233,  5.41751014958,    39609.65458316560}, 
    {     0.00000000185,  4.14324541379,     5642.19824260920}, 
    {     0.00000000247,  3.44855612987,     6702.56049386660}, 
    {     0.00000000205,  4.04424043226,      536.80451209540}, 
    {     0.00000000191,  3.15807087926,    16723.35014259500}, 
    {     0.00000000222,  5.16259496507,    23539.70738633280}, 
    {     0.00000000180,  4.56214752149,     6489.26139842860}, 
    {     0.00000000227,  0.60156339452,     5905.70224207560}, 
    {     0.00000000170,  0.93185903228,    16062.18452611680}, 
    {     0.00000000159,  0.92751013112,    23937.85638974100}, 
    {     0.00000000157,  4.69607868164,     6805.65326808520}, 
    {     0.00000000218,  0.85533373430,    16627.37091537720}, 
    {     0.00000000169,  0.94641052064,     3097.88382272579}, 
    {     0.00000000207,  4.88410451334,     6286.66627864320}, 
    {     0.00000000160,  4.95943826819,    10021.83728009940}, 
    {     0.00000000175,  6.12762824563,   239424.39025435288}, 
    {     0.00000000173,  3.13887234973,     6179.98307577280}, 
    {     0.00000000157,  3.62822057807,    18451.07854656599}, 
    {     0.00000000206,  5.74617821138,     3646.35037735440}, 
    {     0.00000000157,  4.67695912207,     6709.67404086740}, 
    {     0.00000000146,  3.09506069745,     4907.30205014560}, 
    {     0.00000000165,  2.27139128760,    10660.68693504240}, 
    {     0.00000000144,  3.96947747592,     6019.99192661860}, 
    {     0.00000000171,  5.91302216729,     6058.73105428950}, 
    {     0.00000000144,  2.13155655120,    26084.02180621620}, 
    {     0.00000000151,  0.67417383565,     2388.89402044920}, 
    {     0.00000000196,  1.67718461229,     2107.03450754240}, 
    {     0.00000000146,  5.10373877968,    10770.89325626180}, 
    {     0.00000000187,  1.23915444627,    19402.79695281660}, 
    {     0.00000000137,  1.26247412216,    12566.21901028560}, 
    {     0.00000000191,  5.03547476279,      263.08392337280}, 
    {     0.00000000137,  3.52825454595,      639.89728631400}, 
    {     0.00000000135,  0.73840670927,     5017.50837136500}, 
    {     0.00000000164,  2.39195095081,     6357.85744855870}, 
    {     0.00000000168,  0.05515907462,     9380.95967271720}, 
    {     0.00000000161,  1.15721259392,    26735.94526221320}, 
    {     0.00000000144,  1.76097645199,     5888.44996493220}, 
    {     0.00000000131,  2.51859277344,     6599.46771964800}, 
    {     0.00000000142,  2.43802911123,     5881.40372823420}, 
    {     0.00000000159,  5.90325893762,     6281.59137728310}, 
    {     0.00000000151,  3.72338532519,    12669.24447420140}, 
    {     0.00000000132,  2.38417741883,     6525.80445396540}, 
    {     0.00000000127,  0.00254936441,    10027.90319572920}, 
    {     0.00000000148,  2.85102145528,     6418.14093002680}, 
    {     0.00000000143,  5.74460279560,    26087.90314157420}, 
    {     0.00000000172,  0.41289962240,   174242.46596404970}, 
    {     0.00000000136,  4.15497742275,     6311.52503745920}, 
    {     0.00000000170,  5.98194913129,   327574.51427678125}, 
    {     0.00000000136,  2.48430537541,    13341.67431130680}, 
    {     0.00000000149,  0.33002271275,      245.83164622940}, 
    {     0.00000000165,  2.49667924600,    58953.14544329400}, 
    {     0.00000000123,  1.67328384813,    32217.20018108080}, 
    {     0.00000000123,  3.45660563754,     6277.55292568400}, 
    {     0.00000000117,  0.86065134175,     6245.04817735560}, 
    {     0.00000000149,  5.61358281003,     5729.50644714900}, 
    {     0.00000000128,  0.71204006448,      103.09277421860}, 
    {     0.00000000159,  2.43166592149,   221995.02880149524}, 
    {     0.00000000137,  1.70657709200,    12566.08438968000}, 
    {     0.00000000129,  2.80667872683,     6016.46880826960}, 
    {     0.00000000113,  3.58302904101,    25685.87280280800}, 
    {     0.00000000109,  3.26403795962,     6819.88036208680}, 
    {     0.00000000122,  0.34120688202,     1162.47470440780}, 
    {     0.00000000106,  1.59721172719,    17782.73207278420}, 
    {     0.00000000144,  2.28891651774,    12489.88562870720}, 
    {     0.00000000137,  5.82029768354,    44809.65020086340}, 
    {     0.00000000134,  1.26539983018,     5331.35744374080}, 
    {     0.00000000103,  5.96518130595,     6321.10352262720}, 
    {     0.00000000109,  0.33808549034,    11300.58422135640}, 
    {     0.00000000129,  5.89187277190,    12029.34718788740}, 
    {     0.00000000122,  5.77325634636,    11919.14086666800}, 
    {     0.00000000107,  6.24998989350,    77690.75950573849}, 
    {     0.00000000107,  1.00535580713,    77736.78343050249}, 
    {     0.00000000115,  5.86963518266,    12721.57209941700}, 
    {     0.00000000102,  5.66283467269,     5540.08578945880}, 
    {     0.00000000143,  0.24122178432,     4214.06901508480}, 
    {     0.00000000143,  0.88529649733,     7576.56007357400}, 
    {     0.00000000107,  2.92124030351,    31415.37924995700}, 
    {     0.00000000100,  5.99485644501,     4061.21921539440}, 
    {     0.00000000103,  2.41941934525,     5547.19933645960}, 
    {     0.00000000104,  4.44106051277,     2118.76386037840}, 
    {     0.00000000110,  0.37559635174,     5863.59120611620}, 
    {     0.00000000124,  2.55619029611,    12539.85338018300}, 
    {     0.00000000110,  3.66952094465,   238004.52415723629}, 
    {     0.00000000112,  4.32512422724,    97238.62754448749}, 
    {     0.00000000120,  1.26895630075,    12043.57428188900}, 
    {     0.00000000097,  5.42612959752,     7834.12107263940}, 
    {     0.00000000094,  2.56461130309,    19004.64794940840}, 
    {     0.00000000105,  5.68272475301,    16522.65971600220}, 
    {     0.00000000117,  3.65425622684,    34520.30930938080}, 
    {     0.00000000108,  1.24206843948,    84672.47584450469}, 
    {     0.00000000098,  0.13589994287,    11080.17157891760}, 
    {     0.00000000097,  2.46722096722,    71980.63357473118}, 
    {     0.00000000095,  5.36958330451,     6288.59877429880}, 
    {     0.00000000096,  0.20796618776,    18139.29450141590}, 
    {     0.00000000111,  5.01961920313,    11823.16163945020}, 
    {     0.00000000090,  2.72355843779,    26880.31981303260}, 
    {     0.00000000099,  0.90164266199,    18635.92845453620}, 
    {     0.00000000126,  4.78722177847,   305281.94307104882}, 
    {     0.00000000124,  5.00979495566,   172146.97134054029}, 
    {     0.00000000090,  4.50544881196,    40077.61957352000}, 
    {     0.00000000104,  5.63679680710,     2787.04302385740}, 
    {     0.00000000091,  5.43564326147,     6272.03014972750}, 
    {     0.00000000100,  2.00639461597,    12323.42309600880}, 
    {     0.00000000117,  2.35555589778,    83286.91426955358}, 
    {     0.00000000105,  2.59824000109,    30666.15495843280}, 
    {     0.00000000090,  2.35779490026,    12491.37010141550}, 
    {     0.00000000089,  3.57152453732,    11720.06886523160}, 
    {     0.00000000095,  5.67015349858,    14919.01785375460}, 
    {     0.00000000087,  1.86043406047,    27707.54249429480}, 
    {     0.00000000106,  3.04150600352,    22345.26037610820}, 
    {     0.00000000082,  5.58298993353,    10241.20229116720}, 
    {     0.00000000083,  3.10607039533,    36147.40987730040}, 
    {     0.00000000094,  5.47749711149,     9924.81042151060}, 
    {     0.00000000082,  4.71988314145,    15141.39079431200}, 
    {     0.00000000096,  3.89073946348,     6379.05507720920}, 
    {     0.00000000110,  4.92131611151,     5621.84292321040}, 
    {     0.00000000110,  4.89978492291,    72140.62866668739}, 
    {     0.00000000097,  5.20764563059,     6303.43116939020}, 
    {     0.00000000085,  1.61269222311,    33326.57873317420}, 
    {     0.00000000093,  1.32651591333,    23020.65308658799}, 
    {     0.00000000090,  0.57733016380,    26482.17080962440}, 
    {     0.00000000078,  3.99588630754,    11293.47067435560}, 
    {     0.00000000106,  3.92012705073,    62883.35513951360}, 
    {     0.00000000098,  2.94397773524,      316.39186965660}, 
    {     0.00000000076,  3.96310417608,    29026.48522950779}, 
    {     0.00000000098,  0.95914722366,    48739.85989708300}, 
    {     0.00000000078,  1.97068528043,    90279.92316810328}, 
    {     0.00000000076,  0.23027966596,    21424.46664430340}, 
    {     0.00000000079,  1.46227790922,     8982.81066930900}, 
    {     0.00000000078,  2.28840998832,      266.60704172180}, 
    {     0.00000000071,  1.51940765590,    33794.54372352860}, 
    {     0.00000000076,  0.22880641443,    57375.80190084620}, 
    {     0.00000000097,  0.39449562097,    24279.10701821359}, 
    {     0.00000000075,  2.77638584795,    12964.30070339100}, 
    {     0.00000000077,  5.18846946344,    11520.99686379520}, 
    {     0.00000000068,  0.50006599129,     4274.51831083240}, 
    {     0.00000000075,  2.07323762803,    15664.03552270859}, 
    {     0.00000000077,  0.46665178780,    16207.88627150200}, 
    {     0.00000000081,  4.10452219483,   161710.61878623239}, 
    {     0.00000000071,  3.91415328513,     7875.67186362420}, 
    {     0.00000000081,  0.91938383406,       74.78159856730}, 
    {     0.00000000083,  4.69916218791,    23006.42599258639}, 
    {     0.00000000069,  0.98999300277,     6393.28217121080}, 
    {     0.00000000065,  5.41938745446,    28628.33622609960}, 
    {     0.00000000073,  2.45564765251,    15508.61512327440}, 
    {     0.00000000065,  3.02336771694,     5959.57043333400}, 
    {     0.00000000064,  0.18375587635,     1066.49547719000}, 
    {     0.00000000080,  5.81239171612,    12341.80690428090}, 
    {     0.00000000066,  2.15105504851,       38.02767263580}, 
    {     0.00000000067,  5.14047250153,     9814.60410029120}, 
    {     0.00000000062,  2.43313614978,    10138.10951694860}, 
    {     0.00000000068,  2.24442548639,    24383.07910844140}, 
    {     0.00000000078,  1.39649333997,     9411.46461508720}, 
    {     0.00000000059,  4.95362151577,    35707.71008290740}, 
    {     0.00000000073,  1.35229143121,     5327.47610838280}, 
    {     0.00000000057,  3.16018882154,     5490.30096152400}, 
    {     0.00000000072,  5.91833527334,    10881.09957748120}, 
    {     0.00000000067,  0.66414713064,    29864.33402730900}, 
    {     0.00000000065,  0.30352816135,     7018.95236352320}, 
    {     0.00000000059,  5.36231868425,    10239.58386601080}, 
    {     0.00000000056,  3.22196331515,     2636.72547263700}, 
    {     0.00000000068,  5.32086226658,     3116.65941225980}, 
    {     0.00000000059,  1.63156134967,    61306.01159706580}, 
    {     0.00000000054,  4.29491690425,    21947.11137270000}, 
    {     0.00000000070,  0.29271565928,     6528.90749622080}, 
    {     0.00000000057,  5.89190132575,    34513.26307268280}, 
    {     0.00000000054,  2.51856815404,     6279.19451463340}, 
    {     0.00000000074,  1.38235845304,     9967.45389998160}, 
    {     0.00000000054,  0.92276712152,     6286.95718534940}, 
    {     0.00000000070,  5.00933012248,     6453.74872061060}, 
    {     0.00000000053,  3.86543309344,    32370.97899156560}, 
    {     0.00000000055,  4.51794544854,    34911.41207609100}, 
    {     0.00000000063,  5.41479412056,    11502.83761653050}, 
    {     0.00000000063,  2.34416220742,    11510.70192305670}, 
    {     0.00000000056,  0.91310629913,     9910.58332750900}, 
    {     0.00000000067,  4.03308763854,    34596.36465465240}, 
    {     0.00000000060,  5.57024703495,     5756.90800324580}, 
    {     0.00000000072,  2.80863088166,    10866.87248347960}, 
    {     0.00000000066,  6.12047940728,    12074.48840752400}, 
    {     0.00000000051,  2.59519527563,    11396.56344857420}, 
    {     0.00000000062,  5.14746754396,    25287.72379939980}, 
    {     0.00000000054,  2.50994032776,     5999.21653112620}, 
    {     0.00000000051,  4.51195861837,    29822.78323632420}, 
    {     0.00000000059,  0.44167237876,   250570.67585721909}, 
    {     0.00000000051,  3.68849066760,     6262.72053059260}, 
    {     0.00000000049,  0.54704693048,    22594.05489571199}, 
    {     0.00000000065,  2.38423614501,    52670.06959330260}, 
    {     0.00000000069,  5.34363738671,    66813.56483573320}, 
    {     0.00000000056,  2.67216180349,    17892.93839400359}, 
    {     0.00000000049,  4.18361320516,    18606.49894600020}, 
    {     0.00000000055,  0.83886167974,    20452.86941222180}, 
    {     0.00000000050,  1.46327331958,    37455.72649597440}, 
    {     0.00000000058,  3.34847975377,    33990.61834428620}, 
    {     0.00000000065,  1.45522693982,    76251.32777062019}, 
    {     0.00000000056,  2.35650664200,    37724.75341974820}, 
    {     0.00000000048,  1.80689447612,      206.18554843720}, 
    {     0.00000000056,  3.84224878744,     5483.25472482600}, 
    {     0.00000000053,  0.17334326094,    77717.29458646949}, 
    {     0.00000000053,  0.79879700631,    77710.24834977149}, 
    {     0.00000000047,  0.43240779709,      735.87651353180}, 
    {     0.00000000053,  4.58786566028,    11616.97609101300}, 
    {     0.00000000048,  6.20230111054,     4171.42553661380}, 
    {     0.00000000052,  2.91719053030,     6993.00889854970}, 
    {     0.00000000057,  3.42008310383,    50317.20343953080}, 
    {     0.00000000048,  0.12356889012,    13362.44970679920}, 
    {     0.00000000060,  5.52056066934,      949.17560896980}, 
    {     0.00000000045,  3.37963782356,    10763.77970926100}, 
    {     0.00000000047,  5.50958184902,    12779.45079542080}, 
    {     0.00000000052,  5.42770349015,   310145.15282392364}, 
    {     0.00000000061,  2.93237974631,     5791.41255753260}, 
    {     0.00000000044,  2.87440620802,     8584.66166590080}, 
    {     0.00000000046,  4.03141796560,    10667.80048204320}, 
    {     0.00000000044,  1.21579107625,     6272.43918464160}, 
    {     0.00000000047,  2.57670800912,    11492.54267579200}, 
    {     0.00000000044,  3.62570223167,    63658.87775083760}, 
    {     0.00000000051,  0.84531181151,    12345.73905754400}, 
    {     0.00000000046,  1.17584556517,      149.56319713460}, 
    {     0.00000000043,  0.01524970172,    37853.87549938260}, 
    {     0.00000000043,  0.79038834934,      640.87760738220}, 
    {     0.00000000044,  2.22554419931,     6293.71251534120}, 
    {     0.00000000049,  1.01528394907,   149144.46708624958}, 
    {     0.00000000041,  3.27146326065,     8858.31494432060}, 
    {     0.00000000045,  3.03765521215,    65236.22129328540}, 
    {     0.00000000058,  5.45843180927,     1975.49254585600}, 
    {     0.00000000041,  1.32190847146,     2547.83753823240}, 
    {     0.00000000047,  3.67626039848,    28313.28880466100}, 
    {     0.00000000047,  6.21438985953,    10991.30589870060}, 
    {     0.00000000040,  2.37237751212,     8273.82086703240}, 
    {     0.00000000056,  1.09773690181,    77376.20102240759}, 
    {     0.00000000040,  2.35698541041,     2699.73481931760}, 
    {     0.00000000043,  5.28030897946,    17796.95916678580}, 
    {     0.00000000054,  2.59175932091,    22910.44676536859}, 
    {     0.00000000055,  0.07988985505,    83467.15635301729}, 
    {     0.00000000041,  4.47510694062,     5618.31980486140}, 
    {     0.00000000040,  1.35670430524,    27177.85152920020}, 
    {     0.00000000041,  2.48011323946,     6549.68289171320}, 
    {     0.00000000050,  2.56387920528,    82576.98122099529}, 
    {     0.00000000042,  4.78798367468,     7856.89627409019}, 
    {     0.00000000047,  2.75482175292,    18202.21671665939}, 
    {     0.00000000039,  1.97008298629,    24491.42579258340}, 
    {     0.00000000042,  4.04346599946,     7863.94251078820}, 
    {     0.00000000039,  3.01033936420,      853.19638175200}, 
    {     0.00000000038,  0.49178679251,    38650.17350619900}, 
    {     0.00000000044,  1.35931241699,    21393.54196985760}, 
    {     0.00000000036,  4.86047906533,     4157.19844261220}, 
    {     0.00000000043,  5.64354880978,     1062.90504853820}, 
    {     0.00000000039,  3.92736779879,     3903.91137641980}, 
    {     0.00000000040,  5.39694918320,     9498.21223063460}, 
    {     0.00000000043,  2.40863861919,    29424.63423291600}, 
    {     0.00000000046,  2.08022244271,    12573.26524698360}, 
    {     0.00000000050,  6.15760345261,    78051.34191383338}, 
};


static const struct ln_vsop ALIGN32 earth_radius_r1[RADIUS_R1] = {
    {     0.00103018607,  1.10748968172,     6283.07584999140}, 
    {     0.00001721238,  1.06442300386,    12566.15169998280}, 
    {     0.00000702217,  3.14159265359,        0.00000000000}, 
    {     0.00000032345,  1.02168583254,    18849.22754997420}, 
    {     0.00000030801,  2.84358443952,     5507.55323866740}, 
    {     0.00000024978,  1.31906570344,     5223.69391980220}, 
    {     0.00000018487,  1.42428709076,     1577.34354244780}, 
    {     0.00000010077,  5.91385248388,    10977.07880469900}, 
    {     0.00000008635,  0.27158192945,     5486.77784317500}, 
    {     0.00000008654,  1.42046854427,     6275.96230299060}, 
    {     0.00000005069,  1.68613408916,     5088.62883976680}, 
    {     0.00000004985,  6.01402338185,     6286.59896834040}, 
    {     0.00000004667,  5.98749245692,      529.69096509460}, 
    {     0.00000004395,  0.51800423445,     4694.00295470760}, 
    {     0.00000003870,  4.74932206877,     2544.31441988340}, 
    {     0.00000003755,  5.07053801166,      796.29800681640}, 
    {     0.00000004100,  1.08424801084,     9437.76293488700}, 
    {     0.00000003518,  0.02290216978,    83996.84731811189}, 
    {     0.00000003436,  0.94937503872,    71430.69561812909}, 
    {     0.00000003221,  6.15628775321,     2146.16541647520}, 
    {     0.00000003418,  5.41151581880,      775.52261132400}, 
    {     0.00000002863,  5.48433323746,    10447.38783960440}, 
    {     0.00000002525,  0.24296913555,      398.14900340820}, 
    {     0.00000002205,  4.94892172085,     6812.76681508600}, 
    {     0.00000002186,  0.41991932164,     8031.09226305840}, 
    {     0.00000002828,  3.41986300734,     2352.86615377180}, 
    {     0.00000002554,  6.13241770582,     6438.49624942560}, 
    {     0.00000001932,  5.31374587091,     8429.24126646660}, 
    {     0.00000002427,  3.09118902115,     4690.47983635860}, 
    {     0.00000001730,  1.53685999718,     4705.73230754360}, 
    {     0.00000002250,  3.68836395620,     7084.89678111520}, 
    {     0.00000002094,  1.28169060400,     1748.01641306700}, 
    {     0.00000001483,  3.22226346483,     7234.79425624200}, 
    {     0.00000001434,  0.81293662216,    14143.49524243060}, 
    {     0.00000001754,  3.22883705112,     6279.55273164240}, 
    {     0.00000001583,  4.09815978783,    11499.65622279280}, 
    {     0.00000001575,  5.53890314149,     3154.68708489560}, 
    {     0.00000001847,  1.82041234937,     7632.94325965020}, 
    {     0.00000001499,  3.63177937611,    11513.88331679440}, 
    {     0.00000001337,  4.64442556061,     6836.64525283380}, 
    {     0.00000001275,  2.69329661394,     1349.86740965880}, 
    {     0.00000001348,  6.15284035323,     5746.27133789600}, 
    {     0.00000001126,  3.35676107739,    17789.84561978500}, 
    {     0.00000001470,  3.65282991735,     1194.44701022460}, 
    {     0.00000001101,  4.49747427670,     4292.33083295040}, 
    {     0.00000001168,  2.58033028504,    13367.97263110660}, 
    {     0.00000001236,  5.64980098028,     5760.49843189760}, 
    {     0.00000000985,  0.65326301914,     5856.47765911540}, 
    {     0.00000000928,  2.32555018290,    10213.28554621100}, 
    {     0.00000001073,  5.82672338169,    12036.46073488820}, 
    {     0.00000000918,  0.76907130762,    16730.46368959580}, 
    {     0.00000000876,  1.50335727807,    11926.25441366880}, 
    {     0.00000001023,  5.62071200879,     6256.77753019160}, 
    {     0.00000000853,  0.65678134630,      155.42039943420}, 
    {     0.00000000802,  4.10519132094,      951.71840625060}, 
    {     0.00000000859,  1.42880883564,     5753.38488489680}, 
    {     0.00000000992,  1.14238001610,     1059.38193018920}, 
    {     0.00000000814,  1.63584008733,     6681.22485339960}, 
    {     0.00000000664,  4.55039663226,     5216.58037280140}, 
    {     0.00000000627,  1.50782904323,     5643.17856367740}, 
    {     0.00000000644,  4.19480024859,     6040.34724601740}, 
    {     0.00000000590,  6.18371704849,     4164.31198961300}, 
    {     0.00000000635,  0.52423584770,     6290.18939699220}, 
    {     0.00000000650,  0.97935492869,    25132.30339996560}, 
    {     0.00000000568,  2.30121525349,    10973.55568635000}, 
    {     0.00000000549,  5.26737827342,     3340.61242669980}, 
    {     0.00000000547,  2.20143332641,     1592.59601363280}, 
    {     0.00000000526,  0.92464258271,    11371.70468975820}, 
    {     0.00000000493,  5.91036281399,     3894.18182954220}, 
    {     0.00000000483,  1.66005711540,    12168.00269657460}, 
    {     0.00000000514,  3.59683072524,    10969.96525769820}, 
    {     0.00000000516,  3.97164781773,    17298.18232732620}, 
    {     0.00000000529,  5.03538677680,     9917.69687450980}, 
    {     0.00000000487,  2.50544745305,     6127.65545055720}, 
    {     0.00000000419,  4.05235655996,    10984.19235169980}, 
    {     0.00000000538,  5.54081539813,      553.56940284240}, 
    {     0.00000000402,  2.16859478359,     7860.41939243920}, 
    {     0.00000000552,  2.32219865498,    11506.76976979360}, 
    {     0.00000000367,  3.39145698451,     6496.37494542940}, 
    {     0.00000000360,  5.34467204596,     7079.37385680780}, 
    {     0.00000000334,  3.61346365667,    11790.62908865880}, 
    {     0.00000000454,  0.28755421898,      801.82093112380}, 
    {     0.00000000419,  3.69613970002,    10575.40668294180}, 
    {     0.00000000319,  0.30793759304,    16200.77272450120}, 
    {     0.00000000376,  5.81560210508,     7058.59846131540}, 
    {     0.00000000364,  1.08425056923,     6309.37416979120}, 
    {     0.00000000294,  4.54798604178,    11856.21865142450}, 
    {     0.00000000290,  1.26451946335,     8635.94200376320}, 
    {     0.00000000394,  4.15683669084,       26.29831979980}, 
    {     0.00000000260,  5.09424572996,    10177.25767953360}, 
    {     0.00000000241,  2.25766000302,    11712.95531823080}, 
    {     0.00000000239,  1.06936978753,      242.72860397400}, 
    {     0.00000000276,  3.44260568764,     5884.92684658320}, 
    {     0.00000000255,  5.38496803122,    21228.39202354580}, 
    {     0.00000000307,  4.24313885601,     3738.76143010800}, 
    {     0.00000000213,  3.44661200485,      213.29909543800}, 
    {     0.00000000198,  0.69427265195,     1990.74501704100}, 
    {     0.00000000195,  5.16563409007,    12352.85260454480}, 
    {     0.00000000213,  3.89937836808,    13916.01910964160}, 
    {     0.00000000214,  4.00445200772,     5230.80746680300}, 
    {     0.00000000184,  5.59805976614,     6283.14316029419}, 
    {     0.00000000184,  2.85275392124,     7238.67559160000}, 
    {     0.00000000179,  2.54259058252,    14314.16811304980}, 
    {     0.00000000236,  5.58826125715,     6069.77675455340}, 
    {     0.00000000189,  2.72689937708,     6062.66320755260}, 
    {     0.00000000184,  6.04216273598,     6283.00853968860}, 
    {     0.00000000225,  1.66128561344,     4732.03062734340}, 
    {     0.00000000230,  3.62591335086,     6284.05617105960}, 
    {     0.00000000172,  0.97566476085,     3930.20969621960}, 
    {     0.00000000162,  2.19467339429,    18073.70493865020}, 
    {     0.00000000215,  1.04672844028,     3496.03282613400}, 
    {     0.00000000182,  5.17782354566,    17253.04110768959}, 
    {     0.00000000167,  2.17754938066,     6076.89030155420}, 
    {     0.00000000167,  4.75672473773,    17267.26820169119}, 
    {     0.00000000149,  0.80944185798,      709.93304855830}, 
    {     0.00000000149,  0.17584214812,     9779.10867612540}, 
    {     0.00000000192,  5.00680790235,    11015.10647733480}, 
    {     0.00000000141,  4.38420380014,     4136.91043351620}, 
    {     0.00000000158,  4.60969054283,     9623.68827669120}, 
    {     0.00000000133,  3.30507062245,   154717.60988768269}, 
    {     0.00000000166,  6.13191098325,        3.52311834900}, 
    {     0.00000000181,  1.60715321141,        7.11354700080}, 
    {     0.00000000150,  5.28136702046,    13517.87010623340}, 
    {     0.00000000142,  0.49788089569,    25158.60171976540}, 
    {     0.00000000124,  6.03440459813,     9225.53927328300}, 
    {     0.00000000124,  0.99251562639,    65147.61976813770}, 
    {     0.00000000128,  1.92032744711,    22483.84857449259}, 
    {     0.00000000124,  3.99739675184,     4686.88940770680}, 
    {     0.00000000121,  2.37814805239,   167283.76158766549}, 
    {     0.00000000123,  5.62315112940,     5642.19824260920}, 
    {     0.00000000117,  5.81755956156,    12569.67481833180}, 
    {     0.00000000157,  3.40236948518,    16496.36139620240}, 
    {     0.00000000130,  2.10499918142,     1589.07289528380}, 
    {     0.00000000116,  0.55839966736,     5849.36411211460}, 
    {     0.00000000123,  5.81645568991,     6282.09552892320}, 
    {     0.00000000110,  0.42176497674,     6172.86952877200}, 
    {     0.00000000150,  4.26279600865,     3128.38876509580}, 
    {     0.00000000106,  2.27436561182,     5429.87946823940}, 
    {     0.00000000114,  1.52894564202,    12559.03815298200}, 
    {     0.00000000121,  0.39459045915,    12132.43996210600}, 
    {     0.00000000104,  2.41845930933,      426.59819087600}, 
    {     0.00000000109,  5.82786999856,    16858.48253293320}, 
    {     0.00000000102,  4.46626484910,    23543.23050468179}, 
    {     0.00000000100,  2.93812275274,     4535.05943692440}, 
    {     0.00000000097,  3.97935904984,     6133.51265285680}, 
    {     0.00000000098,  0.87616810121,     6525.80445396540}, 
    {     0.00000000110,  6.22339014386,    12146.66705610760}, 
    {     0.00000000098,  3.17344332543,    10440.27429260360}, 
    {     0.00000000096,  2.44128701699,     3097.88382272579}, 
    {     0.00000000099,  5.75642493267,     7342.45778018060}, 
    {     0.00000000090,  0.18984343165,    13119.72110282519}, 
    {     0.00000000099,  5.58884724219,     2388.89402044920}, 
    {     0.00000000091,  6.04278320182,    20426.57109242200}, 
    {     0.00000000080,  1.29028142103,     5650.29211067820}, 
    {     0.00000000086,  3.94529200528,    10454.50138660520}, 
    {     0.00000000085,  1.92836879835,    29088.81141598500}, 
    {     0.00000000076,  2.70726317966,   143571.32428481648}, 
    {     0.00000000091,  5.63859073351,     8827.39026987480}, 
    {     0.00000000076,  1.80783856698,    28286.99048486120}, 
    {     0.00000000075,  3.40858032804,     5481.25491886760}, 
    {     0.00000000070,  4.53719487231,    17256.63153634140}, 
    {     0.00000000089,  1.10064490942,    11769.85369316640}, 
    {     0.00000000066,  2.78384937771,      536.80451209540}, 
    {     0.00000000068,  3.88199295043,    17260.15465469040}, 
    {     0.00000000088,  3.88075269535,     7477.52286021600}, 
    {     0.00000000061,  6.17558202197,    11087.28512591840}, 
    {     0.00000000060,  4.34824715818,     6206.80977871580}, 
    {     0.00000000082,  4.59843208943,     9388.00590941520}, 
    {     0.00000000079,  1.63139280394,     4933.20844033260}, 
    {     0.00000000081,  1.55550779371,     9380.95967271720}, 
    {     0.00000000078,  4.20905757519,     5729.50644714900}, 
    {     0.00000000058,  5.76889633224,     3634.62102451840}, 
    {     0.00000000060,  0.93813100594,    12721.57209941700}, 
    {     0.00000000071,  6.11408885148,     8662.24032356300}, 
    {     0.00000000057,  5.48112524468,    18319.53658487960}, 
    {     0.00000000070,  0.01749174864,    14945.31617355440}, 
    {     0.00000000074,  1.09976045820,    16460.33352952499}, 
    {     0.00000000056,  1.63036186739,    15720.83878487840}, 
    {     0.00000000055,  4.86788348404,    13095.84266507740}, 
    {     0.00000000060,  5.93729841267,    12539.85338018300}, 
    {     0.00000000054,  0.22608242982,    15110.46611986620}, 
    {     0.00000000054,  2.30250047594,    16062.18452611680}, 
    {     0.00000000064,  2.13513754101,     7875.67186362420}, 
    {     0.00000000059,  5.87963500139,     5331.35744374080}, 
    {     0.00000000058,  2.30546168615,      955.59974160860}, 
    {     0.00000000049,  1.93839278478,     5333.90024102160}, 
    {     0.00000000054,  5.80331607119,    12043.57428188900}, 
    {     0.00000000054,  4.44671053809,     4701.11650170840}, 
    {     0.00000000049,  0.30241161485,     6805.65326808520}, 
    {     0.00000000046,  2.76898193028,     6709.67404086740}, 
    {     0.00000000046,  3.98449608961,    98068.53671630539}, 
    {     0.00000000049,  3.72022009896,    12323.42309600880}, 
    {     0.00000000045,  3.30065998328,    22003.91463486980}, 
    {     0.00000000048,  0.71071357303,     6303.43116939020}, 
    {     0.00000000061,  1.66030429494,     6262.30045449900}, 
    {     0.00000000047,  1.26317154881,    11919.14086666800}, 
    {     0.00000000051,  1.08020906825,    10988.80815753500}, 
    {     0.00000000045,  0.89150445122,    51868.24866217880}, 
    {     0.00000000043,  0.57756724285,    24356.78078864160}, 
    {     0.00000000043,  1.61526242998,     6277.55292568400}, 
    {     0.00000000045,  2.96132920534,     8982.81066930900}, 
    {     0.00000000043,  5.74295325645,    11403.67699557500}, 
    {     0.00000000055,  3.14274403422,    33019.02111220460}, 
    {     0.00000000057,  0.06379726305,    15671.08175940660}, 
    {     0.00000000041,  2.53761820726,     6262.72053059260}, 
    {     0.00000000040,  1.53130436944,    18451.07854656599}, 
    {     0.00000000052,  1.71451922581,     1551.04522264800}, 
    {     0.00000000055,  0.89439119424,    11933.36796066960}, 
    {     0.00000000045,  3.88495384656,    60530.48898574180}, 
    {     0.00000000040,  4.75740908001,    38526.57435087200}, 
    {     0.00000000040,  3.77498297348,    26087.90314157420}, 
    {     0.00000000039,  2.97113832621,     2118.76386037840}, 
    {     0.00000000040,  3.36050962605,    10021.83728009940}, 
    {     0.00000000047,  1.67051113434,     6303.85124548380}, 
    {     0.00000000052,  5.21827368711,    77713.77146812050}, 
    {     0.00000000047,  4.26356628717,    21424.46664430340}, 
    {     0.00000000037,  1.66712389942,     6819.88036208680}, 
    {     0.00000000037,  0.65746800933,    12029.34718788740}, 
    {     0.00000000035,  3.36255650927,    24072.92146977640}, 
    {     0.00000000036,  0.11087914947,    10344.29506538580}, 
    {     0.00000000040,  4.14725582115,     2787.04302385740}, 
    {     0.00000000035,  5.93650887012,    31570.79964939120}, 
    {     0.00000000036,  2.15108874765,    30774.50164257480}, 
    {     0.00000000036,  1.75078825382,    16207.88627150200}, 
    {     0.00000000034,  2.75708224536,    12139.55350910680}, 
    {     0.00000000034,  6.16891378800,    24491.42579258340}, 
    {     0.00000000034,  2.31528650443,    55798.45835839840}, 
    {     0.00000000032,  4.21446357042,    15664.03552270859}, 
    {     0.00000000034,  3.19783054699,    32217.20018108080}, 
    {     0.00000000039,  1.24979117796,     6418.14093002680}, 
    {     0.00000000038,  5.89832942685,      640.87760738220}, 
    {     0.00000000033,  4.80200120107,    16723.35014259500}, 
    {     0.00000000032,  1.72442327688,    27433.88921587499}, 
    {     0.00000000035,  4.44608896525,    18202.21671665939}, 
    {     0.00000000031,  4.52790731280,     6702.56049386660}, 
    {     0.00000000034,  3.96287980676,    18216.44381066100}, 
    {     0.00000000030,  5.06259854444,   226858.23855437008}, 
    {     0.00000000034,  1.43910280005,    49515.38250840700}, 
    {     0.00000000030,  0.29303163371,    13521.75144159140}, 
    {     0.00000000029,  2.02633840220,    11609.86254401220}, 
    {     0.00000000030,  2.54923230240,     9924.81042151060}, 
    {     0.00000000032,  4.91793198558,    11300.58422135640}, 
    {     0.00000000030,  0.23284423547,    23581.25817731760}, 
    {     0.00000000029,  1.62807736495,      639.89728631400}, 
    {     0.00000000028,  3.84568936822,     2699.73481931760}, 
    {     0.00000000029,  1.83149729794,    29822.78323632420}, 
    {     0.00000000033,  4.60320094415,    19004.64794940840}, 
    {     0.00000000027,  1.86151121799,     6288.59877429880}, 
    {     0.00000000030,  4.46494072240,    36147.40987730040}, 
    {     0.00000000028,  5.19684492912,     5863.59120611620}, 
    {     0.00000000035,  4.52695674113,    36949.23080842420}, 
    {     0.00000000027,  3.52528177609,    10770.89325626180}, 
    {     0.00000000026,  1.48499438453,    11080.17157891760}, 
    {     0.00000000035,  2.82154380962,    19402.79695281660}, 
    {     0.00000000025,  2.46339998836,     6279.48542133960}, 
    {     0.00000000026,  4.97688894643,    16737.57723659660}, 
    {     0.00000000027,  0.40827112500,    12964.30070339100}, 
    {     0.00000000029,  4.15148654061,    45892.73043315699}, 
    {     0.00000000026,  4.56404104286,    17796.95916678580}, 
    {     0.00000000025,  2.89309528854,     6286.66627864320}, 
    {     0.00000000026,  4.82914580957,     1066.49547719000}, 
    {     0.00000000031,  3.93096113738,    29864.33402730900}, 
    {     0.00000000024,  6.14987193584,    18606.49894600020}, 
    {     0.00000000024,  3.74225964547,    29026.48522950779}, 
    {     0.00000000025,  5.70460621565,    27707.54249429480}, 
    {     0.00000000025,  5.33928840652,    15141.39079431200}, 
    {     0.00000000023,  2.37624087345,    17996.03116822220}, 
    {     0.00000000026,  1.34231351782,    18875.52586977400}, 
    {     0.00000000022,  5.50791626120,     6245.04817735560}, 
    {     0.00000000024,  1.33998410121,    19800.94595622480}, 
    {     0.00000000023,  0.22512280890,     6279.78949257360}, 
    {     0.00000000022,  1.17576471775,    11925.27409260060}, 
    {     0.00000000022,  3.58603606640,     6915.85958930460}, 
    {     0.00000000023,  3.21621246666,     6286.36220740920}, 
    {     0.00000000029,  2.09564449439,    15265.88651930040}, 
    {     0.00000000022,  4.74660932338,    28230.18722269139}, 
    {     0.00000000021,  2.30688751432,     5999.21653112620}, 
    {     0.00000000028,  3.92087592807,    18208.34994259200}, 
    {     0.00000000021,  3.22643339385,    25934.12433108940}, 
    {     0.00000000021,  3.04956726238,     6566.93516885660}, 
    {     0.00000000027,  5.35645770522,    33794.54372352860}, 
    {     0.00000000025,  5.91542362188,     6489.26139842860}, 
    {     0.00000000020,  1.52296293311,      135.06508003540}, 
    {     0.00000000019,  1.78134428631,   156137.47598479928}, 
    {     0.00000000019,  0.34388684087,     5327.47610838280}, 
    {     0.00000000026,  3.41701003233,    25287.72379939980}, 
    {     0.00000000019,  2.86664271911,    18422.62935909819}, 
    {     0.00000000019,  4.71432851499,    77690.75950573849}, 
    {     0.00000000019,  2.54227398241,    77736.78343050249}, 
    {     0.00000000020,  5.91915117116,    48739.85989708300}, 
};


static const struct ln_vsop ALIGN32 earth_radius_r2[RADIUS_R2] = {
    {     0.00004359385,  5.78455133808,     6283.07584999140}, 
    {     0.00000123633,  5.57935427994,    12566.15169998280}, 
    {     0.00000012342,  3.14159265359,        0.00000000000}, 
    {     0.00000008792,  3.62777893099,    77713.77146812050}, 
    {     0.00000005689,  1.86958905084,     5573.14280143310}, 
    {     0.00000003302,  5.47034879713,    18849.22754997420}, 
    {     0.00000001471,  4.47964125007,     5507.55323866740}, 
    {     0.00000001013,  2.81323115556,     5223.69391980220}, 
    {     0.00000000854,  3.10776566900,     1577.34354244780}, 
    {     0.00000001102,  2.84173992403,   161000.68573767410}, 
    {     0.00000000648,  5.47348203398,      775.52261132400}, 
    {     0.00000000608,  1.37894173533,     6438.49624942560}, 
    {     0.00000000499,  4.41649242250,     6286.59896834040}, 
    {     0.00000000416,  0.90332697974,    10977.07880469900}, 
    {     0.00000000404,  3.20567269530,     5088.62883976680}, 
    {     0.00000000351,  1.81081728907,     5486.77784317500}, 
    {     0.00000000466,  3.65086758149,     7084.89678111520}, 
    {     0.00000000458,  5.38585314743,   149854.40013480789}, 
    {     0.00000000304,  3.51015066341,      796.29800681640}, 
    {     0.00000000266,  6.17413982699,     6836.64525283380}, 
    {     0.00000000281,  1.83874672540,     4694.00295470760}, 
    {     0.00000000262,  1.41420110644,     2146.16541647520}, 
    {     0.00000000264,  3.14103683911,    71430.69561812909}, 
    {     0.00000000319,  5.35037932146,     3154.68708489560}, 
    {     0.00000000238,  2.17695432424,      155.42039943420}, 
    {     0.00000000229,  4.75969588070,     7234.79425624200}, 
    {     0.00000000291,  4.61776401638,     4690.47983635860}, 
    {     0.00000000211,  0.21864885298,     4705.73230754360}, 
    {     0.00000000204,  4.22895113488,     1349.86740965880}, 
    {     0.00000000195,  4.58550676556,      529.69096509460}, 
    {     0.00000000255,  2.81442711144,     1748.01641306700}, 
    {     0.00000000182,  5.70454011389,     6040.34724601740}, 
    {     0.00000000180,  6.02147727878,     4292.33083295040}, 
    {     0.00000000186,  1.58690991244,     6309.37416979120}, 
    {     0.00000000167,  2.88802733052,     9437.76293488700}, 
    {     0.00000000166,  1.99990574734,     8031.09226305840}, 
    {     0.00000000160,  0.04412738495,     2544.31441988340}, 
    {     0.00000000197,  2.01089431842,     1194.44701022460}, 
    {     0.00000000165,  5.78372596774,    83996.84731811189}, 
    {     0.00000000214,  3.38300910371,     7632.94325965020}, 
    {     0.00000000140,  0.36669664351,    10447.38783960440}, 
    {     0.00000000151,  0.95519595275,     6127.65545055720}, 
    {     0.00000000136,  1.48417295645,     2352.86615377180}, 
    {     0.00000000128,  5.48057748834,      951.71840625060}, 
    {     0.00000000126,  5.26866506592,     6279.55273164240}, 
    {     0.00000000127,  3.77552907014,     6812.76681508600}, 
    {     0.00000000103,  4.95897533789,      398.14900340820}, 
    {     0.00000000104,  0.70183576826,     1592.59601363280}, 
    {     0.00000000101,  1.14481598642,     3894.18182954220}, 
    {     0.00000000131,  0.76624310306,      553.56940284240}, 
    {     0.00000000109,  5.41063597567,     6256.77753019160}, 
    {     0.00000000078,  5.84775340741,      242.72860397400}, 
    {     0.00000000097,  1.94685257714,    11856.21865142450}, 
    {     0.00000000100,  5.19725292131,   244287.60000722769}, 
    {     0.00000000076,  0.70480774041,     8429.24126646660}, 
    {     0.00000000080,  6.18430772683,     1059.38193018920}, 
    {     0.00000000068,  5.29561709093,    14143.49524243060}, 
    {     0.00000000085,  5.39487308005,    25132.30339996560}, 
    {     0.00000000055,  5.16874637579,     7058.59846131540}, 
    {     0.00000000063,  0.48494730699,      801.82093112380}, 
    {     0.00000000058,  4.07254840265,    13367.97263110660}, 
    {     0.00000000051,  3.89696552232,    12036.46073488820}, 
    {     0.00000000051,  5.56335232286,     1990.74501704100}, 
    {     0.00000000060,  2.25046596710,     8635.94200376320}, 
    {     0.00000000049,  5.58163417371,     6290.18939699220}, 
    {     0.00000000051,  3.87240194908,       26.29831979980}, 
    {     0.00000000051,  4.19300909995,     7860.41939243920}, 
    {     0.00000000041,  3.97169191582,    10973.55568635000}, 
    {     0.00000000041,  3.57080919230,     7079.37385680780}, 
    {     0.00000000056,  2.76959005761,    90955.55169449610}, 
    {     0.00000000042,  1.91461189163,     7477.52286021600}, 
    {     0.00000000042,  0.42775891995,    10213.28554621100}, 
    {     0.00000000042,  1.06925480488,      709.93304855830}, 
    {     0.00000000038,  6.17935925345,     9917.69687450980}, 
    {     0.00000000050,  0.81691517401,    11506.76976979360}, 
    {     0.00000000053,  1.45828359397,   233141.31440436149}, 
    {     0.00000000038,  3.32444534628,     5643.17856367740}, 
    {     0.00000000047,  6.21543665927,     6681.22485339960}, 
    {     0.00000000037,  0.36359309980,    10177.25767953360}, 
    {     0.00000000045,  5.29587706357,    10575.40668294180}, 
    {     0.00000000034,  5.63446915337,     6525.80445396540}, 
    {     0.00000000034,  5.36385158519,     4933.20844033260}, 
    {     0.00000000035,  5.36152295839,    25158.60171976540}, 
    {     0.00000000042,  5.08837645072,    11015.10647733480}, 
    {     0.00000000042,  4.22496037505,    88860.05707098669}, 
    {     0.00000000039,  1.99171699618,     6284.05617105960}, 
    {     0.00000000029,  3.19088628170,    11926.25441366880}, 
    {     0.00000000029,  0.14996158324,    12168.00269657460}, 
    {     0.00000000030,  1.58346276808,     9779.10867612540}, 
    {     0.00000000026,  4.16210340581,    12569.67481833180}, 
    {     0.00000000036,  2.74684637873,     3738.76143010800}, 
    {     0.00000000026,  0.72824915320,     1589.07289528380}, 
    {     0.00000000031,  5.34906371821,   143571.32428481648}, 
    {     0.00000000025,  0.10240267494,    22483.84857449259}, 
    {     0.00000000030,  3.47110495524,    14945.31617355440}, 
    {     0.00000000026,  3.89359701125,     5753.38488489680}, 
    {     0.00000000024,  1.18744224678,     4535.05943692440}, 
    {     0.00000000033,  2.99317143244,     3930.20969621960}, 
    {     0.00000000024,  1.57253767584,     6496.37494542940}, 
    {     0.00000000024,  3.47434797542,     4136.91043351620}, 
    {     0.00000000022,  3.91230073719,     6275.96230299060}, 
    {     0.00000000025,  4.02978941287,     3128.38876509580}, 
    {     0.00000000023,  1.07724492065,    12721.57209941700}, 
    {     0.00000000021,  1.89591807148,    16730.46368959580}, 
    {     0.00000000025,  2.42198937013,     5729.50644714900}, 
    {     0.00000000020,  1.78163489101,    17789.84561978500}, 
    {     0.00000000021,  0.49258939822,    29088.81141598500}, 
    {     0.00000000026,  4.14947806747,     2388.89402044920}, 
    {     0.00000000027,  2.54785812264,     3496.03282613400}, 
    {     0.00000000020,  4.29944129273,    16858.48253293320}, 
    {     0.00000000021,  5.97796936723,        7.11354700080}, 
    {     0.00000000019,  0.80292033311,    16062.18452611680}, 
    {     0.00000000024,  4.89894141052,    17260.15465469040}, 
    {     0.00000000025,  1.37003752175,     6282.09552892320}, 
    {     0.00000000022,  4.92663152168,    18875.52586977400}, 
    {     0.00000000023,  5.68902059771,    16460.33352952499}, 
    {     0.00000000023,  3.03021283729,    66567.48586525429}, 
    {     0.00000000016,  3.89713736666,     5331.35744374080}, 
    {     0.00000000016,  5.68562539832,    12559.03815298200}, 
    {     0.00000000016,  3.95085099736,     3097.88382272579}, 
    {     0.00000000016,  3.99041783945,     6283.14316029419}, 
    {     0.00000000020,  6.10643919100,   167283.76158766549}, 
    {     0.00000000015,  4.09775914607,    11712.95531823080}, 
    {     0.00000000016,  5.71769940700,    17298.18232732620}, 
    {     0.00000000016,  3.28894009404,     5884.92684658320}, 
    {     0.00000000015,  4.42564243680,    13517.87010623340}, 
    {     0.00000000016,  4.43452080930,     6283.00853968860}, 
    {     0.00000000014,  1.44384279999,     4164.31198961300}, 
    {     0.00000000014,  4.47380919159,    11790.62908865880}, 
    {     0.00000000014,  4.77646531825,     7342.45778018060}, 
    {     0.00000000011,  2.56768522896,     5481.25491886760}, 
    {     0.00000000011,  1.51443332200,    16200.77272450120}, 
    {     0.00000000011,  0.88708889185,    21228.39202354580}, 
    {     0.00000000014,  4.50116508534,      640.87760738220}, 
};


static const struct ln_vsop ALIGN32 earth_radius_r3[RADIUS_R3] = {
    {     0.00000144595,  4.27319433901,     6283.07584999140}, 
    {     0.00000006729,  3.91706261708,    12566.15169998280}, 
    {     0.00000000774,  0.00000000000,        0.00000000000}, 
    {     0.00000000247,  3.73021571217,    18849.22754997420}, 
    {     0.00000000036,  2.80081409050,     6286.59896834040}, 
    {     0.00000000033,  5.62990083112,     6127.65545055720}, 
    {     0.00000000018,  3.72826142555,     6438.49624942560}, 
    {     0.00000000016,  4.26011484232,     6525.80445396540}, 
    {     0.00000000014,  3.47817116396,     6256.77753019160}, 
    {     0.00000000012,  3.55747379482,    25132.30339996560}, 
    {     0.00000000010,  4.43995693209,     4705.73230754360}, 
    {     0.00000000010,  4.28045255470,    83996.84731811189}, 
    {     0.00000000009,  5.36457057335,     6040.34724601740}, 
    {     0.00000000008,  1.78458957263,     5507.55323866740}, 
    {     0.00000000009,  0.47275199930,     6279.55273164240}, 
    {     0.00000000009,  1.34741231639,     6309.37416979120}, 
    {     0.00000000009,  0.77092900708,     5729.50644714900}, 
    {     0.00000000007,  3.50146897332,     7058.59846131540}, 
    {     0.00000000005,  2.89071061700,      775.52261132400}, 
    {     0.00000000006,  2.36514111314,     6836.64525283380}, 
};


static const struct ln_vsop ALIGN32 earth_radius_r4[RADIUS_R4] = {
    {     0.00000003858,  2.56389016346,     6283.07584999140}, 
    {     0.00000000306,  2.26911740541,    12566.15169998280}, 
    {     0.00000000053,  3.44031471924,     5573.14280143310}, 
    {     0.00000000015,  2.03136359366,    18849.22754997420}, 
    {     0.00000000013,  2.05688873673,    77713.77146812050}, 
    {     0.00000000007,  4.41218854480,   161000.68573767410}, 
    {     0.00000000004,  5.33854414781,     6438.49624942560}, 
    {     0.00000000006,  3.81514213664,   149854.40013480789}, 
    {     0.00000000004,  4.26602478239,     6127.65545055720}, 
};


static const struct ln_vsop ALIGN32 earth_radius_r5[RADIUS_R5] = {
    {     0.00000000086,  1.21805304895,     6283.07584999140}, 
    {     0.00000000012,  0.65572878044,    12566.15169998280}, 
};

/*! \fn void ln_get_earth_helio_coords(double JD, struct ln_helio_posn *position)
* \param JD Julian day
* \param position Pointer to store heliocentric position
*
* Calculate Earths heliocentric (referred to the centre of the Sun) coordinates 
* for given julian day.
* Longitude and Latitude are in degrees, whilst radius vector is in AU.
*/ 
/* Chapter 31 Pg 206-207 Equ 31.1 31.2 , 31.3 using VSOP 87 
*/
void ln_get_earth_helio_coords(double JD, struct ln_helio_posn *position)
{
	double t, t2, t3, t4, t5;
	double L0, L1, L2, L3, L4, L5;
	double B0, B1, B2, B3, B4, B5;
	double R0, R1, R2, R3, R4, R5;
           	
	/* check cache first */
	if (JD == cJD) {
		/* cache hit */
		position->L = cL;
		position->B = cB;
		position->R = cR;
		return;
	}
	
	/* get julian ephemeris day */
	t =(JD - 2451545.0) / 365250.0;
	t2 = t * t;
	t3 = t2 * t;
	t4 = t3 * t;
	t5 = t4 * t;
	
	/* calc L series */
	L0 = ln_calc_series(earth_longitude_l0, LONG_L0, t);
	L1 = ln_calc_series(earth_longitude_l1, LONG_L1, t);
	L2 = ln_calc_series(earth_longitude_l2, LONG_L2, t);
	L3 = ln_calc_series(earth_longitude_l3, LONG_L3, t);
	L4 = ln_calc_series(earth_longitude_l4, LONG_L4, t);
	L5 = ln_calc_series(earth_longitude_l5, LONG_L5, t);
	position->L = (L0 + L1 * t + L2 * t2 + L3 * t3 + L4 * t4 + L5 * t5);

	/* calc B series */
	B0 = ln_calc_series(earth_latitude_b0, LAT_B0, t);
	B1 = ln_calc_series(earth_latitude_b1, LAT_B1, t);
	B2 = ln_calc_series(earth_latitude_b2, LAT_B2, t);
	B3 = ln_calc_series(earth_latitude_b3, LAT_B3, t);
	B4 = ln_calc_series(earth_latitude_b4, LAT_B4, t);
	B5 = ln_calc_series(earth_latitude_b5, LAT_B5, t);
	position->B = (B0 + B1 * t + B2 * t2 + B3 * t3 + B4 * t4 + B5 * t5);


	/* calc R series */
	R0 = ln_calc_series(earth_radius_r0, RADIUS_R0, t);
	R1 = ln_calc_series(earth_radius_r1, RADIUS_R1, t);
	R2 = ln_calc_series(earth_radius_r2, RADIUS_R2, t);
	R3 = ln_calc_series(earth_radius_r3, RADIUS_R3, t);
	R4 = ln_calc_series(earth_radius_r4, RADIUS_R4, t);
	R5 = ln_calc_series(earth_radius_r5, RADIUS_R5, t);
	position->R = (R0 + R1 * t + R2 * t2 + R3 * t3 + R4 * t4 + R5 * t5);
	
	/* change to degrees in correct quadrant */
	position->L = ln_rad_to_deg(position->L);
	position->B = ln_rad_to_deg(position->B);
	position->L = ln_range_degrees(position->L);
	
	/* change to fk5 reference frame */
	ln_vsop87_to_fk5(position, JD);

	/* save cache */
	cJD = JD;
	cL = position->L;
	cB = position->B;
	cR = position->R;
}
	
/*! \fn double ln_get_earth_solar_dist(double JD);
* \param JD Julian day.
* \return Distance in AU
*
* Calculates the distance in AU between the Sun and Earth for 
* the given julian day.
*/ 
double ln_get_earth_solar_dist(double JD)
{
	struct ln_helio_posn h_earth;
	
	/* get heliocentric position */
	ln_get_earth_helio_coords(JD, &h_earth);

	return h_earth.R;
}
	
/*! \fn void ln_get_earth_centre_dist (float height, double latitude, double *p_sin_o, double *p_cos_o);
* \param height Height above sea level in metres.
* \param latitude latitude in degrees.
* \param p_sin_o Pointer to hold p_sin_o
* \param p_cos_o Pointer to hold p_cos_o
* 
* Calculate the quantities "p sin o" and "p cos o" needed in calculations for
* diurnal parallaxes, eclipses and occultations given the observers height
* in metres above sea level and there latitude in degrees.
*/

void ln_get_earth_centre_dist (float height, double latitude, double *p_sin_o,
	double *p_cos_o)
{
     double a,b,f,u;

     double lat_rad = ln_deg_to_rad(latitude);
     
     a = 6378.14;
     f = 1.0 / 298.257;
     b = a * (1.0 - f);
     
     u = atan2(b, a * tan(lat_rad));
     *p_sin_o = b / a * sin(u) + (height / 6378140.0) * sin(lat_rad);
     *p_cos_o = cos(u) + (height / 6378140.0) * cos(lat_rad);
}
     
/*! \fn void ln_get_earth_rect_helio(double JD, struct ln_rect_posn *position)
* \param JD Julian day.
* \param position pointer to return position
*
* Calculate the Earths rectangular heliocentric coordinates for the
* given Julian day. Coordinates are in AU.
*/
void ln_get_earth_rect_helio(double JD, struct ln_rect_posn *position)
{
	struct ln_helio_posn earth;
		
	ln_get_earth_helio_coords(JD, &earth);
	ln_get_rect_from_helio(&earth, position);
}
