/* automatically generated by rust-bindgen 0.72.0 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    fn extract_bit(byte: u8, index: usize) -> bool {
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        Self::extract_bit(byte, index)
    }
    #[inline]
    pub unsafe fn raw_get_bit(this: *const Self, index: usize) -> bool {
        debug_assert!(index / 8 < core::mem::size_of::<Storage>());
        let byte_index = index / 8;
        let byte = unsafe {
            *(core::ptr::addr_of!((*this).storage) as *const u8).offset(byte_index as isize)
        };
        Self::extract_bit(byte, index)
    }
    #[inline]
    fn change_bit(byte: u8, index: usize, val: bool) -> u8 {
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val { byte | mask } else { byte & !mask }
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        *byte = Self::change_bit(*byte, index, val);
    }
    #[inline]
    pub unsafe fn raw_set_bit(this: *mut Self, index: usize, val: bool) {
        debug_assert!(index / 8 < core::mem::size_of::<Storage>());
        let byte_index = index / 8;
        let byte = unsafe {
            (core::ptr::addr_of_mut!((*this).storage) as *mut u8).offset(byte_index as isize)
        };
        unsafe { *byte = Self::change_bit(*byte, index, val) };
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub unsafe fn raw_get(this: *const Self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < core::mem::size_of::<Storage>());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= core::mem::size_of::<Storage>());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if unsafe { Self::raw_get_bit(this, i + bit_offset) } {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
    #[inline]
    pub unsafe fn raw_set(this: *mut Self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < core::mem::size_of::<Storage>());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= core::mem::size_of::<Storage>());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            unsafe { Self::raw_set_bit(this, index + bit_offset, val_bit_is_set) };
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::core::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::core::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        unsafe { ::core::slice::from_raw_parts(self.as_ptr(), len) }
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        unsafe { ::core::slice::from_raw_parts_mut(self.as_mut_ptr(), len) }
    }
}
impl<T> ::core::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
pub const _SYS_TYPES_H: u32 = 1;
pub const _FEATURES_H: u32 = 1;
pub const _DEFAULT_SOURCE: u32 = 1;
pub const __GLIBC_USE_ISOC2Y: u32 = 0;
pub const __GLIBC_USE_ISOC23: u32 = 0;
pub const __USE_ISOC11: u32 = 1;
pub const __USE_ISOC99: u32 = 1;
pub const __USE_ISOC95: u32 = 1;
pub const __USE_POSIX_IMPLICITLY: u32 = 1;
pub const _POSIX_SOURCE: u32 = 1;
pub const _POSIX_C_SOURCE: u32 = 200809;
pub const __USE_POSIX: u32 = 1;
pub const __USE_POSIX2: u32 = 1;
pub const __USE_POSIX199309: u32 = 1;
pub const __USE_POSIX199506: u32 = 1;
pub const __USE_XOPEN2K: u32 = 1;
pub const __USE_XOPEN2K8: u32 = 1;
pub const _ATFILE_SOURCE: u32 = 1;
pub const __WORDSIZE: u32 = 64;
pub const __WORDSIZE_TIME64_COMPAT32: u32 = 1;
pub const __SYSCALL_WORDSIZE: u32 = 64;
pub const __TIMESIZE: u32 = 64;
pub const __USE_TIME_BITS64: u32 = 1;
pub const __USE_MISC: u32 = 1;
pub const __USE_ATFILE: u32 = 1;
pub const __USE_FORTIFY_LEVEL: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_GETS: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_SCANF: u32 = 0;
pub const __GLIBC_USE_C23_STRTOL: u32 = 0;
pub const _STDC_PREDEF_H: u32 = 1;
pub const __STDC_IEC_559__: u32 = 1;
pub const __STDC_IEC_60559_BFP__: u32 = 201404;
pub const __STDC_IEC_559_COMPLEX__: u32 = 1;
pub const __STDC_IEC_60559_COMPLEX__: u32 = 201404;
pub const __STDC_ISO_10646__: u32 = 201706;
pub const __GNU_LIBRARY__: u32 = 6;
pub const __GLIBC__: u32 = 2;
pub const __GLIBC_MINOR__: u32 = 41;
pub const _SYS_CDEFS_H: u32 = 1;
pub const __glibc_c99_flexarr_available: u32 = 1;
pub const __LDOUBLE_REDIRECTS_TO_FLOAT128_ABI: u32 = 0;
pub const __HAVE_GENERIC_SELECTION: u32 = 1;
pub const _BITS_TYPES_H: u32 = 1;
pub const _BITS_TYPESIZES_H: u32 = 1;
pub const __OFF_T_MATCHES_OFF64_T: u32 = 1;
pub const __INO_T_MATCHES_INO64_T: u32 = 1;
pub const __RLIM_T_MATCHES_RLIM64_T: u32 = 1;
pub const __STATFS_MATCHES_STATFS64: u32 = 1;
pub const __KERNEL_OLD_TIMEVAL_MATCHES_TIMEVAL64: u32 = 1;
pub const __FD_SETSIZE: u32 = 1024;
pub const _BITS_TIME64_H: u32 = 1;
pub const __clock_t_defined: u32 = 1;
pub const __clockid_t_defined: u32 = 1;
pub const __time_t_defined: u32 = 1;
pub const __timer_t_defined: u32 = 1;
pub const _BITS_STDINT_INTN_H: u32 = 1;
pub const __BIT_TYPES_DEFINED__: u32 = 1;
pub const _ENDIAN_H: u32 = 1;
pub const _BITS_ENDIAN_H: u32 = 1;
pub const __LITTLE_ENDIAN: u32 = 1234;
pub const __BIG_ENDIAN: u32 = 4321;
pub const __PDP_ENDIAN: u32 = 3412;
pub const _BITS_ENDIANNESS_H: u32 = 1;
pub const __BYTE_ORDER: u32 = 1234;
pub const __FLOAT_WORD_ORDER: u32 = 1234;
pub const LITTLE_ENDIAN: u32 = 1234;
pub const BIG_ENDIAN: u32 = 4321;
pub const PDP_ENDIAN: u32 = 3412;
pub const BYTE_ORDER: u32 = 1234;
pub const _BITS_BYTESWAP_H: u32 = 1;
pub const _BITS_UINTN_IDENTITY_H: u32 = 1;
pub const _SYS_SELECT_H: u32 = 1;
pub const __sigset_t_defined: u32 = 1;
pub const __timeval_defined: u32 = 1;
pub const _STRUCT_TIMESPEC: u32 = 1;
pub const FD_SETSIZE: u32 = 1024;
pub const _BITS_PTHREADTYPES_COMMON_H: u32 = 1;
pub const _THREAD_SHARED_TYPES_H: u32 = 1;
pub const _BITS_PTHREADTYPES_ARCH_H: u32 = 1;
pub const __SIZEOF_PTHREAD_MUTEX_T: u32 = 40;
pub const __SIZEOF_PTHREAD_ATTR_T: u32 = 56;
pub const __SIZEOF_PTHREAD_RWLOCK_T: u32 = 56;
pub const __SIZEOF_PTHREAD_BARRIER_T: u32 = 32;
pub const __SIZEOF_PTHREAD_MUTEXATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_COND_T: u32 = 48;
pub const __SIZEOF_PTHREAD_CONDATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_RWLOCKATTR_T: u32 = 8;
pub const __SIZEOF_PTHREAD_BARRIERATTR_T: u32 = 4;
pub const _THREAD_MUTEX_INTERNAL_H: u32 = 1;
pub const __PTHREAD_MUTEX_HAVE_PREV: u32 = 1;
pub const __have_pthread_attr_t: u32 = 1;
pub const _STDINT_H: u32 = 1;
pub const __GLIBC_USE_LIB_EXT2: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT_C23: u32 = 0;
pub const __GLIBC_USE_IEC_60559_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT_C23: u32 = 0;
pub const __GLIBC_USE_IEC_60559_TYPES_EXT: u32 = 0;
pub const _BITS_WCHAR_H: u32 = 1;
pub const _BITS_STDINT_UINTN_H: u32 = 1;
pub const _BITS_STDINT_LEAST_H: u32 = 1;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i64 = -9223372036854775808;
pub const INT_FAST32_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u64 = 9223372036854775807;
pub const INT_FAST32_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: i32 = -1;
pub const UINT_FAST32_MAX: i32 = -1;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const UINTPTR_MAX: i32 = -1;
pub const PTRDIFF_MIN: i64 = -9223372036854775808;
pub const PTRDIFF_MAX: u64 = 9223372036854775807;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const SIZE_MAX: i32 = -1;
pub const WINT_MIN: u32 = 0;
pub const WINT_MAX: u32 = 4294967295;
pub const __BITS_PER_LONG: u32 = 64;
pub const __BITS_PER_LONG_LONG: u32 = 64;
pub const _IOC_NRBITS: u32 = 8;
pub const _IOC_TYPEBITS: u32 = 8;
pub const _IOC_SIZEBITS: u32 = 14;
pub const _IOC_DIRBITS: u32 = 2;
pub const _IOC_NRMASK: u32 = 255;
pub const _IOC_TYPEMASK: u32 = 255;
pub const _IOC_SIZEMASK: u32 = 16383;
pub const _IOC_DIRMASK: u32 = 3;
pub const _IOC_NRSHIFT: u32 = 0;
pub const _IOC_TYPESHIFT: u32 = 8;
pub const _IOC_SIZESHIFT: u32 = 16;
pub const _IOC_DIRSHIFT: u32 = 30;
pub const _IOC_NONE: u32 = 0;
pub const _IOC_WRITE: u32 = 1;
pub const _IOC_READ: u32 = 2;
pub const IOC_IN: u32 = 1073741824;
pub const IOC_OUT: u32 = 2147483648;
pub const IOC_INOUT: u32 = 3221225472;
pub const IOCSIZE_MASK: u32 = 1073676288;
pub const IOCSIZE_SHIFT: u32 = 16;
pub const DRM_NAME: &[u8; 4] = b"drm\0";
pub const DRM_MIN_ORDER: u32 = 5;
pub const DRM_MAX_ORDER: u32 = 22;
pub const DRM_RAM_PERCENT: u32 = 10;
pub const _DRM_LOCK_HELD: u32 = 2147483648;
pub const _DRM_LOCK_CONT: u32 = 1073741824;
pub const _DRM_VBLANK_HIGH_CRTC_SHIFT: u32 = 1;
pub const _DRM_PRE_MODESET: u32 = 1;
pub const _DRM_POST_MODESET: u32 = 2;
pub const DRM_CAP_DUMB_BUFFER: u32 = 1;
pub const DRM_CAP_VBLANK_HIGH_CRTC: u32 = 2;
pub const DRM_CAP_DUMB_PREFERRED_DEPTH: u32 = 3;
pub const DRM_CAP_DUMB_PREFER_SHADOW: u32 = 4;
pub const DRM_CAP_PRIME: u32 = 5;
pub const DRM_PRIME_CAP_IMPORT: u32 = 1;
pub const DRM_PRIME_CAP_EXPORT: u32 = 2;
pub const DRM_CAP_TIMESTAMP_MONOTONIC: u32 = 6;
pub const DRM_CAP_ASYNC_PAGE_FLIP: u32 = 7;
pub const DRM_CAP_CURSOR_WIDTH: u32 = 8;
pub const DRM_CAP_CURSOR_HEIGHT: u32 = 9;
pub const DRM_CAP_ADDFB2_MODIFIERS: u32 = 16;
pub const DRM_CAP_PAGE_FLIP_TARGET: u32 = 17;
pub const DRM_CAP_CRTC_IN_VBLANK_EVENT: u32 = 18;
pub const DRM_CAP_SYNCOBJ: u32 = 19;
pub const DRM_CAP_SYNCOBJ_TIMELINE: u32 = 20;
pub const DRM_CAP_ATOMIC_ASYNC_PAGE_FLIP: u32 = 21;
pub const DRM_CLIENT_CAP_STEREO_3D: u32 = 1;
pub const DRM_CLIENT_CAP_UNIVERSAL_PLANES: u32 = 2;
pub const DRM_CLIENT_CAP_ATOMIC: u32 = 3;
pub const DRM_CLIENT_CAP_ASPECT_RATIO: u32 = 4;
pub const DRM_CLIENT_CAP_WRITEBACK_CONNECTORS: u32 = 5;
pub const DRM_CLIENT_CAP_CURSOR_PLANE_HOTSPOT: u32 = 6;
pub const DRM_SYNCOBJ_CREATE_SIGNALED: u32 = 1;
pub const DRM_SYNCOBJ_FD_TO_HANDLE_FLAGS_IMPORT_SYNC_FILE: u32 = 1;
pub const DRM_SYNCOBJ_HANDLE_TO_FD_FLAGS_EXPORT_SYNC_FILE: u32 = 1;
pub const DRM_SYNCOBJ_WAIT_FLAGS_WAIT_ALL: u32 = 1;
pub const DRM_SYNCOBJ_WAIT_FLAGS_WAIT_FOR_SUBMIT: u32 = 2;
pub const DRM_SYNCOBJ_WAIT_FLAGS_WAIT_AVAILABLE: u32 = 4;
pub const DRM_SYNCOBJ_WAIT_FLAGS_WAIT_DEADLINE: u32 = 8;
pub const DRM_SYNCOBJ_QUERY_FLAGS_LAST_SUBMITTED: u32 = 1;
pub const DRM_CRTC_SEQUENCE_RELATIVE: u32 = 1;
pub const DRM_CRTC_SEQUENCE_NEXT_ON_MISS: u32 = 2;
pub const DRM_CONNECTOR_NAME_LEN: u32 = 32;
pub const DRM_DISPLAY_MODE_LEN: u32 = 32;
pub const DRM_PROP_NAME_LEN: u32 = 32;
pub const DRM_MODE_TYPE_BUILTIN: u32 = 1;
pub const DRM_MODE_TYPE_CLOCK_C: u32 = 3;
pub const DRM_MODE_TYPE_CRTC_C: u32 = 5;
pub const DRM_MODE_TYPE_PREFERRED: u32 = 8;
pub const DRM_MODE_TYPE_DEFAULT: u32 = 16;
pub const DRM_MODE_TYPE_USERDEF: u32 = 32;
pub const DRM_MODE_TYPE_DRIVER: u32 = 64;
pub const DRM_MODE_TYPE_ALL: u32 = 104;
pub const DRM_MODE_FLAG_PHSYNC: u32 = 1;
pub const DRM_MODE_FLAG_NHSYNC: u32 = 2;
pub const DRM_MODE_FLAG_PVSYNC: u32 = 4;
pub const DRM_MODE_FLAG_NVSYNC: u32 = 8;
pub const DRM_MODE_FLAG_INTERLACE: u32 = 16;
pub const DRM_MODE_FLAG_DBLSCAN: u32 = 32;
pub const DRM_MODE_FLAG_CSYNC: u32 = 64;
pub const DRM_MODE_FLAG_PCSYNC: u32 = 128;
pub const DRM_MODE_FLAG_NCSYNC: u32 = 256;
pub const DRM_MODE_FLAG_HSKEW: u32 = 512;
pub const DRM_MODE_FLAG_BCAST: u32 = 1024;
pub const DRM_MODE_FLAG_PIXMUX: u32 = 2048;
pub const DRM_MODE_FLAG_DBLCLK: u32 = 4096;
pub const DRM_MODE_FLAG_CLKDIV2: u32 = 8192;
pub const DRM_MODE_FLAG_3D_MASK: u32 = 507904;
pub const DRM_MODE_FLAG_3D_NONE: u32 = 0;
pub const DRM_MODE_FLAG_3D_FRAME_PACKING: u32 = 16384;
pub const DRM_MODE_FLAG_3D_FIELD_ALTERNATIVE: u32 = 32768;
pub const DRM_MODE_FLAG_3D_LINE_ALTERNATIVE: u32 = 49152;
pub const DRM_MODE_FLAG_3D_SIDE_BY_SIDE_FULL: u32 = 65536;
pub const DRM_MODE_FLAG_3D_L_DEPTH: u32 = 81920;
pub const DRM_MODE_FLAG_3D_L_DEPTH_GFX_GFX_DEPTH: u32 = 98304;
pub const DRM_MODE_FLAG_3D_TOP_AND_BOTTOM: u32 = 114688;
pub const DRM_MODE_FLAG_3D_SIDE_BY_SIDE_HALF: u32 = 131072;
pub const DRM_MODE_PICTURE_ASPECT_NONE: u32 = 0;
pub const DRM_MODE_PICTURE_ASPECT_4_3: u32 = 1;
pub const DRM_MODE_PICTURE_ASPECT_16_9: u32 = 2;
pub const DRM_MODE_PICTURE_ASPECT_64_27: u32 = 3;
pub const DRM_MODE_PICTURE_ASPECT_256_135: u32 = 4;
pub const DRM_MODE_CONTENT_TYPE_NO_DATA: u32 = 0;
pub const DRM_MODE_CONTENT_TYPE_GRAPHICS: u32 = 1;
pub const DRM_MODE_CONTENT_TYPE_PHOTO: u32 = 2;
pub const DRM_MODE_CONTENT_TYPE_CINEMA: u32 = 3;
pub const DRM_MODE_CONTENT_TYPE_GAME: u32 = 4;
pub const DRM_MODE_FLAG_PIC_AR_MASK: u32 = 7864320;
pub const DRM_MODE_FLAG_PIC_AR_NONE: u32 = 0;
pub const DRM_MODE_FLAG_PIC_AR_4_3: u32 = 524288;
pub const DRM_MODE_FLAG_PIC_AR_16_9: u32 = 1048576;
pub const DRM_MODE_FLAG_PIC_AR_64_27: u32 = 1572864;
pub const DRM_MODE_FLAG_PIC_AR_256_135: u32 = 2097152;
pub const DRM_MODE_FLAG_ALL: u32 = 521215;
pub const DRM_MODE_DPMS_ON: u32 = 0;
pub const DRM_MODE_DPMS_STANDBY: u32 = 1;
pub const DRM_MODE_DPMS_SUSPEND: u32 = 2;
pub const DRM_MODE_DPMS_OFF: u32 = 3;
pub const DRM_MODE_SCALE_NONE: u32 = 0;
pub const DRM_MODE_SCALE_FULLSCREEN: u32 = 1;
pub const DRM_MODE_SCALE_CENTER: u32 = 2;
pub const DRM_MODE_SCALE_ASPECT: u32 = 3;
pub const DRM_MODE_DITHERING_OFF: u32 = 0;
pub const DRM_MODE_DITHERING_ON: u32 = 1;
pub const DRM_MODE_DITHERING_AUTO: u32 = 2;
pub const DRM_MODE_DIRTY_OFF: u32 = 0;
pub const DRM_MODE_DIRTY_ON: u32 = 1;
pub const DRM_MODE_DIRTY_ANNOTATE: u32 = 2;
pub const DRM_MODE_LINK_STATUS_GOOD: u32 = 0;
pub const DRM_MODE_LINK_STATUS_BAD: u32 = 1;
pub const DRM_MODE_ROTATE_0: u32 = 1;
pub const DRM_MODE_ROTATE_90: u32 = 2;
pub const DRM_MODE_ROTATE_180: u32 = 4;
pub const DRM_MODE_ROTATE_270: u32 = 8;
pub const DRM_MODE_ROTATE_MASK: u32 = 15;
pub const DRM_MODE_REFLECT_X: u32 = 16;
pub const DRM_MODE_REFLECT_Y: u32 = 32;
pub const DRM_MODE_REFLECT_MASK: u32 = 48;
pub const DRM_MODE_CONTENT_PROTECTION_UNDESIRED: u32 = 0;
pub const DRM_MODE_CONTENT_PROTECTION_DESIRED: u32 = 1;
pub const DRM_MODE_CONTENT_PROTECTION_ENABLED: u32 = 2;
pub const DRM_MODE_PRESENT_TOP_FIELD: u32 = 1;
pub const DRM_MODE_PRESENT_BOTTOM_FIELD: u32 = 2;
pub const DRM_MODE_ENCODER_NONE: u32 = 0;
pub const DRM_MODE_ENCODER_DAC: u32 = 1;
pub const DRM_MODE_ENCODER_TMDS: u32 = 2;
pub const DRM_MODE_ENCODER_LVDS: u32 = 3;
pub const DRM_MODE_ENCODER_TVDAC: u32 = 4;
pub const DRM_MODE_ENCODER_VIRTUAL: u32 = 5;
pub const DRM_MODE_ENCODER_DSI: u32 = 6;
pub const DRM_MODE_ENCODER_DPMST: u32 = 7;
pub const DRM_MODE_ENCODER_DPI: u32 = 8;
pub const DRM_MODE_CONNECTOR_Unknown: u32 = 0;
pub const DRM_MODE_CONNECTOR_VGA: u32 = 1;
pub const DRM_MODE_CONNECTOR_DVII: u32 = 2;
pub const DRM_MODE_CONNECTOR_DVID: u32 = 3;
pub const DRM_MODE_CONNECTOR_DVIA: u32 = 4;
pub const DRM_MODE_CONNECTOR_Composite: u32 = 5;
pub const DRM_MODE_CONNECTOR_SVIDEO: u32 = 6;
pub const DRM_MODE_CONNECTOR_LVDS: u32 = 7;
pub const DRM_MODE_CONNECTOR_Component: u32 = 8;
pub const DRM_MODE_CONNECTOR_9PinDIN: u32 = 9;
pub const DRM_MODE_CONNECTOR_DisplayPort: u32 = 10;
pub const DRM_MODE_CONNECTOR_HDMIA: u32 = 11;
pub const DRM_MODE_CONNECTOR_HDMIB: u32 = 12;
pub const DRM_MODE_CONNECTOR_TV: u32 = 13;
pub const DRM_MODE_CONNECTOR_eDP: u32 = 14;
pub const DRM_MODE_CONNECTOR_VIRTUAL: u32 = 15;
pub const DRM_MODE_CONNECTOR_DSI: u32 = 16;
pub const DRM_MODE_CONNECTOR_DPI: u32 = 17;
pub const DRM_MODE_CONNECTOR_WRITEBACK: u32 = 18;
pub const DRM_MODE_CONNECTOR_SPI: u32 = 19;
pub const DRM_MODE_CONNECTOR_USB: u32 = 20;
pub const DRM_MODE_PROP_PENDING: u32 = 1;
pub const DRM_MODE_PROP_RANGE: u32 = 2;
pub const DRM_MODE_PROP_IMMUTABLE: u32 = 4;
pub const DRM_MODE_PROP_ENUM: u32 = 8;
pub const DRM_MODE_PROP_BLOB: u32 = 16;
pub const DRM_MODE_PROP_BITMASK: u32 = 32;
pub const DRM_MODE_PROP_LEGACY_TYPE: u32 = 58;
pub const DRM_MODE_PROP_EXTENDED_TYPE: u32 = 65472;
pub const DRM_MODE_PROP_ATOMIC: u32 = 2147483648;
pub const DRM_MODE_OBJECT_CRTC: u32 = 3435973836;
pub const DRM_MODE_OBJECT_CONNECTOR: u32 = 3233857728;
pub const DRM_MODE_OBJECT_ENCODER: u32 = 3772834016;
pub const DRM_MODE_OBJECT_MODE: u32 = 3739147998;
pub const DRM_MODE_OBJECT_PROPERTY: u32 = 2964369584;
pub const DRM_MODE_OBJECT_FB: u32 = 4227595259;
pub const DRM_MODE_OBJECT_BLOB: u32 = 3149642683;
pub const DRM_MODE_OBJECT_PLANE: u32 = 4008636142;
pub const DRM_MODE_OBJECT_ANY: u32 = 0;
pub const DRM_MODE_FB_INTERLACED: u32 = 1;
pub const DRM_MODE_FB_MODIFIERS: u32 = 2;
pub const DRM_MODE_FB_DIRTY_ANNOTATE_COPY: u32 = 1;
pub const DRM_MODE_FB_DIRTY_ANNOTATE_FILL: u32 = 2;
pub const DRM_MODE_FB_DIRTY_FLAGS: u32 = 3;
pub const DRM_MODE_FB_DIRTY_MAX_CLIPS: u32 = 256;
pub const DRM_MODE_CURSOR_BO: u32 = 1;
pub const DRM_MODE_CURSOR_MOVE: u32 = 2;
pub const DRM_MODE_CURSOR_FLAGS: u32 = 3;
pub const DRM_MODE_PAGE_FLIP_EVENT: u32 = 1;
pub const DRM_MODE_PAGE_FLIP_ASYNC: u32 = 2;
pub const DRM_MODE_PAGE_FLIP_TARGET_ABSOLUTE: u32 = 4;
pub const DRM_MODE_PAGE_FLIP_TARGET_RELATIVE: u32 = 8;
pub const DRM_MODE_PAGE_FLIP_TARGET: u32 = 12;
pub const DRM_MODE_PAGE_FLIP_FLAGS: u32 = 15;
pub const DRM_MODE_ATOMIC_TEST_ONLY: u32 = 256;
pub const DRM_MODE_ATOMIC_NONBLOCK: u32 = 512;
pub const DRM_MODE_ATOMIC_ALLOW_MODESET: u32 = 1024;
pub const DRM_MODE_ATOMIC_FLAGS: u32 = 1795;
pub const FORMAT_BLOB_CURRENT: u32 = 1;
pub const DRM_IOCTL_BASE: u8 = 100u8;
pub const DRM_COMMAND_BASE: u32 = 64;
pub const DRM_COMMAND_END: u32 = 160;
pub const DRM_EVENT_VBLANK: u32 = 1;
pub const DRM_EVENT_FLIP_COMPLETE: u32 = 2;
pub const DRM_EVENT_CRTC_SEQUENCE: u32 = 3;
pub const DRM_MAX_MINOR: u32 = 64;
pub const DRM_IOC_VOID: u32 = 0;
pub const DRM_IOC_READ: u32 = 2;
pub const DRM_IOC_WRITE: u32 = 1;
pub const DRM_IOC_READWRITE: u32 = 3;
pub const DRM_DEV_UID: u32 = 0;
pub const DRM_DEV_GID: u32 = 0;
pub const DRM_DIR_NAME: &[u8; 9] = b"/dev/dri\0";
pub const DRM_PRIMARY_MINOR_NAME: &[u8; 5] = b"card\0";
pub const DRM_CONTROL_MINOR_NAME: &[u8; 9] = b"controlD\0";
pub const DRM_RENDER_MINOR_NAME: &[u8; 8] = b"renderD\0";
pub const DRM_PROC_NAME: &[u8; 11] = b"/proc/dri/\0";
pub const DRM_DEV_NAME: &[u8; 10] = b"%s/card%d\0";
pub const DRM_CONTROL_DEV_NAME: &[u8; 14] = b"%s/controlD%d\0";
pub const DRM_RENDER_DEV_NAME: &[u8; 13] = b"%s/renderD%d\0";
pub const DRM_ERR_NO_DEVICE: i32 = -1001;
pub const DRM_ERR_NO_ACCESS: i32 = -1002;
pub const DRM_ERR_NOT_ROOT: i32 = -1003;
pub const DRM_ERR_INVALID: i32 = -1004;
pub const DRM_ERR_NO_FD: i32 = -1005;
pub const DRM_AGP_NO_HANDLE: u32 = 0;
pub const DRM_VBLANK_HIGH_CRTC_SHIFT: u32 = 1;
pub const DRM_LOCK_HELD: u32 = 2147483648;
pub const DRM_LOCK_CONT: u32 = 1073741824;
pub const DRM_NODE_PRIMARY: u32 = 0;
pub const DRM_NODE_CONTROL: u32 = 1;
pub const DRM_NODE_RENDER: u32 = 2;
pub const DRM_NODE_MAX: u32 = 3;
pub const DRM_EVENT_CONTEXT_VERSION: u32 = 4;
pub const DRM_BUS_PCI: u32 = 0;
pub const DRM_BUS_USB: u32 = 1;
pub const DRM_BUS_PLATFORM: u32 = 2;
pub const DRM_BUS_HOST1X: u32 = 3;
pub const DRM_PLATFORM_DEVICE_NAME_LEN: u32 = 512;
pub const DRM_HOST1X_DEVICE_NAME_LEN: u32 = 512;
pub const DRM_DEVICE_GET_PCI_REVISION: u32 = 1;
pub const __bool_true_false_are_defined: u32 = 1;
pub const true_: u32 = 1;
pub const false_: u32 = 0;
pub const DRM_MODE_FEATURE_KMS: u32 = 1;
pub const DRM_MODE_FEATURE_DIRTYFB: u32 = 1;
pub const DRM_PLANE_TYPE_OVERLAY: u32 = 0;
pub const DRM_PLANE_TYPE_PRIMARY: u32 = 1;
pub const DRM_PLANE_TYPE_CURSOR: u32 = 2;
pub const AMDGPU_CS_MAX_IBS_PER_SUBMIT: u32 = 4;
pub const AMDGPU_TIMEOUT_INFINITE: i32 = -1;
pub const AMDGPU_QUERY_FENCE_TIMEOUT_IS_ABSOLUTE: u32 = 1;
pub const AMDGPU_VA_RANGE_32_BIT: u32 = 1;
pub const AMDGPU_VA_RANGE_HIGH: u32 = 2;
pub const AMDGPU_VA_RANGE_REPLAYABLE: u32 = 4;
pub const DRM_AMDGPU_GEM_CREATE: u32 = 0;
pub const DRM_AMDGPU_GEM_MMAP: u32 = 1;
pub const DRM_AMDGPU_CTX: u32 = 2;
pub const DRM_AMDGPU_BO_LIST: u32 = 3;
pub const DRM_AMDGPU_CS: u32 = 4;
pub const DRM_AMDGPU_INFO: u32 = 5;
pub const DRM_AMDGPU_GEM_METADATA: u32 = 6;
pub const DRM_AMDGPU_GEM_WAIT_IDLE: u32 = 7;
pub const DRM_AMDGPU_GEM_VA: u32 = 8;
pub const DRM_AMDGPU_WAIT_CS: u32 = 9;
pub const DRM_AMDGPU_GEM_OP: u32 = 16;
pub const DRM_AMDGPU_GEM_USERPTR: u32 = 17;
pub const DRM_AMDGPU_WAIT_FENCES: u32 = 18;
pub const DRM_AMDGPU_VM: u32 = 19;
pub const DRM_AMDGPU_FENCE_TO_HANDLE: u32 = 20;
pub const DRM_AMDGPU_SCHED: u32 = 21;
pub const AMDGPU_GEM_DOMAIN_CPU: u32 = 1;
pub const AMDGPU_GEM_DOMAIN_GTT: u32 = 2;
pub const AMDGPU_GEM_DOMAIN_VRAM: u32 = 4;
pub const AMDGPU_GEM_DOMAIN_GDS: u32 = 8;
pub const AMDGPU_GEM_DOMAIN_GWS: u32 = 16;
pub const AMDGPU_GEM_DOMAIN_OA: u32 = 32;
pub const AMDGPU_GEM_DOMAIN_DOORBELL: u32 = 64;
pub const AMDGPU_GEM_DOMAIN_MASK: u32 = 127;
pub const AMDGPU_GEM_CREATE_CPU_ACCESS_REQUIRED: u32 = 1;
pub const AMDGPU_GEM_CREATE_NO_CPU_ACCESS: u32 = 2;
pub const AMDGPU_GEM_CREATE_CPU_GTT_USWC: u32 = 4;
pub const AMDGPU_GEM_CREATE_VRAM_CLEARED: u32 = 8;
pub const AMDGPU_GEM_CREATE_VRAM_CONTIGUOUS: u32 = 32;
pub const AMDGPU_GEM_CREATE_VM_ALWAYS_VALID: u32 = 64;
pub const AMDGPU_GEM_CREATE_EXPLICIT_SYNC: u32 = 128;
pub const AMDGPU_GEM_CREATE_CP_MQD_GFX9: u32 = 256;
pub const AMDGPU_GEM_CREATE_VRAM_WIPE_ON_RELEASE: u32 = 512;
pub const AMDGPU_GEM_CREATE_ENCRYPTED: u32 = 1024;
pub const AMDGPU_GEM_CREATE_PREEMPTIBLE: u32 = 2048;
pub const AMDGPU_GEM_CREATE_DISCARDABLE: u32 = 4096;
pub const AMDGPU_GEM_CREATE_COHERENT: u32 = 8192;
pub const AMDGPU_GEM_CREATE_UNCACHED: u32 = 16384;
pub const AMDGPU_GEM_CREATE_EXT_COHERENT: u32 = 32768;
pub const AMDGPU_BO_LIST_OP_CREATE: u32 = 0;
pub const AMDGPU_BO_LIST_OP_DESTROY: u32 = 1;
pub const AMDGPU_BO_LIST_OP_UPDATE: u32 = 2;
pub const AMDGPU_CTX_OP_ALLOC_CTX: u32 = 1;
pub const AMDGPU_CTX_OP_FREE_CTX: u32 = 2;
pub const AMDGPU_CTX_OP_QUERY_STATE: u32 = 3;
pub const AMDGPU_CTX_OP_QUERY_STATE2: u32 = 4;
pub const AMDGPU_CTX_OP_GET_STABLE_PSTATE: u32 = 5;
pub const AMDGPU_CTX_OP_SET_STABLE_PSTATE: u32 = 6;
pub const AMDGPU_CTX_NO_RESET: u32 = 0;
pub const AMDGPU_CTX_GUILTY_RESET: u32 = 1;
pub const AMDGPU_CTX_INNOCENT_RESET: u32 = 2;
pub const AMDGPU_CTX_UNKNOWN_RESET: u32 = 3;
pub const AMDGPU_CTX_QUERY2_FLAGS_RESET: u32 = 1;
pub const AMDGPU_CTX_QUERY2_FLAGS_VRAMLOST: u32 = 2;
pub const AMDGPU_CTX_QUERY2_FLAGS_GUILTY: u32 = 4;
pub const AMDGPU_CTX_QUERY2_FLAGS_RAS_CE: u32 = 8;
pub const AMDGPU_CTX_QUERY2_FLAGS_RAS_UE: u32 = 16;
pub const AMDGPU_CTX_QUERY2_FLAGS_RESET_IN_PROGRESS: u32 = 32;
pub const AMDGPU_CTX_PRIORITY_UNSET: i32 = -2048;
pub const AMDGPU_CTX_PRIORITY_VERY_LOW: i32 = -1023;
pub const AMDGPU_CTX_PRIORITY_LOW: i32 = -512;
pub const AMDGPU_CTX_PRIORITY_NORMAL: u32 = 0;
pub const AMDGPU_CTX_PRIORITY_HIGH: u32 = 512;
pub const AMDGPU_CTX_PRIORITY_VERY_HIGH: u32 = 1023;
pub const AMDGPU_CTX_STABLE_PSTATE_FLAGS_MASK: u32 = 15;
pub const AMDGPU_CTX_STABLE_PSTATE_NONE: u32 = 0;
pub const AMDGPU_CTX_STABLE_PSTATE_STANDARD: u32 = 1;
pub const AMDGPU_CTX_STABLE_PSTATE_MIN_SCLK: u32 = 2;
pub const AMDGPU_CTX_STABLE_PSTATE_MIN_MCLK: u32 = 3;
pub const AMDGPU_CTX_STABLE_PSTATE_PEAK: u32 = 4;
pub const AMDGPU_VM_OP_RESERVE_VMID: u32 = 1;
pub const AMDGPU_VM_OP_UNRESERVE_VMID: u32 = 2;
pub const AMDGPU_SCHED_OP_PROCESS_PRIORITY_OVERRIDE: u32 = 1;
pub const AMDGPU_SCHED_OP_CONTEXT_PRIORITY_OVERRIDE: u32 = 2;
pub const AMDGPU_GEM_USERPTR_READONLY: u32 = 1;
pub const AMDGPU_GEM_USERPTR_ANONONLY: u32 = 2;
pub const AMDGPU_GEM_USERPTR_VALIDATE: u32 = 4;
pub const AMDGPU_GEM_USERPTR_REGISTER: u32 = 8;
pub const AMDGPU_TILING_ARRAY_MODE_SHIFT: u32 = 0;
pub const AMDGPU_TILING_ARRAY_MODE_MASK: u32 = 15;
pub const AMDGPU_TILING_PIPE_CONFIG_SHIFT: u32 = 4;
pub const AMDGPU_TILING_PIPE_CONFIG_MASK: u32 = 31;
pub const AMDGPU_TILING_TILE_SPLIT_SHIFT: u32 = 9;
pub const AMDGPU_TILING_TILE_SPLIT_MASK: u32 = 7;
pub const AMDGPU_TILING_MICRO_TILE_MODE_SHIFT: u32 = 12;
pub const AMDGPU_TILING_MICRO_TILE_MODE_MASK: u32 = 7;
pub const AMDGPU_TILING_BANK_WIDTH_SHIFT: u32 = 15;
pub const AMDGPU_TILING_BANK_WIDTH_MASK: u32 = 3;
pub const AMDGPU_TILING_BANK_HEIGHT_SHIFT: u32 = 17;
pub const AMDGPU_TILING_BANK_HEIGHT_MASK: u32 = 3;
pub const AMDGPU_TILING_MACRO_TILE_ASPECT_SHIFT: u32 = 19;
pub const AMDGPU_TILING_MACRO_TILE_ASPECT_MASK: u32 = 3;
pub const AMDGPU_TILING_NUM_BANKS_SHIFT: u32 = 21;
pub const AMDGPU_TILING_NUM_BANKS_MASK: u32 = 3;
pub const AMDGPU_TILING_SWIZZLE_MODE_SHIFT: u32 = 0;
pub const AMDGPU_TILING_SWIZZLE_MODE_MASK: u32 = 31;
pub const AMDGPU_TILING_DCC_OFFSET_256B_SHIFT: u32 = 5;
pub const AMDGPU_TILING_DCC_OFFSET_256B_MASK: u32 = 16777215;
pub const AMDGPU_TILING_DCC_PITCH_MAX_SHIFT: u32 = 29;
pub const AMDGPU_TILING_DCC_PITCH_MAX_MASK: u32 = 16383;
pub const AMDGPU_TILING_DCC_INDEPENDENT_64B_SHIFT: u32 = 43;
pub const AMDGPU_TILING_DCC_INDEPENDENT_64B_MASK: u32 = 1;
pub const AMDGPU_TILING_DCC_INDEPENDENT_128B_SHIFT: u32 = 44;
pub const AMDGPU_TILING_DCC_INDEPENDENT_128B_MASK: u32 = 1;
pub const AMDGPU_TILING_SCANOUT_SHIFT: u32 = 63;
pub const AMDGPU_TILING_SCANOUT_MASK: u32 = 1;
pub const AMDGPU_GEM_METADATA_OP_SET_METADATA: u32 = 1;
pub const AMDGPU_GEM_METADATA_OP_GET_METADATA: u32 = 2;
pub const AMDGPU_GEM_OP_GET_GEM_CREATE_INFO: u32 = 0;
pub const AMDGPU_GEM_OP_SET_PLACEMENT: u32 = 1;
pub const AMDGPU_VA_OP_MAP: u32 = 1;
pub const AMDGPU_VA_OP_UNMAP: u32 = 2;
pub const AMDGPU_VA_OP_CLEAR: u32 = 3;
pub const AMDGPU_VA_OP_REPLACE: u32 = 4;
pub const AMDGPU_VM_DELAY_UPDATE: u32 = 1;
pub const AMDGPU_VM_PAGE_READABLE: u32 = 2;
pub const AMDGPU_VM_PAGE_WRITEABLE: u32 = 4;
pub const AMDGPU_VM_PAGE_EXECUTABLE: u32 = 8;
pub const AMDGPU_VM_PAGE_PRT: u32 = 16;
pub const AMDGPU_VM_MTYPE_MASK: u32 = 480;
pub const AMDGPU_VM_MTYPE_DEFAULT: u32 = 0;
pub const AMDGPU_VM_MTYPE_NC: u32 = 32;
pub const AMDGPU_VM_MTYPE_WC: u32 = 64;
pub const AMDGPU_VM_MTYPE_CC: u32 = 96;
pub const AMDGPU_VM_MTYPE_UC: u32 = 128;
pub const AMDGPU_VM_MTYPE_RW: u32 = 160;
pub const AMDGPU_VM_PAGE_NOALLOC: u32 = 512;
pub const AMDGPU_HW_IP_GFX: u32 = 0;
pub const AMDGPU_HW_IP_COMPUTE: u32 = 1;
pub const AMDGPU_HW_IP_DMA: u32 = 2;
pub const AMDGPU_HW_IP_UVD: u32 = 3;
pub const AMDGPU_HW_IP_VCE: u32 = 4;
pub const AMDGPU_HW_IP_UVD_ENC: u32 = 5;
pub const AMDGPU_HW_IP_VCN_DEC: u32 = 6;
pub const AMDGPU_HW_IP_VCN_ENC: u32 = 7;
pub const AMDGPU_HW_IP_VCN_JPEG: u32 = 8;
pub const AMDGPU_HW_IP_VPE: u32 = 9;
pub const AMDGPU_HW_IP_NUM: u32 = 10;
pub const AMDGPU_HW_IP_INSTANCE_MAX_COUNT: u32 = 1;
pub const AMDGPU_CHUNK_ID_IB: u32 = 1;
pub const AMDGPU_CHUNK_ID_FENCE: u32 = 2;
pub const AMDGPU_CHUNK_ID_DEPENDENCIES: u32 = 3;
pub const AMDGPU_CHUNK_ID_SYNCOBJ_IN: u32 = 4;
pub const AMDGPU_CHUNK_ID_SYNCOBJ_OUT: u32 = 5;
pub const AMDGPU_CHUNK_ID_BO_HANDLES: u32 = 6;
pub const AMDGPU_CHUNK_ID_SCHEDULED_DEPENDENCIES: u32 = 7;
pub const AMDGPU_CHUNK_ID_SYNCOBJ_TIMELINE_WAIT: u32 = 8;
pub const AMDGPU_CHUNK_ID_SYNCOBJ_TIMELINE_SIGNAL: u32 = 9;
pub const AMDGPU_CHUNK_ID_CP_GFX_SHADOW: u32 = 10;
pub const AMDGPU_IB_FLAG_CE: u32 = 1;
pub const AMDGPU_IB_FLAG_PREAMBLE: u32 = 2;
pub const AMDGPU_IB_FLAG_PREEMPT: u32 = 4;
pub const AMDGPU_IB_FLAG_TC_WB_NOT_INVALIDATE: u32 = 8;
pub const AMDGPU_IB_FLAG_RESET_GDS_MAX_WAVE_ID: u32 = 16;
pub const AMDGPU_IB_FLAGS_SECURE: u32 = 32;
pub const AMDGPU_IB_FLAG_EMIT_MEM_SYNC: u32 = 64;
pub const AMDGPU_FENCE_TO_HANDLE_GET_SYNCOBJ: u32 = 0;
pub const AMDGPU_FENCE_TO_HANDLE_GET_SYNCOBJ_FD: u32 = 1;
pub const AMDGPU_FENCE_TO_HANDLE_GET_SYNC_FILE_FD: u32 = 2;
pub const AMDGPU_CS_CHUNK_CP_GFX_SHADOW_FLAGS_INIT_SHADOW: u32 = 1;
pub const AMDGPU_IDS_FLAGS_FUSION: u32 = 1;
pub const AMDGPU_IDS_FLAGS_PREEMPTION: u32 = 2;
pub const AMDGPU_IDS_FLAGS_TMZ: u32 = 4;
pub const AMDGPU_IDS_FLAGS_CONFORMANT_TRUNC_COORD: u32 = 8;
pub const AMDGPU_INFO_ACCEL_WORKING: u32 = 0;
pub const AMDGPU_INFO_CRTC_FROM_ID: u32 = 1;
pub const AMDGPU_INFO_HW_IP_INFO: u32 = 2;
pub const AMDGPU_INFO_HW_IP_COUNT: u32 = 3;
pub const AMDGPU_INFO_TIMESTAMP: u32 = 5;
pub const AMDGPU_INFO_FW_VERSION: u32 = 14;
pub const AMDGPU_INFO_FW_VCE: u32 = 1;
pub const AMDGPU_INFO_FW_UVD: u32 = 2;
pub const AMDGPU_INFO_FW_GMC: u32 = 3;
pub const AMDGPU_INFO_FW_GFX_ME: u32 = 4;
pub const AMDGPU_INFO_FW_GFX_PFP: u32 = 5;
pub const AMDGPU_INFO_FW_GFX_CE: u32 = 6;
pub const AMDGPU_INFO_FW_GFX_RLC: u32 = 7;
pub const AMDGPU_INFO_FW_GFX_MEC: u32 = 8;
pub const AMDGPU_INFO_FW_SMC: u32 = 10;
pub const AMDGPU_INFO_FW_SDMA: u32 = 11;
pub const AMDGPU_INFO_FW_SOS: u32 = 12;
pub const AMDGPU_INFO_FW_ASD: u32 = 13;
pub const AMDGPU_INFO_FW_VCN: u32 = 14;
pub const AMDGPU_INFO_FW_GFX_RLC_RESTORE_LIST_CNTL: u32 = 15;
pub const AMDGPU_INFO_FW_GFX_RLC_RESTORE_LIST_GPM_MEM: u32 = 16;
pub const AMDGPU_INFO_FW_GFX_RLC_RESTORE_LIST_SRM_MEM: u32 = 17;
pub const AMDGPU_INFO_FW_DMCU: u32 = 18;
pub const AMDGPU_INFO_FW_TA: u32 = 19;
pub const AMDGPU_INFO_FW_DMCUB: u32 = 20;
pub const AMDGPU_INFO_FW_TOC: u32 = 21;
pub const AMDGPU_INFO_FW_CAP: u32 = 22;
pub const AMDGPU_INFO_FW_GFX_RLCP: u32 = 23;
pub const AMDGPU_INFO_FW_GFX_RLCV: u32 = 24;
pub const AMDGPU_INFO_FW_MES_KIQ: u32 = 25;
pub const AMDGPU_INFO_FW_MES: u32 = 26;
pub const AMDGPU_INFO_FW_IMU: u32 = 27;
pub const AMDGPU_INFO_FW_VPE: u32 = 28;
pub const AMDGPU_INFO_NUM_BYTES_MOVED: u32 = 15;
pub const AMDGPU_INFO_VRAM_USAGE: u32 = 16;
pub const AMDGPU_INFO_GTT_USAGE: u32 = 17;
pub const AMDGPU_INFO_GDS_CONFIG: u32 = 19;
pub const AMDGPU_INFO_VRAM_GTT: u32 = 20;
pub const AMDGPU_INFO_READ_MMR_REG: u32 = 21;
pub const AMDGPU_INFO_DEV_INFO: u32 = 22;
pub const AMDGPU_INFO_VIS_VRAM_USAGE: u32 = 23;
pub const AMDGPU_INFO_NUM_EVICTIONS: u32 = 24;
pub const AMDGPU_INFO_MEMORY: u32 = 25;
pub const AMDGPU_INFO_VCE_CLOCK_TABLE: u32 = 26;
pub const AMDGPU_INFO_VBIOS: u32 = 27;
pub const AMDGPU_INFO_VBIOS_SIZE: u32 = 1;
pub const AMDGPU_INFO_VBIOS_IMAGE: u32 = 2;
pub const AMDGPU_INFO_VBIOS_INFO: u32 = 3;
pub const AMDGPU_INFO_NUM_HANDLES: u32 = 28;
pub const AMDGPU_INFO_SENSOR: u32 = 29;
pub const AMDGPU_INFO_SENSOR_GFX_SCLK: u32 = 1;
pub const AMDGPU_INFO_SENSOR_GFX_MCLK: u32 = 2;
pub const AMDGPU_INFO_SENSOR_GPU_TEMP: u32 = 3;
pub const AMDGPU_INFO_SENSOR_GPU_LOAD: u32 = 4;
pub const AMDGPU_INFO_SENSOR_GPU_AVG_POWER: u32 = 5;
pub const AMDGPU_INFO_SENSOR_VDDNB: u32 = 6;
pub const AMDGPU_INFO_SENSOR_VDDGFX: u32 = 7;
pub const AMDGPU_INFO_SENSOR_STABLE_PSTATE_GFX_SCLK: u32 = 8;
pub const AMDGPU_INFO_SENSOR_STABLE_PSTATE_GFX_MCLK: u32 = 9;
pub const AMDGPU_INFO_SENSOR_PEAK_PSTATE_GFX_SCLK: u32 = 10;
pub const AMDGPU_INFO_SENSOR_PEAK_PSTATE_GFX_MCLK: u32 = 11;
pub const AMDGPU_INFO_NUM_VRAM_CPU_PAGE_FAULTS: u32 = 30;
pub const AMDGPU_INFO_VRAM_LOST_COUNTER: u32 = 31;
pub const AMDGPU_INFO_RAS_ENABLED_FEATURES: u32 = 32;
pub const AMDGPU_INFO_RAS_ENABLED_UMC: u32 = 1;
pub const AMDGPU_INFO_RAS_ENABLED_SDMA: u32 = 2;
pub const AMDGPU_INFO_RAS_ENABLED_GFX: u32 = 4;
pub const AMDGPU_INFO_RAS_ENABLED_MMHUB: u32 = 8;
pub const AMDGPU_INFO_RAS_ENABLED_ATHUB: u32 = 16;
pub const AMDGPU_INFO_RAS_ENABLED_PCIE: u32 = 32;
pub const AMDGPU_INFO_RAS_ENABLED_HDP: u32 = 64;
pub const AMDGPU_INFO_RAS_ENABLED_XGMI: u32 = 128;
pub const AMDGPU_INFO_RAS_ENABLED_DF: u32 = 256;
pub const AMDGPU_INFO_RAS_ENABLED_SMN: u32 = 512;
pub const AMDGPU_INFO_RAS_ENABLED_SEM: u32 = 1024;
pub const AMDGPU_INFO_RAS_ENABLED_MP0: u32 = 2048;
pub const AMDGPU_INFO_RAS_ENABLED_MP1: u32 = 4096;
pub const AMDGPU_INFO_RAS_ENABLED_FUSE: u32 = 8192;
pub const AMDGPU_INFO_VIDEO_CAPS: u32 = 33;
pub const AMDGPU_INFO_VIDEO_CAPS_DECODE: u32 = 0;
pub const AMDGPU_INFO_VIDEO_CAPS_ENCODE: u32 = 1;
pub const AMDGPU_INFO_MAX_IBS: u32 = 34;
pub const AMDGPU_INFO_GPUVM_FAULT: u32 = 35;
pub const AMDGPU_INFO_MMR_SE_INDEX_SHIFT: u32 = 0;
pub const AMDGPU_INFO_MMR_SE_INDEX_MASK: u32 = 255;
pub const AMDGPU_INFO_MMR_SH_INDEX_SHIFT: u32 = 8;
pub const AMDGPU_INFO_MMR_SH_INDEX_MASK: u32 = 255;
pub const AMDGPU_VRAM_TYPE_UNKNOWN: u32 = 0;
pub const AMDGPU_VRAM_TYPE_GDDR1: u32 = 1;
pub const AMDGPU_VRAM_TYPE_DDR2: u32 = 2;
pub const AMDGPU_VRAM_TYPE_GDDR3: u32 = 3;
pub const AMDGPU_VRAM_TYPE_GDDR4: u32 = 4;
pub const AMDGPU_VRAM_TYPE_GDDR5: u32 = 5;
pub const AMDGPU_VRAM_TYPE_HBM: u32 = 6;
pub const AMDGPU_VRAM_TYPE_DDR3: u32 = 7;
pub const AMDGPU_VRAM_TYPE_DDR4: u32 = 8;
pub const AMDGPU_VRAM_TYPE_GDDR6: u32 = 9;
pub const AMDGPU_VRAM_TYPE_DDR5: u32 = 10;
pub const AMDGPU_VRAM_TYPE_LPDDR4: u32 = 11;
pub const AMDGPU_VRAM_TYPE_LPDDR5: u32 = 12;
pub const AMDGPU_VCE_CLOCK_TABLE_ENTRIES: u32 = 6;
pub const AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_MPEG2: u32 = 0;
pub const AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_MPEG4: u32 = 1;
pub const AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_VC1: u32 = 2;
pub const AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_MPEG4_AVC: u32 = 3;
pub const AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_HEVC: u32 = 4;
pub const AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_JPEG: u32 = 5;
pub const AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_VP9: u32 = 6;
pub const AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_AV1: u32 = 7;
pub const AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_COUNT: u32 = 8;
pub const AMDGPU_VMHUB_TYPE_MASK: u32 = 255;
pub const AMDGPU_VMHUB_TYPE_SHIFT: u32 = 0;
pub const AMDGPU_VMHUB_TYPE_GFX: u32 = 0;
pub const AMDGPU_VMHUB_TYPE_MM0: u32 = 1;
pub const AMDGPU_VMHUB_TYPE_MM1: u32 = 2;
pub const AMDGPU_VMHUB_IDX_MASK: u32 = 65280;
pub const AMDGPU_VMHUB_IDX_SHIFT: u32 = 8;
pub const AMDGPU_FAMILY_UNKNOWN: u32 = 0;
pub const AMDGPU_FAMILY_SI: u32 = 110;
pub const AMDGPU_FAMILY_CI: u32 = 120;
pub const AMDGPU_FAMILY_KV: u32 = 125;
pub const AMDGPU_FAMILY_VI: u32 = 130;
pub const AMDGPU_FAMILY_CZ: u32 = 135;
pub const AMDGPU_FAMILY_AI: u32 = 141;
pub const AMDGPU_FAMILY_RV: u32 = 142;
pub const AMDGPU_FAMILY_NV: u32 = 143;
pub const AMDGPU_FAMILY_VGH: u32 = 144;
pub const AMDGPU_FAMILY_GC_11_0_0: u32 = 145;
pub const AMDGPU_FAMILY_YC: u32 = 146;
pub const AMDGPU_FAMILY_GC_11_0_1: u32 = 148;
pub const AMDGPU_FAMILY_GC_10_3_6: u32 = 149;
pub const AMDGPU_FAMILY_GC_10_3_7: u32 = 151;
pub const AMDGPU_FAMILY_GC_11_5_0: u32 = 150;
pub const BIOS_ATOM_PREFIX: &[u8; 9] = b"ATOMBIOS\0";
pub const BIOS_VERSION_PREFIX: &[u8; 15] = b"ATOMBIOSBK-AMD\0";
pub const BIOS_STRING_LENGTH: u32 = 43;
pub const NUM_HBM_INSTANCES: u32 = 4;
pub const NUM_XGMI_LINKS: u32 = 8;
pub const MAX_GFX_CLKS: u32 = 8;
pub const MAX_CLKS: u32 = 4;
pub const NUM_VCN: u32 = 4;
pub const NUM_JPEG_ENG: u32 = 32;
pub type __gnuc_va_list = __builtin_va_list;
pub type va_list = __builtin_va_list;
pub type __u_char = ::core::ffi::c_uchar;
pub type __u_short = ::core::ffi::c_ushort;
pub type __u_int = ::core::ffi::c_uint;
pub type __u_long = ::core::ffi::c_ulong;
pub type __int8_t = ::core::ffi::c_schar;
pub type __uint8_t = ::core::ffi::c_uchar;
pub type __int16_t = ::core::ffi::c_short;
pub type __uint16_t = ::core::ffi::c_ushort;
pub type __int32_t = ::core::ffi::c_int;
pub type __uint32_t = ::core::ffi::c_uint;
pub type __int64_t = ::core::ffi::c_long;
pub type __uint64_t = ::core::ffi::c_ulong;
pub type __int_least8_t = __int8_t;
pub type __uint_least8_t = __uint8_t;
pub type __int_least16_t = __int16_t;
pub type __uint_least16_t = __uint16_t;
pub type __int_least32_t = __int32_t;
pub type __uint_least32_t = __uint32_t;
pub type __int_least64_t = __int64_t;
pub type __uint_least64_t = __uint64_t;
pub type __quad_t = ::core::ffi::c_long;
pub type __u_quad_t = ::core::ffi::c_ulong;
pub type __intmax_t = ::core::ffi::c_long;
pub type __uintmax_t = ::core::ffi::c_ulong;
pub type __dev_t = ::core::ffi::c_ulong;
pub type __uid_t = ::core::ffi::c_uint;
pub type __gid_t = ::core::ffi::c_uint;
pub type __ino_t = ::core::ffi::c_ulong;
pub type __ino64_t = ::core::ffi::c_ulong;
pub type __mode_t = ::core::ffi::c_uint;
pub type __nlink_t = ::core::ffi::c_ulong;
pub type __off_t = ::core::ffi::c_long;
pub type __off64_t = ::core::ffi::c_long;
pub type __pid_t = ::core::ffi::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __fsid_t {
    pub __val: [::core::ffi::c_int; 2usize],
}
pub type __clock_t = ::core::ffi::c_long;
pub type __rlim_t = ::core::ffi::c_ulong;
pub type __rlim64_t = ::core::ffi::c_ulong;
pub type __id_t = ::core::ffi::c_uint;
pub type __time_t = ::core::ffi::c_long;
pub type __useconds_t = ::core::ffi::c_uint;
pub type __suseconds_t = ::core::ffi::c_long;
pub type __suseconds64_t = ::core::ffi::c_long;
pub type __daddr_t = ::core::ffi::c_int;
pub type __key_t = ::core::ffi::c_int;
pub type __clockid_t = ::core::ffi::c_int;
pub type __timer_t = *mut ::core::ffi::c_void;
pub type __blksize_t = ::core::ffi::c_long;
pub type __blkcnt_t = ::core::ffi::c_long;
pub type __blkcnt64_t = ::core::ffi::c_long;
pub type __fsblkcnt_t = ::core::ffi::c_ulong;
pub type __fsblkcnt64_t = ::core::ffi::c_ulong;
pub type __fsfilcnt_t = ::core::ffi::c_ulong;
pub type __fsfilcnt64_t = ::core::ffi::c_ulong;
pub type __fsword_t = ::core::ffi::c_long;
pub type __ssize_t = ::core::ffi::c_long;
pub type __syscall_slong_t = ::core::ffi::c_long;
pub type __syscall_ulong_t = ::core::ffi::c_ulong;
pub type __loff_t = __off64_t;
pub type __caddr_t = *mut ::core::ffi::c_char;
pub type __intptr_t = ::core::ffi::c_long;
pub type __socklen_t = ::core::ffi::c_uint;
pub type __sig_atomic_t = ::core::ffi::c_int;
pub type u_char = __u_char;
pub type u_short = __u_short;
pub type u_int = __u_int;
pub type u_long = __u_long;
pub type quad_t = __quad_t;
pub type u_quad_t = __u_quad_t;
pub type fsid_t = __fsid_t;
pub type loff_t = __loff_t;
pub type ino_t = __ino_t;
pub type dev_t = __dev_t;
pub type gid_t = __gid_t;
pub type mode_t = __mode_t;
pub type nlink_t = __nlink_t;
pub type uid_t = __uid_t;
pub type off_t = __off_t;
pub type pid_t = __pid_t;
pub type id_t = __id_t;
pub type daddr_t = __daddr_t;
pub type caddr_t = __caddr_t;
pub type key_t = __key_t;
pub type clock_t = __clock_t;
pub type clockid_t = __clockid_t;
pub type time_t = __time_t;
pub type timer_t = __timer_t;
pub type ulong = ::core::ffi::c_ulong;
pub type ushort = ::core::ffi::c_ushort;
pub type uint = ::core::ffi::c_uint;
pub type u_int8_t = __uint8_t;
pub type u_int16_t = __uint16_t;
pub type u_int32_t = __uint32_t;
pub type u_int64_t = __uint64_t;
pub type register_t = ::core::ffi::c_long;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sigset_t {
    pub __val: [::core::ffi::c_ulong; 16usize],
}
pub type sigset_t = __sigset_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval {
    pub tv_sec: __time_t,
    pub tv_usec: __suseconds_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timespec {
    pub tv_sec: __time_t,
    pub tv_nsec: __syscall_slong_t,
}
pub type suseconds_t = __suseconds_t;
pub type __fd_mask = ::core::ffi::c_long;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fd_set {
    pub __fds_bits: [__fd_mask; 16usize],
}
pub type fd_mask = __fd_mask;
unsafe extern "C" {
    pub fn select(
        __nfds: ::core::ffi::c_int,
        __readfds: *mut fd_set,
        __writefds: *mut fd_set,
        __exceptfds: *mut fd_set,
        __timeout: *mut timeval,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn pselect(
        __nfds: ::core::ffi::c_int,
        __readfds: *mut fd_set,
        __writefds: *mut fd_set,
        __exceptfds: *mut fd_set,
        __timeout: *const timespec,
        __sigmask: *const __sigset_t,
    ) -> ::core::ffi::c_int;
}
pub type blksize_t = __blksize_t;
pub type blkcnt_t = __blkcnt_t;
pub type fsblkcnt_t = __fsblkcnt_t;
pub type fsfilcnt_t = __fsfilcnt_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __atomic_wide_counter {
    pub __value64: ::core::ffi::c_ulonglong,
    pub __value32: __atomic_wide_counter__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __atomic_wide_counter__bindgen_ty_1 {
    pub __low: ::core::ffi::c_uint,
    pub __high: ::core::ffi::c_uint,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_list {
    pub __prev: *mut __pthread_internal_list,
    pub __next: *mut __pthread_internal_list,
}
pub type __pthread_list_t = __pthread_internal_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_slist {
    pub __next: *mut __pthread_internal_slist,
}
pub type __pthread_slist_t = __pthread_internal_slist;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_mutex_s {
    pub __lock: ::core::ffi::c_int,
    pub __count: ::core::ffi::c_uint,
    pub __owner: ::core::ffi::c_int,
    pub __nusers: ::core::ffi::c_uint,
    pub __kind: ::core::ffi::c_int,
    pub __spins: ::core::ffi::c_short,
    pub __elision: ::core::ffi::c_short,
    pub __list: __pthread_list_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_rwlock_arch_t {
    pub __readers: ::core::ffi::c_uint,
    pub __writers: ::core::ffi::c_uint,
    pub __wrphase_futex: ::core::ffi::c_uint,
    pub __writers_futex: ::core::ffi::c_uint,
    pub __pad3: ::core::ffi::c_uint,
    pub __pad4: ::core::ffi::c_uint,
    pub __cur_writer: ::core::ffi::c_int,
    pub __shared: ::core::ffi::c_int,
    pub __rwelision: ::core::ffi::c_schar,
    pub __pad1: [::core::ffi::c_uchar; 7usize],
    pub __pad2: ::core::ffi::c_ulong,
    pub __flags: ::core::ffi::c_uint,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __pthread_cond_s {
    pub __wseq: __atomic_wide_counter,
    pub __g1_start: __atomic_wide_counter,
    pub __g_size: [::core::ffi::c_uint; 2usize],
    pub __g1_orig_size: ::core::ffi::c_uint,
    pub __wrefs: ::core::ffi::c_uint,
    pub __g_signals: [::core::ffi::c_uint; 2usize],
    pub __unused_initialized_1: ::core::ffi::c_uint,
    pub __unused_initialized_2: ::core::ffi::c_uint,
}
pub type __tss_t = ::core::ffi::c_uint;
pub type __thrd_t = ::core::ffi::c_ulong;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __once_flag {
    pub __data: ::core::ffi::c_int,
}
pub type pthread_t = ::core::ffi::c_ulong;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutexattr_t {
    pub __size: [::core::ffi::c_char; 4usize],
    pub __align: ::core::ffi::c_int,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_condattr_t {
    pub __size: [::core::ffi::c_char; 4usize],
    pub __align: ::core::ffi::c_int,
}
pub type pthread_key_t = ::core::ffi::c_uint;
pub type pthread_once_t = ::core::ffi::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_attr_t {
    pub __size: [::core::ffi::c_char; 56usize],
    pub __align: ::core::ffi::c_long,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutex_t {
    pub __data: __pthread_mutex_s,
    pub __size: [::core::ffi::c_char; 40usize],
    pub __align: ::core::ffi::c_long,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_cond_t {
    pub __data: __pthread_cond_s,
    pub __size: [::core::ffi::c_char; 48usize],
    pub __align: ::core::ffi::c_longlong,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlock_t {
    pub __data: __pthread_rwlock_arch_t,
    pub __size: [::core::ffi::c_char; 56usize],
    pub __align: ::core::ffi::c_long,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlockattr_t {
    pub __size: [::core::ffi::c_char; 8usize],
    pub __align: ::core::ffi::c_long,
}
pub type pthread_spinlock_t = ::core::ffi::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrier_t {
    pub __size: [::core::ffi::c_char; 32usize],
    pub __align: ::core::ffi::c_long,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrierattr_t {
    pub __size: [::core::ffi::c_char; 4usize],
    pub __align: ::core::ffi::c_int,
}
pub type int_least8_t = __int_least8_t;
pub type int_least16_t = __int_least16_t;
pub type int_least32_t = __int_least32_t;
pub type int_least64_t = __int_least64_t;
pub type uint_least8_t = __uint_least8_t;
pub type uint_least16_t = __uint_least16_t;
pub type uint_least32_t = __uint_least32_t;
pub type uint_least64_t = __uint_least64_t;
pub type int_fast8_t = ::core::ffi::c_schar;
pub type int_fast16_t = ::core::ffi::c_long;
pub type int_fast32_t = ::core::ffi::c_long;
pub type int_fast64_t = ::core::ffi::c_long;
pub type uint_fast8_t = ::core::ffi::c_uchar;
pub type uint_fast16_t = ::core::ffi::c_ulong;
pub type uint_fast32_t = ::core::ffi::c_ulong;
pub type uint_fast64_t = ::core::ffi::c_ulong;
pub type intmax_t = __intmax_t;
pub type uintmax_t = __uintmax_t;
pub type __s8 = ::core::ffi::c_schar;
pub type __u8 = ::core::ffi::c_uchar;
pub type __s16 = ::core::ffi::c_short;
pub type __u16 = ::core::ffi::c_ushort;
pub type __s32 = ::core::ffi::c_int;
pub type __u32 = ::core::ffi::c_uint;
pub type __s64 = ::core::ffi::c_longlong;
pub type __u64 = ::core::ffi::c_ulonglong;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __kernel_fd_set {
    pub fds_bits: [::core::ffi::c_ulong; 16usize],
}
pub type __kernel_sighandler_t =
    ::core::option::Option<unsafe extern "C" fn(arg1: ::core::ffi::c_int)>;
pub type __kernel_key_t = ::core::ffi::c_int;
pub type __kernel_mqd_t = ::core::ffi::c_int;
pub type __kernel_old_uid_t = ::core::ffi::c_ushort;
pub type __kernel_old_gid_t = ::core::ffi::c_ushort;
pub type __kernel_old_dev_t = ::core::ffi::c_ulong;
pub type __kernel_long_t = ::core::ffi::c_long;
pub type __kernel_ulong_t = ::core::ffi::c_ulong;
pub type __kernel_ino_t = __kernel_ulong_t;
pub type __kernel_mode_t = ::core::ffi::c_uint;
pub type __kernel_pid_t = ::core::ffi::c_int;
pub type __kernel_ipc_pid_t = ::core::ffi::c_int;
pub type __kernel_uid_t = ::core::ffi::c_uint;
pub type __kernel_gid_t = ::core::ffi::c_uint;
pub type __kernel_suseconds_t = __kernel_long_t;
pub type __kernel_daddr_t = ::core::ffi::c_int;
pub type __kernel_uid32_t = ::core::ffi::c_uint;
pub type __kernel_gid32_t = ::core::ffi::c_uint;
pub type __kernel_size_t = __kernel_ulong_t;
pub type __kernel_ssize_t = __kernel_long_t;
pub type __kernel_ptrdiff_t = __kernel_long_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __kernel_fsid_t {
    pub val: [::core::ffi::c_int; 2usize],
}
pub type __kernel_off_t = __kernel_long_t;
pub type __kernel_loff_t = ::core::ffi::c_longlong;
pub type __kernel_old_time_t = __kernel_long_t;
pub type __kernel_time_t = __kernel_long_t;
pub type __kernel_time64_t = ::core::ffi::c_longlong;
pub type __kernel_clock_t = __kernel_long_t;
pub type __kernel_timer_t = ::core::ffi::c_int;
pub type __kernel_clockid_t = ::core::ffi::c_int;
pub type __kernel_caddr_t = *mut ::core::ffi::c_char;
pub type __kernel_uid16_t = ::core::ffi::c_ushort;
pub type __kernel_gid16_t = ::core::ffi::c_ushort;
pub type __s128 = i128;
pub type __u128 = u128;
pub type __le16 = __u16;
pub type __be16 = __u16;
pub type __le32 = __u32;
pub type __be32 = __u32;
pub type __le64 = __u64;
pub type __be64 = __u64;
pub type __sum16 = __u16;
pub type __wsum = __u32;
pub type __poll_t = ::core::ffi::c_uint;
pub type drm_handle_t = ::core::ffi::c_uint;
pub type drm_context_t = ::core::ffi::c_uint;
pub type drm_drawable_t = ::core::ffi::c_uint;
pub type drm_magic_t = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_clip_rect {
    pub x1: ::core::ffi::c_ushort,
    pub y1: ::core::ffi::c_ushort,
    pub x2: ::core::ffi::c_ushort,
    pub y2: ::core::ffi::c_ushort,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_drawable_info {
    pub num_rects: ::core::ffi::c_uint,
    pub rects: *mut drm_clip_rect,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_tex_region {
    pub next: ::core::ffi::c_uchar,
    pub prev: ::core::ffi::c_uchar,
    pub in_use: ::core::ffi::c_uchar,
    pub padding: ::core::ffi::c_uchar,
    pub age: ::core::ffi::c_uint,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_hw_lock {
    pub lock: ::core::ffi::c_uint,
    pub padding: [::core::ffi::c_char; 60usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_version {
    pub version_major: ::core::ffi::c_int,
    pub version_minor: ::core::ffi::c_int,
    pub version_patchlevel: ::core::ffi::c_int,
    pub name_len: __kernel_size_t,
    pub name: *mut ::core::ffi::c_char,
    pub date_len: __kernel_size_t,
    pub date: *mut ::core::ffi::c_char,
    pub desc_len: __kernel_size_t,
    pub desc: *mut ::core::ffi::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_unique {
    pub unique_len: __kernel_size_t,
    pub unique: *mut ::core::ffi::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_list {
    pub count: ::core::ffi::c_int,
    pub version: *mut drm_version,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_block {
    pub unused: ::core::ffi::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_control {
    pub func: drm_control__bindgen_ty_1,
    pub irq: ::core::ffi::c_int,
}
pub const drm_control_DRM_ADD_COMMAND: drm_control__bindgen_ty_1 = 0;
pub const drm_control_DRM_RM_COMMAND: drm_control__bindgen_ty_1 = 1;
pub const drm_control_DRM_INST_HANDLER: drm_control__bindgen_ty_1 = 2;
pub const drm_control_DRM_UNINST_HANDLER: drm_control__bindgen_ty_1 = 3;
pub type drm_control__bindgen_ty_1 = ::core::ffi::c_uint;
pub const drm_map_type__DRM_FRAME_BUFFER: drm_map_type = 0;
pub const drm_map_type__DRM_REGISTERS: drm_map_type = 1;
pub const drm_map_type__DRM_SHM: drm_map_type = 2;
pub const drm_map_type__DRM_AGP: drm_map_type = 3;
pub const drm_map_type__DRM_SCATTER_GATHER: drm_map_type = 4;
pub const drm_map_type__DRM_CONSISTENT: drm_map_type = 5;
pub type drm_map_type = ::core::ffi::c_uint;
pub const drm_map_flags__DRM_RESTRICTED: drm_map_flags = 1;
pub const drm_map_flags__DRM_READ_ONLY: drm_map_flags = 2;
pub const drm_map_flags__DRM_LOCKED: drm_map_flags = 4;
pub const drm_map_flags__DRM_KERNEL: drm_map_flags = 8;
pub const drm_map_flags__DRM_WRITE_COMBINING: drm_map_flags = 16;
pub const drm_map_flags__DRM_CONTAINS_LOCK: drm_map_flags = 32;
pub const drm_map_flags__DRM_REMOVABLE: drm_map_flags = 64;
pub const drm_map_flags__DRM_DRIVER: drm_map_flags = 128;
pub type drm_map_flags = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_ctx_priv_map {
    pub ctx_id: ::core::ffi::c_uint,
    pub handle: *mut ::core::ffi::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_map {
    pub offset: ::core::ffi::c_ulong,
    pub size: ::core::ffi::c_ulong,
    pub type_: drm_map_type,
    pub flags: drm_map_flags,
    pub handle: *mut ::core::ffi::c_void,
    pub mtrr: ::core::ffi::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_client {
    pub idx: ::core::ffi::c_int,
    pub auth: ::core::ffi::c_int,
    pub pid: ::core::ffi::c_ulong,
    pub uid: ::core::ffi::c_ulong,
    pub magic: ::core::ffi::c_ulong,
    pub iocs: ::core::ffi::c_ulong,
}
pub const drm_stat_type__DRM_STAT_LOCK: drm_stat_type = 0;
pub const drm_stat_type__DRM_STAT_OPENS: drm_stat_type = 1;
pub const drm_stat_type__DRM_STAT_CLOSES: drm_stat_type = 2;
pub const drm_stat_type__DRM_STAT_IOCTLS: drm_stat_type = 3;
pub const drm_stat_type__DRM_STAT_LOCKS: drm_stat_type = 4;
pub const drm_stat_type__DRM_STAT_UNLOCKS: drm_stat_type = 5;
pub const drm_stat_type__DRM_STAT_VALUE: drm_stat_type = 6;
pub const drm_stat_type__DRM_STAT_BYTE: drm_stat_type = 7;
pub const drm_stat_type__DRM_STAT_COUNT: drm_stat_type = 8;
pub const drm_stat_type__DRM_STAT_IRQ: drm_stat_type = 9;
pub const drm_stat_type__DRM_STAT_PRIMARY: drm_stat_type = 10;
pub const drm_stat_type__DRM_STAT_SECONDARY: drm_stat_type = 11;
pub const drm_stat_type__DRM_STAT_DMA: drm_stat_type = 12;
pub const drm_stat_type__DRM_STAT_SPECIAL: drm_stat_type = 13;
pub const drm_stat_type__DRM_STAT_MISSED: drm_stat_type = 14;
pub type drm_stat_type = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_stats {
    pub count: ::core::ffi::c_ulong,
    pub data: [drm_stats__bindgen_ty_1; 15usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_stats__bindgen_ty_1 {
    pub value: ::core::ffi::c_ulong,
    pub type_: drm_stat_type,
}
pub const drm_lock_flags__DRM_LOCK_READY: drm_lock_flags = 1;
pub const drm_lock_flags__DRM_LOCK_QUIESCENT: drm_lock_flags = 2;
pub const drm_lock_flags__DRM_LOCK_FLUSH: drm_lock_flags = 4;
pub const drm_lock_flags__DRM_LOCK_FLUSH_ALL: drm_lock_flags = 8;
pub const drm_lock_flags__DRM_HALT_ALL_QUEUES: drm_lock_flags = 16;
pub const drm_lock_flags__DRM_HALT_CUR_QUEUES: drm_lock_flags = 32;
pub type drm_lock_flags = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_lock {
    pub context: ::core::ffi::c_int,
    pub flags: drm_lock_flags,
}
pub const drm_dma_flags__DRM_DMA_BLOCK: drm_dma_flags = 1;
pub const drm_dma_flags__DRM_DMA_WHILE_LOCKED: drm_dma_flags = 2;
pub const drm_dma_flags__DRM_DMA_PRIORITY: drm_dma_flags = 4;
pub const drm_dma_flags__DRM_DMA_WAIT: drm_dma_flags = 16;
pub const drm_dma_flags__DRM_DMA_SMALLER_OK: drm_dma_flags = 32;
pub const drm_dma_flags__DRM_DMA_LARGER_OK: drm_dma_flags = 64;
pub type drm_dma_flags = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_buf_desc {
    pub count: ::core::ffi::c_int,
    pub size: ::core::ffi::c_int,
    pub low_mark: ::core::ffi::c_int,
    pub high_mark: ::core::ffi::c_int,
    pub flags: drm_buf_desc__bindgen_ty_1,
    pub agp_start: ::core::ffi::c_ulong,
}
pub const drm_buf_desc__DRM_PAGE_ALIGN: drm_buf_desc__bindgen_ty_1 = 1;
pub const drm_buf_desc__DRM_AGP_BUFFER: drm_buf_desc__bindgen_ty_1 = 2;
pub const drm_buf_desc__DRM_SG_BUFFER: drm_buf_desc__bindgen_ty_1 = 4;
pub const drm_buf_desc__DRM_FB_BUFFER: drm_buf_desc__bindgen_ty_1 = 8;
pub const drm_buf_desc__DRM_PCI_BUFFER_RO: drm_buf_desc__bindgen_ty_1 = 16;
pub type drm_buf_desc__bindgen_ty_1 = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_buf_info {
    pub count: ::core::ffi::c_int,
    pub list: *mut drm_buf_desc,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_buf_free {
    pub count: ::core::ffi::c_int,
    pub list: *mut ::core::ffi::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_buf_pub {
    pub idx: ::core::ffi::c_int,
    pub total: ::core::ffi::c_int,
    pub used: ::core::ffi::c_int,
    pub address: *mut ::core::ffi::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_buf_map {
    pub count: ::core::ffi::c_int,
    pub virtual_: *mut ::core::ffi::c_void,
    pub list: *mut drm_buf_pub,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_dma {
    pub context: ::core::ffi::c_int,
    pub send_count: ::core::ffi::c_int,
    pub send_indices: *mut ::core::ffi::c_int,
    pub send_sizes: *mut ::core::ffi::c_int,
    pub flags: drm_dma_flags,
    pub request_count: ::core::ffi::c_int,
    pub request_size: ::core::ffi::c_int,
    pub request_indices: *mut ::core::ffi::c_int,
    pub request_sizes: *mut ::core::ffi::c_int,
    pub granted_count: ::core::ffi::c_int,
}
pub const drm_ctx_flags__DRM_CONTEXT_PRESERVED: drm_ctx_flags = 1;
pub const drm_ctx_flags__DRM_CONTEXT_2DONLY: drm_ctx_flags = 2;
pub type drm_ctx_flags = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_ctx {
    pub handle: drm_context_t,
    pub flags: drm_ctx_flags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_ctx_res {
    pub count: ::core::ffi::c_int,
    pub contexts: *mut drm_ctx,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_draw {
    pub handle: drm_drawable_t,
}
pub const drm_drawable_info_type_t_DRM_DRAWABLE_CLIPRECTS: drm_drawable_info_type_t = 0;
pub type drm_drawable_info_type_t = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_update_draw {
    pub handle: drm_drawable_t,
    pub type_: ::core::ffi::c_uint,
    pub num: ::core::ffi::c_uint,
    pub data: ::core::ffi::c_ulonglong,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_auth {
    pub magic: drm_magic_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_irq_busid {
    pub irq: ::core::ffi::c_int,
    pub busnum: ::core::ffi::c_int,
    pub devnum: ::core::ffi::c_int,
    pub funcnum: ::core::ffi::c_int,
}
pub const drm_vblank_seq_type__DRM_VBLANK_ABSOLUTE: drm_vblank_seq_type = 0;
pub const drm_vblank_seq_type__DRM_VBLANK_RELATIVE: drm_vblank_seq_type = 1;
pub const drm_vblank_seq_type__DRM_VBLANK_HIGH_CRTC_MASK: drm_vblank_seq_type = 62;
pub const drm_vblank_seq_type__DRM_VBLANK_EVENT: drm_vblank_seq_type = 67108864;
pub const drm_vblank_seq_type__DRM_VBLANK_FLIP: drm_vblank_seq_type = 134217728;
pub const drm_vblank_seq_type__DRM_VBLANK_NEXTONMISS: drm_vblank_seq_type = 268435456;
pub const drm_vblank_seq_type__DRM_VBLANK_SECONDARY: drm_vblank_seq_type = 536870912;
pub const drm_vblank_seq_type__DRM_VBLANK_SIGNAL: drm_vblank_seq_type = 1073741824;
pub type drm_vblank_seq_type = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_wait_vblank_request {
    pub type_: drm_vblank_seq_type,
    pub sequence: ::core::ffi::c_uint,
    pub signal: ::core::ffi::c_ulong,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_wait_vblank_reply {
    pub type_: drm_vblank_seq_type,
    pub sequence: ::core::ffi::c_uint,
    pub tval_sec: ::core::ffi::c_long,
    pub tval_usec: ::core::ffi::c_long,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_wait_vblank {
    pub request: drm_wait_vblank_request,
    pub reply: drm_wait_vblank_reply,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_modeset_ctl {
    pub crtc: __u32,
    pub cmd: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_agp_mode {
    pub mode: ::core::ffi::c_ulong,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_agp_buffer {
    pub size: ::core::ffi::c_ulong,
    pub handle: ::core::ffi::c_ulong,
    pub type_: ::core::ffi::c_ulong,
    pub physical: ::core::ffi::c_ulong,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_agp_binding {
    pub handle: ::core::ffi::c_ulong,
    pub offset: ::core::ffi::c_ulong,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_agp_info {
    pub agp_version_major: ::core::ffi::c_int,
    pub agp_version_minor: ::core::ffi::c_int,
    pub mode: ::core::ffi::c_ulong,
    pub aperture_base: ::core::ffi::c_ulong,
    pub aperture_size: ::core::ffi::c_ulong,
    pub memory_allowed: ::core::ffi::c_ulong,
    pub memory_used: ::core::ffi::c_ulong,
    pub id_vendor: ::core::ffi::c_ushort,
    pub id_device: ::core::ffi::c_ushort,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_scatter_gather {
    pub size: ::core::ffi::c_ulong,
    pub handle: ::core::ffi::c_ulong,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_set_version {
    pub drm_di_major: ::core::ffi::c_int,
    pub drm_di_minor: ::core::ffi::c_int,
    pub drm_dd_major: ::core::ffi::c_int,
    pub drm_dd_minor: ::core::ffi::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_gem_close {
    pub handle: __u32,
    pub pad: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_gem_flink {
    pub handle: __u32,
    pub name: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_gem_open {
    pub name: __u32,
    pub handle: __u32,
    pub size: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_get_cap {
    pub capability: __u64,
    pub value: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_set_client_cap {
    pub capability: __u64,
    pub value: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_prime_handle {
    pub handle: __u32,
    pub flags: __u32,
    pub fd: __s32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_syncobj_create {
    pub handle: __u32,
    pub flags: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_syncobj_destroy {
    pub handle: __u32,
    pub pad: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_syncobj_handle {
    pub handle: __u32,
    pub flags: __u32,
    pub fd: __s32,
    pub pad: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_syncobj_transfer {
    pub src_handle: __u32,
    pub dst_handle: __u32,
    pub src_point: __u64,
    pub dst_point: __u64,
    pub flags: __u32,
    pub pad: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_syncobj_wait {
    pub handles: __u64,
    pub timeout_nsec: __s64,
    pub count_handles: __u32,
    pub flags: __u32,
    pub first_signaled: __u32,
    pub pad: __u32,
    pub deadline_nsec: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_syncobj_timeline_wait {
    pub handles: __u64,
    pub points: __u64,
    pub timeout_nsec: __s64,
    pub count_handles: __u32,
    pub flags: __u32,
    pub first_signaled: __u32,
    pub pad: __u32,
    pub deadline_nsec: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_syncobj_eventfd {
    pub handle: __u32,
    pub flags: __u32,
    pub point: __u64,
    pub fd: __s32,
    pub pad: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_syncobj_array {
    pub handles: __u64,
    pub count_handles: __u32,
    pub pad: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_syncobj_timeline_array {
    pub handles: __u64,
    pub points: __u64,
    pub count_handles: __u32,
    pub flags: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_crtc_get_sequence {
    pub crtc_id: __u32,
    pub active: __u32,
    pub sequence: __u64,
    pub sequence_ns: __s64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_crtc_queue_sequence {
    pub crtc_id: __u32,
    pub flags: __u32,
    pub sequence: __u64,
    pub user_data: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_modeinfo {
    pub clock: __u32,
    pub hdisplay: __u16,
    pub hsync_start: __u16,
    pub hsync_end: __u16,
    pub htotal: __u16,
    pub hskew: __u16,
    pub vdisplay: __u16,
    pub vsync_start: __u16,
    pub vsync_end: __u16,
    pub vtotal: __u16,
    pub vscan: __u16,
    pub vrefresh: __u32,
    pub flags: __u32,
    pub type_: __u32,
    pub name: [::core::ffi::c_char; 32usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_card_res {
    pub fb_id_ptr: __u64,
    pub crtc_id_ptr: __u64,
    pub connector_id_ptr: __u64,
    pub encoder_id_ptr: __u64,
    pub count_fbs: __u32,
    pub count_crtcs: __u32,
    pub count_connectors: __u32,
    pub count_encoders: __u32,
    pub min_width: __u32,
    pub max_width: __u32,
    pub min_height: __u32,
    pub max_height: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_crtc {
    pub set_connectors_ptr: __u64,
    pub count_connectors: __u32,
    pub crtc_id: __u32,
    pub fb_id: __u32,
    pub x: __u32,
    pub y: __u32,
    pub gamma_size: __u32,
    pub mode_valid: __u32,
    pub mode: drm_mode_modeinfo,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_set_plane {
    pub plane_id: __u32,
    pub crtc_id: __u32,
    pub fb_id: __u32,
    pub flags: __u32,
    pub crtc_x: __s32,
    pub crtc_y: __s32,
    pub crtc_w: __u32,
    pub crtc_h: __u32,
    pub src_x: __u32,
    pub src_y: __u32,
    pub src_h: __u32,
    pub src_w: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_get_plane {
    pub plane_id: __u32,
    pub crtc_id: __u32,
    pub fb_id: __u32,
    pub possible_crtcs: __u32,
    pub gamma_size: __u32,
    pub count_format_types: __u32,
    pub format_type_ptr: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_get_plane_res {
    pub plane_id_ptr: __u64,
    pub count_planes: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_get_encoder {
    pub encoder_id: __u32,
    pub encoder_type: __u32,
    pub crtc_id: __u32,
    pub possible_crtcs: __u32,
    pub possible_clones: __u32,
}
pub const drm_mode_subconnector_DRM_MODE_SUBCONNECTOR_Automatic: drm_mode_subconnector = 0;
pub const drm_mode_subconnector_DRM_MODE_SUBCONNECTOR_Unknown: drm_mode_subconnector = 0;
pub const drm_mode_subconnector_DRM_MODE_SUBCONNECTOR_VGA: drm_mode_subconnector = 1;
pub const drm_mode_subconnector_DRM_MODE_SUBCONNECTOR_DVID: drm_mode_subconnector = 3;
pub const drm_mode_subconnector_DRM_MODE_SUBCONNECTOR_DVIA: drm_mode_subconnector = 4;
pub const drm_mode_subconnector_DRM_MODE_SUBCONNECTOR_Composite: drm_mode_subconnector = 5;
pub const drm_mode_subconnector_DRM_MODE_SUBCONNECTOR_SVIDEO: drm_mode_subconnector = 6;
pub const drm_mode_subconnector_DRM_MODE_SUBCONNECTOR_Component: drm_mode_subconnector = 8;
pub const drm_mode_subconnector_DRM_MODE_SUBCONNECTOR_SCART: drm_mode_subconnector = 9;
pub const drm_mode_subconnector_DRM_MODE_SUBCONNECTOR_DisplayPort: drm_mode_subconnector = 10;
pub const drm_mode_subconnector_DRM_MODE_SUBCONNECTOR_HDMIA: drm_mode_subconnector = 11;
pub const drm_mode_subconnector_DRM_MODE_SUBCONNECTOR_Native: drm_mode_subconnector = 15;
pub const drm_mode_subconnector_DRM_MODE_SUBCONNECTOR_Wireless: drm_mode_subconnector = 18;
pub type drm_mode_subconnector = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_get_connector {
    pub encoders_ptr: __u64,
    pub modes_ptr: __u64,
    pub props_ptr: __u64,
    pub prop_values_ptr: __u64,
    pub count_modes: __u32,
    pub count_props: __u32,
    pub count_encoders: __u32,
    pub encoder_id: __u32,
    pub connector_id: __u32,
    pub connector_type: __u32,
    pub connector_type_id: __u32,
    pub connection: __u32,
    pub mm_width: __u32,
    pub mm_height: __u32,
    pub subpixel: __u32,
    pub pad: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_property_enum {
    pub value: __u64,
    pub name: [::core::ffi::c_char; 32usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_get_property {
    pub values_ptr: __u64,
    pub enum_blob_ptr: __u64,
    pub prop_id: __u32,
    pub flags: __u32,
    pub name: [::core::ffi::c_char; 32usize],
    pub count_values: __u32,
    pub count_enum_blobs: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_connector_set_property {
    pub value: __u64,
    pub prop_id: __u32,
    pub connector_id: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_obj_get_properties {
    pub props_ptr: __u64,
    pub prop_values_ptr: __u64,
    pub count_props: __u32,
    pub obj_id: __u32,
    pub obj_type: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_obj_set_property {
    pub value: __u64,
    pub prop_id: __u32,
    pub obj_id: __u32,
    pub obj_type: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_get_blob {
    pub blob_id: __u32,
    pub length: __u32,
    pub data: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_fb_cmd {
    pub fb_id: __u32,
    pub width: __u32,
    pub height: __u32,
    pub pitch: __u32,
    pub bpp: __u32,
    pub depth: __u32,
    pub handle: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_fb_cmd2 {
    pub fb_id: __u32,
    pub width: __u32,
    pub height: __u32,
    pub pixel_format: __u32,
    pub flags: __u32,
    pub handles: [__u32; 4usize],
    pub pitches: [__u32; 4usize],
    pub offsets: [__u32; 4usize],
    pub modifier: [__u64; 4usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_fb_dirty_cmd {
    pub fb_id: __u32,
    pub flags: __u32,
    pub color: __u32,
    pub num_clips: __u32,
    pub clips_ptr: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_mode_cmd {
    pub connector_id: __u32,
    pub mode: drm_mode_modeinfo,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_cursor {
    pub flags: __u32,
    pub crtc_id: __u32,
    pub x: __s32,
    pub y: __s32,
    pub width: __u32,
    pub height: __u32,
    pub handle: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_cursor2 {
    pub flags: __u32,
    pub crtc_id: __u32,
    pub x: __s32,
    pub y: __s32,
    pub width: __u32,
    pub height: __u32,
    pub handle: __u32,
    pub hot_x: __s32,
    pub hot_y: __s32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_crtc_lut {
    pub crtc_id: __u32,
    pub gamma_size: __u32,
    pub red: __u64,
    pub green: __u64,
    pub blue: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_color_ctm {
    pub matrix: [__u64; 9usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_color_lut {
    pub red: __u16,
    pub green: __u16,
    pub blue: __u16,
    pub reserved: __u16,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_plane_size_hint {
    pub width: __u16,
    pub height: __u16,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hdr_metadata_infoframe {
    pub eotf: __u8,
    pub metadata_type: __u8,
    pub display_primaries: [hdr_metadata_infoframe__bindgen_ty_1; 3usize],
    pub white_point: hdr_metadata_infoframe__bindgen_ty_2,
    pub max_display_mastering_luminance: __u16,
    pub min_display_mastering_luminance: __u16,
    pub max_cll: __u16,
    pub max_fall: __u16,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hdr_metadata_infoframe__bindgen_ty_1 {
    pub x: __u16,
    pub y: __u16,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hdr_metadata_infoframe__bindgen_ty_2 {
    pub x: __u16,
    pub y: __u16,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hdr_output_metadata {
    pub metadata_type: __u32,
    pub __bindgen_anon_1: hdr_output_metadata__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union hdr_output_metadata__bindgen_ty_1 {
    pub hdmi_metadata_type1: hdr_metadata_infoframe,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_crtc_page_flip {
    pub crtc_id: __u32,
    pub fb_id: __u32,
    pub flags: __u32,
    pub reserved: __u32,
    pub user_data: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_crtc_page_flip_target {
    pub crtc_id: __u32,
    pub fb_id: __u32,
    pub flags: __u32,
    pub sequence: __u32,
    pub user_data: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_create_dumb {
    pub height: __u32,
    pub width: __u32,
    pub bpp: __u32,
    pub flags: __u32,
    pub handle: __u32,
    pub pitch: __u32,
    pub size: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_map_dumb {
    pub handle: __u32,
    pub pad: __u32,
    pub offset: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_destroy_dumb {
    pub handle: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_atomic {
    pub flags: __u32,
    pub count_objs: __u32,
    pub objs_ptr: __u64,
    pub count_props_ptr: __u64,
    pub props_ptr: __u64,
    pub prop_values_ptr: __u64,
    pub reserved: __u64,
    pub user_data: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_format_modifier_blob {
    pub version: __u32,
    pub flags: __u32,
    pub count_formats: __u32,
    pub formats_offset: __u32,
    pub count_modifiers: __u32,
    pub modifiers_offset: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_format_modifier {
    pub formats: __u64,
    pub offset: __u32,
    pub pad: __u32,
    pub modifier: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_create_blob {
    pub data: __u64,
    pub length: __u32,
    pub blob_id: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_destroy_blob {
    pub blob_id: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_create_lease {
    pub object_ids: __u64,
    pub object_count: __u32,
    pub flags: __u32,
    pub lessee_id: __u32,
    pub fd: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_list_lessees {
    pub count_lessees: __u32,
    pub pad: __u32,
    pub lessees_ptr: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_get_lease {
    pub count_objects: __u32,
    pub pad: __u32,
    pub objects_ptr: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_revoke_lease {
    pub lessee_id: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_rect {
    pub x1: __s32,
    pub y1: __s32,
    pub x2: __s32,
    pub y2: __s32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_closefb {
    pub fb_id: __u32,
    pub pad: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_event {
    pub type_: __u32,
    pub length: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_event_vblank {
    pub base: drm_event,
    pub user_data: __u64,
    pub tv_sec: __u32,
    pub tv_usec: __u32,
    pub sequence: __u32,
    pub crtc_id: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_event_crtc_sequence {
    pub base: drm_event,
    pub user_data: __u64,
    pub time_ns: __s64,
    pub sequence: __u64,
}
pub type drm_clip_rect_t = drm_clip_rect;
pub type drm_drawable_info_t = drm_drawable_info;
pub type drm_tex_region_t = drm_tex_region;
pub type drm_hw_lock_t = drm_hw_lock;
pub type drm_version_t = drm_version;
pub type drm_unique_t = drm_unique;
pub type drm_list_t = drm_list;
pub type drm_block_t = drm_block;
pub type drm_control_t = drm_control;
pub use self::drm_map_flags as drm_map_flags_t;
pub use self::drm_map_type as drm_map_type_t;
pub type drm_ctx_priv_map_t = drm_ctx_priv_map;
pub type drm_map_t = drm_map;
pub type drm_client_t = drm_client;
pub use self::drm_stat_type as drm_stat_type_t;
pub type drm_stats_t = drm_stats;
pub use self::drm_lock_flags as drm_lock_flags_t;
pub type drm_lock_t = drm_lock;
pub use self::drm_dma_flags as drm_dma_flags_t;
pub type drm_buf_desc_t = drm_buf_desc;
pub type drm_buf_info_t = drm_buf_info;
pub type drm_buf_free_t = drm_buf_free;
pub type drm_buf_pub_t = drm_buf_pub;
pub type drm_buf_map_t = drm_buf_map;
pub type drm_dma_t = drm_dma;
pub type drm_wait_vblank_t = drm_wait_vblank;
pub type drm_agp_mode_t = drm_agp_mode;
pub use self::drm_ctx_flags as drm_ctx_flags_t;
pub type drm_ctx_t = drm_ctx;
pub type drm_ctx_res_t = drm_ctx_res;
pub type drm_draw_t = drm_draw;
pub type drm_update_draw_t = drm_update_draw;
pub type drm_auth_t = drm_auth;
pub type drm_irq_busid_t = drm_irq_busid;
pub use self::drm_vblank_seq_type as drm_vblank_seq_type_t;
pub type drm_agp_buffer_t = drm_agp_buffer;
pub type drm_agp_binding_t = drm_agp_binding;
pub type drm_agp_info_t = drm_agp_info;
pub type drm_scatter_gather_t = drm_scatter_gather;
pub type drm_set_version_t = drm_set_version;
pub type drmSize = ::core::ffi::c_uint;
pub type drmSizePtr = *mut ::core::ffi::c_uint;
pub type drmAddress = *mut ::core::ffi::c_void;
pub type drmAddressPtr = *mut *mut ::core::ffi::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmServerInfo {
    pub debug_print: ::core::option::Option<
        unsafe extern "C" fn(
            format: *const ::core::ffi::c_char,
            ap: *mut __va_list_tag,
        ) -> ::core::ffi::c_int,
    >,
    pub load_module: ::core::option::Option<
        unsafe extern "C" fn(name: *const ::core::ffi::c_char) -> ::core::ffi::c_int,
    >,
    pub get_perms:
        ::core::option::Option<unsafe extern "C" fn(arg1: *mut gid_t, arg2: *mut mode_t)>,
}
pub type drmServerInfo = _drmServerInfo;
pub type drmServerInfoPtr = *mut _drmServerInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drmHashEntry {
    pub fd: ::core::ffi::c_int,
    pub f: ::core::option::Option<
        unsafe extern "C" fn(
            arg1: ::core::ffi::c_int,
            arg2: *mut ::core::ffi::c_void,
            arg3: *mut ::core::ffi::c_void,
        ),
    >,
    pub tagTable: *mut ::core::ffi::c_void,
}
unsafe extern "C" {
    pub fn drmIoctl(
        fd: ::core::ffi::c_int,
        request: ::core::ffi::c_ulong,
        arg: *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmGetHashTable() -> *mut ::core::ffi::c_void;
}
unsafe extern "C" {
    pub fn drmGetEntry(fd: ::core::ffi::c_int) -> *mut drmHashEntry;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmVersion {
    pub version_major: ::core::ffi::c_int,
    pub version_minor: ::core::ffi::c_int,
    pub version_patchlevel: ::core::ffi::c_int,
    pub name_len: ::core::ffi::c_int,
    pub name: *mut ::core::ffi::c_char,
    pub date_len: ::core::ffi::c_int,
    pub date: *mut ::core::ffi::c_char,
    pub desc_len: ::core::ffi::c_int,
    pub desc: *mut ::core::ffi::c_char,
}
pub type drmVersion = _drmVersion;
pub type drmVersionPtr = *mut _drmVersion;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmStats {
    pub count: ::core::ffi::c_ulong,
    pub data: [_drmStats__bindgen_ty_1; 15usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmStats__bindgen_ty_1 {
    pub value: ::core::ffi::c_ulong,
    pub long_format: *const ::core::ffi::c_char,
    pub long_name: *const ::core::ffi::c_char,
    pub rate_format: *const ::core::ffi::c_char,
    pub rate_name: *const ::core::ffi::c_char,
    pub isvalue: ::core::ffi::c_int,
    pub mult_names: *const ::core::ffi::c_char,
    pub mult: ::core::ffi::c_int,
    pub verbose: ::core::ffi::c_int,
}
pub type drmStatsT = _drmStats;
pub const drmMapType_DRM_FRAME_BUFFER: drmMapType = 0;
pub const drmMapType_DRM_REGISTERS: drmMapType = 1;
pub const drmMapType_DRM_SHM: drmMapType = 2;
pub const drmMapType_DRM_AGP: drmMapType = 3;
pub const drmMapType_DRM_SCATTER_GATHER: drmMapType = 4;
pub const drmMapType_DRM_CONSISTENT: drmMapType = 5;
pub type drmMapType = ::core::ffi::c_uint;
pub const drmMapFlags_DRM_RESTRICTED: drmMapFlags = 1;
pub const drmMapFlags_DRM_READ_ONLY: drmMapFlags = 2;
pub const drmMapFlags_DRM_LOCKED: drmMapFlags = 4;
pub const drmMapFlags_DRM_KERNEL: drmMapFlags = 8;
pub const drmMapFlags_DRM_WRITE_COMBINING: drmMapFlags = 16;
pub const drmMapFlags_DRM_CONTAINS_LOCK: drmMapFlags = 32;
pub const drmMapFlags_DRM_REMOVABLE: drmMapFlags = 64;
pub type drmMapFlags = ::core::ffi::c_uint;
pub const drmDMAFlags_DRM_DMA_BLOCK: drmDMAFlags = 1;
pub const drmDMAFlags_DRM_DMA_WHILE_LOCKED: drmDMAFlags = 2;
pub const drmDMAFlags_DRM_DMA_PRIORITY: drmDMAFlags = 4;
pub const drmDMAFlags_DRM_DMA_WAIT: drmDMAFlags = 16;
pub const drmDMAFlags_DRM_DMA_SMALLER_OK: drmDMAFlags = 32;
pub const drmDMAFlags_DRM_DMA_LARGER_OK: drmDMAFlags = 64;
pub type drmDMAFlags = ::core::ffi::c_uint;
pub const drmBufDescFlags_DRM_PAGE_ALIGN: drmBufDescFlags = 1;
pub const drmBufDescFlags_DRM_AGP_BUFFER: drmBufDescFlags = 2;
pub const drmBufDescFlags_DRM_SG_BUFFER: drmBufDescFlags = 4;
pub const drmBufDescFlags_DRM_FB_BUFFER: drmBufDescFlags = 8;
pub const drmBufDescFlags_DRM_PCI_BUFFER_RO: drmBufDescFlags = 16;
pub type drmBufDescFlags = ::core::ffi::c_uint;
pub const drmLockFlags_DRM_LOCK_READY: drmLockFlags = 1;
pub const drmLockFlags_DRM_LOCK_QUIESCENT: drmLockFlags = 2;
pub const drmLockFlags_DRM_LOCK_FLUSH: drmLockFlags = 4;
pub const drmLockFlags_DRM_LOCK_FLUSH_ALL: drmLockFlags = 8;
pub const drmLockFlags_DRM_HALT_ALL_QUEUES: drmLockFlags = 16;
pub const drmLockFlags_DRM_HALT_CUR_QUEUES: drmLockFlags = 32;
pub type drmLockFlags = ::core::ffi::c_uint;
pub const drm_context_tFlags_DRM_CONTEXT_PRESERVED: drm_context_tFlags = 1;
pub const drm_context_tFlags_DRM_CONTEXT_2DONLY: drm_context_tFlags = 2;
pub type drm_context_tFlags = ::core::ffi::c_uint;
pub type drm_context_tFlagsPtr = *mut drm_context_tFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmBufDesc {
    pub count: ::core::ffi::c_int,
    pub size: ::core::ffi::c_int,
    pub low_mark: ::core::ffi::c_int,
    pub high_mark: ::core::ffi::c_int,
}
pub type drmBufDesc = _drmBufDesc;
pub type drmBufDescPtr = *mut _drmBufDesc;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmBufInfo {
    pub count: ::core::ffi::c_int,
    pub list: drmBufDescPtr,
}
pub type drmBufInfo = _drmBufInfo;
pub type drmBufInfoPtr = *mut _drmBufInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmBuf {
    pub idx: ::core::ffi::c_int,
    pub total: ::core::ffi::c_int,
    pub used: ::core::ffi::c_int,
    pub address: drmAddress,
}
pub type drmBuf = _drmBuf;
pub type drmBufPtr = *mut _drmBuf;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmBufMap {
    pub count: ::core::ffi::c_int,
    pub list: drmBufPtr,
}
pub type drmBufMap = _drmBufMap;
pub type drmBufMapPtr = *mut _drmBufMap;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmLock {
    pub lock: ::core::ffi::c_uint,
    pub padding: [::core::ffi::c_char; 60usize],
}
pub type drmLock = _drmLock;
pub type drmLockPtr = *mut _drmLock;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmDMAReq {
    pub context: drm_context_t,
    pub send_count: ::core::ffi::c_int,
    pub send_list: *mut ::core::ffi::c_int,
    pub send_sizes: *mut ::core::ffi::c_int,
    pub flags: drmDMAFlags,
    pub request_count: ::core::ffi::c_int,
    pub request_size: ::core::ffi::c_int,
    pub request_list: *mut ::core::ffi::c_int,
    pub request_sizes: *mut ::core::ffi::c_int,
    pub granted_count: ::core::ffi::c_int,
}
pub type drmDMAReq = _drmDMAReq;
pub type drmDMAReqPtr = *mut _drmDMAReq;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmRegion {
    pub handle: drm_handle_t,
    pub offset: ::core::ffi::c_uint,
    pub size: drmSize,
    pub map: drmAddress,
}
pub type drmRegion = _drmRegion;
pub type drmRegionPtr = *mut _drmRegion;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmTextureRegion {
    pub next: ::core::ffi::c_uchar,
    pub prev: ::core::ffi::c_uchar,
    pub in_use: ::core::ffi::c_uchar,
    pub padding: ::core::ffi::c_uchar,
    pub age: ::core::ffi::c_uint,
}
pub type drmTextureRegion = _drmTextureRegion;
pub type drmTextureRegionPtr = *mut _drmTextureRegion;
pub const drmVBlankSeqType_DRM_VBLANK_ABSOLUTE: drmVBlankSeqType = 0;
pub const drmVBlankSeqType_DRM_VBLANK_RELATIVE: drmVBlankSeqType = 1;
pub const drmVBlankSeqType_DRM_VBLANK_HIGH_CRTC_MASK: drmVBlankSeqType = 62;
pub const drmVBlankSeqType_DRM_VBLANK_EVENT: drmVBlankSeqType = 67108864;
pub const drmVBlankSeqType_DRM_VBLANK_FLIP: drmVBlankSeqType = 134217728;
pub const drmVBlankSeqType_DRM_VBLANK_NEXTONMISS: drmVBlankSeqType = 268435456;
pub const drmVBlankSeqType_DRM_VBLANK_SECONDARY: drmVBlankSeqType = 536870912;
pub const drmVBlankSeqType_DRM_VBLANK_SIGNAL: drmVBlankSeqType = 1073741824;
pub type drmVBlankSeqType = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmVBlankReq {
    pub type_: drmVBlankSeqType,
    pub sequence: ::core::ffi::c_uint,
    pub signal: ::core::ffi::c_ulong,
}
pub type drmVBlankReq = _drmVBlankReq;
pub type drmVBlankReqPtr = *mut _drmVBlankReq;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmVBlankReply {
    pub type_: drmVBlankSeqType,
    pub sequence: ::core::ffi::c_uint,
    pub tval_sec: ::core::ffi::c_long,
    pub tval_usec: ::core::ffi::c_long,
}
pub type drmVBlankReply = _drmVBlankReply;
pub type drmVBlankReplyPtr = *mut _drmVBlankReply;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _drmVBlank {
    pub request: drmVBlankReq,
    pub reply: drmVBlankReply,
}
pub type drmVBlank = _drmVBlank;
pub type drmVBlankPtr = *mut _drmVBlank;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmSetVersion {
    pub drm_di_major: ::core::ffi::c_int,
    pub drm_di_minor: ::core::ffi::c_int,
    pub drm_dd_major: ::core::ffi::c_int,
    pub drm_dd_minor: ::core::ffi::c_int,
}
pub type drmSetVersion = _drmSetVersion;
pub type drmSetVersionPtr = *mut _drmSetVersion;
unsafe extern "C" {
    pub fn drmAvailable() -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmOpen(
        name: *const ::core::ffi::c_char,
        busid: *const ::core::ffi::c_char,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmOpenWithType(
        name: *const ::core::ffi::c_char,
        busid: *const ::core::ffi::c_char,
        type_: ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmOpenControl(minor: ::core::ffi::c_int) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmOpenRender(minor: ::core::ffi::c_int) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmClose(fd: ::core::ffi::c_int) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmGetVersion(fd: ::core::ffi::c_int) -> drmVersionPtr;
}
unsafe extern "C" {
    pub fn drmGetLibVersion(fd: ::core::ffi::c_int) -> drmVersionPtr;
}
unsafe extern "C" {
    pub fn drmGetCap(
        fd: ::core::ffi::c_int,
        capability: u64,
        value: *mut u64,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmFreeVersion(arg1: drmVersionPtr);
}
unsafe extern "C" {
    pub fn drmGetMagic(fd: ::core::ffi::c_int, magic: *mut drm_magic_t) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmGetBusid(fd: ::core::ffi::c_int) -> *mut ::core::ffi::c_char;
}
unsafe extern "C" {
    pub fn drmGetInterruptFromBusID(
        fd: ::core::ffi::c_int,
        busnum: ::core::ffi::c_int,
        devnum: ::core::ffi::c_int,
        funcnum: ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmGetMap(
        fd: ::core::ffi::c_int,
        idx: ::core::ffi::c_int,
        offset: *mut drm_handle_t,
        size: *mut drmSize,
        type_: *mut drmMapType,
        flags: *mut drmMapFlags,
        handle: *mut drm_handle_t,
        mtrr: *mut ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmGetClient(
        fd: ::core::ffi::c_int,
        idx: ::core::ffi::c_int,
        auth: *mut ::core::ffi::c_int,
        pid: *mut ::core::ffi::c_int,
        uid: *mut ::core::ffi::c_int,
        magic: *mut ::core::ffi::c_ulong,
        iocs: *mut ::core::ffi::c_ulong,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmGetStats(fd: ::core::ffi::c_int, stats: *mut drmStatsT) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmSetInterfaceVersion(
        fd: ::core::ffi::c_int,
        version: *mut drmSetVersion,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmCommandNone(
        fd: ::core::ffi::c_int,
        drmCommandIndex: ::core::ffi::c_ulong,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmCommandRead(
        fd: ::core::ffi::c_int,
        drmCommandIndex: ::core::ffi::c_ulong,
        data: *mut ::core::ffi::c_void,
        size: ::core::ffi::c_ulong,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmCommandWrite(
        fd: ::core::ffi::c_int,
        drmCommandIndex: ::core::ffi::c_ulong,
        data: *mut ::core::ffi::c_void,
        size: ::core::ffi::c_ulong,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmCommandWriteRead(
        fd: ::core::ffi::c_int,
        drmCommandIndex: ::core::ffi::c_ulong,
        data: *mut ::core::ffi::c_void,
        size: ::core::ffi::c_ulong,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmFreeBusid(busid: *const ::core::ffi::c_char);
}
unsafe extern "C" {
    pub fn drmSetBusid(
        fd: ::core::ffi::c_int,
        busid: *const ::core::ffi::c_char,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmAuthMagic(fd: ::core::ffi::c_int, magic: drm_magic_t) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmAddMap(
        fd: ::core::ffi::c_int,
        offset: drm_handle_t,
        size: drmSize,
        type_: drmMapType,
        flags: drmMapFlags,
        handle: *mut drm_handle_t,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmRmMap(fd: ::core::ffi::c_int, handle: drm_handle_t) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmAddContextPrivateMapping(
        fd: ::core::ffi::c_int,
        ctx_id: drm_context_t,
        handle: drm_handle_t,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmAddBufs(
        fd: ::core::ffi::c_int,
        count: ::core::ffi::c_int,
        size: ::core::ffi::c_int,
        flags: drmBufDescFlags,
        agp_offset: ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmMarkBufs(fd: ::core::ffi::c_int, low: f64, high: f64) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmCreateContext(
        fd: ::core::ffi::c_int,
        handle: *mut drm_context_t,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmSetContextFlags(
        fd: ::core::ffi::c_int,
        context: drm_context_t,
        flags: drm_context_tFlags,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmGetContextFlags(
        fd: ::core::ffi::c_int,
        context: drm_context_t,
        flags: drm_context_tFlagsPtr,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmAddContextTag(
        fd: ::core::ffi::c_int,
        context: drm_context_t,
        tag: *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmDelContextTag(fd: ::core::ffi::c_int, context: drm_context_t) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmGetContextTag(
        fd: ::core::ffi::c_int,
        context: drm_context_t,
    ) -> *mut ::core::ffi::c_void;
}
unsafe extern "C" {
    pub fn drmGetReservedContextList(
        fd: ::core::ffi::c_int,
        count: *mut ::core::ffi::c_int,
    ) -> *mut drm_context_t;
}
unsafe extern "C" {
    pub fn drmFreeReservedContextList(arg1: *mut drm_context_t);
}
unsafe extern "C" {
    pub fn drmSwitchToContext(fd: ::core::ffi::c_int, context: drm_context_t)
    -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmDestroyContext(fd: ::core::ffi::c_int, handle: drm_context_t) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmCreateDrawable(
        fd: ::core::ffi::c_int,
        handle: *mut drm_drawable_t,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmDestroyDrawable(fd: ::core::ffi::c_int, handle: drm_drawable_t)
    -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmUpdateDrawableInfo(
        fd: ::core::ffi::c_int,
        handle: drm_drawable_t,
        type_: drm_drawable_info_type_t,
        num: ::core::ffi::c_uint,
        data: *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmCtlInstHandler(fd: ::core::ffi::c_int, irq: ::core::ffi::c_int)
    -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmCtlUninstHandler(fd: ::core::ffi::c_int) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmSetClientCap(
        fd: ::core::ffi::c_int,
        capability: u64,
        value: u64,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmCrtcGetSequence(
        fd: ::core::ffi::c_int,
        crtcId: u32,
        sequence: *mut u64,
        ns: *mut u64,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmCrtcQueueSequence(
        fd: ::core::ffi::c_int,
        crtcId: u32,
        flags: u32,
        sequence: u64,
        sequence_queued: *mut u64,
        user_data: u64,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmMap(
        fd: ::core::ffi::c_int,
        handle: drm_handle_t,
        size: drmSize,
        address: drmAddressPtr,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmUnmap(address: drmAddress, size: drmSize) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmGetBufInfo(fd: ::core::ffi::c_int) -> drmBufInfoPtr;
}
unsafe extern "C" {
    pub fn drmMapBufs(fd: ::core::ffi::c_int) -> drmBufMapPtr;
}
unsafe extern "C" {
    pub fn drmUnmapBufs(bufs: drmBufMapPtr) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmDMA(fd: ::core::ffi::c_int, request: drmDMAReqPtr) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmFreeBufs(
        fd: ::core::ffi::c_int,
        count: ::core::ffi::c_int,
        list: *mut ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmGetLock(
        fd: ::core::ffi::c_int,
        context: drm_context_t,
        flags: drmLockFlags,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmUnlock(fd: ::core::ffi::c_int, context: drm_context_t) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmFinish(
        fd: ::core::ffi::c_int,
        context: ::core::ffi::c_int,
        flags: drmLockFlags,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmGetContextPrivateMapping(
        fd: ::core::ffi::c_int,
        ctx_id: drm_context_t,
        handle: *mut drm_handle_t,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmAgpAcquire(fd: ::core::ffi::c_int) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmAgpRelease(fd: ::core::ffi::c_int) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmAgpEnable(fd: ::core::ffi::c_int, mode: ::core::ffi::c_ulong) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmAgpAlloc(
        fd: ::core::ffi::c_int,
        size: ::core::ffi::c_ulong,
        type_: ::core::ffi::c_ulong,
        address: *mut ::core::ffi::c_ulong,
        handle: *mut drm_handle_t,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmAgpFree(fd: ::core::ffi::c_int, handle: drm_handle_t) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmAgpBind(
        fd: ::core::ffi::c_int,
        handle: drm_handle_t,
        offset: ::core::ffi::c_ulong,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmAgpUnbind(fd: ::core::ffi::c_int, handle: drm_handle_t) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmAgpVersionMajor(fd: ::core::ffi::c_int) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmAgpVersionMinor(fd: ::core::ffi::c_int) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmAgpGetMode(fd: ::core::ffi::c_int) -> ::core::ffi::c_ulong;
}
unsafe extern "C" {
    pub fn drmAgpBase(fd: ::core::ffi::c_int) -> ::core::ffi::c_ulong;
}
unsafe extern "C" {
    pub fn drmAgpSize(fd: ::core::ffi::c_int) -> ::core::ffi::c_ulong;
}
unsafe extern "C" {
    pub fn drmAgpMemoryUsed(fd: ::core::ffi::c_int) -> ::core::ffi::c_ulong;
}
unsafe extern "C" {
    pub fn drmAgpMemoryAvail(fd: ::core::ffi::c_int) -> ::core::ffi::c_ulong;
}
unsafe extern "C" {
    pub fn drmAgpVendorId(fd: ::core::ffi::c_int) -> ::core::ffi::c_uint;
}
unsafe extern "C" {
    pub fn drmAgpDeviceId(fd: ::core::ffi::c_int) -> ::core::ffi::c_uint;
}
unsafe extern "C" {
    pub fn drmScatterGatherAlloc(
        fd: ::core::ffi::c_int,
        size: ::core::ffi::c_ulong,
        handle: *mut drm_handle_t,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmScatterGatherFree(fd: ::core::ffi::c_int, handle: drm_handle_t)
    -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmWaitVBlank(fd: ::core::ffi::c_int, vbl: drmVBlankPtr) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmSetServerInfo(info: drmServerInfoPtr);
}
unsafe extern "C" {
    pub fn drmError(
        err: ::core::ffi::c_int,
        label: *const ::core::ffi::c_char,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmMalloc(size: ::core::ffi::c_int) -> *mut ::core::ffi::c_void;
}
unsafe extern "C" {
    pub fn drmFree(pt: *mut ::core::ffi::c_void);
}
unsafe extern "C" {
    pub fn drmHashCreate() -> *mut ::core::ffi::c_void;
}
unsafe extern "C" {
    pub fn drmHashDestroy(t: *mut ::core::ffi::c_void) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmHashLookup(
        t: *mut ::core::ffi::c_void,
        key: ::core::ffi::c_ulong,
        value: *mut *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmHashInsert(
        t: *mut ::core::ffi::c_void,
        key: ::core::ffi::c_ulong,
        value: *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmHashDelete(
        t: *mut ::core::ffi::c_void,
        key: ::core::ffi::c_ulong,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmHashFirst(
        t: *mut ::core::ffi::c_void,
        key: *mut ::core::ffi::c_ulong,
        value: *mut *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmHashNext(
        t: *mut ::core::ffi::c_void,
        key: *mut ::core::ffi::c_ulong,
        value: *mut *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmRandomCreate(seed: ::core::ffi::c_ulong) -> *mut ::core::ffi::c_void;
}
unsafe extern "C" {
    pub fn drmRandomDestroy(state: *mut ::core::ffi::c_void) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmRandom(state: *mut ::core::ffi::c_void) -> ::core::ffi::c_ulong;
}
unsafe extern "C" {
    pub fn drmRandomDouble(state: *mut ::core::ffi::c_void) -> f64;
}
unsafe extern "C" {
    pub fn drmSLCreate() -> *mut ::core::ffi::c_void;
}
unsafe extern "C" {
    pub fn drmSLDestroy(l: *mut ::core::ffi::c_void) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmSLLookup(
        l: *mut ::core::ffi::c_void,
        key: ::core::ffi::c_ulong,
        value: *mut *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmSLInsert(
        l: *mut ::core::ffi::c_void,
        key: ::core::ffi::c_ulong,
        value: *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmSLDelete(
        l: *mut ::core::ffi::c_void,
        key: ::core::ffi::c_ulong,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmSLNext(
        l: *mut ::core::ffi::c_void,
        key: *mut ::core::ffi::c_ulong,
        value: *mut *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmSLFirst(
        l: *mut ::core::ffi::c_void,
        key: *mut ::core::ffi::c_ulong,
        value: *mut *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmSLDump(l: *mut ::core::ffi::c_void);
}
unsafe extern "C" {
    pub fn drmSLLookupNeighbors(
        l: *mut ::core::ffi::c_void,
        key: ::core::ffi::c_ulong,
        prev_key: *mut ::core::ffi::c_ulong,
        prev_value: *mut *mut ::core::ffi::c_void,
        next_key: *mut ::core::ffi::c_ulong,
        next_value: *mut *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmOpenOnce(
        unused: *mut ::core::ffi::c_void,
        BusID: *const ::core::ffi::c_char,
        newlyopened: *mut ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmOpenOnceWithType(
        BusID: *const ::core::ffi::c_char,
        newlyopened: *mut ::core::ffi::c_int,
        type_: ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmCloseOnce(fd: ::core::ffi::c_int);
}
unsafe extern "C" {
    pub fn drmMsg(format: *const ::core::ffi::c_char, ...);
}
unsafe extern "C" {
    pub fn drmSetMaster(fd: ::core::ffi::c_int) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmDropMaster(fd: ::core::ffi::c_int) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmIsMaster(fd: ::core::ffi::c_int) -> ::core::ffi::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmEventContext {
    pub version: ::core::ffi::c_int,
    pub vblank_handler: ::core::option::Option<
        unsafe extern "C" fn(
            fd: ::core::ffi::c_int,
            sequence: ::core::ffi::c_uint,
            tv_sec: ::core::ffi::c_uint,
            tv_usec: ::core::ffi::c_uint,
            user_data: *mut ::core::ffi::c_void,
        ),
    >,
    pub page_flip_handler: ::core::option::Option<
        unsafe extern "C" fn(
            fd: ::core::ffi::c_int,
            sequence: ::core::ffi::c_uint,
            tv_sec: ::core::ffi::c_uint,
            tv_usec: ::core::ffi::c_uint,
            user_data: *mut ::core::ffi::c_void,
        ),
    >,
    pub page_flip_handler2: ::core::option::Option<
        unsafe extern "C" fn(
            fd: ::core::ffi::c_int,
            sequence: ::core::ffi::c_uint,
            tv_sec: ::core::ffi::c_uint,
            tv_usec: ::core::ffi::c_uint,
            crtc_id: ::core::ffi::c_uint,
            user_data: *mut ::core::ffi::c_void,
        ),
    >,
    pub sequence_handler: ::core::option::Option<
        unsafe extern "C" fn(fd: ::core::ffi::c_int, sequence: u64, ns: u64, user_data: u64),
    >,
}
pub type drmEventContext = _drmEventContext;
pub type drmEventContextPtr = *mut _drmEventContext;
unsafe extern "C" {
    pub fn drmHandleEvent(fd: ::core::ffi::c_int, evctx: drmEventContextPtr) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmGetDeviceNameFromFd(fd: ::core::ffi::c_int) -> *mut ::core::ffi::c_char;
}
unsafe extern "C" {
    pub fn drmGetDeviceNameFromFd2(fd: ::core::ffi::c_int) -> *mut ::core::ffi::c_char;
}
unsafe extern "C" {
    pub fn drmGetNodeTypeFromFd(fd: ::core::ffi::c_int) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmPrimeHandleToFD(
        fd: ::core::ffi::c_int,
        handle: u32,
        flags: u32,
        prime_fd: *mut ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmPrimeFDToHandle(
        fd: ::core::ffi::c_int,
        prime_fd: ::core::ffi::c_int,
        handle: *mut u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmCloseBufferHandle(fd: ::core::ffi::c_int, handle: u32) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmGetPrimaryDeviceNameFromFd(fd: ::core::ffi::c_int) -> *mut ::core::ffi::c_char;
}
unsafe extern "C" {
    pub fn drmGetRenderDeviceNameFromFd(fd: ::core::ffi::c_int) -> *mut ::core::ffi::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmPciBusInfo {
    pub domain: u16,
    pub bus: u8,
    pub dev: u8,
    pub func: u8,
}
pub type drmPciBusInfo = _drmPciBusInfo;
pub type drmPciBusInfoPtr = *mut _drmPciBusInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmPciDeviceInfo {
    pub vendor_id: u16,
    pub device_id: u16,
    pub subvendor_id: u16,
    pub subdevice_id: u16,
    pub revision_id: u8,
}
pub type drmPciDeviceInfo = _drmPciDeviceInfo;
pub type drmPciDeviceInfoPtr = *mut _drmPciDeviceInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmUsbBusInfo {
    pub bus: u8,
    pub dev: u8,
}
pub type drmUsbBusInfo = _drmUsbBusInfo;
pub type drmUsbBusInfoPtr = *mut _drmUsbBusInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmUsbDeviceInfo {
    pub vendor: u16,
    pub product: u16,
}
pub type drmUsbDeviceInfo = _drmUsbDeviceInfo;
pub type drmUsbDeviceInfoPtr = *mut _drmUsbDeviceInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmPlatformBusInfo {
    pub fullname: [::core::ffi::c_char; 512usize],
}
pub type drmPlatformBusInfo = _drmPlatformBusInfo;
pub type drmPlatformBusInfoPtr = *mut _drmPlatformBusInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmPlatformDeviceInfo {
    pub compatible: *mut *mut ::core::ffi::c_char,
}
pub type drmPlatformDeviceInfo = _drmPlatformDeviceInfo;
pub type drmPlatformDeviceInfoPtr = *mut _drmPlatformDeviceInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmHost1xBusInfo {
    pub fullname: [::core::ffi::c_char; 512usize],
}
pub type drmHost1xBusInfo = _drmHost1xBusInfo;
pub type drmHost1xBusInfoPtr = *mut _drmHost1xBusInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmHost1xDeviceInfo {
    pub compatible: *mut *mut ::core::ffi::c_char,
}
pub type drmHost1xDeviceInfo = _drmHost1xDeviceInfo;
pub type drmHost1xDeviceInfoPtr = *mut _drmHost1xDeviceInfo;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _drmDevice {
    pub nodes: *mut *mut ::core::ffi::c_char,
    pub available_nodes: ::core::ffi::c_int,
    pub bustype: ::core::ffi::c_int,
    pub businfo: _drmDevice__bindgen_ty_1,
    pub deviceinfo: _drmDevice__bindgen_ty_2,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _drmDevice__bindgen_ty_1 {
    pub pci: drmPciBusInfoPtr,
    pub usb: drmUsbBusInfoPtr,
    pub platform: drmPlatformBusInfoPtr,
    pub host1x: drmHost1xBusInfoPtr,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _drmDevice__bindgen_ty_2 {
    pub pci: drmPciDeviceInfoPtr,
    pub usb: drmUsbDeviceInfoPtr,
    pub platform: drmPlatformDeviceInfoPtr,
    pub host1x: drmHost1xDeviceInfoPtr,
}
pub type drmDevice = _drmDevice;
pub type drmDevicePtr = *mut _drmDevice;
unsafe extern "C" {
    pub fn drmGetDevice(fd: ::core::ffi::c_int, device: *mut drmDevicePtr) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmFreeDevice(device: *mut drmDevicePtr);
}
unsafe extern "C" {
    pub fn drmGetDevices(
        devices: *mut drmDevicePtr,
        max_devices: ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmFreeDevices(devices: *mut drmDevicePtr, count: ::core::ffi::c_int);
}
unsafe extern "C" {
    pub fn drmGetDevice2(
        fd: ::core::ffi::c_int,
        flags: u32,
        device: *mut drmDevicePtr,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmGetDevices2(
        flags: u32,
        devices: *mut drmDevicePtr,
        max_devices: ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmGetDeviceFromDevId(
        dev_id: dev_t,
        flags: u32,
        device: *mut drmDevicePtr,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmGetNodeTypeFromDevId(devid: dev_t) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmDevicesEqual(a: drmDevicePtr, b: drmDevicePtr) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmSyncobjCreate(
        fd: ::core::ffi::c_int,
        flags: u32,
        handle: *mut u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmSyncobjDestroy(fd: ::core::ffi::c_int, handle: u32) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmSyncobjHandleToFD(
        fd: ::core::ffi::c_int,
        handle: u32,
        obj_fd: *mut ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmSyncobjFDToHandle(
        fd: ::core::ffi::c_int,
        obj_fd: ::core::ffi::c_int,
        handle: *mut u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmSyncobjImportSyncFile(
        fd: ::core::ffi::c_int,
        handle: u32,
        sync_file_fd: ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmSyncobjExportSyncFile(
        fd: ::core::ffi::c_int,
        handle: u32,
        sync_file_fd: *mut ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmSyncobjWait(
        fd: ::core::ffi::c_int,
        handles: *mut u32,
        num_handles: ::core::ffi::c_uint,
        timeout_nsec: i64,
        flags: ::core::ffi::c_uint,
        first_signaled: *mut u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmSyncobjReset(
        fd: ::core::ffi::c_int,
        handles: *const u32,
        handle_count: u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmSyncobjSignal(
        fd: ::core::ffi::c_int,
        handles: *const u32,
        handle_count: u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmSyncobjTimelineSignal(
        fd: ::core::ffi::c_int,
        handles: *const u32,
        points: *mut u64,
        handle_count: u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmSyncobjTimelineWait(
        fd: ::core::ffi::c_int,
        handles: *mut u32,
        points: *mut u64,
        num_handles: ::core::ffi::c_uint,
        timeout_nsec: i64,
        flags: ::core::ffi::c_uint,
        first_signaled: *mut u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmSyncobjQuery(
        fd: ::core::ffi::c_int,
        handles: *mut u32,
        points: *mut u64,
        handle_count: u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmSyncobjQuery2(
        fd: ::core::ffi::c_int,
        handles: *mut u32,
        points: *mut u64,
        handle_count: u32,
        flags: u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmSyncobjTransfer(
        fd: ::core::ffi::c_int,
        dst_handle: u32,
        dst_point: u64,
        src_handle: u32,
        src_point: u64,
        flags: u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmSyncobjEventfd(
        fd: ::core::ffi::c_int,
        handle: u32,
        point: u64,
        ev_fd: ::core::ffi::c_int,
        flags: u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmGetFormatModifierVendor(modifier: u64) -> *mut ::core::ffi::c_char;
}
unsafe extern "C" {
    pub fn drmGetFormatModifierName(modifier: u64) -> *mut ::core::ffi::c_char;
}
unsafe extern "C" {
    pub fn drmGetFormatName(format: u32) -> *mut ::core::ffi::c_char;
}
pub type wchar_t = ::core::ffi::c_int;
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Copy, Clone)]
pub struct max_align_t {
    pub __clang_max_align_nonce1: ::core::ffi::c_longlong,
    pub __bindgen_padding_0: u64,
    pub __clang_max_align_nonce2: u128,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmModeRes {
    pub count_fbs: ::core::ffi::c_int,
    pub fbs: *mut u32,
    pub count_crtcs: ::core::ffi::c_int,
    pub crtcs: *mut u32,
    pub count_connectors: ::core::ffi::c_int,
    pub connectors: *mut u32,
    pub count_encoders: ::core::ffi::c_int,
    pub encoders: *mut u32,
    pub min_width: u32,
    pub max_width: u32,
    pub min_height: u32,
    pub max_height: u32,
}
pub type drmModeRes = _drmModeRes;
pub type drmModeResPtr = *mut _drmModeRes;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmModeModeInfo {
    pub clock: u32,
    pub hdisplay: u16,
    pub hsync_start: u16,
    pub hsync_end: u16,
    pub htotal: u16,
    pub hskew: u16,
    pub vdisplay: u16,
    pub vsync_start: u16,
    pub vsync_end: u16,
    pub vtotal: u16,
    pub vscan: u16,
    pub vrefresh: u32,
    pub flags: u32,
    pub type_: u32,
    pub name: [::core::ffi::c_char; 32usize],
}
pub type drmModeModeInfo = _drmModeModeInfo;
pub type drmModeModeInfoPtr = *mut _drmModeModeInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmModeFB {
    pub fb_id: u32,
    pub width: u32,
    pub height: u32,
    pub pitch: u32,
    pub bpp: u32,
    pub depth: u32,
    pub handle: u32,
}
pub type drmModeFB = _drmModeFB;
pub type drmModeFBPtr = *mut _drmModeFB;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmModeFB2 {
    pub fb_id: u32,
    pub width: u32,
    pub height: u32,
    pub pixel_format: u32,
    pub modifier: u64,
    pub flags: u32,
    pub handles: [u32; 4usize],
    pub pitches: [u32; 4usize],
    pub offsets: [u32; 4usize],
}
pub type drmModeFB2 = _drmModeFB2;
pub type drmModeFB2Ptr = *mut _drmModeFB2;
pub type drmModeClip = drm_clip_rect;
pub type drmModeClipPtr = *mut drm_clip_rect;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmModePropertyBlob {
    pub id: u32,
    pub length: u32,
    pub data: *mut ::core::ffi::c_void,
}
pub type drmModePropertyBlobRes = _drmModePropertyBlob;
pub type drmModePropertyBlobPtr = *mut _drmModePropertyBlob;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmModeProperty {
    pub prop_id: u32,
    pub flags: u32,
    pub name: [::core::ffi::c_char; 32usize],
    pub count_values: ::core::ffi::c_int,
    pub values: *mut u64,
    pub count_enums: ::core::ffi::c_int,
    pub enums: *mut drm_mode_property_enum,
    pub count_blobs: ::core::ffi::c_int,
    pub blob_ids: *mut u32,
}
pub type drmModePropertyRes = _drmModeProperty;
pub type drmModePropertyPtr = *mut _drmModeProperty;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmModeCrtc {
    pub crtc_id: u32,
    pub buffer_id: u32,
    pub x: u32,
    pub y: u32,
    pub width: u32,
    pub height: u32,
    pub mode_valid: ::core::ffi::c_int,
    pub mode: drmModeModeInfo,
    pub gamma_size: ::core::ffi::c_int,
}
pub type drmModeCrtc = _drmModeCrtc;
pub type drmModeCrtcPtr = *mut _drmModeCrtc;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmModeEncoder {
    pub encoder_id: u32,
    pub encoder_type: u32,
    pub crtc_id: u32,
    pub possible_crtcs: u32,
    pub possible_clones: u32,
}
pub type drmModeEncoder = _drmModeEncoder;
pub type drmModeEncoderPtr = *mut _drmModeEncoder;
pub const drmModeConnection_DRM_MODE_CONNECTED: drmModeConnection = 1;
pub const drmModeConnection_DRM_MODE_DISCONNECTED: drmModeConnection = 2;
pub const drmModeConnection_DRM_MODE_UNKNOWNCONNECTION: drmModeConnection = 3;
pub type drmModeConnection = ::core::ffi::c_uint;
pub const drmModeSubPixel_DRM_MODE_SUBPIXEL_UNKNOWN: drmModeSubPixel = 1;
pub const drmModeSubPixel_DRM_MODE_SUBPIXEL_HORIZONTAL_RGB: drmModeSubPixel = 2;
pub const drmModeSubPixel_DRM_MODE_SUBPIXEL_HORIZONTAL_BGR: drmModeSubPixel = 3;
pub const drmModeSubPixel_DRM_MODE_SUBPIXEL_VERTICAL_RGB: drmModeSubPixel = 4;
pub const drmModeSubPixel_DRM_MODE_SUBPIXEL_VERTICAL_BGR: drmModeSubPixel = 5;
pub const drmModeSubPixel_DRM_MODE_SUBPIXEL_NONE: drmModeSubPixel = 6;
pub type drmModeSubPixel = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmModeConnector {
    pub connector_id: u32,
    pub encoder_id: u32,
    pub connector_type: u32,
    pub connector_type_id: u32,
    pub connection: drmModeConnection,
    pub mmWidth: u32,
    pub mmHeight: u32,
    pub subpixel: drmModeSubPixel,
    pub count_modes: ::core::ffi::c_int,
    pub modes: drmModeModeInfoPtr,
    pub count_props: ::core::ffi::c_int,
    pub props: *mut u32,
    pub prop_values: *mut u64,
    pub count_encoders: ::core::ffi::c_int,
    pub encoders: *mut u32,
}
pub type drmModeConnector = _drmModeConnector;
pub type drmModeConnectorPtr = *mut _drmModeConnector;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmModeObjectProperties {
    pub count_props: u32,
    pub props: *mut u32,
    pub prop_values: *mut u64,
}
pub type drmModeObjectProperties = _drmModeObjectProperties;
pub type drmModeObjectPropertiesPtr = *mut _drmModeObjectProperties;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmModeFormatModifierIterator {
    pub fmt_idx: u32,
    pub mod_idx: u32,
    pub fmt: u32,
    pub mod_: u64,
}
pub type drmModeFormatModifierIterator = _drmModeFormatModifierIterator;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmModePlane {
    pub count_formats: u32,
    pub formats: *mut u32,
    pub plane_id: u32,
    pub crtc_id: u32,
    pub fb_id: u32,
    pub crtc_x: u32,
    pub crtc_y: u32,
    pub x: u32,
    pub y: u32,
    pub possible_crtcs: u32,
    pub gamma_size: u32,
}
pub type drmModePlane = _drmModePlane;
pub type drmModePlanePtr = *mut _drmModePlane;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmModePlaneRes {
    pub count_planes: u32,
    pub planes: *mut u32,
}
pub type drmModePlaneRes = _drmModePlaneRes;
pub type drmModePlaneResPtr = *mut _drmModePlaneRes;
unsafe extern "C" {
    pub fn drmModeFreeModeInfo(ptr: drmModeModeInfoPtr);
}
unsafe extern "C" {
    pub fn drmModeFreeResources(ptr: drmModeResPtr);
}
unsafe extern "C" {
    pub fn drmModeFreeFB(ptr: drmModeFBPtr);
}
unsafe extern "C" {
    pub fn drmModeFreeFB2(ptr: drmModeFB2Ptr);
}
unsafe extern "C" {
    pub fn drmModeFreeCrtc(ptr: drmModeCrtcPtr);
}
unsafe extern "C" {
    pub fn drmModeFreeConnector(ptr: drmModeConnectorPtr);
}
unsafe extern "C" {
    pub fn drmModeFreeEncoder(ptr: drmModeEncoderPtr);
}
unsafe extern "C" {
    pub fn drmModeFreePlane(ptr: drmModePlanePtr);
}
unsafe extern "C" {
    pub fn drmModeFreePlaneResources(ptr: drmModePlaneResPtr);
}
unsafe extern "C" {
    pub fn drmIsKMS(fd: ::core::ffi::c_int) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmModeGetResources(fd: ::core::ffi::c_int) -> drmModeResPtr;
}
unsafe extern "C" {
    pub fn drmModeGetFB(fd: ::core::ffi::c_int, bufferId: u32) -> drmModeFBPtr;
}
unsafe extern "C" {
    pub fn drmModeGetFB2(fd: ::core::ffi::c_int, bufferId: u32) -> drmModeFB2Ptr;
}
unsafe extern "C" {
    pub fn drmModeAddFB(
        fd: ::core::ffi::c_int,
        width: u32,
        height: u32,
        depth: u8,
        bpp: u8,
        pitch: u32,
        bo_handle: u32,
        buf_id: *mut u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmModeAddFB2(
        fd: ::core::ffi::c_int,
        width: u32,
        height: u32,
        pixel_format: u32,
        bo_handles: *const u32,
        pitches: *const u32,
        offsets: *const u32,
        buf_id: *mut u32,
        flags: u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmModeAddFB2WithModifiers(
        fd: ::core::ffi::c_int,
        width: u32,
        height: u32,
        pixel_format: u32,
        bo_handles: *const u32,
        pitches: *const u32,
        offsets: *const u32,
        modifier: *const u64,
        buf_id: *mut u32,
        flags: u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmModeRmFB(fd: ::core::ffi::c_int, bufferId: u32) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmModeCloseFB(fd: ::core::ffi::c_int, buffer_id: u32) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmModeDirtyFB(
        fd: ::core::ffi::c_int,
        bufferId: u32,
        clips: drmModeClipPtr,
        num_clips: u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmModeGetCrtc(fd: ::core::ffi::c_int, crtcId: u32) -> drmModeCrtcPtr;
}
unsafe extern "C" {
    pub fn drmModeSetCrtc(
        fd: ::core::ffi::c_int,
        crtcId: u32,
        bufferId: u32,
        x: u32,
        y: u32,
        connectors: *mut u32,
        count: ::core::ffi::c_int,
        mode: drmModeModeInfoPtr,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmModeSetCursor(
        fd: ::core::ffi::c_int,
        crtcId: u32,
        bo_handle: u32,
        width: u32,
        height: u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmModeSetCursor2(
        fd: ::core::ffi::c_int,
        crtcId: u32,
        bo_handle: u32,
        width: u32,
        height: u32,
        hot_x: i32,
        hot_y: i32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmModeMoveCursor(
        fd: ::core::ffi::c_int,
        crtcId: u32,
        x: ::core::ffi::c_int,
        y: ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmModeGetEncoder(fd: ::core::ffi::c_int, encoder_id: u32) -> drmModeEncoderPtr;
}
unsafe extern "C" {
    pub fn drmModeGetConnector(fd: ::core::ffi::c_int, connectorId: u32) -> drmModeConnectorPtr;
}
unsafe extern "C" {
    pub fn drmModeGetConnectorCurrent(
        fd: ::core::ffi::c_int,
        connector_id: u32,
    ) -> drmModeConnectorPtr;
}
unsafe extern "C" {
    pub fn drmModeConnectorGetPossibleCrtcs(
        fd: ::core::ffi::c_int,
        connector: *const drmModeConnector,
    ) -> u32;
}
unsafe extern "C" {
    pub fn drmModeAttachMode(
        fd: ::core::ffi::c_int,
        connectorId: u32,
        mode_info: drmModeModeInfoPtr,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmModeDetachMode(
        fd: ::core::ffi::c_int,
        connectorId: u32,
        mode_info: drmModeModeInfoPtr,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmModeGetProperty(fd: ::core::ffi::c_int, propertyId: u32) -> drmModePropertyPtr;
}
unsafe extern "C" {
    pub fn drmModeFreeProperty(ptr: drmModePropertyPtr);
}
unsafe extern "C" {
    pub fn drmModeGetPropertyBlob(fd: ::core::ffi::c_int, blob_id: u32) -> drmModePropertyBlobPtr;
}
unsafe extern "C" {
    pub fn drmModeFormatModifierBlobIterNext(
        blob: *const drmModePropertyBlobRes,
        iter: *mut drmModeFormatModifierIterator,
    ) -> bool;
}
unsafe extern "C" {
    pub fn drmModeFreePropertyBlob(ptr: drmModePropertyBlobPtr);
}
unsafe extern "C" {
    pub fn drmModeConnectorSetProperty(
        fd: ::core::ffi::c_int,
        connector_id: u32,
        property_id: u32,
        value: u64,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmCheckModesettingSupported(busid: *const ::core::ffi::c_char) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmModeCrtcSetGamma(
        fd: ::core::ffi::c_int,
        crtc_id: u32,
        size: u32,
        red: *const u16,
        green: *const u16,
        blue: *const u16,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmModeCrtcGetGamma(
        fd: ::core::ffi::c_int,
        crtc_id: u32,
        size: u32,
        red: *mut u16,
        green: *mut u16,
        blue: *mut u16,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmModePageFlip(
        fd: ::core::ffi::c_int,
        crtc_id: u32,
        fb_id: u32,
        flags: u32,
        user_data: *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmModePageFlipTarget(
        fd: ::core::ffi::c_int,
        crtc_id: u32,
        fb_id: u32,
        flags: u32,
        user_data: *mut ::core::ffi::c_void,
        target_vblank: u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmModeGetPlaneResources(fd: ::core::ffi::c_int) -> drmModePlaneResPtr;
}
unsafe extern "C" {
    pub fn drmModeGetPlane(fd: ::core::ffi::c_int, plane_id: u32) -> drmModePlanePtr;
}
unsafe extern "C" {
    pub fn drmModeSetPlane(
        fd: ::core::ffi::c_int,
        plane_id: u32,
        crtc_id: u32,
        fb_id: u32,
        flags: u32,
        crtc_x: i32,
        crtc_y: i32,
        crtc_w: u32,
        crtc_h: u32,
        src_x: u32,
        src_y: u32,
        src_w: u32,
        src_h: u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmModeObjectGetProperties(
        fd: ::core::ffi::c_int,
        object_id: u32,
        object_type: u32,
    ) -> drmModeObjectPropertiesPtr;
}
unsafe extern "C" {
    pub fn drmModeFreeObjectProperties(ptr: drmModeObjectPropertiesPtr);
}
unsafe extern "C" {
    pub fn drmModeObjectSetProperty(
        fd: ::core::ffi::c_int,
        object_id: u32,
        object_type: u32,
        property_id: u32,
        value: u64,
    ) -> ::core::ffi::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmModeAtomicReq {
    _unused: [u8; 0],
}
pub type drmModeAtomicReq = _drmModeAtomicReq;
pub type drmModeAtomicReqPtr = *mut _drmModeAtomicReq;
unsafe extern "C" {
    pub fn drmModeAtomicAlloc() -> drmModeAtomicReqPtr;
}
unsafe extern "C" {
    pub fn drmModeAtomicDuplicate(req: drmModeAtomicReqPtr) -> drmModeAtomicReqPtr;
}
unsafe extern "C" {
    pub fn drmModeAtomicMerge(
        base: drmModeAtomicReqPtr,
        augment: drmModeAtomicReqPtr,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmModeAtomicFree(req: drmModeAtomicReqPtr);
}
unsafe extern "C" {
    pub fn drmModeAtomicGetCursor(req: drmModeAtomicReqPtr) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmModeAtomicSetCursor(req: drmModeAtomicReqPtr, cursor: ::core::ffi::c_int);
}
unsafe extern "C" {
    pub fn drmModeAtomicAddProperty(
        req: drmModeAtomicReqPtr,
        object_id: u32,
        property_id: u32,
        value: u64,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmModeAtomicCommit(
        fd: ::core::ffi::c_int,
        req: drmModeAtomicReqPtr,
        flags: u32,
        user_data: *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmModeCreatePropertyBlob(
        fd: ::core::ffi::c_int,
        data: *const ::core::ffi::c_void,
        size: usize,
        id: *mut u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmModeDestroyPropertyBlob(fd: ::core::ffi::c_int, id: u32) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmModeCreateLease(
        fd: ::core::ffi::c_int,
        objects: *const u32,
        num_objects: ::core::ffi::c_int,
        flags: ::core::ffi::c_int,
        lessee_id: *mut u32,
    ) -> ::core::ffi::c_int;
}
#[repr(C)]
#[derive(Debug)]
pub struct drmModeLesseeList {
    pub count: u32,
    pub lessees: __IncompleteArrayField<u32>,
}
pub type drmModeLesseeListRes = drmModeLesseeList;
pub type drmModeLesseeListPtr = *mut drmModeLesseeList;
unsafe extern "C" {
    pub fn drmModeListLessees(fd: ::core::ffi::c_int) -> drmModeLesseeListPtr;
}
#[repr(C)]
#[derive(Debug)]
pub struct drmModeObjectList {
    pub count: u32,
    pub objects: __IncompleteArrayField<u32>,
}
pub type drmModeObjectListRes = drmModeObjectList;
pub type drmModeObjectListPtr = *mut drmModeObjectList;
unsafe extern "C" {
    pub fn drmModeGetLease(fd: ::core::ffi::c_int) -> drmModeObjectListPtr;
}
unsafe extern "C" {
    pub fn drmModeRevokeLease(fd: ::core::ffi::c_int, lessee_id: u32) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmModeGetConnectorTypeName(connector_type: u32) -> *const ::core::ffi::c_char;
}
unsafe extern "C" {
    pub fn drmModeCreateDumbBuffer(
        fd: ::core::ffi::c_int,
        width: u32,
        height: u32,
        bpp: u32,
        flags: u32,
        handle: *mut u32,
        pitch: *mut u32,
        size: *mut u64,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmModeDestroyDumbBuffer(fd: ::core::ffi::c_int, handle: u32) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn drmModeMapDumbBuffer(
        fd: ::core::ffi::c_int,
        handle: u32,
        offset: *mut u64,
    ) -> ::core::ffi::c_int;
}
pub const amdgpu_bo_handle_type_amdgpu_bo_handle_type_gem_flink_name: amdgpu_bo_handle_type = 0;
pub const amdgpu_bo_handle_type_amdgpu_bo_handle_type_kms: amdgpu_bo_handle_type = 1;
pub const amdgpu_bo_handle_type_amdgpu_bo_handle_type_dma_buf_fd: amdgpu_bo_handle_type = 2;
pub const amdgpu_bo_handle_type_amdgpu_bo_handle_type_kms_noimport: amdgpu_bo_handle_type = 3;
pub type amdgpu_bo_handle_type = ::core::ffi::c_uint;
pub const amdgpu_gpu_va_range_amdgpu_gpu_va_range_general: amdgpu_gpu_va_range = 0;
pub type amdgpu_gpu_va_range = ::core::ffi::c_uint;
pub const amdgpu_sw_info_amdgpu_sw_info_address32_hi: amdgpu_sw_info = 0;
pub type amdgpu_sw_info = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_device {
    _unused: [u8; 0],
}
pub type amdgpu_device_handle = *mut amdgpu_device;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_context {
    _unused: [u8; 0],
}
pub type amdgpu_context_handle = *mut amdgpu_context;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_bo {
    _unused: [u8; 0],
}
pub type amdgpu_bo_handle = *mut amdgpu_bo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_bo_list {
    _unused: [u8; 0],
}
pub type amdgpu_bo_list_handle = *mut amdgpu_bo_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_va {
    _unused: [u8; 0],
}
pub type amdgpu_va_handle = *mut amdgpu_va;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_va_manager {
    _unused: [u8; 0],
}
pub type amdgpu_va_manager_handle = *mut amdgpu_va_manager;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_semaphore {
    _unused: [u8; 0],
}
pub type amdgpu_semaphore_handle = *mut amdgpu_semaphore;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_bo_alloc_request {
    pub alloc_size: u64,
    pub phys_alignment: u64,
    pub preferred_heap: u32,
    pub flags: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_bo_metadata {
    pub flags: u64,
    pub tiling_info: u64,
    pub size_metadata: u32,
    pub umd_metadata: [u32; 64usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_bo_info {
    pub alloc_size: u64,
    pub phys_alignment: u64,
    pub preferred_heap: u32,
    pub alloc_flags: u64,
    pub metadata: amdgpu_bo_metadata,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_bo_import_result {
    pub buf_handle: amdgpu_bo_handle,
    pub alloc_size: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_gds_resource_info {
    pub gds_gfx_partition_size: u32,
    pub compute_partition_size: u32,
    pub gds_total_size: u32,
    pub gws_per_gfx_partition: u32,
    pub gws_per_compute_partition: u32,
    pub oa_per_gfx_partition: u32,
    pub oa_per_compute_partition: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_cs_fence {
    pub context: amdgpu_context_handle,
    pub ip_type: u32,
    pub ip_instance: u32,
    pub ring: u32,
    pub fence: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_cs_ib_info {
    pub flags: u64,
    pub ib_mc_address: u64,
    pub size: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_cs_fence_info {
    pub handle: amdgpu_bo_handle,
    pub offset: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_cs_request {
    pub flags: u64,
    pub ip_type: ::core::ffi::c_uint,
    pub ip_instance: ::core::ffi::c_uint,
    pub ring: u32,
    pub resources: amdgpu_bo_list_handle,
    pub number_of_dependencies: u32,
    pub dependencies: *mut amdgpu_cs_fence,
    pub number_of_ibs: u32,
    pub ibs: *mut amdgpu_cs_ib_info,
    pub seq_no: u64,
    pub fence_info: amdgpu_cs_fence_info,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_buffer_size_alignments {
    pub size_local: u64,
    pub size_remote: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_heap_info {
    pub heap_size: u64,
    pub heap_usage: u64,
    pub max_allocation: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_gpu_info {
    pub asic_id: u32,
    pub chip_rev: u32,
    pub chip_external_rev: u32,
    pub family_id: u32,
    pub ids_flags: u64,
    pub max_engine_clk: u64,
    pub max_memory_clk: u64,
    pub num_shader_engines: u32,
    pub num_shader_arrays_per_engine: u32,
    pub avail_quad_shader_pipes: u32,
    pub max_quad_shader_pipes: u32,
    pub cache_entries_per_quad_pipe: u32,
    pub num_hw_gfx_contexts: u32,
    pub rb_pipes: u32,
    pub enabled_rb_pipes_mask: u32,
    pub gpu_counter_freq: u32,
    pub backend_disable: [u32; 4usize],
    pub mc_arb_ramcfg: u32,
    pub gb_addr_cfg: u32,
    pub gb_tile_mode: [u32; 32usize],
    pub gb_macro_tile_mode: [u32; 16usize],
    pub pa_sc_raster_cfg: [u32; 4usize],
    pub pa_sc_raster_cfg1: [u32; 4usize],
    pub cu_active_number: u32,
    pub cu_ao_mask: u32,
    pub cu_bitmap: [[u32; 4usize]; 4usize],
    pub vram_type: u32,
    pub vram_bit_width: u32,
    pub ce_ram_size: u32,
    pub vce_harvest_config: u32,
    pub pci_rev_id: u32,
}
unsafe extern "C" {
    pub fn amdgpu_device_initialize(
        fd: ::core::ffi::c_int,
        major_version: *mut u32,
        minor_version: *mut u32,
        device_handle: *mut amdgpu_device_handle,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_device_initialize2(
        fd: ::core::ffi::c_int,
        deduplicate_device: bool,
        major_version: *mut u32,
        minor_version: *mut u32,
        device_handle: *mut amdgpu_device_handle,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_device_deinitialize(device_handle: amdgpu_device_handle) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_bo_alloc(
        dev: amdgpu_device_handle,
        alloc_buffer: *mut amdgpu_bo_alloc_request,
        buf_handle: *mut amdgpu_bo_handle,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_bo_set_metadata(
        buf_handle: amdgpu_bo_handle,
        info: *mut amdgpu_bo_metadata,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_bo_query_info(
        buf_handle: amdgpu_bo_handle,
        info: *mut amdgpu_bo_info,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_bo_export(
        buf_handle: amdgpu_bo_handle,
        type_: amdgpu_bo_handle_type,
        shared_handle: *mut u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_bo_import(
        dev: amdgpu_device_handle,
        type_: amdgpu_bo_handle_type,
        shared_handle: u32,
        output: *mut amdgpu_bo_import_result,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_create_bo_from_user_mem(
        dev: amdgpu_device_handle,
        cpu: *mut ::core::ffi::c_void,
        size: u64,
        buf_handle: *mut amdgpu_bo_handle,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_find_bo_by_cpu_mapping(
        dev: amdgpu_device_handle,
        cpu: *mut ::core::ffi::c_void,
        size: u64,
        buf_handle: *mut amdgpu_bo_handle,
        offset_in_bo: *mut u64,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_bo_free(buf_handle: amdgpu_bo_handle) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_bo_inc_ref(bo: amdgpu_bo_handle);
}
unsafe extern "C" {
    pub fn amdgpu_bo_cpu_map(
        buf_handle: amdgpu_bo_handle,
        cpu: *mut *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_bo_cpu_unmap(buf_handle: amdgpu_bo_handle) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_bo_wait_for_idle(
        buf_handle: amdgpu_bo_handle,
        timeout_ns: u64,
        buffer_busy: *mut bool,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_bo_list_create_raw(
        dev: amdgpu_device_handle,
        number_of_buffers: u32,
        buffers: *mut drm_amdgpu_bo_list_entry,
        result: *mut u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_bo_list_destroy_raw(
        dev: amdgpu_device_handle,
        bo_list: u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_bo_list_create(
        dev: amdgpu_device_handle,
        number_of_resources: u32,
        resources: *mut amdgpu_bo_handle,
        resource_prios: *mut u8,
        result: *mut amdgpu_bo_list_handle,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_bo_list_destroy(handle: amdgpu_bo_list_handle) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_bo_list_update(
        handle: amdgpu_bo_list_handle,
        number_of_resources: u32,
        resources: *mut amdgpu_bo_handle,
        resource_prios: *mut u8,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_ctx_create2(
        dev: amdgpu_device_handle,
        priority: u32,
        context: *mut amdgpu_context_handle,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_ctx_create(
        dev: amdgpu_device_handle,
        context: *mut amdgpu_context_handle,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_ctx_free(context: amdgpu_context_handle) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_ctx_override_priority(
        dev: amdgpu_device_handle,
        context: amdgpu_context_handle,
        master_fd: ::core::ffi::c_int,
        priority: ::core::ffi::c_uint,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_ctx_stable_pstate(
        context: amdgpu_context_handle,
        op: u32,
        flags: u32,
        out_flags: *mut u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_query_reset_state(
        context: amdgpu_context_handle,
        state: *mut u32,
        hangs: *mut u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_query_reset_state2(
        context: amdgpu_context_handle,
        flags: *mut u64,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_submit(
        context: amdgpu_context_handle,
        flags: u64,
        ibs_request: *mut amdgpu_cs_request,
        number_of_requests: u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_query_fence_status(
        fence: *mut amdgpu_cs_fence,
        timeout_ns: u64,
        flags: u64,
        expired: *mut u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_wait_fences(
        fences: *mut amdgpu_cs_fence,
        fence_count: u32,
        wait_all: bool,
        timeout_ns: u64,
        status: *mut u32,
        first: *mut u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_query_buffer_size_alignment(
        dev: amdgpu_device_handle,
        info: *mut amdgpu_buffer_size_alignments,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_query_firmware_version(
        dev: amdgpu_device_handle,
        fw_type: ::core::ffi::c_uint,
        ip_instance: ::core::ffi::c_uint,
        index: ::core::ffi::c_uint,
        version: *mut u32,
        feature: *mut u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_query_hw_ip_count(
        dev: amdgpu_device_handle,
        type_: ::core::ffi::c_uint,
        count: *mut u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_query_hw_ip_info(
        dev: amdgpu_device_handle,
        type_: ::core::ffi::c_uint,
        ip_instance: ::core::ffi::c_uint,
        info: *mut drm_amdgpu_info_hw_ip,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_query_heap_info(
        dev: amdgpu_device_handle,
        heap: u32,
        flags: u32,
        info: *mut amdgpu_heap_info,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_query_crtc_from_id(
        dev: amdgpu_device_handle,
        id: ::core::ffi::c_uint,
        result: *mut i32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_query_gpu_info(
        dev: amdgpu_device_handle,
        info: *mut amdgpu_gpu_info,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_query_info(
        dev: amdgpu_device_handle,
        info_id: ::core::ffi::c_uint,
        size: ::core::ffi::c_uint,
        value: *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_query_sw_info(
        dev: amdgpu_device_handle,
        info: amdgpu_sw_info,
        value: *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_query_gds_info(
        dev: amdgpu_device_handle,
        gds_info: *mut amdgpu_gds_resource_info,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_query_sensor_info(
        dev: amdgpu_device_handle,
        sensor_type: ::core::ffi::c_uint,
        size: ::core::ffi::c_uint,
        value: *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_query_video_caps_info(
        dev: amdgpu_device_handle,
        cap_type: ::core::ffi::c_uint,
        size: ::core::ffi::c_uint,
        value: *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_query_gpuvm_fault_info(
        dev: amdgpu_device_handle,
        size: ::core::ffi::c_uint,
        value: *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_read_mm_registers(
        dev: amdgpu_device_handle,
        dword_offset: ::core::ffi::c_uint,
        count: ::core::ffi::c_uint,
        instance: u32,
        flags: u32,
        values: *mut u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_va_range_alloc(
        dev: amdgpu_device_handle,
        va_range_type: amdgpu_gpu_va_range,
        size: u64,
        va_base_alignment: u64,
        va_base_required: u64,
        va_base_allocated: *mut u64,
        va_range_handle: *mut amdgpu_va_handle,
        flags: u64,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_va_range_free(va_range_handle: amdgpu_va_handle) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_va_get_start_addr(va_handle: amdgpu_va_handle) -> u64;
}
unsafe extern "C" {
    pub fn amdgpu_va_range_query(
        dev: amdgpu_device_handle,
        type_: amdgpu_gpu_va_range,
        start: *mut u64,
        end: *mut u64,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_va_manager_alloc() -> amdgpu_va_manager_handle;
}
unsafe extern "C" {
    pub fn amdgpu_va_manager_init(
        va_mgr: amdgpu_va_manager_handle,
        low_va_offset: u64,
        low_va_max: u64,
        high_va_offset: u64,
        high_va_max: u64,
        virtual_address_alignment: u32,
    );
}
unsafe extern "C" {
    pub fn amdgpu_va_manager_deinit(va_mgr: amdgpu_va_manager_handle);
}
unsafe extern "C" {
    pub fn amdgpu_va_range_alloc2(
        va_mgr: amdgpu_va_manager_handle,
        va_range_type: amdgpu_gpu_va_range,
        size: u64,
        va_base_alignment: u64,
        va_base_required: u64,
        va_base_allocated: *mut u64,
        va_range_handle: *mut amdgpu_va_handle,
        flags: u64,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_bo_va_op(
        bo: amdgpu_bo_handle,
        offset: u64,
        size: u64,
        addr: u64,
        flags: u64,
        ops: u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_bo_va_op_raw(
        dev: amdgpu_device_handle,
        bo: amdgpu_bo_handle,
        offset: u64,
        size: u64,
        addr: u64,
        flags: u64,
        ops: u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_create_semaphore(sem: *mut amdgpu_semaphore_handle) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_signal_semaphore(
        ctx: amdgpu_context_handle,
        ip_type: u32,
        ip_instance: u32,
        ring: u32,
        sem: amdgpu_semaphore_handle,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_wait_semaphore(
        ctx: amdgpu_context_handle,
        ip_type: u32,
        ip_instance: u32,
        ring: u32,
        sem: amdgpu_semaphore_handle,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_destroy_semaphore(sem: amdgpu_semaphore_handle) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_get_marketing_name(dev: amdgpu_device_handle) -> *const ::core::ffi::c_char;
}
unsafe extern "C" {
    pub fn amdgpu_cs_create_syncobj2(
        dev: amdgpu_device_handle,
        flags: u32,
        syncobj: *mut u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_create_syncobj(
        dev: amdgpu_device_handle,
        syncobj: *mut u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_destroy_syncobj(dev: amdgpu_device_handle, syncobj: u32)
    -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_syncobj_reset(
        dev: amdgpu_device_handle,
        syncobjs: *const u32,
        syncobj_count: u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_syncobj_signal(
        dev: amdgpu_device_handle,
        syncobjs: *const u32,
        syncobj_count: u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_syncobj_timeline_signal(
        dev: amdgpu_device_handle,
        syncobjs: *const u32,
        points: *mut u64,
        syncobj_count: u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_syncobj_wait(
        dev: amdgpu_device_handle,
        handles: *mut u32,
        num_handles: ::core::ffi::c_uint,
        timeout_nsec: i64,
        flags: ::core::ffi::c_uint,
        first_signaled: *mut u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_syncobj_timeline_wait(
        dev: amdgpu_device_handle,
        handles: *mut u32,
        points: *mut u64,
        num_handles: ::core::ffi::c_uint,
        timeout_nsec: i64,
        flags: ::core::ffi::c_uint,
        first_signaled: *mut u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_syncobj_query(
        dev: amdgpu_device_handle,
        handles: *mut u32,
        points: *mut u64,
        num_handles: ::core::ffi::c_uint,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_syncobj_query2(
        dev: amdgpu_device_handle,
        handles: *mut u32,
        points: *mut u64,
        num_handles: ::core::ffi::c_uint,
        flags: u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_export_syncobj(
        dev: amdgpu_device_handle,
        syncobj: u32,
        shared_fd: *mut ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_import_syncobj(
        dev: amdgpu_device_handle,
        shared_fd: ::core::ffi::c_int,
        syncobj: *mut u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_syncobj_export_sync_file(
        dev: amdgpu_device_handle,
        syncobj: u32,
        sync_file_fd: *mut ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_syncobj_import_sync_file(
        dev: amdgpu_device_handle,
        syncobj: u32,
        sync_file_fd: ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_syncobj_export_sync_file2(
        dev: amdgpu_device_handle,
        syncobj: u32,
        point: u64,
        flags: u32,
        sync_file_fd: *mut ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_syncobj_import_sync_file2(
        dev: amdgpu_device_handle,
        syncobj: u32,
        point: u64,
        sync_file_fd: ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_syncobj_transfer(
        dev: amdgpu_device_handle,
        dst_handle: u32,
        dst_point: u64,
        src_handle: u32,
        src_point: u64,
        flags: u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_fence_to_handle(
        dev: amdgpu_device_handle,
        fence: *mut amdgpu_cs_fence,
        what: u32,
        out_handle: *mut u32,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_submit_raw(
        dev: amdgpu_device_handle,
        context: amdgpu_context_handle,
        bo_list_handle: amdgpu_bo_list_handle,
        num_chunks: ::core::ffi::c_int,
        chunks: *mut drm_amdgpu_cs_chunk,
        seq_no: *mut u64,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_submit_raw2(
        dev: amdgpu_device_handle,
        context: amdgpu_context_handle,
        bo_list_handle: u32,
        num_chunks: ::core::ffi::c_int,
        chunks: *mut drm_amdgpu_cs_chunk,
        seq_no: *mut u64,
    ) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_cs_chunk_fence_to_dep(
        fence: *mut amdgpu_cs_fence,
        dep: *mut drm_amdgpu_cs_chunk_dep,
    );
}
unsafe extern "C" {
    pub fn amdgpu_cs_chunk_fence_info_to_data(
        fence_info: *mut amdgpu_cs_fence_info,
        data: *mut drm_amdgpu_cs_chunk_data,
    );
}
unsafe extern "C" {
    pub fn amdgpu_vm_reserve_vmid(dev: amdgpu_device_handle, flags: u32) -> ::core::ffi::c_int;
}
unsafe extern "C" {
    pub fn amdgpu_vm_unreserve_vmid(dev: amdgpu_device_handle, flags: u32) -> ::core::ffi::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_gem_create_in {
    #[doc = " the requested memory size"]
    pub bo_size: __u64,
    #[doc = " physical start_addr alignment in bytes for some HW requirements"]
    pub alignment: __u64,
    #[doc = " the requested memory domains"]
    pub domains: __u64,
    #[doc = " allocation flags"]
    pub domain_flags: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_gem_create_out {
    #[doc = " returned GEM object handle"]
    pub handle: __u32,
    pub _pad: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_amdgpu_gem_create {
    pub in_: drm_amdgpu_gem_create_in,
    pub out: drm_amdgpu_gem_create_out,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_bo_list_in {
    #[doc = " Type of operation"]
    pub operation: __u32,
    #[doc = " Handle of list or 0 if we want to create one"]
    pub list_handle: __u32,
    #[doc = " Number of BOs in list"]
    pub bo_number: __u32,
    #[doc = " Size of each element describing BO"]
    pub bo_info_size: __u32,
    #[doc = " Pointer to array describing BOs"]
    pub bo_info_ptr: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_bo_list_entry {
    #[doc = " Handle of BO"]
    pub bo_handle: __u32,
    #[doc = " New (if specified) BO priority to be used during migration"]
    pub bo_priority: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_bo_list_out {
    #[doc = " Handle of resource list"]
    pub list_handle: __u32,
    pub _pad: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_amdgpu_bo_list {
    pub in_: drm_amdgpu_bo_list_in,
    pub out: drm_amdgpu_bo_list_out,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_ctx_in {
    #[doc = " AMDGPU_CTX_OP_*"]
    pub op: __u32,
    #[doc = " Flags"]
    pub flags: __u32,
    pub ctx_id: __u32,
    #[doc = " AMDGPU_CTX_PRIORITY_*"]
    pub priority: __s32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_amdgpu_ctx_out {
    pub alloc: drm_amdgpu_ctx_out__bindgen_ty_1,
    pub state: drm_amdgpu_ctx_out__bindgen_ty_2,
    pub pstate: drm_amdgpu_ctx_out__bindgen_ty_3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_ctx_out__bindgen_ty_1 {
    pub ctx_id: __u32,
    pub _pad: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_ctx_out__bindgen_ty_2 {
    #[doc = " For future use, no flags defined so far"]
    pub flags: __u64,
    #[doc = " Number of resets caused by this context so far."]
    pub hangs: __u32,
    #[doc = " Reset status since the last call of the ioctl."]
    pub reset_status: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_ctx_out__bindgen_ty_3 {
    pub flags: __u32,
    pub _pad: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_amdgpu_ctx {
    pub in_: drm_amdgpu_ctx_in,
    pub out: drm_amdgpu_ctx_out,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_vm_in {
    #[doc = " AMDGPU_VM_OP_*"]
    pub op: __u32,
    pub flags: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_vm_out {
    #[doc = " For future use, no flags defined so far"]
    pub flags: __u64,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_amdgpu_vm {
    pub in_: drm_amdgpu_vm_in,
    pub out: drm_amdgpu_vm_out,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_sched_in {
    pub op: __u32,
    pub fd: __u32,
    #[doc = " AMDGPU_CTX_PRIORITY_*"]
    pub priority: __s32,
    pub ctx_id: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_amdgpu_sched {
    pub in_: drm_amdgpu_sched_in,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_gem_userptr {
    pub addr: __u64,
    pub size: __u64,
    pub flags: __u32,
    pub handle: __u32,
}
#[doc = " The same structure is shared for input/output"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_gem_metadata {
    #[doc = " GEM Object handle"]
    pub handle: __u32,
    #[doc = " Do we want get or set metadata"]
    pub op: __u32,
    pub data: drm_amdgpu_gem_metadata__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_gem_metadata__bindgen_ty_1 {
    #[doc = " For future use, no flags defined so far"]
    pub flags: __u64,
    #[doc = " family specific tiling info"]
    pub tiling_info: __u64,
    pub data_size_bytes: __u32,
    pub data: [__u32; 64usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_gem_mmap_in {
    #[doc = " the GEM object handle"]
    pub handle: __u32,
    pub _pad: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_gem_mmap_out {
    #[doc = " mmap offset from the vma offset manager"]
    pub addr_ptr: __u64,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_amdgpu_gem_mmap {
    pub in_: drm_amdgpu_gem_mmap_in,
    pub out: drm_amdgpu_gem_mmap_out,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_gem_wait_idle_in {
    #[doc = " GEM object handle"]
    pub handle: __u32,
    #[doc = " For future use, no flags defined so far"]
    pub flags: __u32,
    #[doc = " Absolute timeout to wait"]
    pub timeout: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_gem_wait_idle_out {
    #[doc = " BO status:  0 - BO is idle, 1 - BO is busy"]
    pub status: __u32,
    #[doc = " Returned current memory domain"]
    pub domain: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_amdgpu_gem_wait_idle {
    pub in_: drm_amdgpu_gem_wait_idle_in,
    pub out: drm_amdgpu_gem_wait_idle_out,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_wait_cs_in {
    pub handle: __u64,
    #[doc = " Absolute timeout to wait"]
    pub timeout: __u64,
    pub ip_type: __u32,
    pub ip_instance: __u32,
    pub ring: __u32,
    pub ctx_id: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_wait_cs_out {
    #[doc = " CS status:  0 - CS completed, 1 - CS still busy"]
    pub status: __u64,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_amdgpu_wait_cs {
    pub in_: drm_amdgpu_wait_cs_in,
    pub out: drm_amdgpu_wait_cs_out,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_fence {
    pub ctx_id: __u32,
    pub ip_type: __u32,
    pub ip_instance: __u32,
    pub ring: __u32,
    pub seq_no: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_wait_fences_in {
    #[doc = " This points to uint64_t * which points to fences"]
    pub fences: __u64,
    pub fence_count: __u32,
    pub wait_all: __u32,
    pub timeout_ns: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_wait_fences_out {
    pub status: __u32,
    pub first_signaled: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_amdgpu_wait_fences {
    pub in_: drm_amdgpu_wait_fences_in,
    pub out: drm_amdgpu_wait_fences_out,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_gem_op {
    #[doc = " GEM object handle"]
    pub handle: __u32,
    #[doc = " AMDGPU_GEM_OP_*"]
    pub op: __u32,
    #[doc = " Input or return value"]
    pub value: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_gem_va {
    #[doc = " GEM object handle"]
    pub handle: __u32,
    pub _pad: __u32,
    #[doc = " AMDGPU_VA_OP_*"]
    pub operation: __u32,
    #[doc = " AMDGPU_VM_PAGE_*"]
    pub flags: __u32,
    #[doc = " va address to assign . Must be correctly aligned."]
    pub va_address: __u64,
    #[doc = " Specify offset inside of BO to assign. Must be correctly aligned."]
    pub offset_in_bo: __u64,
    #[doc = " Specify mapping size. Must be correctly aligned."]
    pub map_size: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_cs_chunk {
    pub chunk_id: __u32,
    pub length_dw: __u32,
    pub chunk_data: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_cs_in {
    #[doc = " Rendering context id"]
    pub ctx_id: __u32,
    #[doc = "  Handle of resource list associated with CS"]
    pub bo_list_handle: __u32,
    pub num_chunks: __u32,
    pub flags: __u32,
    #[doc = " this points to __u64 * which point to cs chunks"]
    pub chunks: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_cs_out {
    pub handle: __u64,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_amdgpu_cs {
    pub in_: drm_amdgpu_cs_in,
    pub out: drm_amdgpu_cs_out,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_cs_chunk_ib {
    pub _pad: __u32,
    #[doc = " AMDGPU_IB_FLAG_*"]
    pub flags: __u32,
    #[doc = " Virtual address to begin IB execution"]
    pub va_start: __u64,
    #[doc = " Size of submission"]
    pub ib_bytes: __u32,
    #[doc = " HW IP to submit to"]
    pub ip_type: __u32,
    #[doc = " HW IP index of the same type to submit to"]
    pub ip_instance: __u32,
    #[doc = " Ring index to submit to"]
    pub ring: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_cs_chunk_dep {
    pub ip_type: __u32,
    pub ip_instance: __u32,
    pub ring: __u32,
    pub ctx_id: __u32,
    pub handle: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_cs_chunk_fence {
    pub handle: __u32,
    pub offset: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_cs_chunk_sem {
    pub handle: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_cs_chunk_syncobj {
    pub handle: __u32,
    pub flags: __u32,
    pub point: __u64,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_amdgpu_fence_to_handle {
    pub in_: drm_amdgpu_fence_to_handle__bindgen_ty_1,
    pub out: drm_amdgpu_fence_to_handle__bindgen_ty_2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_fence_to_handle__bindgen_ty_1 {
    pub fence: drm_amdgpu_fence,
    pub what: __u32,
    pub pad: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_fence_to_handle__bindgen_ty_2 {
    pub handle: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct drm_amdgpu_cs_chunk_data {
    pub __bindgen_anon_1: drm_amdgpu_cs_chunk_data__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_amdgpu_cs_chunk_data__bindgen_ty_1 {
    pub ib_data: drm_amdgpu_cs_chunk_ib,
    pub fence_data: drm_amdgpu_cs_chunk_fence,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_cs_chunk_cp_gfx_shadow {
    pub shadow_va: __u64,
    pub csa_va: __u64,
    pub gds_va: __u64,
    pub flags: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_query_fw {
    #[doc = " AMDGPU_INFO_FW_*"]
    pub fw_type: __u32,
    #[doc = " Index of the IP if there are more IPs of\n the same type."]
    pub ip_instance: __u32,
    #[doc = " Index of the engine. Whether this is used depends\n on the firmware type. (e.g. MEC, SDMA)"]
    pub index: __u32,
    pub _pad: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct drm_amdgpu_info {
    pub return_pointer: __u64,
    pub return_size: __u32,
    pub query: __u32,
    pub __bindgen_anon_1: drm_amdgpu_info__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_amdgpu_info__bindgen_ty_1 {
    pub mode_crtc: drm_amdgpu_info__bindgen_ty_1__bindgen_ty_1,
    pub query_hw_ip: drm_amdgpu_info__bindgen_ty_1__bindgen_ty_2,
    pub read_mmr_reg: drm_amdgpu_info__bindgen_ty_1__bindgen_ty_3,
    pub query_fw: drm_amdgpu_query_fw,
    pub vbios_info: drm_amdgpu_info__bindgen_ty_1__bindgen_ty_4,
    pub sensor_info: drm_amdgpu_info__bindgen_ty_1__bindgen_ty_5,
    pub video_cap: drm_amdgpu_info__bindgen_ty_1__bindgen_ty_6,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info__bindgen_ty_1__bindgen_ty_1 {
    pub id: __u32,
    pub _pad: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info__bindgen_ty_1__bindgen_ty_2 {
    #[doc = " AMDGPU_HW_IP_*"]
    pub type_: __u32,
    #[doc = " Index of the IP if there are more IPs of the same\n type. Ignored by AMDGPU_INFO_HW_IP_COUNT."]
    pub ip_instance: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info__bindgen_ty_1__bindgen_ty_3 {
    pub dword_offset: __u32,
    #[doc = " number of registers to read"]
    pub count: __u32,
    pub instance: __u32,
    #[doc = " For future use, no flags defined so far"]
    pub flags: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info__bindgen_ty_1__bindgen_ty_4 {
    pub type_: __u32,
    pub offset: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info__bindgen_ty_1__bindgen_ty_5 {
    pub type_: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info__bindgen_ty_1__bindgen_ty_6 {
    pub type_: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info_gds {
    #[doc = " GDS GFX partition size"]
    pub gds_gfx_partition_size: __u32,
    #[doc = " GDS compute partition size"]
    pub compute_partition_size: __u32,
    #[doc = " total GDS memory size"]
    pub gds_total_size: __u32,
    #[doc = " GWS size per GFX partition"]
    pub gws_per_gfx_partition: __u32,
    #[doc = " GSW size per compute partition"]
    pub gws_per_compute_partition: __u32,
    #[doc = " OA size per GFX partition"]
    pub oa_per_gfx_partition: __u32,
    #[doc = " OA size per compute partition"]
    pub oa_per_compute_partition: __u32,
    pub _pad: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info_vram_gtt {
    pub vram_size: __u64,
    pub vram_cpu_accessible_size: __u64,
    pub gtt_size: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_heap_info {
    #[doc = " max. physical memory"]
    pub total_heap_size: __u64,
    #[doc = " Theoretical max. available memory in the given heap"]
    pub usable_heap_size: __u64,
    #[doc = " Number of bytes allocated in the heap. This includes all processes\n and private allocations in the kernel. It changes when new buffers\n are allocated, freed, and moved. It cannot be larger than\n heap_size."]
    pub heap_usage: __u64,
    #[doc = " Theoretical possible max. size of buffer which\n could be allocated in the given heap"]
    pub max_allocation: __u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_memory_info {
    pub vram: drm_amdgpu_heap_info,
    pub cpu_accessible_vram: drm_amdgpu_heap_info,
    pub gtt: drm_amdgpu_heap_info,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info_firmware {
    pub ver: __u32,
    pub feature: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info_vbios {
    pub name: [__u8; 64usize],
    pub vbios_pn: [__u8; 64usize],
    pub version: __u32,
    pub pad: __u32,
    pub vbios_ver_str: [__u8; 32usize],
    pub date: [__u8; 32usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info_device {
    #[doc = " PCI Device ID"]
    pub device_id: __u32,
    #[doc = " Internal chip revision: A0, A1, etc.)"]
    pub chip_rev: __u32,
    pub external_rev: __u32,
    #[doc = " Revision id in PCI Config space"]
    pub pci_rev: __u32,
    pub family: __u32,
    pub num_shader_engines: __u32,
    pub num_shader_arrays_per_engine: __u32,
    pub gpu_counter_freq: __u32,
    pub max_engine_clock: __u64,
    pub max_memory_clock: __u64,
    pub cu_active_number: __u32,
    pub cu_ao_mask: __u32,
    pub cu_bitmap: [[__u32; 4usize]; 4usize],
    #[doc = " Render backend pipe mask. One render backend is CB+DB."]
    pub enabled_rb_pipes_mask: __u32,
    pub num_rb_pipes: __u32,
    pub num_hw_gfx_contexts: __u32,
    pub pcie_gen: __u32,
    pub ids_flags: __u64,
    #[doc = " Starting virtual address for UMDs."]
    pub virtual_address_offset: __u64,
    #[doc = " The maximum virtual address"]
    pub virtual_address_max: __u64,
    #[doc = " Required alignment of virtual addresses."]
    pub virtual_address_alignment: __u32,
    #[doc = " Page table entry - fragment size"]
    pub pte_fragment_size: __u32,
    pub gart_page_size: __u32,
    #[doc = " constant engine ram size"]
    pub ce_ram_size: __u32,
    #[doc = " video memory type info"]
    pub vram_type: __u32,
    #[doc = " video memory bit width"]
    pub vram_bit_width: __u32,
    pub vce_harvest_config: __u32,
    pub gc_double_offchip_lds_buf: __u32,
    pub prim_buf_gpu_addr: __u64,
    pub pos_buf_gpu_addr: __u64,
    pub cntl_sb_buf_gpu_addr: __u64,
    pub param_buf_gpu_addr: __u64,
    pub prim_buf_size: __u32,
    pub pos_buf_size: __u32,
    pub cntl_sb_buf_size: __u32,
    pub param_buf_size: __u32,
    pub wave_front_size: __u32,
    pub num_shader_visible_vgprs: __u32,
    pub num_cu_per_sh: __u32,
    pub num_tcc_blocks: __u32,
    pub gs_vgt_table_depth: __u32,
    pub gs_prim_buffer_depth: __u32,
    pub max_gs_waves_per_vgt: __u32,
    pub pcie_num_lanes: __u32,
    pub cu_ao_bitmap: [[__u32; 4usize]; 4usize],
    #[doc = " Starting high virtual address for UMDs."]
    pub high_va_offset: __u64,
    #[doc = " The maximum high virtual address"]
    pub high_va_max: __u64,
    pub pa_sc_tile_steering_override: __u32,
    pub tcc_disabled_mask: __u64,
    pub min_engine_clock: __u64,
    pub min_memory_clock: __u64,
    pub tcp_cache_size: __u32,
    pub num_sqc_per_wgp: __u32,
    pub sqc_data_cache_size: __u32,
    pub sqc_inst_cache_size: __u32,
    pub gl1c_cache_size: __u32,
    pub gl2c_cache_size: __u32,
    pub mall_size: __u64,
    pub enabled_rb_pipes_mask_hi: __u32,
    pub shadow_size: __u32,
    pub shadow_alignment: __u32,
    pub csa_size: __u32,
    pub csa_alignment: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info_hw_ip {
    #[doc = " Version of h/w IP"]
    pub hw_ip_version_major: __u32,
    pub hw_ip_version_minor: __u32,
    #[doc = " Capabilities"]
    pub capabilities_flags: __u64,
    #[doc = " command buffer address start alignment"]
    pub ib_start_alignment: __u32,
    #[doc = " command buffer size alignment"]
    pub ib_size_alignment: __u32,
    #[doc = " Bitmask of available rings. Bit 0 means ring 0, etc."]
    pub available_rings: __u32,
    #[doc = " version info: bits 23:16 major, 15:8 minor, 7:0 revision"]
    pub ip_discovery_version: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info_num_handles {
    #[doc = " Max handles as supported by firmware for UVD"]
    pub uvd_max_handles: __u32,
    #[doc = " Handles currently in use for UVD"]
    pub uvd_used_handles: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info_vce_clock_table_entry {
    #[doc = " System clock"]
    pub sclk: __u32,
    #[doc = " Memory clock"]
    pub mclk: __u32,
    #[doc = " VCE clock"]
    pub eclk: __u32,
    pub pad: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info_vce_clock_table {
    pub entries: [drm_amdgpu_info_vce_clock_table_entry; 6usize],
    pub num_valid_entries: __u32,
    pub pad: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info_video_codec_info {
    pub valid: __u32,
    pub max_width: __u32,
    pub max_height: __u32,
    pub max_pixels_per_frame: __u32,
    pub max_level: __u32,
    pub pad: __u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info_video_caps {
    pub codec_info: [drm_amdgpu_info_video_codec_info; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info_gpuvm_fault {
    pub addr: __u64,
    pub status: __u32,
    pub vmhub: __u32,
}
pub const atom_bios_header_version_def_ATOM_MAJOR_VERSION: atom_bios_header_version_def = 3;
pub const atom_bios_header_version_def_ATOM_MINOR_VERSION: atom_bios_header_version_def = 3;
pub type atom_bios_header_version_def = ::core::ffi::c_uint;
pub const atom_crtc_def_ATOM_CRTC1: atom_crtc_def = 0;
pub const atom_crtc_def_ATOM_CRTC2: atom_crtc_def = 1;
pub const atom_crtc_def_ATOM_CRTC3: atom_crtc_def = 2;
pub const atom_crtc_def_ATOM_CRTC4: atom_crtc_def = 3;
pub const atom_crtc_def_ATOM_CRTC5: atom_crtc_def = 4;
pub const atom_crtc_def_ATOM_CRTC6: atom_crtc_def = 5;
pub const atom_crtc_def_ATOM_CRTC_INVALID: atom_crtc_def = 255;
pub type atom_crtc_def = ::core::ffi::c_uint;
pub const atom_ppll_def_ATOM_PPLL0: atom_ppll_def = 2;
pub const atom_ppll_def_ATOM_GCK_DFS: atom_ppll_def = 8;
pub const atom_ppll_def_ATOM_FCH_CLK: atom_ppll_def = 9;
pub const atom_ppll_def_ATOM_DP_DTO: atom_ppll_def = 11;
pub const atom_ppll_def_ATOM_COMBOPHY_PLL0: atom_ppll_def = 20;
pub const atom_ppll_def_ATOM_COMBOPHY_PLL1: atom_ppll_def = 21;
pub const atom_ppll_def_ATOM_COMBOPHY_PLL2: atom_ppll_def = 22;
pub const atom_ppll_def_ATOM_COMBOPHY_PLL3: atom_ppll_def = 23;
pub const atom_ppll_def_ATOM_COMBOPHY_PLL4: atom_ppll_def = 24;
pub const atom_ppll_def_ATOM_COMBOPHY_PLL5: atom_ppll_def = 25;
pub const atom_ppll_def_ATOM_PPLL_INVALID: atom_ppll_def = 255;
pub type atom_ppll_def = ::core::ffi::c_uint;
pub const atom_dig_def_ASIC_INT_DIG1_ENCODER_ID: atom_dig_def = 3;
pub const atom_dig_def_ASIC_INT_DIG2_ENCODER_ID: atom_dig_def = 9;
pub const atom_dig_def_ASIC_INT_DIG3_ENCODER_ID: atom_dig_def = 10;
pub const atom_dig_def_ASIC_INT_DIG4_ENCODER_ID: atom_dig_def = 11;
pub const atom_dig_def_ASIC_INT_DIG5_ENCODER_ID: atom_dig_def = 12;
pub const atom_dig_def_ASIC_INT_DIG6_ENCODER_ID: atom_dig_def = 13;
pub const atom_dig_def_ASIC_INT_DIG7_ENCODER_ID: atom_dig_def = 14;
pub type atom_dig_def = ::core::ffi::c_uint;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_DP: atom_encode_mode_def = 0;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_DP_SST: atom_encode_mode_def = 0;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_LVDS: atom_encode_mode_def = 1;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_DVI: atom_encode_mode_def = 2;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_HDMI: atom_encode_mode_def = 3;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_DP_AUDIO: atom_encode_mode_def = 5;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_DP_MST: atom_encode_mode_def = 5;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_CRT: atom_encode_mode_def = 15;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_DVO: atom_encode_mode_def = 16;
pub type atom_encode_mode_def = ::core::ffi::c_uint;
pub const atom_encoder_refclk_src_def_ENCODER_REFCLK_SRC_P1PLL: atom_encoder_refclk_src_def = 0;
pub const atom_encoder_refclk_src_def_ENCODER_REFCLK_SRC_P2PLL: atom_encoder_refclk_src_def = 1;
pub const atom_encoder_refclk_src_def_ENCODER_REFCLK_SRC_P3PLL: atom_encoder_refclk_src_def = 2;
pub const atom_encoder_refclk_src_def_ENCODER_REFCLK_SRC_EXTCLK: atom_encoder_refclk_src_def = 3;
pub const atom_encoder_refclk_src_def_ENCODER_REFCLK_SRC_INVALID: atom_encoder_refclk_src_def = 255;
pub type atom_encoder_refclk_src_def = ::core::ffi::c_uint;
pub const atom_scaler_def_ATOM_SCALER_DISABLE: atom_scaler_def = 0;
pub const atom_scaler_def_ATOM_SCALER_CENTER: atom_scaler_def = 1;
pub const atom_scaler_def_ATOM_SCALER_EXPANSION: atom_scaler_def = 2;
pub type atom_scaler_def = ::core::ffi::c_uint;
pub const atom_operation_def_ATOM_DISABLE: atom_operation_def = 0;
pub const atom_operation_def_ATOM_ENABLE: atom_operation_def = 1;
pub const atom_operation_def_ATOM_INIT: atom_operation_def = 7;
pub const atom_operation_def_ATOM_GET_STATUS: atom_operation_def = 8;
pub type atom_operation_def = ::core::ffi::c_uint;
pub const atom_embedded_display_op_def_ATOM_LCD_BL_OFF: atom_embedded_display_op_def = 2;
pub const atom_embedded_display_op_def_ATOM_LCD_BL_OM: atom_embedded_display_op_def = 3;
pub const atom_embedded_display_op_def_ATOM_LCD_BL_BRIGHTNESS_CONTROL:
    atom_embedded_display_op_def = 4;
pub const atom_embedded_display_op_def_ATOM_LCD_SELFTEST_START: atom_embedded_display_op_def = 5;
pub const atom_embedded_display_op_def_ATOM_LCD_SELFTEST_STOP: atom_embedded_display_op_def = 6;
pub type atom_embedded_display_op_def = ::core::ffi::c_uint;
pub const atom_spread_spectrum_mode_ATOM_SS_CENTER_OR_DOWN_MODE_MASK: atom_spread_spectrum_mode = 1;
pub const atom_spread_spectrum_mode_ATOM_SS_DOWN_SPREAD_MODE: atom_spread_spectrum_mode = 0;
pub const atom_spread_spectrum_mode_ATOM_SS_CENTRE_SPREAD_MODE: atom_spread_spectrum_mode = 1;
pub const atom_spread_spectrum_mode_ATOM_INT_OR_EXT_SS_MASK: atom_spread_spectrum_mode = 2;
pub const atom_spread_spectrum_mode_ATOM_INTERNAL_SS_MASK: atom_spread_spectrum_mode = 0;
pub const atom_spread_spectrum_mode_ATOM_EXTERNAL_SS_MASK: atom_spread_spectrum_mode = 2;
pub type atom_spread_spectrum_mode = ::core::ffi::c_uint;
pub const atom_panel_bit_per_color_PANEL_BPC_UNDEFINE: atom_panel_bit_per_color = 0;
pub const atom_panel_bit_per_color_PANEL_6BIT_PER_COLOR: atom_panel_bit_per_color = 1;
pub const atom_panel_bit_per_color_PANEL_8BIT_PER_COLOR: atom_panel_bit_per_color = 2;
pub const atom_panel_bit_per_color_PANEL_10BIT_PER_COLOR: atom_panel_bit_per_color = 3;
pub const atom_panel_bit_per_color_PANEL_12BIT_PER_COLOR: atom_panel_bit_per_color = 4;
pub const atom_panel_bit_per_color_PANEL_16BIT_PER_COLOR: atom_panel_bit_per_color = 5;
pub type atom_panel_bit_per_color = ::core::ffi::c_uint;
pub const atom_voltage_type_VOLTAGE_TYPE_VDDC: atom_voltage_type = 1;
pub const atom_voltage_type_VOLTAGE_TYPE_MVDDC: atom_voltage_type = 2;
pub const atom_voltage_type_VOLTAGE_TYPE_MVDDQ: atom_voltage_type = 3;
pub const atom_voltage_type_VOLTAGE_TYPE_VDDCI: atom_voltage_type = 4;
pub const atom_voltage_type_VOLTAGE_TYPE_VDDGFX: atom_voltage_type = 5;
pub const atom_voltage_type_VOLTAGE_TYPE_PCC: atom_voltage_type = 6;
pub const atom_voltage_type_VOLTAGE_TYPE_MVPP: atom_voltage_type = 7;
pub const atom_voltage_type_VOLTAGE_TYPE_LEDDPM: atom_voltage_type = 8;
pub const atom_voltage_type_VOLTAGE_TYPE_PCC_MVDD: atom_voltage_type = 9;
pub const atom_voltage_type_VOLTAGE_TYPE_PCIE_VDDC: atom_voltage_type = 10;
pub const atom_voltage_type_VOLTAGE_TYPE_PCIE_VDDR: atom_voltage_type = 11;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_1: atom_voltage_type = 17;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_2: atom_voltage_type = 18;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_3: atom_voltage_type = 19;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_4: atom_voltage_type = 20;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_5: atom_voltage_type = 21;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_6: atom_voltage_type = 22;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_7: atom_voltage_type = 23;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_8: atom_voltage_type = 24;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_9: atom_voltage_type = 25;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_10: atom_voltage_type = 26;
pub type atom_voltage_type = ::core::ffi::c_uint;
pub const atom_dgpu_vram_type_ATOM_DGPU_VRAM_TYPE_GDDR5: atom_dgpu_vram_type = 80;
pub const atom_dgpu_vram_type_ATOM_DGPU_VRAM_TYPE_HBM2: atom_dgpu_vram_type = 96;
pub const atom_dgpu_vram_type_ATOM_DGPU_VRAM_TYPE_HBM2E: atom_dgpu_vram_type = 97;
pub const atom_dgpu_vram_type_ATOM_DGPU_VRAM_TYPE_GDDR6: atom_dgpu_vram_type = 112;
pub const atom_dgpu_vram_type_ATOM_DGPU_VRAM_TYPE_HBM3: atom_dgpu_vram_type = 128;
pub type atom_dgpu_vram_type = ::core::ffi::c_uint;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL0_PREEMPH_LEVEL0: atom_dp_vs_preemph_def = 0;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL1_PREEMPH_LEVEL0: atom_dp_vs_preemph_def = 1;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL2_PREEMPH_LEVEL0: atom_dp_vs_preemph_def = 2;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL3_PREEMPH_LEVEL0: atom_dp_vs_preemph_def = 3;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL0_PREEMPH_LEVEL1: atom_dp_vs_preemph_def = 8;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL1_PREEMPH_LEVEL1: atom_dp_vs_preemph_def = 9;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL2_PREEMPH_LEVEL1: atom_dp_vs_preemph_def = 10;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL0_PREEMPH_LEVEL2: atom_dp_vs_preemph_def = 16;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL1_PREEMPH_LEVEL2: atom_dp_vs_preemph_def = 17;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL0_PREEMPH_LEVEL3: atom_dp_vs_preemph_def = 24;
pub type atom_dp_vs_preemph_def = ::core::ffi::c_uint;
pub const atombios_image_offset_OFFSET_TO_ATOM_ROM_HEADER_POINTER: atombios_image_offset = 72;
pub const atombios_image_offset_OFFSET_TO_ATOM_ROM_IMAGE_SIZE: atombios_image_offset = 2;
pub const atombios_image_offset_OFFSET_TO_ATOMBIOS_ASIC_BUS_MEM_TYPE: atombios_image_offset = 148;
pub const atombios_image_offset_MAXSIZE_OF_ATOMBIOS_ASIC_BUS_MEM_TYPE: atombios_image_offset = 20;
pub const atombios_image_offset_OFFSET_TO_GET_ATOMBIOS_NUMBER_OF_STRINGS: atombios_image_offset =
    47;
pub const atombios_image_offset_OFFSET_TO_GET_ATOMBIOS_STRING_START: atombios_image_offset = 110;
pub const atombios_image_offset_OFFSET_TO_VBIOS_PART_NUMBER: atombios_image_offset = 128;
pub const atombios_image_offset_OFFSET_TO_VBIOS_DATE: atombios_image_offset = 80;
pub type atombios_image_offset = ::core::ffi::c_uint;
#[doc = " Common header for all tables (Data table, Command function).\n Every table pointed in _ATOM_MASTER_DATA_TABLE has this common header.\n And the pointer actually points to this header."]
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_common_table_header {
    pub structuresize: u16,
    pub format_revision: u8,
    pub content_revision: u8,
}
#[doc = " Structure stores the ROM header."]
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_rom_header_v2_2 {
    pub table_header: atom_common_table_header,
    pub atom_bios_string: [u8; 4usize],
    pub bios_segment_address: u16,
    pub protectedmodeoffset: u16,
    pub configfilenameoffset: u16,
    pub crc_block_offset: u16,
    pub vbios_bootupmessageoffset: u16,
    pub int10_offset: u16,
    pub pcibusdevinitcode: u16,
    pub iobaseaddress: u16,
    pub subsystem_vendor_id: u16,
    pub subsystem_id: u16,
    pub pci_info_offset: u16,
    pub masterhwfunction_offset: u16,
    pub masterdatatable_offset: u16,
    pub reserved: u16,
    pub pspdirtableoffset: u32,
}
#[doc = " Structures used in Command.mtb, each function name is not given here since those function could change from time to time\n The real functionality of each function is associated with the parameter structure version when defined\n For all internal cmd function definitions, please reference to atomstruct.h"]
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_master_list_of_command_functions_v2_1 {
    pub asic_init: u16,
    pub cmd_function1: u16,
    pub cmd_function2: u16,
    pub cmd_function3: u16,
    pub digxencodercontrol: u16,
    pub cmd_function5: u16,
    pub cmd_function6: u16,
    pub cmd_function7: u16,
    pub cmd_function8: u16,
    pub cmd_function9: u16,
    pub setengineclock: u16,
    pub setmemoryclock: u16,
    pub setpixelclock: u16,
    pub enabledisppowergating: u16,
    pub cmd_function14: u16,
    pub cmd_function15: u16,
    pub cmd_function16: u16,
    pub cmd_function17: u16,
    pub cmd_function18: u16,
    pub cmd_function19: u16,
    pub cmd_function20: u16,
    pub cmd_function21: u16,
    pub cmd_function22: u16,
    pub cmd_function23: u16,
    pub cmd_function24: u16,
    pub cmd_function25: u16,
    pub cmd_function26: u16,
    pub cmd_function27: u16,
    pub cmd_function28: u16,
    pub cmd_function29: u16,
    pub cmd_function30: u16,
    pub cmd_function31: u16,
    pub cmd_function32: u16,
    pub cmd_function33: u16,
    pub blankcrtc: u16,
    pub enablecrtc: u16,
    pub cmd_function36: u16,
    pub cmd_function37: u16,
    pub cmd_function38: u16,
    pub cmd_function39: u16,
    pub cmd_function40: u16,
    pub getsmuclockinfo: u16,
    pub selectcrtc_source: u16,
    pub cmd_function43: u16,
    pub cmd_function44: u16,
    pub cmd_function45: u16,
    pub setdceclock: u16,
    pub getmemoryclock: u16,
    pub getengineclock: u16,
    pub setcrtc_usingdtdtiming: u16,
    pub externalencodercontrol: u16,
    pub cmd_function51: u16,
    pub cmd_function52: u16,
    pub cmd_function53: u16,
    pub processi2cchanneltransaction: u16,
    pub cmd_function55: u16,
    pub cmd_function56: u16,
    pub cmd_function57: u16,
    pub cmd_function58: u16,
    pub cmd_function59: u16,
    pub computegpuclockparam: u16,
    pub cmd_function61: u16,
    pub cmd_function62: u16,
    pub dynamicmemorysettings: u16,
    pub memorytraining: u16,
    pub cmd_function65: u16,
    pub cmd_function66: u16,
    pub setvoltage: u16,
    pub cmd_function68: u16,
    pub readefusevalue: u16,
    pub cmd_function70: u16,
    pub cmd_function71: u16,
    pub cmd_function72: u16,
    pub cmd_function73: u16,
    pub cmd_function74: u16,
    pub cmd_function75: u16,
    pub dig1transmittercontrol: u16,
    pub cmd_function77: u16,
    pub processauxchanneltransaction: u16,
    pub cmd_function79: u16,
    pub getvoltageinfo: u16,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_master_command_function_v2_1 {
    pub table_header: atom_common_table_header,
    pub listofcmdfunctions: atom_master_list_of_command_functions_v2_1,
}
#[doc = " Structures used in every command function"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_function_attribute {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
}
impl atom_function_attribute {
    #[inline]
    pub fn ws_in_bytes(&self) -> u16 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u16) }
    }
    #[inline]
    pub fn set_ws_in_bytes(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn ws_in_bytes_raw(this: *const Self) -> u16 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                8u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set_ws_in_bytes_raw(this: *mut Self, val: u16) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn ps_in_bytes(&self) -> u16 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 7u8) as u16) }
    }
    #[inline]
    pub fn set_ps_in_bytes(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn ps_in_bytes_raw(this: *const Self) -> u16 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                8usize,
                7u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set_ps_in_bytes_raw(this: *mut Self, val: u16) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                8usize,
                7u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn updated_by_util(&self) -> u16 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_updated_by_util(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn updated_by_util_raw(this: *const Self) -> u16 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                15usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set_updated_by_util_raw(this: *mut Self, val: u16) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                15usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        ws_in_bytes: u16,
        ps_in_bytes: u16,
        updated_by_util: u16,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let ws_in_bytes: u16 = unsafe { ::core::mem::transmute(ws_in_bytes) };
            ws_in_bytes as u64
        });
        __bindgen_bitfield_unit.set(8usize, 7u8, {
            let ps_in_bytes: u16 = unsafe { ::core::mem::transmute(ps_in_bytes) };
            ps_in_bytes as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let updated_by_util: u16 = unsafe { ::core::mem::transmute(updated_by_util) };
            updated_by_util as u64
        });
        __bindgen_bitfield_unit
    }
}
#[doc = " Common header for all hw functions.\n Every function pointed by _master_list_of_hw_function has this common header.\n And the pointer actually points to this header."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_rom_hw_function_header {
    pub func_header: atom_common_table_header,
    pub func_attrib: atom_function_attribute,
}
#[doc = " Structures used in data.mtb, each data table name is not given here since those data table could change from time to time\n The real name of each table is given when its data structure version is defined"]
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_master_list_of_data_tables_v2_1 {
    pub utilitypipeline: u16,
    pub multimedia_info: u16,
    pub smc_dpm_info: u16,
    pub sw_datatable3: u16,
    pub firmwareinfo: u16,
    pub sw_datatable5: u16,
    pub lcd_info: u16,
    pub sw_datatable7: u16,
    pub smu_info: u16,
    pub sw_datatable9: u16,
    pub sw_datatable10: u16,
    pub vram_usagebyfirmware: u16,
    pub gpio_pin_lut: u16,
    pub sw_datatable13: u16,
    pub gfx_info: u16,
    pub powerplayinfo: u16,
    pub sw_datatable16: u16,
    pub sw_datatable17: u16,
    pub sw_datatable18: u16,
    pub sw_datatable19: u16,
    pub sw_datatable20: u16,
    pub sw_datatable21: u16,
    pub displayobjectinfo: u16,
    pub indirectioaccess: u16,
    pub umc_info: u16,
    pub sw_datatable25: u16,
    pub sw_datatable26: u16,
    pub dce_info: u16,
    pub vram_info: u16,
    pub sw_datatable29: u16,
    pub integratedsysteminfo: u16,
    pub asic_profiling_info: u16,
    pub voltageobject_info: u16,
    pub sw_datatable33: u16,
    pub sw_datatable34: u16,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_master_data_table_v2_1 {
    pub table_header: atom_common_table_header,
    pub listOfdatatables: atom_master_list_of_data_tables_v2_1,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_dtd_format {
    pub pixclk: u16,
    pub h_active: u16,
    pub h_blanking_time: u16,
    pub v_active: u16,
    pub v_blanking_time: u16,
    pub h_sync_offset: u16,
    pub h_sync_width: u16,
    pub v_sync_offset: u16,
    pub v_syncwidth: u16,
    pub reserved: u16,
    pub reserved0: u16,
    pub h_border: u8,
    pub v_border: u8,
    pub miscinfo: u16,
    pub atom_mode_id: u8,
    pub refreshrate: u8,
}
pub const atom_dtd_format_modemiscinfo_ATOM_HSYNC_POLARITY: atom_dtd_format_modemiscinfo = 2;
pub const atom_dtd_format_modemiscinfo_ATOM_VSYNC_POLARITY: atom_dtd_format_modemiscinfo = 4;
pub const atom_dtd_format_modemiscinfo_ATOM_H_REPLICATIONBY2: atom_dtd_format_modemiscinfo = 16;
pub const atom_dtd_format_modemiscinfo_ATOM_V_REPLICATIONBY2: atom_dtd_format_modemiscinfo = 32;
pub const atom_dtd_format_modemiscinfo_ATOM_INTERLACE: atom_dtd_format_modemiscinfo = 128;
pub const atom_dtd_format_modemiscinfo_ATOM_COMPOSITESYNC: atom_dtd_format_modemiscinfo = 64;
pub type atom_dtd_format_modemiscinfo = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_firmware_info_v3_1 {
    pub table_header: atom_common_table_header,
    pub firmware_revision: u32,
    pub bootup_sclk_in10khz: u32,
    pub bootup_mclk_in10khz: u32,
    pub firmware_capability: u32,
    pub main_call_parser_entry: u32,
    pub bios_scratch_reg_startaddr: u32,
    pub bootup_vddc_mv: u16,
    pub bootup_vddci_mv: u16,
    pub bootup_mvddc_mv: u16,
    pub bootup_vddgfx_mv: u16,
    pub mem_module_id: u8,
    pub coolingsolution_id: u8,
    pub reserved1: [u8; 2usize],
    pub mc_baseaddr_high: u32,
    pub mc_baseaddr_low: u32,
    pub reserved2: [u32; 6usize],
}
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_FIRMWARE_POSTED:
    atombios_firmware_capability = 1;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_GPU_VIRTUALIZATION:
    atombios_firmware_capability = 2;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_WMI_SUPPORT: atombios_firmware_capability =
    64;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_HWEMU_ENABLE:
    atombios_firmware_capability = 128;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_HWEMU_UMC_CFG:
    atombios_firmware_capability = 256;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_SRAM_ECC: atombios_firmware_capability =
    512;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_ENABLE_2STAGE_BIST_TRAINING:
    atombios_firmware_capability = 1024;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_ENABLE_2ND_USB20PORT:
    atombios_firmware_capability = 32768;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_DYNAMIC_BOOT_CFG_ENABLE:
    atombios_firmware_capability = 131072;
pub type atombios_firmware_capability = ::core::ffi::c_uint;
pub const atom_cooling_solution_id_AIR_COOLING: atom_cooling_solution_id = 0;
pub const atom_cooling_solution_id_LIQUID_COOLING: atom_cooling_solution_id = 1;
pub type atom_cooling_solution_id = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_firmware_info_v3_2 {
    pub table_header: atom_common_table_header,
    pub firmware_revision: u32,
    pub bootup_sclk_in10khz: u32,
    pub bootup_mclk_in10khz: u32,
    pub firmware_capability: u32,
    pub main_call_parser_entry: u32,
    pub bios_scratch_reg_startaddr: u32,
    pub bootup_vddc_mv: u16,
    pub bootup_vddci_mv: u16,
    pub bootup_mvddc_mv: u16,
    pub bootup_vddgfx_mv: u16,
    pub mem_module_id: u8,
    pub coolingsolution_id: u8,
    pub reserved1: [u8; 2usize],
    pub mc_baseaddr_high: u32,
    pub mc_baseaddr_low: u32,
    pub board_i2c_feature_id: u8,
    pub board_i2c_feature_gpio_id: u8,
    pub board_i2c_feature_slave_addr: u8,
    pub reserved3: u8,
    pub bootup_mvddq_mv: u16,
    pub bootup_mvpp_mv: u16,
    pub zfbstartaddrin16mb: u32,
    pub reserved2: [u32; 3usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_firmware_info_v3_3 {
    pub table_header: atom_common_table_header,
    pub firmware_revision: u32,
    pub bootup_sclk_in10khz: u32,
    pub bootup_mclk_in10khz: u32,
    pub firmware_capability: u32,
    pub main_call_parser_entry: u32,
    pub bios_scratch_reg_startaddr: u32,
    pub bootup_vddc_mv: u16,
    pub bootup_vddci_mv: u16,
    pub bootup_mvddc_mv: u16,
    pub bootup_vddgfx_mv: u16,
    pub mem_module_id: u8,
    pub coolingsolution_id: u8,
    pub reserved1: [u8; 2usize],
    pub mc_baseaddr_high: u32,
    pub mc_baseaddr_low: u32,
    pub board_i2c_feature_id: u8,
    pub board_i2c_feature_gpio_id: u8,
    pub board_i2c_feature_slave_addr: u8,
    pub reserved3: u8,
    pub bootup_mvddq_mv: u16,
    pub bootup_mvpp_mv: u16,
    pub zfbstartaddrin16mb: u32,
    pub pplib_pptable_id: u32,
    pub reserved2: [u32; 2usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_firmware_info_v3_4 {
    pub table_header: atom_common_table_header,
    pub firmware_revision: u32,
    pub bootup_sclk_in10khz: u32,
    pub bootup_mclk_in10khz: u32,
    pub firmware_capability: u32,
    pub main_call_parser_entry: u32,
    pub bios_scratch_reg_startaddr: u32,
    pub bootup_vddc_mv: u16,
    pub bootup_vddci_mv: u16,
    pub bootup_mvddc_mv: u16,
    pub bootup_vddgfx_mv: u16,
    pub mem_module_id: u8,
    pub coolingsolution_id: u8,
    pub reserved1: [u8; 2usize],
    pub mc_baseaddr_high: u32,
    pub mc_baseaddr_low: u32,
    pub board_i2c_feature_id: u8,
    pub board_i2c_feature_gpio_id: u8,
    pub board_i2c_feature_slave_addr: u8,
    pub ras_rom_i2c_slave_addr: u8,
    pub bootup_mvddq_mv: u16,
    pub bootup_mvpp_mv: u16,
    pub zfbstartaddrin16mb: u32,
    pub pplib_pptable_id: u32,
    pub mvdd_ratio: u32,
    pub hw_bootup_vddgfx_mv: u16,
    pub hw_bootup_vddc_mv: u16,
    pub hw_bootup_mvddc_mv: u16,
    pub hw_bootup_vddci_mv: u16,
    pub maco_pwrlimit_mw: u32,
    pub usb_pwrlimit_mw: u32,
    pub fw_reserved_size_in_kb: u32,
    pub pspbl_init_done_reg_addr: u32,
    pub pspbl_init_done_value: u32,
    pub pspbl_init_done_check_timeout: u32,
    pub reserved: [u32; 2usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_firmware_info_v3_5 {
    pub table_header: atom_common_table_header,
    pub firmware_revision: u32,
    pub bootup_clk_reserved: [u32; 2usize],
    pub firmware_capability: u32,
    pub fw_protect_region_size_in_kb: u32,
    pub bios_scratch_reg_startaddr: u32,
    pub bootup_voltage_reserved: [u32; 2usize],
    pub mem_module_id: u8,
    pub coolingsolution_id: u8,
    pub hw_blt_mode: u8,
    pub reserved1: u8,
    pub mc_baseaddr_high: u32,
    pub mc_baseaddr_low: u32,
    pub board_i2c_feature_id: u8,
    pub board_i2c_feature_gpio_id: u8,
    pub board_i2c_feature_slave_addr: u8,
    pub ras_rom_i2c_slave_addr: u8,
    pub bootup_voltage_reserved1: u32,
    pub zfb_reserved: u32,
    pub pplib_pptable_id: u32,
    pub hw_voltage_reserved: [u32; 3usize],
    pub maco_pwrlimit_mw: u32,
    pub usb_pwrlimit_mw: u32,
    pub fw_reserved_size_in_kb: u32,
    pub pspbl_init_reserved: [u32; 3usize],
    pub spi_rom_size: u32,
    pub support_dev_in_objinfo: u16,
    pub disp_phy_tunning_size: u16,
    pub reserved: [u32; 16usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct lcd_info_v2_1 {
    pub table_header: atom_common_table_header,
    pub lcd_timing: atom_dtd_format,
    pub backlight_pwm: u16,
    pub special_handle_cap: u16,
    pub panel_misc: u16,
    pub lvds_max_slink_pclk: u16,
    pub lvds_ss_percentage: u16,
    pub lvds_ss_rate_10hz: u16,
    pub pwr_on_digon_to_de: u8,
    pub pwr_on_de_to_vary_bl: u8,
    pub pwr_down_vary_bloff_to_de: u8,
    pub pwr_down_de_to_digoff: u8,
    pub pwr_off_delay: u8,
    pub pwr_on_vary_bl_to_blon: u8,
    pub pwr_down_bloff_to_vary_bloff: u8,
    pub panel_bpc: u8,
    pub dpcd_edp_config_cap: u8,
    pub dpcd_max_link_rate: u8,
    pub dpcd_max_lane_count: u8,
    pub dpcd_max_downspread: u8,
    pub min_allowed_bl_level: u8,
    pub max_allowed_bl_level: u8,
    pub bootup_bl_level: u8,
    pub dplvdsrxid: u8,
    pub reserved1: [u32; 8usize],
}
pub const atom_lcd_info_panel_misc_ATOM_PANEL_MISC_FPDI: atom_lcd_info_panel_misc = 2;
pub type atom_lcd_info_panel_misc = ::core::ffi::c_uint;
pub const atom_lcd_info_dptolvds_rx_id_eDP_TO_LVDS_RX_DISABLE: atom_lcd_info_dptolvds_rx_id = 0;
pub const atom_lcd_info_dptolvds_rx_id_eDP_TO_LVDS_COMMON_ID: atom_lcd_info_dptolvds_rx_id = 1;
pub const atom_lcd_info_dptolvds_rx_id_eDP_TO_LVDS_REALTEK_ID: atom_lcd_info_dptolvds_rx_id = 2;
pub type atom_lcd_info_dptolvds_rx_id = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gpio_pin_assignment {
    pub data_a_reg_index: u32,
    pub gpio_bitshift: u8,
    pub gpio_mask_bitshift: u8,
    pub gpio_id: u8,
    pub reserved: u8,
}
pub const atom_gpio_pin_assignment_gpio_id_I2C_HW_LANE_MUX: atom_gpio_pin_assignment_gpio_id = 15;
pub const atom_gpio_pin_assignment_gpio_id_I2C_HW_ENGINE_ID_MASK: atom_gpio_pin_assignment_gpio_id =
    112;
pub const atom_gpio_pin_assignment_gpio_id_I2C_HW_CAP: atom_gpio_pin_assignment_gpio_id = 128;
pub const atom_gpio_pin_assignment_gpio_id_PCIE_VDDC_CONTROL_GPIO_PINID:
    atom_gpio_pin_assignment_gpio_id = 56;
pub const atom_gpio_pin_assignment_gpio_id_PP_AC_DC_SWITCH_GPIO_PINID:
    atom_gpio_pin_assignment_gpio_id = 60;
pub const atom_gpio_pin_assignment_gpio_id_VDDC_VRHOT_GPIO_PINID: atom_gpio_pin_assignment_gpio_id =
    61;
pub const atom_gpio_pin_assignment_gpio_id_VDDC_PCC_GPIO_PINID: atom_gpio_pin_assignment_gpio_id =
    62;
pub const atom_gpio_pin_assignment_gpio_id_EFUSE_CUT_ENABLE_GPIO_PINID:
    atom_gpio_pin_assignment_gpio_id = 63;
pub const atom_gpio_pin_assignment_gpio_id_DRAM_SELF_REFRESH_GPIO_PINID:
    atom_gpio_pin_assignment_gpio_id = 64;
pub const atom_gpio_pin_assignment_gpio_id_THERMAL_INT_OUTPUT_GPIO_PINID:
    atom_gpio_pin_assignment_gpio_id = 65;
pub type atom_gpio_pin_assignment_gpio_id = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gpio_pin_lut_v2_1 {
    pub table_header: atom_common_table_header,
    pub gpio_pin: [atom_gpio_pin_assignment; 8usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct vram_usagebyfirmware_v2_1 {
    pub table_header: atom_common_table_header,
    pub start_address_in_kb: u32,
    pub used_by_firmware_in_kb: u16,
    pub used_by_driver_in_kb: u16,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct vram_usagebyfirmware_v2_2 {
    pub table_header: atom_common_table_header,
    pub fw_region_start_address_in_kb: u32,
    pub used_by_firmware_in_kb: u16,
    pub reserved: u16,
    pub driver_region0_start_address_in_kb: u32,
    pub used_by_driver_region0_in_kb: u32,
    pub reserved32: [u32; 7usize],
}
pub const atom_object_record_type_id_ATOM_I2C_RECORD_TYPE: atom_object_record_type_id = 1;
pub const atom_object_record_type_id_ATOM_HPD_INT_RECORD_TYPE: atom_object_record_type_id = 2;
pub const atom_object_record_type_id_ATOM_CONNECTOR_CAP_RECORD_TYPE: atom_object_record_type_id = 3;
pub const atom_object_record_type_id_ATOM_CONNECTOR_SPEED_UPTO: atom_object_record_type_id = 4;
pub const atom_object_record_type_id_ATOM_OBJECT_GPIO_CNTL_RECORD_TYPE: atom_object_record_type_id =
    9;
pub const atom_object_record_type_id_ATOM_CONNECTOR_HPDPIN_LUT_RECORD_TYPE:
    atom_object_record_type_id = 16;
pub const atom_object_record_type_id_ATOM_CONNECTOR_AUXDDC_LUT_RECORD_TYPE:
    atom_object_record_type_id = 17;
pub const atom_object_record_type_id_ATOM_ENCODER_CAP_RECORD_TYPE: atom_object_record_type_id = 20;
pub const atom_object_record_type_id_ATOM_BRACKET_LAYOUT_RECORD_TYPE: atom_object_record_type_id =
    21;
pub const atom_object_record_type_id_ATOM_CONNECTOR_FORCED_TMDS_CAP_RECORD_TYPE:
    atom_object_record_type_id = 22;
pub const atom_object_record_type_id_ATOM_DISP_CONNECTOR_CAPS_RECORD_TYPE:
    atom_object_record_type_id = 23;
pub const atom_object_record_type_id_ATOM_BRACKET_LAYOUT_V2_RECORD_TYPE:
    atom_object_record_type_id = 25;
pub const atom_object_record_type_id_ATOM_RECORD_END_TYPE: atom_object_record_type_id = 255;
pub type atom_object_record_type_id = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_common_record_header {
    pub record_type: u8,
    pub record_size: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_i2c_record {
    pub record_header: atom_common_record_header,
    pub i2c_id: u8,
    pub i2c_slave_addr: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_hpd_int_record {
    pub record_header: atom_common_record_header,
    pub pin_id: u8,
    pub plugin_pin_state: u8,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_connector_caps_record {
    pub record_header: atom_common_record_header,
    pub connector_caps: u16,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_connector_speed_record {
    pub record_header: atom_common_record_header,
    pub connector_max_speed: u32,
    pub reserved: u16,
}
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_HBR2: atom_encoder_caps_def = 1;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_MST_EN: atom_encoder_caps_def = 1;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_HBR2_EN: atom_encoder_caps_def = 2;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_HDMI6Gbps_EN: atom_encoder_caps_def = 4;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_HBR3_EN: atom_encoder_caps_def = 8;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_DP2: atom_encoder_caps_def = 16;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_UHBR10_EN: atom_encoder_caps_def = 32;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_UHBR13_5_EN: atom_encoder_caps_def = 64;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_UHBR20_EN: atom_encoder_caps_def = 128;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_USB_C_TYPE: atom_encoder_caps_def = 256;
pub type atom_encoder_caps_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_encoder_caps_record {
    pub record_header: atom_common_record_header,
    pub encodercaps: u32,
}
pub const atom_connector_caps_def_ATOM_CONNECTOR_CAP_INTERNAL_DISPLAY: atom_connector_caps_def = 1;
pub const atom_connector_caps_def_ATOM_CONNECTOR_CAP_INTERNAL_DISPLAY_BL: atom_connector_caps_def =
    2;
pub type atom_connector_caps_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_disp_connector_caps_record {
    pub record_header: atom_common_record_header,
    pub connectcaps: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gpio_pin_control_pair {
    pub gpio_id: u8,
    pub gpio_pinstate: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_object_gpio_cntl_record {
    pub record_header: atom_common_record_header,
    pub flag: u8,
    pub number_of_pins: u8,
    pub gpio: [atom_gpio_pin_control_pair; 1usize],
}
pub const atom_gpio_pin_control_pinstate_def_GPIO_PIN_TYPE_INPUT:
    atom_gpio_pin_control_pinstate_def = 0;
pub const atom_gpio_pin_control_pinstate_def_GPIO_PIN_TYPE_OUTPUT:
    atom_gpio_pin_control_pinstate_def = 16;
pub const atom_gpio_pin_control_pinstate_def_GPIO_PIN_TYPE_HW_CONTROL:
    atom_gpio_pin_control_pinstate_def = 32;
pub const atom_gpio_pin_control_pinstate_def_GPIO_PIN_OUTPUT_STATE_MASK:
    atom_gpio_pin_control_pinstate_def = 1;
pub const atom_gpio_pin_control_pinstate_def_GPIO_PIN_OUTPUT_STATE_SHIFT:
    atom_gpio_pin_control_pinstate_def = 0;
pub const atom_gpio_pin_control_pinstate_def_GPIO_PIN_STATE_ACTIVE_LOW:
    atom_gpio_pin_control_pinstate_def = 0;
pub const atom_gpio_pin_control_pinstate_def_GPIO_PIN_STATE_ACTIVE_HIGH:
    atom_gpio_pin_control_pinstate_def = 1;
pub type atom_gpio_pin_control_pinstate_def = ::core::ffi::c_uint;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_REFCLK:
    atom_glsync_record_gpio_index_def = 0;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_HSYNC:
    atom_glsync_record_gpio_index_def = 1;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_VSYNC:
    atom_glsync_record_gpio_index_def = 2;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_SWAP_REQ:
    atom_glsync_record_gpio_index_def = 3;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_SWAP_GNT:
    atom_glsync_record_gpio_index_def = 4;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_INTERRUPT:
    atom_glsync_record_gpio_index_def = 5;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_V_RESET:
    atom_glsync_record_gpio_index_def = 6;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_SWAP_CNTL:
    atom_glsync_record_gpio_index_def = 7;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_SWAP_SEL:
    atom_glsync_record_gpio_index_def = 8;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_MAX:
    atom_glsync_record_gpio_index_def = 9;
pub type atom_glsync_record_gpio_index_def = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_connector_hpdpin_lut_record {
    pub record_header: atom_common_record_header,
    pub hpd_pin_map: [u8; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_connector_auxddc_lut_record {
    pub record_header: atom_common_record_header,
    pub aux_ddc_map: [u8; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_connector_forced_tmds_cap_record {
    pub record_header: atom_common_record_header,
    pub maxtmdsclkrate_in2_5mhz: u8,
    pub reserved: u8,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_connector_layout_info {
    pub connectorobjid: u16,
    pub connector_type: u8,
    pub position: u8,
}
pub const atom_connector_layout_info_connector_type_def_CONNECTOR_TYPE_DVI_D:
    atom_connector_layout_info_connector_type_def = 1;
pub const atom_connector_layout_info_connector_type_def_CONNECTOR_TYPE_HDMI:
    atom_connector_layout_info_connector_type_def = 4;
pub const atom_connector_layout_info_connector_type_def_CONNECTOR_TYPE_DISPLAY_PORT:
    atom_connector_layout_info_connector_type_def = 5;
pub const atom_connector_layout_info_connector_type_def_CONNECTOR_TYPE_MINI_DISPLAY_PORT:
    atom_connector_layout_info_connector_type_def = 6;
pub type atom_connector_layout_info_connector_type_def = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_bracket_layout_record {
    pub record_header: atom_common_record_header,
    pub bracketlen: u8,
    pub bracketwidth: u8,
    pub conn_num: u8,
    pub reserved: u8,
    pub conn_info: [atom_connector_layout_info; 1usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_bracket_layout_record_v2 {
    pub record_header: atom_common_record_header,
    pub bracketlen: u8,
    pub bracketwidth: u8,
    pub conn_num: u8,
    pub mini_type: u8,
    pub reserved1: u8,
    pub reserved2: u8,
}
pub const atom_connector_layout_info_mini_type_def_MINI_TYPE_NORMAL:
    atom_connector_layout_info_mini_type_def = 0;
pub const atom_connector_layout_info_mini_type_def_MINI_TYPE_MINI:
    atom_connector_layout_info_mini_type_def = 1;
pub type atom_connector_layout_info_mini_type_def = ::core::ffi::c_uint;
pub const atom_display_device_tag_def_ATOM_DISPLAY_LCD1_SUPPORT: atom_display_device_tag_def = 2;
pub const atom_display_device_tag_def_ATOM_DISPLAY_LCD2_SUPPORT: atom_display_device_tag_def = 32;
pub const atom_display_device_tag_def_ATOM_DISPLAY_DFP1_SUPPORT: atom_display_device_tag_def = 8;
pub const atom_display_device_tag_def_ATOM_DISPLAY_DFP2_SUPPORT: atom_display_device_tag_def = 128;
pub const atom_display_device_tag_def_ATOM_DISPLAY_DFP3_SUPPORT: atom_display_device_tag_def = 512;
pub const atom_display_device_tag_def_ATOM_DISPLAY_DFP4_SUPPORT: atom_display_device_tag_def = 1024;
pub const atom_display_device_tag_def_ATOM_DISPLAY_DFP5_SUPPORT: atom_display_device_tag_def = 2048;
pub const atom_display_device_tag_def_ATOM_DISPLAY_DFP6_SUPPORT: atom_display_device_tag_def = 64;
pub const atom_display_device_tag_def_ATOM_DISPLAY_DFPx_SUPPORT: atom_display_device_tag_def = 3784;
pub type atom_display_device_tag_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_object_path_v2 {
    pub display_objid: u16,
    pub disp_recordoffset: u16,
    pub encoderobjid: u16,
    pub extencoderobjid: u16,
    pub encoder_recordoffset: u16,
    pub extencoder_recordoffset: u16,
    pub device_tag: u16,
    pub priority_id: u8,
    pub reserved: u8,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_object_path_v3 {
    pub display_objid: u16,
    pub disp_recordoffset: u16,
    pub encoderobjid: u16,
    pub reserved1: u16,
    pub reserved2: u16,
    pub reserved3: u16,
    pub device_tag: u16,
    pub reserved4: u16,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct display_object_info_table_v1_4 {
    pub table_header: atom_common_table_header,
    pub supporteddevices: u16,
    pub number_of_path: u8,
    pub reserved: u8,
    pub display_path: [atom_display_object_path_v2; 8usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct display_object_info_table_v1_5 {
    pub table_header: atom_common_table_header,
    pub supporteddevices: u16,
    pub number_of_path: u8,
    pub reserved: u8,
    pub display_path: [atom_display_object_path_v3; 8usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_controller_info_v4_1 {
    pub table_header: atom_common_table_header,
    pub display_caps: u32,
    pub bootup_dispclk_10khz: u32,
    pub dce_refclk_10khz: u16,
    pub i2c_engine_refclk_10khz: u16,
    pub dvi_ss_percentage: u16,
    pub dvi_ss_rate_10hz: u16,
    pub hdmi_ss_percentage: u16,
    pub hdmi_ss_rate_10hz: u16,
    pub dp_ss_percentage: u16,
    pub dp_ss_rate_10hz: u16,
    pub dvi_ss_mode: u8,
    pub hdmi_ss_mode: u8,
    pub dp_ss_mode: u8,
    pub ss_reserved: u8,
    pub hardcode_mode_num: u8,
    pub reserved1: [u8; 3usize],
    pub dpphy_refclk_10khz: u16,
    pub reserved2: u16,
    pub dceip_min_ver: u8,
    pub dceip_max_ver: u8,
    pub max_disp_pipe_num: u8,
    pub max_vbios_active_disp_pipe_num: u8,
    pub max_ppll_num: u8,
    pub max_disp_phy_num: u8,
    pub max_aux_pairs: u8,
    pub remotedisplayconfig: u8,
    pub reserved3: [u8; 8usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_controller_info_v4_2 {
    pub table_header: atom_common_table_header,
    pub display_caps: u32,
    pub bootup_dispclk_10khz: u32,
    pub dce_refclk_10khz: u16,
    pub i2c_engine_refclk_10khz: u16,
    pub dvi_ss_percentage: u16,
    pub dvi_ss_rate_10hz: u16,
    pub hdmi_ss_percentage: u16,
    pub hdmi_ss_rate_10hz: u16,
    pub dp_ss_percentage: u16,
    pub dp_ss_rate_10hz: u16,
    pub dvi_ss_mode: u8,
    pub hdmi_ss_mode: u8,
    pub dp_ss_mode: u8,
    pub ss_reserved: u8,
    pub dfp_hardcode_mode_num: u8,
    pub dfp_hardcode_refreshrate: u8,
    pub vga_hardcode_mode_num: u8,
    pub vga_hardcode_refreshrate: u8,
    pub dpphy_refclk_10khz: u16,
    pub reserved2: u16,
    pub dcnip_min_ver: u8,
    pub dcnip_max_ver: u8,
    pub max_disp_pipe_num: u8,
    pub max_vbios_active_disp_pipe_num: u8,
    pub max_ppll_num: u8,
    pub max_disp_phy_num: u8,
    pub max_aux_pairs: u8,
    pub remotedisplayconfig: u8,
    pub reserved3: [u8; 8usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_controller_info_v4_3 {
    pub table_header: atom_common_table_header,
    pub display_caps: u32,
    pub bootup_dispclk_10khz: u32,
    pub dce_refclk_10khz: u16,
    pub i2c_engine_refclk_10khz: u16,
    pub dvi_ss_percentage: u16,
    pub dvi_ss_rate_10hz: u16,
    pub hdmi_ss_percentage: u16,
    pub hdmi_ss_rate_10hz: u16,
    pub dp_ss_percentage: u16,
    pub dp_ss_rate_10hz: u16,
    pub dvi_ss_mode: u8,
    pub hdmi_ss_mode: u8,
    pub dp_ss_mode: u8,
    pub ss_reserved: u8,
    pub dfp_hardcode_mode_num: u8,
    pub dfp_hardcode_refreshrate: u8,
    pub vga_hardcode_mode_num: u8,
    pub vga_hardcode_refreshrate: u8,
    pub dpphy_refclk_10khz: u16,
    pub reserved2: u16,
    pub dcnip_min_ver: u8,
    pub dcnip_max_ver: u8,
    pub max_disp_pipe_num: u8,
    pub max_vbios_active_disp_pipe_num: u8,
    pub max_ppll_num: u8,
    pub max_disp_phy_num: u8,
    pub max_aux_pairs: u8,
    pub remotedisplayconfig: u8,
    pub reserved3: [u8; 8usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_controller_info_v4_4 {
    pub table_header: atom_common_table_header,
    pub display_caps: u32,
    pub bootup_dispclk_10khz: u32,
    pub dce_refclk_10khz: u16,
    pub i2c_engine_refclk_10khz: u16,
    pub dvi_ss_percentage: u16,
    pub dvi_ss_rate_10hz: u16,
    pub hdmi_ss_percentage: u16,
    pub hdmi_ss_rate_10hz: u16,
    pub dp_ss_percentage: u16,
    pub dp_ss_rate_10hz: u16,
    pub dvi_ss_mode: u8,
    pub hdmi_ss_mode: u8,
    pub dp_ss_mode: u8,
    pub ss_reserved: u8,
    pub dfp_hardcode_mode_num: u8,
    pub dfp_hardcode_refreshrate: u8,
    pub vga_hardcode_mode_num: u8,
    pub vga_hardcode_refreshrate: u8,
    pub dpphy_refclk_10khz: u16,
    pub hw_chip_id: u16,
    pub dcnip_min_ver: u8,
    pub dcnip_max_ver: u8,
    pub max_disp_pipe_num: u8,
    pub max_vbios_active_disp_pipum: u8,
    pub max_ppll_num: u8,
    pub max_disp_phy_num: u8,
    pub max_aux_pairs: u8,
    pub remotedisplayconfig: u8,
    pub dispclk_pll_vco_freq: u32,
    pub dp_ref_clk_freq: u32,
    pub max_mclk_chg_lat: u32,
    pub max_sr_exit_lat: u32,
    pub max_sr_enter_exit_lat: u32,
    pub dc_golden_table_offset: u16,
    pub dc_golden_table_ver: u16,
    pub reserved3: [u32; 3usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_dc_golden_table_v1 {
    pub aux_dphy_rx_control0_val: u32,
    pub aux_dphy_tx_control_val: u32,
    pub aux_dphy_rx_control1_val: u32,
    pub dc_gpio_aux_ctrl_0_val: u32,
    pub dc_gpio_aux_ctrl_1_val: u32,
    pub dc_gpio_aux_ctrl_2_val: u32,
    pub dc_gpio_aux_ctrl_3_val: u32,
    pub dc_gpio_aux_ctrl_4_val: u32,
    pub dc_gpio_aux_ctrl_5_val: u32,
    pub reserved: [u32; 23usize],
}
pub const dce_info_caps_def_DCE_INFO_CAPS_FORCE_DISPDEV_CONNECTED: dce_info_caps_def = 2;
pub const dce_info_caps_def_DCE_INFO_CAPS_DISABLE_DFP_DP_HBR2: dce_info_caps_def = 4;
pub const dce_info_caps_def_DCE_INFO_CAPS_ENABLE_INTERLAC_TIMING: dce_info_caps_def = 8;
pub const dce_info_caps_def_DCE_INFO_CAPS_LTTPR_SUPPORT_ENABLE: dce_info_caps_def = 32;
pub const dce_info_caps_def_DCE_INFO_CAPS_VBIOS_LTTPR_TRANSPARENT_ENABLE: dce_info_caps_def = 64;
pub type dce_info_caps_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_controller_info_v4_5 {
    pub table_header: atom_common_table_header,
    pub display_caps: u32,
    pub bootup_dispclk_10khz: u32,
    pub dce_refclk_10khz: u16,
    pub i2c_engine_refclk_10khz: u16,
    pub dvi_ss_percentage: u16,
    pub dvi_ss_rate_10hz: u16,
    pub hdmi_ss_percentage: u16,
    pub hdmi_ss_rate_10hz: u16,
    pub dp_ss_percentage: u16,
    pub dp_ss_rate_10hz: u16,
    pub dvi_ss_mode: u8,
    pub hdmi_ss_mode: u8,
    pub dp_ss_mode: u8,
    pub ss_reserved: u8,
    pub dfp_hardcode_mode_num: u8,
    pub dfp_hardcode_refreshrate: u8,
    pub vga_hardcode_mode_num: u8,
    pub vga_hardcode_refreshrate: u8,
    pub dpphy_refclk_10khz: u16,
    pub hw_chip_id: u16,
    pub dcnip_min_ver: u8,
    pub dcnip_max_ver: u8,
    pub max_disp_pipe_num: u8,
    pub max_vbios_active_disp_pipe_num: u8,
    pub max_ppll_num: u8,
    pub max_disp_phy_num: u8,
    pub max_aux_pairs: u8,
    pub remotedisplayconfig: u8,
    pub dispclk_pll_vco_freq: u32,
    pub dp_ref_clk_freq: u32,
    pub max_mclk_chg_lat: u32,
    pub max_sr_exit_lat: u32,
    pub max_sr_enter_exit_lat: u32,
    pub dc_golden_table_offset: u16,
    pub dc_golden_table_ver: u16,
    pub aux_dphy_rx_control0_val: u32,
    pub aux_dphy_tx_control_val: u32,
    pub aux_dphy_rx_control1_val: u32,
    pub dc_gpio_aux_ctrl_0_val: u32,
    pub dc_gpio_aux_ctrl_1_val: u32,
    pub dc_gpio_aux_ctrl_2_val: u32,
    pub dc_gpio_aux_ctrl_3_val: u32,
    pub dc_gpio_aux_ctrl_4_val: u32,
    pub dc_gpio_aux_ctrl_5_val: u32,
    pub reserved: [u32; 26usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_ext_display_path {
    pub device_tag: u16,
    pub device_acpi_enum: u16,
    pub connectorobjid: u16,
    pub auxddclut_index: u8,
    pub hpdlut_index: u8,
    pub ext_encoder_objid: u16,
    pub channelmapping: u8,
    pub chpninvert: u8,
    pub caps: u16,
    pub reserved: u16,
}
pub const ext_display_path_cap_def_EXT_DISPLAY_PATH_CAPS__HBR2_DISABLE: ext_display_path_cap_def =
    1;
pub const ext_display_path_cap_def_EXT_DISPLAY_PATH_CAPS__DP_FIXED_VS_EN: ext_display_path_cap_def =
    2;
pub const ext_display_path_cap_def_EXT_DISPLAY_PATH_CAPS__EXT_CHIP_MASK: ext_display_path_cap_def =
    124;
pub const ext_display_path_cap_def_EXT_DISPLAY_PATH_CAPS__HDMI20_PI3EQX1204:
    ext_display_path_cap_def = 4;
pub const ext_display_path_cap_def_EXT_DISPLAY_PATH_CAPS__HDMI20_TISN65DP159RSBT:
    ext_display_path_cap_def = 8;
pub const ext_display_path_cap_def_EXT_DISPLAY_PATH_CAPS__HDMI20_PARADE_PS175:
    ext_display_path_cap_def = 12;
pub type ext_display_path_cap_def = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_external_display_connection_info {
    pub table_header: atom_common_table_header,
    pub guid: [u8; 16usize],
    pub path: [atom_ext_display_path; 7usize],
    pub checksum: u8,
    pub stereopinid: u8,
    pub remotedisplayconfig: u8,
    pub edptolvdsrxid: u8,
    pub fixdpvoltageswing: u8,
    pub reserved: [u8; 3usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_camera_dphy_timing_param {
    pub profile_id: u8,
    pub param: u32,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_camera_dphy_elec_param {
    pub param: [u16; 3usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_camera_module_info {
    pub module_id: u8,
    pub module_name: [u8; 8usize],
    pub timingparam: [atom_camera_dphy_timing_param; 6usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_camera_flashlight_info {
    pub flashlight_id: u8,
    pub name: [u8; 8usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_camera_data {
    pub versionCode: u32,
    pub cameraInfo: [atom_camera_module_info; 3usize],
    pub flashInfo: atom_camera_flashlight_info,
    pub dphy_param: atom_camera_dphy_elec_param,
    pub crc_val: u32,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_14nm_dpphy_dvihdmi_tuningset {
    pub max_symclk_in10khz: u32,
    pub encoder_mode: u8,
    pub phy_sel: u8,
    pub margindeemph: u16,
    pub deemph_6db_4: u8,
    pub boostadj: u8,
    pub tx_driver_fifty_ohms: u8,
    pub deemph_sel: u8,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_14nm_dpphy_dp_setting {
    pub dp_vs_pemph_level: u8,
    pub margindeemph: u16,
    pub deemph_6db_4: u8,
    pub boostadj: u8,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_14nm_dpphy_dp_tuningset {
    pub phy_sel: u8,
    pub version: u8,
    pub table_size: u16,
    pub reserved: u16,
    pub dptuning: [atom_14nm_dpphy_dp_setting; 10usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_14nm_dig_transmitter_info_header_v4_0 {
    pub table_header: atom_common_table_header,
    pub pcie_phy_tmds_hdmi_macro_settings_offset: u16,
    pub uniphy_vs_emph_lookup_table_offset: u16,
    pub uniphy_xbar_settings_table_offset: u16,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_14nm_combphy_tmds_vs_set {
    pub sym_clk: u8,
    pub dig_mode: u8,
    pub phy_sel: u8,
    pub common_mar_deemph_nom__margin_deemph_val: u16,
    pub common_seldeemph60__deemph_6db_4_val: u8,
    pub cmd_bus_global_for_tx_lane0__boostadj_val: u8,
    pub common_zcalcode_ctrl__tx_driver_fifty_ohms_val: u8,
    pub margin_deemph_lane0__deemph_sel_val: u8,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_DCN_dpphy_dvihdmi_tuningset {
    pub max_symclk_in10khz: u32,
    pub encoder_mode: u8,
    pub phy_sel: u8,
    pub tx_eq_main: u8,
    pub tx_eq_pre: u8,
    pub tx_eq_post: u8,
    pub reserved1: u8,
    pub tx_vboost_lvl: u8,
    pub reserved2: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_DCN_dpphy_dp_setting {
    pub dp_vs_pemph_level: u8,
    pub tx_eq_main: u8,
    pub tx_eq_pre: u8,
    pub tx_eq_post: u8,
    pub tx_vboost_lvl: u8,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_DCN_dpphy_dp_tuningset {
    pub phy_sel: u8,
    pub version: u8,
    pub table_size: u16,
    pub reserved: u16,
    pub dptunings: [atom_DCN_dpphy_dp_setting; 10usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_i2c_reg_info {
    pub ucI2cRegIndex: u8,
    pub ucI2cRegVal: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_hdmi_retimer_redriver_set {
    pub HdmiSlvAddr: u8,
    pub HdmiRegNum: u8,
    pub Hdmi6GRegNum: u8,
    pub HdmiRegSetting: [atom_i2c_reg_info; 9usize],
    pub Hdmi6GhzRegSetting: [atom_i2c_reg_info; 3usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_integrated_system_info_v1_11 {
    pub table_header: atom_common_table_header,
    pub vbios_misc: u32,
    pub gpucapinfo: u32,
    pub system_config: u32,
    pub cpucapinfo: u32,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_type: u16,
    pub lvds_ss_percentage: u16,
    pub lvds_ss_rate_10hz: u16,
    pub hdmi_ss_percentage: u16,
    pub hdmi_ss_rate_10hz: u16,
    pub dvi_ss_percentage: u16,
    pub dvi_ss_rate_10hz: u16,
    pub dpphy_override: u16,
    pub lvds_misc: u16,
    pub backlight_pwm_hz: u16,
    pub memorytype: u8,
    pub umachannelnumber: u8,
    pub pwr_on_digon_to_de: u8,
    pub pwr_on_de_to_vary_bl: u8,
    pub pwr_down_vary_bloff_to_de: u8,
    pub pwr_down_de_to_digoff: u8,
    pub pwr_off_delay: u8,
    pub pwr_on_vary_bl_to_blon: u8,
    pub pwr_down_bloff_to_vary_bloff: u8,
    pub min_allowed_bl_level: u8,
    pub htc_hyst_limit: u8,
    pub htc_tmp_limit: u8,
    pub reserved1: u8,
    pub reserved2: u8,
    pub extdispconninfo: atom_external_display_connection_info,
    pub dvi_tuningset: atom_14nm_dpphy_dvihdmi_tuningset,
    pub hdmi_tuningset: atom_14nm_dpphy_dvihdmi_tuningset,
    pub hdmi6g_tuningset: atom_14nm_dpphy_dvihdmi_tuningset,
    pub dp_tuningset: atom_14nm_dpphy_dp_tuningset,
    pub dp_hbr3_tuningset: atom_14nm_dpphy_dp_tuningset,
    pub camera_info: atom_camera_data,
    pub dp0_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp1_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp2_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp3_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp_hbr_tuningset: atom_14nm_dpphy_dp_tuningset,
    pub dp_hbr2_tuningset: atom_14nm_dpphy_dp_tuningset,
    pub edp_tuningset: atom_14nm_dpphy_dp_tuningset,
    pub reserved: [u32; 66usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_integrated_system_info_v1_12 {
    pub table_header: atom_common_table_header,
    pub vbios_misc: u32,
    pub gpucapinfo: u32,
    pub system_config: u32,
    pub cpucapinfo: u32,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_type: u16,
    pub lvds_ss_percentage: u16,
    pub lvds_ss_rate_10hz: u16,
    pub hdmi_ss_percentage: u16,
    pub hdmi_ss_rate_10hz: u16,
    pub dvi_ss_percentage: u16,
    pub dvi_ss_rate_10hz: u16,
    pub dpphy_override: u16,
    pub lvds_misc: u16,
    pub backlight_pwm_hz: u16,
    pub memorytype: u8,
    pub umachannelnumber: u8,
    pub pwr_on_digon_to_de: u8,
    pub pwr_on_de_to_vary_bl: u8,
    pub pwr_down_vary_bloff_to_de: u8,
    pub pwr_down_de_to_digoff: u8,
    pub pwr_off_delay: u8,
    pub pwr_on_vary_bl_to_blon: u8,
    pub pwr_down_bloff_to_vary_bloff: u8,
    pub min_allowed_bl_level: u8,
    pub htc_hyst_limit: u8,
    pub htc_tmp_limit: u8,
    pub reserved1: u8,
    pub reserved2: u8,
    pub extdispconninfo: atom_external_display_connection_info,
    pub TMDS_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub hdmiCLK5_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub hdmiCLK8_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub rbr_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub hbr3_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub camera_info: atom_camera_data,
    pub dp0_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp1_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp2_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp3_retimer_set: atom_hdmi_retimer_redriver_set,
    pub hbr_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub hbr2_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub edp_tunings: atom_DCN_dpphy_dp_tuningset,
    pub hdmiCLK6_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub reserved: [u32; 63usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct edp_info_table {
    pub edp_backlight_pwm_hz: u16,
    pub edp_ss_percentage: u16,
    pub edp_ss_rate_10hz: u16,
    pub reserved1: u16,
    pub reserved2: u32,
    pub edp_pwr_on_off_delay: u8,
    pub edp_pwr_on_vary_bl_to_blon: u8,
    pub edp_pwr_down_bloff_to_vary_bloff: u8,
    pub edp_panel_bpc: u8,
    pub edp_bootup_bl_level: u8,
    pub reserved3: [u8; 3usize],
    pub reserved4: [u32; 3usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_integrated_system_info_v2_1 {
    pub table_header: atom_common_table_header,
    pub vbios_misc: u32,
    pub gpucapinfo: u32,
    pub system_config: u32,
    pub cpucapinfo: u32,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_type: u16,
    pub dpphy_override: u16,
    pub memorytype: u8,
    pub umachannelnumber: u8,
    pub htc_hyst_limit: u8,
    pub htc_tmp_limit: u8,
    pub reserved1: u8,
    pub reserved2: u8,
    pub edp1_info: edp_info_table,
    pub edp2_info: edp_info_table,
    pub reserved3: [u32; 8usize],
    pub extdispconninfo: atom_external_display_connection_info,
    pub TMDS_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub hdmiCLK5_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub hdmiCLK6_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub hdmiCLK8_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub reserved4: [u32; 6usize],
    pub rbr_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub hbr_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub hbr2_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub hbr3_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub edp_tunings: atom_DCN_dpphy_dp_tuningset,
    pub reserved5: [u32; 28usize],
    pub dp0_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp1_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp2_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp3_retimer_set: atom_hdmi_retimer_redriver_set,
    pub reserved6: [u32; 30usize],
    pub reserved7: [u32; 32usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_n6_display_phy_tuning_set {
    pub display_signal_type: u8,
    pub phy_sel: u8,
    pub preset_level: u8,
    pub reserved1: u8,
    pub reserved2: u32,
    pub speed_upto: u32,
    pub tx_vboost_level: u8,
    pub tx_vreg_v2i: u8,
    pub tx_vregdrv_byp: u8,
    pub tx_term_cntl: u8,
    pub tx_peak_level: u8,
    pub tx_slew_en: u8,
    pub tx_eq_pre: u8,
    pub tx_eq_main: u8,
    pub tx_eq_post: u8,
    pub tx_en_inv_pre: u8,
    pub tx_en_inv_post: u8,
    pub reserved3: u8,
    pub reserved4: u32,
    pub reserved5: u32,
    pub reserved6: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_phy_tuning_info {
    pub table_header: atom_common_table_header,
    pub disp_phy_tuning: [atom_n6_display_phy_tuning_set; 1usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_integrated_system_info_v2_2 {
    pub table_header: atom_common_table_header,
    pub vbios_misc: u32,
    pub gpucapinfo: u32,
    pub system_config: u32,
    pub cpucapinfo: u32,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_type: u16,
    pub dpphy_override: u16,
    pub memorytype: u8,
    pub umachannelnumber: u8,
    pub htc_hyst_limit: u8,
    pub htc_tmp_limit: u8,
    pub reserved1: u8,
    pub reserved2: u8,
    pub edp1_info: edp_info_table,
    pub edp2_info: edp_info_table,
    pub reserved3: [u32; 8usize],
    pub extdispconninfo: atom_external_display_connection_info,
    pub reserved4: [u32; 189usize],
}
pub const atom_system_vbiosmisc_def_INTEGRATED_SYSTEM_INFO__GET_EDID_CALLBACK_FUNC_SUPPORT:
    atom_system_vbiosmisc_def = 1;
pub type atom_system_vbiosmisc_def = ::core::ffi::c_uint;
pub const atom_system_gpucapinf_def_SYS_INFO_GPUCAPS__ENABEL_DFS_BYPASS: atom_system_gpucapinf_def =
    16;
pub type atom_system_gpucapinf_def = ::core::ffi::c_uint;
pub const atom_sysinfo_dpphy_override_def_ATOM_ENABLE_DVI_TUNINGSET:
    atom_sysinfo_dpphy_override_def = 1;
pub const atom_sysinfo_dpphy_override_def_ATOM_ENABLE_HDMI_TUNINGSET:
    atom_sysinfo_dpphy_override_def = 2;
pub const atom_sysinfo_dpphy_override_def_ATOM_ENABLE_HDMI6G_TUNINGSET:
    atom_sysinfo_dpphy_override_def = 4;
pub const atom_sysinfo_dpphy_override_def_ATOM_ENABLE_DP_TUNINGSET:
    atom_sysinfo_dpphy_override_def = 8;
pub const atom_sysinfo_dpphy_override_def_ATOM_ENABLE_DP_HBR3_TUNINGSET:
    atom_sysinfo_dpphy_override_def = 16;
pub type atom_sysinfo_dpphy_override_def = ::core::ffi::c_uint;
pub const atom_sys_info_lvds_misc_def_SYS_INFO_LVDS_MISC_888_FPDI_MODE:
    atom_sys_info_lvds_misc_def = 1;
pub const atom_sys_info_lvds_misc_def_SYS_INFO_LVDS_MISC_888_BPC_MODE: atom_sys_info_lvds_misc_def =
    4;
pub const atom_sys_info_lvds_misc_def_SYS_INFO_LVDS_MISC_OVERRIDE_EN: atom_sys_info_lvds_misc_def =
    8;
pub type atom_sys_info_lvds_misc_def = ::core::ffi::c_uint;
#[doc = "< Assign 01 to Other"]
pub const atom_dmi_t17_mem_type_def_OtherMemType: atom_dmi_t17_mem_type_def = 1;
#[doc = "< Assign 02 to Unknown"]
pub const atom_dmi_t17_mem_type_def_UnknownMemType: atom_dmi_t17_mem_type_def = 2;
#[doc = "< Assign 03 to DRAM"]
pub const atom_dmi_t17_mem_type_def_DramMemType: atom_dmi_t17_mem_type_def = 3;
#[doc = "< Assign 04 to EDRAM"]
pub const atom_dmi_t17_mem_type_def_EdramMemType: atom_dmi_t17_mem_type_def = 4;
#[doc = "< Assign 05 to VRAM"]
pub const atom_dmi_t17_mem_type_def_VramMemType: atom_dmi_t17_mem_type_def = 5;
#[doc = "< Assign 06 to SRAM"]
pub const atom_dmi_t17_mem_type_def_SramMemType: atom_dmi_t17_mem_type_def = 6;
#[doc = "< Assign 07 to RAM"]
pub const atom_dmi_t17_mem_type_def_RamMemType: atom_dmi_t17_mem_type_def = 7;
#[doc = "< Assign 08 to ROM"]
pub const atom_dmi_t17_mem_type_def_RomMemType: atom_dmi_t17_mem_type_def = 8;
#[doc = "< Assign 09 to Flash"]
pub const atom_dmi_t17_mem_type_def_FlashMemType: atom_dmi_t17_mem_type_def = 9;
#[doc = "< Assign 10 to EEPROM"]
pub const atom_dmi_t17_mem_type_def_EepromMemType: atom_dmi_t17_mem_type_def = 10;
#[doc = "< Assign 11 to FEPROM"]
pub const atom_dmi_t17_mem_type_def_FepromMemType: atom_dmi_t17_mem_type_def = 11;
#[doc = "< Assign 12 to EPROM"]
pub const atom_dmi_t17_mem_type_def_EpromMemType: atom_dmi_t17_mem_type_def = 12;
#[doc = "< Assign 13 to CDRAM"]
pub const atom_dmi_t17_mem_type_def_CdramMemType: atom_dmi_t17_mem_type_def = 13;
#[doc = "< Assign 14 to 3DRAM"]
pub const atom_dmi_t17_mem_type_def_ThreeDramMemType: atom_dmi_t17_mem_type_def = 14;
#[doc = "< Assign 15 to SDRAM"]
pub const atom_dmi_t17_mem_type_def_SdramMemType: atom_dmi_t17_mem_type_def = 15;
#[doc = "< Assign 16 to SGRAM"]
pub const atom_dmi_t17_mem_type_def_SgramMemType: atom_dmi_t17_mem_type_def = 16;
#[doc = "< Assign 17 to RDRAM"]
pub const atom_dmi_t17_mem_type_def_RdramMemType: atom_dmi_t17_mem_type_def = 17;
#[doc = "< Assign 18 to DDR"]
pub const atom_dmi_t17_mem_type_def_DdrMemType: atom_dmi_t17_mem_type_def = 18;
#[doc = "< Assign 19 to DDR2"]
pub const atom_dmi_t17_mem_type_def_Ddr2MemType: atom_dmi_t17_mem_type_def = 19;
#[doc = "< Assign 20 to DDR2 FB-DIMM"]
pub const atom_dmi_t17_mem_type_def_Ddr2FbdimmMemType: atom_dmi_t17_mem_type_def = 20;
#[doc = "< Assign 24 to DDR3"]
pub const atom_dmi_t17_mem_type_def_Ddr3MemType: atom_dmi_t17_mem_type_def = 24;
#[doc = "< Assign 25 to FBD2"]
pub const atom_dmi_t17_mem_type_def_Fbd2MemType: atom_dmi_t17_mem_type_def = 25;
#[doc = "< Assign 26 to DDR4"]
pub const atom_dmi_t17_mem_type_def_Ddr4MemType: atom_dmi_t17_mem_type_def = 26;
#[doc = "< Assign 27 to LPDDR"]
pub const atom_dmi_t17_mem_type_def_LpDdrMemType: atom_dmi_t17_mem_type_def = 27;
#[doc = "< Assign 28 to LPDDR2"]
pub const atom_dmi_t17_mem_type_def_LpDdr2MemType: atom_dmi_t17_mem_type_def = 28;
#[doc = "< Assign 29 to LPDDR3"]
pub const atom_dmi_t17_mem_type_def_LpDdr3MemType: atom_dmi_t17_mem_type_def = 29;
#[doc = "< Assign 30 to LPDDR4"]
pub const atom_dmi_t17_mem_type_def_LpDdr4MemType: atom_dmi_t17_mem_type_def = 30;
#[doc = "< Assign 31 to GDDR6"]
pub const atom_dmi_t17_mem_type_def_GDdr6MemType: atom_dmi_t17_mem_type_def = 31;
#[doc = "< Assign 32 to HBM"]
pub const atom_dmi_t17_mem_type_def_HbmMemType: atom_dmi_t17_mem_type_def = 32;
#[doc = "< Assign 33 to HBM2"]
pub const atom_dmi_t17_mem_type_def_Hbm2MemType: atom_dmi_t17_mem_type_def = 33;
#[doc = "< Assign 34 to DDR5"]
pub const atom_dmi_t17_mem_type_def_Ddr5MemType: atom_dmi_t17_mem_type_def = 34;
#[doc = "< Assign 35 to LPDDR5"]
pub const atom_dmi_t17_mem_type_def_LpDdr5MemType: atom_dmi_t17_mem_type_def = 35;
pub type atom_dmi_t17_mem_type_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_fusion_system_info_v4 {
    pub sysinfo: atom_integrated_system_info_v1_11,
    pub powerplayinfo: [u32; 256usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gfx_info_v2_2 {
    pub table_header: atom_common_table_header,
    pub gfxip_min_ver: u8,
    pub gfxip_max_ver: u8,
    pub max_shader_engines: u8,
    pub max_tile_pipes: u8,
    pub max_cu_per_sh: u8,
    pub max_sh_per_se: u8,
    pub max_backends_per_se: u8,
    pub max_texture_channel_caches: u8,
    pub regaddr_cp_dma_src_addr: u32,
    pub regaddr_cp_dma_src_addr_hi: u32,
    pub regaddr_cp_dma_dst_addr: u32,
    pub regaddr_cp_dma_dst_addr_hi: u32,
    pub regaddr_cp_dma_command: u32,
    pub regaddr_cp_status: u32,
    pub regaddr_rlc_gpu_clock_32: u32,
    pub rlc_gpu_timer_refclk: u32,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gfx_info_v2_3 {
    pub table_header: atom_common_table_header,
    pub gfxip_min_ver: u8,
    pub gfxip_max_ver: u8,
    pub max_shader_engines: u8,
    pub max_tile_pipes: u8,
    pub max_cu_per_sh: u8,
    pub max_sh_per_se: u8,
    pub max_backends_per_se: u8,
    pub max_texture_channel_caches: u8,
    pub regaddr_cp_dma_src_addr: u32,
    pub regaddr_cp_dma_src_addr_hi: u32,
    pub regaddr_cp_dma_dst_addr: u32,
    pub regaddr_cp_dma_dst_addr_hi: u32,
    pub regaddr_cp_dma_command: u32,
    pub regaddr_cp_status: u32,
    pub regaddr_rlc_gpu_clock_32: u32,
    pub rlc_gpu_timer_refclk: u32,
    pub active_cu_per_sh: u8,
    pub active_rb_per_se: u8,
    pub gcgoldenoffset: u16,
    pub rm21_sram_vmin_value: u32,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gfx_info_v2_4 {
    pub table_header: atom_common_table_header,
    pub gfxip_min_ver: u8,
    pub gfxip_max_ver: u8,
    pub max_shader_engines: u8,
    pub reserved: u8,
    pub max_cu_per_sh: u8,
    pub max_sh_per_se: u8,
    pub max_backends_per_se: u8,
    pub max_texture_channel_caches: u8,
    pub regaddr_cp_dma_src_addr: u32,
    pub regaddr_cp_dma_src_addr_hi: u32,
    pub regaddr_cp_dma_dst_addr: u32,
    pub regaddr_cp_dma_dst_addr_hi: u32,
    pub regaddr_cp_dma_command: u32,
    pub regaddr_cp_status: u32,
    pub regaddr_rlc_gpu_clock_32: u32,
    pub rlc_gpu_timer_refclk: u32,
    pub active_cu_per_sh: u8,
    pub active_rb_per_se: u8,
    pub gcgoldenoffset: u16,
    pub gc_num_gprs: u16,
    pub gc_gsprim_buff_depth: u16,
    pub gc_parameter_cache_depth: u16,
    pub gc_wave_size: u16,
    pub gc_max_waves_per_simd: u16,
    pub gc_lds_size: u16,
    pub gc_num_max_gs_thds: u8,
    pub gc_gs_table_depth: u8,
    pub gc_double_offchip_lds_buffer: u8,
    pub gc_max_scratch_slots_per_cu: u8,
    pub sram_rm_fuses_val: u32,
    pub sram_custom_rm_fuses_val: u32,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gfx_info_v2_7 {
    pub table_header: atom_common_table_header,
    pub gfxip_min_ver: u8,
    pub gfxip_max_ver: u8,
    pub max_shader_engines: u8,
    pub reserved: u8,
    pub max_cu_per_sh: u8,
    pub max_sh_per_se: u8,
    pub max_backends_per_se: u8,
    pub max_texture_channel_caches: u8,
    pub regaddr_cp_dma_src_addr: u32,
    pub regaddr_cp_dma_src_addr_hi: u32,
    pub regaddr_cp_dma_dst_addr: u32,
    pub regaddr_cp_dma_dst_addr_hi: u32,
    pub regaddr_cp_dma_command: u32,
    pub regaddr_cp_status: u32,
    pub regaddr_rlc_gpu_clock_32: u32,
    pub rlc_gpu_timer_refclk: u32,
    pub active_cu_per_sh: u8,
    pub active_rb_per_se: u8,
    pub gcgoldenoffset: u16,
    pub gc_num_gprs: u16,
    pub gc_gsprim_buff_depth: u16,
    pub gc_parameter_cache_depth: u16,
    pub gc_wave_size: u16,
    pub gc_max_waves_per_simd: u16,
    pub gc_lds_size: u16,
    pub gc_num_max_gs_thds: u8,
    pub gc_gs_table_depth: u8,
    pub gc_double_offchip_lds_buffer: u8,
    pub gc_max_scratch_slots_per_cu: u8,
    pub sram_rm_fuses_val: u32,
    pub sram_custom_rm_fuses_val: u32,
    pub cut_cu: u8,
    pub active_cu_total: u8,
    pub cu_reserved: [u8; 2usize],
    pub gc_config: u32,
    pub inactive_cu_per_se: [u8; 8usize],
    pub reserved2: [u32; 6usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gfx_info_v3_0 {
    pub table_header: atom_common_table_header,
    pub gfxip_min_ver: u8,
    pub gfxip_max_ver: u8,
    pub max_shader_engines: u8,
    pub max_tile_pipes: u8,
    pub max_cu_per_sh: u8,
    pub max_sh_per_se: u8,
    pub max_backends_per_se: u8,
    pub max_texture_channel_caches: u8,
    pub regaddr_lsdma_queue0_rb_rptr: u32,
    pub regaddr_lsdma_queue0_rb_rptr_hi: u32,
    pub regaddr_lsdma_queue0_rb_wptr: u32,
    pub regaddr_lsdma_queue0_rb_wptr_hi: u32,
    pub regaddr_lsdma_command: u32,
    pub regaddr_lsdma_status: u32,
    pub regaddr_golden_tsc_count_lower: u32,
    pub golden_tsc_count_lower_refclk: u32,
    pub active_wgp_per_se: u8,
    pub active_rb_per_se: u8,
    pub active_se: u8,
    pub reserved1: u8,
    pub sram_rm_fuses_val: u32,
    pub sram_custom_rm_fuses_val: u32,
    pub inactive_sa_mask: u32,
    pub gc_config: u32,
    pub inactive_wgp: [u8; 16usize],
    pub inactive_rb: [u8; 16usize],
    pub gdfll_as_wait_ctrl_val: u32,
    pub gdfll_as_step_ctrl_val: u32,
    pub reserved: [u32; 8usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smu_info_v3_1 {
    pub table_header: atom_common_table_header,
    pub smuip_min_ver: u8,
    pub smuip_max_ver: u8,
    pub smu_rsd1: u8,
    pub gpuclk_ss_mode: u8,
    pub sclk_ss_percentage: u16,
    pub sclk_ss_rate_10hz: u16,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_rate_10hz: u16,
    pub core_refclk_10khz: u32,
    pub ac_dc_gpio_bit: u8,
    pub ac_dc_polarity: u8,
    pub vr0hot_gpio_bit: u8,
    pub vr0hot_polarity: u8,
    pub vr1hot_gpio_bit: u8,
    pub vr1hot_polarity: u8,
    pub fw_ctf_gpio_bit: u8,
    pub fw_ctf_polarity: u8,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smu_info_v3_2 {
    pub table_header: atom_common_table_header,
    pub smuip_min_ver: u8,
    pub smuip_max_ver: u8,
    pub smu_rsd1: u8,
    pub gpuclk_ss_mode: u8,
    pub sclk_ss_percentage: u16,
    pub sclk_ss_rate_10hz: u16,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_rate_10hz: u16,
    pub core_refclk_10khz: u32,
    pub ac_dc_gpio_bit: u8,
    pub ac_dc_polarity: u8,
    pub vr0hot_gpio_bit: u8,
    pub vr0hot_polarity: u8,
    pub vr1hot_gpio_bit: u8,
    pub vr1hot_polarity: u8,
    pub fw_ctf_gpio_bit: u8,
    pub fw_ctf_polarity: u8,
    pub pcc_gpio_bit: u8,
    pub pcc_gpio_polarity: u8,
    pub smugoldenoffset: u16,
    pub gpupll_vco_freq_10khz: u32,
    pub bootup_smnclk_10khz: u32,
    pub bootup_socclk_10khz: u32,
    pub bootup_mp0clk_10khz: u32,
    pub bootup_mp1clk_10khz: u32,
    pub bootup_lclk_10khz: u32,
    pub bootup_dcefclk_10khz: u32,
    pub ctf_threshold_override_value: u32,
    pub reserved: [u32; 5usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smu_info_v3_3 {
    pub table_header: atom_common_table_header,
    pub smuip_min_ver: u8,
    pub smuip_max_ver: u8,
    pub waflclk_ss_mode: u8,
    pub gpuclk_ss_mode: u8,
    pub sclk_ss_percentage: u16,
    pub sclk_ss_rate_10hz: u16,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_rate_10hz: u16,
    pub core_refclk_10khz: u32,
    pub ac_dc_gpio_bit: u8,
    pub ac_dc_polarity: u8,
    pub vr0hot_gpio_bit: u8,
    pub vr0hot_polarity: u8,
    pub vr1hot_gpio_bit: u8,
    pub vr1hot_polarity: u8,
    pub fw_ctf_gpio_bit: u8,
    pub fw_ctf_polarity: u8,
    pub pcc_gpio_bit: u8,
    pub pcc_gpio_polarity: u8,
    pub smugoldenoffset: u16,
    pub gpupll_vco_freq_10khz: u32,
    pub bootup_smnclk_10khz: u32,
    pub bootup_socclk_10khz: u32,
    pub bootup_mp0clk_10khz: u32,
    pub bootup_mp1clk_10khz: u32,
    pub bootup_lclk_10khz: u32,
    pub bootup_dcefclk_10khz: u32,
    pub ctf_threshold_override_value: u32,
    pub syspll3_0_vco_freq_10khz: u32,
    pub syspll3_1_vco_freq_10khz: u32,
    pub bootup_fclk_10khz: u32,
    pub bootup_waflclk_10khz: u32,
    pub smu_info_caps: u32,
    pub waflclk_ss_percentage: u16,
    pub smuinitoffset: u16,
    pub reserved: u32,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smu_info_v3_5 {
    pub table_header: atom_common_table_header,
    pub smuip_min_ver: u8,
    pub smuip_max_ver: u8,
    pub waflclk_ss_mode: u8,
    pub gpuclk_ss_mode: u8,
    pub sclk_ss_percentage: u16,
    pub sclk_ss_rate_10hz: u16,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_rate_10hz: u16,
    pub core_refclk_10khz: u32,
    pub syspll0_1_vco_freq_10khz: u32,
    pub syspll0_2_vco_freq_10khz: u32,
    pub pcc_gpio_bit: u8,
    pub pcc_gpio_polarity: u8,
    pub smugoldenoffset: u16,
    pub syspll0_0_vco_freq_10khz: u32,
    pub bootup_smnclk_10khz: u32,
    pub bootup_socclk_10khz: u32,
    pub bootup_mp0clk_10khz: u32,
    pub bootup_mp1clk_10khz: u32,
    pub bootup_lclk_10khz: u32,
    pub bootup_dcefclk_10khz: u32,
    pub ctf_threshold_override_value: u32,
    pub syspll3_0_vco_freq_10khz: u32,
    pub syspll3_1_vco_freq_10khz: u32,
    pub bootup_fclk_10khz: u32,
    pub bootup_waflclk_10khz: u32,
    pub smu_info_caps: u32,
    pub waflclk_ss_percentage: u16,
    pub smuinitoffset: u16,
    pub bootup_dprefclk_10khz: u32,
    pub bootup_usbclk_10khz: u32,
    pub smb_slave_address: u32,
    pub cg_fdo_ctrl0_val: u32,
    pub cg_fdo_ctrl1_val: u32,
    pub cg_fdo_ctrl2_val: u32,
    pub gdfll_as_wait_ctrl_val: u32,
    pub gdfll_as_step_ctrl_val: u32,
    pub bootup_dtbclk_10khz: u32,
    pub fclk_syspll_refclk_10khz: u32,
    pub smusvi_svc0_val: u32,
    pub smusvi_svc1_val: u32,
    pub smusvi_svd0_val: u32,
    pub smusvi_svd1_val: u32,
    pub smusvi_svt0_val: u32,
    pub smusvi_svt1_val: u32,
    pub cg_tach_ctrl_val: u32,
    pub cg_pump_ctrl1_val: u32,
    pub cg_pump_tach_ctrl_val: u32,
    pub thm_ctf_delay_val: u32,
    pub thm_thermal_int_ctrl_val: u32,
    pub thm_tmon_config_val: u32,
    pub reserved: [u32; 16usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smu_info_v3_6 {
    pub table_header: atom_common_table_header,
    pub smuip_min_ver: u8,
    pub smuip_max_ver: u8,
    pub waflclk_ss_mode: u8,
    pub gpuclk_ss_mode: u8,
    pub sclk_ss_percentage: u16,
    pub sclk_ss_rate_10hz: u16,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_rate_10hz: u16,
    pub core_refclk_10khz: u32,
    pub syspll0_1_vco_freq_10khz: u32,
    pub syspll0_2_vco_freq_10khz: u32,
    pub pcc_gpio_bit: u8,
    pub pcc_gpio_polarity: u8,
    pub smugoldenoffset: u16,
    pub syspll0_0_vco_freq_10khz: u32,
    pub bootup_smnclk_10khz: u32,
    pub bootup_socclk_10khz: u32,
    pub bootup_mp0clk_10khz: u32,
    pub bootup_mp1clk_10khz: u32,
    pub bootup_lclk_10khz: u32,
    pub bootup_dxioclk_10khz: u32,
    pub ctf_threshold_override_value: u32,
    pub syspll3_0_vco_freq_10khz: u32,
    pub syspll3_1_vco_freq_10khz: u32,
    pub bootup_fclk_10khz: u32,
    pub bootup_waflclk_10khz: u32,
    pub smu_info_caps: u32,
    pub waflclk_ss_percentage: u16,
    pub smuinitoffset: u16,
    pub bootup_gfxavsclk_10khz: u32,
    pub bootup_mpioclk_10khz: u32,
    pub smb_slave_address: u32,
    pub cg_fdo_ctrl0_val: u32,
    pub cg_fdo_ctrl1_val: u32,
    pub cg_fdo_ctrl2_val: u32,
    pub gdfll_as_wait_ctrl_val: u32,
    pub gdfll_as_step_ctrl_val: u32,
    pub reserved_clk: u32,
    pub fclk_syspll_refclk_10khz: u32,
    pub smusvi_svc0_val: u32,
    pub smusvi_svc1_val: u32,
    pub smusvi_svd0_val: u32,
    pub smusvi_svd1_val: u32,
    pub smusvi_svt0_val: u32,
    pub smusvi_svt1_val: u32,
    pub cg_tach_ctrl_val: u32,
    pub cg_pump_ctrl1_val: u32,
    pub cg_pump_tach_ctrl_val: u32,
    pub thm_ctf_delay_val: u32,
    pub thm_thermal_int_ctrl_val: u32,
    pub thm_tmon_config_val: u32,
    pub bootup_vclk_10khz: u32,
    pub bootup_dclk_10khz: u32,
    pub smu_gpiopad_pu_en_val: u32,
    pub smu_gpiopad_pd_en_val: u32,
    pub reserved: [u32; 12usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smu_info_v4_0 {
    pub table_header: atom_common_table_header,
    pub bootup_gfxclk_bypass_10khz: u32,
    pub bootup_usrclk_10khz: u32,
    pub bootup_csrclk_10khz: u32,
    pub core_refclk_10khz: u32,
    pub syspll1_vco_freq_10khz: u32,
    pub syspll2_vco_freq_10khz: u32,
    pub pcc_gpio_bit: u8,
    pub pcc_gpio_polarity: u8,
    pub bootup_vddusr_mv: u16,
    pub syspll0_vco_freq_10khz: u32,
    pub bootup_smnclk_10khz: u32,
    pub bootup_socclk_10khz: u32,
    pub bootup_mp0clk_10khz: u32,
    pub bootup_mp1clk_10khz: u32,
    pub bootup_lclk_10khz: u32,
    pub bootup_dcefclk_10khz: u32,
    pub ctf_threshold_override_value: u32,
    pub syspll3_vco_freq_10khz: u32,
    pub mm_syspll_vco_freq_10khz: u32,
    pub bootup_fclk_10khz: u32,
    pub bootup_waflclk_10khz: u32,
    pub smu_info_caps: u32,
    pub waflclk_ss_percentage: u16,
    pub smuinitoffset: u16,
    pub bootup_dprefclk_10khz: u32,
    pub bootup_usbclk_10khz: u32,
    pub smb_slave_address: u32,
    pub cg_fdo_ctrl0_val: u32,
    pub cg_fdo_ctrl1_val: u32,
    pub cg_fdo_ctrl2_val: u32,
    pub gdfll_as_wait_ctrl_val: u32,
    pub gdfll_as_step_ctrl_val: u32,
    pub bootup_dtbclk_10khz: u32,
    pub fclk_syspll_refclk_10khz: u32,
    pub smusvi_svc0_val: u32,
    pub smusvi_svc1_val: u32,
    pub smusvi_svd0_val: u32,
    pub smusvi_svd1_val: u32,
    pub smusvi_svt0_val: u32,
    pub smusvi_svt1_val: u32,
    pub cg_tach_ctrl_val: u32,
    pub cg_pump_ctrl1_val: u32,
    pub cg_pump_tach_ctrl_val: u32,
    pub thm_ctf_delay_val: u32,
    pub thm_thermal_int_ctrl_val: u32,
    pub thm_tmon_config_val: u32,
    pub smbus_timing_cntrl0_val: u32,
    pub smbus_timing_cntrl1_val: u32,
    pub smbus_timing_cntrl2_val: u32,
    pub pwr_disp_timer_global_control_val: u32,
    pub bootup_mpioclk_10khz: u32,
    pub bootup_dclk0_10khz: u32,
    pub bootup_vclk0_10khz: u32,
    pub bootup_dclk1_10khz: u32,
    pub bootup_vclk1_10khz: u32,
    pub bootup_baco400clk_10khz: u32,
    pub bootup_baco1200clk_bypass_10khz: u32,
    pub bootup_baco700clk_bypass_10khz: u32,
    pub reserved: [u32; 16usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_1 {
    pub table_header: atom_common_table_header,
    pub liquid1_i2c_address: u8,
    pub liquid2_i2c_address: u8,
    pub vr_i2c_address: u8,
    pub plx_i2c_address: u8,
    pub liquid_i2c_linescl: u8,
    pub liquid_i2c_linesda: u8,
    pub vr_i2c_linescl: u8,
    pub vr_i2c_linesda: u8,
    pub plx_i2c_linescl: u8,
    pub plx_i2c_linesda: u8,
    pub vrsensorpresent: u8,
    pub liquidsensorpresent: u8,
    pub maxvoltagestepgfx: u16,
    pub maxvoltagestepsoc: u16,
    pub vddgfxvrmapping: u8,
    pub vddsocvrmapping: u8,
    pub vddmem0vrmapping: u8,
    pub vddmem1vrmapping: u8,
    pub gfxulvphasesheddingmask: u8,
    pub soculvphasesheddingmask: u8,
    pub padding8_v: [u8; 2usize],
    pub gfxmaxcurrent: u16,
    pub gfxoffset: u8,
    pub padding_telemetrygfx: u8,
    pub socmaxcurrent: u16,
    pub socoffset: u8,
    pub padding_telemetrysoc: u8,
    pub mem0maxcurrent: u16,
    pub mem0offset: u8,
    pub padding_telemetrymem0: u8,
    pub mem1maxcurrent: u16,
    pub mem1offset: u8,
    pub padding_telemetrymem1: u8,
    pub acdcgpio: u8,
    pub acdcpolarity: u8,
    pub vr0hotgpio: u8,
    pub vr0hotpolarity: u8,
    pub vr1hotgpio: u8,
    pub vr1hotpolarity: u8,
    pub padding1: u8,
    pub padding2: u8,
    pub ledpin0: u8,
    pub ledpin1: u8,
    pub ledpin2: u8,
    pub padding8_4: u8,
    pub pllgfxclkspreadenabled: u8,
    pub pllgfxclkspreadpercent: u8,
    pub pllgfxclkspreadfreq: u16,
    pub uclkspreadenabled: u8,
    pub uclkspreadpercent: u8,
    pub uclkspreadfreq: u16,
    pub socclkspreadenabled: u8,
    pub socclkspreadpercent: u8,
    pub socclkspreadfreq: u16,
    pub acggfxclkspreadenabled: u8,
    pub acggfxclkspreadpercent: u8,
    pub acggfxclkspreadfreq: u16,
    pub Vr2_I2C_address: u8,
    pub padding_vr2: [u8; 3usize],
    pub boardreserved: [u32; 9usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_3 {
    pub table_header: atom_common_table_header,
    pub liquid1_i2c_address: u8,
    pub liquid2_i2c_address: u8,
    pub vr_i2c_address: u8,
    pub plx_i2c_address: u8,
    pub liquid_i2c_linescl: u8,
    pub liquid_i2c_linesda: u8,
    pub vr_i2c_linescl: u8,
    pub vr_i2c_linesda: u8,
    pub plx_i2c_linescl: u8,
    pub plx_i2c_linesda: u8,
    pub vrsensorpresent: u8,
    pub liquidsensorpresent: u8,
    pub maxvoltagestepgfx: u16,
    pub maxvoltagestepsoc: u16,
    pub vddgfxvrmapping: u8,
    pub vddsocvrmapping: u8,
    pub vddmem0vrmapping: u8,
    pub vddmem1vrmapping: u8,
    pub gfxulvphasesheddingmask: u8,
    pub soculvphasesheddingmask: u8,
    pub externalsensorpresent: u8,
    pub padding8_v: u8,
    pub gfxmaxcurrent: u16,
    pub gfxoffset: u8,
    pub padding_telemetrygfx: u8,
    pub socmaxcurrent: u16,
    pub socoffset: u8,
    pub padding_telemetrysoc: u8,
    pub mem0maxcurrent: u16,
    pub mem0offset: u8,
    pub padding_telemetrymem0: u8,
    pub mem1maxcurrent: u16,
    pub mem1offset: u8,
    pub padding_telemetrymem1: u8,
    pub acdcgpio: u8,
    pub acdcpolarity: u8,
    pub vr0hotgpio: u8,
    pub vr0hotpolarity: u8,
    pub vr1hotgpio: u8,
    pub vr1hotpolarity: u8,
    pub padding1: u8,
    pub padding2: u8,
    pub ledpin0: u8,
    pub ledpin1: u8,
    pub ledpin2: u8,
    pub padding8_4: u8,
    pub pllgfxclkspreadenabled: u8,
    pub pllgfxclkspreadpercent: u8,
    pub pllgfxclkspreadfreq: u16,
    pub uclkspreadenabled: u8,
    pub uclkspreadpercent: u8,
    pub uclkspreadfreq: u16,
    pub fclkspreadenabled: u8,
    pub fclkspreadpercent: u8,
    pub fclkspreadfreq: u16,
    pub fllgfxclkspreadenabled: u8,
    pub fllgfxclkspreadpercent: u8,
    pub fllgfxclkspreadfreq: u16,
    pub boardreserved: [u32; 10usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct smudpm_i2ccontrollerconfig_t {
    pub enabled: u32,
    pub slaveaddress: u32,
    pub controllerport: u32,
    pub controllername: u32,
    pub thermalthrottler: u32,
    pub i2cprotocol: u32,
    pub i2cspeed: u32,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_4 {
    pub table_header: atom_common_table_header,
    pub i2c_padding: [u32; 3usize],
    pub maxvoltagestepgfx: u16,
    pub maxvoltagestepsoc: u16,
    pub vddgfxvrmapping: u8,
    pub vddsocvrmapping: u8,
    pub vddmem0vrmapping: u8,
    pub vddmem1vrmapping: u8,
    pub gfxulvphasesheddingmask: u8,
    pub soculvphasesheddingmask: u8,
    pub externalsensorpresent: u8,
    pub padding8_v: u8,
    pub gfxmaxcurrent: u16,
    pub gfxoffset: u8,
    pub padding_telemetrygfx: u8,
    pub socmaxcurrent: u16,
    pub socoffset: u8,
    pub padding_telemetrysoc: u8,
    pub mem0maxcurrent: u16,
    pub mem0offset: u8,
    pub padding_telemetrymem0: u8,
    pub mem1maxcurrent: u16,
    pub mem1offset: u8,
    pub padding_telemetrymem1: u8,
    pub acdcgpio: u8,
    pub acdcpolarity: u8,
    pub vr0hotgpio: u8,
    pub vr0hotpolarity: u8,
    pub vr1hotgpio: u8,
    pub vr1hotpolarity: u8,
    pub padding1: u8,
    pub padding2: u8,
    pub ledpin0: u8,
    pub ledpin1: u8,
    pub ledpin2: u8,
    pub padding8_4: u8,
    pub pllgfxclkspreadenabled: u8,
    pub pllgfxclkspreadpercent: u8,
    pub pllgfxclkspreadfreq: u16,
    pub uclkspreadenabled: u8,
    pub uclkspreadpercent: u8,
    pub uclkspreadfreq: u16,
    pub fclkspreadenabled: u8,
    pub fclkspreadpercent: u8,
    pub fclkspreadfreq: u16,
    pub fllgfxclkspreadenabled: u8,
    pub fllgfxclkspreadpercent: u8,
    pub fllgfxclkspreadfreq: u16,
    pub i2ccontrollers: [smudpm_i2ccontrollerconfig_t; 7usize],
    pub boardreserved: [u32; 10usize],
}
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_VR_GFX:
    smudpm_v4_5_i2ccontrollername_e = 0;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_VR_SOC:
    smudpm_v4_5_i2ccontrollername_e = 1;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_VR_VDDCI:
    smudpm_v4_5_i2ccontrollername_e = 2;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_VR_MVDD:
    smudpm_v4_5_i2ccontrollername_e = 3;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_LIQUID0:
    smudpm_v4_5_i2ccontrollername_e = 4;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_LIQUID1:
    smudpm_v4_5_i2ccontrollername_e = 5;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_PLX:
    smudpm_v4_5_i2ccontrollername_e = 6;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_SPARE:
    smudpm_v4_5_i2ccontrollername_e = 7;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_COUNT:
    smudpm_v4_5_i2ccontrollername_e = 8;
pub type smudpm_v4_5_i2ccontrollername_e = ::core::ffi::c_uint;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_TYPE_NONE:
    smudpm_v4_5_i2ccontrollerthrottler_e = 0;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_VR_GFX:
    smudpm_v4_5_i2ccontrollerthrottler_e = 1;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_VR_SOC:
    smudpm_v4_5_i2ccontrollerthrottler_e = 2;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_VR_VDDCI:
    smudpm_v4_5_i2ccontrollerthrottler_e = 3;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_VR_MVDD:
    smudpm_v4_5_i2ccontrollerthrottler_e = 4;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_LIQUID0:
    smudpm_v4_5_i2ccontrollerthrottler_e = 5;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_LIQUID1:
    smudpm_v4_5_i2ccontrollerthrottler_e = 6;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_PLX:
    smudpm_v4_5_i2ccontrollerthrottler_e = 7;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_COUNT:
    smudpm_v4_5_i2ccontrollerthrottler_e = 8;
pub type smudpm_v4_5_i2ccontrollerthrottler_e = ::core::ffi::c_uint;
pub const smudpm_v4_5_i2ccontrollerprotocol_e_SMC_V4_5_I2C_CONTROLLER_PROTOCOL_VR_0:
    smudpm_v4_5_i2ccontrollerprotocol_e = 0;
pub const smudpm_v4_5_i2ccontrollerprotocol_e_SMC_V4_5_I2C_CONTROLLER_PROTOCOL_VR_1:
    smudpm_v4_5_i2ccontrollerprotocol_e = 1;
pub const smudpm_v4_5_i2ccontrollerprotocol_e_SMC_V4_5_I2C_CONTROLLER_PROTOCOL_TMP_0:
    smudpm_v4_5_i2ccontrollerprotocol_e = 2;
pub const smudpm_v4_5_i2ccontrollerprotocol_e_SMC_V4_5_I2C_CONTROLLER_PROTOCOL_TMP_1:
    smudpm_v4_5_i2ccontrollerprotocol_e = 3;
pub const smudpm_v4_5_i2ccontrollerprotocol_e_SMC_V4_5_I2C_CONTROLLER_PROTOCOL_SPARE_0:
    smudpm_v4_5_i2ccontrollerprotocol_e = 4;
pub const smudpm_v4_5_i2ccontrollerprotocol_e_SMC_V4_5_I2C_CONTROLLER_PROTOCOL_SPARE_1:
    smudpm_v4_5_i2ccontrollerprotocol_e = 5;
pub const smudpm_v4_5_i2ccontrollerprotocol_e_SMC_V4_5_I2C_CONTROLLER_PROTOCOL_COUNT:
    smudpm_v4_5_i2ccontrollerprotocol_e = 6;
pub type smudpm_v4_5_i2ccontrollerprotocol_e = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct smudpm_i2c_controller_config_v2 {
    pub Enabled: u8,
    pub Speed: u8,
    pub Padding: [u8; 2usize],
    pub SlaveAddress: u32,
    pub ControllerPort: u8,
    pub ControllerName: u8,
    pub ThermalThrotter: u8,
    pub I2cProtocol: u8,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_5 {
    pub table_header: atom_common_table_header,
    pub I2cControllers: [smudpm_i2c_controller_config_v2; 8usize],
    pub MaxVoltageStepGfx: u16,
    pub MaxVoltageStepSoc: u16,
    pub VddGfxVrMapping: u8,
    pub VddSocVrMapping: u8,
    pub VddMem0VrMapping: u8,
    pub VddMem1VrMapping: u8,
    pub GfxUlvPhaseSheddingMask: u8,
    pub SocUlvPhaseSheddingMask: u8,
    pub ExternalSensorPresent: u8,
    pub Padding8_V: u8,
    pub GfxMaxCurrent: u16,
    pub GfxOffset: u8,
    pub Padding_TelemetryGfx: u8,
    pub SocMaxCurrent: u16,
    pub SocOffset: u8,
    pub Padding_TelemetrySoc: u8,
    pub Mem0MaxCurrent: u16,
    pub Mem0Offset: u8,
    pub Padding_TelemetryMem0: u8,
    pub Mem1MaxCurrent: u16,
    pub Mem1Offset: u8,
    pub Padding_TelemetryMem1: u8,
    pub AcDcGpio: u8,
    pub AcDcPolarity: u8,
    pub VR0HotGpio: u8,
    pub VR0HotPolarity: u8,
    pub VR1HotGpio: u8,
    pub VR1HotPolarity: u8,
    pub GthrGpio: u8,
    pub GthrPolarity: u8,
    pub LedPin0: u8,
    pub LedPin1: u8,
    pub LedPin2: u8,
    pub padding8_4: u8,
    pub PllGfxclkSpreadEnabled: u8,
    pub PllGfxclkSpreadPercent: u8,
    pub PllGfxclkSpreadFreq: u16,
    pub DfllGfxclkSpreadEnabled: u8,
    pub DfllGfxclkSpreadPercent: u8,
    pub DfllGfxclkSpreadFreq: u16,
    pub UclkSpreadEnabled: u8,
    pub UclkSpreadPercent: u8,
    pub UclkSpreadFreq: u16,
    pub SoclkSpreadEnabled: u8,
    pub SocclkSpreadPercent: u8,
    pub SocclkSpreadFreq: u16,
    pub TotalBoardPower: u16,
    pub BoardPadding: u16,
    pub MvddRatio: u32,
    pub BoardReserved: [u32; 9usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_6 {
    pub table_header: atom_common_table_header,
    pub i2c_padding: [u32; 3usize],
    pub maxvoltagestepgfx: u16,
    pub maxvoltagestepsoc: u16,
    pub vddgfxvrmapping: u8,
    pub vddsocvrmapping: u8,
    pub vddmemvrmapping: u8,
    pub boardvrmapping: u8,
    pub gfxulvphasesheddingmask: u8,
    pub externalsensorpresent: u8,
    pub padding8_v: [u8; 2usize],
    pub gfxmaxcurrent: u16,
    pub gfxoffset: u8,
    pub padding_telemetrygfx: u8,
    pub socmaxcurrent: u16,
    pub socoffset: u8,
    pub padding_telemetrysoc: u8,
    pub memmaxcurrent: u16,
    pub memoffset: u8,
    pub padding_telemetrymem: u8,
    pub boardmaxcurrent: u16,
    pub boardoffset: u8,
    pub padding_telemetryboardinput: u8,
    pub vr0hotgpio: u8,
    pub vr0hotpolarity: u8,
    pub vr1hotgpio: u8,
    pub vr1hotpolarity: u8,
    pub pllgfxclkspreadenabled: u8,
    pub pllgfxclkspreadpercent: u8,
    pub pllgfxclkspreadfreq: u16,
    pub uclkspreadenabled: u8,
    pub uclkspreadpercent: u8,
    pub uclkspreadfreq: u16,
    pub fclkspreadenabled: u8,
    pub fclkspreadpercent: u8,
    pub fclkspreadfreq: u16,
    pub fllgfxclkspreadenabled: u8,
    pub fllgfxclkspreadpercent: u8,
    pub fllgfxclkspreadfreq: u16,
    pub i2ccontrollers: [smudpm_i2c_controller_config_v2; 8usize],
    pub memorychannelenabled: u32,
    pub drambitwidth: u8,
    pub paddingmem: [u8; 3usize],
    pub totalboardpower: u16,
    pub boardpadding: u16,
    pub xgmilinkspeed: [u8; 4usize],
    pub xgmilinkwidth: [u8; 4usize],
    pub xgmifclkfreq: [u16; 4usize],
    pub xgmisocvoltage: [u16; 4usize],
    pub boardreserved: [u32; 10usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_7 {
    pub table_header: atom_common_table_header,
    pub I2cControllers: [smudpm_i2c_controller_config_v2; 8usize],
    pub MaxVoltageStepGfx: u16,
    pub MaxVoltageStepSoc: u16,
    pub VddGfxVrMapping: u8,
    pub VddSocVrMapping: u8,
    pub VddMem0VrMapping: u8,
    pub VddMem1VrMapping: u8,
    pub GfxUlvPhaseSheddingMask: u8,
    pub SocUlvPhaseSheddingMask: u8,
    pub ExternalSensorPresent: u8,
    pub Padding8_V: u8,
    pub GfxMaxCurrent: u16,
    pub GfxOffset: u8,
    pub Padding_TelemetryGfx: u8,
    pub SocMaxCurrent: u16,
    pub SocOffset: u8,
    pub Padding_TelemetrySoc: u8,
    pub Mem0MaxCurrent: u16,
    pub Mem0Offset: u8,
    pub Padding_TelemetryMem0: u8,
    pub Mem1MaxCurrent: u16,
    pub Mem1Offset: u8,
    pub Padding_TelemetryMem1: u8,
    pub AcDcGpio: u8,
    pub AcDcPolarity: u8,
    pub VR0HotGpio: u8,
    pub VR0HotPolarity: u8,
    pub VR1HotGpio: u8,
    pub VR1HotPolarity: u8,
    pub GthrGpio: u8,
    pub GthrPolarity: u8,
    pub LedPin0: u8,
    pub LedPin1: u8,
    pub LedPin2: u8,
    pub padding8_4: u8,
    pub PllGfxclkSpreadEnabled: u8,
    pub PllGfxclkSpreadPercent: u8,
    pub PllGfxclkSpreadFreq: u16,
    pub DfllGfxclkSpreadEnabled: u8,
    pub DfllGfxclkSpreadPercent: u8,
    pub DfllGfxclkSpreadFreq: u16,
    pub UclkSpreadEnabled: u8,
    pub UclkSpreadPercent: u8,
    pub UclkSpreadFreq: u16,
    pub SoclkSpreadEnabled: u8,
    pub SocclkSpreadPercent: u8,
    pub SocclkSpreadFreq: u16,
    pub TotalBoardPower: u16,
    pub BoardPadding: u16,
    pub MvddRatio: u32,
    pub GpioI2cScl: u8,
    pub GpioI2cSda: u8,
    pub GpioPadding: u16,
    pub LedPin3: u8,
    pub LedPin4: u8,
    pub LedEnableMask: u16,
    pub PowerLimitScalar: [u8; 4usize],
    pub MvddUlvPhaseSheddingMask: u8,
    pub VddciUlvPhaseSheddingMask: u8,
    pub Padding8_Psi1: u8,
    pub Padding8_Psi2: u8,
    pub BoardReserved: [u32; 5usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct smudpm_i2c_controller_config_v3 {
    pub Enabled: u8,
    pub Speed: u8,
    pub SlaveAddress: u8,
    pub ControllerPort: u8,
    pub ControllerName: u8,
    pub ThermalThrotter: u8,
    pub I2cProtocol: u8,
    pub PaddingConfig: u8,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_9 {
    pub table_header: atom_common_table_header,
    pub I2cControllers: [smudpm_i2c_controller_config_v3; 16usize],
    pub GpioScl: u8,
    pub GpioSda: u8,
    pub FchUsbPdSlaveAddr: u8,
    pub I2cSpare: u8,
    pub VddGfxVrMapping: u8,
    pub VddSocVrMapping: u8,
    pub VddMem0VrMapping: u8,
    pub VddMem1VrMapping: u8,
    pub GfxUlvPhaseSheddingMask: u8,
    pub SocUlvPhaseSheddingMask: u8,
    pub VddciUlvPhaseSheddingMask: u8,
    pub MvddUlvPhaseSheddingMask: u8,
    pub GfxMaxCurrent: u16,
    pub GfxOffset: u8,
    pub Padding_TelemetryGfx: u8,
    pub SocMaxCurrent: u16,
    pub SocOffset: u8,
    pub Padding_TelemetrySoc: u8,
    pub Mem0MaxCurrent: u16,
    pub Mem0Offset: u8,
    pub Padding_TelemetryMem0: u8,
    pub Mem1MaxCurrent: u16,
    pub Mem1Offset: u8,
    pub Padding_TelemetryMem1: u8,
    pub MvddRatio: u32,
    pub AcDcGpio: u8,
    pub AcDcPolarity: u8,
    pub VR0HotGpio: u8,
    pub VR0HotPolarity: u8,
    pub VR1HotGpio: u8,
    pub VR1HotPolarity: u8,
    pub GthrGpio: u8,
    pub GthrPolarity: u8,
    pub LedPin0: u8,
    pub LedPin1: u8,
    pub LedPin2: u8,
    pub LedEnableMask: u8,
    pub LedPcie: u8,
    pub LedError: u8,
    pub LedSpare1: [u8; 2usize],
    pub PllGfxclkSpreadEnabled: u8,
    pub PllGfxclkSpreadPercent: u8,
    pub PllGfxclkSpreadFreq: u16,
    pub DfllGfxclkSpreadEnabled: u8,
    pub DfllGfxclkSpreadPercent: u8,
    pub DfllGfxclkSpreadFreq: u16,
    pub UclkSpreadEnabled: u8,
    pub UclkSpreadPercent: u8,
    pub UclkSpreadFreq: u16,
    pub FclkSpreadEnabled: u8,
    pub FclkSpreadPercent: u8,
    pub FclkSpreadFreq: u16,
    pub MemoryChannelEnabled: u32,
    pub DramBitWidth: u8,
    pub PaddingMem1: [u8; 3usize],
    pub TotalBoardPower: u16,
    pub BoardPowerPadding: u16,
    pub XgmiLinkSpeed: [u8; 4usize],
    pub XgmiLinkWidth: [u8; 4usize],
    pub XgmiFclkFreq: [u16; 4usize],
    pub XgmiSocVoltage: [u16; 4usize],
    pub BoardReserved: [u32; 16usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_10 {
    pub table_header: atom_common_table_header,
    pub GfxMaxCurrent: u16,
    pub GfxOffset: u8,
    pub Padding_TelemetryGfx: u8,
    pub SocMaxCurrent: u16,
    pub SocOffset: u8,
    pub Padding_TelemetrySoc: u8,
    pub MemMaxCurrent: u16,
    pub MemOffset: u8,
    pub Padding_TelemetryMem: u8,
    pub BoardMaxCurrent: u16,
    pub BoardOffset: u8,
    pub Padding_TelemetryBoardInput: u8,
    pub BoardVoltageCoeffA: u32,
    pub BoardVoltageCoeffB: u32,
    pub VR0HotGpio: u8,
    pub VR0HotPolarity: u8,
    pub VR1HotGpio: u8,
    pub VR1HotPolarity: u8,
    pub UclkSpreadEnabled: u8,
    pub UclkSpreadPercent: u8,
    pub UclkSpreadFreq: u16,
    pub FclkSpreadEnabled: u8,
    pub FclkSpreadPercent: u8,
    pub FclkSpreadFreq: u16,
    pub I2cControllers: [smudpm_i2c_controller_config_v3; 8usize],
    pub GpioI2cScl: u8,
    pub GpioI2cSda: u8,
    pub spare5: u16,
    pub reserved: [u32; 16usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_asic_profiling_info_v4_1 {
    pub table_header: atom_common_table_header,
    pub maxvddc: u32,
    pub minvddc: u32,
    pub avfs_meannsigma_acontant0: u32,
    pub avfs_meannsigma_acontant1: u32,
    pub avfs_meannsigma_acontant2: u32,
    pub avfs_meannsigma_dc_tol_sigma: u16,
    pub avfs_meannsigma_platform_mean: u16,
    pub avfs_meannsigma_platform_sigma: u16,
    pub gb_vdroop_table_cksoff_a0: u32,
    pub gb_vdroop_table_cksoff_a1: u32,
    pub gb_vdroop_table_cksoff_a2: u32,
    pub gb_vdroop_table_ckson_a0: u32,
    pub gb_vdroop_table_ckson_a1: u32,
    pub gb_vdroop_table_ckson_a2: u32,
    pub avfsgb_fuse_table_cksoff_m1: u32,
    pub avfsgb_fuse_table_cksoff_m2: u32,
    pub avfsgb_fuse_table_cksoff_b: u32,
    pub avfsgb_fuse_table_ckson_m1: u32,
    pub avfsgb_fuse_table_ckson_m2: u32,
    pub avfsgb_fuse_table_ckson_b: u32,
    pub max_voltage_0_25mv: u16,
    pub enable_gb_vdroop_table_cksoff: u8,
    pub enable_gb_vdroop_table_ckson: u8,
    pub enable_gb_fuse_table_cksoff: u8,
    pub enable_gb_fuse_table_ckson: u8,
    pub psm_age_comfactor: u16,
    pub enable_apply_avfs_cksoff_voltage: u8,
    pub reserved: u8,
    pub dispclk2gfxclk_a: u32,
    pub dispclk2gfxclk_b: u32,
    pub dispclk2gfxclk_c: u32,
    pub pixclk2gfxclk_a: u32,
    pub pixclk2gfxclk_b: u32,
    pub pixclk2gfxclk_c: u32,
    pub dcefclk2gfxclk_a: u32,
    pub dcefclk2gfxclk_b: u32,
    pub dcefclk2gfxclk_c: u32,
    pub phyclk2gfxclk_a: u32,
    pub phyclk2gfxclk_b: u32,
    pub phyclk2gfxclk_c: u32,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_asic_profiling_info_v4_2 {
    pub table_header: atom_common_table_header,
    pub maxvddc: u32,
    pub minvddc: u32,
    pub avfs_meannsigma_acontant0: u32,
    pub avfs_meannsigma_acontant1: u32,
    pub avfs_meannsigma_acontant2: u32,
    pub avfs_meannsigma_dc_tol_sigma: u16,
    pub avfs_meannsigma_platform_mean: u16,
    pub avfs_meannsigma_platform_sigma: u16,
    pub gb_vdroop_table_cksoff_a0: u32,
    pub gb_vdroop_table_cksoff_a1: u32,
    pub gb_vdroop_table_cksoff_a2: u32,
    pub gb_vdroop_table_ckson_a0: u32,
    pub gb_vdroop_table_ckson_a1: u32,
    pub gb_vdroop_table_ckson_a2: u32,
    pub avfsgb_fuse_table_cksoff_m1: u32,
    pub avfsgb_fuse_table_cksoff_m2: u32,
    pub avfsgb_fuse_table_cksoff_b: u32,
    pub avfsgb_fuse_table_ckson_m1: u32,
    pub avfsgb_fuse_table_ckson_m2: u32,
    pub avfsgb_fuse_table_ckson_b: u32,
    pub max_voltage_0_25mv: u16,
    pub enable_gb_vdroop_table_cksoff: u8,
    pub enable_gb_vdroop_table_ckson: u8,
    pub enable_gb_fuse_table_cksoff: u8,
    pub enable_gb_fuse_table_ckson: u8,
    pub psm_age_comfactor: u16,
    pub enable_apply_avfs_cksoff_voltage: u8,
    pub reserved: u8,
    pub dispclk2gfxclk_a: u32,
    pub dispclk2gfxclk_b: u32,
    pub dispclk2gfxclk_c: u32,
    pub pixclk2gfxclk_a: u32,
    pub pixclk2gfxclk_b: u32,
    pub pixclk2gfxclk_c: u32,
    pub dcefclk2gfxclk_a: u32,
    pub dcefclk2gfxclk_b: u32,
    pub dcefclk2gfxclk_c: u32,
    pub phyclk2gfxclk_a: u32,
    pub phyclk2gfxclk_b: u32,
    pub phyclk2gfxclk_c: u32,
    pub acg_gb_vdroop_table_a0: u32,
    pub acg_gb_vdroop_table_a1: u32,
    pub acg_gb_vdroop_table_a2: u32,
    pub acg_avfsgb_fuse_table_m1: u32,
    pub acg_avfsgb_fuse_table_m2: u32,
    pub acg_avfsgb_fuse_table_b: u32,
    pub enable_acg_gb_vdroop_table: u8,
    pub enable_acg_gb_fuse_table: u8,
    pub acg_dispclk2gfxclk_a: u32,
    pub acg_dispclk2gfxclk_b: u32,
    pub acg_dispclk2gfxclk_c: u32,
    pub acg_pixclk2gfxclk_a: u32,
    pub acg_pixclk2gfxclk_b: u32,
    pub acg_pixclk2gfxclk_c: u32,
    pub acg_dcefclk2gfxclk_a: u32,
    pub acg_dcefclk2gfxclk_b: u32,
    pub acg_dcefclk2gfxclk_c: u32,
    pub acg_phyclk2gfxclk_a: u32,
    pub acg_phyclk2gfxclk_b: u32,
    pub acg_phyclk2gfxclk_c: u32,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_multimedia_info_v2_1 {
    pub table_header: atom_common_table_header,
    pub uvdip_min_ver: u8,
    pub uvdip_max_ver: u8,
    pub vceip_min_ver: u8,
    pub vceip_max_ver: u8,
    pub uvd_enc_max_input_width_pixels: u16,
    pub uvd_enc_max_input_height_pixels: u16,
    pub vce_enc_max_input_width_pixels: u16,
    pub vce_enc_max_input_height_pixels: u16,
    pub uvd_enc_max_bandwidth: u32,
    pub vce_enc_max_bandwidth: u32,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_umc_info_v3_1 {
    pub table_header: atom_common_table_header,
    pub ucode_version: u32,
    pub ucode_rom_startaddr: u32,
    pub ucode_length: u32,
    pub umc_reg_init_offset: u16,
    pub customer_ucode_name_offset: u16,
    pub mclk_ss_percentage: u16,
    pub mclk_ss_rate_10hz: u16,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub vram_type: u8,
    pub umc_config: u8,
    pub mem_refclk_10khz: u32,
}
pub const atom_umc_config_def_UMC_CONFIG__ENABLE_1KB_INTERLEAVE_MODE: atom_umc_config_def = 1;
pub const atom_umc_config_def_UMC_CONFIG__DEFAULT_MEM_ECC_ENABLE: atom_umc_config_def = 2;
pub const atom_umc_config_def_UMC_CONFIG__ENABLE_HBM_LANE_REPAIR: atom_umc_config_def = 4;
pub const atom_umc_config_def_UMC_CONFIG__ENABLE_BANK_HARVESTING: atom_umc_config_def = 8;
pub const atom_umc_config_def_UMC_CONFIG__ENABLE_PHY_REINIT: atom_umc_config_def = 16;
pub const atom_umc_config_def_UMC_CONFIG__DISABLE_UCODE_CHKSTATUS: atom_umc_config_def = 32;
pub type atom_umc_config_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_umc_info_v3_2 {
    pub table_header: atom_common_table_header,
    pub ucode_version: u32,
    pub ucode_rom_startaddr: u32,
    pub ucode_length: u32,
    pub umc_reg_init_offset: u16,
    pub customer_ucode_name_offset: u16,
    pub mclk_ss_percentage: u16,
    pub mclk_ss_rate_10hz: u16,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub vram_type: u8,
    pub umc_config: u8,
    pub mem_refclk_10khz: u32,
    pub pstate_uclk_10khz: [u32; 4usize],
    pub umcgoldenoffset: u16,
    pub densitygoldenoffset: u16,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_umc_info_v3_3 {
    pub table_header: atom_common_table_header,
    pub ucode_reserved: u32,
    pub ucode_rom_startaddr: u32,
    pub ucode_length: u32,
    pub umc_reg_init_offset: u16,
    pub customer_ucode_name_offset: u16,
    pub mclk_ss_percentage: u16,
    pub mclk_ss_rate_10hz: u16,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub vram_type: u8,
    pub umc_config: u8,
    pub mem_refclk_10khz: u32,
    pub pstate_uclk_10khz: [u32; 4usize],
    pub umcgoldenoffset: u16,
    pub densitygoldenoffset: u16,
    pub umc_config1: u32,
    pub bist_data_startaddr: u32,
    pub reserved: [u32; 2usize],
}
pub const atom_umc_config1_def_UMC_CONFIG1__ENABLE_PSTATE_PHASE_STORE_TRAIN: atom_umc_config1_def =
    1;
pub const atom_umc_config1_def_UMC_CONFIG1__ENABLE_AUTO_FRAMING: atom_umc_config1_def = 2;
pub const atom_umc_config1_def_UMC_CONFIG1__ENABLE_RESTORE_BIST_DATA: atom_umc_config1_def = 4;
pub const atom_umc_config1_def_UMC_CONFIG1__DISABLE_STROBE_MODE: atom_umc_config1_def = 8;
pub const atom_umc_config1_def_UMC_CONFIG1__DEBUG_DATA_PARITY_EN: atom_umc_config1_def = 16;
pub const atom_umc_config1_def_UMC_CONFIG1__ENABLE_ECC_CAPABLE: atom_umc_config1_def = 65536;
pub type atom_umc_config1_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_umc_info_v4_0 {
    pub table_header: atom_common_table_header,
    pub ucode_reserved: [u32; 5usize],
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub vram_type: u8,
    pub umc_config: u8,
    pub mem_refclk_10khz: u32,
    pub clk_reserved: [u32; 4usize],
    pub golden_reserved: u32,
    pub umc_config1: u32,
    pub reserved: [u32; 2usize],
    pub channel_num: u8,
    pub channel_width: u8,
    pub channel_reserve: [u8; 2usize],
    pub umc_info_reserved: [u8; 16usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_module_v9 {
    pub memory_size: u32,
    pub channel_enable: u32,
    pub max_mem_clk: u32,
    pub reserved: [u16; 3usize],
    pub mem_voltage: u16,
    pub vram_module_size: u16,
    pub ext_memory_id: u8,
    pub memory_type: u8,
    pub channel_num: u8,
    pub channel_width: u8,
    pub density: u8,
    pub tunningset_id: u8,
    pub vender_rev_id: u8,
    pub refreshrate: u8,
    pub hbm_ven_rev_id: u8,
    pub vram_rsd2: u8,
    pub dram_pnstring: [::core::ffi::c_char; 20usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_info_header_v2_3 {
    pub table_header: atom_common_table_header,
    pub mem_adjust_tbloffset: u16,
    pub mem_clk_patch_tbloffset: u16,
    pub mc_adjust_pertile_tbloffset: u16,
    pub mc_phyinit_tbloffset: u16,
    pub dram_data_remap_tbloffset: u16,
    pub tmrs_seq_offset: u16,
    pub post_ucode_init_offset: u16,
    pub vram_rsd2: u16,
    pub vram_module_num: u8,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub mc_phy_tile_num: u8,
    pub vram_module: [atom_vram_module_v9; 16usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_module_v3_0 {
    pub density: u8,
    pub tunningset_id: u8,
    pub ext_memory_id: u8,
    pub dram_vendor_id: u8,
    pub dram_info_offset: u16,
    pub mem_tuning_offset: u16,
    pub tmrs_seq_offset: u16,
    pub reserved1: u16,
    pub dram_size_per_ch: u32,
    pub reserved: [u32; 3usize],
    pub dram_pnstring: [::core::ffi::c_char; 40usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_info_header_v3_0 {
    pub table_header: atom_common_table_header,
    pub mem_tuning_table_offset: u16,
    pub dram_info_table_offset: u16,
    pub tmrs_table_offset: u16,
    pub mc_init_table_offset: u16,
    pub dram_data_remap_table_offset: u16,
    pub umc_emuinittable_offset: u16,
    pub reserved_sub_table_offset: [u16; 2usize],
    pub vram_module_num: u8,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub mc_phy_tile_num: u8,
    pub memory_type: u8,
    pub channel_num: u8,
    pub channel_width: u8,
    pub reserved1: u8,
    pub channel_enable: u32,
    pub channel1_enable: u32,
    pub feature_enable: u32,
    pub feature1_enable: u32,
    pub hardcode_mem_size: u32,
    pub reserved4: [u32; 4usize],
    pub vram_module: [atom_vram_module_v3_0; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_umc_register_addr_info {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl atom_umc_register_addr_info {
    #[inline]
    pub fn umc_register_addr(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_umc_register_addr(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn umc_register_addr_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                24u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_umc_register_addr_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                24u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn umc_reg_type_ind(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_umc_reg_type_ind(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn umc_reg_type_ind_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                24usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_umc_reg_type_ind_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                24usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn umc_reg_rsvd(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(25usize, 7u8) as u32) }
    }
    #[inline]
    pub fn set_umc_reg_rsvd(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(25usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn umc_reg_rsvd_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                25usize,
                7u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_umc_reg_rsvd_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                25usize,
                7u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        umc_register_addr: u32,
        umc_reg_type_ind: u32,
        umc_reg_rsvd: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let umc_register_addr: u32 = unsafe { ::core::mem::transmute(umc_register_addr) };
            umc_register_addr as u64
        });
        __bindgen_bitfield_unit.set(24usize, 1u8, {
            let umc_reg_type_ind: u32 = unsafe { ::core::mem::transmute(umc_reg_type_ind) };
            umc_reg_type_ind as u64
        });
        __bindgen_bitfield_unit.set(25usize, 7u8, {
            let umc_reg_rsvd: u32 = unsafe { ::core::mem::transmute(umc_reg_rsvd) };
            umc_reg_rsvd as u64
        });
        __bindgen_bitfield_unit
    }
}
pub const atom_umc_register_addr_info_flag_b3ATOM_UMC_REG_ADD_INFO_INDIRECT_ACCESS:
    atom_umc_register_addr_info_flag = 1;
pub type atom_umc_register_addr_info_flag = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub union atom_umc_register_addr_info_access {
    pub umc_reg_addr: atom_umc_register_addr_info,
    pub u32umc_reg_addr: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_umc_reg_setting_id_config {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl atom_umc_reg_setting_id_config {
    #[inline]
    pub fn memclockrange(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_memclockrange(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn memclockrange_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                24u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_memclockrange_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                24u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn mem_blk_id(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_mem_blk_id(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn mem_blk_id_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                24usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_mem_blk_id_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                24usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        memclockrange: u32,
        mem_blk_id: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let memclockrange: u32 = unsafe { ::core::mem::transmute(memclockrange) };
            memclockrange as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let mem_blk_id: u32 = unsafe { ::core::mem::transmute(mem_blk_id) };
            mem_blk_id as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub union atom_umc_reg_setting_id_config_access {
    pub umc_id_access: atom_umc_reg_setting_id_config,
    pub u32umc_id_access: u32,
}
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct atom_umc_reg_setting_data_block {
    pub block_id: atom_umc_reg_setting_id_config_access,
    pub u32umc_reg_data: [u32; 1usize],
}
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct atom_umc_init_reg_block {
    pub umc_reg_num: u16,
    pub reserved: u16,
    pub umc_reg_list: [atom_umc_register_addr_info_access; 1usize],
    pub umc_reg_setting_list: [atom_umc_reg_setting_data_block; 1usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_module_v10 {
    pub memory_size: u32,
    pub channel_enable: u32,
    pub max_mem_clk: u32,
    pub reserved: [u16; 3usize],
    pub mem_voltage: u16,
    pub vram_module_size: u16,
    pub ext_memory_id: u8,
    pub memory_type: u8,
    pub channel_num: u8,
    pub channel_width: u8,
    pub density: u8,
    pub tunningset_id: u8,
    pub vender_rev_id: u8,
    pub refreshrate: u8,
    pub vram_flags: u8,
    pub vram_rsd2: u8,
    pub gddr6_mr10: u16,
    pub gddr6_mr1: u16,
    pub gddr6_mr2: u16,
    pub gddr6_mr7: u16,
    pub dram_pnstring: [::core::ffi::c_char; 20usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_info_header_v2_4 {
    pub table_header: atom_common_table_header,
    pub mem_adjust_tbloffset: u16,
    pub mem_clk_patch_tbloffset: u16,
    pub mc_adjust_pertile_tbloffset: u16,
    pub mc_phyinit_tbloffset: u16,
    pub dram_data_remap_tbloffset: u16,
    pub reserved: u16,
    pub post_ucode_init_offset: u16,
    pub vram_rsd2: u16,
    pub vram_module_num: u8,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub mc_phy_tile_num: u8,
    pub vram_module: [atom_vram_module_v10; 16usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_module_v11 {
    pub memory_size: u32,
    pub channel_enable: u32,
    pub mem_voltage: u16,
    pub vram_module_size: u16,
    pub ext_memory_id: u8,
    pub memory_type: u8,
    pub channel_num: u8,
    pub channel_width: u8,
    pub density: u8,
    pub tunningset_id: u8,
    pub reserved: [u16; 4usize],
    pub vender_rev_id: u8,
    pub refreshrate: u8,
    pub vram_flags: u8,
    pub vram_rsd2: u8,
    pub gddr6_mr10: u16,
    pub gddr6_mr0: u16,
    pub gddr6_mr1: u16,
    pub gddr6_mr2: u16,
    pub gddr6_mr4: u16,
    pub gddr6_mr7: u16,
    pub gddr6_mr8: u16,
    pub dram_pnstring: [::core::ffi::c_char; 40usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gddr6_ac_timing_v2_5 {
    pub u32umc_id_access: u32,
    pub RL: u8,
    pub WL: u8,
    pub tRAS: u8,
    pub tRC: u8,
    pub tREFI: u16,
    pub tRFC: u8,
    pub tRFCpb: u8,
    pub tRREFD: u8,
    pub tRCDRD: u8,
    pub tRCDWR: u8,
    pub tRP: u8,
    pub tRRDS: u8,
    pub tRRDL: u8,
    pub tWR: u8,
    pub tWTRS: u8,
    pub tWTRL: u8,
    pub tFAW: u8,
    pub tCCDS: u8,
    pub tCCDL: u8,
    pub tCRCRL: u8,
    pub tCRCWL: u8,
    pub tCKE: u8,
    pub tCKSRE: u8,
    pub tCKSRX: u8,
    pub tRTPS: u8,
    pub tRTPL: u8,
    pub tMRD: u8,
    pub tMOD: u8,
    pub tXS: u8,
    pub tXHP: u8,
    pub tXSMRS: u8,
    pub tXSH: u32,
    pub tPD: u8,
    pub tXP: u8,
    pub tCPDED: u8,
    pub tACTPDE: u8,
    pub tPREPDE: u8,
    pub tREFPDE: u8,
    pub tMRSPDEN: u8,
    pub tRDSRE: u8,
    pub tWRSRE: u8,
    pub tPPD: u8,
    pub tCCDMW: u8,
    pub tWTRTR: u8,
    pub tLTLTR: u8,
    pub tREFTR: u8,
    pub VNDR: u8,
    pub reserved: [u8; 9usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gddr6_bit_byte_remap {
    pub dphy_byteremap: u32,
    pub dphy_bitremap0: u32,
    pub dphy_bitremap1: u32,
    pub dphy_bitremap2: u32,
    pub aphy_bitremap0: u32,
    pub aphy_bitremap1: u32,
    pub phy_dram: u32,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gddr6_dram_data_remap {
    pub table_size: u32,
    pub phyintf_ck_inverted: [u8; 8usize],
    pub bit_byte_remap: [atom_gddr6_bit_byte_remap; 16usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_info_header_v2_5 {
    pub table_header: atom_common_table_header,
    pub mem_adjust_tbloffset: u16,
    pub gddr6_ac_timing_offset: u16,
    pub mc_adjust_pertile_tbloffset: u16,
    pub mc_phyinit_tbloffset: u16,
    pub dram_data_remap_tbloffset: u16,
    pub reserved: u16,
    pub post_ucode_init_offset: u16,
    pub strobe_mode_patch_tbloffset: u16,
    pub vram_module_num: u8,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub mc_phy_tile_num: u8,
    pub vram_module: [atom_vram_module_v11; 16usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_info_header_v2_6 {
    pub table_header: atom_common_table_header,
    pub mem_adjust_tbloffset: u16,
    pub mem_clk_patch_tbloffset: u16,
    pub mc_adjust_pertile_tbloffset: u16,
    pub mc_phyinit_tbloffset: u16,
    pub dram_data_remap_tbloffset: u16,
    pub tmrs_seq_offset: u16,
    pub post_ucode_init_offset: u16,
    pub vram_rsd2: u16,
    pub vram_module_num: u8,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub mc_phy_tile_num: u8,
    pub vram_module: [atom_vram_module_v9; 16usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_i2c_data_entry {
    pub i2c_reg_index: u16,
    pub i2c_reg_data: u16,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_voltage_object_header_v4 {
    pub voltage_type: u8,
    pub voltage_mode: u8,
    pub object_size: u16,
}
pub const atom_voltage_object_mode_VOLTAGE_OBJ_GPIO_LUT: atom_voltage_object_mode = 0;
pub const atom_voltage_object_mode_VOLTAGE_OBJ_VR_I2C_INIT_SEQ: atom_voltage_object_mode = 3;
pub const atom_voltage_object_mode_VOLTAGE_OBJ_PHASE_LUT: atom_voltage_object_mode = 4;
pub const atom_voltage_object_mode_VOLTAGE_OBJ_SVID2: atom_voltage_object_mode = 7;
pub const atom_voltage_object_mode_VOLTAGE_OBJ_EVV: atom_voltage_object_mode = 8;
pub const atom_voltage_object_mode_VOLTAGE_OBJ_MERGED_POWER: atom_voltage_object_mode = 9;
pub type atom_voltage_object_mode = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_i2c_voltage_object_v4 {
    pub header: atom_voltage_object_header_v4,
    pub regulator_id: u8,
    pub i2c_id: u8,
    pub i2c_slave_addr: u8,
    pub i2c_control_offset: u8,
    pub i2c_flag: u8,
    pub i2c_speed: u8,
    pub reserved: [u8; 2usize],
    pub i2cdatalut: [atom_i2c_data_entry; 1usize],
}
pub const atom_i2c_voltage_control_flag_VOLTAGE_DATA_ONE_BYTE: atom_i2c_voltage_control_flag = 0;
pub const atom_i2c_voltage_control_flag_VOLTAGE_DATA_TWO_BYTE: atom_i2c_voltage_control_flag = 1;
pub type atom_i2c_voltage_control_flag = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_voltage_gpio_map_lut {
    pub voltage_gpio_reg_val: u32,
    pub voltage_level_mv: u16,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gpio_voltage_object_v4 {
    pub header: atom_voltage_object_header_v4,
    pub gpio_control_id: u8,
    pub gpio_entry_num: u8,
    pub phase_delay_us: u8,
    pub reserved: u8,
    pub gpio_mask_val: u32,
    pub voltage_gpio_lut: [atom_voltage_gpio_map_lut; 1usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_svid2_voltage_object_v4 {
    pub header: atom_voltage_object_header_v4,
    pub loadline_psi1: u8,
    pub psi0_l_vid_thresd: u8,
    pub psi0_enable: u8,
    pub maxvstep: u8,
    pub telemetry_offset: u8,
    pub telemetry_gain: u8,
    pub reserved1: u16,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_merged_voltage_object_v4 {
    pub header: atom_voltage_object_header_v4,
    pub merged_powerrail_type: u8,
    pub reserved: [u8; 3usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union atom_voltage_object_v4 {
    pub gpio_voltage_obj: atom_gpio_voltage_object_v4,
    pub i2c_voltage_obj: atom_i2c_voltage_object_v4,
    pub svid2_voltage_obj: atom_svid2_voltage_object_v4,
    pub merged_voltage_obj: atom_merged_voltage_object_v4,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct atom_voltage_objects_info_v4_1 {
    pub table_header: atom_common_table_header,
    pub voltage_object: [atom_voltage_object_v4; 1usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct asic_init_engine_parameters {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl asic_init_engine_parameters {
    #[inline]
    pub fn sclkfreqin10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_sclkfreqin10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn sclkfreqin10khz_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                24u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_sclkfreqin10khz_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                24u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn engineflag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_engineflag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn engineflag_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                24usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_engineflag_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                24usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        sclkfreqin10khz: u32,
        engineflag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let sclkfreqin10khz: u32 = unsafe { ::core::mem::transmute(sclkfreqin10khz) };
            sclkfreqin10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let engineflag: u32 = unsafe { ::core::mem::transmute(engineflag) };
            engineflag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct asic_init_mem_parameters {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl asic_init_mem_parameters {
    #[inline]
    pub fn mclkfreqin10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_mclkfreqin10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn mclkfreqin10khz_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                24u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_mclkfreqin10khz_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                24u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn memflag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_memflag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn memflag_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                24usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_memflag_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                24usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        mclkfreqin10khz: u32,
        memflag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let mclkfreqin10khz: u32 = unsafe { ::core::mem::transmute(mclkfreqin10khz) };
            mclkfreqin10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let memflag: u32 = unsafe { ::core::mem::transmute(memflag) };
            memflag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct asic_init_parameters_v2_1 {
    pub engineparam: asic_init_engine_parameters,
    pub memparam: asic_init_mem_parameters,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct asic_init_ps_allocation_v2_1 {
    pub param: asic_init_parameters_v2_1,
    pub reserved: [u32; 16usize],
}
pub const atom_asic_init_engine_flag_b3NORMAL_ENGINE_INIT: atom_asic_init_engine_flag = 0;
pub const atom_asic_init_engine_flag_b3SRIOV_SKIP_ASIC_INIT: atom_asic_init_engine_flag = 2;
pub const atom_asic_init_engine_flag_b3SRIOV_LOAD_UCODE: atom_asic_init_engine_flag = 64;
pub type atom_asic_init_engine_flag = ::core::ffi::c_uint;
pub const atom_asic_init_mem_flag_b3NORMAL_MEM_INIT: atom_asic_init_mem_flag = 0;
pub const atom_asic_init_mem_flag_b3DRAM_SELF_REFRESH_EXIT: atom_asic_init_mem_flag = 32;
pub type atom_asic_init_mem_flag = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_engine_clock_parameters_v2_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub reserved: [u32; 10usize],
}
impl set_engine_clock_parameters_v2_1 {
    #[inline]
    pub fn sclkfreqin10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_sclkfreqin10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn sclkfreqin10khz_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                24u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_sclkfreqin10khz_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                24u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn sclkflag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_sclkflag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn sclkflag_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                24usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_sclkflag_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                24usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        sclkfreqin10khz: u32,
        sclkflag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let sclkfreqin10khz: u32 = unsafe { ::core::mem::transmute(sclkfreqin10khz) };
            sclkfreqin10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let sclkflag: u32 = unsafe { ::core::mem::transmute(sclkflag) };
            sclkflag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_engine_clock_ps_allocation_v2_1 {
    pub clockinfo: set_engine_clock_parameters_v2_1,
    pub reserved: [u32; 10usize],
}
pub const atom_set_engine_mem_clock_flag_b3NORMAL_CHANGE_CLOCK: atom_set_engine_mem_clock_flag = 0;
pub const atom_set_engine_mem_clock_flag_b3FIRST_TIME_CHANGE_CLOCK: atom_set_engine_mem_clock_flag =
    8;
pub const atom_set_engine_mem_clock_flag_b3STORE_DPM_TRAINGING: atom_set_engine_mem_clock_flag = 64;
pub type atom_set_engine_mem_clock_flag = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct get_engine_clock_parameter {
    pub sclk_10khz: u32,
    pub reserved: u32,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_memory_clock_parameters_v2_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub reserved: [u32; 10usize],
}
impl set_memory_clock_parameters_v2_1 {
    #[inline]
    pub fn mclkfreqin10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_mclkfreqin10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn mclkfreqin10khz_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                24u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_mclkfreqin10khz_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                24u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn mclkflag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_mclkflag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn mclkflag_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                24usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_mclkflag_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                24usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        mclkfreqin10khz: u32,
        mclkflag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let mclkfreqin10khz: u32 = unsafe { ::core::mem::transmute(mclkfreqin10khz) };
            mclkfreqin10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let mclkflag: u32 = unsafe { ::core::mem::transmute(mclkflag) };
            mclkflag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_memory_clock_ps_allocation_v2_1 {
    pub clockinfo: set_memory_clock_parameters_v2_1,
    pub reserved: [u32; 10usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct get_memory_clock_parameter {
    pub mclk_10khz: u32,
    pub reserved: u32,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_voltage_parameters_v1_4 {
    pub voltagetype: u8,
    pub command: u8,
    pub vlevel_mv: u16,
}
pub const atom_set_voltage_command_ATOM_SET_VOLTAGE: atom_set_voltage_command = 0;
pub const atom_set_voltage_command_ATOM_INIT_VOLTAGE_REGULATOR: atom_set_voltage_command = 3;
pub const atom_set_voltage_command_ATOM_SET_VOLTAGE_PHASE: atom_set_voltage_command = 4;
pub const atom_set_voltage_command_ATOM_GET_LEAKAGE_ID: atom_set_voltage_command = 8;
pub type atom_set_voltage_command = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_voltage_ps_allocation_v1_4 {
    pub setvoltageparam: set_voltage_parameters_v1_4,
    pub reserved: [u32; 10usize],
}
pub const atom_gpu_clock_type_COMPUTE_GPUCLK_INPUT_FLAG_DEFAULT_GPUCLK: atom_gpu_clock_type = 0;
pub const atom_gpu_clock_type_COMPUTE_GPUCLK_INPUT_FLAG_GFXCLK: atom_gpu_clock_type = 1;
pub const atom_gpu_clock_type_COMPUTE_GPUCLK_INPUT_FLAG_UCLK: atom_gpu_clock_type = 2;
pub type atom_gpu_clock_type = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct compute_gpu_clock_input_parameter_v1_8 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub reserved: [u32; 5usize],
}
impl compute_gpu_clock_input_parameter_v1_8 {
    #[inline]
    pub fn gpuclock_10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_gpuclock_10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn gpuclock_10khz_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                24u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_gpuclock_10khz_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                24u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn gpu_clock_type(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_gpu_clock_type(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn gpu_clock_type_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                24usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_gpu_clock_type_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                24usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        gpuclock_10khz: u32,
        gpu_clock_type: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let gpuclock_10khz: u32 = unsafe { ::core::mem::transmute(gpuclock_10khz) };
            gpuclock_10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let gpu_clock_type: u32 = unsafe { ::core::mem::transmute(gpu_clock_type) };
            gpu_clock_type as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct compute_gpu_clock_output_parameter_v1_8 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub pll_fb_mult: u32,
    pub pll_ss_fbsmult: u32,
    pub pll_ss_slew_frac: u16,
    pub pll_ss_enable: u8,
    pub reserved: u8,
    pub reserved1: [u32; 2usize],
}
impl compute_gpu_clock_output_parameter_v1_8 {
    #[inline]
    pub fn gpuclock_10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_gpuclock_10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn gpuclock_10khz_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                24u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_gpuclock_10khz_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                24u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn dfs_did(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_dfs_did(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn dfs_did_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                24usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_dfs_did_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                24usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        gpuclock_10khz: u32,
        dfs_did: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let gpuclock_10khz: u32 = unsafe { ::core::mem::transmute(gpuclock_10khz) };
            gpuclock_10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let dfs_did: u32 = unsafe { ::core::mem::transmute(dfs_did) };
            dfs_did as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct read_efuse_input_parameters_v3_1 {
    pub efuse_start_index: u16,
    pub reserved: u8,
    pub bitslen: u8,
}
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub union read_efuse_value_parameters_v3_1 {
    pub efuse_info: read_efuse_input_parameters_v3_1,
    pub efusevalue: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_get_smu_clock_info_parameters_v3_1 {
    pub syspll_id: u8,
    pub clk_id: u8,
    pub command: u8,
    pub dfsdid: u8,
}
pub const atom_get_smu_clock_info_command_GET_SMU_CLOCK_INFO_V3_1_GET_CLOCK_FREQ:
    atom_get_smu_clock_info_command = 0;
pub const atom_get_smu_clock_info_command_GET_SMU_CLOCK_INFO_V3_1_GET_PLLVCO_FREQ:
    atom_get_smu_clock_info_command = 1;
pub const atom_get_smu_clock_info_command_GET_SMU_CLOCK_INFO_V3_1_GET_PLLREFCLK_FREQ:
    atom_get_smu_clock_info_command = 2;
pub type atom_get_smu_clock_info_command = ::core::ffi::c_uint;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_SMNCLK_ID: atom_smu9_syspll0_clock_id = 0;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_SOCCLK_ID: atom_smu9_syspll0_clock_id = 1;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_MP0CLK_ID: atom_smu9_syspll0_clock_id = 2;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_MP1CLK_ID: atom_smu9_syspll0_clock_id = 3;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_LCLK_ID: atom_smu9_syspll0_clock_id = 4;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_DCLK_ID: atom_smu9_syspll0_clock_id = 5;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_VCLK_ID: atom_smu9_syspll0_clock_id = 6;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_ECLK_ID: atom_smu9_syspll0_clock_id = 7;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_DCEFCLK_ID: atom_smu9_syspll0_clock_id = 8;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_DPREFCLK_ID: atom_smu9_syspll0_clock_id = 10;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_DISPCLK_ID: atom_smu9_syspll0_clock_id = 11;
pub type atom_smu9_syspll0_clock_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll_id_SMU11_SYSPLL0_ID: atom_smu11_syspll_id = 0;
pub const atom_smu11_syspll_id_SMU11_SYSPLL1_0_ID: atom_smu11_syspll_id = 1;
pub const atom_smu11_syspll_id_SMU11_SYSPLL1_1_ID: atom_smu11_syspll_id = 2;
pub const atom_smu11_syspll_id_SMU11_SYSPLL1_2_ID: atom_smu11_syspll_id = 3;
pub const atom_smu11_syspll_id_SMU11_SYSPLL2_ID: atom_smu11_syspll_id = 4;
pub const atom_smu11_syspll_id_SMU11_SYSPLL3_0_ID: atom_smu11_syspll_id = 5;
pub const atom_smu11_syspll_id_SMU11_SYSPLL3_1_ID: atom_smu11_syspll_id = 6;
pub type atom_smu11_syspll_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll0_clock_id_SMU11_SYSPLL0_ECLK_ID: atom_smu11_syspll0_clock_id = 0;
pub const atom_smu11_syspll0_clock_id_SMU11_SYSPLL0_SOCCLK_ID: atom_smu11_syspll0_clock_id = 1;
pub const atom_smu11_syspll0_clock_id_SMU11_SYSPLL0_MP0CLK_ID: atom_smu11_syspll0_clock_id = 2;
pub const atom_smu11_syspll0_clock_id_SMU11_SYSPLL0_DCLK_ID: atom_smu11_syspll0_clock_id = 3;
pub const atom_smu11_syspll0_clock_id_SMU11_SYSPLL0_VCLK_ID: atom_smu11_syspll0_clock_id = 4;
pub const atom_smu11_syspll0_clock_id_SMU11_SYSPLL0_DCEFCLK_ID: atom_smu11_syspll0_clock_id = 5;
pub type atom_smu11_syspll0_clock_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll1_0_clock_id_SMU11_SYSPLL1_0_UCLKA_ID: atom_smu11_syspll1_0_clock_id = 0;
pub type atom_smu11_syspll1_0_clock_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll1_1_clock_id_SMU11_SYSPLL1_0_UCLKB_ID: atom_smu11_syspll1_1_clock_id = 0;
pub type atom_smu11_syspll1_1_clock_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll1_2_clock_id_SMU11_SYSPLL1_0_FCLK_ID: atom_smu11_syspll1_2_clock_id = 0;
pub type atom_smu11_syspll1_2_clock_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll2_clock_id_SMU11_SYSPLL2_GFXCLK_ID: atom_smu11_syspll2_clock_id = 0;
pub type atom_smu11_syspll2_clock_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll3_0_clock_id_SMU11_SYSPLL3_0_WAFCLK_ID: atom_smu11_syspll3_0_clock_id =
    0;
pub const atom_smu11_syspll3_0_clock_id_SMU11_SYSPLL3_0_DISPCLK_ID: atom_smu11_syspll3_0_clock_id =
    1;
pub const atom_smu11_syspll3_0_clock_id_SMU11_SYSPLL3_0_DPREFCLK_ID: atom_smu11_syspll3_0_clock_id =
    2;
pub type atom_smu11_syspll3_0_clock_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll3_1_clock_id_SMU11_SYSPLL3_1_MP1CLK_ID: atom_smu11_syspll3_1_clock_id =
    0;
pub const atom_smu11_syspll3_1_clock_id_SMU11_SYSPLL3_1_SMNCLK_ID: atom_smu11_syspll3_1_clock_id =
    1;
pub const atom_smu11_syspll3_1_clock_id_SMU11_SYSPLL3_1_LCLK_ID: atom_smu11_syspll3_1_clock_id = 2;
pub type atom_smu11_syspll3_1_clock_id = ::core::ffi::c_uint;
pub const atom_smu12_syspll_id_SMU12_SYSPLL0_ID: atom_smu12_syspll_id = 0;
pub const atom_smu12_syspll_id_SMU12_SYSPLL1_ID: atom_smu12_syspll_id = 1;
pub const atom_smu12_syspll_id_SMU12_SYSPLL2_ID: atom_smu12_syspll_id = 2;
pub const atom_smu12_syspll_id_SMU12_SYSPLL3_0_ID: atom_smu12_syspll_id = 3;
pub const atom_smu12_syspll_id_SMU12_SYSPLL3_1_ID: atom_smu12_syspll_id = 4;
pub type atom_smu12_syspll_id = ::core::ffi::c_uint;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_SMNCLK_ID: atom_smu12_syspll0_clock_id = 0;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_SOCCLK_ID: atom_smu12_syspll0_clock_id = 1;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_MP0CLK_ID: atom_smu12_syspll0_clock_id = 2;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_MP1CLK_ID: atom_smu12_syspll0_clock_id = 3;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_MP2CLK_ID: atom_smu12_syspll0_clock_id = 4;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_VCLK_ID: atom_smu12_syspll0_clock_id = 5;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_LCLK_ID: atom_smu12_syspll0_clock_id = 6;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_DCLK_ID: atom_smu12_syspll0_clock_id = 7;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_ACLK_ID: atom_smu12_syspll0_clock_id = 8;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_ISPCLK_ID: atom_smu12_syspll0_clock_id = 9;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_SHUBCLK_ID: atom_smu12_syspll0_clock_id = 10;
pub type atom_smu12_syspll0_clock_id = ::core::ffi::c_uint;
pub const atom_smu12_syspll1_clock_id_SMU12_SYSPLL1_DISPCLK_ID: atom_smu12_syspll1_clock_id = 0;
pub const atom_smu12_syspll1_clock_id_SMU12_SYSPLL1_DPPCLK_ID: atom_smu12_syspll1_clock_id = 1;
pub const atom_smu12_syspll1_clock_id_SMU12_SYSPLL1_DPREFCLK_ID: atom_smu12_syspll1_clock_id = 2;
pub const atom_smu12_syspll1_clock_id_SMU12_SYSPLL1_DCFCLK_ID: atom_smu12_syspll1_clock_id = 3;
pub type atom_smu12_syspll1_clock_id = ::core::ffi::c_uint;
pub const atom_smu12_syspll2_clock_id_SMU12_SYSPLL2_Pre_GFXCLK_ID: atom_smu12_syspll2_clock_id = 0;
pub type atom_smu12_syspll2_clock_id = ::core::ffi::c_uint;
pub const atom_smu12_syspll3_0_clock_id_SMU12_SYSPLL3_0_FCLK_ID: atom_smu12_syspll3_0_clock_id = 0;
pub type atom_smu12_syspll3_0_clock_id = ::core::ffi::c_uint;
pub const atom_smu12_syspll3_1_clock_id_SMU12_SYSPLL3_1_UMCCLK_ID: atom_smu12_syspll3_1_clock_id =
    0;
pub type atom_smu12_syspll3_1_clock_id = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct atom_get_smu_clock_info_output_parameters_v3_1 {
    pub atom_smu_outputclkfreq: atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1,
}
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub union atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1 {
    pub smu_clock_freq_hz: u32,
    pub syspllvcofreq_10khz: u32,
    pub sysspllrefclk_10khz: u32,
}
pub const atom_dynamic_memory_setting_command_COMPUTE_MEMORY_PLL_PARAM:
    atom_dynamic_memory_setting_command = 1;
pub const atom_dynamic_memory_setting_command_COMPUTE_ENGINE_PLL_PARAM:
    atom_dynamic_memory_setting_command = 2;
pub const atom_dynamic_memory_setting_command_ADJUST_MC_SETTING_PARAM:
    atom_dynamic_memory_setting_command = 3;
pub type atom_dynamic_memory_setting_command = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct dynamic_mclk_settings_parameters_v2_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub reserved: u32,
}
impl dynamic_mclk_settings_parameters_v2_1 {
    #[inline]
    pub fn mclk_10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_mclk_10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn mclk_10khz_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                24u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_mclk_10khz_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                24u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn command(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_command(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn command_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                24usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_command_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                24usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(mclk_10khz: u32, command: u32) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let mclk_10khz: u32 = unsafe { ::core::mem::transmute(mclk_10khz) };
            mclk_10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let command: u32 = unsafe { ::core::mem::transmute(command) };
            command as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct dynamic_sclk_settings_parameters_v2_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub mclk_10khz: u32,
    pub reserved: u32,
}
impl dynamic_sclk_settings_parameters_v2_1 {
    #[inline]
    pub fn sclk_10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_sclk_10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn sclk_10khz_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                24u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_sclk_10khz_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                24u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn command(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_command(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn command_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                24usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_command_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                24usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(sclk_10khz: u32, command: u32) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let sclk_10khz: u32 = unsafe { ::core::mem::transmute(sclk_10khz) };
            sclk_10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let command: u32 = unsafe { ::core::mem::transmute(command) };
            command as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union dynamic_memory_settings_parameters_v2_1 {
    pub mclk_setting: dynamic_mclk_settings_parameters_v2_1,
    pub sclk_setting: dynamic_sclk_settings_parameters_v2_1,
}
pub const atom_umc6_0_ucode_function_call_enum_id_UMC60_UCODE_FUNC_ID_REINIT:
    atom_umc6_0_ucode_function_call_enum_id = 0;
pub const atom_umc6_0_ucode_function_call_enum_id_UMC60_UCODE_FUNC_ID_ENTER_SELFREFRESH:
    atom_umc6_0_ucode_function_call_enum_id = 1;
pub const atom_umc6_0_ucode_function_call_enum_id_UMC60_UCODE_FUNC_ID_EXIT_SELFREFRESH:
    atom_umc6_0_ucode_function_call_enum_id = 2;
pub type atom_umc6_0_ucode_function_call_enum_id = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct memory_training_parameters_v2_1 {
    pub ucode_func_id: u8,
    pub ucode_reserved: [u8; 3usize],
    pub reserved: [u32; 5usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_pixel_clock_parameter_v1_7 {
    pub pixclk_100hz: u32,
    pub pll_id: u8,
    pub encoderobjid: u8,
    pub encoder_mode: u8,
    pub miscinfo: u8,
    pub crtc_id: u8,
    pub deep_color_ratio: u8,
    pub reserved1: [u8; 2usize],
    pub reserved2: u32,
}
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_FORCE_PROG_PPLL:
    atom_set_pixel_clock_v1_7_misc_info = 1;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_PROG_PHYPLL:
    atom_set_pixel_clock_v1_7_misc_info = 2;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_YUV420_MODE:
    atom_set_pixel_clock_v1_7_misc_info = 4;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_DVI_DUALLINK_EN:
    atom_set_pixel_clock_v1_7_misc_info = 8;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_REF_DIV_SRC:
    atom_set_pixel_clock_v1_7_misc_info = 48;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_REF_DIV_SRC_XTALIN:
    atom_set_pixel_clock_v1_7_misc_info = 0;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_REF_DIV_SRC_PCIE:
    atom_set_pixel_clock_v1_7_misc_info = 16;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_REF_DIV_SRC_GENLK:
    atom_set_pixel_clock_v1_7_misc_info = 32;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_REF_DIV_SRC_REFPAD:
    atom_set_pixel_clock_v1_7_misc_info = 48;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_ATOMIC_UPDATE:
    atom_set_pixel_clock_v1_7_misc_info = 64;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_FORCE_SS_DIS:
    atom_set_pixel_clock_v1_7_misc_info = 128;
pub type atom_set_pixel_clock_v1_7_misc_info = ::core::ffi::c_uint;
pub const atom_set_pixel_clock_v1_7_deepcolor_ratio_PIXEL_CLOCK_V7_DEEPCOLOR_RATIO_DIS:
    atom_set_pixel_clock_v1_7_deepcolor_ratio = 0;
pub const atom_set_pixel_clock_v1_7_deepcolor_ratio_PIXEL_CLOCK_V7_DEEPCOLOR_RATIO_5_4:
    atom_set_pixel_clock_v1_7_deepcolor_ratio = 1;
pub const atom_set_pixel_clock_v1_7_deepcolor_ratio_PIXEL_CLOCK_V7_DEEPCOLOR_RATIO_3_2:
    atom_set_pixel_clock_v1_7_deepcolor_ratio = 2;
pub const atom_set_pixel_clock_v1_7_deepcolor_ratio_PIXEL_CLOCK_V7_DEEPCOLOR_RATIO_2_1:
    atom_set_pixel_clock_v1_7_deepcolor_ratio = 3;
pub type atom_set_pixel_clock_v1_7_deepcolor_ratio = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_dce_clock_parameters_v2_1 {
    pub dceclk_10khz: u32,
    pub dceclktype: u8,
    pub dceclksrc: u8,
    pub dceclkflag: u8,
    pub crtc_id: u8,
}
pub const atom_set_dce_clock_clock_type_DCE_CLOCK_TYPE_DISPCLK: atom_set_dce_clock_clock_type = 0;
pub const atom_set_dce_clock_clock_type_DCE_CLOCK_TYPE_DPREFCLK: atom_set_dce_clock_clock_type = 1;
pub const atom_set_dce_clock_clock_type_DCE_CLOCK_TYPE_PIXELCLK: atom_set_dce_clock_clock_type = 2;
pub type atom_set_dce_clock_clock_type = ::core::ffi::c_uint;
pub const atom_set_dce_clock_dprefclk_flag_DCE_CLOCK_FLAG_PLL_REFCLK_SRC_MASK:
    atom_set_dce_clock_dprefclk_flag = 3;
pub const atom_set_dce_clock_dprefclk_flag_DCE_CLOCK_FLAG_PLL_REFCLK_SRC_GENERICA:
    atom_set_dce_clock_dprefclk_flag = 0;
pub const atom_set_dce_clock_dprefclk_flag_DCE_CLOCK_FLAG_PLL_REFCLK_SRC_GENLK:
    atom_set_dce_clock_dprefclk_flag = 1;
pub const atom_set_dce_clock_dprefclk_flag_DCE_CLOCK_FLAG_PLL_REFCLK_SRC_PCIE:
    atom_set_dce_clock_dprefclk_flag = 2;
pub const atom_set_dce_clock_dprefclk_flag_DCE_CLOCK_FLAG_PLL_REFCLK_SRC_XTALIN:
    atom_set_dce_clock_dprefclk_flag = 3;
pub type atom_set_dce_clock_dprefclk_flag = ::core::ffi::c_uint;
pub const atom_set_dce_clock_pixclk_flag_DCE_CLOCK_FLAG_PCLK_DEEPCOLOR_RATIO_MASK:
    atom_set_dce_clock_pixclk_flag = 3;
pub const atom_set_dce_clock_pixclk_flag_DCE_CLOCK_FLAG_PCLK_DEEPCOLOR_RATIO_DIS:
    atom_set_dce_clock_pixclk_flag = 0;
pub const atom_set_dce_clock_pixclk_flag_DCE_CLOCK_FLAG_PCLK_DEEPCOLOR_RATIO_5_4:
    atom_set_dce_clock_pixclk_flag = 1;
pub const atom_set_dce_clock_pixclk_flag_DCE_CLOCK_FLAG_PCLK_DEEPCOLOR_RATIO_3_2:
    atom_set_dce_clock_pixclk_flag = 2;
pub const atom_set_dce_clock_pixclk_flag_DCE_CLOCK_FLAG_PCLK_DEEPCOLOR_RATIO_2_1:
    atom_set_dce_clock_pixclk_flag = 3;
pub const atom_set_dce_clock_pixclk_flag_DCE_CLOCK_FLAG_PIXCLK_YUV420_MODE:
    atom_set_dce_clock_pixclk_flag = 4;
pub type atom_set_dce_clock_pixclk_flag = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_dce_clock_ps_allocation_v2_1 {
    pub param: set_dce_clock_parameters_v2_1,
    pub ulReserved: [u32; 2usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct blank_crtc_parameters {
    pub crtc_id: u8,
    pub blanking: u8,
    pub reserved: u16,
    pub reserved1: u32,
}
pub const atom_blank_crtc_command_ATOM_BLANKING: atom_blank_crtc_command = 1;
pub const atom_blank_crtc_command_ATOM_BLANKING_OFF: atom_blank_crtc_command = 0;
pub type atom_blank_crtc_command = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct enable_crtc_parameters {
    pub crtc_id: u8,
    pub enable: u8,
    pub padding: [u8; 2usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct enable_disp_power_gating_parameters_v2_1 {
    pub disp_pipe_id: u8,
    pub enable: u8,
    pub padding: [u8; 2usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct enable_disp_power_gating_ps_allocation {
    pub param: enable_disp_power_gating_parameters_v2_1,
    pub ulReserved: [u32; 4usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_crtc_using_dtd_timing_parameters {
    pub h_size: u16,
    pub h_blanking_time: u16,
    pub v_size: u16,
    pub v_blanking_time: u16,
    pub h_syncoffset: u16,
    pub h_syncwidth: u16,
    pub v_syncoffset: u16,
    pub v_syncwidth: u16,
    pub modemiscinfo: u16,
    pub h_border: u8,
    pub v_border: u8,
    pub crtc_id: u8,
    pub encoder_mode: u8,
    pub padding: [u8; 2usize],
}
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct process_i2c_channel_transaction_parameters {
    pub i2cspeed_khz: u8,
    pub regind_status: process_i2c_channel_transaction_parameters__bindgen_ty_1,
    pub i2c_data_out: u16,
    pub flag: u8,
    pub trans_bytes: u8,
    pub slave_addr: u8,
    pub i2c_id: u8,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union process_i2c_channel_transaction_parameters__bindgen_ty_1 {
    pub regindex: u8,
    pub status: u8,
}
pub const atom_process_i2c_flag_HW_I2C_WRITE: atom_process_i2c_flag = 1;
pub const atom_process_i2c_flag_HW_I2C_READ: atom_process_i2c_flag = 0;
pub const atom_process_i2c_flag_I2C_2BYTE_ADDR: atom_process_i2c_flag = 2;
pub const atom_process_i2c_flag_HW_I2C_SMBUS_BYTE_WR: atom_process_i2c_flag = 4;
pub type atom_process_i2c_flag = ::core::ffi::c_uint;
pub const atom_process_i2c_status_HW_ASSISTED_I2C_STATUS_FAILURE: atom_process_i2c_status = 2;
pub const atom_process_i2c_status_HW_ASSISTED_I2C_STATUS_SUCCESS: atom_process_i2c_status = 1;
pub type atom_process_i2c_status = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct process_aux_channel_transaction_parameters_v1_2 {
    pub aux_request: u16,
    pub dataout: u16,
    pub channelid: u8,
    pub aux_status_delay: process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1,
    pub dataout_len: u8,
    pub hpd_id: u8,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1 {
    pub reply_status: u8,
    pub aux_delay: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct select_crtc_source_parameters_v2_3 {
    pub crtc_id: u8,
    pub encoder_id: u8,
    pub encode_mode: u8,
    pub dst_bpc: u8,
}
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DISABLE_DIG:
    atom_dig_encoder_control_action = 0;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_ENABLE_DIG:
    atom_dig_encoder_control_action = 1;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_LINK_TRAINING_START:
    atom_dig_encoder_control_action = 8;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_LINK_TRAINING_PATTERN1:
    atom_dig_encoder_control_action = 9;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_LINK_TRAINING_PATTERN2:
    atom_dig_encoder_control_action = 10;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_LINK_TRAINING_PATTERN3:
    atom_dig_encoder_control_action = 19;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_LINK_TRAINING_COMPLETE:
    atom_dig_encoder_control_action = 11;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_VIDEO_OFF:
    atom_dig_encoder_control_action = 12;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_VIDEO_ON:
    atom_dig_encoder_control_action = 13;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_SETUP_PANEL_MODE:
    atom_dig_encoder_control_action = 16;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_LINK_TRAINING_PATTERN4:
    atom_dig_encoder_control_action = 20;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_STREAM_SETUP:
    atom_dig_encoder_control_action = 15;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_LINK_SETUP:
    atom_dig_encoder_control_action = 17;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_ENCODER_BLANK:
    atom_dig_encoder_control_action = 18;
pub type atom_dig_encoder_control_action = ::core::ffi::c_uint;
pub const atom_dig_encoder_control_panelmode_DP_PANEL_MODE_DISABLE:
    atom_dig_encoder_control_panelmode = 0;
pub const atom_dig_encoder_control_panelmode_DP_PANEL_MODE_ENABLE_eDP_MODE:
    atom_dig_encoder_control_panelmode = 1;
pub const atom_dig_encoder_control_panelmode_DP_PANEL_MODE_ENABLE_LVLINK_MODE:
    atom_dig_encoder_control_panelmode = 17;
pub type atom_dig_encoder_control_panelmode = ::core::ffi::c_uint;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG0_ENCODER:
    atom_dig_encoder_control_v5_digid = 0;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG1_ENCODER:
    atom_dig_encoder_control_v5_digid = 1;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG2_ENCODER:
    atom_dig_encoder_control_v5_digid = 2;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG3_ENCODER:
    atom_dig_encoder_control_v5_digid = 3;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG4_ENCODER:
    atom_dig_encoder_control_v5_digid = 4;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG5_ENCODER:
    atom_dig_encoder_control_v5_digid = 5;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG6_ENCODER:
    atom_dig_encoder_control_v5_digid = 6;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG7_ENCODER:
    atom_dig_encoder_control_v5_digid = 7;
pub type atom_dig_encoder_control_v5_digid = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct dig_encoder_stream_setup_parameters_v1_5 {
    pub digid: u8,
    pub action: u8,
    pub digmode: u8,
    pub lanenum: u8,
    pub pclk_10khz: u32,
    pub bitpercolor: u8,
    pub dplinkrate_270mhz: u8,
    pub reserved: [u8; 2usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dig_encoder_link_setup_parameters_v1_5 {
    pub digid: u8,
    pub action: u8,
    pub digmode: u8,
    pub lanenum: u8,
    pub symclk_10khz: u8,
    pub hpd_sel: u8,
    pub digfe_sel: u8,
    pub reserved: [u8; 2usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct dp_panel_mode_set_parameters_v1_5 {
    pub digid: u8,
    pub action: u8,
    pub panelmode: u8,
    pub reserved1: u8,
    pub reserved2: [u32; 2usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct dig_encoder_generic_cmd_parameters_v1_5 {
    pub digid: u8,
    pub action: u8,
    pub reserved1: [u8; 2usize],
    pub reserved2: [u32; 2usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union dig_encoder_control_parameters_v1_5 {
    pub cmd_param: dig_encoder_generic_cmd_parameters_v1_5,
    pub stream_param: dig_encoder_stream_setup_parameters_v1_5,
    pub link_param: dig_encoder_link_setup_parameters_v1_5,
    pub dppanel_param: dp_panel_mode_set_parameters_v1_5,
}
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct dig_transmitter_control_parameters_v1_6 {
    pub phyid: u8,
    pub action: u8,
    pub mode_laneset: dig_transmitter_control_parameters_v1_6__bindgen_ty_1,
    pub lanenum: u8,
    pub symclk_10khz: u32,
    pub hpdsel: u8,
    pub digfe_sel: u8,
    pub connobj_id: u8,
    pub reserved: u8,
    pub reserved1: u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union dig_transmitter_control_parameters_v1_6__bindgen_ty_1 {
    pub digmode: u8,
    pub dplaneset: u8,
}
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct dig_transmitter_control_ps_allocation_v1_6 {
    pub param: dig_transmitter_control_parameters_v1_6,
    pub reserved: [u32; 4usize],
}
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_DISABLE:
    atom_dig_transmitter_control_action = 0;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_ENABLE:
    atom_dig_transmitter_control_action = 1;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_LCD_BLOFF:
    atom_dig_transmitter_control_action = 2;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_LCD_BLON:
    atom_dig_transmitter_control_action = 3;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_BL_BRIGHTNESS_CONTROL:
    atom_dig_transmitter_control_action = 4;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_LCD_SELFTEST_START:
    atom_dig_transmitter_control_action = 5;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_LCD_SELFTEST_STOP:
    atom_dig_transmitter_control_action = 6;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_INIT:
    atom_dig_transmitter_control_action = 7;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_DISABLE_OUTPUT:
    atom_dig_transmitter_control_action = 8;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_ENABLE_OUTPUT:
    atom_dig_transmitter_control_action = 9;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_SETUP:
    atom_dig_transmitter_control_action = 10;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_SETUP_VSEMPH:
    atom_dig_transmitter_control_action = 11;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_POWER_ON:
    atom_dig_transmitter_control_action = 12;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_POWER_OFF:
    atom_dig_transmitter_control_action = 13;
pub type atom_dig_transmitter_control_action = ::core::ffi::c_uint;
pub const atom_dig_transmitter_control_digfe_sel_ATOM_TRANMSITTER_V6__DIGA_SEL:
    atom_dig_transmitter_control_digfe_sel = 1;
pub const atom_dig_transmitter_control_digfe_sel_ATOM_TRANMSITTER_V6__DIGB_SEL:
    atom_dig_transmitter_control_digfe_sel = 2;
pub const atom_dig_transmitter_control_digfe_sel_ATOM_TRANMSITTER_V6__DIGC_SEL:
    atom_dig_transmitter_control_digfe_sel = 4;
pub const atom_dig_transmitter_control_digfe_sel_ATOM_TRANMSITTER_V6__DIGD_SEL:
    atom_dig_transmitter_control_digfe_sel = 8;
pub const atom_dig_transmitter_control_digfe_sel_ATOM_TRANMSITTER_V6__DIGE_SEL:
    atom_dig_transmitter_control_digfe_sel = 16;
pub const atom_dig_transmitter_control_digfe_sel_ATOM_TRANMSITTER_V6__DIGF_SEL:
    atom_dig_transmitter_control_digfe_sel = 32;
pub const atom_dig_transmitter_control_digfe_sel_ATOM_TRANMSITTER_V6__DIGG_SEL:
    atom_dig_transmitter_control_digfe_sel = 64;
pub type atom_dig_transmitter_control_digfe_sel = ::core::ffi::c_uint;
pub const atom_dig_transmitter_control_hpd_sel_ATOM_TRANSMITTER_V6_NO_HPD_SEL:
    atom_dig_transmitter_control_hpd_sel = 0;
pub const atom_dig_transmitter_control_hpd_sel_ATOM_TRANSMITTER_V6_HPD1_SEL:
    atom_dig_transmitter_control_hpd_sel = 1;
pub const atom_dig_transmitter_control_hpd_sel_ATOM_TRANSMITTER_V6_HPD2_SEL:
    atom_dig_transmitter_control_hpd_sel = 2;
pub const atom_dig_transmitter_control_hpd_sel_ATOM_TRANSMITTER_V6_HPD3_SEL:
    atom_dig_transmitter_control_hpd_sel = 3;
pub const atom_dig_transmitter_control_hpd_sel_ATOM_TRANSMITTER_V6_HPD4_SEL:
    atom_dig_transmitter_control_hpd_sel = 4;
pub const atom_dig_transmitter_control_hpd_sel_ATOM_TRANSMITTER_V6_HPD5_SEL:
    atom_dig_transmitter_control_hpd_sel = 5;
pub const atom_dig_transmitter_control_hpd_sel_ATOM_TRANSMITTER_V6_HPD6_SEL:
    atom_dig_transmitter_control_hpd_sel = 6;
pub type atom_dig_transmitter_control_hpd_sel = ::core::ffi::c_uint;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__0DB_0_4V:
    atom_dig_transmitter_control_dplaneset = 0;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__0DB_0_6V:
    atom_dig_transmitter_control_dplaneset = 1;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__0DB_0_8V:
    atom_dig_transmitter_control_dplaneset = 2;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__0DB_1_2V:
    atom_dig_transmitter_control_dplaneset = 3;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__3_5DB_0_4V:
    atom_dig_transmitter_control_dplaneset = 8;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__3_5DB_0_6V:
    atom_dig_transmitter_control_dplaneset = 9;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__3_5DB_0_8V:
    atom_dig_transmitter_control_dplaneset = 10;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__6DB_0_4V:
    atom_dig_transmitter_control_dplaneset = 16;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__6DB_0_6V:
    atom_dig_transmitter_control_dplaneset = 17;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__9_5DB_0_4V:
    atom_dig_transmitter_control_dplaneset = 24;
pub type atom_dig_transmitter_control_dplaneset = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct external_encoder_control_parameters_v2_4 {
    pub pixelclock_10khz: u16,
    pub config: u8,
    pub action: u8,
    pub encodermode: u8,
    pub lanenum: u8,
    pub bitpercolor: u8,
    pub hpd_id: u8,
}
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_DISABLE_OUTPUT:
    external_encoder_control_action_def = 0;
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_ENABLE_OUTPUT:
    external_encoder_control_action_def = 1;
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_ENCODER_INIT:
    external_encoder_control_action_def = 7;
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_ENCODER_SETUP:
    external_encoder_control_action_def = 15;
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_ENCODER_BLANKING_OFF:
    external_encoder_control_action_def = 16;
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_ENCODER_BLANKING:
    external_encoder_control_action_def = 17;
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_DACLOAD_DETECTION:
    external_encoder_control_action_def = 18;
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_DDC_SETUP:
    external_encoder_control_action_def = 20;
pub type external_encoder_control_action_def = ::core::ffi::c_uint;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_DPLINKRATE_MASK:
    external_encoder_control_v2_4_config_def = 3;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_DPLINKRATE_1_62GHZ:
    external_encoder_control_v2_4_config_def = 0;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_DPLINKRATE_2_70GHZ:
    external_encoder_control_v2_4_config_def = 1;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_DPLINKRATE_5_40GHZ:
    external_encoder_control_v2_4_config_def = 2;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_DPLINKRATE_3_24GHZ:
    external_encoder_control_v2_4_config_def = 3;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_ENCODER_SEL_MAKS:
    external_encoder_control_v2_4_config_def = 112;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_ENCODER1:
    external_encoder_control_v2_4_config_def = 0;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_ENCODER2:
    external_encoder_control_v2_4_config_def = 16;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_ENCODER3:
    external_encoder_control_v2_4_config_def = 32;
pub type external_encoder_control_v2_4_config_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct external_encoder_control_ps_allocation_v2_4 {
    pub sExtEncoder: external_encoder_control_parameters_v2_4,
    pub reserved: [u32; 2usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct amd_acpi_description_header {
    pub signature: u32,
    pub tableLength: u32,
    pub revision: u8,
    pub checksum: u8,
    pub oemId: [u8; 6usize],
    pub oemTableId: [u8; 8usize],
    pub oemRevision: u32,
    pub creatorId: u32,
    pub creatorRevision: u32,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct uefi_acpi_vfct {
    pub sheader: amd_acpi_description_header,
    pub tableUUID: [u8; 16usize],
    pub vbiosimageoffset: u32,
    pub lib1Imageoffset: u32,
    pub reserved: [u32; 4usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct vfct_image_header {
    pub pcibus: u32,
    pub pcidevice: u32,
    pub pcifunction: u32,
    pub vendorid: u16,
    pub deviceid: u16,
    pub ssvid: u16,
    pub ssid: u16,
    pub revision: u32,
    pub imagelength: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gop_vbios_content {
    pub vbiosheader: vfct_image_header,
    pub vbioscontent: [u8; 1usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gop_lib1_content {
    pub lib1header: vfct_image_header,
    pub lib1content: [u8; 1usize],
}
pub const scratch_register_def_ATOM_DEVICE_CONNECT_INFO_DEF: scratch_register_def = 0;
pub const scratch_register_def_ATOM_BL_BRI_LEVEL_INFO_DEF: scratch_register_def = 2;
pub const scratch_register_def_ATOM_ACTIVE_INFO_DEF: scratch_register_def = 3;
pub const scratch_register_def_ATOM_LCD_INFO_DEF: scratch_register_def = 4;
pub const scratch_register_def_ATOM_DEVICE_REQ_INFO_DEF: scratch_register_def = 5;
pub const scratch_register_def_ATOM_ACC_CHANGE_INFO_DEF: scratch_register_def = 6;
pub const scratch_register_def_ATOM_PRE_OS_MODE_INFO_DEF: scratch_register_def = 7;
pub const scratch_register_def_ATOM_PRE_OS_ASSERTION_DEF: scratch_register_def = 8;
pub const scratch_register_def_ATOM_INTERNAL_TIMER_INFO_DEF: scratch_register_def = 10;
pub type scratch_register_def = ::core::ffi::c_uint;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_LCD1_CONNECT:
    scratch_device_connect_info_bit_def = 2;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_DFP1_CONNECT:
    scratch_device_connect_info_bit_def = 8;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_DFP2_CONNECT:
    scratch_device_connect_info_bit_def = 128;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_DFP3_CONNECT:
    scratch_device_connect_info_bit_def = 512;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_DFP4_CONNECT:
    scratch_device_connect_info_bit_def = 1024;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_DFP5_CONNECT:
    scratch_device_connect_info_bit_def = 2048;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_DFP6_CONNECT:
    scratch_device_connect_info_bit_def = 64;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_DFPx_CONNECT:
    scratch_device_connect_info_bit_def = 3784;
pub const scratch_device_connect_info_bit_def_ATOM_CONNECT_INFO_DEVICE_MASK:
    scratch_device_connect_info_bit_def = 4095;
pub type scratch_device_connect_info_bit_def = ::core::ffi::c_uint;
pub const scratch_bl_bri_level_info_bit_def_ATOM_CURRENT_BL_LEVEL_SHIFT:
    scratch_bl_bri_level_info_bit_def = 8;
pub const scratch_bl_bri_level_info_bit_def_ATOM_CURRENT_BL_LEVEL_MASK:
    scratch_bl_bri_level_info_bit_def = 65280;
pub const scratch_bl_bri_level_info_bit_def_ATOM_DEVICE_DPMS_STATE:
    scratch_bl_bri_level_info_bit_def = 65536;
pub type scratch_bl_bri_level_info_bit_def = ::core::ffi::c_uint;
pub const scratch_active_info_bits_def_ATOM_DISPLAY_LCD1_ACTIVE: scratch_active_info_bits_def = 2;
pub const scratch_active_info_bits_def_ATOM_DISPLAY_DFP1_ACTIVE: scratch_active_info_bits_def = 8;
pub const scratch_active_info_bits_def_ATOM_DISPLAY_DFP2_ACTIVE: scratch_active_info_bits_def = 128;
pub const scratch_active_info_bits_def_ATOM_DISPLAY_DFP3_ACTIVE: scratch_active_info_bits_def = 512;
pub const scratch_active_info_bits_def_ATOM_DISPLAY_DFP4_ACTIVE: scratch_active_info_bits_def =
    1024;
pub const scratch_active_info_bits_def_ATOM_DISPLAY_DFP5_ACTIVE: scratch_active_info_bits_def =
    2048;
pub const scratch_active_info_bits_def_ATOM_DISPLAY_DFP6_ACTIVE: scratch_active_info_bits_def = 64;
pub const scratch_active_info_bits_def_ATOM_ACTIVE_INFO_DEVICE_MASK: scratch_active_info_bits_def =
    4095;
pub type scratch_active_info_bits_def = ::core::ffi::c_uint;
pub const scratch_device_req_info_bits_def_ATOM_DISPLAY_LCD1_REQ: scratch_device_req_info_bits_def =
    2;
pub const scratch_device_req_info_bits_def_ATOM_DISPLAY_DFP1_REQ: scratch_device_req_info_bits_def =
    8;
pub const scratch_device_req_info_bits_def_ATOM_DISPLAY_DFP2_REQ: scratch_device_req_info_bits_def =
    128;
pub const scratch_device_req_info_bits_def_ATOM_DISPLAY_DFP3_REQ: scratch_device_req_info_bits_def =
    512;
pub const scratch_device_req_info_bits_def_ATOM_DISPLAY_DFP4_REQ: scratch_device_req_info_bits_def =
    1024;
pub const scratch_device_req_info_bits_def_ATOM_DISPLAY_DFP5_REQ: scratch_device_req_info_bits_def =
    2048;
pub const scratch_device_req_info_bits_def_ATOM_DISPLAY_DFP6_REQ: scratch_device_req_info_bits_def =
    64;
pub const scratch_device_req_info_bits_def_ATOM_REQ_INFO_DEVICE_MASK:
    scratch_device_req_info_bits_def = 4095;
pub type scratch_device_req_info_bits_def = ::core::ffi::c_uint;
pub const scratch_acc_change_info_bitshift_def_ATOM_ACC_CHANGE_ACC_MODE_SHIFT:
    scratch_acc_change_info_bitshift_def = 4;
pub const scratch_acc_change_info_bitshift_def_ATOM_ACC_CHANGE_LID_STATUS_SHIFT:
    scratch_acc_change_info_bitshift_def = 6;
pub type scratch_acc_change_info_bitshift_def = ::core::ffi::c_uint;
pub const scratch_acc_change_info_bits_def_ATOM_ACC_CHANGE_ACC_MODE:
    scratch_acc_change_info_bits_def = 16;
pub const scratch_acc_change_info_bits_def_ATOM_ACC_CHANGE_LID_STATUS:
    scratch_acc_change_info_bits_def = 64;
pub type scratch_acc_change_info_bits_def = ::core::ffi::c_uint;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_MASK:
    scratch_pre_os_mode_info_bits_def = 3;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_VGA:
    scratch_pre_os_mode_info_bits_def = 0;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_VESA:
    scratch_pre_os_mode_info_bits_def = 1;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_GOP:
    scratch_pre_os_mode_info_bits_def = 2;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_PIXEL_DEPTH:
    scratch_pre_os_mode_info_bits_def = 12;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_PIXEL_FORMAT_MASK:
    scratch_pre_os_mode_info_bits_def = 240;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_8BIT_PAL_EN:
    scratch_pre_os_mode_info_bits_def = 256;
pub const scratch_pre_os_mode_info_bits_def_ATOM_ASIC_INIT_COMPLETE:
    scratch_pre_os_mode_info_bits_def = 512;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_NUMBER_MASK:
    scratch_pre_os_mode_info_bits_def = 4294901760;
pub type scratch_pre_os_mode_info_bits_def = ::core::ffi::c_uint;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__UTILITY_PIPELINE: atom_master_data_table_id =
    0;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__MULTIMEDIA_INF: atom_master_data_table_id =
    1;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__FIRMWARE_INF: atom_master_data_table_id = 2;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__LCD_INF: atom_master_data_table_id = 3;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__SMU_INF: atom_master_data_table_id = 4;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__VRAM_USAGE_BY_FIRMWARE:
    atom_master_data_table_id = 5;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__GPIO_PIN_LUT: atom_master_data_table_id = 6;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__GFX_INF: atom_master_data_table_id = 7;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__POWER_PLAY_INF: atom_master_data_table_id =
    8;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__DISPLAY_OBJECT_INF:
    atom_master_data_table_id = 9;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__INDIRECT_IO_ACCESS:
    atom_master_data_table_id = 10;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__UMC_INF: atom_master_data_table_id = 11;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__DCE_INF: atom_master_data_table_id = 12;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__VRAM_INF: atom_master_data_table_id = 13;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__INTEGRATED_SYS_INF:
    atom_master_data_table_id = 14;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__ASIC_PROFILING_INF:
    atom_master_data_table_id = 15;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__VOLTAGE_OBJ_INF: atom_master_data_table_id =
    16;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__UNDEFINED: atom_master_data_table_id = 17;
pub type atom_master_data_table_id = ::core::ffi::c_uint;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__ASIC_INIT: atom_master_command_table_id =
    0;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__DIGX_ENCODER_CONTROL:
    atom_master_command_table_id = 1;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__SET_ENGINE_CLOCK:
    atom_master_command_table_id = 2;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__SET_MEMORY_CLOCK:
    atom_master_command_table_id = 3;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__SET_PIXEL_CLOCK:
    atom_master_command_table_id = 4;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__ENABLE_DISP_POWER_GATING:
    atom_master_command_table_id = 5;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__BLANK_CRTC: atom_master_command_table_id =
    6;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__ENABLE_CRTC: atom_master_command_table_id =
    7;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__GET_SMU_CLOCK_INFO:
    atom_master_command_table_id = 8;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__SELECT_CRTC_SOURCE:
    atom_master_command_table_id = 9;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__SET_DCE_CLOCK:
    atom_master_command_table_id = 10;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__GET_MEMORY_CLOCK:
    atom_master_command_table_id = 11;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__GET_ENGINE_CLOCK:
    atom_master_command_table_id = 12;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__SET_CRTC_USING_DTD_TIMING:
    atom_master_command_table_id = 13;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__EXTENAL_ENCODER_CONTROL:
    atom_master_command_table_id = 14;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__PROCESS_I2C_CHANNEL_TRANSACTION:
    atom_master_command_table_id = 15;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__COMPUTE_GPU_CLOCK_PARAM:
    atom_master_command_table_id = 16;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__DYNAMIC_MEMORY_SETTINGS:
    atom_master_command_table_id = 17;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__MEMORY_TRAINING:
    atom_master_command_table_id = 18;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__SET_VOLTAGE: atom_master_command_table_id =
    19;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__DIG1_TRANSMITTER_CONTROL:
    atom_master_command_table_id = 20;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__PROCESS_AUX_CHANNEL_TRANSACTION:
    atom_master_command_table_id = 21;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__GET_VOLTAGE_INF:
    atom_master_command_table_id = 22;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__UNDEFINED: atom_master_command_table_id =
    23;
pub type atom_master_command_table_id = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct metrics_table_header {
    pub structure_size: u16,
    pub format_revision: u8,
    pub content_revision: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gpu_metrics_v1_0 {
    pub common_header: metrics_table_header,
    pub system_clock_counter: u64,
    pub temperature_edge: u16,
    pub temperature_hotspot: u16,
    pub temperature_mem: u16,
    pub temperature_vrgfx: u16,
    pub temperature_vrsoc: u16,
    pub temperature_vrmem: u16,
    pub average_gfx_activity: u16,
    pub average_umc_activity: u16,
    pub average_mm_activity: u16,
    pub average_socket_power: u16,
    pub energy_accumulator: u32,
    pub average_gfxclk_frequency: u16,
    pub average_socclk_frequency: u16,
    pub average_uclk_frequency: u16,
    pub average_vclk0_frequency: u16,
    pub average_dclk0_frequency: u16,
    pub average_vclk1_frequency: u16,
    pub average_dclk1_frequency: u16,
    pub current_gfxclk: u16,
    pub current_socclk: u16,
    pub current_uclk: u16,
    pub current_vclk0: u16,
    pub current_dclk0: u16,
    pub current_vclk1: u16,
    pub current_dclk1: u16,
    pub throttle_status: u32,
    pub current_fan_speed: u16,
    pub pcie_link_width: u8,
    pub pcie_link_speed: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gpu_metrics_v1_1 {
    pub common_header: metrics_table_header,
    pub temperature_edge: u16,
    pub temperature_hotspot: u16,
    pub temperature_mem: u16,
    pub temperature_vrgfx: u16,
    pub temperature_vrsoc: u16,
    pub temperature_vrmem: u16,
    pub average_gfx_activity: u16,
    pub average_umc_activity: u16,
    pub average_mm_activity: u16,
    pub average_socket_power: u16,
    pub energy_accumulator: u64,
    pub system_clock_counter: u64,
    pub average_gfxclk_frequency: u16,
    pub average_socclk_frequency: u16,
    pub average_uclk_frequency: u16,
    pub average_vclk0_frequency: u16,
    pub average_dclk0_frequency: u16,
    pub average_vclk1_frequency: u16,
    pub average_dclk1_frequency: u16,
    pub current_gfxclk: u16,
    pub current_socclk: u16,
    pub current_uclk: u16,
    pub current_vclk0: u16,
    pub current_dclk0: u16,
    pub current_vclk1: u16,
    pub current_dclk1: u16,
    pub throttle_status: u32,
    pub current_fan_speed: u16,
    pub pcie_link_width: u16,
    pub pcie_link_speed: u16,
    pub padding: u16,
    pub gfx_activity_acc: u32,
    pub mem_activity_acc: u32,
    pub temperature_hbm: [u16; 4usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gpu_metrics_v1_2 {
    pub common_header: metrics_table_header,
    pub temperature_edge: u16,
    pub temperature_hotspot: u16,
    pub temperature_mem: u16,
    pub temperature_vrgfx: u16,
    pub temperature_vrsoc: u16,
    pub temperature_vrmem: u16,
    pub average_gfx_activity: u16,
    pub average_umc_activity: u16,
    pub average_mm_activity: u16,
    pub average_socket_power: u16,
    pub energy_accumulator: u64,
    pub system_clock_counter: u64,
    pub average_gfxclk_frequency: u16,
    pub average_socclk_frequency: u16,
    pub average_uclk_frequency: u16,
    pub average_vclk0_frequency: u16,
    pub average_dclk0_frequency: u16,
    pub average_vclk1_frequency: u16,
    pub average_dclk1_frequency: u16,
    pub current_gfxclk: u16,
    pub current_socclk: u16,
    pub current_uclk: u16,
    pub current_vclk0: u16,
    pub current_dclk0: u16,
    pub current_vclk1: u16,
    pub current_dclk1: u16,
    pub throttle_status: u32,
    pub current_fan_speed: u16,
    pub pcie_link_width: u16,
    pub pcie_link_speed: u16,
    pub padding: u16,
    pub gfx_activity_acc: u32,
    pub mem_activity_acc: u32,
    pub temperature_hbm: [u16; 4usize],
    pub firmware_timestamp: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gpu_metrics_v1_3 {
    pub common_header: metrics_table_header,
    pub temperature_edge: u16,
    pub temperature_hotspot: u16,
    pub temperature_mem: u16,
    pub temperature_vrgfx: u16,
    pub temperature_vrsoc: u16,
    pub temperature_vrmem: u16,
    pub average_gfx_activity: u16,
    pub average_umc_activity: u16,
    pub average_mm_activity: u16,
    pub average_socket_power: u16,
    pub energy_accumulator: u64,
    pub system_clock_counter: u64,
    pub average_gfxclk_frequency: u16,
    pub average_socclk_frequency: u16,
    pub average_uclk_frequency: u16,
    pub average_vclk0_frequency: u16,
    pub average_dclk0_frequency: u16,
    pub average_vclk1_frequency: u16,
    pub average_dclk1_frequency: u16,
    pub current_gfxclk: u16,
    pub current_socclk: u16,
    pub current_uclk: u16,
    pub current_vclk0: u16,
    pub current_dclk0: u16,
    pub current_vclk1: u16,
    pub current_dclk1: u16,
    pub throttle_status: u32,
    pub current_fan_speed: u16,
    pub pcie_link_width: u16,
    pub pcie_link_speed: u16,
    pub padding: u16,
    pub gfx_activity_acc: u32,
    pub mem_activity_acc: u32,
    pub temperature_hbm: [u16; 4usize],
    pub firmware_timestamp: u64,
    pub voltage_soc: u16,
    pub voltage_gfx: u16,
    pub voltage_mem: u16,
    pub padding1: u16,
    pub indep_throttle_status: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gpu_metrics_v1_4 {
    pub common_header: metrics_table_header,
    pub temperature_hotspot: u16,
    pub temperature_mem: u16,
    pub temperature_vrsoc: u16,
    pub curr_socket_power: u16,
    pub average_gfx_activity: u16,
    pub average_umc_activity: u16,
    pub vcn_activity: [u16; 4usize],
    pub energy_accumulator: u64,
    pub system_clock_counter: u64,
    pub throttle_status: u32,
    pub gfxclk_lock_status: u32,
    pub pcie_link_width: u16,
    pub pcie_link_speed: u16,
    pub xgmi_link_width: u16,
    pub xgmi_link_speed: u16,
    pub gfx_activity_acc: u32,
    pub mem_activity_acc: u32,
    pub pcie_bandwidth_acc: u64,
    pub pcie_bandwidth_inst: u64,
    pub pcie_l0_to_recov_count_acc: u64,
    pub pcie_replay_count_acc: u64,
    pub pcie_replay_rover_count_acc: u64,
    pub xgmi_read_data_acc: [u64; 8usize],
    pub xgmi_write_data_acc: [u64; 8usize],
    pub firmware_timestamp: u64,
    pub current_gfxclk: [u16; 8usize],
    pub current_socclk: [u16; 4usize],
    pub current_vclk0: [u16; 4usize],
    pub current_dclk0: [u16; 4usize],
    pub current_uclk: u16,
    pub padding: u16,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gpu_metrics_v1_5 {
    pub common_header: metrics_table_header,
    pub temperature_hotspot: u16,
    pub temperature_mem: u16,
    pub temperature_vrsoc: u16,
    pub curr_socket_power: u16,
    pub average_gfx_activity: u16,
    pub average_umc_activity: u16,
    pub vcn_activity: [u16; 4usize],
    pub jpeg_activity: [u16; 32usize],
    pub energy_accumulator: u64,
    pub system_clock_counter: u64,
    pub throttle_status: u32,
    pub gfxclk_lock_status: u32,
    pub pcie_link_width: u16,
    pub pcie_link_speed: u16,
    pub xgmi_link_width: u16,
    pub xgmi_link_speed: u16,
    pub gfx_activity_acc: u32,
    pub mem_activity_acc: u32,
    pub pcie_bandwidth_acc: u64,
    pub pcie_bandwidth_inst: u64,
    pub pcie_l0_to_recov_count_acc: u64,
    pub pcie_replay_count_acc: u64,
    pub pcie_replay_rover_count_acc: u64,
    pub pcie_nak_sent_count_acc: u32,
    pub pcie_nak_rcvd_count_acc: u32,
    pub xgmi_read_data_acc: [u64; 8usize],
    pub xgmi_write_data_acc: [u64; 8usize],
    pub firmware_timestamp: u64,
    pub current_gfxclk: [u16; 8usize],
    pub current_socclk: [u16; 4usize],
    pub current_vclk0: [u16; 4usize],
    pub current_dclk0: [u16; 4usize],
    pub current_uclk: u16,
    pub padding: u16,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gpu_metrics_v2_0 {
    pub common_header: metrics_table_header,
    pub system_clock_counter: u64,
    pub temperature_gfx: u16,
    pub temperature_soc: u16,
    pub temperature_core: [u16; 8usize],
    pub temperature_l3: [u16; 2usize],
    pub average_gfx_activity: u16,
    pub average_mm_activity: u16,
    pub average_socket_power: u16,
    pub average_cpu_power: u16,
    pub average_soc_power: u16,
    pub average_gfx_power: u16,
    pub average_core_power: [u16; 8usize],
    pub average_gfxclk_frequency: u16,
    pub average_socclk_frequency: u16,
    pub average_uclk_frequency: u16,
    pub average_fclk_frequency: u16,
    pub average_vclk_frequency: u16,
    pub average_dclk_frequency: u16,
    pub current_gfxclk: u16,
    pub current_socclk: u16,
    pub current_uclk: u16,
    pub current_fclk: u16,
    pub current_vclk: u16,
    pub current_dclk: u16,
    pub current_coreclk: [u16; 8usize],
    pub current_l3clk: [u16; 2usize],
    pub throttle_status: u32,
    pub fan_pwm: u16,
    pub padding: u16,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gpu_metrics_v2_1 {
    pub common_header: metrics_table_header,
    pub temperature_gfx: u16,
    pub temperature_soc: u16,
    pub temperature_core: [u16; 8usize],
    pub temperature_l3: [u16; 2usize],
    pub average_gfx_activity: u16,
    pub average_mm_activity: u16,
    pub system_clock_counter: u64,
    pub average_socket_power: u16,
    pub average_cpu_power: u16,
    pub average_soc_power: u16,
    pub average_gfx_power: u16,
    pub average_core_power: [u16; 8usize],
    pub average_gfxclk_frequency: u16,
    pub average_socclk_frequency: u16,
    pub average_uclk_frequency: u16,
    pub average_fclk_frequency: u16,
    pub average_vclk_frequency: u16,
    pub average_dclk_frequency: u16,
    pub current_gfxclk: u16,
    pub current_socclk: u16,
    pub current_uclk: u16,
    pub current_fclk: u16,
    pub current_vclk: u16,
    pub current_dclk: u16,
    pub current_coreclk: [u16; 8usize],
    pub current_l3clk: [u16; 2usize],
    pub throttle_status: u32,
    pub fan_pwm: u16,
    pub padding: [u16; 3usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gpu_metrics_v2_2 {
    pub common_header: metrics_table_header,
    pub temperature_gfx: u16,
    pub temperature_soc: u16,
    pub temperature_core: [u16; 8usize],
    pub temperature_l3: [u16; 2usize],
    pub average_gfx_activity: u16,
    pub average_mm_activity: u16,
    pub system_clock_counter: u64,
    pub average_socket_power: u16,
    pub average_cpu_power: u16,
    pub average_soc_power: u16,
    pub average_gfx_power: u16,
    pub average_core_power: [u16; 8usize],
    pub average_gfxclk_frequency: u16,
    pub average_socclk_frequency: u16,
    pub average_uclk_frequency: u16,
    pub average_fclk_frequency: u16,
    pub average_vclk_frequency: u16,
    pub average_dclk_frequency: u16,
    pub current_gfxclk: u16,
    pub current_socclk: u16,
    pub current_uclk: u16,
    pub current_fclk: u16,
    pub current_vclk: u16,
    pub current_dclk: u16,
    pub current_coreclk: [u16; 8usize],
    pub current_l3clk: [u16; 2usize],
    pub throttle_status: u32,
    pub fan_pwm: u16,
    pub padding: [u16; 3usize],
    pub indep_throttle_status: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gpu_metrics_v2_3 {
    pub common_header: metrics_table_header,
    pub temperature_gfx: u16,
    pub temperature_soc: u16,
    pub temperature_core: [u16; 8usize],
    pub temperature_l3: [u16; 2usize],
    pub average_gfx_activity: u16,
    pub average_mm_activity: u16,
    pub system_clock_counter: u64,
    pub average_socket_power: u16,
    pub average_cpu_power: u16,
    pub average_soc_power: u16,
    pub average_gfx_power: u16,
    pub average_core_power: [u16; 8usize],
    pub average_gfxclk_frequency: u16,
    pub average_socclk_frequency: u16,
    pub average_uclk_frequency: u16,
    pub average_fclk_frequency: u16,
    pub average_vclk_frequency: u16,
    pub average_dclk_frequency: u16,
    pub current_gfxclk: u16,
    pub current_socclk: u16,
    pub current_uclk: u16,
    pub current_fclk: u16,
    pub current_vclk: u16,
    pub current_dclk: u16,
    pub current_coreclk: [u16; 8usize],
    pub current_l3clk: [u16; 2usize],
    pub throttle_status: u32,
    pub fan_pwm: u16,
    pub padding: [u16; 3usize],
    pub indep_throttle_status: u64,
    pub average_temperature_gfx: u16,
    pub average_temperature_soc: u16,
    pub average_temperature_core: [u16; 8usize],
    pub average_temperature_l3: [u16; 2usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gpu_metrics_v2_4 {
    pub common_header: metrics_table_header,
    pub temperature_gfx: u16,
    pub temperature_soc: u16,
    pub temperature_core: [u16; 8usize],
    pub temperature_l3: [u16; 2usize],
    pub average_gfx_activity: u16,
    pub average_mm_activity: u16,
    pub system_clock_counter: u64,
    pub average_socket_power: u16,
    pub average_cpu_power: u16,
    pub average_soc_power: u16,
    pub average_gfx_power: u16,
    pub average_core_power: [u16; 8usize],
    pub average_gfxclk_frequency: u16,
    pub average_socclk_frequency: u16,
    pub average_uclk_frequency: u16,
    pub average_fclk_frequency: u16,
    pub average_vclk_frequency: u16,
    pub average_dclk_frequency: u16,
    pub current_gfxclk: u16,
    pub current_socclk: u16,
    pub current_uclk: u16,
    pub current_fclk: u16,
    pub current_vclk: u16,
    pub current_dclk: u16,
    pub current_coreclk: [u16; 8usize],
    pub current_l3clk: [u16; 2usize],
    pub throttle_status: u32,
    pub fan_pwm: u16,
    pub padding: [u16; 3usize],
    pub indep_throttle_status: u64,
    pub average_temperature_gfx: u16,
    pub average_temperature_soc: u16,
    pub average_temperature_core: [u16; 8usize],
    pub average_temperature_l3: [u16; 2usize],
    pub average_cpu_voltage: u16,
    pub average_soc_voltage: u16,
    pub average_gfx_voltage: u16,
    pub average_cpu_current: u16,
    pub average_soc_current: u16,
    pub average_gfx_current: u16,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gpu_metrics_v3_0 {
    pub common_header: metrics_table_header,
    pub temperature_gfx: u16,
    pub temperature_soc: u16,
    pub temperature_core: [u16; 16usize],
    pub temperature_skin: u16,
    pub average_gfx_activity: u16,
    pub average_vcn_activity: u16,
    pub average_ipu_activity: [u16; 8usize],
    pub average_core_c0_activity: [u16; 16usize],
    pub average_dram_reads: u16,
    pub average_dram_writes: u16,
    pub average_ipu_reads: u16,
    pub average_ipu_writes: u16,
    pub system_clock_counter: u64,
    pub average_socket_power: u32,
    pub average_ipu_power: u16,
    pub average_apu_power: u32,
    pub average_gfx_power: u32,
    pub average_dgpu_power: u32,
    pub average_all_core_power: u32,
    pub average_core_power: [u16; 16usize],
    pub average_sys_power: u16,
    pub stapm_power_limit: u16,
    pub current_stapm_power_limit: u16,
    pub average_gfxclk_frequency: u16,
    pub average_socclk_frequency: u16,
    pub average_vpeclk_frequency: u16,
    pub average_ipuclk_frequency: u16,
    pub average_fclk_frequency: u16,
    pub average_vclk_frequency: u16,
    pub average_uclk_frequency: u16,
    pub average_mpipu_frequency: u16,
    pub current_coreclk: [u16; 16usize],
    pub current_core_maxfreq: u16,
    pub current_gfx_maxfreq: u16,
    pub throttle_residency_prochot: u32,
    pub throttle_residency_spl: u32,
    pub throttle_residency_fppt: u32,
    pub throttle_residency_sppt: u32,
    pub throttle_residency_thm_core: u32,
    pub throttle_residency_thm_gfx: u32,
    pub throttle_residency_thm_soc: u32,
    pub time_filter_alphavalue: u32,
}
pub type __builtin_va_list = [__va_list_tag; 1usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __va_list_tag {
    pub gp_offset: ::core::ffi::c_uint,
    pub fp_offset: ::core::ffi::c_uint,
    pub overflow_arg_area: *mut ::core::ffi::c_void,
    pub reg_save_area: *mut ::core::ffi::c_void,
}
