// Code generated by stringdata. DO NOT EDIT.

package schema

// BatchSpecJSON is the content of the file "../../../schema/batch_spec.schema.json".
const BatchSpecJSON = `{
  "$id": "batch_spec.schema.json#",
  "$schema": "http://json-schema.org/draft-07/schema#",
  "title": "BatchSpec",
  "description": "A batch specification, which describes the batch change and what kinds of changes to make (or what existing changesets to track).",
  "type": "object",
  "additionalProperties": false,
  "required": ["name"],
  "properties": {
    "name": {
      "type": "string",
      "description": "The name of the batch change, which is unique among all batch changes in the namespace. A batch change's name is case-preserving.",
      "pattern": "^[\\w.-]+$"
    },
    "description": {
      "type": "string",
      "description": "The description of the batch change."
    },
    "on": {
      "type": ["array", "null"],
      "description": "The set of repositories (and branches) to run the batch change on, specified as a list of search queries (that match repositories) and/or specific repositories.",
      "items": {
        "title": "OnQueryOrRepository",
        "oneOf": [
          {
            "title": "OnQuery",
            "type": "object",
            "description": "A Sourcegraph search query that matches a set of repositories (and branches). Each matched repository branch is added to the list of repositories that the batch change will be run on.",
            "additionalProperties": false,
            "required": ["repositoriesMatchingQuery"],
            "properties": {
              "repositoriesMatchingQuery": {
                "type": "string",
                "description": "A Sourcegraph search query that matches a set of repositories (and branches). If the query matches files, symbols, or some other object inside a repository, the object's repository is included.",
                "examples": ["file:README.md"]
              }
            }
          },
          {
            "title": "OnRepository",
            "type": "object",
            "description": "A specific repository (and branch) that is added to the list of repositories that the batch change will be run on.",
            "additionalProperties": false,
            "required": ["repository"],
            "properties": {
              "repository": {
                "type": "string",
                "description": "The name of the repository (as it is known to Sourcegraph).",
                "examples": ["github.com/foo/bar"]
              },
              "branch": {
                "description": "The repository branch to propose changes to. If unset, the repository's default branch is used. If this field is defined, branches cannot be.",
                "type": "string"
              },
              "branches": {
                "description": "The repository branches to propose changes to. If unset, the repository's default branch is used. If this field is defined, branch cannot be.",
                "type": "array",
                "items": {
                  "type": "string"
                }
              }
            },
            "$comment": "This is a convoluted way of saying either ` + "`" + `branch` + "`" + ` or ` + "`" + `branches` + "`" + ` can be provided, but not both at once, and neither are required.",
            "anyOf": [
              {
                "oneOf": [
                  {
                    "required": ["branch"]
                  },
                  {
                    "required": ["branches"]
                  }
                ]
              },
              {
                "not": {
                  "required": ["branch", "branches"]
                }
              }
            ]
          }
        ]
      }
    },
    "workspaces": {
      "type": ["array", "null"],
      "description": "Individual workspace configurations for one or more repositories that define which workspaces to use for the execution of steps in the repositories.",
      "items": {
        "title": "WorkspaceConfiguration",
        "type": "object",
        "description": "Configuration for how to setup workspaces in repositories",
        "additionalProperties": false,
        "required": ["rootAtLocationOf"],
        "properties": {
          "rootAtLocationOf": {
            "type": "string",
            "description": "The name of the file that sits at the root of the desired workspace.",
            "examples": ["package.json", "go.mod", "Gemfile", "Cargo.toml", "README.md"]
          },
          "in": {
            "type": "string",
            "description": "The repositories in which to apply the workspace configuration. Supports globbing.",
            "examples": ["github.com/sourcegraph/src-cli", "github.com/sourcegraph/*"]
          },
          "onlyFetchWorkspace": {
            "type": "boolean",
            "description": "If this is true only the files in the workspace (and additional .gitignore) are downloaded instead of an archive of the full repository.",
            "default": false
          }
        }
      }
    },
    "steps": {
      "type": ["array", "null"],
      "description": "The sequence of commands to run (for each repository branch matched in the ` + "`" + `on` + "`" + ` property) to produce the workspace changes that will be included in the batch change.",
      "items": {
        "title": "Step",
        "type": "object",
        "description": "A command to run (as part of a sequence) in a repository branch to produce the required changes.",
        "additionalProperties": false,
        "required": ["run", "container"],
        "properties": {
          "run": {
            "type": "string",
            "description": "The shell command to run in the container. It can also be a multi-line shell script. The working directory is the root directory of the repository checkout."
          },
          "container": {
            "type": "string",
            "description": "The Docker image used to launch the Docker container in which the shell command is run.",
            "examples": ["alpine:3"]
          },
          "outputs": {
            "type": ["object", "null"],
            "description": "Output variables of this step that can be referenced in the changesetTemplate or other steps via outputs.<name-of-output>",
            "additionalProperties": {
              "title": "OutputVariable",
              "type": "object",
              "required": ["value"],
              "properties": {
                "value": {
                  "type": "string",
                  "description": "The value of the output, which can be a template string.",
                  "examples": ["hello world", "${{ step.stdout }}", "${{ repository.name }}"]
                },
                "format": {
                  "type": "string",
                  "description": "The expected format of the output. If set, the output is being parsed in that format before being stored in the var. If not set, 'text' is assumed to the format.",
                  "enum": ["json", "yaml", "text"]
                }
              }
            }
          },
          "env": {
            "description": "Environment variables to set in the step environment.",
            "oneOf": [
              {
                "type": "null"
              },
              {
                "type": "object",
                "description": "Environment variables to set in the step environment.",
                "additionalProperties": {
                  "type": "string"
                }
              },
              {
                "type": "array",
                "items": {
                  "oneOf": [
                    {
                      "type": "string",
                      "description": "An environment variable to set in the step environment: the value will be passed through from the environment src is running within."
                    },
                    {
                      "type": "object",
                      "description": "An environment variable to set in the step environment: the key is used as the environment variable name and the value as the value.",
                      "additionalProperties": {
                        "type": "string"
                      },
                      "minProperties": 1,
                      "maxProperties": 1
                    }
                  ]
                }
              }
            ]
          },
          "files": {
            "type": ["object", "null"],
            "description": "Files that should be mounted into or be created inside the Docker container.",
            "additionalProperties": {
              "type": "string"
            }
          },
          "if": {
            "oneOf": [
              {
                "type": "boolean"
              },
              {
                "type": "string"
              },
              {
                "type": "null"
              }
            ],
            "description": "A condition to check before executing steps. Supports templating. The value 'true' is interpreted as true.",
            "examples": [
              "true",
              "${{ matches repository.name \"github.com/my-org/my-repo*\" }}",
              "${{ outputs.goModFileExists }}",
              "${{ eq previous_step.stdout \"success\" }}"
            ]
          },
          "mount": {
            "description": "Files that are mounted to the Docker container.",
            "type": ["array", "null"],
            "items": {
              "type": "object",
              "additionalProperties": false,
              "required": ["path", "mountpoint"],
              "properties": {
                "path": {
                  "type": "string",
                  "description": "The path on the local machine to mount. The path must be in the same directory or a subdirectory of the batch spec.",
                  "examples": ["local/path/to/file.text", "local/path/to/directory"]
                },
                "mountpoint": {
                  "type": "string",
                  "description": "The path in the container to mount the path on the local machine to.",
                  "examples": ["path/to/file.txt", "path/to/directory"]
                }
              }
            }
          }
        }
      }
    },
    "transformChanges": {
      "type": ["object", "null"],
      "description": "Optional transformations to apply to the changes produced in each repository.",
      "additionalProperties": false,
      "properties": {
        "group": {
          "type": ["array", "null"],
          "description": "A list of groups of changes in a repository that each create a separate, additional changeset for this repository, with all ungrouped changes being in the default changeset.",
          "items": {
            "title": "TransformChangesGroup",
            "type": "object",
            "additionalProperties": false,
            "required": ["directory", "branch"],
            "properties": {
              "directory": {
                "type": "string",
                "description": "The directory path (relative to the repository root) of the changes to include in this group.",
                "minLength": 1
              },
              "branch": {
                "type": "string",
                "description": "The branch on the repository to propose changes to. If unset, the repository's default branch is used.",
                "minLength": 1
              },
              "repository": {
                "type": "string",
                "description": "Only apply this transformation in the repository with this name (as it is known to Sourcegraph).",
                "examples": ["github.com/foo/bar"]
              }
            }
          }
        }
      }
    },
    "importChangesets": {
      "type": ["array", "null"],
      "description": "Import existing changesets on code hosts.",
      "items": {
        "type": "object",
        "additionalProperties": false,
        "required": ["repository", "externalIDs"],
        "properties": {
          "repository": {
            "type": "string",
            "description": "The repository name as configured on your Sourcegraph instance."
          },
          "externalIDs": {
            "type": ["array", "null"],
            "description": "The changesets to import from the code host. For GitHub this is the PR number, for GitLab this is the MR number, for Bitbucket Server this is the PR number.",
            "uniqueItems": true,
            "items": {
              "oneOf": [
                {
                  "type": "string"
                },
                {
                  "type": "integer"
                }
              ]
            },
            "examples": [120, "120"]
          }
        }
      }
    },
    "changesetTemplate": {
      "type": "object",
      "description": "A template describing how to create (and update) changesets with the file changes produced by the command steps.",
      "additionalProperties": false,
      "required": ["title", "branch", "commit"],
      "properties": {
        "title": {
          "type": "string",
          "description": "The title of the changeset."
        },
        "body": {
          "type": "string",
          "description": "The body (description) of the changeset."
        },
        "branch": {
          "type": "string",
          "description": "The name of the Git branch to create or update on each repository with the changes."
        },
        "commit": {
          "title": "ExpandedGitCommitDescription",
          "type": "object",
          "description": "The Git commit to create with the changes.",
          "additionalProperties": false,
          "required": ["message"],
          "properties": {
            "message": {
              "type": "string",
              "description": "The Git commit message."
            },
            "author": {
              "title": "GitCommitAuthor",
              "type": "object",
              "description": "The author of the Git commit.",
              "additionalProperties": false,
              "required": ["name", "email"],
              "properties": {
                "name": {
                  "type": "string",
                  "description": "The Git commit author name."
                },
                "email": {
                  "type": "string",
                  "format": "email",
                  "description": "The Git commit author email."
                }
              }
            }
          }
        },
        "published": {
          "description": "Whether to publish the changeset. An unpublished changeset can be previewed on Sourcegraph by any person who can view the batch change, but its commit, branch, and pull request aren't created on the code host. A published changeset results in a commit, branch, and pull request being created on the code host. If omitted, the publication state is controlled from the Batch Changes UI.",
          "oneOf": [
            {
              "type": "null"
            },
            {
              "oneOf": [
                {
                  "type": "boolean"
                },
                {
                  "type": "string",
                  "pattern": "^draft$"
                }
              ],
              "description": "A single flag to control the publishing state for the entire batch change."
            },
            {
              "type": "array",
              "description": "A list of glob patterns to match repository names. In the event multiple patterns match, the last matching pattern in the list will be used.",
              "items": {
                "type": "object",
                "description": "An object with one field: the key is the glob pattern to match against repository names; the value will be used as the published flag for matching repositories.",
                "additionalProperties": {
                  "oneOf": [
                    {
                      "type": "boolean"
                    },
                    {
                      "type": "string",
                      "pattern": "^draft$"
                    }
                  ]
                },
                "minProperties": 1,
                "maxProperties": 1
              }
            }
          ]
        }
      }
    }
  }
}
`
