// Copyright 2010-2021, Google Inc.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//     * Neither the name of Google Inc. nor the names of its
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#ifndef MOZC_STORAGE_TINY_STORAGE_H_
#define MOZC_STORAGE_TINY_STORAGE_H_

#include "base/port.h"
#include "storage/storage_interface.h"

namespace mozc {
namespace storage {

// Very simple and tiny key/value storage.
// Use it just for saving small data which
// are not updated frequently, like timestamp, auth_token, etc.
// We will replace it with faster and more robust implementation.
class TinyStorage {
 public:
  TinyStorage() = delete;
  TinyStorage(const TinyStorage &) = delete;
  TinyStorage &operator=(const TinyStorage &) = delete;
  // Returns an implementation of StorageInterface.
  // Caller must take ownership of the returned object.
  // Returns NULL if fails.
  static StorageInterface *New();
  static StorageInterface *Create(const char *filename);
};

}  // namespace storage
}  // namespace mozc

#endif  // MOZC_STORAGE_TINY_STORAGE_H_
