/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog.mavendeptree;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.jfrog.mavendeptree.dependenciesresults.MavenDepTreeResults;
import com.jfrog.mavendeptree.dependenciesresults.MavenDependencyNode;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;

public class Utils {
    private static final ObjectMapper mapper = Utils.createMapper();

    public static ObjectMapper createMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    }

    public static MavenDepTreeResults createDependencyTree(DependencyGraphBuilder dependencyGraphBuilder, MavenSession session, MavenProject project) throws DependencyGraphBuilderException {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(session.getProjectBuildingRequest());
        buildingRequest.setProject(project);
        DependencyNode root = dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)buildingRequest, null);
        HashMap<String, MavenDependencyNode> nodes = new HashMap<String, MavenDependencyNode>();
        Utils.populateDependencyMap(root, nodes);
        return new MavenDepTreeResults(Utils.getGavString(root.getArtifact()), nodes);
    }

    static void populateDependencyMap(DependencyNode node, Map<String, MavenDependencyNode> nodes) {
        Artifact artifact = node.getArtifact();
        MavenDependencyNode mavenDependencyNode = nodes.get(Utils.getGavString(artifact));
        if (mavenDependencyNode == null) {
            mavenDependencyNode = new MavenDependencyNode(artifact.getScope(), artifact.getType(), artifact.getClassifier());
            nodes.put(Utils.getGavString(artifact), mavenDependencyNode);
        } else {
            mavenDependencyNode.addConfiguration(artifact.getScope());
            mavenDependencyNode.addType(artifact.getType());
        }
        List children = node.getChildren();
        if (children != null) {
            for (DependencyNode child : children) {
                mavenDependencyNode.addChild(Utils.getGavString(child.getArtifact()));
                Utils.populateDependencyMap(child, nodes);
            }
        }
    }

    static File writeResultsToFile(MavenProject project, MavenDepTreeResults results) throws IOException {
        File targetDir = Paths.get(project.getModel().getBuild().getDirectory(), "maven-dep-tree").toFile();
        FileUtils.forceMkdir((File)targetDir);
        File resultsPath = targetDir.toPath().resolve(Base64.getEncoder().encodeToString(project.getName().getBytes(StandardCharsets.UTF_8))).toFile();
        mapper.writeValue(resultsPath, (Object)results);
        return resultsPath;
    }

    public static String getGavString(Artifact artifact) {
        if (artifact == null) {
            return "";
        }
        if (artifact.hasClassifier()) {
            return String.join((CharSequence)":", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion() + "-" + artifact.getClassifier());
        }
        return String.join((CharSequence)":", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
    }
}

