package cli

import (
	"fmt"
	"github.com/jfrog/jfrog-cli-core/v2/common/commands"
	"os"
)

type execCommandFunc func(command commands.Command) error

func exec(command commands.Command) error {
	return commands.Exec(command)
}

var subjectTypes = []string{
	subjectRepoPath,
	releaseBundle,
	buildName,
	packageName,
}

func getEnvVariable(envVarName string) (string, error) {
	if key, exists := os.LookupEnv(envVarName); exists {
		return key, nil
	}
	return "", fmt.Errorf("'%s'  field wasn't provided.", envVarName)
}
