/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* "%code top" blocks.  */
#line 172 "parsers/smartpl_parser.y"

#ifndef _GNU_SOURCE
#define _GNU_SOURCE // For asprintf
#endif
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <stdarg.h> // For vsnprintf
#include <string.h>
#include <time.h>
#include <assert.h>

#define INVERT_MASK 0x80000000
#define RECURSION_MAX 64
#line 189 "parsers/smartpl_parser.y"

#ifndef DEBUG_PARSER_MOCK
#include "db.h"
#include "misc.h"
#else
#include "owntonefunctions.h"
#endif

#line 92 "parsers/smartpl_parser.c"
/* Substitute the type names.  */
#define YYSTYPE         SMARTPL_STYPE
/* Substitute the variable and function names.  */
#define yyparse         smartpl_parse
#define yylex           smartpl_lex
#define yyerror         smartpl_error
#define yydebug         smartpl_debug
#define yynerrs         smartpl_nerrs


# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Use api.header.include to #include this header
   instead of duplicating it here.  */
#ifndef YY_SMARTPL_PARSERS_SMARTPL_PARSER_H_INCLUDED
# define YY_SMARTPL_PARSERS_SMARTPL_PARSER_H_INCLUDED
/* Debug traces.  */
#ifndef SMARTPL_DEBUG
# if defined YYDEBUG
#if YYDEBUG
#   define SMARTPL_DEBUG 1
#  else
#   define SMARTPL_DEBUG 0
#  endif
# else /* ! defined YYDEBUG */
#  define SMARTPL_DEBUG 1
# endif /* ! defined YYDEBUG */
#endif  /* ! defined SMARTPL_DEBUG */
#if SMARTPL_DEBUG
extern int smartpl_debug;
#endif
/* "%code requires" blocks.  */
#line 202 "parsers/smartpl_parser.y"

struct result_part {
  char str[8192];
  int offset;
};

struct smartpl_result {
  struct result_part where_part;
  struct result_part order_part;
  struct result_part having_part;
  char title[128];
  const char *where; // Points to where_part.str
  const char *order; // Points to order_part.str
  const char *having; // Points to having_part.str
  int limit;
  int err;
  char errmsg[128];

  int recursion_level;
};

#line 166 "parsers/smartpl_parser.c"

/* Token kinds.  */
#ifndef SMARTPL_TOKENTYPE
# define SMARTPL_TOKENTYPE
  enum smartpl_tokentype
  {
    SMARTPL_EMPTY = -2,
    SMARTPL_EOF = 0,               /* "end of file"  */
    SMARTPL_error = 256,           /* error  */
    SMARTPL_UNDEF = 257,           /* "invalid token"  */
    SMARTPL_T_STRING = 258,        /* SMARTPL_T_STRING  */
    SMARTPL_T_NUM = 259,           /* SMARTPL_T_NUM  */
    SMARTPL_T_STRTAG = 260,        /* SMARTPL_T_STRTAG  */
    SMARTPL_T_INTTAG = 261,        /* SMARTPL_T_INTTAG  */
    SMARTPL_T_DATETAG = 262,       /* SMARTPL_T_DATETAG  */
    SMARTPL_T_GROUPTAG = 263,      /* SMARTPL_T_GROUPTAG  */
    SMARTPL_T_ENUMTAG = 264,       /* SMARTPL_T_ENUMTAG  */
    SMARTPL_T_ENUMTAG_DATAKIND = 265, /* SMARTPL_T_ENUMTAG_DATAKIND  */
    SMARTPL_T_ENUMTAG_MEDIAKIND = 266, /* SMARTPL_T_ENUMTAG_MEDIAKIND  */
    SMARTPL_T_ENUMTAG_SCANKIND = 267, /* SMARTPL_T_ENUMTAG_SCANKIND  */
    SMARTPL_T_FILE = 268,          /* SMARTPL_T_FILE  */
    SMARTPL_T_URL = 269,           /* SMARTPL_T_URL  */
    SMARTPL_T_SPOTIFY = 270,       /* SMARTPL_T_SPOTIFY  */
    SMARTPL_T_PIPE = 271,          /* SMARTPL_T_PIPE  */
    SMARTPL_T_RSS = 272,           /* SMARTPL_T_RSS  */
    SMARTPL_T_MUSIC = 273,         /* SMARTPL_T_MUSIC  */
    SMARTPL_T_MOVIE = 274,         /* SMARTPL_T_MOVIE  */
    SMARTPL_T_PODCAST = 275,       /* SMARTPL_T_PODCAST  */
    SMARTPL_T_AUDIOBOOK = 276,     /* SMARTPL_T_AUDIOBOOK  */
    SMARTPL_T_TVSHOW = 277,        /* SMARTPL_T_TVSHOW  */
    SMARTPL_T_DATEEXPR = 278,      /* SMARTPL_T_DATEEXPR  */
    SMARTPL_T_HAVING = 279,        /* SMARTPL_T_HAVING  */
    SMARTPL_T_ORDERBY = 280,       /* SMARTPL_T_ORDERBY  */
    SMARTPL_T_ORDER_ASC = 281,     /* SMARTPL_T_ORDER_ASC  */
    SMARTPL_T_ORDER_DESC = 282,    /* SMARTPL_T_ORDER_DESC  */
    SMARTPL_T_LIMIT = 283,         /* SMARTPL_T_LIMIT  */
    SMARTPL_T_RANDOM = 284,        /* SMARTPL_T_RANDOM  */
    SMARTPL_T_PARENS = 285,        /* SMARTPL_T_PARENS  */
    SMARTPL_T_OR = 286,            /* SMARTPL_T_OR  */
    SMARTPL_T_AND = 287,           /* SMARTPL_T_AND  */
    SMARTPL_T_NOT = 288,           /* SMARTPL_T_NOT  */
    SMARTPL_T_EMPTY = 289,         /* SMARTPL_T_EMPTY  */
    SMARTPL_T_NULL = 290,          /* SMARTPL_T_NULL  */
    SMARTPL_T_IS_OPERATOR = 291,   /* SMARTPL_T_IS_OPERATOR  */
    SMARTPL_T_DAYS = 292,          /* SMARTPL_T_DAYS  */
    SMARTPL_T_WEEKS = 293,         /* SMARTPL_T_WEEKS  */
    SMARTPL_T_MONTHS = 294,        /* SMARTPL_T_MONTHS  */
    SMARTPL_T_YEARS = 295,         /* SMARTPL_T_YEARS  */
    SMARTPL_T_INTERVAL = 296,      /* SMARTPL_T_INTERVAL  */
    SMARTPL_T_DATE = 297,          /* SMARTPL_T_DATE  */
    SMARTPL_T_DATE_TODAY = 298,    /* SMARTPL_T_DATE_TODAY  */
    SMARTPL_T_DATE_YESTERDAY = 299, /* SMARTPL_T_DATE_YESTERDAY  */
    SMARTPL_T_DATE_THISWEEK = 300, /* SMARTPL_T_DATE_THISWEEK  */
    SMARTPL_T_DATE_LASTWEEK = 301, /* SMARTPL_T_DATE_LASTWEEK  */
    SMARTPL_T_DATE_LASTMONTH = 302, /* SMARTPL_T_DATE_LASTMONTH  */
    SMARTPL_T_DATE_LASTYEAR = 303, /* SMARTPL_T_DATE_LASTYEAR  */
    SMARTPL_T_IS = 304,            /* SMARTPL_T_IS  */
    SMARTPL_T_INCLUDES = 305,      /* SMARTPL_T_INCLUDES  */
    SMARTPL_T_STARTSWITH = 306,    /* SMARTPL_T_STARTSWITH  */
    SMARTPL_T_ENDSWITH = 307,      /* SMARTPL_T_ENDSWITH  */
    SMARTPL_T_EQUAL = 308,         /* SMARTPL_T_EQUAL  */
    SMARTPL_T_LESS = 309,          /* SMARTPL_T_LESS  */
    SMARTPL_T_LESSEQUAL = 310,     /* SMARTPL_T_LESSEQUAL  */
    SMARTPL_T_GREATER = 311,       /* SMARTPL_T_GREATER  */
    SMARTPL_T_GREATEREQUAL = 312,  /* SMARTPL_T_GREATEREQUAL  */
    SMARTPL_T_BEFORE = 313,        /* SMARTPL_T_BEFORE  */
    SMARTPL_T_AFTER = 314,         /* SMARTPL_T_AFTER  */
    SMARTPL_T_AGO = 315            /* SMARTPL_T_AGO  */
  };
  typedef enum smartpl_tokentype smartpl_token_kind_t;
#endif

/* Value type.  */
#if ! defined SMARTPL_STYPE && ! defined SMARTPL_STYPE_IS_DECLARED
union SMARTPL_STYPE
{
#line 485 "parsers/smartpl_parser.y"

  unsigned int ival;
  char *str;
  struct ast *ast;

#line 249 "parsers/smartpl_parser.c"

};
typedef union SMARTPL_STYPE SMARTPL_STYPE;
# define SMARTPL_STYPE_IS_TRIVIAL 1
# define SMARTPL_STYPE_IS_DECLARED 1
#endif




int smartpl_parse (struct smartpl_result *result, void *scanner);

/* "%code provides" blocks.  */
#line 42 "parsers/smartpl_parser.y"

/* Convenience functions for caller to use instead of interfacing with lexer and
   parser directly */
int smartpl_lex_cb(char *input, void (*cb)(int, const char *));
int smartpl_lex_parse(struct smartpl_result *result, const char *input);

#line 270 "parsers/smartpl_parser.c"

#endif /* !YY_SMARTPL_PARSERS_SMARTPL_PARSER_H_INCLUDED  */
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_SMARTPL_T_STRING = 3,           /* SMARTPL_T_STRING  */
  YYSYMBOL_SMARTPL_T_NUM = 4,              /* SMARTPL_T_NUM  */
  YYSYMBOL_SMARTPL_T_STRTAG = 5,           /* SMARTPL_T_STRTAG  */
  YYSYMBOL_SMARTPL_T_INTTAG = 6,           /* SMARTPL_T_INTTAG  */
  YYSYMBOL_SMARTPL_T_DATETAG = 7,          /* SMARTPL_T_DATETAG  */
  YYSYMBOL_SMARTPL_T_GROUPTAG = 8,         /* SMARTPL_T_GROUPTAG  */
  YYSYMBOL_SMARTPL_T_ENUMTAG = 9,          /* SMARTPL_T_ENUMTAG  */
  YYSYMBOL_SMARTPL_T_ENUMTAG_DATAKIND = 10, /* SMARTPL_T_ENUMTAG_DATAKIND  */
  YYSYMBOL_SMARTPL_T_ENUMTAG_MEDIAKIND = 11, /* SMARTPL_T_ENUMTAG_MEDIAKIND  */
  YYSYMBOL_SMARTPL_T_ENUMTAG_SCANKIND = 12, /* SMARTPL_T_ENUMTAG_SCANKIND  */
  YYSYMBOL_SMARTPL_T_FILE = 13,            /* SMARTPL_T_FILE  */
  YYSYMBOL_SMARTPL_T_URL = 14,             /* SMARTPL_T_URL  */
  YYSYMBOL_SMARTPL_T_SPOTIFY = 15,         /* SMARTPL_T_SPOTIFY  */
  YYSYMBOL_SMARTPL_T_PIPE = 16,            /* SMARTPL_T_PIPE  */
  YYSYMBOL_SMARTPL_T_RSS = 17,             /* SMARTPL_T_RSS  */
  YYSYMBOL_SMARTPL_T_MUSIC = 18,           /* SMARTPL_T_MUSIC  */
  YYSYMBOL_SMARTPL_T_MOVIE = 19,           /* SMARTPL_T_MOVIE  */
  YYSYMBOL_SMARTPL_T_PODCAST = 20,         /* SMARTPL_T_PODCAST  */
  YYSYMBOL_SMARTPL_T_AUDIOBOOK = 21,       /* SMARTPL_T_AUDIOBOOK  */
  YYSYMBOL_SMARTPL_T_TVSHOW = 22,          /* SMARTPL_T_TVSHOW  */
  YYSYMBOL_SMARTPL_T_DATEEXPR = 23,        /* SMARTPL_T_DATEEXPR  */
  YYSYMBOL_SMARTPL_T_HAVING = 24,          /* SMARTPL_T_HAVING  */
  YYSYMBOL_SMARTPL_T_ORDERBY = 25,         /* SMARTPL_T_ORDERBY  */
  YYSYMBOL_SMARTPL_T_ORDER_ASC = 26,       /* SMARTPL_T_ORDER_ASC  */
  YYSYMBOL_SMARTPL_T_ORDER_DESC = 27,      /* SMARTPL_T_ORDER_DESC  */
  YYSYMBOL_SMARTPL_T_LIMIT = 28,           /* SMARTPL_T_LIMIT  */
  YYSYMBOL_SMARTPL_T_RANDOM = 29,          /* SMARTPL_T_RANDOM  */
  YYSYMBOL_SMARTPL_T_PARENS = 30,          /* SMARTPL_T_PARENS  */
  YYSYMBOL_SMARTPL_T_OR = 31,              /* SMARTPL_T_OR  */
  YYSYMBOL_SMARTPL_T_AND = 32,             /* SMARTPL_T_AND  */
  YYSYMBOL_SMARTPL_T_NOT = 33,             /* SMARTPL_T_NOT  */
  YYSYMBOL_SMARTPL_T_EMPTY = 34,           /* SMARTPL_T_EMPTY  */
  YYSYMBOL_SMARTPL_T_NULL = 35,            /* SMARTPL_T_NULL  */
  YYSYMBOL_SMARTPL_T_IS_OPERATOR = 36,     /* SMARTPL_T_IS_OPERATOR  */
  YYSYMBOL_SMARTPL_T_DAYS = 37,            /* SMARTPL_T_DAYS  */
  YYSYMBOL_SMARTPL_T_WEEKS = 38,           /* SMARTPL_T_WEEKS  */
  YYSYMBOL_SMARTPL_T_MONTHS = 39,          /* SMARTPL_T_MONTHS  */
  YYSYMBOL_SMARTPL_T_YEARS = 40,           /* SMARTPL_T_YEARS  */
  YYSYMBOL_SMARTPL_T_INTERVAL = 41,        /* SMARTPL_T_INTERVAL  */
  YYSYMBOL_SMARTPL_T_DATE = 42,            /* SMARTPL_T_DATE  */
  YYSYMBOL_SMARTPL_T_DATE_TODAY = 43,      /* SMARTPL_T_DATE_TODAY  */
  YYSYMBOL_SMARTPL_T_DATE_YESTERDAY = 44,  /* SMARTPL_T_DATE_YESTERDAY  */
  YYSYMBOL_SMARTPL_T_DATE_THISWEEK = 45,   /* SMARTPL_T_DATE_THISWEEK  */
  YYSYMBOL_SMARTPL_T_DATE_LASTWEEK = 46,   /* SMARTPL_T_DATE_LASTWEEK  */
  YYSYMBOL_SMARTPL_T_DATE_LASTMONTH = 47,  /* SMARTPL_T_DATE_LASTMONTH  */
  YYSYMBOL_SMARTPL_T_DATE_LASTYEAR = 48,   /* SMARTPL_T_DATE_LASTYEAR  */
  YYSYMBOL_SMARTPL_T_IS = 49,              /* SMARTPL_T_IS  */
  YYSYMBOL_SMARTPL_T_INCLUDES = 50,        /* SMARTPL_T_INCLUDES  */
  YYSYMBOL_SMARTPL_T_STARTSWITH = 51,      /* SMARTPL_T_STARTSWITH  */
  YYSYMBOL_SMARTPL_T_ENDSWITH = 52,        /* SMARTPL_T_ENDSWITH  */
  YYSYMBOL_SMARTPL_T_EQUAL = 53,           /* SMARTPL_T_EQUAL  */
  YYSYMBOL_SMARTPL_T_LESS = 54,            /* SMARTPL_T_LESS  */
  YYSYMBOL_SMARTPL_T_LESSEQUAL = 55,       /* SMARTPL_T_LESSEQUAL  */
  YYSYMBOL_SMARTPL_T_GREATER = 56,         /* SMARTPL_T_GREATER  */
  YYSYMBOL_SMARTPL_T_GREATEREQUAL = 57,    /* SMARTPL_T_GREATEREQUAL  */
  YYSYMBOL_SMARTPL_T_BEFORE = 58,          /* SMARTPL_T_BEFORE  */
  YYSYMBOL_SMARTPL_T_AFTER = 59,           /* SMARTPL_T_AFTER  */
  YYSYMBOL_SMARTPL_T_AGO = 60,             /* SMARTPL_T_AGO  */
  YYSYMBOL_61_ = 61,                       /* '{'  */
  YYSYMBOL_62_ = 62,                       /* '}'  */
  YYSYMBOL_63_ = 63,                       /* '('  */
  YYSYMBOL_64_ = 64,                       /* ')'  */
  YYSYMBOL_YYACCEPT = 65,                  /* $accept  */
  YYSYMBOL_playlist = 66,                  /* playlist  */
  YYSYMBOL_criteria = 67,                  /* criteria  */
  YYSYMBOL_predicate = 68,                 /* predicate  */
  YYSYMBOL_enumexpr = 69,                  /* enumexpr  */
  YYSYMBOL_dateexpr = 70,                  /* dateexpr  */
  YYSYMBOL_daterelative = 71,              /* daterelative  */
  YYSYMBOL_interval = 72,                  /* interval  */
  YYSYMBOL_time = 73,                      /* time  */
  YYSYMBOL_having = 74,                    /* having  */
  YYSYMBOL_order = 75,                     /* order  */
  YYSYMBOL_limit = 76,                     /* limit  */
  YYSYMBOL_strbool = 77,                   /* strbool  */
  YYSYMBOL_intbool = 78,                   /* intbool  */
  YYSYMBOL_datebool = 79                   /* datebool  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;



/* Unqualified %code blocks.  */
#line 51 "parsers/smartpl_parser.y"

  #include "smartpl_lexer.h"

  int smartpl_lex_cb(char *input, void (*cb)(int, const char *))
  {
    int ret;
    yyscan_t scanner;
    YY_BUFFER_STATE buf;
    YYSTYPE val;

    if ((ret = smartpl_lex_init(&scanner)) != 0)
      return ret;

    buf = smartpl__scan_string(input, scanner);

    while ((ret = smartpl_lex(&val, scanner)) > 0)
      cb(ret, smartpl_get_text(scanner));

    smartpl__delete_buffer(buf, scanner);
    smartpl_lex_destroy(scanner);
    return 0;
  }

  int smartpl_lex_parse(struct smartpl_result *result, const char *input)
  {
    YY_BUFFER_STATE buffer;
    yyscan_t scanner;
    int retval = -1;
    int ret;

    result->errmsg[0] = '\0'; // For safety

    ret = smartpl_lex_init(&scanner);
    if (ret != 0)
      goto error_init;

    buffer = smartpl__scan_string(input, scanner);
    if (!buffer)
      goto error_buffer;

    ret = smartpl_parse(result, scanner);
    if (ret != 0)
      goto error_parse;

    retval = 0;

   error_parse:
    smartpl__delete_buffer(buffer, scanner);
   error_buffer:
    smartpl_lex_destroy(scanner);
   error_init:
    return retval;
  }

  void smartpl_error(struct smartpl_result *result, yyscan_t scanner, const char *msg)
  {
    snprintf(result->errmsg, sizeof(result->errmsg), "%s", msg);
  }

#line 114 "parsers/smartpl_parser.y"

  struct ast
  {
    int type;
    struct ast *l;
    struct ast *r;
    void *data;
    int ival;
  };

  __attribute__((unused)) static struct ast * ast_new(int type, struct ast *l, struct ast *r)
  {
    struct ast *a = calloc(1, sizeof(struct ast));

    a->type = type;
    a->l = l;
    a->r = r;
    return a;
  }

  /* Note *data is expected to be freeable with regular free() */
  __attribute__((unused)) static struct ast * ast_data(int type, void *data)
  {
    struct ast *a = calloc(1, sizeof(struct ast));

    a->type = type;
    a->data = data;
    return a;
  }

  __attribute__((unused)) static struct ast * ast_int(int type, int ival)
  {
    struct ast *a = calloc(1, sizeof(struct ast));

    a->type = type;
    a->ival = ival;
    return a;
  }

  __attribute__((unused)) static void ast_free(struct ast *a)
  {
    if (!a)
      return;

    ast_free(a->l);
    ast_free(a->r);
    free(a->data);
    free(a);
  }
#line 224 "parsers/smartpl_parser.y"

enum sql_append_type {
  SQL_APPEND_OPERATOR,
  SQL_APPEND_OPERATOR_STR,
  SQL_APPEND_OPERATOR_LIKE,
  SQL_APPEND_FIELD,
  SQL_APPEND_STR,
  SQL_APPEND_INT,
  SQL_APPEND_NULL,
  SQL_APPEND_ORDER,
  SQL_APPEND_PARENS,
  SQL_APPEND_DATE_STRFTIME,
  SQL_APPEND_DATE_FIELD,
};

static void sql_from_ast(struct smartpl_result *, struct result_part *, struct ast *);

// Escapes any '%' or '_' that might be in the string
static void sql_like_escape(char **value, char *escape_char)
{
  char *s = *value;
  size_t len = strlen(s);
  char *new;

  *escape_char = 0;

  // Fast path, nothing to escape
  if (!strpbrk(s, "_%"))
    return;

  len = 2 * len; // Enough for every char to be escaped
  new = realloc(s, len);
  safe_snreplace(new, len, "%", "\\%");
  safe_snreplace(new, len, "_", "\\_");
  *escape_char = '\\';
  *value = new;
}

static void sql_str_escape(char **value)
{
  char *old = *value;
  *value = db_escape_string(old);
  free(old);
}

static void sql_append(struct smartpl_result *result, struct result_part *part, const char *fmt, ...)
{
  va_list ap;
  int remaining = sizeof(part->str) - part->offset;
  int ret;

  if (remaining <= 0)
    goto nospace;

  va_start(ap, fmt);
  ret = vsnprintf(part->str + part->offset, remaining, fmt, ap);
  va_end(ap);
  if (ret < 0 || ret >= remaining)
    goto nospace;

  part->offset += ret;
  return;

 nospace:
  snprintf(result->errmsg, sizeof(result->errmsg), "Parser output buffer too small (%zu bytes)", sizeof(part->str));
  result->err = -2;
}

static void sql_append_recursive(struct smartpl_result *result, struct result_part *part, struct ast *a, const char *op, const char *op_not, bool is_not, enum sql_append_type append_type)
{
  char escape_char;

  if (result->recursion_level > RECURSION_MAX)
  {
    snprintf(result->errmsg, sizeof(result->errmsg), "Recursion maximum exceeded");
    result->err = -2;
    return;
  }

  result->recursion_level++;

  switch (append_type)
  {
    case SQL_APPEND_OPERATOR:
      sql_from_ast(result, part, a->l);
      sql_append(result, part, " %s ", is_not ? op_not : op);
      sql_from_ast(result, part, a->r);
      break;
    case SQL_APPEND_OPERATOR_STR:
      sql_from_ast(result, part, a->l);
      sql_append(result, part, " %s '", is_not ? op_not : op);
      sql_from_ast(result, part, a->r);
      sql_append(result, part, "'");
      break;
    case SQL_APPEND_OPERATOR_LIKE:
      sql_from_ast(result, part, a->l);
      sql_append(result, part, " %s '%s", is_not ? op_not : op, a->type == SMARTPL_T_STARTSWITH ? "" : "%");
      sql_like_escape((char **)(&a->r->data), &escape_char);
      sql_from_ast(result, part, a->r);
      sql_append(result, part, "%s'", a->type == SMARTPL_T_ENDSWITH ? "" : "%");
      if (escape_char)
        sql_append(result, part, " ESCAPE '%c'", escape_char);
      break;
    case SQL_APPEND_FIELD:
      assert(a->l == NULL);
      assert(a->r == NULL);
      sql_append(result, part, "%s", (char *)a->data);
      break;
    case SQL_APPEND_STR:
      assert(a->l == NULL);
      assert(a->r == NULL);
      sql_str_escape((char **)&a->data);
      sql_append(result, part, "%s", (char *)a->data);
      break;
    case SQL_APPEND_INT:
      assert(a->l == NULL);
      assert(a->r == NULL);
      sql_append(result, part, "%d", a->ival);
      break;
    case SQL_APPEND_NULL:
      assert(a->l == NULL);
      assert(a->r == NULL);
      sql_append(result, part, "NULL", NULL);
      break;
    case SQL_APPEND_ORDER:
      assert(a->l == NULL);
      assert(a->r == NULL);
      if (a->data)
        sql_append(result, part, "%s ", (char *)a->data);
      sql_append(result, part, "%s", is_not ? op_not : op);
      break;
    case SQL_APPEND_PARENS:
      assert(a->r == NULL);
      if (is_not ? op_not : op)
        sql_append(result, part, "%s ", is_not ? op_not : op);
      sql_append(result, part, "(");
      sql_from_ast(result, part, a->l);
      sql_append(result, part, ")");
      break;
    case SQL_APPEND_DATE_STRFTIME:
      sql_append(result, part, "strftime('%%s', datetime(");
      sql_from_ast(result, part, a->l); // Appends the anchor date
      sql_from_ast(result, part, a->r); // Appends interval if there is one
      sql_append(result, part, "'utc'))");
      break;
    case SQL_APPEND_DATE_FIELD:
      assert(a->l == NULL);
      assert(a->r == NULL);
      sql_append(result, part, "'");
      if (is_not ? op_not : op)
        sql_append(result, part, "%s", is_not ? op_not : op);
      if (a->data)
        sql_append(result, part, "%s", (char *)a->data);
      sql_append(result, part, "', ");
      break;
  }

  result->recursion_level--;
}

/* Creates the parsing result from the AST. Errors are set via result->err. */
static void sql_from_ast(struct smartpl_result *result, struct result_part *part, struct ast *a) {
  if (!a || result->err < 0)
    return;

  bool is_not = (a->type & INVERT_MASK);
  a->type &= ~INVERT_MASK;

  switch (a->type)
  {
    case SMARTPL_T_EQUAL:
      sql_append_recursive(result, part, a, "=", "!=", is_not, SQL_APPEND_OPERATOR); break;
    case SMARTPL_T_LESS:
      sql_append_recursive(result, part, a, "<", ">=", is_not, SQL_APPEND_OPERATOR); break;
    case SMARTPL_T_LESSEQUAL:
      sql_append_recursive(result, part, a, "<=", ">", is_not, SQL_APPEND_OPERATOR); break;
    case SMARTPL_T_GREATER:
      sql_append_recursive(result, part, a, ">", ">=", is_not, SQL_APPEND_OPERATOR); break;
    case SMARTPL_T_GREATEREQUAL:
      sql_append_recursive(result, part, a, ">=", "<", is_not, SQL_APPEND_OPERATOR); break;
    case SMARTPL_T_IS:
      sql_append_recursive(result, part, a, "=", "!=", is_not, SQL_APPEND_OPERATOR_STR); break;
    case SMARTPL_T_IS_OPERATOR:
      sql_append_recursive(result, part, a, "IS", "IS NOT", is_not, SQL_APPEND_OPERATOR); break;
    case SMARTPL_T_INCLUDES:
    case SMARTPL_T_STARTSWITH:
    case SMARTPL_T_ENDSWITH:
      sql_append_recursive(result, part, a, "LIKE", "NOT LIKE", is_not, SQL_APPEND_OPERATOR_LIKE); break;
    case SMARTPL_T_BEFORE:
      sql_append_recursive(result, part, a, "<", ">=", is_not, SQL_APPEND_OPERATOR); break;
    case SMARTPL_T_AFTER:
      sql_append_recursive(result, part, a, ">", "<=", is_not, SQL_APPEND_OPERATOR); break;
    case SMARTPL_T_AND:
      sql_append_recursive(result, part, a, "AND", "AND NOT", is_not, SQL_APPEND_OPERATOR); break;
    case SMARTPL_T_OR:
      sql_append_recursive(result, part, a, "OR", "OR NOT", is_not, SQL_APPEND_OPERATOR); break;
    case SMARTPL_T_DATEEXPR:
      sql_append_recursive(result, part, a, NULL, NULL, 0, SQL_APPEND_DATE_STRFTIME); break;
    case SMARTPL_T_DATE:
      sql_append_recursive(result, part, a, NULL, NULL, 0, SQL_APPEND_DATE_FIELD); break;
    case SMARTPL_T_DATE_TODAY:
      sql_append_recursive(result, part, a, "now', 'start of day", NULL, 0, SQL_APPEND_DATE_FIELD); break;
    case SMARTPL_T_DATE_YESTERDAY:
      sql_append_recursive(result, part, a, "now', 'start of day', '-1 day", NULL, 0, SQL_APPEND_DATE_FIELD); break;
    case SMARTPL_T_DATE_THISWEEK:
      sql_append_recursive(result, part, a, "now', 'start of day', 'weekday 0', '-7 days", NULL, 0, SQL_APPEND_DATE_FIELD); break;
    case SMARTPL_T_DATE_LASTWEEK:
      sql_append_recursive(result, part, a, "now', 'start of day', 'weekday 0', '-13 days", NULL, 0, SQL_APPEND_DATE_FIELD); break;
    case SMARTPL_T_DATE_LASTMONTH:
      sql_append_recursive(result, part, a, "now', 'start of month', '-1 month", NULL, 0, SQL_APPEND_DATE_FIELD); break;
    case SMARTPL_T_DATE_LASTYEAR:
      sql_append_recursive(result, part, a, "now', 'start of year', '-1 year", NULL, 0, SQL_APPEND_DATE_FIELD); break;
    case SMARTPL_T_INTERVAL:
      sql_append_recursive(result, part, a, "-", "+", is_not, SQL_APPEND_DATE_FIELD); break;
    case SMARTPL_T_STRING:
    case SMARTPL_T_GROUPTAG:
      sql_append_recursive(result, part, a, NULL, NULL, 0, SQL_APPEND_STR); break;
    case SMARTPL_T_STRTAG:
    case SMARTPL_T_INTTAG:
    case SMARTPL_T_DATETAG:
    case SMARTPL_T_ENUMTAG:
      sql_append_recursive(result, part, a, NULL, NULL, 0, SQL_APPEND_FIELD); break;
    case SMARTPL_T_NUM:
      sql_append_recursive(result, part, a, NULL, NULL, 0, SQL_APPEND_INT); break;
    case SMARTPL_T_NULL:
      sql_append_recursive(result, part, a, NULL, NULL, 0, SQL_APPEND_NULL); break;
    case SMARTPL_T_ORDERBY:
      sql_append_recursive(result, part, a, "ASC", "DESC", is_not, SQL_APPEND_ORDER); break;
    case SMARTPL_T_RANDOM:
      sql_append_recursive(result, part, a, "random()", NULL, 0, SQL_APPEND_ORDER); break;
    case SMARTPL_T_PARENS:
      sql_append_recursive(result, part, a, NULL, "NOT", is_not, SQL_APPEND_PARENS); break;
    default:
      snprintf(result->errmsg, sizeof(result->errmsg), "Parser produced unrecognized AST type %d", a->type);
      result->err = -1;
  }
}

static int result_set(struct smartpl_result *result, char *title, struct ast *criteria, struct ast *having, struct ast *order, struct ast *limit)
{
  memset(result, 0, sizeof(struct smartpl_result));
  snprintf(result->title, sizeof(result->title), "%s", title); // just silently truncated if too long
  sql_from_ast(result, &result->where_part, criteria);
  sql_from_ast(result, &result->having_part, having);
  sql_from_ast(result, &result->order_part, order);

  result->where  = result->where_part.offset ? result->where_part.str : NULL;
  result->having = result->having_part.offset ? result->having_part.str : NULL;
  result->order  = result->order_part.offset ? result->order_part.str : NULL;
  result->limit  = limit ? limit->ival : 0;

  free(title);
  ast_free(criteria);
  ast_free(having);
  ast_free(order);
  ast_free(limit);

  return result->err;
}

#line 734 "parsers/smartpl_parser.c"

#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int8 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined SMARTPL_STYPE_IS_TRIVIAL && SMARTPL_STYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  4
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   106

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  65
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  15
/* YYNRULES -- Number of rules.  */
#define YYNRULES  70
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  107

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   315


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      63,    64,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    61,     2,    62,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60
};

#if SMARTPL_DEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   586,   586,   587,   588,   589,   590,   591,   592,   593,
     596,   597,   598,   599,   600,   603,   604,   605,   606,   607,
     612,   613,   614,   615,   617,   618,   619,   620,   621,   623,
     624,   625,   628,   629,   630,   631,   632,   635,   636,   637,
     638,   639,   640,   643,   644,   647,   648,   649,   650,   653,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   666,
     669,   670,   671,   672,   675,   676,   677,   678,   679,   682,
     683
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "SMARTPL_T_STRING",
  "SMARTPL_T_NUM", "SMARTPL_T_STRTAG", "SMARTPL_T_INTTAG",
  "SMARTPL_T_DATETAG", "SMARTPL_T_GROUPTAG", "SMARTPL_T_ENUMTAG",
  "SMARTPL_T_ENUMTAG_DATAKIND", "SMARTPL_T_ENUMTAG_MEDIAKIND",
  "SMARTPL_T_ENUMTAG_SCANKIND", "SMARTPL_T_FILE", "SMARTPL_T_URL",
  "SMARTPL_T_SPOTIFY", "SMARTPL_T_PIPE", "SMARTPL_T_RSS",
  "SMARTPL_T_MUSIC", "SMARTPL_T_MOVIE", "SMARTPL_T_PODCAST",
  "SMARTPL_T_AUDIOBOOK", "SMARTPL_T_TVSHOW", "SMARTPL_T_DATEEXPR",
  "SMARTPL_T_HAVING", "SMARTPL_T_ORDERBY", "SMARTPL_T_ORDER_ASC",
  "SMARTPL_T_ORDER_DESC", "SMARTPL_T_LIMIT", "SMARTPL_T_RANDOM",
  "SMARTPL_T_PARENS", "SMARTPL_T_OR", "SMARTPL_T_AND", "SMARTPL_T_NOT",
  "SMARTPL_T_EMPTY", "SMARTPL_T_NULL", "SMARTPL_T_IS_OPERATOR",
  "SMARTPL_T_DAYS", "SMARTPL_T_WEEKS", "SMARTPL_T_MONTHS",
  "SMARTPL_T_YEARS", "SMARTPL_T_INTERVAL", "SMARTPL_T_DATE",
  "SMARTPL_T_DATE_TODAY", "SMARTPL_T_DATE_YESTERDAY",
  "SMARTPL_T_DATE_THISWEEK", "SMARTPL_T_DATE_LASTWEEK",
  "SMARTPL_T_DATE_LASTMONTH", "SMARTPL_T_DATE_LASTYEAR", "SMARTPL_T_IS",
  "SMARTPL_T_INCLUDES", "SMARTPL_T_STARTSWITH", "SMARTPL_T_ENDSWITH",
  "SMARTPL_T_EQUAL", "SMARTPL_T_LESS", "SMARTPL_T_LESSEQUAL",
  "SMARTPL_T_GREATER", "SMARTPL_T_GREATEREQUAL", "SMARTPL_T_BEFORE",
  "SMARTPL_T_AFTER", "SMARTPL_T_AGO", "'{'", "'}'", "'('", "')'",
  "$accept", "playlist", "criteria", "predicate", "enumexpr", "dateexpr",
  "daterelative", "interval", "time", "having", "order", "limit",
  "strbool", "intbool", "datebool", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-49)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-1)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int8 yypact[] =
{
       1,   -48,    16,    -5,   -49,    36,    17,   -23,   -27,   -18,
      -9,    -5,    -5,   -14,   -49,   -49,    18,   -49,   -49,   -49,
      47,   -49,   -49,   -49,   -49,   -49,    53,   -49,   -49,    -1,
      76,    57,    67,   -49,    -2,    52,    27,    77,    -5,    -5,
     -49,   -13,    -7,    38,   -49,   -49,   -49,    56,   -49,   -49,
     -49,   -49,   -49,   -49,   -49,   -49,   -49,    21,    39,   -49,
     -49,   -49,   -49,   -49,   -49,   -49,   -49,   -49,   -49,   -49,
     -49,   -49,    17,   -49,   -49,   -49,   -49,   -49,   -49,   -49,
     -49,    29,   -49,   -49,    -3,    40,   -49,   -49,   -49,    41,
     -49,   -49,   -49,   -49,   -49,   -49,   -49,   -49,   -49,   -49,
      79,   -49,    42,   -49,   -49,   -49,   -49
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int8 yydefact[] =
{
       0,     0,     0,     0,     1,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    14,    19,    60,    61,    62,    63,
       0,    64,    65,    66,    67,    68,     0,    69,    70,     0,
       0,     0,     0,    13,     0,     0,     0,     0,     0,     0,
       9,     0,     0,     0,    18,    15,    16,     0,    32,    37,
      38,    39,    40,    41,    42,    17,    33,     0,     0,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    12,     0,    50,    51,    52,    53,    54,    55,    56,
      59,    11,    10,     5,     0,     0,    57,    58,     7,     0,
       8,    45,    46,    47,    48,    34,    35,    43,    44,    36,
       0,     3,     0,     4,     6,    49,     2
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int8 yypgoto[] =
{
     -49,   -49,    15,   -49,   -49,   -49,    44,   -49,   -49,   -49,
      64,   -33,   -49,    34,   -49
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int8 yydefgoto[] =
{
       0,     2,    13,    14,    15,    55,    56,    57,    58,    41,
      42,    43,    20,    26,    29
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int8 yytable[] =
{
       5,     6,     7,    47,     1,     8,     9,    10,    85,    89,
      35,    36,    36,     3,    37,    37,     4,    38,    39,    86,
      87,    37,    30,    86,    87,    37,    33,    34,    11,    38,
      39,    31,    73,    74,    75,    27,    28,    76,    77,    78,
      32,    48,    49,    50,    51,    52,    53,    54,    40,    83,
      45,   102,    44,    81,    82,    88,    79,    46,    12,   101,
      72,    39,    71,    95,    49,    50,    51,    52,    53,    54,
      21,    22,    23,    24,    25,    63,    64,    65,    66,    67,
      68,    80,    69,   105,    70,    16,    17,    18,    19,    59,
      60,    61,    62,    91,    92,    93,    94,    97,    98,    99,
      90,    96,   103,   104,   106,    84,   100
};

static const yytype_int8 yycheck[] =
{
       5,     6,     7,     4,     3,    10,    11,    12,    41,    42,
      24,    25,    25,    61,    28,    28,     0,    31,    32,    26,
      27,    28,    49,    26,    27,    28,    11,    12,    33,    31,
      32,    49,     5,     6,     7,    58,    59,    10,    11,    12,
      49,    42,    43,    44,    45,    46,    47,    48,    62,    62,
       3,    84,    34,    38,    39,    62,    29,     4,    63,    62,
       8,    32,    64,    42,    43,    44,    45,    46,    47,    48,
      53,    54,    55,    56,    57,    18,    19,    20,    21,    22,
      13,     4,    15,     4,    17,    49,    50,    51,    52,    13,
      14,    15,    16,    37,    38,    39,    40,    58,    59,    60,
      62,    57,    62,    62,    62,    41,    72
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,     3,    66,    61,     0,     5,     6,     7,    10,    11,
      12,    33,    63,    67,    68,    69,    49,    50,    51,    52,
      77,    53,    54,    55,    56,    57,    78,    58,    59,    79,
      49,    49,    49,    67,    67,    24,    25,    28,    31,    32,
      62,    74,    75,    76,    34,     3,     4,     4,    42,    43,
      44,    45,    46,    47,    48,    70,    71,    72,    73,    13,
      14,    15,    16,    18,    19,    20,    21,    22,    13,    15,
      17,    64,     8,     5,     6,     7,    10,    11,    12,    29,
       4,    67,    67,    62,    75,    76,    26,    27,    62,    76,
      62,    37,    38,    39,    40,    42,    71,    58,    59,    60,
      78,    62,    76,    62,    62,     4,    62
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr1[] =
{
       0,    65,    66,    66,    66,    66,    66,    66,    66,    66,
      67,    67,    67,    67,    67,    68,    68,    68,    68,    68,
      69,    69,    69,    69,    69,    69,    69,    69,    69,    69,
      69,    69,    70,    70,    70,    70,    70,    71,    71,    71,
      71,    71,    71,    72,    72,    73,    73,    73,    73,    74,
      75,    75,    75,    75,    75,    75,    75,    75,    75,    76,
      77,    77,    77,    77,    78,    78,    78,    78,    78,    79,
      79
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     7,     6,     6,     5,     6,     5,     5,     4,
       3,     3,     3,     2,     1,     3,     3,     3,     3,     1,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     1,     1,     2,     2,     2,     1,     1,     1,
       1,     1,     1,     2,     2,     2,     2,     2,     2,     4,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = SMARTPL_EMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == SMARTPL_EMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (result, scanner, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use SMARTPL_error or SMARTPL_UNDEF. */
#define YYERRCODE SMARTPL_UNDEF


/* Enable debugging if requested.  */
#if SMARTPL_DEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, result, scanner); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, struct smartpl_result *result, void *scanner)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (result);
  YY_USE (scanner);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, struct smartpl_result *result, void *scanner)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep, result, scanner);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule, struct smartpl_result *result, void *scanner)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)], result, scanner);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule, result, scanner); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !SMARTPL_DEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !SMARTPL_DEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yysymbol_kind_t yytoken;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  int yyn = yypact[+*yyctx->yyssp];
  if (!yypact_value_is_default (yyn))
    {
      /* Start YYX at -YYN if negative to avoid negative indexes in
         YYCHECK.  In other words, skip the first -YYN actions for
         this state because they are default actions.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;
      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yyx;
      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
        if (yycheck[yyx + yyn] == yyx && yyx != YYSYMBOL_YYerror
            && !yytable_value_is_error (yytable[yyx + yyn]))
          {
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = YY_CAST (yysymbol_kind_t, yyx);
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




#ifndef yystrlen
# if defined __GLIBC__ && defined _STRING_H
#  define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
# else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
# endif
#endif

#ifndef yystpcpy
# if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#  define yystpcpy stpcpy
# else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
# endif
#endif

#ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;
      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
#endif


static int
yy_syntax_error_arguments (const yypcontext_t *yyctx,
                           yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yyctx->yytoken != YYSYMBOL_YYEMPTY)
    {
      int yyn;
      if (yyarg)
        yyarg[yycount] = yyctx->yytoken;
      ++yycount;
      yyn = yypcontext_expected_tokens (yyctx,
                                        yyarg ? yyarg + 1 : yyarg, yyargn - 1);
      if (yyn == YYENOMEM)
        return YYENOMEM;
      else
        yycount += yyn;
    }
  return yycount;
}

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return -1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return YYENOMEM if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                const yypcontext_t *yyctx)
{
  enum { YYARGS_MAX = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  yysymbol_kind_t yyarg[YYARGS_MAX];
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* Actual size of YYARG. */
  int yycount = yy_syntax_error_arguments (yyctx, yyarg, YYARGS_MAX);
  if (yycount == YYENOMEM)
    return YYENOMEM;

  switch (yycount)
    {
#define YYCASE_(N, S)                       \
      case N:                               \
        yyformat = S;                       \
        break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
    }

  /* Compute error message size.  Don't count the "%s"s, but reserve
     room for the terminator.  */
  yysize = yystrlen (yyformat) - 2 * yycount + 1;
  {
    int yyi;
    for (yyi = 0; yyi < yycount; ++yyi)
      {
        YYPTRDIFF_T yysize1
          = yysize + yytnamerr (YY_NULLPTR, yytname[yyarg[yyi]]);
        if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
          yysize = yysize1;
        else
          return YYENOMEM;
      }
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return -1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yytname[yyarg[yyi++]]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, struct smartpl_result *result, void *scanner)
{
  YY_USE (yyvaluep);
  YY_USE (result);
  YY_USE (scanner);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  switch (yykind)
    {
    case YYSYMBOL_SMARTPL_T_STRING: /* SMARTPL_T_STRING  */
#line 165 "parsers/smartpl_parser.y"
            { free(((*yyvaluep).str)); }
#line 1786 "parsers/smartpl_parser.c"
        break;

    case YYSYMBOL_SMARTPL_T_STRTAG: /* SMARTPL_T_STRTAG  */
#line 165 "parsers/smartpl_parser.y"
            { free(((*yyvaluep).str)); }
#line 1792 "parsers/smartpl_parser.c"
        break;

    case YYSYMBOL_SMARTPL_T_INTTAG: /* SMARTPL_T_INTTAG  */
#line 165 "parsers/smartpl_parser.y"
            { free(((*yyvaluep).str)); }
#line 1798 "parsers/smartpl_parser.c"
        break;

    case YYSYMBOL_SMARTPL_T_DATETAG: /* SMARTPL_T_DATETAG  */
#line 165 "parsers/smartpl_parser.y"
            { free(((*yyvaluep).str)); }
#line 1804 "parsers/smartpl_parser.c"
        break;

    case YYSYMBOL_SMARTPL_T_GROUPTAG: /* SMARTPL_T_GROUPTAG  */
#line 165 "parsers/smartpl_parser.y"
            { free(((*yyvaluep).str)); }
#line 1810 "parsers/smartpl_parser.c"
        break;

    case YYSYMBOL_SMARTPL_T_ENUMTAG_DATAKIND: /* SMARTPL_T_ENUMTAG_DATAKIND  */
#line 165 "parsers/smartpl_parser.y"
            { free(((*yyvaluep).str)); }
#line 1816 "parsers/smartpl_parser.c"
        break;

    case YYSYMBOL_SMARTPL_T_ENUMTAG_MEDIAKIND: /* SMARTPL_T_ENUMTAG_MEDIAKIND  */
#line 165 "parsers/smartpl_parser.y"
            { free(((*yyvaluep).str)); }
#line 1822 "parsers/smartpl_parser.c"
        break;

    case YYSYMBOL_SMARTPL_T_ENUMTAG_SCANKIND: /* SMARTPL_T_ENUMTAG_SCANKIND  */
#line 165 "parsers/smartpl_parser.y"
            { free(((*yyvaluep).str)); }
#line 1828 "parsers/smartpl_parser.c"
        break;

    case YYSYMBOL_SMARTPL_T_DATE: /* SMARTPL_T_DATE  */
#line 165 "parsers/smartpl_parser.y"
            { free(((*yyvaluep).str)); }
#line 1834 "parsers/smartpl_parser.c"
        break;

    case YYSYMBOL_criteria: /* criteria  */
#line 166 "parsers/smartpl_parser.y"
            { ast_free(((*yyvaluep).ast)); }
#line 1840 "parsers/smartpl_parser.c"
        break;

    case YYSYMBOL_predicate: /* predicate  */
#line 166 "parsers/smartpl_parser.y"
            { ast_free(((*yyvaluep).ast)); }
#line 1846 "parsers/smartpl_parser.c"
        break;

    case YYSYMBOL_enumexpr: /* enumexpr  */
#line 166 "parsers/smartpl_parser.y"
            { ast_free(((*yyvaluep).ast)); }
#line 1852 "parsers/smartpl_parser.c"
        break;

    case YYSYMBOL_dateexpr: /* dateexpr  */
#line 166 "parsers/smartpl_parser.y"
            { ast_free(((*yyvaluep).ast)); }
#line 1858 "parsers/smartpl_parser.c"
        break;

    case YYSYMBOL_interval: /* interval  */
#line 166 "parsers/smartpl_parser.y"
            { ast_free(((*yyvaluep).ast)); }
#line 1864 "parsers/smartpl_parser.c"
        break;

    case YYSYMBOL_time: /* time  */
#line 165 "parsers/smartpl_parser.y"
            { free(((*yyvaluep).str)); }
#line 1870 "parsers/smartpl_parser.c"
        break;

    case YYSYMBOL_having: /* having  */
#line 166 "parsers/smartpl_parser.y"
            { ast_free(((*yyvaluep).ast)); }
#line 1876 "parsers/smartpl_parser.c"
        break;

    case YYSYMBOL_order: /* order  */
#line 166 "parsers/smartpl_parser.y"
            { ast_free(((*yyvaluep).ast)); }
#line 1882 "parsers/smartpl_parser.c"
        break;

    case YYSYMBOL_limit: /* limit  */
#line 166 "parsers/smartpl_parser.y"
            { ast_free(((*yyvaluep).ast)); }
#line 1888 "parsers/smartpl_parser.c"
        break;

      default:
        break;
    }
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}






/*----------.
| yyparse.  |
`----------*/

int
yyparse (struct smartpl_result *result, void *scanner)
{
/* Lookahead token kind.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

    /* Number of syntax errors so far.  */
    int yynerrs = 0;

    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = SMARTPL_EMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == SMARTPL_EMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (&yylval, scanner);
    }

  if (yychar <= SMARTPL_EOF)
    {
      yychar = SMARTPL_EOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == SMARTPL_error)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = SMARTPL_UNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = SMARTPL_EMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* playlist: SMARTPL_T_STRING '{' criteria having order limit '}'  */
#line 586 "parsers/smartpl_parser.y"
                                                            { if (result_set(result, (yyvsp[-6].str), (yyvsp[-4].ast), (yyvsp[-3].ast), (yyvsp[-2].ast), (yyvsp[-1].ast)) < 0) YYABORT; }
#line 2167 "parsers/smartpl_parser.c"
    break;

  case 3: /* playlist: SMARTPL_T_STRING '{' criteria having order '}'  */
#line 587 "parsers/smartpl_parser.y"
                                                            { if (result_set(result, (yyvsp[-5].str), (yyvsp[-3].ast), (yyvsp[-2].ast), (yyvsp[-1].ast), NULL) < 0) YYABORT; }
#line 2173 "parsers/smartpl_parser.c"
    break;

  case 4: /* playlist: SMARTPL_T_STRING '{' criteria having limit '}'  */
#line 588 "parsers/smartpl_parser.y"
                                                            { if (result_set(result, (yyvsp[-5].str), (yyvsp[-3].ast), (yyvsp[-2].ast), NULL, (yyvsp[-1].ast)) < 0) YYABORT; }
#line 2179 "parsers/smartpl_parser.c"
    break;

  case 5: /* playlist: SMARTPL_T_STRING '{' criteria having '}'  */
#line 589 "parsers/smartpl_parser.y"
                                                            { if (result_set(result, (yyvsp[-4].str), (yyvsp[-2].ast), (yyvsp[-1].ast), NULL, NULL) < 0) YYABORT; }
#line 2185 "parsers/smartpl_parser.c"
    break;

  case 6: /* playlist: SMARTPL_T_STRING '{' criteria order limit '}'  */
#line 590 "parsers/smartpl_parser.y"
                                                            { if (result_set(result, (yyvsp[-5].str), (yyvsp[-3].ast), NULL, (yyvsp[-2].ast), (yyvsp[-1].ast)) < 0) YYABORT; }
#line 2191 "parsers/smartpl_parser.c"
    break;

  case 7: /* playlist: SMARTPL_T_STRING '{' criteria order '}'  */
#line 591 "parsers/smartpl_parser.y"
                                                            { if (result_set(result, (yyvsp[-4].str), (yyvsp[-2].ast), NULL, (yyvsp[-1].ast), NULL) < 0) YYABORT; }
#line 2197 "parsers/smartpl_parser.c"
    break;

  case 8: /* playlist: SMARTPL_T_STRING '{' criteria limit '}'  */
#line 592 "parsers/smartpl_parser.y"
                                                            { if (result_set(result, (yyvsp[-4].str), (yyvsp[-2].ast), NULL, NULL, (yyvsp[-1].ast)) < 0) YYABORT; }
#line 2203 "parsers/smartpl_parser.c"
    break;

  case 9: /* playlist: SMARTPL_T_STRING '{' criteria '}'  */
#line 593 "parsers/smartpl_parser.y"
                                                            { if (result_set(result, (yyvsp[-3].str), (yyvsp[-1].ast), NULL, NULL, NULL) < 0) YYABORT; }
#line 2209 "parsers/smartpl_parser.c"
    break;

  case 10: /* criteria: criteria SMARTPL_T_AND criteria  */
#line 596 "parsers/smartpl_parser.y"
                                                            { (yyval.ast) = ast_new(SMARTPL_T_AND, (yyvsp[-2].ast), (yyvsp[0].ast)); }
#line 2215 "parsers/smartpl_parser.c"
    break;

  case 11: /* criteria: criteria SMARTPL_T_OR criteria  */
#line 597 "parsers/smartpl_parser.y"
                                                            { (yyval.ast) = ast_new(SMARTPL_T_OR, (yyvsp[-2].ast), (yyvsp[0].ast)); }
#line 2221 "parsers/smartpl_parser.c"
    break;

  case 12: /* criteria: '(' criteria ')'  */
#line 598 "parsers/smartpl_parser.y"
                                                            { (yyval.ast) = ast_new(SMARTPL_T_PARENS, (yyvsp[-1].ast), NULL); }
#line 2227 "parsers/smartpl_parser.c"
    break;

  case 13: /* criteria: SMARTPL_T_NOT criteria  */
#line 599 "parsers/smartpl_parser.y"
                                                            { struct ast *a = (yyvsp[0].ast); a->type |= INVERT_MASK; (yyval.ast) = (yyvsp[0].ast); }
#line 2233 "parsers/smartpl_parser.c"
    break;

  case 15: /* predicate: SMARTPL_T_STRTAG strbool SMARTPL_T_STRING  */
#line 603 "parsers/smartpl_parser.y"
                                                            { (yyval.ast) = ast_new((yyvsp[-1].ival), ast_data(SMARTPL_T_STRTAG, (yyvsp[-2].str)), ast_data(SMARTPL_T_STRING, (yyvsp[0].str))); }
#line 2239 "parsers/smartpl_parser.c"
    break;

  case 16: /* predicate: SMARTPL_T_INTTAG intbool SMARTPL_T_NUM  */
#line 604 "parsers/smartpl_parser.y"
                                                            { (yyval.ast) = ast_new((yyvsp[-1].ival), ast_data(SMARTPL_T_INTTAG, (yyvsp[-2].str)), ast_int(SMARTPL_T_NUM, (yyvsp[0].ival))); }
#line 2245 "parsers/smartpl_parser.c"
    break;

  case 17: /* predicate: SMARTPL_T_DATETAG datebool dateexpr  */
#line 605 "parsers/smartpl_parser.y"
                                                            { (yyval.ast) = ast_new((yyvsp[-1].ival), ast_data(SMARTPL_T_DATETAG, (yyvsp[-2].str)), (yyvsp[0].ast)); }
#line 2251 "parsers/smartpl_parser.c"
    break;

  case 18: /* predicate: SMARTPL_T_STRTAG SMARTPL_T_IS SMARTPL_T_EMPTY  */
#line 606 "parsers/smartpl_parser.y"
                                                            { (yyval.ast) = ast_new(SMARTPL_T_IS_OPERATOR, ast_data(SMARTPL_T_STRTAG, (yyvsp[-2].str)), ast_data(SMARTPL_T_NULL, NULL)); }
#line 2257 "parsers/smartpl_parser.c"
    break;

  case 20: /* enumexpr: SMARTPL_T_ENUMTAG_DATAKIND SMARTPL_T_IS SMARTPL_T_FILE  */
#line 612 "parsers/smartpl_parser.y"
                                                                { (yyval.ast) = ast_new(SMARTPL_T_EQUAL, ast_data(SMARTPL_T_ENUMTAG, (yyvsp[-2].str)), ast_int(SMARTPL_T_NUM, DATA_KIND_FILE)); }
#line 2263 "parsers/smartpl_parser.c"
    break;

  case 21: /* enumexpr: SMARTPL_T_ENUMTAG_DATAKIND SMARTPL_T_IS SMARTPL_T_URL  */
#line 613 "parsers/smartpl_parser.y"
                                                                { (yyval.ast) = ast_new(SMARTPL_T_EQUAL, ast_data(SMARTPL_T_ENUMTAG, (yyvsp[-2].str)), ast_int(SMARTPL_T_NUM, DATA_KIND_HTTP)); }
#line 2269 "parsers/smartpl_parser.c"
    break;

  case 22: /* enumexpr: SMARTPL_T_ENUMTAG_DATAKIND SMARTPL_T_IS SMARTPL_T_SPOTIFY  */
#line 614 "parsers/smartpl_parser.y"
                                                                { (yyval.ast) = ast_new(SMARTPL_T_EQUAL, ast_data(SMARTPL_T_ENUMTAG, (yyvsp[-2].str)), ast_int(SMARTPL_T_NUM, DATA_KIND_SPOTIFY)); }
#line 2275 "parsers/smartpl_parser.c"
    break;

  case 23: /* enumexpr: SMARTPL_T_ENUMTAG_DATAKIND SMARTPL_T_IS SMARTPL_T_PIPE  */
#line 615 "parsers/smartpl_parser.y"
                                                                { (yyval.ast) = ast_new(SMARTPL_T_EQUAL, ast_data(SMARTPL_T_ENUMTAG, (yyvsp[-2].str)), ast_int(SMARTPL_T_NUM, DATA_KIND_PIPE)); }
#line 2281 "parsers/smartpl_parser.c"
    break;

  case 24: /* enumexpr: SMARTPL_T_ENUMTAG_MEDIAKIND SMARTPL_T_IS SMARTPL_T_MUSIC  */
#line 617 "parsers/smartpl_parser.y"
                                                                { (yyval.ast) = ast_new(SMARTPL_T_EQUAL, ast_data(SMARTPL_T_ENUMTAG, (yyvsp[-2].str)), ast_int(SMARTPL_T_NUM, MEDIA_KIND_MUSIC)); }
#line 2287 "parsers/smartpl_parser.c"
    break;

  case 25: /* enumexpr: SMARTPL_T_ENUMTAG_MEDIAKIND SMARTPL_T_IS SMARTPL_T_MOVIE  */
#line 618 "parsers/smartpl_parser.y"
                                                                { (yyval.ast) = ast_new(SMARTPL_T_EQUAL, ast_data(SMARTPL_T_ENUMTAG, (yyvsp[-2].str)), ast_int(SMARTPL_T_NUM, MEDIA_KIND_MOVIE)); }
#line 2293 "parsers/smartpl_parser.c"
    break;

  case 26: /* enumexpr: SMARTPL_T_ENUMTAG_MEDIAKIND SMARTPL_T_IS SMARTPL_T_PODCAST  */
#line 619 "parsers/smartpl_parser.y"
                                                                { (yyval.ast) = ast_new(SMARTPL_T_EQUAL, ast_data(SMARTPL_T_ENUMTAG, (yyvsp[-2].str)), ast_int(SMARTPL_T_NUM, MEDIA_KIND_PODCAST)); }
#line 2299 "parsers/smartpl_parser.c"
    break;

  case 27: /* enumexpr: SMARTPL_T_ENUMTAG_MEDIAKIND SMARTPL_T_IS SMARTPL_T_AUDIOBOOK  */
#line 620 "parsers/smartpl_parser.y"
                                                                { (yyval.ast) = ast_new(SMARTPL_T_EQUAL, ast_data(SMARTPL_T_ENUMTAG, (yyvsp[-2].str)), ast_int(SMARTPL_T_NUM, MEDIA_KIND_AUDIOBOOK)); }
#line 2305 "parsers/smartpl_parser.c"
    break;

  case 28: /* enumexpr: SMARTPL_T_ENUMTAG_MEDIAKIND SMARTPL_T_IS SMARTPL_T_TVSHOW  */
#line 621 "parsers/smartpl_parser.y"
                                                                { (yyval.ast) = ast_new(SMARTPL_T_EQUAL, ast_data(SMARTPL_T_ENUMTAG, (yyvsp[-2].str)), ast_int(SMARTPL_T_NUM, MEDIA_KIND_TVSHOW)); }
#line 2311 "parsers/smartpl_parser.c"
    break;

  case 29: /* enumexpr: SMARTPL_T_ENUMTAG_SCANKIND SMARTPL_T_IS SMARTPL_T_FILE  */
#line 623 "parsers/smartpl_parser.y"
                                                                { (yyval.ast) = ast_new(SMARTPL_T_EQUAL, ast_data(SMARTPL_T_ENUMTAG, (yyvsp[-2].str)), ast_int(SMARTPL_T_NUM, SCAN_KIND_FILES)); }
#line 2317 "parsers/smartpl_parser.c"
    break;

  case 30: /* enumexpr: SMARTPL_T_ENUMTAG_SCANKIND SMARTPL_T_IS SMARTPL_T_SPOTIFY  */
#line 624 "parsers/smartpl_parser.y"
                                                                { (yyval.ast) = ast_new(SMARTPL_T_EQUAL, ast_data(SMARTPL_T_ENUMTAG, (yyvsp[-2].str)), ast_int(SMARTPL_T_NUM, SCAN_KIND_SPOTIFY)); }
#line 2323 "parsers/smartpl_parser.c"
    break;

  case 31: /* enumexpr: SMARTPL_T_ENUMTAG_SCANKIND SMARTPL_T_IS SMARTPL_T_RSS  */
#line 625 "parsers/smartpl_parser.y"
                                                                { (yyval.ast) = ast_new(SMARTPL_T_EQUAL, ast_data(SMARTPL_T_ENUMTAG, (yyvsp[-2].str)), ast_int(SMARTPL_T_NUM, SCAN_KIND_RSS)); }
#line 2329 "parsers/smartpl_parser.c"
    break;

  case 32: /* dateexpr: SMARTPL_T_DATE  */
#line 628 "parsers/smartpl_parser.y"
                                                            { (yyval.ast) = ast_new(SMARTPL_T_DATEEXPR, ast_data(SMARTPL_T_DATE, (yyvsp[0].str)), NULL); }
#line 2335 "parsers/smartpl_parser.c"
    break;

  case 33: /* dateexpr: daterelative  */
#line 629 "parsers/smartpl_parser.y"
                                                            { (yyval.ast) = ast_new(SMARTPL_T_DATEEXPR, ast_data((yyvsp[0].ival), NULL), NULL); }
#line 2341 "parsers/smartpl_parser.c"
    break;

  case 34: /* dateexpr: interval SMARTPL_T_DATE  */
#line 630 "parsers/smartpl_parser.y"
                                                            { (yyval.ast) = ast_new(SMARTPL_T_DATEEXPR, ast_data(SMARTPL_T_DATE, (yyvsp[0].str)), (yyvsp[-1].ast)); }
#line 2347 "parsers/smartpl_parser.c"
    break;

  case 35: /* dateexpr: interval daterelative  */
#line 631 "parsers/smartpl_parser.y"
                                                            { (yyval.ast) = ast_new(SMARTPL_T_DATEEXPR, ast_data((yyvsp[0].ival), NULL), (yyvsp[-1].ast)); }
#line 2353 "parsers/smartpl_parser.c"
    break;

  case 36: /* dateexpr: time SMARTPL_T_AGO  */
#line 632 "parsers/smartpl_parser.y"
                                                            { (yyval.ast) = ast_new(SMARTPL_T_DATEEXPR, ast_data(SMARTPL_T_DATE_TODAY, NULL), ast_data(SMARTPL_T_INTERVAL, (yyvsp[-1].str))); }
#line 2359 "parsers/smartpl_parser.c"
    break;

  case 43: /* interval: time SMARTPL_T_BEFORE  */
#line 643 "parsers/smartpl_parser.y"
                                                            { (yyval.ast) = ast_data(SMARTPL_T_INTERVAL, (yyvsp[-1].str)); }
#line 2365 "parsers/smartpl_parser.c"
    break;

  case 44: /* interval: time SMARTPL_T_AFTER  */
#line 644 "parsers/smartpl_parser.y"
                                                            { (yyval.ast) = ast_data(SMARTPL_T_INTERVAL | INVERT_MASK, (yyvsp[-1].str)); }
#line 2371 "parsers/smartpl_parser.c"
    break;

  case 45: /* time: SMARTPL_T_NUM SMARTPL_T_DAYS  */
#line 647 "parsers/smartpl_parser.y"
                                                            { if (asprintf(&((yyval.str)), "%d days", (yyvsp[-1].ival)) < 0) YYABORT; }
#line 2377 "parsers/smartpl_parser.c"
    break;

  case 46: /* time: SMARTPL_T_NUM SMARTPL_T_WEEKS  */
#line 648 "parsers/smartpl_parser.y"
                                                            { if (asprintf(&((yyval.str)), "%d days", 7 * (yyvsp[-1].ival)) < 0) YYABORT; }
#line 2383 "parsers/smartpl_parser.c"
    break;

  case 47: /* time: SMARTPL_T_NUM SMARTPL_T_MONTHS  */
#line 649 "parsers/smartpl_parser.y"
                                                            { if (asprintf(&((yyval.str)), "%d months", (yyvsp[-1].ival)) < 0) YYABORT;  }
#line 2389 "parsers/smartpl_parser.c"
    break;

  case 48: /* time: SMARTPL_T_NUM SMARTPL_T_YEARS  */
#line 650 "parsers/smartpl_parser.y"
                                                            { if (asprintf(&((yyval.str)), "%d years", (yyvsp[-1].ival)) < 0) YYABORT;  }
#line 2395 "parsers/smartpl_parser.c"
    break;

  case 49: /* having: SMARTPL_T_HAVING SMARTPL_T_GROUPTAG intbool SMARTPL_T_NUM  */
#line 653 "parsers/smartpl_parser.y"
                                                                  { (yyval.ast) = ast_new((yyvsp[-1].ival), ast_data(SMARTPL_T_GROUPTAG, (yyvsp[-2].str)), ast_int(SMARTPL_T_NUM, (yyvsp[0].ival))); }
#line 2401 "parsers/smartpl_parser.c"
    break;

  case 50: /* order: SMARTPL_T_ORDERBY SMARTPL_T_STRTAG  */
#line 655 "parsers/smartpl_parser.y"
                                                            { (yyval.ast) = ast_data(SMARTPL_T_ORDERBY, (yyvsp[0].str)); }
#line 2407 "parsers/smartpl_parser.c"
    break;

  case 51: /* order: SMARTPL_T_ORDERBY SMARTPL_T_INTTAG  */
#line 656 "parsers/smartpl_parser.y"
                                                            { (yyval.ast) = ast_data(SMARTPL_T_ORDERBY, (yyvsp[0].str)); }
#line 2413 "parsers/smartpl_parser.c"
    break;

  case 52: /* order: SMARTPL_T_ORDERBY SMARTPL_T_DATETAG  */
#line 657 "parsers/smartpl_parser.y"
                                                            { (yyval.ast) = ast_data(SMARTPL_T_ORDERBY, (yyvsp[0].str)); }
#line 2419 "parsers/smartpl_parser.c"
    break;

  case 53: /* order: SMARTPL_T_ORDERBY SMARTPL_T_ENUMTAG_DATAKIND  */
#line 658 "parsers/smartpl_parser.y"
                                                            { (yyval.ast) = ast_data(SMARTPL_T_ORDERBY, (yyvsp[0].str)); }
#line 2425 "parsers/smartpl_parser.c"
    break;

  case 54: /* order: SMARTPL_T_ORDERBY SMARTPL_T_ENUMTAG_MEDIAKIND  */
#line 659 "parsers/smartpl_parser.y"
                                                            { (yyval.ast) = ast_data(SMARTPL_T_ORDERBY, (yyvsp[0].str)); }
#line 2431 "parsers/smartpl_parser.c"
    break;

  case 55: /* order: SMARTPL_T_ORDERBY SMARTPL_T_ENUMTAG_SCANKIND  */
#line 660 "parsers/smartpl_parser.y"
                                                            { (yyval.ast) = ast_data(SMARTPL_T_ORDERBY, (yyvsp[0].str)); }
#line 2437 "parsers/smartpl_parser.c"
    break;

  case 56: /* order: SMARTPL_T_ORDERBY SMARTPL_T_RANDOM  */
#line 661 "parsers/smartpl_parser.y"
                                                            { (yyval.ast) = ast_data(SMARTPL_T_RANDOM, NULL); }
#line 2443 "parsers/smartpl_parser.c"
    break;

  case 57: /* order: order SMARTPL_T_ORDER_ASC  */
#line 662 "parsers/smartpl_parser.y"
                                                            { struct ast *a = (yyvsp[-1].ast); a->type = SMARTPL_T_ORDERBY; (yyval.ast) = (yyvsp[-1].ast); }
#line 2449 "parsers/smartpl_parser.c"
    break;

  case 58: /* order: order SMARTPL_T_ORDER_DESC  */
#line 663 "parsers/smartpl_parser.y"
                                                            { struct ast *a = (yyvsp[-1].ast); a->type |= INVERT_MASK; (yyval.ast) = (yyvsp[-1].ast); }
#line 2455 "parsers/smartpl_parser.c"
    break;

  case 59: /* limit: SMARTPL_T_LIMIT SMARTPL_T_NUM  */
#line 666 "parsers/smartpl_parser.y"
                                                            { (yyval.ast) = ast_int(SMARTPL_T_LIMIT, (yyvsp[0].ival)); }
#line 2461 "parsers/smartpl_parser.c"
    break;


#line 2465 "parsers/smartpl_parser.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == SMARTPL_EMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      {
        yypcontext_t yyctx
          = {yyssp, yytoken};
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == -1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *,
                             YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (yymsg)
              {
                yysyntax_error_status
                  = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
                yymsgp = yymsg;
              }
            else
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = YYENOMEM;
              }
          }
        yyerror (result, scanner, yymsgp);
        if (yysyntax_error_status == YYENOMEM)
          YYNOMEM;
      }
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= SMARTPL_EOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == SMARTPL_EOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, result, scanner);
          yychar = SMARTPL_EMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, result, scanner);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (result, scanner, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != SMARTPL_EMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, result, scanner);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, result, scanner);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
  return yyresult;
}

#line 686 "parsers/smartpl_parser.y"


