/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.websocket.impl;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.SmackFuture;
import org.jivesoftware.smack.c2s.internal.ModularXmppClientToServerConnectionInternal;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.websocket.WebSocketException;
import org.jivesoftware.smack.websocket.elements.WebSocketCloseElement;
import org.jivesoftware.smack.websocket.elements.WebSocketOpenElement;
import org.jivesoftware.smack.websocket.impl.SmackWebSocketDebugger;
import org.jivesoftware.smack.websocket.rce.WebSocketRemoteConnectionEndpoint;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public abstract class AbstractWebSocket {
    protected static final Logger LOGGER = Logger.getLogger(AbstractWebSocket.class.getName());
    protected static final String SEC_WEBSOCKET_PROTOCOL_HEADER_FILED_NAME = "Sec-WebSocket-Protocol";
    protected static final String SEC_WEBSOCKET_PROTOCOL_HEADER_FILED_VALUE_XMPP = "xmpp";
    protected final SmackFuture.InternalSmackFuture<AbstractWebSocket, Exception> future = new SmackFuture.InternalSmackFuture();
    protected final ModularXmppClientToServerConnectionInternal connectionInternal;
    protected final WebSocketRemoteConnectionEndpoint endpoint;
    private final SmackWebSocketDebugger debugger;
    private String streamOpen;
    private String streamClose;

    protected AbstractWebSocket(WebSocketRemoteConnectionEndpoint endpoint, ModularXmppClientToServerConnectionInternal connectionInternal) {
        this.endpoint = endpoint;
        this.connectionInternal = connectionInternal;
        SmackDebugger smackDebugger = connectionInternal.smackDebugger;
        this.debugger = smackDebugger != null ? new SmackWebSocketDebugger(smackDebugger) : null;
    }

    public final WebSocketRemoteConnectionEndpoint getEndpoint() {
        return this.endpoint;
    }

    protected final void onIncomingWebSocketElement(String element) {
        if (this.debugger != null) {
            this.debugger.incoming(element);
        }
        if (AbstractWebSocket.isOpenElement(element)) {
            this.streamOpen = AbstractWebSocket.getStreamFromOpenElement(element);
            this.streamClose = this.connectionInternal.onStreamOpen(this.streamOpen);
            return;
        }
        if (AbstractWebSocket.isCloseElement(element)) {
            this.connectionInternal.onStreamClosed();
            return;
        }
        this.connectionInternal.withSmackDebugger(debugger -> debugger.onIncomingElementCompleted());
        String wrappedCompleteElement = this.streamOpen + element + this.streamClose;
        this.connectionInternal.parseAndProcessElement(wrappedCompleteElement);
    }

    static String getStreamFromOpenElement(String openElement) {
        String streamElement = openElement.replaceFirst("\\A<open ", "<stream:stream ").replace("urn:ietf:params:xml:ns:xmpp-framing", "jabber:client").replaceFirst("/>\\s*\\z", " xmlns:stream='http://etherx.jabber.org/streams'>").replaceFirst("></open>\\s*\\z", " xmlns:stream='http://etherx.jabber.org/streams'>");
        return streamElement;
    }

    static boolean isOpenElement(String text) {
        try {
            XmlPullParser parser = PacketParserUtils.getParserFor(text);
            QName qname = parser.getQName();
            return qname.equals(WebSocketOpenElement.QNAME);
        }
        catch (IOException | XmlPullParserException e) {
            LOGGER.log(Level.WARNING, "Could not inspect \"" + text + "\" for open element", e);
            return false;
        }
    }

    static boolean isCloseElement(String text) {
        try {
            XmlPullParser parser = PacketParserUtils.getParserFor(text);
            QName qname = parser.getQName();
            return qname.equals(WebSocketCloseElement.QNAME);
        }
        catch (IOException | XmlPullParserException e) {
            LOGGER.log(Level.WARNING, "Could not inspect \"" + text + "\" for close element", e);
            return false;
        }
    }

    protected void onWebSocketFailure(Throwable throwable) {
        WebSocketException websocketException = new WebSocketException(throwable);
        if (this.future.wasSuccessful()) {
            this.connectionInternal.notifyConnectionError(websocketException);
        } else {
            this.future.setException(websocketException);
        }
    }

    public final SmackFuture<AbstractWebSocket, Exception> getFuture() {
        return this.future;
    }

    public final void send(TopLevelStreamElement element) {
        XmlEnvironment outgoingStreamXmlEnvironment = this.connectionInternal.getOutgoingStreamXmlEnvironment();
        String elementString = element.toXML(outgoingStreamXmlEnvironment).toString();
        if (this.debugger != null) {
            this.debugger.outgoing(elementString);
        }
        this.send(elementString);
    }

    protected abstract void send(String var1);

    public abstract void disconnect(int var1, String var2);

    public boolean isConnectionSecure() {
        return this.endpoint.isSecureEndpoint();
    }

    public abstract SSLSession getSSLSession();

    public final String toString() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.connectionInternal.connection) + "]";
    }
}

