/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jivesoftware.smack.util.CollectionUtil;
import org.jivesoftware.smackx.xdata.FormField;
import org.jxmpp.util.XmppDateTime;

public class AbstractMultiFormField
extends FormField {
    private final List<FormField.Value> values;

    protected AbstractMultiFormField(Builder<?, ?> builder) {
        super(builder);
        this.values = CollectionUtil.cloneAndSeal(builder.values);
    }

    @Override
    public final List<FormField.Value> getRawValues() {
        return this.values;
    }

    public static abstract class Builder<F extends AbstractMultiFormField, B extends FormField.Builder<F, B>>
    extends FormField.Builder<F, B> {
        private List<FormField.Value> values;

        protected Builder(AbstractMultiFormField formField) {
            super(formField);
            this.values = CollectionUtil.newListWith(formField.getRawValues());
        }

        protected Builder(String fieldName, FormField.Type type) {
            super(fieldName, type);
        }

        private void ensureValuesAreInitialized() {
            if (this.values == null) {
                this.values = new ArrayList<FormField.Value>();
            }
        }

        @Override
        protected void resetInternal() {
            this.values = null;
        }

        public abstract B addValue(CharSequence var1);

        public B addValueVerbatim(CharSequence value) {
            return this.addValueVerbatim(new FormField.Value(value));
        }

        public B addValueVerbatim(FormField.Value value) {
            this.ensureValuesAreInitialized();
            this.values.add(value);
            return this.getThis();
        }

        public final B addValue(Date date) {
            String dateString = XmppDateTime.formatXEP0082Date(date);
            return this.addValueVerbatim(dateString);
        }

        public final B addValues(Collection<? extends CharSequence> values) {
            this.ensureValuesAreInitialized();
            for (CharSequence charSequence : values) {
                this.addValueVerbatim(charSequence);
            }
            return this.getThis();
        }
    }
}

