/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionBuilderInterface;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.OpenPgpMessageInputStream;

public class DecryptionBuilder
implements DecryptionBuilderInterface {
    @Override
    public DecryptionBuilderInterface.DecryptWith onInputStream(@Nonnull InputStream inputStream) {
        return new DecryptWithImpl(inputStream);
    }

    static class DecryptWithImpl
    implements DecryptionBuilderInterface.DecryptWith {
        private final InputStream inputStream;

        DecryptWithImpl(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public DecryptionStream withOptions(ConsumerOptions consumerOptions) throws PGPException, IOException {
            if (consumerOptions == null) {
                throw new IllegalArgumentException("Consumer options cannot be null.");
            }
            return OpenPgpMessageInputStream.create(this.inputStream, consumerOptions);
        }
    }
}

