/* PSPP - a program for statistical analysis.
   Copyright (C) 2012 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>. */

#ifndef OUTPUT_CHARTS_SL_PLOT_H
#define OUTPUT_CHARTS_SL_PLOT_H 1

#include "output/chart.h"
#include <stddef.h>

struct datum
{
  double x;
  double y;
};

struct spreadlevel_plot_chart
  {
    struct chart chart;

    /* Calculated parameters */
    double y_lower, y_upper;
    double x_lower, x_upper;

    double tx_pwr;

    size_t n_data;
    struct datum *data;
  };

struct chart *spreadlevel_plot_create (const char *label, double slp);

void spreadlevel_plot_add (struct chart *, double spread, double level);



/* This boilerplate for spreadlevel_plot_chart, a subclass of chart, was
   autogenerated by mk-class-boilerplate. */

#include <assert.h>
#include "libpspp/cast.h"

extern const struct chart_class spreadlevel_plot_chart_class;

/* Returns true if SUPER is a spreadlevel_plot_chart, otherwise false. */
static inline bool
is_spreadlevel_plot_chart (const struct chart *super)
{
  return super->class == &spreadlevel_plot_chart_class;
}

/* Returns SUPER converted to spreadlevel_plot_chart.  SUPER must be a spreadlevel_plot_chart, as
   reported by is_spreadlevel_plot_chart. */
static inline struct spreadlevel_plot_chart *
to_spreadlevel_plot_chart (const struct chart *super)
{
  assert (is_spreadlevel_plot_chart (super));
  return UP_CAST (super, struct spreadlevel_plot_chart, chart);
}

/* Returns INSTANCE converted to chart. */
static inline struct chart *
spreadlevel_plot_chart_super (const struct spreadlevel_plot_chart *instance)
{
  return CONST_CAST (struct chart *, &instance->chart);
}

/* Increments INSTANCE's reference count and returns INSTANCE. */
static inline struct spreadlevel_plot_chart *
spreadlevel_plot_chart_ref (const struct spreadlevel_plot_chart *instance)
{
  return to_spreadlevel_plot_chart (chart_ref (&instance->chart));
}

/* Decrements INSTANCE's reference count, then destroys INSTANCE if
   the reference count is now zero. */
static inline void
spreadlevel_plot_chart_unref (struct spreadlevel_plot_chart *instance)
{
  chart_unref (&instance->chart);
}

/* Returns true if INSTANCE's reference count is greater than 1,
   false otherwise. */
static inline bool
spreadlevel_plot_chart_is_shared (const struct spreadlevel_plot_chart *instance)
{
  return chart_is_shared (&instance->chart);
}

static inline void
spreadlevel_plot_chart_submit (struct spreadlevel_plot_chart *instance)
{
  chart_submit (&instance->chart);
}

#endif
